
![Pow logo](http://www.pythononwheels.org/static/images/pow_logo_300.png)


# This is the new pow 2017. And it's really good. 
(ok I might be biased ;)

But it's by far the best PoW (concept and implementation) ever !
Ever, ever, ever!!

I call it *SQUEEZY* => for Simple, Quick and Easy.

## Principle
As simple to use as possible. Everything you always need on board. And you can always escape and go *RAW*.
Batteries included! (tornado Webswerver, SQLite DB)

## Strong Foundation:
* python 3.x
* tornado webserver
* sqlalchemy ORM
* cerberus schemas and validation on board
* tornado templates
* tinyDB and ElasticSearch on board... more to come

## Super easy, quick to start and all the basics on board:
* super easy relations with decorators @relations.has_many("comments")
* super easy REST routing with decorators @app.add\_restful\_routes(), 
* routing decorator @app.add_route(route)
* db migrations autogenerated using alembic in the back 
* validation on board with cerberus schemas
* use the same schema descrition for all model types (sql, nosql, elastic..)
* generate_models script
* generate_migrations script 
* update_db script
* generate_handlers 
* generate_app
* automatic scaffolding views (work in progress)

## Current Status:
The current <master> version in this repo is fully working except for:
* automatic scaffolding views

## Code examples

### Routes:

    # this will call the myget methog on HTTP GET calls.
    # and will hand over the re-group as the 1st parameter.
    @app.add_route("/index/([0-9]+)*", dispatch={"get" : "myget"})
    class IndexdHandler(BaseHandler):
        def myget(self, index=None):
            print("  index:" + str(index))
            self.render("index.tmpl")

### Relations: (SQL Models)

    @relation.has_many("comments")
    class Post(Base):
        # a blog Post
        schema = {
            'text': {'type': 'string'},
            'name': {'type': 'string', 'maxlength' : 35},
            'last': {'type': 'number'}
        }


## For more check: [The PythonOnWheels Homepage](http://www.pythononwheels.org)


    