# Django Hijack

[![CI](https://github.com/django-hijack/django-hijack/workflows/CI/badge.svg?branch=master)](https://github.com/django-hijack/django-hijack/actions)
[![codecov](https://codecov.io/gh/django-hijack/django-hijack/branch/master/graph/badge.svg?token=zX0nCDRJDj)](https://codecov.io/gh/django-hijack/django-hijack)
[![PyPI](https://img.shields.io/pypi/v/django-hijack)](https://pypi.org/project/django-hijack/)

![Screenshot of the notification seen while hijacking another user.](https://github.com/django-hijack/django-hijack/raw/master/docs/django-hijack.jpg)

With Django Hijack, admins can log in and work on behalf of other users without having to know their credentials.

## Docs

Docs are available on Read the Docs http://django-hijack.readthedocs.org/en/stable/, both for **v2.x** and **v3.x**.

## Versions

There are two versions available: **v2.x** and **v3.x**.

**v3.x** provides a security first design, easy integration, customisation, out-of-the-box Django admin support and dark-mode.
It is a complete rewrite and all former APIs are broken.

## Testimonials

> I am using django-hijack on a project with hundreds of users, wonderful tool for support. Thank you!
>
> -- [benzinonapoloni](https://www.reddit.com/user/benzinonapoloni) on [reddit](https://redd.it/39aggd)


> This is a super useful tool. I have a site where I occasionally impersonating users to help troubleshoot their issues. This is a huge time saver.
>
> -- [orangishyellow](https://www.reddit.com/user/orangishyellow) on [reddit](https://redd.it/2i35fu)



> ... one of our standard apps to install now.
>
> -- [thundersnow](https://www.reddit.com/user/thundersnow) on [reddit](https://redd.it/4wqo0d/)

> Love django-hijack
>
> -- [bmihelac](https://twitter.com/bmihelac) on [Twitter](https://twitter.com/bmihelac/status/836225081508519936)
