# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAuditProfileAvailableAuditVolumesResult',
    'AwaitableGetAuditProfileAvailableAuditVolumesResult',
    'get_audit_profile_available_audit_volumes',
    'get_audit_profile_available_audit_volumes_output',
]

@pulumi.output_type
class GetAuditProfileAvailableAuditVolumesResult:
    """
    A collection of values returned by getAuditProfileAvailableAuditVolumes.
    """
    def __init__(__self__, audit_profile_id=None, available_audit_volume_collections=None, filters=None, id=None, month_in_consideration_greater_than=None, month_in_consideration_less_than=None, trail_location=None, work_request_id=None):
        if audit_profile_id and not isinstance(audit_profile_id, str):
            raise TypeError("Expected argument 'audit_profile_id' to be a str")
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if available_audit_volume_collections and not isinstance(available_audit_volume_collections, list):
            raise TypeError("Expected argument 'available_audit_volume_collections' to be a list")
        pulumi.set(__self__, "available_audit_volume_collections", available_audit_volume_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if month_in_consideration_greater_than and not isinstance(month_in_consideration_greater_than, str):
            raise TypeError("Expected argument 'month_in_consideration_greater_than' to be a str")
        pulumi.set(__self__, "month_in_consideration_greater_than", month_in_consideration_greater_than)
        if month_in_consideration_less_than and not isinstance(month_in_consideration_less_than, str):
            raise TypeError("Expected argument 'month_in_consideration_less_than' to be a str")
        pulumi.set(__self__, "month_in_consideration_less_than", month_in_consideration_less_than)
        if trail_location and not isinstance(trail_location, str):
            raise TypeError("Expected argument 'trail_location' to be a str")
        pulumi.set(__self__, "trail_location", trail_location)
        if work_request_id and not isinstance(work_request_id, str):
            raise TypeError("Expected argument 'work_request_id' to be a str")
        pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> str:
        """
        The OCID of the audit profile resource.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="availableAuditVolumeCollections")
    def available_audit_volume_collections(self) -> Sequence['outputs.GetAuditProfileAvailableAuditVolumesAvailableAuditVolumeCollectionResult']:
        """
        The list of available_audit_volume_collection.
        """
        return pulumi.get(self, "available_audit_volume_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAuditProfileAvailableAuditVolumesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monthInConsiderationGreaterThan")
    def month_in_consideration_greater_than(self) -> Optional[str]:
        return pulumi.get(self, "month_in_consideration_greater_than")

    @property
    @pulumi.getter(name="monthInConsiderationLessThan")
    def month_in_consideration_less_than(self) -> Optional[str]:
        return pulumi.get(self, "month_in_consideration_less_than")

    @property
    @pulumi.getter(name="trailLocation")
    def trail_location(self) -> Optional[str]:
        """
        Audit trail location on the target database from where the audit data is being collected by Data Safe.
        """
        return pulumi.get(self, "trail_location")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> str:
        return pulumi.get(self, "work_request_id")


class AwaitableGetAuditProfileAvailableAuditVolumesResult(GetAuditProfileAvailableAuditVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAuditProfileAvailableAuditVolumesResult(
            audit_profile_id=self.audit_profile_id,
            available_audit_volume_collections=self.available_audit_volume_collections,
            filters=self.filters,
            id=self.id,
            month_in_consideration_greater_than=self.month_in_consideration_greater_than,
            month_in_consideration_less_than=self.month_in_consideration_less_than,
            trail_location=self.trail_location,
            work_request_id=self.work_request_id)


def get_audit_profile_available_audit_volumes(audit_profile_id: Optional[str] = None,
                                              filters: Optional[Sequence[Union['GetAuditProfileAvailableAuditVolumesFilterArgs', 'GetAuditProfileAvailableAuditVolumesFilterArgsDict']]] = None,
                                              month_in_consideration_greater_than: Optional[str] = None,
                                              month_in_consideration_less_than: Optional[str] = None,
                                              trail_location: Optional[str] = None,
                                              work_request_id: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAuditProfileAvailableAuditVolumesResult:
    """
    This data source provides the list of Audit Profile Available Audit Volumes in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of audit trails, and associated audit event volume for each trail up to defined start date.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile_available_audit_volumes = oci.DataSafe.get_audit_profile_available_audit_volumes(audit_profile_id=test_audit_profile["id"],
        work_request_id=test_work_request["id"],
        month_in_consideration_greater_than=audit_profile_available_audit_volume_month_in_consideration_greater_than,
        month_in_consideration_less_than=audit_profile_available_audit_volume_month_in_consideration_less_than,
        trail_location=audit_profile_available_audit_volume_trail_location)
    ```


    :param str audit_profile_id: The OCID of the audit.
    :param str month_in_consideration_greater_than: Specifying `monthInConsiderationGreaterThan` parameter will retrieve all items for which the event month is greater than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str month_in_consideration_less_than: Specifying `monthInConsiderationLessThan` parameter will retrieve all items for which the event month is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str trail_location: The audit trail location.
    :param str work_request_id: The OCID of the work request.
    """
    __args__ = dict()
    __args__['auditProfileId'] = audit_profile_id
    __args__['filters'] = filters
    __args__['monthInConsiderationGreaterThan'] = month_in_consideration_greater_than
    __args__['monthInConsiderationLessThan'] = month_in_consideration_less_than
    __args__['trailLocation'] = trail_location
    __args__['workRequestId'] = work_request_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getAuditProfileAvailableAuditVolumes:getAuditProfileAvailableAuditVolumes', __args__, opts=opts, typ=GetAuditProfileAvailableAuditVolumesResult).value

    return AwaitableGetAuditProfileAvailableAuditVolumesResult(
        audit_profile_id=pulumi.get(__ret__, 'audit_profile_id'),
        available_audit_volume_collections=pulumi.get(__ret__, 'available_audit_volume_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        month_in_consideration_greater_than=pulumi.get(__ret__, 'month_in_consideration_greater_than'),
        month_in_consideration_less_than=pulumi.get(__ret__, 'month_in_consideration_less_than'),
        trail_location=pulumi.get(__ret__, 'trail_location'),
        work_request_id=pulumi.get(__ret__, 'work_request_id'))


@_utilities.lift_output_func(get_audit_profile_available_audit_volumes)
def get_audit_profile_available_audit_volumes_output(audit_profile_id: Optional[pulumi.Input[str]] = None,
                                                     filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAuditProfileAvailableAuditVolumesFilterArgs', 'GetAuditProfileAvailableAuditVolumesFilterArgsDict']]]]] = None,
                                                     month_in_consideration_greater_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                     month_in_consideration_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                     trail_location: Optional[pulumi.Input[Optional[str]]] = None,
                                                     work_request_id: Optional[pulumi.Input[str]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAuditProfileAvailableAuditVolumesResult]:
    """
    This data source provides the list of Audit Profile Available Audit Volumes in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of audit trails, and associated audit event volume for each trail up to defined start date.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_audit_profile_available_audit_volumes = oci.DataSafe.get_audit_profile_available_audit_volumes(audit_profile_id=test_audit_profile["id"],
        work_request_id=test_work_request["id"],
        month_in_consideration_greater_than=audit_profile_available_audit_volume_month_in_consideration_greater_than,
        month_in_consideration_less_than=audit_profile_available_audit_volume_month_in_consideration_less_than,
        trail_location=audit_profile_available_audit_volume_trail_location)
    ```


    :param str audit_profile_id: The OCID of the audit.
    :param str month_in_consideration_greater_than: Specifying `monthInConsiderationGreaterThan` parameter will retrieve all items for which the event month is greater than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str month_in_consideration_less_than: Specifying `monthInConsiderationLessThan` parameter will retrieve all items for which the event month is less than the date and time specified, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
           
           **Example:** 2016-12-19T00:00:00.000Z
    :param str trail_location: The audit trail location.
    :param str work_request_id: The OCID of the work request.
    """
    ...
