# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsIdentityProviderArgs', 'DomainsIdentityProvider']

@pulumi.input_type
class DomainsIdentityProviderArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 idcs_endpoint: pulumi.Input[str],
                 partner_name: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assertion_attribute: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authn_request_binding: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 correlation_policy: Optional[pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 encryption_certificate: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 idp_sso_url: Optional[pulumi.Input[str]] = None,
                 include_signing_cert_in_signature: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]]] = None,
                 jit_user_prov_attribute_update_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_attributes: Optional[pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs']] = None,
                 jit_user_prov_create_user_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assertion_attribute_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assignment_method: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mapping_mode: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]]] = None,
                 jit_user_prov_group_saml_attribute_name: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_static_list_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_ignore_error_on_absent_groups: Optional[pulumi.Input[bool]] = None,
                 logout_binding: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_request_url: Optional[pulumi.Input[str]] = None,
                 logout_response_url: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 partner_provider_id: Optional[pulumi.Input[str]] = None,
                 requested_authentication_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_force_authn: Optional[pulumi.Input[bool]] = None,
                 requires_encrypted_assertion: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_ho_krequired: Optional[pulumi.Input[bool]] = None,
                 service_instance_identifier: Optional[pulumi.Input[str]] = None,
                 shown_on_login_page: Optional[pulumi.Input[bool]] = None,
                 signature_hash_algorithm: Optional[pulumi.Input[str]] = None,
                 signing_certificate: Optional[pulumi.Input[str]] = None,
                 succinct_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionx509identity_provider: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs']] = None,
                 user_mapping_method: Optional[pulumi.Input[str]] = None,
                 user_mapping_store_attribute: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DomainsIdentityProvider resource.
        :param pulumi.Input[bool] enabled: (Updatable) Set to true to indicate Partner enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] partner_name: (Updatable) Unique name of the trusted Identity Provider.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] assertion_attribute: (Updatable) Assertion attribute name.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authn_request_binding: (Updatable) HTTP binding to use for authentication requests.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs'] correlation_policy: (Updatable) Correlation policy
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) Description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] encryption_certificate: (Updatable) Encryption certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon_url: (Updatable) Identity Provider Icon URL.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idp_sso_url: (Updatable) Identity Provider SSO URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] include_signing_cert_in_signature: (Updatable) Set to true to include the signing certificate in the signature.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]] jit_user_prov_assigned_groups: (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_attribute_update_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs'] jit_user_prov_attributes: (Updatable) Assertion To User Mapping
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_create_user_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_enabled: (Updatable) Set to true to indicate JIT User Provisioning is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_assertion_attribute_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_assignment_method: (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_mapping_mode: (Updatable) Property to indicate the mode of group mapping
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]] jit_user_prov_group_mappings: (Updatable) The list of mappings between the Identity Domain Group and the IDP group.
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [idpGroup]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_saml_attribute_name: (Updatable) Name of the assertion attribute containing the users groups
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_static_list_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_ignore_error_on_absent_groups: (Updatable) Set to true to indicate ignoring absence of group while provisioning
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsAddedSinceVersion: 30
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] logout_binding: (Updatable) HTTP binding to use for logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] logout_enabled: (Updatable) Set to true to enable logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] logout_request_url: (Updatable) Logout request URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_response_url: (Updatable) Logout response URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] metadata: (Updatable) Metadata
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] name_id_format: (Updatable) Default authentication request name ID format.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] partner_provider_id: (Updatable) Provider ID
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_authentication_contexts: (Updatable) SAML SP authentication type.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] require_force_authn: (Updatable) This SP requires requests SAML IdP to enforce re-authentication.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] requires_encrypted_assertion: (Updatable) SAML SP must accept encrypted assertion only.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] saml_ho_krequired: (Updatable) SAML SP HoK Enabled.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] service_instance_identifier: (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: server
        :param pulumi.Input[bool] shown_on_login_page: (Updatable) Set to true to indicate whether to show IdP in login page or not.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] signature_hash_algorithm: (Updatable) Signature hash algorithm.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] signing_certificate: (Updatable) Signing certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] succinct_id: (Updatable) Succinct ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) Identity Provider Type
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs'] urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: (Updatable) Social Identity Provider Extension Schema
        :param pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs'] urnietfparamsscimschemasoracleidcsextensionx509identity_provider: (Updatable) X509 Identity Provider Extension Schema
        :param pulumi.Input[str] user_mapping_method: (Updatable) User mapping method.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[str] user_mapping_store_attribute: (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "partner_name", partner_name)
        pulumi.set(__self__, "schemas", schemas)
        if assertion_attribute is not None:
            pulumi.set(__self__, "assertion_attribute", assertion_attribute)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authn_request_binding is not None:
            pulumi.set(__self__, "authn_request_binding", authn_request_binding)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if correlation_policy is not None:
            pulumi.set(__self__, "correlation_policy", correlation_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_certificate is not None:
            pulumi.set(__self__, "encryption_certificate", encryption_certificate)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if idp_sso_url is not None:
            pulumi.set(__self__, "idp_sso_url", idp_sso_url)
        if include_signing_cert_in_signature is not None:
            pulumi.set(__self__, "include_signing_cert_in_signature", include_signing_cert_in_signature)
        if jit_user_prov_assigned_groups is not None:
            pulumi.set(__self__, "jit_user_prov_assigned_groups", jit_user_prov_assigned_groups)
        if jit_user_prov_attribute_update_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_attribute_update_enabled", jit_user_prov_attribute_update_enabled)
        if jit_user_prov_attributes is not None:
            pulumi.set(__self__, "jit_user_prov_attributes", jit_user_prov_attributes)
        if jit_user_prov_create_user_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_create_user_enabled", jit_user_prov_create_user_enabled)
        if jit_user_prov_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_enabled", jit_user_prov_enabled)
        if jit_user_prov_group_assertion_attribute_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_group_assertion_attribute_enabled", jit_user_prov_group_assertion_attribute_enabled)
        if jit_user_prov_group_assignment_method is not None:
            pulumi.set(__self__, "jit_user_prov_group_assignment_method", jit_user_prov_group_assignment_method)
        if jit_user_prov_group_mapping_mode is not None:
            pulumi.set(__self__, "jit_user_prov_group_mapping_mode", jit_user_prov_group_mapping_mode)
        if jit_user_prov_group_mappings is not None:
            pulumi.set(__self__, "jit_user_prov_group_mappings", jit_user_prov_group_mappings)
        if jit_user_prov_group_saml_attribute_name is not None:
            pulumi.set(__self__, "jit_user_prov_group_saml_attribute_name", jit_user_prov_group_saml_attribute_name)
        if jit_user_prov_group_static_list_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_group_static_list_enabled", jit_user_prov_group_static_list_enabled)
        if jit_user_prov_ignore_error_on_absent_groups is not None:
            pulumi.set(__self__, "jit_user_prov_ignore_error_on_absent_groups", jit_user_prov_ignore_error_on_absent_groups)
        if logout_binding is not None:
            pulumi.set(__self__, "logout_binding", logout_binding)
        if logout_enabled is not None:
            pulumi.set(__self__, "logout_enabled", logout_enabled)
        if logout_request_url is not None:
            pulumi.set(__self__, "logout_request_url", logout_request_url)
        if logout_response_url is not None:
            pulumi.set(__self__, "logout_response_url", logout_response_url)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if partner_provider_id is not None:
            pulumi.set(__self__, "partner_provider_id", partner_provider_id)
        if requested_authentication_contexts is not None:
            pulumi.set(__self__, "requested_authentication_contexts", requested_authentication_contexts)
        if require_force_authn is not None:
            pulumi.set(__self__, "require_force_authn", require_force_authn)
        if requires_encrypted_assertion is not None:
            pulumi.set(__self__, "requires_encrypted_assertion", requires_encrypted_assertion)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if saml_ho_krequired is not None:
            pulumi.set(__self__, "saml_ho_krequired", saml_ho_krequired)
        if service_instance_identifier is not None:
            pulumi.set(__self__, "service_instance_identifier", service_instance_identifier)
        if shown_on_login_page is not None:
            pulumi.set(__self__, "shown_on_login_page", shown_on_login_page)
        if signature_hash_algorithm is not None:
            pulumi.set(__self__, "signature_hash_algorithm", signature_hash_algorithm)
        if signing_certificate is not None:
            pulumi.set(__self__, "signing_certificate", signing_certificate)
        if succinct_id is not None:
            pulumi.set(__self__, "succinct_id", succinct_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider", urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider)
        if urnietfparamsscimschemasoracleidcsextensionx509identity_provider is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider", urnietfparamsscimschemasoracleidcsextensionx509identity_provider)
        if user_mapping_method is not None:
            pulumi.set(__self__, "user_mapping_method", user_mapping_method)
        if user_mapping_store_attribute is not None:
            pulumi.set(__self__, "user_mapping_store_attribute", user_mapping_store_attribute)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        (Updatable) Set to true to indicate Partner enabled.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Unique name of the trusted Identity Provider.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="assertionAttribute")
    def assertion_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Assertion attribute name.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true
        """
        return pulumi.get(self, "assertion_attribute")

    @assertion_attribute.setter
    def assertion_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assertion_attribute", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="authnRequestBinding")
    def authn_request_binding(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) HTTP binding to use for authentication requests.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "authn_request_binding")

    @authn_request_binding.setter
    def authn_request_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authn_request_binding", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="correlationPolicy")
    def correlation_policy(self) -> Optional[pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs']]:
        """
        (Updatable) Correlation policy

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "correlation_policy")

    @correlation_policy.setter
    def correlation_policy(self, value: Optional[pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs']]):
        pulumi.set(self, "correlation_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="encryptionCertificate")
    def encryption_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Encryption certificate

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "encryption_certificate")

    @encryption_certificate.setter
    def encryption_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_certificate", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identity Provider Icon URL.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="idpSsoUrl")
    def idp_sso_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identity Provider SSO URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idp_sso_url")

    @idp_sso_url.setter
    def idp_sso_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_sso_url", value)

    @property
    @pulumi.getter(name="includeSigningCertInSignature")
    def include_signing_cert_in_signature(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to include the signing certificate in the signature.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "include_signing_cert_in_signature")

    @include_signing_cert_in_signature.setter
    def include_signing_cert_in_signature(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_signing_cert_in_signature", value)

    @property
    @pulumi.getter(name="jitUserProvAssignedGroups")
    def jit_user_prov_assigned_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]]]:
        """
        (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_assigned_groups")

    @jit_user_prov_assigned_groups.setter
    def jit_user_prov_assigned_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]]]):
        pulumi.set(self, "jit_user_prov_assigned_groups", value)

    @property
    @pulumi.getter(name="jitUserProvAttributeUpdateEnabled")
    def jit_user_prov_attribute_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Creation is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_attribute_update_enabled")

    @jit_user_prov_attribute_update_enabled.setter
    def jit_user_prov_attribute_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_attribute_update_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvAttributes")
    def jit_user_prov_attributes(self) -> Optional[pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs']]:
        """
        (Updatable) Assertion To User Mapping

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_attributes")

    @jit_user_prov_attributes.setter
    def jit_user_prov_attributes(self, value: Optional[pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs']]):
        pulumi.set(self, "jit_user_prov_attributes", value)

    @property
    @pulumi.getter(name="jitUserProvCreateUserEnabled")
    def jit_user_prov_create_user_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Creation is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_create_user_enabled")

    @jit_user_prov_create_user_enabled.setter
    def jit_user_prov_create_user_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_create_user_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvEnabled")
    def jit_user_prov_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_enabled")

    @jit_user_prov_enabled.setter
    def jit_user_prov_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvGroupAssertionAttributeEnabled")
    def jit_user_prov_group_assertion_attribute_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_assertion_attribute_enabled")

    @jit_user_prov_group_assertion_attribute_enabled.setter
    def jit_user_prov_group_assertion_attribute_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_group_assertion_attribute_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvGroupAssignmentMethod")
    def jit_user_prov_group_assignment_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_assignment_method")

    @jit_user_prov_group_assignment_method.setter
    def jit_user_prov_group_assignment_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jit_user_prov_group_assignment_method", value)

    @property
    @pulumi.getter(name="jitUserProvGroupMappingMode")
    def jit_user_prov_group_mapping_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property to indicate the mode of group mapping

        **Added In:** 2205120021

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_mapping_mode")

    @jit_user_prov_group_mapping_mode.setter
    def jit_user_prov_group_mapping_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jit_user_prov_group_mapping_mode", value)

    @property
    @pulumi.getter(name="jitUserProvGroupMappings")
    def jit_user_prov_group_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]]]:
        """
        (Updatable) The list of mappings between the Identity Domain Group and the IDP group.

        **Added In:** 2205120021

        **SCIM++ Properties:**
        * idcsCompositeKey: [idpGroup]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_mappings")

    @jit_user_prov_group_mappings.setter
    def jit_user_prov_group_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]]]):
        pulumi.set(self, "jit_user_prov_group_mappings", value)

    @property
    @pulumi.getter(name="jitUserProvGroupSamlAttributeName")
    def jit_user_prov_group_saml_attribute_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the assertion attribute containing the users groups

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_saml_attribute_name")

    @jit_user_prov_group_saml_attribute_name.setter
    def jit_user_prov_group_saml_attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jit_user_prov_group_saml_attribute_name", value)

    @property
    @pulumi.getter(name="jitUserProvGroupStaticListEnabled")
    def jit_user_prov_group_static_list_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_static_list_enabled")

    @jit_user_prov_group_static_list_enabled.setter
    def jit_user_prov_group_static_list_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_group_static_list_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvIgnoreErrorOnAbsentGroups")
    def jit_user_prov_ignore_error_on_absent_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate ignoring absence of group while provisioning

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * caseExact: false
        * idcsAddedSinceVersion: 30
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_ignore_error_on_absent_groups")

    @jit_user_prov_ignore_error_on_absent_groups.setter
    def jit_user_prov_ignore_error_on_absent_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_ignore_error_on_absent_groups", value)

    @property
    @pulumi.getter(name="logoutBinding")
    def logout_binding(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) HTTP binding to use for logout.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_binding")

    @logout_binding.setter
    def logout_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_binding", value)

    @property
    @pulumi.getter(name="logoutEnabled")
    def logout_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to enable logout.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "logout_enabled")

    @logout_enabled.setter
    def logout_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logout_enabled", value)

    @property
    @pulumi.getter(name="logoutRequestUrl")
    def logout_request_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logout request URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_request_url")

    @logout_request_url.setter
    def logout_request_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_request_url", value)

    @property
    @pulumi.getter(name="logoutResponseUrl")
    def logout_response_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logout response URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_response_url")

    @logout_response_url.setter
    def logout_response_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_response_url", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Metadata

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Default authentication request name ID format.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name_id_format")

    @name_id_format.setter
    def name_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_id_format", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="partnerProviderId")
    def partner_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provider ID

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "partner_provider_id")

    @partner_provider_id.setter
    def partner_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_provider_id", value)

    @property
    @pulumi.getter(name="requestedAuthenticationContexts")
    def requested_authentication_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) SAML SP authentication type.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "requested_authentication_contexts")

    @requested_authentication_contexts.setter
    def requested_authentication_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requested_authentication_contexts", value)

    @property
    @pulumi.getter(name="requireForceAuthn")
    def require_force_authn(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) This SP requires requests SAML IdP to enforce re-authentication.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "require_force_authn")

    @require_force_authn.setter
    def require_force_authn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_force_authn", value)

    @property
    @pulumi.getter(name="requiresEncryptedAssertion")
    def requires_encrypted_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) SAML SP must accept encrypted assertion only.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "requires_encrypted_assertion")

    @requires_encrypted_assertion.setter
    def requires_encrypted_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requires_encrypted_assertion", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="samlHoKrequired")
    def saml_ho_krequired(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) SAML SP HoK Enabled.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "saml_ho_krequired")

    @saml_ho_krequired.setter
    def saml_ho_krequired(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml_ho_krequired", value)

    @property
    @pulumi.getter(name="serviceInstanceIdentifier")
    def service_instance_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: never
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "service_instance_identifier")

    @service_instance_identifier.setter
    def service_instance_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_instance_identifier", value)

    @property
    @pulumi.getter(name="shownOnLoginPage")
    def shown_on_login_page(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate whether to show IdP in login page or not.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "shown_on_login_page")

    @shown_on_login_page.setter
    def shown_on_login_page(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shown_on_login_page", value)

    @property
    @pulumi.getter(name="signatureHashAlgorithm")
    def signature_hash_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Signature hash algorithm.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "signature_hash_algorithm")

    @signature_hash_algorithm.setter
    def signature_hash_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_hash_algorithm", value)

    @property
    @pulumi.getter(name="signingCertificate")
    def signing_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Signing certificate

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "signing_certificate")

    @signing_certificate.setter
    def signing_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_certificate", value)

    @property
    @pulumi.getter(name="succinctId")
    def succinct_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Succinct ID

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "succinct_id")

    @succinct_id.setter
    def succinct_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "succinct_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identity Provider Type

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsocialIdentityProvider")
    def urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider(self) -> Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs']]:
        """
        (Updatable) Social Identity Provider Extension Schema
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider")

    @urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider.setter
    def urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider(self, value: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionx509identityProvider")
    def urnietfparamsscimschemasoracleidcsextensionx509identity_provider(self) -> Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs']]:
        """
        (Updatable) X509 Identity Provider Extension Schema
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider")

    @urnietfparamsscimschemasoracleidcsextensionx509identity_provider.setter
    def urnietfparamsscimschemasoracleidcsextensionx509identity_provider(self, value: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider", value)

    @property
    @pulumi.getter(name="userMappingMethod")
    def user_mapping_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User mapping method.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true
        """
        return pulumi.get(self, "user_mapping_method")

    @user_mapping_method.setter
    def user_mapping_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_mapping_method", value)

    @property
    @pulumi.getter(name="userMappingStoreAttribute")
    def user_mapping_store_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_mapping_store_attribute")

    @user_mapping_store_attribute.setter
    def user_mapping_store_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_mapping_store_attribute", value)


@pulumi.input_type
class _DomainsIdentityProviderState:
    def __init__(__self__, *,
                 assertion_attribute: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authn_request_binding: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 correlation_policy: Optional[pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs']] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 encryption_certificate: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 idp_sso_url: Optional[pulumi.Input[str]] = None,
                 include_signing_cert_in_signature: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]]] = None,
                 jit_user_prov_attribute_update_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_attributes: Optional[pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs']] = None,
                 jit_user_prov_create_user_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assertion_attribute_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assignment_method: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mapping_mode: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]]] = None,
                 jit_user_prov_group_saml_attribute_name: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_static_list_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_ignore_error_on_absent_groups: Optional[pulumi.Input[bool]] = None,
                 last_notification_sent_time: Optional[pulumi.Input[str]] = None,
                 logout_binding: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_request_url: Optional[pulumi.Input[str]] = None,
                 logout_response_url: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderMetaArgs']]]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 partner_name: Optional[pulumi.Input[str]] = None,
                 partner_provider_id: Optional[pulumi.Input[str]] = None,
                 requested_authentication_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_force_authn: Optional[pulumi.Input[bool]] = None,
                 requires_encrypted_assertion: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_ho_krequired: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_instance_identifier: Optional[pulumi.Input[str]] = None,
                 shown_on_login_page: Optional[pulumi.Input[bool]] = None,
                 signature_hash_algorithm: Optional[pulumi.Input[str]] = None,
                 signing_certificate: Optional[pulumi.Input[str]] = None,
                 succinct_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 tenant_provider_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionx509identity_provider: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs']] = None,
                 user_mapping_method: Optional[pulumi.Input[str]] = None,
                 user_mapping_store_attribute: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DomainsIdentityProvider resources.
        :param pulumi.Input[str] assertion_attribute: (Updatable) Assertion attribute name.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authn_request_binding: (Updatable) HTTP binding to use for authentication requests.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs'] correlation_policy: (Updatable) Correlation policy
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) Description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] enabled: (Updatable) Set to true to indicate Partner enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] encryption_certificate: (Updatable) Encryption certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon_url: (Updatable) Identity Provider Icon URL.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idp_sso_url: (Updatable) Identity Provider SSO URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] include_signing_cert_in_signature: (Updatable) Set to true to include the signing certificate in the signature.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]] jit_user_prov_assigned_groups: (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_attribute_update_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs'] jit_user_prov_attributes: (Updatable) Assertion To User Mapping
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_create_user_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_enabled: (Updatable) Set to true to indicate JIT User Provisioning is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_assertion_attribute_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_assignment_method: (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_mapping_mode: (Updatable) Property to indicate the mode of group mapping
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]] jit_user_prov_group_mappings: (Updatable) The list of mappings between the Identity Domain Group and the IDP group.
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [idpGroup]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_saml_attribute_name: (Updatable) Name of the assertion attribute containing the users groups
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_static_list_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_ignore_error_on_absent_groups: (Updatable) Set to true to indicate ignoring absence of group while provisioning
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsAddedSinceVersion: 30
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] last_notification_sent_time: (Updatable) Records the notification timestamp for the IdP whose signing certificate is about to expire
               
               **Added In:** 2302092332
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[str] logout_binding: (Updatable) HTTP binding to use for logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] logout_enabled: (Updatable) Set to true to enable logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] logout_request_url: (Updatable) Logout request URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_response_url: (Updatable) Logout response URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] metadata: (Updatable) Metadata
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] name_id_format: (Updatable) Default authentication request name ID format.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] partner_name: (Updatable) Unique name of the trusted Identity Provider.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[str] partner_provider_id: (Updatable) Provider ID
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_authentication_contexts: (Updatable) SAML SP authentication type.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] require_force_authn: (Updatable) This SP requires requests SAML IdP to enforce re-authentication.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] requires_encrypted_assertion: (Updatable) SAML SP must accept encrypted assertion only.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] saml_ho_krequired: (Updatable) SAML SP HoK Enabled.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_instance_identifier: (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: server
        :param pulumi.Input[bool] shown_on_login_page: (Updatable) Set to true to indicate whether to show IdP in login page or not.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] signature_hash_algorithm: (Updatable) Signature hash algorithm.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] signing_certificate: (Updatable) Signing certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] succinct_id: (Updatable) Succinct ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] tenant_provider_id: (Updatable) The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this IdP.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) Identity Provider Type
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs'] urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: (Updatable) Social Identity Provider Extension Schema
        :param pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs'] urnietfparamsscimschemasoracleidcsextensionx509identity_provider: (Updatable) X509 Identity Provider Extension Schema
        :param pulumi.Input[str] user_mapping_method: (Updatable) User mapping method.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[str] user_mapping_store_attribute: (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if assertion_attribute is not None:
            pulumi.set(__self__, "assertion_attribute", assertion_attribute)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authn_request_binding is not None:
            pulumi.set(__self__, "authn_request_binding", authn_request_binding)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if correlation_policy is not None:
            pulumi.set(__self__, "correlation_policy", correlation_policy)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if encryption_certificate is not None:
            pulumi.set(__self__, "encryption_certificate", encryption_certificate)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if icon_url is not None:
            pulumi.set(__self__, "icon_url", icon_url)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if idp_sso_url is not None:
            pulumi.set(__self__, "idp_sso_url", idp_sso_url)
        if include_signing_cert_in_signature is not None:
            pulumi.set(__self__, "include_signing_cert_in_signature", include_signing_cert_in_signature)
        if jit_user_prov_assigned_groups is not None:
            pulumi.set(__self__, "jit_user_prov_assigned_groups", jit_user_prov_assigned_groups)
        if jit_user_prov_attribute_update_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_attribute_update_enabled", jit_user_prov_attribute_update_enabled)
        if jit_user_prov_attributes is not None:
            pulumi.set(__self__, "jit_user_prov_attributes", jit_user_prov_attributes)
        if jit_user_prov_create_user_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_create_user_enabled", jit_user_prov_create_user_enabled)
        if jit_user_prov_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_enabled", jit_user_prov_enabled)
        if jit_user_prov_group_assertion_attribute_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_group_assertion_attribute_enabled", jit_user_prov_group_assertion_attribute_enabled)
        if jit_user_prov_group_assignment_method is not None:
            pulumi.set(__self__, "jit_user_prov_group_assignment_method", jit_user_prov_group_assignment_method)
        if jit_user_prov_group_mapping_mode is not None:
            pulumi.set(__self__, "jit_user_prov_group_mapping_mode", jit_user_prov_group_mapping_mode)
        if jit_user_prov_group_mappings is not None:
            pulumi.set(__self__, "jit_user_prov_group_mappings", jit_user_prov_group_mappings)
        if jit_user_prov_group_saml_attribute_name is not None:
            pulumi.set(__self__, "jit_user_prov_group_saml_attribute_name", jit_user_prov_group_saml_attribute_name)
        if jit_user_prov_group_static_list_enabled is not None:
            pulumi.set(__self__, "jit_user_prov_group_static_list_enabled", jit_user_prov_group_static_list_enabled)
        if jit_user_prov_ignore_error_on_absent_groups is not None:
            pulumi.set(__self__, "jit_user_prov_ignore_error_on_absent_groups", jit_user_prov_ignore_error_on_absent_groups)
        if last_notification_sent_time is not None:
            pulumi.set(__self__, "last_notification_sent_time", last_notification_sent_time)
        if logout_binding is not None:
            pulumi.set(__self__, "logout_binding", logout_binding)
        if logout_enabled is not None:
            pulumi.set(__self__, "logout_enabled", logout_enabled)
        if logout_request_url is not None:
            pulumi.set(__self__, "logout_request_url", logout_request_url)
        if logout_response_url is not None:
            pulumi.set(__self__, "logout_response_url", logout_response_url)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if partner_name is not None:
            pulumi.set(__self__, "partner_name", partner_name)
        if partner_provider_id is not None:
            pulumi.set(__self__, "partner_provider_id", partner_provider_id)
        if requested_authentication_contexts is not None:
            pulumi.set(__self__, "requested_authentication_contexts", requested_authentication_contexts)
        if require_force_authn is not None:
            pulumi.set(__self__, "require_force_authn", require_force_authn)
        if requires_encrypted_assertion is not None:
            pulumi.set(__self__, "requires_encrypted_assertion", requires_encrypted_assertion)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if saml_ho_krequired is not None:
            pulumi.set(__self__, "saml_ho_krequired", saml_ho_krequired)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if service_instance_identifier is not None:
            pulumi.set(__self__, "service_instance_identifier", service_instance_identifier)
        if shown_on_login_page is not None:
            pulumi.set(__self__, "shown_on_login_page", shown_on_login_page)
        if signature_hash_algorithm is not None:
            pulumi.set(__self__, "signature_hash_algorithm", signature_hash_algorithm)
        if signing_certificate is not None:
            pulumi.set(__self__, "signing_certificate", signing_certificate)
        if succinct_id is not None:
            pulumi.set(__self__, "succinct_id", succinct_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if tenant_provider_id is not None:
            pulumi.set(__self__, "tenant_provider_id", tenant_provider_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider", urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider)
        if urnietfparamsscimschemasoracleidcsextensionx509identity_provider is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider", urnietfparamsscimschemasoracleidcsextensionx509identity_provider)
        if user_mapping_method is not None:
            pulumi.set(__self__, "user_mapping_method", user_mapping_method)
        if user_mapping_store_attribute is not None:
            pulumi.set(__self__, "user_mapping_store_attribute", user_mapping_store_attribute)

    @property
    @pulumi.getter(name="assertionAttribute")
    def assertion_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Assertion attribute name.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true
        """
        return pulumi.get(self, "assertion_attribute")

    @assertion_attribute.setter
    def assertion_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assertion_attribute", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="authnRequestBinding")
    def authn_request_binding(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) HTTP binding to use for authentication requests.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "authn_request_binding")

    @authn_request_binding.setter
    def authn_request_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authn_request_binding", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="correlationPolicy")
    def correlation_policy(self) -> Optional[pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs']]:
        """
        (Updatable) Correlation policy

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "correlation_policy")

    @correlation_policy.setter
    def correlation_policy(self, value: Optional[pulumi.Input['DomainsIdentityProviderCorrelationPolicyArgs']]):
        pulumi.set(self, "correlation_policy", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate Partner enabled.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="encryptionCertificate")
    def encryption_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Encryption certificate

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "encryption_certificate")

    @encryption_certificate.setter
    def encryption_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_certificate", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identity Provider Icon URL.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "icon_url")

    @icon_url.setter
    def icon_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "icon_url", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="idpSsoUrl")
    def idp_sso_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identity Provider SSO URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idp_sso_url")

    @idp_sso_url.setter
    def idp_sso_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idp_sso_url", value)

    @property
    @pulumi.getter(name="includeSigningCertInSignature")
    def include_signing_cert_in_signature(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to include the signing certificate in the signature.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "include_signing_cert_in_signature")

    @include_signing_cert_in_signature.setter
    def include_signing_cert_in_signature(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_signing_cert_in_signature", value)

    @property
    @pulumi.getter(name="jitUserProvAssignedGroups")
    def jit_user_prov_assigned_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]]]:
        """
        (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_assigned_groups")

    @jit_user_prov_assigned_groups.setter
    def jit_user_prov_assigned_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvAssignedGroupArgs']]]]):
        pulumi.set(self, "jit_user_prov_assigned_groups", value)

    @property
    @pulumi.getter(name="jitUserProvAttributeUpdateEnabled")
    def jit_user_prov_attribute_update_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Creation is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_attribute_update_enabled")

    @jit_user_prov_attribute_update_enabled.setter
    def jit_user_prov_attribute_update_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_attribute_update_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvAttributes")
    def jit_user_prov_attributes(self) -> Optional[pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs']]:
        """
        (Updatable) Assertion To User Mapping

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_attributes")

    @jit_user_prov_attributes.setter
    def jit_user_prov_attributes(self, value: Optional[pulumi.Input['DomainsIdentityProviderJitUserProvAttributesArgs']]):
        pulumi.set(self, "jit_user_prov_attributes", value)

    @property
    @pulumi.getter(name="jitUserProvCreateUserEnabled")
    def jit_user_prov_create_user_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Creation is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_create_user_enabled")

    @jit_user_prov_create_user_enabled.setter
    def jit_user_prov_create_user_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_create_user_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvEnabled")
    def jit_user_prov_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_enabled")

    @jit_user_prov_enabled.setter
    def jit_user_prov_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvGroupAssertionAttributeEnabled")
    def jit_user_prov_group_assertion_attribute_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_assertion_attribute_enabled")

    @jit_user_prov_group_assertion_attribute_enabled.setter
    def jit_user_prov_group_assertion_attribute_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_group_assertion_attribute_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvGroupAssignmentMethod")
    def jit_user_prov_group_assignment_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_assignment_method")

    @jit_user_prov_group_assignment_method.setter
    def jit_user_prov_group_assignment_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jit_user_prov_group_assignment_method", value)

    @property
    @pulumi.getter(name="jitUserProvGroupMappingMode")
    def jit_user_prov_group_mapping_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property to indicate the mode of group mapping

        **Added In:** 2205120021

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_mapping_mode")

    @jit_user_prov_group_mapping_mode.setter
    def jit_user_prov_group_mapping_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jit_user_prov_group_mapping_mode", value)

    @property
    @pulumi.getter(name="jitUserProvGroupMappings")
    def jit_user_prov_group_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]]]:
        """
        (Updatable) The list of mappings between the Identity Domain Group and the IDP group.

        **Added In:** 2205120021

        **SCIM++ Properties:**
        * idcsCompositeKey: [idpGroup]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_mappings")

    @jit_user_prov_group_mappings.setter
    def jit_user_prov_group_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderJitUserProvGroupMappingArgs']]]]):
        pulumi.set(self, "jit_user_prov_group_mappings", value)

    @property
    @pulumi.getter(name="jitUserProvGroupSamlAttributeName")
    def jit_user_prov_group_saml_attribute_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the assertion attribute containing the users groups

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_saml_attribute_name")

    @jit_user_prov_group_saml_attribute_name.setter
    def jit_user_prov_group_saml_attribute_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jit_user_prov_group_saml_attribute_name", value)

    @property
    @pulumi.getter(name="jitUserProvGroupStaticListEnabled")
    def jit_user_prov_group_static_list_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_static_list_enabled")

    @jit_user_prov_group_static_list_enabled.setter
    def jit_user_prov_group_static_list_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_group_static_list_enabled", value)

    @property
    @pulumi.getter(name="jitUserProvIgnoreErrorOnAbsentGroups")
    def jit_user_prov_ignore_error_on_absent_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate ignoring absence of group while provisioning

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * caseExact: false
        * idcsAddedSinceVersion: 30
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_ignore_error_on_absent_groups")

    @jit_user_prov_ignore_error_on_absent_groups.setter
    def jit_user_prov_ignore_error_on_absent_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "jit_user_prov_ignore_error_on_absent_groups", value)

    @property
    @pulumi.getter(name="lastNotificationSentTime")
    def last_notification_sent_time(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Records the notification timestamp for the IdP whose signing certificate is about to expire

        **Added In:** 2302092332

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "last_notification_sent_time")

    @last_notification_sent_time.setter
    def last_notification_sent_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_notification_sent_time", value)

    @property
    @pulumi.getter(name="logoutBinding")
    def logout_binding(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) HTTP binding to use for logout.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_binding")

    @logout_binding.setter
    def logout_binding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_binding", value)

    @property
    @pulumi.getter(name="logoutEnabled")
    def logout_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to enable logout.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "logout_enabled")

    @logout_enabled.setter
    def logout_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "logout_enabled", value)

    @property
    @pulumi.getter(name="logoutRequestUrl")
    def logout_request_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logout request URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_request_url")

    @logout_request_url.setter
    def logout_request_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_request_url", value)

    @property
    @pulumi.getter(name="logoutResponseUrl")
    def logout_response_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Logout response URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_response_url")

    @logout_response_url.setter
    def logout_response_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logout_response_url", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Metadata

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Default authentication request name ID format.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name_id_format")

    @name_id_format.setter
    def name_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_id_format", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Unique name of the trusted Identity Provider.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "partner_name")

    @partner_name.setter
    def partner_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_name", value)

    @property
    @pulumi.getter(name="partnerProviderId")
    def partner_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Provider ID

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "partner_provider_id")

    @partner_provider_id.setter
    def partner_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_provider_id", value)

    @property
    @pulumi.getter(name="requestedAuthenticationContexts")
    def requested_authentication_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) SAML SP authentication type.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "requested_authentication_contexts")

    @requested_authentication_contexts.setter
    def requested_authentication_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requested_authentication_contexts", value)

    @property
    @pulumi.getter(name="requireForceAuthn")
    def require_force_authn(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) This SP requires requests SAML IdP to enforce re-authentication.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "require_force_authn")

    @require_force_authn.setter
    def require_force_authn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_force_authn", value)

    @property
    @pulumi.getter(name="requiresEncryptedAssertion")
    def requires_encrypted_assertion(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) SAML SP must accept encrypted assertion only.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "requires_encrypted_assertion")

    @requires_encrypted_assertion.setter
    def requires_encrypted_assertion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "requires_encrypted_assertion", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter(name="samlHoKrequired")
    def saml_ho_krequired(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) SAML SP HoK Enabled.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "saml_ho_krequired")

    @saml_ho_krequired.setter
    def saml_ho_krequired(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "saml_ho_krequired", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="serviceInstanceIdentifier")
    def service_instance_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: never
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "service_instance_identifier")

    @service_instance_identifier.setter
    def service_instance_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_instance_identifier", value)

    @property
    @pulumi.getter(name="shownOnLoginPage")
    def shown_on_login_page(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Set to true to indicate whether to show IdP in login page or not.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "shown_on_login_page")

    @shown_on_login_page.setter
    def shown_on_login_page(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shown_on_login_page", value)

    @property
    @pulumi.getter(name="signatureHashAlgorithm")
    def signature_hash_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Signature hash algorithm.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "signature_hash_algorithm")

    @signature_hash_algorithm.setter
    def signature_hash_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature_hash_algorithm", value)

    @property
    @pulumi.getter(name="signingCertificate")
    def signing_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Signing certificate

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "signing_certificate")

    @signing_certificate.setter
    def signing_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signing_certificate", value)

    @property
    @pulumi.getter(name="succinctId")
    def succinct_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Succinct ID

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "succinct_id")

    @succinct_id.setter
    def succinct_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "succinct_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsIdentityProviderTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter(name="tenantProviderId")
    def tenant_provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this IdP.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenant_provider_id")

    @tenant_provider_id.setter
    def tenant_provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_provider_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Identity Provider Type

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsocialIdentityProvider")
    def urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider(self) -> Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs']]:
        """
        (Updatable) Social Identity Provider Extension Schema
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider")

    @urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider.setter
    def urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider(self, value: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionx509identityProvider")
    def urnietfparamsscimschemasoracleidcsextensionx509identity_provider(self) -> Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs']]:
        """
        (Updatable) X509 Identity Provider Extension Schema
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider")

    @urnietfparamsscimschemasoracleidcsextensionx509identity_provider.setter
    def urnietfparamsscimschemasoracleidcsextensionx509identity_provider(self, value: Optional[pulumi.Input['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider", value)

    @property
    @pulumi.getter(name="userMappingMethod")
    def user_mapping_method(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User mapping method.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true
        """
        return pulumi.get(self, "user_mapping_method")

    @user_mapping_method.setter
    def user_mapping_method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_mapping_method", value)

    @property
    @pulumi.getter(name="userMappingStoreAttribute")
    def user_mapping_store_attribute(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_mapping_store_attribute")

    @user_mapping_store_attribute.setter
    def user_mapping_store_attribute(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_mapping_store_attribute", value)


class DomainsIdentityProvider(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assertion_attribute: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authn_request_binding: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 correlation_policy: Optional[pulumi.Input[Union['DomainsIdentityProviderCorrelationPolicyArgs', 'DomainsIdentityProviderCorrelationPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 encryption_certificate: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idp_sso_url: Optional[pulumi.Input[str]] = None,
                 include_signing_cert_in_signature: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAssignedGroupArgs', 'DomainsIdentityProviderJitUserProvAssignedGroupArgsDict']]]]] = None,
                 jit_user_prov_attribute_update_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_attributes: Optional[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAttributesArgs', 'DomainsIdentityProviderJitUserProvAttributesArgsDict']]] = None,
                 jit_user_prov_create_user_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assertion_attribute_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assignment_method: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mapping_mode: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvGroupMappingArgs', 'DomainsIdentityProviderJitUserProvGroupMappingArgsDict']]]]] = None,
                 jit_user_prov_group_saml_attribute_name: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_static_list_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_ignore_error_on_absent_groups: Optional[pulumi.Input[bool]] = None,
                 logout_binding: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_request_url: Optional[pulumi.Input[str]] = None,
                 logout_response_url: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 partner_name: Optional[pulumi.Input[str]] = None,
                 partner_provider_id: Optional[pulumi.Input[str]] = None,
                 requested_authentication_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_force_authn: Optional[pulumi.Input[bool]] = None,
                 requires_encrypted_assertion: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_ho_krequired: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_instance_identifier: Optional[pulumi.Input[str]] = None,
                 shown_on_login_page: Optional[pulumi.Input[bool]] = None,
                 signature_hash_algorithm: Optional[pulumi.Input[str]] = None,
                 signing_certificate: Optional[pulumi.Input[str]] = None,
                 succinct_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderTagArgs', 'DomainsIdentityProviderTagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: Optional[pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionx509identity_provider: Optional[pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgsDict']]] = None,
                 user_mapping_method: Optional[pulumi.Input[str]] = None,
                 user_mapping_store_attribute: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Identity Provider resource in Oracle Cloud Infrastructure Identity Domains service.

        Create an Identity Provider

        ## Import

        IdentityProviders can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsIdentityProvider:DomainsIdentityProvider test_identity_provider "idcsEndpoint/{idcsEndpoint}/identityProviders/{identityProviderId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assertion_attribute: (Updatable) Assertion attribute name.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authn_request_binding: (Updatable) HTTP binding to use for authentication requests.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[Union['DomainsIdentityProviderCorrelationPolicyArgs', 'DomainsIdentityProviderCorrelationPolicyArgsDict']] correlation_policy: (Updatable) Correlation policy
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) Description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] enabled: (Updatable) Set to true to indicate Partner enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] encryption_certificate: (Updatable) Encryption certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon_url: (Updatable) Identity Provider Icon URL.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[str] idp_sso_url: (Updatable) Identity Provider SSO URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] include_signing_cert_in_signature: (Updatable) Set to true to include the signing certificate in the signature.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAssignedGroupArgs', 'DomainsIdentityProviderJitUserProvAssignedGroupArgsDict']]]] jit_user_prov_assigned_groups: (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_attribute_update_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsIdentityProviderJitUserProvAttributesArgs', 'DomainsIdentityProviderJitUserProvAttributesArgsDict']] jit_user_prov_attributes: (Updatable) Assertion To User Mapping
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_create_user_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_enabled: (Updatable) Set to true to indicate JIT User Provisioning is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_assertion_attribute_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_assignment_method: (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_mapping_mode: (Updatable) Property to indicate the mode of group mapping
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvGroupMappingArgs', 'DomainsIdentityProviderJitUserProvGroupMappingArgsDict']]]] jit_user_prov_group_mappings: (Updatable) The list of mappings between the Identity Domain Group and the IDP group.
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [idpGroup]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_saml_attribute_name: (Updatable) Name of the assertion attribute containing the users groups
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_static_list_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_ignore_error_on_absent_groups: (Updatable) Set to true to indicate ignoring absence of group while provisioning
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsAddedSinceVersion: 30
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] logout_binding: (Updatable) HTTP binding to use for logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] logout_enabled: (Updatable) Set to true to enable logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] logout_request_url: (Updatable) Logout request URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_response_url: (Updatable) Logout response URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] metadata: (Updatable) Metadata
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] name_id_format: (Updatable) Default authentication request name ID format.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] partner_name: (Updatable) Unique name of the trusted Identity Provider.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[str] partner_provider_id: (Updatable) Provider ID
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_authentication_contexts: (Updatable) SAML SP authentication type.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] require_force_authn: (Updatable) This SP requires requests SAML IdP to enforce re-authentication.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] requires_encrypted_assertion: (Updatable) SAML SP must accept encrypted assertion only.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] saml_ho_krequired: (Updatable) SAML SP HoK Enabled.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_instance_identifier: (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: server
        :param pulumi.Input[bool] shown_on_login_page: (Updatable) Set to true to indicate whether to show IdP in login page or not.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] signature_hash_algorithm: (Updatable) Signature hash algorithm.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] signing_certificate: (Updatable) Signing certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] succinct_id: (Updatable) Succinct ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderTagArgs', 'DomainsIdentityProviderTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) Identity Provider Type
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgsDict']] urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: (Updatable) Social Identity Provider Extension Schema
        :param pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgsDict']] urnietfparamsscimschemasoracleidcsextensionx509identity_provider: (Updatable) X509 Identity Provider Extension Schema
        :param pulumi.Input[str] user_mapping_method: (Updatable) User mapping method.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[str] user_mapping_store_attribute: (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsIdentityProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Identity Provider resource in Oracle Cloud Infrastructure Identity Domains service.

        Create an Identity Provider

        ## Import

        IdentityProviders can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsIdentityProvider:DomainsIdentityProvider test_identity_provider "idcsEndpoint/{idcsEndpoint}/identityProviders/{identityProviderId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsIdentityProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsIdentityProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assertion_attribute: Optional[pulumi.Input[str]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authn_request_binding: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 correlation_policy: Optional[pulumi.Input[Union['DomainsIdentityProviderCorrelationPolicyArgs', 'DomainsIdentityProviderCorrelationPolicyArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 encryption_certificate: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 icon_url: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idp_sso_url: Optional[pulumi.Input[str]] = None,
                 include_signing_cert_in_signature: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAssignedGroupArgs', 'DomainsIdentityProviderJitUserProvAssignedGroupArgsDict']]]]] = None,
                 jit_user_prov_attribute_update_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_attributes: Optional[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAttributesArgs', 'DomainsIdentityProviderJitUserProvAttributesArgsDict']]] = None,
                 jit_user_prov_create_user_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assertion_attribute_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_group_assignment_method: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mapping_mode: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvGroupMappingArgs', 'DomainsIdentityProviderJitUserProvGroupMappingArgsDict']]]]] = None,
                 jit_user_prov_group_saml_attribute_name: Optional[pulumi.Input[str]] = None,
                 jit_user_prov_group_static_list_enabled: Optional[pulumi.Input[bool]] = None,
                 jit_user_prov_ignore_error_on_absent_groups: Optional[pulumi.Input[bool]] = None,
                 logout_binding: Optional[pulumi.Input[str]] = None,
                 logout_enabled: Optional[pulumi.Input[bool]] = None,
                 logout_request_url: Optional[pulumi.Input[str]] = None,
                 logout_response_url: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[str]] = None,
                 name_id_format: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 partner_name: Optional[pulumi.Input[str]] = None,
                 partner_provider_id: Optional[pulumi.Input[str]] = None,
                 requested_authentication_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 require_force_authn: Optional[pulumi.Input[bool]] = None,
                 requires_encrypted_assertion: Optional[pulumi.Input[bool]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 saml_ho_krequired: Optional[pulumi.Input[bool]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_instance_identifier: Optional[pulumi.Input[str]] = None,
                 shown_on_login_page: Optional[pulumi.Input[bool]] = None,
                 signature_hash_algorithm: Optional[pulumi.Input[str]] = None,
                 signing_certificate: Optional[pulumi.Input[str]] = None,
                 succinct_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderTagArgs', 'DomainsIdentityProviderTagArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: Optional[pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgsDict']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionx509identity_provider: Optional[pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgsDict']]] = None,
                 user_mapping_method: Optional[pulumi.Input[str]] = None,
                 user_mapping_store_attribute: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsIdentityProviderArgs.__new__(DomainsIdentityProviderArgs)

            __props__.__dict__["assertion_attribute"] = assertion_attribute
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authn_request_binding"] = authn_request_binding
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["correlation_policy"] = correlation_policy
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["encryption_certificate"] = encryption_certificate
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["icon_url"] = icon_url
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["idp_sso_url"] = idp_sso_url
            __props__.__dict__["include_signing_cert_in_signature"] = include_signing_cert_in_signature
            __props__.__dict__["jit_user_prov_assigned_groups"] = jit_user_prov_assigned_groups
            __props__.__dict__["jit_user_prov_attribute_update_enabled"] = jit_user_prov_attribute_update_enabled
            __props__.__dict__["jit_user_prov_attributes"] = jit_user_prov_attributes
            __props__.__dict__["jit_user_prov_create_user_enabled"] = jit_user_prov_create_user_enabled
            __props__.__dict__["jit_user_prov_enabled"] = jit_user_prov_enabled
            __props__.__dict__["jit_user_prov_group_assertion_attribute_enabled"] = jit_user_prov_group_assertion_attribute_enabled
            __props__.__dict__["jit_user_prov_group_assignment_method"] = jit_user_prov_group_assignment_method
            __props__.__dict__["jit_user_prov_group_mapping_mode"] = jit_user_prov_group_mapping_mode
            __props__.__dict__["jit_user_prov_group_mappings"] = jit_user_prov_group_mappings
            __props__.__dict__["jit_user_prov_group_saml_attribute_name"] = jit_user_prov_group_saml_attribute_name
            __props__.__dict__["jit_user_prov_group_static_list_enabled"] = jit_user_prov_group_static_list_enabled
            __props__.__dict__["jit_user_prov_ignore_error_on_absent_groups"] = jit_user_prov_ignore_error_on_absent_groups
            __props__.__dict__["logout_binding"] = logout_binding
            __props__.__dict__["logout_enabled"] = logout_enabled
            __props__.__dict__["logout_request_url"] = logout_request_url
            __props__.__dict__["logout_response_url"] = logout_response_url
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name_id_format"] = name_id_format
            __props__.__dict__["ocid"] = ocid
            if partner_name is None and not opts.urn:
                raise TypeError("Missing required property 'partner_name'")
            __props__.__dict__["partner_name"] = partner_name
            __props__.__dict__["partner_provider_id"] = partner_provider_id
            __props__.__dict__["requested_authentication_contexts"] = requested_authentication_contexts
            __props__.__dict__["require_force_authn"] = require_force_authn
            __props__.__dict__["requires_encrypted_assertion"] = requires_encrypted_assertion
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            __props__.__dict__["saml_ho_krequired"] = saml_ho_krequired
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["service_instance_identifier"] = service_instance_identifier
            __props__.__dict__["shown_on_login_page"] = shown_on_login_page
            __props__.__dict__["signature_hash_algorithm"] = signature_hash_algorithm
            __props__.__dict__["signing_certificate"] = signing_certificate
            __props__.__dict__["succinct_id"] = succinct_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider"] = urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionx509identity_provider"] = urnietfparamsscimschemasoracleidcsextensionx509identity_provider
            __props__.__dict__["user_mapping_method"] = user_mapping_method
            __props__.__dict__["user_mapping_store_attribute"] = user_mapping_store_attribute
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["last_notification_sent_time"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
            __props__.__dict__["tenant_provider_id"] = None
        super(DomainsIdentityProvider, __self__).__init__(
            'oci:Identity/domainsIdentityProvider:DomainsIdentityProvider',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assertion_attribute: Optional[pulumi.Input[str]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authn_request_binding: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            correlation_policy: Optional[pulumi.Input[Union['DomainsIdentityProviderCorrelationPolicyArgs', 'DomainsIdentityProviderCorrelationPolicyArgsDict']]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            encryption_certificate: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            icon_url: Optional[pulumi.Input[str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderIdcsCreatedByArgs', 'DomainsIdentityProviderIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderIdcsLastModifiedByArgs', 'DomainsIdentityProviderIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            idp_sso_url: Optional[pulumi.Input[str]] = None,
            include_signing_cert_in_signature: Optional[pulumi.Input[bool]] = None,
            jit_user_prov_assigned_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAssignedGroupArgs', 'DomainsIdentityProviderJitUserProvAssignedGroupArgsDict']]]]] = None,
            jit_user_prov_attribute_update_enabled: Optional[pulumi.Input[bool]] = None,
            jit_user_prov_attributes: Optional[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAttributesArgs', 'DomainsIdentityProviderJitUserProvAttributesArgsDict']]] = None,
            jit_user_prov_create_user_enabled: Optional[pulumi.Input[bool]] = None,
            jit_user_prov_enabled: Optional[pulumi.Input[bool]] = None,
            jit_user_prov_group_assertion_attribute_enabled: Optional[pulumi.Input[bool]] = None,
            jit_user_prov_group_assignment_method: Optional[pulumi.Input[str]] = None,
            jit_user_prov_group_mapping_mode: Optional[pulumi.Input[str]] = None,
            jit_user_prov_group_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvGroupMappingArgs', 'DomainsIdentityProviderJitUserProvGroupMappingArgsDict']]]]] = None,
            jit_user_prov_group_saml_attribute_name: Optional[pulumi.Input[str]] = None,
            jit_user_prov_group_static_list_enabled: Optional[pulumi.Input[bool]] = None,
            jit_user_prov_ignore_error_on_absent_groups: Optional[pulumi.Input[bool]] = None,
            last_notification_sent_time: Optional[pulumi.Input[str]] = None,
            logout_binding: Optional[pulumi.Input[str]] = None,
            logout_enabled: Optional[pulumi.Input[bool]] = None,
            logout_request_url: Optional[pulumi.Input[str]] = None,
            logout_response_url: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[str]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderMetaArgs', 'DomainsIdentityProviderMetaArgsDict']]]]] = None,
            name_id_format: Optional[pulumi.Input[str]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            partner_name: Optional[pulumi.Input[str]] = None,
            partner_provider_id: Optional[pulumi.Input[str]] = None,
            requested_authentication_contexts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            require_force_authn: Optional[pulumi.Input[bool]] = None,
            requires_encrypted_assertion: Optional[pulumi.Input[bool]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            saml_ho_krequired: Optional[pulumi.Input[bool]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            service_instance_identifier: Optional[pulumi.Input[str]] = None,
            shown_on_login_page: Optional[pulumi.Input[bool]] = None,
            signature_hash_algorithm: Optional[pulumi.Input[str]] = None,
            signing_certificate: Optional[pulumi.Input[str]] = None,
            succinct_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderTagArgs', 'DomainsIdentityProviderTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            tenant_provider_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: Optional[pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgsDict']]] = None,
            urnietfparamsscimschemasoracleidcsextensionx509identity_provider: Optional[pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgsDict']]] = None,
            user_mapping_method: Optional[pulumi.Input[str]] = None,
            user_mapping_store_attribute: Optional[pulumi.Input[str]] = None) -> 'DomainsIdentityProvider':
        """
        Get an existing DomainsIdentityProvider resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assertion_attribute: (Updatable) Assertion attribute name.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authn_request_binding: (Updatable) HTTP binding to use for authentication requests.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsIdentityProviderCorrelationPolicyArgs', 'DomainsIdentityProviderCorrelationPolicyArgsDict']] correlation_policy: (Updatable) Correlation policy
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) Description
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] enabled: (Updatable) Set to true to indicate Partner enabled.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] encryption_certificate: (Updatable) Encryption certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * caseExact: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] icon_url: (Updatable) Identity Provider Icon URL.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderIdcsCreatedByArgs', 'DomainsIdentityProviderIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderIdcsLastModifiedByArgs', 'DomainsIdentityProviderIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idp_sso_url: (Updatable) Identity Provider SSO URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] include_signing_cert_in_signature: (Updatable) Set to true to include the signing certificate in the signature.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvAssignedGroupArgs', 'DomainsIdentityProviderJitUserProvAssignedGroupArgsDict']]]] jit_user_prov_assigned_groups: (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_attribute_update_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Union['DomainsIdentityProviderJitUserProvAttributesArgs', 'DomainsIdentityProviderJitUserProvAttributesArgsDict']] jit_user_prov_attributes: (Updatable) Assertion To User Mapping
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCompositeKey: [value]
               * idcsSearchable: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_create_user_enabled: (Updatable) Set to true to indicate JIT User Creation is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_enabled: (Updatable) Set to true to indicate JIT User Provisioning is enabled
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_assertion_attribute_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_assignment_method: (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_mapping_mode: (Updatable) Property to indicate the mode of group mapping
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderJitUserProvGroupMappingArgs', 'DomainsIdentityProviderJitUserProvGroupMappingArgsDict']]]] jit_user_prov_group_mappings: (Updatable) The list of mappings between the Identity Domain Group and the IDP group.
               
               **Added In:** 2205120021
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [idpGroup]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] jit_user_prov_group_saml_attribute_name: (Updatable) Name of the assertion attribute containing the users groups
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_group_static_list_enabled: (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] jit_user_prov_ignore_error_on_absent_groups: (Updatable) Set to true to indicate ignoring absence of group while provisioning
               
               **Added In:** 2111112015
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsAddedSinceVersion: 30
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] last_notification_sent_time: (Updatable) Records the notification timestamp for the IdP whose signing certificate is about to expire
               
               **Added In:** 2302092332
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: dateTime
               * uniqueness: none
        :param pulumi.Input[str] logout_binding: (Updatable) HTTP binding to use for logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] logout_enabled: (Updatable) Set to true to enable logout.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] logout_request_url: (Updatable) Logout request URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] logout_response_url: (Updatable) Logout response URL
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] metadata: (Updatable) Metadata
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderMetaArgs', 'DomainsIdentityProviderMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[str] name_id_format: (Updatable) Default authentication request name ID format.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] partner_name: (Updatable) Unique name of the trusted Identity Provider.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: server
        :param pulumi.Input[str] partner_provider_id: (Updatable) Provider ID
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested_authentication_contexts: (Updatable) SAML SP authentication type.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] require_force_authn: (Updatable) This SP requires requests SAML IdP to enforce re-authentication.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[bool] requires_encrypted_assertion: (Updatable) SAML SP must accept encrypted assertion only.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[bool] saml_ho_krequired: (Updatable) SAML SP HoK Enabled.
               
               **Added In:** 2102181953
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] service_instance_identifier: (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.
               
               **Added In:** 18.2.6
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: never
               * type: string
               * uniqueness: server
        :param pulumi.Input[bool] shown_on_login_page: (Updatable) Set to true to indicate whether to show IdP in login page or not.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] signature_hash_algorithm: (Updatable) Signature hash algorithm.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] signing_certificate: (Updatable) Signing certificate
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] succinct_id: (Updatable) Succinct ID
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: server
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsIdentityProviderTagArgs', 'DomainsIdentityProviderTagArgsDict']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] tenant_provider_id: (Updatable) The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this IdP.
               
               **Added In:** 19.2.1
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] type: (Updatable) Identity Provider Type
               
               **Added In:** 20.1.3
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProviderArgsDict']] urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider: (Updatable) Social Identity Provider Extension Schema
        :param pulumi.Input[Union['DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgs', 'DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProviderArgsDict']] urnietfparamsscimschemasoracleidcsextensionx509identity_provider: (Updatable) X509 Identity Provider Extension Schema
        :param pulumi.Input[str] user_mapping_method: (Updatable) User mapping method.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
        :param pulumi.Input[str] user_mapping_store_attribute: (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.
               
               **Deprecated Since: 20.1.3**
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               * idcsValuePersistedInOtherAttribute: true
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsIdentityProviderState.__new__(_DomainsIdentityProviderState)

        __props__.__dict__["assertion_attribute"] = assertion_attribute
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authn_request_binding"] = authn_request_binding
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["correlation_policy"] = correlation_policy
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["encryption_certificate"] = encryption_certificate
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["icon_url"] = icon_url
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["idp_sso_url"] = idp_sso_url
        __props__.__dict__["include_signing_cert_in_signature"] = include_signing_cert_in_signature
        __props__.__dict__["jit_user_prov_assigned_groups"] = jit_user_prov_assigned_groups
        __props__.__dict__["jit_user_prov_attribute_update_enabled"] = jit_user_prov_attribute_update_enabled
        __props__.__dict__["jit_user_prov_attributes"] = jit_user_prov_attributes
        __props__.__dict__["jit_user_prov_create_user_enabled"] = jit_user_prov_create_user_enabled
        __props__.__dict__["jit_user_prov_enabled"] = jit_user_prov_enabled
        __props__.__dict__["jit_user_prov_group_assertion_attribute_enabled"] = jit_user_prov_group_assertion_attribute_enabled
        __props__.__dict__["jit_user_prov_group_assignment_method"] = jit_user_prov_group_assignment_method
        __props__.__dict__["jit_user_prov_group_mapping_mode"] = jit_user_prov_group_mapping_mode
        __props__.__dict__["jit_user_prov_group_mappings"] = jit_user_prov_group_mappings
        __props__.__dict__["jit_user_prov_group_saml_attribute_name"] = jit_user_prov_group_saml_attribute_name
        __props__.__dict__["jit_user_prov_group_static_list_enabled"] = jit_user_prov_group_static_list_enabled
        __props__.__dict__["jit_user_prov_ignore_error_on_absent_groups"] = jit_user_prov_ignore_error_on_absent_groups
        __props__.__dict__["last_notification_sent_time"] = last_notification_sent_time
        __props__.__dict__["logout_binding"] = logout_binding
        __props__.__dict__["logout_enabled"] = logout_enabled
        __props__.__dict__["logout_request_url"] = logout_request_url
        __props__.__dict__["logout_response_url"] = logout_response_url
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name_id_format"] = name_id_format
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["partner_name"] = partner_name
        __props__.__dict__["partner_provider_id"] = partner_provider_id
        __props__.__dict__["requested_authentication_contexts"] = requested_authentication_contexts
        __props__.__dict__["require_force_authn"] = require_force_authn
        __props__.__dict__["requires_encrypted_assertion"] = requires_encrypted_assertion
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["saml_ho_krequired"] = saml_ho_krequired
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["service_instance_identifier"] = service_instance_identifier
        __props__.__dict__["shown_on_login_page"] = shown_on_login_page
        __props__.__dict__["signature_hash_algorithm"] = signature_hash_algorithm
        __props__.__dict__["signing_certificate"] = signing_certificate
        __props__.__dict__["succinct_id"] = succinct_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["tenant_provider_id"] = tenant_provider_id
        __props__.__dict__["type"] = type
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider"] = urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionx509identity_provider"] = urnietfparamsscimschemasoracleidcsextensionx509identity_provider
        __props__.__dict__["user_mapping_method"] = user_mapping_method
        __props__.__dict__["user_mapping_store_attribute"] = user_mapping_store_attribute
        return DomainsIdentityProvider(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assertionAttribute")
    def assertion_attribute(self) -> pulumi.Output[str]:
        """
        (Updatable) Assertion attribute name.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true
        """
        return pulumi.get(self, "assertion_attribute")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="authnRequestBinding")
    def authn_request_binding(self) -> pulumi.Output[str]:
        """
        (Updatable) HTTP binding to use for authentication requests.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "authn_request_binding")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="correlationPolicy")
    def correlation_policy(self) -> pulumi.Output['outputs.DomainsIdentityProviderCorrelationPolicy']:
        """
        (Updatable) Correlation policy

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "correlation_policy")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate Partner enabled.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="encryptionCertificate")
    def encryption_certificate(self) -> pulumi.Output[str]:
        """
        (Updatable) Encryption certificate

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "encryption_certificate")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * caseExact: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="iconUrl")
    def icon_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Identity Provider Icon URL.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "icon_url")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityProviderIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityProviderIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="idpSsoUrl")
    def idp_sso_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Identity Provider SSO URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idp_sso_url")

    @property
    @pulumi.getter(name="includeSigningCertInSignature")
    def include_signing_cert_in_signature(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to include the signing certificate in the signature.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "include_signing_cert_in_signature")

    @property
    @pulumi.getter(name="jitUserProvAssignedGroups")
    def jit_user_prov_assigned_groups(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityProviderJitUserProvAssignedGroup']]:
        """
        (Updatable) Refers to every group of which a JIT-provisioned User should be a member.  Just-in-Time user-provisioning applies this static list when jitUserProvGroupStaticListEnabled:true.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_assigned_groups")

    @property
    @pulumi.getter(name="jitUserProvAttributeUpdateEnabled")
    def jit_user_prov_attribute_update_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate JIT User Creation is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_attribute_update_enabled")

    @property
    @pulumi.getter(name="jitUserProvAttributes")
    def jit_user_prov_attributes(self) -> pulumi.Output['outputs.DomainsIdentityProviderJitUserProvAttributes']:
        """
        (Updatable) Assertion To User Mapping

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCompositeKey: [value]
        * idcsSearchable: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_attributes")

    @property
    @pulumi.getter(name="jitUserProvCreateUserEnabled")
    def jit_user_prov_create_user_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate JIT User Creation is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_create_user_enabled")

    @property
    @pulumi.getter(name="jitUserProvEnabled")
    def jit_user_prov_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning is enabled

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_enabled")

    @property
    @pulumi.getter(name="jitUserProvGroupAssertionAttributeEnabled")
    def jit_user_prov_group_assertion_attribute_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned based on assertion attribute

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_assertion_attribute_enabled")

    @property
    @pulumi.getter(name="jitUserProvGroupAssignmentMethod")
    def jit_user_prov_group_assignment_method(self) -> pulumi.Output[str]:
        """
        (Updatable) The default value is 'Overwrite', which tells Just-In-Time user-provisioning to replace any current group-assignments for a User with those assigned by assertions and/or those assigned statically. Specify 'Merge' if you want Just-In-Time user-provisioning to combine its group-assignments with those the user already has.

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_assignment_method")

    @property
    @pulumi.getter(name="jitUserProvGroupMappingMode")
    def jit_user_prov_group_mapping_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) Property to indicate the mode of group mapping

        **Added In:** 2205120021

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_mapping_mode")

    @property
    @pulumi.getter(name="jitUserProvGroupMappings")
    def jit_user_prov_group_mappings(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityProviderJitUserProvGroupMapping']]:
        """
        (Updatable) The list of mappings between the Identity Domain Group and the IDP group.

        **Added In:** 2205120021

        **SCIM++ Properties:**
        * idcsCompositeKey: [idpGroup]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_mappings")

    @property
    @pulumi.getter(name="jitUserProvGroupSamlAttributeName")
    def jit_user_prov_group_saml_attribute_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the assertion attribute containing the users groups

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_saml_attribute_name")

    @property
    @pulumi.getter(name="jitUserProvGroupStaticListEnabled")
    def jit_user_prov_group_static_list_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate JIT User Provisioning Groups should be assigned from a static list

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_group_static_list_enabled")

    @property
    @pulumi.getter(name="jitUserProvIgnoreErrorOnAbsentGroups")
    def jit_user_prov_ignore_error_on_absent_groups(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate ignoring absence of group while provisioning

        **Added In:** 2111112015

        **SCIM++ Properties:**
        * caseExact: false
        * idcsAddedSinceVersion: 30
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "jit_user_prov_ignore_error_on_absent_groups")

    @property
    @pulumi.getter(name="lastNotificationSentTime")
    def last_notification_sent_time(self) -> pulumi.Output[str]:
        """
        (Updatable) Records the notification timestamp for the IdP whose signing certificate is about to expire

        **Added In:** 2302092332

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: dateTime
        * uniqueness: none
        """
        return pulumi.get(self, "last_notification_sent_time")

    @property
    @pulumi.getter(name="logoutBinding")
    def logout_binding(self) -> pulumi.Output[str]:
        """
        (Updatable) HTTP binding to use for logout.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_binding")

    @property
    @pulumi.getter(name="logoutEnabled")
    def logout_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to enable logout.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "logout_enabled")

    @property
    @pulumi.getter(name="logoutRequestUrl")
    def logout_request_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Logout request URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_request_url")

    @property
    @pulumi.getter(name="logoutResponseUrl")
    def logout_response_url(self) -> pulumi.Output[str]:
        """
        (Updatable) Logout response URL

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "logout_response_url")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[str]:
        """
        (Updatable) Metadata

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityProviderMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> pulumi.Output[str]:
        """
        (Updatable) Default authentication request name ID format.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name_id_format")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="partnerName")
    def partner_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Unique name of the trusted Identity Provider.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "partner_name")

    @property
    @pulumi.getter(name="partnerProviderId")
    def partner_provider_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Provider ID

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "partner_provider_id")

    @property
    @pulumi.getter(name="requestedAuthenticationContexts")
    def requested_authentication_contexts(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) SAML SP authentication type.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "requested_authentication_contexts")

    @property
    @pulumi.getter(name="requireForceAuthn")
    def require_force_authn(self) -> pulumi.Output[bool]:
        """
        (Updatable) This SP requires requests SAML IdP to enforce re-authentication.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "require_force_authn")

    @property
    @pulumi.getter(name="requiresEncryptedAssertion")
    def requires_encrypted_assertion(self) -> pulumi.Output[bool]:
        """
        (Updatable) SAML SP must accept encrypted assertion only.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "requires_encrypted_assertion")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter(name="samlHoKrequired")
    def saml_ho_krequired(self) -> pulumi.Output[bool]:
        """
        (Updatable) SAML SP HoK Enabled.

        **Added In:** 2102181953

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "saml_ho_krequired")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="serviceInstanceIdentifier")
    def service_instance_identifier(self) -> pulumi.Output[str]:
        """
        (Updatable) The serviceInstanceIdentifier of the App that hosts this IdP. This value will match the opcServiceInstanceGUID of any service-instance that the IdP represents.

        **Added In:** 18.2.6

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: never
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "service_instance_identifier")

    @property
    @pulumi.getter(name="shownOnLoginPage")
    def shown_on_login_page(self) -> pulumi.Output[bool]:
        """
        (Updatable) Set to true to indicate whether to show IdP in login page or not.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "shown_on_login_page")

    @property
    @pulumi.getter(name="signatureHashAlgorithm")
    def signature_hash_algorithm(self) -> pulumi.Output[str]:
        """
        (Updatable) Signature hash algorithm.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "signature_hash_algorithm")

    @property
    @pulumi.getter(name="signingCertificate")
    def signing_certificate(self) -> pulumi.Output[str]:
        """
        (Updatable) Signing certificate

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "signing_certificate")

    @property
    @pulumi.getter(name="succinctId")
    def succinct_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Succinct ID

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: server
        """
        return pulumi.get(self, "succinct_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsIdentityProviderTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter(name="tenantProviderId")
    def tenant_provider_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The alternate Provider ID to be used as the Oracle Identity Cloud Service providerID (instead of the one in SamlSettings) when interacting with this IdP.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenant_provider_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) Identity Provider Type

        **Added In:** 20.1.3

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsocialIdentityProvider")
    def urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider(self) -> pulumi.Output['outputs.DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionsocialIdentityProvider']:
        """
        (Updatable) Social Identity Provider Extension Schema
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsocial_identity_provider")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionx509identityProvider")
    def urnietfparamsscimschemasoracleidcsextensionx509identity_provider(self) -> pulumi.Output['outputs.DomainsIdentityProviderUrnietfparamsscimschemasoracleidcsextensionx509identityProvider']:
        """
        (Updatable) X509 Identity Provider Extension Schema
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionx509identity_provider")

    @property
    @pulumi.getter(name="userMappingMethod")
    def user_mapping_method(self) -> pulumi.Output[str]:
        """
        (Updatable) User mapping method.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true
        """
        return pulumi.get(self, "user_mapping_method")

    @property
    @pulumi.getter(name="userMappingStoreAttribute")
    def user_mapping_store_attribute(self) -> pulumi.Output[str]:
        """
        (Updatable) This property specifies the userstore attribute value that must match the incoming assertion attribute value or the incoming nameid attribute value in order to identify the user during SSO.<br>You can construct the userMappingStoreAttribute value by specifying attributes from the Oracle Identity Cloud Service Core Users schema. For examples of how to construct the userMappingStoreAttribute value, see the <b>Example of a Request Body</b> section of the Examples tab for the <a href='./op-admin-v1-identityproviders-post.html'>POST</a> and <a href='./op-admin-v1-identityproviders-id-put.html'>PUT</a> methods of the /IdentityProviders endpoint.

        **Deprecated Since: 20.1.3**

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        * idcsValuePersistedInOtherAttribute: true


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_mapping_store_attribute")

