# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDomainsIdentityPropagationTrustResult',
    'AwaitableGetDomainsIdentityPropagationTrustResult',
    'get_domains_identity_propagation_trust',
    'get_domains_identity_propagation_trust_output',
]

@pulumi.output_type
class GetDomainsIdentityPropagationTrustResult:
    """
    A collection of values returned by getDomainsIdentityPropagationTrust.
    """
    def __init__(__self__, account_id=None, active=None, allow_impersonation=None, attribute_sets=None, attributes=None, authorization=None, client_claim_name=None, client_claim_values=None, clock_skew_seconds=None, compartment_ocid=None, delete_in_progress=None, description=None, domain_ocid=None, id=None, idcs_created_bies=None, idcs_endpoint=None, idcs_last_modified_bies=None, idcs_last_upgraded_in_release=None, idcs_prevented_operations=None, identity_propagation_trust_id=None, impersonation_service_users=None, issuer=None, keytabs=None, metas=None, name=None, oauth_clients=None, ocid=None, public_certificate=None, public_key_endpoint=None, resource_type_schema_version=None, schemas=None, subject_claim_name=None, subject_mapping_attribute=None, subject_type=None, tags=None, tenancy_ocid=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if active and not isinstance(active, bool):
            raise TypeError("Expected argument 'active' to be a bool")
        pulumi.set(__self__, "active", active)
        if allow_impersonation and not isinstance(allow_impersonation, bool):
            raise TypeError("Expected argument 'allow_impersonation' to be a bool")
        pulumi.set(__self__, "allow_impersonation", allow_impersonation)
        if attribute_sets and not isinstance(attribute_sets, list):
            raise TypeError("Expected argument 'attribute_sets' to be a list")
        pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes and not isinstance(attributes, str):
            raise TypeError("Expected argument 'attributes' to be a str")
        pulumi.set(__self__, "attributes", attributes)
        if authorization and not isinstance(authorization, str):
            raise TypeError("Expected argument 'authorization' to be a str")
        pulumi.set(__self__, "authorization", authorization)
        if client_claim_name and not isinstance(client_claim_name, str):
            raise TypeError("Expected argument 'client_claim_name' to be a str")
        pulumi.set(__self__, "client_claim_name", client_claim_name)
        if client_claim_values and not isinstance(client_claim_values, list):
            raise TypeError("Expected argument 'client_claim_values' to be a list")
        pulumi.set(__self__, "client_claim_values", client_claim_values)
        if clock_skew_seconds and not isinstance(clock_skew_seconds, int):
            raise TypeError("Expected argument 'clock_skew_seconds' to be a int")
        pulumi.set(__self__, "clock_skew_seconds", clock_skew_seconds)
        if compartment_ocid and not isinstance(compartment_ocid, str):
            raise TypeError("Expected argument 'compartment_ocid' to be a str")
        pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress and not isinstance(delete_in_progress, bool):
            raise TypeError("Expected argument 'delete_in_progress' to be a bool")
        pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_ocid and not isinstance(domain_ocid, str):
            raise TypeError("Expected argument 'domain_ocid' to be a str")
        pulumi.set(__self__, "domain_ocid", domain_ocid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idcs_created_bies and not isinstance(idcs_created_bies, list):
            raise TypeError("Expected argument 'idcs_created_bies' to be a list")
        pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint and not isinstance(idcs_endpoint, str):
            raise TypeError("Expected argument 'idcs_endpoint' to be a str")
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies and not isinstance(idcs_last_modified_bies, list):
            raise TypeError("Expected argument 'idcs_last_modified_bies' to be a list")
        pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release and not isinstance(idcs_last_upgraded_in_release, str):
            raise TypeError("Expected argument 'idcs_last_upgraded_in_release' to be a str")
        pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations and not isinstance(idcs_prevented_operations, list):
            raise TypeError("Expected argument 'idcs_prevented_operations' to be a list")
        pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if identity_propagation_trust_id and not isinstance(identity_propagation_trust_id, str):
            raise TypeError("Expected argument 'identity_propagation_trust_id' to be a str")
        pulumi.set(__self__, "identity_propagation_trust_id", identity_propagation_trust_id)
        if impersonation_service_users and not isinstance(impersonation_service_users, list):
            raise TypeError("Expected argument 'impersonation_service_users' to be a list")
        pulumi.set(__self__, "impersonation_service_users", impersonation_service_users)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if keytabs and not isinstance(keytabs, list):
            raise TypeError("Expected argument 'keytabs' to be a list")
        pulumi.set(__self__, "keytabs", keytabs)
        if metas and not isinstance(metas, list):
            raise TypeError("Expected argument 'metas' to be a list")
        pulumi.set(__self__, "metas", metas)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if oauth_clients and not isinstance(oauth_clients, list):
            raise TypeError("Expected argument 'oauth_clients' to be a list")
        pulumi.set(__self__, "oauth_clients", oauth_clients)
        if ocid and not isinstance(ocid, str):
            raise TypeError("Expected argument 'ocid' to be a str")
        pulumi.set(__self__, "ocid", ocid)
        if public_certificate and not isinstance(public_certificate, str):
            raise TypeError("Expected argument 'public_certificate' to be a str")
        pulumi.set(__self__, "public_certificate", public_certificate)
        if public_key_endpoint and not isinstance(public_key_endpoint, str):
            raise TypeError("Expected argument 'public_key_endpoint' to be a str")
        pulumi.set(__self__, "public_key_endpoint", public_key_endpoint)
        if resource_type_schema_version and not isinstance(resource_type_schema_version, str):
            raise TypeError("Expected argument 'resource_type_schema_version' to be a str")
        pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas and not isinstance(schemas, list):
            raise TypeError("Expected argument 'schemas' to be a list")
        pulumi.set(__self__, "schemas", schemas)
        if subject_claim_name and not isinstance(subject_claim_name, str):
            raise TypeError("Expected argument 'subject_claim_name' to be a str")
        pulumi.set(__self__, "subject_claim_name", subject_claim_name)
        if subject_mapping_attribute and not isinstance(subject_mapping_attribute, str):
            raise TypeError("Expected argument 'subject_mapping_attribute' to be a str")
        pulumi.set(__self__, "subject_mapping_attribute", subject_mapping_attribute)
        if subject_type and not isinstance(subject_type, str):
            raise TypeError("Expected argument 'subject_type' to be a str")
        pulumi.set(__self__, "subject_type", subject_type)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tenancy_ocid and not isinstance(tenancy_ocid, str):
            raise TypeError("Expected argument 'tenancy_ocid' to be a str")
        pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The Identity cloud provider service identifier, for example, the Azure Tenancy ID, AWS Account ID, or GCP Project ID.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def active(self) -> bool:
        """
        If true, specifies that this Identity Propagation Trust is in an enabled state. The default value is false.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="allowImpersonation")
    def allow_impersonation(self) -> bool:
        """
        Allow customers to define whether the resulting token should contain the authenticated user as the subject or whether the token should impersonate another Application Principal in IAM.
        """
        return pulumi.get(self, "allow_impersonation")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[str]:
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> Optional[str]:
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="clientClaimName")
    def client_claim_name(self) -> str:
        """
        The claim name that identifies to whom the JWT/SAML token is issued. If AWS, then \\"aud\\" or \\"client_id\\". If Azure, then \\"appid\\". If GCP, then \\"aud\\".
        """
        return pulumi.get(self, "client_claim_name")

    @property
    @pulumi.getter(name="clientClaimValues")
    def client_claim_values(self) -> Sequence[str]:
        """
        The value that corresponds to the client claim name used to identify to whom the token is issued.
        """
        return pulumi.get(self, "client_claim_values")

    @property
    @pulumi.getter(name="clockSkewSeconds")
    def clock_skew_seconds(self) -> int:
        """
        The clock skew (in secs) that's allowed for the token issue and expiry time.
        """
        return pulumi.get(self, "clock_skew_seconds")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> str:
        """
        Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> bool:
        """
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the Identity Propagation Trust.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> str:
        """
        Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Sequence['outputs.GetDomainsIdentityPropagationTrustIdcsCreatedByResult']:
        """
        The User or App who created the Resource
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> str:
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Sequence['outputs.GetDomainsIdentityPropagationTrustIdcsLastModifiedByResult']:
        """
        The User or App who modified the Resource
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> str:
        """
        The release number when the resource was upgraded.
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Sequence[str]:
        """
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="identityPropagationTrustId")
    def identity_propagation_trust_id(self) -> str:
        return pulumi.get(self, "identity_propagation_trust_id")

    @property
    @pulumi.getter(name="impersonationServiceUsers")
    def impersonation_service_users(self) -> Sequence['outputs.GetDomainsIdentityPropagationTrustImpersonationServiceUserResult']:
        """
        The Impersonating Principal.
        """
        return pulumi.get(self, "impersonation_service_users")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The issuer claim of the Identity provider.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def keytabs(self) -> Sequence['outputs.GetDomainsIdentityPropagationTrustKeytabResult']:
        """
        The keytab stored in the tenancy's Vault. This is required if the identity propagation type is 'SPNEGO'.
        """
        return pulumi.get(self, "keytabs")

    @property
    @pulumi.getter
    def metas(self) -> Sequence['outputs.GetDomainsIdentityPropagationTrustMetaResult']:
        """
        A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the the Identity Propagation Trust.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oauthClients")
    def oauth_clients(self) -> Sequence[str]:
        """
        The value of all the authorized OAuth Clients.
        """
        return pulumi.get(self, "oauth_clients")

    @property
    @pulumi.getter
    def ocid(self) -> str:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="publicCertificate")
    def public_certificate(self) -> str:
        """
        Store the public key if public key cert.
        """
        return pulumi.get(self, "public_certificate")

    @property
    @pulumi.getter(name="publicKeyEndpoint")
    def public_key_endpoint(self) -> str:
        """
        The cloud provider's public key API of SAML and OIDC providers for signature validation.
        """
        return pulumi.get(self, "public_key_endpoint")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[str]:
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence[str]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="subjectClaimName")
    def subject_claim_name(self) -> str:
        """
        Used for locating the subject claim from the incoming token.
        """
        return pulumi.get(self, "subject_claim_name")

    @property
    @pulumi.getter(name="subjectMappingAttribute")
    def subject_mapping_attribute(self) -> str:
        """
        Subject Mapping Attribute to which the value from subject claim name value would be used for identity lookup.
        """
        return pulumi.get(self, "subject_mapping_attribute")

    @property
    @pulumi.getter(name="subjectType")
    def subject_type(self) -> str:
        """
        The type of the resource against which lookup will be made in the identity domain in IAM for the incoming subject claim value.
        """
        return pulumi.get(self, "subject_type")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetDomainsIdentityPropagationTrustTagResult']:
        """
        A list of tags on this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> str:
        """
        Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the inbound token from the Identity cloud provider.
        """
        return pulumi.get(self, "type")


class AwaitableGetDomainsIdentityPropagationTrustResult(GetDomainsIdentityPropagationTrustResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainsIdentityPropagationTrustResult(
            account_id=self.account_id,
            active=self.active,
            allow_impersonation=self.allow_impersonation,
            attribute_sets=self.attribute_sets,
            attributes=self.attributes,
            authorization=self.authorization,
            client_claim_name=self.client_claim_name,
            client_claim_values=self.client_claim_values,
            clock_skew_seconds=self.clock_skew_seconds,
            compartment_ocid=self.compartment_ocid,
            delete_in_progress=self.delete_in_progress,
            description=self.description,
            domain_ocid=self.domain_ocid,
            id=self.id,
            idcs_created_bies=self.idcs_created_bies,
            idcs_endpoint=self.idcs_endpoint,
            idcs_last_modified_bies=self.idcs_last_modified_bies,
            idcs_last_upgraded_in_release=self.idcs_last_upgraded_in_release,
            idcs_prevented_operations=self.idcs_prevented_operations,
            identity_propagation_trust_id=self.identity_propagation_trust_id,
            impersonation_service_users=self.impersonation_service_users,
            issuer=self.issuer,
            keytabs=self.keytabs,
            metas=self.metas,
            name=self.name,
            oauth_clients=self.oauth_clients,
            ocid=self.ocid,
            public_certificate=self.public_certificate,
            public_key_endpoint=self.public_key_endpoint,
            resource_type_schema_version=self.resource_type_schema_version,
            schemas=self.schemas,
            subject_claim_name=self.subject_claim_name,
            subject_mapping_attribute=self.subject_mapping_attribute,
            subject_type=self.subject_type,
            tags=self.tags,
            tenancy_ocid=self.tenancy_ocid,
            type=self.type)


def get_domains_identity_propagation_trust(attribute_sets: Optional[Sequence[str]] = None,
                                           attributes: Optional[str] = None,
                                           authorization: Optional[str] = None,
                                           idcs_endpoint: Optional[str] = None,
                                           identity_propagation_trust_id: Optional[str] = None,
                                           resource_type_schema_version: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainsIdentityPropagationTrustResult:
    """
    This data source provides details about a specific Identity Propagation Trust resource in Oracle Cloud Infrastructure Identity Domains service.

    Get an existing Identity Propagation Trust configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_identity_propagation_trust = oci.Identity.get_domains_identity_propagation_trust(idcs_endpoint=test_domain["url"],
        identity_propagation_trust_id=test_identity_propagation_trust_oci_identity_domains_identity_propagation_trust["id"],
        attribute_sets=["all"],
        attributes="",
        authorization=identity_propagation_trust_authorization,
        resource_type_schema_version=identity_propagation_trust_resource_type_schema_version)
    ```


    :param Sequence[str] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
    :param str attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
    :param str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param str idcs_endpoint: The basic endpoint for the identity domain
    :param str identity_propagation_trust_id: ID of the resource
    :param str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    __args__ = dict()
    __args__['attributeSets'] = attribute_sets
    __args__['attributes'] = attributes
    __args__['authorization'] = authorization
    __args__['idcsEndpoint'] = idcs_endpoint
    __args__['identityPropagationTrustId'] = identity_propagation_trust_id
    __args__['resourceTypeSchemaVersion'] = resource_type_schema_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getDomainsIdentityPropagationTrust:getDomainsIdentityPropagationTrust', __args__, opts=opts, typ=GetDomainsIdentityPropagationTrustResult).value

    return AwaitableGetDomainsIdentityPropagationTrustResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        active=pulumi.get(__ret__, 'active'),
        allow_impersonation=pulumi.get(__ret__, 'allow_impersonation'),
        attribute_sets=pulumi.get(__ret__, 'attribute_sets'),
        attributes=pulumi.get(__ret__, 'attributes'),
        authorization=pulumi.get(__ret__, 'authorization'),
        client_claim_name=pulumi.get(__ret__, 'client_claim_name'),
        client_claim_values=pulumi.get(__ret__, 'client_claim_values'),
        clock_skew_seconds=pulumi.get(__ret__, 'clock_skew_seconds'),
        compartment_ocid=pulumi.get(__ret__, 'compartment_ocid'),
        delete_in_progress=pulumi.get(__ret__, 'delete_in_progress'),
        description=pulumi.get(__ret__, 'description'),
        domain_ocid=pulumi.get(__ret__, 'domain_ocid'),
        id=pulumi.get(__ret__, 'id'),
        idcs_created_bies=pulumi.get(__ret__, 'idcs_created_bies'),
        idcs_endpoint=pulumi.get(__ret__, 'idcs_endpoint'),
        idcs_last_modified_bies=pulumi.get(__ret__, 'idcs_last_modified_bies'),
        idcs_last_upgraded_in_release=pulumi.get(__ret__, 'idcs_last_upgraded_in_release'),
        idcs_prevented_operations=pulumi.get(__ret__, 'idcs_prevented_operations'),
        identity_propagation_trust_id=pulumi.get(__ret__, 'identity_propagation_trust_id'),
        impersonation_service_users=pulumi.get(__ret__, 'impersonation_service_users'),
        issuer=pulumi.get(__ret__, 'issuer'),
        keytabs=pulumi.get(__ret__, 'keytabs'),
        metas=pulumi.get(__ret__, 'metas'),
        name=pulumi.get(__ret__, 'name'),
        oauth_clients=pulumi.get(__ret__, 'oauth_clients'),
        ocid=pulumi.get(__ret__, 'ocid'),
        public_certificate=pulumi.get(__ret__, 'public_certificate'),
        public_key_endpoint=pulumi.get(__ret__, 'public_key_endpoint'),
        resource_type_schema_version=pulumi.get(__ret__, 'resource_type_schema_version'),
        schemas=pulumi.get(__ret__, 'schemas'),
        subject_claim_name=pulumi.get(__ret__, 'subject_claim_name'),
        subject_mapping_attribute=pulumi.get(__ret__, 'subject_mapping_attribute'),
        subject_type=pulumi.get(__ret__, 'subject_type'),
        tags=pulumi.get(__ret__, 'tags'),
        tenancy_ocid=pulumi.get(__ret__, 'tenancy_ocid'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_domains_identity_propagation_trust)
def get_domains_identity_propagation_trust_output(attribute_sets: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                  attributes: Optional[pulumi.Input[Optional[str]]] = None,
                                                  authorization: Optional[pulumi.Input[Optional[str]]] = None,
                                                  idcs_endpoint: Optional[pulumi.Input[str]] = None,
                                                  identity_propagation_trust_id: Optional[pulumi.Input[str]] = None,
                                                  resource_type_schema_version: Optional[pulumi.Input[Optional[str]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDomainsIdentityPropagationTrustResult]:
    """
    This data source provides details about a specific Identity Propagation Trust resource in Oracle Cloud Infrastructure Identity Domains service.

    Get an existing Identity Propagation Trust configuration.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_identity_propagation_trust = oci.Identity.get_domains_identity_propagation_trust(idcs_endpoint=test_domain["url"],
        identity_propagation_trust_id=test_identity_propagation_trust_oci_identity_domains_identity_propagation_trust["id"],
        attribute_sets=["all"],
        attributes="",
        authorization=identity_propagation_trust_authorization,
        resource_type_schema_version=identity_propagation_trust_resource_type_schema_version)
    ```


    :param Sequence[str] attribute_sets: A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
    :param str attributes: A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
    :param str authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
    :param str idcs_endpoint: The basic endpoint for the identity domain
    :param str identity_propagation_trust_id: ID of the resource
    :param str resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
    """
    ...
