# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServiceEnvironmentsResult',
    'AwaitableGetServiceEnvironmentsResult',
    'get_service_environments',
    'get_service_environments_output',
]

@pulumi.output_type
class GetServiceEnvironmentsResult:
    """
    A collection of values returned by getServiceEnvironments.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, service_environment_collections=None, service_environment_id=None, service_environment_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_environment_collections and not isinstance(service_environment_collections, list):
            raise TypeError("Expected argument 'service_environment_collections' to be a list")
        pulumi.set(__self__, "service_environment_collections", service_environment_collections)
        if service_environment_id and not isinstance(service_environment_id, str):
            raise TypeError("Expected argument 'service_environment_id' to be a str")
        pulumi.set(__self__, "service_environment_id", service_environment_id)
        if service_environment_type and not isinstance(service_environment_type, str):
            raise TypeError("Expected argument 'service_environment_type' to be a str")
        pulumi.set(__self__, "service_environment_type", service_environment_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Display name of the service. For example, "Oracle Retail Order Management Cloud Service".
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetServiceEnvironmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceEnvironmentCollections")
    def service_environment_collections(self) -> Sequence['outputs.GetServiceEnvironmentsServiceEnvironmentCollectionResult']:
        """
        The list of service_environment_collection.
        """
        return pulumi.get(self, "service_environment_collections")

    @property
    @pulumi.getter(name="serviceEnvironmentId")
    def service_environment_id(self) -> Optional[str]:
        return pulumi.get(self, "service_environment_id")

    @property
    @pulumi.getter(name="serviceEnvironmentType")
    def service_environment_type(self) -> Optional[str]:
        return pulumi.get(self, "service_environment_type")


class AwaitableGetServiceEnvironmentsResult(GetServiceEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceEnvironmentsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            service_environment_collections=self.service_environment_collections,
            service_environment_id=self.service_environment_id,
            service_environment_type=self.service_environment_type)


def get_service_environments(compartment_id: Optional[str] = None,
                             display_name: Optional[str] = None,
                             filters: Optional[Sequence[Union['GetServiceEnvironmentsFilterArgs', 'GetServiceEnvironmentsFilterArgsDict']]] = None,
                             service_environment_id: Optional[str] = None,
                             service_environment_type: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceEnvironmentsResult:
    """
    This data source provides the list of Service Environments in Oracle Cloud Infrastructure Service Manager Proxy service.

    List the details of Software as a Service (SaaS) environments provisioned by Service Manager.
    Information includes the service instance endpoints and service definition details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_environments = oci.ServiceManagerProxy.get_service_environments(compartment_id=compartment_id,
        display_name=service_environment_display_name,
        service_environment_id=test_service_environment["id"],
        service_environment_type=service_environment_service_environment_type)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment.
    :param str display_name: The display name of the resource.
    :param str service_environment_id: The unique identifier associated with the service environment. 
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str service_environment_type: The environment's service definition type.  For example, "RGBUOROMS" is the service definition type for "Oracle Retail Order Management Cloud Service".
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['serviceEnvironmentId'] = service_environment_id
    __args__['serviceEnvironmentType'] = service_environment_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceManagerProxy/getServiceEnvironments:getServiceEnvironments', __args__, opts=opts, typ=GetServiceEnvironmentsResult).value

    return AwaitableGetServiceEnvironmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        service_environment_collections=pulumi.get(__ret__, 'service_environment_collections'),
        service_environment_id=pulumi.get(__ret__, 'service_environment_id'),
        service_environment_type=pulumi.get(__ret__, 'service_environment_type'))


@_utilities.lift_output_func(get_service_environments)
def get_service_environments_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetServiceEnvironmentsFilterArgs', 'GetServiceEnvironmentsFilterArgsDict']]]]] = None,
                                    service_environment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    service_environment_type: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceEnvironmentsResult]:
    """
    This data source provides the list of Service Environments in Oracle Cloud Infrastructure Service Manager Proxy service.

    List the details of Software as a Service (SaaS) environments provisioned by Service Manager.
    Information includes the service instance endpoints and service definition details.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_environments = oci.ServiceManagerProxy.get_service_environments(compartment_id=compartment_id,
        display_name=service_environment_display_name,
        service_environment_id=test_service_environment["id"],
        service_environment_type=service_environment_service_environment_type)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the compartment.
    :param str display_name: The display name of the resource.
    :param str service_environment_id: The unique identifier associated with the service environment. 
           
           **Note:** Not an [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str service_environment_type: The environment's service definition type.  For example, "RGBUOROMS" is the service definition type for "Oracle Retail Order Management Cloud Service".
    """
    ...
