# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDatabaseResult',
    'AwaitableGetDatabaseResult',
    'get_database',
    'get_database_output',
]

@pulumi.output_type
class GetDatabaseResult:
    """
    A collection of values returned by getDatabase.
    """
    def __init__(__self__, character_set=None, compartment_id=None, connection_strings=None, database_id=None, database_management_configs=None, database_software_image_id=None, databases=None, db_backup_configs=None, db_home_id=None, db_name=None, db_system_id=None, db_unique_name=None, db_version=None, db_workload=None, defined_tags=None, freeform_tags=None, id=None, is_cdb=None, key_store_id=None, key_store_wallet_name=None, kms_key_id=None, kms_key_migration=None, kms_key_rotation=None, kms_key_version_id=None, last_backup_duration_in_seconds=None, last_backup_timestamp=None, last_failed_backup_timestamp=None, lifecycle_details=None, ncharacter_set=None, pdb_name=None, sid_prefix=None, source=None, source_database_point_in_time_recovery_timestamp=None, state=None, time_created=None, vault_id=None, vm_cluster_id=None):
        if character_set and not isinstance(character_set, str):
            raise TypeError("Expected argument 'character_set' to be a str")
        pulumi.set(__self__, "character_set", character_set)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_strings and not isinstance(connection_strings, list):
            raise TypeError("Expected argument 'connection_strings' to be a list")
        pulumi.set(__self__, "connection_strings", connection_strings)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_management_configs and not isinstance(database_management_configs, list):
            raise TypeError("Expected argument 'database_management_configs' to be a list")
        pulumi.set(__self__, "database_management_configs", database_management_configs)
        if database_software_image_id and not isinstance(database_software_image_id, str):
            raise TypeError("Expected argument 'database_software_image_id' to be a str")
        pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if databases and not isinstance(databases, list):
            raise TypeError("Expected argument 'databases' to be a list")
        pulumi.set(__self__, "databases", databases)
        if db_backup_configs and not isinstance(db_backup_configs, list):
            raise TypeError("Expected argument 'db_backup_configs' to be a list")
        pulumi.set(__self__, "db_backup_configs", db_backup_configs)
        if db_home_id and not isinstance(db_home_id, str):
            raise TypeError("Expected argument 'db_home_id' to be a str")
        pulumi.set(__self__, "db_home_id", db_home_id)
        if db_name and not isinstance(db_name, str):
            raise TypeError("Expected argument 'db_name' to be a str")
        pulumi.set(__self__, "db_name", db_name)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if db_unique_name and not isinstance(db_unique_name, str):
            raise TypeError("Expected argument 'db_unique_name' to be a str")
        pulumi.set(__self__, "db_unique_name", db_unique_name)
        if db_version and not isinstance(db_version, str):
            raise TypeError("Expected argument 'db_version' to be a str")
        pulumi.set(__self__, "db_version", db_version)
        if db_workload and not isinstance(db_workload, str):
            raise TypeError("Expected argument 'db_workload' to be a str")
        pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_cdb and not isinstance(is_cdb, bool):
            raise TypeError("Expected argument 'is_cdb' to be a bool")
        pulumi.set(__self__, "is_cdb", is_cdb)
        if key_store_id and not isinstance(key_store_id, str):
            raise TypeError("Expected argument 'key_store_id' to be a str")
        pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_wallet_name and not isinstance(key_store_wallet_name, str):
            raise TypeError("Expected argument 'key_store_wallet_name' to be a str")
        pulumi.set(__self__, "key_store_wallet_name", key_store_wallet_name)
        if kms_key_id and not isinstance(kms_key_id, str):
            raise TypeError("Expected argument 'kms_key_id' to be a str")
        pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_migration and not isinstance(kms_key_migration, bool):
            raise TypeError("Expected argument 'kms_key_migration' to be a bool")
        pulumi.set(__self__, "kms_key_migration", kms_key_migration)
        if kms_key_rotation and not isinstance(kms_key_rotation, int):
            raise TypeError("Expected argument 'kms_key_rotation' to be a int")
        pulumi.set(__self__, "kms_key_rotation", kms_key_rotation)
        if kms_key_version_id and not isinstance(kms_key_version_id, str):
            raise TypeError("Expected argument 'kms_key_version_id' to be a str")
        pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if last_backup_duration_in_seconds and not isinstance(last_backup_duration_in_seconds, int):
            raise TypeError("Expected argument 'last_backup_duration_in_seconds' to be a int")
        pulumi.set(__self__, "last_backup_duration_in_seconds", last_backup_duration_in_seconds)
        if last_backup_timestamp and not isinstance(last_backup_timestamp, str):
            raise TypeError("Expected argument 'last_backup_timestamp' to be a str")
        pulumi.set(__self__, "last_backup_timestamp", last_backup_timestamp)
        if last_failed_backup_timestamp and not isinstance(last_failed_backup_timestamp, str):
            raise TypeError("Expected argument 'last_failed_backup_timestamp' to be a str")
        pulumi.set(__self__, "last_failed_backup_timestamp", last_failed_backup_timestamp)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if ncharacter_set and not isinstance(ncharacter_set, str):
            raise TypeError("Expected argument 'ncharacter_set' to be a str")
        pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if pdb_name and not isinstance(pdb_name, str):
            raise TypeError("Expected argument 'pdb_name' to be a str")
        pulumi.set(__self__, "pdb_name", pdb_name)
        if sid_prefix and not isinstance(sid_prefix, str):
            raise TypeError("Expected argument 'sid_prefix' to be a str")
        pulumi.set(__self__, "sid_prefix", sid_prefix)
        if source and not isinstance(source, str):
            raise TypeError("Expected argument 'source' to be a str")
        pulumi.set(__self__, "source", source)
        if source_database_point_in_time_recovery_timestamp and not isinstance(source_database_point_in_time_recovery_timestamp, str):
            raise TypeError("Expected argument 'source_database_point_in_time_recovery_timestamp' to be a str")
        pulumi.set(__self__, "source_database_point_in_time_recovery_timestamp", source_database_point_in_time_recovery_timestamp)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if vault_id and not isinstance(vault_id, str):
            raise TypeError("Expected argument 'vault_id' to be a str")
        pulumi.set(__self__, "vault_id", vault_id)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> str:
        """
        The character set for the database.
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Sequence['outputs.GetDatabaseConnectionStringResult']:
        """
        The Connection strings used to connect to the Oracle Database.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseManagementConfigs")
    def database_management_configs(self) -> Sequence['outputs.GetDatabaseDatabaseManagementConfigResult']:
        """
        The configuration of the Database Management service.
        """
        return pulumi.get(self, "database_management_configs")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> str:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter
    def databases(self) -> Sequence['outputs.GetDatabaseDatabaseResult']:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="dbBackupConfigs")
    def db_backup_configs(self) -> Sequence['outputs.GetDatabaseDbBackupConfigResult']:
        """
        Backup Options To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to an administrator. If you're an administrator who needs to write policies to give users access, see [Getting Started with Policies](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/policygetstarted.htm).
        """
        return pulumi.get(self, "db_backup_configs")

    @property
    @pulumi.getter(name="dbHomeId")
    def db_home_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Home.
        """
        return pulumi.get(self, "db_home_id")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        The database name.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> str:
        """
        A system-generated name for the database to ensure uniqueness within an Oracle Data Guard group (a primary database and its standby databases). The unique name cannot be changed.
        """
        return pulumi.get(self, "db_unique_name")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> str:
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> str:
        """
        **Deprecated.** The dbWorkload field has been deprecated for Exadata Database Service on Dedicated Infrastructure, Exadata Database Service on Cloud@Customer, and Base Database Service. Support for this attribute will end in November 2023. You may choose to update your custom scripts to exclude the dbWorkload attribute. After November 2023 if you pass a value to the dbWorkload attribute, it will be ignored.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCdb")
    def is_cdb(self) -> bool:
        """
        True if the database is a container database.
        """
        return pulumi.get(self, "is_cdb")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the key store.
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreWalletName")
    def key_store_wallet_name(self) -> str:
        """
        The wallet name for Oracle Key Vault.
        """
        return pulumi.get(self, "key_store_wallet_name")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyMigration")
    def kms_key_migration(self) -> bool:
        return pulumi.get(self, "kms_key_migration")

    @property
    @pulumi.getter(name="kmsKeyRotation")
    def kms_key_rotation(self) -> int:
        return pulumi.get(self, "kms_key_rotation")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> str:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lastBackupDurationInSeconds")
    def last_backup_duration_in_seconds(self) -> int:
        """
        The duration when the latest database backup created.
        """
        return pulumi.get(self, "last_backup_duration_in_seconds")

    @property
    @pulumi.getter(name="lastBackupTimestamp")
    def last_backup_timestamp(self) -> str:
        """
        The date and time when the latest database backup was created.
        """
        return pulumi.get(self, "last_backup_timestamp")

    @property
    @pulumi.getter(name="lastFailedBackupTimestamp")
    def last_failed_backup_timestamp(self) -> str:
        """
        The date and time when the latest database backup failed.
        """
        return pulumi.get(self, "last_failed_backup_timestamp")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> str:
        """
        The national character set for the database.
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> str:
        """
        The name of the pluggable database. The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. Pluggable database should not be same as database name.
        """
        return pulumi.get(self, "pdb_name")

    @property
    @pulumi.getter(name="sidPrefix")
    def sid_prefix(self) -> str:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "sid_prefix")

    @property
    @pulumi.getter
    def source(self) -> str:
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceDatabasePointInTimeRecoveryTimestamp")
    def source_database_point_in_time_recovery_timestamp(self) -> str:
        """
        Point in time recovery timeStamp of the source database at which cloned database system is cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339)
        """
        return pulumi.get(self, "source_database_point_in_time_recovery_timestamp")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the database was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure [vault](https://docs.cloud.oracle.com/iaas/Content/KeyManagement/Concepts/keyoverview.htm#concepts).
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
        """
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetDatabaseResult(GetDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatabaseResult(
            character_set=self.character_set,
            compartment_id=self.compartment_id,
            connection_strings=self.connection_strings,
            database_id=self.database_id,
            database_management_configs=self.database_management_configs,
            database_software_image_id=self.database_software_image_id,
            databases=self.databases,
            db_backup_configs=self.db_backup_configs,
            db_home_id=self.db_home_id,
            db_name=self.db_name,
            db_system_id=self.db_system_id,
            db_unique_name=self.db_unique_name,
            db_version=self.db_version,
            db_workload=self.db_workload,
            defined_tags=self.defined_tags,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_cdb=self.is_cdb,
            key_store_id=self.key_store_id,
            key_store_wallet_name=self.key_store_wallet_name,
            kms_key_id=self.kms_key_id,
            kms_key_migration=self.kms_key_migration,
            kms_key_rotation=self.kms_key_rotation,
            kms_key_version_id=self.kms_key_version_id,
            last_backup_duration_in_seconds=self.last_backup_duration_in_seconds,
            last_backup_timestamp=self.last_backup_timestamp,
            last_failed_backup_timestamp=self.last_failed_backup_timestamp,
            lifecycle_details=self.lifecycle_details,
            ncharacter_set=self.ncharacter_set,
            pdb_name=self.pdb_name,
            sid_prefix=self.sid_prefix,
            source=self.source,
            source_database_point_in_time_recovery_timestamp=self.source_database_point_in_time_recovery_timestamp,
            state=self.state,
            time_created=self.time_created,
            vault_id=self.vault_id,
            vm_cluster_id=self.vm_cluster_id)


def get_database(database_id: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatabaseResult:
    """
    This data source provides details about a specific Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database = oci.Database.get_database(database_id=database_id)
    ```


    :param str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDatabase:getDatabase', __args__, opts=opts, typ=GetDatabaseResult).value

    return AwaitableGetDatabaseResult(
        character_set=pulumi.get(__ret__, 'character_set'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_strings=pulumi.get(__ret__, 'connection_strings'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_management_configs=pulumi.get(__ret__, 'database_management_configs'),
        database_software_image_id=pulumi.get(__ret__, 'database_software_image_id'),
        databases=pulumi.get(__ret__, 'databases'),
        db_backup_configs=pulumi.get(__ret__, 'db_backup_configs'),
        db_home_id=pulumi.get(__ret__, 'db_home_id'),
        db_name=pulumi.get(__ret__, 'db_name'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        db_unique_name=pulumi.get(__ret__, 'db_unique_name'),
        db_version=pulumi.get(__ret__, 'db_version'),
        db_workload=pulumi.get(__ret__, 'db_workload'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_cdb=pulumi.get(__ret__, 'is_cdb'),
        key_store_id=pulumi.get(__ret__, 'key_store_id'),
        key_store_wallet_name=pulumi.get(__ret__, 'key_store_wallet_name'),
        kms_key_id=pulumi.get(__ret__, 'kms_key_id'),
        kms_key_migration=pulumi.get(__ret__, 'kms_key_migration'),
        kms_key_rotation=pulumi.get(__ret__, 'kms_key_rotation'),
        kms_key_version_id=pulumi.get(__ret__, 'kms_key_version_id'),
        last_backup_duration_in_seconds=pulumi.get(__ret__, 'last_backup_duration_in_seconds'),
        last_backup_timestamp=pulumi.get(__ret__, 'last_backup_timestamp'),
        last_failed_backup_timestamp=pulumi.get(__ret__, 'last_failed_backup_timestamp'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        ncharacter_set=pulumi.get(__ret__, 'ncharacter_set'),
        pdb_name=pulumi.get(__ret__, 'pdb_name'),
        sid_prefix=pulumi.get(__ret__, 'sid_prefix'),
        source=pulumi.get(__ret__, 'source'),
        source_database_point_in_time_recovery_timestamp=pulumi.get(__ret__, 'source_database_point_in_time_recovery_timestamp'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        vault_id=pulumi.get(__ret__, 'vault_id'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))


@_utilities.lift_output_func(get_database)
def get_database_output(database_id: Optional[pulumi.Input[str]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatabaseResult]:
    """
    This data source provides details about a specific Database resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_database = oci.Database.get_database(database_id=database_id)
    ```


    :param str database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
