# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetDbNodeConsoleHistoryResult',
    'AwaitableGetDbNodeConsoleHistoryResult',
    'get_db_node_console_history',
    'get_db_node_console_history_output',
]

@pulumi.output_type
class GetDbNodeConsoleHistoryResult:
    """
    A collection of values returned by getDbNodeConsoleHistory.
    """
    def __init__(__self__, compartment_id=None, console_history_id=None, db_node_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, state=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if console_history_id and not isinstance(console_history_id, str):
            raise TypeError("Expected argument 'console_history_id' to be a str")
        pulumi.set(__self__, "console_history_id", console_history_id)
        if db_node_id and not isinstance(db_node_id, str):
            raise TypeError("Expected argument 'db_node_id' to be a str")
        pulumi.set(__self__, "db_node_id", db_node_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the console history.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="consoleHistoryId")
    def console_history_id(self) -> str:
        return pulumi.get(self, "console_history_id")

    @property
    @pulumi.getter(name="dbNodeId")
    def db_node_id(self) -> str:
        """
        The OCID of the database node.
        """
        return pulumi.get(self, "db_node_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the console history. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the console history.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the console history.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the console history was created.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetDbNodeConsoleHistoryResult(GetDbNodeConsoleHistoryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbNodeConsoleHistoryResult(
            compartment_id=self.compartment_id,
            console_history_id=self.console_history_id,
            db_node_id=self.db_node_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            time_created=self.time_created)


def get_db_node_console_history(console_history_id: Optional[str] = None,
                                db_node_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbNodeConsoleHistoryResult:
    """
    This data source provides details about a specific Db Node Console History resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified database node console history.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_history = oci.Database.get_db_node_console_history(console_history_id=test_console_history["id"],
        db_node_id=test_db_node["id"])
    ```


    :param str console_history_id: The OCID of the console history.
    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['consoleHistoryId'] = console_history_id
    __args__['dbNodeId'] = db_node_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getDbNodeConsoleHistory:getDbNodeConsoleHistory', __args__, opts=opts, typ=GetDbNodeConsoleHistoryResult).value

    return AwaitableGetDbNodeConsoleHistoryResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        console_history_id=pulumi.get(__ret__, 'console_history_id'),
        db_node_id=pulumi.get(__ret__, 'db_node_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_db_node_console_history)
def get_db_node_console_history_output(console_history_id: Optional[pulumi.Input[str]] = None,
                                       db_node_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDbNodeConsoleHistoryResult]:
    """
    This data source provides details about a specific Db Node Console History resource in Oracle Cloud Infrastructure Database service.

    Gets information about the specified database node console history.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_db_node_console_history = oci.Database.get_db_node_console_history(console_history_id=test_console_history["id"],
        db_node_id=test_db_node["id"])
    ```


    :param str console_history_id: The OCID of the console history.
    :param str db_node_id: The database node [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
