# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint, constr

class MovementMatrixElement(BaseModel):
    """
    Time and distance matrix.
    """
    source_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Target key.")
    destination_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Target key.")
    distance: conint(strict=True, le=40000, ge=0) = Field(..., description="Total length, in km.")
    cost_per_transport: Optional[conint(strict=True, le=100000000, ge=0)] = Field(0, description="The total cost of usage 1 transport between source and destination, in conventional monetary units. ")
    __properties = ["source_key", "destination_key", "distance", "cost_per_transport"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MovementMatrixElement:
        """Create an instance of MovementMatrixElement from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MovementMatrixElement:
        """Create an instance of MovementMatrixElement from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MovementMatrixElement.parse_obj(obj)

        _obj = MovementMatrixElement.parse_obj({
            "source_key": obj.get("source_key"),
            "destination_key": obj.get("destination_key"),
            "distance": obj.get("distance"),
            "cost_per_transport": obj.get("cost_per_transport") if obj.get("cost_per_transport") is not None else 0
        })
        return _obj

