# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.13.2112

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conint, conlist
from vrt_lss_agro.models.calculation_info import CalculationInfo
from vrt_lss_agro.models.entity_warning import EntityWarning
from vrt_lss_agro.models.operation import Operation
from vrt_lss_agro.models.plan_statistics import PlanStatistics
from vrt_lss_agro.models.tracedata import Tracedata
from vrt_lss_agro.models.unplanned_items import UnplannedItems

class PlanResult(BaseModel):
    """
    Planning result.
    """
    tracedata: Tracedata = Field(...)
    project: conlist(Operation, max_items=1000001, min_items=0) = Field(..., description="Production plan. The sequence of work. ")
    statistics: PlanStatistics = Field(...)
    warnings: Optional[conlist(EntityWarning, max_items=100001, min_items=0)] = Field(None, description="List of warnings. Depending on the flag `calculation_settings.treat_warnings_as_errors` - triggered checks are interpreted as errors or result in the removal of incorrect data from the calculation. ")
    unplanned_items: Optional[UnplannedItems] = None
    progress: conint(strict=True, le=100, ge=0) = Field(..., description="Calculation progress as a percentage. The progress displays the current number of completed steps. ")
    info: CalculationInfo = Field(...)
    __properties = ["tracedata", "project", "statistics", "warnings", "unplanned_items", "progress", "info"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PlanResult:
        """Create an instance of PlanResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tracedata
        if self.tracedata:
            _dict['tracedata'] = self.tracedata.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in project (list)
        _items = []
        if self.project:
            for _item in self.project:
                if _item:
                    _items.append(_item.to_dict())
            _dict['project'] = _items
        # override the default output from pydantic by calling `to_dict()` of statistics
        if self.statistics:
            _dict['statistics'] = self.statistics.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in warnings (list)
        _items = []
        if self.warnings:
            for _item in self.warnings:
                if _item:
                    _items.append(_item.to_dict())
            _dict['warnings'] = _items
        # override the default output from pydantic by calling `to_dict()` of unplanned_items
        if self.unplanned_items:
            _dict['unplanned_items'] = self.unplanned_items.to_dict()
        # override the default output from pydantic by calling `to_dict()` of info
        if self.info:
            _dict['info'] = self.info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PlanResult:
        """Create an instance of PlanResult from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PlanResult.parse_obj(obj)

        _obj = PlanResult.parse_obj({
            "tracedata": Tracedata.from_dict(obj.get("tracedata")) if obj.get("tracedata") is not None else None,
            "project": [Operation.from_dict(_item) for _item in obj.get("project")] if obj.get("project") is not None else None,
            "statistics": PlanStatistics.from_dict(obj.get("statistics")) if obj.get("statistics") is not None else None,
            "warnings": [EntityWarning.from_dict(_item) for _item in obj.get("warnings")] if obj.get("warnings") is not None else None,
            "unplanned_items": UnplannedItems.from_dict(obj.get("unplanned_items")) if obj.get("unplanned_items") is not None else None,
            "progress": obj.get("progress") if obj.get("progress") is not None else 0,
            "info": CalculationInfo.from_dict(obj.get("info")) if obj.get("info") is not None else None
        })
        return _obj

