# coding: utf-8

"""
    LocalStack REST API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 4.12.0
    Contact: info@localstack.cloud
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class AwsPinpointApplicationIdReferenceIdGet200Response(BaseModel):
    """
    AwsPinpointApplicationIdReferenceIdGet200Response
    """ # noqa: E501
    allowed_attempts: Annotated[int, Field(le=5, strict=True)] = Field(description="Maximum number of allowed attempts for OTP validation.", alias="AllowedAttempts")
    brand_name: Optional[StrictStr] = Field(default=None, description="Name of the brand that is associated with the OTP code.", alias="BrandName")
    code_length: Annotated[int, Field(le=8, strict=True, ge=5)] = Field(description="Number of digits in the OTP code that was sent.", alias="CodeLength")
    destination_identity: StrictStr = Field(description="Phone number that the OTP code was sent to.", alias="DestinationIdentity")
    entity_id: Optional[StrictStr] = Field(default=None, description="ID registered with the regulatory agency (India only).", alias="EntityId")
    language: Optional[StrictStr] = Field(default=None, description="Language used when sending the message.", alias="Language")
    origination_identity: StrictStr = Field(description="Identity (e.g. short code) that is used to send the OTP code.", alias="OriginationIdentity")
    reference_id: Annotated[str, Field(min_length=1, strict=True, max_length=48)] = Field(description="Unique reference ID that was used in the SendOTPMessage request.", alias="ReferenceId")
    template_id: Optional[StrictStr] = Field(default=None, description="ID that is registered with the regulatory agency (India only).", alias="TemplateId")
    validity_period: Annotated[int, Field(le=60, strict=True)] = Field(description="Time in minutes the OTP code is valid for.", alias="ValidityPeriod")
    attempts: Annotated[str, Field(strict=True)] = Field(description="OTP validation attempts made so far.", alias="Attempts")
    application_id: StrictStr = Field(description="Identifier of the Pinpoint Application.", alias="ApplicationId")
    created_timestamp: datetime = Field(description="Timestamp of the SendOTPMessage request.", alias="CreatedTimestamp")
    code: Annotated[str, Field(min_length=5, strict=True, max_length=8)] = Field(description="One-time password.", alias="Code")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["AllowedAttempts", "BrandName", "CodeLength", "DestinationIdentity", "EntityId", "Language", "OriginationIdentity", "ReferenceId", "TemplateId", "ValidityPeriod", "Attempts", "ApplicationId", "CreatedTimestamp", "Code"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AwsPinpointApplicationIdReferenceIdGet200Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AwsPinpointApplicationIdReferenceIdGet200Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "AllowedAttempts": obj.get("AllowedAttempts"),
            "BrandName": obj.get("BrandName"),
            "CodeLength": obj.get("CodeLength"),
            "DestinationIdentity": obj.get("DestinationIdentity"),
            "EntityId": obj.get("EntityId"),
            "Language": obj.get("Language"),
            "OriginationIdentity": obj.get("OriginationIdentity"),
            "ReferenceId": obj.get("ReferenceId"),
            "TemplateId": obj.get("TemplateId"),
            "ValidityPeriod": obj.get("ValidityPeriod"),
            "Attempts": obj.get("Attempts"),
            "ApplicationId": obj.get("ApplicationId"),
            "CreatedTimestamp": obj.get("CreatedTimestamp"),
            "Code": obj.get("Code")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


