"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn_element_1 = require("./cfn-element");
class CfnOutput extends cfn_element_1.CfnElement {
    /**
     * Creates an CfnOutput value for this stack.
     * @param scope The parent construct.
     * @param props CfnOutput properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.value === undefined) {
            throw new Error(`Missing value for CloudFormation output at path "${this.node.path}"`);
        }
        this._description = props.description;
        this._value = props.value;
        this._condition = props.condition;
        this._export = props.exportName;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Outputs: {
                [this.logicalId]: {
                    Description: this._description,
                    Value: this._value,
                    Export: this._export != null ? { Name: this._export } : undefined,
                    Condition: this._condition ? this._condition.logicalId : undefined,
                },
            },
        };
    }
}
exports.CfnOutput = CfnOutput;
//# sourceMappingURL=data:application/json;base64,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