# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoBgpFeatureTemplateArgs', 'CiscoBgpFeatureTemplate']

@pulumi.input_type
class CiscoBgpFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]]] = None,
                 always_compare_med: Optional[pulumi.Input[builtins.bool]] = None,
                 always_compare_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 as_number: Optional[pulumi.Input[builtins.str]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 compare_router_id: Optional[pulumi.Input[builtins.bool]] = None,
                 compare_router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 deterministic_med: Optional[pulumi.Input[builtins.bool]] = None,
                 deterministic_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_external: Optional[pulumi.Input[builtins.int]] = None,
                 distance_external_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_internal: Optional[pulumi.Input[builtins.int]] = None,
                 distance_internal_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_local: Optional[pulumi.Input[builtins.int]] = None,
                 distance_local_variable: Optional[pulumi.Input[builtins.str]] = None,
                 holdtime: Optional[pulumi.Input[builtins.int]] = None,
                 holdtime_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]]] = None,
                 ipv4_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]]] = None,
                 ipv6_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]]] = None,
                 ipv6_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]]] = None,
                 keepalive: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_variable: Optional[pulumi.Input[builtins.str]] = None,
                 missing_med_worst: Optional[pulumi.Input[builtins.bool]] = None,
                 missing_med_worst_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mpls_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]]] = None,
                 multipath_relax: Optional[pulumi.Input[builtins.bool]] = None,
                 multipath_relax_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_aspath: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_aspath_variable: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_community: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_community_variable: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoBgpFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]] address_families: Set BGP address family
        :param pulumi.Input[builtins.bool] always_compare_med: Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] always_compare_med_variable: Variable name
        :param pulumi.Input[builtins.str] as_number: Set autonomous system number <1..4294967295> or <XX.YY>
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.bool] compare_router_id: Compare router IDs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] compare_router_id_variable: Variable name
        :param pulumi.Input[builtins.bool] deterministic_med: Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] deterministic_med_variable: Variable name
        :param pulumi.Input[builtins.int] distance_external: Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_external_variable: Variable name
        :param pulumi.Input[builtins.int] distance_internal: Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        :param pulumi.Input[builtins.str] distance_internal_variable: Variable name
        :param pulumi.Input[builtins.int] distance_local: Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_local_variable: Variable name
        :param pulumi.Input[builtins.int] holdtime: Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        :param pulumi.Input[builtins.str] holdtime_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]] ipv4_neighbors: Set BGP neighbors
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]] ipv4_route_targets: Router Target for IPV4
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]] ipv6_neighbors: Set BGP IPv6 neighbors
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]] ipv6_route_targets: Router Target for IPV6
        :param pulumi.Input[builtins.int] keepalive: Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        :param pulumi.Input[builtins.str] keepalive_variable: Variable name
        :param pulumi.Input[builtins.bool] missing_med_worst: If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] missing_med_worst_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]] mpls_interfaces: MPLS BGP Interface
        :param pulumi.Input[builtins.bool] multipath_relax: Ignore AS for multipath selection - Default value: `false`
        :param pulumi.Input[builtins.str] multipath_relax_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] propagate_aspath: Propagate AS Path - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_aspath_variable: Variable name
        :param pulumi.Input[builtins.bool] propagate_community: Propagate Community - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_community_variable: Variable name
        :param pulumi.Input[builtins.str] router_id: Configure BGP router identifier
        :param pulumi.Input[builtins.str] router_id_variable: Variable name
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable BGP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if address_families is not None:
            pulumi.set(__self__, "address_families", address_families)
        if always_compare_med is not None:
            pulumi.set(__self__, "always_compare_med", always_compare_med)
        if always_compare_med_variable is not None:
            pulumi.set(__self__, "always_compare_med_variable", always_compare_med_variable)
        if as_number is not None:
            pulumi.set(__self__, "as_number", as_number)
        if as_number_variable is not None:
            pulumi.set(__self__, "as_number_variable", as_number_variable)
        if compare_router_id is not None:
            pulumi.set(__self__, "compare_router_id", compare_router_id)
        if compare_router_id_variable is not None:
            pulumi.set(__self__, "compare_router_id_variable", compare_router_id_variable)
        if deterministic_med is not None:
            pulumi.set(__self__, "deterministic_med", deterministic_med)
        if deterministic_med_variable is not None:
            pulumi.set(__self__, "deterministic_med_variable", deterministic_med_variable)
        if distance_external is not None:
            pulumi.set(__self__, "distance_external", distance_external)
        if distance_external_variable is not None:
            pulumi.set(__self__, "distance_external_variable", distance_external_variable)
        if distance_internal is not None:
            pulumi.set(__self__, "distance_internal", distance_internal)
        if distance_internal_variable is not None:
            pulumi.set(__self__, "distance_internal_variable", distance_internal_variable)
        if distance_local is not None:
            pulumi.set(__self__, "distance_local", distance_local)
        if distance_local_variable is not None:
            pulumi.set(__self__, "distance_local_variable", distance_local_variable)
        if holdtime is not None:
            pulumi.set(__self__, "holdtime", holdtime)
        if holdtime_variable is not None:
            pulumi.set(__self__, "holdtime_variable", holdtime_variable)
        if ipv4_neighbors is not None:
            pulumi.set(__self__, "ipv4_neighbors", ipv4_neighbors)
        if ipv4_route_targets is not None:
            pulumi.set(__self__, "ipv4_route_targets", ipv4_route_targets)
        if ipv6_neighbors is not None:
            pulumi.set(__self__, "ipv6_neighbors", ipv6_neighbors)
        if ipv6_route_targets is not None:
            pulumi.set(__self__, "ipv6_route_targets", ipv6_route_targets)
        if keepalive is not None:
            pulumi.set(__self__, "keepalive", keepalive)
        if keepalive_variable is not None:
            pulumi.set(__self__, "keepalive_variable", keepalive_variable)
        if missing_med_worst is not None:
            pulumi.set(__self__, "missing_med_worst", missing_med_worst)
        if missing_med_worst_variable is not None:
            pulumi.set(__self__, "missing_med_worst_variable", missing_med_worst_variable)
        if mpls_interfaces is not None:
            pulumi.set(__self__, "mpls_interfaces", mpls_interfaces)
        if multipath_relax is not None:
            pulumi.set(__self__, "multipath_relax", multipath_relax)
        if multipath_relax_variable is not None:
            pulumi.set(__self__, "multipath_relax_variable", multipath_relax_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if propagate_aspath is not None:
            pulumi.set(__self__, "propagate_aspath", propagate_aspath)
        if propagate_aspath_variable is not None:
            pulumi.set(__self__, "propagate_aspath_variable", propagate_aspath_variable)
        if propagate_community is not None:
            pulumi.set(__self__, "propagate_community", propagate_community)
        if propagate_community_variable is not None:
            pulumi.set(__self__, "propagate_community_variable", propagate_community_variable)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_id_variable is not None:
            pulumi.set(__self__, "router_id_variable", router_id_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="addressFamilies")
    def address_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]]]:
        """
        Set BGP address family
        """
        return pulumi.get(self, "address_families")

    @address_families.setter
    def address_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]]]):
        pulumi.set(self, "address_families", value)

    @property
    @pulumi.getter(name="alwaysCompareMed")
    def always_compare_med(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "always_compare_med")

    @always_compare_med.setter
    def always_compare_med(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "always_compare_med", value)

    @property
    @pulumi.getter(name="alwaysCompareMedVariable")
    def always_compare_med_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "always_compare_med_variable")

    @always_compare_med_variable.setter
    def always_compare_med_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "always_compare_med_variable", value)

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set autonomous system number <1..4294967295> or <XX.YY>
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as_number", value)

    @property
    @pulumi.getter(name="asNumberVariable")
    def as_number_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "as_number_variable")

    @as_number_variable.setter
    def as_number_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as_number_variable", value)

    @property
    @pulumi.getter(name="compareRouterId")
    def compare_router_id(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Compare router IDs when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "compare_router_id")

    @compare_router_id.setter
    def compare_router_id(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compare_router_id", value)

    @property
    @pulumi.getter(name="compareRouterIdVariable")
    def compare_router_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "compare_router_id_variable")

    @compare_router_id_variable.setter
    def compare_router_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compare_router_id_variable", value)

    @property
    @pulumi.getter(name="deterministicMed")
    def deterministic_med(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "deterministic_med")

    @deterministic_med.setter
    def deterministic_med(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deterministic_med", value)

    @property
    @pulumi.getter(name="deterministicMedVariable")
    def deterministic_med_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "deterministic_med_variable")

    @deterministic_med_variable.setter
    def deterministic_med_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deterministic_med_variable", value)

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        """
        return pulumi.get(self, "distance_external")

    @distance_external.setter
    def distance_external(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "distance_external", value)

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @distance_external_variable.setter
    def distance_external_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distance_external_variable", value)

    @property
    @pulumi.getter(name="distanceInternal")
    def distance_internal(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        """
        return pulumi.get(self, "distance_internal")

    @distance_internal.setter
    def distance_internal(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "distance_internal", value)

    @property
    @pulumi.getter(name="distanceInternalVariable")
    def distance_internal_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_internal_variable")

    @distance_internal_variable.setter
    def distance_internal_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distance_internal_variable", value)

    @property
    @pulumi.getter(name="distanceLocal")
    def distance_local(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        """
        return pulumi.get(self, "distance_local")

    @distance_local.setter
    def distance_local(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "distance_local", value)

    @property
    @pulumi.getter(name="distanceLocalVariable")
    def distance_local_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_local_variable")

    @distance_local_variable.setter
    def distance_local_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distance_local_variable", value)

    @property
    @pulumi.getter
    def holdtime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        """
        return pulumi.get(self, "holdtime")

    @holdtime.setter
    def holdtime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "holdtime", value)

    @property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @holdtime_variable.setter
    def holdtime_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "holdtime_variable", value)

    @property
    @pulumi.getter(name="ipv4Neighbors")
    def ipv4_neighbors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]]]:
        """
        Set BGP neighbors
        """
        return pulumi.get(self, "ipv4_neighbors")

    @ipv4_neighbors.setter
    def ipv4_neighbors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]]]):
        pulumi.set(self, "ipv4_neighbors", value)

    @property
    @pulumi.getter(name="ipv4RouteTargets")
    def ipv4_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]]]:
        """
        Router Target for IPV4
        """
        return pulumi.get(self, "ipv4_route_targets")

    @ipv4_route_targets.setter
    def ipv4_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]]]):
        pulumi.set(self, "ipv4_route_targets", value)

    @property
    @pulumi.getter(name="ipv6Neighbors")
    def ipv6_neighbors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]]]:
        """
        Set BGP IPv6 neighbors
        """
        return pulumi.get(self, "ipv6_neighbors")

    @ipv6_neighbors.setter
    def ipv6_neighbors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]]]):
        pulumi.set(self, "ipv6_neighbors", value)

    @property
    @pulumi.getter(name="ipv6RouteTargets")
    def ipv6_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]]]:
        """
        Router Target for IPV6
        """
        return pulumi.get(self, "ipv6_route_targets")

    @ipv6_route_targets.setter
    def ipv6_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]]]):
        pulumi.set(self, "ipv6_route_targets", value)

    @property
    @pulumi.getter
    def keepalive(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        """
        return pulumi.get(self, "keepalive")

    @keepalive.setter
    def keepalive(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "keepalive", value)

    @property
    @pulumi.getter(name="keepaliveVariable")
    def keepalive_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "keepalive_variable")

    @keepalive_variable.setter
    def keepalive_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keepalive_variable", value)

    @property
    @pulumi.getter(name="missingMedWorst")
    def missing_med_worst(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "missing_med_worst")

    @missing_med_worst.setter
    def missing_med_worst(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "missing_med_worst", value)

    @property
    @pulumi.getter(name="missingMedWorstVariable")
    def missing_med_worst_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "missing_med_worst_variable")

    @missing_med_worst_variable.setter
    def missing_med_worst_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "missing_med_worst_variable", value)

    @property
    @pulumi.getter(name="mplsInterfaces")
    def mpls_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]]]:
        """
        MPLS BGP Interface
        """
        return pulumi.get(self, "mpls_interfaces")

    @mpls_interfaces.setter
    def mpls_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]]]):
        pulumi.set(self, "mpls_interfaces", value)

    @property
    @pulumi.getter(name="multipathRelax")
    def multipath_relax(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Ignore AS for multipath selection - Default value: `false`
        """
        return pulumi.get(self, "multipath_relax")

    @multipath_relax.setter
    def multipath_relax(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multipath_relax", value)

    @property
    @pulumi.getter(name="multipathRelaxVariable")
    def multipath_relax_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multipath_relax_variable")

    @multipath_relax_variable.setter
    def multipath_relax_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multipath_relax_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="propagateAspath")
    def propagate_aspath(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Propagate AS Path - Default value: `false`
        """
        return pulumi.get(self, "propagate_aspath")

    @propagate_aspath.setter
    def propagate_aspath(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "propagate_aspath", value)

    @property
    @pulumi.getter(name="propagateAspathVariable")
    def propagate_aspath_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "propagate_aspath_variable")

    @propagate_aspath_variable.setter
    def propagate_aspath_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "propagate_aspath_variable", value)

    @property
    @pulumi.getter(name="propagateCommunity")
    def propagate_community(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Propagate Community - Default value: `false`
        """
        return pulumi.get(self, "propagate_community")

    @propagate_community.setter
    def propagate_community(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "propagate_community", value)

    @property
    @pulumi.getter(name="propagateCommunityVariable")
    def propagate_community_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "propagate_community_variable")

    @propagate_community_variable.setter
    def propagate_community_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "propagate_community_variable", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure BGP router identifier
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @router_id_variable.setter
    def router_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_id_variable", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable BGP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)


@pulumi.input_type
class _CiscoBgpFeatureTemplateState:
    def __init__(__self__, *,
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]]] = None,
                 always_compare_med: Optional[pulumi.Input[builtins.bool]] = None,
                 always_compare_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 as_number: Optional[pulumi.Input[builtins.str]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 compare_router_id: Optional[pulumi.Input[builtins.bool]] = None,
                 compare_router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 deterministic_med: Optional[pulumi.Input[builtins.bool]] = None,
                 deterministic_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 distance_external: Optional[pulumi.Input[builtins.int]] = None,
                 distance_external_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_internal: Optional[pulumi.Input[builtins.int]] = None,
                 distance_internal_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_local: Optional[pulumi.Input[builtins.int]] = None,
                 distance_local_variable: Optional[pulumi.Input[builtins.str]] = None,
                 holdtime: Optional[pulumi.Input[builtins.int]] = None,
                 holdtime_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]]] = None,
                 ipv4_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]]] = None,
                 ipv6_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]]] = None,
                 ipv6_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]]] = None,
                 keepalive: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_variable: Optional[pulumi.Input[builtins.str]] = None,
                 missing_med_worst: Optional[pulumi.Input[builtins.bool]] = None,
                 missing_med_worst_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mpls_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]]] = None,
                 multipath_relax: Optional[pulumi.Input[builtins.bool]] = None,
                 multipath_relax_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_aspath: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_aspath_variable: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_community: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_community_variable: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CiscoBgpFeatureTemplate resources.
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]] address_families: Set BGP address family
        :param pulumi.Input[builtins.bool] always_compare_med: Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] always_compare_med_variable: Variable name
        :param pulumi.Input[builtins.str] as_number: Set autonomous system number <1..4294967295> or <XX.YY>
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.bool] compare_router_id: Compare router IDs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] compare_router_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[builtins.bool] deterministic_med: Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] deterministic_med_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.int] distance_external: Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_external_variable: Variable name
        :param pulumi.Input[builtins.int] distance_internal: Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        :param pulumi.Input[builtins.str] distance_internal_variable: Variable name
        :param pulumi.Input[builtins.int] distance_local: Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_local_variable: Variable name
        :param pulumi.Input[builtins.int] holdtime: Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        :param pulumi.Input[builtins.str] holdtime_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]] ipv4_neighbors: Set BGP neighbors
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]] ipv4_route_targets: Router Target for IPV4
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]] ipv6_neighbors: Set BGP IPv6 neighbors
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]] ipv6_route_targets: Router Target for IPV6
        :param pulumi.Input[builtins.int] keepalive: Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        :param pulumi.Input[builtins.str] keepalive_variable: Variable name
        :param pulumi.Input[builtins.bool] missing_med_worst: If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] missing_med_worst_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]] mpls_interfaces: MPLS BGP Interface
        :param pulumi.Input[builtins.bool] multipath_relax: Ignore AS for multipath selection - Default value: `false`
        :param pulumi.Input[builtins.str] multipath_relax_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] propagate_aspath: Propagate AS Path - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_aspath_variable: Variable name
        :param pulumi.Input[builtins.bool] propagate_community: Propagate Community - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_community_variable: Variable name
        :param pulumi.Input[builtins.str] router_id: Configure BGP router identifier
        :param pulumi.Input[builtins.str] router_id_variable: Variable name
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable BGP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if address_families is not None:
            pulumi.set(__self__, "address_families", address_families)
        if always_compare_med is not None:
            pulumi.set(__self__, "always_compare_med", always_compare_med)
        if always_compare_med_variable is not None:
            pulumi.set(__self__, "always_compare_med_variable", always_compare_med_variable)
        if as_number is not None:
            pulumi.set(__self__, "as_number", as_number)
        if as_number_variable is not None:
            pulumi.set(__self__, "as_number_variable", as_number_variable)
        if compare_router_id is not None:
            pulumi.set(__self__, "compare_router_id", compare_router_id)
        if compare_router_id_variable is not None:
            pulumi.set(__self__, "compare_router_id_variable", compare_router_id_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if deterministic_med is not None:
            pulumi.set(__self__, "deterministic_med", deterministic_med)
        if deterministic_med_variable is not None:
            pulumi.set(__self__, "deterministic_med_variable", deterministic_med_variable)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if distance_external is not None:
            pulumi.set(__self__, "distance_external", distance_external)
        if distance_external_variable is not None:
            pulumi.set(__self__, "distance_external_variable", distance_external_variable)
        if distance_internal is not None:
            pulumi.set(__self__, "distance_internal", distance_internal)
        if distance_internal_variable is not None:
            pulumi.set(__self__, "distance_internal_variable", distance_internal_variable)
        if distance_local is not None:
            pulumi.set(__self__, "distance_local", distance_local)
        if distance_local_variable is not None:
            pulumi.set(__self__, "distance_local_variable", distance_local_variable)
        if holdtime is not None:
            pulumi.set(__self__, "holdtime", holdtime)
        if holdtime_variable is not None:
            pulumi.set(__self__, "holdtime_variable", holdtime_variable)
        if ipv4_neighbors is not None:
            pulumi.set(__self__, "ipv4_neighbors", ipv4_neighbors)
        if ipv4_route_targets is not None:
            pulumi.set(__self__, "ipv4_route_targets", ipv4_route_targets)
        if ipv6_neighbors is not None:
            pulumi.set(__self__, "ipv6_neighbors", ipv6_neighbors)
        if ipv6_route_targets is not None:
            pulumi.set(__self__, "ipv6_route_targets", ipv6_route_targets)
        if keepalive is not None:
            pulumi.set(__self__, "keepalive", keepalive)
        if keepalive_variable is not None:
            pulumi.set(__self__, "keepalive_variable", keepalive_variable)
        if missing_med_worst is not None:
            pulumi.set(__self__, "missing_med_worst", missing_med_worst)
        if missing_med_worst_variable is not None:
            pulumi.set(__self__, "missing_med_worst_variable", missing_med_worst_variable)
        if mpls_interfaces is not None:
            pulumi.set(__self__, "mpls_interfaces", mpls_interfaces)
        if multipath_relax is not None:
            pulumi.set(__self__, "multipath_relax", multipath_relax)
        if multipath_relax_variable is not None:
            pulumi.set(__self__, "multipath_relax_variable", multipath_relax_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if propagate_aspath is not None:
            pulumi.set(__self__, "propagate_aspath", propagate_aspath)
        if propagate_aspath_variable is not None:
            pulumi.set(__self__, "propagate_aspath_variable", propagate_aspath_variable)
        if propagate_community is not None:
            pulumi.set(__self__, "propagate_community", propagate_community)
        if propagate_community_variable is not None:
            pulumi.set(__self__, "propagate_community_variable", propagate_community_variable)
        if router_id is not None:
            pulumi.set(__self__, "router_id", router_id)
        if router_id_variable is not None:
            pulumi.set(__self__, "router_id_variable", router_id_variable)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="addressFamilies")
    def address_families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]]]:
        """
        Set BGP address family
        """
        return pulumi.get(self, "address_families")

    @address_families.setter
    def address_families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateAddressFamilyArgs']]]]):
        pulumi.set(self, "address_families", value)

    @property
    @pulumi.getter(name="alwaysCompareMed")
    def always_compare_med(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "always_compare_med")

    @always_compare_med.setter
    def always_compare_med(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "always_compare_med", value)

    @property
    @pulumi.getter(name="alwaysCompareMedVariable")
    def always_compare_med_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "always_compare_med_variable")

    @always_compare_med_variable.setter
    def always_compare_med_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "always_compare_med_variable", value)

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set autonomous system number <1..4294967295> or <XX.YY>
        """
        return pulumi.get(self, "as_number")

    @as_number.setter
    def as_number(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as_number", value)

    @property
    @pulumi.getter(name="asNumberVariable")
    def as_number_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "as_number_variable")

    @as_number_variable.setter
    def as_number_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "as_number_variable", value)

    @property
    @pulumi.getter(name="compareRouterId")
    def compare_router_id(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Compare router IDs when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "compare_router_id")

    @compare_router_id.setter
    def compare_router_id(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "compare_router_id", value)

    @property
    @pulumi.getter(name="compareRouterIdVariable")
    def compare_router_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "compare_router_id_variable")

    @compare_router_id_variable.setter
    def compare_router_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compare_router_id_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deterministicMed")
    def deterministic_med(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "deterministic_med")

    @deterministic_med.setter
    def deterministic_med(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deterministic_med", value)

    @property
    @pulumi.getter(name="deterministicMedVariable")
    def deterministic_med_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "deterministic_med_variable")

    @deterministic_med_variable.setter
    def deterministic_med_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deterministic_med_variable", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        """
        return pulumi.get(self, "distance_external")

    @distance_external.setter
    def distance_external(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "distance_external", value)

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @distance_external_variable.setter
    def distance_external_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distance_external_variable", value)

    @property
    @pulumi.getter(name="distanceInternal")
    def distance_internal(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        """
        return pulumi.get(self, "distance_internal")

    @distance_internal.setter
    def distance_internal(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "distance_internal", value)

    @property
    @pulumi.getter(name="distanceInternalVariable")
    def distance_internal_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_internal_variable")

    @distance_internal_variable.setter
    def distance_internal_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distance_internal_variable", value)

    @property
    @pulumi.getter(name="distanceLocal")
    def distance_local(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        """
        return pulumi.get(self, "distance_local")

    @distance_local.setter
    def distance_local(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "distance_local", value)

    @property
    @pulumi.getter(name="distanceLocalVariable")
    def distance_local_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_local_variable")

    @distance_local_variable.setter
    def distance_local_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distance_local_variable", value)

    @property
    @pulumi.getter
    def holdtime(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        """
        return pulumi.get(self, "holdtime")

    @holdtime.setter
    def holdtime(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "holdtime", value)

    @property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @holdtime_variable.setter
    def holdtime_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "holdtime_variable", value)

    @property
    @pulumi.getter(name="ipv4Neighbors")
    def ipv4_neighbors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]]]:
        """
        Set BGP neighbors
        """
        return pulumi.get(self, "ipv4_neighbors")

    @ipv4_neighbors.setter
    def ipv4_neighbors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4NeighborArgs']]]]):
        pulumi.set(self, "ipv4_neighbors", value)

    @property
    @pulumi.getter(name="ipv4RouteTargets")
    def ipv4_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]]]:
        """
        Router Target for IPV4
        """
        return pulumi.get(self, "ipv4_route_targets")

    @ipv4_route_targets.setter
    def ipv4_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv4RouteTargetArgs']]]]):
        pulumi.set(self, "ipv4_route_targets", value)

    @property
    @pulumi.getter(name="ipv6Neighbors")
    def ipv6_neighbors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]]]:
        """
        Set BGP IPv6 neighbors
        """
        return pulumi.get(self, "ipv6_neighbors")

    @ipv6_neighbors.setter
    def ipv6_neighbors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6NeighborArgs']]]]):
        pulumi.set(self, "ipv6_neighbors", value)

    @property
    @pulumi.getter(name="ipv6RouteTargets")
    def ipv6_route_targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]]]:
        """
        Router Target for IPV6
        """
        return pulumi.get(self, "ipv6_route_targets")

    @ipv6_route_targets.setter
    def ipv6_route_targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateIpv6RouteTargetArgs']]]]):
        pulumi.set(self, "ipv6_route_targets", value)

    @property
    @pulumi.getter
    def keepalive(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        """
        return pulumi.get(self, "keepalive")

    @keepalive.setter
    def keepalive(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "keepalive", value)

    @property
    @pulumi.getter(name="keepaliveVariable")
    def keepalive_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "keepalive_variable")

    @keepalive_variable.setter
    def keepalive_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "keepalive_variable", value)

    @property
    @pulumi.getter(name="missingMedWorst")
    def missing_med_worst(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "missing_med_worst")

    @missing_med_worst.setter
    def missing_med_worst(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "missing_med_worst", value)

    @property
    @pulumi.getter(name="missingMedWorstVariable")
    def missing_med_worst_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "missing_med_worst_variable")

    @missing_med_worst_variable.setter
    def missing_med_worst_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "missing_med_worst_variable", value)

    @property
    @pulumi.getter(name="mplsInterfaces")
    def mpls_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]]]:
        """
        MPLS BGP Interface
        """
        return pulumi.get(self, "mpls_interfaces")

    @mpls_interfaces.setter
    def mpls_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoBgpFeatureTemplateMplsInterfaceArgs']]]]):
        pulumi.set(self, "mpls_interfaces", value)

    @property
    @pulumi.getter(name="multipathRelax")
    def multipath_relax(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Ignore AS for multipath selection - Default value: `false`
        """
        return pulumi.get(self, "multipath_relax")

    @multipath_relax.setter
    def multipath_relax(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "multipath_relax", value)

    @property
    @pulumi.getter(name="multipathRelaxVariable")
    def multipath_relax_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multipath_relax_variable")

    @multipath_relax_variable.setter
    def multipath_relax_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multipath_relax_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="propagateAspath")
    def propagate_aspath(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Propagate AS Path - Default value: `false`
        """
        return pulumi.get(self, "propagate_aspath")

    @propagate_aspath.setter
    def propagate_aspath(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "propagate_aspath", value)

    @property
    @pulumi.getter(name="propagateAspathVariable")
    def propagate_aspath_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "propagate_aspath_variable")

    @propagate_aspath_variable.setter
    def propagate_aspath_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "propagate_aspath_variable", value)

    @property
    @pulumi.getter(name="propagateCommunity")
    def propagate_community(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Propagate Community - Default value: `false`
        """
        return pulumi.get(self, "propagate_community")

    @propagate_community.setter
    def propagate_community(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "propagate_community", value)

    @property
    @pulumi.getter(name="propagateCommunityVariable")
    def propagate_community_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "propagate_community_variable")

    @propagate_community_variable.setter
    def propagate_community_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "propagate_community_variable", value)

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure BGP router identifier
        """
        return pulumi.get(self, "router_id")

    @router_id.setter
    def router_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_id", value)

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @router_id_variable.setter
    def router_id_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router_id_variable", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable or disable BGP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/ciscoBgpFeatureTemplate:CiscoBgpFeatureTemplate")
class CiscoBgpFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateAddressFamilyArgs', 'CiscoBgpFeatureTemplateAddressFamilyArgsDict']]]]] = None,
                 always_compare_med: Optional[pulumi.Input[builtins.bool]] = None,
                 always_compare_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 as_number: Optional[pulumi.Input[builtins.str]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 compare_router_id: Optional[pulumi.Input[builtins.bool]] = None,
                 compare_router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 deterministic_med: Optional[pulumi.Input[builtins.bool]] = None,
                 deterministic_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 distance_external: Optional[pulumi.Input[builtins.int]] = None,
                 distance_external_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_internal: Optional[pulumi.Input[builtins.int]] = None,
                 distance_internal_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_local: Optional[pulumi.Input[builtins.int]] = None,
                 distance_local_variable: Optional[pulumi.Input[builtins.str]] = None,
                 holdtime: Optional[pulumi.Input[builtins.int]] = None,
                 holdtime_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4NeighborArgs', 'CiscoBgpFeatureTemplateIpv4NeighborArgsDict']]]]] = None,
                 ipv4_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv4RouteTargetArgsDict']]]]] = None,
                 ipv6_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6NeighborArgs', 'CiscoBgpFeatureTemplateIpv6NeighborArgsDict']]]]] = None,
                 ipv6_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv6RouteTargetArgsDict']]]]] = None,
                 keepalive: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_variable: Optional[pulumi.Input[builtins.str]] = None,
                 missing_med_worst: Optional[pulumi.Input[builtins.bool]] = None,
                 missing_med_worst_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mpls_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateMplsInterfaceArgs', 'CiscoBgpFeatureTemplateMplsInterfaceArgsDict']]]]] = None,
                 multipath_relax: Optional[pulumi.Input[builtins.bool]] = None,
                 multipath_relax_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_aspath: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_aspath_variable: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_community: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_community_variable: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco BGP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoBgpFeatureTemplate:CiscoBgpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateAddressFamilyArgs', 'CiscoBgpFeatureTemplateAddressFamilyArgsDict']]]] address_families: Set BGP address family
        :param pulumi.Input[builtins.bool] always_compare_med: Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] always_compare_med_variable: Variable name
        :param pulumi.Input[builtins.str] as_number: Set autonomous system number <1..4294967295> or <XX.YY>
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.bool] compare_router_id: Compare router IDs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] compare_router_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[builtins.bool] deterministic_med: Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] deterministic_med_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.int] distance_external: Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_external_variable: Variable name
        :param pulumi.Input[builtins.int] distance_internal: Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        :param pulumi.Input[builtins.str] distance_internal_variable: Variable name
        :param pulumi.Input[builtins.int] distance_local: Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_local_variable: Variable name
        :param pulumi.Input[builtins.int] holdtime: Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        :param pulumi.Input[builtins.str] holdtime_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4NeighborArgs', 'CiscoBgpFeatureTemplateIpv4NeighborArgsDict']]]] ipv4_neighbors: Set BGP neighbors
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv4RouteTargetArgsDict']]]] ipv4_route_targets: Router Target for IPV4
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6NeighborArgs', 'CiscoBgpFeatureTemplateIpv6NeighborArgsDict']]]] ipv6_neighbors: Set BGP IPv6 neighbors
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv6RouteTargetArgsDict']]]] ipv6_route_targets: Router Target for IPV6
        :param pulumi.Input[builtins.int] keepalive: Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        :param pulumi.Input[builtins.str] keepalive_variable: Variable name
        :param pulumi.Input[builtins.bool] missing_med_worst: If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] missing_med_worst_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateMplsInterfaceArgs', 'CiscoBgpFeatureTemplateMplsInterfaceArgsDict']]]] mpls_interfaces: MPLS BGP Interface
        :param pulumi.Input[builtins.bool] multipath_relax: Ignore AS for multipath selection - Default value: `false`
        :param pulumi.Input[builtins.str] multipath_relax_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] propagate_aspath: Propagate AS Path - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_aspath_variable: Variable name
        :param pulumi.Input[builtins.bool] propagate_community: Propagate Community - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_community_variable: Variable name
        :param pulumi.Input[builtins.str] router_id: Configure BGP router identifier
        :param pulumi.Input[builtins.str] router_id_variable: Variable name
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable BGP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoBgpFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco BGP feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoBgpFeatureTemplate:CiscoBgpFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoBgpFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoBgpFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateAddressFamilyArgs', 'CiscoBgpFeatureTemplateAddressFamilyArgsDict']]]]] = None,
                 always_compare_med: Optional[pulumi.Input[builtins.bool]] = None,
                 always_compare_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 as_number: Optional[pulumi.Input[builtins.str]] = None,
                 as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
                 compare_router_id: Optional[pulumi.Input[builtins.bool]] = None,
                 compare_router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 deterministic_med: Optional[pulumi.Input[builtins.bool]] = None,
                 deterministic_med_variable: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 distance_external: Optional[pulumi.Input[builtins.int]] = None,
                 distance_external_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_internal: Optional[pulumi.Input[builtins.int]] = None,
                 distance_internal_variable: Optional[pulumi.Input[builtins.str]] = None,
                 distance_local: Optional[pulumi.Input[builtins.int]] = None,
                 distance_local_variable: Optional[pulumi.Input[builtins.str]] = None,
                 holdtime: Optional[pulumi.Input[builtins.int]] = None,
                 holdtime_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4NeighborArgs', 'CiscoBgpFeatureTemplateIpv4NeighborArgsDict']]]]] = None,
                 ipv4_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv4RouteTargetArgsDict']]]]] = None,
                 ipv6_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6NeighborArgs', 'CiscoBgpFeatureTemplateIpv6NeighborArgsDict']]]]] = None,
                 ipv6_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv6RouteTargetArgsDict']]]]] = None,
                 keepalive: Optional[pulumi.Input[builtins.int]] = None,
                 keepalive_variable: Optional[pulumi.Input[builtins.str]] = None,
                 missing_med_worst: Optional[pulumi.Input[builtins.bool]] = None,
                 missing_med_worst_variable: Optional[pulumi.Input[builtins.str]] = None,
                 mpls_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateMplsInterfaceArgs', 'CiscoBgpFeatureTemplateMplsInterfaceArgsDict']]]]] = None,
                 multipath_relax: Optional[pulumi.Input[builtins.bool]] = None,
                 multipath_relax_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_aspath: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_aspath_variable: Optional[pulumi.Input[builtins.str]] = None,
                 propagate_community: Optional[pulumi.Input[builtins.bool]] = None,
                 propagate_community_variable: Optional[pulumi.Input[builtins.str]] = None,
                 router_id: Optional[pulumi.Input[builtins.str]] = None,
                 router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoBgpFeatureTemplateArgs.__new__(CiscoBgpFeatureTemplateArgs)

            __props__.__dict__["address_families"] = address_families
            __props__.__dict__["always_compare_med"] = always_compare_med
            __props__.__dict__["always_compare_med_variable"] = always_compare_med_variable
            __props__.__dict__["as_number"] = as_number
            __props__.__dict__["as_number_variable"] = as_number_variable
            __props__.__dict__["compare_router_id"] = compare_router_id
            __props__.__dict__["compare_router_id_variable"] = compare_router_id_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["deterministic_med"] = deterministic_med
            __props__.__dict__["deterministic_med_variable"] = deterministic_med_variable
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["distance_external"] = distance_external
            __props__.__dict__["distance_external_variable"] = distance_external_variable
            __props__.__dict__["distance_internal"] = distance_internal
            __props__.__dict__["distance_internal_variable"] = distance_internal_variable
            __props__.__dict__["distance_local"] = distance_local
            __props__.__dict__["distance_local_variable"] = distance_local_variable
            __props__.__dict__["holdtime"] = holdtime
            __props__.__dict__["holdtime_variable"] = holdtime_variable
            __props__.__dict__["ipv4_neighbors"] = ipv4_neighbors
            __props__.__dict__["ipv4_route_targets"] = ipv4_route_targets
            __props__.__dict__["ipv6_neighbors"] = ipv6_neighbors
            __props__.__dict__["ipv6_route_targets"] = ipv6_route_targets
            __props__.__dict__["keepalive"] = keepalive
            __props__.__dict__["keepalive_variable"] = keepalive_variable
            __props__.__dict__["missing_med_worst"] = missing_med_worst
            __props__.__dict__["missing_med_worst_variable"] = missing_med_worst_variable
            __props__.__dict__["mpls_interfaces"] = mpls_interfaces
            __props__.__dict__["multipath_relax"] = multipath_relax
            __props__.__dict__["multipath_relax_variable"] = multipath_relax_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["propagate_aspath"] = propagate_aspath
            __props__.__dict__["propagate_aspath_variable"] = propagate_aspath_variable
            __props__.__dict__["propagate_community"] = propagate_community
            __props__.__dict__["propagate_community_variable"] = propagate_community_variable
            __props__.__dict__["router_id"] = router_id
            __props__.__dict__["router_id_variable"] = router_id_variable
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoBgpFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoBgpFeatureTemplate:CiscoBgpFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateAddressFamilyArgs', 'CiscoBgpFeatureTemplateAddressFamilyArgsDict']]]]] = None,
            always_compare_med: Optional[pulumi.Input[builtins.bool]] = None,
            always_compare_med_variable: Optional[pulumi.Input[builtins.str]] = None,
            as_number: Optional[pulumi.Input[builtins.str]] = None,
            as_number_variable: Optional[pulumi.Input[builtins.str]] = None,
            compare_router_id: Optional[pulumi.Input[builtins.bool]] = None,
            compare_router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            deterministic_med: Optional[pulumi.Input[builtins.bool]] = None,
            deterministic_med_variable: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            distance_external: Optional[pulumi.Input[builtins.int]] = None,
            distance_external_variable: Optional[pulumi.Input[builtins.str]] = None,
            distance_internal: Optional[pulumi.Input[builtins.int]] = None,
            distance_internal_variable: Optional[pulumi.Input[builtins.str]] = None,
            distance_local: Optional[pulumi.Input[builtins.int]] = None,
            distance_local_variable: Optional[pulumi.Input[builtins.str]] = None,
            holdtime: Optional[pulumi.Input[builtins.int]] = None,
            holdtime_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4NeighborArgs', 'CiscoBgpFeatureTemplateIpv4NeighborArgsDict']]]]] = None,
            ipv4_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv4RouteTargetArgsDict']]]]] = None,
            ipv6_neighbors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6NeighborArgs', 'CiscoBgpFeatureTemplateIpv6NeighborArgsDict']]]]] = None,
            ipv6_route_targets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv6RouteTargetArgsDict']]]]] = None,
            keepalive: Optional[pulumi.Input[builtins.int]] = None,
            keepalive_variable: Optional[pulumi.Input[builtins.str]] = None,
            missing_med_worst: Optional[pulumi.Input[builtins.bool]] = None,
            missing_med_worst_variable: Optional[pulumi.Input[builtins.str]] = None,
            mpls_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateMplsInterfaceArgs', 'CiscoBgpFeatureTemplateMplsInterfaceArgsDict']]]]] = None,
            multipath_relax: Optional[pulumi.Input[builtins.bool]] = None,
            multipath_relax_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            propagate_aspath: Optional[pulumi.Input[builtins.bool]] = None,
            propagate_aspath_variable: Optional[pulumi.Input[builtins.str]] = None,
            propagate_community: Optional[pulumi.Input[builtins.bool]] = None,
            propagate_community_variable: Optional[pulumi.Input[builtins.str]] = None,
            router_id: Optional[pulumi.Input[builtins.str]] = None,
            router_id_variable: Optional[pulumi.Input[builtins.str]] = None,
            shutdown: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CiscoBgpFeatureTemplate':
        """
        Get an existing CiscoBgpFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateAddressFamilyArgs', 'CiscoBgpFeatureTemplateAddressFamilyArgsDict']]]] address_families: Set BGP address family
        :param pulumi.Input[builtins.bool] always_compare_med: Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] always_compare_med_variable: Variable name
        :param pulumi.Input[builtins.str] as_number: Set autonomous system number <1..4294967295> or <XX.YY>
        :param pulumi.Input[builtins.str] as_number_variable: Variable name
        :param pulumi.Input[builtins.bool] compare_router_id: Compare router IDs when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] compare_router_id_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[builtins.bool] deterministic_med: Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] deterministic_med_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.int] distance_external: Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_external_variable: Variable name
        :param pulumi.Input[builtins.int] distance_internal: Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        :param pulumi.Input[builtins.str] distance_internal_variable: Variable name
        :param pulumi.Input[builtins.int] distance_local: Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        :param pulumi.Input[builtins.str] distance_local_variable: Variable name
        :param pulumi.Input[builtins.int] holdtime: Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        :param pulumi.Input[builtins.str] holdtime_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4NeighborArgs', 'CiscoBgpFeatureTemplateIpv4NeighborArgsDict']]]] ipv4_neighbors: Set BGP neighbors
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv4RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv4RouteTargetArgsDict']]]] ipv4_route_targets: Router Target for IPV4
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6NeighborArgs', 'CiscoBgpFeatureTemplateIpv6NeighborArgsDict']]]] ipv6_neighbors: Set BGP IPv6 neighbors
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateIpv6RouteTargetArgs', 'CiscoBgpFeatureTemplateIpv6RouteTargetArgsDict']]]] ipv6_route_targets: Router Target for IPV6
        :param pulumi.Input[builtins.int] keepalive: Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        :param pulumi.Input[builtins.str] keepalive_variable: Variable name
        :param pulumi.Input[builtins.bool] missing_med_worst: If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        :param pulumi.Input[builtins.str] missing_med_worst_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoBgpFeatureTemplateMplsInterfaceArgs', 'CiscoBgpFeatureTemplateMplsInterfaceArgsDict']]]] mpls_interfaces: MPLS BGP Interface
        :param pulumi.Input[builtins.bool] multipath_relax: Ignore AS for multipath selection - Default value: `false`
        :param pulumi.Input[builtins.str] multipath_relax_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.bool] propagate_aspath: Propagate AS Path - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_aspath_variable: Variable name
        :param pulumi.Input[builtins.bool] propagate_community: Propagate Community - Default value: `false`
        :param pulumi.Input[builtins.str] propagate_community_variable: Variable name
        :param pulumi.Input[builtins.str] router_id: Configure BGP router identifier
        :param pulumi.Input[builtins.str] router_id_variable: Variable name
        :param pulumi.Input[builtins.bool] shutdown: Enable or disable BGP - Default value: `false`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoBgpFeatureTemplateState.__new__(_CiscoBgpFeatureTemplateState)

        __props__.__dict__["address_families"] = address_families
        __props__.__dict__["always_compare_med"] = always_compare_med
        __props__.__dict__["always_compare_med_variable"] = always_compare_med_variable
        __props__.__dict__["as_number"] = as_number
        __props__.__dict__["as_number_variable"] = as_number_variable
        __props__.__dict__["compare_router_id"] = compare_router_id
        __props__.__dict__["compare_router_id_variable"] = compare_router_id_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["deterministic_med"] = deterministic_med
        __props__.__dict__["deterministic_med_variable"] = deterministic_med_variable
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["distance_external"] = distance_external
        __props__.__dict__["distance_external_variable"] = distance_external_variable
        __props__.__dict__["distance_internal"] = distance_internal
        __props__.__dict__["distance_internal_variable"] = distance_internal_variable
        __props__.__dict__["distance_local"] = distance_local
        __props__.__dict__["distance_local_variable"] = distance_local_variable
        __props__.__dict__["holdtime"] = holdtime
        __props__.__dict__["holdtime_variable"] = holdtime_variable
        __props__.__dict__["ipv4_neighbors"] = ipv4_neighbors
        __props__.__dict__["ipv4_route_targets"] = ipv4_route_targets
        __props__.__dict__["ipv6_neighbors"] = ipv6_neighbors
        __props__.__dict__["ipv6_route_targets"] = ipv6_route_targets
        __props__.__dict__["keepalive"] = keepalive
        __props__.__dict__["keepalive_variable"] = keepalive_variable
        __props__.__dict__["missing_med_worst"] = missing_med_worst
        __props__.__dict__["missing_med_worst_variable"] = missing_med_worst_variable
        __props__.__dict__["mpls_interfaces"] = mpls_interfaces
        __props__.__dict__["multipath_relax"] = multipath_relax
        __props__.__dict__["multipath_relax_variable"] = multipath_relax_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["propagate_aspath"] = propagate_aspath
        __props__.__dict__["propagate_aspath_variable"] = propagate_aspath_variable
        __props__.__dict__["propagate_community"] = propagate_community
        __props__.__dict__["propagate_community_variable"] = propagate_community_variable
        __props__.__dict__["router_id"] = router_id
        __props__.__dict__["router_id_variable"] = router_id_variable
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return CiscoBgpFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressFamilies")
    def address_families(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBgpFeatureTemplateAddressFamily']]]:
        """
        Set BGP address family
        """
        return pulumi.get(self, "address_families")

    @property
    @pulumi.getter(name="alwaysCompareMed")
    def always_compare_med(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Compare MEDs from all ASs when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "always_compare_med")

    @property
    @pulumi.getter(name="alwaysCompareMedVariable")
    def always_compare_med_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "always_compare_med_variable")

    @property
    @pulumi.getter(name="asNumber")
    def as_number(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set autonomous system number <1..4294967295> or <XX.YY>
        """
        return pulumi.get(self, "as_number")

    @property
    @pulumi.getter(name="asNumberVariable")
    def as_number_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "as_number_variable")

    @property
    @pulumi.getter(name="compareRouterId")
    def compare_router_id(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Compare router IDs when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "compare_router_id")

    @property
    @pulumi.getter(name="compareRouterIdVariable")
    def compare_router_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "compare_router_id_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deterministicMed")
    def deterministic_med(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Compare MEDs from all routes from same AS when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "deterministic_med")

    @property
    @pulumi.getter(name="deterministicMedVariable")
    def deterministic_med_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "deterministic_med_variable")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="distanceExternal")
    def distance_external(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set administrative distance for external BGP routes - Range: `1`-`255` - Default value: `20`
        """
        return pulumi.get(self, "distance_external")

    @property
    @pulumi.getter(name="distanceExternalVariable")
    def distance_external_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_external_variable")

    @property
    @pulumi.getter(name="distanceInternal")
    def distance_internal(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set administrative distance for internal BGP routes - Range: `1`-`255` - Default value: `200`
        """
        return pulumi.get(self, "distance_internal")

    @property
    @pulumi.getter(name="distanceInternalVariable")
    def distance_internal_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_internal_variable")

    @property
    @pulumi.getter(name="distanceLocal")
    def distance_local(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set administrative distance for local BGP routes - Range: `1`-`255` - Default value: `20`
        """
        return pulumi.get(self, "distance_local")

    @property
    @pulumi.getter(name="distanceLocalVariable")
    def distance_local_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "distance_local_variable")

    @property
    @pulumi.getter
    def holdtime(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set the interval when BGP considers a neighbor to be down - Range: `0`-`65535` - Default value: `180`
        """
        return pulumi.get(self, "holdtime")

    @property
    @pulumi.getter(name="holdtimeVariable")
    def holdtime_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "holdtime_variable")

    @property
    @pulumi.getter(name="ipv4Neighbors")
    def ipv4_neighbors(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBgpFeatureTemplateIpv4Neighbor']]]:
        """
        Set BGP neighbors
        """
        return pulumi.get(self, "ipv4_neighbors")

    @property
    @pulumi.getter(name="ipv4RouteTargets")
    def ipv4_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBgpFeatureTemplateIpv4RouteTarget']]]:
        """
        Router Target for IPV4
        """
        return pulumi.get(self, "ipv4_route_targets")

    @property
    @pulumi.getter(name="ipv6Neighbors")
    def ipv6_neighbors(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBgpFeatureTemplateIpv6Neighbor']]]:
        """
        Set BGP IPv6 neighbors
        """
        return pulumi.get(self, "ipv6_neighbors")

    @property
    @pulumi.getter(name="ipv6RouteTargets")
    def ipv6_route_targets(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBgpFeatureTemplateIpv6RouteTarget']]]:
        """
        Router Target for IPV6
        """
        return pulumi.get(self, "ipv6_route_targets")

    @property
    @pulumi.getter
    def keepalive(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set how often keepalive messages are sent to BGP peer - Range: `0`-`65535` - Default value: `60`
        """
        return pulumi.get(self, "keepalive")

    @property
    @pulumi.getter(name="keepaliveVariable")
    def keepalive_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "keepalive_variable")

    @property
    @pulumi.getter(name="missingMedWorst")
    def missing_med_worst(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If path has no MED, consider it to be worst path when selecting active BGP paths - Default value: `false`
        """
        return pulumi.get(self, "missing_med_worst")

    @property
    @pulumi.getter(name="missingMedWorstVariable")
    def missing_med_worst_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "missing_med_worst_variable")

    @property
    @pulumi.getter(name="mplsInterfaces")
    def mpls_interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoBgpFeatureTemplateMplsInterface']]]:
        """
        MPLS BGP Interface
        """
        return pulumi.get(self, "mpls_interfaces")

    @property
    @pulumi.getter(name="multipathRelax")
    def multipath_relax(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Ignore AS for multipath selection - Default value: `false`
        """
        return pulumi.get(self, "multipath_relax")

    @property
    @pulumi.getter(name="multipathRelaxVariable")
    def multipath_relax_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multipath_relax_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="propagateAspath")
    def propagate_aspath(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Propagate AS Path - Default value: `false`
        """
        return pulumi.get(self, "propagate_aspath")

    @property
    @pulumi.getter(name="propagateAspathVariable")
    def propagate_aspath_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "propagate_aspath_variable")

    @property
    @pulumi.getter(name="propagateCommunity")
    def propagate_community(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Propagate Community - Default value: `false`
        """
        return pulumi.get(self, "propagate_community")

    @property
    @pulumi.getter(name="propagateCommunityVariable")
    def propagate_community_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "propagate_community_variable")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Configure BGP router identifier
        """
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter(name="routerIdVariable")
    def router_id_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "router_id_variable")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable or disable BGP - Default value: `false`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

