# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CiscoDhcpServerFeatureTemplateArgs', 'CiscoDhcpServerFeatureTemplate']

@pulumi.input_type
class CiscoDhcpServerFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 address_pool: Optional[pulumi.Input[builtins.str]] = None,
                 address_pool_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 exclude_addresses_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CiscoDhcpServerFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.str] address_pool: Configure IPv4 prefix range of the DHCP address pool
        :param pulumi.Input[builtins.str] address_pool_variable: Variable name
        :param pulumi.Input[builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude_addresses: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[builtins.str] exclude_addresses_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Set MTU on interface to DHCP client - Range: `68`-`65535`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        :param pulumi.Input[builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]] options: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]] static_leases: Configure static IP addresses
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[builtins.str] tftp_servers_variable: Variable name
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if address_pool is not None:
            pulumi.set(__self__, "address_pool", address_pool)
        if address_pool_variable is not None:
            pulumi.set(__self__, "address_pool_variable", address_pool_variable)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable is not None:
            pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if dns_servers_variable is not None:
            pulumi.set(__self__, "dns_servers_variable", dns_servers_variable)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_name_variable is not None:
            pulumi.set(__self__, "domain_name_variable", domain_name_variable)
        if exclude_addresses is not None:
            pulumi.set(__self__, "exclude_addresses", exclude_addresses)
        if exclude_addresses_variable is not None:
            pulumi.set(__self__, "exclude_addresses_variable", exclude_addresses_variable)
        if interface_mtu is not None:
            pulumi.set(__self__, "interface_mtu", interface_mtu)
        if interface_mtu_variable is not None:
            pulumi.set(__self__, "interface_mtu_variable", interface_mtu_variable)
        if lease_time is not None:
            pulumi.set(__self__, "lease_time", lease_time)
        if lease_time_variable is not None:
            pulumi.set(__self__, "lease_time_variable", lease_time_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if static_leases is not None:
            pulumi.set(__self__, "static_leases", static_leases)
        if tftp_servers is not None:
            pulumi.set(__self__, "tftp_servers", tftp_servers)
        if tftp_servers_variable is not None:
            pulumi.set(__self__, "tftp_servers_variable", tftp_servers_variable)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="addressPool")
    def address_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure IPv4 prefix range of the DHCP address pool
        """
        return pulumi.get(self, "address_pool")

    @address_pool.setter
    def address_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_pool", value)

    @property
    @pulumi.getter(name="addressPoolVariable")
    def address_pool_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "address_pool_variable")

    @address_pool_variable.setter
    def address_pool_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_pool_variable", value)

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set IP address of default gateway
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_gateway", value)

    @property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @default_gateway_variable.setter
    def default_gateway_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_gateway_variable", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configure one or more DNS server IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="dnsServersVariable")
    def dns_servers_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dns_servers_variable")

    @dns_servers_variable.setter
    def dns_servers_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_servers_variable", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set domain name client uses to resolve hostnames
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainNameVariable")
    def domain_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "domain_name_variable")

    @domain_name_variable.setter
    def domain_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name_variable", value)

    @property
    @pulumi.getter(name="excludeAddresses")
    def exclude_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configure IPv4 address to exclude from DHCP address pool
        """
        return pulumi.get(self, "exclude_addresses")

    @exclude_addresses.setter
    def exclude_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exclude_addresses", value)

    @property
    @pulumi.getter(name="excludeAddressesVariable")
    def exclude_addresses_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "exclude_addresses_variable")

    @exclude_addresses_variable.setter
    def exclude_addresses_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exclude_addresses_variable", value)

    @property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set MTU on interface to DHCP client - Range: `68`-`65535`
        """
        return pulumi.get(self, "interface_mtu")

    @interface_mtu.setter
    def interface_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interface_mtu", value)

    @property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @interface_mtu_variable.setter
    def interface_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_mtu_variable", value)

    @property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        """
        return pulumi.get(self, "lease_time")

    @lease_time.setter
    def lease_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lease_time", value)

    @property
    @pulumi.getter(name="leaseTimeVariable")
    def lease_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "lease_time_variable")

    @lease_time_variable.setter
    def lease_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lease_time_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]]]:
        """
        Configure Options Code
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="staticLeases")
    def static_leases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]]]:
        """
        Configure static IP addresses
        """
        return pulumi.get(self, "static_leases")

    @static_leases.setter
    def static_leases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]]]):
        pulumi.set(self, "static_leases", value)

    @property
    @pulumi.getter(name="tftpServers")
    def tftp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configure TFTP server IP addresses
        """
        return pulumi.get(self, "tftp_servers")

    @tftp_servers.setter
    def tftp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tftp_servers", value)

    @property
    @pulumi.getter(name="tftpServersVariable")
    def tftp_servers_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tftp_servers_variable")

    @tftp_servers_variable.setter
    def tftp_servers_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tftp_servers_variable", value)


@pulumi.input_type
class _CiscoDhcpServerFeatureTemplateState:
    def __init__(__self__, *,
                 address_pool: Optional[pulumi.Input[builtins.str]] = None,
                 address_pool_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 exclude_addresses_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CiscoDhcpServerFeatureTemplate resources.
        :param pulumi.Input[builtins.str] address_pool: Configure IPv4 prefix range of the DHCP address pool
        :param pulumi.Input[builtins.str] address_pool_variable: Variable name
        :param pulumi.Input[builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude_addresses: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[builtins.str] exclude_addresses_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Set MTU on interface to DHCP client - Range: `68`-`65535`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        :param pulumi.Input[builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]] options: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]] static_leases: Configure static IP addresses
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[builtins.str] tftp_servers_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if address_pool is not None:
            pulumi.set(__self__, "address_pool", address_pool)
        if address_pool_variable is not None:
            pulumi.set(__self__, "address_pool_variable", address_pool_variable)
        if default_gateway is not None:
            pulumi.set(__self__, "default_gateway", default_gateway)
        if default_gateway_variable is not None:
            pulumi.set(__self__, "default_gateway_variable", default_gateway_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if dns_servers_variable is not None:
            pulumi.set(__self__, "dns_servers_variable", dns_servers_variable)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if domain_name_variable is not None:
            pulumi.set(__self__, "domain_name_variable", domain_name_variable)
        if exclude_addresses is not None:
            pulumi.set(__self__, "exclude_addresses", exclude_addresses)
        if exclude_addresses_variable is not None:
            pulumi.set(__self__, "exclude_addresses_variable", exclude_addresses_variable)
        if interface_mtu is not None:
            pulumi.set(__self__, "interface_mtu", interface_mtu)
        if interface_mtu_variable is not None:
            pulumi.set(__self__, "interface_mtu_variable", interface_mtu_variable)
        if lease_time is not None:
            pulumi.set(__self__, "lease_time", lease_time)
        if lease_time_variable is not None:
            pulumi.set(__self__, "lease_time_variable", lease_time_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if static_leases is not None:
            pulumi.set(__self__, "static_leases", static_leases)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if tftp_servers is not None:
            pulumi.set(__self__, "tftp_servers", tftp_servers)
        if tftp_servers_variable is not None:
            pulumi.set(__self__, "tftp_servers_variable", tftp_servers_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="addressPool")
    def address_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure IPv4 prefix range of the DHCP address pool
        """
        return pulumi.get(self, "address_pool")

    @address_pool.setter
    def address_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_pool", value)

    @property
    @pulumi.getter(name="addressPoolVariable")
    def address_pool_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "address_pool_variable")

    @address_pool_variable.setter
    def address_pool_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_pool_variable", value)

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set IP address of default gateway
        """
        return pulumi.get(self, "default_gateway")

    @default_gateway.setter
    def default_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_gateway", value)

    @property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @default_gateway_variable.setter
    def default_gateway_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_gateway_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configure one or more DNS server IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @dns_servers.setter
    def dns_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dns_servers", value)

    @property
    @pulumi.getter(name="dnsServersVariable")
    def dns_servers_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dns_servers_variable")

    @dns_servers_variable.setter
    def dns_servers_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_servers_variable", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set domain name client uses to resolve hostnames
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="domainNameVariable")
    def domain_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "domain_name_variable")

    @domain_name_variable.setter
    def domain_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_name_variable", value)

    @property
    @pulumi.getter(name="excludeAddresses")
    def exclude_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configure IPv4 address to exclude from DHCP address pool
        """
        return pulumi.get(self, "exclude_addresses")

    @exclude_addresses.setter
    def exclude_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "exclude_addresses", value)

    @property
    @pulumi.getter(name="excludeAddressesVariable")
    def exclude_addresses_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "exclude_addresses_variable")

    @exclude_addresses_variable.setter
    def exclude_addresses_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exclude_addresses_variable", value)

    @property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set MTU on interface to DHCP client - Range: `68`-`65535`
        """
        return pulumi.get(self, "interface_mtu")

    @interface_mtu.setter
    def interface_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interface_mtu", value)

    @property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @interface_mtu_variable.setter
    def interface_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_mtu_variable", value)

    @property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        """
        return pulumi.get(self, "lease_time")

    @lease_time.setter
    def lease_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "lease_time", value)

    @property
    @pulumi.getter(name="leaseTimeVariable")
    def lease_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "lease_time_variable")

    @lease_time_variable.setter
    def lease_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lease_time_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]]]:
        """
        Configure Options Code
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="staticLeases")
    def static_leases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]]]:
        """
        Configure static IP addresses
        """
        return pulumi.get(self, "static_leases")

    @static_leases.setter
    def static_leases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CiscoDhcpServerFeatureTemplateStaticLeaseArgs']]]]):
        pulumi.set(self, "static_leases", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="tftpServers")
    def tftp_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Configure TFTP server IP addresses
        """
        return pulumi.get(self, "tftp_servers")

    @tftp_servers.setter
    def tftp_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tftp_servers", value)

    @property
    @pulumi.getter(name="tftpServersVariable")
    def tftp_servers_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tftp_servers_variable")

    @tftp_servers_variable.setter
    def tftp_servers_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tftp_servers_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/ciscoDhcpServerFeatureTemplate:CiscoDhcpServerFeatureTemplate")
class CiscoDhcpServerFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_pool: Optional[pulumi.Input[builtins.str]] = None,
                 address_pool_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 exclude_addresses_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateOptionArgs', 'CiscoDhcpServerFeatureTemplateOptionArgsDict']]]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateStaticLeaseArgs', 'CiscoDhcpServerFeatureTemplateStaticLeaseArgsDict']]]]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Cisco DHCP Server feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoDhcpServerFeatureTemplate:CiscoDhcpServerFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_pool: Configure IPv4 prefix range of the DHCP address pool
        :param pulumi.Input[builtins.str] address_pool_variable: Variable name
        :param pulumi.Input[builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude_addresses: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[builtins.str] exclude_addresses_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Set MTU on interface to DHCP client - Range: `68`-`65535`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        :param pulumi.Input[builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateOptionArgs', 'CiscoDhcpServerFeatureTemplateOptionArgsDict']]]] options: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateStaticLeaseArgs', 'CiscoDhcpServerFeatureTemplateStaticLeaseArgsDict']]]] static_leases: Configure static IP addresses
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[builtins.str] tftp_servers_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CiscoDhcpServerFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Cisco DHCP Server feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/ciscoDhcpServerFeatureTemplate:CiscoDhcpServerFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param CiscoDhcpServerFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CiscoDhcpServerFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_pool: Optional[pulumi.Input[builtins.str]] = None,
                 address_pool_variable: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dns_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name: Optional[pulumi.Input[builtins.str]] = None,
                 domain_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 exclude_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 exclude_addresses_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 lease_time: Optional[pulumi.Input[builtins.int]] = None,
                 lease_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateOptionArgs', 'CiscoDhcpServerFeatureTemplateOptionArgsDict']]]]] = None,
                 static_leases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateStaticLeaseArgs', 'CiscoDhcpServerFeatureTemplateStaticLeaseArgsDict']]]]] = None,
                 tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tftp_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CiscoDhcpServerFeatureTemplateArgs.__new__(CiscoDhcpServerFeatureTemplateArgs)

            __props__.__dict__["address_pool"] = address_pool
            __props__.__dict__["address_pool_variable"] = address_pool_variable
            __props__.__dict__["default_gateway"] = default_gateway
            __props__.__dict__["default_gateway_variable"] = default_gateway_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["dns_servers"] = dns_servers
            __props__.__dict__["dns_servers_variable"] = dns_servers_variable
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["domain_name_variable"] = domain_name_variable
            __props__.__dict__["exclude_addresses"] = exclude_addresses
            __props__.__dict__["exclude_addresses_variable"] = exclude_addresses_variable
            __props__.__dict__["interface_mtu"] = interface_mtu
            __props__.__dict__["interface_mtu_variable"] = interface_mtu_variable
            __props__.__dict__["lease_time"] = lease_time
            __props__.__dict__["lease_time_variable"] = lease_time_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["static_leases"] = static_leases
            __props__.__dict__["tftp_servers"] = tftp_servers
            __props__.__dict__["tftp_servers_variable"] = tftp_servers_variable
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(CiscoDhcpServerFeatureTemplate, __self__).__init__(
            'sdwan:index/ciscoDhcpServerFeatureTemplate:CiscoDhcpServerFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_pool: Optional[pulumi.Input[builtins.str]] = None,
            address_pool_variable: Optional[pulumi.Input[builtins.str]] = None,
            default_gateway: Optional[pulumi.Input[builtins.str]] = None,
            default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            dns_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            dns_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
            domain_name: Optional[pulumi.Input[builtins.str]] = None,
            domain_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            exclude_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            exclude_addresses_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
            interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
            lease_time: Optional[pulumi.Input[builtins.int]] = None,
            lease_time_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateOptionArgs', 'CiscoDhcpServerFeatureTemplateOptionArgsDict']]]]] = None,
            static_leases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateStaticLeaseArgs', 'CiscoDhcpServerFeatureTemplateStaticLeaseArgsDict']]]]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            tftp_servers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tftp_servers_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'CiscoDhcpServerFeatureTemplate':
        """
        Get an existing CiscoDhcpServerFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address_pool: Configure IPv4 prefix range of the DHCP address pool
        :param pulumi.Input[builtins.str] address_pool_variable: Variable name
        :param pulumi.Input[builtins.str] default_gateway: Set IP address of default gateway
        :param pulumi.Input[builtins.str] default_gateway_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] dns_servers: Configure one or more DNS server IP addresses
        :param pulumi.Input[builtins.str] dns_servers_variable: Variable name
        :param pulumi.Input[builtins.str] domain_name: Set domain name client uses to resolve hostnames
        :param pulumi.Input[builtins.str] domain_name_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] exclude_addresses: Configure IPv4 address to exclude from DHCP address pool
        :param pulumi.Input[builtins.str] exclude_addresses_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Set MTU on interface to DHCP client - Range: `68`-`65535`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.int] lease_time: Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        :param pulumi.Input[builtins.str] lease_time_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateOptionArgs', 'CiscoDhcpServerFeatureTemplateOptionArgsDict']]]] options: Configure Options Code
        :param pulumi.Input[Sequence[pulumi.Input[Union['CiscoDhcpServerFeatureTemplateStaticLeaseArgs', 'CiscoDhcpServerFeatureTemplateStaticLeaseArgsDict']]]] static_leases: Configure static IP addresses
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tftp_servers: Configure TFTP server IP addresses
        :param pulumi.Input[builtins.str] tftp_servers_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CiscoDhcpServerFeatureTemplateState.__new__(_CiscoDhcpServerFeatureTemplateState)

        __props__.__dict__["address_pool"] = address_pool
        __props__.__dict__["address_pool_variable"] = address_pool_variable
        __props__.__dict__["default_gateway"] = default_gateway
        __props__.__dict__["default_gateway_variable"] = default_gateway_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["dns_servers"] = dns_servers
        __props__.__dict__["dns_servers_variable"] = dns_servers_variable
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["domain_name_variable"] = domain_name_variable
        __props__.__dict__["exclude_addresses"] = exclude_addresses
        __props__.__dict__["exclude_addresses_variable"] = exclude_addresses_variable
        __props__.__dict__["interface_mtu"] = interface_mtu
        __props__.__dict__["interface_mtu_variable"] = interface_mtu_variable
        __props__.__dict__["lease_time"] = lease_time
        __props__.__dict__["lease_time_variable"] = lease_time_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["static_leases"] = static_leases
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["tftp_servers"] = tftp_servers
        __props__.__dict__["tftp_servers_variable"] = tftp_servers_variable
        __props__.__dict__["version"] = version
        return CiscoDhcpServerFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressPool")
    def address_pool(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Configure IPv4 prefix range of the DHCP address pool
        """
        return pulumi.get(self, "address_pool")

    @property
    @pulumi.getter(name="addressPoolVariable")
    def address_pool_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "address_pool_variable")

    @property
    @pulumi.getter(name="defaultGateway")
    def default_gateway(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set IP address of default gateway
        """
        return pulumi.get(self, "default_gateway")

    @property
    @pulumi.getter(name="defaultGatewayVariable")
    def default_gateway_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_gateway_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Configure one or more DNS server IP addresses
        """
        return pulumi.get(self, "dns_servers")

    @property
    @pulumi.getter(name="dnsServersVariable")
    def dns_servers_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "dns_servers_variable")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set domain name client uses to resolve hostnames
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainNameVariable")
    def domain_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "domain_name_variable")

    @property
    @pulumi.getter(name="excludeAddresses")
    def exclude_addresses(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Configure IPv4 address to exclude from DHCP address pool
        """
        return pulumi.get(self, "exclude_addresses")

    @property
    @pulumi.getter(name="excludeAddressesVariable")
    def exclude_addresses_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "exclude_addresses_variable")

    @property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set MTU on interface to DHCP client - Range: `68`-`65535`
        """
        return pulumi.get(self, "interface_mtu")

    @property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @property
    @pulumi.getter(name="leaseTime")
    def lease_time(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Configure how long a DHCP-assigned IP address is valid - Range: `60`-`31536000` - Default value: `86400`
        """
        return pulumi.get(self, "lease_time")

    @property
    @pulumi.getter(name="leaseTimeVariable")
    def lease_time_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "lease_time_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoDhcpServerFeatureTemplateOption']]]:
        """
        Configure Options Code
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="staticLeases")
    def static_leases(self) -> pulumi.Output[Optional[Sequence['outputs.CiscoDhcpServerFeatureTemplateStaticLease']]]:
        """
        Configure static IP addresses
        """
        return pulumi.get(self, "static_leases")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="tftpServers")
    def tftp_servers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Configure TFTP server IP addresses
        """
        return pulumi.get(self, "tftp_servers")

    @property
    @pulumi.getter(name="tftpServersVariable")
    def tftp_servers_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tftp_servers_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

