# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ClassMapPolicyObjectArgs', 'ClassMapPolicyObject']

@pulumi.input_type
class ClassMapPolicyObjectArgs:
    def __init__(__self__, *,
                 queue: pulumi.Input[builtins.int],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ClassMapPolicyObject resource.
        :param pulumi.Input[builtins.int] queue: Queue - Range: `0`-`7`
        :param pulumi.Input[builtins.str] name: The name of the policy object
        """
        pulumi.set(__self__, "queue", queue)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Input[builtins.int]:
        """
        Queue - Range: `0`-`7`
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ClassMapPolicyObjectState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queue: Optional[pulumi.Input[builtins.int]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ClassMapPolicyObject resources.
        :param pulumi.Input[builtins.str] name: The name of the policy object
        :param pulumi.Input[builtins.int] queue: Queue - Range: `0`-`7`
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queue is not None:
            pulumi.set(__self__, "queue", queue)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def queue(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Queue - Range: `0`-`7`
        """
        return pulumi.get(self, "queue")

    @queue.setter
    def queue(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "queue", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/classMapPolicyObject:ClassMapPolicyObject")
class ClassMapPolicyObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queue: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource can manage a Class Map Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ClassMapPolicyObject("example",
            name="Example",
            queue=2)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/classMapPolicyObject:ClassMapPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the policy object
        :param pulumi.Input[builtins.int] queue: Queue - Range: `0`-`7`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClassMapPolicyObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Class Map Policy Object .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.ClassMapPolicyObject("example",
            name="Example",
            queue=2)
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/classMapPolicyObject:ClassMapPolicyObject example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param ClassMapPolicyObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClassMapPolicyObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 queue: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClassMapPolicyObjectArgs.__new__(ClassMapPolicyObjectArgs)

            __props__.__dict__["name"] = name
            if queue is None and not opts.urn:
                raise TypeError("Missing required property 'queue'")
            __props__.__dict__["queue"] = queue
            __props__.__dict__["version"] = None
        super(ClassMapPolicyObject, __self__).__init__(
            'sdwan:index/classMapPolicyObject:ClassMapPolicyObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            queue: Optional[pulumi.Input[builtins.int]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ClassMapPolicyObject':
        """
        Get an existing ClassMapPolicyObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the policy object
        :param pulumi.Input[builtins.int] queue: Queue - Range: `0`-`7`
        :param pulumi.Input[builtins.int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClassMapPolicyObjectState.__new__(_ClassMapPolicyObjectState)

        __props__.__dict__["name"] = name
        __props__.__dict__["queue"] = queue
        __props__.__dict__["version"] = version
        return ClassMapPolicyObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the policy object
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Output[builtins.int]:
        """
        Queue - Range: `0`-`7`
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

