# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DnsSecurityPolicyArgs', 'DnsSecurityPolicy']

@pulumi.input_type
class DnsSecurityPolicyArgs:
    def __init__(__self__, *,
                 child_org_id: pulumi.Input[builtins.str],
                 dns_crypt: pulumi.Input[builtins.bool],
                 dns_server_ip: pulumi.Input[builtins.str],
                 feature_profile_id: pulumi.Input[builtins.str],
                 local_domain_bypass_enabled: pulumi.Input[builtins.bool],
                 local_domain_bypass_list_id: pulumi.Input[builtins.str],
                 match_all_vpn: pulumi.Input[builtins.bool],
                 umbrella_default: pulumi.Input[builtins.bool],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]]] = None):
        """
        The set of arguments for constructing a DnsSecurityPolicy resource.
        :param pulumi.Input[builtins.str] child_org_id: String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        :param pulumi.Input[builtins.bool] dns_crypt: If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        :param pulumi.Input[builtins.str] dns_server_ip: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.bool] match_all_vpn: If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        :param pulumi.Input[builtins.bool] umbrella_default: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.str] description: The description of the Policy
        :param pulumi.Input[builtins.str] name: The name of the Policy
        :param pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]] target_vpns: Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        """
        pulumi.set(__self__, "child_org_id", child_org_id)
        pulumi.set(__self__, "dns_crypt", dns_crypt)
        pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "local_domain_bypass_enabled", local_domain_bypass_enabled)
        pulumi.set(__self__, "local_domain_bypass_list_id", local_domain_bypass_list_id)
        pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        pulumi.set(__self__, "umbrella_default", umbrella_default)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)

    @property
    @pulumi.getter(name="childOrgId")
    def child_org_id(self) -> pulumi.Input[builtins.str]:
        """
        String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        """
        return pulumi.get(self, "child_org_id")

    @child_org_id.setter
    def child_org_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "child_org_id", value)

    @property
    @pulumi.getter(name="dnsCrypt")
    def dns_crypt(self) -> pulumi.Input[builtins.bool]:
        """
        If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        """
        return pulumi.get(self, "dns_crypt")

    @dns_crypt.setter
    def dns_crypt(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "dns_crypt", value)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> pulumi.Input[builtins.str]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        """
        return pulumi.get(self, "dns_server_ip")

    @dns_server_ip.setter
    def dns_server_ip(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dns_server_ip", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @local_domain_bypass_enabled.setter
    def local_domain_bypass_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "local_domain_bypass_enabled", value)

    @property
    @pulumi.getter(name="localDomainBypassListId")
    def local_domain_bypass_list_id(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "local_domain_bypass_list_id")

    @local_domain_bypass_list_id.setter
    def local_domain_bypass_list_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "local_domain_bypass_list_id", value)

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> pulumi.Input[builtins.bool]:
        """
        If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        """
        return pulumi.get(self, "match_all_vpn")

    @match_all_vpn.setter
    def match_all_vpn(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "match_all_vpn", value)

    @property
    @pulumi.getter(name="umbrellaDefault")
    def umbrella_default(self) -> pulumi.Input[builtins.bool]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "umbrella_default")

    @umbrella_default.setter
    def umbrella_default(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "umbrella_default", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]]]:
        """
        Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]]]):
        pulumi.set(self, "target_vpns", value)


@pulumi.input_type
class _DnsSecurityPolicyState:
    def __init__(__self__, *,
                 child_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns_crypt: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_domain_bypass_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]]] = None,
                 umbrella_default: Optional[pulumi.Input[builtins.bool]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering DnsSecurityPolicy resources.
        :param pulumi.Input[builtins.str] child_org_id: String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        :param pulumi.Input[builtins.str] description: The description of the Policy
        :param pulumi.Input[builtins.bool] dns_crypt: If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        :param pulumi.Input[builtins.str] dns_server_ip: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.bool] match_all_vpn: If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        :param pulumi.Input[builtins.str] name: The name of the Policy
        :param pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]] target_vpns: Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        :param pulumi.Input[builtins.bool] umbrella_default: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.int] version: The version of the Policy
        """
        if child_org_id is not None:
            pulumi.set(__self__, "child_org_id", child_org_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_crypt is not None:
            pulumi.set(__self__, "dns_crypt", dns_crypt)
        if dns_server_ip is not None:
            pulumi.set(__self__, "dns_server_ip", dns_server_ip)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if local_domain_bypass_enabled is not None:
            pulumi.set(__self__, "local_domain_bypass_enabled", local_domain_bypass_enabled)
        if local_domain_bypass_list_id is not None:
            pulumi.set(__self__, "local_domain_bypass_list_id", local_domain_bypass_list_id)
        if match_all_vpn is not None:
            pulumi.set(__self__, "match_all_vpn", match_all_vpn)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_vpns is not None:
            pulumi.set(__self__, "target_vpns", target_vpns)
        if umbrella_default is not None:
            pulumi.set(__self__, "umbrella_default", umbrella_default)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="childOrgId")
    def child_org_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        """
        return pulumi.get(self, "child_org_id")

    @child_org_id.setter
    def child_org_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "child_org_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsCrypt")
    def dns_crypt(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        """
        return pulumi.get(self, "dns_crypt")

    @dns_crypt.setter
    def dns_crypt(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dns_crypt", value)

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        """
        return pulumi.get(self, "dns_server_ip")

    @dns_server_ip.setter
    def dns_server_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dns_server_ip", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @local_domain_bypass_enabled.setter
    def local_domain_bypass_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "local_domain_bypass_enabled", value)

    @property
    @pulumi.getter(name="localDomainBypassListId")
    def local_domain_bypass_list_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "local_domain_bypass_list_id")

    @local_domain_bypass_list_id.setter
    def local_domain_bypass_list_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "local_domain_bypass_list_id", value)

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        """
        return pulumi.get(self, "match_all_vpn")

    @match_all_vpn.setter
    def match_all_vpn(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "match_all_vpn", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]]]:
        """
        Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        """
        return pulumi.get(self, "target_vpns")

    @target_vpns.setter
    def target_vpns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DnsSecurityPolicyTargetVpnArgs']]]]):
        pulumi.set(self, "target_vpns", value)

    @property
    @pulumi.getter(name="umbrellaDefault")
    def umbrella_default(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "umbrella_default")

    @umbrella_default.setter
    def umbrella_default(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "umbrella_default", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Policy
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/dnsSecurityPolicy:DnsSecurityPolicy")
class DnsSecurityPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns_crypt: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_domain_bypass_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyTargetVpnArgs', 'DnsSecurityPolicyTargetVpnArgsDict']]]]] = None,
                 umbrella_default: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        This resource can manage a DNS Security Policy.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.DnsSecurityPolicy("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            local_domain_bypass_list_id="0c4e096d-b06d-4052-93ed-70fe34fda6dc",
            match_all_vpn=True,
            umbrella_default=False,
            dns_server_ip="1.2.3.4",
            local_domain_bypass_enabled=True,
            dns_crypt=False,
            child_org_id="12334")
        ```

        ## Import

        Expected import identifier with the format: "dns_security_policy_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/dnsSecurityPolicy:DnsSecurityPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] child_org_id: String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        :param pulumi.Input[builtins.str] description: The description of the Policy
        :param pulumi.Input[builtins.bool] dns_crypt: If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        :param pulumi.Input[builtins.str] dns_server_ip: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.bool] match_all_vpn: If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        :param pulumi.Input[builtins.str] name: The name of the Policy
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyTargetVpnArgs', 'DnsSecurityPolicyTargetVpnArgsDict']]]] target_vpns: Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        :param pulumi.Input[builtins.bool] umbrella_default: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DnsSecurityPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a DNS Security Policy.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.DnsSecurityPolicy("example",
            name="Example",
            description="My Example",
            feature_profile_id="f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac",
            local_domain_bypass_list_id="0c4e096d-b06d-4052-93ed-70fe34fda6dc",
            match_all_vpn=True,
            umbrella_default=False,
            dns_server_ip="1.2.3.4",
            local_domain_bypass_enabled=True,
            dns_crypt=False,
            child_org_id="12334")
        ```

        ## Import

        Expected import identifier with the format: "dns_security_policy_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/dnsSecurityPolicy:DnsSecurityPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param DnsSecurityPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DnsSecurityPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 child_org_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dns_crypt: Optional[pulumi.Input[builtins.bool]] = None,
                 dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 local_domain_bypass_list_id: Optional[pulumi.Input[builtins.str]] = None,
                 match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyTargetVpnArgs', 'DnsSecurityPolicyTargetVpnArgsDict']]]]] = None,
                 umbrella_default: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DnsSecurityPolicyArgs.__new__(DnsSecurityPolicyArgs)

            if child_org_id is None and not opts.urn:
                raise TypeError("Missing required property 'child_org_id'")
            __props__.__dict__["child_org_id"] = child_org_id
            __props__.__dict__["description"] = description
            if dns_crypt is None and not opts.urn:
                raise TypeError("Missing required property 'dns_crypt'")
            __props__.__dict__["dns_crypt"] = dns_crypt
            if dns_server_ip is None and not opts.urn:
                raise TypeError("Missing required property 'dns_server_ip'")
            __props__.__dict__["dns_server_ip"] = dns_server_ip
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            if local_domain_bypass_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'local_domain_bypass_enabled'")
            __props__.__dict__["local_domain_bypass_enabled"] = local_domain_bypass_enabled
            if local_domain_bypass_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'local_domain_bypass_list_id'")
            __props__.__dict__["local_domain_bypass_list_id"] = local_domain_bypass_list_id
            if match_all_vpn is None and not opts.urn:
                raise TypeError("Missing required property 'match_all_vpn'")
            __props__.__dict__["match_all_vpn"] = match_all_vpn
            __props__.__dict__["name"] = name
            __props__.__dict__["target_vpns"] = target_vpns
            if umbrella_default is None and not opts.urn:
                raise TypeError("Missing required property 'umbrella_default'")
            __props__.__dict__["umbrella_default"] = umbrella_default
            __props__.__dict__["version"] = None
        super(DnsSecurityPolicy, __self__).__init__(
            'sdwan:index/dnsSecurityPolicy:DnsSecurityPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child_org_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dns_crypt: Optional[pulumi.Input[builtins.bool]] = None,
            dns_server_ip: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            local_domain_bypass_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            local_domain_bypass_list_id: Optional[pulumi.Input[builtins.str]] = None,
            match_all_vpn: Optional[pulumi.Input[builtins.bool]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            target_vpns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyTargetVpnArgs', 'DnsSecurityPolicyTargetVpnArgsDict']]]]] = None,
            umbrella_default: Optional[pulumi.Input[builtins.bool]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'DnsSecurityPolicy':
        """
        Get an existing DnsSecurityPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] child_org_id: String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        :param pulumi.Input[builtins.str] description: The description of the Policy
        :param pulumi.Input[builtins.bool] dns_crypt: If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        :param pulumi.Input[builtins.str] dns_server_ip: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] local_domain_bypass_enabled: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.bool] match_all_vpn: If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        :param pulumi.Input[builtins.str] name: The name of the Policy
        :param pulumi.Input[Sequence[pulumi.Input[Union['DnsSecurityPolicyTargetVpnArgs', 'DnsSecurityPolicyTargetVpnArgsDict']]]] target_vpns: Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        :param pulumi.Input[builtins.bool] umbrella_default: Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        :param pulumi.Input[builtins.int] version: The version of the Policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DnsSecurityPolicyState.__new__(_DnsSecurityPolicyState)

        __props__.__dict__["child_org_id"] = child_org_id
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_crypt"] = dns_crypt
        __props__.__dict__["dns_server_ip"] = dns_server_ip
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["local_domain_bypass_enabled"] = local_domain_bypass_enabled
        __props__.__dict__["local_domain_bypass_list_id"] = local_domain_bypass_list_id
        __props__.__dict__["match_all_vpn"] = match_all_vpn
        __props__.__dict__["name"] = name
        __props__.__dict__["target_vpns"] = target_vpns
        __props__.__dict__["umbrella_default"] = umbrella_default
        __props__.__dict__["version"] = version
        return DnsSecurityPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="childOrgId")
    def child_org_id(self) -> pulumi.Output[builtins.str]:
        """
        String that is a number that corresponds to Umbrella Multi Org, can be empty if not using Umbrella Multi Org
        """
        return pulumi.get(self, "child_org_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsCrypt")
    def dns_crypt(self) -> pulumi.Output[builtins.bool]:
        """
        If matchAllVpn is false, this field is only true if at least one of the targetVpns entires contains an umbrellaDefault true
        """
        return pulumi.get(self, "dns_crypt")

    @property
    @pulumi.getter(name="dnsServerIp")
    def dns_server_ip(self) -> pulumi.Output[builtins.str]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry, Attribute conditional on `match_all_vpn` being equal to `true`
        """
        return pulumi.get(self, "dns_server_ip")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="localDomainBypassEnabled")
    def local_domain_bypass_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "local_domain_bypass_enabled")

    @property
    @pulumi.getter(name="localDomainBypassListId")
    def local_domain_bypass_list_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "local_domain_bypass_list_id")

    @property
    @pulumi.getter(name="matchAllVpn")
    def match_all_vpn(self) -> pulumi.Output[builtins.bool]:
        """
        If this is true, there shouldn't be a targetVpns field, if false then targetVpns field should be there
        """
        return pulumi.get(self, "match_all_vpn")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="targetVpns")
    def target_vpns(self) -> pulumi.Output[Optional[Sequence['outputs.DnsSecurityPolicyTargetVpn']]]:
        """
        Will be under data field only if matchAllVpn is false, if matchAllVpn is true field should not be in payload, Attribute conditional on `match_all_vpn` being equal to `false`
        """
        return pulumi.get(self, "target_vpns")

    @property
    @pulumi.getter(name="umbrellaDefault")
    def umbrella_default(self) -> pulumi.Output[builtins.bool]:
        """
        Field will only be under data field if matchAllVpn is true, otherwise field will be under targetVpns and set per entry
        """
        return pulumi.get(self, "umbrella_default")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Policy
        """
        return pulumi.get(self, "version")

