# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetCedgeMulticastFeatureTemplateResult',
    'AwaitableGetCedgeMulticastFeatureTemplateResult',
    'get_cedge_multicast_feature_template',
    'get_cedge_multicast_feature_template_output',
]

@pulumi.output_type
class GetCedgeMulticastFeatureTemplateResult:
    """
    A collection of values returned by getCedgeMulticastFeatureTemplate.
    """
    def __init__(__self__, description=None, device_types=None, id=None, local_replicator=None, local_replicator_variable=None, name=None, spt_only=None, spt_only_variable=None, template_type=None, threshold=None, threshold_variable=None, version=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if local_replicator and not isinstance(local_replicator, bool):
            raise TypeError("Expected argument 'local_replicator' to be a bool")
        pulumi.set(__self__, "local_replicator", local_replicator)
        if local_replicator_variable and not isinstance(local_replicator_variable, str):
            raise TypeError("Expected argument 'local_replicator_variable' to be a str")
        pulumi.set(__self__, "local_replicator_variable", local_replicator_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if spt_only and not isinstance(spt_only, bool):
            raise TypeError("Expected argument 'spt_only' to be a bool")
        pulumi.set(__self__, "spt_only", spt_only)
        if spt_only_variable and not isinstance(spt_only_variable, str):
            raise TypeError("Expected argument 'spt_only_variable' to be a str")
        pulumi.set(__self__, "spt_only_variable", spt_only_variable)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if threshold and not isinstance(threshold, int):
            raise TypeError("Expected argument 'threshold' to be a int")
        pulumi.set(__self__, "threshold", threshold)
        if threshold_variable and not isinstance(threshold_variable, str):
            raise TypeError("Expected argument 'threshold_variable' to be a str")
        pulumi.set(__self__, "threshold_variable", threshold_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localReplicator")
    def local_replicator(self) -> builtins.bool:
        """
        Replicator is local to this device
        """
        return pulumi.get(self, "local_replicator")

    @property
    @pulumi.getter(name="localReplicatorVariable")
    def local_replicator_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "local_replicator_variable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sptOnly")
    def spt_only(self) -> builtins.bool:
        """
        Shortest Path Tree (SPT) Only Mode
        """
        return pulumi.get(self, "spt_only")

    @property
    @pulumi.getter(name="sptOnlyVariable")
    def spt_only_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "spt_only_variable")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.int:
        """
        Set number of joins per group the router supports
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter(name="thresholdVariable")
    def threshold_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "threshold_variable")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCedgeMulticastFeatureTemplateResult(GetCedgeMulticastFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCedgeMulticastFeatureTemplateResult(
            description=self.description,
            device_types=self.device_types,
            id=self.id,
            local_replicator=self.local_replicator,
            local_replicator_variable=self.local_replicator_variable,
            name=self.name,
            spt_only=self.spt_only,
            spt_only_variable=self.spt_only_variable,
            template_type=self.template_type,
            threshold=self.threshold,
            threshold_variable=self.threshold_variable,
            version=self.version)


def get_cedge_multicast_feature_template(id: Optional[builtins.str] = None,
                                         name: Optional[builtins.str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCedgeMulticastFeatureTemplateResult:
    """
    This data source can read the cEdge Multicast feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cedge_multicast_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param builtins.str id: The id of the feature template
    :param builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCedgeMulticastFeatureTemplate:getCedgeMulticastFeatureTemplate', __args__, opts=opts, typ=GetCedgeMulticastFeatureTemplateResult).value

    return AwaitableGetCedgeMulticastFeatureTemplateResult(
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        id=pulumi.get(__ret__, 'id'),
        local_replicator=pulumi.get(__ret__, 'local_replicator'),
        local_replicator_variable=pulumi.get(__ret__, 'local_replicator_variable'),
        name=pulumi.get(__ret__, 'name'),
        spt_only=pulumi.get(__ret__, 'spt_only'),
        spt_only_variable=pulumi.get(__ret__, 'spt_only_variable'),
        template_type=pulumi.get(__ret__, 'template_type'),
        threshold=pulumi.get(__ret__, 'threshold'),
        threshold_variable=pulumi.get(__ret__, 'threshold_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_cedge_multicast_feature_template_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCedgeMulticastFeatureTemplateResult]:
    """
    This data source can read the cEdge Multicast feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cedge_multicast_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param builtins.str id: The id of the feature template
    :param builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCedgeMulticastFeatureTemplate:getCedgeMulticastFeatureTemplate', __args__, opts=opts, typ=GetCedgeMulticastFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCedgeMulticastFeatureTemplateResult(
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        id=pulumi.get(__response__, 'id'),
        local_replicator=pulumi.get(__response__, 'local_replicator'),
        local_replicator_variable=pulumi.get(__response__, 'local_replicator_variable'),
        name=pulumi.get(__response__, 'name'),
        spt_only=pulumi.get(__response__, 'spt_only'),
        spt_only_variable=pulumi.get(__response__, 'spt_only_variable'),
        template_type=pulumi.get(__response__, 'template_type'),
        threshold=pulumi.get(__response__, 'threshold'),
        threshold_variable=pulumi.get(__response__, 'threshold_variable'),
        version=pulumi.get(__response__, 'version')))
