# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetCiscoNtpFeatureTemplateResult',
    'AwaitableGetCiscoNtpFeatureTemplateResult',
    'get_cisco_ntp_feature_template',
    'get_cisco_ntp_feature_template_output',
]

@pulumi.output_type
class GetCiscoNtpFeatureTemplateResult:
    """
    A collection of values returned by getCiscoNtpFeatureTemplate.
    """
    def __init__(__self__, authentication_keys=None, description=None, device_types=None, id=None, master=None, master_source_interface=None, master_source_interface_variable=None, master_stratum=None, master_stratum_variable=None, master_variable=None, name=None, servers=None, template_type=None, trusted_keys=None, trusted_keys_variable=None, version=None):
        if authentication_keys and not isinstance(authentication_keys, list):
            raise TypeError("Expected argument 'authentication_keys' to be a list")
        pulumi.set(__self__, "authentication_keys", authentication_keys)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if device_types and not isinstance(device_types, list):
            raise TypeError("Expected argument 'device_types' to be a list")
        pulumi.set(__self__, "device_types", device_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if master and not isinstance(master, bool):
            raise TypeError("Expected argument 'master' to be a bool")
        pulumi.set(__self__, "master", master)
        if master_source_interface and not isinstance(master_source_interface, str):
            raise TypeError("Expected argument 'master_source_interface' to be a str")
        pulumi.set(__self__, "master_source_interface", master_source_interface)
        if master_source_interface_variable and not isinstance(master_source_interface_variable, str):
            raise TypeError("Expected argument 'master_source_interface_variable' to be a str")
        pulumi.set(__self__, "master_source_interface_variable", master_source_interface_variable)
        if master_stratum and not isinstance(master_stratum, int):
            raise TypeError("Expected argument 'master_stratum' to be a int")
        pulumi.set(__self__, "master_stratum", master_stratum)
        if master_stratum_variable and not isinstance(master_stratum_variable, str):
            raise TypeError("Expected argument 'master_stratum_variable' to be a str")
        pulumi.set(__self__, "master_stratum_variable", master_stratum_variable)
        if master_variable and not isinstance(master_variable, str):
            raise TypeError("Expected argument 'master_variable' to be a str")
        pulumi.set(__self__, "master_variable", master_variable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if servers and not isinstance(servers, list):
            raise TypeError("Expected argument 'servers' to be a list")
        pulumi.set(__self__, "servers", servers)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if trusted_keys and not isinstance(trusted_keys, list):
            raise TypeError("Expected argument 'trusted_keys' to be a list")
        pulumi.set(__self__, "trusted_keys", trusted_keys)
        if trusted_keys_variable and not isinstance(trusted_keys_variable, str):
            raise TypeError("Expected argument 'trusted_keys_variable' to be a str")
        pulumi.set(__self__, "trusted_keys_variable", trusted_keys_variable)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authenticationKeys")
    def authentication_keys(self) -> Sequence['outputs.GetCiscoNtpFeatureTemplateAuthenticationKeyResult']:
        """
        Set MD5 authentication key
        """
        return pulumi.get(self, "authentication_keys")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Sequence[builtins.str]:
        """
        List of supported device types
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the feature template
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def master(self) -> builtins.bool:
        """
        Configure device as NTP master
        """
        return pulumi.get(self, "master")

    @property
    @pulumi.getter(name="masterSourceInterface")
    def master_source_interface(self) -> builtins.str:
        """
        Set interface for NTP Master
        """
        return pulumi.get(self, "master_source_interface")

    @property
    @pulumi.getter(name="masterSourceInterfaceVariable")
    def master_source_interface_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "master_source_interface_variable")

    @property
    @pulumi.getter(name="masterStratum")
    def master_stratum(self) -> builtins.int:
        """
        Master Stratum \\n\\n
        """
        return pulumi.get(self, "master_stratum")

    @property
    @pulumi.getter(name="masterStratumVariable")
    def master_stratum_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "master_stratum_variable")

    @property
    @pulumi.getter(name="masterVariable")
    def master_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "master_variable")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.GetCiscoNtpFeatureTemplateServerResult']:
        """
        Configure NTP servers
        """
        return pulumi.get(self, "servers")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> builtins.str:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="trustedKeys")
    def trusted_keys(self) -> Sequence[builtins.int]:
        """
        Designate authentication key as trustworthy
        """
        return pulumi.get(self, "trusted_keys")

    @property
    @pulumi.getter(name="trustedKeysVariable")
    def trusted_keys_variable(self) -> builtins.str:
        """
        Variable name
        """
        return pulumi.get(self, "trusted_keys_variable")

    @property
    @pulumi.getter
    def version(self) -> builtins.int:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")


class AwaitableGetCiscoNtpFeatureTemplateResult(GetCiscoNtpFeatureTemplateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCiscoNtpFeatureTemplateResult(
            authentication_keys=self.authentication_keys,
            description=self.description,
            device_types=self.device_types,
            id=self.id,
            master=self.master,
            master_source_interface=self.master_source_interface,
            master_source_interface_variable=self.master_source_interface_variable,
            master_stratum=self.master_stratum,
            master_stratum_variable=self.master_stratum_variable,
            master_variable=self.master_variable,
            name=self.name,
            servers=self.servers,
            template_type=self.template_type,
            trusted_keys=self.trusted_keys,
            trusted_keys_variable=self.trusted_keys_variable,
            version=self.version)


def get_cisco_ntp_feature_template(id: Optional[builtins.str] = None,
                                   name: Optional[builtins.str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCiscoNtpFeatureTemplateResult:
    """
    This data source can read the Cisco NTP feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_ntp_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param builtins.str id: The id of the feature template
    :param builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sdwan:index/getCiscoNtpFeatureTemplate:getCiscoNtpFeatureTemplate', __args__, opts=opts, typ=GetCiscoNtpFeatureTemplateResult).value

    return AwaitableGetCiscoNtpFeatureTemplateResult(
        authentication_keys=pulumi.get(__ret__, 'authentication_keys'),
        description=pulumi.get(__ret__, 'description'),
        device_types=pulumi.get(__ret__, 'device_types'),
        id=pulumi.get(__ret__, 'id'),
        master=pulumi.get(__ret__, 'master'),
        master_source_interface=pulumi.get(__ret__, 'master_source_interface'),
        master_source_interface_variable=pulumi.get(__ret__, 'master_source_interface_variable'),
        master_stratum=pulumi.get(__ret__, 'master_stratum'),
        master_stratum_variable=pulumi.get(__ret__, 'master_stratum_variable'),
        master_variable=pulumi.get(__ret__, 'master_variable'),
        name=pulumi.get(__ret__, 'name'),
        servers=pulumi.get(__ret__, 'servers'),
        template_type=pulumi.get(__ret__, 'template_type'),
        trusted_keys=pulumi.get(__ret__, 'trusted_keys'),
        trusted_keys_variable=pulumi.get(__ret__, 'trusted_keys_variable'),
        version=pulumi.get(__ret__, 'version'))
def get_cisco_ntp_feature_template_output(id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCiscoNtpFeatureTemplateResult]:
    """
    This data source can read the Cisco NTP feature template.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sdwan as sdwan

    example = sdwan.get_cisco_ntp_feature_template(id="f6b2c44c-693c-4763-b010-895aa3d236bd")
    ```


    :param builtins.str id: The id of the feature template
    :param builtins.str name: The name of the feature template
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sdwan:index/getCiscoNtpFeatureTemplate:getCiscoNtpFeatureTemplate', __args__, opts=opts, typ=GetCiscoNtpFeatureTemplateResult)
    return __ret__.apply(lambda __response__: GetCiscoNtpFeatureTemplateResult(
        authentication_keys=pulumi.get(__response__, 'authentication_keys'),
        description=pulumi.get(__response__, 'description'),
        device_types=pulumi.get(__response__, 'device_types'),
        id=pulumi.get(__response__, 'id'),
        master=pulumi.get(__response__, 'master'),
        master_source_interface=pulumi.get(__response__, 'master_source_interface'),
        master_source_interface_variable=pulumi.get(__response__, 'master_source_interface_variable'),
        master_stratum=pulumi.get(__response__, 'master_stratum'),
        master_stratum_variable=pulumi.get(__response__, 'master_stratum_variable'),
        master_variable=pulumi.get(__response__, 'master_variable'),
        name=pulumi.get(__response__, 'name'),
        servers=pulumi.get(__response__, 'servers'),
        template_type=pulumi.get(__response__, 'template_type'),
        trusted_keys=pulumi.get(__response__, 'trusted_keys'),
        trusted_keys_variable=pulumi.get(__response__, 'trusted_keys_variable'),
        version=pulumi.get(__response__, 'version')))
