# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceLanVpnInterfaceSviFeatureArgs', 'ServiceLanVpnInterfaceSviFeature']

@pulumi.input_type
class ServiceLanVpnInterfaceSviFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 acl_ipv4_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv4_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 arp_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[builtins.str]] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dhcpv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_dhcpv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_redirect_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 icmp_redirect_disable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv4_dhcp_helpers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceLanVpnInterfaceSviFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        :param pulumi.Input[builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]] arps: Configure static ARP entries
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_dhcpv6: Enable DHCPv6 - Default value: `false`
        :param pulumi.Input[builtins.str] enable_dhcpv6_variable: Variable name
        :param pulumi.Input[builtins.bool] icmp_redirect_disable: ICMP/ICMPv6 Redirect Disable - Default value: `true`
        :param pulumi.Input[builtins.str] icmp_redirect_disable_variable: Variable name
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.bool] ip_directed_broadcast: IP Directed-Broadcast - Default value: `false`
        :param pulumi.Input[builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address: IP Address
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[builtins.str] ipv4_dhcp_helpers_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]] ipv4_vrrps: Enable ipv4 VRRP
        :param pulumi.Input[builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]] ipv6_vrrps: Enable ipv6 VRRP
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if acl_ipv4_egress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv4_egress_feature_id", acl_ipv4_egress_feature_id)
        if acl_ipv4_ingress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv4_ingress_feature_id", acl_ipv4_ingress_feature_id)
        if acl_ipv6_egress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv6_egress_feature_id", acl_ipv6_egress_feature_id)
        if acl_ipv6_ingress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv6_ingress_feature_id", acl_ipv6_ingress_feature_id)
        if arp_timeout is not None:
            pulumi.set(__self__, "arp_timeout", arp_timeout)
        if arp_timeout_variable is not None:
            pulumi.set(__self__, "arp_timeout_variable", arp_timeout_variable)
        if arps is not None:
            pulumi.set(__self__, "arps", arps)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_dhcpv6 is not None:
            pulumi.set(__self__, "enable_dhcpv6", enable_dhcpv6)
        if enable_dhcpv6_variable is not None:
            pulumi.set(__self__, "enable_dhcpv6_variable", enable_dhcpv6_variable)
        if icmp_redirect_disable is not None:
            pulumi.set(__self__, "icmp_redirect_disable", icmp_redirect_disable)
        if icmp_redirect_disable_variable is not None:
            pulumi.set(__self__, "icmp_redirect_disable_variable", icmp_redirect_disable_variable)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_mtu is not None:
            pulumi.set(__self__, "interface_mtu", interface_mtu)
        if interface_mtu_variable is not None:
            pulumi.set(__self__, "interface_mtu_variable", interface_mtu_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_directed_broadcast is not None:
            pulumi.set(__self__, "ip_directed_broadcast", ip_directed_broadcast)
        if ip_directed_broadcast_variable is not None:
            pulumi.set(__self__, "ip_directed_broadcast_variable", ip_directed_broadcast_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if ipv4_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv4_dhcp_helpers", ipv4_dhcp_helpers)
        if ipv4_dhcp_helpers_variable is not None:
            pulumi.set(__self__, "ipv4_dhcp_helpers_variable", ipv4_dhcp_helpers_variable)
        if ipv4_secondary_addresses is not None:
            pulumi.set(__self__, "ipv4_secondary_addresses", ipv4_secondary_addresses)
        if ipv4_subnet_mask is not None:
            pulumi.set(__self__, "ipv4_subnet_mask", ipv4_subnet_mask)
        if ipv4_subnet_mask_variable is not None:
            pulumi.set(__self__, "ipv4_subnet_mask_variable", ipv4_subnet_mask_variable)
        if ipv4_vrrps is not None:
            pulumi.set(__self__, "ipv4_vrrps", ipv4_vrrps)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_address_variable is not None:
            pulumi.set(__self__, "ipv6_address_variable", ipv6_address_variable)
        if ipv6_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv6_dhcp_helpers", ipv6_dhcp_helpers)
        if ipv6_secondary_addresses is not None:
            pulumi.set(__self__, "ipv6_secondary_addresses", ipv6_secondary_addresses)
        if ipv6_vrrps is not None:
            pulumi.set(__self__, "ipv6_vrrps", ipv6_vrrps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_lan_vpn_feature_id is not None:
            pulumi.set(__self__, "service_lan_vpn_feature_id", service_lan_vpn_feature_id)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss is not None:
            pulumi.set(__self__, "tcp_mss", tcp_mss)
        if tcp_mss_variable is not None:
            pulumi.set(__self__, "tcp_mss_variable", tcp_mss_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="aclIpv4EgressFeatureId")
    def acl_ipv4_egress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv4_egress_feature_id")

    @acl_ipv4_egress_feature_id.setter
    def acl_ipv4_egress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv4_egress_feature_id", value)

    @property
    @pulumi.getter(name="aclIpv4IngressFeatureId")
    def acl_ipv4_ingress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv4_ingress_feature_id")

    @acl_ipv4_ingress_feature_id.setter
    def acl_ipv4_ingress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv4_ingress_feature_id", value)

    @property
    @pulumi.getter(name="aclIpv6EgressFeatureId")
    def acl_ipv6_egress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv6_egress_feature_id")

    @acl_ipv6_egress_feature_id.setter
    def acl_ipv6_egress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv6_egress_feature_id", value)

    @property
    @pulumi.getter(name="aclIpv6IngressFeatureId")
    def acl_ipv6_ingress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv6_ingress_feature_id")

    @acl_ipv6_ingress_feature_id.setter
    def acl_ipv6_ingress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv6_ingress_feature_id", value)

    @property
    @pulumi.getter(name="arpTimeout")
    def arp_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        """
        return pulumi.get(self, "arp_timeout")

    @arp_timeout.setter
    def arp_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "arp_timeout", value)

    @property
    @pulumi.getter(name="arpTimeoutVariable")
    def arp_timeout_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "arp_timeout_variable")

    @arp_timeout_variable.setter
    def arp_timeout_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arp_timeout_variable", value)

    @property
    @pulumi.getter
    def arps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]]]:
        """
        Configure static ARP entries
        """
        return pulumi.get(self, "arps")

    @arps.setter
    def arps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]]]):
        pulumi.set(self, "arps", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableDhcpv6")
    def enable_dhcpv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable DHCPv6 - Default value: `false`
        """
        return pulumi.get(self, "enable_dhcpv6")

    @enable_dhcpv6.setter
    def enable_dhcpv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_dhcpv6", value)

    @property
    @pulumi.getter(name="enableDhcpv6Variable")
    def enable_dhcpv6_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_dhcpv6_variable")

    @enable_dhcpv6_variable.setter
    def enable_dhcpv6_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable_dhcpv6_variable", value)

    @property
    @pulumi.getter(name="icmpRedirectDisable")
    def icmp_redirect_disable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ICMP/ICMPv6 Redirect Disable - Default value: `true`
        """
        return pulumi.get(self, "icmp_redirect_disable")

    @icmp_redirect_disable.setter
    def icmp_redirect_disable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "icmp_redirect_disable", value)

    @property
    @pulumi.getter(name="icmpRedirectDisableVariable")
    def icmp_redirect_disable_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "icmp_redirect_disable_variable")

    @icmp_redirect_disable_variable.setter
    def icmp_redirect_disable_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icmp_redirect_disable_variable", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "interface_mtu")

    @interface_mtu.setter
    def interface_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interface_mtu", value)

    @property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @interface_mtu_variable.setter
    def interface_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_mtu_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface name: VLAN 1 - VLAN 4094 when present
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipDirectedBroadcast")
    def ip_directed_broadcast(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        IP Directed-Broadcast - Default value: `false`
        """
        return pulumi.get(self, "ip_directed_broadcast")

    @ip_directed_broadcast.setter
    def ip_directed_broadcast(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ip_directed_broadcast", value)

    @property
    @pulumi.getter(name="ipDirectedBroadcastVariable")
    def ip_directed_broadcast_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_directed_broadcast_variable")

    @ip_directed_broadcast_variable.setter
    def ip_directed_broadcast_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_directed_broadcast_variable", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @property
    @pulumi.getter(name="ipv4DhcpHelpers")
    def ipv4_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of DHCP helper addresses
        """
        return pulumi.get(self, "ipv4_dhcp_helpers")

    @ipv4_dhcp_helpers.setter
    def ipv4_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv4_dhcp_helpers", value)

    @property
    @pulumi.getter(name="ipv4DhcpHelpersVariable")
    def ipv4_dhcp_helpers_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_dhcp_helpers_variable")

    @ipv4_dhcp_helpers_variable.setter
    def ipv4_dhcp_helpers_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_dhcp_helpers_variable", value)

    @property
    @pulumi.getter(name="ipv4SecondaryAddresses")
    def ipv4_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]]]:
        """
        Assign secondary IP addresses
        """
        return pulumi.get(self, "ipv4_secondary_addresses")

    @ipv4_secondary_addresses.setter
    def ipv4_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv4_secondary_addresses", value)

    @property
    @pulumi.getter(name="ipv4SubnetMask")
    def ipv4_subnet_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "ipv4_subnet_mask")

    @ipv4_subnet_mask.setter
    def ipv4_subnet_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask", value)

    @property
    @pulumi.getter(name="ipv4SubnetMaskVariable")
    def ipv4_subnet_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_subnet_mask_variable")

    @ipv4_subnet_mask_variable.setter
    def ipv4_subnet_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask_variable", value)

    @property
    @pulumi.getter(name="ipv4Vrrps")
    def ipv4_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]]]:
        """
        Enable ipv4 VRRP
        """
        return pulumi.get(self, "ipv4_vrrps")

    @ipv4_vrrps.setter
    def ipv4_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]]]):
        pulumi.set(self, "ipv4_vrrps", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assign IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6AddressVariable")
    def ipv6_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_address_variable")

    @ipv6_address_variable.setter
    def ipv6_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address_variable", value)

    @property
    @pulumi.getter(name="ipv6DhcpHelpers")
    def ipv6_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]]]:
        """
        DHCPv6 Helper
        """
        return pulumi.get(self, "ipv6_dhcp_helpers")

    @ipv6_dhcp_helpers.setter
    def ipv6_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]]]):
        pulumi.set(self, "ipv6_dhcp_helpers", value)

    @property
    @pulumi.getter(name="ipv6SecondaryAddresses")
    def ipv6_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]]]:
        """
        Assign secondary IPv6 addresses
        """
        return pulumi.get(self, "ipv6_secondary_addresses")

    @ipv6_secondary_addresses.setter
    def ipv6_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv6_secondary_addresses", value)

    @property
    @pulumi.getter(name="ipv6Vrrps")
    def ipv6_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]]]:
        """
        Enable ipv6 VRRP
        """
        return pulumi.get(self, "ipv6_vrrps")

    @ipv6_vrrps.setter
    def ipv6_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]]]):
        pulumi.set(self, "ipv6_vrrps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceLanVpnFeatureId")
    def service_lan_vpn_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service LAN VPN Feature ID
        """
        return pulumi.get(self, "service_lan_vpn_feature_id")

    @service_lan_vpn_feature_id.setter
    def service_lan_vpn_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_lan_vpn_feature_id", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMss")
    def tcp_mss(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        """
        return pulumi.get(self, "tcp_mss")

    @tcp_mss.setter
    def tcp_mss(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_mss", value)

    @property
    @pulumi.getter(name="tcpMssVariable")
    def tcp_mss_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_variable")

    @tcp_mss_variable.setter
    def tcp_mss_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_mss_variable", value)


@pulumi.input_type
class _ServiceLanVpnInterfaceSviFeatureState:
    def __init__(__self__, *,
                 acl_ipv4_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv4_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 arp_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[builtins.str]] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dhcpv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_dhcpv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_redirect_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 icmp_redirect_disable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv4_dhcp_helpers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceLanVpnInterfaceSviFeature resources.
        :param pulumi.Input[builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        :param pulumi.Input[builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]] arps: Configure static ARP entries
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_dhcpv6: Enable DHCPv6 - Default value: `false`
        :param pulumi.Input[builtins.str] enable_dhcpv6_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] icmp_redirect_disable: ICMP/ICMPv6 Redirect Disable - Default value: `true`
        :param pulumi.Input[builtins.str] icmp_redirect_disable_variable: Variable name
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.bool] ip_directed_broadcast: IP Directed-Broadcast - Default value: `false`
        :param pulumi.Input[builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address: IP Address
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[builtins.str] ipv4_dhcp_helpers_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]] ipv4_vrrps: Enable ipv4 VRRP
        :param pulumi.Input[builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]] ipv6_vrrps: Enable ipv6 VRRP
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if acl_ipv4_egress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv4_egress_feature_id", acl_ipv4_egress_feature_id)
        if acl_ipv4_ingress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv4_ingress_feature_id", acl_ipv4_ingress_feature_id)
        if acl_ipv6_egress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv6_egress_feature_id", acl_ipv6_egress_feature_id)
        if acl_ipv6_ingress_feature_id is not None:
            pulumi.set(__self__, "acl_ipv6_ingress_feature_id", acl_ipv6_ingress_feature_id)
        if arp_timeout is not None:
            pulumi.set(__self__, "arp_timeout", arp_timeout)
        if arp_timeout_variable is not None:
            pulumi.set(__self__, "arp_timeout_variable", arp_timeout_variable)
        if arps is not None:
            pulumi.set(__self__, "arps", arps)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_dhcpv6 is not None:
            pulumi.set(__self__, "enable_dhcpv6", enable_dhcpv6)
        if enable_dhcpv6_variable is not None:
            pulumi.set(__self__, "enable_dhcpv6_variable", enable_dhcpv6_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if icmp_redirect_disable is not None:
            pulumi.set(__self__, "icmp_redirect_disable", icmp_redirect_disable)
        if icmp_redirect_disable_variable is not None:
            pulumi.set(__self__, "icmp_redirect_disable_variable", icmp_redirect_disable_variable)
        if interface_description is not None:
            pulumi.set(__self__, "interface_description", interface_description)
        if interface_description_variable is not None:
            pulumi.set(__self__, "interface_description_variable", interface_description_variable)
        if interface_mtu is not None:
            pulumi.set(__self__, "interface_mtu", interface_mtu)
        if interface_mtu_variable is not None:
            pulumi.set(__self__, "interface_mtu_variable", interface_mtu_variable)
        if interface_name is not None:
            pulumi.set(__self__, "interface_name", interface_name)
        if interface_name_variable is not None:
            pulumi.set(__self__, "interface_name_variable", interface_name_variable)
        if ip_directed_broadcast is not None:
            pulumi.set(__self__, "ip_directed_broadcast", ip_directed_broadcast)
        if ip_directed_broadcast_variable is not None:
            pulumi.set(__self__, "ip_directed_broadcast_variable", ip_directed_broadcast_variable)
        if ip_mtu is not None:
            pulumi.set(__self__, "ip_mtu", ip_mtu)
        if ip_mtu_variable is not None:
            pulumi.set(__self__, "ip_mtu_variable", ip_mtu_variable)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_variable is not None:
            pulumi.set(__self__, "ipv4_address_variable", ipv4_address_variable)
        if ipv4_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv4_dhcp_helpers", ipv4_dhcp_helpers)
        if ipv4_dhcp_helpers_variable is not None:
            pulumi.set(__self__, "ipv4_dhcp_helpers_variable", ipv4_dhcp_helpers_variable)
        if ipv4_secondary_addresses is not None:
            pulumi.set(__self__, "ipv4_secondary_addresses", ipv4_secondary_addresses)
        if ipv4_subnet_mask is not None:
            pulumi.set(__self__, "ipv4_subnet_mask", ipv4_subnet_mask)
        if ipv4_subnet_mask_variable is not None:
            pulumi.set(__self__, "ipv4_subnet_mask_variable", ipv4_subnet_mask_variable)
        if ipv4_vrrps is not None:
            pulumi.set(__self__, "ipv4_vrrps", ipv4_vrrps)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_address_variable is not None:
            pulumi.set(__self__, "ipv6_address_variable", ipv6_address_variable)
        if ipv6_dhcp_helpers is not None:
            pulumi.set(__self__, "ipv6_dhcp_helpers", ipv6_dhcp_helpers)
        if ipv6_secondary_addresses is not None:
            pulumi.set(__self__, "ipv6_secondary_addresses", ipv6_secondary_addresses)
        if ipv6_vrrps is not None:
            pulumi.set(__self__, "ipv6_vrrps", ipv6_vrrps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if service_lan_vpn_feature_id is not None:
            pulumi.set(__self__, "service_lan_vpn_feature_id", service_lan_vpn_feature_id)
        if shutdown is not None:
            pulumi.set(__self__, "shutdown", shutdown)
        if shutdown_variable is not None:
            pulumi.set(__self__, "shutdown_variable", shutdown_variable)
        if tcp_mss is not None:
            pulumi.set(__self__, "tcp_mss", tcp_mss)
        if tcp_mss_variable is not None:
            pulumi.set(__self__, "tcp_mss_variable", tcp_mss_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="aclIpv4EgressFeatureId")
    def acl_ipv4_egress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv4_egress_feature_id")

    @acl_ipv4_egress_feature_id.setter
    def acl_ipv4_egress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv4_egress_feature_id", value)

    @property
    @pulumi.getter(name="aclIpv4IngressFeatureId")
    def acl_ipv4_ingress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv4_ingress_feature_id")

    @acl_ipv4_ingress_feature_id.setter
    def acl_ipv4_ingress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv4_ingress_feature_id", value)

    @property
    @pulumi.getter(name="aclIpv6EgressFeatureId")
    def acl_ipv6_egress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv6_egress_feature_id")

    @acl_ipv6_egress_feature_id.setter
    def acl_ipv6_egress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv6_egress_feature_id", value)

    @property
    @pulumi.getter(name="aclIpv6IngressFeatureId")
    def acl_ipv6_ingress_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "acl_ipv6_ingress_feature_id")

    @acl_ipv6_ingress_feature_id.setter
    def acl_ipv6_ingress_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "acl_ipv6_ingress_feature_id", value)

    @property
    @pulumi.getter(name="arpTimeout")
    def arp_timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        """
        return pulumi.get(self, "arp_timeout")

    @arp_timeout.setter
    def arp_timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "arp_timeout", value)

    @property
    @pulumi.getter(name="arpTimeoutVariable")
    def arp_timeout_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "arp_timeout_variable")

    @arp_timeout_variable.setter
    def arp_timeout_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arp_timeout_variable", value)

    @property
    @pulumi.getter
    def arps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]]]:
        """
        Configure static ARP entries
        """
        return pulumi.get(self, "arps")

    @arps.setter
    def arps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureArpArgs']]]]):
        pulumi.set(self, "arps", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableDhcpv6")
    def enable_dhcpv6(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable DHCPv6 - Default value: `false`
        """
        return pulumi.get(self, "enable_dhcpv6")

    @enable_dhcpv6.setter
    def enable_dhcpv6(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_dhcpv6", value)

    @property
    @pulumi.getter(name="enableDhcpv6Variable")
    def enable_dhcpv6_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_dhcpv6_variable")

    @enable_dhcpv6_variable.setter
    def enable_dhcpv6_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable_dhcpv6_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="icmpRedirectDisable")
    def icmp_redirect_disable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ICMP/ICMPv6 Redirect Disable - Default value: `true`
        """
        return pulumi.get(self, "icmp_redirect_disable")

    @icmp_redirect_disable.setter
    def icmp_redirect_disable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "icmp_redirect_disable", value)

    @property
    @pulumi.getter(name="icmpRedirectDisableVariable")
    def icmp_redirect_disable_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "icmp_redirect_disable_variable")

    @icmp_redirect_disable_variable.setter
    def icmp_redirect_disable_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "icmp_redirect_disable_variable", value)

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @interface_description.setter
    def interface_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description", value)

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @interface_description_variable.setter
    def interface_description_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_description_variable", value)

    @property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "interface_mtu")

    @interface_mtu.setter
    def interface_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "interface_mtu", value)

    @property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @interface_mtu_variable.setter
    def interface_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_mtu_variable", value)

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Interface name: VLAN 1 - VLAN 4094 when present
        """
        return pulumi.get(self, "interface_name")

    @interface_name.setter
    def interface_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name", value)

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @interface_name_variable.setter
    def interface_name_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interface_name_variable", value)

    @property
    @pulumi.getter(name="ipDirectedBroadcast")
    def ip_directed_broadcast(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        IP Directed-Broadcast - Default value: `false`
        """
        return pulumi.get(self, "ip_directed_broadcast")

    @ip_directed_broadcast.setter
    def ip_directed_broadcast(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "ip_directed_broadcast", value)

    @property
    @pulumi.getter(name="ipDirectedBroadcastVariable")
    def ip_directed_broadcast_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_directed_broadcast_variable")

    @ip_directed_broadcast_variable.setter
    def ip_directed_broadcast_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_directed_broadcast_variable", value)

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @ip_mtu.setter
    def ip_mtu(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ip_mtu", value)

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @ip_mtu_variable.setter
    def ip_mtu_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_mtu_variable", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IP Address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @ipv4_address_variable.setter
    def ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_address_variable", value)

    @property
    @pulumi.getter(name="ipv4DhcpHelpers")
    def ipv4_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of DHCP helper addresses
        """
        return pulumi.get(self, "ipv4_dhcp_helpers")

    @ipv4_dhcp_helpers.setter
    def ipv4_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipv4_dhcp_helpers", value)

    @property
    @pulumi.getter(name="ipv4DhcpHelpersVariable")
    def ipv4_dhcp_helpers_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_dhcp_helpers_variable")

    @ipv4_dhcp_helpers_variable.setter
    def ipv4_dhcp_helpers_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_dhcp_helpers_variable", value)

    @property
    @pulumi.getter(name="ipv4SecondaryAddresses")
    def ipv4_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]]]:
        """
        Assign secondary IP addresses
        """
        return pulumi.get(self, "ipv4_secondary_addresses")

    @ipv4_secondary_addresses.setter
    def ipv4_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv4_secondary_addresses", value)

    @property
    @pulumi.getter(name="ipv4SubnetMask")
    def ipv4_subnet_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "ipv4_subnet_mask")

    @ipv4_subnet_mask.setter
    def ipv4_subnet_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask", value)

    @property
    @pulumi.getter(name="ipv4SubnetMaskVariable")
    def ipv4_subnet_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_subnet_mask_variable")

    @ipv4_subnet_mask_variable.setter
    def ipv4_subnet_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv4_subnet_mask_variable", value)

    @property
    @pulumi.getter(name="ipv4Vrrps")
    def ipv4_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]]]:
        """
        Enable ipv4 VRRP
        """
        return pulumi.get(self, "ipv4_vrrps")

    @ipv4_vrrps.setter
    def ipv4_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs']]]]):
        pulumi.set(self, "ipv4_vrrps", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Assign IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6AddressVariable")
    def ipv6_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_address_variable")

    @ipv6_address_variable.setter
    def ipv6_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipv6_address_variable", value)

    @property
    @pulumi.getter(name="ipv6DhcpHelpers")
    def ipv6_dhcp_helpers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]]]:
        """
        DHCPv6 Helper
        """
        return pulumi.get(self, "ipv6_dhcp_helpers")

    @ipv6_dhcp_helpers.setter
    def ipv6_dhcp_helpers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs']]]]):
        pulumi.set(self, "ipv6_dhcp_helpers", value)

    @property
    @pulumi.getter(name="ipv6SecondaryAddresses")
    def ipv6_secondary_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]]]:
        """
        Assign secondary IPv6 addresses
        """
        return pulumi.get(self, "ipv6_secondary_addresses")

    @ipv6_secondary_addresses.setter
    def ipv6_secondary_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs']]]]):
        pulumi.set(self, "ipv6_secondary_addresses", value)

    @property
    @pulumi.getter(name="ipv6Vrrps")
    def ipv6_vrrps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]]]:
        """
        Enable ipv6 VRRP
        """
        return pulumi.get(self, "ipv6_vrrps")

    @ipv6_vrrps.setter
    def ipv6_vrrps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs']]]]):
        pulumi.set(self, "ipv6_vrrps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="serviceLanVpnFeatureId")
    def service_lan_vpn_feature_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service LAN VPN Feature ID
        """
        return pulumi.get(self, "service_lan_vpn_feature_id")

    @service_lan_vpn_feature_id.setter
    def service_lan_vpn_feature_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_lan_vpn_feature_id", value)

    @property
    @pulumi.getter
    def shutdown(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @shutdown.setter
    def shutdown(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "shutdown", value)

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @shutdown_variable.setter
    def shutdown_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shutdown_variable", value)

    @property
    @pulumi.getter(name="tcpMss")
    def tcp_mss(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        """
        return pulumi.get(self, "tcp_mss")

    @tcp_mss.setter
    def tcp_mss(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tcp_mss", value)

    @property
    @pulumi.getter(name="tcpMssVariable")
    def tcp_mss_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_variable")

    @tcp_mss_variable.setter
    def tcp_mss_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tcp_mss_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/serviceLanVpnInterfaceSviFeature:ServiceLanVpnInterfaceSviFeature")
class ServiceLanVpnInterfaceSviFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_ipv4_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv4_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 arp_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[builtins.str]] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureArpArgs', 'ServiceLanVpnInterfaceSviFeatureArpArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dhcpv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_dhcpv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_redirect_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 icmp_redirect_disable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv4_dhcp_helpers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgsDict']]]]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgsDict']]]]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgsDict']]]]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgsDict']]]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Service LAN VPN Interface SVI Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_lan_vpn_interface_svi_feature_id,feature_profile_id,service_lan_vpn_feature_id"

        ```sh
        $ pulumi import sdwan:index/serviceLanVpnInterfaceSviFeature:ServiceLanVpnInterfaceSviFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac,140331f6-5418-4755-a059-13c77eb96037"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        :param pulumi.Input[builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureArpArgs', 'ServiceLanVpnInterfaceSviFeatureArpArgsDict']]]] arps: Configure static ARP entries
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_dhcpv6: Enable DHCPv6 - Default value: `false`
        :param pulumi.Input[builtins.str] enable_dhcpv6_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] icmp_redirect_disable: ICMP/ICMPv6 Redirect Disable - Default value: `true`
        :param pulumi.Input[builtins.str] icmp_redirect_disable_variable: Variable name
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.bool] ip_directed_broadcast: IP Directed-Broadcast - Default value: `false`
        :param pulumi.Input[builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address: IP Address
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[builtins.str] ipv4_dhcp_helpers_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgsDict']]]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgsDict']]]] ipv4_vrrps: Enable ipv4 VRRP
        :param pulumi.Input[builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgsDict']]]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgsDict']]]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgsDict']]]] ipv6_vrrps: Enable ipv6 VRRP
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceLanVpnInterfaceSviFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service LAN VPN Interface SVI Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_lan_vpn_interface_svi_feature_id,feature_profile_id,service_lan_vpn_feature_id"

        ```sh
        $ pulumi import sdwan:index/serviceLanVpnInterfaceSviFeature:ServiceLanVpnInterfaceSviFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac,140331f6-5418-4755-a059-13c77eb96037"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceLanVpnInterfaceSviFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceLanVpnInterfaceSviFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl_ipv4_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv4_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 acl_ipv6_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 arp_timeout: Optional[pulumi.Input[builtins.int]] = None,
                 arp_timeout_variable: Optional[pulumi.Input[builtins.str]] = None,
                 arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureArpArgs', 'ServiceLanVpnInterfaceSviFeatureArpArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable_dhcpv6: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_dhcpv6_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_redirect_disable: Optional[pulumi.Input[builtins.bool]] = None,
                 icmp_redirect_disable_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description: Optional[pulumi.Input[builtins.str]] = None,
                 interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name: Optional[pulumi.Input[builtins.str]] = None,
                 interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_directed_broadcast: Optional[pulumi.Input[builtins.bool]] = None,
                 ip_directed_broadcast_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
                 ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 ipv4_dhcp_helpers_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgsDict']]]]] = None,
                 ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgsDict']]]]] = None,
                 ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgsDict']]]]] = None,
                 ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgsDict']]]]] = None,
                 ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
                 shutdown: Optional[pulumi.Input[builtins.bool]] = None,
                 shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
                 tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
                 tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceLanVpnInterfaceSviFeatureArgs.__new__(ServiceLanVpnInterfaceSviFeatureArgs)

            __props__.__dict__["acl_ipv4_egress_feature_id"] = acl_ipv4_egress_feature_id
            __props__.__dict__["acl_ipv4_ingress_feature_id"] = acl_ipv4_ingress_feature_id
            __props__.__dict__["acl_ipv6_egress_feature_id"] = acl_ipv6_egress_feature_id
            __props__.__dict__["acl_ipv6_ingress_feature_id"] = acl_ipv6_ingress_feature_id
            __props__.__dict__["arp_timeout"] = arp_timeout
            __props__.__dict__["arp_timeout_variable"] = arp_timeout_variable
            __props__.__dict__["arps"] = arps
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_dhcpv6"] = enable_dhcpv6
            __props__.__dict__["enable_dhcpv6_variable"] = enable_dhcpv6_variable
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["icmp_redirect_disable"] = icmp_redirect_disable
            __props__.__dict__["icmp_redirect_disable_variable"] = icmp_redirect_disable_variable
            __props__.__dict__["interface_description"] = interface_description
            __props__.__dict__["interface_description_variable"] = interface_description_variable
            __props__.__dict__["interface_mtu"] = interface_mtu
            __props__.__dict__["interface_mtu_variable"] = interface_mtu_variable
            __props__.__dict__["interface_name"] = interface_name
            __props__.__dict__["interface_name_variable"] = interface_name_variable
            __props__.__dict__["ip_directed_broadcast"] = ip_directed_broadcast
            __props__.__dict__["ip_directed_broadcast_variable"] = ip_directed_broadcast_variable
            __props__.__dict__["ip_mtu"] = ip_mtu
            __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
            __props__.__dict__["ipv4_address"] = ipv4_address
            __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
            __props__.__dict__["ipv4_dhcp_helpers"] = ipv4_dhcp_helpers
            __props__.__dict__["ipv4_dhcp_helpers_variable"] = ipv4_dhcp_helpers_variable
            __props__.__dict__["ipv4_secondary_addresses"] = ipv4_secondary_addresses
            __props__.__dict__["ipv4_subnet_mask"] = ipv4_subnet_mask
            __props__.__dict__["ipv4_subnet_mask_variable"] = ipv4_subnet_mask_variable
            __props__.__dict__["ipv4_vrrps"] = ipv4_vrrps
            __props__.__dict__["ipv6_address"] = ipv6_address
            __props__.__dict__["ipv6_address_variable"] = ipv6_address_variable
            __props__.__dict__["ipv6_dhcp_helpers"] = ipv6_dhcp_helpers
            __props__.__dict__["ipv6_secondary_addresses"] = ipv6_secondary_addresses
            __props__.__dict__["ipv6_vrrps"] = ipv6_vrrps
            __props__.__dict__["name"] = name
            __props__.__dict__["service_lan_vpn_feature_id"] = service_lan_vpn_feature_id
            __props__.__dict__["shutdown"] = shutdown
            __props__.__dict__["shutdown_variable"] = shutdown_variable
            __props__.__dict__["tcp_mss"] = tcp_mss
            __props__.__dict__["tcp_mss_variable"] = tcp_mss_variable
            __props__.__dict__["version"] = None
        super(ServiceLanVpnInterfaceSviFeature, __self__).__init__(
            'sdwan:index/serviceLanVpnInterfaceSviFeature:ServiceLanVpnInterfaceSviFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl_ipv4_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
            acl_ipv4_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
            acl_ipv6_egress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
            acl_ipv6_ingress_feature_id: Optional[pulumi.Input[builtins.str]] = None,
            arp_timeout: Optional[pulumi.Input[builtins.int]] = None,
            arp_timeout_variable: Optional[pulumi.Input[builtins.str]] = None,
            arps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureArpArgs', 'ServiceLanVpnInterfaceSviFeatureArpArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable_dhcpv6: Optional[pulumi.Input[builtins.bool]] = None,
            enable_dhcpv6_variable: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            icmp_redirect_disable: Optional[pulumi.Input[builtins.bool]] = None,
            icmp_redirect_disable_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_description: Optional[pulumi.Input[builtins.str]] = None,
            interface_description_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_mtu: Optional[pulumi.Input[builtins.int]] = None,
            interface_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
            interface_name: Optional[pulumi.Input[builtins.str]] = None,
            interface_name_variable: Optional[pulumi.Input[builtins.str]] = None,
            ip_directed_broadcast: Optional[pulumi.Input[builtins.bool]] = None,
            ip_directed_broadcast_variable: Optional[pulumi.Input[builtins.str]] = None,
            ip_mtu: Optional[pulumi.Input[builtins.int]] = None,
            ip_mtu_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            ipv4_dhcp_helpers_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgsDict']]]]] = None,
            ipv4_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv4_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgsDict']]]]] = None,
            ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            ipv6_dhcp_helpers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgsDict']]]]] = None,
            ipv6_secondary_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgsDict']]]]] = None,
            ipv6_vrrps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            service_lan_vpn_feature_id: Optional[pulumi.Input[builtins.str]] = None,
            shutdown: Optional[pulumi.Input[builtins.bool]] = None,
            shutdown_variable: Optional[pulumi.Input[builtins.str]] = None,
            tcp_mss: Optional[pulumi.Input[builtins.int]] = None,
            tcp_mss_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ServiceLanVpnInterfaceSviFeature':
        """
        Get an existing ServiceLanVpnInterfaceSviFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] arp_timeout: Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        :param pulumi.Input[builtins.str] arp_timeout_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureArpArgs', 'ServiceLanVpnInterfaceSviFeatureArpArgsDict']]]] arps: Configure static ARP entries
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable_dhcpv6: Enable DHCPv6 - Default value: `false`
        :param pulumi.Input[builtins.str] enable_dhcpv6_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] icmp_redirect_disable: ICMP/ICMPv6 Redirect Disable - Default value: `true`
        :param pulumi.Input[builtins.str] icmp_redirect_disable_variable: Variable name
        :param pulumi.Input[builtins.str] interface_description: Interface description
        :param pulumi.Input[builtins.str] interface_description_variable: Variable name
        :param pulumi.Input[builtins.int] interface_mtu: Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] interface_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] interface_name: Interface name: VLAN 1 - VLAN 4094 when present
        :param pulumi.Input[builtins.str] interface_name_variable: Variable name
        :param pulumi.Input[builtins.bool] ip_directed_broadcast: IP Directed-Broadcast - Default value: `false`
        :param pulumi.Input[builtins.str] ip_directed_broadcast_variable: Variable name
        :param pulumi.Input[builtins.int] ip_mtu: IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        :param pulumi.Input[builtins.str] ip_mtu_variable: Variable name
        :param pulumi.Input[builtins.str] ipv4_address: IP Address
        :param pulumi.Input[builtins.str] ipv4_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipv4_dhcp_helpers: List of DHCP helper addresses
        :param pulumi.Input[builtins.str] ipv4_dhcp_helpers_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddressArgsDict']]]] ipv4_secondary_addresses: Assign secondary IP addresses
        :param pulumi.Input[builtins.str] ipv4_subnet_mask: Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
               `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
               `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
               `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
               `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] ipv4_subnet_mask_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv4VrrpArgsDict']]]] ipv4_vrrps: Enable ipv4 VRRP
        :param pulumi.Input[builtins.str] ipv6_address: Assign IPv6 address
        :param pulumi.Input[builtins.str] ipv6_address_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelperArgsDict']]]] ipv6_dhcp_helpers: DHCPv6 Helper
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddressArgsDict']]]] ipv6_secondary_addresses: Assign secondary IPv6 addresses
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgs', 'ServiceLanVpnInterfaceSviFeatureIpv6VrrpArgsDict']]]] ipv6_vrrps: Enable ipv6 VRRP
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] service_lan_vpn_feature_id: Service LAN VPN Feature ID
        :param pulumi.Input[builtins.bool] shutdown: Administrative state - Default value: `true`
        :param pulumi.Input[builtins.str] shutdown_variable: Variable name
        :param pulumi.Input[builtins.int] tcp_mss: TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        :param pulumi.Input[builtins.str] tcp_mss_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceLanVpnInterfaceSviFeatureState.__new__(_ServiceLanVpnInterfaceSviFeatureState)

        __props__.__dict__["acl_ipv4_egress_feature_id"] = acl_ipv4_egress_feature_id
        __props__.__dict__["acl_ipv4_ingress_feature_id"] = acl_ipv4_ingress_feature_id
        __props__.__dict__["acl_ipv6_egress_feature_id"] = acl_ipv6_egress_feature_id
        __props__.__dict__["acl_ipv6_ingress_feature_id"] = acl_ipv6_ingress_feature_id
        __props__.__dict__["arp_timeout"] = arp_timeout
        __props__.__dict__["arp_timeout_variable"] = arp_timeout_variable
        __props__.__dict__["arps"] = arps
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_dhcpv6"] = enable_dhcpv6
        __props__.__dict__["enable_dhcpv6_variable"] = enable_dhcpv6_variable
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["icmp_redirect_disable"] = icmp_redirect_disable
        __props__.__dict__["icmp_redirect_disable_variable"] = icmp_redirect_disable_variable
        __props__.__dict__["interface_description"] = interface_description
        __props__.__dict__["interface_description_variable"] = interface_description_variable
        __props__.__dict__["interface_mtu"] = interface_mtu
        __props__.__dict__["interface_mtu_variable"] = interface_mtu_variable
        __props__.__dict__["interface_name"] = interface_name
        __props__.__dict__["interface_name_variable"] = interface_name_variable
        __props__.__dict__["ip_directed_broadcast"] = ip_directed_broadcast
        __props__.__dict__["ip_directed_broadcast_variable"] = ip_directed_broadcast_variable
        __props__.__dict__["ip_mtu"] = ip_mtu
        __props__.__dict__["ip_mtu_variable"] = ip_mtu_variable
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_address_variable"] = ipv4_address_variable
        __props__.__dict__["ipv4_dhcp_helpers"] = ipv4_dhcp_helpers
        __props__.__dict__["ipv4_dhcp_helpers_variable"] = ipv4_dhcp_helpers_variable
        __props__.__dict__["ipv4_secondary_addresses"] = ipv4_secondary_addresses
        __props__.__dict__["ipv4_subnet_mask"] = ipv4_subnet_mask
        __props__.__dict__["ipv4_subnet_mask_variable"] = ipv4_subnet_mask_variable
        __props__.__dict__["ipv4_vrrps"] = ipv4_vrrps
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_address_variable"] = ipv6_address_variable
        __props__.__dict__["ipv6_dhcp_helpers"] = ipv6_dhcp_helpers
        __props__.__dict__["ipv6_secondary_addresses"] = ipv6_secondary_addresses
        __props__.__dict__["ipv6_vrrps"] = ipv6_vrrps
        __props__.__dict__["name"] = name
        __props__.__dict__["service_lan_vpn_feature_id"] = service_lan_vpn_feature_id
        __props__.__dict__["shutdown"] = shutdown
        __props__.__dict__["shutdown_variable"] = shutdown_variable
        __props__.__dict__["tcp_mss"] = tcp_mss
        __props__.__dict__["tcp_mss_variable"] = tcp_mss_variable
        __props__.__dict__["version"] = version
        return ServiceLanVpnInterfaceSviFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aclIpv4EgressFeatureId")
    def acl_ipv4_egress_feature_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "acl_ipv4_egress_feature_id")

    @property
    @pulumi.getter(name="aclIpv4IngressFeatureId")
    def acl_ipv4_ingress_feature_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "acl_ipv4_ingress_feature_id")

    @property
    @pulumi.getter(name="aclIpv6EgressFeatureId")
    def acl_ipv6_egress_feature_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "acl_ipv6_egress_feature_id")

    @property
    @pulumi.getter(name="aclIpv6IngressFeatureId")
    def acl_ipv6_ingress_feature_id(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "acl_ipv6_ingress_feature_id")

    @property
    @pulumi.getter(name="arpTimeout")
    def arp_timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Timeout value for dynamically learned ARP entries, <0..2678400> seconds - Range: `0`-`2678400` - Default value: `1200`
        """
        return pulumi.get(self, "arp_timeout")

    @property
    @pulumi.getter(name="arpTimeoutVariable")
    def arp_timeout_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "arp_timeout_variable")

    @property
    @pulumi.getter
    def arps(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnInterfaceSviFeatureArp']]]:
        """
        Configure static ARP entries
        """
        return pulumi.get(self, "arps")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableDhcpv6")
    def enable_dhcpv6(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable DHCPv6 - Default value: `false`
        """
        return pulumi.get(self, "enable_dhcpv6")

    @property
    @pulumi.getter(name="enableDhcpv6Variable")
    def enable_dhcpv6_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable_dhcpv6_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="icmpRedirectDisable")
    def icmp_redirect_disable(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        ICMP/ICMPv6 Redirect Disable - Default value: `true`
        """
        return pulumi.get(self, "icmp_redirect_disable")

    @property
    @pulumi.getter(name="icmpRedirectDisableVariable")
    def icmp_redirect_disable_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "icmp_redirect_disable_variable")

    @property
    @pulumi.getter(name="interfaceDescription")
    def interface_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface description
        """
        return pulumi.get(self, "interface_description")

    @property
    @pulumi.getter(name="interfaceDescriptionVariable")
    def interface_description_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_description_variable")

    @property
    @pulumi.getter(name="interfaceMtu")
    def interface_mtu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Interface MTU <1500..9216> in bytes - Range: `1500`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "interface_mtu")

    @property
    @pulumi.getter(name="interfaceMtuVariable")
    def interface_mtu_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_mtu_variable")

    @property
    @pulumi.getter(name="interfaceName")
    def interface_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Interface name: VLAN 1 - VLAN 4094 when present
        """
        return pulumi.get(self, "interface_name")

    @property
    @pulumi.getter(name="interfaceNameVariable")
    def interface_name_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "interface_name_variable")

    @property
    @pulumi.getter(name="ipDirectedBroadcast")
    def ip_directed_broadcast(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        IP Directed-Broadcast - Default value: `false`
        """
        return pulumi.get(self, "ip_directed_broadcast")

    @property
    @pulumi.getter(name="ipDirectedBroadcastVariable")
    def ip_directed_broadcast_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_directed_broadcast_variable")

    @property
    @pulumi.getter(name="ipMtu")
    def ip_mtu(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        IP MTU <576..Interface MTU>, in bytes - Range: `576`-`9216` - Default value: `1500`
        """
        return pulumi.get(self, "ip_mtu")

    @property
    @pulumi.getter(name="ipMtuVariable")
    def ip_mtu_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ip_mtu_variable")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        IP Address
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4AddressVariable")
    def ipv4_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_address_variable")

    @property
    @pulumi.getter(name="ipv4DhcpHelpers")
    def ipv4_dhcp_helpers(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        List of DHCP helper addresses
        """
        return pulumi.get(self, "ipv4_dhcp_helpers")

    @property
    @pulumi.getter(name="ipv4DhcpHelpersVariable")
    def ipv4_dhcp_helpers_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_dhcp_helpers_variable")

    @property
    @pulumi.getter(name="ipv4SecondaryAddresses")
    def ipv4_secondary_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnInterfaceSviFeatureIpv4SecondaryAddress']]]:
        """
        Assign secondary IP addresses
        """
        return pulumi.get(self, "ipv4_secondary_addresses")

    @property
    @pulumi.getter(name="ipv4SubnetMask")
    def ipv4_subnet_mask(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Subnet Mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`, `255.255.255.248`, `255.255.255.240`,
        `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`, `255.255.254.0`, `255.255.252.0`,
        `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`, `255.255.0.0`, `255.254.0.0`,
        `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`, `254.0.0.0`, `252.0.0.0`,
        `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "ipv4_subnet_mask")

    @property
    @pulumi.getter(name="ipv4SubnetMaskVariable")
    def ipv4_subnet_mask_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv4_subnet_mask_variable")

    @property
    @pulumi.getter(name="ipv4Vrrps")
    def ipv4_vrrps(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnInterfaceSviFeatureIpv4Vrrp']]]:
        """
        Enable ipv4 VRRP
        """
        return pulumi.get(self, "ipv4_vrrps")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Assign IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6AddressVariable")
    def ipv6_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "ipv6_address_variable")

    @property
    @pulumi.getter(name="ipv6DhcpHelpers")
    def ipv6_dhcp_helpers(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnInterfaceSviFeatureIpv6DhcpHelper']]]:
        """
        DHCPv6 Helper
        """
        return pulumi.get(self, "ipv6_dhcp_helpers")

    @property
    @pulumi.getter(name="ipv6SecondaryAddresses")
    def ipv6_secondary_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnInterfaceSviFeatureIpv6SecondaryAddress']]]:
        """
        Assign secondary IPv6 addresses
        """
        return pulumi.get(self, "ipv6_secondary_addresses")

    @property
    @pulumi.getter(name="ipv6Vrrps")
    def ipv6_vrrps(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceLanVpnInterfaceSviFeatureIpv6Vrrp']]]:
        """
        Enable ipv6 VRRP
        """
        return pulumi.get(self, "ipv6_vrrps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serviceLanVpnFeatureId")
    def service_lan_vpn_feature_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Service LAN VPN Feature ID
        """
        return pulumi.get(self, "service_lan_vpn_feature_id")

    @property
    @pulumi.getter
    def shutdown(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Administrative state - Default value: `true`
        """
        return pulumi.get(self, "shutdown")

    @property
    @pulumi.getter(name="shutdownVariable")
    def shutdown_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "shutdown_variable")

    @property
    @pulumi.getter(name="tcpMss")
    def tcp_mss(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        TCP MSS on SYN packets, in bytes - Range: `552`-`1960`
        """
        return pulumi.get(self, "tcp_mss")

    @property
    @pulumi.getter(name="tcpMssVariable")
    def tcp_mss_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "tcp_mss_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

