# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceWirelessLanFeatureArgs', 'ServiceWirelessLanFeature']

@pulumi.input_type
class ServiceWirelessLanFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 me_dynamic_ip_enabled: pulumi.Input[builtins.bool],
                 ssids: pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]],
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 country_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable24g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable24g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 enable5g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable5g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 me_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 username_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ServiceWirelessLanFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.bool] me_dynamic_ip_enabled: ME management IP dynamic allocated by DHCP
        :param pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]] ssids: Configure Wi-Fi SSID profile
        :param pulumi.Input[builtins.str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[builtins.str] country_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable24g: 2.4GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable24g_variable: Variable name
        :param pulumi.Input[builtins.bool] enable5g: 5GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable5g_variable: Variable name
        :param pulumi.Input[builtins.str] me_default_gateway: Set mobile express default gateway
        :param pulumi.Input[builtins.str] me_default_gateway_variable: Variable name
        :param pulumi.Input[builtins.str] me_ipv4_address: Set mobile express controller address
        :param pulumi.Input[builtins.str] me_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] me_subnet_mask: Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
               `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
               `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
               `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
               `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] me_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] password: Set management password,the password must contains characters from all of the following classes,lowercase
               letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
               times consecutively. The password must not be the same as the associated username or the username reversed. The password
               must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
               addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        :param pulumi.Input[builtins.str] password_variable: Variable name
        :param pulumi.Input[builtins.str] username: Set management username
        :param pulumi.Input[builtins.str] username_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "me_dynamic_ip_enabled", me_dynamic_ip_enabled)
        pulumi.set(__self__, "ssids", ssids)
        if country is not None:
            pulumi.set(__self__, "country", country)
        if country_variable is not None:
            pulumi.set(__self__, "country_variable", country_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable24g is not None:
            pulumi.set(__self__, "enable24g", enable24g)
        if enable24g_variable is not None:
            pulumi.set(__self__, "enable24g_variable", enable24g_variable)
        if enable5g is not None:
            pulumi.set(__self__, "enable5g", enable5g)
        if enable5g_variable is not None:
            pulumi.set(__self__, "enable5g_variable", enable5g_variable)
        if me_default_gateway is not None:
            pulumi.set(__self__, "me_default_gateway", me_default_gateway)
        if me_default_gateway_variable is not None:
            pulumi.set(__self__, "me_default_gateway_variable", me_default_gateway_variable)
        if me_ipv4_address is not None:
            pulumi.set(__self__, "me_ipv4_address", me_ipv4_address)
        if me_ipv4_address_variable is not None:
            pulumi.set(__self__, "me_ipv4_address_variable", me_ipv4_address_variable)
        if me_subnet_mask is not None:
            pulumi.set(__self__, "me_subnet_mask", me_subnet_mask)
        if me_subnet_mask_variable is not None:
            pulumi.set(__self__, "me_subnet_mask_variable", me_subnet_mask_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_variable is not None:
            pulumi.set(__self__, "password_variable", password_variable)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_variable is not None:
            pulumi.set(__self__, "username_variable", username_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="meDynamicIpEnabled")
    def me_dynamic_ip_enabled(self) -> pulumi.Input[builtins.bool]:
        """
        ME management IP dynamic allocated by DHCP
        """
        return pulumi.get(self, "me_dynamic_ip_enabled")

    @me_dynamic_ip_enabled.setter
    def me_dynamic_ip_enabled(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "me_dynamic_ip_enabled", value)

    @property
    @pulumi.getter
    def ssids(self) -> pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]]:
        """
        Configure Wi-Fi SSID profile
        """
        return pulumi.get(self, "ssids")

    @ssids.setter
    def ssids(self, value: pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]]):
        pulumi.set(self, "ssids", value)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
        `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
        `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
        `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
        `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
        `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @country_variable.setter
    def country_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enable24g(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        2.4GHz Enabled - Default value: `true`
        """
        return pulumi.get(self, "enable24g")

    @enable24g.setter
    def enable24g(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable24g", value)

    @property
    @pulumi.getter(name="enable24gVariable")
    def enable24g_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable24g_variable")

    @enable24g_variable.setter
    def enable24g_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable24g_variable", value)

    @property
    @pulumi.getter
    def enable5g(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        5GHz Enabled - Default value: `true`
        """
        return pulumi.get(self, "enable5g")

    @enable5g.setter
    def enable5g(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable5g", value)

    @property
    @pulumi.getter(name="enable5gVariable")
    def enable5g_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable5g_variable")

    @enable5g_variable.setter
    def enable5g_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable5g_variable", value)

    @property
    @pulumi.getter(name="meDefaultGateway")
    def me_default_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set mobile express default gateway
        """
        return pulumi.get(self, "me_default_gateway")

    @me_default_gateway.setter
    def me_default_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_default_gateway", value)

    @property
    @pulumi.getter(name="meDefaultGatewayVariable")
    def me_default_gateway_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_default_gateway_variable")

    @me_default_gateway_variable.setter
    def me_default_gateway_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_default_gateway_variable", value)

    @property
    @pulumi.getter(name="meIpv4Address")
    def me_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set mobile express controller address
        """
        return pulumi.get(self, "me_ipv4_address")

    @me_ipv4_address.setter
    def me_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_ipv4_address", value)

    @property
    @pulumi.getter(name="meIpv4AddressVariable")
    def me_ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_ipv4_address_variable")

    @me_ipv4_address_variable.setter
    def me_ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_ipv4_address_variable", value)

    @property
    @pulumi.getter(name="meSubnetMask")
    def me_subnet_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
        `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
        `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
        `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
        `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "me_subnet_mask")

    @me_subnet_mask.setter
    def me_subnet_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_subnet_mask", value)

    @property
    @pulumi.getter(name="meSubnetMaskVariable")
    def me_subnet_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_subnet_mask_variable")

    @me_subnet_mask_variable.setter
    def me_subnet_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_subnet_mask_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set management password,the password must contains characters from all of the following classes,lowercase
        letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
        times consecutively. The password must not be the same as the associated username or the username reversed. The password
        must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
        addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @password_variable.setter
    def password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password_variable", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @username_variable.setter
    def username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username_variable", value)


@pulumi.input_type
class _ServiceWirelessLanFeatureState:
    def __init__(__self__, *,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 country_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable24g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable24g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 enable5g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable5g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_dynamic_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 me_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 me_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ServiceWirelessLanFeature resources.
        :param pulumi.Input[builtins.str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[builtins.str] country_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable24g: 2.4GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable24g_variable: Variable name
        :param pulumi.Input[builtins.bool] enable5g: 5GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable5g_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] me_default_gateway: Set mobile express default gateway
        :param pulumi.Input[builtins.str] me_default_gateway_variable: Variable name
        :param pulumi.Input[builtins.bool] me_dynamic_ip_enabled: ME management IP dynamic allocated by DHCP
        :param pulumi.Input[builtins.str] me_ipv4_address: Set mobile express controller address
        :param pulumi.Input[builtins.str] me_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] me_subnet_mask: Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
               `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
               `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
               `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
               `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] me_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] password: Set management password,the password must contains characters from all of the following classes,lowercase
               letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
               times consecutively. The password must not be the same as the associated username or the username reversed. The password
               must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
               addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        :param pulumi.Input[builtins.str] password_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]] ssids: Configure Wi-Fi SSID profile
        :param pulumi.Input[builtins.str] username: Set management username
        :param pulumi.Input[builtins.str] username_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if country is not None:
            pulumi.set(__self__, "country", country)
        if country_variable is not None:
            pulumi.set(__self__, "country_variable", country_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable24g is not None:
            pulumi.set(__self__, "enable24g", enable24g)
        if enable24g_variable is not None:
            pulumi.set(__self__, "enable24g_variable", enable24g_variable)
        if enable5g is not None:
            pulumi.set(__self__, "enable5g", enable5g)
        if enable5g_variable is not None:
            pulumi.set(__self__, "enable5g_variable", enable5g_variable)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if me_default_gateway is not None:
            pulumi.set(__self__, "me_default_gateway", me_default_gateway)
        if me_default_gateway_variable is not None:
            pulumi.set(__self__, "me_default_gateway_variable", me_default_gateway_variable)
        if me_dynamic_ip_enabled is not None:
            pulumi.set(__self__, "me_dynamic_ip_enabled", me_dynamic_ip_enabled)
        if me_ipv4_address is not None:
            pulumi.set(__self__, "me_ipv4_address", me_ipv4_address)
        if me_ipv4_address_variable is not None:
            pulumi.set(__self__, "me_ipv4_address_variable", me_ipv4_address_variable)
        if me_subnet_mask is not None:
            pulumi.set(__self__, "me_subnet_mask", me_subnet_mask)
        if me_subnet_mask_variable is not None:
            pulumi.set(__self__, "me_subnet_mask_variable", me_subnet_mask_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_variable is not None:
            pulumi.set(__self__, "password_variable", password_variable)
        if ssids is not None:
            pulumi.set(__self__, "ssids", ssids)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if username_variable is not None:
            pulumi.set(__self__, "username_variable", username_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def country(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
        `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
        `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
        `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
        `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
        `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        """
        return pulumi.get(self, "country")

    @country.setter
    def country(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country", value)

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @country_variable.setter
    def country_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "country_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def enable24g(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        2.4GHz Enabled - Default value: `true`
        """
        return pulumi.get(self, "enable24g")

    @enable24g.setter
    def enable24g(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable24g", value)

    @property
    @pulumi.getter(name="enable24gVariable")
    def enable24g_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable24g_variable")

    @enable24g_variable.setter
    def enable24g_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable24g_variable", value)

    @property
    @pulumi.getter
    def enable5g(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        5GHz Enabled - Default value: `true`
        """
        return pulumi.get(self, "enable5g")

    @enable5g.setter
    def enable5g(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable5g", value)

    @property
    @pulumi.getter(name="enable5gVariable")
    def enable5g_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable5g_variable")

    @enable5g_variable.setter
    def enable5g_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enable5g_variable", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="meDefaultGateway")
    def me_default_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set mobile express default gateway
        """
        return pulumi.get(self, "me_default_gateway")

    @me_default_gateway.setter
    def me_default_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_default_gateway", value)

    @property
    @pulumi.getter(name="meDefaultGatewayVariable")
    def me_default_gateway_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_default_gateway_variable")

    @me_default_gateway_variable.setter
    def me_default_gateway_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_default_gateway_variable", value)

    @property
    @pulumi.getter(name="meDynamicIpEnabled")
    def me_dynamic_ip_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        ME management IP dynamic allocated by DHCP
        """
        return pulumi.get(self, "me_dynamic_ip_enabled")

    @me_dynamic_ip_enabled.setter
    def me_dynamic_ip_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "me_dynamic_ip_enabled", value)

    @property
    @pulumi.getter(name="meIpv4Address")
    def me_ipv4_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set mobile express controller address
        """
        return pulumi.get(self, "me_ipv4_address")

    @me_ipv4_address.setter
    def me_ipv4_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_ipv4_address", value)

    @property
    @pulumi.getter(name="meIpv4AddressVariable")
    def me_ipv4_address_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_ipv4_address_variable")

    @me_ipv4_address_variable.setter
    def me_ipv4_address_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_ipv4_address_variable", value)

    @property
    @pulumi.getter(name="meSubnetMask")
    def me_subnet_mask(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
        `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
        `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
        `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
        `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "me_subnet_mask")

    @me_subnet_mask.setter
    def me_subnet_mask(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_subnet_mask", value)

    @property
    @pulumi.getter(name="meSubnetMaskVariable")
    def me_subnet_mask_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_subnet_mask_variable")

    @me_subnet_mask_variable.setter
    def me_subnet_mask_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "me_subnet_mask_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set management password,the password must contains characters from all of the following classes,lowercase
        letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
        times consecutively. The password must not be the same as the associated username or the username reversed. The password
        must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
        addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @password_variable.setter
    def password_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password_variable", value)

    @property
    @pulumi.getter
    def ssids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]]]:
        """
        Configure Wi-Fi SSID profile
        """
        return pulumi.get(self, "ssids")

    @ssids.setter
    def ssids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceWirelessLanFeatureSsidArgs']]]]):
        pulumi.set(self, "ssids", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @username_variable.setter
    def username_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/serviceWirelessLanFeature:ServiceWirelessLanFeature")
class ServiceWirelessLanFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 country_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable24g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable24g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 enable5g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable5g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_dynamic_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 me_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 me_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceWirelessLanFeatureSsidArgs', 'ServiceWirelessLanFeatureSsidArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Service Wireless LAN Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_wireless_lan_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceWirelessLanFeature:ServiceWirelessLanFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[builtins.str] country_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable24g: 2.4GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable24g_variable: Variable name
        :param pulumi.Input[builtins.bool] enable5g: 5GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable5g_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] me_default_gateway: Set mobile express default gateway
        :param pulumi.Input[builtins.str] me_default_gateway_variable: Variable name
        :param pulumi.Input[builtins.bool] me_dynamic_ip_enabled: ME management IP dynamic allocated by DHCP
        :param pulumi.Input[builtins.str] me_ipv4_address: Set mobile express controller address
        :param pulumi.Input[builtins.str] me_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] me_subnet_mask: Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
               `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
               `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
               `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
               `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] me_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] password: Set management password,the password must contains characters from all of the following classes,lowercase
               letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
               times consecutively. The password must not be the same as the associated username or the username reversed. The password
               must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
               addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        :param pulumi.Input[builtins.str] password_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceWirelessLanFeatureSsidArgs', 'ServiceWirelessLanFeatureSsidArgsDict']]]] ssids: Configure Wi-Fi SSID profile
        :param pulumi.Input[builtins.str] username: Set management username
        :param pulumi.Input[builtins.str] username_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceWirelessLanFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Service Wireless LAN Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "service_wireless_lan_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/serviceWirelessLanFeature:ServiceWirelessLanFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param ServiceWirelessLanFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceWirelessLanFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 country: Optional[pulumi.Input[builtins.str]] = None,
                 country_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 enable24g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable24g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 enable5g: Optional[pulumi.Input[builtins.bool]] = None,
                 enable5g_variable: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 me_default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_dynamic_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 me_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
                 me_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
                 me_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 password_variable: Optional[pulumi.Input[builtins.str]] = None,
                 ssids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceWirelessLanFeatureSsidArgs', 'ServiceWirelessLanFeatureSsidArgsDict']]]]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 username_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceWirelessLanFeatureArgs.__new__(ServiceWirelessLanFeatureArgs)

            __props__.__dict__["country"] = country
            __props__.__dict__["country_variable"] = country_variable
            __props__.__dict__["description"] = description
            __props__.__dict__["enable24g"] = enable24g
            __props__.__dict__["enable24g_variable"] = enable24g_variable
            __props__.__dict__["enable5g"] = enable5g
            __props__.__dict__["enable5g_variable"] = enable5g_variable
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["me_default_gateway"] = me_default_gateway
            __props__.__dict__["me_default_gateway_variable"] = me_default_gateway_variable
            if me_dynamic_ip_enabled is None and not opts.urn:
                raise TypeError("Missing required property 'me_dynamic_ip_enabled'")
            __props__.__dict__["me_dynamic_ip_enabled"] = me_dynamic_ip_enabled
            __props__.__dict__["me_ipv4_address"] = me_ipv4_address
            __props__.__dict__["me_ipv4_address_variable"] = me_ipv4_address_variable
            __props__.__dict__["me_subnet_mask"] = me_subnet_mask
            __props__.__dict__["me_subnet_mask_variable"] = me_subnet_mask_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = password
            __props__.__dict__["password_variable"] = password_variable
            if ssids is None and not opts.urn:
                raise TypeError("Missing required property 'ssids'")
            __props__.__dict__["ssids"] = ssids
            __props__.__dict__["username"] = username
            __props__.__dict__["username_variable"] = username_variable
            __props__.__dict__["version"] = None
        super(ServiceWirelessLanFeature, __self__).__init__(
            'sdwan:index/serviceWirelessLanFeature:ServiceWirelessLanFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            country: Optional[pulumi.Input[builtins.str]] = None,
            country_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            enable24g: Optional[pulumi.Input[builtins.bool]] = None,
            enable24g_variable: Optional[pulumi.Input[builtins.str]] = None,
            enable5g: Optional[pulumi.Input[builtins.bool]] = None,
            enable5g_variable: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            me_default_gateway: Optional[pulumi.Input[builtins.str]] = None,
            me_default_gateway_variable: Optional[pulumi.Input[builtins.str]] = None,
            me_dynamic_ip_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            me_ipv4_address: Optional[pulumi.Input[builtins.str]] = None,
            me_ipv4_address_variable: Optional[pulumi.Input[builtins.str]] = None,
            me_subnet_mask: Optional[pulumi.Input[builtins.str]] = None,
            me_subnet_mask_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            password_variable: Optional[pulumi.Input[builtins.str]] = None,
            ssids: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceWirelessLanFeatureSsidArgs', 'ServiceWirelessLanFeatureSsidArgsDict']]]]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None,
            username_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'ServiceWirelessLanFeature':
        """
        Get an existing ServiceWirelessLanFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] country: Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
               `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
               `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
               `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
               `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
               `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        :param pulumi.Input[builtins.str] country_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.bool] enable24g: 2.4GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable24g_variable: Variable name
        :param pulumi.Input[builtins.bool] enable5g: 5GHz Enabled - Default value: `true`
        :param pulumi.Input[builtins.str] enable5g_variable: Variable name
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] me_default_gateway: Set mobile express default gateway
        :param pulumi.Input[builtins.str] me_default_gateway_variable: Variable name
        :param pulumi.Input[builtins.bool] me_dynamic_ip_enabled: ME management IP dynamic allocated by DHCP
        :param pulumi.Input[builtins.str] me_ipv4_address: Set mobile express controller address
        :param pulumi.Input[builtins.str] me_ipv4_address_variable: Variable name
        :param pulumi.Input[builtins.str] me_subnet_mask: Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
               `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
               `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
               `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
               `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        :param pulumi.Input[builtins.str] me_subnet_mask_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] password: Set management password,the password must contains characters from all of the following classes,lowercase
               letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
               times consecutively. The password must not be the same as the associated username or the username reversed. The password
               must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
               addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        :param pulumi.Input[builtins.str] password_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceWirelessLanFeatureSsidArgs', 'ServiceWirelessLanFeatureSsidArgsDict']]]] ssids: Configure Wi-Fi SSID profile
        :param pulumi.Input[builtins.str] username: Set management username
        :param pulumi.Input[builtins.str] username_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceWirelessLanFeatureState.__new__(_ServiceWirelessLanFeatureState)

        __props__.__dict__["country"] = country
        __props__.__dict__["country_variable"] = country_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["enable24g"] = enable24g
        __props__.__dict__["enable24g_variable"] = enable24g_variable
        __props__.__dict__["enable5g"] = enable5g
        __props__.__dict__["enable5g_variable"] = enable5g_variable
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["me_default_gateway"] = me_default_gateway
        __props__.__dict__["me_default_gateway_variable"] = me_default_gateway_variable
        __props__.__dict__["me_dynamic_ip_enabled"] = me_dynamic_ip_enabled
        __props__.__dict__["me_ipv4_address"] = me_ipv4_address
        __props__.__dict__["me_ipv4_address_variable"] = me_ipv4_address_variable
        __props__.__dict__["me_subnet_mask"] = me_subnet_mask
        __props__.__dict__["me_subnet_mask_variable"] = me_subnet_mask_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["password_variable"] = password_variable
        __props__.__dict__["ssids"] = ssids
        __props__.__dict__["username"] = username
        __props__.__dict__["username_variable"] = username_variable
        __props__.__dict__["version"] = version
        return ServiceWirelessLanFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def country(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Select country - Choices: `AE`, `AR`, `AT`, `AU`, `BA`, `BB`, `BE`, `BG`, `BH`, `BN`, `BO`, `BR`, `BY`, `CA`, `CA2`,
        `CH`, `CL`, `CM`, `CN`, `CO`, `CR`, `CY`, `CZ`, `DE`, `DK`, `DO`, `DZ`, `EC`, `EE`, `EG`, `ES`, `FI`, `FJ`, `FR`, `GB`,
        `GH`, `GI`, `GR`, `HK`, `HR`, `HU`, `ID`, `IE`, `IL`, `IO`, `IN`, `IQ`, `IS`, `IT`, `J2`, `J4`, `JM`, `JO`, `KE`, `KN`,
        `KW`, `KZ`, `LB`, `LI`, `LK`, `LT`, `LU`, `LV`, `LY`, `MA`, `MC`, `ME`, `MK`, `MN`, `MO`, `MT`, `MX`, `MY`, `NL`, `NO`,
        `NZ`, `OM`, `PA`, `PE`, `PH`, `PH2`, `PK`, `PL`, `PR`, `PT`, `PY`, `QA`, `RO`, `RS`, `RU`, `SA`, `SE`, `SG`, `SI`, `SK`,
        `TH`, `TN`, `TR`, `TW`, `UA`, `US`, `UY`, `VE`, `VN`, `ZA`
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter(name="countryVariable")
    def country_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "country_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enable24g(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        2.4GHz Enabled - Default value: `true`
        """
        return pulumi.get(self, "enable24g")

    @property
    @pulumi.getter(name="enable24gVariable")
    def enable24g_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable24g_variable")

    @property
    @pulumi.getter
    def enable5g(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        5GHz Enabled - Default value: `true`
        """
        return pulumi.get(self, "enable5g")

    @property
    @pulumi.getter(name="enable5gVariable")
    def enable5g_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "enable5g_variable")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter(name="meDefaultGateway")
    def me_default_gateway(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set mobile express default gateway
        """
        return pulumi.get(self, "me_default_gateway")

    @property
    @pulumi.getter(name="meDefaultGatewayVariable")
    def me_default_gateway_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_default_gateway_variable")

    @property
    @pulumi.getter(name="meDynamicIpEnabled")
    def me_dynamic_ip_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        ME management IP dynamic allocated by DHCP
        """
        return pulumi.get(self, "me_dynamic_ip_enabled")

    @property
    @pulumi.getter(name="meIpv4Address")
    def me_ipv4_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set mobile express controller address
        """
        return pulumi.get(self, "me_ipv4_address")

    @property
    @pulumi.getter(name="meIpv4AddressVariable")
    def me_ipv4_address_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_ipv4_address_variable")

    @property
    @pulumi.getter(name="meSubnetMask")
    def me_subnet_mask(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set mobile express controller subnet mask - Choices: `255.255.255.255`, `255.255.255.254`, `255.255.255.252`,
        `255.255.255.248`, `255.255.255.240`, `255.255.255.224`, `255.255.255.192`, `255.255.255.128`, `255.255.255.0`,
        `255.255.254.0`, `255.255.252.0`, `255.255.248.0`, `255.255.240.0`, `255.255.224.0`, `255.255.192.0`, `255.255.128.0`,
        `255.255.0.0`, `255.254.0.0`, `255.252.0.0`, `255.240.0.0`, `255.224.0.0`, `255.192.0.0`, `255.128.0.0`, `255.0.0.0`,
        `254.0.0.0`, `252.0.0.0`, `248.0.0.0`, `240.0.0.0`, `224.0.0.0`, `192.0.0.0`, `128.0.0.0`, `0.0.0.0`
        """
        return pulumi.get(self, "me_subnet_mask")

    @property
    @pulumi.getter(name="meSubnetMaskVariable")
    def me_subnet_mask_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "me_subnet_mask_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set management password,the password must contains characters from all of the following classes,lowercase
        letters,uppercase letters,digits,and special characters. No character in the password can be repeated more than three
        times consecutively. The password must not be the same as the associated username or the username reversed. The password
        must not be cisco,ocsic,or any variant obtained by changing the capitalization of the letters in word cisco. In
        addition,you can't substitute 1,l,or ! for i,0 for o,$ for s.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="passwordVariable")
    def password_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "password_variable")

    @property
    @pulumi.getter
    def ssids(self) -> pulumi.Output[Sequence['outputs.ServiceWirelessLanFeatureSsid']]:
        """
        Configure Wi-Fi SSID profile
        """
        return pulumi.get(self, "ssids")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Set management username
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="usernameVariable")
    def username_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "username_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

