# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchportFeatureTemplateArgs', 'SwitchportFeatureTemplate']

@pulumi.input_type
class SwitchportFeatureTemplateArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[builtins.str],
                 device_types: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 age_out_time: Optional[pulumi.Input[builtins.int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]]] = None,
                 module_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.int]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]]] = None,
                 sub_slot: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a SwitchportFeatureTemplate resource.
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[builtins.int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[builtins.str] age_out_time_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[builtins.str] module_type: Module type - Choices: `4`, `8`, `22`, `50`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] slot: Number of Slots - Range: `0`-`31` - Default value: `0`
        :param pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]] static_mac_addresses: Add static MAC address entries for interface
        :param pulumi.Input[builtins.int] sub_slot: Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_types", device_types)
        if age_out_time is not None:
            pulumi.set(__self__, "age_out_time", age_out_time)
        if age_out_time_variable is not None:
            pulumi.set(__self__, "age_out_time_variable", age_out_time_variable)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if module_type is not None:
            pulumi.set(__self__, "module_type", module_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if static_mac_addresses is not None:
            pulumi.set(__self__, "static_mac_addresses", static_mac_addresses)
        if sub_slot is not None:
            pulumi.set(__self__, "sub_slot", sub_slot)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        """
        return pulumi.get(self, "age_out_time")

    @age_out_time.setter
    def age_out_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "age_out_time", value)

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @age_out_time_variable.setter
    def age_out_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "age_out_time_variable", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter(name="moduleType")
    def module_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Module type - Choices: `4`, `8`, `22`, `50`
        """
        return pulumi.get(self, "module_type")

    @module_type.setter
    def module_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "module_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slot(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of Slots - Range: `0`-`31` - Default value: `0`
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "slot", value)

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]]]:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @static_mac_addresses.setter
    def static_mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]]]):
        pulumi.set(self, "static_mac_addresses", value)

    @property
    @pulumi.getter(name="subSlot")
    def sub_slot(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        """
        return pulumi.get(self, "sub_slot")

    @sub_slot.setter
    def sub_slot(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sub_slot", value)


@pulumi.input_type
class _SwitchportFeatureTemplateState:
    def __init__(__self__, *,
                 age_out_time: Optional[pulumi.Input[builtins.int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]]] = None,
                 module_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.int]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]]] = None,
                 sub_slot: Optional[pulumi.Input[builtins.int]] = None,
                 template_type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SwitchportFeatureTemplate resources.
        :param pulumi.Input[builtins.int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[builtins.str] age_out_time_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[builtins.str] module_type: Module type - Choices: `4`, `8`, `22`, `50`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] slot: Number of Slots - Range: `0`-`31` - Default value: `0`
        :param pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]] static_mac_addresses: Add static MAC address entries for interface
        :param pulumi.Input[builtins.int] sub_slot: Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        if age_out_time is not None:
            pulumi.set(__self__, "age_out_time", age_out_time)
        if age_out_time_variable is not None:
            pulumi.set(__self__, "age_out_time_variable", age_out_time_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_types is not None:
            pulumi.set(__self__, "device_types", device_types)
        if interfaces is not None:
            pulumi.set(__self__, "interfaces", interfaces)
        if module_type is not None:
            pulumi.set(__self__, "module_type", module_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if static_mac_addresses is not None:
            pulumi.set(__self__, "static_mac_addresses", static_mac_addresses)
        if sub_slot is not None:
            pulumi.set(__self__, "sub_slot", sub_slot)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        """
        return pulumi.get(self, "age_out_time")

    @age_out_time.setter
    def age_out_time(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "age_out_time", value)

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @age_out_time_variable.setter
    def age_out_time_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "age_out_time_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @device_types.setter
    def device_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "device_types", value)

    @property
    @pulumi.getter
    def interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @interfaces.setter
    def interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateInterfaceArgs']]]]):
        pulumi.set(self, "interfaces", value)

    @property
    @pulumi.getter(name="moduleType")
    def module_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Module type - Choices: `4`, `8`, `22`, `50`
        """
        return pulumi.get(self, "module_type")

    @module_type.setter
    def module_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "module_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slot(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of Slots - Range: `0`-`31` - Default value: `0`
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "slot", value)

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]]]:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @static_mac_addresses.setter
    def static_mac_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchportFeatureTemplateStaticMacAddressArgs']]]]):
        pulumi.set(self, "static_mac_addresses", value)

    @property
    @pulumi.getter(name="subSlot")
    def sub_slot(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        """
        return pulumi.get(self, "sub_slot")

    @sub_slot.setter
    def sub_slot(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "sub_slot", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/switchportFeatureTemplate:SwitchportFeatureTemplate")
class SwitchportFeatureTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 age_out_time: Optional[pulumi.Input[builtins.int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateInterfaceArgs', 'SwitchportFeatureTemplateInterfaceArgsDict']]]]] = None,
                 module_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.int]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateStaticMacAddressArgs', 'SwitchportFeatureTemplateStaticMacAddressArgsDict']]]]] = None,
                 sub_slot: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource can manage a Switchport feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/switchportFeatureTemplate:SwitchportFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[builtins.str] age_out_time_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateInterfaceArgs', 'SwitchportFeatureTemplateInterfaceArgsDict']]]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[builtins.str] module_type: Module type - Choices: `4`, `8`, `22`, `50`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] slot: Number of Slots - Range: `0`-`31` - Default value: `0`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateStaticMacAddressArgs', 'SwitchportFeatureTemplateStaticMacAddressArgsDict']]]] static_mac_addresses: Add static MAC address entries for interface
        :param pulumi.Input[builtins.int] sub_slot: Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchportFeatureTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Switchport feature template.
          - Minimum SD-WAN Manager version: `15.0.0`

        ## Import

        ```sh
        $ pulumi import sdwan:index/switchportFeatureTemplate:SwitchportFeatureTemplate example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchportFeatureTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchportFeatureTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 age_out_time: Optional[pulumi.Input[builtins.int]] = None,
                 age_out_time_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateInterfaceArgs', 'SwitchportFeatureTemplateInterfaceArgsDict']]]]] = None,
                 module_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.int]] = None,
                 static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateStaticMacAddressArgs', 'SwitchportFeatureTemplateStaticMacAddressArgsDict']]]]] = None,
                 sub_slot: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchportFeatureTemplateArgs.__new__(SwitchportFeatureTemplateArgs)

            __props__.__dict__["age_out_time"] = age_out_time
            __props__.__dict__["age_out_time_variable"] = age_out_time_variable
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if device_types is None and not opts.urn:
                raise TypeError("Missing required property 'device_types'")
            __props__.__dict__["device_types"] = device_types
            __props__.__dict__["interfaces"] = interfaces
            __props__.__dict__["module_type"] = module_type
            __props__.__dict__["name"] = name
            __props__.__dict__["slot"] = slot
            __props__.__dict__["static_mac_addresses"] = static_mac_addresses
            __props__.__dict__["sub_slot"] = sub_slot
            __props__.__dict__["template_type"] = None
            __props__.__dict__["version"] = None
        super(SwitchportFeatureTemplate, __self__).__init__(
            'sdwan:index/switchportFeatureTemplate:SwitchportFeatureTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            age_out_time: Optional[pulumi.Input[builtins.int]] = None,
            age_out_time_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            device_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateInterfaceArgs', 'SwitchportFeatureTemplateInterfaceArgsDict']]]]] = None,
            module_type: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            slot: Optional[pulumi.Input[builtins.int]] = None,
            static_mac_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateStaticMacAddressArgs', 'SwitchportFeatureTemplateStaticMacAddressArgsDict']]]]] = None,
            sub_slot: Optional[pulumi.Input[builtins.int]] = None,
            template_type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'SwitchportFeatureTemplate':
        """
        Get an existing SwitchportFeatureTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] age_out_time: Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        :param pulumi.Input[builtins.str] age_out_time_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the feature template
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] device_types: List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
               `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
               `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateInterfaceArgs', 'SwitchportFeatureTemplateInterfaceArgsDict']]]] interfaces: Interface name: GigabitEthernet0/<>/<> when present
        :param pulumi.Input[builtins.str] module_type: Module type - Choices: `4`, `8`, `22`, `50`
        :param pulumi.Input[builtins.str] name: The name of the feature template
        :param pulumi.Input[builtins.int] slot: Number of Slots - Range: `0`-`31` - Default value: `0`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchportFeatureTemplateStaticMacAddressArgs', 'SwitchportFeatureTemplateStaticMacAddressArgsDict']]]] static_mac_addresses: Add static MAC address entries for interface
        :param pulumi.Input[builtins.int] sub_slot: Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        :param pulumi.Input[builtins.str] template_type: The template type
        :param pulumi.Input[builtins.int] version: The version of the feature template
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchportFeatureTemplateState.__new__(_SwitchportFeatureTemplateState)

        __props__.__dict__["age_out_time"] = age_out_time
        __props__.__dict__["age_out_time_variable"] = age_out_time_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["device_types"] = device_types
        __props__.__dict__["interfaces"] = interfaces
        __props__.__dict__["module_type"] = module_type
        __props__.__dict__["name"] = name
        __props__.__dict__["slot"] = slot
        __props__.__dict__["static_mac_addresses"] = static_mac_addresses
        __props__.__dict__["sub_slot"] = sub_slot
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["version"] = version
        return SwitchportFeatureTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ageOutTime")
    def age_out_time(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Set when a MAC table entry ages out (0 to disable, 10-1000000 otherwise) - Range: `0`-`1000000` - Default value: `300`
        """
        return pulumi.get(self, "age_out_time")

    @property
    @pulumi.getter(name="ageOutTimeVariable")
    def age_out_time_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "age_out_time_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        The description of the feature template
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceTypes")
    def device_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of supported device types - Choices: `vedge-C8000V`, `vedge-C8300-1N1S-4T2X`, `vedge-C8300-1N1S-6T`,
        `vedge-C8300-2N2S-6T`, `vedge-C8300-2N2S-4T2X`, `vedge-C8500-12X4QC`, `vedge-C8500-12X`, `vedge-C8500-20X6C`,
        `vedge-C8500L-8S4X`, `vedge-C8200-1N-4T`, `vedge-C8200L-1N-4T`
        """
        return pulumi.get(self, "device_types")

    @property
    @pulumi.getter
    def interfaces(self) -> pulumi.Output[Optional[Sequence['outputs.SwitchportFeatureTemplateInterface']]]:
        """
        Interface name: GigabitEthernet0/<>/<> when present
        """
        return pulumi.get(self, "interfaces")

    @property
    @pulumi.getter(name="moduleType")
    def module_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Module type - Choices: `4`, `8`, `22`, `50`
        """
        return pulumi.get(self, "module_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the feature template
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slot(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of Slots - Range: `0`-`31` - Default value: `0`
        """
        return pulumi.get(self, "slot")

    @property
    @pulumi.getter(name="staticMacAddresses")
    def static_mac_addresses(self) -> pulumi.Output[Optional[Sequence['outputs.SwitchportFeatureTemplateStaticMacAddress']]]:
        """
        Add static MAC address entries for interface
        """
        return pulumi.get(self, "static_mac_addresses")

    @property
    @pulumi.getter(name="subSlot")
    def sub_slot(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Number of Sub-Slots - Range: `0`-`31` - Default value: `0`
        """
        return pulumi.get(self, "sub_slot")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[builtins.str]:
        """
        The template type
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the feature template
        """
        return pulumi.get(self, "version")

