# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemAaaFeatureArgs', 'SystemAaaFeature']

@pulumi.input_type
class SystemAaaFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 server_auth_orders: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 accounting_group: Optional[pulumi.Input[builtins.bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]]] = None,
                 authentication_group: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]]] = None):
        """
        The set of arguments for constructing a SystemAaaFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[builtins.bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] authentication_group_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]] users: Create local login account
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "server_auth_orders", server_auth_orders)
        if accounting_group is not None:
            pulumi.set(__self__, "accounting_group", accounting_group)
        if accounting_group_variable is not None:
            pulumi.set(__self__, "accounting_group_variable", accounting_group_variable)
        if accounting_rules is not None:
            pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authentication_group is not None:
            pulumi.set(__self__, "authentication_group", authentication_group)
        if authentication_group_variable is not None:
            pulumi.set(__self__, "authentication_group_variable", authentication_group_variable)
        if authorization_config_commands is not None:
            pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable is not None:
            pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console is not None:
            pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable is not None:
            pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius_groups is not None:
            pulumi.set(__self__, "radius_groups", radius_groups)
        if tacacs_groups is not None:
            pulumi.set(__self__, "tacacs_groups", tacacs_groups)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @server_auth_orders.setter
    def server_auth_orders(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "server_auth_orders", value)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "accounting_group")

    @accounting_group.setter
    def accounting_group(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accounting_group", value)

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @accounting_group_variable.setter
    def accounting_group_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accounting_group_variable", value)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @accounting_rules.setter
    def accounting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]]]):
        pulumi.set(self, "accounting_rules", value)

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "authentication_group")

    @authentication_group.setter
    def authentication_group(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_group", value)

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @authentication_group_variable.setter
    def authentication_group_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_group_variable", value)

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @authorization_config_commands.setter
    def authorization_config_commands(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_config_commands", value)

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @authorization_config_commands_variable.setter
    def authorization_config_commands_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_config_commands_variable", value)

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @authorization_console.setter
    def authorization_console(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_console", value)

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @authorization_console_variable.setter
    def authorization_console_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_console_variable", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @radius_groups.setter
    def radius_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]]]):
        pulumi.set(self, "radius_groups", value)

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @tacacs_groups.setter
    def tacacs_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]]]):
        pulumi.set(self, "tacacs_groups", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _SystemAaaFeatureState:
    def __init__(__self__, *,
                 accounting_group: Optional[pulumi.Input[builtins.bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]]] = None,
                 authentication_group: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]]] = None,
                 server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SystemAaaFeature resources.
        :param pulumi.Input[builtins.bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] authentication_group_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]] users: Create local login account
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if accounting_group is not None:
            pulumi.set(__self__, "accounting_group", accounting_group)
        if accounting_group_variable is not None:
            pulumi.set(__self__, "accounting_group_variable", accounting_group_variable)
        if accounting_rules is not None:
            pulumi.set(__self__, "accounting_rules", accounting_rules)
        if authentication_group is not None:
            pulumi.set(__self__, "authentication_group", authentication_group)
        if authentication_group_variable is not None:
            pulumi.set(__self__, "authentication_group_variable", authentication_group_variable)
        if authorization_config_commands is not None:
            pulumi.set(__self__, "authorization_config_commands", authorization_config_commands)
        if authorization_config_commands_variable is not None:
            pulumi.set(__self__, "authorization_config_commands_variable", authorization_config_commands_variable)
        if authorization_console is not None:
            pulumi.set(__self__, "authorization_console", authorization_console)
        if authorization_console_variable is not None:
            pulumi.set(__self__, "authorization_console_variable", authorization_console_variable)
        if authorization_rules is not None:
            pulumi.set(__self__, "authorization_rules", authorization_rules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if radius_groups is not None:
            pulumi.set(__self__, "radius_groups", radius_groups)
        if server_auth_orders is not None:
            pulumi.set(__self__, "server_auth_orders", server_auth_orders)
        if tacacs_groups is not None:
            pulumi.set(__self__, "tacacs_groups", tacacs_groups)
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "accounting_group")

    @accounting_group.setter
    def accounting_group(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "accounting_group", value)

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @accounting_group_variable.setter
    def accounting_group_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "accounting_group_variable", value)

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @accounting_rules.setter
    def accounting_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAccountingRuleArgs']]]]):
        pulumi.set(self, "accounting_rules", value)

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "authentication_group")

    @authentication_group.setter
    def authentication_group(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authentication_group", value)

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @authentication_group_variable.setter
    def authentication_group_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authentication_group_variable", value)

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @authorization_config_commands.setter
    def authorization_config_commands(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_config_commands", value)

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @authorization_config_commands_variable.setter
    def authorization_config_commands_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_config_commands_variable", value)

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @authorization_console.setter
    def authorization_console(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "authorization_console", value)

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @authorization_console_variable.setter
    def authorization_console_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization_console_variable", value)

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @authorization_rules.setter
    def authorization_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureAuthorizationRuleArgs']]]]):
        pulumi.set(self, "authorization_rules", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @radius_groups.setter
    def radius_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureRadiusGroupArgs']]]]):
        pulumi.set(self, "radius_groups", value)

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @server_auth_orders.setter
    def server_auth_orders(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "server_auth_orders", value)

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @tacacs_groups.setter
    def tacacs_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureTacacsGroupArgs']]]]):
        pulumi.set(self, "tacacs_groups", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemAaaFeatureUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/systemAaaFeature:SystemAaaFeature")
class SystemAaaFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_group: Optional[pulumi.Input[builtins.bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAccountingRuleArgs', 'SystemAaaFeatureAccountingRuleArgsDict']]]]] = None,
                 authentication_group: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAuthorizationRuleArgs', 'SystemAaaFeatureAuthorizationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureRadiusGroupArgs', 'SystemAaaFeatureRadiusGroupArgsDict']]]]] = None,
                 server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureTacacsGroupArgs', 'SystemAaaFeatureTacacsGroupArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureUserArgs', 'SystemAaaFeatureUserArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource can manage a System AAA Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "system_aaa_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemAaaFeature:SystemAaaFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAccountingRuleArgs', 'SystemAaaFeatureAccountingRuleArgsDict']]]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] authentication_group_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAuthorizationRuleArgs', 'SystemAaaFeatureAuthorizationRuleArgsDict']]]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureRadiusGroupArgs', 'SystemAaaFeatureRadiusGroupArgsDict']]]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureTacacsGroupArgs', 'SystemAaaFeatureTacacsGroupArgsDict']]]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureUserArgs', 'SystemAaaFeatureUserArgsDict']]]] users: Create local login account
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemAaaFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System AAA Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "system_aaa_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemAaaFeature:SystemAaaFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param SystemAaaFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemAaaFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accounting_group: Optional[pulumi.Input[builtins.bool]] = None,
                 accounting_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAccountingRuleArgs', 'SystemAaaFeatureAccountingRuleArgsDict']]]]] = None,
                 authentication_group: Optional[pulumi.Input[builtins.bool]] = None,
                 authentication_group_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
                 authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
                 authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAuthorizationRuleArgs', 'SystemAaaFeatureAuthorizationRuleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureRadiusGroupArgs', 'SystemAaaFeatureRadiusGroupArgsDict']]]]] = None,
                 server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureTacacsGroupArgs', 'SystemAaaFeatureTacacsGroupArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureUserArgs', 'SystemAaaFeatureUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemAaaFeatureArgs.__new__(SystemAaaFeatureArgs)

            __props__.__dict__["accounting_group"] = accounting_group
            __props__.__dict__["accounting_group_variable"] = accounting_group_variable
            __props__.__dict__["accounting_rules"] = accounting_rules
            __props__.__dict__["authentication_group"] = authentication_group
            __props__.__dict__["authentication_group_variable"] = authentication_group_variable
            __props__.__dict__["authorization_config_commands"] = authorization_config_commands
            __props__.__dict__["authorization_config_commands_variable"] = authorization_config_commands_variable
            __props__.__dict__["authorization_console"] = authorization_console
            __props__.__dict__["authorization_console_variable"] = authorization_console_variable
            __props__.__dict__["authorization_rules"] = authorization_rules
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["radius_groups"] = radius_groups
            if server_auth_orders is None and not opts.urn:
                raise TypeError("Missing required property 'server_auth_orders'")
            __props__.__dict__["server_auth_orders"] = server_auth_orders
            __props__.__dict__["tacacs_groups"] = tacacs_groups
            __props__.__dict__["users"] = users
            __props__.__dict__["version"] = None
        super(SystemAaaFeature, __self__).__init__(
            'sdwan:index/systemAaaFeature:SystemAaaFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accounting_group: Optional[pulumi.Input[builtins.bool]] = None,
            accounting_group_variable: Optional[pulumi.Input[builtins.str]] = None,
            accounting_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAccountingRuleArgs', 'SystemAaaFeatureAccountingRuleArgsDict']]]]] = None,
            authentication_group: Optional[pulumi.Input[builtins.bool]] = None,
            authentication_group_variable: Optional[pulumi.Input[builtins.str]] = None,
            authorization_config_commands: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_config_commands_variable: Optional[pulumi.Input[builtins.str]] = None,
            authorization_console: Optional[pulumi.Input[builtins.bool]] = None,
            authorization_console_variable: Optional[pulumi.Input[builtins.str]] = None,
            authorization_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAuthorizationRuleArgs', 'SystemAaaFeatureAuthorizationRuleArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            radius_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureRadiusGroupArgs', 'SystemAaaFeatureRadiusGroupArgsDict']]]]] = None,
            server_auth_orders: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tacacs_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureTacacsGroupArgs', 'SystemAaaFeatureTacacsGroupArgsDict']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureUserArgs', 'SystemAaaFeatureUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'SystemAaaFeature':
        """
        Get an existing SystemAaaFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] accounting_group: Accounting configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] accounting_group_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAccountingRuleArgs', 'SystemAaaFeatureAccountingRuleArgsDict']]]] accounting_rules: Configure the accounting rules
        :param pulumi.Input[builtins.bool] authentication_group: Authentication configurations parameters - Default value: `false`
        :param pulumi.Input[builtins.str] authentication_group_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_config_commands: For configuration mode commands. - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_config_commands_variable: Variable name
        :param pulumi.Input[builtins.bool] authorization_console: For enabling console authorization - Default value: `false`
        :param pulumi.Input[builtins.str] authorization_console_variable: Variable name
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureAuthorizationRuleArgs', 'SystemAaaFeatureAuthorizationRuleArgsDict']]]] authorization_rules: Configure the Authorization Rules
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureRadiusGroupArgs', 'SystemAaaFeatureRadiusGroupArgsDict']]]] radius_groups: Configure the Radius serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] server_auth_orders: ServerGroups priority order
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureTacacsGroupArgs', 'SystemAaaFeatureTacacsGroupArgsDict']]]] tacacs_groups: Configure the TACACS serverGroup
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemAaaFeatureUserArgs', 'SystemAaaFeatureUserArgsDict']]]] users: Create local login account
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemAaaFeatureState.__new__(_SystemAaaFeatureState)

        __props__.__dict__["accounting_group"] = accounting_group
        __props__.__dict__["accounting_group_variable"] = accounting_group_variable
        __props__.__dict__["accounting_rules"] = accounting_rules
        __props__.__dict__["authentication_group"] = authentication_group
        __props__.__dict__["authentication_group_variable"] = authentication_group_variable
        __props__.__dict__["authorization_config_commands"] = authorization_config_commands
        __props__.__dict__["authorization_config_commands_variable"] = authorization_config_commands_variable
        __props__.__dict__["authorization_console"] = authorization_console
        __props__.__dict__["authorization_console_variable"] = authorization_console_variable
        __props__.__dict__["authorization_rules"] = authorization_rules
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["radius_groups"] = radius_groups
        __props__.__dict__["server_auth_orders"] = server_auth_orders
        __props__.__dict__["tacacs_groups"] = tacacs_groups
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        return SystemAaaFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountingGroup")
    def accounting_group(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Accounting configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "accounting_group")

    @property
    @pulumi.getter(name="accountingGroupVariable")
    def accounting_group_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "accounting_group_variable")

    @property
    @pulumi.getter(name="accountingRules")
    def accounting_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaFeatureAccountingRule']]]:
        """
        Configure the accounting rules
        """
        return pulumi.get(self, "accounting_rules")

    @property
    @pulumi.getter(name="authenticationGroup")
    def authentication_group(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Authentication configurations parameters - Default value: `false`
        """
        return pulumi.get(self, "authentication_group")

    @property
    @pulumi.getter(name="authenticationGroupVariable")
    def authentication_group_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authentication_group_variable")

    @property
    @pulumi.getter(name="authorizationConfigCommands")
    def authorization_config_commands(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        For configuration mode commands. - Default value: `false`
        """
        return pulumi.get(self, "authorization_config_commands")

    @property
    @pulumi.getter(name="authorizationConfigCommandsVariable")
    def authorization_config_commands_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_config_commands_variable")

    @property
    @pulumi.getter(name="authorizationConsole")
    def authorization_console(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        For enabling console authorization - Default value: `false`
        """
        return pulumi.get(self, "authorization_console")

    @property
    @pulumi.getter(name="authorizationConsoleVariable")
    def authorization_console_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "authorization_console_variable")

    @property
    @pulumi.getter(name="authorizationRules")
    def authorization_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaFeatureAuthorizationRule']]]:
        """
        Configure the Authorization Rules
        """
        return pulumi.get(self, "authorization_rules")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="radiusGroups")
    def radius_groups(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaFeatureRadiusGroup']]]:
        """
        Configure the Radius serverGroup
        """
        return pulumi.get(self, "radius_groups")

    @property
    @pulumi.getter(name="serverAuthOrders")
    def server_auth_orders(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        ServerGroups priority order
        """
        return pulumi.get(self, "server_auth_orders")

    @property
    @pulumi.getter(name="tacacsGroups")
    def tacacs_groups(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaFeatureTacacsGroup']]]:
        """
        Configure the TACACS serverGroup
        """
        return pulumi.get(self, "tacacs_groups")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.SystemAaaFeatureUser']]]:
        """
        Create local login account
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

