# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SystemBfdFeatureArgs', 'SystemBfdFeature']

@pulumi.input_type
class SystemBfdFeatureArgs:
    def __init__(__self__, *,
                 feature_profile_id: pulumi.Input[builtins.str],
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]]] = None,
                 default_dscp: Optional[pulumi.Input[builtins.int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 poll_interval: Optional[pulumi.Input[builtins.int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SystemBfdFeature resource.
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[builtins.int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[builtins.str] default_dscp_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[builtins.str] poll_interval_variable: Variable name
        """
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if default_dscp is not None:
            pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable is not None:
            pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable is not None:
            pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]]]):
        pulumi.set(self, "colors", value)

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @default_dscp.setter
    def default_dscp(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_dscp", value)

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @default_dscp_variable.setter
    def default_dscp_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_dscp_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        - Range: `1`-`4294967295` - Default value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @poll_interval_variable.setter
    def poll_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "poll_interval_variable", value)


@pulumi.input_type
class _SystemBfdFeatureState:
    def __init__(__self__, *,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]]] = None,
                 default_dscp: Optional[pulumi.Input[builtins.int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 poll_interval: Optional[pulumi.Input[builtins.int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering SystemBfdFeature resources.
        :param pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[builtins.int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[builtins.str] default_dscp_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[builtins.str] poll_interval_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if colors is not None:
            pulumi.set(__self__, "colors", colors)
        if default_dscp is not None:
            pulumi.set(__self__, "default_dscp", default_dscp)
        if default_dscp_variable is not None:
            pulumi.set(__self__, "default_dscp_variable", default_dscp_variable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if multiplier is not None:
            pulumi.set(__self__, "multiplier", multiplier)
        if multiplier_variable is not None:
            pulumi.set(__self__, "multiplier_variable", multiplier_variable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if poll_interval is not None:
            pulumi.set(__self__, "poll_interval", poll_interval)
        if poll_interval_variable is not None:
            pulumi.set(__self__, "poll_interval_variable", poll_interval_variable)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def colors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @colors.setter
    def colors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemBfdFeatureColorArgs']]]]):
        pulumi.set(self, "colors", value)

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @default_dscp.setter
    def default_dscp(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "default_dscp", value)

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @default_dscp_variable.setter
    def default_dscp_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_dscp_variable", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def multiplier(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @multiplier.setter
    def multiplier(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "multiplier", value)

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @multiplier_variable.setter
    def multiplier_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "multiplier_variable", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        - Range: `1`-`4294967295` - Default value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @poll_interval.setter
    def poll_interval(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "poll_interval", value)

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @poll_interval_variable.setter
    def poll_interval_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "poll_interval_variable", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/systemBfdFeature:SystemBfdFeature")
class SystemBfdFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdFeatureColorArgs', 'SystemBfdFeatureColorArgsDict']]]]] = None,
                 default_dscp: Optional[pulumi.Input[builtins.int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 poll_interval: Optional[pulumi.Input[builtins.int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a System BFD Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "system_bfd_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemBfdFeature:SystemBfdFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdFeatureColorArgs', 'SystemBfdFeatureColorArgsDict']]]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[builtins.int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[builtins.str] default_dscp_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[builtins.str] poll_interval_variable: Variable name
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SystemBfdFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a System BFD Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "system_bfd_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/systemBfdFeature:SystemBfdFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param SystemBfdFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SystemBfdFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdFeatureColorArgs', 'SystemBfdFeatureColorArgsDict']]]]] = None,
                 default_dscp: Optional[pulumi.Input[builtins.int]] = None,
                 default_dscp_variable: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 multiplier: Optional[pulumi.Input[builtins.int]] = None,
                 multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 poll_interval: Optional[pulumi.Input[builtins.int]] = None,
                 poll_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SystemBfdFeatureArgs.__new__(SystemBfdFeatureArgs)

            __props__.__dict__["colors"] = colors
            __props__.__dict__["default_dscp"] = default_dscp
            __props__.__dict__["default_dscp_variable"] = default_dscp_variable
            __props__.__dict__["description"] = description
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["multiplier"] = multiplier
            __props__.__dict__["multiplier_variable"] = multiplier_variable
            __props__.__dict__["name"] = name
            __props__.__dict__["poll_interval"] = poll_interval
            __props__.__dict__["poll_interval_variable"] = poll_interval_variable
            __props__.__dict__["version"] = None
        super(SystemBfdFeature, __self__).__init__(
            'sdwan:index/systemBfdFeature:SystemBfdFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            colors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdFeatureColorArgs', 'SystemBfdFeatureColorArgsDict']]]]] = None,
            default_dscp: Optional[pulumi.Input[builtins.int]] = None,
            default_dscp_variable: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            multiplier: Optional[pulumi.Input[builtins.int]] = None,
            multiplier_variable: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            poll_interval: Optional[pulumi.Input[builtins.int]] = None,
            poll_interval_variable: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'SystemBfdFeature':
        """
        Get an existing SystemBfdFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SystemBfdFeatureColorArgs', 'SystemBfdFeatureColorArgsDict']]]] colors: Set color that identifies the WAN transport tunnel
        :param pulumi.Input[builtins.int] default_dscp: - Range: `0`-`63` - Default value: `48`
        :param pulumi.Input[builtins.str] default_dscp_variable: Variable name
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.int] multiplier: - Range: `1`-`6` - Default value: `6`
        :param pulumi.Input[builtins.str] multiplier_variable: Variable name
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.int] poll_interval: - Range: `1`-`4294967295` - Default value: `600000`
        :param pulumi.Input[builtins.str] poll_interval_variable: Variable name
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SystemBfdFeatureState.__new__(_SystemBfdFeatureState)

        __props__.__dict__["colors"] = colors
        __props__.__dict__["default_dscp"] = default_dscp
        __props__.__dict__["default_dscp_variable"] = default_dscp_variable
        __props__.__dict__["description"] = description
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["multiplier"] = multiplier
        __props__.__dict__["multiplier_variable"] = multiplier_variable
        __props__.__dict__["name"] = name
        __props__.__dict__["poll_interval"] = poll_interval
        __props__.__dict__["poll_interval_variable"] = poll_interval_variable
        __props__.__dict__["version"] = version
        return SystemBfdFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def colors(self) -> pulumi.Output[Optional[Sequence['outputs.SystemBfdFeatureColor']]]:
        """
        Set color that identifies the WAN transport tunnel
        """
        return pulumi.get(self, "colors")

    @property
    @pulumi.getter(name="defaultDscp")
    def default_dscp(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        - Range: `0`-`63` - Default value: `48`
        """
        return pulumi.get(self, "default_dscp")

    @property
    @pulumi.getter(name="defaultDscpVariable")
    def default_dscp_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "default_dscp_variable")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def multiplier(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        - Range: `1`-`6` - Default value: `6`
        """
        return pulumi.get(self, "multiplier")

    @property
    @pulumi.getter(name="multiplierVariable")
    def multiplier_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "multiplier_variable")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pollInterval")
    def poll_interval(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        - Range: `1`-`4294967295` - Default value: `600000`
        """
        return pulumi.get(self, "poll_interval")

    @property
    @pulumi.getter(name="pollIntervalVariable")
    def poll_interval_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "poll_interval_variable")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

