# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TransportT1E1ControllerFeatureArgs', 'TransportT1E1ControllerFeature']

@pulumi.input_type
class TransportT1E1ControllerFeatureArgs:
    def __init__(__self__, *,
                 entries: pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]],
                 feature_profile_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.str]] = None,
                 slot_variable: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a TransportT1E1ControllerFeature resource.
        :param pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]] entries: Controller tx-ex List
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] type: Card Type - Choices: `e1`, `t1`
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] slot: Slot number
        :param pulumi.Input[builtins.str] slot_variable: Variable name
        """
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if slot_variable is not None:
            pulumi.set(__self__, "slot_variable", slot_variable)

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]]:
        """
        Controller tx-ex List
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Card Type - Choices: `e1`, `t1`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slot(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Slot number
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slot", value)

    @property
    @pulumi.getter(name="slotVariable")
    def slot_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "slot_variable")

    @slot_variable.setter
    def slot_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slot_variable", value)


@pulumi.input_type
class _TransportT1E1ControllerFeatureState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.str]] = None,
                 slot_variable: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering TransportT1E1ControllerFeature resources.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]] entries: Controller tx-ex List
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] slot: Slot number
        :param pulumi.Input[builtins.str] slot_variable: Variable name
        :param pulumi.Input[builtins.str] type: Card Type - Choices: `e1`, `t1`
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if feature_profile_id is not None:
            pulumi.set(__self__, "feature_profile_id", feature_profile_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if slot is not None:
            pulumi.set(__self__, "slot", slot)
        if slot_variable is not None:
            pulumi.set(__self__, "slot_variable", slot_variable)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]]]:
        """
        Controller tx-ex List
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TransportT1E1ControllerFeatureEntryArgs']]]]):
        pulumi.set(self, "entries", value)

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @feature_profile_id.setter
    def feature_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "feature_profile_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def slot(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Slot number
        """
        return pulumi.get(self, "slot")

    @slot.setter
    def slot(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slot", value)

    @property
    @pulumi.getter(name="slotVariable")
    def slot_variable(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "slot_variable")

    @slot_variable.setter
    def slot_variable(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "slot_variable", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Card Type - Choices: `e1`, `t1`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("sdwan:index/transportT1E1ControllerFeature:TransportT1E1ControllerFeature")
class TransportT1E1ControllerFeature(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportT1E1ControllerFeatureEntryArgs', 'TransportT1E1ControllerFeatureEntryArgsDict']]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.str]] = None,
                 slot_variable: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Transport T1 E1 Controller Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "transport_t1_e1_controller_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportT1E1ControllerFeature:TransportT1E1ControllerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportT1E1ControllerFeatureEntryArgs', 'TransportT1E1ControllerFeatureEntryArgsDict']]]] entries: Controller tx-ex List
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] slot: Slot number
        :param pulumi.Input[builtins.str] slot_variable: Variable name
        :param pulumi.Input[builtins.str] type: Card Type - Choices: `e1`, `t1`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TransportT1E1ControllerFeatureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Transport T1 E1 Controller Feature.
          - Minimum SD-WAN Manager version: `20.12.0`

        ## Import

        Expected import identifier with the format: "transport_t1_e1_controller_feature_id,feature_profile_id"

        ```sh
        $ pulumi import sdwan:index/transportT1E1ControllerFeature:TransportT1E1ControllerFeature example "f6b2c44c-693c-4763-b010-895aa3d236bd,f6dd22c8-0b4f-496c-9a0b-6813d1f8b8ac"
        ```

        :param str resource_name: The name of the resource.
        :param TransportT1E1ControllerFeatureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TransportT1E1ControllerFeatureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportT1E1ControllerFeatureEntryArgs', 'TransportT1E1ControllerFeatureEntryArgsDict']]]]] = None,
                 feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 slot: Optional[pulumi.Input[builtins.str]] = None,
                 slot_variable: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TransportT1E1ControllerFeatureArgs.__new__(TransportT1E1ControllerFeatureArgs)

            __props__.__dict__["description"] = description
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            if feature_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'feature_profile_id'")
            __props__.__dict__["feature_profile_id"] = feature_profile_id
            __props__.__dict__["name"] = name
            __props__.__dict__["slot"] = slot
            __props__.__dict__["slot_variable"] = slot_variable
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = None
        super(TransportT1E1ControllerFeature, __self__).__init__(
            'sdwan:index/transportT1E1ControllerFeature:TransportT1E1ControllerFeature',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TransportT1E1ControllerFeatureEntryArgs', 'TransportT1E1ControllerFeatureEntryArgsDict']]]]] = None,
            feature_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            slot: Optional[pulumi.Input[builtins.str]] = None,
            slot_variable: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.int]] = None) -> 'TransportT1E1ControllerFeature':
        """
        Get an existing TransportT1E1ControllerFeature resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: The description of the Feature
        :param pulumi.Input[Sequence[pulumi.Input[Union['TransportT1E1ControllerFeatureEntryArgs', 'TransportT1E1ControllerFeatureEntryArgsDict']]]] entries: Controller tx-ex List
        :param pulumi.Input[builtins.str] feature_profile_id: Feature Profile ID
        :param pulumi.Input[builtins.str] name: The name of the Feature
        :param pulumi.Input[builtins.str] slot: Slot number
        :param pulumi.Input[builtins.str] slot_variable: Variable name
        :param pulumi.Input[builtins.str] type: Card Type - Choices: `e1`, `t1`
        :param pulumi.Input[builtins.int] version: The version of the Feature
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TransportT1E1ControllerFeatureState.__new__(_TransportT1E1ControllerFeatureState)

        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["feature_profile_id"] = feature_profile_id
        __props__.__dict__["name"] = name
        __props__.__dict__["slot"] = slot
        __props__.__dict__["slot_variable"] = slot_variable
        __props__.__dict__["type"] = type
        __props__.__dict__["version"] = version
        return TransportT1E1ControllerFeature(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Feature
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence['outputs.TransportT1E1ControllerFeatureEntry']]:
        """
        Controller tx-ex List
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter(name="featureProfileId")
    def feature_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        Feature Profile ID
        """
        return pulumi.get(self, "feature_profile_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the Feature
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def slot(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Slot number
        """
        return pulumi.get(self, "slot")

    @property
    @pulumi.getter(name="slotVariable")
    def slot_variable(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Variable name
        """
        return pulumi.get(self, "slot_variable")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Card Type - Choices: `e1`, `t1`
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.int]:
        """
        The version of the Feature
        """
        return pulumi.get(self, "version")

