# coding: utf-8

"""
    SEMAPHORE

    Semaphore API  # noqa: E501

    OpenAPI spec version: 2.2.0-oas3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from semaphore_client.api_client import ApiClient


class ProjectApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def project_project_id_delete(self, project_id, **kwargs):  # noqa: E501
        """Delete project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_delete(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_delete_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_delete_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_delete_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Delete project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_delete_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_environment_environment_id_delete(self, project_id, environment_id, **kwargs):  # noqa: E501
        """Removes environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_environment_id_delete(project_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int environment_id: environment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_environment_environment_id_delete_with_http_info(project_id, environment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_environment_environment_id_delete_with_http_info(project_id, environment_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_environment_environment_id_delete_with_http_info(self, project_id, environment_id, **kwargs):  # noqa: E501
        """Removes environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_environment_id_delete_with_http_info(project_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int environment_id: environment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'environment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_environment_environment_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_environment_environment_id_delete`")  # noqa: E501
        # verify the required parameter 'environment_id' is set
        if ('environment_id' not in params or
                params['environment_id'] is None):
            raise ValueError("Missing the required parameter `environment_id` when calling `project_project_id_environment_environment_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'environment_id' in params:
            path_params['environment_id'] = params['environment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/environment/{environment_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_environment_environment_id_put(self, body, project_id, environment_id, **kwargs):  # noqa: E501
        """Update environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_environment_id_put(body, project_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EnvironmentRequest body: (required)
        :param int project_id: Project ID (required)
        :param int environment_id: environment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_environment_environment_id_put_with_http_info(body, project_id, environment_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_environment_environment_id_put_with_http_info(body, project_id, environment_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_environment_environment_id_put_with_http_info(self, body, project_id, environment_id, **kwargs):  # noqa: E501
        """Update environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_environment_id_put_with_http_info(body, project_id, environment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EnvironmentRequest body: (required)
        :param int project_id: Project ID (required)
        :param int environment_id: environment ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'environment_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_environment_environment_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_environment_environment_id_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_environment_environment_id_put`")  # noqa: E501
        # verify the required parameter 'environment_id' is set
        if ('environment_id' not in params or
                params['environment_id'] is None):
            raise ValueError("Missing the required parameter `environment_id` when calling `project_project_id_environment_environment_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'environment_id' in params:
            path_params['environment_id'] = params['environment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/environment/{environment_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_environment_get(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_get(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Environment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_environment_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_environment_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
            return data

    def project_project_id_environment_get_with_http_info(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_get_with_http_info(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Environment]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'sort', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_environment_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_environment_get`")  # noqa: E501
        # verify the required parameter 'sort' is set
        if ('sort' not in params or
                params['sort'] is None):
            raise ValueError("Missing the required parameter `sort` when calling `project_project_id_environment_get`")  # noqa: E501
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `project_project_id_environment_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/environment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Environment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_environment_post(self, body, project_id, **kwargs):  # noqa: E501
        """Add environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EnvironmentRequest body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_environment_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_environment_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_environment_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Add environment  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_environment_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param EnvironmentRequest body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_environment_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_environment_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_environment_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/environment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_events_get(self, project_id, **kwargs):  # noqa: E501
        """Get Events related to this project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_events_get(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: list[Event]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_events_get_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_events_get_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_events_get_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Get Events related to this project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_events_get_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: list[Event]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_events_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_events_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Event]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_get(self, project_id, **kwargs):  # noqa: E501
        """Fetch project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_get(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_get_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_get_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_get_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Fetch project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_get_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Project',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_inventory_get(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_get(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Inventory]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_inventory_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_inventory_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
            return data

    def project_project_id_inventory_get_with_http_info(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_get_with_http_info(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Inventory]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'sort', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_inventory_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_inventory_get`")  # noqa: E501
        # verify the required parameter 'sort' is set
        if ('sort' not in params or
                params['sort'] is None):
            raise ValueError("Missing the required parameter `sort` when calling `project_project_id_inventory_get`")  # noqa: E501
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `project_project_id_inventory_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/inventory', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Inventory]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_inventory_inventory_id_delete(self, project_id, inventory_id, **kwargs):  # noqa: E501
        """Removes inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_inventory_id_delete(project_id, inventory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int inventory_id: inventory ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_inventory_inventory_id_delete_with_http_info(project_id, inventory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_inventory_inventory_id_delete_with_http_info(project_id, inventory_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_inventory_inventory_id_delete_with_http_info(self, project_id, inventory_id, **kwargs):  # noqa: E501
        """Removes inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_inventory_id_delete_with_http_info(project_id, inventory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int inventory_id: inventory ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'inventory_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_inventory_inventory_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_inventory_inventory_id_delete`")  # noqa: E501
        # verify the required parameter 'inventory_id' is set
        if ('inventory_id' not in params or
                params['inventory_id'] is None):
            raise ValueError("Missing the required parameter `inventory_id` when calling `project_project_id_inventory_inventory_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'inventory_id' in params:
            path_params['inventory_id'] = params['inventory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/inventory/{inventory_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_inventory_inventory_id_put(self, body, project_id, inventory_id, **kwargs):  # noqa: E501
        """Updates inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_inventory_id_put(body, project_id, inventory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InventoryRequest body: (required)
        :param int project_id: Project ID (required)
        :param int inventory_id: inventory ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_inventory_inventory_id_put_with_http_info(body, project_id, inventory_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_inventory_inventory_id_put_with_http_info(body, project_id, inventory_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_inventory_inventory_id_put_with_http_info(self, body, project_id, inventory_id, **kwargs):  # noqa: E501
        """Updates inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_inventory_id_put_with_http_info(body, project_id, inventory_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InventoryRequest body: (required)
        :param int project_id: Project ID (required)
        :param int inventory_id: inventory ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'inventory_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_inventory_inventory_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_inventory_inventory_id_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_inventory_inventory_id_put`")  # noqa: E501
        # verify the required parameter 'inventory_id' is set
        if ('inventory_id' not in params or
                params['inventory_id'] is None):
            raise ValueError("Missing the required parameter `inventory_id` when calling `project_project_id_inventory_inventory_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'inventory_id' in params:
            path_params['inventory_id'] = params['inventory_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/inventory/{inventory_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_inventory_post(self, body, project_id, **kwargs):  # noqa: E501
        """create inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InventoryRequest body: (required)
        :param int project_id: Project ID (required)
        :return: Inventory
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_inventory_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_inventory_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_inventory_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """create inventory  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_inventory_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InventoryRequest body: (required)
        :param int project_id: Project ID (required)
        :return: Inventory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_inventory_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_inventory_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_inventory_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/inventory', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Inventory',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_keys_get(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get access keys linked to project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_get(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :param str key_type: Filter by key type
        :return: list[AccessKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_keys_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_keys_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
            return data

    def project_project_id_keys_get_with_http_info(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get access keys linked to project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_get_with_http_info(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :param str key_type: Filter by key type
        :return: list[AccessKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'sort', 'order', 'key_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_keys_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_keys_get`")  # noqa: E501
        # verify the required parameter 'sort' is set
        if ('sort' not in params or
                params['sort'] is None):
            raise ValueError("Missing the required parameter `sort` when calling `project_project_id_keys_get`")  # noqa: E501
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `project_project_id_keys_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []
        if 'key_type' in params:
            query_params.append(('Key type', params['key_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/keys', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[AccessKey]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_keys_key_id_delete(self, project_id, key_id, **kwargs):  # noqa: E501
        """Removes access key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_key_id_delete(project_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int key_id: key ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_keys_key_id_delete_with_http_info(project_id, key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_keys_key_id_delete_with_http_info(project_id, key_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_keys_key_id_delete_with_http_info(self, project_id, key_id, **kwargs):  # noqa: E501
        """Removes access key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_key_id_delete_with_http_info(project_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int key_id: key ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_keys_key_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_keys_key_id_delete`")  # noqa: E501
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params or
                params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `project_project_id_keys_key_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'key_id' in params:
            path_params['key_id'] = params['key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/keys/{key_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_keys_key_id_put(self, body, project_id, key_id, **kwargs):  # noqa: E501
        """Updates access key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_key_id_put(body, project_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessKeyRequest body: (required)
        :param int project_id: Project ID (required)
        :param int key_id: key ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_keys_key_id_put_with_http_info(body, project_id, key_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_keys_key_id_put_with_http_info(body, project_id, key_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_keys_key_id_put_with_http_info(self, body, project_id, key_id, **kwargs):  # noqa: E501
        """Updates access key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_key_id_put_with_http_info(body, project_id, key_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessKeyRequest body: (required)
        :param int project_id: Project ID (required)
        :param int key_id: key ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'key_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_keys_key_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_keys_key_id_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_keys_key_id_put`")  # noqa: E501
        # verify the required parameter 'key_id' is set
        if ('key_id' not in params or
                params['key_id'] is None):
            raise ValueError("Missing the required parameter `key_id` when calling `project_project_id_keys_key_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'key_id' in params:
            path_params['key_id'] = params['key_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/keys/{key_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_keys_post(self, body, project_id, **kwargs):  # noqa: E501
        """Add access key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessKeyRequest body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_keys_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_keys_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_keys_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Add access key  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_keys_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param AccessKeyRequest body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_keys_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_keys_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_keys_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/keys', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_put(self, body, project_id, **kwargs):  # noqa: E501
        """Update project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_put(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body1 body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_put_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_put_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_put_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Update project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_put_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body1 body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_repositories_get(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get repositories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_repositories_get(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Repository]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_repositories_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_repositories_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
            return data

    def project_project_id_repositories_get_with_http_info(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get repositories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_repositories_get_with_http_info(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Repository]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'sort', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_repositories_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_repositories_get`")  # noqa: E501
        # verify the required parameter 'sort' is set
        if ('sort' not in params or
                params['sort'] is None):
            raise ValueError("Missing the required parameter `sort` when calling `project_project_id_repositories_get`")  # noqa: E501
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `project_project_id_repositories_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/repositories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Repository]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_repositories_post(self, body, project_id, **kwargs):  # noqa: E501
        """Add repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_repositories_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepositoryRequest body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_repositories_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_repositories_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_repositories_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Add repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_repositories_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepositoryRequest body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_repositories_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_repositories_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_repositories_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/repositories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_repositories_repository_id_delete(self, project_id, repository_id, **kwargs):  # noqa: E501
        """Removes repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_repositories_repository_id_delete(project_id, repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int repository_id: repository ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_repositories_repository_id_delete_with_http_info(project_id, repository_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_repositories_repository_id_delete_with_http_info(project_id, repository_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_repositories_repository_id_delete_with_http_info(self, project_id, repository_id, **kwargs):  # noqa: E501
        """Removes repository  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_repositories_repository_id_delete_with_http_info(project_id, repository_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int repository_id: repository ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'repository_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_repositories_repository_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_repositories_repository_id_delete`")  # noqa: E501
        # verify the required parameter 'repository_id' is set
        if ('repository_id' not in params or
                params['repository_id'] is None):
            raise ValueError("Missing the required parameter `repository_id` when calling `project_project_id_repositories_repository_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'repository_id' in params:
            path_params['repository_id'] = params['repository_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/repositories/{repository_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_tasks_get(self, project_id, **kwargs):  # noqa: E501
        """Get Tasks related to current project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_get(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_tasks_get_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_tasks_get_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_tasks_get_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Get Tasks related to current project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_get_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_tasks_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_tasks_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Task]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_tasks_last_get(self, project_id, **kwargs):  # noqa: E501
        """Get last 200 Tasks related to current project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_last_get(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_tasks_last_get_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_tasks_last_get_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_tasks_last_get_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """Get last 200 Tasks related to current project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_last_get_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_tasks_last_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_tasks_last_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/tasks/last', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Task]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_tasks_post(self, body, project_id, **kwargs):  # noqa: E501
        """Starts a job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body3 body: (required)
        :param int project_id: Project ID (required)
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_tasks_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_tasks_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_tasks_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Starts a job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body3 body: (required)
        :param int project_id: Project ID (required)
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_tasks_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_tasks_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_tasks_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/tasks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_tasks_task_id_delete(self, project_id, task_id, **kwargs):  # noqa: E501
        """Deletes task (including output)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_task_id_delete(project_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int task_id: task ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_tasks_task_id_delete_with_http_info(project_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_tasks_task_id_delete_with_http_info(project_id, task_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_tasks_task_id_delete_with_http_info(self, project_id, task_id, **kwargs):  # noqa: E501
        """Deletes task (including output)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_task_id_delete_with_http_info(project_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int task_id: task ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_tasks_task_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_tasks_task_id_delete`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `project_project_id_tasks_task_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'task_id' in params:
            path_params['task_id'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/tasks/{task_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_tasks_task_id_get(self, project_id, task_id, **kwargs):  # noqa: E501
        """Get a single task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_task_id_get(project_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int task_id: task ID (required)
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_tasks_task_id_get_with_http_info(project_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_tasks_task_id_get_with_http_info(project_id, task_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_tasks_task_id_get_with_http_info(self, project_id, task_id, **kwargs):  # noqa: E501
        """Get a single task  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_task_id_get_with_http_info(project_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int task_id: task ID (required)
        :return: Task
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_tasks_task_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_tasks_task_id_get`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `project_project_id_tasks_task_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'task_id' in params:
            path_params['task_id'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/tasks/{task_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Task',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_tasks_task_id_output_get(self, project_id, task_id, **kwargs):  # noqa: E501
        """Get task output  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_task_id_output_get(project_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int task_id: task ID (required)
        :return: list[TaskOutput]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_tasks_task_id_output_get_with_http_info(project_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_tasks_task_id_output_get_with_http_info(project_id, task_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_tasks_task_id_output_get_with_http_info(self, project_id, task_id, **kwargs):  # noqa: E501
        """Get task output  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_tasks_task_id_output_get_with_http_info(project_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int task_id: task ID (required)
        :return: list[TaskOutput]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'task_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_tasks_task_id_output_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_tasks_task_id_output_get`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `project_project_id_tasks_task_id_output_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'task_id' in params:
            path_params['task_id'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/tasks/{task_id}/output', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TaskOutput]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_templates_get(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_get(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Template]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_templates_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_templates_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
            return data

    def project_project_id_templates_get_with_http_info(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_get_with_http_info(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[Template]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'sort', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_templates_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_templates_get`")  # noqa: E501
        # verify the required parameter 'sort' is set
        if ('sort' not in params or
                params['sort'] is None):
            raise ValueError("Missing the required parameter `sort` when calling `project_project_id_templates_get`")  # noqa: E501
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `project_project_id_templates_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Template]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_templates_post(self, body, project_id, **kwargs):  # noqa: E501
        """create template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateRequest body: (required)
        :param int project_id: Project ID (required)
        :return: Template
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_templates_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_templates_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_templates_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """create template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateRequest body: (required)
        :param int project_id: Project ID (required)
        :return: Template
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_templates_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_templates_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_templates_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/templates', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Template',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_templates_template_id_delete(self, project_id, template_id, **kwargs):  # noqa: E501
        """Removes template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_template_id_delete(project_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int template_id: template ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_templates_template_id_delete_with_http_info(project_id, template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_templates_template_id_delete_with_http_info(project_id, template_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_templates_template_id_delete_with_http_info(self, project_id, template_id, **kwargs):  # noqa: E501
        """Removes template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_template_id_delete_with_http_info(project_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int template_id: template ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_templates_template_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_templates_template_id_delete`")  # noqa: E501
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `project_project_id_templates_template_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'template_id' in params:
            path_params['template_id'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/templates/{template_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_templates_template_id_put(self, body, project_id, template_id, **kwargs):  # noqa: E501
        """Updates template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_template_id_put(body, project_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateRequest body: (required)
        :param int project_id: Project ID (required)
        :param int template_id: template ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_templates_template_id_put_with_http_info(body, project_id, template_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_templates_template_id_put_with_http_info(body, project_id, template_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_templates_template_id_put_with_http_info(self, body, project_id, template_id, **kwargs):  # noqa: E501
        """Updates template  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_templates_template_id_put_with_http_info(body, project_id, template_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TemplateRequest body: (required)
        :param int project_id: Project ID (required)
        :param int template_id: template ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id', 'template_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_templates_template_id_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_templates_template_id_put`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_templates_template_id_put`")  # noqa: E501
        # verify the required parameter 'template_id' is set
        if ('template_id' not in params or
                params['template_id'] is None):
            raise ValueError("Missing the required parameter `template_id` when calling `project_project_id_templates_template_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'template_id' in params:
            path_params['template_id'] = params['template_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/templates/{template_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_users_get(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get users linked to project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_get(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_users_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_users_get_with_http_info(project_id, sort, order, **kwargs)  # noqa: E501
            return data

    def project_project_id_users_get_with_http_info(self, project_id, sort, order, **kwargs):  # noqa: E501
        """Get users linked to project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_get_with_http_info(project_id, sort, order, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param str sort: sorting name (required)
        :param str order: ordering manner (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'sort', 'order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_users_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_users_get`")  # noqa: E501
        # verify the required parameter 'sort' is set
        if ('sort' not in params or
                params['sort'] is None):
            raise ValueError("Missing the required parameter `sort` when calling `project_project_id_users_get`")  # noqa: E501
        # verify the required parameter 'order' is set
        if ('order' not in params or
                params['order'] is None):
            raise ValueError("Missing the required parameter `order` when calling `project_project_id_users_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'order' in params:
            query_params.append(('order', params['order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_users_post(self, body, project_id, **kwargs):  # noqa: E501
        """Link user to project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_post(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body2 body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_users_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_users_post_with_http_info(body, project_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_users_post_with_http_info(self, body, project_id, **kwargs):  # noqa: E501
        """Link user to project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_post_with_http_info(body, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Body2 body: (required)
        :param int project_id: Project ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'project_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_users_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `project_project_id_users_post`")  # noqa: E501
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_users_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_users_user_id_admin_delete(self, project_id, user_id, **kwargs):  # noqa: E501
        """Revoke admin privileges  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_user_id_admin_delete(project_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_users_user_id_admin_delete_with_http_info(project_id, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_users_user_id_admin_delete_with_http_info(project_id, user_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_users_user_id_admin_delete_with_http_info(self, project_id, user_id, **kwargs):  # noqa: E501
        """Revoke admin privileges  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_user_id_admin_delete_with_http_info(project_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_users_user_id_admin_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_users_user_id_admin_delete`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `project_project_id_users_user_id_admin_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/users/{user_id}/admin', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_users_user_id_admin_post(self, project_id, user_id, **kwargs):  # noqa: E501
        """Makes user admin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_user_id_admin_post(project_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_users_user_id_admin_post_with_http_info(project_id, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_users_user_id_admin_post_with_http_info(project_id, user_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_users_user_id_admin_post_with_http_info(self, project_id, user_id, **kwargs):  # noqa: E501
        """Makes user admin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_user_id_admin_post_with_http_info(project_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_users_user_id_admin_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_users_user_id_admin_post`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `project_project_id_users_user_id_admin_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/users/{user_id}/admin', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def project_project_id_users_user_id_delete(self, project_id, user_id, **kwargs):  # noqa: E501
        """Removes user from project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_user_id_delete(project_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.project_project_id_users_user_id_delete_with_http_info(project_id, user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.project_project_id_users_user_id_delete_with_http_info(project_id, user_id, **kwargs)  # noqa: E501
            return data

    def project_project_id_users_user_id_delete_with_http_info(self, project_id, user_id, **kwargs):  # noqa: E501
        """Removes user from project  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.project_project_id_users_user_id_delete_with_http_info(project_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int project_id: Project ID (required)
        :param int user_id: User ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_id', 'user_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method project_project_id_users_user_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_id' is set
        if ('project_id' not in params or
                params['project_id'] is None):
            raise ValueError("Missing the required parameter `project_id` when calling `project_project_id_users_user_id_delete`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params or
                params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `project_project_id_users_user_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_id' in params:
            path_params['project_id'] = params['project_id']  # noqa: E501
        if 'user_id' in params:
            path_params['user_id'] = params['user_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['bearer', 'cookie']  # noqa: E501

        return self.api_client.call_api(
            '/project/{project_id}/users/{user_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
