/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.core.util;

import java.security.SecureRandom;

public final class ProActiveRandom {
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    public static final char[] SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();

    public static boolean nextBoolean() {
        return SECURE_RANDOM.nextBoolean();
    }

    public static void nextBytes(byte[] bytes) {
        SECURE_RANDOM.nextBytes(bytes);
    }

    public static double nextDouble() {
        return SECURE_RANDOM.nextDouble();
    }

    public static float nextFloat() {
        return SECURE_RANDOM.nextFloat();
    }

    public static int nextInt() {
        return SECURE_RANDOM.nextInt();
    }

    public static int nextPosInt() {
        return SECURE_RANDOM.nextInt(Integer.MAX_VALUE);
    }

    public static int nextInt(int n) {
        return SECURE_RANDOM.nextInt(n);
    }

    public static long nextLong() {
        return SECURE_RANDOM.nextLong();
    }

    public static long nextPosLong() {
        return Math.abs(ProActiveRandom.nextLong());
    }

    public static String nextString(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(SYMBOLS[ProActiveRandom.nextInt(SYMBOLS.length)]);
        }
        return sb.toString();
    }
}

