/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.job.UserIdentification;

@PublicAPI
public class SchedulerUsers
implements Serializable {
    private Set<UserIdentification> users = Collections.synchronizedSet(new HashSet());

    public Collection<UserIdentification> getUsers() {
        ArrayList<UserIdentification> tmp = new ArrayList<UserIdentification>(this.users.size());
        Iterator<UserIdentification> iter = this.users.iterator();
        while (iter.hasNext()) {
            tmp.add(iter.next());
        }
        Collections.sort(tmp);
        return tmp;
    }

    public int getUsersCount() {
        return this.users.size();
    }

    public void update(UserIdentification user) {
        Iterator<UserIdentification> iter = this.users.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(user)) continue;
            iter.remove();
        }
        if (!user.isToRemove()) {
            this.users.add(user);
        }
    }

    private void readObject(ObjectInputStream aInputStream) throws ClassNotFoundException, IOException {
        this.users = Collections.synchronizedSet((Set)aInputStream.readObject());
    }

    private void writeObject(ObjectOutputStream aOutputStream) throws IOException {
        aOutputStream.writeObject(new HashSet<UserIdentification>(this.users));
    }
}

