/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.proactive.extensions.dataspaces.api;

import java.util.List;
import org.objectweb.proactive.extensions.dataspaces.api.Capability;
import org.objectweb.proactive.extensions.dataspaces.api.FileContent;
import org.objectweb.proactive.extensions.dataspaces.api.FileSelector;
import org.objectweb.proactive.extensions.dataspaces.api.FileType;
import org.objectweb.proactive.extensions.dataspaces.exceptions.FileSystemException;
import org.objectweb.proactive.extensions.dataspaces.exceptions.SpaceNotFoundException;

public interface DataSpacesFileObject {
    public String getVirtualURI();

    public String getRealURI();

    public String getBaseName();

    public String getPath();

    public List<String> getAllRealURIs();

    public List<String> getAllSpaceRootURIs();

    public DataSpacesFileObject switchToSpaceRoot(String var1) throws FileSystemException, SpaceNotFoundException;

    public String getSpaceRootURI();

    public DataSpacesFileObject ensureExistingOrSwitch(boolean var1) throws FileSystemException, SpaceNotFoundException;

    public boolean exists() throws FileSystemException;

    public boolean isHidden() throws FileSystemException;

    public boolean isReadable() throws FileSystemException;

    public boolean isWritable() throws FileSystemException;

    public FileType getType() throws FileSystemException;

    public boolean hasSpaceCapability(Capability var1);

    public DataSpacesFileObject getParent() throws FileSystemException;

    public List<DataSpacesFileObject> getChildren() throws FileSystemException;

    public DataSpacesFileObject getChild(String var1) throws FileSystemException;

    public DataSpacesFileObject resolveFile(String var1) throws FileSystemException;

    public List<DataSpacesFileObject> findFiles(FileSelector var1) throws FileSystemException;

    public List<DataSpacesFileObject> findFiles(org.apache.commons.vfs2.FileSelector var1) throws FileSystemException;

    public void findFiles(FileSelector var1, boolean var2, List<DataSpacesFileObject> var3) throws FileSystemException;

    public boolean delete() throws FileSystemException;

    public int delete(FileSelector var1) throws FileSystemException;

    public void createFolder() throws FileSystemException;

    public void createFile() throws FileSystemException;

    public void copyFrom(DataSpacesFileObject var1, FileSelector var2) throws FileSystemException;

    public void moveTo(DataSpacesFileObject var1) throws FileSystemException;

    public FileContent getContent() throws FileSystemException;

    public void close() throws FileSystemException;

    public void refresh() throws FileSystemException;

    public boolean isContentOpen();

    public boolean isFile() throws FileSystemException;

    public boolean isFolder() throws FileSystemException;

    public boolean equals(Object var1);

    public boolean setExecutable(boolean var1, boolean var2) throws FileSystemException;

    public boolean setReadable(boolean var1, boolean var2) throws FileSystemException;

    public boolean setWritable(boolean var1, boolean var2) throws FileSystemException;
}

