# Changelog

## 2.5.0 (2024-08-16)

Full Changelog: [v2.4.0...v2.5.0](https://github.com/orbcorp/orb-python/compare/v2.4.0...v2.5.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#349](https://github.com/orbcorp/orb-python/issues/349)) ([dc573e4](https://github.com/orbcorp/orb-python/commit/dc573e48b5dda28ef03944c11590daa67e8b054e))

## 2.4.0 (2024-08-15)

Full Changelog: [v2.3.0...v2.4.0](https://github.com/orbcorp/orb-python/compare/v2.3.0...v2.4.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#346](https://github.com/orbcorp/orb-python/issues/346)) ([9906e02](https://github.com/orbcorp/orb-python/commit/9906e02fbe3f889942fd235ed19b0cc588797344))

## 2.3.0 (2024-08-15)

Full Changelog: [v2.2.0...v2.3.0](https://github.com/orbcorp/orb-python/compare/v2.2.0...v2.3.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#343](https://github.com/orbcorp/orb-python/issues/343)) ([b4db3f3](https://github.com/orbcorp/orb-python/commit/b4db3f330e2518878125f3e6b72ad555e0fe4873))

## 2.2.0 (2024-08-15)

Full Changelog: [v2.1.0...v2.2.0](https://github.com/orbcorp/orb-python/compare/v2.1.0...v2.2.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#340](https://github.com/orbcorp/orb-python/issues/340)) ([632a6bd](https://github.com/orbcorp/orb-python/commit/632a6bdf45dcf3e88212ab82c7748a3c47a9b6d0))

## 2.1.0 (2024-08-14)

Full Changelog: [v2.0.0...v2.1.0](https://github.com/orbcorp/orb-python/compare/v2.0.0...v2.1.0)

### Features

* **api:** OpenAPI spec update via Stainless API ([#338](https://github.com/orbcorp/orb-python/issues/338)) ([ff005e5](https://github.com/orbcorp/orb-python/commit/ff005e562aeebdc0b4c4a6f91f1dad7af7030d2e))
* **client:** add `retries_taken` to raw response class ([#334](https://github.com/orbcorp/orb-python/issues/334)) ([99d1df1](https://github.com/orbcorp/orb-python/commit/99d1df1a5da230325d47e8c1cc8bf1da53e74253))


### Chores

* **internal:** bump pyright ([#333](https://github.com/orbcorp/orb-python/issues/333)) ([7678fca](https://github.com/orbcorp/orb-python/commit/7678fca8726890c52693c1ff9747f81379749245))
* **internal:** bump ruff version ([#336](https://github.com/orbcorp/orb-python/issues/336)) ([dffe52f](https://github.com/orbcorp/orb-python/commit/dffe52ffdd81cd279b0c789d8c4bfc72493b848a))
* **internal:** test updates ([#335](https://github.com/orbcorp/orb-python/issues/335)) ([ef3b8d2](https://github.com/orbcorp/orb-python/commit/ef3b8d2fc6ae76a79cf08ddd9f3142c594459aa5))
* **internal:** update pydantic compat helper function ([#337](https://github.com/orbcorp/orb-python/issues/337)) ([d8a0d01](https://github.com/orbcorp/orb-python/commit/d8a0d01d4b2b43a8b6a7d6e69891d5ec4ff20809))
* **internal:** use `TypeAlias` marker for type assignments ([#331](https://github.com/orbcorp/orb-python/issues/331)) ([5208144](https://github.com/orbcorp/orb-python/commit/5208144f3767ed7e615ca066c9185b861ca73969))

## 2.0.0 (2024-08-02)

Full Changelog: [v1.56.0...v2.0.0](https://github.com/orbcorp/orb-python/compare/v1.56.0...v2.0.0)

### ⚠ BREAKING CHANGES

* **api:** remove methods 'customers.usage.create' and 'customers.usage.update_by_external_id' ([#330](https://github.com/orbcorp/orb-python/issues/330))
* **api:** endpoint expects amount of new allocation price to be a string, not a number ([#297](https://github.com/orbcorp/orb-python/issues/297))
* **api:** add semi_annual cadence and remove metadata from update items ([#288](https://github.com/orbcorp/orb-python/issues/288))

### Features

* **api:** add 'status' to plan creation params ([#310](https://github.com/orbcorp/orb-python/issues/310)) ([561898f](https://github.com/orbcorp/orb-python/commit/561898f1fa75d83d83f0c1c50d382d04cbaff7d2))
* **api:** add cadence enum value 'custom' ([#327](https://github.com/orbcorp/orb-python/issues/327)) ([e1df500](https://github.com/orbcorp/orb-python/commit/e1df500b8f268eef2a0a8d65851ce903919f8bd2))
* **api:** add methods to prices and invoices ([#321](https://github.com/orbcorp/orb-python/issues/321)) ([0eaba5f](https://github.com/orbcorp/orb-python/commit/0eaba5fe665bf54bd02748587153bb42b080dc2d))
* **api:** add semi_annual cadence and remove metadata from update items ([#288](https://github.com/orbcorp/orb-python/issues/288)) ([4b07848](https://github.com/orbcorp/orb-python/commit/4b07848ecc9d2a4899e20710e121d5cdc984de79))
* **api:** add support for adding allocation price to subscription ([#295](https://github.com/orbcorp/orb-python/issues/295)) ([7e16ef5](https://github.com/orbcorp/orb-python/commit/7e16ef55cd743b63b0ee8f0a9e45052c610998fb))
* **api:** add support for query param include_all_blocks ([#301](https://github.com/orbcorp/orb-python/issues/301)) ([1b7b6a3](https://github.com/orbcorp/orb-python/commit/1b7b6a3236226bdd7bf7bd00d041a0c0a99f24bf))
* **api:** deprecate methods 'customers.usage.create' and 'customers.usage.update_by_external_id' ([#329](https://github.com/orbcorp/orb-python/issues/329)) ([1cc12f1](https://github.com/orbcorp/orb-python/commit/1cc12f133f42ef99910ed4bf5f8e7bf0b42ab34e))
* **api:** external connections made optional when updating items ([#296](https://github.com/orbcorp/orb-python/issues/296)) ([9076f38](https://github.com/orbcorp/orb-python/commit/9076f38ee750cf1f59d6260befb9931d3f878743))
* **api:** remove methods 'customers.usage.create' and 'customers.usage.update_by_external_id' ([#330](https://github.com/orbcorp/orb-python/issues/330)) ([62e5158](https://github.com/orbcorp/orb-python/commit/62e5158e1febd96d28081bd2c7faf023a410088d))
* **api:** updates ([#291](https://github.com/orbcorp/orb-python/issues/291)) ([38aaf34](https://github.com/orbcorp/orb-python/commit/38aaf34361e649e4111f8a4038afe82867c8d4d8))


### Bug Fixes

* **api:** endpoint expects amount of new allocation price to be a string, not a number ([#297](https://github.com/orbcorp/orb-python/issues/297)) ([cb8992b](https://github.com/orbcorp/orb-python/commit/cb8992bf23e9639a27d885e110966cb01acc3e61))
* **build:** include more files in sdist builds ([#300](https://github.com/orbcorp/orb-python/issues/300)) ([922476f](https://github.com/orbcorp/orb-python/commit/922476f4690435b72b12c6a06a92108cf9368d1a))
* **client/async:** avoid blocking io call for platform headers ([#294](https://github.com/orbcorp/orb-python/issues/294)) ([89f4bfe](https://github.com/orbcorp/orb-python/commit/89f4bfe6516912f25d0bbe6e8ecf3343a2e05300))
* **client:** always respect content-type multipart/form-data if provided ([#308](https://github.com/orbcorp/orb-python/issues/308)) ([9d980df](https://github.com/orbcorp/orb-python/commit/9d980dfe52c7e0a9cfdbd9dbed32540589353d1d))
* **docs:** fix link to advanced python httpx docs ([#298](https://github.com/orbcorp/orb-python/issues/298)) ([55cff13](https://github.com/orbcorp/orb-python/commit/55cff139e8175d1dce02004c9715a42006bbb11c))
* temporarily patch upstream version to fix broken release flow ([#299](https://github.com/orbcorp/orb-python/issues/299)) ([b0c95aa](https://github.com/orbcorp/orb-python/commit/b0c95aa994d16c17486bbd999115114174fd2eac))


### Chores

* **ci:** also run workflows for PRs targeting `next` ([#314](https://github.com/orbcorp/orb-python/issues/314)) ([4fc3bcb](https://github.com/orbcorp/orb-python/commit/4fc3bcb9dc201a36e907a56983cb0cf8498c1f54))
* **ci:** limit release doctor target branches ([#323](https://github.com/orbcorp/orb-python/issues/323)) ([fdf2291](https://github.com/orbcorp/orb-python/commit/fdf2291d68f4d0e119ff8ae4c6022f2ed95ca071))
* **ci:** update rye to v0.35.0 ([#309](https://github.com/orbcorp/orb-python/issues/309)) ([540ff37](https://github.com/orbcorp/orb-python/commit/540ff3705d0f986577012bde92cfd2a60c45825d))
* **deps:** bump anyio to v4.4.0 ([#303](https://github.com/orbcorp/orb-python/issues/303)) ([e02d74d](https://github.com/orbcorp/orb-python/commit/e02d74db5b900a2d7a8a3d3bbdb0356ab78db978))
* **docs:** document how to do per-request http client customization ([#322](https://github.com/orbcorp/orb-python/issues/322)) ([30320ae](https://github.com/orbcorp/orb-python/commit/30320ae1074928dc95ee1e23ed6aea8bf47759fd))
* **docs:** improve Coupon description ([#293](https://github.com/orbcorp/orb-python/issues/293)) ([5aa0f32](https://github.com/orbcorp/orb-python/commit/5aa0f328e70673ff0c928bd2b704b1e3822b480c))
* **docs:** minor update to formatting of API link in README ([#318](https://github.com/orbcorp/orb-python/issues/318)) ([67d26e4](https://github.com/orbcorp/orb-python/commit/67d26e4c49d1a0e3b482e660c50ad1bfe99c434f))
* **docs:** updates price intervals docs ([#302](https://github.com/orbcorp/orb-python/issues/302)) ([a05b099](https://github.com/orbcorp/orb-python/commit/a05b09901baddddec77db515ae7102dec167014e))
* fix error message import example ([#326](https://github.com/orbcorp/orb-python/issues/326)) ([4993ac4](https://github.com/orbcorp/orb-python/commit/4993ac4368cfe41249931e45aa7b030c0dceddce))
* gitignore test server logs ([#305](https://github.com/orbcorp/orb-python/issues/305)) ([9a8b82f](https://github.com/orbcorp/orb-python/commit/9a8b82f869b9bb975920f994b0bf8585196445d4))
* **internal:** add a `default_query` method ([#292](https://github.com/orbcorp/orb-python/issues/292)) ([8aa1d73](https://github.com/orbcorp/orb-python/commit/8aa1d7356132d6221b32654616669b8fa1aee9f7))
* **internal:** add helper function ([#312](https://github.com/orbcorp/orb-python/issues/312)) ([3d9704e](https://github.com/orbcorp/orb-python/commit/3d9704eaa3fc9acdd900a0e2357785ac93b18d6a))
* **internal:** add helper method for constructing `BaseModel`s ([#307](https://github.com/orbcorp/orb-python/issues/307)) ([73a4593](https://github.com/orbcorp/orb-python/commit/73a4593797c5bbca315f6ed846427e388c0445ec))
* **internal:** add reflection helper function ([#304](https://github.com/orbcorp/orb-python/issues/304)) ([986bd84](https://github.com/orbcorp/orb-python/commit/986bd84dcb22d9413430f578c28a5adccadaacfd))
* **internal:** add rich as a dev dependency ([#306](https://github.com/orbcorp/orb-python/issues/306)) ([d2a2f3f](https://github.com/orbcorp/orb-python/commit/d2a2f3fe411cb3d57b15c7f3bfd102523def0e8f))
* **internal:** add type construction helper ([#328](https://github.com/orbcorp/orb-python/issues/328)) ([6094016](https://github.com/orbcorp/orb-python/commit/60940163e63ef9798cfb7f177088892933000844))
* **internal:** minor import restructuring ([#315](https://github.com/orbcorp/orb-python/issues/315)) ([eeee65e](https://github.com/orbcorp/orb-python/commit/eeee65e7b30438c9133f47f0aa86b35e54878506))
* **internal:** minor options / compat functions updates ([#317](https://github.com/orbcorp/orb-python/issues/317)) ([2a05873](https://github.com/orbcorp/orb-python/commit/2a05873d80ae4e8bebdbcd2adb7cd1817377cc11))
* **internal:** minor request options handling changes ([#311](https://github.com/orbcorp/orb-python/issues/311)) ([cfcc3eb](https://github.com/orbcorp/orb-python/commit/cfcc3ebc299a387decd8812879a8ad851dc7d6da))
* **internal:** update formatting ([#319](https://github.com/orbcorp/orb-python/issues/319)) ([f212cc8](https://github.com/orbcorp/orb-python/commit/f212cc89ee7b8b783e0fad9fb09d3e772abdf1f4))
* **internal:** update formatting ([#320](https://github.com/orbcorp/orb-python/issues/320)) ([6dc313b](https://github.com/orbcorp/orb-python/commit/6dc313bc36ba258ae2522b649387ff6f42cee818))
* **internal:** update mypy ([#313](https://github.com/orbcorp/orb-python/issues/313)) ([e98ba62](https://github.com/orbcorp/orb-python/commit/e98ba6215dea14581b1d3b54b570a5f176948003))
* **tests:** update prism version ([#325](https://github.com/orbcorp/orb-python/issues/325)) ([a26627c](https://github.com/orbcorp/orb-python/commit/a26627c3b271916424bdd72b4087a51e3b36fc72))


### Documentation

* **examples:** use named params more ([#316](https://github.com/orbcorp/orb-python/issues/316)) ([a451ed6](https://github.com/orbcorp/orb-python/commit/a451ed63406c95767251f976805496a1cf300b5d))
* **readme:** fix example snippet imports ([#324](https://github.com/orbcorp/orb-python/issues/324)) ([47e954d](https://github.com/orbcorp/orb-python/commit/47e954df9d22f1b9cef2883b72479bd10a6a6b69))
* small updates ([#290](https://github.com/orbcorp/orb-python/issues/290)) ([4beb928](https://github.com/orbcorp/orb-python/commit/4beb9285099ff26ed8ca6a9f178f34daf87f053f))

## 1.56.0 (2024-05-29)

Full Changelog: [v1.55.0...v1.56.0](https://github.com/orbcorp/orb-python/compare/v1.55.0...v1.56.0)

### Features

* **api:** pricing model updates ([4dc829a](https://github.com/orbcorp/orb-python/commit/4dc829ad67edf6b4384c6b4432edb7f73c847167))
* **api:** update item endpoint ([#287](https://github.com/orbcorp/orb-python/issues/287)) ([4dc829a](https://github.com/orbcorp/orb-python/commit/4dc829ad67edf6b4384c6b4432edb7f73c847167))


### Chores

* **ci:** update rye install location ([#282](https://github.com/orbcorp/orb-python/issues/282)) ([667cef5](https://github.com/orbcorp/orb-python/commit/667cef59e90027b25829b2dd2bfcdd5917f68627))
* **internal:** bump pyright ([#284](https://github.com/orbcorp/orb-python/issues/284)) ([ef316cc](https://github.com/orbcorp/orb-python/commit/ef316cc860ed7571788a4fbb5509a273f5ac731c))
* **internal:** update bootstrap script ([#286](https://github.com/orbcorp/orb-python/issues/286)) ([72edfe5](https://github.com/orbcorp/orb-python/commit/72edfe561c937aeec2006986b64c7cb18bc8655f))


### Documentation

* **contributing:** update references to rye-up.com ([#285](https://github.com/orbcorp/orb-python/issues/285)) ([5502012](https://github.com/orbcorp/orb-python/commit/55020125e1397497a437de9fcce80f31f341c7d8))

## 1.55.0 (2024-05-23)

Full Changelog: [v1.54.0...v1.55.0](https://github.com/orbcorp/orb-python/compare/v1.54.0...v1.55.0)

### Features

* **api:** updates ([#281](https://github.com/orbcorp/orb-python/issues/281)) ([9293cda](https://github.com/orbcorp/orb-python/commit/9293cdab4af46bc5dbeb1f8dbc7d6dfc1ebf43d6))


### Chores

* **ci:** update rye install location ([#279](https://github.com/orbcorp/orb-python/issues/279)) ([a69dda3](https://github.com/orbcorp/orb-python/commit/a69dda372329408a5e8f5c25da8fb740297d4fd5))

## 1.54.0 (2024-05-22)

Full Changelog: [v1.53.0...v1.54.0](https://github.com/orbcorp/orb-python/compare/v1.53.0...v1.54.0)

### Features

* **api:** add adjustment interval to subscriptions ([#277](https://github.com/orbcorp/orb-python/issues/277)) ([7248240](https://github.com/orbcorp/orb-python/commit/7248240a566b0907f20a3c1639b7c5fa6129bb29))

## 1.53.0 (2024-05-16)

Full Changelog: [v1.52.0...v1.53.0](https://github.com/orbcorp/orb-python/compare/v1.52.0...v1.53.0)

### Features

* **api:** updates ([#276](https://github.com/orbcorp/orb-python/issues/276)) ([b82fbca](https://github.com/orbcorp/orb-python/commit/b82fbca25bf22a6ca49b5cdcc32f916ce8a880d9))


### Chores

* **internal:** add slightly better logging to scripts ([#274](https://github.com/orbcorp/orb-python/issues/274)) ([af172ca](https://github.com/orbcorp/orb-python/commit/af172ca303ee54e6d453bbeee9d0b77e93fcfdf6))

## 1.52.0 (2024-05-14)

Full Changelog: [v1.51.0...v1.52.0](https://github.com/orbcorp/orb-python/compare/v1.51.0...v1.52.0)

### Features

* **api:** updates ([#273](https://github.com/orbcorp/orb-python/issues/273)) ([199805d](https://github.com/orbcorp/orb-python/commit/199805d51549536bf508776452ddc72933507ace))


### Chores

* **internal:** bump pydantic dependency ([#271](https://github.com/orbcorp/orb-python/issues/271)) ([c40750a](https://github.com/orbcorp/orb-python/commit/c40750a90bb962d63bd4531d24d69e6b9e930a9f))

## 1.51.0 (2024-05-13)

Full Changelog: [v1.50.1...v1.51.0](https://github.com/orbcorp/orb-python/compare/v1.50.1...v1.51.0)

### Features

* **api:** updates ([#270](https://github.com/orbcorp/orb-python/issues/270)) ([cc12356](https://github.com/orbcorp/orb-python/commit/cc12356f4d04c4b97ae7eb9ebaf92abdd4192658))


### Chores

* **docs:** add SECURITY.md ([#268](https://github.com/orbcorp/orb-python/issues/268)) ([57ed634](https://github.com/orbcorp/orb-python/commit/57ed634ffbe8be758a1123359f5e61c7e09f7eb7))

## 1.50.1 (2024-05-10)

Full Changelog: [v1.50.0...v1.50.1](https://github.com/orbcorp/orb-python/compare/v1.50.0...v1.50.1)

### Bug Fixes

* **api:** remove alert parameters and method that aren't supported by the live API ([#267](https://github.com/orbcorp/orb-python/issues/267)) ([0719f0d](https://github.com/orbcorp/orb-python/commit/0719f0df752a85aee84067b3c50c1c879de1cebd))


### Chores

* **docs:** improve alert endpoints descriptions ([#263](https://github.com/orbcorp/orb-python/issues/263)) ([633b79d](https://github.com/orbcorp/orb-python/commit/633b79d89acc1c7c80768ee65464f93014b80b5a))
* rebuild project due to oas spec rename ([#266](https://github.com/orbcorp/orb-python/issues/266)) ([60072ac](https://github.com/orbcorp/orb-python/commit/60072ac2e0a3dc8ae6c0af9c8919ee77438a8d47))
* **types:** add union discriminator metadata ([#265](https://github.com/orbcorp/orb-python/issues/265)) ([4cfa964](https://github.com/orbcorp/orb-python/commit/4cfa96454f09914d15405b1d2bb3fe26d95cd2bc))

## 1.50.0 (2024-05-09)

Full Changelog: [v1.49.0...v1.50.0](https://github.com/orbcorp/orb-python/compare/v1.49.0...v1.50.0)

### Features

* **api:** add alert methods and models ([#261](https://github.com/orbcorp/orb-python/issues/261)) ([fca2f46](https://github.com/orbcorp/orb-python/commit/fca2f46382d5f88213d2b214cef88b8d6ac4902f))


### Chores

* **internal:** remove redundant decorator args ([#259](https://github.com/orbcorp/orb-python/issues/259)) ([944e9fd](https://github.com/orbcorp/orb-python/commit/944e9fdc862b5628afd4924a3dfe66870f5030c5))

## 1.49.0 (2024-05-08)

Full Changelog: [v1.48.0...v1.49.0](https://github.com/orbcorp/orb-python/compare/v1.48.0...v1.49.0)

### Features

* **api:** add method to enable alerts ([#255](https://github.com/orbcorp/orb-python/issues/255)) ([8531900](https://github.com/orbcorp/orb-python/commit/853190015924d67b6264db3f3f60cc143e037a6e))

## 1.48.0 (2024-05-03)

Full Changelog: [v1.47.1...v1.48.0](https://github.com/orbcorp/orb-python/compare/v1.47.1...v1.48.0)

### Features

* add webhooks verification helpers ([d3763df](https://github.com/orbcorp/orb-python/commit/d3763df9526cf311d85b32db4edba3e45e5030ae))
* **api:** add `invoice_source` to invoice ([#225](https://github.com/orbcorp/orb-python/issues/225)) ([4d65ea3](https://github.com/orbcorp/orb-python/commit/4d65ea32c00b414b048bfef207693c7b2d37179d))
* **api:** add effective_date field ([#231](https://github.com/orbcorp/orb-python/issues/231)) ([4db6fc1](https://github.com/orbcorp/orb-python/commit/4db6fc122e378b78a64a1acf39e1ee6706219261))
* **api:** add param to backfill create ([#247](https://github.com/orbcorp/orb-python/issues/247)) ([8a21054](https://github.com/orbcorp/orb-python/commit/8a21054c80251481a73d34bf6e08c54a40d4f172))
* **api:** add subscription update endpoint ([#238](https://github.com/orbcorp/orb-python/issues/238)) ([c116802](https://github.com/orbcorp/orb-python/commit/c1168027beec59d88637ef4ea8494ccfbd894f16))
* **api:** add the shared model PaginationMetadata ([#235](https://github.com/orbcorp/orb-python/issues/235)) ([0506ab6](https://github.com/orbcorp/orb-python/commit/0506ab6af67bdb2def0f6df28c2678738c43a16c))
* **api:** add tiered package with minimum price ([#220](https://github.com/orbcorp/orb-python/issues/220)) ([6f47aea](https://github.com/orbcorp/orb-python/commit/6f47aeaa3b8e7989559e969dd589aa20eeb0b725))
* **api:** price evaluation endpoint generally available ([#240](https://github.com/orbcorp/orb-python/issues/240)) ([c83a0b4](https://github.com/orbcorp/orb-python/commit/c83a0b4e13cdb01d1baa394d600f88dee8185b10))
* **api:** remove accidental null ([#215](https://github.com/orbcorp/orb-python/issues/215)) ([41dcb8c](https://github.com/orbcorp/orb-python/commit/41dcb8cc7a79ec9a7692112b7fe8ad26ddcf1635))
* **api:** timeframe_end and timeframe_start accept null ([#219](https://github.com/orbcorp/orb-python/issues/219)) ([3a3872e](https://github.com/orbcorp/orb-python/commit/3a3872e0e6982ddbf8470112aa2e6717f7f8bd75))
* **api:** updates ([#210](https://github.com/orbcorp/orb-python/issues/210)) ([5b302c6](https://github.com/orbcorp/orb-python/commit/5b302c6eded8517c30f599d71dbd3b7bd7bb0cc7))
* **api:** updates ([#228](https://github.com/orbcorp/orb-python/issues/228)) ([d0ffb6d](https://github.com/orbcorp/orb-python/commit/d0ffb6da7fc33b7f73a98957f0f934a762839e4b))
* **api:** updates ([#229](https://github.com/orbcorp/orb-python/issues/229)) ([dc48f78](https://github.com/orbcorp/orb-python/commit/dc48f788211674bd4c583abaedbb2cb447b81663))
* **api:** updates ([#252](https://github.com/orbcorp/orb-python/issues/252)) ([85d4759](https://github.com/orbcorp/orb-python/commit/85d4759b593cc6cc7a531f0fba9cb1b2c13baf8a))
* **client:** add DefaultHttpxClient and DefaultAsyncHttpxClient ([#224](https://github.com/orbcorp/orb-python/issues/224)) ([128a275](https://github.com/orbcorp/orb-python/commit/128a2759502c5fe4ffb1ca6eb064f9cc770849fc))
* **client:** add webhook secret argument ([#212](https://github.com/orbcorp/orb-python/issues/212)) ([b611a6c](https://github.com/orbcorp/orb-python/commit/b611a6cc05461d9f671013d30ffb064c12585902))
* **models:** add to_dict & to_json helper methods ([#226](https://github.com/orbcorp/orb-python/issues/226)) ([db7526a](https://github.com/orbcorp/orb-python/commit/db7526af6d978a9e30efd8a2bd2ec3b2b64f237f))
* **package:** export default constants ([#214](https://github.com/orbcorp/orb-python/issues/214)) ([1d80f5f](https://github.com/orbcorp/orb-python/commit/1d80f5f5ddba235105be06802de4dfab63ac58d7))


### Bug Fixes

* **api:** add shared model BillingCycleRelativeDate ([#237](https://github.com/orbcorp/orb-python/issues/237)) ([ed85a2a](https://github.com/orbcorp/orb-python/commit/ed85a2a011526f244f8da2f709ad7dd3039c6ffc))
* **api:** some path params were incorrectly typed as nullable ([#236](https://github.com/orbcorp/orb-python/issues/236)) ([f89e868](https://github.com/orbcorp/orb-python/commit/f89e868c1645a4f6d45f398cded1bea2b1706fb4))
* **docs:** doc improvements ([#242](https://github.com/orbcorp/orb-python/issues/242)) ([d7bc080](https://github.com/orbcorp/orb-python/commit/d7bc080c79678c9e4afff43ae65a306435e64445))
* **project:** use absolute github links on PyPi ([#216](https://github.com/orbcorp/orb-python/issues/216)) ([bb54f40](https://github.com/orbcorp/orb-python/commit/bb54f4068a50e3ca4ce7e87e5ce9f75259f1a082))


### Chores

* **client:** log response headers in debug mode ([#248](https://github.com/orbcorp/orb-python/issues/248)) ([b368546](https://github.com/orbcorp/orb-python/commit/b368546016f0d95e0c8f87f54388b62c6116c777))
* **client:** validate that max_retries is not None ([#218](https://github.com/orbcorp/orb-python/issues/218)) ([c885c17](https://github.com/orbcorp/orb-python/commit/c885c1755b467647bb42ab6b1ded3125dd90a705))
* **docs:** revise currency description ([#223](https://github.com/orbcorp/orb-python/issues/223)) ([b19a196](https://github.com/orbcorp/orb-python/commit/b19a196e63cc79d69e0249ae510357d614bd2691))
* fix typo ([#227](https://github.com/orbcorp/orb-python/issues/227)) ([cd4f7e2](https://github.com/orbcorp/orb-python/commit/cd4f7e2d071d6ea336466d41a0c707b47e60caf9))
* **internal:** add link to openapi spec ([#249](https://github.com/orbcorp/orb-python/issues/249)) ([b370433](https://github.com/orbcorp/orb-python/commit/b3704332e9fd5613ff182e7883c56eeebfaa8b15))
* **internal:** add lru_cache helper function ([#232](https://github.com/orbcorp/orb-python/issues/232)) ([a7b6f74](https://github.com/orbcorp/orb-python/commit/a7b6f74ca43e4480cf54b8c859a4c7cc5139bab9))
* **internal:** add scripts/test, scripts/mock and add ci job ([#250](https://github.com/orbcorp/orb-python/issues/250)) ([85b7769](https://github.com/orbcorp/orb-python/commit/85b77697608292090e5308885553abd9a9e0e540))
* **internal:** ban usage of lru_cache ([#233](https://github.com/orbcorp/orb-python/issues/233)) ([e7074d3](https://github.com/orbcorp/orb-python/commit/e7074d3efeba5b4ee5d1cd686f614f18222c04ee))
* **internal:** bump mock server version to ~5.8.0 ([#251](https://github.com/orbcorp/orb-python/issues/251)) ([d9d27b0](https://github.com/orbcorp/orb-python/commit/d9d27b014c244616d6b57264e325104986fb8d18))
* **internal:** bump pyright to 1.1.359 ([#234](https://github.com/orbcorp/orb-python/issues/234)) ([11ab6aa](https://github.com/orbcorp/orb-python/commit/11ab6aa7fb78ad5828837ce9ebfcb70d60eee413))
* **internal:** defer model build for import latency ([#221](https://github.com/orbcorp/orb-python/issues/221)) ([5a58805](https://github.com/orbcorp/orb-python/commit/5a58805776bdc08f3b045b8a1cf6117f99e49ac4))
* **internal:** formatting ([#230](https://github.com/orbcorp/orb-python/issues/230)) ([04ff195](https://github.com/orbcorp/orb-python/commit/04ff19541848db9f482f2215900f969229436975))
* **internal:** minor reformatting ([#246](https://github.com/orbcorp/orb-python/issues/246)) ([c549be2](https://github.com/orbcorp/orb-python/commit/c549be2564cefe0779cbcc272236c00d91bf3764))
* **internal:** reformat imports ([#245](https://github.com/orbcorp/orb-python/issues/245)) ([45181a9](https://github.com/orbcorp/orb-python/commit/45181a960e7af01dfea6aa1c3da874f39753d572))
* **internal:** restructure imports ([#239](https://github.com/orbcorp/orb-python/issues/239)) ([3dddf85](https://github.com/orbcorp/orb-python/commit/3dddf850cfaf3fffde98856f2b1dc3d91947f145))
* **internal:** streaming updates ([#222](https://github.com/orbcorp/orb-python/issues/222)) ([a207206](https://github.com/orbcorp/orb-python/commit/a2072064621318de18de7597caf2afb24ce3a93c))
* **internal:** update test helper function ([#244](https://github.com/orbcorp/orb-python/issues/244)) ([2c95701](https://github.com/orbcorp/orb-python/commit/2c9570140a896212ec8f29d3bcb5769325cbe46b))
* **internal:** use actions/checkout@v4 for codeflow ([#243](https://github.com/orbcorp/orb-python/issues/243)) ([5ee51b3](https://github.com/orbcorp/orb-python/commit/5ee51b32ff1e46896b0a5f7bd285ab1d825bcb94))


### Documentation

* **readme:** fix misleading timeout example value ([#253](https://github.com/orbcorp/orb-python/issues/253)) ([293da36](https://github.com/orbcorp/orb-python/commit/293da3662174d57cdb8dbcf8c2f38e687d974e80))

## 1.47.1 (2024-03-25)

Full Changelog: [v1.47.0...v1.47.1](https://github.com/orbcorp/orb-python/compare/v1.47.0...v1.47.1)

### Bug Fixes

* revert regression with 3.7 support ([#209](https://github.com/orbcorp/orb-python/issues/209)) ([11f44da](https://github.com/orbcorp/orb-python/commit/11f44da6ff3ca5f9f3d762a216fc0e434ae78ba0))


### Chores

* **internal:** formatting change ([#206](https://github.com/orbcorp/orb-python/issues/206)) ([b4bfd91](https://github.com/orbcorp/orb-python/commit/b4bfd91467762d409b0d1d699d914aeb5d730e72))


### Documentation

* **contributing:** fix typo ([#208](https://github.com/orbcorp/orb-python/issues/208)) ([1d2f286](https://github.com/orbcorp/orb-python/commit/1d2f2866dee4556bc0c3124ec73aca49d62b138a))

## 1.47.0 (2024-03-21)

Full Changelog: [v1.46.0...v1.47.0](https://github.com/orbcorp/orb-python/compare/v1.46.0...v1.47.0)

### Features

* **api:** introduce credits status ([d15d875](https://github.com/orbcorp/orb-python/commit/d15d875ee628eb8a3af8d3a2e67126b069984d1c))
* **api:** remove `scaling_factor` ([#205](https://github.com/orbcorp/orb-python/issues/205)) ([d15d875](https://github.com/orbcorp/orb-python/commit/d15d875ee628eb8a3af8d3a2e67126b069984d1c))


### Performance Improvements

* cache TypeAdapters ([#197](https://github.com/orbcorp/orb-python/issues/197)) ([536a387](https://github.com/orbcorp/orb-python/commit/536a38777b2b9fb5dc944eb712e9f31e389cc52f))


### Chores

* **internal:** construct error properties instead of using the raw response ([#204](https://github.com/orbcorp/orb-python/issues/204)) ([e5438a9](https://github.com/orbcorp/orb-python/commit/e5438a9958ba21a35c90d40edc4438450e91601b))
* **internal:** loosen input type for util function ([#202](https://github.com/orbcorp/orb-python/issues/202)) ([6d48c20](https://github.com/orbcorp/orb-python/commit/6d48c20cb8f0b64aaa2ce57804076987b422f9f4))
* **internal:** update generated pragma comment ([#200](https://github.com/orbcorp/orb-python/issues/200)) ([336a736](https://github.com/orbcorp/orb-python/commit/336a736ae99e6c54353da05891a0a68a78339cd0))


### Documentation

* fix typo in CONTRIBUTING.md ([#199](https://github.com/orbcorp/orb-python/issues/199)) ([5ffe938](https://github.com/orbcorp/orb-python/commit/5ffe9386e8baec7f94bcb0505ee25c153004767f))
* **readme:** document how to make undocumented requests ([#203](https://github.com/orbcorp/orb-python/issues/203)) ([9757d20](https://github.com/orbcorp/orb-python/commit/9757d20415f0ad8f42109d207800f6546be56ff4))
* updated invoice description ([#201](https://github.com/orbcorp/orb-python/issues/201)) ([ba19ce0](https://github.com/orbcorp/orb-python/commit/ba19ce050fedf92e06a6775d4b51f9b43b0a4d8d))

## 1.46.0 (2024-03-15)

Full Changelog: [v1.45.0...v1.46.0](https://github.com/orbcorp/orb-python/compare/v1.45.0...v1.46.0)

### Features

* **api:** create invoice metadata param ([#195](https://github.com/orbcorp/orb-python/issues/195)) ([e5504a6](https://github.com/orbcorp/orb-python/commit/e5504a69a54c4b5b6548ec7e4914c5dfb58cdd09))

## 1.45.0 (2024-03-14)

Full Changelog: [v1.44.0...v1.45.0](https://github.com/orbcorp/orb-python/compare/v1.44.0...v1.45.0)

### Features

* **api:** add matrix with allocation price ([#193](https://github.com/orbcorp/orb-python/issues/193)) ([45cc072](https://github.com/orbcorp/orb-python/commit/45cc0723c18b50506456591498798a1fa4994bff))

## 1.44.0 (2024-03-11)

Full Changelog: [v1.43.0...v1.44.0](https://github.com/orbcorp/orb-python/compare/v1.43.0...v1.44.0)

### Features

* **api:** updates ([#192](https://github.com/orbcorp/orb-python/issues/192)) ([876b19f](https://github.com/orbcorp/orb-python/commit/876b19f71822f752eb33e106466ac766cc73e148))


### Chores

* **internal:** improve deserialisation of discriminated unions ([#190](https://github.com/orbcorp/orb-python/issues/190)) ([5b96dd5](https://github.com/orbcorp/orb-python/commit/5b96dd5f664fb69a0db1a990e184a6bfbcb5b499))

## 1.43.0 (2024-03-09)

Full Changelog: [v1.42.3...v1.43.0](https://github.com/orbcorp/orb-python/compare/v1.42.3...v1.43.0)

### Features

* **api:** updates ([#189](https://github.com/orbcorp/orb-python/issues/189)) ([3b9e36f](https://github.com/orbcorp/orb-python/commit/3b9e36f1fbca43b9e29794778178056d94870b2e))


### Chores

* **ci:** uses Stainless GitHub App for releases ([#172](https://github.com/orbcorp/orb-python/issues/172)) ([d5b9f5f](https://github.com/orbcorp/orb-python/commit/d5b9f5fff40d93d4aad599b38b8771284619d01d))
* **client:** improve error message for invalid http_client argument ([#184](https://github.com/orbcorp/orb-python/issues/184)) ([17dacf2](https://github.com/orbcorp/orb-python/commit/17dacf22512f6bb7d3cc0c87905f92d964a84a76))
* **client:** use anyio.sleep instead of asyncio.sleep ([#178](https://github.com/orbcorp/orb-python/issues/178)) ([677ef7e](https://github.com/orbcorp/orb-python/commit/677ef7e68840dd04cfbd7cae8e6a5af9998bc306))
* **docs:** mention install from git repo ([#181](https://github.com/orbcorp/orb-python/issues/181)) ([795ae88](https://github.com/orbcorp/orb-python/commit/795ae882855d557105339689155110f4506da4c2))
* export NOT_GIVEN sentinel value ([#188](https://github.com/orbcorp/orb-python/issues/188)) ([7a739b9](https://github.com/orbcorp/orb-python/commit/7a739b9a3b0a06704e02944c1af01930335c2b97))
* **internal:** add core support for deserializing into number response ([#185](https://github.com/orbcorp/orb-python/issues/185)) ([247964e](https://github.com/orbcorp/orb-python/commit/247964ea68575e12ba5aad7c39675a48e3653474))
* **internal:** bump pyright ([#177](https://github.com/orbcorp/orb-python/issues/177)) ([f5c6f0c](https://github.com/orbcorp/orb-python/commit/f5c6f0c3b5a432933a053f227d630df20582c4c4))
* **internal:** bump pyright ([#186](https://github.com/orbcorp/orb-python/issues/186)) ([03ff063](https://github.com/orbcorp/orb-python/commit/03ff063b02838b75a1e8f602aae312afd12e44b6))
* **internal:** bump rye to v0.24.0 ([#175](https://github.com/orbcorp/orb-python/issues/175)) ([450508a](https://github.com/orbcorp/orb-python/commit/450508a34a4838b92c54ff10ba439f6d60808b04))
* **internal:** minor core client restructuring ([#179](https://github.com/orbcorp/orb-python/issues/179)) ([ace9451](https://github.com/orbcorp/orb-python/commit/ace945177ced39721f2eb8ea1ddd9b9b448b73bd))
* **internal:** refactor release environment script ([#173](https://github.com/orbcorp/orb-python/issues/173)) ([2503fbc](https://github.com/orbcorp/orb-python/commit/2503fbc1c20524c9057ab5a1ef25bb279ee35827))
* **internal:** split up transforms into sync / async ([#182](https://github.com/orbcorp/orb-python/issues/182)) ([17a94e7](https://github.com/orbcorp/orb-python/commit/17a94e75d071908b7e9048d26a26adaf16f2b52c))
* **internal:** support more input types ([#183](https://github.com/orbcorp/orb-python/issues/183)) ([fc2721e](https://github.com/orbcorp/orb-python/commit/fc2721e1638b3c79d5e22f573923c09142196c43))
* **internal:** support parsing Annotated types ([#187](https://github.com/orbcorp/orb-python/issues/187)) ([9982119](https://github.com/orbcorp/orb-python/commit/9982119ec618bba15f0e1cfa1eac9adc5168206a))
* **internal:** update deps ([#176](https://github.com/orbcorp/orb-python/issues/176)) ([abdbcc6](https://github.com/orbcorp/orb-python/commit/abdbcc69bb3efc80fabe4980c6eacc3cf8725dbd))


### Documentation

* add CONTRIBUTING.md ([#170](https://github.com/orbcorp/orb-python/issues/170)) ([87d1adf](https://github.com/orbcorp/orb-python/commit/87d1adfaaeb7afaf4741e9e26afb07ac7962b6c1))
* **contributing:** improve wording ([#180](https://github.com/orbcorp/orb-python/issues/180)) ([ff322f1](https://github.com/orbcorp/orb-python/commit/ff322f16b36dba9051c6c6c7c49d2c34419317ca))

## 1.42.3 (2024-02-07)

Full Changelog: [v1.42.2...v1.42.3](https://github.com/orbcorp/orb-python/compare/v1.42.2...v1.42.3)

### Bug Fixes

* change status serialization behavior ([#168](https://github.com/orbcorp/orb-python/issues/168)) ([fb5348b](https://github.com/orbcorp/orb-python/commit/fb5348bc15be70b3d5165916013d0f597265ad00))

## 1.42.2 (2024-02-06)

Full Changelog: [v1.42.1...v1.42.2](https://github.com/orbcorp/orb-python/compare/v1.42.1...v1.42.2)

### Bug Fixes

* **types:** loosen most List params types to Iterable ([#167](https://github.com/orbcorp/orb-python/issues/167)) ([ee5959e](https://github.com/orbcorp/orb-python/commit/ee5959e48c748cd89010d8a4e74b9b366746dde9))


### Chores

* **internal:** add lint command ([#166](https://github.com/orbcorp/orb-python/issues/166)) ([0cc21f7](https://github.com/orbcorp/orb-python/commit/0cc21f78e4a17364ad89917f5a9f32a4ecc039a3))
* **internal:** support serialising iterable types ([#164](https://github.com/orbcorp/orb-python/issues/164)) ([246a496](https://github.com/orbcorp/orb-python/commit/246a496c589b015931f273912d31fefacfe08a93))

## 1.42.1 (2024-02-04)

Full Changelog: [v1.42.0...v1.42.1](https://github.com/orbcorp/orb-python/compare/v1.42.0...v1.42.1)

### Bug Fixes

* prevent crash when platform.architecture() is not allowed ([#163](https://github.com/orbcorp/orb-python/issues/163)) ([20629a0](https://github.com/orbcorp/orb-python/commit/20629a05e67981b09a3b506ae32e5d3d64ca9420))


### Chores

* **interal:** make link to api.md relative ([#161](https://github.com/orbcorp/orb-python/issues/161)) ([7710cdc](https://github.com/orbcorp/orb-python/commit/7710cdcad2adeaa76d1ff7f7ee6e149a5e67c451))

## 1.42.0 (2024-02-01)

Full Changelog: [v1.41.0...v1.42.0](https://github.com/orbcorp/orb-python/compare/v1.41.0...v1.42.0)

### Features

* **api:** add `version` to plan ([#160](https://github.com/orbcorp/orb-python/issues/160)) ([de490e8](https://github.com/orbcorp/orb-python/commit/de490e80dd640df0a12132bbccaf692f3312db77))


### Chores

* **internal:** support pre-release versioning ([#158](https://github.com/orbcorp/orb-python/issues/158)) ([3dd41bb](https://github.com/orbcorp/orb-python/commit/3dd41bb0c9673ed434bdb95fc11391f735148117))

## 1.41.0 (2024-01-30)

Full Changelog: [v1.40.0...v1.41.0](https://github.com/orbcorp/orb-python/compare/v1.40.0...v1.41.0)

### Features

* **api:** price schema updates ([#156](https://github.com/orbcorp/orb-python/issues/156)) ([e995c09](https://github.com/orbcorp/orb-python/commit/e995c090615a17b3f622b001639ff1a3f619006e))

## 1.40.0 (2024-01-30)

Full Changelog: [v1.39.1...v1.40.0](https://github.com/orbcorp/orb-python/compare/v1.39.1...v1.40.0)

### Features

* **api:** add `external_customer_id` ([#155](https://github.com/orbcorp/orb-python/issues/155)) ([0e74ce3](https://github.com/orbcorp/orb-python/commit/0e74ce35a735c8900b291a476b4099b3bed6bc64))
* **client:** enable follow redirects by default ([#150](https://github.com/orbcorp/orb-python/issues/150)) ([94c7376](https://github.com/orbcorp/orb-python/commit/94c737641bd7bd06c388ed8bb549e84a6ee35e61))
* **client:** support parsing custom response types ([#153](https://github.com/orbcorp/orb-python/issues/153)) ([da133ec](https://github.com/orbcorp/orb-python/commit/da133ec1c09a43ee47462862981864b0661aa3a2))


### Chores

* **internal:** add internal helpers ([#147](https://github.com/orbcorp/orb-python/issues/147)) ([bf87d8e](https://github.com/orbcorp/orb-python/commit/bf87d8e4067e77bfa2ace0f4c8904e4994c28996))
* **internal:** cast type in mocked test ([#154](https://github.com/orbcorp/orb-python/issues/154)) ([579cda7](https://github.com/orbcorp/orb-python/commit/579cda758208204d9817e8bfffed19e88f526aca))
* **internal:** enable ruff type checking misuse lint rule ([#152](https://github.com/orbcorp/orb-python/issues/152)) ([a98b037](https://github.com/orbcorp/orb-python/commit/a98b037cc8689969a7f482a1476df3e280cb1696))
* **internal:** support multipart data with overlapping keys ([#151](https://github.com/orbcorp/orb-python/issues/151)) ([988e720](https://github.com/orbcorp/orb-python/commit/988e72066d898cb2c86913a255d3cccc72e3aba5))


### Refactors

* remove unnecessary builtin import ([#149](https://github.com/orbcorp/orb-python/issues/149)) ([285bbc2](https://github.com/orbcorp/orb-python/commit/285bbc2397151118d8fdbf5b5475673566d4cba8))

## 1.39.1 (2024-01-18)

Full Changelog: [v1.39.0...v1.39.1](https://github.com/orbcorp/orb-python/compare/v1.39.0...v1.39.1)

### Bug Fixes

* **ci:** ignore stainless-app edits to release PR title ([#146](https://github.com/orbcorp/orb-python/issues/146)) ([5a2e2b5](https://github.com/orbcorp/orb-python/commit/5a2e2b58b7763a99907ae3a3a8afd6a19789cb62))


### Chores

* **internal:** fix typing util function ([#140](https://github.com/orbcorp/orb-python/issues/140)) ([31a83a9](https://github.com/orbcorp/orb-python/commit/31a83a9d24ba25004ab234dc1b555a03d7333a1f))
* **internal:** remove redundant client test ([#142](https://github.com/orbcorp/orb-python/issues/142)) ([e315f4e](https://github.com/orbcorp/orb-python/commit/e315f4e00c4e2a45a657d56df3a22813264632a3))
* **internal:** share client instances between all tests ([#145](https://github.com/orbcorp/orb-python/issues/145)) ([64a4cb6](https://github.com/orbcorp/orb-python/commit/64a4cb6dfc3b5947701dba25dbe8c37b6050eb38))
* **internal:** speculative retry-after-ms support ([#143](https://github.com/orbcorp/orb-python/issues/143)) ([d7affe9](https://github.com/orbcorp/orb-python/commit/d7affe9e3fae951027d43307df10420143e69042))
* lazy load raw resource class properties ([#144](https://github.com/orbcorp/orb-python/issues/144)) ([72734a3](https://github.com/orbcorp/orb-python/commit/72734a340d158aae1e039d615a72bff2b9d89454))

## 1.39.0 (2024-01-17)

Full Changelog: [v1.38.1...v1.39.0](https://github.com/orbcorp/orb-python/compare/v1.38.1...v1.39.0)

### Features

* **api:** updates ([#139](https://github.com/orbcorp/orb-python/issues/139)) ([ab7998f](https://github.com/orbcorp/orb-python/commit/ab7998fa311038357c124fe556b9cd1a664d826b))


### Chores

* add write_to_file binary helper method ([#138](https://github.com/orbcorp/orb-python/issues/138)) ([f48014d](https://github.com/orbcorp/orb-python/commit/f48014d0792e01dde7206088ab672c6012d00deb))
* **internal:** updates to proxy helper ([#136](https://github.com/orbcorp/orb-python/issues/136)) ([15d29d5](https://github.com/orbcorp/orb-python/commit/15d29d513cd6b58fee06b6165bc2ce16fba7e096))

## 1.38.1 (2024-01-16)

Full Changelog: [v1.38.0...v1.38.1](https://github.com/orbcorp/orb-python/compare/v1.38.0...v1.38.1)

### Bug Fixes

* **client:** ensure path params are non-empty ([#134](https://github.com/orbcorp/orb-python/issues/134)) ([f318392](https://github.com/orbcorp/orb-python/commit/f318392b5ff32e4b53a021773220fda59aae0920))

## 1.38.0 (2024-01-15)

Full Changelog: [v1.37.0...v1.38.0](https://github.com/orbcorp/orb-python/compare/v1.37.0...v1.38.0)

### Features

* **api:** updates ([#133](https://github.com/orbcorp/orb-python/issues/133)) ([ace1234](https://github.com/orbcorp/orb-python/commit/ace12344fddc86150429c497f64f7fca030fc24e))
* **client:** add support for streaming raw responses ([#132](https://github.com/orbcorp/orb-python/issues/132)) ([171a504](https://github.com/orbcorp/orb-python/commit/171a504c2c74724fbedcd82d3696e8e1acf18eb9))


### Chores

* formatting ([#130](https://github.com/orbcorp/orb-python/issues/130)) ([4ae6c11](https://github.com/orbcorp/orb-python/commit/4ae6c1177b9d67e82baa44c4560e1372bfbd2f0a))

## 1.37.0 (2024-01-12)

Full Changelog: [v1.36.0...v1.37.0](https://github.com/orbcorp/orb-python/compare/v1.36.0...v1.37.0)

### Features

* add `None` default value to nullable response properties ([#123](https://github.com/orbcorp/orb-python/issues/123)) ([823f95c](https://github.com/orbcorp/orb-python/commit/823f95c2b504524de1bc65e00ca088d2552fad7b))
* **api:** add beta evaluate price endpoint ([#129](https://github.com/orbcorp/orb-python/issues/129)) ([5f8379a](https://github.com/orbcorp/orb-python/commit/5f8379a3acea6a9937219cb6878991a05a8c50b4))


### Chores

* add .keep files for examples and custom code directories ([#126](https://github.com/orbcorp/orb-python/issues/126)) ([672693d](https://github.com/orbcorp/orb-python/commit/672693d7c7cfec8d55d54ab328ea4c89f3527b55))
* **client:** improve debug logging for failed requests ([#127](https://github.com/orbcorp/orb-python/issues/127)) ([b35adf9](https://github.com/orbcorp/orb-python/commit/b35adf9795ce2321640904d43eb4ff806c8a1af8))
* **internal:** loosen type var restrictions ([#125](https://github.com/orbcorp/orb-python/issues/125)) ([60a2816](https://github.com/orbcorp/orb-python/commit/60a28169d5912c1a76f128c02012c062f507cb1f))
* **internal:** replace isort with ruff ([#121](https://github.com/orbcorp/orb-python/issues/121)) ([42b60df](https://github.com/orbcorp/orb-python/commit/42b60dfa929e6806fbddf6138af4df5a1557f2d7))
* use property declarations for resource members ([#124](https://github.com/orbcorp/orb-python/issues/124)) ([b60f5a8](https://github.com/orbcorp/orb-python/commit/b60f5a8a44687083c627d284fe3f7c105a3bbb84))


### Documentation

* **readme:** improve api reference ([#128](https://github.com/orbcorp/orb-python/issues/128)) ([5fbd017](https://github.com/orbcorp/orb-python/commit/5fbd01703a0dd0dd90f7359a703a8d6693c608ca))

## 1.36.0 (2024-01-01)

Full Changelog: [v1.35.2...v1.36.0](https://github.com/orbcorp/orb-python/compare/v1.35.2...v1.36.0)

### Features

* **api:** add currency fields ([#119](https://github.com/orbcorp/orb-python/issues/119)) ([35574d3](https://github.com/orbcorp/orb-python/commit/35574d339cff2ed011a17433af556ffed02af9b7))

## 1.35.2 (2023-12-28)

Full Changelog: [v1.35.1...v1.35.2](https://github.com/orbcorp/orb-python/compare/v1.35.1...v1.35.2)

### Bug Fixes

* **client:** correctly use custom http client auth ([#117](https://github.com/orbcorp/orb-python/issues/117)) ([863ebe8](https://github.com/orbcorp/orb-python/commit/863ebe87f4881f01afa7a39286a5b154ca047305))

## 1.35.1 (2023-12-26)

Full Changelog: [v1.35.0...v1.35.1](https://github.com/orbcorp/orb-python/compare/v1.35.0...v1.35.1)

### Bug Fixes

* use brackets instead of commas for array query params ([#116](https://github.com/orbcorp/orb-python/issues/116)) ([a03afeb](https://github.com/orbcorp/orb-python/commit/a03afeb4c13765e905a3e5fc8e52e1da4fa8e4be))


### Chores

* **ci:** run release workflow once per day ([#107](https://github.com/orbcorp/orb-python/issues/107)) ([8399dca](https://github.com/orbcorp/orb-python/commit/8399dcad701cac68076d88efba8aa2f6d456ad4b))
* **internal:** add bin script ([#113](https://github.com/orbcorp/orb-python/issues/113)) ([ed19a63](https://github.com/orbcorp/orb-python/commit/ed19a63151d3f4119fa70b68459242030a4ba199))
* **internal:** fix typos ([#111](https://github.com/orbcorp/orb-python/issues/111)) ([e2ba1db](https://github.com/orbcorp/orb-python/commit/e2ba1db59f6d8e86c625310d5017ece279788bd2))
* **internal:** minor utils restructuring ([#110](https://github.com/orbcorp/orb-python/issues/110)) ([1946480](https://github.com/orbcorp/orb-python/commit/19464809e1a6d4ba122b767ed59551ec0509503e))
* **internal:** updates to base client ([#108](https://github.com/orbcorp/orb-python/issues/108)) ([53ea238](https://github.com/orbcorp/orb-python/commit/53ea2380bb8280bd679255afed4300daeb1620ea))
* **internal:** use ruff instead of black for formatting ([#115](https://github.com/orbcorp/orb-python/issues/115)) ([ed83783](https://github.com/orbcorp/orb-python/commit/ed837839d28c1191bb4656577b8d80a411ce82dd))
* **package:** bump minimum typing-extensions to 4.7 ([#112](https://github.com/orbcorp/orb-python/issues/112)) ([440c756](https://github.com/orbcorp/orb-python/commit/440c756ffab480330f7a01dbbb129a26f41c1612))


### Documentation

* **api:** updates ([#109](https://github.com/orbcorp/orb-python/issues/109)) ([692c3e8](https://github.com/orbcorp/orb-python/commit/692c3e8ea49d3fe7dfc2f03d78be25cc2237fb9f))
* avoid normalizing trailing space ([#106](https://github.com/orbcorp/orb-python/issues/106)) ([09fd3f8](https://github.com/orbcorp/orb-python/commit/09fd3f8e37d3138bd32532aba6729e24b208684c))
* improve README timeout comment ([#101](https://github.com/orbcorp/orb-python/issues/101)) ([69a6970](https://github.com/orbcorp/orb-python/commit/69a6970e11ba88969a3c17dcd4374f8197b88dca))


### Refactors

* **client:** simplify cleanup ([#103](https://github.com/orbcorp/orb-python/issues/103)) ([54ac0dd](https://github.com/orbcorp/orb-python/commit/54ac0ddb1b703e011e84f184e6e90ee9f31e2055))
* remove unused model types used in params ([#105](https://github.com/orbcorp/orb-python/issues/105)) ([e18a59e](https://github.com/orbcorp/orb-python/commit/e18a59e47125aafb2e81f29f45fe9e866c738d28))
* simplify internal error handling ([#104](https://github.com/orbcorp/orb-python/issues/104)) ([cd0f847](https://github.com/orbcorp/orb-python/commit/cd0f8472457ac651c2fa44dc1e464cac78257c59))

## 1.35.0 (2023-12-11)

Full Changelog: [v1.34.1...v1.35.0](https://github.com/orbcorp/orb-python/compare/v1.34.1...v1.35.0)

### Features

* **api:** updates ([#99](https://github.com/orbcorp/orb-python/issues/99)) ([3b9bc05](https://github.com/orbcorp/orb-python/commit/3b9bc053aab713661aa372952e44e30a76f8bd81))

## 1.34.1 (2023-12-08)

Full Changelog: [v1.34.0...v1.34.1](https://github.com/orbcorp/orb-python/compare/v1.34.0...v1.34.1)

### Bug Fixes

* avoid leaking memory when Client.with_options is used ([#97](https://github.com/orbcorp/orb-python/issues/97)) ([b65cdf2](https://github.com/orbcorp/orb-python/commit/b65cdf2017fa80622e879ad6c4c700cbe04fb329))

## 1.34.0 (2023-12-08)

Full Changelog: [v1.33.4...v1.34.0](https://github.com/orbcorp/orb-python/compare/v1.33.4...v1.34.0)

### Features

* **api:** remove unsupported field ([#95](https://github.com/orbcorp/orb-python/issues/95)) ([fbb9a6a](https://github.com/orbcorp/orb-python/commit/fbb9a6ad26b452fbf8985007f770ed2c903e3b66))

## 1.33.4 (2023-12-08)

Full Changelog: [v1.33.3...v1.33.4](https://github.com/orbcorp/orb-python/compare/v1.33.3...v1.33.4)

### Bug Fixes

* **errors:** properly assign APIError.body ([#94](https://github.com/orbcorp/orb-python/issues/94)) ([7ee4eea](https://github.com/orbcorp/orb-python/commit/7ee4eea7f164e0b0685149d1591571c6c9566d77))


### Chores

* **internal:** enable more lint rules ([#93](https://github.com/orbcorp/orb-python/issues/93)) ([a3dd337](https://github.com/orbcorp/orb-python/commit/a3dd3377f5246ba6d1302224981a45c9c3a9121d))
* **internal:** minor updates to pagination ([#91](https://github.com/orbcorp/orb-python/issues/91)) ([cc341f4](https://github.com/orbcorp/orb-python/commit/cc341f40366a81e9f1db9bd4ad049d2228cc15b5))
* **internal:** reformat imports ([#89](https://github.com/orbcorp/orb-python/issues/89)) ([26a17d4](https://github.com/orbcorp/orb-python/commit/26a17d4cd116a58ce16657bc8e189bbd4dda775a))
* **internal:** reformat imports ([#92](https://github.com/orbcorp/orb-python/issues/92)) ([55b46bb](https://github.com/orbcorp/orb-python/commit/55b46bb375aee8a00d79177bad06c907d854b1fa))
* **internal:** update formatting ([#90](https://github.com/orbcorp/orb-python/issues/90)) ([ce98611](https://github.com/orbcorp/orb-python/commit/ce98611dd7fe75931d01f7119244388c51224a74))

## 1.33.3 (2023-12-04)

Full Changelog: [v1.33.2...v1.33.3](https://github.com/orbcorp/orb-python/compare/v1.33.2...v1.33.3)

### Chores

* **package:** lift anyio v4 restriction ([#84](https://github.com/orbcorp/orb-python/issues/84)) ([70cbb10](https://github.com/orbcorp/orb-python/commit/70cbb104fe927cebfa5e3d42a3c29f0ed4ab19ab))

## 1.33.2 (2023-12-01)

Full Changelog: [v1.33.1...v1.33.2](https://github.com/orbcorp/orb-python/compare/v1.33.1...v1.33.2)

### Bug Fixes

* **client:** correct base_url setter implementation ([#83](https://github.com/orbcorp/orb-python/issues/83)) ([83ad98c](https://github.com/orbcorp/orb-python/commit/83ad98c68e6103792d0e9739db105c82ae44f6f4))


### Chores

* **internal:** remove unused type var ([#82](https://github.com/orbcorp/orb-python/issues/82)) ([a9a3dbe](https://github.com/orbcorp/orb-python/commit/a9a3dbe325cbc0b3621469208871a616abe3979b))
* **internal:** replace string concatenation with f-strings ([#81](https://github.com/orbcorp/orb-python/issues/81)) ([d290faf](https://github.com/orbcorp/orb-python/commit/d290faf226356c4968bca7308306ae02e6bcb600))


### Documentation

* **readme:** update example snippets ([#79](https://github.com/orbcorp/orb-python/issues/79)) ([da58b27](https://github.com/orbcorp/orb-python/commit/da58b276e4c352f5f1bacb03455277f33f872243))

## 1.33.1 (2023-11-30)

Full Changelog: [v1.33.0...v1.33.1](https://github.com/orbcorp/orb-python/compare/v1.33.0...v1.33.1)

### Bug Fixes

* **client:** ensure retried requests are closed ([#78](https://github.com/orbcorp/orb-python/issues/78)) ([af69dbb](https://github.com/orbcorp/orb-python/commit/af69dbbf926375b4383badf61b22471ccca48661))


### Chores

* **internal:** add tests for proxy change ([#77](https://github.com/orbcorp/orb-python/issues/77)) ([3d80ca9](https://github.com/orbcorp/orb-python/commit/3d80ca9ba3dcadafe21c2066b7e605c27771edf9))
* **internal:** update lock file ([#74](https://github.com/orbcorp/orb-python/issues/74)) ([d3c1761](https://github.com/orbcorp/orb-python/commit/d3c1761a169d423394d0ae6a7f30a0549d344029))
* **internal:** updates to proxy helper ([#76](https://github.com/orbcorp/orb-python/issues/76)) ([80e0f3d](https://github.com/orbcorp/orb-python/commit/80e0f3dc784b29adc1b32005f5bfc75f51fff2e3))

## 1.33.0 (2023-11-28)

Full Changelog: [v1.32.0...v1.33.0](https://github.com/orbcorp/orb-python/compare/v1.32.0...v1.33.0)

### Features

* **api:** updates ([#73](https://github.com/orbcorp/orb-python/issues/73)) ([1e4d614](https://github.com/orbcorp/orb-python/commit/1e4d6148fcb859c095fd46e21841aff004475430))


### Chores

* **deps:** bump mypy to v1.7.1 ([#72](https://github.com/orbcorp/orb-python/issues/72)) ([e7f7b47](https://github.com/orbcorp/orb-python/commit/e7f7b47e99c4e1ae73c09de6c83d8879e0172bae))
* **internal:** options updates ([#67](https://github.com/orbcorp/orb-python/issues/67)) ([8f91e55](https://github.com/orbcorp/orb-python/commit/8f91e55e750372c77dfd98202cd445560343e747))
* **internal:** revert recent options change ([#70](https://github.com/orbcorp/orb-python/issues/70)) ([6ff55a6](https://github.com/orbcorp/orb-python/commit/6ff55a6bff7f7281b6288cb7a3042fd51e3a29f0))
* **internal:** send more detailed x-stainless headers ([#71](https://github.com/orbcorp/orb-python/issues/71)) ([7dd46f3](https://github.com/orbcorp/orb-python/commit/7dd46f3ed8ba12999cbb3376b48f01c12f7e80e3))


### Documentation

* **api:** update metadata docstrings ([#69](https://github.com/orbcorp/orb-python/issues/69)) ([cf25b7c](https://github.com/orbcorp/orb-python/commit/cf25b7c8280a5dae5796fc5506db794ccba3b425))

## 1.32.0 (2023-11-22)

Full Changelog: [v1.31.2...v1.32.0](https://github.com/orbcorp/orb-python/compare/v1.31.2...v1.32.0)

### Features

* **api:** updates ([#66](https://github.com/orbcorp/orb-python/issues/66)) ([cfefc76](https://github.com/orbcorp/orb-python/commit/cfefc763c7d1e08e280b076ee5c88274ab42c1a4))


### Chores

* **client:** improve copy method ([#63](https://github.com/orbcorp/orb-python/issues/63)) ([ae3eed5](https://github.com/orbcorp/orb-python/commit/ae3eed56e988ff66e793116c8a0c80c5b5d87869))
* **package:** add license classifier metadata ([#65](https://github.com/orbcorp/orb-python/issues/65)) ([da28530](https://github.com/orbcorp/orb-python/commit/da28530b636f74e64a343957437daaeb80da49ef))

## 1.31.2 (2023-11-21)

Full Changelog: [v1.31.1...v1.31.2](https://github.com/orbcorp/orb-python/compare/v1.31.1...v1.31.2)

### Bug Fixes

* **client:** attempt to parse unknown json content types ([#61](https://github.com/orbcorp/orb-python/issues/61)) ([2ff1f69](https://github.com/orbcorp/orb-python/commit/2ff1f69a8a7b6a138002cf8eef49d76e71a6bb2e))

## 1.31.1 (2023-11-20)

Full Changelog: [v1.31.0...v1.31.1](https://github.com/orbcorp/orb-python/compare/v1.31.0...v1.31.1)

### Chores

* **internal:** update some test values ([#60](https://github.com/orbcorp/orb-python/issues/60)) ([cf1e4a9](https://github.com/orbcorp/orb-python/commit/cf1e4a9a241eb6fdd66f42f05f5dbaa2c3fec2ed))
* **internal:** update type hint for helper function ([#59](https://github.com/orbcorp/orb-python/issues/59)) ([191e197](https://github.com/orbcorp/orb-python/commit/191e19734a80480dfaa4ea614baef2d565264bea))


### Documentation

* **readme:** fix link to docs website ([#58](https://github.com/orbcorp/orb-python/issues/58)) ([4510e87](https://github.com/orbcorp/orb-python/commit/4510e8728e7282b16c9e91ca97b74106681b0666))
* **readme:** minor updates ([#56](https://github.com/orbcorp/orb-python/issues/56)) ([0d09713](https://github.com/orbcorp/orb-python/commit/0d097132f1884d193e8fee9a781c29d8afe25f32))

## 1.31.0 (2023-11-16)

Full Changelog: [v1.30.3...v1.31.0](https://github.com/orbcorp/orb-python/compare/v1.30.3...v1.31.0)

### Features

* **api:** updates ([#55](https://github.com/orbcorp/orb-python/issues/55)) ([dbfb455](https://github.com/orbcorp/orb-python/commit/dbfb455e7019597b33f723b9d5682e378489eb2d))
* **client:** support reading the base url from an env variable ([#54](https://github.com/orbcorp/orb-python/issues/54)) ([04d5ca5](https://github.com/orbcorp/orb-python/commit/04d5ca523c38a36e72c42587e323a55b7a9d09a4))


### Chores

* **internal:** fix devcontainer interpeter path ([#52](https://github.com/orbcorp/orb-python/issues/52)) ([a35fe95](https://github.com/orbcorp/orb-python/commit/a35fe959fe9bbe9a4ecd4a50148c4c5d447643b6))
* **internal:** fix typo in NotGiven docstring ([#50](https://github.com/orbcorp/orb-python/issues/50)) ([7e1d704](https://github.com/orbcorp/orb-python/commit/7e1d704c9a4baebf09bb9b95d4e0baf5e2c9809e))


### Documentation

* fix code comment typo ([#53](https://github.com/orbcorp/orb-python/issues/53)) ([0171b18](https://github.com/orbcorp/orb-python/commit/0171b183ee377d4c1aaa9dab7d0c4faaa1b1c1f9))

## 1.30.3 (2023-11-13)

Full Changelog: [v1.30.2...v1.30.3](https://github.com/orbcorp/orb-python/compare/v1.30.2...v1.30.3)

### Bug Fixes

* **client:** retry if SSLWantReadError occurs in the async client ([#48](https://github.com/orbcorp/orb-python/issues/48)) ([52d5c13](https://github.com/orbcorp/orb-python/commit/52d5c134035252e12290930ffc7797f3e386f7cc))

## 1.30.2 (2023-11-10)

Full Changelog: [v1.30.1...v1.30.2](https://github.com/orbcorp/orb-python/compare/v1.30.1...v1.30.2)

### Bug Fixes

* **client:** serialise pydantic v1 default fields correctly in params ([#46](https://github.com/orbcorp/orb-python/issues/46)) ([dc058e3](https://github.com/orbcorp/orb-python/commit/dc058e30be77833522880b651a7eed16b23bc7c3))

## 1.30.1 (2023-11-10)

Full Changelog: [v1.30.0...v1.30.1](https://github.com/orbcorp/orb-python/compare/v1.30.0...v1.30.1)

### Bug Fixes

* **models:** mark unknown fields as set in pydantic v1 ([#45](https://github.com/orbcorp/orb-python/issues/45)) ([c965317](https://github.com/orbcorp/orb-python/commit/c9653177220c301b99b95455a58c0cdd9088091e))


### Chores

* **internal:** base client updates ([#44](https://github.com/orbcorp/orb-python/issues/44)) ([79ff165](https://github.com/orbcorp/orb-python/commit/79ff1652c90c689452ed7e2ce264f72ae9c1bfe5))


### Documentation

* reword package description ([#42](https://github.com/orbcorp/orb-python/issues/42)) ([6994f49](https://github.com/orbcorp/orb-python/commit/6994f492fe7c0e890017bf0275990cc5a0ae147e))

## 1.30.0 (2023-11-09)

Full Changelog: [v1.29.0...v1.30.0](https://github.com/orbcorp/orb-python/compare/v1.29.0...v1.30.0)

### Features

* **api:** updates ([#41](https://github.com/orbcorp/orb-python/issues/41)) ([ea5d1a4](https://github.com/orbcorp/orb-python/commit/ea5d1a460b0c2ee26ed2844b3f19cbc65762b922))
* **client:** support passing chunk size for binary responses ([#40](https://github.com/orbcorp/orb-python/issues/40)) ([6cc1be0](https://github.com/orbcorp/orb-python/commit/6cc1be01b788208d963cd8c4a300ca8c8649420d))
* **client:** support passing httpx.Timeout to method timeout argument ([#35](https://github.com/orbcorp/orb-python/issues/35)) ([65c7fc9](https://github.com/orbcorp/orb-python/commit/65c7fc93f25d8d651f6dcb0472a98695d6d4acb6))


### Chores

* **docs:** fix github links ([#38](https://github.com/orbcorp/orb-python/issues/38)) ([2a83f73](https://github.com/orbcorp/orb-python/commit/2a83f73006fb0edbc063360b90bad706375ca318))
* **internal:** fix some typos ([#37](https://github.com/orbcorp/orb-python/issues/37)) ([b0fc909](https://github.com/orbcorp/orb-python/commit/b0fc909f70c539d529b1eeb24aa4aa9683999dbd))
* **internal:** improve github devcontainer setup ([#39](https://github.com/orbcorp/orb-python/issues/39)) ([3fabb8f](https://github.com/orbcorp/orb-python/commit/3fabb8f4bc47f418b7d4ec7833048589802298db))

## 1.29.0 (2023-11-06)

Full Changelog: [v1.28.1...v1.29.0](https://github.com/orbcorp/orb-python/compare/v1.28.1...v1.29.0)

### Features

* **api:** remove unsupported params ([#33](https://github.com/orbcorp/orb-python/issues/33)) ([abd325f](https://github.com/orbcorp/orb-python/commit/abd325f78c1d58c30207bf69ba36b32229626fac))

## 1.28.1 (2023-11-06)

Full Changelog: [v1.28.0...v1.28.1](https://github.com/orbcorp/orb-python/compare/v1.28.0...v1.28.1)

### Bug Fixes

* prevent TypeError in Python 3.8 (ABC is not subscriptable) ([#32](https://github.com/orbcorp/orb-python/issues/32)) ([f21abfa](https://github.com/orbcorp/orb-python/commit/f21abfae14e1897cd501e09a1dc3051e5c7e54ec))


### Chores

* **internal:** remove unused int/float conversion ([#29](https://github.com/orbcorp/orb-python/issues/29)) ([0b701e1](https://github.com/orbcorp/orb-python/commit/0b701e1812c7293fd313f759944e400e202eab69))


### Documentation

* **readme:** improve example snippets ([#31](https://github.com/orbcorp/orb-python/issues/31)) ([3815aad](https://github.com/orbcorp/orb-python/commit/3815aad75faa9ce55a499eaabb04c3c3f15b1701))

## 1.28.0 (2023-11-03)

Full Changelog: [v1.27.0...v1.28.0](https://github.com/orbcorp/orb-python/compare/v1.27.0...v1.28.0)

### Features

* **api:** updates ([#13](https://github.com/orbcorp/orb-python/issues/13)) ([4256067](https://github.com/orbcorp/orb-python/commit/42560678cd0b5bdfeafb5f3940aa06e6266fc193))
* **api:** updates ([#8](https://github.com/orbcorp/orb-python/issues/8)) ([c9c4a66](https://github.com/orbcorp/orb-python/commit/c9c4a664b617f2e6749ccecdd83580adf3ff8a33))
* **client:** adjust retry behavior to be exponential backoff ([#4](https://github.com/orbcorp/orb-python/issues/4)) ([62c25f6](https://github.com/orbcorp/orb-python/commit/62c25f6cf9456cb3ea26a79272417e79b366603c))
* **client:** allow binary returns ([#26](https://github.com/orbcorp/orb-python/issues/26)) ([9a25d2f](https://github.com/orbcorp/orb-python/commit/9a25d2f07d4fd5b18ab2702240a4c470c680715d))
* **client:** improve file upload types ([#3](https://github.com/orbcorp/orb-python/issues/3)) ([91b3d5c](https://github.com/orbcorp/orb-python/commit/91b3d5c4b383f2ccc1fad7209ad834aeeecaf96e))
* **client:** improve retry behaviour ([#6](https://github.com/orbcorp/orb-python/issues/6)) ([04d94d2](https://github.com/orbcorp/orb-python/commit/04d94d22b7ad214ba748f0a1722b67d5b756e5c8))
* **client:** support passing BaseModels to request params at runtime ([#27](https://github.com/orbcorp/orb-python/issues/27)) ([e8d0844](https://github.com/orbcorp/orb-python/commit/e8d08448ab25e34955f3ae5ca2501565cbe2d192))
* **github:** include a devcontainer setup ([#25](https://github.com/orbcorp/orb-python/issues/25)) ([fc96155](https://github.com/orbcorp/orb-python/commit/fc961559403ad78cb144c348635afbf00410640d))
* **package:** add classifiers ([#16](https://github.com/orbcorp/orb-python/issues/16)) ([fa652f3](https://github.com/orbcorp/orb-python/commit/fa652f3a4b68afb1204c4f6c0f74b00b39f1b9af))


### Bug Fixes

* **binaries:** don't synchronously block in astream_to_file ([#28](https://github.com/orbcorp/orb-python/issues/28)) ([ad6ebef](https://github.com/orbcorp/orb-python/commit/ad6ebefccc8e1cb178b0cc394103ff646a130d72))
* **client:** include more detail in error messages ([#12](https://github.com/orbcorp/orb-python/issues/12)) ([7b64c85](https://github.com/orbcorp/orb-python/commit/7b64c851f6825ec8d2e2f8fcc6174f88f3676d59))
* rename customer.credits.ledger.create_entry_by_exteral_id and RequestValidationErrors ([#9](https://github.com/orbcorp/orb-python/issues/9)) ([bd8dbe9](https://github.com/orbcorp/orb-python/commit/bd8dbe9335a24ff0830d7dad90676fa1d55202d0))


### Chores

* **internal:** minor restructuring of base client ([#15](https://github.com/orbcorp/orb-python/issues/15)) ([550d18c](https://github.com/orbcorp/orb-python/commit/550d18c72e0eb2c06dc83329f07d207a6cf2b0de))
* **internal:** require explicit overrides ([#11](https://github.com/orbcorp/orb-python/issues/11)) ([4dab0a6](https://github.com/orbcorp/orb-python/commit/4dab0a6da2d4992046c6a125b460bd21fb26cd10))


### Documentation

* improve to dictionary example ([#7](https://github.com/orbcorp/orb-python/issues/7)) ([3dac2fd](https://github.com/orbcorp/orb-python/commit/3dac2fd2595e1e2b62f85f284daa4c519998942d))

## 1.27.0 (2023-10-20)

Full Changelog: [v1.26.0...v1.27.0](https://github.com/orbcorp/orb-python/compare/v1.26.0...v1.27.0)

### Features

* **init:** initial commit ([33d4af6](https://github.com/orbcorp/orb-python/commit/33d4af66059edfeffd6b39f058867d1babfd8fa9))


### Chores

* correct version ([58bb98d](https://github.com/orbcorp/orb-python/commit/58bb98df611c05e4b89fb5c2e4a1d7a99dbb312e))


### Documentation

* improve code examples ([927512a](https://github.com/orbcorp/orb-python/commit/927512a8d90168348136c312527b816344ec3a88))
