# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourceArgs', 'MonitoredResource']

@pulumi.input_type
class MonitoredResourceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]] = None,
                 aliases: Optional[pulumi.Input['MonitoredResourceAliasesArgs']] = None,
                 credentials: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']] = None,
                 database_connection_details: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 external_resource_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 license: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]] = None,
                 resource_time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MonitoredResource resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input['MonitoredResourceAliasesArgs'] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input['MonitoredResourceCredentialsArgs'] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs'] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if additional_aliases is not None:
            pulumi.set(__self__, "additional_aliases", additional_aliases)
        if additional_credentials is not None:
            pulumi.set(__self__, "additional_credentials", additional_credentials)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_connection_details is not None:
            pulumi.set(__self__, "database_connection_details", database_connection_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_resource_id is not None:
            pulumi.set(__self__, "external_resource_id", external_resource_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_time_zone is not None:
            pulumi.set(__self__, "resource_time_zone", resource_time_zone)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="additionalAliases")
    def additional_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]:
        """
        (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        """
        return pulumi.get(self, "additional_aliases")

    @additional_aliases.setter
    def additional_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]):
        pulumi.set(self, "additional_aliases", value)

    @property
    @pulumi.getter(name="additionalCredentials")
    def additional_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]:
        """
        (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        """
        return pulumi.get(self, "additional_credentials")

    @additional_credentials.setter
    def additional_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]):
        pulumi.set(self, "additional_credentials", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input['MonitoredResourceAliasesArgs']]:
        """
        (Updatable) Monitored Resource Alias Credential Details
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input['MonitoredResourceAliasesArgs']]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]:
        """
        (Updatable) Monitored Resource Credential Details.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="databaseConnectionDetails")
    def database_connection_details(self) -> Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]:
        """
        (Updatable) Connection details for the database.
        """
        return pulumi.get(self, "database_connection_details")

    @database_connection_details.setter
    def database_connection_details(self, value: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]):
        pulumi.set(self, "database_connection_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="externalResourceId")
    def external_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        """
        return pulumi.get(self, "external_resource_id")

    @external_resource_id.setter
    def external_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_resource_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Host name of the monitored resource.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @resource_time_zone.setter
    def resource_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_time_zone", value)


@pulumi.input_type
class _MonitoredResourceState:
    def __init__(__self__, *,
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]] = None,
                 aliases: Optional[pulumi.Input['MonitoredResourceAliasesArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']] = None,
                 database_connection_details: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 external_resource_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 license: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]] = None,
                 resource_category: Optional[pulumi.Input[str]] = None,
                 resource_time_zone: Optional[pulumi.Input[str]] = None,
                 source_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MonitoredResource resources.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input['MonitoredResourceAliasesArgs'] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input['MonitoredResourceCredentialsArgs'] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs'] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[str] resource_category: Resource Category to indicate the kind of resource type.
        :param pulumi.Input[str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[str] source_type: Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        :param pulumi.Input[str] state: Lifecycle state of the monitored resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] tenant_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] time_created: The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[str] time_updated: The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if additional_aliases is not None:
            pulumi.set(__self__, "additional_aliases", additional_aliases)
        if additional_credentials is not None:
            pulumi.set(__self__, "additional_credentials", additional_credentials)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_connection_details is not None:
            pulumi.set(__self__, "database_connection_details", database_connection_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_resource_id is not None:
            pulumi.set(__self__, "external_resource_id", external_resource_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_category is not None:
            pulumi.set(__self__, "resource_category", resource_category)
        if resource_time_zone is not None:
            pulumi.set(__self__, "resource_time_zone", resource_time_zone)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="additionalAliases")
    def additional_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]:
        """
        (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        """
        return pulumi.get(self, "additional_aliases")

    @additional_aliases.setter
    def additional_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]):
        pulumi.set(self, "additional_aliases", value)

    @property
    @pulumi.getter(name="additionalCredentials")
    def additional_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]:
        """
        (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        """
        return pulumi.get(self, "additional_credentials")

    @additional_credentials.setter
    def additional_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]):
        pulumi.set(self, "additional_credentials", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input['MonitoredResourceAliasesArgs']]:
        """
        (Updatable) Monitored Resource Alias Credential Details
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input['MonitoredResourceAliasesArgs']]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]:
        """
        (Updatable) Monitored Resource Credential Details.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="databaseConnectionDetails")
    def database_connection_details(self) -> Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]:
        """
        (Updatable) Connection details for the database.
        """
        return pulumi.get(self, "database_connection_details")

    @database_connection_details.setter
    def database_connection_details(self, value: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]):
        pulumi.set(self, "database_connection_details", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="externalResourceId")
    def external_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        """
        return pulumi.get(self, "external_resource_id")

    @external_resource_id.setter
    def external_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_resource_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Host name of the monitored resource.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> Optional[pulumi.Input[str]]:
        """
        Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @resource_category.setter
    def resource_category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_category", value)

    @property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @resource_time_zone.setter
    def resource_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_time_zone", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[str]]:
        """
        Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Lifecycle state of the monitored resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class MonitoredResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalAliasArgs']]]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalCredentialArgs']]]]] = None,
                 aliases: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceAliasesArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceCredentialsArgs']]] = None,
                 database_connection_details: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceDatabaseConnectionDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 external_resource_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 license: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourcePropertyArgs']]]]] = None,
                 resource_time_zone: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Monitored Resource resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitored resource for the given resource type with the details and submits
        a work request for promoting the resource to agent. Once the resource is successfully
        added to agent, resource state will be marked active.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource = oci.stack_monitoring.MonitoredResource("test_monitored_resource",
            compartment_id=compartment_id,
            name=monitored_resource_name,
            type=monitored_resource_type,
            additional_aliases=[oci.stack_monitoring.MonitoredResourceAdditionalAliasArgs(
                credential=oci.stack_monitoring.MonitoredResourceAdditionalAliasCredentialArgs(
                    name=monitored_resource_additional_aliases_credential_name,
                    service=monitored_resource_additional_aliases_credential_service,
                    source=monitored_resource_additional_aliases_credential_source,
                ),
                name=monitored_resource_additional_aliases_name,
                source=monitored_resource_additional_aliases_source,
            )],
            additional_credentials=[oci.stack_monitoring.MonitoredResourceAdditionalCredentialArgs(
                credential_type=monitored_resource_additional_credentials_credential_type,
                description=monitored_resource_additional_credentials_description,
                key_id=test_key["id"],
                name=monitored_resource_additional_credentials_name,
                properties=[oci.stack_monitoring.MonitoredResourceAdditionalCredentialPropertyArgs(
                    name=monitored_resource_additional_credentials_properties_name,
                    value=monitored_resource_additional_credentials_properties_value,
                )],
                source=monitored_resource_additional_credentials_source,
                type=monitored_resource_additional_credentials_type,
            )],
            aliases=oci.stack_monitoring.MonitoredResourceAliasesArgs(
                credential=oci.stack_monitoring.MonitoredResourceAliasesCredentialArgs(
                    name=monitored_resource_aliases_credential_name,
                    service=monitored_resource_aliases_credential_service,
                    source=monitored_resource_aliases_credential_source,
                ),
                name=monitored_resource_aliases_name,
                source=monitored_resource_aliases_source,
            ),
            credentials=oci.stack_monitoring.MonitoredResourceCredentialsArgs(
                credential_type=monitored_resource_credentials_credential_type,
                description=monitored_resource_credentials_description,
                key_id=monitored_resource_credentials_key_id,
                name=monitored_resource_credentials_name,
                properties=[oci.stack_monitoring.MonitoredResourceCredentialsPropertyArgs(
                    name=monitored_resource_credentials_properties_name,
                    value=monitored_resource_credentials_properties_value,
                )],
                source=monitored_resource_credentials_source,
                type=monitored_resource_credentials_type,
            ),
            database_connection_details=oci.stack_monitoring.MonitoredResourceDatabaseConnectionDetailsArgs(
                port=monitored_resource_database_connection_details_port,
                protocol=monitored_resource_database_connection_details_protocol,
                service_name=monitored_resource_database_service_name,
                connector_id=monitored_resource_database_connector_id,
                db_id=monitored_resource_database_id,
                db_unique_name=monitored_resource_database_connection_details_db_unique_name,
                ssl_secret_id=test_secret["id"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=monitored_resource_display_name,
            external_resource_id=monitored_resource_external_resource_id,
            external_id=test_external["id"],
            freeform_tags={
                "bar-key": "value",
            },
            host_name=monitored_resource_host_name,
            license=monitored_resource_license,
            management_agent_id=test_management_agent["id"],
            properties=[oci.stack_monitoring.MonitoredResourcePropertyArgs(
                name=monitored_resource_properties_name,
                value=monitored_resource_properties_value,
            )],
            resource_time_zone=monitored_resource_resource_time_zone)
        ```

        ## Import

        MonitoredResources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResource:MonitoredResource test_monitored_resource "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalAliasArgs']]]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalCredentialArgs']]]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input[pulumi.InputType['MonitoredResourceAliasesArgs']] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[pulumi.InputType['MonitoredResourceCredentialsArgs']] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input[pulumi.InputType['MonitoredResourceDatabaseConnectionDetailsArgs']] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourcePropertyArgs']]]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitored Resource resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitored resource for the given resource type with the details and submits
        a work request for promoting the resource to agent. Once the resource is successfully
        added to agent, resource state will be marked active.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource = oci.stack_monitoring.MonitoredResource("test_monitored_resource",
            compartment_id=compartment_id,
            name=monitored_resource_name,
            type=monitored_resource_type,
            additional_aliases=[oci.stack_monitoring.MonitoredResourceAdditionalAliasArgs(
                credential=oci.stack_monitoring.MonitoredResourceAdditionalAliasCredentialArgs(
                    name=monitored_resource_additional_aliases_credential_name,
                    service=monitored_resource_additional_aliases_credential_service,
                    source=monitored_resource_additional_aliases_credential_source,
                ),
                name=monitored_resource_additional_aliases_name,
                source=monitored_resource_additional_aliases_source,
            )],
            additional_credentials=[oci.stack_monitoring.MonitoredResourceAdditionalCredentialArgs(
                credential_type=monitored_resource_additional_credentials_credential_type,
                description=monitored_resource_additional_credentials_description,
                key_id=test_key["id"],
                name=monitored_resource_additional_credentials_name,
                properties=[oci.stack_monitoring.MonitoredResourceAdditionalCredentialPropertyArgs(
                    name=monitored_resource_additional_credentials_properties_name,
                    value=monitored_resource_additional_credentials_properties_value,
                )],
                source=monitored_resource_additional_credentials_source,
                type=monitored_resource_additional_credentials_type,
            )],
            aliases=oci.stack_monitoring.MonitoredResourceAliasesArgs(
                credential=oci.stack_monitoring.MonitoredResourceAliasesCredentialArgs(
                    name=monitored_resource_aliases_credential_name,
                    service=monitored_resource_aliases_credential_service,
                    source=monitored_resource_aliases_credential_source,
                ),
                name=monitored_resource_aliases_name,
                source=monitored_resource_aliases_source,
            ),
            credentials=oci.stack_monitoring.MonitoredResourceCredentialsArgs(
                credential_type=monitored_resource_credentials_credential_type,
                description=monitored_resource_credentials_description,
                key_id=monitored_resource_credentials_key_id,
                name=monitored_resource_credentials_name,
                properties=[oci.stack_monitoring.MonitoredResourceCredentialsPropertyArgs(
                    name=monitored_resource_credentials_properties_name,
                    value=monitored_resource_credentials_properties_value,
                )],
                source=monitored_resource_credentials_source,
                type=monitored_resource_credentials_type,
            ),
            database_connection_details=oci.stack_monitoring.MonitoredResourceDatabaseConnectionDetailsArgs(
                port=monitored_resource_database_connection_details_port,
                protocol=monitored_resource_database_connection_details_protocol,
                service_name=monitored_resource_database_service_name,
                connector_id=monitored_resource_database_connector_id,
                db_id=monitored_resource_database_id,
                db_unique_name=monitored_resource_database_connection_details_db_unique_name,
                ssl_secret_id=test_secret["id"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=monitored_resource_display_name,
            external_resource_id=monitored_resource_external_resource_id,
            external_id=test_external["id"],
            freeform_tags={
                "bar-key": "value",
            },
            host_name=monitored_resource_host_name,
            license=monitored_resource_license,
            management_agent_id=test_management_agent["id"],
            properties=[oci.stack_monitoring.MonitoredResourcePropertyArgs(
                name=monitored_resource_properties_name,
                value=monitored_resource_properties_value,
            )],
            resource_time_zone=monitored_resource_resource_time_zone)
        ```

        ## Import

        MonitoredResources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResource:MonitoredResource test_monitored_resource "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalAliasArgs']]]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalCredentialArgs']]]]] = None,
                 aliases: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceAliasesArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceCredentialsArgs']]] = None,
                 database_connection_details: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceDatabaseConnectionDetailsArgs']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 external_resource_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 license: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourcePropertyArgs']]]]] = None,
                 resource_time_zone: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourceArgs.__new__(MonitoredResourceArgs)

            __props__.__dict__["additional_aliases"] = additional_aliases
            __props__.__dict__["additional_credentials"] = additional_credentials
            __props__.__dict__["aliases"] = aliases
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["database_connection_details"] = database_connection_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["external_resource_id"] = external_resource_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["license"] = license
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["name"] = name
            __props__.__dict__["properties"] = properties
            __props__.__dict__["resource_time_zone"] = resource_time_zone
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["resource_category"] = None
            __props__.__dict__["source_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MonitoredResource, __self__).__init__(
            'oci:StackMonitoring/monitoredResource:MonitoredResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalAliasArgs']]]]] = None,
            additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalCredentialArgs']]]]] = None,
            aliases: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceAliasesArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            credentials: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceCredentialsArgs']]] = None,
            database_connection_details: Optional[pulumi.Input[pulumi.InputType['MonitoredResourceDatabaseConnectionDetailsArgs']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            external_resource_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            host_name: Optional[pulumi.Input[str]] = None,
            license: Optional[pulumi.Input[str]] = None,
            management_agent_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourcePropertyArgs']]]]] = None,
            resource_category: Optional[pulumi.Input[str]] = None,
            resource_time_zone: Optional[pulumi.Input[str]] = None,
            source_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'MonitoredResource':
        """
        Get an existing MonitoredResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalAliasArgs']]]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourceAdditionalCredentialArgs']]]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input[pulumi.InputType['MonitoredResourceAliasesArgs']] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[pulumi.InputType['MonitoredResourceCredentialsArgs']] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input[pulumi.InputType['MonitoredResourceDatabaseConnectionDetailsArgs']] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MonitoredResourcePropertyArgs']]]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[str] resource_category: Resource Category to indicate the kind of resource type.
        :param pulumi.Input[str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[str] source_type: Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        :param pulumi.Input[str] state: Lifecycle state of the monitored resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] tenant_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] time_created: The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[str] time_updated: The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourceState.__new__(_MonitoredResourceState)

        __props__.__dict__["additional_aliases"] = additional_aliases
        __props__.__dict__["additional_credentials"] = additional_credentials
        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["database_connection_details"] = database_connection_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["external_resource_id"] = external_resource_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["license"] = license
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["resource_category"] = resource_category
        __props__.__dict__["resource_time_zone"] = resource_time_zone
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return MonitoredResource(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalAliases")
    def additional_aliases(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoredResourceAdditionalAlias']]]:
        """
        (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        """
        return pulumi.get(self, "additional_aliases")

    @property
    @pulumi.getter(name="additionalCredentials")
    def additional_credentials(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoredResourceAdditionalCredential']]]:
        """
        (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        """
        return pulumi.get(self, "additional_credentials")

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional['outputs.MonitoredResourceAliases']]:
        """
        (Updatable) Monitored Resource Alias Credential Details
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.MonitoredResourceCredentials']]:
        """
        (Updatable) Monitored Resource Credential Details.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="databaseConnectionDetails")
    def database_connection_details(self) -> pulumi.Output[Optional['outputs.MonitoredResourceDatabaseConnectionDetails']]:
        """
        (Updatable) Connection details for the database.
        """
        return pulumi.get(self, "database_connection_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="externalResourceId")
    def external_resource_id(self) -> pulumi.Output[Optional[str]]:
        """
        Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        """
        return pulumi.get(self, "external_resource_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) Host name of the monitored resource.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter
    def license(self) -> pulumi.Output[str]:
        """
        (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        """
        return pulumi.get(self, "license")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[Optional[str]]:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoredResourceProperty']]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> pulumi.Output[str]:
        """
        Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[str]:
        """
        Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Lifecycle state of the monitored resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

