# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ModelArgs', 'Model']

@pulumi.input_type
class ModelArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 model_type: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[float]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input['ModelTestingDatasetArgs']] = None,
                 training_dataset: Optional[pulumi.Input['ModelTrainingDatasetArgs']] = None,
                 validation_dataset: Optional[pulumi.Input['ModelValidationDatasetArgs']] = None):
        """
        The set of arguments for constructing a Model resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[str] model_type: The type of the Document model.
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[str] model_version: The model version
        :param pulumi.Input['ModelTestingDatasetArgs'] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input['ModelValidationDatasetArgs'] validation_dataset: The base entity which is the input for creating and training a model.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "model_type", model_type)
        pulumi.set(__self__, "project_id", project_id)
        if component_models is not None:
            pulumi.set(__self__, "component_models", component_models)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_quick_mode is not None:
            pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        if max_training_time_in_hours is not None:
            pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if testing_dataset is not None:
            pulumi.set(__self__, "testing_dataset", testing_dataset)
        if training_dataset is not None:
            pulumi.set(__self__, "training_dataset", training_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Input[str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @component_models.setter
    def component_models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]):
        pulumi.set(self, "component_models", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A human-friendly name for the model, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @is_quick_mode.setter
    def is_quick_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_quick_mode", value)

    @property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @max_training_time_in_hours.setter
    def max_training_time_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_training_time_in_hours", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        The model version
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> Optional[pulumi.Input['ModelTestingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: Optional[pulumi.Input['ModelTestingDatasetArgs']]):
        pulumi.set(self, "testing_dataset", value)

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> Optional[pulumi.Input['ModelTrainingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: Optional[pulumi.Input['ModelTrainingDatasetArgs']]):
        pulumi.set(self, "training_dataset", value)

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelValidationDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


@pulumi.input_type
class _ModelState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_composed_model: Optional[pulumi.Input[bool]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[float]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 tenancy_id: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input['ModelTestingDatasetArgs']] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 trained_time_in_hours: Optional[pulumi.Input[float]] = None,
                 training_dataset: Optional[pulumi.Input['ModelTrainingDatasetArgs']] = None,
                 validation_dataset: Optional[pulumi.Input['ModelValidationDatasetArgs']] = None):
        """
        Input properties used for looking up and filtering Model resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param pulumi.Input[bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The collection of labels used to train the custom model.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param pulumi.Input[float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]] metrics: Trained Model Metrics.
        :param pulumi.Input[str] model_type: The type of the Document model.
        :param pulumi.Input[str] model_version: The model version
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[str] state: The current state of the model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param pulumi.Input[str] tenancy_id: The tenancy id of the model.
        :param pulumi.Input['ModelTestingDatasetArgs'] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[str] time_created: When the model was created, as an RFC3339 datetime string.
        :param pulumi.Input[str] time_updated: When the model was updated, as an RFC3339 datetime string.
        :param pulumi.Input[float] trained_time_in_hours: The total hours actually used for model training.
        :param pulumi.Input['ModelTrainingDatasetArgs'] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input['ModelValidationDatasetArgs'] validation_dataset: The base entity which is the input for creating and training a model.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if component_models is not None:
            pulumi.set(__self__, "component_models", component_models)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_composed_model is not None:
            pulumi.set(__self__, "is_composed_model", is_composed_model)
        if is_quick_mode is not None:
            pulumi.set(__self__, "is_quick_mode", is_quick_mode)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if max_training_time_in_hours is not None:
            pulumi.set(__self__, "max_training_time_in_hours", max_training_time_in_hours)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if model_id is not None:
            pulumi.set(__self__, "model_id", model_id)
        if model_type is not None:
            pulumi.set(__self__, "model_type", model_type)
        if model_version is not None:
            pulumi.set(__self__, "model_version", model_version)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenancy_id is not None:
            pulumi.set(__self__, "tenancy_id", tenancy_id)
        if testing_dataset is not None:
            pulumi.set(__self__, "testing_dataset", testing_dataset)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if trained_time_in_hours is not None:
            pulumi.set(__self__, "trained_time_in_hours", trained_time_in_hours)
        if training_dataset is not None:
            pulumi.set(__self__, "training_dataset", training_dataset)
        if validation_dataset is not None:
            pulumi.set(__self__, "validation_dataset", validation_dataset)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @component_models.setter
    def component_models(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelComponentModelArgs']]]]):
        pulumi.set(self, "component_models", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A human-friendly name for the model, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @is_composed_model.setter
    def is_composed_model(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_composed_model", value)

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @is_quick_mode.setter
    def is_quick_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_quick_mode", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @max_training_time_in_hours.setter
    def max_training_time_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_training_time_in_hours", value)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]]]:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ModelMetricArgs']]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @model_type.setter
    def model_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_type", value)

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> Optional[pulumi.Input[str]]:
        """
        The model version
        """
        return pulumi.get(self, "model_version")

    @model_version.setter
    def model_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model_version", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the model.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @tenancy_id.setter
    def tenancy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_id", value)

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> Optional[pulumi.Input['ModelTestingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_dataset")

    @testing_dataset.setter
    def testing_dataset(self, value: Optional[pulumi.Input['ModelTestingDatasetArgs']]):
        pulumi.set(self, "testing_dataset", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> Optional[pulumi.Input[float]]:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @trained_time_in_hours.setter
    def trained_time_in_hours(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "trained_time_in_hours", value)

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> Optional[pulumi.Input['ModelTrainingDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_dataset")

    @training_dataset.setter
    def training_dataset(self, value: Optional[pulumi.Input['ModelTrainingDatasetArgs']]):
        pulumi.set(self, "training_dataset", value)

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> Optional[pulumi.Input['ModelValidationDatasetArgs']]:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_dataset")

    @validation_dataset.setter
    def validation_dataset(self, value: Optional[pulumi.Input['ModelValidationDatasetArgs']]):
        pulumi.set(self, "validation_dataset", value)


class Model(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelComponentModelArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[float]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']]] = None,
                 training_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']]] = None,
                 validation_dataset: Optional[pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Document service.

        Create a new model.

          Updates the model metadata only selected path parameter.

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiDocument/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelComponentModelArgs']]]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[str] model_type: The type of the Document model.
        :param pulumi.Input[str] model_version: The model version
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']] validation_dataset: The base entity which is the input for creating and training a model.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ModelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Model resource in Oracle Cloud Infrastructure Ai Document service.

        Create a new model.

          Updates the model metadata only selected path parameter.

        ## Import

        Models can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:AiDocument/model:Model test_model "id"
        ```

        :param str resource_name: The name of the resource.
        :param ModelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ModelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 component_models: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelComponentModelArgs']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_quick_mode: Optional[pulumi.Input[bool]] = None,
                 max_training_time_in_hours: Optional[pulumi.Input[float]] = None,
                 model_id: Optional[pulumi.Input[str]] = None,
                 model_type: Optional[pulumi.Input[str]] = None,
                 model_version: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 testing_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']]] = None,
                 training_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']]] = None,
                 validation_dataset: Optional[pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ModelArgs.__new__(ModelArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["component_models"] = component_models
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_quick_mode"] = is_quick_mode
            __props__.__dict__["max_training_time_in_hours"] = max_training_time_in_hours
            __props__.__dict__["model_id"] = model_id
            if model_type is None and not opts.urn:
                raise TypeError("Missing required property 'model_type'")
            __props__.__dict__["model_type"] = model_type
            __props__.__dict__["model_version"] = model_version
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["testing_dataset"] = testing_dataset
            __props__.__dict__["training_dataset"] = training_dataset
            __props__.__dict__["validation_dataset"] = validation_dataset
            __props__.__dict__["is_composed_model"] = None
            __props__.__dict__["labels"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["metrics"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenancy_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["trained_time_in_hours"] = None
        super(Model, __self__).__init__(
            'oci:AiDocument/model:Model',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            component_models: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelComponentModelArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_composed_model: Optional[pulumi.Input[bool]] = None,
            is_quick_mode: Optional[pulumi.Input[bool]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            max_training_time_in_hours: Optional[pulumi.Input[float]] = None,
            metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelMetricArgs']]]]] = None,
            model_id: Optional[pulumi.Input[str]] = None,
            model_type: Optional[pulumi.Input[str]] = None,
            model_version: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            tenancy_id: Optional[pulumi.Input[str]] = None,
            testing_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            trained_time_in_hours: Optional[pulumi.Input[float]] = None,
            training_dataset: Optional[pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']]] = None,
            validation_dataset: Optional[pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']]] = None) -> 'Model':
        """
        Get an existing Model resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The compartment identifier.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelComponentModelArgs']]]] component_models: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        :param pulumi.Input[str] description: (Updatable) An optional description of the model.
        :param pulumi.Input[str] display_name: (Updatable) A human-friendly name for the model, which can be changed.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        :param pulumi.Input[bool] is_composed_model: Set to true when the model is created by using multiple key value extraction models.
        :param pulumi.Input[bool] is_quick_mode: Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] labels: The collection of labels used to train the custom model.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail, that can provide actionable information if training failed.
        :param pulumi.Input[float] max_training_time_in_hours: The maximum model training time in hours, expressed as a decimal fraction.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ModelMetricArgs']]]] metrics: Trained Model Metrics.
        :param pulumi.Input[str] model_type: The type of the Document model.
        :param pulumi.Input[str] model_version: The model version
        :param pulumi.Input[str] project_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        :param pulumi.Input[str] state: The current state of the model.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        :param pulumi.Input[str] tenancy_id: The tenancy id of the model.
        :param pulumi.Input[pulumi.InputType['ModelTestingDatasetArgs']] testing_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[str] time_created: When the model was created, as an RFC3339 datetime string.
        :param pulumi.Input[str] time_updated: When the model was updated, as an RFC3339 datetime string.
        :param pulumi.Input[float] trained_time_in_hours: The total hours actually used for model training.
        :param pulumi.Input[pulumi.InputType['ModelTrainingDatasetArgs']] training_dataset: The base entity which is the input for creating and training a model.
        :param pulumi.Input[pulumi.InputType['ModelValidationDatasetArgs']] validation_dataset: The base entity which is the input for creating and training a model.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ModelState.__new__(_ModelState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["component_models"] = component_models
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_composed_model"] = is_composed_model
        __props__.__dict__["is_quick_mode"] = is_quick_mode
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["max_training_time_in_hours"] = max_training_time_in_hours
        __props__.__dict__["metrics"] = metrics
        __props__.__dict__["model_id"] = model_id
        __props__.__dict__["model_type"] = model_type
        __props__.__dict__["model_version"] = model_version
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenancy_id"] = tenancy_id
        __props__.__dict__["testing_dataset"] = testing_dataset
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["trained_time_in_hours"] = trained_time_in_hours
        __props__.__dict__["training_dataset"] = training_dataset
        __props__.__dict__["validation_dataset"] = validation_dataset
        return Model(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="componentModels")
    def component_models(self) -> pulumi.Output[Sequence['outputs.ModelComponentModel']]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) list of active custom Key Value models that need to be composed.
        """
        return pulumi.get(self, "component_models")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For example: `{"foo-namespace": {"bar-key": "value"}}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) An optional description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A human-friendly name for the model, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only. For example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isComposedModel")
    def is_composed_model(self) -> pulumi.Output[bool]:
        """
        Set to true when the model is created by using multiple key value extraction models.
        """
        return pulumi.get(self, "is_composed_model")

    @property
    @pulumi.getter(name="isQuickMode")
    def is_quick_mode(self) -> pulumi.Output[bool]:
        """
        Set to true when experimenting with a new model type or dataset, so the model training is quick, with a predefined low number of passes through the training data.
        """
        return pulumi.get(self, "is_quick_mode")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of labels used to train the custom model.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail, that can provide actionable information if training failed.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maxTrainingTimeInHours")
    def max_training_time_in_hours(self) -> pulumi.Output[float]:
        """
        The maximum model training time in hours, expressed as a decimal fraction.
        """
        return pulumi.get(self, "max_training_time_in_hours")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.ModelMetric']]:
        """
        Trained Model Metrics.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelType")
    def model_type(self) -> pulumi.Output[str]:
        """
        The type of the Document model.
        """
        return pulumi.get(self, "model_type")

    @property
    @pulumi.getter(name="modelVersion")
    def model_version(self) -> pulumi.Output[str]:
        """
        The model version
        """
        return pulumi.get(self, "model_version")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project that contains the model.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. For example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenancyId")
    def tenancy_id(self) -> pulumi.Output[str]:
        """
        The tenancy id of the model.
        """
        return pulumi.get(self, "tenancy_id")

    @property
    @pulumi.getter(name="testingDataset")
    def testing_dataset(self) -> pulumi.Output['outputs.ModelTestingDataset']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "testing_dataset")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        When the model was created, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        When the model was updated, as an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="trainedTimeInHours")
    def trained_time_in_hours(self) -> pulumi.Output[float]:
        """
        The total hours actually used for model training.
        """
        return pulumi.get(self, "trained_time_in_hours")

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> pulumi.Output['outputs.ModelTrainingDataset']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "training_dataset")

    @property
    @pulumi.getter(name="validationDataset")
    def validation_dataset(self) -> pulumi.Output['outputs.ModelValidationDataset']:
        """
        The base entity which is the input for creating and training a model.
        """
        return pulumi.get(self, "validation_dataset")

