# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMigrationResult',
    'AwaitableGetMigrationResult',
    'get_migration',
    'get_migration_output',
]

@pulumi.output_type
class GetMigrationResult:
    """
    A collection of values returned by getMigration.
    """
    def __init__(__self__, advisor_settings=None, bulk_include_exclude_data=None, compartment_id=None, data_transfer_medium_details=None, database_combination=None, defined_tags=None, description=None, display_name=None, exclude_objects=None, executing_job_id=None, freeform_tags=None, ggs_details=None, hub_details=None, id=None, include_objects=None, initial_load_settings=None, lifecycle_details=None, migration_id=None, source_container_database_connection_id=None, source_database_connection_id=None, state=None, system_tags=None, target_database_connection_id=None, time_created=None, time_last_migration=None, time_updated=None, type=None, wait_after=None):
        if advisor_settings and not isinstance(advisor_settings, list):
            raise TypeError("Expected argument 'advisor_settings' to be a list")
        pulumi.set(__self__, "advisor_settings", advisor_settings)
        if bulk_include_exclude_data and not isinstance(bulk_include_exclude_data, str):
            raise TypeError("Expected argument 'bulk_include_exclude_data' to be a str")
        pulumi.set(__self__, "bulk_include_exclude_data", bulk_include_exclude_data)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if data_transfer_medium_details and not isinstance(data_transfer_medium_details, list):
            raise TypeError("Expected argument 'data_transfer_medium_details' to be a list")
        pulumi.set(__self__, "data_transfer_medium_details", data_transfer_medium_details)
        if database_combination and not isinstance(database_combination, str):
            raise TypeError("Expected argument 'database_combination' to be a str")
        pulumi.set(__self__, "database_combination", database_combination)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if exclude_objects and not isinstance(exclude_objects, list):
            raise TypeError("Expected argument 'exclude_objects' to be a list")
        pulumi.set(__self__, "exclude_objects", exclude_objects)
        if executing_job_id and not isinstance(executing_job_id, str):
            raise TypeError("Expected argument 'executing_job_id' to be a str")
        pulumi.set(__self__, "executing_job_id", executing_job_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ggs_details and not isinstance(ggs_details, list):
            raise TypeError("Expected argument 'ggs_details' to be a list")
        pulumi.set(__self__, "ggs_details", ggs_details)
        if hub_details and not isinstance(hub_details, list):
            raise TypeError("Expected argument 'hub_details' to be a list")
        pulumi.set(__self__, "hub_details", hub_details)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_objects and not isinstance(include_objects, list):
            raise TypeError("Expected argument 'include_objects' to be a list")
        pulumi.set(__self__, "include_objects", include_objects)
        if initial_load_settings and not isinstance(initial_load_settings, list):
            raise TypeError("Expected argument 'initial_load_settings' to be a list")
        pulumi.set(__self__, "initial_load_settings", initial_load_settings)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if migration_id and not isinstance(migration_id, str):
            raise TypeError("Expected argument 'migration_id' to be a str")
        pulumi.set(__self__, "migration_id", migration_id)
        if source_container_database_connection_id and not isinstance(source_container_database_connection_id, str):
            raise TypeError("Expected argument 'source_container_database_connection_id' to be a str")
        pulumi.set(__self__, "source_container_database_connection_id", source_container_database_connection_id)
        if source_database_connection_id and not isinstance(source_database_connection_id, str):
            raise TypeError("Expected argument 'source_database_connection_id' to be a str")
        pulumi.set(__self__, "source_database_connection_id", source_database_connection_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if target_database_connection_id and not isinstance(target_database_connection_id, str):
            raise TypeError("Expected argument 'target_database_connection_id' to be a str")
        pulumi.set(__self__, "target_database_connection_id", target_database_connection_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_last_migration and not isinstance(time_last_migration, str):
            raise TypeError("Expected argument 'time_last_migration' to be a str")
        pulumi.set(__self__, "time_last_migration", time_last_migration)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if wait_after and not isinstance(wait_after, str):
            raise TypeError("Expected argument 'wait_after' to be a str")
        pulumi.set(__self__, "wait_after", wait_after)

    @property
    @pulumi.getter(name="advisorSettings")
    def advisor_settings(self) -> Sequence['outputs.GetMigrationAdvisorSettingResult']:
        """
        Details about Oracle Advisor Settings.
        """
        return pulumi.get(self, "advisor_settings")

    @property
    @pulumi.getter(name="bulkIncludeExcludeData")
    def bulk_include_exclude_data(self) -> str:
        return pulumi.get(self, "bulk_include_exclude_data")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dataTransferMediumDetails")
    def data_transfer_medium_details(self) -> Sequence['outputs.GetMigrationDataTransferMediumDetailResult']:
        """
        Optional additional properties for data transfer.
        """
        return pulumi.get(self, "data_transfer_medium_details")

    @property
    @pulumi.getter(name="databaseCombination")
    def database_combination(self) -> str:
        """
        The combination of source and target databases participating in a migration. Example: ORACLE means the migration is meant for migrating Oracle source and target databases.
        """
        return pulumi.get(self, "database_combination")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="excludeObjects")
    def exclude_objects(self) -> Sequence['outputs.GetMigrationExcludeObjectResult']:
        return pulumi.get(self, "exclude_objects")

    @property
    @pulumi.getter(name="executingJobId")
    def executing_job_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "executing_job_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ggsDetails")
    def ggs_details(self) -> Sequence['outputs.GetMigrationGgsDetailResult']:
        """
        Details for Oracle GoldenGate Deployment (Internally managed by the service, not required and will be ignored if provided).
        """
        return pulumi.get(self, "ggs_details")

    @property
    @pulumi.getter(name="hubDetails")
    def hub_details(self) -> Sequence['outputs.GetMigrationHubDetailResult']:
        """
        Details for Oracle GoldenGate Marketplace  Instance / Deployment (Currently not supported for MySQL migrations).
        """
        return pulumi.get(self, "hub_details")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeObjects")
    def include_objects(self) -> Sequence['outputs.GetMigrationIncludeObjectResult']:
        return pulumi.get(self, "include_objects")

    @property
    @pulumi.getter(name="initialLoadSettings")
    def initial_load_settings(self) -> Sequence['outputs.GetMigrationInitialLoadSettingResult']:
        """
        Optional settings for Data Pump Export and Import jobs
        """
        return pulumi.get(self, "initial_load_settings")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional status related to the execution and current state of the Migration.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationId")
    def migration_id(self) -> str:
        return pulumi.get(self, "migration_id")

    @property
    @pulumi.getter(name="sourceContainerDatabaseConnectionId")
    def source_container_database_connection_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_container_database_connection_id")

    @property
    @pulumi.getter(name="sourceDatabaseConnectionId")
    def source_database_connection_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "source_database_connection_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Migration resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetDatabaseConnectionId")
    def target_database_connection_id(self) -> str:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "target_database_connection_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastMigration")
    def time_last_migration(self) -> str:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_last_migration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the migration to be performed. Example: ONLINE if no downtime is preferred for a migration. This method uses Oracle GoldenGate for replication.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="waitAfter")
    def wait_after(self) -> str:
        """
        You can optionally pause a migration after a job phase. This property allows you to optionally specify the phase after which you can pause the migration.
        """
        return pulumi.get(self, "wait_after")


class AwaitableGetMigrationResult(GetMigrationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMigrationResult(
            advisor_settings=self.advisor_settings,
            bulk_include_exclude_data=self.bulk_include_exclude_data,
            compartment_id=self.compartment_id,
            data_transfer_medium_details=self.data_transfer_medium_details,
            database_combination=self.database_combination,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            exclude_objects=self.exclude_objects,
            executing_job_id=self.executing_job_id,
            freeform_tags=self.freeform_tags,
            ggs_details=self.ggs_details,
            hub_details=self.hub_details,
            id=self.id,
            include_objects=self.include_objects,
            initial_load_settings=self.initial_load_settings,
            lifecycle_details=self.lifecycle_details,
            migration_id=self.migration_id,
            source_container_database_connection_id=self.source_container_database_connection_id,
            source_database_connection_id=self.source_database_connection_id,
            state=self.state,
            system_tags=self.system_tags,
            target_database_connection_id=self.target_database_connection_id,
            time_created=self.time_created,
            time_last_migration=self.time_last_migration,
            time_updated=self.time_updated,
            type=self.type,
            wait_after=self.wait_after)


def get_migration(migration_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMigrationResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration = oci.DatabaseMigration.get_migration(migration_id=test_migration_oci_database_migration_migration["id"])
    ```


    :param str migration_id: The OCID of the migration
    """
    __args__ = dict()
    __args__['migrationId'] = migration_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseMigration/getMigration:getMigration', __args__, opts=opts, typ=GetMigrationResult).value

    return AwaitableGetMigrationResult(
        advisor_settings=pulumi.get(__ret__, 'advisor_settings'),
        bulk_include_exclude_data=pulumi.get(__ret__, 'bulk_include_exclude_data'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        data_transfer_medium_details=pulumi.get(__ret__, 'data_transfer_medium_details'),
        database_combination=pulumi.get(__ret__, 'database_combination'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        exclude_objects=pulumi.get(__ret__, 'exclude_objects'),
        executing_job_id=pulumi.get(__ret__, 'executing_job_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        ggs_details=pulumi.get(__ret__, 'ggs_details'),
        hub_details=pulumi.get(__ret__, 'hub_details'),
        id=pulumi.get(__ret__, 'id'),
        include_objects=pulumi.get(__ret__, 'include_objects'),
        initial_load_settings=pulumi.get(__ret__, 'initial_load_settings'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        migration_id=pulumi.get(__ret__, 'migration_id'),
        source_container_database_connection_id=pulumi.get(__ret__, 'source_container_database_connection_id'),
        source_database_connection_id=pulumi.get(__ret__, 'source_database_connection_id'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        target_database_connection_id=pulumi.get(__ret__, 'target_database_connection_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_last_migration=pulumi.get(__ret__, 'time_last_migration'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        wait_after=pulumi.get(__ret__, 'wait_after'))


@_utilities.lift_output_func(get_migration)
def get_migration_output(migration_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMigrationResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_migration = oci.DatabaseMigration.get_migration(migration_id=test_migration_oci_database_migration_migration["id"])
    ```


    :param str migration_id: The OCID of the migration
    """
    ...
