# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DedicatedAiClusterCapacity',
    'EndpointContentModerationConfig',
    'ModelFineTuneDetails',
    'ModelFineTuneDetailsTrainingConfig',
    'ModelFineTuneDetailsTrainingDataset',
    'ModelModelMetric',
    'GetDedicatedAiClusterCapacityResult',
    'GetDedicatedAiClustersDedicatedAiClusterCollectionResult',
    'GetDedicatedAiClustersDedicatedAiClusterCollectionItemResult',
    'GetDedicatedAiClustersDedicatedAiClusterCollectionItemCapacityResult',
    'GetDedicatedAiClustersFilterResult',
    'GetEndpointContentModerationConfigResult',
    'GetEndpointsEndpointCollectionResult',
    'GetEndpointsEndpointCollectionItemResult',
    'GetEndpointsEndpointCollectionItemContentModerationConfigResult',
    'GetEndpointsFilterResult',
    'GetModelFineTuneDetailResult',
    'GetModelFineTuneDetailTrainingConfigResult',
    'GetModelFineTuneDetailTrainingDatasetResult',
    'GetModelModelMetricResult',
    'GetModelsFilterResult',
    'GetModelsModelCollectionResult',
    'GetModelsModelCollectionItemResult',
    'GetModelsModelCollectionItemFineTuneDetailResult',
    'GetModelsModelCollectionItemFineTuneDetailTrainingConfigResult',
    'GetModelsModelCollectionItemFineTuneDetailTrainingDatasetResult',
    'GetModelsModelCollectionItemModelMetricResult',
]

@pulumi.output_type
class DedicatedAiClusterCapacity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityType":
            suggest = "capacity_type"
        elif key == "totalEndpointCapacity":
            suggest = "total_endpoint_capacity"
        elif key == "usedEndpointCapacity":
            suggest = "used_endpoint_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedAiClusterCapacity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedAiClusterCapacity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedAiClusterCapacity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_type: Optional[str] = None,
                 total_endpoint_capacity: Optional[int] = None,
                 used_endpoint_capacity: Optional[int] = None):
        """
        :param str capacity_type: The type of the dedicated AI cluster capacity.
        :param int total_endpoint_capacity: The total number of endpoints that can be hosted on this dedicated AI cluster.
        :param int used_endpoint_capacity: The number of endpoints hosted on this dedicated AI cluster.
        """
        if capacity_type is not None:
            pulumi.set(__self__, "capacity_type", capacity_type)
        if total_endpoint_capacity is not None:
            pulumi.set(__self__, "total_endpoint_capacity", total_endpoint_capacity)
        if used_endpoint_capacity is not None:
            pulumi.set(__self__, "used_endpoint_capacity", used_endpoint_capacity)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[str]:
        """
        The type of the dedicated AI cluster capacity.
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="totalEndpointCapacity")
    def total_endpoint_capacity(self) -> Optional[int]:
        """
        The total number of endpoints that can be hosted on this dedicated AI cluster.
        """
        return pulumi.get(self, "total_endpoint_capacity")

    @property
    @pulumi.getter(name="usedEndpointCapacity")
    def used_endpoint_capacity(self) -> Optional[int]:
        """
        The number of endpoints hosted on this dedicated AI cluster.
        """
        return pulumi.get(self, "used_endpoint_capacity")


@pulumi.output_type
class EndpointContentModerationConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointContentModerationConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointContentModerationConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointContentModerationConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: bool):
        """
        :param bool is_enabled: (Updatable) Whether to enable the content moderation feature.
        """
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        """
        (Updatable) Whether to enable the content moderation feature.
        """
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class ModelFineTuneDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dedicatedAiClusterId":
            suggest = "dedicated_ai_cluster_id"
        elif key == "trainingDataset":
            suggest = "training_dataset"
        elif key == "trainingConfig":
            suggest = "training_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelFineTuneDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelFineTuneDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelFineTuneDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dedicated_ai_cluster_id: str,
                 training_dataset: 'outputs.ModelFineTuneDetailsTrainingDataset',
                 training_config: Optional['outputs.ModelFineTuneDetailsTrainingConfig'] = None):
        """
        :param str dedicated_ai_cluster_id: The OCID of the dedicated AI cluster this fine-tuning runs on.
        :param 'ModelFineTuneDetailsTrainingDatasetArgs' training_dataset: The dataset used to fine-tune the model. 
               
               Only one dataset is allowed per custom model, which is split 80-20 for training and validating. You must provide the dataset in a JSON Lines (JSONL) file. Each line in the JSONL file must have the format: `{"prompt": "<first prompt>", "completion": "<expected completion given first prompt>"}`
        :param 'ModelFineTuneDetailsTrainingConfigArgs' training_config: The fine-tuning method and hyperparameters used for fine-tuning a custom model.
        """
        pulumi.set(__self__, "dedicated_ai_cluster_id", dedicated_ai_cluster_id)
        pulumi.set(__self__, "training_dataset", training_dataset)
        if training_config is not None:
            pulumi.set(__self__, "training_config", training_config)

    @property
    @pulumi.getter(name="dedicatedAiClusterId")
    def dedicated_ai_cluster_id(self) -> str:
        """
        The OCID of the dedicated AI cluster this fine-tuning runs on.
        """
        return pulumi.get(self, "dedicated_ai_cluster_id")

    @property
    @pulumi.getter(name="trainingDataset")
    def training_dataset(self) -> 'outputs.ModelFineTuneDetailsTrainingDataset':
        """
        The dataset used to fine-tune the model. 

        Only one dataset is allowed per custom model, which is split 80-20 for training and validating. You must provide the dataset in a JSON Lines (JSONL) file. Each line in the JSONL file must have the format: `{"prompt": "<first prompt>", "completion": "<expected completion given first prompt>"}`
        """
        return pulumi.get(self, "training_dataset")

    @property
    @pulumi.getter(name="trainingConfig")
    def training_config(self) -> Optional['outputs.ModelFineTuneDetailsTrainingConfig']:
        """
        The fine-tuning method and hyperparameters used for fine-tuning a custom model.
        """
        return pulumi.get(self, "training_config")


@pulumi.output_type
class ModelFineTuneDetailsTrainingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trainingConfigType":
            suggest = "training_config_type"
        elif key == "earlyStoppingPatience":
            suggest = "early_stopping_patience"
        elif key == "earlyStoppingThreshold":
            suggest = "early_stopping_threshold"
        elif key == "learningRate":
            suggest = "learning_rate"
        elif key == "logModelMetricsIntervalInSteps":
            suggest = "log_model_metrics_interval_in_steps"
        elif key == "loraAlpha":
            suggest = "lora_alpha"
        elif key == "loraDropout":
            suggest = "lora_dropout"
        elif key == "loraR":
            suggest = "lora_r"
        elif key == "numOfLastLayers":
            suggest = "num_of_last_layers"
        elif key == "totalTrainingEpochs":
            suggest = "total_training_epochs"
        elif key == "trainingBatchSize":
            suggest = "training_batch_size"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelFineTuneDetailsTrainingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelFineTuneDetailsTrainingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelFineTuneDetailsTrainingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 training_config_type: str,
                 early_stopping_patience: Optional[int] = None,
                 early_stopping_threshold: Optional[float] = None,
                 learning_rate: Optional[float] = None,
                 log_model_metrics_interval_in_steps: Optional[int] = None,
                 lora_alpha: Optional[int] = None,
                 lora_dropout: Optional[float] = None,
                 lora_r: Optional[int] = None,
                 num_of_last_layers: Optional[int] = None,
                 total_training_epochs: Optional[int] = None,
                 training_batch_size: Optional[int] = None):
        """
        :param str training_config_type: The fine-tuning method for training a custom model.
        :param int early_stopping_patience: Stop training if the loss metric does not improve beyond 'early_stopping_threshold' for this many times of evaluation.
        :param float early_stopping_threshold: How much the loss must improve to prevent early stopping.
        :param float learning_rate: The initial learning rate to be used during training
        :param int log_model_metrics_interval_in_steps: Determines how frequently to log model metrics. 
               
               Every step is logged for the first 20 steps and then follows this parameter for log frequency. Set to 0 to disable logging the model metrics.
        :param int lora_alpha: This parameter represents the scaling factor for the weight matrices in LoRA.
        :param float lora_dropout: This parameter indicates the dropout probability for LoRA layers.
        :param int lora_r: This parameter represents the LoRA rank of the update matrices.
        :param int num_of_last_layers: The number of last layers to be fine-tuned.
        :param int total_training_epochs: The maximum number of training epochs to run for.
        :param int training_batch_size: The batch size used during training.
        """
        pulumi.set(__self__, "training_config_type", training_config_type)
        if early_stopping_patience is not None:
            pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        if early_stopping_threshold is not None:
            pulumi.set(__self__, "early_stopping_threshold", early_stopping_threshold)
        if learning_rate is not None:
            pulumi.set(__self__, "learning_rate", learning_rate)
        if log_model_metrics_interval_in_steps is not None:
            pulumi.set(__self__, "log_model_metrics_interval_in_steps", log_model_metrics_interval_in_steps)
        if lora_alpha is not None:
            pulumi.set(__self__, "lora_alpha", lora_alpha)
        if lora_dropout is not None:
            pulumi.set(__self__, "lora_dropout", lora_dropout)
        if lora_r is not None:
            pulumi.set(__self__, "lora_r", lora_r)
        if num_of_last_layers is not None:
            pulumi.set(__self__, "num_of_last_layers", num_of_last_layers)
        if total_training_epochs is not None:
            pulumi.set(__self__, "total_training_epochs", total_training_epochs)
        if training_batch_size is not None:
            pulumi.set(__self__, "training_batch_size", training_batch_size)

    @property
    @pulumi.getter(name="trainingConfigType")
    def training_config_type(self) -> str:
        """
        The fine-tuning method for training a custom model.
        """
        return pulumi.get(self, "training_config_type")

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> Optional[int]:
        """
        Stop training if the loss metric does not improve beyond 'early_stopping_threshold' for this many times of evaluation.
        """
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="earlyStoppingThreshold")
    def early_stopping_threshold(self) -> Optional[float]:
        """
        How much the loss must improve to prevent early stopping.
        """
        return pulumi.get(self, "early_stopping_threshold")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> Optional[float]:
        """
        The initial learning rate to be used during training
        """
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="logModelMetricsIntervalInSteps")
    def log_model_metrics_interval_in_steps(self) -> Optional[int]:
        """
        Determines how frequently to log model metrics. 

        Every step is logged for the first 20 steps and then follows this parameter for log frequency. Set to 0 to disable logging the model metrics.
        """
        return pulumi.get(self, "log_model_metrics_interval_in_steps")

    @property
    @pulumi.getter(name="loraAlpha")
    def lora_alpha(self) -> Optional[int]:
        """
        This parameter represents the scaling factor for the weight matrices in LoRA.
        """
        return pulumi.get(self, "lora_alpha")

    @property
    @pulumi.getter(name="loraDropout")
    def lora_dropout(self) -> Optional[float]:
        """
        This parameter indicates the dropout probability for LoRA layers.
        """
        return pulumi.get(self, "lora_dropout")

    @property
    @pulumi.getter(name="loraR")
    def lora_r(self) -> Optional[int]:
        """
        This parameter represents the LoRA rank of the update matrices.
        """
        return pulumi.get(self, "lora_r")

    @property
    @pulumi.getter(name="numOfLastLayers")
    def num_of_last_layers(self) -> Optional[int]:
        """
        The number of last layers to be fine-tuned.
        """
        return pulumi.get(self, "num_of_last_layers")

    @property
    @pulumi.getter(name="totalTrainingEpochs")
    def total_training_epochs(self) -> Optional[int]:
        """
        The maximum number of training epochs to run for.
        """
        return pulumi.get(self, "total_training_epochs")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> Optional[int]:
        """
        The batch size used during training.
        """
        return pulumi.get(self, "training_batch_size")


@pulumi.output_type
class ModelFineTuneDetailsTrainingDataset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetType":
            suggest = "dataset_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelFineTuneDetailsTrainingDataset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelFineTuneDetailsTrainingDataset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelFineTuneDetailsTrainingDataset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: The Object Storage bucket name.
        :param str dataset_type: The type of the data asset.
        :param str namespace: The Object Storage namespace.
        :param str object: The Object Storage object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The Object Storage bucket name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        """
        The type of the data asset.
        """
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        The Object Storage object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class ModelModelMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "finalAccuracy":
            suggest = "final_accuracy"
        elif key == "finalLoss":
            suggest = "final_loss"
        elif key == "modelMetricsType":
            suggest = "model_metrics_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ModelModelMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ModelModelMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ModelModelMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 final_accuracy: Optional[float] = None,
                 final_loss: Optional[float] = None,
                 model_metrics_type: Optional[str] = None):
        """
        :param float final_accuracy: Fine-tuned model accuracy.
        :param float final_loss: Fine-tuned model loss.
        :param str model_metrics_type: The type of the model metrics. Each type of model can expect a different set of model metrics.
        """
        if final_accuracy is not None:
            pulumi.set(__self__, "final_accuracy", final_accuracy)
        if final_loss is not None:
            pulumi.set(__self__, "final_loss", final_loss)
        if model_metrics_type is not None:
            pulumi.set(__self__, "model_metrics_type", model_metrics_type)

    @property
    @pulumi.getter(name="finalAccuracy")
    def final_accuracy(self) -> Optional[float]:
        """
        Fine-tuned model accuracy.
        """
        return pulumi.get(self, "final_accuracy")

    @property
    @pulumi.getter(name="finalLoss")
    def final_loss(self) -> Optional[float]:
        """
        Fine-tuned model loss.
        """
        return pulumi.get(self, "final_loss")

    @property
    @pulumi.getter(name="modelMetricsType")
    def model_metrics_type(self) -> Optional[str]:
        """
        The type of the model metrics. Each type of model can expect a different set of model metrics.
        """
        return pulumi.get(self, "model_metrics_type")


@pulumi.output_type
class GetDedicatedAiClusterCapacityResult(dict):
    def __init__(__self__, *,
                 capacity_type: str,
                 total_endpoint_capacity: int,
                 used_endpoint_capacity: int):
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "total_endpoint_capacity", total_endpoint_capacity)
        pulumi.set(__self__, "used_endpoint_capacity", used_endpoint_capacity)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> str:
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="totalEndpointCapacity")
    def total_endpoint_capacity(self) -> int:
        return pulumi.get(self, "total_endpoint_capacity")

    @property
    @pulumi.getter(name="usedEndpointCapacity")
    def used_endpoint_capacity(self) -> int:
        return pulumi.get(self, "used_endpoint_capacity")


@pulumi.output_type
class GetDedicatedAiClustersDedicatedAiClusterCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDedicatedAiClustersDedicatedAiClusterCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDedicatedAiClustersDedicatedAiClusterCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDedicatedAiClustersDedicatedAiClusterCollectionItemResult(dict):
    def __init__(__self__, *,
                 capacities: Sequence['outputs.GetDedicatedAiClustersDedicatedAiClusterCollectionItemCapacityResult'],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str,
                 type: str,
                 unit_count: int,
                 unit_shape: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
        :param str state: A filter to return only the dedicated AI clusters that their lifecycle state matches the given lifecycle state.
        """
        pulumi.set(__self__, "capacities", capacities)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "unit_count", unit_count)
        pulumi.set(__self__, "unit_shape", unit_shape)

    @property
    @pulumi.getter
    def capacities(self) -> Sequence['outputs.GetDedicatedAiClustersDedicatedAiClusterCollectionItemCapacityResult']:
        return pulumi.get(self, "capacities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated AI cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only the dedicated AI clusters that their lifecycle state matches the given lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="unitCount")
    def unit_count(self) -> int:
        return pulumi.get(self, "unit_count")

    @property
    @pulumi.getter(name="unitShape")
    def unit_shape(self) -> str:
        return pulumi.get(self, "unit_shape")


@pulumi.output_type
class GetDedicatedAiClustersDedicatedAiClusterCollectionItemCapacityResult(dict):
    def __init__(__self__, *,
                 capacity_type: str,
                 total_endpoint_capacity: int,
                 used_endpoint_capacity: int):
        pulumi.set(__self__, "capacity_type", capacity_type)
        pulumi.set(__self__, "total_endpoint_capacity", total_endpoint_capacity)
        pulumi.set(__self__, "used_endpoint_capacity", used_endpoint_capacity)

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> str:
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="totalEndpointCapacity")
    def total_endpoint_capacity(self) -> int:
        return pulumi.get(self, "total_endpoint_capacity")

    @property
    @pulumi.getter(name="usedEndpointCapacity")
    def used_endpoint_capacity(self) -> int:
        return pulumi.get(self, "used_endpoint_capacity")


@pulumi.output_type
class GetDedicatedAiClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetEndpointContentModerationConfigResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool):
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetEndpointsEndpointCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetEndpointsEndpointCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetEndpointsEndpointCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetEndpointsEndpointCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 content_moderation_configs: Sequence['outputs.GetEndpointsEndpointCollectionItemContentModerationConfigResult'],
                 dedicated_ai_cluster_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 lifecycle_details: str,
                 model_id: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_updated: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the endpoint.
        :param str model_id: The OCID of the model that's used to create this endpoint.
        :param str state: A filter to return only resources that their lifecycle state matches the given lifecycle state.
        :param str time_created: The date and time that the endpoint was created in the format of an RFC3339 datetime string.
        :param str time_updated: The date and time that the endpoint was updated in the format of an RFC3339 datetime string.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "content_moderation_configs", content_moderation_configs)
        pulumi.set(__self__, "dedicated_ai_cluster_id", dedicated_ai_cluster_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contentModerationConfigs")
    def content_moderation_configs(self) -> Sequence['outputs.GetEndpointsEndpointCollectionItemContentModerationConfigResult']:
        return pulumi.get(self, "content_moderation_configs")

    @property
    @pulumi.getter(name="dedicatedAiClusterId")
    def dedicated_ai_cluster_id(self) -> str:
        return pulumi.get(self, "dedicated_ai_cluster_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the endpoint.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        """
        The OCID of the model that's used to create this endpoint.
        """
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources that their lifecycle state matches the given lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the endpoint was created in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time that the endpoint was updated in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetEndpointsEndpointCollectionItemContentModerationConfigResult(dict):
    def __init__(__self__, *,
                 is_enabled: bool):
        pulumi.set(__self__, "is_enabled", is_enabled)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> bool:
        return pulumi.get(self, "is_enabled")


@pulumi.output_type
class GetEndpointsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelFineTuneDetailResult(dict):
    def __init__(__self__, *,
                 dedicated_ai_cluster_id: str,
                 training_configs: Sequence['outputs.GetModelFineTuneDetailTrainingConfigResult'],
                 training_datasets: Sequence['outputs.GetModelFineTuneDetailTrainingDatasetResult']):
        pulumi.set(__self__, "dedicated_ai_cluster_id", dedicated_ai_cluster_id)
        pulumi.set(__self__, "training_configs", training_configs)
        pulumi.set(__self__, "training_datasets", training_datasets)

    @property
    @pulumi.getter(name="dedicatedAiClusterId")
    def dedicated_ai_cluster_id(self) -> str:
        return pulumi.get(self, "dedicated_ai_cluster_id")

    @property
    @pulumi.getter(name="trainingConfigs")
    def training_configs(self) -> Sequence['outputs.GetModelFineTuneDetailTrainingConfigResult']:
        return pulumi.get(self, "training_configs")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelFineTuneDetailTrainingDatasetResult']:
        return pulumi.get(self, "training_datasets")


@pulumi.output_type
class GetModelFineTuneDetailTrainingConfigResult(dict):
    def __init__(__self__, *,
                 early_stopping_patience: int,
                 early_stopping_threshold: float,
                 learning_rate: float,
                 log_model_metrics_interval_in_steps: int,
                 lora_alpha: int,
                 lora_dropout: float,
                 lora_r: int,
                 num_of_last_layers: int,
                 total_training_epochs: int,
                 training_batch_size: int,
                 training_config_type: str):
        pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        pulumi.set(__self__, "early_stopping_threshold", early_stopping_threshold)
        pulumi.set(__self__, "learning_rate", learning_rate)
        pulumi.set(__self__, "log_model_metrics_interval_in_steps", log_model_metrics_interval_in_steps)
        pulumi.set(__self__, "lora_alpha", lora_alpha)
        pulumi.set(__self__, "lora_dropout", lora_dropout)
        pulumi.set(__self__, "lora_r", lora_r)
        pulumi.set(__self__, "num_of_last_layers", num_of_last_layers)
        pulumi.set(__self__, "total_training_epochs", total_training_epochs)
        pulumi.set(__self__, "training_batch_size", training_batch_size)
        pulumi.set(__self__, "training_config_type", training_config_type)

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> int:
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="earlyStoppingThreshold")
    def early_stopping_threshold(self) -> float:
        return pulumi.get(self, "early_stopping_threshold")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> float:
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="logModelMetricsIntervalInSteps")
    def log_model_metrics_interval_in_steps(self) -> int:
        return pulumi.get(self, "log_model_metrics_interval_in_steps")

    @property
    @pulumi.getter(name="loraAlpha")
    def lora_alpha(self) -> int:
        return pulumi.get(self, "lora_alpha")

    @property
    @pulumi.getter(name="loraDropout")
    def lora_dropout(self) -> float:
        return pulumi.get(self, "lora_dropout")

    @property
    @pulumi.getter(name="loraR")
    def lora_r(self) -> int:
        return pulumi.get(self, "lora_r")

    @property
    @pulumi.getter(name="numOfLastLayers")
    def num_of_last_layers(self) -> int:
        return pulumi.get(self, "num_of_last_layers")

    @property
    @pulumi.getter(name="totalTrainingEpochs")
    def total_training_epochs(self) -> int:
        return pulumi.get(self, "total_training_epochs")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> int:
        return pulumi.get(self, "training_batch_size")

    @property
    @pulumi.getter(name="trainingConfigType")
    def training_config_type(self) -> str:
        return pulumi.get(self, "training_config_type")


@pulumi.output_type
class GetModelFineTuneDetailTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelModelMetricResult(dict):
    def __init__(__self__, *,
                 final_accuracy: float,
                 final_loss: float,
                 model_metrics_type: str):
        pulumi.set(__self__, "final_accuracy", final_accuracy)
        pulumi.set(__self__, "final_loss", final_loss)
        pulumi.set(__self__, "model_metrics_type", model_metrics_type)

    @property
    @pulumi.getter(name="finalAccuracy")
    def final_accuracy(self) -> float:
        return pulumi.get(self, "final_accuracy")

    @property
    @pulumi.getter(name="finalLoss")
    def final_loss(self) -> float:
        return pulumi.get(self, "final_loss")

    @property
    @pulumi.getter(name="modelMetricsType")
    def model_metrics_type(self) -> str:
        return pulumi.get(self, "model_metrics_type")


@pulumi.output_type
class GetModelsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetModelsModelCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetModelsModelCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetModelsModelCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetModelsModelCollectionItemResult(dict):
    def __init__(__self__, *,
                 base_model_id: str,
                 capabilities: Sequence[str],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 fine_tune_details: Sequence['outputs.GetModelsModelCollectionItemFineTuneDetailResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_long_term_supported: bool,
                 lifecycle_details: str,
                 model_metrics: Sequence['outputs.GetModelsModelCollectionItemModelMetricResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_deprecated: str,
                 time_updated: str,
                 type: str,
                 vendor: str,
                 version: str):
        """
        :param Sequence[str] capabilities: Describes what this model can be used for.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param str id: The ID of the model.
        :param str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param str time_deprecated: Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        :param str type: The model type indicating whether this is a pretrained/base model or a custom/fine-tuned model.
        :param str vendor: A filter to return only resources that match the entire vendor given.
        :param str version: The version of the model.
        """
        pulumi.set(__self__, "base_model_id", base_model_id)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "fine_tune_details", fine_tune_details)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_long_term_supported", is_long_term_supported)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "model_metrics", model_metrics)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_deprecated", time_deprecated)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vendor", vendor)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="baseModelId")
    def base_model_id(self) -> str:
        return pulumi.get(self, "base_model_id")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence[str]:
        """
        Describes what this model can be used for.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fineTuneDetails")
    def fine_tune_details(self) -> Sequence['outputs.GetModelsModelCollectionItemFineTuneDetailResult']:
        return pulumi.get(self, "fine_tune_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the model.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLongTermSupported")
    def is_long_term_supported(self) -> bool:
        return pulumi.get(self, "is_long_term_supported")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelMetrics")
    def model_metrics(self) -> Sequence['outputs.GetModelsModelCollectionItemModelMetricResult']:
        return pulumi.get(self, "model_metrics")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeprecated")
    def time_deprecated(self) -> str:
        """
        Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        """
        return pulumi.get(self, "time_deprecated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The model type indicating whether this is a pretrained/base model or a custom/fine-tuned model.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        A filter to return only resources that match the entire vendor given.
        """
        return pulumi.get(self, "vendor")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the model.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetModelsModelCollectionItemFineTuneDetailResult(dict):
    def __init__(__self__, *,
                 dedicated_ai_cluster_id: str,
                 training_configs: Sequence['outputs.GetModelsModelCollectionItemFineTuneDetailTrainingConfigResult'],
                 training_datasets: Sequence['outputs.GetModelsModelCollectionItemFineTuneDetailTrainingDatasetResult']):
        pulumi.set(__self__, "dedicated_ai_cluster_id", dedicated_ai_cluster_id)
        pulumi.set(__self__, "training_configs", training_configs)
        pulumi.set(__self__, "training_datasets", training_datasets)

    @property
    @pulumi.getter(name="dedicatedAiClusterId")
    def dedicated_ai_cluster_id(self) -> str:
        return pulumi.get(self, "dedicated_ai_cluster_id")

    @property
    @pulumi.getter(name="trainingConfigs")
    def training_configs(self) -> Sequence['outputs.GetModelsModelCollectionItemFineTuneDetailTrainingConfigResult']:
        return pulumi.get(self, "training_configs")

    @property
    @pulumi.getter(name="trainingDatasets")
    def training_datasets(self) -> Sequence['outputs.GetModelsModelCollectionItemFineTuneDetailTrainingDatasetResult']:
        return pulumi.get(self, "training_datasets")


@pulumi.output_type
class GetModelsModelCollectionItemFineTuneDetailTrainingConfigResult(dict):
    def __init__(__self__, *,
                 early_stopping_patience: int,
                 early_stopping_threshold: float,
                 learning_rate: float,
                 log_model_metrics_interval_in_steps: int,
                 lora_alpha: int,
                 lora_dropout: float,
                 lora_r: int,
                 num_of_last_layers: int,
                 total_training_epochs: int,
                 training_batch_size: int,
                 training_config_type: str):
        pulumi.set(__self__, "early_stopping_patience", early_stopping_patience)
        pulumi.set(__self__, "early_stopping_threshold", early_stopping_threshold)
        pulumi.set(__self__, "learning_rate", learning_rate)
        pulumi.set(__self__, "log_model_metrics_interval_in_steps", log_model_metrics_interval_in_steps)
        pulumi.set(__self__, "lora_alpha", lora_alpha)
        pulumi.set(__self__, "lora_dropout", lora_dropout)
        pulumi.set(__self__, "lora_r", lora_r)
        pulumi.set(__self__, "num_of_last_layers", num_of_last_layers)
        pulumi.set(__self__, "total_training_epochs", total_training_epochs)
        pulumi.set(__self__, "training_batch_size", training_batch_size)
        pulumi.set(__self__, "training_config_type", training_config_type)

    @property
    @pulumi.getter(name="earlyStoppingPatience")
    def early_stopping_patience(self) -> int:
        return pulumi.get(self, "early_stopping_patience")

    @property
    @pulumi.getter(name="earlyStoppingThreshold")
    def early_stopping_threshold(self) -> float:
        return pulumi.get(self, "early_stopping_threshold")

    @property
    @pulumi.getter(name="learningRate")
    def learning_rate(self) -> float:
        return pulumi.get(self, "learning_rate")

    @property
    @pulumi.getter(name="logModelMetricsIntervalInSteps")
    def log_model_metrics_interval_in_steps(self) -> int:
        return pulumi.get(self, "log_model_metrics_interval_in_steps")

    @property
    @pulumi.getter(name="loraAlpha")
    def lora_alpha(self) -> int:
        return pulumi.get(self, "lora_alpha")

    @property
    @pulumi.getter(name="loraDropout")
    def lora_dropout(self) -> float:
        return pulumi.get(self, "lora_dropout")

    @property
    @pulumi.getter(name="loraR")
    def lora_r(self) -> int:
        return pulumi.get(self, "lora_r")

    @property
    @pulumi.getter(name="numOfLastLayers")
    def num_of_last_layers(self) -> int:
        return pulumi.get(self, "num_of_last_layers")

    @property
    @pulumi.getter(name="totalTrainingEpochs")
    def total_training_epochs(self) -> int:
        return pulumi.get(self, "total_training_epochs")

    @property
    @pulumi.getter(name="trainingBatchSize")
    def training_batch_size(self) -> int:
        return pulumi.get(self, "training_batch_size")

    @property
    @pulumi.getter(name="trainingConfigType")
    def training_config_type(self) -> str:
        return pulumi.get(self, "training_config_type")


@pulumi.output_type
class GetModelsModelCollectionItemFineTuneDetailTrainingDatasetResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 dataset_type: str,
                 namespace: str,
                 object: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "dataset_type", dataset_type)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="datasetType")
    def dataset_type(self) -> str:
        return pulumi.get(self, "dataset_type")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        return pulumi.get(self, "object")


@pulumi.output_type
class GetModelsModelCollectionItemModelMetricResult(dict):
    def __init__(__self__, *,
                 final_accuracy: float,
                 final_loss: float,
                 model_metrics_type: str):
        pulumi.set(__self__, "final_accuracy", final_accuracy)
        pulumi.set(__self__, "final_loss", final_loss)
        pulumi.set(__self__, "model_metrics_type", model_metrics_type)

    @property
    @pulumi.getter(name="finalAccuracy")
    def final_accuracy(self) -> float:
        return pulumi.get(self, "final_accuracy")

    @property
    @pulumi.getter(name="finalLoss")
    def final_loss(self) -> float:
        return pulumi.get(self, "final_loss")

    @property
    @pulumi.getter(name="modelMetricsType")
    def model_metrics_type(self) -> str:
        return pulumi.get(self, "model_metrics_type")


