# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterDatastoreArgs',
    'ClusterNetworkConfigurationArgs',
    'ClusterUpgradeLicenseArgs',
    'ClusterVsphereUpgradeObjectArgs',
    'SddcDatastoreArgs',
    'SddcHcxOnPremLicenseArgs',
    'SddcInitialConfigurationArgs',
    'SddcInitialConfigurationInitialClusterConfigurationArgs',
    'SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs',
    'SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs',
    'SddcUpgradeLicenseArgs',
    'SddcVsphereUpgradeObjectArgs',
    'GetClustersFilterArgs',
    'GetExsiHostsFilterArgs',
    'GetSddcsFilterArgs',
    'GetSupportedCommitmentsFilterArgs',
    'GetSupportedHostShapesFilterArgs',
    'GetSupportedSkusFilterArgs',
    'GetSupportedVmwareSoftwareVersionsFilterArgs',
]

@pulumi.input_type
class ClusterDatastoreArgs:
    def __init__(__self__, *,
                 block_volume_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 datastore_type: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param pulumi.Input[str] datastore_type: Type of the datastore.
        :param pulumi.Input[float] capacity: Size of the Block Storage Volume in GB.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @block_volume_ids.setter
    def block_volume_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "block_volume_ids", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class ClusterNetworkConfigurationArgs:
    def __init__(__self__, *,
                 nsx_edge_vtep_vlan_id: pulumi.Input[str],
                 nsx_vtep_vlan_id: pulumi.Input[str],
                 provisioning_subnet_id: pulumi.Input[str],
                 vmotion_vlan_id: pulumi.Input[str],
                 vsan_vlan_id: pulumi.Input[str],
                 hcx_vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
                 provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
                 replication_vlan_id: Optional[pulumi.Input[str]] = None,
                 vsphere_vlan_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] nsx_edge_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] nsx_vtep_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] provisioning_subnet_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        :param pulumi.Input[str] vmotion_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] vsan_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] hcx_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
               
               This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] nsx_edge_uplink1vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] nsx_edge_uplink2vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] provisioning_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        :param pulumi.Input[str] replication_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        :param pulumi.Input[str] vsphere_vlan_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        if hcx_vlan_id is not None:
            pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        if nsx_edge_uplink1vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        if nsx_edge_uplink2vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        if provisioning_vlan_id is not None:
            pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        if replication_vlan_id is not None:
            pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        if vsphere_vlan_id is not None:
            pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @nsx_edge_vtep_vlan_id.setter
    def nsx_edge_vtep_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_edge_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @nsx_vtep_vlan_id.setter
    def nsx_vtep_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @provisioning_subnet_id.setter
    def provisioning_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioning_subnet_id", value)

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.

        This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @vmotion_vlan_id.setter
    def vmotion_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmotion_vlan_id", value)

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.

        This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @vsan_vlan_id.setter
    def vsan_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vsan_vlan_id", value)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.

        This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @hcx_vlan_id.setter
    def hcx_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @nsx_edge_uplink1vlan_id.setter
    def nsx_edge_uplink1vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink1vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @nsx_edge_uplink2vlan_id.setter
    def nsx_edge_uplink2vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink2vlan_id", value)

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @provisioning_vlan_id.setter
    def provisioning_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_vlan_id", value)

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @replication_vlan_id.setter
    def replication_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_vlan_id", value)

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsphere_vlan_id")

    @vsphere_vlan_id.setter
    def vsphere_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vsphere_vlan_id", value)


@pulumi.input_type
class ClusterUpgradeLicenseArgs:
    def __init__(__self__, *,
                 license_key: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] license_key: vSphere license key value.
        :param pulumi.Input[str] license_type: vSphere license type.
        """
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[str]]:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_key", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class ClusterVsphereUpgradeObjectArgs:
    def __init__(__self__, *,
                 download_link: Optional[pulumi.Input[str]] = None,
                 link_description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] download_link: Binary object download link.
        :param pulumi.Input[str] link_description: Binary object description.
        """
        if download_link is not None:
            pulumi.set(__self__, "download_link", download_link)
        if link_description is not None:
            pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> Optional[pulumi.Input[str]]:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @download_link.setter
    def download_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "download_link", value)

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> Optional[pulumi.Input[str]]:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")

    @link_description.setter
    def link_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_description", value)


@pulumi.input_type
class SddcDatastoreArgs:
    def __init__(__self__, *,
                 block_volume_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 datastore_type: pulumi.Input[str],
                 capacity: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param pulumi.Input[str] datastore_type: Type of the datastore.
        :param pulumi.Input[float] capacity: Size of the Block Storage Volume in GB.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @block_volume_ids.setter
    def block_volume_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "block_volume_ids", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[float]]:
        """
        Size of the Block Storage Volume in GB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "capacity", value)


@pulumi.input_type
class SddcHcxOnPremLicenseArgs:
    def __init__(__self__, *,
                 activation_key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] activation_key: HCX on-premise license key value.
        :param pulumi.Input[str] status: status of HCX on-premise license.
        :param pulumi.Input[str] system_name: Name of the system that consumed the HCX on-premise license
        """
        if activation_key is not None:
            pulumi.set(__self__, "activation_key", activation_key)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_name is not None:
            pulumi.set(__self__, "system_name", system_name)

    @property
    @pulumi.getter(name="activationKey")
    def activation_key(self) -> Optional[pulumi.Input[str]]:
        """
        HCX on-premise license key value.
        """
        return pulumi.get(self, "activation_key")

    @activation_key.setter
    def activation_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        status of HCX on-premise license.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemName")
    def system_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the system that consumed the HCX on-premise license
        """
        return pulumi.get(self, "system_name")

    @system_name.setter
    def system_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "system_name", value)


@pulumi.input_type
class SddcInitialConfigurationArgs:
    def __init__(__self__, *,
                 initial_cluster_configurations: pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationArgs']]] initial_cluster_configurations: The configurations for Clusters initially created in the SDDC.
        """
        pulumi.set(__self__, "initial_cluster_configurations", initial_cluster_configurations)

    @property
    @pulumi.getter(name="initialClusterConfigurations")
    def initial_cluster_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationArgs']]]:
        """
        The configurations for Clusters initially created in the SDDC.
        """
        return pulumi.get(self, "initial_cluster_configurations")

    @initial_cluster_configurations.setter
    def initial_cluster_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationArgs']]]):
        pulumi.set(self, "initial_cluster_configurations", value)


@pulumi.input_type
class SddcInitialConfigurationInitialClusterConfigurationArgs:
    def __init__(__self__, *,
                 compute_availability_domain: pulumi.Input[str],
                 esxi_hosts_count: pulumi.Input[int],
                 vsphere_type: pulumi.Input[str],
                 actual_esxi_hosts_count: Optional[pulumi.Input[int]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs']]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 initial_commitment: Optional[pulumi.Input[str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[str]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[bool]] = None,
                 network_configuration: Optional[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs']] = None,
                 workload_network_cidr: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param pulumi.Input[int] esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a Cluster with a ESXi host count of 1 will be considered a single ESXi host Cluster.
               
               **Note:** If you later delete EXSi hosts from a production Cluster to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until it again has at least 3 ESXi hosts.
        :param pulumi.Input[str] vsphere_type: vSphere Cluster types.
        :param pulumi.Input[int] actual_esxi_hosts_count: The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC. **Deprecated**.
        :param pulumi.Input[str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs']]] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[str] display_name: A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[str] initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[float] initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param pulumi.Input[str] initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
               
               For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        :param pulumi.Input[bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this Cluster.
        :param pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs'] network_configuration: The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param pulumi.Input[str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads.
        """
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "vsphere_type", vsphere_type)
        if actual_esxi_hosts_count is not None:
            pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if datastores is not None:
            pulumi.set(__self__, "datastores", datastores)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if initial_commitment is not None:
            pulumi.set(__self__, "initial_commitment", initial_commitment)
        if initial_host_ocpu_count is not None:
            pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name is not None:
            pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        if instance_display_name_prefix is not None:
            pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        if is_shielded_instance_enabled is not None:
            pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if workload_network_cidr is not None:
            pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> pulumi.Input[int]:
        """
        The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). Creating a Cluster with a ESXi host count of 1 will be considered a single ESXi host Cluster.

        **Note:** If you later delete EXSi hosts from a production Cluster to total less than 3, you are still billed for the 3 minimum recommended ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until it again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @esxi_hosts_count.setter
    def esxi_hosts_count(self, value: pulumi.Input[int]):
        pulumi.set(self, "esxi_hosts_count", value)

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> pulumi.Input[str]:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @vsphere_type.setter
    def vsphere_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "vsphere_type", value)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of actual ESXi hosts in the SDDC on the cloud. This attribute will be different when esxi Host is added to an existing SDDC. **Deprecated**.
        """
        return pulumi.get(self, "actual_esxi_hosts_count")

    @actual_esxi_hosts_count.setter
    def actual_esxi_hosts_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "actual_esxi_hosts_count", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter
    def datastores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs']]]]:
        """
        A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @datastores.setter
    def datastores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs']]]]):
        pulumi.set(self, "datastores", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> Optional[pulumi.Input[str]]:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @initial_commitment.setter
    def initial_commitment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_commitment", value)

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @initial_host_ocpu_count.setter
    def initial_host_ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "initial_host_ocpu_count", value)

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[pulumi.Input[str]]:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @initial_host_shape_name.setter
    def initial_host_shape_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "initial_host_shape_name", value)

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.

        For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @instance_display_name_prefix.setter
    def instance_display_name_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_display_name_prefix", value)

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether shielded instance is enabled for this Cluster.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @is_shielded_instance_enabled.setter
    def is_shielded_instance_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shielded_instance_enabled", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs']]:
        """
        The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads.
        """
        return pulumi.get(self, "workload_network_cidr")

    @workload_network_cidr.setter
    def workload_network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_network_cidr", value)


@pulumi.input_type
class SddcInitialConfigurationInitialClusterConfigurationDatastoreArgs:
    def __init__(__self__, *,
                 block_volume_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 datastore_type: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] block_volume_ids: A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        :param pulumi.Input[str] datastore_type: Type of the datastore.
        """
        pulumi.set(__self__, "block_volume_ids", block_volume_ids)
        pulumi.set(__self__, "datastore_type", datastore_type)

    @property
    @pulumi.getter(name="blockVolumeIds")
    def block_volume_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)s of Block Storage Volumes.
        """
        return pulumi.get(self, "block_volume_ids")

    @block_volume_ids.setter
    def block_volume_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "block_volume_ids", value)

    @property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> pulumi.Input[str]:
        """
        Type of the datastore.
        """
        return pulumi.get(self, "datastore_type")

    @datastore_type.setter
    def datastore_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "datastore_type", value)


@pulumi.input_type
class SddcInitialConfigurationInitialClusterConfigurationNetworkConfigurationArgs:
    def __init__(__self__, *,
                 nsx_edge_vtep_vlan_id: pulumi.Input[str],
                 nsx_vtep_vlan_id: pulumi.Input[str],
                 provisioning_subnet_id: pulumi.Input[str],
                 vmotion_vlan_id: pulumi.Input[str],
                 vsan_vlan_id: pulumi.Input[str],
                 hcx_vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink1vlan_id: Optional[pulumi.Input[str]] = None,
                 nsx_edge_uplink2vlan_id: Optional[pulumi.Input[str]] = None,
                 provisioning_vlan_id: Optional[pulumi.Input[str]] = None,
                 replication_vlan_id: Optional[pulumi.Input[str]] = None,
                 vsphere_vlan_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] nsx_edge_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] nsx_vtep_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.
               
               This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] provisioning_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        :param pulumi.Input[str] vmotion_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] vsan_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.
               
               This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] hcx_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.
               
               This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] nsx_edge_uplink1vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] nsx_edge_uplink2vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        :param pulumi.Input[str] provisioning_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        :param pulumi.Input[str] replication_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        :param pulumi.Input[str] vsphere_vlan_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.
               
               This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).
               
               Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        pulumi.set(__self__, "nsx_edge_vtep_vlan_id", nsx_edge_vtep_vlan_id)
        pulumi.set(__self__, "nsx_vtep_vlan_id", nsx_vtep_vlan_id)
        pulumi.set(__self__, "provisioning_subnet_id", provisioning_subnet_id)
        pulumi.set(__self__, "vmotion_vlan_id", vmotion_vlan_id)
        pulumi.set(__self__, "vsan_vlan_id", vsan_vlan_id)
        if hcx_vlan_id is not None:
            pulumi.set(__self__, "hcx_vlan_id", hcx_vlan_id)
        if nsx_edge_uplink1vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink1vlan_id", nsx_edge_uplink1vlan_id)
        if nsx_edge_uplink2vlan_id is not None:
            pulumi.set(__self__, "nsx_edge_uplink2vlan_id", nsx_edge_uplink2vlan_id)
        if provisioning_vlan_id is not None:
            pulumi.set(__self__, "provisioning_vlan_id", provisioning_vlan_id)
        if replication_vlan_id is not None:
            pulumi.set(__self__, "replication_vlan_id", replication_vlan_id)
        if vsphere_vlan_id is not None:
            pulumi.set(__self__, "vsphere_vlan_id", vsphere_vlan_id)

    @property
    @pulumi.getter(name="nsxEdgeVtepVlanId")
    def nsx_edge_vtep_vlan_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX Edge VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX Edge VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_vtep_vlan_id")

    @nsx_edge_vtep_vlan_id.setter
    def nsx_edge_vtep_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_edge_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="nsxVtepVlanId")
    def nsx_vtep_vlan_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the NSX VTEP component of the VMware environment.

        This attribute is not guaranteed to reflect the NSX VTEP VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX VTEP VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX VTEP component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxVTepVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_vtep_vlan_id")

    @nsx_vtep_vlan_id.setter
    def nsx_vtep_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "nsx_vtep_vlan_id", value)

    @property
    @pulumi.getter(name="provisioningSubnetId")
    def provisioning_subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet used to provision the Cluster.
        """
        return pulumi.get(self, "provisioning_subnet_id")

    @provisioning_subnet_id.setter
    def provisioning_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "provisioning_subnet_id", value)

    @property
    @pulumi.getter(name="vmotionVlanId")
    def vmotion_vlan_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vMotion component of the VMware environment.

        This attribute is not guaranteed to reflect the vMotion VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vMotion VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vMotion component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateCluster) to update the Cluster's `vmotionVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vmotion_vlan_id")

    @vmotion_vlan_id.setter
    def vmotion_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vmotion_vlan_id", value)

    @property
    @pulumi.getter(name="vsanVlanId")
    def vsan_vlan_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSAN component of the VMware environment.

        This attribute is not guaranteed to reflect the vSAN VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSAN VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSAN component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `vsanVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsan_vlan_id")

    @vsan_vlan_id.setter
    def vsan_vlan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vsan_vlan_id", value)

    @property
    @pulumi.getter(name="hcxVlanId")
    def hcx_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the HCX component of the VMware environment. This VLAN is a mandatory attribute  for Management Cluster when HCX is enabled.

        This attribute is not guaranteed to reflect the HCX VLAN currently used by the ESXi hosts in the SDDC. The purpose of this attribute is to show the HCX VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this SDDC in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the SDDC to use a different VLAN for the HCX component of the VMware environment, you should use [UpdateSddc](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/Sddc/UpdateSddc) to update the SDDC's `hcxVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "hcx_vlan_id")

    @hcx_vlan_id.setter
    def hcx_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hcx_vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink1vlanId")
    def nsx_edge_uplink1vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the NSX Edge Uplink 1 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 1 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 1 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 1 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink1VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink1vlan_id")

    @nsx_edge_uplink1vlan_id.setter
    def nsx_edge_uplink1vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink1vlan_id", value)

    @property
    @pulumi.getter(name="nsxEdgeUplink2vlanId")
    def nsx_edge_uplink2vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC  for the NSX Edge Uplink 2 component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the NSX Edge Uplink 2 VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the NSX Edge Uplink 2 VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the NSX Edge Uplink 2 component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Cluster/UpdateCluster) to update the Cluster's `nsxEdgeUplink2VlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "nsx_edge_uplink2vlan_id")

    @nsx_edge_uplink2vlan_id.setter
    def nsx_edge_uplink2vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nsx_edge_uplink2vlan_id", value)

    @property
    @pulumi.getter(name="provisioningVlanId")
    def provisioning_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the Provisioning component of the VMware environment.
        """
        return pulumi.get(self, "provisioning_vlan_id")

    @provisioning_vlan_id.setter
    def provisioning_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provisioning_vlan_id", value)

    @property
    @pulumi.getter(name="replicationVlanId")
    def replication_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the Cluster for the vSphere Replication component of the VMware environment.
        """
        return pulumi.get(self, "replication_vlan_id")

    @replication_vlan_id.setter
    def replication_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_vlan_id", value)

    @property
    @pulumi.getter(name="vsphereVlanId")
    def vsphere_vlan_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VLAN used by the SDDC for the vSphere component of the VMware environment. This VLAN is a mandatory attribute for Management Cluster.

        This attribute is not guaranteed to reflect the vSphere VLAN currently used by the ESXi hosts in the Cluster. The purpose of this attribute is to show the vSphere VLAN that the Oracle Cloud VMware Solution will use for any new ESXi hosts that you *add to this Cluster in the future* with [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost).

        Therefore, if you change the existing ESXi hosts in the Cluster to use a different VLAN for the vSphere component of the VMware environment, you should use [UpdateCluster](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/Sddc/UpdateSddc) to update the Cluster's `vsphereVlanId` with that new VLAN's OCID.
        """
        return pulumi.get(self, "vsphere_vlan_id")

    @vsphere_vlan_id.setter
    def vsphere_vlan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vsphere_vlan_id", value)


@pulumi.input_type
class SddcUpgradeLicenseArgs:
    def __init__(__self__, *,
                 license_key: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] license_key: vSphere license key value.
        :param pulumi.Input[str] license_type: vSphere license type.
        """
        if license_key is not None:
            pulumi.set(__self__, "license_key", license_key)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)

    @property
    @pulumi.getter(name="licenseKey")
    def license_key(self) -> Optional[pulumi.Input[str]]:
        """
        vSphere license key value.
        """
        return pulumi.get(self, "license_key")

    @license_key.setter
    def license_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_key", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        vSphere license type.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)


@pulumi.input_type
class SddcVsphereUpgradeObjectArgs:
    def __init__(__self__, *,
                 download_link: Optional[pulumi.Input[str]] = None,
                 link_description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] download_link: Binary object download link.
        :param pulumi.Input[str] link_description: Binary object description.
        """
        if download_link is not None:
            pulumi.set(__self__, "download_link", download_link)
        if link_description is not None:
            pulumi.set(__self__, "link_description", link_description)

    @property
    @pulumi.getter(name="downloadLink")
    def download_link(self) -> Optional[pulumi.Input[str]]:
        """
        Binary object download link.
        """
        return pulumi.get(self, "download_link")

    @download_link.setter
    def download_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "download_link", value)

    @property
    @pulumi.getter(name="linkDescription")
    def link_description(self) -> Optional[pulumi.Input[str]]:
        """
        Binary object description.
        """
        return pulumi.get(self, "link_description")

    @link_description.setter
    def link_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_description", value)


@pulumi.input_type
class GetClustersFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetExsiHostsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSddcsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedCommitmentsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: name of Commitment
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of Commitment
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedHostShapesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only resources that match the given name exactly.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only resources that match the given name exactly.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedSkusFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: name of SKU
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name of SKU
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetSupportedVmwareSoftwareVersionsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


