"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricType = void 0;
var MetricType;
(function (MetricType) {
    /**
     * This metric measures an attribute of events
     *
     * It could be time, or request size, or similar. The default
     * aggregate for this type of event is "Avg".
     */
    MetricType["Attrib"] = "attrib";
    /**
     * This metric is counting events.
     *
     * This means the metric "1" is emitted every time an event occurs.
     * Only "Sum" is a meaningful aggregate of this type of metric.
     */
    MetricType["Count"] = "count";
    /**
     * This metric is emitting a size.
     *
     * The metric is not event-based, but measures some global ever-changing
     * property. The most useful aggregate of this type of metric is "Max".
     */
    MetricType["Gauge"] = "gauge";
})(MetricType = exports.MetricType || (exports.MetricType = {}));
//# sourceMappingURL=data:application/json;base64,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