import { AwsDestination } from './aws-destination';
/**
 * A file asset.
 *
 * @stability stable
 */
export interface FileAsset {
    /**
     * Source description for file assets.
     *
     * @stability stable
     */
    readonly source: FileSource;
    /**
     * Destinations for this file asset.
     *
     * @stability stable
     */
    readonly destinations: {
        [id: string]: FileDestination;
    };
}
/**
 * Packaging strategy for file assets.
 *
 * @stability stable
 */
export declare enum FileAssetPackaging {
    /**
     * Upload the given path as a file.
     *
     * @stability stable
     */
    FILE = "file",
    /**
     * The given path is a directory, zip it and upload.
     *
     * @stability stable
     */
    ZIP_DIRECTORY = "zip"
}
/**
 * Describe the source of a file asset.
 *
 * @stability stable
 */
export interface FileSource {
    /**
     * External command which will produce the file asset to upload.
     *
     * @default - Exactly one of `executable` and `path` is required.
     * @stability stable
     */
    readonly executable?: string[];
    /**
     * The filesystem object to upload.
     *
     * This path is relative to the asset manifest location.
     *
     * @default - Exactly one of `executable` and `path` is required.
     * @stability stable
     */
    readonly path?: string;
    /**
     * Packaging method.
     *
     * Only allowed when `path` is specified.
     *
     * @default FILE
     * @stability stable
     */
    readonly packaging?: FileAssetPackaging;
}
/**
 * Where in S3 a file asset needs to be published.
 *
 * @stability stable
 */
export interface FileDestination extends AwsDestination {
    /**
     * The name of the bucket.
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * The destination object key.
     *
     * @stability stable
     */
    readonly objectKey: string;
}
