import { ArtifactProperties } from './artifact-schema';
import { ContextProvider, ContextQueryProperties } from './context-queries';
import { MetadataEntry } from './metadata-schema';
/**
 * Type of cloud artifact.
 *
 * @stability stable
 */
export declare enum ArtifactType {
    /**
     * Stub required because of JSII.
     *
     * @stability stable
     */
    NONE = "none",
    /**
     * The artifact is an AWS CloudFormation stack.
     *
     * @stability stable
     */
    AWS_CLOUDFORMATION_STACK = "aws:cloudformation:stack",
    /**
     * The artifact contains the CDK application's construct tree.
     *
     * @stability stable
     */
    CDK_TREE = "cdk:tree",
    /**
     * Manifest for all assets in the Cloud Assembly.
     *
     * @stability stable
     */
    ASSET_MANIFEST = "cdk:asset-manifest",
    /**
     * Nested Cloud Assembly.
     *
     * @stability stable
     */
    NESTED_CLOUD_ASSEMBLY = "cdk:cloud-assembly"
}
/**
 * Information about the application's runtime components.
 *
 * @stability stable
 */
export interface RuntimeInfo {
    /**
     * The list of libraries loaded in the application, associated with their versions.
     *
     * @stability stable
     */
    readonly libraries: {
        [name: string]: string;
    };
}
/**
 * Represents a missing piece of context.
 *
 * @stability stable
 */
export interface MissingContext {
    /**
     * The missing context key.
     *
     * @stability stable
     */
    readonly key: string;
    /**
     * The provider from which we expect this context key to be obtained.
     *
     * @stability stable
     */
    readonly provider: ContextProvider;
    /**
     * A set of provider-specific options.
     *
     * @stability stable
     */
    readonly props: ContextQueryProperties;
}
/**
 * A manifest for a single artifact within the cloud assembly.
 *
 * @stability stable
 */
export interface ArtifactManifest {
    /**
     * The type of artifact.
     *
     * @stability stable
     */
    readonly type: ArtifactType;
    /**
     * The environment into which this artifact is deployed.
     *
     * @default - no envrionment.
     * @stability stable
     */
    readonly environment?: string;
    /**
     * Associated metadata.
     *
     * @default - no metadata.
     * @stability stable
     */
    readonly metadata?: {
        [path: string]: MetadataEntry[];
    };
    /**
     * IDs of artifacts that must be deployed before this artifact.
     *
     * @default - no dependencies.
     * @stability stable
     */
    readonly dependencies?: string[];
    /**
     * The set of properties for this artifact (depends on type).
     *
     * @default - no properties.
     * @stability stable
     */
    readonly properties?: ArtifactProperties;
}
/**
 * A manifest which describes the cloud assembly.
 *
 * @stability stable
 */
export interface AssemblyManifest {
    /**
     * Protocol version.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * The set of artifacts in this assembly.
     *
     * @default - no artifacts.
     * @stability stable
     */
    readonly artifacts?: {
        [id: string]: ArtifactManifest;
    };
    /**
     * Missing context information.
     *
     * If this field has values, it means that the
     * cloud assembly is not complete and should not be deployed.
     *
     * @default - no missing context.
     * @stability stable
     */
    readonly missing?: MissingContext[];
    /**
     * Runtime information.
     *
     * @default - no info.
     * @stability stable
     */
    readonly runtime?: RuntimeInfo;
}
