import * as cxschema from '@aws-cdk/cloud-assembly-schema';
import { CloudFormationStackArtifact } from './artifacts/cloudformation-artifact';
import { NestedCloudAssemblyArtifact } from './artifacts/nested-cloud-assembly-artifact';
import { TreeCloudArtifact } from './artifacts/tree-cloud-artifact';
import { CloudArtifact } from './cloud-artifact';
/**
 * Represents a deployable cloud application.
 *
 * @stability stable
 */
export declare class CloudAssembly {
    /**
     * The root directory of the cloud assembly.
     *
     * @stability stable
     */
    readonly directory: string;
    /**
     * The schema version of the assembly manifest.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * All artifacts included in this assembly.
     *
     * @stability stable
     */
    readonly artifacts: CloudArtifact[];
    /**
     * Runtime information such as module versions used to synthesize this assembly.
     *
     * @stability stable
     */
    readonly runtime: cxschema.RuntimeInfo;
    /**
     * The raw assembly manifest.
     *
     * @stability stable
     */
    readonly manifest: cxschema.AssemblyManifest;
    /**
     * Reads a cloud assembly from the specified directory.
     *
     * @param directory The root directory of the assembly.
     * @stability stable
     */
    constructor(directory: string);
    /**
     * Attempts to find an artifact with a specific identity.
     *
     * @param id The artifact ID.
     * @returns A `CloudArtifact` object or `undefined` if the artifact does not exist in this assembly.
     * @stability stable
     */
    tryGetArtifact(id: string): CloudArtifact | undefined;
    /**
     * Returns a CloudFormation stack artifact from this assembly.
     *
     * Will only search the current assembly.
     *
     * @param stackName the name of the CloudFormation stack.
     * @returns a `CloudFormationStackArtifact` object.
     * @stability stable
     * @throws if there is more than one stack with the same stack name. You can
     * use `getStackArtifact(stack.artifactId)` instead.
     */
    getStackByName(stackName: string): CloudFormationStackArtifact;
    /**
     * (deprecated) Returns a CloudFormation stack artifact by name from this assembly.
     *
     * @deprecated renamed to `getStackByName` (or `getStackArtifact(id)`)
     */
    getStack(stackName: string): CloudFormationStackArtifact;
    /**
     * Returns a CloudFormation stack artifact from this assembly.
     *
     * @param artifactId the artifact id of the stack (can be obtained through `stack.artifactId`).
     * @returns a `CloudFormationStackArtifact` object.
     * @stability stable
     * @throws if there is no stack artifact with that id
     */
    getStackArtifact(artifactId: string): CloudFormationStackArtifact;
    /**
     * Returns a nested assembly artifact.
     *
     * @param artifactId The artifact ID of the nested assembly.
     * @stability stable
     */
    getNestedAssemblyArtifact(artifactId: string): NestedCloudAssemblyArtifact;
    /**
     * Returns a nested assembly.
     *
     * @param artifactId The artifact ID of the nested assembly.
     * @stability stable
     */
    getNestedAssembly(artifactId: string): CloudAssembly;
    /**
     * Returns the tree metadata artifact from this assembly.
     *
     * @returns a `TreeCloudArtifact` object if there is one defined in the manifest, `undefined` otherwise.
     * @stability stable
     * @throws if there is no metadata artifact by that name
     */
    tree(): TreeCloudArtifact | undefined;
    /**
     * @returns all the CloudFormation stack artifacts that are included in this assembly.
     * @stability stable
     */
    get stacks(): CloudFormationStackArtifact[];
    /**
     * The nested assembly artifacts in this assembly.
     *
     * @stability stable
     */
    get nestedAssemblies(): NestedCloudAssemblyArtifact[];
    private validateDeps;
    private renderArtifacts;
}
/**
 * Construction properties for CloudAssemblyBuilder.
 *
 * @stability stable
 */
export interface CloudAssemblyBuilderProps {
    /**
     * Use the given asset output directory.
     *
     * @default - Same as the manifest outdir
     * @stability stable
     */
    readonly assetOutdir?: string;
    /**
     * If this builder is for a nested assembly, the parent assembly builder.
     *
     * @default - This is a root assembly
     * @stability stable
     */
    readonly parentBuilder?: CloudAssemblyBuilder;
}
/**
 * Can be used to build a cloud assembly.
 *
 * @stability stable
 */
export declare class CloudAssemblyBuilder {
    /**
     * The root directory of the resulting cloud assembly.
     *
     * @stability stable
     */
    readonly outdir: string;
    /**
     * The directory where assets of this Cloud Assembly should be stored.
     *
     * @stability stable
     */
    readonly assetOutdir: string;
    private readonly artifacts;
    private readonly missing;
    private readonly parentBuilder?;
    /**
     * Initializes a cloud assembly builder.
     *
     * @param outdir The output directory, uses temporary directory if undefined.
     * @stability stable
     */
    constructor(outdir?: string, props?: CloudAssemblyBuilderProps);
    /**
     * Adds an artifact into the cloud assembly.
     *
     * @param id The ID of the artifact.
     * @param manifest The artifact manifest.
     * @stability stable
     */
    addArtifact(id: string, manifest: cxschema.ArtifactManifest): void;
    /**
     * Reports that some context is missing in order for this cloud assembly to be fully synthesized.
     *
     * @param missing Missing context information.
     * @stability stable
     */
    addMissing(missing: cxschema.MissingContext): void;
    /**
     * Finalizes the cloud assembly into the output directory returns a `CloudAssembly` object that can be used to inspect the assembly.
     *
     * @stability stable
     */
    buildAssembly(options?: AssemblyBuildOptions): CloudAssembly;
    /**
     * Creates a nested cloud assembly.
     *
     * @stability stable
     */
    createNestedAssembly(artifactId: string, displayName: string): CloudAssemblyBuilder;
}
/**
 * (deprecated) Backwards compatibility for when `RuntimeInfo` was defined here.
 *
 * This is necessary because its used as an input in the stable
 *
 * @see core.ConstructNode.synth
 * @deprecated moved to package 'cloud-assembly-schema'
 * @aws-cdk /core library.
 */
export interface RuntimeInfo extends cxschema.RuntimeInfo {
}
/**
 * (deprecated) Backwards compatibility for when `MetadataEntry` was defined here.
 *
 * This is necessary because its used as an input in the stable
 *
 * @see core.ConstructNode.metadata
 * @deprecated moved to package 'cloud-assembly-schema'
 * @aws-cdk /core library.
 */
export interface MetadataEntry extends cxschema.MetadataEntry {
}
/**
 * (deprecated) Backwards compatibility for when `MissingContext` was defined here.
 *
 * This is necessary because its used as an input in the stable
 *
 * @see core.Stack.reportMissingContext
 * @deprecated moved to package 'cloud-assembly-schema'
 * @aws-cdk /core library.
 */
export interface MissingContext {
    /**
     * (deprecated) The missing context key.
     *
     * @deprecated
     */
    readonly key: string;
    /**
     * (deprecated) The provider from which we expect this context key to be obtained.
     *
     * (This is the old untyped definition, which is necessary for backwards compatibility.
     * See cxschema for a type definition.)
     *
     * @deprecated
     */
    readonly provider: string;
    /**
     * (deprecated) A set of provider-specific options.
     *
     * (This is the old untyped definition, which is necessary for backwards compatibility.
     * See cxschema for a type definition.)
     *
     * @deprecated
     */
    readonly props: Record<string, any>;
}
/**
 * @stability stable
 */
export interface AssemblyBuildOptions {
    /**
     * (deprecated) Include the specified runtime information (module versions) in manifest.
     *
     * @default - if this option is not specified, runtime info will not be included
     * @deprecated All template modifications that should result from this should
     * have already been inserted into the template.
     */
    readonly runtimeInfo?: RuntimeInfo;
}
