"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfnspec = require("../lib");
module.exports = {
    'spot-check DynamoDB metrics'(test) {
        const metrics = cfnspec.cannedMetricsForService('AWS::DynamoDB');
        test.ok(metrics.length > 0);
        const resLatency = metrics.find(m => m.metricName === 'SuccessfulRequestLatency');
        test.ok(resLatency);
        test.deepEqual(resLatency === null || resLatency === void 0 ? void 0 : resLatency.dimensions, [['Operation', 'TableName']]);
        test.done();
    },
    'spot-check MediaStore metrics'(test) {
        const metrics = cfnspec.cannedMetricsForService('AWS::MediaStore');
        test.ok(metrics.length > 0);
        test.done();
    },
};
/**
 * Test that we can read canned metrics for all namespaces in the spec without throwing an error
 */
for (const _namespace of cfnspec.namespaces()) {
    const namespace = _namespace;
    module.exports[`Validate canned metrics for ${namespace}`] = (test) => {
        const metrics = cfnspec.cannedMetricsForService(namespace);
        // Check that there are no duplicates in these list (duplicates may occur because of duplicate
        // dimensions, but those have readly been combined).
        const uniqueMetricNames = new Set(metrics.map(m => `${m.namespace}/${m.metricName}`));
        test.equal(uniqueMetricNames.size, metrics.length, 'There are metrics with duplicate names');
        test.done();
    };
}
//# sourceMappingURL=data:application/json;base64,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