"use strict";
const lib_1 = require("../lib");
const schema_1 = require("../lib/schema");
module.exports = {
    'spot-check IAM identity tags'(test) {
        const prop = lib_1.propertySpecification('AWS::IAM::Role', 'Policies');
        test.equals(prop.ScrutinyType, schema_1.PropertyScrutinyType.InlineIdentityPolicies);
        test.done();
    },
    'IAM AssumeRolePolicy'(test) {
        // AssumeRolePolicyDocument is a resource policy, because it applies to the Role itself!
        const prop = lib_1.propertySpecification('AWS::IAM::Role', 'AssumeRolePolicyDocument');
        test.equals(prop.ScrutinyType, schema_1.PropertyScrutinyType.InlineResourcePolicy);
        test.done();
    },
    'spot-check IAM resource tags'(test) {
        const prop = lib_1.propertySpecification('AWS::KMS::Key', 'KeyPolicy');
        test.equals(prop.ScrutinyType, schema_1.PropertyScrutinyType.InlineResourcePolicy);
        test.done();
    },
    'spot-check resource policy resources'(test) {
        test.equals(lib_1.resourceSpecification('AWS::S3::BucketPolicy').ScrutinyType, schema_1.ResourceScrutinyType.ResourcePolicyResource);
        test.done();
    },
    'spot-check no misclassified tags'(test) {
        const prop = lib_1.propertySpecification('AWS::SNS::Subscription', 'DeliveryPolicy');
        test.equals(prop.ScrutinyType, schema_1.PropertyScrutinyType.None);
        test.done();
    },
    'check Lambda permission resource scrutiny'(test) {
        test.equals(lib_1.resourceSpecification('AWS::Lambda::Permission').ScrutinyType, schema_1.ResourceScrutinyType.LambdaPermission);
        test.done();
    },
    'check role managedpolicyarns'(test) {
        const prop = lib_1.propertySpecification('AWS::IAM::Role', 'ManagedPolicyArns');
        test.equals(prop.ScrutinyType, schema_1.PropertyScrutinyType.ManagedPolicies);
        test.done();
    },
    'check securityGroup scrutinies'(test) {
        const inProp = lib_1.propertySpecification('AWS::EC2::SecurityGroup', 'SecurityGroupIngress');
        test.equals(inProp.ScrutinyType, schema_1.PropertyScrutinyType.IngressRules);
        const eProp = lib_1.propertySpecification('AWS::EC2::SecurityGroup', 'SecurityGroupEgress');
        test.equals(eProp.ScrutinyType, schema_1.PropertyScrutinyType.EgressRules);
        test.done();
    },
    'check securityGroupRule scrutinies'(test) {
        const inRes = lib_1.resourceSpecification('AWS::EC2::SecurityGroupIngress');
        test.equals(inRes.ScrutinyType, schema_1.ResourceScrutinyType.IngressRuleResource);
        const eRes = lib_1.resourceSpecification('AWS::EC2::SecurityGroupEgress');
        test.equals(eRes.ScrutinyType, schema_1.ResourceScrutinyType.EgressRuleResource);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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