import { IFragmentConcatenator, IResolvable } from './resolvable';
/**
 * Fragments of a concatenated string containing stringified Tokens.
 *
 * @stability stable
 */
export declare class TokenizedStringFragments {
    private readonly fragments;
    /**
     * @stability stable
     */
    get firstToken(): IResolvable | undefined;
    /**
     * @stability stable
     */
    get firstValue(): any;
    /**
     * @stability stable
     */
    get length(): number;
    /**
     * @stability stable
     */
    addLiteral(lit: any): void;
    /**
     * @stability stable
     */
    addToken(token: IResolvable): void;
    /**
     * @stability stable
     */
    addIntrinsic(value: any): void;
    /**
     * Return all Tokens from this string.
     *
     * @stability stable
     */
    get tokens(): IResolvable[];
    /**
     * Apply a transformation function to all tokens in the string.
     *
     * @stability stable
     */
    mapTokens(mapper: ITokenMapper): TokenizedStringFragments;
    /**
     * Combine the string fragments using the given joiner.
     *
     * If there are any
     *
     * @stability stable
     */
    join(concat: IFragmentConcatenator): any;
}
/**
 * Interface to apply operation to tokens in a string.
 *
 * Interface so it can be exported via jsii.
 *
 * @stability stable
 */
export interface ITokenMapper {
    /**
     * Replace a single token.
     *
     * @stability stable
     */
    mapToken(t: IResolvable): any;
}
