/**
 * Inspector that maintains an attribute bag.
 *
 * @stability stable
 */
export declare class TreeInspector {
    /**
     * Represents the bag of attributes as key-value pairs.
     *
     * @stability stable
     */
    readonly attributes: {
        [key: string]: any;
    };
    /**
     * Adds attribute to bag.
     *
     * Keys should be added by convention to prevent conflicts
     * i.e. L1 constructs will contain attributes with keys prefixed with aws:cdk:cloudformation
     *
     * @param key - key for metadata.
     * @param value - value of metadata.
     * @stability stable
     */
    addAttribute(key: string, value: any): void;
}
/**
 * Interface for examining a construct and exposing metadata.
 *
 * @stability stable
 */
export interface IInspectable {
    /**
     * Examines construct.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @stability stable
     */
    inspect(inspector: TreeInspector): void;
}
