"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatePolicy = exports.checkParseTemplate = exports.checkParsePolicy = exports.checkParseSchema = void 0;
const cedar = require("@cedar-policy/cedar-wasm/nodejs");
function checkParseSchema(schemaStr) {
    const schemaParseResult = cedar.checkParseSchema(schemaStr);
    if (schemaParseResult.type === 'error') {
        throw new Error(`Schema is invalid: ${schemaParseResult.errors}`);
    }
}
exports.checkParseSchema = checkParseSchema;
function checkParsePolicy(policyStatement) {
    const parsePolicyResult = cedar.checkParsePolicySet(policyStatement);
    if (parsePolicyResult.type == 'error') {
        throw new Error(`Invalid policy statement: ${policyStatement}. Errors: ${parsePolicyResult.errors.join(', ')}`);
    }
}
exports.checkParsePolicy = checkParsePolicy;
function checkParseTemplate(templateStatement) {
    const templateParseResult = cedar.checkParseTemplate(templateStatement);
    if (templateParseResult.type === 'error') {
        throw new Error(`Error parsing template: ${templateStatement}. Errors: ${templateParseResult.errors.join(', ')}`);
    }
}
exports.checkParseTemplate = checkParseTemplate;
function validatePolicy(policyStatement, schemaStr) {
    const validationResult = cedar.validate({
        validationSettings: { enabled: 'on' },
        schema: {
            json: JSON.parse(schemaStr),
        },
        policySet: policyStatement,
    });
    if (validationResult.type === 'failure') {
        throw new Error(`Policy (contents: ${policyStatement}) could not be parsed: ${validationResult.errors.join('; ')}`);
    }
    if (validationResult.type === 'success' && validationResult.validationErrors.length > 0) {
        throw new Error(`Policy (contents: ${policyStatement}) could not be validated against the schema:
      ${validationResult.validationErrors.join('; ')}`);
    }
}
exports.validatePolicy = validatePolicy;
//# sourceMappingURL=data:application/json;base64,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