"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentitySource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_verifiedpermissions_1 = require("aws-cdk-lib/aws-verifiedpermissions");
const core_1 = require("aws-cdk-lib/core");
class IdentitySourceBase extends core_1.Resource {
}
class IdentitySource extends IdentitySourceBase {
    /**
     * Creates Identity Source from its attributes
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs An `IdentitySourceAttributes` object.
     */
    static fromIdentitySourceAttributes(scope, id, attrs) {
        class Import extends IdentitySourceBase {
            constructor(identitySourceId) {
                super(scope, id);
                this.identitySourceId = identitySourceId;
            }
        }
        let identitySourceId;
        identitySourceId = attrs.identitySourceId;
        return new Import(identitySourceId);
    }
    /**
     * Create an Identity Source from its identifier
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param identitySourceId The Identity Source identifier.
     */
    static fromIdentitySourceId(scope, id, identitySourceId) {
        return IdentitySource.fromIdentitySourceAttributes(scope, id, {
            identitySourceId,
        });
    }
    constructor(scope, id, props) {
        super(scope, id);
        this.clientIds =
            props.configuration.cognitoUserPoolConfiguration.clientIds ?? [];
        this.userPoolArn =
            props.configuration.cognitoUserPoolConfiguration.userPool.userPoolArn;
        const cognitoGroupConfiguration = props.configuration.cognitoUserPoolConfiguration.groupConfiguration?.groupEntityType
            ? {
                groupEntityType: props.configuration.cognitoUserPoolConfiguration.groupConfiguration.groupEntityType,
            }
            : undefined;
        this.identitySource = new aws_verifiedpermissions_1.CfnIdentitySource(this, id, {
            configuration: {
                cognitoUserPoolConfiguration: {
                    clientIds: core_1.Lazy.list({ produce: () => this.clientIds }),
                    userPoolArn: this.userPoolArn,
                    groupConfiguration: cognitoGroupConfiguration,
                },
            },
            policyStoreId: props.policyStore.policyStoreId,
            principalEntityType: props.principalEntityType,
        });
        this.discoveryUrl = this.identitySource.attrDetailsDiscoveryUrl;
        this.identitySourceId = this.identitySource.attrIdentitySourceId;
        this.openIdIssuer = this.identitySource.attrDetailsOpenIdIssuer;
        this.policyStore = props.policyStore;
        this.cognitoGroupEntityType = cognitoGroupConfiguration?.groupEntityType;
    }
    /**
     * Add a User Pool Client
     *
     * @param userPoolClient The User Pool Client Construct.
     */
    addUserPoolClient(userPoolClient) {
        this.clientIds.push(userPoolClient.userPoolClientId);
    }
}
exports.IdentitySource = IdentitySource;
_a = JSII_RTTI_SYMBOL_1;
IdentitySource[_a] = { fqn: "@cdklabs/cdk-verified-permissions.IdentitySource", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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