# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel  
from typing import Dict, List



class CreateUserRequest(TeaModel):
    def __init__(
        self,
        username: str = None,
        phone_send_pwd: int = None,
        email_send_pwd: int = None,
        password: str = None,
        group_name: str = None,
        bandwidth: float = None,
        area_code: str = None,
        cell_phone: str = None,
        email: str = None,
        sms_auth: int = None,
        totp_auth: int = None,
        expire_time: int = None,
        enable_status: int = None,
        remark: str = None,
    ):
        # {"en":"username
        # 
        # Format: 2-32 characters, can contain Chinese, English, numbers and symbols @ . _ -\
        # 
        # This parameter must be specified.", "zh_CN":"用户名
        # 2-32个字符，支持中文、英文、数字和符号@._-\
        # 该参数必须指定"}
        self.username = username
        # {"en":"Whether to send the password to the user mobile, the default is 0
        # 0: Do not send
        # 1: send", "zh_CN":"是否发送密码给用户的手机，默认0
        # 0：不发送
        # 1：发送"}
        self.phone_send_pwd = phone_send_pwd
        # {"en":"Whether to send the password to the user&lsquo;s email, the default is 0
        # 0: Do not send
        # 1: send", "zh_CN":"是否发送密码给用户的邮箱，默认0
        # 0：不发送
        # 1：发送"}
        self.email_send_pwd = email_send_pwd
        # {"en":"If the parameter is  \"\" or null, it will be randomly generated by system.
        # If the parameter is not empty, it will be the password for user.
        # Format: 8-32 characters, including at least 3 types of uppercase letters, lowercase letters, numbers and punctuation marks", "zh_CN":"若传参为空或不传,则随机生成
        # 若传参不为空，则为预设密码
        # 8-32个字符，字母大写、字母小写、数字和标点符号至少包含3种"}
        self.password = password
        # {"en":"Parent group name.
        # If the request parameters do not contain this field or it is empty, the user will belongs the root deirectory group.", "zh_CN":"父组名称
        # 不传或空保存在根用户组下"}
        self.group_name = group_name
        # {"en":"Bandwidth limit.
        # If the parameters do not contains this field,it  will be 1/2 of maximum bandwidth limit.
        # If the value exceeds the maximum bandwidth,it  will be maximum bandwidth limit.", "zh_CN":"带宽限制
        # 不传参为 1/2{最大带宽}
        # 传参超过最大带宽，则为{最大带宽}"}
        self.bandwidth = bandwidth
        # {"en":"Area code
        # If the areaCode is null and when cellPhone is not null, areaCode  will be 86.", "zh_CN":"区号，手机号存在但区号不存在时会默认设置86"}
        self.area_code = area_code
        # {"en":"Mobile.When phoneSendPwd is equal to \"1\", this field cannnot be empty.", "zh_CN":"手机号；当phoneSendPwd=1时，不为空"}
        self.cell_phone = cell_phone
        # {"en":"Email.
        # When emailSendPwd is equal to \"1\", this field cannnot be empty.", "zh_CN":"邮箱
        # 当emailSendPwd=1时，不为空"}
        self.email = email
        # {"en":"MFA: message authentication, default 0
        # \"0\": off,
        # \"1\":  on", "zh_CN":"双因子认证 : 短信认证，默认0
        # 0 关闭， 1 开启"}
        self.sms_auth = sms_auth
        # {"en":"MFA: totp authentication, default 0
        # \"0\": off,
        # \"1\":  on", "zh_CN":"双因子认证 : totp认证，默认0
        # 0 关闭， 1 开启"}
        self.totp_auth = totp_auth
        # {"en":"Expiration time: pass timestamp, millisecond level
        # If the parameters do not contain the filed, it will be \"0\"
        # 0: never expire
        # 1626732871372: Set expiration time", "zh_CN":"过期时间，传时间戳，毫秒级别，不传为0
        # 0：永不过期
        # 1626732871372：设置过期时间"}
        self.expire_time = expire_time
        # {"en":"Whether to enable the user, do not pass the parameter to enable
        # 1: enable
        # 0: disable", "zh_CN":"是否启用用户，不传参为启用
        # 1:启用
        # 0:禁用"}
        self.enable_status = enable_status
        # {"en":"Note
        # Maximum length is 255 characters.", "zh_CN":"备注
        # 最大长度255个字符"}
        self.remark = remark

    def validate(self):
        self.validate_required(self.username, 'username')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        if self.phone_send_pwd is not None:
            result['phoneSendPwd'] = self.phone_send_pwd
        if self.email_send_pwd is not None:
            result['emailSendPwd'] = self.email_send_pwd
        if self.password is not None:
            result['password'] = self.password
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        if self.area_code is not None:
            result['areaCode'] = self.area_code
        if self.cell_phone is not None:
            result['cellPhone'] = self.cell_phone
        if self.email is not None:
            result['email'] = self.email
        if self.sms_auth is not None:
            result['smsAuth'] = self.sms_auth
        if self.totp_auth is not None:
            result['totpAuth'] = self.totp_auth
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.enable_status is not None:
            result['enableStatus'] = self.enable_status
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('phoneSendPwd') is not None:
            self.phone_send_pwd = m.get('phoneSendPwd')
        if m.get('emailSendPwd') is not None:
            self.email_send_pwd = m.get('emailSendPwd')
        if m.get('password') is not None:
            self.password = m.get('password')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        if m.get('areaCode') is not None:
            self.area_code = m.get('areaCode')
        if m.get('cellPhone') is not None:
            self.cell_phone = m.get('cellPhone')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('smsAuth') is not None:
            self.sms_auth = m.get('smsAuth')
        if m.get('totpAuth') is not None:
            self.totp_auth = m.get('totpAuth')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('enableStatus') is not None:
            self.enable_status = m.get('enableStatus')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class CreateUserResponseContent(TeaModel):
    def __init__(
        self,
        username: str = None,
        id: int = None,
        email: str = None,
        area_code: str = None,
        cell_phone: str = None,
        group_id: int = None,
        group_name: str = None,
        bandwidth: str = None,
        remark: str = None,
        expiration_time: int = None,
        enable_user: int = None,
        sms_auth: int = None,
        totp_auth: int = None,
        create_time: int = None,
    ):
        # {'en':'username', 'zh_CN':'用户名称'}
        self.username = username
        # {'en':'id', 'zh_CN':'用户id'}
        self.id = id
        # {'en':'email', 'zh_CN':'邮箱'}
        self.email = email
        # {'en':'areaCode', 'zh_CN':'区号'}
        self.area_code = area_code
        # {'en':'cellPhone', 'zh_CN':'手机号'}
        self.cell_phone = cell_phone
        # {'en':'groupId', 'zh_CN':'父组ID'}
        self.group_id = group_id
        # {'en':'groupName', 'zh_CN':'父组名称'}
        self.group_name = group_name
        # {'en':'bandwidth', 'zh_CN':'带宽'}
        self.bandwidth = bandwidth
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'expirationTime', 'zh_CN':'过期时间戳，0-永不过期'}
        self.expiration_time = expiration_time
        # {'en':'enableUser', 'zh_CN':'启用状态'}
        self.enable_user = enable_user
        # {'en':'smsAuth', 'zh_CN':'短信认证启用'}
        self.sms_auth = sms_auth
        # {'en':'totpAuth', 'zh_CN':'totp认证启用'}
        self.totp_auth = totp_auth
        # {'en':'createTime', 'zh_CN':'创建时间戳'}
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.username, 'username')
        self.validate_required(self.id, 'id')
        self.validate_required(self.email, 'email')
        self.validate_required(self.area_code, 'area_code')
        self.validate_required(self.cell_phone, 'cell_phone')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.expiration_time, 'expiration_time')
        self.validate_required(self.enable_user, 'enable_user')
        self.validate_required(self.sms_auth, 'sms_auth')
        self.validate_required(self.totp_auth, 'totp_auth')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        if self.id is not None:
            result['id'] = self.id
        if self.email is not None:
            result['email'] = self.email
        if self.area_code is not None:
            result['areaCode'] = self.area_code
        if self.cell_phone is not None:
            result['cellPhone'] = self.cell_phone
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        if self.remark is not None:
            result['remark'] = self.remark
        if self.expiration_time is not None:
            result['expirationTime'] = self.expiration_time
        if self.enable_user is not None:
            result['enableUser'] = self.enable_user
        if self.sms_auth is not None:
            result['smsAuth'] = self.sms_auth
        if self.totp_auth is not None:
            result['totpAuth'] = self.totp_auth
        if self.create_time is not None:
            result['createTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('areaCode') is not None:
            self.area_code = m.get('areaCode')
        if m.get('cellPhone') is not None:
            self.cell_phone = m.get('cellPhone')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('expirationTime') is not None:
            self.expiration_time = m.get('expirationTime')
        if m.get('enableUser') is not None:
            self.enable_user = m.get('enableUser')
        if m.get('smsAuth') is not None:
            self.sms_auth = m.get('smsAuth')
        if m.get('totpAuth') is not None:
            self.totp_auth = m.get('totpAuth')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        return self


class CreateUserResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: CreateUserResponseContent = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = CreateUserResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class CreateUserPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateUserParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateUserRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateUserResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ModifyGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        new_group_name: str = None,
        new_parent_group_name: str = None,
        remark: str = None,
    ):
        # {'en':'User group name
        # This parameter must be specified.', 'zh_CN':'用户组名称'}
        self.group_name = group_name
        # {'en':'new Group name.
        # The maximum length is 32 characters, and it can be the combination of English, Chinese, and numbers. It cannot contain /', 'zh_CN':'用户组名称
        # 最大长度32个字符，支持英文、中文、数字的组合，不可包含/\
        # 该参数必须指定'}
        self.new_group_name = new_group_name
        # {'en':'new Parent group name.
        # If the value is '', the group will belongs the root deirectory group.', 'zh_CN':'若传参为&ldquo;&rdquo;，则在根目录下'}
        self.new_parent_group_name = new_parent_group_name
        # {'en':'New note
        # Maximum length is 255 characters.', 'zh_CN':'新的备注
        # 最大长度255个字符
        # 不传不修改'}
        self.remark = remark

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.new_group_name is not None:
            result['newGroupName'] = self.new_group_name
        if self.new_parent_group_name is not None:
            result['newParentGroupName'] = self.new_parent_group_name
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('newGroupName') is not None:
            self.new_group_name = m.get('newGroupName')
        if m.get('newParentGroupName') is not None:
            self.new_parent_group_name = m.get('newParentGroupName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class ModifyGroupResponseContent(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        group_id: int = None,
        parent_group_name: str = None,
        parent_group_id: str = None,
        remark: str = None,
        create_time: int = None,
        update_time: int = None,
    ):
        # {'en':'groupName', 'zh_CN':'用户组名称'}
        self.group_name = group_name
        # {'en':'groupId', 'zh_CN':'用户组ID'}
        self.group_id = group_id
        # {'en':'parentGroupName', 'zh_CN':'父组名称'}
        self.parent_group_name = parent_group_name
        # {'en':'parentGroupID', 'zh_CN':'父组ID'}
        self.parent_group_id = parent_group_id
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'createTime', 'zh_CN':'创建时间'}
        self.create_time = create_time
        # {'en':'updateTime', 'zh_CN':'更新时间'}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.parent_group_name, 'parent_group_name')
        self.validate_required(self.parent_group_id, 'parent_group_id')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.parent_group_name is not None:
            result['parentGroupName'] = self.parent_group_name
        if self.parent_group_id is not None:
            result['parentGroupId'] = self.parent_group_id
        if self.remark is not None:
            result['remark'] = self.remark
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('parentGroupName') is not None:
            self.parent_group_name = m.get('parentGroupName')
        if m.get('parentGroupId') is not None:
            self.parent_group_id = m.get('parentGroupId')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class ModifyGroupResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: ModifyGroupResponseContent = None,
    ):
        # {'en':'Interface error code, '1' means success', 'zh_CN':'接口错误码，&ldquo;1&rdquo;代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = ModifyGroupResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class ModifyGroupPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ModifyGroupParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ModifyGroupRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ModifyGroupResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        parent_group_name: str = None,
        remark: str = None,
    ):
        # {'en':'Group name.
        # The maximum length is 32 characters, and it can be the combination of English, Chinese, and numbers. It cannot contain /\
        # This parameter must be specified.', 'zh_CN':'用户组名称
        # 最大长度32个字符，支持英文、中文、数字的组合，不可包含/\
        # 该参数必须指定'}
        self.group_name = group_name
        # {'en':'Parent group name.
        # If the request parameters do not contain this field or it is empty, the group will belongs the root deirectory group.', 'zh_CN':'若传参为空或不传，则在根目录下'}
        self.parent_group_name = parent_group_name
        # {'en':'Note
        # Maximum length is 255 characters.', 'zh_CN':'新的备注
        # 最大长度255个字符'}
        self.remark = remark

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.parent_group_name is not None:
            result['parentGroupName'] = self.parent_group_name
        if self.remark is not None:
            result['remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('parentGroupName') is not None:
            self.parent_group_name = m.get('parentGroupName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        return self


class CreateGroupResponseContent(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        group_id: int = None,
        parent_group_name: str = None,
        parent_group_id: str = None,
        remark: str = None,
        create_time: int = None,
        update_time: int = None,
    ):
        # {'en':'groupName', 'zh_CN':'用户组名称'}
        self.group_name = group_name
        # {'en':'groupId', 'zh_CN':'用户组ID'}
        self.group_id = group_id
        # {'en':'parentGroupName', 'zh_CN':'父组名称'}
        self.parent_group_name = parent_group_name
        # {'en':'parentGroupID', 'zh_CN':'父组ID'}
        self.parent_group_id = parent_group_id
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'createTime', 'zh_CN':'创建时间'}
        self.create_time = create_time
        # {'en':'updateTime', 'zh_CN':'更新时间'}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.parent_group_name, 'parent_group_name')
        self.validate_required(self.parent_group_id, 'parent_group_id')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.parent_group_name is not None:
            result['parentGroupName'] = self.parent_group_name
        if self.parent_group_id is not None:
            result['parentGroupId'] = self.parent_group_id
        if self.remark is not None:
            result['remark'] = self.remark
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('parentGroupName') is not None:
            self.parent_group_name = m.get('parentGroupName')
        if m.get('parentGroupId') is not None:
            self.parent_group_id = m.get('parentGroupId')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class CreateGroupResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: CreateGroupResponseContent = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = CreateGroupResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class CreateGroupPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateGroupParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateGroupRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateGroupResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DescribeUserInfoRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeUserInfoResponseContent(TeaModel):
    def __init__(
        self,
        username: str = None,
        id: int = None,
        email: str = None,
        area_code: str = None,
        cell_phone: str = None,
        group_id: int = None,
        group_name: str = None,
        bandwidth: str = None,
        remark: str = None,
        expiration_time: int = None,
        enable_user: int = None,
        sms_auth: int = None,
        totp_auth: int = None,
        vip: str = None,
        create_time: int = None,
    ):
        # {'en':'username', 'zh_CN':'用户名称'}
        self.username = username
        # {'en':'id', 'zh_CN':'用户id'}
        self.id = id
        # {'en':'email', 'zh_CN':'邮箱'}
        self.email = email
        # {'en':'areaCode', 'zh_CN':'区号'}
        self.area_code = area_code
        # {'en':'cellPhone', 'zh_CN':'手机号'}
        self.cell_phone = cell_phone
        # {'en':'groupId', 'zh_CN':'父组ID'}
        self.group_id = group_id
        # {'en':'groupName', 'zh_CN':'父组名称'}
        self.group_name = group_name
        # {'en':'bandwidth', 'zh_CN':'带宽'}
        self.bandwidth = bandwidth
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'expirationTime', 'zh_CN':'过期时间戳，0-永不过期'}
        self.expiration_time = expiration_time
        # {'en':'enableUser', 'zh_CN':'启用状态'}
        self.enable_user = enable_user
        # {'en':'smsAuth', 'zh_CN':'短信认证启用'}
        self.sms_auth = sms_auth
        # {'en':'totpAuth', 'zh_CN':'totp认证启用'}
        self.totp_auth = totp_auth
        # {'en':'virtual ip', 'zh_CN':'虚拟ip'}
        self.vip = vip
        # {'en':'createTime', 'zh_CN':'创建时间戳'}
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.username, 'username')
        self.validate_required(self.id, 'id')
        self.validate_required(self.email, 'email')
        self.validate_required(self.area_code, 'area_code')
        self.validate_required(self.cell_phone, 'cell_phone')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.expiration_time, 'expiration_time')
        self.validate_required(self.enable_user, 'enable_user')
        self.validate_required(self.sms_auth, 'sms_auth')
        self.validate_required(self.totp_auth, 'totp_auth')
        self.validate_required(self.vip, 'vip')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        if self.id is not None:
            result['id'] = self.id
        if self.email is not None:
            result['email'] = self.email
        if self.area_code is not None:
            result['areaCode'] = self.area_code
        if self.cell_phone is not None:
            result['cellPhone'] = self.cell_phone
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        if self.remark is not None:
            result['remark'] = self.remark
        if self.expiration_time is not None:
            result['expirationTime'] = self.expiration_time
        if self.enable_user is not None:
            result['enableUser'] = self.enable_user
        if self.sms_auth is not None:
            result['smsAuth'] = self.sms_auth
        if self.totp_auth is not None:
            result['totpAuth'] = self.totp_auth
        if self.vip is not None:
            result['vip'] = self.vip
        if self.create_time is not None:
            result['createTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('areaCode') is not None:
            self.area_code = m.get('areaCode')
        if m.get('cellPhone') is not None:
            self.cell_phone = m.get('cellPhone')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('expirationTime') is not None:
            self.expiration_time = m.get('expirationTime')
        if m.get('enableUser') is not None:
            self.enable_user = m.get('enableUser')
        if m.get('smsAuth') is not None:
            self.sms_auth = m.get('smsAuth')
        if m.get('totpAuth') is not None:
            self.totp_auth = m.get('totpAuth')
        if m.get('vip') is not None:
            self.vip = m.get('vip')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        return self


class DescribeUserInfoResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: DescribeUserInfoResponseContent = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = DescribeUserInfoResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class DescribeUserInfoPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeUserInfoParameters(TeaModel):
    def __init__(
        self,
        username: str = None,
    ):
        # {'en':'username', 'zh_CN':'用户名'}
        self.username = username

    def validate(self):
        self.validate_required(self.username, 'username')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DescribeUserInfoRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DescribeUserInfoResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
    ):
        # {'en':'User group name', 'zh_CN':'用户组名称'}
        self.group_name = group_name

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        return self


class DeleteGroupPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteGroupParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteGroupRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteGroupResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ModifyuserRequest(TeaModel):
    def __init__(
        self,
        username: str = None,
        group_name: str = None,
        area_code: str = None,
        cell_phone: str = None,
        sms_auth: int = None,
        totp_auth: int = None,
        email: str = None,
        expire_time: int = None,
        enable_status: int = None,
        remark: str = None,
        bandwidth: float = None,
    ):
        # {'en':'Username of the specific user.', 'zh_CN':'需要修改的用户'}
        self.username = username
        # {'en':'Parent group name', 'zh_CN':'父组名称'}
        self.group_name = group_name
        # {'en':'Area code
        # If the areaCode is null and when cellPhone is not null, areaCode  will be 86.', 'zh_CN':'区号，手机号存在但区号不存在时会默认设置86'}
        self.area_code = area_code
        # {'en':'Mobile', 'zh_CN':'手机号'}
        self.cell_phone = cell_phone
        # {'en':'MFA: message authentication, default 0
        # 0: off,
        # 1:  on', 'zh_CN':'双因子认证 : 短信认证，默认0
        # 0 关闭， 1 开启'}
        self.sms_auth = sms_auth
        # {'en':'MFA: totp authentication, default 0
        # 0: off,
        # 1:  on', 'zh_CN':'双因子认证 : totp认证，默认0
        # 0 关闭， 1 开启'}
        self.totp_auth = totp_auth
        # {'en':'Mail.', 'zh_CN':'邮箱'}
        self.email = email
        # {'en':'Expiration time, pass timestamp, millisecond level, do not pass as 0
        # 0: never expire
        # 1626732871372: Set expiration time', 'zh_CN':'过期时间，传时间戳，毫秒级别，不传为0
        # 0：永不过期
        # 1626732871372：设置过期时间'}
        self.expire_time = expire_time
        # {'en':'Whether to enable the user, do not pass the parameter to enable
        # 1: enable
        # 0: disable', 'zh_CN':'是否启用用户，不传参为启用
        # 1:启用
        # 0:禁用'}
        self.enable_status = enable_status
        # {'en':'New note
        # Maximum length is 255 characters.', 'zh_CN':'新的备注
        # 最大长度255个字符'}
        self.remark = remark
        # {'en':'Bandwidth limit
        # No parameter transmission is 1/2{max bandwidth}
        # If the parameter transmission exceeds the maximum bandwidth, it is {maximum bandwidth}', 'zh_CN':'带宽限制
        # 不传参为 1/2{最大带宽}
        # 传参超过最大带宽，则为{最大带宽}'}
        self.bandwidth = bandwidth

    def validate(self):
        self.validate_required(self.username, 'username')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.area_code is not None:
            result['areaCode'] = self.area_code
        if self.cell_phone is not None:
            result['cellPhone'] = self.cell_phone
        if self.sms_auth is not None:
            result['smsAuth'] = self.sms_auth
        if self.totp_auth is not None:
            result['totpAuth'] = self.totp_auth
        if self.email is not None:
            result['email'] = self.email
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.enable_status is not None:
            result['enableStatus'] = self.enable_status
        if self.remark is not None:
            result['remark'] = self.remark
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('areaCode') is not None:
            self.area_code = m.get('areaCode')
        if m.get('cellPhone') is not None:
            self.cell_phone = m.get('cellPhone')
        if m.get('smsAuth') is not None:
            self.sms_auth = m.get('smsAuth')
        if m.get('totpAuth') is not None:
            self.totp_auth = m.get('totpAuth')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('enableStatus') is not None:
            self.enable_status = m.get('enableStatus')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        return self


class ModifyuserResponseContent(TeaModel):
    def __init__(
        self,
        username: str = None,
        id: int = None,
        email: str = None,
        area_code: str = None,
        cell_phone: str = None,
        group_id: int = None,
        group_name: str = None,
        bandwidth: str = None,
        remark: str = None,
        expiration_time: int = None,
        enable_user: int = None,
        sms_auth: int = None,
        totp_auth: int = None,
        create_time: int = None,
    ):
        # {'en':'username', 'zh_CN':'用户名称'}
        self.username = username
        # {'en':'id', 'zh_CN':'用户id'}
        self.id = id
        # {'en':'email', 'zh_CN':'邮箱'}
        self.email = email
        # {'en':'areaCode', 'zh_CN':'区号'}
        self.area_code = area_code
        # {'en':'cellPhone', 'zh_CN':'手机号'}
        self.cell_phone = cell_phone
        # {'en':'groupId', 'zh_CN':'父组Id'}
        self.group_id = group_id
        # {'en':'groupName', 'zh_CN':'父组名称'}
        self.group_name = group_name
        # {'en':'bandwidth', 'zh_CN':'带宽'}
        self.bandwidth = bandwidth
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'expirationTime', 'zh_CN':'过期时间戳，0-永不过期'}
        self.expiration_time = expiration_time
        # {'en':'enableUser', 'zh_CN':'启用状态'}
        self.enable_user = enable_user
        # {'en':'smsAuth', 'zh_CN':'短信认证启用'}
        self.sms_auth = sms_auth
        # {'en':'totpAuth', 'zh_CN':'totp认证启用'}
        self.totp_auth = totp_auth
        # {'en':'createTime', 'zh_CN':'创建时间戳'}
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.username, 'username')
        self.validate_required(self.id, 'id')
        self.validate_required(self.email, 'email')
        self.validate_required(self.area_code, 'area_code')
        self.validate_required(self.cell_phone, 'cell_phone')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.expiration_time, 'expiration_time')
        self.validate_required(self.enable_user, 'enable_user')
        self.validate_required(self.sms_auth, 'sms_auth')
        self.validate_required(self.totp_auth, 'totp_auth')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        if self.id is not None:
            result['id'] = self.id
        if self.email is not None:
            result['email'] = self.email
        if self.area_code is not None:
            result['areaCode'] = self.area_code
        if self.cell_phone is not None:
            result['cellPhone'] = self.cell_phone
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        if self.remark is not None:
            result['remark'] = self.remark
        if self.expiration_time is not None:
            result['expirationTime'] = self.expiration_time
        if self.enable_user is not None:
            result['enableUser'] = self.enable_user
        if self.sms_auth is not None:
            result['smsAuth'] = self.sms_auth
        if self.totp_auth is not None:
            result['totpAuth'] = self.totp_auth
        if self.create_time is not None:
            result['createTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('areaCode') is not None:
            self.area_code = m.get('areaCode')
        if m.get('cellPhone') is not None:
            self.cell_phone = m.get('cellPhone')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('expirationTime') is not None:
            self.expiration_time = m.get('expirationTime')
        if m.get('enableUser') is not None:
            self.enable_user = m.get('enableUser')
        if m.get('smsAuth') is not None:
            self.sms_auth = m.get('smsAuth')
        if m.get('totpAuth') is not None:
            self.totp_auth = m.get('totpAuth')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        return self


class ModifyuserResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: ModifyuserResponseContent = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = ModifyuserResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class ModifyuserPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ModifyuserParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ModifyuserRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ModifyuserResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class SyncAuthConfigRequest(TeaModel):
    def __init__(
        self,
        auth_config_name: str = None,
    ):
        # {"en":"auth config name", "zh_CN":"身份源名称"}
        self.auth_config_name = auth_config_name

    def validate(self):
        self.validate_required(self.auth_config_name, 'auth_config_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_config_name is not None:
            result['authConfigName'] = self.auth_config_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authConfigName') is not None:
            self.auth_config_name = m.get('authConfigName')
        return self


class SyncAuthConfigResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
    ):
        # {"en":"Interface error code, 0-fail,1-success", "zh_CN":"接口错误码，0-代表失败，1-代表成功"}
        self.return_code = return_code
        # {"en":"Error message", "zh_CN":"错误信息"}
        self.return_msg = return_msg

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        return self


class SyncAuthConfigPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class SyncAuthConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class SyncAuthConfigRequestHeader(TeaModel):
    def __init__(
        self,
        auth_user: str = None,
    ):
        # {"en":"uac account name", "zh_CN":"当前企业的UAC主账号名"}
        self.auth_user = auth_user

    def validate(self):
        self.validate_required(self.auth_user, 'auth_user')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_user is not None:
            result['authUser'] = self.auth_user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('authUser') is not None:
            self.auth_user = m.get('authUser')
        return self


class SyncAuthConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteuserRequest(TeaModel):
    def __init__(
        self,
        username: str = None,
    ):
        # {'en':'username
        # This parameter must be specified.', 'zh_CN':'用户名
        # 该参数必须指定。'}
        self.username = username

    def validate(self):
        self.validate_required(self.username, 'username')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        return self


class DeleteuserResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        return self


class DeleteuserPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteuserParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteuserRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteuserResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListGroupsRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListGroupsResponseContentGroupList(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        group_id: int = None,
        parent_group_name: str = None,
        parent_group_id: str = None,
        auth_config_name: str = None,
        remark: str = None,
        create_time: int = None,
        update_time: int = None,
    ):
        # {'en':'groupName', 'zh_CN':'用户组名称'}
        self.group_name = group_name
        # {'en':'groupId', 'zh_CN':'用户组ID'}
        self.group_id = group_id
        # {'en':'parentGroupName', 'zh_CN':'父组名称'}
        self.parent_group_name = parent_group_name
        # {'en':'parentGroupID', 'zh_CN':'父组ID'}
        self.parent_group_id = parent_group_id
        # {'en':'authConfigName', 'zh_CN':'所属组织架构名称'}
        self.auth_config_name = auth_config_name
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'createTime', 'zh_CN':'创建时间'}
        self.create_time = create_time
        # {'en':'updateTime', 'zh_CN':'更新时间'}
        self.update_time = update_time

    def validate(self):
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.parent_group_name, 'parent_group_name')
        self.validate_required(self.parent_group_id, 'parent_group_id')
        self.validate_required(self.auth_config_name, 'auth_config_name')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.parent_group_name is not None:
            result['parentGroupName'] = self.parent_group_name
        if self.parent_group_id is not None:
            result['parentGroupId'] = self.parent_group_id
        if self.auth_config_name is not None:
            result['authConfigName'] = self.auth_config_name
        if self.remark is not None:
            result['remark'] = self.remark
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('parentGroupName') is not None:
            self.parent_group_name = m.get('parentGroupName')
        if m.get('parentGroupId') is not None:
            self.parent_group_id = m.get('parentGroupId')
        if m.get('authConfigName') is not None:
            self.auth_config_name = m.get('authConfigName')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class ListGroupsResponseContent(TeaModel):
    def __init__(
        self,
        group_list: List[ListGroupsResponseContentGroupList] = None,
    ):
        # {'en':'groupList', 'zh_CN':'group集合，下面为字段'}
        self.group_list = group_list

    def validate(self):
        self.validate_required(self.group_list, 'group_list')
        if self.group_list:
            for k in self.group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_list is not None:
            result['groupList'] = []
            for k in self.group_list:
                result['groupList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupList') is not None:
            self.group_list = []
            for k in m.get('groupList'):
                temp_model = ListGroupsResponseContentGroupList()
                self.group_list.append(temp_model.from_map(k))
        return self


class ListGroupsResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: ListGroupsResponseContent = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = ListGroupsResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class ListGroupsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListGroupsParameters(TeaModel):
    def __init__(
        self,
        group_name: str = None,
    ):
        # {'en':'Query all user groups under the specified parent group.
        # If the value is null, query all groups under the root directory group.', 'zh_CN':'查询指定父组下的所有用户组
        # 不填写时，查全部'}
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        return self


class ListGroupsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListGroupsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListUsersRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListUsersResponseContentResult(TeaModel):
    def __init__(
        self,
        username: str = None,
        id: int = None,
        email: str = None,
        area_code: str = None,
        cellphone: str = None,
        group_id: int = None,
        group_name: str = None,
        bandwidth: str = None,
        remark: str = None,
        expire_time: int = None,
        enable_status: int = None,
        sms_auth: int = None,
        totp_auth: int = None,
        vip: str = None,
        create_time: int = None,
    ):
        # {'en':'username', 'zh_CN':'用户名称'}
        self.username = username
        # {'en':'id', 'zh_CN':'用户id'}
        self.id = id
        # {'en':'email', 'zh_CN':'邮箱'}
        self.email = email
        # {'en':'areaCode', 'zh_CN':'区号'}
        self.area_code = area_code
        # {'en':'cellphone', 'zh_CN':'手机号'}
        self.cellphone = cellphone
        # {'en':'groupID', 'zh_CN':'父组ID'}
        self.group_id = group_id
        # {'en':'groupName', 'zh_CN':'父组名称'}
        self.group_name = group_name
        # {'en':'bandwidth', 'zh_CN':'带宽'}
        self.bandwidth = bandwidth
        # {'en':'remark', 'zh_CN':'备注'}
        self.remark = remark
        # {'en':'expireTime', 'zh_CN':'过期时间戳，0-永不过期'}
        self.expire_time = expire_time
        # {'en':'enableStatus', 'zh_CN':'启用状态,-1：禁用，0：启用但离线，2：启用且在线'}
        self.enable_status = enable_status
        # {'en':'smsAuth', 'zh_CN':'短信认证启用'}
        self.sms_auth = sms_auth
        # {'en':'totpAuth', 'zh_CN':'totp认证启用'}
        self.totp_auth = totp_auth
        # {'en':'virtual ip', 'zh_CN':'虚拟ip'}
        self.vip = vip
        # {'en':'createTime', 'zh_CN':'创建时间戳'}
        self.create_time = create_time

    def validate(self):
        self.validate_required(self.username, 'username')
        self.validate_required(self.id, 'id')
        self.validate_required(self.email, 'email')
        self.validate_required(self.area_code, 'area_code')
        self.validate_required(self.cellphone, 'cellphone')
        self.validate_required(self.group_id, 'group_id')
        self.validate_required(self.group_name, 'group_name')
        self.validate_required(self.bandwidth, 'bandwidth')
        self.validate_required(self.remark, 'remark')
        self.validate_required(self.expire_time, 'expire_time')
        self.validate_required(self.enable_status, 'enable_status')
        self.validate_required(self.sms_auth, 'sms_auth')
        self.validate_required(self.totp_auth, 'totp_auth')
        self.validate_required(self.vip, 'vip')
        self.validate_required(self.create_time, 'create_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.username is not None:
            result['username'] = self.username
        if self.id is not None:
            result['id'] = self.id
        if self.email is not None:
            result['email'] = self.email
        if self.area_code is not None:
            result['areaCode'] = self.area_code
        if self.cellphone is not None:
            result['cellphone'] = self.cellphone
        if self.group_id is not None:
            result['groupId'] = self.group_id
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.bandwidth is not None:
            result['bandwidth'] = self.bandwidth
        if self.remark is not None:
            result['remark'] = self.remark
        if self.expire_time is not None:
            result['expireTime'] = self.expire_time
        if self.enable_status is not None:
            result['enableStatus'] = self.enable_status
        if self.sms_auth is not None:
            result['smsAuth'] = self.sms_auth
        if self.totp_auth is not None:
            result['totpAuth'] = self.totp_auth
        if self.vip is not None:
            result['vip'] = self.vip
        if self.create_time is not None:
            result['createTime'] = self.create_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('username') is not None:
            self.username = m.get('username')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('email') is not None:
            self.email = m.get('email')
        if m.get('areaCode') is not None:
            self.area_code = m.get('areaCode')
        if m.get('cellphone') is not None:
            self.cellphone = m.get('cellphone')
        if m.get('groupId') is not None:
            self.group_id = m.get('groupId')
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('bandwidth') is not None:
            self.bandwidth = m.get('bandwidth')
        if m.get('remark') is not None:
            self.remark = m.get('remark')
        if m.get('expireTime') is not None:
            self.expire_time = m.get('expireTime')
        if m.get('enableStatus') is not None:
            self.enable_status = m.get('enableStatus')
        if m.get('smsAuth') is not None:
            self.sms_auth = m.get('smsAuth')
        if m.get('totpAuth') is not None:
            self.totp_auth = m.get('totpAuth')
        if m.get('vip') is not None:
            self.vip = m.get('vip')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        return self


class ListUsersResponseContent(TeaModel):
    def __init__(
        self,
        page_size: int = None,
        page_no: int = None,
        total_count: int = None,
        result: ListUsersResponseContentResult = None,
    ):
        # {'en':'pageSize', 'zh_CN':'输入时设置的每页行数'}
        self.page_size = page_size
        # {'en':'pageNo', 'zh_CN':'用户列表的页码'}
        self.page_no = page_no
        # {'en':'totalCount', 'zh_CN':'实例总数'}
        self.total_count = total_count
        # {'en':'result', 'zh_CN':'分页结果数据，下面为数据格式'}
        self.result = result

    def validate(self):
        self.validate_required(self.page_size, 'page_size')
        self.validate_required(self.page_no, 'page_no')
        self.validate_required(self.total_count, 'total_count')
        self.validate_required(self.result, 'result')
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.page_no is not None:
            result['pageNo'] = self.page_no
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        if self.result is not None:
            result['result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('pageNo') is not None:
            self.page_no = m.get('pageNo')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        if m.get('result') is not None:
            temp_model = ListUsersResponseContentResult()
            self.result = temp_model.from_map(m['result'])
        return self


class ListUsersResponse(TeaModel):
    def __init__(
        self,
        return_code: str = None,
        return_msg: str = None,
        content: ListUsersResponseContent = None,
    ):
        # {'en':'Interface error code, 0-fail,1-success', 'zh_CN':'接口错误码，0-代表失败，1-代表成功'}
        self.return_code = return_code
        # {'en':'Error message', 'zh_CN':'错误信息'}
        self.return_msg = return_msg
        # {'en':'content', 'zh_CN':'数据，下面全是数据的内容'}
        self.content = content

    def validate(self):
        self.validate_required(self.return_code, 'return_code')
        self.validate_required(self.return_msg, 'return_msg')
        self.validate_required(self.content, 'content')
        if self.content:
            self.content.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.return_code is not None:
            result['returnCode'] = self.return_code
        if self.return_msg is not None:
            result['returnMsg'] = self.return_msg
        if self.content is not None:
            result['content'] = self.content.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('returnCode') is not None:
            self.return_code = m.get('returnCode')
        if m.get('returnMsg') is not None:
            self.return_msg = m.get('returnMsg')
        if m.get('content') is not None:
            temp_model = ListUsersResponseContent()
            self.content = temp_model.from_map(m['content'])
        return self


class ListUsersPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListUsersParameters(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        page_no: int = None,
        page_size: int = None,
    ):
        # {'en':'Query all users under the specified parent group
        # If the value is null, query all users under the root directory group.', 'zh_CN':'查询指定父组下的所有用户
        # 不填写时，查全部'}
        self.group_name = group_name
        # {'en':'Page number of users list
        # Start value: 1
        # Default value: 1', 'zh_CN':'用户列表的页码
        # 起始值：1
        # 默认值：1'}
        self.page_no = page_no
        # {'en':'The number of rows per page set during pagination query. Value range: 1~50
        # Default value: 20', 'zh_CN':'分页查询时设置的每页行数。取值范围：1~50
        # 默认值：20'}
        self.page_size = page_size

    def validate(self):
        self.validate_required(self.group_name, 'group_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['groupName'] = self.group_name
        if self.page_no is not None:
            result['pageNo'] = self.page_no
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('groupName') is not None:
            self.group_name = m.get('groupName')
        if m.get('pageNo') is not None:
            self.page_no = m.get('pageNo')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        return self


class ListUsersRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListUsersResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self




