# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel  
from typing import Dict, List



class EditAccessSpeedLimitRequestAccessSpeedRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        limit_mode: str = None,
        start_size: str = None,
        start_time: str = None,
        start_speed: str = None,
        priority: str = None,
        speed: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *.", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The speed limit method can be limited by the start size (unit: KB) or the start time (unit: s), both of which are mutually exclusive
        # Allowed values: size/time.", "zh_CN":"限速方式，可按开始大小（单位KB）或开始时间（单位：s）限速，两者互斥
        # 允许值：size/time"}
        self.limit_mode = limit_mode
        # {"en":"Specify the number of bytes to start limiting, in KB, which means that the limit starts after a certain number of bytes, and 0 means no limit. When limit-mode is size, this item is required, and start-time is cleared.", "zh_CN":"开始限制字节，单位KB，从多少字节后开始限制，0表示不限制
        # limit-mode为size时，此项必填，start-time清空"}
        self.start_size = start_size
        # {"en":"Specifies how long the speed limit starts after the connection is established, the unit is S, 0 means no limit.
        # When the limit-mode is time, this item is required, and the start-size is cleared.", "zh_CN":"开始限制时间，单位S，从建连后多长时间后开始限制，0表示不限制
        # limit-mode为time时，此项必填，start-size清空"}
        self.start_time = start_time
        # {"en":"The rate before starting to limit, unit KB/S.", "zh_CN":"开始限制之前的速率，单位KB/S"}
        self.start_speed = start_speed
        # {"en":"fill in the integer, if match multiple entries, Large number has a high priority", "zh_CN":"优先级，填写整数，当配置多条时数字大的优先"}
        self.priority = priority
        # {"en":"Speed limit value, refers to the speed after the limit, stable speed, unit KB/S, -1 means no limit.", "zh_CN":"限速值，指限制之后的速率，稳定速率，单位KB/S"}
        self.speed = speed
        # {"en":"DataId is to indicate a specific group configuration when the client has multiple groups of configurations. dataId can be retrieved through a query interface. Note: A. If dataId is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with dataId and others are not, then the expression of dataId is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of dataId. C. If the dataId is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the dataId must be filled in, and the value is the actual dataId, which means clearing the value of the corresponding dataId configuration item; it is not allowed that there is no specific configuration item or dataId in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。本功能只支持一组配置。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改该组配置项内容； b、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； c、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.limit_mode, 'limit_mode')
        self.validate_required(self.speed, 'speed')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.limit_mode is not None:
            result['limit-mode'] = self.limit_mode
        if self.start_size is not None:
            result['start-size'] = self.start_size
        if self.start_time is not None:
            result['start-time'] = self.start_time
        if self.start_speed is not None:
            result['start-speed'] = self.start_speed
        if self.priority is not None:
            result['priority'] = self.priority
        if self.speed is not None:
            result['speed'] = self.speed
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('limit-mode') is not None:
            self.limit_mode = m.get('limit-mode')
        if m.get('start-size') is not None:
            self.start_size = m.get('start-size')
        if m.get('start-time') is not None:
            self.start_time = m.get('start-time')
        if m.get('start-speed') is not None:
            self.start_speed = m.get('start-speed')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('speed') is not None:
            self.speed = m.get('speed')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class EditAccessSpeedLimitRequest(TeaModel):
    def __init__(
        self,
        access_speed_rules: List[EditAccessSpeedLimitRequestAccessSpeedRules] = None,
    ):
        # {"en":"Access speed limit configuration
        # 1. This item is required when access speed limit is required
        # 2. Clear the configuration for blank access-speed-rules", "zh_CN":"访问限速配置
        # 1.需要访问限速时，此项必填
        # 2.只有空标签access-speed-rules时清空访问限速配置"}
        self.access_speed_rules = access_speed_rules

    def validate(self):
        self.validate_required(self.access_speed_rules, 'access_speed_rules')
        if self.access_speed_rules:
            for k in self.access_speed_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_speed_rules is not None:
            result['access-speed-rules'] = []
            for k in self.access_speed_rules:
                result['access-speed-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('access-speed-rules') is not None:
            self.access_speed_rules = []
            for k in m.get('access-speed-rules'):
                temp_model = EditAccessSpeedLimitRequestAccessSpeedRules()
                self.access_speed_rules.append(temp_model.from_map(k))
        return self


class EditAccessSpeedLimitResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Error code, which appears when HTTPStatus is not 202, represents the error type of the current request call", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response message, and shows as success when it is successful.", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditAccessSpeedLimitPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain you want to update, support domain id and domain name.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditAccessSpeedLimitParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditAccessSpeedLimitRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditAccessSpeedLimitResponseHeader(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        return self






class PredeployCompressionConfigRequestCompressionSettings(TeaModel):
    def __init__(
        self,
        compression_enabled: str = None,
        path_pattern: str = None,
        ignore_letter_case: str = None,
        file_types: List[str] = None,
        br_types: str = None,
    ):
        # {"en":"To enable compress setting, allowed true or false.", "zh_CN":"开启压缩响应功能：允许值为true和false"}
        self.compression_enabled = compression_enabled
        # {"en":"The url matching mode. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Whether to ignore letter case.", "zh_CN":"是否忽略大小写：允许值为true和false"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Define the file types to be compressed.  'text/' will be compressed by default.", "zh_CN":"配置需要压缩的文件类型，默认只对'text'文件类型压缩，配置为*时压缩任意文件类型"}
        self.file_types = file_types
        # {"en":"Use br compression.The allowed values are true and false.", "zh_CN":"是否使用br压缩：允许值为true和false"}
        self.br_types = br_types

    def validate(self):
        self.validate_required(self.compression_enabled, 'compression_enabled')
        self.validate_required(self.path_pattern, 'path_pattern')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compression_enabled is not None:
            result['compression-enabled'] = self.compression_enabled
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.file_types is not None:
            result['file-types'] = self.file_types
        if self.br_types is not None:
            result['br-types'] = self.br_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('compression-enabled') is not None:
            self.compression_enabled = m.get('compression-enabled')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('file-types') is not None:
            self.file_types = m.get('file-types')
        if m.get('br-types') is not None:
            self.br_types = m.get('br-types')
        return self


class PredeployCompressionConfigRequest(TeaModel):
    def __init__(
        self,
        compression_settings: PredeployCompressionConfigRequestCompressionSettings = None,
    ):
        # {"en":"Compress setting config", "zh_CN":"压缩响应功能配置
        # 1.需要设置压缩响应配置时，此项必填
        # 2.为<compression-settings/>空时清空压缩响应配置"}
        self.compression_settings = compression_settings

    def validate(self):
        self.validate_required(self.compression_settings, 'compression_settings')
        if self.compression_settings:
            self.compression_settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compression_settings is not None:
            result['compression-settings'] = self.compression_settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('compression-settings') is not None:
            temp_model = PredeployCompressionConfigRequestCompressionSettings()
            self.compression_settings = temp_model.from_map(m['compression-settings'])
        return self


class PredeployCompressionConfigResponse(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The id of the pre-deployed task against which you can query the progress and results of the pre-deployment", "zh_CN":"预部署任务的id，可以根据这个id查询预部署的进展和结果"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class PredeployCompressionConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class PredeployCompressionConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class PredeployCompressionConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class PredeployCompressionConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EnableOrDisableDMSprotectionRequest(TeaModel):
    def __init__(
        self,
        domain_names: List[str] = None,
        type: str = None,
    ):
        # {"en":"Domain names list, the parent tag.", "zh_CN":"开启/关闭Dms防护的域名列表， 父标签"}
        self.domain_names = domain_names
        # {"en":"1: Enable Dms protection; 0: Disable Dms  protection", "zh_CN":"1：开启Dms防护，0：关闭Dms防护"}
        self.type = type

    def validate(self):
        self.validate_required(self.domain_names, 'domain_names')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['domainNames'] = self.domain_names
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainNames') is not None:
            self.domain_names = m.get('domainNames')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class EnableOrDisableDMSprotectionResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"Error code. 0 message successful", "zh_CN":"错误代码。 0：成功"}
        self.code = code
        # {"en":"The response message. Response success when calling API successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"The body of return data.", "zh_CN":"返回体"}
        self.data = data

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EnableOrDisableDMSprotectionPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EnableOrDisableDMSprotectionParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EnableOrDisableDMSprotectionRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EnableOrDisableDMSprotectionResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditHttpHeaderConfigEditHttpHeaderConfigRequestHeaderModifyRules(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        path_pattern: str = None,
        except_path_pattern: str = None,
        custom_pattern: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        directory: str = None,
        specify_url: str = None,
        request_method: str = None,
        header_direction: str = None,
        action: str = None,
        allow_regexp: str = None,
        header_name: str = None,
        header_value: str = None,
        header_value_old: str = None,
        request_header: str = None,
        priority: str = None,
        except_file_type: str = None,
        except_directory: str = None,
        except_request_method: str = None,
        except_request_header: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # data-id可以通过查询接口获取。
        # 注意：添加grid类型标识：data-id，每一组配置对应一个data-id：
        # a、如果客户有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置；
        # c、如果客户入参都没有传data-id,表示用本次的配置全量覆盖原先配置；
        # d、如果客户入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置。（c、d内容和当前方案实现一致）；
        # e、一个gird标签下的入参不能为空，如果，没有具体的配置项，则data-id必填，且值为实际存在的data-id,表示清空这个data-id对应配置项的值；"}
        self.data_id = data_id
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Exception url matching pattern, support regular. Example: ", "zh_CN":"例外的url匹配模式，支持正则。 入参参考："}
        self.except_path_pattern = except_path_pattern
        # {"en":"Matching conditions: specify common types, optional values are all or homepage. 1. all: all files 2. homepage: home page", "zh_CN":"匹配条件：指定常用类型，可选值为all或homepage 1. all：全部文件 2. homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"Matching conditions: file type, please separate by semicolon, optional values: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts.", "zh_CN":"匹配条件：文件类型，多个请以英文;分隔，可选值：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts"}
        self.file_type = file_type
        # {"en":"Matching condition: Custom file type, separate by semicolon.", "zh_CN":"匹配条件：自定义文件类型，多个请以英文分号分隔。"}
        self.custom_file_type = custom_file_type
        # {"en":"Directory", "zh_CN":"目录"}
        self.directory = directory
        # {"en":"Matching Condition: Specify URL.
        # The input parameter does not support the URI format starting with http(s)://", "zh_CN":"匹配条件：指定URL
        # 入参不支持含http(s):// 开头的URI格式"}
        self.specify_url = specify_url
        # {"en":"The matching request method, the optional values are: GET, POST, PUT, HEAD, DELETE, OPTIONS, separate by semicolons.", "zh_CN":"匹配的请求方式，可选值为：GET、POST、PUT、HEAD、DELETE、OPTIONS，多个请以英文分号分隔"}
        self.request_method = request_method
        # {"en":"The control direction of the http header, the optional value is cache2visitor/cache2origin/visitor2cache/origin2cache, single-select.
        # Cache2origin refers to the source direction---corresponding to the configuration item return source request;
        # Cache2visitor refers to the direction of the client back - the corresponding configuration item returns to the client response;
        # Visitor2cache refers to receiving client requests
        # Origin2cache refers to the receiving source response", "zh_CN":"http头的控制方向，可选值为cache2visitor/cache2origin/visitor2cache/origin2cache，单选。
        # cache2origin是指回源方向---对应配置项回源请求；
        # cache2visitor是指回客户端方向—对应配置项回客户端应答；
        # visitor2cache是指接收客户端请求
        # origin2cache是指接收源应答
        # 配置接收源应答方向，添加非CACHE control头，无法传递给客户端"}
        self.header_direction = header_direction
        # {"en":"The control type of the http header supports the addition and deletion of the http header value. The optional value is add|set|delete, which is single-selected. Corresponding to the header-name and header-value parameters.
        # 1. Add: add a header
        # 2. Set: modify the header value
        # 3. Delete: delete the header
        # Note: priority is delete > set > add", "zh_CN":"http头的控制类型，支持http头部的增删改，可选值为add|set|delete，单选。对应header-name、header-value参数
        # 1. add：表示新增一个头部，头部名称为header-name，头部值为header-value
        # 2. set：表示修改指定头部header-name的值为header-value
        # 3. delete：表示删除头部，header-name可同时配置多个
        # 注意：优先级delete>set>add。当源站有对应响应头，则按源站响应的头部响应给客户端，此处新增的无效。"}
        self.action = action
        # {"en":"Http header regular match, optional value: true / false.
        # True: indicates that the value of the header-name is handled as a regular match.
        # False: indicates that the value of the header-name is processed according to the actual parameters, and no regular match is made.
        # Do not pass the default is false", "zh_CN":"http头正则匹配，可选值：true/false。
        # true：表示对header-name的值按正则匹配方式处理
        # false:表示对header-name的值按实际入参处理，不做正则匹配。
        # 不传默认是false"}
        self.allow_regexp = allow_regexp
        # {"en":"Http header name, add or modify the http header, only one is allowed; delete the http header to allow multiple entries, separated by a semicolon ';'.
        # Note: The operation of the special http header is limited, and the http header and operation type of the operation are allowed.
        # This item is required and cannot be empty
        # When the action is add: indicates that the header-name header is added.
        # When the action is set: modify the header-name header
        # When the action is delete: delete the header-name header", "zh_CN":"http头名称，新增或修改http头，只允许输入一个；删除http头允许输入多个，以分号“;”隔开。
        # 1.当action为add：表示新增这个header-name头部
        # 2.当action为set：修改这个header-name头部的值
        # 3.当action为delete：删除这个header-name头部
        #   
        # 注意：对特殊http头的操作是受限的，允许操作的http头及操作类型请参看【概览】-【附件2： header操作】"}
        self.header_name = header_name
        # {"en":"The value corresponding to the HTTP header field, for example: mytest.example.com
        # Note:
        # 1. When the action is add or set, the input parameter must be passed a value
        # 2. When the action is delete, the input parameter is not passed
        # Support to get the value of specified variable by keyword, such as client IP, including:
        # Key words: meaning
        # #timestamp: current time, timestamp as 1559124945
        # #request-host: host in the request header
        # #request-url: request url, which contains the full path of the protocol domain name, etc., such as http://aaa.aa.com/a.html
        # #request-uri: request uri, relative path format, such as /index.html
        # #origin- IP: return source IP
        # #cache-ip: edge node IP
        # #server-ip: external service IP
        # #client-ip: client IP, or visitor IP
        # #response-header{XXX} : get the value in the response header, such as #response-header{etag}, get the etag value in response-header 
        # #header{XXX} : to get the value in the HTTP header of the request, such as #header{user-agent}, is to get the user-agent value in the header
        # #cookie{XXX} : get the value in the cookie, such as #cookie{account}, is to get the value of the account set in the cookie", "zh_CN":"http头域对应的值，例如：mytest.example.com 
        # 注意：
        # 1. 当action为add或set时，该入参必须传值
        # 2. 当action为delete时，该入参不用传
        # 支持通过关键字获取指定变量值，如客户端ip，包含如下：
        # 关键字：含义
        # #timestamp：当前时间，时间戳如1559124945
        # #request-host：请求头中的HOST
        # #request-url：请求url，包含协议域名等的全路径，如http://aaa.aa.com/a.html
        # #request-uri：请求uri，相对路径格式，如/index.html
        # #origin-ip：回源IP
        # #cache-ip：边缘节点IP
        # #server-ip：对外服务IP
        # #client-ip：客户端IP，即访客IP
        # #response-header{xxx}：获取响应头中的值，如#response-header{etag}，获取response-header中的etag值
        # #header{xxx}：获取请求的http header中的值，如#header{User-Agent}，是获取header中的User-Agent值
        # #cookie{xxx}：获取cookie中的值，如#cookie{account}，是获取cookie中设置的account的值  "}
        self.header_value = header_value
        # {"en":"The original value corresponding to the HTTP header field","zh_CN":"http头域对应的原始值"}
        self.header_value_old = header_value_old
        # {"en":"Match request header, header values support regular, header and header values separated by Spaces, e.g. : Range bytes=[0-9]{9,}", "zh_CN":"2匹配请求头，头部值支持正则，头和头部值用空格隔开，如：Range bytes=[0-9]{9,}"}
        self.request_header = request_header
        # {"en":"Indicates the priority of execution order for multiple sets of configurations. A higher number indicates higher priority. If no parameters are passed, the default value is 10 and cannot be cleared.", "zh_CN":"表示客户多组配置的优先执行顺序。数字越大，优先级越高。 不传参默认为10，不可清空"}
        self.priority = priority
        # {"en":"Exception file type.", "zh_CN":"例外的文件类型"}
        self.except_file_type = except_file_type
        # {"en":"Exception directory.", "zh_CN":"例外的目录"}
        self.except_directory = except_directory
        # {"en":"Exception request method.", "zh_CN":"例外的请求方式"}
        self.except_request_method = except_request_method
        # {"en":"Exception request header.", "zh_CN":"例外的请求头"}
        self.except_request_header = except_request_header

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.file_type is not None:
            result['file-type'] = self.file_type
        if self.custom_file_type is not None:
            result['custom-file-type'] = self.custom_file_type
        if self.directory is not None:
            result['directory'] = self.directory
        if self.specify_url is not None:
            result['specify-url'] = self.specify_url
        if self.request_method is not None:
            result['request-method'] = self.request_method
        if self.header_direction is not None:
            result['header-direction'] = self.header_direction
        if self.action is not None:
            result['action'] = self.action
        if self.allow_regexp is not None:
            result['allow-regexp'] = self.allow_regexp
        if self.header_name is not None:
            result['header-name'] = self.header_name
        if self.header_value is not None:
            result['header-value'] = self.header_value
        if self.header_value_old is not None:
            result['header-value-old'] = self.header_value_old
        if self.request_header is not None:
            result['request-header'] = self.request_header
        if self.priority is not None:
            result['priority'] = self.priority
        if self.except_file_type is not None:
            result['except-file-type'] = self.except_file_type
        if self.except_directory is not None:
            result['except-directory'] = self.except_directory
        if self.except_request_method is not None:
            result['except-request-method'] = self.except_request_method
        if self.except_request_header is not None:
            result['except-request-header'] = self.except_request_header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('file-type') is not None:
            self.file_type = m.get('file-type')
        if m.get('custom-file-type') is not None:
            self.custom_file_type = m.get('custom-file-type')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('specify-url') is not None:
            self.specify_url = m.get('specify-url')
        if m.get('request-method') is not None:
            self.request_method = m.get('request-method')
        if m.get('header-direction') is not None:
            self.header_direction = m.get('header-direction')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('allow-regexp') is not None:
            self.allow_regexp = m.get('allow-regexp')
        if m.get('header-name') is not None:
            self.header_name = m.get('header-name')
        if m.get('header-value') is not None:
            self.header_value = m.get('header-value')
        if m.get('header-value-old') is not None:
            self.header_value_old = m.get('header-value-old')
        if m.get('request-header') is not None:
            self.request_header = m.get('request-header')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('except-file-type') is not None:
            self.except_file_type = m.get('except-file-type')
        if m.get('except-directory') is not None:
            self.except_directory = m.get('except-directory')
        if m.get('except-request-method') is not None:
            self.except_request_method = m.get('except-request-method')
        if m.get('except-request-header') is not None:
            self.except_request_header = m.get('except-request-header')
        return self


class EditHttpHeaderConfigRequest(TeaModel):
    def __init__(
        self,
        header_modify_rules: List[EditHttpHeaderConfigEditHttpHeaderConfigRequestHeaderModifyRules] = None,
    ):
        # {"en":"Http header settings
        # note:
        # 1. When you need to cancel the http header setting, you can pass in the empty node <header-modify-rules></header-modify-rules>.
        # 2. indicating that you need to set the http header, this field is required", "zh_CN":"http头设置
        # 注意：
        # 1. 需要取消http头设置时，可以传入空节点<header-modify-rules></header-modify-rules>。
        # 2. 表示需要设置http头，此项必填"}
        self.header_modify_rules = header_modify_rules

    def validate(self):
        self.validate_required(self.header_modify_rules, 'header_modify_rules')
        if self.header_modify_rules:
            for k in self.header_modify_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header_modify_rules is not None:
            result['header-modify-rules'] = []
            for k in self.header_modify_rules:
                result['header-modify-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('header-modify-rules') is not None:
            self.header_modify_rules = []
            for k in m.get('header-modify-rules'):
                temp_model = EditHttpHeaderConfigEditHttpHeaderConfigRequestHeaderModifyRules()
                self.header_modify_rules.append(temp_model.from_map(k))
        return self


class EditHttpHeaderConfigResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        location: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The URL used to access the domain information, where domain-id is the unique token generated by our cloud platform for the domain name and whose value is a string.", "zh_CN":"用于访问该域名信息的URL，其中domain-id为我司云平台为该域名生成的唯一标示，其值为字符串。"}
        self.location = location
        # {"en":"Error code, which appears when HTTPStatus is not 202, represents the error type of the current request call", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.location, 'location')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.location is not None:
            result['location'] = self.location
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditHttpHeaderConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditHttpHeaderConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditHttpHeaderConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditHttpHeaderConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateScreenshotConfigurationRequestScreenshotRules(TeaModel):
    def __init__(
        self,
        screenshot_enabled: bool = None,
        space_name: str = None,
        interval: int = None,
        width: int = None,
        high: int = None,
        overwrite: str = None,
        notice_address: str = None,
        publish_points: List[str] = None,
        data_id: int = None,
    ):
        # {"en":"If screenshot is enabled, the values of [true] and [false] are optional.If true, spaceName is required, and if false, other configuration items will be cleared with invalid arguments.", "zh_CN":"是否开启截图，可选值为true、false
        # 为true时，spaceName必填；
        # 为false时，其他配置项会被清空，且入参无效"}
        self.screenshot_enabled = screenshot_enabled
        # {"en":"Screenshot space name, this must be filled when screenshot is opened.", "zh_CN":"截图空间名，开启截图时，此项必填"}
        self.space_name = space_name
        # {"en":"Screenshot interval. This is required when screenshot is enabled.When configured, it must be >=5s, for example, 30, which means taking screenshots every 30s.", "zh_CN":"截图时间间隔，单位秒（s）；开启截图时，此项必填。配置时，必须>=5s。例如30，表示间隔30s截图一次。"}
        self.interval = interval
        # {"en":"Screenshot width resolution, not in the original resolution;Exceeding the original resolution also according to the original resolution.Note: the value should be <=2560.", "zh_CN":"截图宽度分辨率，未传入则按原始分辨率；超过原始分辨率也按原始分辨率。注：值要<=2560。"}
        self.width = width
        # {"en":"Screenshot height resolution, not in the original resolution;Exceeding the original resolution also according to the original resolution.Note: the value should be <=1440.", "zh_CN":"截图高度分辨率，未传入则按原始分辨率；超过原始分辨率也按原始分辨率。注：值要<=1440。"}
        self.high = high
        # {"en":"The optional values to override storage are true, false, true for override, and false for not override.When opening screenshot, this item must be filled in.", "zh_CN":"是否覆盖存储，可选值为true、false，true为覆盖，false为不覆盖。开启截图时，此项必填。
        # 注意：
        # 1.开启截图时，此项必填
        # 2.覆盖存储时，文件命名格式为“流名”
        # 3.非覆盖存储时，文件命名格式为“流名-时间戳”"}
        self.overwrite = overwrite
        # {"en":"Callback notification address, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；
        # 回调通知地址，url格式"}
        self.notice_address = notice_address
        # {"en":"Setting publish point of pull push domain. This is parent Tag.
        # example:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.screenshot_enabled is not None:
            result['screenshotEnabled'] = self.screenshot_enabled
        if self.space_name is not None:
            result['spaceName'] = self.space_name
        if self.interval is not None:
            result['interval'] = self.interval
        if self.width is not None:
            result['width'] = self.width
        if self.high is not None:
            result['high'] = self.high
        if self.overwrite is not None:
            result['overwrite'] = self.overwrite
        if self.notice_address is not None:
            result['noticeAddress'] = self.notice_address
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('screenshotEnabled') is not None:
            self.screenshot_enabled = m.get('screenshotEnabled')
        if m.get('spaceName') is not None:
            self.space_name = m.get('spaceName')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('high') is not None:
            self.high = m.get('high')
        if m.get('overwrite') is not None:
            self.overwrite = m.get('overwrite')
        if m.get('noticeAddress') is not None:
            self.notice_address = m.get('noticeAddress')
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class UpdateScreenshotConfigurationRequest(TeaModel):
    def __init__(
        self,
        screenshot_rules: List[UpdateScreenshotConfigurationRequestScreenshotRules] = None,
    ):
        # {"en":"Screenshot Configuration, parent node
        # 1. When you need to use the screenshot function, this must be filled in.
        # 2. Configuration of clearing for <screenshotRules/>.", "zh_CN":"截图配置，父标签
        # 1.需要设置截图配置时，此项必填
        # 2.为<screenshotRules/>时清空配置
        # 3.只支持jpg格式的截图"}
        self.screenshot_rules = screenshot_rules

    def validate(self):
        if self.screenshot_rules:
            for k in self.screenshot_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.screenshot_rules is not None:
            result['screenshotRules'] = []
            for k in self.screenshot_rules:
                result['screenshotRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('screenshotRules') is not None:
            self.screenshot_rules = []
            for k in m.get('screenshotRules'):
                temp_model = UpdateScreenshotConfigurationRequestScreenshotRules()
                self.screenshot_rules.append(temp_model.from_map(k))
        return self


class UpdateScreenshotConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"The error code", "zh_CN":"错误码"}
        self.code = code
        # {"en":"The message body", "zh_CN":"消息体"}
        self.message = message
        # {"en":"Returns the body of the data.", "zh_CN":"返回数据体。"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateScreenshotConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class UpdateScreenshotConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateScreenshotConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateScreenshotConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateIpVersionConfigRequest(TeaModel):
    def __init__(
        self,
        ip_version: List[str] = None,
    ):
        # {"en":"1: Update DNS region IP version, optional values: V4, V6", "zh_CN":"可选值为V4，V6。新增域名时，默认是使用IPV4。可以开启V6协议。
        # 示例：
        # \"ipVersion\":[\"V4\",\"V6\"]，表示全球使用V4和V6资源。
        # \"ipVersion\":[\"V4\"]，表示全球使用V4资源。
        # \"ipVersion\":[\"V6\"]，表示全球使用V6资源。"}
        self.ip_version = ip_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_version is not None:
            result['ipVersion'] = self.ip_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipVersion') is not None:
            self.ip_version = m.get('ipVersion')
        return self


class UpdateIpVersionConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        http_status: int = None,
        data: str = None,
    ):
        # {"en":"Error code. 0: successful", "zh_CN":"错误代码。 0：成功"}
        self.code = code
        # {"en":"The response message. Response 'Success' when calling API successful.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"The body of return data.", "zh_CN":"返回体数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.http_status is not None:
            result['httpStatus'] = self.http_status
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('httpStatus') is not None:
            self.http_status = m.get('httpStatus')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateIpVersionConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class UpdateIpVersionConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateIpVersionConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateIpVersionConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class PushNotifyAddressRequest(TeaModel):
    def __init__(
        self,
        notify_address: str = None,
    ):
        # {"en":"push notify address", "zh_CN":"推送地址"}
        self.notify_address = notify_address

    def validate(self):
        self.validate_required(self.notify_address, 'notify_address')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_address is not None:
            result['notifyAddress'] = self.notify_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('notifyAddress') is not None:
            self.notify_address = m.get('notifyAddress')
        return self


class PushNotifyAddressResponse(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class PushNotifyAddressPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class PushNotifyAddressParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class PushNotifyAddressRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class PushNotifyAddressResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainOriginsRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainOriginsResponseDataOriginsServers(TeaModel):
    def __init__(
        self,
        address: str = None,
        priority: int = None,
        weight: int = None,
        origin_host: str = None,
    ):
        # {"en":"Address", "zh_CN":"源站地址"}
        self.address = address
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"Weight", "zh_CN":"权重"}
        self.weight = weight
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host

    def validate(self):
        self.validate_required(self.address, 'address')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.weight, 'weight')
        self.validate_required(self.origin_host, 'origin_host')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.priority is not None:
            result['priority'] = self.priority
        if self.weight is not None:
            result['weight'] = self.weight
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        return self


class QueryLiveDomainOriginsResponseDataOrigins(TeaModel):
    def __init__(
        self,
        servers: List[QueryLiveDomainOriginsResponseDataOriginsServers] = None,
        round_robin: bool = None,
        origin_host: str = None,
    ):
        # {"en":"Servers", "zh_CN":"源站主机对象"}
        self.servers = servers
        # {"en":"Upstream Polling Enable Control", "zh_CN":"多个server默认主备"}
        self.round_robin = round_robin
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host

    def validate(self):
        self.validate_required(self.servers, 'servers')
        if self.servers:
            for k in self.servers:
                if k:
                    k.validate()
        self.validate_required(self.round_robin, 'round_robin')
        self.validate_required(self.origin_host, 'origin_host')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.servers is not None:
            result['servers'] = []
            for k in self.servers:
                result['servers'].append(k.to_map() if k else None)
        if self.round_robin is not None:
            result['roundRobin'] = self.round_robin
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('servers') is not None:
            self.servers = []
            for k in m.get('servers'):
                temp_model = QueryLiveDomainOriginsResponseDataOriginsServers()
                self.servers.append(temp_model.from_map(k))
        if m.get('roundRobin') is not None:
            self.round_robin = m.get('roundRobin')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        return self


class QueryLiveDomainOriginsResponseData(TeaModel):
    def __init__(
        self,
        origin_address: str = None,
        origin_host: str = None,
        origin_protocol: str = None,
        origin_port: int = None,
        enable_https: bool = None,
        client_ip_header: str = None,
        advanced_origins: bool = None,
        origins: QueryLiveDomainOriginsResponseDataOrigins = None,
    ):
        # {"en":"Origin Address", "zh_CN":"普通源"}
        self.origin_address = origin_address
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host
        # {"en":"Origin Protocol", "zh_CN":"回源协议"}
        self.origin_protocol = origin_protocol
        # {"en":"Origin Port", "zh_CN":"回源端口"}
        self.origin_port = origin_port
        # {"en":"Enable Https", "zh_CN":"是否通过HTTPS回源，只支持HDL协议"}
        self.enable_https = enable_https
        # {"en":"Client IP Header", "zh_CN":"传递客户端IP头"}
        self.client_ip_header = client_ip_header
        # {"en":"Enable Advanced Origins", "zh_CN":"是否启用高级源"}
        self.advanced_origins = advanced_origins
        # {"en":"Advanced Origins", "zh_CN":"高级源"}
        self.origins = origins

    def validate(self):
        self.validate_required(self.origin_address, 'origin_address')
        self.validate_required(self.origin_host, 'origin_host')
        self.validate_required(self.origin_protocol, 'origin_protocol')
        self.validate_required(self.origin_port, 'origin_port')
        self.validate_required(self.enable_https, 'enable_https')
        self.validate_required(self.client_ip_header, 'client_ip_header')
        self.validate_required(self.advanced_origins, 'advanced_origins')
        self.validate_required(self.origins, 'origins')
        if self.origins:
            self.origins.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_address is not None:
            result['originAddress'] = self.origin_address
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        if self.origin_protocol is not None:
            result['originProtocol'] = self.origin_protocol
        if self.origin_port is not None:
            result['originPort'] = self.origin_port
        if self.enable_https is not None:
            result['enableHttps'] = self.enable_https
        if self.client_ip_header is not None:
            result['clientIpHeader'] = self.client_ip_header
        if self.advanced_origins is not None:
            result['advancedOrigins'] = self.advanced_origins
        if self.origins is not None:
            result['origins'] = self.origins.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('originAddress') is not None:
            self.origin_address = m.get('originAddress')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        if m.get('originProtocol') is not None:
            self.origin_protocol = m.get('originProtocol')
        if m.get('originPort') is not None:
            self.origin_port = m.get('originPort')
        if m.get('enableHttps') is not None:
            self.enable_https = m.get('enableHttps')
        if m.get('clientIpHeader') is not None:
            self.client_ip_header = m.get('clientIpHeader')
        if m.get('advancedOrigins') is not None:
            self.advanced_origins = m.get('advancedOrigins')
        if m.get('origins') is not None:
            temp_model = QueryLiveDomainOriginsResponseDataOrigins()
            self.origins = temp_model.from_map(m['origins'])
        return self


class QueryLiveDomainOriginsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainOriginsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainOriginsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainOriginsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainOriginsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainOriginsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainOriginsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryHttpHeaderConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttpHeaderConfigQueryHttpHeaderConfigResponseHeaderModifyRules(TeaModel):
    def __init__(
        self,
        except_path_pattern: str = None,
        custom_pattern: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        directory: str = None,
        specify_url: str = None,
        request_method: str = None,
        data_id: int = None,
        path_pattern: str = None,
        header_direction: str = None,
        action: str = None,
        allow_regexp: str = None,
        header_name: str = None,
        header_value: str = None,
        header_value_old: str = None,
        reques_header: str = None,
        priority: str = None,
        except_file_type: str = None,
        except_directory: str = None,
        except_request_method: str = None,
        except_request_header: str = None,
    ):
        # {"en":"Exception url matching pattern, support regular. Example: ", "zh_CN":"例外的url匹配模式，支持正则。 入参参考："}
        self.except_path_pattern = except_path_pattern
        # {"en":"Matching conditions: specify common types, optional values are all or homepage. 1. all: all files 2. homepage: home page", "zh_CN":"匹配条件：指定常用类型，可选值为all或homepage 1、all：全部文件 2、homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"Matching conditions: file type, please separate by semicolon, optional values: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts.", "zh_CN":"匹配条件：文件类型，多个请以英文;分隔，可选值：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts"}
        self.file_type = file_type
        # {"en":"Matching condition: Custom file type, separate by semicolon.", "zh_CN":"匹配条件：自定义文件类型，多个请以英文分号分隔。"}
        self.custom_file_type = custom_file_type
        # {"en":"directory", "zh_CN":"目录"}
        self.directory = directory
        # {"en":"Matching Condition: Specify URL. The input parameter does not support the URI format starting with http(s)://", "zh_CN":"匹配条件：指定URL 入参不支持含http(s):// 开头的URI格式"}
        self.specify_url = specify_url
        # {"en":"The matching request method, the optional values are: GET, POST, PUT, HEAD, DELETE, OPTIONS, separate by semicolons.", "zh_CN":"匹配的请求方式，可选值为：GET、POST、PUT、HEAD、DELETE、OPTIONS，多个请以英文分号分隔"}
        self.request_method = request_method
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置"}
        self.data_id = data_id
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The control direction of the http header, the optional value is cache2visitor/cache2origin/visitor2cache/origin2cache, single-select.
        # Cache2origin refers to the source direction---corresponding to the configuration item return source request;
        # Cache2visitor refers to the direction of the client back - the corresponding configuration item returns to the client response;
        # Visitor2cache refers to receiving client requests
        # Origin2cache refers to the receiving source response", "zh_CN":"http头的控制方向，可选值为cache2visitor/cache2origin/visitor2cache/origin2cache，单选。&nbsp;
        # cache2origin是指回源方向---对应配置项回源请求；&nbsp;
        # cache2visitor是指回客户端方向&mdash;对应配置项回客户端应答；
        # visitor2cache是指接收客户端请求
        # origin2cache是指接收源应答"}
        self.header_direction = header_direction
        # {"en":"The control type of the http header supports the addition and deletion of the http header value. The optional value is add|set|delete, which is single-selected. Corresponding to the header-name and header-value parameters
        # Add: add a header
        # Set: modify the header
        # Delete: delete the header
        # Note: priority is delete>set>add", "zh_CN":"http头的控制类型，支持http头部值的增改删，可选值为add|delete|set，单选。对应header-name、header-value参数
        # add：新增头部
        # set：修改头部
        # delete：删除头部
        # 注意：优先级顺序为delete>set>add"}
        self.action = action
        # {"en":"Http header regular match, optional value: true / false.
        # True: indicates that the value of the header-name is handled as a regular match.
        # False: indicates that the value of the header-name is processed according to the actual parameters, and no regular match is made.
        # Do not pass the default is false", "zh_CN":"http头正则匹配，可选值：true/false。
        # true：表示对header-name的值按正则匹配方式处理
        # false:表示对header-name的值按实际入参处理，不做正则匹配。
        # 不传默认是false"}
        self.allow_regexp = allow_regexp
        # {"en":"Http header name, add or modify the http header, only one is allowed; delete the http header to allow multiple entries, separated by a semicolon ';'.
        # Note: The operation of the special http header is limited, and the http header and operation type of the operation are allowed.
        # This item is required and cannot be empty
        # When the action is add: indicates that the header-name header is added.
        # When the action is set: modify the header-name header
        # When the action is delete: delete the header-name header", "zh_CN":"http头名称，新增或修改http头，只允许输入一个；删除http头允许输入多个，以分号&ldquo;;&rdquo;隔开。
        # 注意：对特殊http头的操作是受限的，允许操作的http头及操作类型参看
        # 此项为必填项，不能为空
        # 当action为add：表示新增这个header-name头部
        # 当action为set：修改这个header-name头部
        # 当action为delete：删除这个header-name头部"}
        self.header_name = header_name
        # {"en":"The value corresponding to the HTTP header field, for example: mytest.example.com
        # 
        # Note:
        # 
        # 1. When the action is add or set, the input parameter must be passed a value
        # 
        # 2. When the action is delete, the input parameter is not passed
        # 
        # Support to get the value of specified variable by keyword, such as client IP, including:
        # 
        # Key words: meaning
        # 
        # #timestamp: current time, timestamp as 1559124945
        # #request-host: host in the request header
        # #request-url: request url, which contains the full path of the protocol domain name, etc., such as http://aaa.aa.com/a.html
        # #request-uri: request uri, relative path format, such as /index.html
        # #origin- IP: return source IP
        # #cache-ip: edge node IP
        # #server-ip: external service IP
        # #client-ip: client IP, or visitor IP
        # #response-header{XXX} : get the value in the response header, such as #response-header{etag}, get the etag value in response-header
        # 
        # #header{XXX} : to get the value in the HTTP header of the request, such as #header{user-agent}, is to get the user-agent value in the header
        # 
        # #cookie{XXX} : get the value in the cookie, such as #cookie{account}, is to get the value of the account set in the cookie", "zh_CN":"http头域对应的值，例如：mytest.example.com   
        # 注意：
        # 1、当action为add或set时，该入参必须传值
        # 2、当action为delete时，该入参不用传
        # 支持通过关键字获取指定变量值，如客户端ip，包含如下：
        # 关键字：含义
        # #timestamp ：当前时间，时间戳如1559124945
        # #request-host：请求头中的HOST
        # #request-url ：请求url，包含协议域名等的全路径，如http://aaa.aa.com/a.html
        # #request-uri ：请求uri，相对路径格式，如/index.html
        # #origin-ip ：回源IP
        # #cache-ip ：边缘节点IP
        # #server-ip ：对外服务IP
        # #client-ip ：客户端IP，即访客IP
        # #response-header{xxx}：获取响应头中的值，如#response-header{etag}，获取response-header中的etag值
        # #header{xxx}：获取请求的http header中的值，如#header{User-Agent}，是获取header中的User-Agent值
        # #cookie{xxx}：获取cookie中的值，如#cookie{account}，是获取cookie中设置的account的值&nbsp;&nbsp;"}
        self.header_value = header_value
        # {"en":"The original value corresponding to the HTTP header field","zh_CN":"http头域对应的原始值"}
        self.header_value_old = header_value_old
        # {"en":"Match request header, header values support regular, header and header values separated by Spaces, e.g. : Range bytes=[0-9]{9,}", "zh_CN":"匹配请求头，头部值支持正则，头和头部值用空格隔开，如：Range bytes=[0-9]{9,}"}
        self.reques_header = reques_header
        # {"en":"Indicates the priority of execution order for multiple sets of configurations. A higher number indicates higher priority. If no parameters are passed, the default value is 10 and cannot be cleared.", "zh_CN":"表示客户多组配置的优先执行顺序。数字越大，优先级越高。 不传参默认为10，不可清空"}
        self.priority = priority
        # {"en":"Exception file type.", "zh_CN":"例外的文件类型	"}
        self.except_file_type = except_file_type
        # {"en":"Exception directory.", "zh_CN":"例外的目录"}
        self.except_directory = except_directory
        # {"en":"Exception request method.", "zh_CN":"例外的请求方式"}
        self.except_request_method = except_request_method
        # {"en":"Exception request header.", "zh_CN":"例外的请求头"}
        self.except_request_header = except_request_header

    def validate(self):
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.custom_pattern, 'custom_pattern')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.custom_file_type, 'custom_file_type')
        self.validate_required(self.directory, 'directory')
        self.validate_required(self.specify_url, 'specify_url')
        self.validate_required(self.request_method, 'request_method')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.header_direction, 'header_direction')
        self.validate_required(self.action, 'action')
        self.validate_required(self.allow_regexp, 'allow_regexp')
        self.validate_required(self.header_name, 'header_name')
        self.validate_required(self.header_value, 'header_value')
        self.validate_required(self.header_value_old, 'header_value_old')
        self.validate_required(self.reques_header, 'reques_header')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.except_file_type, 'except_file_type')
        self.validate_required(self.except_directory, 'except_directory')
        self.validate_required(self.except_request_method, 'except_request_method')
        self.validate_required(self.except_request_header, 'except_request_header')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.file_type is not None:
            result['file-type'] = self.file_type
        if self.custom_file_type is not None:
            result['custom-file-type'] = self.custom_file_type
        if self.directory is not None:
            result['directory'] = self.directory
        if self.specify_url is not None:
            result['specify-url'] = self.specify_url
        if self.request_method is not None:
            result['request-method'] = self.request_method
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.path_pattern is not None:
            result[' path-pattern'] = self.path_pattern
        if self.header_direction is not None:
            result['header-direction'] = self.header_direction
        if self.action is not None:
            result['action'] = self.action
        if self.allow_regexp is not None:
            result[' allow-regexp'] = self.allow_regexp
        if self.header_name is not None:
            result['header-name'] = self.header_name
        if self.header_value is not None:
            result['header-value'] = self.header_value
        if self.header_value_old is not None:
            result['header-value-old'] = self.header_value_old
        if self.reques_header is not None:
            result['request-header'] = self.reques_header
        if self.priority is not None:
            result['priority'] = self.priority
        if self.except_file_type is not None:
            result['except-file-type'] = self.except_file_type
        if self.except_directory is not None:
            result['except-directory'] = self.except_directory
        if self.except_request_method is not None:
            result['except-request-method'] = self.except_request_method
        if self.except_request_header is not None:
            result['except-request-header'] = self.except_request_header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('file-type') is not None:
            self.file_type = m.get('file-type')
        if m.get('custom-file-type') is not None:
            self.custom_file_type = m.get('custom-file-type')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('specify-url') is not None:
            self.specify_url = m.get('specify-url')
        if m.get('request-method') is not None:
            self.request_method = m.get('request-method')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get(' path-pattern') is not None:
            self.path_pattern = m.get(' path-pattern')
        if m.get('header-direction') is not None:
            self.header_direction = m.get('header-direction')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get(' allow-regexp') is not None:
            self.allow_regexp = m.get(' allow-regexp')
        if m.get('header-name') is not None:
            self.header_name = m.get('header-name')
        if m.get('header-value') is not None:
            self.header_value = m.get('header-value')
        if m.get('header-value-old') is not None:
            self.header_value_old = m.get('header-value-old')
        if m.get('request-header') is not None:
            self.reques_header = m.get('request-header')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('except-file-type') is not None:
            self.except_file_type = m.get('except-file-type')
        if m.get('except-directory') is not None:
            self.except_directory = m.get('except-directory')
        if m.get('except-request-method') is not None:
            self.except_request_method = m.get('except-request-method')
        if m.get('except-request-header') is not None:
            self.except_request_header = m.get('except-request-header')
        return self


class QueryHttpHeaderConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        header_modify_rules: List[QueryHttpHeaderConfigQueryHttpHeaderConfigResponseHeaderModifyRules] = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        self.header_modify_rules = header_modify_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.header_modify_rules, 'header_modify_rules')
        if self.header_modify_rules:
            for k in self.header_modify_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.header_modify_rules is not None:
            result['header-modify-rules'] = []
            for k in self.header_modify_rules:
                result['header-modify-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('header-modify-rules') is not None:
            self.header_modify_rules = []
            for k in m.get('header-modify-rules'):
                temp_model = QueryHttpHeaderConfigQueryHttpHeaderConfigResponseHeaderModifyRules()
                self.header_modify_rules.append(temp_model.from_map(k))
        return self


class QueryHttpHeaderConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryHttpHeaderConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttpHeaderConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttpHeaderConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateLiveDomainMiscRequest(TeaModel):
    def __init__(
        self,
        enable_http_2: bool = None,
        redirect_http_to_https: bool = None,
        disable_rtmp: bool = None,
        disable_hdl: bool = None,
    ):
        # {"en":"Enable HTTP2", "zh_CN":"是否启用HTTP2"}
        self.enable_http_2 = enable_http_2
        # {"en":"Redirect Http To Https", "zh_CN":"请求协议类型"}
        self.redirect_http_to_https = redirect_http_to_https
        # {"en":"Disable RTMP", "zh_CN":"是否禁止RTMP协议"}
        self.disable_rtmp = disable_rtmp
        # {"en":"Disable HDL", "zh_CN":"是否禁止HDL协议"}
        self.disable_hdl = disable_hdl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_http_2 is not None:
            result['enableHttp2'] = self.enable_http_2
        if self.redirect_http_to_https is not None:
            result['redirectHttpToHttps'] = self.redirect_http_to_https
        if self.disable_rtmp is not None:
            result['disableRtmp'] = self.disable_rtmp
        if self.disable_hdl is not None:
            result['disableHdl'] = self.disable_hdl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHttp2') is not None:
            self.enable_http_2 = m.get('enableHttp2')
        if m.get('redirectHttpToHttps') is not None:
            self.redirect_http_to_https = m.get('redirectHttpToHttps')
        if m.get('disableRtmp') is not None:
            self.disable_rtmp = m.get('disableRtmp')
        if m.get('disableHdl') is not None:
            self.disable_hdl = m.get('disableHdl')
        return self


class UpdateLiveDomainMiscResponseData(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The preliminary deployment id", "zh_CN":"预部署id"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class UpdateLiveDomainMiscResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: UpdateLiveDomainMiscResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = UpdateLiveDomainMiscResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateLiveDomainMiscPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class UpdateLiveDomainMiscParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainMiscRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainMiscResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateCacheKeyConfigurationRequestCacheKeyRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        specify_url: str = None,
        full_match_4specify_url: str = None,
        custom_pattern: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        directory: str = None,
        ignore_case: str = None,
        header_name: str = None,
        parameter_of_header: str = None,
        priority: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Specify a uri, such as /test/specifyurl", "zh_CN":"指定具体的uri，如/test/specifyurl"}
        self.specify_url = specify_url
        # {"en":"Whether to match specifyUrl exactly or not, you can select true and false.
        # True:means match exactly. False: means fuzzy match, such as specifyUrl='/test/uri', and  request for /test/uri?p=1 will be matched.", "zh_CN":"是否完全匹配specifyUrl，可选择为true和false。
        # 为true则完全匹配；为false则模糊匹配，如指定/test/uri，请求/test/uri?p=1也会匹配"}
        self.full_match_4specify_url = full_match_4specify_url
        # {"en":"Specify common types: Select the domain name that requires the cache to be all files or the home page. :
        # E.g:
        # All: all files
        # Homepage: homepage", "zh_CN":"指定常用类型：选择缓存域名的是全部文件还是首页。入参参考值： all：全部文件 homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"File Type: Specify the file type for cache settings.
        # File types include: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # If you need all types, pass all directly. Multiples are separated by semicolons, and all and specific file types cannot be configured at the same time.", "zh_CN":"文件类型：指定需要缓存的文件类型。 文件类型包括：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf 如果需要全部类型，则直接传all。多个以分号隔开，all和具体文件类型不能同时配置。"}
        self.file_type = file_type
        # {"en":"Custom file type: Fill in the appropriate identifiable file type according to your needs outside of the specified file type. Can be used with file-type. If the file-type is also configured, the actual file type is the sum of the two parameters.", "zh_CN":"自定义文件类型：在指定文件类型外根据自身需求，填写适当的可识别文件类型。可以搭配file-type使用。如果file-type也有配置，实际生效的文件类型是两个入参的总和"}
        self.custom_file_type = custom_file_type
        # {"en":"Directory: Specify the directory cache.
        # Enter a legal directory format. Multiple separated by semicolons", "zh_CN":"目录：指定目录缓存。 输入合法的目录格式。多个以英文分号隔开"}
        self.directory = directory
        # {"en":"Ignore case, the optional value is true or false, true means to ignore case; false means not to ignore case;
        # When adding a new configuration item, the default is true", "zh_CN":"是否忽略大小写：允许值为true和false，默认为忽略"}
        self.ignore_case = ignore_case
        # {"en":"Header name.
        # Example: If you specify a header as &lsquo;lang', Then, if the value of Lang is consistent, one copy will be cached", "zh_CN":"头部名称
        # 例如：指定头部lang，lang的值一致则缓存一份"}
        self.header_name = header_name
        # {"en":"Parameter Of the specified Header，
        # Example: Specifies the header as 'cookie', parameterOfHeader as 'name'. Then, if the value of name is consistent, one copy will be cached.", "zh_CN":"头部值的参数名，
        # 例如：指定头部Cookie，头部值的参数名为name。则name的值一致则缓存一份。"}
        self.parameter_of_header = parameter_of_header
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"优先级，表示客户多组配置的优先执行顺序。数字越大，优先级越高。不传默认为10，不可清空。"}
        self.priority = priority
        # {"en":"DataId is to indicate a specific group configuration when the client has multiple groups of configurations. dataId can be retrieved through a query interface. Note: A. If dataId is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with dataId and others are not, then the expression of dataId is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of dataId. C. If the dataId is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the dataId must be filled in, and the value is the actual dataId, which means clearing the value of the corresponding dataId configuration item; it is not allowed that there is no specific configuration item or dataId in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。本功能只支持一组配置。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改该组配置项内容； b、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； c、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['pathPattern'] = self.path_pattern
        if self.specify_url is not None:
            result['specifyUrl'] = self.specify_url
        if self.full_match_4specify_url is not None:
            result['fullMatch4SpecifyUrl'] = self.full_match_4specify_url
        if self.custom_pattern is not None:
            result['customPattern'] = self.custom_pattern
        if self.file_type is not None:
            result['fileType'] = self.file_type
        if self.custom_file_type is not None:
            result['customFileType'] = self.custom_file_type
        if self.directory is not None:
            result['directory'] = self.directory
        if self.ignore_case is not None:
            result['ignoreCase'] = self.ignore_case
        if self.header_name is not None:
            result['headerName'] = self.header_name
        if self.parameter_of_header is not None:
            result['parameterOfHeader'] = self.parameter_of_header
        if self.priority is not None:
            result['priority'] = self.priority
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pathPattern') is not None:
            self.path_pattern = m.get('pathPattern')
        if m.get('specifyUrl') is not None:
            self.specify_url = m.get('specifyUrl')
        if m.get('fullMatch4SpecifyUrl') is not None:
            self.full_match_4specify_url = m.get('fullMatch4SpecifyUrl')
        if m.get('customPattern') is not None:
            self.custom_pattern = m.get('customPattern')
        if m.get('fileType') is not None:
            self.file_type = m.get('fileType')
        if m.get('customFileType') is not None:
            self.custom_file_type = m.get('customFileType')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('ignoreCase') is not None:
            self.ignore_case = m.get('ignoreCase')
        if m.get('headerName') is not None:
            self.header_name = m.get('headerName')
        if m.get('parameterOfHeader') is not None:
            self.parameter_of_header = m.get('parameterOfHeader')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class UpdateCacheKeyConfigurationRequest(TeaModel):
    def __init__(
        self,
        cache_key_rules: List[UpdateCacheKeyConfigurationRequestCacheKeyRules] = None,
    ):
        # {"en":"Custom Cachekey Configuration, parent node
        # 1. When you need to configure the cachekey rules,this must be filled in.
        # 2. Configuration of clearing for <cacheKeyRules/>.", "zh_CN":"配置自定义缓存key功能。
        # 1. 需要设置自定义缓存key配置时，此项必填
        # 2. 为<cacheKeyRules/>时清空自定义缓存key配置"}
        self.cache_key_rules = cache_key_rules

    def validate(self):
        self.validate_required(self.cache_key_rules, 'cache_key_rules')
        if self.cache_key_rules:
            for k in self.cache_key_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_key_rules is not None:
            result['cacheKeyRules'] = []
            for k in self.cache_key_rules:
                result['cacheKeyRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cacheKeyRules') is not None:
            self.cache_key_rules = []
            for k in m.get('cacheKeyRules'):
                temp_model = UpdateCacheKeyConfigurationRequestCacheKeyRules()
                self.cache_key_rules.append(temp_model.from_map(k))
        return self


class UpdateCacheKeyConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200 or 202.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateCacheKeyConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class UpdateCacheKeyConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCacheKeyConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCacheKeyConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryWebsocketConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryWebsocketConfigResponseDataWebsocketSwitch(TeaModel):
    def __init__(
        self,
        enable_websocket: bool = None,
    ):
        # {"en":"Whether to turn on the websocket function, the allowable values are true and false, default false", "zh_CN":"是否开启websocket功能,允许值为true和false，默认为否"}
        self.enable_websocket = enable_websocket

    def validate(self):
        self.validate_required(self.enable_websocket, 'enable_websocket')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_websocket is not None:
            result['enableWebsocket'] = self.enable_websocket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableWebsocket') is not None:
            self.enable_websocket = m.get('enableWebsocket')
        return self


class QueryWebsocketConfigResponseData(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        websocket_switch: QueryWebsocketConfigResponseDataWebsocketSwitch = None,
    ):
        # {"en":"domain id", "zh_CN":"域名id"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"Open or close websocket function, parent node, you can set <websocketSwitch/> to clear this configuration.
        # Scope of application: wsa, web pages", "zh_CN":"开启或关闭websocket功能，父标签，为<websocketSwitch/>则清空websocket开关配置
        # 适用范围：wsa、网页"}
        self.websocket_switch = websocket_switch

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.websocket_switch, 'websocket_switch')
        if self.websocket_switch:
            self.websocket_switch.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.websocket_switch is not None:
            result['websocketSwitch'] = self.websocket_switch.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('websocketSwitch') is not None:
            temp_model = QueryWebsocketConfigResponseDataWebsocketSwitch()
            self.websocket_switch = temp_model.from_map(m['websocketSwitch'])
        return self


class QueryWebsocketConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryWebsocketConfigResponseData = None,
    ):
        # {"en":"Error code, 0 is success.", "zh_CN":"错误代码，成功为0"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"data content, parent node.", "zh_CN":"数据内容，父标签"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryWebsocketConfigResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryWebsocketConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryWebsocketConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryWebsocketConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryWebsocketConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditOriginUriAndHostRequestOriginRulesRewrites(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        path_pattern: str = None,
        path_pattern_http: str = None,
        except_path_pattern: str = None,
        except_path_pattern_http: str = None,
        ignore_letter_case: str = None,
        origin_info: str = None,
        priority: str = None,
        origin_host: str = None,
        before_rewrited_uri: str = None,
        after_rewrited_uri: str = None,
    ):
        # {"en":"Add a grid type identifier to represent a specific group of configurations when a customer has multiple groups of configurations.
        # Note: Add grid type identifier: data-id, each group configuration corresponds to a data-id: a. If the customer has passed data-id, specify that modifying one group of configuration items content does not require modifying other group configuration content does not need to be included; B. If the customer enters multiple groups of configuration, some of them have data-id, some have not. If there is transmission, the expression of data-id is used to modify a specific group of configurations, but no expression of data-id is used to add a new group of configurations on the original basis; C. If no data-id is transmitted to the customer, it means that the original configuration is completely covered by this configuration; D. If no configuration parameters are transmitted to the customer, only the domain name and the second level are transmitted. Label, which indicates that clearing this interface corresponds to all configuration of domain name secondary service. (c, D content is consistent with the current solution); e, a gird tag can not be empty, if there is no specific configuration item, then data-id must be filled in, and the value is the actual data-id, indicating the value of clearing this data-id corresponding configuration item;", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置
        # 注意：添加grid类型标识：data-id，每一组配置对应一个data-id：a、如果客户有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；b、如果客户入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置；c、如果客户入参都没有传data-id,表示用本次的配置全量覆盖原先配置；d、如果客户入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置。（c、d内容和当前方案实现一致）；e、一个gird标签下的入参不能为空，如果，没有具体的配置项，则data-id必填，且值为实际存在的data-id,表示清空这个data-id对应配置项的值；"}
        self.data_id = data_id
        # {"en":"The URL matching mode supports regularization. If all matches are made, the input can be configured as:.*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The protocol of URL matching mode, which is used with path-pattern, is supported by adding parameters: default is empty, blank is default is to support HTTP and HTTPS protocol before URL matching mode path is needed at the same time;
        # 
        # Http: URL matches pattern path with HTTP protocol
        # 
        # Https: URL matches pattern path with HTTPS protocol
        # 
        # Ignore: URL matching mode path without protocol", "zh_CN":"url匹配模式的协议，该配置项与path-pattern搭配使用；入参支持：默认为空，为空则默认为需要同时支持url匹配模式路径前支持http和https协议；
        # http：url匹配模式路径前加上http协议
        # https:url 匹配模式路径前加上HTTPS协议
        # ignore:url匹配模式路径前不加协议"}
        self.path_pattern_http = path_pattern_http
        # {"en":"Exceptional URL matching pattern in the same format as path pattern", "zh_CN":"例外的url匹配模式，格式同pathPattern"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Exceptional URL matching mode protocol, which is used in conjunction with except-path-pattern; participation support: default is empty, blank is default is required to support both HTTP and HTTPS protocol before URL matching mode path;
        # 
        # Http: URL matches pattern path with HTTP protocol.
        # Https: URL matches pattern path with HTTPS protocol.
        # Ignore: URL matching mode path without protocol.", "zh_CN":"例外的url匹配模式的协议，该配置项与except-path-pattern搭配使用；入参支持：默认为空，为空则默认为需要同时支持url匹配模式路径前支持http和https协议；
        # http：url匹配模式路径前加上http协议
        # https:url 匹配模式路径前加上HTTPS协议
        # ignore:url匹配模式路径前不加协议"}
        self.except_path_pattern_http = except_path_pattern_http
        # {"en":"Ignore case or not: the allowable values are true and false, and the default is Ignore", "zh_CN":"是否忽略大小写：允许值为true和false，默认为忽略"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Back-source information, you can enter IP or domain name.
        # That is, customer source IP or domain name", "zh_CN":"回源信息，可以输入ip或者域名
        # 即客户源站IP或域名"}
        self.origin_info = origin_info
        # {"en":"Represents the priority execution order of the customer's multi-group redirected content. The bigger the number, the higher the priority.", "zh_CN":"表示客户多组重定向内容的优先执行顺序。数字越大，优先级越高。
        # 新增配置项时，不传默认为 10
        # 如果传了值，不能为空"}
        self.priority = priority
        # {"en":"Back source host,that support to enter domain names;
        # Example: The backsource host of domain name A configures domain name B. When the A domain name requests the source, the requested URL uses the B domain name instead of the A domain name.", "zh_CN":"回源host,支持入参域名；
        # 示例：域名A的回源host配置了域名B。当A域名请求的回源的时候，请求的url上用B域名代替A域名&nbsp;"}
        self.origin_host = origin_host
        # {"en":"Pre-rewrite uri. That is, the original request URI for user access. Support regular configuration", "zh_CN":"改写前的uri.&nbsp;即用户访问的原始请求uri&nbsp;。支持正则配置"}
        self.before_rewrited_uri = before_rewrited_uri
        # {"en":"The rewritten uri, the request URI configured before-rewrited-uri, is retrieved with the rewritten uri. Rewrite the source path. Support regular configuration", "zh_CN":"改写后的uri,即将&nbsp;before-rewrited-uri配置的请求uri，用改写后的uri回源。实现回源路径改写。支持正则配置"}
        self.after_rewrited_uri = after_rewrited_uri

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.priority, 'priority')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.path_pattern is not None:
            result['pathPattern'] = self.path_pattern
        if self.path_pattern_http is not None:
            result['pathPatternHttp'] = self.path_pattern_http
        if self.except_path_pattern is not None:
            result['exceptPathPattern'] = self.except_path_pattern
        if self.except_path_pattern_http is not None:
            result['exceptPathPatternHttp'] = self.except_path_pattern_http
        if self.ignore_letter_case is not None:
            result['ignoreLetterCase'] = self.ignore_letter_case
        if self.origin_info is not None:
            result['originInfo'] = self.origin_info
        if self.priority is not None:
            result['priority'] = self.priority
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        if self.before_rewrited_uri is not None:
            result['beforeRewritedUri'] = self.before_rewrited_uri
        if self.after_rewrited_uri is not None:
            result['afterRewritedUri'] = self.after_rewrited_uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('pathPattern') is not None:
            self.path_pattern = m.get('pathPattern')
        if m.get('pathPatternHttp') is not None:
            self.path_pattern_http = m.get('pathPatternHttp')
        if m.get('exceptPathPattern') is not None:
            self.except_path_pattern = m.get('exceptPathPattern')
        if m.get('exceptPathPatternHttp') is not None:
            self.except_path_pattern_http = m.get('exceptPathPatternHttp')
        if m.get('ignoreLetterCase') is not None:
            self.ignore_letter_case = m.get('ignoreLetterCase')
        if m.get('originInfo') is not None:
            self.origin_info = m.get('originInfo')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        if m.get('beforeRewritedUri') is not None:
            self.before_rewrited_uri = m.get('beforeRewritedUri')
        if m.get('afterRewritedUri') is not None:
            self.after_rewrited_uri = m.get('afterRewritedUri')
        return self


class EditOriginUriAndHostRequest(TeaModel):
    def __init__(
        self,
        origin_rules_rewrites: List[EditOriginUriAndHostRequestOriginRulesRewrites] = None,
    ):
        # {"en":"Return path rewrite configuration
        # 
        # 1. When you need to set the rewrite configuration of the backsource path, this must be filled in
        # 
        # 2. Rewrite configuration for clearing the return path for <origin-rules-rewrites/>.", "zh_CN":"回源路径改写配置
        # 1.需要设置回源路径改写配置时，此项必填
        # 2.为<origin-rules-rewrites/>时清空回源路径改写配置"}
        self.origin_rules_rewrites = origin_rules_rewrites

    def validate(self):
        self.validate_required(self.origin_rules_rewrites, 'origin_rules_rewrites')
        if self.origin_rules_rewrites:
            for k in self.origin_rules_rewrites:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_rules_rewrites is not None:
            result['originRulesRewrites'] = []
            for k in self.origin_rules_rewrites:
                result['originRulesRewrites'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('originRulesRewrites') is not None:
            self.origin_rules_rewrites = []
            for k in m.get('originRulesRewrites'):
                temp_model = EditOriginUriAndHostRequestOriginRulesRewrites()
                self.origin_rules_rewrites.append(temp_model.from_map(k))
        return self


class EditOriginUriAndHostResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"Error code. It pops up when the HTTPStatus is not 202, and shows the revoking error type of the current request.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response message, and shows as success when it succeeds.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data.", "zh_CN":"返回数据主体"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EditOriginUriAndHostPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditOriginUriAndHostParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditOriginUriAndHostRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditOriginUriAndHostResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QuerysourceverificationconfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QuerysourceverificationconfigResponseSourceVerification(TeaModel):
    def __init__(
        self,
        switch_position: str = None,
        ref_switch: str = None,
        md_5path: str = None,
        time_offset: int = None,
        sign_name: str = None,
        time_name: str = None,
        other_parameters: str = None,
    ):
        # {"en":"", "zh_CN":"生效位置，代表配置生效的位置。可选值，多个分号隔开
        # Cache:边缘
        # stfuCache：静态中转
        # dyfuCache：动态中转"}
        self.switch_position = switch_position
        # {"en":"", "zh_CN":"是否开启回源校验。
        # 可选值：
        # close：关闭
        # push:转推使用
        # origin：回源使用
        # push-origin：即转推又回源使用"}
        self.ref_switch = ref_switch
        # {"en":"", "zh_CN":"md5加密方式
        # 标识客户md5加密涉及的内容。参考入参
        # ||%S||BASE10||12345678||"}
        self.md_5path = md_5path
        # {"en":"", "zh_CN":"时间偏移量:未配置时以当前时间为准；配了时移就以当前时间+时移秒数的那个时间为准。不传默认为0，即无时间偏移"}
        self.time_offset = time_offset
        # {"en":"", "zh_CN":"sign字段名称：问号后需要鉴权的参数名
        # 参考入参：sign"}
        self.sign_name = sign_name
        # {"en":"", "zh_CN":"time字段名称：问号后需要鉴权的参数名
        # 参考入参：time"}
        self.time_name = time_name
        # {"en":"", "zh_CN":"额外固定参数：需要带额外的参数回客户源站鉴权
        # 参考入参：trans=live.a.com"}
        self.other_parameters = other_parameters

    def validate(self):
        self.validate_required(self.switch_position, 'switch_position')
        self.validate_required(self.ref_switch, 'ref_switch')
        self.validate_required(self.md_5path, 'md_5path')
        self.validate_required(self.time_offset, 'time_offset')
        self.validate_required(self.sign_name, 'sign_name')
        self.validate_required(self.time_name, 'time_name')
        self.validate_required(self.other_parameters, 'other_parameters')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.switch_position is not None:
            result['switch-position'] = self.switch_position
        if self.ref_switch is not None:
            result['ref-switch'] = self.ref_switch
        if self.md_5path is not None:
            result['md5-path'] = self.md_5path
        if self.time_offset is not None:
            result['time-offset'] = self.time_offset
        if self.sign_name is not None:
            result['sign-name'] = self.sign_name
        if self.time_name is not None:
            result['time-name'] = self.time_name
        if self.other_parameters is not None:
            result['other-parameters'] = self.other_parameters
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('switch-position') is not None:
            self.switch_position = m.get('switch-position')
        if m.get('ref-switch') is not None:
            self.ref_switch = m.get('ref-switch')
        if m.get('md5-path') is not None:
            self.md_5path = m.get('md5-path')
        if m.get('time-offset') is not None:
            self.time_offset = m.get('time-offset')
        if m.get('sign-name') is not None:
            self.sign_name = m.get('sign-name')
        if m.get('time-name') is not None:
            self.time_name = m.get('time-name')
        if m.get('other-parameters') is not None:
            self.other_parameters = m.get('other-parameters')
        return self


class QuerysourceverificationconfigResponse(TeaModel):
    def __init__(
        self,
        source_verification: QuerysourceverificationconfigResponseSourceVerification = None,
    ):
        # {"en":"", "zh_CN":"转推回源带参数鉴权配置
        # 注意：
        # 1、需要取消花椒转推回源带参数鉴权配置时，可以传入空节点<source-verification></source-verification>。
        # 2、表示需要设置花椒转推回源带参数鉴权配置时，此项必填"}
        self.source_verification = source_verification

    def validate(self):
        self.validate_required(self.source_verification, 'source_verification')
        if self.source_verification:
            self.source_verification.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_verification is not None:
            result['source-verification'] = self.source_verification.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('source-verification') is not None:
            temp_model = QuerysourceverificationconfigResponseSourceVerification()
            self.source_verification = temp_model.from_map(m['source-verification'])
        return self


class QuerysourceverificationconfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QuerysourceverificationconfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QuerysourceverificationconfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QuerysourceverificationconfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAppaDomainPortInfoForWplusRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaDomainPortInfoForWplusResponseData(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        tcp_listening_ports: List[str] = None,
        tcp_listening_port_http_ls: List[str] = None,
        tcp_listening_port_https_ls: List[str] = None,
        ftp_control_ports: List[str] = None,
        ftp_data_ports: List[str] = None,
        udp_listening_ports: List[str] = None,
        tcp_adv_srcs: List[str] = None,
    ):
        # {"en":"domain name", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"tcp listening port", "zh_CN":"TCP监听端口"}
        self.tcp_listening_ports = tcp_listening_ports
        # {"en":"tcp listening port http", "zh_CN":"HTTP协议复用TCP监听端口"}
        self.tcp_listening_port_http_ls = tcp_listening_port_http_ls
        # {"en":"tcp listening port https", "zh_CN":"HTTPS协议复用TCP监听端口"}
        self.tcp_listening_port_https_ls = tcp_listening_port_https_ls
        # {"en":"ftp control ports", "zh_CN":"FTP控制端口"}
        self.ftp_control_ports = ftp_control_ports
        # {"en":"ftp data ports", "zh_CN":"FTP数据端口"}
        self.ftp_data_ports = ftp_data_ports
        # {"en":"udp listening ports", "zh_CN":"UDP监听端口"}
        self.udp_listening_ports = udp_listening_ports
        # {"en":"tcp advence srcs", "zh_CN":"TCP高级源的回源域名/源IP"}
        self.tcp_adv_srcs = tcp_adv_srcs

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.tcp_listening_ports, 'tcp_listening_ports')
        self.validate_required(self.tcp_listening_port_http_ls, 'tcp_listening_port_http_ls')
        self.validate_required(self.tcp_listening_port_https_ls, 'tcp_listening_port_https_ls')
        self.validate_required(self.ftp_control_ports, 'ftp_control_ports')
        self.validate_required(self.ftp_data_ports, 'ftp_data_ports')
        self.validate_required(self.udp_listening_ports, 'udp_listening_ports')
        self.validate_required(self.tcp_adv_srcs, 'tcp_adv_srcs')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.tcp_listening_ports is not None:
            result['tcpListeningPorts'] = self.tcp_listening_ports
        if self.tcp_listening_port_http_ls is not None:
            result['tcpListeningPortHttpLs'] = self.tcp_listening_port_http_ls
        if self.tcp_listening_port_https_ls is not None:
            result['tcpListeningPortHttpsLs'] = self.tcp_listening_port_https_ls
        if self.ftp_control_ports is not None:
            result['ftpControlPorts'] = self.ftp_control_ports
        if self.ftp_data_ports is not None:
            result['ftpDataPorts'] = self.ftp_data_ports
        if self.udp_listening_ports is not None:
            result['udpListeningPorts'] = self.udp_listening_ports
        if self.tcp_adv_srcs is not None:
            result['tcpAdvSrcs'] = self.tcp_adv_srcs
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('tcpListeningPorts') is not None:
            self.tcp_listening_ports = m.get('tcpListeningPorts')
        if m.get('tcpListeningPortHttpLs') is not None:
            self.tcp_listening_port_http_ls = m.get('tcpListeningPortHttpLs')
        if m.get('tcpListeningPortHttpsLs') is not None:
            self.tcp_listening_port_https_ls = m.get('tcpListeningPortHttpsLs')
        if m.get('ftpControlPorts') is not None:
            self.ftp_control_ports = m.get('ftpControlPorts')
        if m.get('ftpDataPorts') is not None:
            self.ftp_data_ports = m.get('ftpDataPorts')
        if m.get('udpListeningPorts') is not None:
            self.udp_listening_ports = m.get('udpListeningPorts')
        if m.get('tcpAdvSrcs') is not None:
            self.tcp_adv_srcs = m.get('tcpAdvSrcs')
        return self


class QueryAppaDomainPortInfoForWplusResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryAppaDomainPortInfoForWplusResponseData = None,
    ):
        # {"en":"query result code, 0 for success, other for fail", "zh_CN":"查询结果代号，0表示成功，其他表示失败"}
        self.code = code
        # {"en":"query result message", "zh_CN":"查询结果信息"}
        self.message = message
        # {"en":"query datas", "zh_CN":"查询数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryAppaDomainPortInfoForWplusResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryAppaDomainPortInfoForWplusPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaDomainPortInfoForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaDomainPortInfoForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaDomainPortInfoForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateGlobalTransCodingConfigForWplusRequestTransCodeSwitch(TeaModel):
    def __init__(
        self,
        trans_code_enabled: bool = None,
        pull_domain_name: str = None,
    ):
        # {"en":"Turn on transcoding, the optional values are true and false.
        # Please note: only transcoding stream names without underscores is supported. Please contact technical support if necessary.", "zh_CN":"开启转码，可选值为true（开启）、false（关闭）。
        # 请注意：只支持流名不带下划线的转码，若需要，请联系技术支持。"}
        self.trans_code_enabled = trans_code_enabled
        # {"en":"Transcoding pull stream domain name, this item is required when transcoding is enabled.", "zh_CN":"转码拉流域名，开启转码时，此项必填"}
        self.pull_domain_name = pull_domain_name

    def validate(self):
        self.validate_required(self.trans_code_enabled, 'trans_code_enabled')
        self.validate_required(self.pull_domain_name, 'pull_domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trans_code_enabled is not None:
            result['transCodeEnabled'] = self.trans_code_enabled
        if self.pull_domain_name is not None:
            result['pullDomainName'] = self.pull_domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('transCodeEnabled') is not None:
            self.trans_code_enabled = m.get('transCodeEnabled')
        if m.get('pullDomainName') is not None:
            self.pull_domain_name = m.get('pullDomainName')
        return self


class UpdateGlobalTransCodingConfigForWplusRequest(TeaModel):
    def __init__(
        self,
        trans_code_switch: UpdateGlobalTransCodingConfigForWplusRequestTransCodeSwitch = None,
    ):
        # {"en":"Transcode Global Configuration, parent node
        # 1. When you need to use the transcode function, this must be filled in.
        # 2. Configuration of clearing for <transCodeSwitch/>.", "zh_CN":"转码全局配置，父标签
        # 1.需要设置转码功能时，此项必填
        # 2.为<transCodeSwitch/>时清空配置"}
        self.trans_code_switch = trans_code_switch

    def validate(self):
        self.validate_required(self.trans_code_switch, 'trans_code_switch')
        if self.trans_code_switch:
            self.trans_code_switch.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trans_code_switch is not None:
            result['transCodeSwitch'] = self.trans_code_switch.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('transCodeSwitch') is not None:
            temp_model = UpdateGlobalTransCodingConfigForWplusRequestTransCodeSwitch()
            self.trans_code_switch = temp_model.from_map(m['transCodeSwitch'])
        return self


class UpdateGlobalTransCodingConfigForWplusResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateGlobalTransCodingConfigForWplusPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class UpdateGlobalTransCodingConfigForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateGlobalTransCodingConfigForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateGlobalTransCodingConfigForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryIgnoreProtocolRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryIgnoreProtocolResponseIgnoreProtocolRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        except_path_pattern: str = None,
        cache_ignore_protocol: str = None,
        purge_ignore_protocol: str = None,
        data_id: int = None,
    ):
        # {"en":"Url matching pattern, support regular, if all matches, input parameters can be configured as:.*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The exception url matches the pattern in the same format as the path-pattern", "zh_CN":"例外的url匹配模式，格式同path-pattern"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Whether to ignore the protocol cache, with allowable values of true and false. True turns on the HTTP/HTTPS Shared cache. Not on by default.", "zh_CN":"是否忽略协议缓存，允许值为true和false。为true则开启http/https共用缓存。默认不开启。"}
        self.cache_ignore_protocol = cache_ignore_protocol
        # {"en":"It is recommended to use with cache-ignore protocol to avoid push failure.
        # 
        # Note:
        # 
        # 1. Once configured, the global effect is not applied to the matched path-pattern.
        # 
        # 2. Directory push does not distinguish protocols, while url push can distinguish protocols", "zh_CN":"是否忽略协议推送，允许值为true和false。为true则推送时忽略协议；为false则区分协议推送。
        # 建议和cache-ignore-protocol配套使用，避免推送失效。
        # 注意：
        # 1.一旦配置，则全局生效，不针对匹配的path-pattern生效。
        # 2.目录推送不区分协议，url推送可区分协议"}
        self.purge_ignore_protocol = purge_ignore_protocol
        # {"en":"When configuring multiple groups of configurations, specify the id of a particular group of configurations", "zh_CN":"配置多组配置时，具体某组配置的id"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.cache_ignore_protocol, 'cache_ignore_protocol')
        self.validate_required(self.purge_ignore_protocol, 'purge_ignore_protocol')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.cache_ignore_protocol is not None:
            result['cache-ignore-protocol'] = self.cache_ignore_protocol
        if self.purge_ignore_protocol is not None:
            result['purge-ignore-protocol'] = self.purge_ignore_protocol
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('cache-ignore-protocol') is not None:
            self.cache_ignore_protocol = m.get('cache-ignore-protocol')
        if m.get('purge-ignore-protocol') is not None:
            self.purge_ignore_protocol = m.get('purge-ignore-protocol')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class QueryIgnoreProtocolResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        ignore_protocol_rules: List[QueryIgnoreProtocolResponseIgnoreProtocolRules] = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        # {"en":"Ignore protocol caching and push configuration, parent tags
        # 
        # 1. This must be filled when protocol cache and push configuration need to be ignored
        # 2.<ignore-protocol-rules/>:Clear the configuration ignore about protocol cache and pushing", "zh_CN":"忽略协议缓存和推送配置，父标签
        # 1.需要设置忽略协议缓存和推送配置时，此项必填
        # 2.为<ignore-protocol-rules/>时清空忽略协议缓存和推送的配置"}
        self.ignore_protocol_rules = ignore_protocol_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.ignore_protocol_rules, 'ignore_protocol_rules')
        if self.ignore_protocol_rules:
            for k in self.ignore_protocol_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.ignore_protocol_rules is not None:
            result['ignore-protocol-rules'] = []
            for k in self.ignore_protocol_rules:
                result['ignore-protocol-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('ignore-protocol-rules') is not None:
            self.ignore_protocol_rules = []
            for k in m.get('ignore-protocol-rules'):
                temp_model = QueryIgnoreProtocolResponseIgnoreProtocolRules()
                self.ignore_protocol_rules.append(temp_model.from_map(k))
        return self


class QueryIgnoreProtocolPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryIgnoreProtocolParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryIgnoreProtocolRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryIgnoreProtocolResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EnableOrDisableWAFProtectionRequest(TeaModel):
    def __init__(
        self,
        domain_names: List[str] = None,
        refer_domain: str = None,
        type: str = None,
    ):
        # {"en":"Domain names list, the parent tag.", "zh_CN":"开启/关闭WAF防护的域名列表， 父标签"}
        self.domain_names = domain_names
        # {"en":"The reference  domain name. the reference domain cannot be null while enabling WAF protection", "zh_CN":"参考域名， 开启waf防护时，参考域名不能为空"}
        self.refer_domain = refer_domain
        # {"en":"1: Enable WAF protection; 
        # 0: Disable WAF protection", "zh_CN":"1：开启WAF防护，0：关闭WAF防护"}
        self.type = type

    def validate(self):
        self.validate_required(self.domain_names, 'domain_names')
        self.validate_required(self.refer_domain, 'refer_domain')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['domainNames'] = self.domain_names
        if self.refer_domain is not None:
            result['referDomain'] = self.refer_domain
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainNames') is not None:
            self.domain_names = m.get('domainNames')
        if m.get('referDomain') is not None:
            self.refer_domain = m.get('referDomain')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class EnableOrDisableWAFProtectionResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        http_status: int = None,
        x_cnc_request_id: str = None,
        data: str = None,
    ):
        # {"en":"Error code.
        #  0：successful", "zh_CN":"错误代码。 0：成功"}
        self.code = code
        # {"en":"The response message.
        # Response "Success" when calling API successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The body of return data.", "zh_CN":"返回体数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EnableOrDisableWAFProtectionPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EnableOrDisableWAFProtectionParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EnableOrDisableWAFProtectionRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EnableOrDisableWAFProtectionResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdatesourceverificationconfigRequestSourceVerification(TeaModel):
    def __init__(
        self,
        switch_position: str = None,
        ref_switch: str = None,
        md_5path: str = None,
        time_offset: int = None,
        sign_name: str = None,
        time_name: str = None,
        other_parameters: str = None,
    ):
        # {"en":"", "zh_CN":"生效位置，代表配置生效的位置。可选值，多个分号隔开
        # Cache:边缘
        # stfuCache：静态中转
        # dyfuCache：动态中转"}
        self.switch_position = switch_position
        # {"en":"", "zh_CN":"是否开启回源校验。
        # 可选值：
        # close：关闭
        # push:转推使用
        # origin：回源使用
        # push-origin：即转推又回源使用"}
        self.ref_switch = ref_switch
        # {"en":"", "zh_CN":"md5加密方式
        # 标识客户md5加密涉及的内容。参考入参
        # ||%S||BASE10||12345678||"}
        self.md_5path = md_5path
        # {"en":"", "zh_CN":"时间偏移量:未配置时以当前时间为准；配了时移就以当前时间+时移秒数的那个时间为准。不传默认为0，即无时间偏移"}
        self.time_offset = time_offset
        # {"en":"", "zh_CN":"sign字段名称：问号后需要鉴权的参数名
        # 参考入参：sign"}
        self.sign_name = sign_name
        # {"en":"", "zh_CN":"time字段名称：问号后需要鉴权的参数名
        # 参考入参：time"}
        self.time_name = time_name
        # {"en":"", "zh_CN":"额外固定参数：需要带额外的参数回客户源站鉴权
        # 参考入参：trans=live.a.com"}
        self.other_parameters = other_parameters

    def validate(self):
        self.validate_required(self.switch_position, 'switch_position')
        self.validate_required(self.ref_switch, 'ref_switch')
        self.validate_required(self.md_5path, 'md_5path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.switch_position is not None:
            result['switch-position'] = self.switch_position
        if self.ref_switch is not None:
            result['ref-switch'] = self.ref_switch
        if self.md_5path is not None:
            result['md5-path'] = self.md_5path
        if self.time_offset is not None:
            result['time-offset'] = self.time_offset
        if self.sign_name is not None:
            result['sign-name'] = self.sign_name
        if self.time_name is not None:
            result['time-name'] = self.time_name
        if self.other_parameters is not None:
            result['other-parameters'] = self.other_parameters
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('switch-position') is not None:
            self.switch_position = m.get('switch-position')
        if m.get('ref-switch') is not None:
            self.ref_switch = m.get('ref-switch')
        if m.get('md5-path') is not None:
            self.md_5path = m.get('md5-path')
        if m.get('time-offset') is not None:
            self.time_offset = m.get('time-offset')
        if m.get('sign-name') is not None:
            self.sign_name = m.get('sign-name')
        if m.get('time-name') is not None:
            self.time_name = m.get('time-name')
        if m.get('other-parameters') is not None:
            self.other_parameters = m.get('other-parameters')
        return self


class UpdatesourceverificationconfigRequest(TeaModel):
    def __init__(
        self,
        source_verification: UpdatesourceverificationconfigRequestSourceVerification = None,
    ):
        # {"en":"", "zh_CN":"转推回源带参数鉴权配置
        # 注意：
        # 1、需要取消花椒转推回源带参数鉴权配置时，可以传入空节点<source-verification></source-verification>。
        # 2、表示需要设置花椒转推回源带参数鉴权配置时，此项必填"}
        self.source_verification = source_verification

    def validate(self):
        self.validate_required(self.source_verification, 'source_verification')
        if self.source_verification:
            self.source_verification.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_verification is not None:
            result['source-verification'] = self.source_verification.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('source-verification') is not None:
            temp_model = UpdatesourceverificationconfigRequestSourceVerification()
            self.source_verification = temp_model.from_map(m['source-verification'])
        return self


class UpdatesourceverificationconfigResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型
        # 错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success
        # 响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdatesourceverificationconfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class UpdatesourceverificationconfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdatesourceverificationconfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdatesourceverificationconfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryDomainRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainResponseResultDomainsDomain(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        src_ip: str = None,
        cname: str = None,
        status: str = None,
        cust_suit_type: str = None,
        create_time: str = None,
        test_url: str = None,
        can_change_src: str = None,
        can_change_adv_src: str = None,
        is_use_ssl: str = None,
        version: str = None,
    ):
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain_name = domain_name
        # {"en":"The origin server address, which can be an IP or a domain name. 1. IPs should be separated by semicolons and multiple IPs are supported. 2. Only one domain name is allowed. 3. The maximum length must not exceed 500 characters.", "zh_CN":"回源地址，可以是IP或域名。 1、IP以分号分隔，支持多个。 2、域名只能一个。 3、限制最大不能超过500个字符长度。"}
        self.src_ip = src_ip
        # {"en":"Service Domain", "zh_CN":"服务域名"}
        self.cname = cname
        # {"en":"Status", "zh_CN":"域名状态"}
        self.status = status
        # {"en":"Offer Code", "zh_CN":"商品"}
        self.cust_suit_type = cust_suit_type
        # {"en":"Create time", "zh_CN":"创建时间"}
        self.create_time = create_time
        # {"en":"Test URL", "zh_CN":"测试URL"}
        self.test_url = test_url
        # {"en":"Whether modification of the origin server is permitted. 0 indicates it is not allowed, 1 indicates it is allowed.", "zh_CN":"是否允许修改源站。0表示不可以，1表示可以。"}
        self.can_change_src = can_change_src
        # {"en":"Whether modification of the advanced origin is permitted. 0 indicates it is not allowed, 1 indicates it is allowed.", "zh_CN":"是否允许修改高级源。0表示不可以，1表示可以。"}
        self.can_change_adv_src = can_change_adv_src
        # {"en":"Whether a certificate is in use. 0 indicates that no certificate is being used, 1 indicates that a certificate is in use.", "zh_CN":"是否有使用证书。0表示未使用，1表示有使用。"}
        self.is_use_ssl = is_use_ssl
        # {"en":"Version", "zh_CN":"版本号"}
        self.version = version

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.src_ip, 'src_ip')
        self.validate_required(self.cname, 'cname')
        self.validate_required(self.status, 'status')
        self.validate_required(self.cust_suit_type, 'cust_suit_type')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.test_url, 'test_url')
        self.validate_required(self.can_change_src, 'can_change_src')
        self.validate_required(self.can_change_adv_src, 'can_change_adv_src')
        self.validate_required(self.is_use_ssl, 'is_use_ssl')
        self.validate_required(self.version, 'version')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.src_ip is not None:
            result['src-ip'] = self.src_ip
        if self.cname is not None:
            result['cname'] = self.cname
        if self.status is not None:
            result['status'] = self.status
        if self.cust_suit_type is not None:
            result['cust-suit-type'] = self.cust_suit_type
        if self.create_time is not None:
            result['create-time'] = self.create_time
        if self.test_url is not None:
            result['test-url'] = self.test_url
        if self.can_change_src is not None:
            result['can-change-src'] = self.can_change_src
        if self.can_change_adv_src is not None:
            result['can-change-adv-src'] = self.can_change_adv_src
        if self.is_use_ssl is not None:
            result['is-use-ssl'] = self.is_use_ssl
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('src-ip') is not None:
            self.src_ip = m.get('src-ip')
        if m.get('cname') is not None:
            self.cname = m.get('cname')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('cust-suit-type') is not None:
            self.cust_suit_type = m.get('cust-suit-type')
        if m.get('create-time') is not None:
            self.create_time = m.get('create-time')
        if m.get('test-url') is not None:
            self.test_url = m.get('test-url')
        if m.get('can-change-src') is not None:
            self.can_change_src = m.get('can-change-src')
        if m.get('can-change-adv-src') is not None:
            self.can_change_adv_src = m.get('can-change-adv-src')
        if m.get('is-use-ssl') is not None:
            self.is_use_ssl = m.get('is-use-ssl')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class QueryDomainResponseResultDomains(TeaModel):
    def __init__(
        self,
        domain: QueryDomainResponseResultDomainsDomain = None,
    ):
        # {"en":"domain config", "zh_CN":"域名配置"}
        self.domain = domain

    def validate(self):
        if self.domain:
            self.domain.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            temp_model = QueryDomainResponseResultDomainsDomain()
            self.domain = temp_model.from_map(m['domain'])
        return self


class QueryDomainResponseResult(TeaModel):
    def __init__(
        self,
        domains: QueryDomainResponseResultDomains = None,
    ):
        # {"en":"domain list", "zh_CN":"域名配置列表"}
        self.domains = domains

    def validate(self):
        self.validate_required(self.domains, 'domains')
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['domains'] = self.domains.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domains') is not None:
            temp_model = QueryDomainResponseResultDomains()
            self.domains = temp_model.from_map(m['domains'])
        return self


class QueryDomainResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        result: QueryDomainResponseResult = None,
    ):
        # {"en":"Response code, 200 means successful.", "zh_CN":"接口响应code，200代表成功。"}
        self.code = code
        # {"en":"data result.", "zh_CN":"查询结果"}
        self.result = result

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.result, 'result')
        if self.result:
            self.result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.result is not None:
            result['result'] = self.result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('result') is not None:
            temp_model = QueryDomainResponseResult()
            self.result = temp_model.from_map(m['result'])
        return self


class QueryDomainPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainParameters(TeaModel):
    def __init__(
        self,
        service_type: str = None,
        domain: str = None,
        return_ssl: str = None,
    ):
        # {"en":"OfferCode", "zh_CN":"商品编码"}
        self.service_type = service_type
        # {"en":"Domain names, multiple entries allowed, separated by ';'.", "zh_CN":"域名，允许传多个，用“;”分隔。"}
        self.domain = domain
        # {"en":"Whether to filter based on the presence of an SSL certificate. Not passing a value means no filtering; passing 'no' means only returning domain names without a certificate; passing any other value is considered as returning only domain names with a certificate.", "zh_CN":"是否按有使用SSL证书进行过滤。不传表示不过滤；传no表示仅返回未使用证书的域名；传其它值视为仅返回有使用证书的域名。"}
        self.return_ssl = return_ssl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        if self.domain is not None:
            result['domain'] = self.domain
        if self.return_ssl is not None:
            result['returnSsl'] = self.return_ssl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('returnSsl') is not None:
            self.return_ssl = m.get('returnSsl')
        return self


class QueryDomainRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCompressionConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCompressionConfigResponseCompressionSettings(TeaModel):
    def __init__(
        self,
        compression_enabled: str = None,
        path_pattern: str = None,
        ignore_letter_case: str = None,
        file_types: List[str] = None,
        file_type_others: List[str] = None,
        br_types: str = None,
    ):
        # {"en":"To enable compress setting, allowed true or false.", "zh_CN":"开启压缩响应功能：允许值为true和false"}
        self.compression_enabled = compression_enabled
        # {"en":"The url matching mode. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Whether to ignore letter case.", "zh_CN":"是否忽略大小写：允许值为true和false"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Define the file types to be compressed. 'text/' will be compressed by default.", "zh_CN":"配置需要压缩的文件类型，默认只对'text'文件类型压缩，配置为*时压缩任意文件类型"}
        self.file_types = file_types
        # {"en":"Another way to specify the file type to open the compressed response, <file-types-other/> can be cleared and the configuration is the parent tag of file-type-other", "zh_CN":"指定文件类型开启压缩响应的另一种方式，<file-types-other/>可清空配置，是file-type-other的父标签"}
        self.file_type_others = file_type_others
        # {"en":"Use br compression.The allowed values are true and false.", "zh_CN":"是否使用br压缩：允许值为true和false"}
        self.br_types = br_types

    def validate(self):
        self.validate_required(self.compression_enabled, 'compression_enabled')
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.ignore_letter_case, 'ignore_letter_case')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_type_others, 'file_type_others')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.compression_enabled is not None:
            result['compression-enabled'] = self.compression_enabled
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.file_types is not None:
            result['file-types'] = self.file_types
        if self.file_type_others is not None:
            result['file-type-others'] = self.file_type_others
        if self.br_types is not None:
            result['br-types'] = self.br_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('compression-enabled') is not None:
            self.compression_enabled = m.get('compression-enabled')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('file-types') is not None:
            self.file_types = m.get('file-types')
        if m.get('file-type-others') is not None:
            self.file_type_others = m.get('file-type-others')
        if m.get('br-types') is not None:
            self.br_types = m.get('br-types')
        return self


class QueryCompressionConfigResponse(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        compression_settings: QueryCompressionConfigResponseCompressionSettings = None,
    ):
        # {"en":"The domain id you are query.", "zh_CN":"需要查询配置的域名id"}
        self.domain_id = domain_id
        # {"en":"The domain name you are query.", "zh_CN":"需要查询配置的域名"}
        self.domain_name = domain_name
        # {"en":"Compress setting config", "zh_CN":"压缩响应功能配置
        # 1.需要设置压缩响应配置时，此项必填
        # 2.为<compression-settings/>空时清空压缩响应配置"}
        self.compression_settings = compression_settings

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.compression_settings, 'compression_settings')
        if self.compression_settings:
            self.compression_settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.compression_settings is not None:
            result['compression-settings'] = self.compression_settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('compression-settings') is not None:
            temp_model = QueryCompressionConfigResponseCompressionSettings()
            self.compression_settings = temp_model.from_map(m['compression-settings'])
        return self


class QueryCompressionConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain you want to query, support domain id and domain name.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryCompressionConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCompressionConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCompressionConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateDomainSrcStrategyForWplusRequestAdvSrcSettingAdvSrcConfigs(TeaModel):
    def __init__(
        self,
        master_ips: List[str] = None,
        backup_ips: List[str] = None,
    ):
        # {"en":"Advanced origin primarily involves Back-to-origin IP/domain, supports multiple IPs/domains, and must be unique.", "zh_CN":"高级源主要回源IP/域名，支持多个IP/域名，不能重复"}
        self.master_ips = master_ips
        # {"en":"Advanced origin backup to back-to-origin IP/domain supports multiple IPs/domains without duplication.", "zh_CN":"高级源备用回源IP/域名，支持多个IP/域名，不能重复"}
        self.backup_ips = backup_ips

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_ips is not None:
            result['masterIps'] = self.master_ips
        if self.backup_ips is not None:
            result['backupIps'] = self.backup_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('masterIps') is not None:
            self.master_ips = m.get('masterIps')
        if m.get('backupIps') is not None:
            self.backup_ips = m.get('backupIps')
        return self


class UpdateDomainSrcStrategyForWplusRequestAdvSrcSetting(TeaModel):
    def __init__(
        self,
        use_adv_src: bool = None,
        detect_url: str = None,
        detect_period: int = None,
        adv_src_configs: List[UpdateDomainSrcStrategyForWplusRequestAdvSrcSettingAdvSrcConfigs] = None,
    ):
        # {"en":"Whether to use Advanced origin; the optional values are true or false.
        # Enable Advanced Origin
        # false: Disable advanced origin
        # Notice:
        # 1. When useAdvSrc=true, at least one advanced back-to-origin IP or domain must be set.
        # 2. When useAdvSrc=true, if the domain is manually configured with an Advanced origin in the background, and there are additional special configurations for the Advanced origin, modifying the Advanced origin via the API is prohibited.", "zh_CN":"是否使用高级源，可选值为true、false
        # true：开启高级源
        # false：关闭高级源
        # 注意：
        # 1、当useAdvSrc=true时，至少要设置一个高级源的回源IP/域名
        # 2、当useAdvSrc=true时，如果域名已经通过后台人工配置了高级源，并且存在高级源其他特殊配置时，则不允许通过API接口修改高级源"}
        self.use_adv_src = use_adv_src
        # {"en":"Advanced origin monitoring URL, request through this URL <master-ips>. If the response is not 2** or 3**, the primary origin IP is deemed faulty. Use <backup-ips> in this case.
        # For instance, the full URL: http://a.example.com/test.html", "zh_CN":"高级源监控url，通过该url请求<master-ips>，如果返回非2**，3**响应时，认为主要回源IP故障，此时使用<backup-ips>
        # 完整的url，例如：http://a.example.com/test.html"}
        self.detect_url = detect_url
        # {"en":"Advanced origin monitoring period, in seconds. Optional value is an integer greater than or equal to 0; 0 means no monitoring.", "zh_CN":"高级源监控周期，单位秒，可选值为大于等于0的整数，0表示不监控"}
        self.detect_period = detect_period
        self.adv_src_configs = adv_src_configs

    def validate(self):
        if self.adv_src_configs:
            for k in self.adv_src_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.use_adv_src is not None:
            result['useAdvSrc'] = self.use_adv_src
        if self.detect_url is not None:
            result['detectUrl'] = self.detect_url
        if self.detect_period is not None:
            result['detectPeriod'] = self.detect_period
        if self.adv_src_configs is not None:
            result['advSrcConfigs'] = []
            for k in self.adv_src_configs:
                result['advSrcConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('useAdvSrc') is not None:
            self.use_adv_src = m.get('useAdvSrc')
        if m.get('detectUrl') is not None:
            self.detect_url = m.get('detectUrl')
        if m.get('detectPeriod') is not None:
            self.detect_period = m.get('detectPeriod')
        if m.get('advSrcConfigs') is not None:
            self.adv_src_configs = []
            for k in m.get('advSrcConfigs'):
                temp_model = UpdateDomainSrcStrategyForWplusRequestAdvSrcSettingAdvSrcConfigs()
                self.adv_src_configs.append(temp_model.from_map(k))
        return self


class UpdateDomainSrcStrategyForWplusRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        use_range: bool = None,
        follow_301: bool = None,
        follow_302: bool = None,
        adv_src_setting: UpdateDomainSrcStrategyForWplusRequestAdvSrcSetting = None,
    ):
        # {"en":"DomainName", "zh_CN":"要修改配置的加速域名，一次仅支持修改一个域名的配置信息"}
        self.domain_name = domain_name
        # {"en":"Enable or disable the Back-to-origin function. The available options are true and false.
        # Enable origin range request
        # false: Disable Range Back-to-Origin
        # Not transferred: means unchanged
        # Notice:
        # 1. The Range is an HTTP request header used to request specific file segments. For instance, Range: bytes=0-999 requests the first 1000 bytes of the file. Enabling Range Back-to-origin configuration enhances large file distribution efficiency and response speed. The Origin must support range requests, or it will result in Back-to-origin failure.
        # The default back-to-origin range for domains with download acceleration is enabled, while for domains with web acceleration, it is disabled.", "zh_CN":"设置range回源功能的开启或关闭，可选值为true、false
        # true：开启range回源
        # false：关闭range回源
        # 不传：表示不修改
        # 注意：
        # 1、Range是Http请求头，用于文件指定部分的请求。如：Range: bytes=0-999   就是请求该文件的前1000个字节。开启Range回源配置能够有效提高大文件分发效率，提升响应速度。源站需要支持range请求，否则会导致回源失败。
        # 2、下载加速的域名默认range回源为开启状态，网页加速的域名默认为关闭状态"}
        self.use_range = use_range
        # {"en":"Configure the Back-to-origin to follow 301. When a Back-to-origin request from the node returns a 301 status code, the CDN node will directly request resources from the redirect address instead of passing the 301 status back to the user. The available options are true and false.
        # Enable 301 Redirect
        # disable 301 redirect follow
        # Not transferred: indicates no modification", "zh_CN":"设置回源跟随301。当节点回源请求返回301状态码时，CDN节点会直接向跳转地址请求资源而不返回301给用户。可选值为true、false
        # true：开启301跟随
        # false：关闭301跟随
        # 不传：表示不修改"}
        self.follow_301 = follow_301
        # {"en":"Configure the Back-to-origin to follow 302 redirects. When the Back-to-origin request from a CDN node receives a 302 status code, the CDN node will directly fetch resources from the redirect address instead of sending a 302 status back to the user. Possible values are true and false.
        # Enable 302 redirection
        # false: disable 302 follow
        # Not transferred means unchanged", "zh_CN":"设置回源跟随302。当节点回源请求返回302状态码时，CDN节点会直接向跳转地址请求资源而不返回302给用户。可选值为true、false
        # true：开启302跟随
        # false：关闭302跟随
        # 不传：表示不修改"}
        self.follow_302 = follow_302
        # {"en":"Configuring Advanced Origin Policy", "zh_CN":"设置高级源策略"}
        self.adv_src_setting = adv_src_setting

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        if self.adv_src_setting:
            self.adv_src_setting.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.use_range is not None:
            result['useRange'] = self.use_range
        if self.follow_301 is not None:
            result['follow301'] = self.follow_301
        if self.follow_302 is not None:
            result['follow302'] = self.follow_302
        if self.adv_src_setting is not None:
            result['advSrcSetting'] = self.adv_src_setting.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('useRange') is not None:
            self.use_range = m.get('useRange')
        if m.get('follow301') is not None:
            self.follow_301 = m.get('follow301')
        if m.get('follow302') is not None:
            self.follow_302 = m.get('follow302')
        if m.get('advSrcSetting') is not None:
            temp_model = UpdateDomainSrcStrategyForWplusRequestAdvSrcSetting()
            self.adv_src_setting = temp_model.from_map(m['advSrcSetting'])
        return self


class UpdateDomainSrcStrategyForWplusResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"A unique identifier used to query the task for each request (applicable to all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"Error code displayed when HTTPStatus is not 202, indicating the error type of the current request invocation.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response details, indicates success if successful.", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateDomainSrcStrategyForWplusPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainSrcStrategyForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainSrcStrategyForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainSrcStrategyForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryHttpCodeCasheConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttpCodeCasheConfigResponseHttpCodeCacheRules(TeaModel):
    def __init__(
        self,
        http_codes: List[int] = None,
        cache_ttl: int = None,
        data_id: int = None,
    ):
        # {"en":"Configure HTTP status code, parent node", "zh_CN":"配置http状态码，父标签"}
        self.http_codes = http_codes
        # {"en":"Define the caching time of the specified status code in units s, 0 to indicate no caching", "zh_CN":"配置指定的状态码的缓存时间，单位s，0表示不缓存"}
        self.cache_ttl = cache_ttl
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.http_codes, 'http_codes')
        self.validate_required(self.cache_ttl, 'cache_ttl')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_codes is not None:
            result['http-codes'] = self.http_codes
        if self.cache_ttl is not None:
            result['cache-ttl'] = self.cache_ttl
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http-codes') is not None:
            self.http_codes = m.get('http-codes')
        if m.get('cache-ttl') is not None:
            self.cache_ttl = m.get('cache-ttl')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class QueryHttpCodeCasheConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        http_code_cache_rules: List[QueryHttpCodeCasheConfigResponseHttpCodeCacheRules] = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置域名id"}
        self.domain_id = domain_id
        # {"en":"State Code Caching Rule Configuration, parent node
        # 1. When you need to set state code caching rules, this must be filled in.
        # 2. Configuration of Clear State Code Caching Rules for <http-code-cache-rules/>.", "zh_CN":"状态码缓存规则配置，父标签
        # 1.需要设置状态码缓存规则时，此项必填
        # 2.为<http-code-cache-rules/>时清空状态码缓存规则配置"}
        self.http_code_cache_rules = http_code_cache_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.http_code_cache_rules, 'http_code_cache_rules')
        if self.http_code_cache_rules:
            for k in self.http_code_cache_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.http_code_cache_rules is not None:
            result['http-code-cache-rules'] = []
            for k in self.http_code_cache_rules:
                result['http-code-cache-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('http-code-cache-rules') is not None:
            self.http_code_cache_rules = []
            for k in m.get('http-code-cache-rules'):
                temp_model = QueryHttpCodeCasheConfigResponseHttpCodeCacheRules()
                self.http_code_cache_rules.append(temp_model.from_map(k))
        return self


class QueryHttpCodeCasheConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryHttpCodeCasheConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttpCodeCasheConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttpCodeCasheConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryDomainRangeFollowConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainRangeFollowConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        use_range: str = None,
        follow_301: str = None,
        follow_302: str = None,
    ):
        # {"en":"DomainName", "zh_CN":"加速域名"}
        self.domain_name = domain_name
        # {"en":"Back-to-origin function. The available options are true and false.
        # true: Enable origin range request
        # false: Disable Range Back-to-Origin
        # Not transferred: means unchanged
        # Notice:
        # 1. The Range is an HTTP request header used to request specific file segments. For instance, Range: bytes=0-999 requests the first 1000 bytes of the file. Enabling Range Back-to-origin configuration enhances large file distribution efficiency and response speed. The Origin must support range requests, or it will result in Back-to-origin failure.
        # The default back-to-origin range for domains with download acceleration is enabled, while for domains with web acceleration, it is disabled.", "zh_CN":"range回源功能的开启或关闭，可选值为true、false
        # true：开启range回源
        # false：关闭range回源
        # 不传：表示不修改
        # 注意：
        # 1、Range是Http请求头，用于文件指定部分的请求。如：Range: bytes=0-999   就是请求该文件的前1000个字节。开启Range回源配置能够有效提高大文件分发效率，提升响应速度。源站需要支持range请求，否则会导致回源失败。
        # 2、下载加速的域名默认range回源为开启状态，网页加速的域名默认为关闭状态"}
        self.use_range = use_range
        # {"en":"Back-to-origin to follow 301. When a Back-to-origin request from the node returns a 301 status code, the CDN node will directly request resources from the redirect address instead of passing the 301 status back to the user. The available options are true and false.
        # Enable 301 Redirect
        # disable 301 redirect follow", "zh_CN":"回源跟随301。当节点回源请求返回301状态码时，CDN节点会直接向跳转地址请求资源而不返回301给用户。可选值为true、false
        # true：开启301跟随
        # false：关闭301跟随"}
        self.follow_301 = follow_301
        # {"en":"Back-to-origin to follow 302 redirects. When the Back-to-origin request from a CDN node receives a 302 status code, the CDN node will directly fetch resources from the redirect address instead of sending a 302 status back to the user. Possible values are true and false.
        # Enable 302 redirection
        # false: disable 302 follow", "zh_CN":"回源跟随302。当节点回源请求返回302状态码时，CDN节点会直接向跳转地址请求资源而不返回302给用户。可选值为true、false
        # true：开启302跟随
        # false：关闭302跟随"}
        self.follow_302 = follow_302

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.use_range, 'use_range')
        self.validate_required(self.follow_301, 'follow_301')
        self.validate_required(self.follow_302, 'follow_302')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.use_range is not None:
            result['useRange'] = self.use_range
        if self.follow_301 is not None:
            result['follow301'] = self.follow_301
        if self.follow_302 is not None:
            result['follow302'] = self.follow_302
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('useRange') is not None:
            self.use_range = m.get('useRange')
        if m.get('follow301') is not None:
            self.follow_301 = m.get('follow301')
        if m.get('follow302') is not None:
            self.follow_302 = m.get('follow302')
        return self


class QueryDomainRangeFollowConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryDomainRangeFollowConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainRangeFollowConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainRangeFollowConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAccessspeedConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAccessspeedConfigResponseAccessSpeedRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        limit_mode: str = None,
        start_size: str = None,
        start_time: str = None,
        start_speed: str = None,
        speed: str = None,
        priority: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Define the limitation mode. Allowed 'size'(with unit KB) or 'time'(with unit s). You can define only one mode in the same time.", "zh_CN":"限速方式，可按开始大小（单位KB）或开始时间（单位s）限速，两者互斥
        # 允许值：size/time"}
        self.limit_mode = limit_mode
        # {"en":"Start limit size, with unit KB. Limitation starts.after the amount of bytes. 0 means no limitation.
        # When limit-mode equals 'size', this item is required.", "zh_CN":"开始限制字节，单位KB，从多少字节后开始限制，0表示不限制
        # limit-mode为size时,此项必填"}
        self.start_size = start_size
        # {"en":"Start limit time, with unit s. Limitation starts.after the time specified. 0 means no limitation.
        # When limit-mode equals 'time', this item is required.", "zh_CN":"开始限制时间，单位s，从建连后多长时间后开始限制，0表示不限制
        # limit-mode为time时,此项必填"}
        self.start_time = start_time
        # {"en":"The speed before limitation, with unit KB/s. -1 means no limitation.", "zh_CN":"开始限制之前的速率，单位KB/s，-1表示不限制"}
        self.start_speed = start_speed
        # {"en":"The limit speed, with unit KB/s.", "zh_CN":"限速值，指限制之后的速率，稳定速率，单位KB/s"}
        self.speed = speed
        # {"en":"fill in the integer, if match multiple entries, Large number has a high priority", "zh_CN":"优先级，填写整数，当配置多条时数字大的优先"}
        self.priority = priority
        # {"en":"DataId is to indicate a specific group configuration when the client has multiple groups of configurations. dataId can be retrieved through a query interface. Note: A. If dataId is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with dataId and others are not, then the expression of dataId is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of dataId. C. If the dataId is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the dataId must be filled in, and the value is the actual dataId, which means clearing the value of the corresponding dataId configuration item; it is not allowed that there is no specific configuration item or dataId in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。本功能只支持一组配置。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改该组配置项内容； b、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； c、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.limit_mode, 'limit_mode')
        self.validate_required(self.start_size, 'start_size')
        self.validate_required(self.start_time, 'start_time')
        self.validate_required(self.start_speed, 'start_speed')
        self.validate_required(self.speed, 'speed')
        self.validate_required(self.priority, 'priority')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.limit_mode is not None:
            result['limit-mode'] = self.limit_mode
        if self.start_size is not None:
            result['start-size'] = self.start_size
        if self.start_time is not None:
            result['start-time'] = self.start_time
        if self.start_speed is not None:
            result['start-speed'] = self.start_speed
        if self.speed is not None:
            result['speed'] = self.speed
        if self.priority is not None:
            result['priority'] = self.priority
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('limit-mode') is not None:
            self.limit_mode = m.get('limit-mode')
        if m.get('start-size') is not None:
            self.start_size = m.get('start-size')
        if m.get('start-time') is not None:
            self.start_time = m.get('start-time')
        if m.get('start-speed') is not None:
            self.start_speed = m.get('start-speed')
        if m.get('speed') is not None:
            self.speed = m.get('speed')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryAccessspeedConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        access_speed_rules: List[QueryAccessspeedConfigResponseAccessSpeedRules] = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        # {"en":"Access speed limitation configuration.
        # Note:
        # 1.When you want to limit access speed, this item is required.
        # 2.When you want to cancel it, please pass <access-speed-rules/>", "zh_CN":"访问限速配置
        # 1.需要访问限速时，此项必填
        # 2.为<access-speed-rules/>时清空访问限速配置"}
        self.access_speed_rules = access_speed_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.access_speed_rules, 'access_speed_rules')
        if self.access_speed_rules:
            for k in self.access_speed_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.access_speed_rules is not None:
            result['access-speed-rules'] = []
            for k in self.access_speed_rules:
                result['access-speed-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('access-speed-rules') is not None:
            self.access_speed_rules = []
            for k in m.get('access-speed-rules'):
                temp_model = QueryAccessspeedConfigResponseAccessSpeedRules()
                self.access_speed_rules.append(temp_model.from_map(k))
        return self


class QueryAccessspeedConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryAccessspeedConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAccessspeedConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAccessspeedConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainHlsRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainHlsResponseDataSlices(TeaModel):
    def __init__(
        self,
        enable_hls: bool = None,
        m_3u_8seg_num: int = None,
        first_m3u_8seg_num: int = None,
        seg_duration: int = None,
        new_meta_seq_reset: bool = None,
    ):
        # {"en":"Enable HLS", "zh_CN":"是否启用HLS"}
        self.enable_hls = enable_hls
        # {"en":"M3u8 Seg Num", "zh_CN":"普通m3u8切片个数"}
        self.m_3u_8seg_num = m_3u_8seg_num
        # {"en":"First M3u8 Seg Num", "zh_CN":"首个m3u8切片个数"}
        self.first_m3u_8seg_num = first_m3u_8seg_num
        # {"en":"Seg Duration", "zh_CN":"切片间隔，单位秒"}
        self.seg_duration = seg_duration
        # {"en":"New Meta Seq Reset", "zh_CN":"收到新的metadata是否重置sequence"}
        self.new_meta_seq_reset = new_meta_seq_reset

    def validate(self):
        self.validate_required(self.enable_hls, 'enable_hls')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_hls is not None:
            result['enableHls'] = self.enable_hls
        if self.m_3u_8seg_num is not None:
            result['m3u8SegNum'] = self.m_3u_8seg_num
        if self.first_m3u_8seg_num is not None:
            result['firstM3u8SegNum'] = self.first_m3u_8seg_num
        if self.seg_duration is not None:
            result['segDuration'] = self.seg_duration
        if self.new_meta_seq_reset is not None:
            result['newMetaSeqReset'] = self.new_meta_seq_reset
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHls') is not None:
            self.enable_hls = m.get('enableHls')
        if m.get('m3u8SegNum') is not None:
            self.m_3u_8seg_num = m.get('m3u8SegNum')
        if m.get('firstM3u8SegNum') is not None:
            self.first_m3u_8seg_num = m.get('firstM3u8SegNum')
        if m.get('segDuration') is not None:
            self.seg_duration = m.get('segDuration')
        if m.get('newMetaSeqReset') is not None:
            self.new_meta_seq_reset = m.get('newMetaSeqReset')
        return self


class QueryLiveDomainHlsResponseDataCacheTimeRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        cache_time: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainHlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Cache Time", "zh_CN":"缓存时间，整数加单位，比如20s、30m、1h、2d"}
        self.cache_time = cache_time

    def validate(self):
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.cache_time, 'cache_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainHlsPaths'] = self.file_paths
        if self.cache_time is not None:
            result['cacheTime'] = self.cache_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainHlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainHlsPaths')
        if m.get('cacheTime') is not None:
            self.cache_time = m.get('cacheTime')
        return self


class QueryLiveDomainHlsResponseDataQueryStringRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        ignore_query_string: bool = None,
        ignore_case: bool = None,
        query_string_2origin: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainHlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Ignore Query String", "zh_CN":"是否去问号缓存"}
        self.ignore_query_string = ignore_query_string
        # {"en":"Ignore Case", "zh_CN":"是否忽略querystring大小写"}
        self.ignore_case = ignore_case
        # {"en":"Query String To Origin", "zh_CN":"回源是否带querystring"}
        self.query_string_2origin = query_string_2origin

    def validate(self):
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.ignore_query_string, 'ignore_query_string')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainHlsPaths'] = self.file_paths
        if self.ignore_query_string is not None:
            result['ignoreQueryString'] = self.ignore_query_string
        if self.ignore_case is not None:
            result['ignoreCase'] = self.ignore_case
        if self.query_string_2origin is not None:
            result['queryString2Origin'] = self.query_string_2origin
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainHlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainHlsPaths')
        if m.get('ignoreQueryString') is not None:
            self.ignore_query_string = m.get('ignoreQueryString')
        if m.get('ignoreCase') is not None:
            self.ignore_case = m.get('ignoreCase')
        if m.get('queryString2Origin') is not None:
            self.query_string_2origin = m.get('queryString2Origin')
        return self


class QueryLiveDomainHlsResponseData(TeaModel):
    def __init__(
        self,
        slices: QueryLiveDomainHlsResponseDataSlices = None,
        cache_time_rules: List[QueryLiveDomainHlsResponseDataCacheTimeRules] = None,
        query_string_rules: List[QueryLiveDomainHlsResponseDataQueryStringRules] = None,
    ):
        # {"en":"Slices", "zh_CN":"多协议输出-HLS"}
        self.slices = slices
        # {"en":"Cache Time Rules", "zh_CN":"节点缓存-缓存时间配置"}
        self.cache_time_rules = cache_time_rules
        # {"en":"Query String Rules", "zh_CN":"节点缓存-带问号缓存配置"}
        self.query_string_rules = query_string_rules

    def validate(self):
        if self.slices:
            self.slices.validate()
        if self.cache_time_rules:
            for k in self.cache_time_rules:
                if k:
                    k.validate()
        if self.query_string_rules:
            for k in self.query_string_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slices is not None:
            result['slices'] = self.slices.to_map()
        if self.cache_time_rules is not None:
            result['cacheTimeRules'] = []
            for k in self.cache_time_rules:
                result['cacheTimeRules'].append(k.to_map() if k else None)
        if self.query_string_rules is not None:
            result['queryStringRules'] = []
            for k in self.query_string_rules:
                result['queryStringRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('slices') is not None:
            temp_model = QueryLiveDomainHlsResponseDataSlices()
            self.slices = temp_model.from_map(m['slices'])
        if m.get('cacheTimeRules') is not None:
            self.cache_time_rules = []
            for k in m.get('cacheTimeRules'):
                temp_model = QueryLiveDomainHlsResponseDataCacheTimeRules()
                self.cache_time_rules.append(temp_model.from_map(k))
        if m.get('queryStringRules') is not None:
            self.query_string_rules = []
            for k in m.get('queryStringRules'):
                temp_model = QueryLiveDomainHlsResponseDataQueryStringRules()
                self.query_string_rules.append(temp_model.from_map(k))
        return self


class QueryLiveDomainHlsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainHlsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainHlsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainHlsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainHlsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainHlsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainHlsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAliyunOssAuthorizationConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAliyunOssAuthorizationConfigResponseAliyunOssAccessAuthorizationRules(TeaModel):
    def __init__(
        self,
        add_authorization_header: str = None,
        access_key: str = None,
        access_key_id: str = None,
        data_id: int = None,
    ):
        # {"en":"Define whether to add Authorization header when back to Aliyun OSS source. Allowed  true and false.", "zh_CN":"是否添加鉴权头部，为true，则回源按照Aliyun OSS的算法添加 添加Authorization头部。
        # 允许值为true和false，默认为false"}
        self.add_authorization_header = add_authorization_header
        # {"en":"access key", "zh_CN":"校验所需的密钥"}
        self.access_key = access_key
        # {"en":"access key id", "zh_CN":"校验所需的密钥ID"}
        self.access_key_id = access_key_id
        # {"en":"When configuring multiple configurations, the ID of a specific group of configurations", "zh_CN":"配置多组配置时，具体某组配置的id"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.add_authorization_header, 'add_authorization_header')
        self.validate_required(self.access_key, 'access_key')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_authorization_header is not None:
            result['add-authorization-header'] = self.add_authorization_header
        if self.access_key is not None:
            result['access-key'] = self.access_key
        if self.access_key_id is not None:
            result['access-key-id'] = self.access_key_id
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add-authorization-header') is not None:
            self.add_authorization_header = m.get('add-authorization-header')
        if m.get('access-key') is not None:
            self.access_key = m.get('access-key')
        if m.get('access-key-id') is not None:
            self.access_key_id = m.get('access-key-id')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class QueryAliyunOssAuthorizationConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        aliyun_oss_access_authorization_rules: List[QueryAliyunOssAuthorizationConfigResponseAliyunOssAccessAuthorizationRules] = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        # {"en":"Aliyun OSS access Authorization Configuration, parent node
        # 1. When you need to configure the Aliyun OSS access Authorization rules, this must be filled in.
        # 2. Configuration of clearing for <aliyun-oss-access-authorization-rules/>.
        # 3.vodstream/download support, web/wsa does not support.
        # 4.Amason S3 and Aliyun OSS cannot be configured simultaneously.", "zh_CN":"Aliyun OSS鉴权配置，父标签
        # 1.需要设置Aliyun OSS鉴权时，此项必填
        # 2.为<aliyun-oss-access-authorization-rules/>时清空Aliyun OSS鉴权的配置
        # 3.点播下载支持，网页wsa不支持
        # 4.Amason S3和Aliyun OSS不可同时配置"}
        self.aliyun_oss_access_authorization_rules = aliyun_oss_access_authorization_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.aliyun_oss_access_authorization_rules, 'aliyun_oss_access_authorization_rules')
        if self.aliyun_oss_access_authorization_rules:
            for k in self.aliyun_oss_access_authorization_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.aliyun_oss_access_authorization_rules is not None:
            result['aliyun-oss-access-authorization-rules'] = []
            for k in self.aliyun_oss_access_authorization_rules:
                result['aliyun-oss-access-authorization-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('aliyun-oss-access-authorization-rules') is not None:
            self.aliyun_oss_access_authorization_rules = []
            for k in m.get('aliyun-oss-access-authorization-rules'):
                temp_model = QueryAliyunOssAuthorizationConfigResponseAliyunOssAccessAuthorizationRules()
                self.aliyun_oss_access_authorization_rules.append(temp_model.from_map(k))
        return self


class QueryAliyunOssAuthorizationConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryAliyunOssAuthorizationConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAliyunOssAuthorizationConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAliyunOssAuthorizationConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateStreamNotificationConfigRequestStreamNotificationsNotifyParams(TeaModel):
    def __init__(
        self,
        notify_type: str = None,
        path: str = None,
        id: str = None,
        client_ip: str = None,
        node_ip: str = None,
        app: str = None,
        app_name: str = None,
        port: str = None,
        mill_time: str = None,
        custom_params: str = None,
    ):
        # {"en":"notifyType", "zh_CN":"可选值：publish_start、publish_end，分别表示推流开始和推流结束(断流)"}
        self.notify_type = notify_type
        # {"en":"Notify path, it should start with a slash.", "zh_CN":"推流汇报路径，/ 开头"}
        self.path = path
        # {"en":"Stream name, the default is 'id', cannot be cleared.", "zh_CN":"流名，不传默认为id，不可清空"}
        self.id = id
        # {"en":"Streaming client IP, anchor IP, the default is 'ip', cannot be cleared.", "zh_CN":"推流的客户端IP，主播IP，不传默认为ip，不可清空"}
        self.client_ip = client_ip
        # {"en":"The IP of the node where the CDN accepts the streaming, the default is 'node', cannot be cleared.", "zh_CN":"CDN接受推流的节点IP，不传默认为node，不可清空"}
        self.node_ip = node_ip
        # {"en":"Push domain, the default is 'app', cannot be cleared.", "zh_CN":"推流域名，不传默认为app，不可清空"}
        self.app = app
        # {"en":"AppName, the default is 'appname', cannot be cleared.", "zh_CN":"发布点，不传默认为appname，不可清空"}
        self.app_name = app_name
        # {"en":"Port, the default is 'port', cannot be cleared.", "zh_CN":"端口，不传默认为port，不可清空"}
        self.port = port
        # {"en":"Report time (milliseconds), the default is 'milltime', cannot be cleared.", "zh_CN":"汇报时间（毫秒级），不传默认为milltime，不可清空"}
        self.mill_time = mill_time
        # {"en":"Specify the parameters to be carried in the push report, which come from the user push parameters, and these parameters are not carried by default. Separated by semicolons.", "zh_CN":"指定推流汇报要携带的参数，来自用户推流参数，默认不携带这些参数。多个按分号分隔。"}
        self.custom_params = custom_params

    def validate(self):
        self.validate_required(self.notify_type, 'notify_type')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.notify_type is not None:
            result['notifyType'] = self.notify_type
        if self.path is not None:
            result['path'] = self.path
        if self.id is not None:
            result['id'] = self.id
        if self.client_ip is not None:
            result['clientIp'] = self.client_ip
        if self.node_ip is not None:
            result['nodeIp'] = self.node_ip
        if self.app is not None:
            result['app'] = self.app
        if self.app_name is not None:
            result['appName'] = self.app_name
        if self.port is not None:
            result['port'] = self.port
        if self.mill_time is not None:
            result['millTime'] = self.mill_time
        if self.custom_params is not None:
            result['customParams'] = self.custom_params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('notifyType') is not None:
            self.notify_type = m.get('notifyType')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('clientIp') is not None:
            self.client_ip = m.get('clientIp')
        if m.get('nodeIp') is not None:
            self.node_ip = m.get('nodeIp')
        if m.get('app') is not None:
            self.app = m.get('app')
        if m.get('appName') is not None:
            self.app_name = m.get('appName')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('millTime') is not None:
            self.mill_time = m.get('millTime')
        if m.get('customParams') is not None:
            self.custom_params = m.get('customParams')
        return self


class UpdateStreamNotificationConfigRequestStreamNotifications(TeaModel):
    def __init__(
        self,
        enable_stream_notification: bool = None,
        notify_address: str = None,
        notify_method: str = None,
        notify_params: List[UpdateStreamNotificationConfigRequestStreamNotificationsNotifyParams] = None,
        data_id: int = None,
    ):
        # {"en":"Switch for streaming notification feature. The optional values are true and false.", "zh_CN":"推流状态反馈开关配置，可选值为true和false。
        # 为true则开启，且需完整设置配置信息
        # 为false则其他入参无效。"}
        self.enable_stream_notification = enable_stream_notification
        # {"en":"Notify address, format is protocol://{host:port}, the protocol is HTTP or HTTPS, for example:
        # http://www.exam.com 
        # http://www.exam.com:81
        # http://12.12.12.12
        # http://12.12.12.12:81", "zh_CN":"推流状态汇报地址，格式为：protocol://{host:port}，例如：
        # http://www.exam.com 
        # http://www.exam.com:81
        # http://12.12.12.12
        # http://12.12.12.12:81"}
        self.notify_address = notify_address
        # {"en":"Request method, support POST and GET.", "zh_CN":"推流汇报请求方式，支持POST和GET"}
        self.notify_method = notify_method
        # {"en":"notifyParams", "zh_CN":"设置推流开始的汇报参数，推流结束的汇报参数。最多只能有一个开始，一个结束。"}
        self.notify_params = notify_params
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.enable_stream_notification, 'enable_stream_notification')
        self.validate_required(self.notify_address, 'notify_address')
        self.validate_required(self.notify_params, 'notify_params')
        if self.notify_params:
            for k in self.notify_params:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_stream_notification is not None:
            result['enableStreamNotification'] = self.enable_stream_notification
        if self.notify_address is not None:
            result['notifyAddress'] = self.notify_address
        if self.notify_method is not None:
            result['notifyMethod'] = self.notify_method
        if self.notify_params is not None:
            result['notifyParams'] = []
            for k in self.notify_params:
                result['notifyParams'].append(k.to_map() if k else None)
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableStreamNotification') is not None:
            self.enable_stream_notification = m.get('enableStreamNotification')
        if m.get('notifyAddress') is not None:
            self.notify_address = m.get('notifyAddress')
        if m.get('notifyMethod') is not None:
            self.notify_method = m.get('notifyMethod')
        if m.get('notifyParams') is not None:
            self.notify_params = []
            for k in m.get('notifyParams'):
                temp_model = UpdateStreamNotificationConfigRequestStreamNotificationsNotifyParams()
                self.notify_params.append(temp_model.from_map(k))
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class UpdateStreamNotificationConfigRequest(TeaModel):
    def __init__(
        self,
        stream_notifications: List[UpdateStreamNotificationConfigRequestStreamNotifications] = None,
    ):
        # {"en":"Streaming notify Configuration
        # 1. It is requied when you need to set streaming notify rules.
        # 2. Use \"streamNotifications\":[] to clear Streaming notify Configuration.", "zh_CN":"推流状态反馈配置
        # 1.需要设置推流状态反馈配置时，此项必填
        # 2.为\"streamNotifications\":[]时清空配置"}
        self.stream_notifications = stream_notifications

    def validate(self):
        self.validate_required(self.stream_notifications, 'stream_notifications')
        if self.stream_notifications:
            for k in self.stream_notifications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stream_notifications is not None:
            result['streamNotifications'] = []
            for k in self.stream_notifications:
                result['streamNotifications'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('streamNotifications') is not None:
            self.stream_notifications = []
            for k in m.get('streamNotifications'):
                temp_model = UpdateStreamNotificationConfigRequestStreamNotifications()
                self.stream_notifications.append(temp_model.from_map(k))
        return self


class UpdateStreamNotificationConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"code", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"message", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateStreamNotificationConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain whoes need to update.", "zh_CN":"需要修改的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class UpdateStreamNotificationConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateStreamNotificationConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateStreamNotificationConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAppaCarryClientIpConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaCarryClientIpConfigResponseDataCarryClientIpTcpCarryClientIp(TeaModel):
    def __init__(
        self,
        carry_client_ip_enabled: str = None,
        protocol: str = None,
        packet_num: str = None,
        mode: int = None,
        tcp_option_code: str = None,
    ):
        # {"en":"The function switch of TCP carry client IP.
        # true：Enabled
        # false：Disabled", "zh_CN":"TCP协议携带用户IP回源功能开关。
        # true：开启
        # false：关闭"}
        self.carry_client_ip_enabled = carry_client_ip_enabled
        # {"en":"The protocol of TCP carry client IP.
        # ws：The client IP is carried through TCP Option 78. The origin can get the client IP through the SDK provided by Wangsu or the F5 device.      
        # toa：Carry client IP through TOA.
        # pp：Carry client IP through Proxy Protocol.", "zh_CN":"TCP协议携带用户IP回源所使用的协议。
        # ws：通过tcp option 78携带用户IP，源站可通过F5设备或网宿提供的SDK获取用户IP。
        # toa：通过TOA携带用户IP回源。
        # pp：通过Proxy Protocol携带用户IP回源。"}
        self.protocol = protocol
        # {"en":"The number of packets carrying client IP other than SYN packet, when using ws or toa to carry client IP.", "zh_CN":"使用ws或toa携带用户IP回源时，除SYN包外携带用户IP的数据包个数。"}
        self.packet_num = packet_num
        # {"en":"The mode of TCP carry client IP by ws or toa.
        # 0：Only SYN packet carry client IP.
        # 1：SYN packet and the first N packets carry client IP,N is specified by packetNum.
        # 2：SYN packet, the first N packets, RST, PSH, URG and FIN/ACK packet carry client IP, N is specified by packetNum.", "zh_CN":"使用ws或toa携带用户IP回源的模式。
        # 0：仅SYN包携带用户IP回源。
        # 1：SYN包及前N个数据包携带用户IP回源，N由carryClientIpNum指定。
        # 2：SYN包、前N个数据包 、RST、PSH、URG、FIN/ACK包携带用户IP回源，N由carryClientIpNum指定。"}
        self.mode = mode
        # {"en":"The opcode to carry client IP  by TOA.", "zh_CN":"通过TOA携带用户IP回源时所使用的opcode。"}
        self.tcp_option_code = tcp_option_code

    def validate(self):
        self.validate_required(self.carry_client_ip_enabled, 'carry_client_ip_enabled')
        self.validate_required(self.protocol, 'protocol')
        self.validate_required(self.packet_num, 'packet_num')
        self.validate_required(self.mode, 'mode')
        self.validate_required(self.tcp_option_code, 'tcp_option_code')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.carry_client_ip_enabled is not None:
            result['carryClientIpEnabled'] = self.carry_client_ip_enabled
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.packet_num is not None:
            result['packetNum'] = self.packet_num
        if self.mode is not None:
            result['mode'] = self.mode
        if self.tcp_option_code is not None:
            result['tcpOptionCode'] = self.tcp_option_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('carryClientIpEnabled') is not None:
            self.carry_client_ip_enabled = m.get('carryClientIpEnabled')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('packetNum') is not None:
            self.packet_num = m.get('packetNum')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('tcpOptionCode') is not None:
            self.tcp_option_code = m.get('tcpOptionCode')
        return self


class QueryAppaCarryClientIpConfigResponseDataCarryClientIpHttpCarryClientIp(TeaModel):
    def __init__(
        self,
        carry_client_ip_enabled: str = None,
        ports: List[str] = None,
        http_header_name: str = None,
    ):
        # {"en":"The function switch of carry client IP through the HTTP header.
        # true：Enabled.
        # false：Disabled.", "zh_CN":"HTTP协议通过HTTP头部携带用户IP回源的功能开关。
        # true：开启
        # false：关闭"}
        self.carry_client_ip_enabled = carry_client_ip_enabled
        # {"en":"Specify which acceleration ports to carry client IP, the function of carry client IP through the HTTP header is enabled.", "zh_CN":"当开启通过HTTP头部携带用户IP回源时，指定哪些加速端口传递用户IP回源。"}
        self.ports = ports
        # {"en":"The field name of HTTP header to carry client IP, such as X-Forwarded-For, Cdn-Src-Ip.", "zh_CN":"HTTP头部携带IP字段的名称，如X-Forwarded-For、Cdn-Src-Ip。"}
        self.http_header_name = http_header_name

    def validate(self):
        self.validate_required(self.carry_client_ip_enabled, 'carry_client_ip_enabled')
        self.validate_required(self.ports, 'ports')
        self.validate_required(self.http_header_name, 'http_header_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.carry_client_ip_enabled is not None:
            result['carryClientIpEnabled'] = self.carry_client_ip_enabled
        if self.ports is not None:
            result['ports'] = self.ports
        if self.http_header_name is not None:
            result['httpHeaderName'] = self.http_header_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('carryClientIpEnabled') is not None:
            self.carry_client_ip_enabled = m.get('carryClientIpEnabled')
        if m.get('ports') is not None:
            self.ports = m.get('ports')
        if m.get('httpHeaderName') is not None:
            self.http_header_name = m.get('httpHeaderName')
        return self


class QueryAppaCarryClientIpConfigResponseDataCarryClientIp(TeaModel):
    def __init__(
        self,
        tcp_carry_client_ip: QueryAppaCarryClientIpConfigResponseDataCarryClientIpTcpCarryClientIp = None,
        http_carry_client_ip: QueryAppaCarryClientIpConfigResponseDataCarryClientIpHttpCarryClientIp = None,
    ):
        # {"en":"Carry client IP configuration for TCP.", "zh_CN":"TCP协议携带用户IP回源功能配置。"}
        self.tcp_carry_client_ip = tcp_carry_client_ip
        # {"en":"Carry client IP configuration for HTTP.", "zh_CN":"HTTP协议携带用户IP回源功能。"}
        self.http_carry_client_ip = http_carry_client_ip

    def validate(self):
        self.validate_required(self.tcp_carry_client_ip, 'tcp_carry_client_ip')
        if self.tcp_carry_client_ip:
            self.tcp_carry_client_ip.validate()
        self.validate_required(self.http_carry_client_ip, 'http_carry_client_ip')
        if self.http_carry_client_ip:
            self.http_carry_client_ip.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tcp_carry_client_ip is not None:
            result['tcpCarryClientIp'] = self.tcp_carry_client_ip.to_map()
        if self.http_carry_client_ip is not None:
            result['httpCarryClientIp'] = self.http_carry_client_ip.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tcpCarryClientIp') is not None:
            temp_model = QueryAppaCarryClientIpConfigResponseDataCarryClientIpTcpCarryClientIp()
            self.tcp_carry_client_ip = temp_model.from_map(m['tcpCarryClientIp'])
        if m.get('httpCarryClientIp') is not None:
            temp_model = QueryAppaCarryClientIpConfigResponseDataCarryClientIpHttpCarryClientIp()
            self.http_carry_client_ip = temp_model.from_map(m['httpCarryClientIp'])
        return self


class QueryAppaCarryClientIpConfigResponseData(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        carry_client_ip: QueryAppaCarryClientIpConfigResponseDataCarryClientIp = None,
    ):
        # {"en":"Domain ID.", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"Domain name.", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"Carry client IP configuration.", "zh_CN":"携带用户IP回源配置配置。"}
        self.carry_client_ip = carry_client_ip

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.carry_client_ip, 'carry_client_ip')
        if self.carry_client_ip:
            self.carry_client_ip.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.carry_client_ip is not None:
            result['carryClientIp'] = self.carry_client_ip.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('carryClientIp') is not None:
            temp_model = QueryAppaCarryClientIpConfigResponseDataCarryClientIp()
            self.carry_client_ip = temp_model.from_map(m['carryClientIp'])
        return self


class QueryAppaCarryClientIpConfigResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        message: str = None,
        data: QueryAppaCarryClientIpConfigResponseData = None,
    ):
        # {"en":"Response code, 0 means successful.", "zh_CN":"接口响应code，0代表成功。"}
        self.code = code
        # {"en":"Response error message if failed.", "zh_CN":"接口响应信息，success代表成功，失败则提供失败信息。"}
        self.message = message
        # {"en":"Response data array.", "zh_CN":"接口响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryAppaCarryClientIpConfigResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryAppaCarryClientIpConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain ID or domain name you want to get config.", "zh_CN":"指定要查询的域名名称或域名ID，在URI上"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryAppaCarryClientIpConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaCarryClientIpConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAppaCarryClientIpConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCloudStorageBasicConfigurationRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCloudStorageBasicConfigurationResponseDataCloudStorageRules(TeaModel):
    def __init__(
        self,
        storage_enabled: bool = None,
        access_key_id: str = None,
        access_key: str = None,
        storage_manage_domain: str = None,
        pull_address: str = None,
        notice_address: str = None,
        merge_notice: bool = None,
        publish_points: List[str] = None,
        data_id: int = None,
    ):
        # {"en":"This item is to open cloud storage. The optional vaules are true and false.", "zh_CN":"是否开启云存储，可选择为true、false"}
        self.storage_enabled = storage_enabled
        # {"en":"Access Key ID for uploading files.", "zh_CN":"上传文件密钥ID，Access Key ID"}
        self.access_key_id = access_key_id
        # {"en":"Secret Access Key for uploading files.", "zh_CN":"上传文件密钥，Secret Access Key"}
        self.access_key = access_key
        # {"en":"Management domain for cloud storage, used for recording / screenshot uploadingt, domain name format.", "zh_CN":"云存储的管理域名，用于录制/截图上传汇报，域名格式"}
        self.storage_manage_domain = storage_manage_domain
        # {"en":"The address of the pull tream domain. It needs to be configured with a full path in the format of http://domainname/, where the domain name is the matching  pull tream domain and must end with '/'", "zh_CN":"拉流域名地址，需要配置完整路径，格式为http://域名/，其中，域名为配套的拉流域名，必须以‘/’结束"}
        self.pull_address = pull_address
        # {"en":"Callback notification address, URL format", "zh_CN":"回调通知地址，url格式"}
        self.notice_address = notice_address
        # {"en":"Whether to notify after merging files.", "zh_CN":"是否合并通知，可选择为true、false"}
        self.merge_notice = merge_notice
        # {"en":"Setting publish point of pull push domain. This is parent Tag.
        # example:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。本功能只支持一组配置。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改该组配置项内容； b、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； c、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.storage_enabled, 'storage_enabled')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.access_key, 'access_key')
        self.validate_required(self.storage_manage_domain, 'storage_manage_domain')
        self.validate_required(self.pull_address, 'pull_address')
        self.validate_required(self.notice_address, 'notice_address')
        self.validate_required(self.merge_notice, 'merge_notice')
        self.validate_required(self.publish_points, 'publish_points')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_enabled is not None:
            result['storageEnabled'] = self.storage_enabled
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key is not None:
            result['accessKey'] = self.access_key
        if self.storage_manage_domain is not None:
            result['storageManageDomain'] = self.storage_manage_domain
        if self.pull_address is not None:
            result['pullAddress'] = self.pull_address
        if self.notice_address is not None:
            result['noticeAddress'] = self.notice_address
        if self.merge_notice is not None:
            result['mergeNotice'] = self.merge_notice
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('storageEnabled') is not None:
            self.storage_enabled = m.get('storageEnabled')
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKey') is not None:
            self.access_key = m.get('accessKey')
        if m.get('storageManageDomain') is not None:
            self.storage_manage_domain = m.get('storageManageDomain')
        if m.get('pullAddress') is not None:
            self.pull_address = m.get('pullAddress')
        if m.get('noticeAddress') is not None:
            self.notice_address = m.get('noticeAddress')
        if m.get('mergeNotice') is not None:
            self.merge_notice = m.get('mergeNotice')
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryCloudStorageBasicConfigurationResponseData(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        cloud_storage_rules: List[QueryCloudStorageBasicConfigurationResponseDataCloudStorageRules] = None,
    ):
        # {"en":"domain id", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain_name = domain_name
        # {"en":"Recording Storage Configuration, parent node
        # 1. When you need to use the recording or screenshot function, this must be filled in.
        # 2. Configuration of clearing for <cloudStorageRules/>.", "zh_CN":"云存储配置，父标签
        # 1.需要设置录制/截图功能时，此项必填
        # 2.为<cloudStorageRules/>时清空配置"}
        self.cloud_storage_rules = cloud_storage_rules

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.cloud_storage_rules, 'cloud_storage_rules')
        if self.cloud_storage_rules:
            for k in self.cloud_storage_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.cloud_storage_rules is not None:
            result['cloudStorageRules'] = []
            for k in self.cloud_storage_rules:
                result['cloudStorageRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('cloudStorageRules') is not None:
            self.cloud_storage_rules = []
            for k in m.get('cloudStorageRules'):
                temp_model = QueryCloudStorageBasicConfigurationResponseDataCloudStorageRules()
                self.cloud_storage_rules.append(temp_model.from_map(k))
        return self


class QueryCloudStorageBasicConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryCloudStorageBasicConfigurationResponseData = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryCloudStorageBasicConfigurationResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryCloudStorageBasicConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryCloudStorageBasicConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCloudStorageBasicConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCloudStorageBasicConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainMiscRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainMiscResponseData(TeaModel):
    def __init__(
        self,
        enable_http_2: bool = None,
        redirect_http_to_https: bool = None,
        disable_rtmp: bool = None,
        disable_hdl: bool = None,
    ):
        # {"en":"Enable HTTP2", "zh_CN":"是否启用HTTP2"}
        self.enable_http_2 = enable_http_2
        # {"en":"Redirect Http To Https", "zh_CN":"请求协议类型"}
        self.redirect_http_to_https = redirect_http_to_https
        # {"en":"Disable RTMP", "zh_CN":"是否禁止RTMP协议"}
        self.disable_rtmp = disable_rtmp
        # {"en":"Disable HDL", "zh_CN":"是否禁止HDL协议"}
        self.disable_hdl = disable_hdl

    def validate(self):
        self.validate_required(self.enable_http_2, 'enable_http_2')
        self.validate_required(self.redirect_http_to_https, 'redirect_http_to_https')
        self.validate_required(self.disable_rtmp, 'disable_rtmp')
        self.validate_required(self.disable_hdl, 'disable_hdl')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_http_2 is not None:
            result['enableHttp2'] = self.enable_http_2
        if self.redirect_http_to_https is not None:
            result['redirectHttpToHttps'] = self.redirect_http_to_https
        if self.disable_rtmp is not None:
            result['disableRtmp'] = self.disable_rtmp
        if self.disable_hdl is not None:
            result['disableHdl'] = self.disable_hdl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHttp2') is not None:
            self.enable_http_2 = m.get('enableHttp2')
        if m.get('redirectHttpToHttps') is not None:
            self.redirect_http_to_https = m.get('redirectHttpToHttps')
        if m.get('disableRtmp') is not None:
            self.disable_rtmp = m.get('disableRtmp')
        if m.get('disableHdl') is not None:
            self.disable_hdl = m.get('disableHdl')
        return self


class QueryLiveDomainMiscResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainMiscResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainMiscResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainMiscPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainMiscParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainMiscRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainMiscResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateAliyunOssAuthorizationConfigRequestAliyunOssAccessAuthorizationRules(TeaModel):
    def __init__(
        self,
        add_authorization_header: str = None,
        access_key: str = None,
        access_key_id: str = None,
        data_id: int = None,
    ):
        # {"en":"Define whether to add Authorization header when back to Aliyun OSS source. Allowed  true and false.", "zh_CN":"是否添加鉴权头部，为true，则回源按照Aliyun OSS的算法添加 添加Authorization头部。
        # 允许值为true和false，默认为false"}
        self.add_authorization_header = add_authorization_header
        # {"en":"access key", "zh_CN":"校验所需的密钥"}
        self.access_key = access_key
        # {"en":"access key id", "zh_CN":"校验所需的密钥ID"}
        self.access_key_id = access_key_id
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note:
        # A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified.
        # B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id.
        # C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration.
        # D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared.
        # E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。data-id可以通过查询接口获取。 注意：
        # a、如果有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； 
        # b、如果入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置； 
        # c、如果入参都没有传data-id,表示用本次的配置全量覆盖原先配置； 
        # d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； 
        # e、如果一组配置没有具体的配置项，则data-id必填，且值为实际存在的data-id，表示清空这个data-id对应配置项的值；不允许一组配置没有具体的配置项也没有data-id。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.add_authorization_header, 'add_authorization_header')
        self.validate_required(self.access_key, 'access_key')
        self.validate_required(self.access_key_id, 'access_key_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add_authorization_header is not None:
            result['add-authorization-header'] = self.add_authorization_header
        if self.access_key is not None:
            result['access-key'] = self.access_key
        if self.access_key_id is not None:
            result['access-key-id'] = self.access_key_id
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add-authorization-header') is not None:
            self.add_authorization_header = m.get('add-authorization-header')
        if m.get('access-key') is not None:
            self.access_key = m.get('access-key')
        if m.get('access-key-id') is not None:
            self.access_key_id = m.get('access-key-id')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class UpdateAliyunOssAuthorizationConfigRequest(TeaModel):
    def __init__(
        self,
        aliyun_oss_access_authorization_rules: List[UpdateAliyunOssAuthorizationConfigRequestAliyunOssAccessAuthorizationRules] = None,
    ):
        # {"en":"Aliyun OSS access Authorization Configuration, parent node
        # 1. When you need to configure the Aliyun OSS access Authorization rules, this must be filled in.
        # 2. Configuration of clearing for <aliyun-oss-access-authorization-rules/>.
        # 3.vodstream/download support, web/wsa does not support.
        # 4.Amason S3 and Aliyun OSS cannot be configured simultaneously.", "zh_CN":"Aliyun OSS鉴权配置，父标签
        # 1.需要设置Aliyun OSS鉴权时，此项必填
        # 2.为<aliyun-oss-access-authorization-rules/>时清空Aliyun OSS鉴权的配置
        # 3.点播下载支持，网页wsa不支持
        # 4.Amason S3和Aliyun OSS不可同时配置"}
        self.aliyun_oss_access_authorization_rules = aliyun_oss_access_authorization_rules

    def validate(self):
        self.validate_required(self.aliyun_oss_access_authorization_rules, 'aliyun_oss_access_authorization_rules')
        if self.aliyun_oss_access_authorization_rules:
            for k in self.aliyun_oss_access_authorization_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aliyun_oss_access_authorization_rules is not None:
            result['aliyun-oss-access-authorization-rules'] = []
            for k in self.aliyun_oss_access_authorization_rules:
                result['aliyun-oss-access-authorization-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aliyun-oss-access-authorization-rules') is not None:
            self.aliyun_oss_access_authorization_rules = []
            for k in m.get('aliyun-oss-access-authorization-rules'):
                temp_model = UpdateAliyunOssAuthorizationConfigRequestAliyunOssAccessAuthorizationRules()
                self.aliyun_oss_access_authorization_rules.append(temp_model.from_map(k))
        return self


class UpdateAliyunOssAuthorizationConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateAliyunOssAuthorizationConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class UpdateAliyunOssAuthorizationConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateAliyunOssAuthorizationConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateAliyunOssAuthorizationConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainDetailRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainDetailResponseDataOriginsOriginsServers(TeaModel):
    def __init__(
        self,
        address: str = None,
        priority: int = None,
        weight: int = None,
        origin_host: str = None,
    ):
        # {"en":"Address", "zh_CN":"源站地址"}
        self.address = address
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"Weight", "zh_CN":"权重"}
        self.weight = weight
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host

    def validate(self):
        self.validate_required(self.address, 'address')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.weight, 'weight')
        self.validate_required(self.origin_host, 'origin_host')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.priority is not None:
            result['priority'] = self.priority
        if self.weight is not None:
            result['weight'] = self.weight
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        return self


class QueryLiveDomainDetailResponseDataOriginsOrigins(TeaModel):
    def __init__(
        self,
        servers: List[QueryLiveDomainDetailResponseDataOriginsOriginsServers] = None,
        round_robin: bool = None,
        origin_host: str = None,
    ):
        # {"en":"Servers", "zh_CN":"源站主机对象"}
        self.servers = servers
        # {"en":"Upstream Polling Enable Control", "zh_CN":"多个server默认主备"}
        self.round_robin = round_robin
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host

    def validate(self):
        self.validate_required(self.servers, 'servers')
        if self.servers:
            for k in self.servers:
                if k:
                    k.validate()
        self.validate_required(self.round_robin, 'round_robin')
        self.validate_required(self.origin_host, 'origin_host')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.servers is not None:
            result['servers'] = []
            for k in self.servers:
                result['servers'].append(k.to_map() if k else None)
        if self.round_robin is not None:
            result['roundRobin'] = self.round_robin
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('servers') is not None:
            self.servers = []
            for k in m.get('servers'):
                temp_model = QueryLiveDomainDetailResponseDataOriginsOriginsServers()
                self.servers.append(temp_model.from_map(k))
        if m.get('roundRobin') is not None:
            self.round_robin = m.get('roundRobin')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        return self


class QueryLiveDomainDetailResponseDataOrigins(TeaModel):
    def __init__(
        self,
        origin_address: str = None,
        origin_host: str = None,
        origin_protocol: str = None,
        origin_port: int = None,
        enable_https: bool = None,
        client_ip_header: str = None,
        advanced_origins: bool = None,
        origins: QueryLiveDomainDetailResponseDataOriginsOrigins = None,
    ):
        # {"en":"Origin Address", "zh_CN":"普通源"}
        self.origin_address = origin_address
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host
        # {"en":"Origin Protocol", "zh_CN":"回源协议"}
        self.origin_protocol = origin_protocol
        # {"en":"Origin Port", "zh_CN":"回源端口"}
        self.origin_port = origin_port
        # {"en":"Enable Https", "zh_CN":"是否通过HTTPS回源，只支持HDL协议"}
        self.enable_https = enable_https
        # {"en":"Client IP Header", "zh_CN":"传递客户端IP头"}
        self.client_ip_header = client_ip_header
        # {"en":"Enable Advanced Origins", "zh_CN":"是否启用高级源"}
        self.advanced_origins = advanced_origins
        # {"en":"Advanced Origins", "zh_CN":"高级源"}
        self.origins = origins

    def validate(self):
        self.validate_required(self.origin_address, 'origin_address')
        self.validate_required(self.origin_host, 'origin_host')
        self.validate_required(self.origin_protocol, 'origin_protocol')
        self.validate_required(self.origin_port, 'origin_port')
        self.validate_required(self.enable_https, 'enable_https')
        self.validate_required(self.client_ip_header, 'client_ip_header')
        self.validate_required(self.advanced_origins, 'advanced_origins')
        self.validate_required(self.origins, 'origins')
        if self.origins:
            self.origins.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_address is not None:
            result['originAddress'] = self.origin_address
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        if self.origin_protocol is not None:
            result['originProtocol'] = self.origin_protocol
        if self.origin_port is not None:
            result['originPort'] = self.origin_port
        if self.enable_https is not None:
            result['enableHttps'] = self.enable_https
        if self.client_ip_header is not None:
            result['clientIpHeader'] = self.client_ip_header
        if self.advanced_origins is not None:
            result['advancedOrigins'] = self.advanced_origins
        if self.origins is not None:
            result['origins'] = self.origins.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('originAddress') is not None:
            self.origin_address = m.get('originAddress')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        if m.get('originProtocol') is not None:
            self.origin_protocol = m.get('originProtocol')
        if m.get('originPort') is not None:
            self.origin_port = m.get('originPort')
        if m.get('enableHttps') is not None:
            self.enable_https = m.get('enableHttps')
        if m.get('clientIpHeader') is not None:
            self.client_ip_header = m.get('clientIpHeader')
        if m.get('advancedOrigins') is not None:
            self.advanced_origins = m.get('advancedOrigins')
        if m.get('origins') is not None:
            temp_model = QueryLiveDomainDetailResponseDataOriginsOrigins()
            self.origins = temp_model.from_map(m['origins'])
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsIpFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        ips: List[str] = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"IP List", "zh_CN":"IP或IP段"}
        self.ips = ips

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.type, 'type')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsRefererFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        referer_regex: str = None,
        referer_url: str = None,
        referer_domain: str = None,
        allow_empty_referer: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"Referer Regex", "zh_CN":"Referer正则"}
        self.referer_regex = referer_regex
        # {"en":"Referer URL", "zh_CN":"Referer URL"}
        self.referer_url = referer_url
        # {"en":"Referer Domain", "zh_CN":"Referer 域名"}
        self.referer_domain = referer_domain
        # {"en":"Allow Empty Referer", "zh_CN":"是否允许空referer"}
        self.allow_empty_referer = allow_empty_referer

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.type, 'type')
        self.validate_required(self.referer_regex, 'referer_regex')
        self.validate_required(self.referer_url, 'referer_url')
        self.validate_required(self.referer_domain, 'referer_domain')
        self.validate_required(self.allow_empty_referer, 'allow_empty_referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.referer_regex is not None:
            result['refererRegex'] = self.referer_regex
        if self.referer_url is not None:
            result['refererUrl'] = self.referer_url
        if self.referer_domain is not None:
            result['refererDomain'] = self.referer_domain
        if self.allow_empty_referer is not None:
            result['allowEmptyReferer'] = self.allow_empty_referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('refererRegex') is not None:
            self.referer_regex = m.get('refererRegex')
        if m.get('refererUrl') is not None:
            self.referer_url = m.get('refererUrl')
        if m.get('refererDomain') is not None:
            self.referer_domain = m.get('refererDomain')
        if m.get('allowEmptyReferer') is not None:
            self.allow_empty_referer = m.get('allowEmptyReferer')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsUaFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        ua_regex: List[str] = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"UA Regex", "zh_CN":"客户端UA，支持正则"}
        self.ua_regex = ua_regex

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.type, 'type')
        self.validate_required(self.ua_regex, 'ua_regex')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.ua_regex is not None:
            result['uaRegex'] = self.ua_regex
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('uaRegex') is not None:
            self.ua_regex = m.get('uaRegex')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsUrlAuths(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        sign_keys: List[str] = None,
        time_format: str = None,
        cipher_combination: str = None,
        sign_aglo: str = None,
        time_arg: str = None,
        secret_arg: str = None,
        period: int = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Sign Keys", "zh_CN":"加密串key"}
        self.sign_keys = sign_keys
        # {"en":"Time Format, Enum[1, 2]", "zh_CN":"Unix时间戳格式，可选值[1, 2]"}
        self.time_format = time_format
        # {"en":"Cipher Combination, Enum[1,2,3,4,5,6]", "zh_CN":"密码组合，可选值[1, 2, 3, 4, 5, 6]"}
        self.cipher_combination = cipher_combination
        # {"en":"Sign Aglo", "zh_CN":"加密算法"}
        self.sign_aglo = sign_aglo
        # {"en":"Time Arg", "zh_CN":"时间串的参数名"}
        self.time_arg = time_arg
        # {"en":"Secret Arg", "zh_CN":"防盗链串的参数名称"}
        self.secret_arg = secret_arg
        # {"en":"Period", "zh_CN":"相对时间有效期，单位秒"}
        self.period = period

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.sign_keys, 'sign_keys')
        self.validate_required(self.time_format, 'time_format')
        self.validate_required(self.cipher_combination, 'cipher_combination')
        self.validate_required(self.sign_aglo, 'sign_aglo')
        self.validate_required(self.time_arg, 'time_arg')
        self.validate_required(self.secret_arg, 'secret_arg')
        self.validate_required(self.period, 'period')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.sign_keys is not None:
            result['signKeys'] = self.sign_keys
        if self.time_format is not None:
            result['timeFormat'] = self.time_format
        if self.cipher_combination is not None:
            result['cipherCombination'] = self.cipher_combination
        if self.sign_aglo is not None:
            result['signAglo'] = self.sign_aglo
        if self.time_arg is not None:
            result['timeArg'] = self.time_arg
        if self.secret_arg is not None:
            result['secretArg'] = self.secret_arg
        if self.period is not None:
            result['period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('signKeys') is not None:
            self.sign_keys = m.get('signKeys')
        if m.get('timeFormat') is not None:
            self.time_format = m.get('timeFormat')
        if m.get('cipherCombination') is not None:
            self.cipher_combination = m.get('cipherCombination')
        if m.get('signAglo') is not None:
            self.sign_aglo = m.get('signAglo')
        if m.get('timeArg') is not None:
            self.time_arg = m.get('timeArg')
        if m.get('secretArg') is not None:
            self.secret_arg = m.get('secretArg')
        if m.get('period') is not None:
            self.period = m.get('period')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuthsAuthArgs(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en":"Arg Name", "zh_CN":"参数名称"}
        self.name = name
        # {"en":"Arg Value", "zh_CN":"参数值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuthsAuthResult(TeaModel):
    def __init__(
        self,
        success_codes: List[str] = None,
        failed_codes: List[str] = None,
        success_body: str = None,
        failed_body: str = None,
    ):
        # {"en":"Auth Result Success Codes", "zh_CN":"鉴权成功响应状态码"}
        self.success_codes = success_codes
        # {"en":"Auth Result Failed Codes", "zh_CN":"鉴权失败响应状态码"}
        self.failed_codes = failed_codes
        # {"en":"Auth Result Success Body", "zh_CN":"鉴权成功响应body"}
        self.success_body = success_body
        # {"en":"Auth Result Failed Body", "zh_CN":"鉴权失败响应body"}
        self.failed_body = failed_body

    def validate(self):
        self.validate_required(self.success_codes, 'success_codes')
        self.validate_required(self.failed_codes, 'failed_codes')
        self.validate_required(self.success_body, 'success_body')
        self.validate_required(self.failed_body, 'failed_body')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_codes is not None:
            result['successCodes'] = self.success_codes
        if self.failed_codes is not None:
            result['failedCodes'] = self.failed_codes
        if self.success_body is not None:
            result['successBody'] = self.success_body
        if self.failed_body is not None:
            result['failedBody'] = self.failed_body
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('successCodes') is not None:
            self.success_codes = m.get('successCodes')
        if m.get('failedCodes') is not None:
            self.failed_codes = m.get('failedCodes')
        if m.get('successBody') is not None:
            self.success_body = m.get('successBody')
        if m.get('failedBody') is not None:
            self.failed_body = m.get('failedBody')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuths(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        enabled: bool = None,
        auth_address: str = None,
        auth_host: str = None,
        auth_uri: str = None,
        auth_args: List[QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuthsAuthArgs] = None,
        auth_method: str = None,
        auth_use_https: bool = None,
        auth_result: QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuthsAuthResult = None,
        auth_timeout: int = None,
        retry_times: int = None,
        timeout_action: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Enabled", "zh_CN":"是否启用回源鉴权"}
        self.enabled = enabled
        # {"en":"Auth Address", "zh_CN":"鉴权地址，支持IP或域名"}
        self.auth_address = auth_address
        # {"en":"Auth Host", "zh_CN":"鉴权主机名"}
        self.auth_host = auth_host
        # {"en":"Auth URI", "zh_CN":"回源鉴权URI"}
        self.auth_uri = auth_uri
        # {"en":"Auth Args", "zh_CN":"回源鉴权请求参数"}
        self.auth_args = auth_args
        # {"en":"Auth Method, Enum [GET, POST]", "zh_CN":"回源鉴权请求方法，可选值[GET, POST]"}
        self.auth_method = auth_method
        # {"en":"Auth Use Https", "zh_CN":"回源鉴权是否启用HTTPS"}
        self.auth_use_https = auth_use_https
        # {"en":"Auth Result", "zh_CN":"鉴权结果判定，成功或失败的标识"}
        self.auth_result = auth_result
        # {"en":"Auth Timeout, [1, 10]", "zh_CN":"鉴权超时时间，[1, 10]"}
        self.auth_timeout = auth_timeout
        # {"en":"Auth Timeout, [0, 30]", "zh_CN":"鉴权重试次数，[0, 30]"}
        self.retry_times = retry_times
        # {"en":"Timeout Action, Enum [allow, deny]", "zh_CN":"超时动作，可选值[allow, deny]"}
        self.timeout_action = timeout_action

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.auth_address, 'auth_address')
        self.validate_required(self.auth_host, 'auth_host')
        self.validate_required(self.auth_uri, 'auth_uri')
        self.validate_required(self.auth_args, 'auth_args')
        if self.auth_args:
            for k in self.auth_args:
                if k:
                    k.validate()
        self.validate_required(self.auth_method, 'auth_method')
        self.validate_required(self.auth_use_https, 'auth_use_https')
        self.validate_required(self.auth_result, 'auth_result')
        if self.auth_result:
            self.auth_result.validate()
        self.validate_required(self.auth_timeout, 'auth_timeout')
        self.validate_required(self.retry_times, 'retry_times')
        self.validate_required(self.timeout_action, 'timeout_action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.auth_address is not None:
            result['authAddress'] = self.auth_address
        if self.auth_host is not None:
            result['authHost'] = self.auth_host
        if self.auth_uri is not None:
            result['authUri'] = self.auth_uri
        if self.auth_args is not None:
            result['authArgs'] = []
            for k in self.auth_args:
                result['authArgs'].append(k.to_map() if k else None)
        if self.auth_method is not None:
            result['authMethod'] = self.auth_method
        if self.auth_use_https is not None:
            result['authUseHttps'] = self.auth_use_https
        if self.auth_result is not None:
            result['authResult'] = self.auth_result.to_map()
        if self.auth_timeout is not None:
            result['authTimeout'] = self.auth_timeout
        if self.retry_times is not None:
            result['retryTimes'] = self.retry_times
        if self.timeout_action is not None:
            result['timeoutAction'] = self.timeout_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('authAddress') is not None:
            self.auth_address = m.get('authAddress')
        if m.get('authHost') is not None:
            self.auth_host = m.get('authHost')
        if m.get('authUri') is not None:
            self.auth_uri = m.get('authUri')
        if m.get('authArgs') is not None:
            self.auth_args = []
            for k in m.get('authArgs'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuthsAuthArgs()
                self.auth_args.append(temp_model.from_map(k))
        if m.get('authMethod') is not None:
            self.auth_method = m.get('authMethod')
        if m.get('authUseHttps') is not None:
            self.auth_use_https = m.get('authUseHttps')
        if m.get('authResult') is not None:
            temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuthsAuthResult()
            self.auth_result = temp_model.from_map(m['authResult'])
        if m.get('authTimeout') is not None:
            self.auth_timeout = m.get('authTimeout')
        if m.get('retryTimes') is not None:
            self.retry_times = m.get('retryTimes')
        if m.get('timeoutAction') is not None:
            self.timeout_action = m.get('timeoutAction')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersIpFilter(TeaModel):
    def __init__(
        self,
        type: str = None,
        ips: List[str] = None,
    ):
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"IP List", "zh_CN":"IP或IP段"}
        self.ips = ips

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersUaFilter(TeaModel):
    def __init__(
        self,
        type: str = None,
        ua_regex: List[str] = None,
    ):
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"UA Regex", "zh_CN":"客户端UA，支持正则"}
        self.ua_regex = ua_regex

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.ua_regex, 'ua_regex')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.ua_regex is not None:
            result['uaRegex'] = self.ua_regex
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('uaRegex') is not None:
            self.ua_regex = m.get('uaRegex')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersRefererFilter(TeaModel):
    def __init__(
        self,
        type: str = None,
        referer_regex: str = None,
        referer_url: str = None,
        referer_domain: str = None,
        allow_empty_referer: bool = None,
    ):
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"Referer Regex", "zh_CN":"Referer正则"}
        self.referer_regex = referer_regex
        # {"en":"Referer URL", "zh_CN":"Referer URL"}
        self.referer_url = referer_url
        # {"en":"Referer Domain", "zh_CN":"Referer 域名"}
        self.referer_domain = referer_domain
        # {"en":"Allow Empty Referer", "zh_CN":"是否允许空referer"}
        self.allow_empty_referer = allow_empty_referer

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.referer_regex, 'referer_regex')
        self.validate_required(self.referer_url, 'referer_url')
        self.validate_required(self.referer_domain, 'referer_domain')
        self.validate_required(self.allow_empty_referer, 'allow_empty_referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.referer_regex is not None:
            result['refererRegex'] = self.referer_regex
        if self.referer_url is not None:
            result['refererUrl'] = self.referer_url
        if self.referer_domain is not None:
            result['refererDomain'] = self.referer_domain
        if self.allow_empty_referer is not None:
            result['allowEmptyReferer'] = self.allow_empty_referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('refererRegex') is not None:
            self.referer_regex = m.get('refererRegex')
        if m.get('refererUrl') is not None:
            self.referer_url = m.get('refererUrl')
        if m.get('refererDomain') is not None:
            self.referer_domain = m.get('refererDomain')
        if m.get('allowEmptyReferer') is not None:
            self.allow_empty_referer = m.get('allowEmptyReferer')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url: str = None,
        url_regex: str = None,
        exclude_url_regex: str = None,
        file_types: List[str] = None,
        exclude_file_types: List[str] = None,
        file_paths: List[str] = None,
        exclude_file_paths: List[str] = None,
        ip_filter: QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersIpFilter = None,
        ua_filter: QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersUaFilter = None,
        referer_filter: QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersRefererFilter = None,
        action: str = None,
        redirect_url: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL", "zh_CN":"指定URL，非正则"}
        self.url = url
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"Exclude URL Regex", "zh_CN":"URL正则取反"}
        self.exclude_url_regex = exclude_url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"Exclude File Types", "zh_CN":"文件类型取反"}
        self.exclude_file_types = exclude_file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Exclude File QueryLiveDomainDetailPaths", "zh_CN":"文件目录取反"}
        self.exclude_file_paths = exclude_file_paths
        # {"en":"IP Filter", "zh_CN":"IP黑白名单"}
        self.ip_filter = ip_filter
        # {"en":"UA Filter", "zh_CN":"UA黑白名单"}
        self.ua_filter = ua_filter
        # {"en":"Referer Filter", "zh_CN":"referer黑白名单"}
        self.referer_filter = referer_filter
        # {"en":"Control Action", "zh_CN":"控制动作"}
        self.action = action
        # {"en":"Redirect URL", "zh_CN":"跳转到URL"}
        self.redirect_url = redirect_url

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url, 'url')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.exclude_url_regex, 'exclude_url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.exclude_file_types, 'exclude_file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.exclude_file_paths, 'exclude_file_paths')
        self.validate_required(self.ip_filter, 'ip_filter')
        if self.ip_filter:
            self.ip_filter.validate()
        self.validate_required(self.ua_filter, 'ua_filter')
        if self.ua_filter:
            self.ua_filter.validate()
        self.validate_required(self.referer_filter, 'referer_filter')
        if self.referer_filter:
            self.referer_filter.validate()
        self.validate_required(self.action, 'action')
        self.validate_required(self.redirect_url, 'redirect_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url is not None:
            result['url'] = self.url
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.exclude_url_regex is not None:
            result['excludeUrlRegex'] = self.exclude_url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.exclude_file_types is not None:
            result['excludeFileTypes'] = self.exclude_file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.exclude_file_paths is not None:
            result['excludeFileQueryLiveDomainDetailPaths'] = self.exclude_file_paths
        if self.ip_filter is not None:
            result['ipFilter'] = self.ip_filter.to_map()
        if self.ua_filter is not None:
            result['uaFilter'] = self.ua_filter.to_map()
        if self.referer_filter is not None:
            result['refererFilter'] = self.referer_filter.to_map()
        if self.action is not None:
            result['action'] = self.action
        if self.redirect_url is not None:
            result['redirectUrl'] = self.redirect_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('excludeUrlRegex') is not None:
            self.exclude_url_regex = m.get('excludeUrlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('excludeFileTypes') is not None:
            self.exclude_file_types = m.get('excludeFileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('excludeFileQueryLiveDomainDetailPaths') is not None:
            self.exclude_file_paths = m.get('excludeFileQueryLiveDomainDetailPaths')
        if m.get('ipFilter') is not None:
            temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersIpFilter()
            self.ip_filter = temp_model.from_map(m['ipFilter'])
        if m.get('uaFilter') is not None:
            temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersUaFilter()
            self.ua_filter = temp_model.from_map(m['uaFilter'])
        if m.get('refererFilter') is not None:
            temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFiltersRefererFilter()
            self.referer_filter = temp_model.from_map(m['refererFilter'])
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('redirectUrl') is not None:
            self.redirect_url = m.get('redirectUrl')
        return self


class QueryLiveDomainDetailResponseDataAccessCtrls(TeaModel):
    def __init__(
        self,
        ip_filters: List[QueryLiveDomainDetailResponseDataAccessCtrlsIpFilters] = None,
        referer_filters: List[QueryLiveDomainDetailResponseDataAccessCtrlsRefererFilters] = None,
        ua_filters: List[QueryLiveDomainDetailResponseDataAccessCtrlsUaFilters] = None,
        url_auths: List[QueryLiveDomainDetailResponseDataAccessCtrlsUrlAuths] = None,
        remote_auths: List[QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuths] = None,
        combined_filters: List[QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFilters] = None,
    ):
        # {"en":"IP Filters", "zh_CN":"IP访问控制"}
        self.ip_filters = ip_filters
        # {"en":"Referer Filters", "zh_CN":"Refferer访问控制"}
        self.referer_filters = referer_filters
        # {"en":"UA Filters", "zh_CN":"UA访问控制"}
        self.ua_filters = ua_filters
        # {"en":"URL Auths", "zh_CN":"URL Auths"}
        self.url_auths = url_auths
        # {"en":"Remote Auths", "zh_CN":"Remote Auths"}
        self.remote_auths = remote_auths
        # {"en":"Combined Filters", "zh_CN":"访问控制组合"}
        self.combined_filters = combined_filters

    def validate(self):
        self.validate_required(self.ip_filters, 'ip_filters')
        if self.ip_filters:
            for k in self.ip_filters:
                if k:
                    k.validate()
        self.validate_required(self.referer_filters, 'referer_filters')
        if self.referer_filters:
            for k in self.referer_filters:
                if k:
                    k.validate()
        self.validate_required(self.ua_filters, 'ua_filters')
        if self.ua_filters:
            for k in self.ua_filters:
                if k:
                    k.validate()
        self.validate_required(self.url_auths, 'url_auths')
        if self.url_auths:
            for k in self.url_auths:
                if k:
                    k.validate()
        self.validate_required(self.remote_auths, 'remote_auths')
        if self.remote_auths:
            for k in self.remote_auths:
                if k:
                    k.validate()
        self.validate_required(self.combined_filters, 'combined_filters')
        if self.combined_filters:
            for k in self.combined_filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_filters is not None:
            result['ipFilters'] = []
            for k in self.ip_filters:
                result['ipFilters'].append(k.to_map() if k else None)
        if self.referer_filters is not None:
            result['refererFilters'] = []
            for k in self.referer_filters:
                result['refererFilters'].append(k.to_map() if k else None)
        if self.ua_filters is not None:
            result['uaFilters'] = []
            for k in self.ua_filters:
                result['uaFilters'].append(k.to_map() if k else None)
        if self.url_auths is not None:
            result['urlAuths'] = []
            for k in self.url_auths:
                result['urlAuths'].append(k.to_map() if k else None)
        if self.remote_auths is not None:
            result['remoteAuths'] = []
            for k in self.remote_auths:
                result['remoteAuths'].append(k.to_map() if k else None)
        if self.combined_filters is not None:
            result['combinedFilters'] = []
            for k in self.combined_filters:
                result['combinedFilters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipFilters') is not None:
            self.ip_filters = []
            for k in m.get('ipFilters'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsIpFilters()
                self.ip_filters.append(temp_model.from_map(k))
        if m.get('refererFilters') is not None:
            self.referer_filters = []
            for k in m.get('refererFilters'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsRefererFilters()
                self.referer_filters.append(temp_model.from_map(k))
        if m.get('uaFilters') is not None:
            self.ua_filters = []
            for k in m.get('uaFilters'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsUaFilters()
                self.ua_filters.append(temp_model.from_map(k))
        if m.get('urlAuths') is not None:
            self.url_auths = []
            for k in m.get('urlAuths'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsUrlAuths()
                self.url_auths.append(temp_model.from_map(k))
        if m.get('remoteAuths') is not None:
            self.remote_auths = []
            for k in m.get('remoteAuths'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsRemoteAuths()
                self.remote_auths.append(temp_model.from_map(k))
        if m.get('combinedFilters') is not None:
            self.combined_filters = []
            for k in m.get('combinedFilters'):
                temp_model = QueryLiveDomainDetailResponseDataAccessCtrlsCombinedFilters()
                self.combined_filters.append(temp_model.from_map(k))
        return self


class QueryLiveDomainDetailResponseDataHeaderRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        header_name: str = None,
        header_type: str = None,
        action: str = None,
        header_value: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Header Name", "zh_CN":"头部名称"}
        self.header_name = header_name
        # {"en":"Header Type, Enum[clientReq, clientResp, originReq, originResp]", "zh_CN":"头部类型，可选值[clientReq, clientResp, originReq, originResp]"}
        self.header_type = header_type
        # {"en":"Operate Type, Enum[add, set, delete]", "zh_CN":"操作类型，可选值[add, set, delete]"}
        self.action = action
        # {"en":"Header Value", "zh_CN":"头部值"}
        self.header_value = header_value

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.header_name, 'header_name')
        self.validate_required(self.header_type, 'header_type')
        self.validate_required(self.action, 'action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.header_name is not None:
            result['headerName'] = self.header_name
        if self.header_type is not None:
            result['headerType'] = self.header_type
        if self.action is not None:
            result['action'] = self.action
        if self.header_value is not None:
            result['headerValue'] = self.header_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('headerName') is not None:
            self.header_name = m.get('headerName')
        if m.get('headerType') is not None:
            self.header_type = m.get('headerType')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('headerValue') is not None:
            self.header_value = m.get('headerValue')
        return self


class QueryLiveDomainDetailResponseDataHlsSlices(TeaModel):
    def __init__(
        self,
        enable_hls: bool = None,
        m_3u_8seg_num: int = None,
        first_m3u_8seg_num: int = None,
        seg_duration: int = None,
        new_meta_seq_reset: bool = None,
    ):
        # {"en":"Enable HLS", "zh_CN":"是否启用HLS"}
        self.enable_hls = enable_hls
        # {"en":"M3u8 Seg Num", "zh_CN":"普通m3u8切片个数"}
        self.m_3u_8seg_num = m_3u_8seg_num
        # {"en":"First M3u8 Seg Num", "zh_CN":"首个m3u8切片个数"}
        self.first_m3u_8seg_num = first_m3u_8seg_num
        # {"en":"Seg Duration", "zh_CN":"切片间隔，单位秒"}
        self.seg_duration = seg_duration
        # {"en":"New Meta Seq Reset", "zh_CN":"收到新的metadata是否重置sequence"}
        self.new_meta_seq_reset = new_meta_seq_reset

    def validate(self):
        self.validate_required(self.enable_hls, 'enable_hls')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_hls is not None:
            result['enableHls'] = self.enable_hls
        if self.m_3u_8seg_num is not None:
            result['m3u8SegNum'] = self.m_3u_8seg_num
        if self.first_m3u_8seg_num is not None:
            result['firstM3u8SegNum'] = self.first_m3u_8seg_num
        if self.seg_duration is not None:
            result['segDuration'] = self.seg_duration
        if self.new_meta_seq_reset is not None:
            result['newMetaSeqReset'] = self.new_meta_seq_reset
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHls') is not None:
            self.enable_hls = m.get('enableHls')
        if m.get('m3u8SegNum') is not None:
            self.m_3u_8seg_num = m.get('m3u8SegNum')
        if m.get('firstM3u8SegNum') is not None:
            self.first_m3u_8seg_num = m.get('firstM3u8SegNum')
        if m.get('segDuration') is not None:
            self.seg_duration = m.get('segDuration')
        if m.get('newMetaSeqReset') is not None:
            self.new_meta_seq_reset = m.get('newMetaSeqReset')
        return self


class QueryLiveDomainDetailResponseDataHlsCacheTimeRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        cache_time: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Cache Time", "zh_CN":"缓存时间，整数加单位，比如20s、30m、1h、2d"}
        self.cache_time = cache_time

    def validate(self):
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.cache_time, 'cache_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.cache_time is not None:
            result['cacheTime'] = self.cache_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('cacheTime') is not None:
            self.cache_time = m.get('cacheTime')
        return self


class QueryLiveDomainDetailResponseDataHlsQueryStringRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        ignore_query_string: bool = None,
        ignore_case: bool = None,
        query_string_2origin: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainDetailPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Ignore Query String", "zh_CN":"是否去问号缓存"}
        self.ignore_query_string = ignore_query_string
        # {"en":"Ignore Case", "zh_CN":"是否忽略querystring大小写"}
        self.ignore_case = ignore_case
        # {"en":"Query String To Origin", "zh_CN":"回源是否带querystring"}
        self.query_string_2origin = query_string_2origin

    def validate(self):
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.ignore_query_string, 'ignore_query_string')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainDetailPaths'] = self.file_paths
        if self.ignore_query_string is not None:
            result['ignoreQueryString'] = self.ignore_query_string
        if self.ignore_case is not None:
            result['ignoreCase'] = self.ignore_case
        if self.query_string_2origin is not None:
            result['queryString2Origin'] = self.query_string_2origin
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainDetailPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainDetailPaths')
        if m.get('ignoreQueryString') is not None:
            self.ignore_query_string = m.get('ignoreQueryString')
        if m.get('ignoreCase') is not None:
            self.ignore_case = m.get('ignoreCase')
        if m.get('queryString2Origin') is not None:
            self.query_string_2origin = m.get('queryString2Origin')
        return self


class QueryLiveDomainDetailResponseDataHls(TeaModel):
    def __init__(
        self,
        slices: QueryLiveDomainDetailResponseDataHlsSlices = None,
        cache_time_rules: List[QueryLiveDomainDetailResponseDataHlsCacheTimeRules] = None,
        query_string_rules: List[QueryLiveDomainDetailResponseDataHlsQueryStringRules] = None,
    ):
        # {"en":"Slices", "zh_CN":"多协议输出-HLS"}
        self.slices = slices
        # {"en":"Cache Time Rules", "zh_CN":"节点缓存-缓存时间配置"}
        self.cache_time_rules = cache_time_rules
        # {"en":"Query String Rules", "zh_CN":"节点缓存-带问号缓存配置"}
        self.query_string_rules = query_string_rules

    def validate(self):
        if self.slices:
            self.slices.validate()
        if self.cache_time_rules:
            for k in self.cache_time_rules:
                if k:
                    k.validate()
        if self.query_string_rules:
            for k in self.query_string_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slices is not None:
            result['slices'] = self.slices.to_map()
        if self.cache_time_rules is not None:
            result['cacheTimeRules'] = []
            for k in self.cache_time_rules:
                result['cacheTimeRules'].append(k.to_map() if k else None)
        if self.query_string_rules is not None:
            result['queryStringRules'] = []
            for k in self.query_string_rules:
                result['queryStringRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('slices') is not None:
            temp_model = QueryLiveDomainDetailResponseDataHlsSlices()
            self.slices = temp_model.from_map(m['slices'])
        if m.get('cacheTimeRules') is not None:
            self.cache_time_rules = []
            for k in m.get('cacheTimeRules'):
                temp_model = QueryLiveDomainDetailResponseDataHlsCacheTimeRules()
                self.cache_time_rules.append(temp_model.from_map(k))
        if m.get('queryStringRules') is not None:
            self.query_string_rules = []
            for k in m.get('queryStringRules'):
                temp_model = QueryLiveDomainDetailResponseDataHlsQueryStringRules()
                self.query_string_rules.append(temp_model.from_map(k))
        return self


class QueryLiveDomainDetailResponseDataPublishReportsStartArgs(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        server_ip: str = None,
        stream_name: str = None,
        host: str = None,
        app_name: str = None,
        port: str = None,
        time: str = None,
        milltime: str = None,
        md_5sign: str = None,
        request_args: List[str] = None,
    ):
        # {"en":"Client IP", "zh_CN":"客户端IP汇报参数名称"}
        self.client_ip = client_ip
        # {"en":"Server IP", "zh_CN":"服务器IP汇报参数名称"}
        self.server_ip = server_ip
        # {"en":"Stream Name", "zh_CN":"流名汇报参数名称"}
        self.stream_name = stream_name
        # {"en":"Host", "zh_CN":"推流域名汇报参数名称"}
        self.host = host
        # {"en":"App Name", "zh_CN":"发布点汇报参数名称"}
        self.app_name = app_name
        # {"en":"Port", "zh_CN":"推流器端口汇报参数名称"}
        self.port = port
        # {"en":"Time", "zh_CN":"推流时间汇报参数名称，单位秒"}
        self.time = time
        # {"en":"Milltime", "zh_CN":"推流时间汇报参数名称，单位毫秒"}
        self.milltime = milltime
        # {"en":"MD5 Sign", "zh_CN":"MD5签名汇报参数名称"}
        self.md_5sign = md_5sign
        # {"en":"Request Args", "zh_CN":"URL请求参数名称，汇报参数名称同请求参数名称"}
        self.request_args = request_args

    def validate(self):
        self.validate_required(self.client_ip, 'client_ip')
        self.validate_required(self.server_ip, 'server_ip')
        self.validate_required(self.stream_name, 'stream_name')
        self.validate_required(self.host, 'host')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.port, 'port')
        self.validate_required(self.time, 'time')
        self.validate_required(self.milltime, 'milltime')
        self.validate_required(self.md_5sign, 'md_5sign')
        self.validate_required(self.request_args, 'request_args')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['clientIp'] = self.client_ip
        if self.server_ip is not None:
            result['serverIp'] = self.server_ip
        if self.stream_name is not None:
            result['streamName'] = self.stream_name
        if self.host is not None:
            result['host'] = self.host
        if self.app_name is not None:
            result['appName'] = self.app_name
        if self.port is not None:
            result['port'] = self.port
        if self.time is not None:
            result['time'] = self.time
        if self.milltime is not None:
            result['milltime'] = self.milltime
        if self.md_5sign is not None:
            result['md5Sign'] = self.md_5sign
        if self.request_args is not None:
            result['requestArgs'] = self.request_args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientIp') is not None:
            self.client_ip = m.get('clientIp')
        if m.get('serverIp') is not None:
            self.server_ip = m.get('serverIp')
        if m.get('streamName') is not None:
            self.stream_name = m.get('streamName')
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('appName') is not None:
            self.app_name = m.get('appName')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('milltime') is not None:
            self.milltime = m.get('milltime')
        if m.get('md5Sign') is not None:
            self.md_5sign = m.get('md5Sign')
        if m.get('requestArgs') is not None:
            self.request_args = m.get('requestArgs')
        return self


class QueryLiveDomainDetailResponseDataPublishReportsStopArgs(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        server_ip: str = None,
        stream_name: str = None,
        host: str = None,
        app_name: str = None,
        port: str = None,
        time: str = None,
        milltime: str = None,
        md_5sign: str = None,
        request_args: List[str] = None,
    ):
        # {"en":"Client IP", "zh_CN":"客户端IP汇报参数名称"}
        self.client_ip = client_ip
        # {"en":"Server IP", "zh_CN":"服务器IP汇报参数名称"}
        self.server_ip = server_ip
        # {"en":"Stream Name", "zh_CN":"流名汇报参数名称"}
        self.stream_name = stream_name
        # {"en":"Host", "zh_CN":"推流域名汇报参数名称"}
        self.host = host
        # {"en":"App Name", "zh_CN":"发布点汇报参数名称"}
        self.app_name = app_name
        # {"en":"Port", "zh_CN":"推流器端口汇报参数名称"}
        self.port = port
        # {"en":"Time", "zh_CN":"推流时间汇报参数名称，单位秒"}
        self.time = time
        # {"en":"Milltime", "zh_CN":"推流时间汇报参数名称，单位毫秒"}
        self.milltime = milltime
        # {"en":"MD5 Sign", "zh_CN":"MD5签名汇报参数名称"}
        self.md_5sign = md_5sign
        # {"en":"Request Args", "zh_CN":"URL请求参数名称，汇报参数名称同请求参数名称"}
        self.request_args = request_args

    def validate(self):
        self.validate_required(self.client_ip, 'client_ip')
        self.validate_required(self.server_ip, 'server_ip')
        self.validate_required(self.stream_name, 'stream_name')
        self.validate_required(self.host, 'host')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.port, 'port')
        self.validate_required(self.time, 'time')
        self.validate_required(self.milltime, 'milltime')
        self.validate_required(self.md_5sign, 'md_5sign')
        self.validate_required(self.request_args, 'request_args')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['clientIp'] = self.client_ip
        if self.server_ip is not None:
            result['serverIp'] = self.server_ip
        if self.stream_name is not None:
            result['streamName'] = self.stream_name
        if self.host is not None:
            result['host'] = self.host
        if self.app_name is not None:
            result['appName'] = self.app_name
        if self.port is not None:
            result['port'] = self.port
        if self.time is not None:
            result['time'] = self.time
        if self.milltime is not None:
            result['milltime'] = self.milltime
        if self.md_5sign is not None:
            result['md5Sign'] = self.md_5sign
        if self.request_args is not None:
            result['requestArgs'] = self.request_args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientIp') is not None:
            self.client_ip = m.get('clientIp')
        if m.get('serverIp') is not None:
            self.server_ip = m.get('serverIp')
        if m.get('streamName') is not None:
            self.stream_name = m.get('streamName')
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('appName') is not None:
            self.app_name = m.get('appName')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('milltime') is not None:
            self.milltime = m.get('milltime')
        if m.get('md5Sign') is not None:
            self.md_5sign = m.get('md5Sign')
        if m.get('requestArgs') is not None:
            self.request_args = m.get('requestArgs')
        return self


class QueryLiveDomainDetailResponseDataPublishReports(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        app_names: List[str] = None,
        enabled: bool = None,
        report_method: str = None,
        report_address: str = None,
        enable_https: bool = None,
        sign_key: str = None,
        start_uri: str = None,
        start_args: QueryLiveDomainDetailResponseDataPublishReportsStartArgs = None,
        stop_uri: str = None,
        stop_args: QueryLiveDomainDetailResponseDataPublishReportsStopArgs = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"App Names", "zh_CN":"发布点"}
        self.app_names = app_names
        # {"en":"Enabled", "zh_CN":"是否启用汇报"}
        self.enabled = enabled
        # {"en":"Report Method, Enum [POST,GET]", "zh_CN":"汇报方法，可选值[POST,GET]"}
        self.report_method = report_method
        # {"en":"Report Address", "zh_CN":"汇报地址"}
        self.report_address = report_address
        # {"en":"Enable Https", "zh_CN":"是否启用HTTPS汇报"}
        self.enable_https = enable_https
        # {"en":"Sign Key", "zh_CN":"Md5签名的密钥"}
        self.sign_key = sign_key
        # {"en":"Start Uri", "zh_CN":"推流开始汇报URI"}
        self.start_uri = start_uri
        # {"en":"Start Args", "zh_CN":"推流开始汇报参数"}
        self.start_args = start_args
        # {"en":"Stop Uri", "zh_CN":"推流结束汇报URI"}
        self.stop_uri = stop_uri
        # {"en":"Stop Args", "zh_CN":"推流结束汇报参数"}
        self.stop_args = stop_args

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.app_names, 'app_names')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.report_method, 'report_method')
        self.validate_required(self.report_address, 'report_address')
        self.validate_required(self.enable_https, 'enable_https')
        self.validate_required(self.sign_key, 'sign_key')
        self.validate_required(self.start_uri, 'start_uri')
        self.validate_required(self.start_args, 'start_args')
        if self.start_args:
            self.start_args.validate()
        self.validate_required(self.stop_uri, 'stop_uri')
        self.validate_required(self.stop_args, 'stop_args')
        if self.stop_args:
            self.stop_args.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.app_names is not None:
            result['appNames'] = self.app_names
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.report_method is not None:
            result['reportMethod'] = self.report_method
        if self.report_address is not None:
            result['reportAddress'] = self.report_address
        if self.enable_https is not None:
            result['enableHttps'] = self.enable_https
        if self.sign_key is not None:
            result['signKey'] = self.sign_key
        if self.start_uri is not None:
            result['startUri'] = self.start_uri
        if self.start_args is not None:
            result['startArgs'] = self.start_args.to_map()
        if self.stop_uri is not None:
            result['stopUri'] = self.stop_uri
        if self.stop_args is not None:
            result['stopArgs'] = self.stop_args.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('appNames') is not None:
            self.app_names = m.get('appNames')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('reportMethod') is not None:
            self.report_method = m.get('reportMethod')
        if m.get('reportAddress') is not None:
            self.report_address = m.get('reportAddress')
        if m.get('enableHttps') is not None:
            self.enable_https = m.get('enableHttps')
        if m.get('signKey') is not None:
            self.sign_key = m.get('signKey')
        if m.get('startUri') is not None:
            self.start_uri = m.get('startUri')
        if m.get('startArgs') is not None:
            temp_model = QueryLiveDomainDetailResponseDataPublishReportsStartArgs()
            self.start_args = temp_model.from_map(m['startArgs'])
        if m.get('stopUri') is not None:
            self.stop_uri = m.get('stopUri')
        if m.get('stopArgs') is not None:
            temp_model = QueryLiveDomainDetailResponseDataPublishReportsStopArgs()
            self.stop_args = temp_model.from_map(m['stopArgs'])
        return self


class QueryLiveDomainDetailResponseDataMisc(TeaModel):
    def __init__(
        self,
        enable_http_2: bool = None,
        redirect_http_to_https: bool = None,
        disable_rtmp: bool = None,
        disable_hdl: bool = None,
    ):
        # {"en":"Enable HTTP2", "zh_CN":"是否启用HTTP2"}
        self.enable_http_2 = enable_http_2
        # {"en":"Redirect Http To Https", "zh_CN":"请求协议类型"}
        self.redirect_http_to_https = redirect_http_to_https
        # {"en":"Disable RTMP", "zh_CN":"是否禁止RTMP协议"}
        self.disable_rtmp = disable_rtmp
        # {"en":"Disable HDL", "zh_CN":"是否禁止HDL协议"}
        self.disable_hdl = disable_hdl

    def validate(self):
        self.validate_required(self.enable_http_2, 'enable_http_2')
        self.validate_required(self.redirect_http_to_https, 'redirect_http_to_https')
        self.validate_required(self.disable_rtmp, 'disable_rtmp')
        self.validate_required(self.disable_hdl, 'disable_hdl')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_http_2 is not None:
            result['enableHttp2'] = self.enable_http_2
        if self.redirect_http_to_https is not None:
            result['redirectHttpToHttps'] = self.redirect_http_to_https
        if self.disable_rtmp is not None:
            result['disableRtmp'] = self.disable_rtmp
        if self.disable_hdl is not None:
            result['disableHdl'] = self.disable_hdl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHttp2') is not None:
            self.enable_http_2 = m.get('enableHttp2')
        if m.get('redirectHttpToHttps') is not None:
            self.redirect_http_to_https = m.get('redirectHttpToHttps')
        if m.get('disableRtmp') is not None:
            self.disable_rtmp = m.get('disableRtmp')
        if m.get('disableHdl') is not None:
            self.disable_hdl = m.get('disableHdl')
        return self


class QueryLiveDomainDetailResponseData(TeaModel):
    def __init__(
        self,
        product: str = None,
        domain: str = None,
        domain_type: str = None,
        live_mode: str = None,
        publish_domain: str = None,
        cname: str = None,
        hls_origin: bool = None,
        slice_arch: str = None,
        app_names: List[str] = None,
        status: str = None,
        create_time: str = None,
        update_time: str = None,
        origins: QueryLiveDomainDetailResponseDataOrigins = None,
        access_ctrls: QueryLiveDomainDetailResponseDataAccessCtrls = None,
        header_rules: List[QueryLiveDomainDetailResponseDataHeaderRules] = None,
        hls: QueryLiveDomainDetailResponseDataHls = None,
        publish_reports: List[QueryLiveDomainDetailResponseDataPublishReports] = None,
        misc: QueryLiveDomainDetailResponseDataMisc = None,
    ):
        # {"en":"product", "zh_CN":"商品名称"}
        self.product = product
        # {"en":"domain", "zh_CN":"加速域名"}
        self.domain = domain
        # {"en":"domainType", "zh_CN":"域名类型，推流或拉流"}
        self.domain_type = domain_type
        # {"en":"liveMode", "zh_CN":"直播模式，互动直播或客户源模式"}
        self.live_mode = live_mode
        # {"en":"publishDomain", "zh_CN":"推流域名"}
        self.publish_domain = publish_domain
        # {"en":"cname", "zh_CN":"一级域名"}
        self.cname = cname
        # {"en":"hlsOrigin", "zh_CN":"是否HLS源站"}
        self.hls_origin = hls_origin
        # {"en":"sliceArch", "zh_CN":"切片架构"}
        self.slice_arch = slice_arch
        # {"en":"appNames", "zh_CN":"发布点"}
        self.app_names = app_names
        # {"en":"status", "zh_CN":"域名状态"}
        self.status = status
        # {"en":"createTime", "zh_CN":"域名创建时间"}
        self.create_time = create_time
        # {"en":"updateTime", "zh_CN":"域名更新时间"}
        self.update_time = update_time
        # {"en":"Origins Config", "zh_CN":"源站配置"}
        self.origins = origins
        # {"en":"Access Ctrls", "zh_CN":"访问控制"}
        self.access_ctrls = access_ctrls
        # {"en":"Header Rules", "zh_CN":"HTTP头部控制"}
        self.header_rules = header_rules
        # {"en":"HLS Config", "zh_CN":"切片配置"}
        self.hls = hls
        # {"en":"Publish Reports", "zh_CN":"推流汇报"}
        self.publish_reports = publish_reports
        # {"en":"MISC Config", "zh_CN":"MISC配置"}
        self.misc = misc

    def validate(self):
        self.validate_required(self.product, 'product')
        self.validate_required(self.domain, 'domain')
        self.validate_required(self.domain_type, 'domain_type')
        self.validate_required(self.live_mode, 'live_mode')
        self.validate_required(self.publish_domain, 'publish_domain')
        self.validate_required(self.cname, 'cname')
        self.validate_required(self.hls_origin, 'hls_origin')
        self.validate_required(self.slice_arch, 'slice_arch')
        self.validate_required(self.app_names, 'app_names')
        self.validate_required(self.status, 'status')
        self.validate_required(self.create_time, 'create_time')
        self.validate_required(self.update_time, 'update_time')
        self.validate_required(self.origins, 'origins')
        if self.origins:
            self.origins.validate()
        self.validate_required(self.access_ctrls, 'access_ctrls')
        if self.access_ctrls:
            self.access_ctrls.validate()
        self.validate_required(self.header_rules, 'header_rules')
        if self.header_rules:
            for k in self.header_rules:
                if k:
                    k.validate()
        self.validate_required(self.hls, 'hls')
        if self.hls:
            self.hls.validate()
        self.validate_required(self.publish_reports, 'publish_reports')
        if self.publish_reports:
            for k in self.publish_reports:
                if k:
                    k.validate()
        self.validate_required(self.misc, 'misc')
        if self.misc:
            self.misc.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.product is not None:
            result['product'] = self.product
        if self.domain is not None:
            result['domain'] = self.domain
        if self.domain_type is not None:
            result['domainType'] = self.domain_type
        if self.live_mode is not None:
            result['liveMode'] = self.live_mode
        if self.publish_domain is not None:
            result['publishDomain'] = self.publish_domain
        if self.cname is not None:
            result['cname'] = self.cname
        if self.hls_origin is not None:
            result['hlsOrigin'] = self.hls_origin
        if self.slice_arch is not None:
            result['sliceArch'] = self.slice_arch
        if self.app_names is not None:
            result['appNames'] = self.app_names
        if self.status is not None:
            result['status'] = self.status
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        if self.origins is not None:
            result['origins'] = self.origins.to_map()
        if self.access_ctrls is not None:
            result['accessCtrls'] = self.access_ctrls.to_map()
        if self.header_rules is not None:
            result['headerRules'] = []
            for k in self.header_rules:
                result['headerRules'].append(k.to_map() if k else None)
        if self.hls is not None:
            result['hls'] = self.hls.to_map()
        if self.publish_reports is not None:
            result['publishReports'] = []
            for k in self.publish_reports:
                result['publishReports'].append(k.to_map() if k else None)
        if self.misc is not None:
            result['misc'] = self.misc.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('product') is not None:
            self.product = m.get('product')
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        if m.get('domainType') is not None:
            self.domain_type = m.get('domainType')
        if m.get('liveMode') is not None:
            self.live_mode = m.get('liveMode')
        if m.get('publishDomain') is not None:
            self.publish_domain = m.get('publishDomain')
        if m.get('cname') is not None:
            self.cname = m.get('cname')
        if m.get('hlsOrigin') is not None:
            self.hls_origin = m.get('hlsOrigin')
        if m.get('sliceArch') is not None:
            self.slice_arch = m.get('sliceArch')
        if m.get('appNames') is not None:
            self.app_names = m.get('appNames')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        if m.get('origins') is not None:
            temp_model = QueryLiveDomainDetailResponseDataOrigins()
            self.origins = temp_model.from_map(m['origins'])
        if m.get('accessCtrls') is not None:
            temp_model = QueryLiveDomainDetailResponseDataAccessCtrls()
            self.access_ctrls = temp_model.from_map(m['accessCtrls'])
        if m.get('headerRules') is not None:
            self.header_rules = []
            for k in m.get('headerRules'):
                temp_model = QueryLiveDomainDetailResponseDataHeaderRules()
                self.header_rules.append(temp_model.from_map(k))
        if m.get('hls') is not None:
            temp_model = QueryLiveDomainDetailResponseDataHls()
            self.hls = temp_model.from_map(m['hls'])
        if m.get('publishReports') is not None:
            self.publish_reports = []
            for k in m.get('publishReports'):
                temp_model = QueryLiveDomainDetailResponseDataPublishReports()
                self.publish_reports.append(temp_model.from_map(k))
        if m.get('misc') is not None:
            temp_model = QueryLiveDomainDetailResponseDataMisc()
            self.misc = temp_model.from_map(m['misc'])
        return self


class QueryLiveDomainDetailResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainDetailResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainDetailResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainDetailPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainDetailParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainDetailRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainDetailResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryHttp2SettingsConfigForWplusRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttp2SettingsConfigForWplusResponseHttp2Settings(TeaModel):
    def __init__(
        self,
        enable_http_2: bool = None,
        back_to_origin_protocol: str = None,
    ):
        # {"en":"Enable http2.0. The optional values are true and false. If it is empty, the default value is false. True means http2.0 is on; false means http2.0 is off.", "zh_CN":"开启http2.0，可选值为true和false，为空时默认为false。true表示开启http2.0；false表示关闭http2.0"}
        self.enable_http_2 = enable_http_2
        # {"en":"Back-to-origin protocol, the optional value is
        # http1.1: Use the HTTP1.1 protocol version to back to source. if not filled, use it as default.
        # follow-request: Same as client request protocol
        # http2.0: Use the HTTP2.0 protocol. version to back to source.", "zh_CN":"回源协议，可选值为
        # http1.1：使用HTTP1.1协议版本回源，不填时默认该协议
        # follow-request：跟随客户端请求协议
        # http2.0：使用HTTP2.0协议版本回源"}
        self.back_to_origin_protocol = back_to_origin_protocol

    def validate(self):
        self.validate_required(self.enable_http_2, 'enable_http_2')
        self.validate_required(self.back_to_origin_protocol, 'back_to_origin_protocol')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_http_2 is not None:
            result['enableHttp2'] = self.enable_http_2
        if self.back_to_origin_protocol is not None:
            result['backToOriginProtocol'] = self.back_to_origin_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHttp2') is not None:
            self.enable_http_2 = m.get('enableHttp2')
        if m.get('backToOriginProtocol') is not None:
            self.back_to_origin_protocol = m.get('backToOriginProtocol')
        return self


class QueryHttp2SettingsConfigForWplusResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        http_2settings: QueryHttp2SettingsConfigForWplusResponseHttp2Settings = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名id（domainId）"}
        self.domain_id = domain_id
        # {"en":"Http2.0 settings, used to enable or disable http2.0, parent node.", "zh_CN":"http2.0设置，用于设置http2.0的开启或关闭，父标签"}
        self.http_2settings = http_2settings

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.http_2settings, 'http_2settings')
        if self.http_2settings:
            self.http_2settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.http_2settings is not None:
            result['http2Settings'] = self.http_2settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('http2Settings') is not None:
            temp_model = QueryHttp2SettingsConfigForWplusResponseHttp2Settings()
            self.http_2settings = temp_model.from_map(m['http2Settings'])
        return self


class QueryHttp2SettingsConfigForWplusPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryHttp2SettingsConfigForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttp2SettingsConfigForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryHttp2SettingsConfigForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainPublishReportsRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainPublishReportsResponseDataPublishReportsStartArgs(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        server_ip: str = None,
        stream_name: str = None,
        host: str = None,
        app_name: str = None,
        port: str = None,
        time: str = None,
        milltime: str = None,
        md_5sign: str = None,
        request_args: List[str] = None,
    ):
        # {"en":"Client IP", "zh_CN":"客户端IP汇报参数名称"}
        self.client_ip = client_ip
        # {"en":"Server IP", "zh_CN":"服务器IP汇报参数名称"}
        self.server_ip = server_ip
        # {"en":"Stream Name", "zh_CN":"流名汇报参数名称"}
        self.stream_name = stream_name
        # {"en":"Host", "zh_CN":"推流域名汇报参数名称"}
        self.host = host
        # {"en":"App Name", "zh_CN":"发布点汇报参数名称"}
        self.app_name = app_name
        # {"en":"Port", "zh_CN":"推流器端口汇报参数名称"}
        self.port = port
        # {"en":"Time", "zh_CN":"推流时间汇报参数名称，单位秒"}
        self.time = time
        # {"en":"Milltime", "zh_CN":"推流时间汇报参数名称，单位毫秒"}
        self.milltime = milltime
        # {"en":"MD5 Sign", "zh_CN":"MD5签名汇报参数名称"}
        self.md_5sign = md_5sign
        # {"en":"Request Args", "zh_CN":"URL请求参数名称，汇报参数名称同请求参数名称"}
        self.request_args = request_args

    def validate(self):
        self.validate_required(self.client_ip, 'client_ip')
        self.validate_required(self.server_ip, 'server_ip')
        self.validate_required(self.stream_name, 'stream_name')
        self.validate_required(self.host, 'host')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.port, 'port')
        self.validate_required(self.time, 'time')
        self.validate_required(self.milltime, 'milltime')
        self.validate_required(self.md_5sign, 'md_5sign')
        self.validate_required(self.request_args, 'request_args')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['clientIp'] = self.client_ip
        if self.server_ip is not None:
            result['serverIp'] = self.server_ip
        if self.stream_name is not None:
            result['streamName'] = self.stream_name
        if self.host is not None:
            result['host'] = self.host
        if self.app_name is not None:
            result['appName'] = self.app_name
        if self.port is not None:
            result['port'] = self.port
        if self.time is not None:
            result['time'] = self.time
        if self.milltime is not None:
            result['milltime'] = self.milltime
        if self.md_5sign is not None:
            result['md5Sign'] = self.md_5sign
        if self.request_args is not None:
            result['requestArgs'] = self.request_args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientIp') is not None:
            self.client_ip = m.get('clientIp')
        if m.get('serverIp') is not None:
            self.server_ip = m.get('serverIp')
        if m.get('streamName') is not None:
            self.stream_name = m.get('streamName')
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('appName') is not None:
            self.app_name = m.get('appName')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('milltime') is not None:
            self.milltime = m.get('milltime')
        if m.get('md5Sign') is not None:
            self.md_5sign = m.get('md5Sign')
        if m.get('requestArgs') is not None:
            self.request_args = m.get('requestArgs')
        return self


class QueryLiveDomainPublishReportsResponseDataPublishReportsStopArgs(TeaModel):
    def __init__(
        self,
        client_ip: str = None,
        server_ip: str = None,
        stream_name: str = None,
        host: str = None,
        app_name: str = None,
        port: str = None,
        time: str = None,
        milltime: str = None,
        md_5sign: str = None,
        request_args: List[str] = None,
    ):
        # {"en":"Client IP", "zh_CN":"客户端IP汇报参数名称"}
        self.client_ip = client_ip
        # {"en":"Server IP", "zh_CN":"服务器IP汇报参数名称"}
        self.server_ip = server_ip
        # {"en":"Stream Name", "zh_CN":"流名汇报参数名称"}
        self.stream_name = stream_name
        # {"en":"Host", "zh_CN":"推流域名汇报参数名称"}
        self.host = host
        # {"en":"App Name", "zh_CN":"发布点汇报参数名称"}
        self.app_name = app_name
        # {"en":"Port", "zh_CN":"推流器端口汇报参数名称"}
        self.port = port
        # {"en":"Time", "zh_CN":"推流时间汇报参数名称，单位秒"}
        self.time = time
        # {"en":"Milltime", "zh_CN":"推流时间汇报参数名称，单位毫秒"}
        self.milltime = milltime
        # {"en":"MD5 Sign", "zh_CN":"MD5签名汇报参数名称"}
        self.md_5sign = md_5sign
        # {"en":"Request Args", "zh_CN":"URL请求参数名称，汇报参数名称同请求参数名称"}
        self.request_args = request_args

    def validate(self):
        self.validate_required(self.client_ip, 'client_ip')
        self.validate_required(self.server_ip, 'server_ip')
        self.validate_required(self.stream_name, 'stream_name')
        self.validate_required(self.host, 'host')
        self.validate_required(self.app_name, 'app_name')
        self.validate_required(self.port, 'port')
        self.validate_required(self.time, 'time')
        self.validate_required(self.milltime, 'milltime')
        self.validate_required(self.md_5sign, 'md_5sign')
        self.validate_required(self.request_args, 'request_args')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_ip is not None:
            result['clientIp'] = self.client_ip
        if self.server_ip is not None:
            result['serverIp'] = self.server_ip
        if self.stream_name is not None:
            result['streamName'] = self.stream_name
        if self.host is not None:
            result['host'] = self.host
        if self.app_name is not None:
            result['appName'] = self.app_name
        if self.port is not None:
            result['port'] = self.port
        if self.time is not None:
            result['time'] = self.time
        if self.milltime is not None:
            result['milltime'] = self.milltime
        if self.md_5sign is not None:
            result['md5Sign'] = self.md_5sign
        if self.request_args is not None:
            result['requestArgs'] = self.request_args
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clientIp') is not None:
            self.client_ip = m.get('clientIp')
        if m.get('serverIp') is not None:
            self.server_ip = m.get('serverIp')
        if m.get('streamName') is not None:
            self.stream_name = m.get('streamName')
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('appName') is not None:
            self.app_name = m.get('appName')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('milltime') is not None:
            self.milltime = m.get('milltime')
        if m.get('md5Sign') is not None:
            self.md_5sign = m.get('md5Sign')
        if m.get('requestArgs') is not None:
            self.request_args = m.get('requestArgs')
        return self


class QueryLiveDomainPublishReportsResponseDataPublishReports(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        app_names: List[str] = None,
        enabled: bool = None,
        report_method: str = None,
        report_address: str = None,
        enable_https: bool = None,
        sign_key: str = None,
        start_uri: str = None,
        start_args: QueryLiveDomainPublishReportsResponseDataPublishReportsStartArgs = None,
        stop_uri: str = None,
        stop_args: QueryLiveDomainPublishReportsResponseDataPublishReportsStopArgs = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"App Names", "zh_CN":"发布点"}
        self.app_names = app_names
        # {"en":"Enabled", "zh_CN":"是否启用汇报"}
        self.enabled = enabled
        # {"en":"Report Method, Enum [POST,GET]", "zh_CN":"汇报方法，可选值[POST,GET]"}
        self.report_method = report_method
        # {"en":"Report Address", "zh_CN":"汇报地址"}
        self.report_address = report_address
        # {"en":"Enable Https", "zh_CN":"是否启用HTTPS汇报"}
        self.enable_https = enable_https
        # {"en":"Sign Key", "zh_CN":"Md5签名的密钥"}
        self.sign_key = sign_key
        # {"en":"Start Uri", "zh_CN":"推流开始汇报URI"}
        self.start_uri = start_uri
        # {"en":"Start Args", "zh_CN":"推流开始汇报参数"}
        self.start_args = start_args
        # {"en":"Stop Uri", "zh_CN":"推流结束汇报URI"}
        self.stop_uri = stop_uri
        # {"en":"Stop Args", "zh_CN":"推流结束汇报参数"}
        self.stop_args = stop_args

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.app_names, 'app_names')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.report_method, 'report_method')
        self.validate_required(self.report_address, 'report_address')
        self.validate_required(self.enable_https, 'enable_https')
        self.validate_required(self.sign_key, 'sign_key')
        self.validate_required(self.start_uri, 'start_uri')
        self.validate_required(self.start_args, 'start_args')
        if self.start_args:
            self.start_args.validate()
        self.validate_required(self.stop_uri, 'stop_uri')
        self.validate_required(self.stop_args, 'stop_args')
        if self.stop_args:
            self.stop_args.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.app_names is not None:
            result['appNames'] = self.app_names
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.report_method is not None:
            result['reportMethod'] = self.report_method
        if self.report_address is not None:
            result['reportAddress'] = self.report_address
        if self.enable_https is not None:
            result['enableHttps'] = self.enable_https
        if self.sign_key is not None:
            result['signKey'] = self.sign_key
        if self.start_uri is not None:
            result['startUri'] = self.start_uri
        if self.start_args is not None:
            result['startArgs'] = self.start_args.to_map()
        if self.stop_uri is not None:
            result['stopUri'] = self.stop_uri
        if self.stop_args is not None:
            result['stopArgs'] = self.stop_args.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('appNames') is not None:
            self.app_names = m.get('appNames')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('reportMethod') is not None:
            self.report_method = m.get('reportMethod')
        if m.get('reportAddress') is not None:
            self.report_address = m.get('reportAddress')
        if m.get('enableHttps') is not None:
            self.enable_https = m.get('enableHttps')
        if m.get('signKey') is not None:
            self.sign_key = m.get('signKey')
        if m.get('startUri') is not None:
            self.start_uri = m.get('startUri')
        if m.get('startArgs') is not None:
            temp_model = QueryLiveDomainPublishReportsResponseDataPublishReportsStartArgs()
            self.start_args = temp_model.from_map(m['startArgs'])
        if m.get('stopUri') is not None:
            self.stop_uri = m.get('stopUri')
        if m.get('stopArgs') is not None:
            temp_model = QueryLiveDomainPublishReportsResponseDataPublishReportsStopArgs()
            self.stop_args = temp_model.from_map(m['stopArgs'])
        return self


class QueryLiveDomainPublishReportsResponseData(TeaModel):
    def __init__(
        self,
        publish_reports: List[QueryLiveDomainPublishReportsResponseDataPublishReports] = None,
    ):
        # {"en":"Publish Reports", "zh_CN":"推流汇报配置"}
        self.publish_reports = publish_reports

    def validate(self):
        self.validate_required(self.publish_reports, 'publish_reports')
        if self.publish_reports:
            for k in self.publish_reports:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.publish_reports is not None:
            result['publishReports'] = []
            for k in self.publish_reports:
                result['publishReports'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('publishReports') is not None:
            self.publish_reports = []
            for k in m.get('publishReports'):
                temp_model = QueryLiveDomainPublishReportsResponseDataPublishReports()
                self.publish_reports.append(temp_model.from_map(k))
        return self


class QueryLiveDomainPublishReportsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainPublishReportsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainPublishReportsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainPublishReportsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainPublishReportsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainPublishReportsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainPublishReportsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryRecordingBasicConfigurationRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryRecordingBasicConfigurationResponseDataRecordRulesFlvSettings(TeaModel):
    def __init__(
        self,
        flv_record_enabled: bool = None,
        flv_space_name: str = None,
        flv_file_name: str = None,
        flv_record_period: int = None,
        flv_notice_address: str = None,
    ):
        # {"en":"This item is to enable flv recording, the optional values are true and false.
        # flvSpaceName is required when flv recording is enabled. If false,  flvSpaceName,flvRecordPeriod and flvFileName will be cleared.", "zh_CN":"是否开启flv录制，可选值为true、false
        # 为是时，flvSpaceName必填;为否时，flvSpaceName、flvRecordPeriod、flvFileName"}
        self.flv_record_enabled = flv_record_enabled
        # {"en":"Flv recording space name. This item is required when flv recording is enabled; when flv recording is turned off, this item will be cleared.", "zh_CN":"flv录制空间名，开启flv录制时，此项必填；关闭flv录制时，此项会被清空。"}
        self.flv_space_name = flv_space_name
        # {"en":"flv file name", "zh_CN":"flv录制文件名，可选值支持2种格式如下：
        # 
        # 1）流名-时间戳（默认为该格式）：$(streamname)-$(timestamp)
        # 2）流名：$(streamname)
        # 关闭flv录制时，此项会被清空。"}
        self.flv_file_name = flv_file_name
        # {"en":"Flv recording time period, unit seconds (s). The default value is 1 day.
        # This item will be cleared when flv recording is turned off.", "zh_CN":"flv录制时间周期，单位秒（s）。
        # 为空，则默认为1天。
        # 关闭flv录制时，此项会被清空。"}
        self.flv_record_period = flv_record_period
        # {"en":"Callback notification address for flv record, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"flv回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；"}
        self.flv_notice_address = flv_notice_address

    def validate(self):
        self.validate_required(self.flv_record_enabled, 'flv_record_enabled')
        self.validate_required(self.flv_space_name, 'flv_space_name')
        self.validate_required(self.flv_file_name, 'flv_file_name')
        self.validate_required(self.flv_record_period, 'flv_record_period')
        self.validate_required(self.flv_notice_address, 'flv_notice_address')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flv_record_enabled is not None:
            result['flvRecordEnabled'] = self.flv_record_enabled
        if self.flv_space_name is not None:
            result['flvSpaceName'] = self.flv_space_name
        if self.flv_file_name is not None:
            result['flvFileName'] = self.flv_file_name
        if self.flv_record_period is not None:
            result['flvRecordPeriod'] = self.flv_record_period
        if self.flv_notice_address is not None:
            result['flvNoticeAddress'] = self.flv_notice_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flvRecordEnabled') is not None:
            self.flv_record_enabled = m.get('flvRecordEnabled')
        if m.get('flvSpaceName') is not None:
            self.flv_space_name = m.get('flvSpaceName')
        if m.get('flvFileName') is not None:
            self.flv_file_name = m.get('flvFileName')
        if m.get('flvRecordPeriod') is not None:
            self.flv_record_period = m.get('flvRecordPeriod')
        if m.get('flvNoticeAddress') is not None:
            self.flv_notice_address = m.get('flvNoticeAddress')
        return self


class QueryRecordingBasicConfigurationResponseDataRecordRulesM3u8Settings(TeaModel):
    def __init__(
        self,
        m_3u_8record_enabled: bool = None,
        m_3u_8space_name: str = None,
        m_3u_8record_period: int = None,
        m_3u_8file_name: str = None,
        time_shift: bool = None,
        segment_time: int = None,
        merge_ts_number: int = None,
        wait_time_4keyframe: int = None,
        m_3u_8notice_address: str = None,
    ):
        # {"en":"This item is to enable m3u8 recording, the optional values are true and false.
        # m3u8SpaceName is required when flv recording is enabled. If false, m3u8SpaceName, m3u8RecordPeriod, m3u8FileName, timeShift, segmentTime, mergeTsNumber, waitTime4Keyframe will be cleared.", "zh_CN":"是否开启m3u8录制，可选值为true、false
        # 为是时，m3u8SpaceName必填。为否时，清空m3u8SpaceName、m3u8RecordPeriod、m3u8FileName、timeShift、segmentTime、mergeTsNumber、waitTime4Keyframe"}
        self.m_3u_8record_enabled = m_3u_8record_enabled
        # {"en":"M3u8 recording space name. This item is required when m3u8 recording is enabled; when m3u8 recording is turned off, this item will be cleared.", "zh_CN":"m3u8录制空间名，开启m3u8录制时，此项必填;关闭m3u8录制时，此项会被清空。"}
        self.m_3u_8space_name = m_3u_8space_name
        # {"en":"M3u8 recording time period, unit hours (h). The range is 1-24, and -1 is also supported, indicating infinite merging.
        # The time of TS slice is 15s by default, and 240 slices are merged in one hour of recording period.
        # Note:
        # This item is required when m3u8 recording is turned on. And it will be cleared when m3u8 recording is turned off.It is different from that of FLV and MP4.", "zh_CN":"m3u8录制时间周期，配置时间区间内同流名的自动合并，单位小时（h）。范围1-24，同时也支持-1，表示无限期合并。
        # 
        # ts切片时长默认为15s，录制周期1h则有240个切片合并。
        # 
        # 注意：
        # 1.开启m3u8录制时，录制周期必填。关闭m3u8录制时，此项会被清空。
        # 2.m3u8的录制周期单位和flv/mp4不同。
        # 3.相同录制周期内的同流名多次推流，会合并一份文件（flv/mp4不会合并）。不设置时，一次推流为一份文件。
        # 4.周期计算（和flv/mp4不同）：比如配置2h，8:15:00开始录制，则8:15:00-9:59:59会合并一个文件，10:00:00~12:59:59合并一个文件"}
        self.m_3u_8record_period = m_3u_8record_period
        # {"en":"m3u8 file name", "zh_CN":"m3u8录制文件名，可选值支持2种格式如下：
        # 
        # 1）流名-时间戳（默认为该格式）：$(streamname)-$(timestamp)
        # 2）流名：$(streamname)
        # 关闭m3u8录制时，此项会被清空。"}
        self.m_3u_8file_name = m_3u_8file_name
        # {"en":"is support time shift", "zh_CN":"是否支持时移，可选值为true、false。不设置时默认是不支持的。"}
        self.time_shift = time_shift
        # {"en":"specify m3u8 segment time", "zh_CN":"指定m3u8的分段ts时长，整数，单位：秒，默认为15s，取值范围[0,120]"}
        self.segment_time = segment_time
        # {"en":"setting merge ts number", "zh_CN":"设置拼接成TS的ts切片数量，建议范围1-30，配置过长，可能引起等待过长m3u8无TS列表"}
        self.merge_ts_number = merge_ts_number
        # {"en":"setting wait time for key frame", "zh_CN":"指定中间出现连续音频数据时，等待视频关键帧的最大时长，单位s。达到此时长若仍未出现视频关键帧，则不再等待，进行ts切片。建议值：360"}
        self.wait_time_4keyframe = wait_time_4keyframe
        # {"en":"Callback notification address for m3u8 record, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"m3u8回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；"}
        self.m_3u_8notice_address = m_3u_8notice_address

    def validate(self):
        self.validate_required(self.m_3u_8record_enabled, 'm_3u_8record_enabled')
        self.validate_required(self.m_3u_8space_name, 'm_3u_8space_name')
        self.validate_required(self.m_3u_8record_period, 'm_3u_8record_period')
        self.validate_required(self.m_3u_8file_name, 'm_3u_8file_name')
        self.validate_required(self.time_shift, 'time_shift')
        self.validate_required(self.segment_time, 'segment_time')
        self.validate_required(self.merge_ts_number, 'merge_ts_number')
        self.validate_required(self.wait_time_4keyframe, 'wait_time_4keyframe')
        self.validate_required(self.m_3u_8notice_address, 'm_3u_8notice_address')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.m_3u_8record_enabled is not None:
            result['m3u8RecordEnabled'] = self.m_3u_8record_enabled
        if self.m_3u_8space_name is not None:
            result['m3u8SpaceName'] = self.m_3u_8space_name
        if self.m_3u_8record_period is not None:
            result['m3u8RecordPeriod'] = self.m_3u_8record_period
        if self.m_3u_8file_name is not None:
            result['m3u8FileName'] = self.m_3u_8file_name
        if self.time_shift is not None:
            result['timeShift'] = self.time_shift
        if self.segment_time is not None:
            result['segmentTime'] = self.segment_time
        if self.merge_ts_number is not None:
            result['mergeTsNumber'] = self.merge_ts_number
        if self.wait_time_4keyframe is not None:
            result['waitTime4Keyframe'] = self.wait_time_4keyframe
        if self.m_3u_8notice_address is not None:
            result['m3u8NoticeAddress'] = self.m_3u_8notice_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('m3u8RecordEnabled') is not None:
            self.m_3u_8record_enabled = m.get('m3u8RecordEnabled')
        if m.get('m3u8SpaceName') is not None:
            self.m_3u_8space_name = m.get('m3u8SpaceName')
        if m.get('m3u8RecordPeriod') is not None:
            self.m_3u_8record_period = m.get('m3u8RecordPeriod')
        if m.get('m3u8FileName') is not None:
            self.m_3u_8file_name = m.get('m3u8FileName')
        if m.get('timeShift') is not None:
            self.time_shift = m.get('timeShift')
        if m.get('segmentTime') is not None:
            self.segment_time = m.get('segmentTime')
        if m.get('mergeTsNumber') is not None:
            self.merge_ts_number = m.get('mergeTsNumber')
        if m.get('waitTime4Keyframe') is not None:
            self.wait_time_4keyframe = m.get('waitTime4Keyframe')
        if m.get('m3u8NoticeAddress') is not None:
            self.m_3u_8notice_address = m.get('m3u8NoticeAddress')
        return self


class QueryRecordingBasicConfigurationResponseDataRecordRulesMp4Settings(TeaModel):
    def __init__(
        self,
        mp_4record_enabled: bool = None,
        mp_4space_name: str = None,
        mp_4record_period: int = None,
        mp_4notice_address: str = None,
    ):
        # {"en":"This item is to enable mp4 recording, the optional values are true and false.
        # mp4SpaceName is required when mp4 recording is enabled. If false,  mp3SpaceName and mp3RecordPeriod will be cleared.", "zh_CN":"是否开启mp4录制，可选值为true、false
        # 为是时，mp4SpaceName必填。为否时，清空mp4SpaceName和mp4RecordPeriod"}
        self.mp_4record_enabled = mp_4record_enabled
        # {"en":"Mp3 recording space name. This item is required when mp3 recording is enabled; when mp3 recording is turned off, this item will be cleared.", "zh_CN":"mp4录制空间名,开启mp4录制时，此项必填；关闭mp4录制时，此项会被清空。"}
        self.mp_4space_name = mp_4space_name
        # {"en":"Mp4 recording time period, unit seconds (s). The default value is 1 day.
        # This item will be cleared when mp4 recording is turned off.", "zh_CN":"mp4录制时间周期，单位秒（s）
        # 为空，则默认为1天。关闭mp4录制时，此项会被清空。"}
        self.mp_4record_period = mp_4record_period
        # {"en":"Callback notification address for mp4 record, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"mp4回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；"}
        self.mp_4notice_address = mp_4notice_address

    def validate(self):
        self.validate_required(self.mp_4record_enabled, 'mp_4record_enabled')
        self.validate_required(self.mp_4space_name, 'mp_4space_name')
        self.validate_required(self.mp_4record_period, 'mp_4record_period')
        self.validate_required(self.mp_4notice_address, 'mp_4notice_address')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mp_4record_enabled is not None:
            result['mp4RecordEnabled'] = self.mp_4record_enabled
        if self.mp_4space_name is not None:
            result['mp4SpaceName'] = self.mp_4space_name
        if self.mp_4record_period is not None:
            result['mp4RecordPeriod'] = self.mp_4record_period
        if self.mp_4notice_address is not None:
            result['mp4NoticeAddress'] = self.mp_4notice_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mp4RecordEnabled') is not None:
            self.mp_4record_enabled = m.get('mp4RecordEnabled')
        if m.get('mp4SpaceName') is not None:
            self.mp_4space_name = m.get('mp4SpaceName')
        if m.get('mp4RecordPeriod') is not None:
            self.mp_4record_period = m.get('mp4RecordPeriod')
        if m.get('mp4NoticeAddress') is not None:
            self.mp_4notice_address = m.get('mp4NoticeAddress')
        return self


class QueryRecordingBasicConfigurationResponseDataRecordRules(TeaModel):
    def __init__(
        self,
        flv_settings: QueryRecordingBasicConfigurationResponseDataRecordRulesFlvSettings = None,
        m_3u_8settings: QueryRecordingBasicConfigurationResponseDataRecordRulesM3u8Settings = None,
        mp_4settings: QueryRecordingBasicConfigurationResponseDataRecordRulesMp4Settings = None,
        publish_points: List[str] = None,
        data_id: int = None,
    ):
        # {"en":"Flv recording configuration, parent node, Set <flvSettings/>  to clear the configuration.
        # flvRecordEnabled is required when flvSettings is not empty", "zh_CN":"flv录制配置，父标签，<flvSettings/>则清除配置
        # flvSettings不为空时，flvRecordEnabled必填"}
        self.flv_settings = flv_settings
        # {"en":"M3u8 recording configuration, parent node, Set <m3u8Settings/>  to clear the configuration.
        # m3u8RecordEnabled is required when m3u8Settings is not empty", "zh_CN":"m3u8录制配置，父标签，<m3u8Settings/>则清除配置
        # m3u8Settings不为空时，m3u8RecordEnabled必填"}
        self.m_3u_8settings = m_3u_8settings
        # {"en":"Mp4 recording configuration, parent node, Set <mp4Settings/>  to clear the configuration.
        # mp4RecordEnabled is required when mp4Settings is not empty", "zh_CN":"mp4录制配置，父标签，<mp4Settings/>则清除配置
        # mp4Settings不为空时，mp4RecordEnabled必填"}
        self.mp_4settings = mp_4settings
        # {"en":"Setting publish point of pull push domain. This is parent Tag.
        # example:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.flv_settings, 'flv_settings')
        if self.flv_settings:
            self.flv_settings.validate()
        self.validate_required(self.m_3u_8settings, 'm_3u_8settings')
        if self.m_3u_8settings:
            self.m_3u_8settings.validate()
        self.validate_required(self.mp_4settings, 'mp_4settings')
        if self.mp_4settings:
            self.mp_4settings.validate()
        self.validate_required(self.publish_points, 'publish_points')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flv_settings is not None:
            result['flvSettings'] = self.flv_settings.to_map()
        if self.m_3u_8settings is not None:
            result['m3u8Settings'] = self.m_3u_8settings.to_map()
        if self.mp_4settings is not None:
            result['mp4Settings'] = self.mp_4settings.to_map()
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flvSettings') is not None:
            temp_model = QueryRecordingBasicConfigurationResponseDataRecordRulesFlvSettings()
            self.flv_settings = temp_model.from_map(m['flvSettings'])
        if m.get('m3u8Settings') is not None:
            temp_model = QueryRecordingBasicConfigurationResponseDataRecordRulesM3u8Settings()
            self.m_3u_8settings = temp_model.from_map(m['m3u8Settings'])
        if m.get('mp4Settings') is not None:
            temp_model = QueryRecordingBasicConfigurationResponseDataRecordRulesMp4Settings()
            self.mp_4settings = temp_model.from_map(m['mp4Settings'])
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryRecordingBasicConfigurationResponseData(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        record_rules: List[QueryRecordingBasicConfigurationResponseDataRecordRules] = None,
    ):
        # {"en":"domain id", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain_name = domain_name
        # {"en":"Recording Configuration, parent node
        # 1. When you need to use the recording function, this must be filled in. 
        # 2. Configuration of clearing for <recordRules/>.", "zh_CN":"录制配置，父标签
        # 1.需要设置录制配置时，此项必填
        # 2.为<recordRules/>时清空配置"}
        self.record_rules = record_rules

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.record_rules, 'record_rules')
        if self.record_rules:
            for k in self.record_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.record_rules is not None:
            result['recordRules'] = []
            for k in self.record_rules:
                result['recordRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('recordRules') is not None:
            self.record_rules = []
            for k in m.get('recordRules'):
                temp_model = QueryRecordingBasicConfigurationResponseDataRecordRules()
                self.record_rules.append(temp_model.from_map(k))
        return self


class QueryRecordingBasicConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryRecordingBasicConfigurationResponseData = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryRecordingBasicConfigurationResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryRecordingBasicConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryRecordingBasicConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryRecordingBasicConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryRecordingBasicConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditIgnoreProtocolRequestIgnoreProtocolRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        except_path_pattern: str = None,
        cache_ignore_protocol: str = None,
        purge_ignore_protocol: str = None,
        data_id: int = None,
    ):
        # {"en":"Url matching pattern, support regular, if all matches, input parameters can be configured as:.*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The exception url matches the pattern in the same format as the path-pattern", "zh_CN":"例外的url匹配模式，格式同path-pattern"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Whether to ignore the protocol cache, with allowable values of true and false. True turns on the HTTP/HTTPS Shared cache. Not on by default.", "zh_CN":"是否忽略协议缓存，允许值为true和false。为true则开启http/https共用缓存。默认不开启。"}
        self.cache_ignore_protocol = cache_ignore_protocol
        # {"en":"It is recommended to use with cache-ignore protocol to avoid push failure.
        # 
        # Note:
        # 
        # 1. Once configured, the global effect is not applied to the matched path-pattern.
        # 
        # 2. Directory push does not distinguish protocols, while url push can distinguish protocols", "zh_CN":"是否忽略协议推送，允许值为true和false。为true则推送时忽略协议；为false则区分协议推送。
        # 建议和cache-ignore-protocol配套使用，避免推送失效。
        # 注意：
        # 1.一旦配置，则全局生效，不针对匹配的path-pattern生效。
        # 2.目录推送不区分协议，url推送可区分协议"}
        self.purge_ignore_protocol = purge_ignore_protocol
        # {"en":"When configuring multiple groups of configurations, specify the id of a particular group of configurations", "zh_CN":"配置多组配置时，具体某组配置的id"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.cache_ignore_protocol is not None:
            result['cache-ignore-protocol'] = self.cache_ignore_protocol
        if self.purge_ignore_protocol is not None:
            result['purge-ignore-protocol'] = self.purge_ignore_protocol
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('cache-ignore-protocol') is not None:
            self.cache_ignore_protocol = m.get('cache-ignore-protocol')
        if m.get('purge-ignore-protocol') is not None:
            self.purge_ignore_protocol = m.get('purge-ignore-protocol')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class EditIgnoreProtocolRequest(TeaModel):
    def __init__(
        self,
        ignore_protocol_rules: List[EditIgnoreProtocolRequestIgnoreProtocolRules] = None,
    ):
        # {"en":"Ignore protocol caching and push configuration, parent tags
        # 
        # 1. This must be filled when protocol cache and push configuration need to be ignored
        # 2.<ignore-protocol-rules/>:Clear the configuration ignore about protocol cache and pushing", "zh_CN":"忽略协议缓存和推送配置，父标签
        # 1.需要设置忽略协议缓存和推送配置时，此项必填
        # 2.为<ignore-protocol-rules/>时清空忽略协议缓存和推送的配置"}
        self.ignore_protocol_rules = ignore_protocol_rules

    def validate(self):
        self.validate_required(self.ignore_protocol_rules, 'ignore_protocol_rules')
        if self.ignore_protocol_rules:
            for k in self.ignore_protocol_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ignore_protocol_rules is not None:
            result['ignore-protocol-rules'] = []
            for k in self.ignore_protocol_rules:
                result['ignore-protocol-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ignore-protocol-rules') is not None:
            self.ignore_protocol_rules = []
            for k in m.get('ignore-protocol-rules'):
                temp_model = EditIgnoreProtocolRequestIgnoreProtocolRules()
                self.ignore_protocol_rules.append(temp_model.from_map(k))
        return self


class EditIgnoreProtocolResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        location: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The URL used to access the domain information, where domain-id is the unique token generated by our cloud platform for the domain name and whose value is a string.", "zh_CN":"响应信用于访问该域名信息的URL，其中domain-id为
        #      我司云平台为该域名生成的唯一标示，其值为字符串。"}
        self.location = location
        # {"en":"Error code, which appears when HTTPStatus is not 202, represents the error type of the current request call", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.location, 'location')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.location is not None:
            result['location'] = self.location
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditIgnoreProtocolPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditIgnoreProtocolParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditIgnoreProtocolRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditIgnoreProtocolResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditHttpCodeCacheRequestHttpCodeCacheRules(TeaModel):
    def __init__(
        self,
        http_codes: List[str] = None,
        cache_ttl: str = None,
        data_id: int = None,
    ):
        # {"en":"Configure HTTP status code, parent node", "zh_CN":"配置http状态码，父标签"}
        self.http_codes = http_codes
        # {"en":"Define the caching time of the specified status code in units s, 0 to indicate no caching", "zh_CN":"配置指定的状态码的缓存时间，单位s，0表示不缓存"}
        self.cache_ttl = cache_ttl
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note:
        # A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified.
        # B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id.
        # C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration.
        # D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared.
        # E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。data-id可以通过查询接口获取。 注意：
        # a、如果有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； 
        # b、如果入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置； 
        # c、如果入参都没有传data-id,表示用本次的配置全量覆盖原先配置； 
        # d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； 
        # e、如果一组配置没有具体的配置项，则data-id必填，且值为实际存在的data-id，表示清空这个data-id对应配置项的值；不允许一组配置没有具体的配置项也没有data-id。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.http_codes, 'http_codes')
        self.validate_required(self.cache_ttl, 'cache_ttl')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_codes is not None:
            result['http-codes'] = self.http_codes
        if self.cache_ttl is not None:
            result['cache-ttl'] = self.cache_ttl
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http-codes') is not None:
            self.http_codes = m.get('http-codes')
        if m.get('cache-ttl') is not None:
            self.cache_ttl = m.get('cache-ttl')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class EditHttpCodeCacheRequest(TeaModel):
    def __init__(
        self,
        http_code_cache_rules: List[EditHttpCodeCacheRequestHttpCodeCacheRules] = None,
    ):
        # {"en":"Status Code Caching Rule Configuration, parent node
        # 1. When you need to set status code caching rules, this must be filled in.
        # 2. Configuration of Clear Status Code Caching Rules for <http-code-cache-rules/>.", "zh_CN":"状态码缓存规则配置，父标签
        # 1.需要设置状态码缓存规则时，此项必填
        # 2.为<http-code-cache-rules/>时清空状态码缓存规则配置"}
        self.http_code_cache_rules = http_code_cache_rules

    def validate(self):
        self.validate_required(self.http_code_cache_rules, 'http_code_cache_rules')
        if self.http_code_cache_rules:
            for k in self.http_code_cache_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_code_cache_rules is not None:
            result['http-code-cache-rules'] = []
            for k in self.http_code_cache_rules:
                result['http-code-cache-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http-code-cache-rules') is not None:
            self.http_code_cache_rules = []
            for k in m.get('http-code-cache-rules'):
                temp_model = EditHttpCodeCacheRequestHttpCodeCacheRules()
                self.http_code_cache_rules.append(temp_model.from_map(k))
        return self


class EditHttpCodeCacheResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditHttpCodeCachePaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditHttpCodeCacheParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditHttpCodeCacheRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditHttpCodeCacheResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditWebsocketConfigRequestWebsocketSwitch(TeaModel):
    def __init__(
        self,
        enable_websocket: bool = None,
    ):
        # {"en":"Whether to turn on the websocket function, the allowable values are true and false, default false", "zh_CN":"是否开启websocket功能,允许值为true和false，默认为否"}
        self.enable_websocket = enable_websocket

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_websocket is not None:
            result['enableWebsocket'] = self.enable_websocket
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableWebsocket') is not None:
            self.enable_websocket = m.get('enableWebsocket')
        return self


class EditWebsocketConfigRequest(TeaModel):
    def __init__(
        self,
        websocket_switch: EditWebsocketConfigRequestWebsocketSwitch = None,
    ):
        # {"en":"Open or close websocket function, parent node, you can set <websocketSwitch/> to clear this configuration.
        # Scope of application: wsa, web pages", "zh_CN":"开启或关闭websocket功能，父标签，为<websocketSwitch/>则清空websocket开关配置
        # 适用范围：wsa、网页"}
        self.websocket_switch = websocket_switch

    def validate(self):
        self.validate_required(self.websocket_switch, 'websocket_switch')
        if self.websocket_switch:
            self.websocket_switch.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.websocket_switch is not None:
            result['websocketSwitch'] = self.websocket_switch.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('websocketSwitch') is not None:
            temp_model = EditWebsocketConfigRequestWebsocketSwitch()
            self.websocket_switch = temp_model.from_map(m['websocketSwitch'])
        return self


class EditWebsocketConfigResponse(TeaModel):
    def __init__(
        self,
        x_cnc_request_id: str = None,
        location: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The URL used to access the domain information, where domain-id is the unique token generated by our cloud platform for the domain name and whose value is a string.", "zh_CN":"用于访问该域名信息的URL，其中domain-id为我司云平台为该域名生成的唯一标示，其值为字符串。"}
        self.location = location
        # {"en":"Error code, 0 is success.", "zh_CN":"错误代码，成功为0"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.location, 'location')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.location is not None:
            result['Location'] = self.location
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditWebsocketConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditWebsocketConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditWebsocketConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditWebsocketConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateRecordingBasicConfigurationRequestRecordRulesFlvSettings(TeaModel):
    def __init__(
        self,
        flv_record_enabled: bool = None,
        flv_space_name: str = None,
        flv_file_name: str = None,
        flv_record_period: int = None,
        flv_notice_address: str = None,
    ):
        # {"en":"This item is to enable flv recording, the optional values are true and false.
        # flvSpaceName is required when flv recording is enabled. If false,  flvSpaceName,flvRecordPeriod and flvFileName will be cleared.", "zh_CN":"是否开启flv录制，可选值为true、false
        # 为是时，flvSpaceName必填;为否时，flvSpaceName、flvRecordPeriod、flvFileName"}
        self.flv_record_enabled = flv_record_enabled
        # {"en":"Flv recording space name. This item is required when flv recording is enabled; when flv recording is turned off, this item will be cleared.", "zh_CN":"flv录制空间名，开启flv录制时，此项必填；关闭flv录制时，此项会被清空。"}
        self.flv_space_name = flv_space_name
        # {"en":"flv file name", "zh_CN":"flv录制文件名，可选值支持2种格式如下：
        # 
        # 1）流名-时间戳（默认为该格式）：$(streamname)-$(timestamp)
        # 2）流名：$(streamname)
        # 关闭flv录制时，此项会被清空。"}
        self.flv_file_name = flv_file_name
        # {"en":"Flv recording time period, unit seconds (s). The default value is 1 day.
        # This item will be cleared when flv recording is turned off.", "zh_CN":"flv录制时间周期，单位秒（s）。
        # 为空，则默认为1天。
        # 注意：
        # 1.关闭flv录制时，此项会被清空。
        # 2.相同录制周期内的同流名多次推流，每次推流会独立文件。
        # 3.录制周期：从录制开始算起+录制周期时长，则保存一份文件"}
        self.flv_record_period = flv_record_period
        # {"en":"Callback notification address for flv record, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"flv回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；"}
        self.flv_notice_address = flv_notice_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flv_record_enabled is not None:
            result['flvRecordEnabled'] = self.flv_record_enabled
        if self.flv_space_name is not None:
            result['flvSpaceName'] = self.flv_space_name
        if self.flv_file_name is not None:
            result['flvFileName'] = self.flv_file_name
        if self.flv_record_period is not None:
            result['flvRecordPeriod'] = self.flv_record_period
        if self.flv_notice_address is not None:
            result['flvNoticeAddress'] = self.flv_notice_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flvRecordEnabled') is not None:
            self.flv_record_enabled = m.get('flvRecordEnabled')
        if m.get('flvSpaceName') is not None:
            self.flv_space_name = m.get('flvSpaceName')
        if m.get('flvFileName') is not None:
            self.flv_file_name = m.get('flvFileName')
        if m.get('flvRecordPeriod') is not None:
            self.flv_record_period = m.get('flvRecordPeriod')
        if m.get('flvNoticeAddress') is not None:
            self.flv_notice_address = m.get('flvNoticeAddress')
        return self


class UpdateRecordingBasicConfigurationRequestRecordRulesM3u8Settings(TeaModel):
    def __init__(
        self,
        m_3u_8record_enabled: bool = None,
        m_3u_8space_name: str = None,
        m_3u_8record_period: int = None,
        m_3u_8file_name: str = None,
        time_shift: bool = None,
        segment_time: int = None,
        merge_ts_number: int = None,
        wait_time_4keyframe: int = None,
        m_3u_8notice_address: str = None,
    ):
        # {"en":"This item is to enable m3u8 recording, the optional values are true and false.
        # m3u8SpaceName is required when flv recording is enabled. If false, m3u8SpaceName, m3u8RecordPeriod, m3u8FileName, timeShift, segmentTime, mergeTsNumber, waitTime4Keyframe will be cleared.", "zh_CN":"是否开启m3u8录制，可选值为true、false
        # 为是时，m3u8SpaceName必填。为否时，清空m3u8SpaceName、m3u8RecordPeriod、m3u8FileName、timeShift、segmentTime、mergeTsNumber、waitTime4Keyframe"}
        self.m_3u_8record_enabled = m_3u_8record_enabled
        # {"en":"M3u8 recording space name. This item is required when m3u8 recording is enabled; when m3u8 recording is turned off, this item will be cleared.", "zh_CN":"m3u8录制空间名，开启m3u8录制时，此项必填;关闭m3u8录制时，此项会被清空。"}
        self.m_3u_8space_name = m_3u_8space_name
        # {"en":"M3u8 recording time period, unit hours (h). The range is 1-24, and -1 is also supported, indicating infinite merging.
        # The time of TS slice is 15s by default, and 240 slices are merged in one hour of recording period.
        # Note:
        # This item is required when m3u8 recording is turned on. And it will be cleared when m3u8 recording is turned off.It is different from that of FLV and MP4.", "zh_CN":"m3u8录制时间周期，配置时间区间内同流名的自动合并，单位小时（h）。范围1-24，同时也支持-1，表示无限期合并。
        # 
        # ts切片时长默认为15s，录制周期1h则有240个切片合并。
        # 
        # 注意：
        # 
        # 1.开启m3u8录制时，录制周期必填。关闭m3u8录制时，此项会被清空。
        # 2.m3u8的录制周期单位和flv/mp4不同。
        # 3.相同录制周期内的同流名多次推流，会合并一份文件（flv/mp4不会合并）。不设置时，一次推流为一份文件。
        # 4.周期计算（和flv/mp4不同）：比如配置2h，8:15:00开始录制，则8:15:00-9:59:59会合并一个文件，10:00:00~12:59:59合并一个文件"}
        self.m_3u_8record_period = m_3u_8record_period
        # {"en":"m3u8 file name", "zh_CN":"m3u8录制文件名，可选值支持2种格式如下：
        # 1）流名-时间戳（默认为该格式）：$(streamname)-$(timestamp)
        # 2）流名：$(streamname)
        # 关闭m3u8录制时，此项会被清空。"}
        self.m_3u_8file_name = m_3u_8file_name
        # {"en":"is support time shift", "zh_CN":"是否支持时移，可选值为true、false。不设置时默认是不支持的。"}
        self.time_shift = time_shift
        # {"en":"specify m3u8 segment time", "zh_CN":"指定m3u8的分段ts时长，整数，单位：秒，默认为15s，取值范围[0,120]"}
        self.segment_time = segment_time
        # {"en":"setting merge ts number", "zh_CN":"设置拼接成TS的ts切片数量，建议范围1-30，配置过长，可能引起等待过长m3u8无TS列表"}
        self.merge_ts_number = merge_ts_number
        # {"en":"setting wait time for key frame", "zh_CN":"指定中间出现连续音频数据时，等待视频关键帧的最大时长，单位s。达到此时长若仍未出现视频关键帧，则不再等待，进行ts切片。建议值：360"}
        self.wait_time_4keyframe = wait_time_4keyframe
        # {"en":"Callback notification address for m3u8 record, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"m3u8回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；"}
        self.m_3u_8notice_address = m_3u_8notice_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.m_3u_8record_enabled is not None:
            result['m3u8RecordEnabled'] = self.m_3u_8record_enabled
        if self.m_3u_8space_name is not None:
            result['m3u8SpaceName'] = self.m_3u_8space_name
        if self.m_3u_8record_period is not None:
            result['m3u8RecordPeriod'] = self.m_3u_8record_period
        if self.m_3u_8file_name is not None:
            result['m3u8FileName'] = self.m_3u_8file_name
        if self.time_shift is not None:
            result['timeShift'] = self.time_shift
        if self.segment_time is not None:
            result['segmentTime'] = self.segment_time
        if self.merge_ts_number is not None:
            result['mergeTsNumber'] = self.merge_ts_number
        if self.wait_time_4keyframe is not None:
            result['waitTime4Keyframe'] = self.wait_time_4keyframe
        if self.m_3u_8notice_address is not None:
            result['m3u8NoticeAddress'] = self.m_3u_8notice_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('m3u8RecordEnabled') is not None:
            self.m_3u_8record_enabled = m.get('m3u8RecordEnabled')
        if m.get('m3u8SpaceName') is not None:
            self.m_3u_8space_name = m.get('m3u8SpaceName')
        if m.get('m3u8RecordPeriod') is not None:
            self.m_3u_8record_period = m.get('m3u8RecordPeriod')
        if m.get('m3u8FileName') is not None:
            self.m_3u_8file_name = m.get('m3u8FileName')
        if m.get('timeShift') is not None:
            self.time_shift = m.get('timeShift')
        if m.get('segmentTime') is not None:
            self.segment_time = m.get('segmentTime')
        if m.get('mergeTsNumber') is not None:
            self.merge_ts_number = m.get('mergeTsNumber')
        if m.get('waitTime4Keyframe') is not None:
            self.wait_time_4keyframe = m.get('waitTime4Keyframe')
        if m.get('m3u8NoticeAddress') is not None:
            self.m_3u_8notice_address = m.get('m3u8NoticeAddress')
        return self


class UpdateRecordingBasicConfigurationRequestRecordRulesMp4Settings(TeaModel):
    def __init__(
        self,
        mp_4record_enabled: bool = None,
        mp_4space_name: str = None,
        mp_4file_name: str = None,
        mp_4record_period: int = None,
        mp_4notice_address: str = None,
    ):
        # {"en":"This item is to enable mp4 recording, the optional values are true and false.
        # mp4SpaceName is required when mp4 recording is enabled. If false,  mp4SpaceName, mp4RecordPeriod and mp4FileName will be cleared.", "zh_CN":"是否开启mp4录制，可选值为true、false
        # 为是时，mp4SpaceName必填。为否时，清空mp4SpaceName、mp4RecordPeriod、mp4FileName"}
        self.mp_4record_enabled = mp_4record_enabled
        # {"en":"Mp3 recording space name. This item is required when mp3 recording is enabled; when mp3 recording is turned off, this item will be cleared.", "zh_CN":"mp4录制空间名,开启mp4录制时，此项必填；关闭mp4录制时，此项会被清空。"}
        self.mp_4space_name = mp_4space_name
        # {"en":"mp4 file name", "zh_CN":"mp4录制文件名，可选值支持2种格式如下：
        # 
        # 1）流名-时间戳（默认为该格式）：$(streamname)-$(timestamp)
        # 2）流名：$(streamname)
        # 关闭flv录制时，此项会被清空。"}
        self.mp_4file_name = mp_4file_name
        # {"en":"Mp4 recording time period, unit seconds (s). The default value is 1 day.
        # This item will be cleared when mp4 recording is turned off.", "zh_CN":"mp4录制时间周期，单位秒（s）
        # 为空，则默认为1天。
        # 注意：
        # 1.关闭mp4录制时，此项会被清空。
        # 2.相同录制周期内的同流名多次推流，每次推流会独立文件。
        # 3.录制周期：从录制开始算起+录制周期时长，则保存一份文件"}
        self.mp_4record_period = mp_4record_period
        # {"en":"Callback notification address for mp4 record, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"mp4回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；"}
        self.mp_4notice_address = mp_4notice_address

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mp_4record_enabled is not None:
            result['mp4RecordEnabled'] = self.mp_4record_enabled
        if self.mp_4space_name is not None:
            result['mp4SpaceName'] = self.mp_4space_name
        if self.mp_4file_name is not None:
            result['mp4FileName'] = self.mp_4file_name
        if self.mp_4record_period is not None:
            result['mp4RecordPeriod'] = self.mp_4record_period
        if self.mp_4notice_address is not None:
            result['mp4NoticeAddress'] = self.mp_4notice_address
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mp4RecordEnabled') is not None:
            self.mp_4record_enabled = m.get('mp4RecordEnabled')
        if m.get('mp4SpaceName') is not None:
            self.mp_4space_name = m.get('mp4SpaceName')
        if m.get('mp4FileName') is not None:
            self.mp_4file_name = m.get('mp4FileName')
        if m.get('mp4RecordPeriod') is not None:
            self.mp_4record_period = m.get('mp4RecordPeriod')
        if m.get('mp4NoticeAddress') is not None:
            self.mp_4notice_address = m.get('mp4NoticeAddress')
        return self


class UpdateRecordingBasicConfigurationRequestRecordRules(TeaModel):
    def __init__(
        self,
        flv_settings: UpdateRecordingBasicConfigurationRequestRecordRulesFlvSettings = None,
        m_3u_8settings: UpdateRecordingBasicConfigurationRequestRecordRulesM3u8Settings = None,
        mp_4settings: UpdateRecordingBasicConfigurationRequestRecordRulesMp4Settings = None,
        publish_points: List[str] = None,
        data_id: int = None,
    ):
        # {"en":"Flv recording configuration, parent node, Set <flvSettings/>  to clear the configuration.
        # flvRecordEnabled is required when flvSettings is not empty", "zh_CN":"flv录制配置，父标签，<flvSettings/>则清除配置
        # flvSettings不为空时，flvRecordEnabled必填"}
        self.flv_settings = flv_settings
        # {"en":"M3u8 recording configuration, parent node, Set <m3u8Settings/>  to clear the configuration.
        # m3u8RecordEnabled is required when m3u8Settings is not empty", "zh_CN":"m3u8录制配置，父标签，<m3u8Settings/>则清除配置
        # m3u8Settings不为空时，m3u8RecordEnabled必填"}
        self.m_3u_8settings = m_3u_8settings
        # {"en":"Mp4 recording configuration, parent node, Set <mp4Settings/>  to clear the configuration.
        # mp4RecordEnabled is required when mp4Settings is not empty", "zh_CN":"mp4录制配置，父标签，<mp4Settings/>则清除配置
        # mp4Settings不为空时，mp4RecordEnabled必填"}
        self.mp_4settings = mp_4settings
        # {"en":"Setting publish point of pull push domain. This is parent Tag.
        # example:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        if self.flv_settings:
            self.flv_settings.validate()
        if self.m_3u_8settings:
            self.m_3u_8settings.validate()
        if self.mp_4settings:
            self.mp_4settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flv_settings is not None:
            result['flvSettings'] = self.flv_settings.to_map()
        if self.m_3u_8settings is not None:
            result['m3u8Settings'] = self.m_3u_8settings.to_map()
        if self.mp_4settings is not None:
            result['mp4Settings'] = self.mp_4settings.to_map()
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('flvSettings') is not None:
            temp_model = UpdateRecordingBasicConfigurationRequestRecordRulesFlvSettings()
            self.flv_settings = temp_model.from_map(m['flvSettings'])
        if m.get('m3u8Settings') is not None:
            temp_model = UpdateRecordingBasicConfigurationRequestRecordRulesM3u8Settings()
            self.m_3u_8settings = temp_model.from_map(m['m3u8Settings'])
        if m.get('mp4Settings') is not None:
            temp_model = UpdateRecordingBasicConfigurationRequestRecordRulesMp4Settings()
            self.mp_4settings = temp_model.from_map(m['mp4Settings'])
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class UpdateRecordingBasicConfigurationRequest(TeaModel):
    def __init__(
        self,
        record_rules: List[UpdateRecordingBasicConfigurationRequestRecordRules] = None,
    ):
        # {"en":"Recording Configuration, parent node
        # 1. When you need to use the recording function, this must be filled in. 
        # 2. Configuration of clearing for <recordRules/>.", "zh_CN":"录制配置，父标签
        # 1.需要设置录制配置时，此项必填
        # 2.为<recordRules/>时清空配置"}
        self.record_rules = record_rules

    def validate(self):
        self.validate_required(self.record_rules, 'record_rules')
        if self.record_rules:
            for k in self.record_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_rules is not None:
            result['recordRules'] = []
            for k in self.record_rules:
                result['recordRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('recordRules') is not None:
            self.record_rules = []
            for k in m.get('recordRules'):
                temp_model = UpdateRecordingBasicConfigurationRequestRecordRules()
                self.record_rules.append(temp_model.from_map(k))
        return self


class UpdateRecordingBasicConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateRecordingBasicConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class UpdateRecordingBasicConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateRecordingBasicConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateRecordingBasicConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditBack2originProtocolRewriteConfigRequestBackToOriginRewriteRule(TeaModel):
    def __init__(
        self,
        protocol: str = None,
        port: str = None,
    ):
        # {"en":"The specified protocol is either http or https.", "zh_CN":"改写后的回源协议，可选值：http、https"}
        self.protocol = protocol
        # {"en":"If the protocol is http, the default is 80. If the protocol is https, the default is 443", "zh_CN":"改写后的回源端口，若protocol为http时，默认为80，若protocol为https时，默认为443"}
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class EditBack2originProtocolRewriteConfigRequest(TeaModel):
    def __init__(
        self,
        back_to_origin_rewrite_rule: EditBack2originProtocolRewriteConfigRequestBackToOriginRewriteRule = None,
    ):
        # {"en":"Back to origin rewrite rule.", "zh_CN":"修改回源协议和端口；若要按原始请求回源，则可清空该对象，示例\"backToOriginRewriteRule\":{}"}
        self.back_to_origin_rewrite_rule = back_to_origin_rewrite_rule

    def validate(self):
        self.validate_required(self.back_to_origin_rewrite_rule, 'back_to_origin_rewrite_rule')
        if self.back_to_origin_rewrite_rule:
            self.back_to_origin_rewrite_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.back_to_origin_rewrite_rule is not None:
            result['backToOriginRewriteRule'] = self.back_to_origin_rewrite_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('backToOriginRewriteRule') is not None:
            temp_model = EditBack2originProtocolRewriteConfigRequestBackToOriginRewriteRule()
            self.back_to_origin_rewrite_rule = temp_model.from_map(m['backToOriginRewriteRule'])
        return self


class EditBack2originProtocolRewriteConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200 or 202.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class EditBack2originProtocolRewriteConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditBack2originProtocolRewriteConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditBack2originProtocolRewriteConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditBack2originProtocolRewriteConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetAppaDomainConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetAppaDomainConfigResponseOriginConfigOrigin(TeaModel):
    def __init__(
        self,
        origin_ip: str = None,
        weight: int = None,
    ):
        # {"en":"Origin address, which can be an IP or domain name.", "zh_CN":"回源IP/域名，可配置一个IP或域名。"}
        self.origin_ip = origin_ip
        # {"en":"Weight, which is only useful for robin strategy. The value is an integer ranging from 1 to 10000. If this parameter is not specified, the default value is 10.", "zh_CN":"权重，只对轮询策略有用。取值范围为1-10000的整数，不填默认为10。"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.origin_ip, 'origin_ip')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_ip is not None:
            result['originIp'] = self.origin_ip
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('originIp') is not None:
            self.origin_ip = m.get('originIp')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class GetAppaDomainConfigResponseOriginConfig(TeaModel):
    def __init__(
        self,
        level: int = None,
        strategy: str = None,
        origin: List[GetAppaDomainConfigResponseOriginConfigOrigin] = None,
    ):
        # {"en":"The level of the origin, which value can be an integer ranging from 1 to 5. Note:1. Must be configured level by level start from level 1. The same level cannot be configured repeatedly.2. The lower the value, the higher the priority.", "zh_CN":"层级，可选值为1-5的整数。注意：1、必须从层级1开始逐级配置，相同层级不能重复配置。2、数值越低，优先级越高。"}
        self.level = level
        # {"en":"Origin selection strategy supports fast, robin and hash. The value can be: fast: Fast strategy, robin: Robin strategy,hash: Hash strategy", "zh_CN":"选源策略，支持快速、轮询、哈希，可选值为:fast：快速,robin：轮询,hash：哈希"}
        self.strategy = strategy
        # {"en":"Origin information of a certain level. A level can be configured with multiple origin IP addresses or domain names.Example:'origin':[{'originIp':'1.1.1.1','weight':10},{'originIp':'2.2.2.2','weight':20}]", "zh_CN":"某个层级的源信息。一个层级可以配置多个回源IP/域名。示例：'origin':[{'originIp':'1.1.1.1','weight':10},{'originIp':'2.2.2.2','weight':20}]"}
        self.origin = origin

    def validate(self):
        self.validate_required(self.level, 'level')
        self.validate_required(self.strategy, 'strategy')
        self.validate_required(self.origin, 'origin')
        if self.origin:
            for k in self.origin:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.strategy is not None:
            result['strategy'] = self.strategy
        if self.origin is not None:
            result['origin'] = []
            for k in self.origin:
                result['origin'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('strategy') is not None:
            self.strategy = m.get('strategy')
        if m.get('origin') is not None:
            self.origin = []
            for k in m.get('origin'):
                temp_model = GetAppaDomainConfigResponseOriginConfigOrigin()
                self.origin.append(temp_model.from_map(k))
        return self


class GetAppaDomainConfigResponse(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        service_type: str = None,
        origin_config: List[GetAppaDomainConfigResponseOriginConfig] = None,
        http_ports: List[str] = None,
        https_ports: List[str] = None,
        tcp_ports: List[str] = None,
        udp_ports: List[str] = None,
    ):
        # {"en":"Domain ID", "zh_CN":"加速域名ID"}
        self.domain_id = domain_id
        # {"en":"Domain name you want to accelerate.A generic domain name is supported, starting with the symbol '.', such as .example.com.", "zh_CN":"加速域名。支持泛域名，以符号“.”开头，例如：.example.com。"}
        self.domain_name = domain_name
        # {"en":"The service type of the accelerated domain name. The value can be: 
        # appa: Application Acceleration", "zh_CN":"加速域名的服务类型，可选值为：
        # appa：应用加速/s-appa：应用安全加速解决方案"}
        self.service_type = service_type
        # {"en":"Origin configuration.
        # Example:
        # 'originConfig':[
        #   {'level':1,'strategy':'robin','origin': 
        #     [
        #       {'originIp':'1.1.1.1','weight':10}, 
        #       {'originIp':'2.2.2.2','weight':20}
        #     ]
        #   },
        #   {'level':2,'strategy':'quick','origin': 
        #    [{'originIp':'3.3.3.3','weight':10}]
        #   }
        # ]", "zh_CN":"源站配置
        # 示例
        # 'originConfig':[
        #   {'level':1,'strategy':'robin','origin': 
        #     [
        #       {'originIp':'1.1.1.1','weight':10}, 
        #       {'originIp':'2.2.2.2','weight':20}
        #     ]
        #   },
        #   {'level':2,'strategy':'quick','origin': 
        #    [{'originIp':'3.3.3.3','weight':10}]
        #   }
        # ]"}
        self.origin_config = origin_config
        # {'en':'HTTP port. The value is an integer ranging from 1 to 65535. Multiple ports are supported and can be configured in the following format:httpPorts:["9001"]Note: 1. Ports 2012, 2323, 2443, 4031, 12012, 20121, 57891, 62016, 65383, and 65529 do not support.2. The HTTP port and HTTPS port and TCP port must be unique.3. At least one HTTP port or HTTPS port or TCP port or UDP port must be configured.', 'zh_CN':'HTTP端口，取值范围为1-65535的整数，可配置多个，格式如：httpPorts:["9001"]注意：1、端口2012、2323、2443、4031、12012、20121、57891、62016、65383、65529不支持配置。2、HTTP端口和HTTPS端口和TCP端口不能重复。3、HTTP端口和HTTPS端口和TCP端口和UDP端口必须至少配置一个。'}
        self.http_ports = http_ports
        # {'en':'HTTPS port. The value is an integer ranging from 1 to 65535. Multiple ports are supported and can be configured in the following format:httpPorts:["9002","9003"]Note: 1. Ports 2012, 2323, 2443, 4031, 12012, 20121, 57891, 62016, 65383, and 65529 do not support.2. The HTTP port and HTTPS port and TCP port must be unique.3. At least one HTTP port or HTTPS port or TCP port or UDP port must be configured.', 'zh_CN':'HTTPS端口，取值范围为1-65535的整数，可配置多个，格式如：httpsPorts:["9002","9003"]注意：1、端口2012、2323、2443、4031、12012、20121、57891、62016、65383、65529不支持配置。2、HTTP端口和HTTPS端口和TCP端口不能重复。3、HTTP端口和HTTPS端口和TCP端口和UDP端口必须至少配置一个。'}
        self.https_ports = https_ports
        # {'en':'TCP port.The value is an integer ranging from 1 to 65535. Multiple ports are supported and can be configured in the following format:tcpPorts:["9005-9007"]Note: 1. Ports 2012, 2323, 2443, 4031, 12012, 20121, 57891, 62016, 65383, and 65529 do not support.2. The HTTP port and HTTPS port and TCP port must be unique.3. At least one HTTP port or HTTPS port or TCP port or UDP port must be configured.', 'zh_CN':'TCP端口，取值范围为1-65535的整数，可配置多个，格式如：tcpPorts:["9005-9007"]注意：1、端口2012、2323、2443、4031、12012、20121、57891、62016、65383、65529不支持配置。2、HTTP端口和HTTPS端口和TCP端口不能重复。3、HTTP端口和HTTPS端口和TCP端口和UDP端口必须至少配置一个。'}
        self.tcp_ports = tcp_ports
        # {'en':'UDP port.The value is an integer ranging from 1 to 65535. Multiple ports are supported and can be configured in the following format:udpPorts:["9008-9009"]Note: 1. Ports 2012, 2323, 2443, 4031, 12012, 20121, 57891, 62016, 65383, and 65529 do not support.2. At least one HTTP port or HTTPS port or TCP port or UDP port must be configured.', 'zh_CN':'UDP端口，取值范围为1-65535的整数，可配置多个，格式如：udpPorts:["9008-9009"]注意：1、端口2012、2323、2443、4031、12012、20121、57891、62016、65383、65529不支持配置。2、HTTP端口和HTTPS端口和TCP端口和UDP端口必须至少配置一个。'}
        self.udp_ports = udp_ports

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.service_type, 'service_type')
        self.validate_required(self.origin_config, 'origin_config')
        if self.origin_config:
            for k in self.origin_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.service_type is not None:
            result['serviceType'] = self.service_type
        if self.origin_config is not None:
            result['originConfig'] = []
            for k in self.origin_config:
                result['originConfig'].append(k.to_map() if k else None)
        if self.http_ports is not None:
            result['httpPorts'] = self.http_ports
        if self.https_ports is not None:
            result['httpsPorts'] = self.https_ports
        if self.tcp_ports is not None:
            result['tcpPorts'] = self.tcp_ports
        if self.udp_ports is not None:
            result['udpPorts'] = self.udp_ports
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('serviceType') is not None:
            self.service_type = m.get('serviceType')
        if m.get('originConfig') is not None:
            self.origin_config = []
            for k in m.get('originConfig'):
                temp_model = GetAppaDomainConfigResponseOriginConfig()
                self.origin_config.append(temp_model.from_map(k))
        if m.get('httpPorts') is not None:
            self.http_ports = m.get('httpPorts')
        if m.get('httpsPorts') is not None:
            self.https_ports = m.get('httpsPorts')
        if m.get('tcpPorts') is not None:
            self.tcp_ports = m.get('tcpPorts')
        if m.get('udpPorts') is not None:
            self.udp_ports = m.get('udpPorts')
        return self


class GetAppaDomainConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain whoes need to query.", "zh_CN":"需要查询的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class GetAppaDomainConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetAppaDomainConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetAppaDomainConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateDomainMultiCertConfigForWplusCertConfigs(TeaModel):
    def __init__(
        self,
        cert_usage: str = None,
        certificate_ids: List[str] = None,
    ):
        # {"en":"certUsage", "zh_CN":"证书用途"}
        self.cert_usage = cert_usage
        # {"en":"certificate id list", "zh_CN":"证书id列表"}
        self.certificate_ids = certificate_ids

    def validate(self):
        self.validate_required(self.cert_usage, 'cert_usage')
        self.validate_required(self.certificate_ids, 'certificate_ids')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_usage is not None:
            result['certUsage'] = self.cert_usage
        if self.certificate_ids is not None:
            result['certificateIds'] = self.certificate_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('certUsage') is not None:
            self.cert_usage = m.get('certUsage')
        if m.get('certificateIds') is not None:
            self.certificate_ids = m.get('certificateIds')
        return self


class UpdateDomainMultiCertConfigForWplusDomainCertConfig(TeaModel):
    def __init__(
        self,
        operate_type: str = None,
        cert_configs: List[UpdateDomainMultiCertConfigForWplusCertConfigs] = None,
    ):
        # {"en":"operateType", "zh_CN":"CANCEL表示删除，ADD表示关联"}
        self.operate_type = operate_type
        # {"en":"cert config", "zh_CN":"域名证书配置"}
        self.cert_configs = cert_configs

    def validate(self):
        self.validate_required(self.operate_type, 'operate_type')
        self.validate_required(self.cert_configs, 'cert_configs')
        if self.cert_configs:
            for k in self.cert_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_type is not None:
            result['operateType'] = self.operate_type
        if self.cert_configs is not None:
            result['certConfigs'] = []
            for k in self.cert_configs:
                result['certConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('operateType') is not None:
            self.operate_type = m.get('operateType')
        if m.get('certConfigs') is not None:
            self.cert_configs = []
            for k in m.get('certConfigs'):
                temp_model = UpdateDomainMultiCertConfigForWplusCertConfigs()
                self.cert_configs.append(temp_model.from_map(k))
        return self


class UpdateDomainMultiCertConfigForWplusOtherConfig(TeaModel):
    def __init__(
        self,
        tls_version: str = None,
        enable_ocsp: str = None,
        cipher_suites: str = None,
    ):
        # {"en":"tlsVersion", "zh_CN":"TLS协议"}
        self.tls_version = tls_version
        # {"en":"enableOCSP", "zh_CN":"支持OCSP"}
        self.enable_ocsp = enable_ocsp
        # {"en":"cipherSuites", "zh_CN":"cipher套件"}
        self.cipher_suites = cipher_suites

    def validate(self):
        self.validate_required(self.tls_version, 'tls_version')
        self.validate_required(self.enable_ocsp, 'enable_ocsp')
        self.validate_required(self.cipher_suites, 'cipher_suites')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tls_version is not None:
            result['tlsVersion'] = self.tls_version
        if self.enable_ocsp is not None:
            result['enableOCSP'] = self.enable_ocsp
        if self.cipher_suites is not None:
            result['cipherSuites'] = self.cipher_suites
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('tlsVersion') is not None:
            self.tls_version = m.get('tlsVersion')
        if m.get('enableOCSP') is not None:
            self.enable_ocsp = m.get('enableOCSP')
        if m.get('cipherSuites') is not None:
            self.cipher_suites = m.get('cipherSuites')
        return self


class UpdateDomainMultiCertConfigForWplusRequest(TeaModel):
    def __init__(
        self,
        domain_cert_config: UpdateDomainMultiCertConfigForWplusDomainCertConfig = None,
        other_config: UpdateDomainMultiCertConfigForWplusOtherConfig = None,
    ):
        # {"en":"Signature certificate info", "zh_CN":"签名证书信息"}
        self.domain_cert_config = domain_cert_config
        # {"en":"Encryption certificate info", "zh_CN":"加密证书信息"}
        self.other_config = other_config

    def validate(self):
        self.validate_required(self.domain_cert_config, 'domain_cert_config')
        if self.domain_cert_config:
            self.domain_cert_config.validate()
        self.validate_required(self.other_config, 'other_config')
        if self.other_config:
            self.other_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_cert_config is not None:
            result['domainCertConfig'] = self.domain_cert_config.to_map()
        if self.other_config is not None:
            result['otherConfig'] = self.other_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainCertConfig') is not None:
            temp_model = UpdateDomainMultiCertConfigForWplusDomainCertConfig()
            self.domain_cert_config = temp_model.from_map(m['domainCertConfig'])
        if m.get('otherConfig') is not None:
            temp_model = UpdateDomainMultiCertConfigForWplusOtherConfig()
            self.other_config = temp_model.from_map(m['otherConfig'])
        return self


class UpdateDomainMultiCertConfigForWplusResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"code", "zh_CN":"错误码，成功为0"}
        self.code = code
        # {"en":"error message", "zh_CN":"错误信息"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateDomainMultiCertConfigForWplusPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainMultiCertConfigForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainMultiCertConfigForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateDomainMultiCertConfigForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCdnwContractDomainsByCustomerRequest(TeaModel):
    def __init__(
        self,
        cnc_customer_code: str = None,
        contract_id: str = None,
        item_id: str = None,
    ):
        # {"en":"cncCustomerCode.", "zh_CN":"客户编码"}
        self.cnc_customer_code = cnc_customer_code
        # {"en":"contractId.", "zh_CN":"合同ID"}
        self.contract_id = contract_id
        # {"en":"itemId.", "zh_CN":"订单项ID"}
        self.item_id = item_id

    def validate(self):
        self.validate_required(self.cnc_customer_code, 'cnc_customer_code')
        self.validate_required(self.contract_id, 'contract_id')
        self.validate_required(self.item_id, 'item_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cnc_customer_code is not None:
            result['cnc_customer_code'] = self.cnc_customer_code
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.item_id is not None:
            result['item_id'] = self.item_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cnc_customer_code') is not None:
            self.cnc_customer_code = m.get('cnc_customer_code')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('item_id') is not None:
            self.item_id = m.get('item_id')
        return self


class QueryCdnwContractDomainsByCustomerResponseContractItems(TeaModel):
    def __init__(
        self,
        cnc_customer_code: str = None,
        contract_id: str = None,
        item_id: str = None,
        domains: List[str] = None,
    ):
        # {"en":"cncCustomerCode.", "zh_CN":"客户编码"}
        self.cnc_customer_code = cnc_customer_code
        # {"en":"contractId.", "zh_CN":"合同ID"}
        self.contract_id = contract_id
        # {"en":"itemId.", "zh_CN":"订单项ID"}
        self.item_id = item_id
        # {"en":"Domain list", "zh_CN":"域名列表"}
        self.domains = domains

    def validate(self):
        self.validate_required(self.cnc_customer_code, 'cnc_customer_code')
        self.validate_required(self.contract_id, 'contract_id')
        self.validate_required(self.item_id, 'item_id')
        self.validate_required(self.domains, 'domains')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cnc_customer_code is not None:
            result['cnc_customer_code'] = self.cnc_customer_code
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.item_id is not None:
            result['item_id'] = self.item_id
        if self.domains is not None:
            result['domains'] = self.domains
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cnc_customer_code') is not None:
            self.cnc_customer_code = m.get('cnc_customer_code')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('item_id') is not None:
            self.item_id = m.get('item_id')
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        return self


class QueryCdnwContractDomainsByCustomerResponse(TeaModel):
    def __init__(
        self,
        contract_items: List[QueryCdnwContractDomainsByCustomerResponseContractItems] = None,
    ):
        # {"en":"contract items", "zh_CN":"合同列表"}
        self.contract_items = contract_items

    def validate(self):
        self.validate_required(self.contract_items, 'contract_items')
        if self.contract_items:
            for k in self.contract_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contract_items is not None:
            result['contract_items'] = []
            for k in self.contract_items:
                result['contract_items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contract_items') is not None:
            self.contract_items = []
            for k in m.get('contract_items'):
                temp_model = QueryCdnwContractDomainsByCustomerResponseContractItems()
                self.contract_items.append(temp_model.from_map(k))
        return self


class QueryCdnwContractDomainsByCustomerPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsByCustomerParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsByCustomerRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsByCustomerResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteBanURLsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        ban_urls: List[str] = None,
        delete_all: bool = None,
    ):
        # {"en":"The domain name", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"List of urls to mask.Can contain multiple <url> nodes.<banUrls> cannot be specified as blank when it exists.When the value of the <deleteAll> node is true, the <banUrls> node and its children cannot exist.When the <deleteAll> node value is false or does not exist, the <banUrls> node and its children must exist and have a value.", "zh_CN":"要屏蔽的url列表。可包含多个<url>节点。当<banUrls>存在时，不能被指定为空白。当<deleteAll>节点值为true时，<banUrls>节点及其子节点都不能存在。当<deleteAll>节点值为false或不存在时，<banUrls>节点及其子节点必须存在，且有值。"}
        self.ban_urls = ban_urls
        # {"en":"Whether to remove all ban urls under the domain name.Optional value [true: delete all, false: do not delete all] (ignore case).Cannot be specified as blank when existing.When the value of the <deleteAll> node is true, the <banUrls> node and its children cannot exist.When the <deleteAll> node value is false or does not exist, the <banUrls> node and its children must exist and have a value.", "zh_CN":"是否删除域名下所有ban url。可选值为【true：删除所有，false：不删除所有】（忽略大小写）。当存在时，不能被指定为空白。当<deleteAll>节点值为true时，<banUrls>节点及其子节点都不能存在。当<deleteAll>节点值为false或不存在时，<banUrls>节点及其子节点必须存在，且有值。"}
        self.delete_all = delete_all

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.delete_all, 'delete_all')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.ban_urls is not None:
            result['banUrls'] = self.ban_urls
        if self.delete_all is not None:
            result['deleteAll'] = self.delete_all
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('banUrls') is not None:
            self.ban_urls = m.get('banUrls')
        if m.get('deleteAll') is not None:
            self.delete_all = m.get('deleteAll')
        return self


class DeleteBanURLsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"Error code", "zh_CN":"错误码"}
        self.code = code
        # {"en":"The message body", "zh_CN":"消息体"}
        self.message = message
        # {"en":"Returns the body of the data. The <date> returned by this interface is always empty", "zh_CN":"返回数据体，此接口返回的<date>恒为空"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class DeleteBanURLsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteBanURLsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteBanURLsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteBanURLsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditQueryStringUrlConfigRequestQueryStringSettings(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        file_types: str = None,
        custom_file_types: str = None,
        custom_pattern: str = None,
        specify_url_pattern: str = None,
        directories: str = None,
        priority: str = None,
        ignore_letter_case: str = None,
        ignore_query_string: str = None,
        query_string_kept: str = None,
        query_string_removed: str = None,
        source_with_query: str = None,
        source_key_kept: str = None,
        source_key_removed: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*\
        # 注：url匹配模式、文件类型（自定义文件类型）、常用类型、指定url、目录，有且仅有一项必填"}
        self.path_pattern = path_pattern
        # {"en":"File Type: Specify the file type for anti-theft chain settings.
        # File types include: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # If you need all types, pass all directly. Multiples are separated by semicolons, and all and specific file types cannot be configured at the same time.", "zh_CN":"文件类型：指定文件类型进行防盗链设置。可选文件类型包括：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts 如果需要全部类型，则直接传all。多个以分号隔开，all和具体文件类型不能同时配置"}
        self.file_types = file_types
        # {"en":"Custom file type: Fill in the appropriate identifiable file type according to your needs outside of the specified file type. Can be used with file-type. If the file-type is also configured, the actual file type is the sum of the two parameters.", "zh_CN":"自定义文件类型：在指定文件类型外根据自身需求，填写适当的可识别文件类型。可以搭配file-type使用。如果file-type也有配置，实际生效的文件类型是两个入参的总和"}
        self.custom_file_types = custom_file_types
        # {"en":"Specify common types: Select the domain name that requires the anti-theft chain to be all files or the home page. :
        # E.g:
        # All: all files
        # Homepage: homepage", "zh_CN":"常用类型：可选值为homepage和all
        # all：全部文件
        # homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"Specify URL cache: Specify url according to requirements for anti-theft chain setting
        # INS format does not support URI format with http(s)://", "zh_CN":"指定url，非http(s):// 开头，多个以换行分隔"}
        self.specify_url_pattern = specify_url_pattern
        # {"en":"Directory: Specify the directory for anti-theft chain settings
        # Enter a legal directory format. Multiple separated by semicolons", "zh_CN":"目录，可输入合法的目录格式。以/开头和结尾，多个以分号隔开。"}
        self.directories = directories
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"优先级，表示客户多组配置的优先执行顺序。数字越大，优先级越高。不传默认为10，不可清空。"}
        self.priority = priority
        # {"en":"Whether to ignore letter case.", "zh_CN":"是否忽略大小写：允许值为true和false，默认为忽略"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Define whether to cache with query strings, 'true' means ignore query strings, while 'false' means cache with all query strings.", "zh_CN":"缓存是否忽略查询串，允许值为true和false。
        # true表示忽略查询串，相同拷贝；false表示不忽略，分别缓存，即带全部参数缓存。"}
        self.ignore_query_string = ignore_query_string
        # {"en":"Cache with the specified query string parameters. If the kept parameter values are the same, one copy will be cached.
        # Note:
        # 1. query-string-kept and query-string-removed are mutually exclusive, and only one of them has a value.
        # 2. query-string-kept and ignore-query-string are mutually exclusive, and only one has a value.", "zh_CN":"缓存保留参数，指定保留的参数值相同，则缓存一份。
        # 注：
        # 1.query-string-kept和query-string-removed两者互斥，只能一个有值。
        # 2.query-string-kept和ignore-query-string两者互斥，只能一个有值。"}
        self.query_string_kept = query_string_kept
        # {"en":"Cache without the specified query string parameters. After deleting the specified parameter, if the other parameter values are the same, one copy will be cached.
        # 1. query-string-kept and query string removed are mutually exclusive, and only one has a value.
        # 2. query-string-removed and ignore-query-string are mutually exclusive.", "zh_CN":"缓存删除参数，删除指定的参数后，其余参数值相同，则缓存一份。
        # 1.query-string-kept和query-string-removed两者互斥，只能一个有值。
        # 2.query-string-removed和ignore-query-string两者互斥，只能一个有值。"}
        self.query_string_removed = query_string_removed
        # {"en":"Whether to use the original URL back source, the allowable values are true and false.
        # When ignore-query-string is true or not set, source-with-query is true to indicate that the source is returned according to the original request, and false to indicate that the question mark is returned.
        # When ignore-query-string is false, this default setting is empty (input is invalid)", "zh_CN":"是否用原始url回源，允许值为true和false。
        # ignore-query-string为true或未设置时，source-with-query为true表示按原始请求回源；为false表示去问号回源。
        # ignore-query-string为false时，此项默认设置为空（输入无效）。"}
        self.source_with_query = source_with_query
        # {"en":"Return to the source after specifying the reserved parameter value. Please separate them with semicolons, if no parameters reserved, please fill in:- . 1. Source-key-kept and ignore-query-string are mutually exclusive, and only one of them has a value. 2. Source-key-kept and source-key-removed are mutually exclusive, and only one of them has a value.
        # ", "zh_CN":"回源保留参数，指定保留的参数值后回源。多个请以英文分号分隔，任何参数都不保留请填：- 1、source-key-kept和ignore-query-string两者互斥，只能一个有值。 2、source-key-kept和source-key-removed两者互斥，只能一个有值。
        # "}
        self.source_key_kept = source_key_kept
        # {"en":"Return to the source after specifying the deleted parameter value. Please separate them with semicolons, and if you do not delete any parameters, please fill in:- . 1. Source-key-removed and ignore-query-string are mutually exclusive, and only one of them has a value. 2. Source-key-kept and source-key-removed are mutually exclusive, and only one of them has a value.
        # ", "zh_CN":"回源删除参数，指定删除的参数值后回源。多个请以英文分号分隔，任何参数都不删除请填：- 1、source-key-removed和ignore-query-string两者互斥，只能一个有值。 2、source-key-kept和source-key-removed两者互斥，只能一个有值。
        # "}
        self.source_key_removed = source_key_removed
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。data-id可以通过查询接口获取。 注意： a、如果有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；  b、如果入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置；  c、如果入参都没有传data-id,表示用本次的配置全量覆盖原先配置；  d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置；  e、如果一组配置没有具体的配置项，则data-id必填，且值为实际存在的data-id，表示清空这个data-id对应配置项的值；不允许一组配置没有具体的配置项也没有data-id。"}
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.file_types is not None:
            result['file-types'] = self.file_types
        if self.custom_file_types is not None:
            result['custom-file-types'] = self.custom_file_types
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.specify_url_pattern is not None:
            result['specify-url-pattern'] = self.specify_url_pattern
        if self.directories is not None:
            result[''] = self.directories
        if self.priority is not None:
            result['priority'] = self.priority
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.ignore_query_string is not None:
            result['ignore-query-string'] = self.ignore_query_string
        if self.query_string_kept is not None:
            result['query-string-kept'] = self.query_string_kept
        if self.query_string_removed is not None:
            result['query-string-removed'] = self.query_string_removed
        if self.source_with_query is not None:
            result['source-with-query'] = self.source_with_query
        if self.source_key_kept is not None:
            result['source-key-kept'] = self.source_key_kept
        if self.source_key_removed is not None:
            result['source-key-removed'] = self.source_key_removed
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('file-types') is not None:
            self.file_types = m.get('file-types')
        if m.get('custom-file-types') is not None:
            self.custom_file_types = m.get('custom-file-types')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('specify-url-pattern') is not None:
            self.specify_url_pattern = m.get('specify-url-pattern')
        if m.get('') is not None:
            self.directories = m.get('')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('ignore-query-string') is not None:
            self.ignore_query_string = m.get('ignore-query-string')
        if m.get('query-string-kept') is not None:
            self.query_string_kept = m.get('query-string-kept')
        if m.get('query-string-removed') is not None:
            self.query_string_removed = m.get('query-string-removed')
        if m.get('source-with-query') is not None:
            self.source_with_query = m.get('source-with-query')
        if m.get('source-key-kept') is not None:
            self.source_key_kept = m.get('source-key-kept')
        if m.get('source-key-removed') is not None:
            self.source_key_removed = m.get('source-key-removed')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class EditQueryStringUrlConfigRequest(TeaModel):
    def __init__(
        self,
        query_string_settings: List[EditQueryStringUrlConfigRequestQueryStringSettings] = None,
    ):
        # {"en":"Query String Settings Configuration, parent node
        # 1. When you need to configure the query string, this must be filled in.
        # 2. Configuration of clearing query string settings for <query-string-settings/>.", "zh_CN":"查询串设置配置，父标签
        # 1.需要设置查询串配置时，此项必填
        # 2.为<query-string-settings/>时清空查询串设置的配置"}
        self.query_string_settings = query_string_settings

    def validate(self):
        self.validate_required(self.query_string_settings, 'query_string_settings')
        if self.query_string_settings:
            for k in self.query_string_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.query_string_settings is not None:
            result['query-string-settings'] = []
            for k in self.query_string_settings:
                result['query-string-settings'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('query-string-settings') is not None:
            self.query_string_settings = []
            for k in m.get('query-string-settings'):
                temp_model = EditQueryStringUrlConfigRequestQueryStringSettings()
                self.query_string_settings.append(temp_model.from_map(k))
        return self


class EditQueryStringUrlConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditQueryStringUrlConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditQueryStringUrlConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditQueryStringUrlConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditQueryStringUrlConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateVariableConfigRequestVariables(TeaModel):
    def __init__(
        self,
        variable_name: str = None,
        condition_type: str = None,
        option: str = None,
        expression_1: str = None,
        expression_2: str = None,
        expression_3: str = None,
        data_id: int = None,
    ):
        # {"en":"variable name", "zh_CN":"函数变量名称"}
        self.variable_name = variable_name
        # {"en":"Function Condition Type:
        # escape_part:Encoding input string (1)
        # escape_uri:Encoding input string (2)
        # date_format:Get time format
        # base64url:base64url
        # hex_to_bin:Convert hexadecimal to binary
        # unescape:Decode input string
        # special_arg_name:Get special parameter
        # escape_arg:Encoding input string (3)
        # md5sum:md5sum
        # bin_to_hex:Convert binary to hexadecimal
        # json_get:Get the json variable
        # bool_to_int:Converts a bool to an integer
        # sha1sum:sha1sum
        # regex_capture:Regex captures function variables
        # copy:Assign a function variable
        # base64:base64", "zh_CN":"函数条件类型，可选范围：
        # escape_part:编码输入字符串（一）
        # escape_uri:编码输入字符串（二）
        # date_format:获得时间格式
        # base64url:base64url
        # hex_to_bin:将十六进制转为二进制
        # unescape:解码输入字符串
        # special_arg_name:获取特殊参数值
        # escape_arg:编码输入字符串（三）
        # md5sum:md5sum
        # bin_to_hex:将二进制转为十六进制
        # json_get:获取json变量
        # bool_to_int:将bool值转为整型
        # sha1sum:sha1sum
        # regex_capture:正则捕获函数变量
        # copy:赋值函数变量
        # base64:base64"}
        self.condition_type = condition_type
        # {"en":"option:
        # -s:copy
        # -g:Many times to replace
        # -i:Ignoring case
        # -n:Automatic matching", "zh_CN":"option选项，可选范围：
        # -s:纯拷贝
        # -g:多次替换
        # -i:忽略大小写
        # -n:自动匹配"}
        self.option = option
        # {"en":"expression_1", "zh_CN":"变量表达式1"}
        self.expression_1 = expression_1
        # {"en":"expression_2", "zh_CN":"变量表达式2"}
        self.expression_2 = expression_2
        # {"en":"expression_3", "zh_CN":"变量表达式3"}
        self.expression_3 = expression_3
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: 
        # A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. 
        # B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. 
        # C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. 
        # D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. 
        # E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", 
        #       "zh_CN":"配置多组配置时，具体某组配置的id。data-id可以通过查询接口获取。 注意： 
        # a、如果有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； 
        # b、如果入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置； 
        # c、如果入参都没有传data-id,表示用本次的配置全量覆盖原先配置； 
        # d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； 
        # e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的data-id，表示清空这个data-id对应配置项的值；不允许一组配置没有具体的配置项也没有data-id。
        # "}
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.variable_name is not None:
            result['variable-name'] = self.variable_name
        if self.condition_type is not None:
            result['condition-type'] = self.condition_type
        if self.option is not None:
            result['option'] = self.option
        if self.expression_1 is not None:
            result['expression-1'] = self.expression_1
        if self.expression_2 is not None:
            result['expression-2'] = self.expression_2
        if self.expression_3 is not None:
            result['expression-3'] = self.expression_3
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('variable-name') is not None:
            self.variable_name = m.get('variable-name')
        if m.get('condition-type') is not None:
            self.condition_type = m.get('condition-type')
        if m.get('option') is not None:
            self.option = m.get('option')
        if m.get('expression-1') is not None:
            self.expression_1 = m.get('expression-1')
        if m.get('expression-2') is not None:
            self.expression_2 = m.get('expression-2')
        if m.get('expression-3') is not None:
            self.expression_3 = m.get('expression-3')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class UpdateVariableConfigRequest(TeaModel):
    def __init__(
        self,
        variables: List[UpdateVariableConfigRequestVariables] = None,
    ):
        # {"en":"Variables configuration, parent tag
        # 1. This must be filled when the variables configuration needs to be set
        # 2. Empty the configuration for variables", "zh_CN":"变量配置，复合对象
        # 1.需要设置变量配置时，此项必填
        # 2.为时清空配置"}
        self.variables = variables

    def validate(self):
        self.validate_required(self.variables, 'variables')
        if self.variables:
            for k in self.variables:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.variables is not None:
            result['variables'] = []
            for k in self.variables:
                result['variables'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('variables') is not None:
            self.variables = []
            for k in m.get('variables'):
                temp_model = UpdateVariableConfigRequestVariables()
                self.variables.append(temp_model.from_map(k))
        return self


class UpdateVariableConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
        x_cnc_request_id: str = None,
    ):
        # {"en":"The error code", "zh_CN":"错误码"}
        self.code = code
        # {"en":"The message body", "zh_CN":"消息体"}
        self.message = message
        # {"en":"Returns the body of the data.", "zh_CN":"返回数据体。"}
        self.data = data
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        return self


class UpdateVariableConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class UpdateVariableConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateVariableConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateVariableConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateLiveDomainOriginsRequestOriginsServers(TeaModel):
    def __init__(
        self,
        address: str = None,
        priority: int = None,
        weight: int = None,
        origin_host: str = None,
    ):
        # {"en":"Address", "zh_CN":"源站地址"}
        self.address = address
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"Weight", "zh_CN":"权重"}
        self.weight = weight
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host

    def validate(self):
        self.validate_required(self.address, 'address')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['address'] = self.address
        if self.priority is not None:
            result['priority'] = self.priority
        if self.weight is not None:
            result['weight'] = self.weight
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('address') is not None:
            self.address = m.get('address')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        return self


class UpdateLiveDomainOriginsRequestOrigins(TeaModel):
    def __init__(
        self,
        servers: List[UpdateLiveDomainOriginsRequestOriginsServers] = None,
        round_robin: bool = None,
        origin_host: str = None,
    ):
        # {"en":"Servers", "zh_CN":"源站主机对象"}
        self.servers = servers
        # {"en":"Upstream Polling Enable Control", "zh_CN":"多个server默认主备"}
        self.round_robin = round_robin
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host

    def validate(self):
        self.validate_required(self.servers, 'servers')
        if self.servers:
            for k in self.servers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.servers is not None:
            result['servers'] = []
            for k in self.servers:
                result['servers'].append(k.to_map() if k else None)
        if self.round_robin is not None:
            result['roundRobin'] = self.round_robin
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('servers') is not None:
            self.servers = []
            for k in m.get('servers'):
                temp_model = UpdateLiveDomainOriginsRequestOriginsServers()
                self.servers.append(temp_model.from_map(k))
        if m.get('roundRobin') is not None:
            self.round_robin = m.get('roundRobin')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        return self


class UpdateLiveDomainOriginsRequest(TeaModel):
    def __init__(
        self,
        origin_address: str = None,
        origin_host: str = None,
        origin_protocol: str = None,
        origin_port: int = None,
        enable_https: bool = None,
        client_ip_header: str = None,
        advanced_origins: bool = None,
        origins: UpdateLiveDomainOriginsRequestOrigins = None,
    ):
        # {"en":"Origin Address", "zh_CN":"普通源"}
        self.origin_address = origin_address
        # {"en":"Origin Host", "zh_CN":"回源主机名"}
        self.origin_host = origin_host
        # {"en":"Origin Protocol", "zh_CN":"回源协议"}
        self.origin_protocol = origin_protocol
        # {"en":"Origin Port", "zh_CN":"回源端口"}
        self.origin_port = origin_port
        # {"en":"Enable Https", "zh_CN":"是否通过HTTPS回源，只支持HDL协议"}
        self.enable_https = enable_https
        # {"en":"Client IP Header", "zh_CN":"传递客户端IP头"}
        self.client_ip_header = client_ip_header
        # {"en":"Enable Advanced Origins", "zh_CN":"是否启用高级源"}
        self.advanced_origins = advanced_origins
        # {"en":"Advanced Origins", "zh_CN":"高级源"}
        self.origins = origins

    def validate(self):
        if self.origins:
            self.origins.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_address is not None:
            result['originAddress'] = self.origin_address
        if self.origin_host is not None:
            result['originHost'] = self.origin_host
        if self.origin_protocol is not None:
            result['originProtocol'] = self.origin_protocol
        if self.origin_port is not None:
            result['originPort'] = self.origin_port
        if self.enable_https is not None:
            result['enableHttps'] = self.enable_https
        if self.client_ip_header is not None:
            result['clientIpHeader'] = self.client_ip_header
        if self.advanced_origins is not None:
            result['advancedOrigins'] = self.advanced_origins
        if self.origins is not None:
            result['origins'] = self.origins.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('originAddress') is not None:
            self.origin_address = m.get('originAddress')
        if m.get('originHost') is not None:
            self.origin_host = m.get('originHost')
        if m.get('originProtocol') is not None:
            self.origin_protocol = m.get('originProtocol')
        if m.get('originPort') is not None:
            self.origin_port = m.get('originPort')
        if m.get('enableHttps') is not None:
            self.enable_https = m.get('enableHttps')
        if m.get('clientIpHeader') is not None:
            self.client_ip_header = m.get('clientIpHeader')
        if m.get('advancedOrigins') is not None:
            self.advanced_origins = m.get('advancedOrigins')
        if m.get('origins') is not None:
            temp_model = UpdateLiveDomainOriginsRequestOrigins()
            self.origins = temp_model.from_map(m['origins'])
        return self


class UpdateLiveDomainOriginsResponseData(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The preliminary deployment id", "zh_CN":"预部署id"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class UpdateLiveDomainOriginsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: UpdateLiveDomainOriginsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = UpdateLiveDomainOriginsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateLiveDomainOriginsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class UpdateLiveDomainOriginsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainOriginsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainOriginsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryVariableConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryVariableConfigResponseDataVariables(TeaModel):
    def __init__(
        self,
        variable_name: str = None,
        condition_type: str = None,
        option: str = None,
        expression_1: str = None,
        expression_2: str = None,
        expression_3: str = None,
        data_id: int = None,
    ):
        # {"en":"variable name", "zh_CN":"函数变量名称"}
        self.variable_name = variable_name
        # {"en":"Function Condition Type:
        # escape_part:Encoding input string (1)
        # escape_uri:Encoding input string (2)
        # date_format:Get time format
        # base64url:base64url
        # hex_to_bin:Convert hexadecimal to binary
        # unescape:Decode input string
        # special_arg_name:Get special parameter
        # escape_arg:Encoding input string (3)
        # md5sum:md5sum
        # bin_to_hex:Convert binary to hexadecimal
        # json_get:Get the json variable
        # bool_to_int:Converts a bool to an integer
        # sha1sum:sha1sum
        # regex_capture:Regex captures function variables
        # copy:Assign a function variable
        # base64:base64", "zh_CN":"函数条件类型，可选范围：
        # escape_part:编码输入字符串（一）
        # escape_uri:编码输入字符串（二）
        # date_format:获得时间格式
        # base64url:base64url
        # hex_to_bin:将十六进制转为二进制
        # unescape:解码输入字符串
        # special_arg_name:获取特殊参数值
        # escape_arg:编码输入字符串（三）
        # md5sum:md5sum
        # bin_to_hex:将二进制转为十六进制
        # json_get:获取json变量
        # bool_to_int:将bool值转为整型
        # sha1sum:sha1sum
        # regex_capture:正则捕获函数变量
        # copy:赋值函数变量
        # base64:base64"}
        self.condition_type = condition_type
        # {"en":"option:
        # -s:copy
        # -g:Many times to replace
        # -i:Ignoring case
        # -n:Automatic matching", "zh_CN":"option选项，可选范围：
        # -s:纯拷贝
        # -g:多次替换
        # -i:忽略大小写
        # -n:自动匹配"}
        self.option = option
        # {"en":"expression_1", "zh_CN":"变量表达式1"}
        self.expression_1 = expression_1
        # {"en":"expression_2", "zh_CN":"变量表达式2"}
        self.expression_2 = expression_2
        # {"en":"expression_3", "zh_CN":"变量表达式3"}
        self.expression_3 = expression_3
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: 
        # A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. 
        # B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. 
        # C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. 
        # D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. 
        # E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", 
        #       "zh_CN":"配置多组配置时，具体某组配置的id。data-id可以通过查询接口获取。 注意： 
        # a、如果有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； 
        # b、如果入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置； 
        # c、如果入参都没有传data-id,表示用本次的配置全量覆盖原先配置； 
        # d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； 
        # e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的data-id，表示清空这个data-id对应配置项的值；不允许一组配置没有具体的配置项也没有data-id。
        # "}
        self.data_id = data_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.variable_name is not None:
            result['variable-name'] = self.variable_name
        if self.condition_type is not None:
            result['condition-type'] = self.condition_type
        if self.option is not None:
            result['option'] = self.option
        if self.expression_1 is not None:
            result['expression-1'] = self.expression_1
        if self.expression_2 is not None:
            result['expression-2'] = self.expression_2
        if self.expression_3 is not None:
            result['expression-3'] = self.expression_3
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('variable-name') is not None:
            self.variable_name = m.get('variable-name')
        if m.get('condition-type') is not None:
            self.condition_type = m.get('condition-type')
        if m.get('option') is not None:
            self.option = m.get('option')
        if m.get('expression-1') is not None:
            self.expression_1 = m.get('expression-1')
        if m.get('expression-2') is not None:
            self.expression_2 = m.get('expression-2')
        if m.get('expression-3') is not None:
            self.expression_3 = m.get('expression-3')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class QueryVariableConfigResponseData(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        variables: List[QueryVariableConfigResponseDataVariables] = None,
    ):
        # {"en":"domain id.", "zh_CN":"域名id"}
        self.domain_id = domain_id
        # {"en":"domain name.", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"Variables configuration, parent tag
        # 1. This must be filled when the variables configuration needs to be set
        # 2. Empty the configuration for variables", "zh_CN":"变量配置，复合对象
        # 1.需要设置变量配置时，此项必填
        # 2.为时清空配置"}
        self.variables = variables

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.variables, 'variables')
        if self.variables:
            for k in self.variables:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.variables is not None:
            result['variables'] = []
            for k in self.variables:
                result['variables'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('variables') is not None:
            self.variables = []
            for k in m.get('variables'):
                temp_model = QueryVariableConfigResponseDataVariables()
                self.variables.append(temp_model.from_map(k))
        return self


class QueryVariableConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryVariableConfigResponseData = None,
        x_cnc_request_id: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 200, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"The response data", "zh_CN":"响应数据"}
        self.data = data
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryVariableConfigResponseData()
            self.data = temp_model.from_map(m['data'])
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        return self


class QueryVariableConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryVariableConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryVariableConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryVariableConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class GetBasicConfigurationOfDomainRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBasicConfigurationOfDomainResponseOriginConfigAdvOriginConfigsAdvOriginConfig(TeaModel):
    def __init__(
        self,
        master_ips: str = None,
        backup_ips: str = None,
    ):
        # {"en":"The advanced source mainly returns the source IP. Multiple IPs are separated by a semicolon \";\", and the return source IP cannot be repeated.", "zh_CN":"高级源主要回源IP，多个IP用分号“;”分隔，回源IP不能重复"}
        self.master_ips = master_ips
        # {"en":"Advanced source backup source IP, multiple IPs are separated by semicolon \";\", and the return source IP cannot be duplicated.", "zh_CN":"高级源备用回源IP，多个IP用分号“;”分隔，回源IP不能重复"}
        self.backup_ips = backup_ips

    def validate(self):
        self.validate_required(self.master_ips, 'master_ips')
        self.validate_required(self.backup_ips, 'backup_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.master_ips is not None:
            result['master-ips'] = self.master_ips
        if self.backup_ips is not None:
            result['backup-ips'] = self.backup_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('master-ips') is not None:
            self.master_ips = m.get('master-ips')
        if m.get('backup-ips') is not None:
            self.backup_ips = m.get('backup-ips')
        return self


class GetBasicConfigurationOfDomainResponseOriginConfigAdvOriginConfigs(TeaModel):
    def __init__(
        self,
        detect_url: str = None,
        detect_period: int = None,
        adv_origin_config: GetBasicConfigurationOfDomainResponseOriginConfigAdvOriginConfigsAdvOriginConfig = None,
    ):
        # {"en":"The advanced source monitors the url, and requests <master-ips> through the url. If the response is not 2**, 3** response, it is considered that the primary source ip is faulty, and <backup-ips> is used at this time.", "zh_CN":"高级源监控url，通过该url请求<master-ips>，如果返回非2**，3**响应时，认为主要回源ip故障，此时使用<backup-ips>。
        # 完整的url，例如：http://a.example.com/test.html"}
        self.detect_url = detect_url
        # {"en":"Advanced source monitoring period, in seconds, optional as an integer greater than or equal to 0, 0 means no monitoring", "zh_CN":"高级源监控周期，单位秒，可选值为大于等于0的整数，0表示不监控"}
        self.detect_period = detect_period
        # {"en":"advance origin config", "zh_CN":"高级源配置"}
        self.adv_origin_config = adv_origin_config

    def validate(self):
        self.validate_required(self.detect_url, 'detect_url')
        self.validate_required(self.detect_period, 'detect_period')
        self.validate_required(self.adv_origin_config, 'adv_origin_config')
        if self.adv_origin_config:
            self.adv_origin_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.detect_url is not None:
            result['detect-url'] = self.detect_url
        if self.detect_period is not None:
            result['detect-period'] = self.detect_period
        if self.adv_origin_config is not None:
            result['adv-origin-config'] = self.adv_origin_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('detect-url') is not None:
            self.detect_url = m.get('detect-url')
        if m.get('detect-period') is not None:
            self.detect_period = m.get('detect-period')
        if m.get('adv-origin-config') is not None:
            temp_model = GetBasicConfigurationOfDomainResponseOriginConfigAdvOriginConfigsAdvOriginConfig()
            self.adv_origin_config = temp_model.from_map(m['adv-origin-config'])
        return self


class GetBasicConfigurationOfDomainResponseOriginConfig(TeaModel):
    def __init__(
        self,
        origin_ips: str = None,
        default_origin_host_header: str = None,
        adv_origin_configs: GetBasicConfigurationOfDomainResponseOriginConfigAdvOriginConfigs = None,
    ):
        # {"en":"Return source address, which can be IP or domain name.", "zh_CN":"回源地址，可以是IP或域名。
        # 1、IP以分号分隔，支持多个。
        # 2、域名只能一个。
        # 3、限制最大不能超过500个字符长度。"}
        self.origin_ips = origin_ips
        # {"en":"Back to the source HOST, used to change the HOST field in the source HTTP request header.", "zh_CN":"回源HOST，用于更改回源HTTP请求头中的HOST字段。"}
        self.default_origin_host_header = default_origin_host_header
        # {"en":"advance origin config", "zh_CN":"高级源配置"}
        self.adv_origin_configs = adv_origin_configs

    def validate(self):
        self.validate_required(self.origin_ips, 'origin_ips')
        self.validate_required(self.default_origin_host_header, 'default_origin_host_header')
        self.validate_required(self.adv_origin_configs, 'adv_origin_configs')
        if self.adv_origin_configs:
            self.adv_origin_configs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_ips is not None:
            result['originIps'] = self.origin_ips
        if self.default_origin_host_header is not None:
            result['default-origin-host-header'] = self.default_origin_host_header
        if self.adv_origin_configs is not None:
            result['adv-origin-configs'] = self.adv_origin_configs.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('originIps') is not None:
            self.origin_ips = m.get('originIps')
        if m.get('default-origin-host-header') is not None:
            self.default_origin_host_header = m.get('default-origin-host-header')
        if m.get('adv-origin-configs') is not None:
            temp_model = GetBasicConfigurationOfDomainResponseOriginConfigAdvOriginConfigs()
            self.adv_origin_configs = temp_model.from_map(m['adv-origin-configs'])
        return self


class GetBasicConfigurationOfDomainResponseSsl(TeaModel):
    def __init__(
        self,
        use_ssl: str = None,
        use_for_sni: str = None,
        ssl_certificate_id: int = None,
    ):
        # {"en":"Use a certificate, the optional values are true and false, true means to use the certificate, false means not to use the certificate", "zh_CN":"使用证书，可选值为true和false，true表示使用证书，false表示不使用证书"}
        self.use_ssl = use_ssl
        # {"en":"Use sni certificate, the optional values are true and false, true means use sni certificate, false means use non-sni traditional certificate", "zh_CN":"使用sni证书，可选值为true和false，true表示使用sni证书，false表示使用非sni的传统证书"}
        self.use_for_sni = use_for_sni
        # {"en":"Certificate ID, the certificate ID returned by the system after the new certificate is successfully added.", "zh_CN":"证书ID，新增证书成功后，系统返回的证书ID"}
        self.ssl_certificate_id = ssl_certificate_id

    def validate(self):
        self.validate_required(self.use_ssl, 'use_ssl')
        self.validate_required(self.use_for_sni, 'use_for_sni')
        self.validate_required(self.ssl_certificate_id, 'ssl_certificate_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.use_ssl is not None:
            result['use-ssl'] = self.use_ssl
        if self.use_for_sni is not None:
            result['use-for-sni'] = self.use_for_sni
        if self.ssl_certificate_id is not None:
            result['ssl-certificate-id'] = self.ssl_certificate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('use-ssl') is not None:
            self.use_ssl = m.get('use-ssl')
        if m.get('use-for-sni') is not None:
            self.use_for_sni = m.get('use-for-sni')
        if m.get('ssl-certificate-id') is not None:
            self.ssl_certificate_id = m.get('ssl-certificate-id')
        return self


class GetBasicConfigurationOfDomainResponseLiveConfig(TeaModel):
    def __init__(
        self,
        stream_type: str = None,
        origin_ips: str = None,
        origin_push_host: str = None,
    ):
        # {"en":"The live push-pull stream type, the optional values are pull and push.", "zh_CN":"直播推拉流类型，可选值为pull和push，pull表示拉流；   push表示推流。"}
        self.stream_type = stream_type
        # {"en":"Source station IP. When the stream-type is pull, at least one of the source station IP and the companion push stream domain name is not empty.", "zh_CN":"源站IP，当stream-type为pull时，源站IP和配套推流域名至少一个不为空。
        # 1、如果是推拉流配套，则返回127.0.0.1
        # 2、如果是直接回源拉流，则返回源站IP"}
        self.origin_ips = origin_ips
        # {"en":"The corresponding push domain name, the rtmp live streaming domain name corresponding to the push domain name", "zh_CN":"配套推流域名，rtmp直播拉流域名对应的推流域名"}
        self.origin_push_host = origin_push_host

    def validate(self):
        self.validate_required(self.stream_type, 'stream_type')
        self.validate_required(self.origin_ips, 'origin_ips')
        self.validate_required(self.origin_push_host, 'origin_push_host')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.stream_type is not None:
            result['stream-type'] = self.stream_type
        if self.origin_ips is not None:
            result['origin-ips'] = self.origin_ips
        if self.origin_push_host is not None:
            result['origin-push-host'] = self.origin_push_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('stream-type') is not None:
            self.stream_type = m.get('stream-type')
        if m.get('origin-ips') is not None:
            self.origin_ips = m.get('origin-ips')
        if m.get('origin-push-host') is not None:
            self.origin_push_host = m.get('origin-push-host')
        return self


class GetBasicConfigurationOfDomainResponsePublishPoints(TeaModel):
    def __init__(
        self,
        uri: str = None,
    ):
        # {"en":"Release point, support multiple, the system default is \"/\"", "zh_CN":"发布点，支持多个，系统默认值为“/”"}
        self.uri = uri

    def validate(self):
        self.validate_required(self.uri, 'uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class GetBasicConfigurationOfDomainResponse(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        created_date: str = None,
        last_modified: str = None,
        service_type: str = None,
        comment: str = None,
        service_areas: str = None,
        cname: str = None,
        status: str = None,
        cdn_service_status: str = None,
        enabled: str = None,
        cname_label: str = None,
        origin_config: GetBasicConfigurationOfDomainResponseOriginConfig = None,
        ssl: GetBasicConfigurationOfDomainResponseSsl = None,
        cache_behaviors: dict = None,
        cache_host: str = None,
        enable_httpdns: str = None,
        header_of_clientip: str = None,
        domain_stream_type: str = None,
        live_config: GetBasicConfigurationOfDomainResponseLiveConfig = None,
        publish_points: GetBasicConfigurationOfDomainResponsePublishPoints = None,
    ):
        # {"en":"Acceleration domain ID returned by the system.", "zh_CN":"系统返回的加速域名ID"}
        self.domain_id = domain_id
        # {"en":"Accelerated domain name.", "zh_CN":"加速域名的名称"}
        self.domain_name = domain_name
        # {"en":"Domain name creation time,
        # Format: week, dd month yyyy hh:mm:ss GMT +8:00", "zh_CN":"域名创建时间，格式: week, dd month yyyy hh:mm:ss GMT +8:00
        # 如：Mon, 18 Feb 2019 02:54:19 GMT +8:00"}
        self.created_date = created_date
        # {"en":"Domain name last modified time,
        # Format: week, dd month yyyy hh:mm:ss GMT +8:00
        # Example: Mon, 18 Feb 2019 02:54:19 GMT +8 p.m", "zh_CN":"域名最近修改时间，格式: week, dd month yyyy hh:mm:ss GMT +8:00
        # 如：Mon, 18 Feb 2019 02:54:19 GMT +8:00"}
        self.last_modified = last_modified
        # {"en":"Speed up domain name service types, including the following:
        # Web/web-https: web acceleration / web acceleration - https
        # Wsa/wsa-https: Total Station Acceleration / Total Station Acceleration - https
        # Vodstream/vod-https: on-demand acceleration/on-demand acceleration-https
        # Download/dl-https: Download acceleration/download acceleration - https", "zh_CN":"加速域名的服务类型，包括如下：
        # web/web-https：网页加速/网页加速-https
        # wsa/wsa-https：全站加速/全站加速-https
        # vodstream/vod-https：点播加速/点播加速-https
        # download/dl-https：下载加速/下载加速-https"}
        self.service_type = service_type
        # {"en":"Remarks, up to 1000 characters", "zh_CN":"备注信息，最大限制1000个字符"}
        self.comment = comment
        # {"en":"Service areas of the domain name", "zh_CN":"域名的加速区域."}
        self.service_areas = service_areas
        # {"en":"CNAME of the domain you queried, for example: 7nt6mrh7sdkslj.cdn30.com.", 
        #     "zh_CN":"加速域名对应的CNAME域名，例如：7nt6mrh7sdkslj.cdn30.com。"}
        self.cname = cname
        # {"en":"The deployment status of the domain name. Deployed indicates that the domain configuration is distributed successfully. InProgress indicates that the deployment task of the domain configuration is still in progress, and may be in queue, or failed.", 
        #     "zh_CN":"加速域名的部署状态，Deployed表示该加速域名配置完成部署；InProgress表示该加速域名配置的部署任务还在进行中，可能处于排队、部署中或失败任意一种状态。"}
        self.status = status
        # {"en":"Accelerate status of the domain in our CDN, true means the CDN acceleration is normal; false means all request will back to origin directly in DNS.", "zh_CN":"加速域名的CDN服务状态，true表示启用CDN加速服务；false表示取消CDN加速服务。"}
        self.cdn_service_status = cdn_service_status
        # {"en":"Activation of the domain. It is false when the domain service is disabled, and true when the domain service is enabled.","zh_CN":"加速域名的启用状态，当禁用加速域名服务后，此项为false；当启用加速域名服务后，此项为true"}
        self.enabled = enabled
        # {"en":"Shared first level alias", "zh_CN":"共用一级别名"}
        self.cname_label = cname_label
        # {"en":"Return source policy setting, used to set the source station information and return source policy of the accelerated domain name", "zh_CN":"回源策略设置，用于设置加速域名的源站信息和回源策略"}
        self.origin_config = origin_config
        # {"en":"Ssl certificate settings, used to set the ssl certificate configuration for the accelerated domain name", "zh_CN":"ssl证书设置，用于设置加速域名的ssl证书配置"}
        self.ssl = ssl
        # {"en":"Cache rule settings for setting cache rules for accelerated domain names", "zh_CN":"查询缓存时间配置，请使用新接口：【查询缓存时间配置】接口"}
        self.cache_behaviors = cache_behaviors
        # {"en":"Cache file HOST (not return by default, application is required to use)", "zh_CN":"缓存文件HOST（默认不返回，使用需申请）
        # 缓存HOST域名和加速域名的”缓存规则”必须一致
        # 注意：该节点下的相关参数配置，除开通API调用权限外，还需要联系专属客服申请开通对应的API客户模板"}
        self.cache_host = cache_host
        # {"en":"Enable httpdns settings (not return by default, application is required to use)", "zh_CN":"启用httpdns设置（默认不返回，使用需申请）
        # 可选值为true和false，true表示启用；false表示关闭
        # 注意：该节点下的相关参数配置，除开通API调用权限外，还需要联系专属客服申请开通对应的API客户模板"}
        self.enable_httpdns = enable_httpdns
        # {"en":"Pass the response header of client IP. The optional values are Cdn-Src-Ip and X-Forwarded-For. The default value is Cdn-Src-Ip", "zh_CN":"传递客户端ip的响应头部，可选值为Cdn-Src-Ip和X-Forwarded-For，默认值为Cdn-Src-Ip"}
        self.header_of_clientip = header_of_clientip
        # {"en":"The live push-pull stream type, the optional values are pull and push, pull means pull flow; push means push flow.", "zh_CN":"直播推拉流类型，可选值为pull和push，pull表示拉流；   push表示推流。"}
        self.domain_stream_type = domain_stream_type
        # {"en":"Live domain name configuration, rtmp live acceleration domain name push-pull flow", "zh_CN":"直播域名配置，rtmp直播加速域名的推拉流"}
        self.live_config = live_config
        # {"en":"The launch point of the live push-pull domain name", "zh_CN":"直播推拉流域名的发布点
        # 注意：拉流和对应的推流域名，发布点是相同的"}
        self.publish_points = publish_points

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.created_date, 'created_date')
        self.validate_required(self.last_modified, 'last_modified')
        self.validate_required(self.service_type, 'service_type')
        self.validate_required(self.comment, 'comment')
        self.validate_required(self.service_areas, 'service_areas')
        self.validate_required(self.cname, 'cname')
        self.validate_required(self.status, 'status')
        self.validate_required(self.cdn_service_status, 'cdn_service_status')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.cname_label, 'cname_label')
        self.validate_required(self.origin_config, 'origin_config')
        if self.origin_config:
            self.origin_config.validate()
        self.validate_required(self.ssl, 'ssl')
        if self.ssl:
            self.ssl.validate()
        self.validate_required(self.cache_behaviors, 'cache_behaviors')
        self.validate_required(self.cache_host, 'cache_host')
        self.validate_required(self.enable_httpdns, 'enable_httpdns')
        self.validate_required(self.header_of_clientip, 'header_of_clientip')
        self.validate_required(self.domain_stream_type, 'domain_stream_type')
        self.validate_required(self.live_config, 'live_config')
        if self.live_config:
            self.live_config.validate()
        self.validate_required(self.publish_points, 'publish_points')
        if self.publish_points:
            self.publish_points.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.created_date is not None:
            result['created-date'] = self.created_date
        if self.last_modified is not None:
            result['last-modified'] = self.last_modified
        if self.service_type is not None:
            result['service-type'] = self.service_type
        if self.comment is not None:
            result['comment'] = self.comment
        if self.service_areas is not None:
            result['service-areas'] = self.service_areas
        if self.cname is not None:
            result['cname'] = self.cname
        if self.status is not None:
            result['status'] = self.status
        if self.cdn_service_status is not None:
            result['cdn-service-status'] = self.cdn_service_status
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.cname_label is not None:
            result['cname-label'] = self.cname_label
        if self.origin_config is not None:
            result['origin-config'] = self.origin_config.to_map()
        if self.ssl is not None:
            result['ssl'] = self.ssl.to_map()
        if self.cache_behaviors is not None:
            result['cache-behaviors'] = self.cache_behaviors
        if self.cache_host is not None:
            result['cache-host'] = self.cache_host
        if self.enable_httpdns is not None:
            result['enable-httpdns'] = self.enable_httpdns
        if self.header_of_clientip is not None:
            result['header-of-clientip'] = self.header_of_clientip
        if self.domain_stream_type is not None:
            result['domain-stream-type'] = self.domain_stream_type
        if self.live_config is not None:
            result['live-config'] = self.live_config.to_map()
        if self.publish_points is not None:
            result['publish-points'] = self.publish_points.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('created-date') is not None:
            self.created_date = m.get('created-date')
        if m.get('last-modified') is not None:
            self.last_modified = m.get('last-modified')
        if m.get('service-type') is not None:
            self.service_type = m.get('service-type')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('service-areas') is not None:
            self.service_areas = m.get('service-areas')
        if m.get('cname') is not None:
            self.cname = m.get('cname')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('cdn-service-status') is not None:
            self.cdn_service_status = m.get('cdn-service-status')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('cname-label') is not None:
            self.cname_label = m.get('cname-label')
        if m.get('origin-config') is not None:
            temp_model = GetBasicConfigurationOfDomainResponseOriginConfig()
            self.origin_config = temp_model.from_map(m['origin-config'])
        if m.get('ssl') is not None:
            temp_model = GetBasicConfigurationOfDomainResponseSsl()
            self.ssl = temp_model.from_map(m['ssl'])
        if m.get('cache-behaviors') is not None:
            self.cache_behaviors = m.get('cache-behaviors')
        if m.get('cache-host') is not None:
            self.cache_host = m.get('cache-host')
        if m.get('enable-httpdns') is not None:
            self.enable_httpdns = m.get('enable-httpdns')
        if m.get('header-of-clientip') is not None:
            self.header_of_clientip = m.get('header-of-clientip')
        if m.get('domain-stream-type') is not None:
            self.domain_stream_type = m.get('domain-stream-type')
        if m.get('live-config') is not None:
            temp_model = GetBasicConfigurationOfDomainResponseLiveConfig()
            self.live_config = temp_model.from_map(m['live-config'])
        if m.get('publish-points') is not None:
            temp_model = GetBasicConfigurationOfDomainResponsePublishPoints()
            self.publish_points = temp_model.from_map(m['publish-points'])
        return self


class GetBasicConfigurationOfDomainPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Accelerated domain name or domain ID", "zh_CN":"域名名称或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain-name'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain = m.get('domain-name')
        return self


class GetBasicConfigurationOfDomainParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBasicConfigurationOfDomainRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class GetBasicConfigurationOfDomainResponseHeader(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        x_cnc_request_id: str = None,
        x_cnc_deploy_version: str = None,
    ):
        # {"en":"Httpstatus=200 indicates that the interface is successfully invoked.", "zh_CN":"httpstatus=200;   表示成功调用接口"}
        self.http_status_code = http_status_code
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The corresponding deployment version number of this modification", "zh_CN":"本次修改对应的部署版本号"}
        self.x_cnc_deploy_version = x_cnc_deploy_version

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.x_cnc_deploy_version, 'x_cnc_deploy_version')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['http status code'] = self.http_status_code
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.x_cnc_deploy_version is not None:
            result['x-cnc-deploy-version'] = self.x_cnc_deploy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status_code = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('x-cnc-deploy-version') is not None:
            self.x_cnc_deploy_version = m.get('x-cnc-deploy-version')
        return self






class QueryGlobalTransCodingConfigForWplusRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryGlobalTransCodingConfigForWplusResponseDataTransCodeSwitch(TeaModel):
    def __init__(
        self,
        trans_code_enabled: bool = None,
        pull_domain_name: str = None,
    ):
        # {"en":"Turn on transcoding, the optional values are true and false.", "zh_CN":"开启转码，可选值为true（开启）、false（关闭）"}
        self.trans_code_enabled = trans_code_enabled
        # {"en":"Transcoding pull stream domain name, this item is required when transcoding is enabled.", "zh_CN":"转码拉流域名"}
        self.pull_domain_name = pull_domain_name

    def validate(self):
        self.validate_required(self.trans_code_enabled, 'trans_code_enabled')
        self.validate_required(self.pull_domain_name, 'pull_domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.trans_code_enabled is not None:
            result['transCodeEnabled'] = self.trans_code_enabled
        if self.pull_domain_name is not None:
            result['pullDomainName'] = self.pull_domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('transCodeEnabled') is not None:
            self.trans_code_enabled = m.get('transCodeEnabled')
        if m.get('pullDomainName') is not None:
            self.pull_domain_name = m.get('pullDomainName')
        return self


class QueryGlobalTransCodingConfigForWplusResponseData(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        trans_code_switch: QueryGlobalTransCodingConfigForWplusResponseDataTransCodeSwitch = None,
    ):
        # {"en":"domain id", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain_name = domain_name
        # {"en":"Transcode Global Configuration, parent node
        # 1. When you need to use the transcode function, this must be filled in.
        # 2. Configuration of clearing for <transCodeSwitch/>.", "zh_CN":"转码全局配置，父标签
        # 1.需要设置转码功能时，此项必填
        # 2.为<transCodeSwitch/>时清空配置"}
        self.trans_code_switch = trans_code_switch

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.trans_code_switch, 'trans_code_switch')
        if self.trans_code_switch:
            self.trans_code_switch.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.trans_code_switch is not None:
            result['transCodeSwitch'] = self.trans_code_switch.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('transCodeSwitch') is not None:
            temp_model = QueryGlobalTransCodingConfigForWplusResponseDataTransCodeSwitch()
            self.trans_code_switch = temp_model.from_map(m['transCodeSwitch'])
        return self


class QueryGlobalTransCodingConfigForWplusResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryGlobalTransCodingConfigForWplusResponseData = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryGlobalTransCodingConfigForWplusResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryGlobalTransCodingConfigForWplusPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryGlobalTransCodingConfigForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryGlobalTransCodingConfigForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryGlobalTransCodingConfigForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCdnwContractDomainsRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsResponseContractItems(TeaModel):
    def __init__(
        self,
        cnc_customer_code: str = None,
        contract_id: str = None,
        item_id: str = None,
        domains: List[str] = None,
    ):
        # {"en":"cncCustomerCode.", "zh_CN":"客户编码"}
        self.cnc_customer_code = cnc_customer_code
        # {"en":"contractId.", "zh_CN":"合同ID"}
        self.contract_id = contract_id
        # {"en":"itemId.", "zh_CN":"订单项ID"}
        self.item_id = item_id
        # {"en":"Domain list", "zh_CN":"域名列表"}
        self.domains = domains

    def validate(self):
        self.validate_required(self.cnc_customer_code, 'cnc_customer_code')
        self.validate_required(self.contract_id, 'contract_id')
        self.validate_required(self.item_id, 'item_id')
        self.validate_required(self.domains, 'domains')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cnc_customer_code is not None:
            result['cnc_customer_code'] = self.cnc_customer_code
        if self.contract_id is not None:
            result['contract_id'] = self.contract_id
        if self.item_id is not None:
            result['item_id'] = self.item_id
        if self.domains is not None:
            result['domains'] = self.domains
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cnc_customer_code') is not None:
            self.cnc_customer_code = m.get('cnc_customer_code')
        if m.get('contract_id') is not None:
            self.contract_id = m.get('contract_id')
        if m.get('item_id') is not None:
            self.item_id = m.get('item_id')
        if m.get('domains') is not None:
            self.domains = m.get('domains')
        return self


class QueryCdnwContractDomainsResponse(TeaModel):
    def __init__(
        self,
        contract_items: List[QueryCdnwContractDomainsResponseContractItems] = None,
    ):
        # {"en":"contract items", "zh_CN":"合同列表"}
        self.contract_items = contract_items

    def validate(self):
        self.validate_required(self.contract_items, 'contract_items')
        if self.contract_items:
            for k in self.contract_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contract_items is not None:
            result['contract_items'] = []
            for k in self.contract_items:
                result['contract_items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('contract_items') is not None:
            self.contract_items = []
            for k in m.get('contract_items'):
                temp_model = QueryCdnwContractDomainsResponseContractItems()
                self.contract_items.append(temp_model.from_map(k))
        return self


class QueryCdnwContractDomainsPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCdnwContractDomainsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryTOSAuthorizationConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryTOSAuthorizationConfigResponseTosAccessAuthorizationRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        except_path_pattern: str = None,
        access_key: str = None,
        access_key_id: str = None,
        header_name: str = None,
        expire_time: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The exception url matching mode.", "zh_CN":"例外的url匹配模式，格式同path-pattern"}
        self.except_path_pattern = except_path_pattern
        # {"en":"access key", "zh_CN":"校验所需的密钥"}
        self.access_key = access_key
        # {"en":"access key id", "zh_CN":"校验所需的密钥ID"}
        self.access_key_id = access_key_id
        # {"en":"Authorization header, default X-TOS-Authorization.", "zh_CN":"校验所需的头部名称，默认值为X-TOS-Authorization"}
        self.header_name = header_name
        # {"en":"The time-out window, unit seconds (s), required for verification is considered to be expired if the absolute value of the difference between client and TOS exceeds this time window due to the possible time deviation between client and TOS.", "zh_CN":"校验所需的超时时间窗口，单位秒（s），由于客户端和TOS可能存在时间偏差，两者差值的绝对值，超过这个时间窗口则视为过期。"}
        self.expire_time = expire_time
        # {"en":"When configuring multiple configurations, the ID of a specific group of configurations", "zh_CN":"配置多组配置时，具体某组配置的id"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.access_key, 'access_key')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.header_name, 'header_name')
        self.validate_required(self.expire_time, 'expire_time')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.access_key is not None:
            result['access-key'] = self.access_key
        if self.access_key_id is not None:
            result['access-key-id'] = self.access_key_id
        if self.header_name is not None:
            result['header-name'] = self.header_name
        if self.expire_time is not None:
            result['expire-time'] = self.expire_time
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('access-key') is not None:
            self.access_key = m.get('access-key')
        if m.get('access-key-id') is not None:
            self.access_key_id = m.get('access-key-id')
        if m.get('header-name') is not None:
            self.header_name = m.get('header-name')
        if m.get('expire-time') is not None:
            self.expire_time = m.get('expire-time')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class QueryTOSAuthorizationConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        tos_access_authorization_rules: List[QueryTOSAuthorizationConfigResponseTosAccessAuthorizationRules] = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        # {"en":"tos access authorization Configuration, parent node
        # 1. When you need to configure the tos access authorization rules, this must be filled in.
        # 2. Configuration of clearing for <tos-access-authorization-rules/>.", "zh_CN":"TOS回源鉴权配置，父标签
        # 1.需要设置TOS回源鉴权时，此项必填
        # 2.为<tos-access-authorization-rules/>时清空TOS回源鉴权配置的配置"}
        self.tos_access_authorization_rules = tos_access_authorization_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.tos_access_authorization_rules, 'tos_access_authorization_rules')
        if self.tos_access_authorization_rules:
            for k in self.tos_access_authorization_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.tos_access_authorization_rules is not None:
            result['tos-access-authorization-rules'] = []
            for k in self.tos_access_authorization_rules:
                result['tos-access-authorization-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('tos-access-authorization-rules') is not None:
            self.tos_access_authorization_rules = []
            for k in m.get('tos-access-authorization-rules'):
                temp_model = QueryTOSAuthorizationConfigResponseTosAccessAuthorizationRules()
                self.tos_access_authorization_rules.append(temp_model.from_map(k))
        return self


class QueryTOSAuthorizationConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryTOSAuthorizationConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryTOSAuthorizationConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryTOSAuthorizationConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QuerySingleTransCodingConfigForWplusRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QuerySingleTransCodingConfigForWplusResponseDataTransCodesCustomAudioTranscode(TeaModel):
    def __init__(
        self,
        audio_codec: str = None,
        audio_bitrate: int = None,
    ):
        # {"en":"Custom audio format, support: aac and mp4.", "zh_CN":"自定义音频格式，支持入参：aac,mp4"}
        self.audio_codec = audio_codec
        # {"en":"Custom audio bitrate, unit kbps, scope [0,257].", "zh_CN":"自定义音频码率，单位kbps，范围【0，256】"}
        self.audio_bitrate = audio_bitrate

    def validate(self):
        self.validate_required(self.audio_codec, 'audio_codec')
        self.validate_required(self.audio_bitrate, 'audio_bitrate')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audio_codec is not None:
            result['audioCodec'] = self.audio_codec
        if self.audio_bitrate is not None:
            result['audioBitrate'] = self.audio_bitrate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('audioCodec') is not None:
            self.audio_codec = m.get('audioCodec')
        if m.get('audioBitrate') is not None:
            self.audio_bitrate = m.get('audioBitrate')
        return self


class QuerySingleTransCodingConfigForWplusResponseDataTransCodes(TeaModel):
    def __init__(
        self,
        template: str = None,
        data_id: int = None,
        audio_template: str = None,
        custom_audio_transcode: QuerySingleTransCodingConfigForWplusResponseDataTransCodesCustomAudioTranscode = None,
        frame_rate: int = None,
        gop: int = None,
        height_adaptive: bool = None,
        limit_low_2high: bool = None,
        publish_points: List[str] = None,
    ):
        # {"en":"Transcoding template. Define a template. The optional values are lld, lsd, lhd, lud,  l2k, l4k. The corresponding resolution/rate are as follows.
        # 
        # lld: smooth, which means that the resolution of the original flow is 640 * 360, and the transcoding rate is 500kbps
        # lsd: standard definition, which means that the resolution of the original flow is 854 * 480, and the transcoding rate is 900kbps
        # lhd: HD, which means that the original flow is 1280 * 720 resolution, and the transcoding rate is 1500kbps
        # lud: ultra clear, which means the resolution of original flow is 1920 * 1080, and the transcoding code rate is 2000kbps
        # l2k: 2K, which means that the resolution of the original flow is 2560 * 1440, and the transcoding rate is 4000kbps
        # l4k: 4K, which means the resolution of original flow is 4096 * 2160, and the transcoding rate is 8000kbps", "zh_CN":"转码模板，定义一个模板，可选值为lld、lsd、lhd、lud、lud、l2k、l4k，对应分辨率如下
        # 1.lld:表示把原始流转为640*360 的分辨率，转码码率500kbps
        # 2.lsd:表示把原始流转为854*480 的分辨率，转码码率900kbps
        # 3.lhd:表示把原始流转为1280*720 的分辨率，转码码率1500kbps
        # 4.lud:表示把原始流转为1920*1080 的分辨率，转码码率2000kbps
        # 5.l2k:表示把原始流转为2560*1440 的分辨率，转码码率4000kbps
        # 6.l4k:表示把原始流转为4096*2160 的分辨率，转码码率8000kbps"}
        self.template = template
        # {"en":"dataId is to indicate a specific group configuration when the client has multiple groups of configurations. dataId can be retrieved through a query interface. Note: A. If dataId is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with dataId and others are not, then the expression of dataId is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of dataId. C. If the dataId is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the dataId must be filled in, and the value is the actual dataId, which means clearing the value of the corresponding dataId configuration item; it is not allowed that there is no specific configuration item or dataId in a set of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；c、如果客户入参都没有传dataId,表示用本次的配置全量覆盖原先配置；d、如果客户入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置。（c、d内容和当前方案实现一致）；e、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的dataId,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"For pure audio transcoding template, the optional values and corresponding resolution/rate are as below:
        # ao-32, audio codec AAC, bitrate 32 Kbps
        # ao-64, audio codec AAC, bitrate 64Kbps
        # ao-128, audio codec AAC, bitrate 128kbps
        # ao-257, audio codec AAC, bitrat", "zh_CN":"纯音频转码模板，音频模板可选项和对应码率如下：
        # ao-32，音频格式aac，码率32kbps
        # ao-64，音频格式aac，码率64kbps
        # ao-128  ，音频格式aac，码率128kbps
        # ao-256，音频格式aac，码率256kbps
        # mp3-32，音频格式mp3，码率32kbps
        # mp3-64，音频格式mp3，码率64kbps
        # mp3-128  ，音频格式mp3，码率128kbps
        # mp3-256，音频格式mp3，码率256kbps
        # 注意：
        # 纯音频转码模板，自定义音频转码，两者不可同时配置
        # 开启转码功能时，视频模板和纯音频模板，二者至少一个不为空"}
        self.audio_template = audio_template
        # {"en":"Custom audio transcoding, such as:
        # <customAudioTranscode><audioCodec>aac</audioCodec><audioBitrate>129</audioBitrate></customAudioTranscode>", "zh_CN":"自定义音频转码，父标签，格式如：
        # <customAudioTranscode><audioCodec>aac</audioCodec><audioBitrate>129</audioBitrate></customAudioTranscode>"}
        self.custom_audio_transcode = custom_audio_transcode
        # {"en":"Frame rate, scope [1,61].", "zh_CN":"帧率，范围【1，60】"}
        self.frame_rate = frame_rate
        # {"en":"Gop, scope [1,11].", "zh_CN":"gop，范围【1，10】"}
        self.gop = gop
        # {"en":"Enable short edge adaptation. Values: true and false. It will not be enabled by default.
        # It will not take effect if video transcoding is not enabled.", "zh_CN":"是否开启短边自适应，默认为否
        # 未开启视频转码时，该配置项无效。"}
        self.height_adaptive = height_adaptive
        # {"en":"Limit low to high. Values: true and false. The default is unlimited.", "zh_CN":"限制低转高，可选值为true、false，默认不限制"}
        self.limit_low_2high = limit_low_2high
        # {"en":"Publish points, such as:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points

    def validate(self):
        self.validate_required(self.template, 'template')
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.audio_template, 'audio_template')
        self.validate_required(self.custom_audio_transcode, 'custom_audio_transcode')
        if self.custom_audio_transcode:
            self.custom_audio_transcode.validate()
        self.validate_required(self.frame_rate, 'frame_rate')
        self.validate_required(self.gop, 'gop')
        self.validate_required(self.height_adaptive, 'height_adaptive')
        self.validate_required(self.limit_low_2high, 'limit_low_2high')
        self.validate_required(self.publish_points, 'publish_points')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.template is not None:
            result['template'] = self.template
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.audio_template is not None:
            result['audioTemplate'] = self.audio_template
        if self.custom_audio_transcode is not None:
            result['customAudioTranscode'] = self.custom_audio_transcode.to_map()
        if self.frame_rate is not None:
            result['frameRate'] = self.frame_rate
        if self.gop is not None:
            result['gop'] = self.gop
        if self.height_adaptive is not None:
            result['heightAdaptive'] = self.height_adaptive
        if self.limit_low_2high is not None:
            result['limitLow2High'] = self.limit_low_2high
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('template') is not None:
            self.template = m.get('template')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('audioTemplate') is not None:
            self.audio_template = m.get('audioTemplate')
        if m.get('customAudioTranscode') is not None:
            temp_model = QuerySingleTransCodingConfigForWplusResponseDataTransCodesCustomAudioTranscode()
            self.custom_audio_transcode = temp_model.from_map(m['customAudioTranscode'])
        if m.get('frameRate') is not None:
            self.frame_rate = m.get('frameRate')
        if m.get('gop') is not None:
            self.gop = m.get('gop')
        if m.get('heightAdaptive') is not None:
            self.height_adaptive = m.get('heightAdaptive')
        if m.get('limitLow2High') is not None:
            self.limit_low_2high = m.get('limitLow2High')
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        return self


class QuerySingleTransCodingConfigForWplusResponseData(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
        domain_name: str = None,
        trans_codes: List[QuerySingleTransCodingConfigForWplusResponseDataTransCodes] = None,
    ):
        # {"en":"domain id", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名"}
        self.domain_name = domain_name
        # {"en":"Transcode Configuration, parent node
        # 1. When you need to configure the transcode rules, this must be filled in.
        # 2. Configuration of clearing for <transCodes/>.", "zh_CN":"转码配置，父标签
        # 1.需要设置转码配置时，此项必填
        # 2.为<transCodes/>时清空配置"}
        self.trans_codes = trans_codes

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.trans_codes, 'trans_codes')
        if self.trans_codes:
            for k in self.trans_codes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.trans_codes is not None:
            result['transCodes'] = []
            for k in self.trans_codes:
                result['transCodes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('transCodes') is not None:
            self.trans_codes = []
            for k in m.get('transCodes'):
                temp_model = QuerySingleTransCodingConfigForWplusResponseDataTransCodes()
                self.trans_codes.append(temp_model.from_map(k))
        return self


class QuerySingleTransCodingConfigForWplusResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QuerySingleTransCodingConfigForWplusResponseData = None,
        x_cnc_request_id: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QuerySingleTransCodingConfigForWplusResponseData()
            self.data = temp_model.from_map(m['data'])
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        return self


class QuerySingleTransCodingConfigForWplusPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QuerySingleTransCodingConfigForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QuerySingleTransCodingConfigForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QuerySingleTransCodingConfigForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditDomainConfigRequestOriginConfig(TeaModel):
    def __init__(
        self,
        origin_ips: str = None,
        default_origin_host_header: str = None,
    ):
        # {"en":"Origin address, which can be an IP or domain name.
        # 1. Multiple IPs are supported, separated by semicolons.
        # 2. Only one domain name is allowed. IP and domain name cannot exist at the same time.
        # 3. The length cannot exceed 500 characters.
        # 4. The number of IPs cannot exceed 15.
        # ", "zh_CN":"回源地址，可以是IP或域名。
        # 1、IP以分号分隔，支持多个。
        # 2、域名只能输入一个。IP与域名不能同时输入。
        # 3、限制最大不能超过500个字符长度。
        # 4、IP最多15个。"}
        self.origin_ips = origin_ips
        # {"en":"Back-to-origin HOST, used to change the HOST field in the back-to-origin HTTP request header. The supported formats are: ① domain name ③ ip 
        # Note:
        # 1. Must comply with the ip/domain name format specification. If it is a domain name, the length of the domain name must be less than or equal to 128 characters.", "zh_CN":"回源HOST，用于更改回源HTTP请求头中的HOST字段。支持格式为: ①域名；②ip；
        # 注意：
        # 1、必须符合ip/域名格式规范。如果是域名，则域名长度小于等于128。"}
        self.default_origin_host_header = default_origin_host_header

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_ips is not None:
            result['origin-ips'] = self.origin_ips
        if self.default_origin_host_header is not None:
            result['default-origin-host-header'] = self.default_origin_host_header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('origin-ips') is not None:
            self.origin_ips = m.get('origin-ips')
        if m.get('default-origin-host-header') is not None:
            self.default_origin_host_header = m.get('default-origin-host-header')
        return self


class EditDomainConfigRequestSsl(TeaModel):
    def __init__(
        self,
        use_ssl: str = None,
        use_for_sni: str = None,
        ssl_certificate_id: int = None,
    ):
        # {"en":"Use a certificate, the optional values are true and false, true means to use the certificate, false means not to use the certificate", "zh_CN":"使用证书，可选值为true和false，true表示使用证书，false表示不使用证书"}
        self.use_ssl = use_ssl
        # {"en":"Use sni certificate, the optional values are true and false, true means use sni certificate, false means use shared certificate (not supported)", "zh_CN":"使用sni证书，可选值为true和false，true表示使用sni证书，false表示使用合用证书（暂不支持）"}
        self.use_for_sni = use_for_sni
        # {"en":"Use sni certificate, the optional values are true and false, true means use sni certificate, false means use shared certificate (not supported)", "zh_CN":"证书ID，新增证书成功后，系统返回的证书ID
        # use-ssl为true时，才能传ssl-certificate-id。"}
        self.ssl_certificate_id = ssl_certificate_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.use_ssl is not None:
            result['use-ssl'] = self.use_ssl
        if self.use_for_sni is not None:
            result['use-for-sni'] = self.use_for_sni
        if self.ssl_certificate_id is not None:
            result['ssl-certificate-id'] = self.ssl_certificate_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('use-ssl') is not None:
            self.use_ssl = m.get('use-ssl')
        if m.get('use-for-sni') is not None:
            self.use_for_sni = m.get('use-for-sni')
        if m.get('ssl-certificate-id') is not None:
            self.ssl_certificate_id = m.get('ssl-certificate-id')
        return self


class EditDomainConfigRequestLiveConfig(TeaModel):
    def __init__(
        self,
        live_config_origin_ips: str = None,
        origin_push_host: str = None,
    ):
        # {"en":"Source station IP. When the stream-type is pull, at least one of the source station IP and the companion push stream domain name is not empty.
        # 1. If it is a push-pull flow package, fill in 127.0.0.1, and the system will also default to 127.0.0.1.
        # 2. If it is directly returning to the source, fill in the source IP of the source pull stream.
        # ", "zh_CN":"源站IP，当stream-type为pull时，源站IP和配套推流域名至少一个不为空。
        # 1、如果是推拉流配套，则填写127.0.0.1，不传系统也默认为127.0.0.1
        # 2、如果是直接回源拉流，则填写回源拉流的源站IP"}
        self.live_config_origin_ips = live_config_origin_ips
        # {"en":"A matching push domain name is used to set up a current domain name corresponding to the live streaming domain name. When the stream-type is pull, the source station IP and the supporting current domain name are at least one empty; when stream-type is push, it does not need to be introduced.", "zh_CN":"配套推流域名，用于设置直播拉流域名对应的推流域名，当stream-type为pull时，源站IP和配套推流域名至少一个不为空；当stream-type为push时，无需传入。"}
        self.origin_push_host = origin_push_host

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.live_config_origin_ips is not None:
            result['origin-ips'] = self.live_config_origin_ips
        if self.origin_push_host is not None:
            result['origin-push-host'] = self.origin_push_host
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('origin-ips') is not None:
            self.live_config_origin_ips = m.get('origin-ips')
        if m.get('origin-push-host') is not None:
            self.origin_push_host = m.get('origin-push-host')
        return self


class EditDomainConfigRequestPublishPoints(TeaModel):
    def __init__(
        self,
        uri: str = None,
    ):
        # {"en":"Livestream domain settings. Publish point, support multiple, do not pass the system by default to generate a publishing point uri for [/]", "zh_CN":"发布点，支持多个，不传系统默认生成一条发布点uri为“/”"}
        self.uri = uri

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uri is not None:
            result['uri'] = self.uri
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('uri') is not None:
            self.uri = m.get('uri')
        return self


class EditDomainConfigRequest(TeaModel):
    def __init__(
        self,
        version: str = None,
        comment: str = None,
        service_areas: str = None,
        cname_label: str = None,
        origin_config: EditDomainConfigRequestOriginConfig = None,
        ssl: EditDomainConfigRequestSsl = None,
        cache_host: str = None,
        enable_httpdns: str = None,
        header_of_clientip: str = None,
        live_config: EditDomainConfigRequestLiveConfig = None,
        publish_points: List[EditDomainConfigRequestPublishPoints] = None,
    ):
        # {"en":"Version, the current version is 1.0.0", "zh_CN":"版本号，当前版本号1.0.0"}
        self.version = version
        # {"en":"Remarks, up to 1000 characters.", "zh_CN":"备注信息，最大限制1000个字符"}
        self.comment = comment
        # {"en":"The acceleration area of the acceleration domain, if the resource coverage needs to be limited according to the area, the acceleration area needs to be specified. When no acceleration area is specified, we will provide acceleration services with optimal resource coverage according to the service area opened by the customer. Multiple regions are separated by semicolons, and the supported regions are as follows: cn (Mainland China), am (Americas), emea (Europe, Middle East, Africa), apac (Asia-Pacific region).", 
        #     "zh_CN":"加速域名的加速区域，如果有需要根据区域限定资源覆盖时，才需要指定加速区域。未指定加速区域时，我们将按照客户开通的服务区域，以最优的资源覆盖提供加速服务。多个区域以分号分隔，支持配置的区域如下：cn（中国大陆）、am（美洲）、emea（欧洲、中东、非洲）、apac（亚太地区）"}
        self.service_areas = service_areas
        # {"en":"If you need to share a CNAME between domains, you can use this parameter. This parameter is a unique label for a public CNAME. Domains with the same cname-label will have the same CNAME. 
        # Note:
        # 1. Domains with the same cname-label have the same coverage.
        # 2. Constraints of sharing a CNAME: consistent service-type, consistent certificate-id (if there is a certificate), consistent service-areas
        # 3. Multiple http domains can share a CNAME, multiple sni https domains can share a CNAME too.
        # 4. When a cname-label is used by a single domain, then the domain can be canceled acceleration. While a cname-label using by more then one domains, they can not be canceled acceleration.
        # 5. Support the purpose of modifying cname by modifying cname-label. )", 
        # "zh_CN":"共用一级标签，若有多个加速域名需要共用一级域名，则可以使用该参数。即拥有相同cname-label的一组域名，共用一级cname。
        # 注意：
        # 1、拥有相同cname-label的域名共用一级cname，且有完全一致的dns覆盖
        # 2、共用一级的约束：加速类型一致(service-type)、证书id一致（certificate-id,如果有证书）、加速区域一致(service-areas)
        # 3、多个http域名可共用一级，多个sni https域名可共用一级
        # 4、单个域名使用cname-label时，域名可cancel；多个域名共用一级时，不允许cancel这些域名
        # 5、支持通过修改cname-label达到修改cname的目的。"}
        self.cname_label = cname_label
        # {"en":"Back to origin policy settings for setting source site information and return source policies for accelerated domain names", "zh_CN":"回源策略设置，用于设置加速域名的源站信息和回源策略"}
        self.origin_config = origin_config
        # {"en":"SSL settings, to bind a certificate with the accelerated domain. You can use the interface [AddCertificate] to upload your  certificates. If you want to modify a certificate, please use the interface: [UpdateCertificate]", "zh_CN":"ssl证书设置，用于设置加速域名的ssl证书配置。上传证书请使用接口：【新增证书V2】；若要修改证书，请使用接口：【修改证书V2】"}
        self.ssl = ssl
        # {"en":"Cache file HOST.
        # Cache rules for caching HOST domain names and accelerated domain names must be consistent.", "zh_CN":"缓存文件HOST。缓存HOST域名和加速域名的缓存规则必须一致。"}
        self.cache_host = cache_host
        # {"en":"Enable httpdns settings.
        # The optional values are true and false, true means enabled; false means off. This function is not enabled by default. If you need it, please contact the technical support to apply for this feature.", "zh_CN":"启用httpdns设置（使用需申请）
        # 可选值为true和false，true表示启用；false表示关闭
        # 注意：该功能默认不开启，若您有需要，请联系专属客服申请开通。"}
        self.enable_httpdns = enable_httpdns
        # {"en":"Pass the response header of client IP. The optional values are Cdn-Src-Ip and X-Forwarded-For. The default value is Cdn-Src-Ip.", "zh_CN":"传递客户端ip的响应头部，可选值为Cdn-Src-Ip和X-Forwarded-For，默认值为Cdn-Src-Ip"}
        self.header_of_clientip = header_of_clientip
        # {"en":"Live domain name configuration, used to set the push flow of live acceleration domain name", "zh_CN":"直播域名配置，用于设置直播加速域名的推拉流"}
        self.live_config = live_config
        # {"en":"Set the publishing point of the live push-pull domain.
        # Note:
        # 1. The pull stream and the corresponding push stream domain must be configured with the same publishing point.
        # 2. If you are not going to modify the publishing point, please do not pass this param.
        # 3. The publishing point adopts the overlay update. Each time you modify, you need to submit all the publishing points. You cannot submit only the parts that need to be modified.", "zh_CN":"设置直播推拉流域名的发布点
        # 注意：
        # 1、拉流和对应的推流域名，必须配置相同的发布点；
        # 2、不想修改发布点时，不要传入该节点及以下入参；
        # 3、发布点采用覆盖式更新，每次修改时，需要提交全部发布点，不能仅提交需要修改的部分。"}
        self.publish_points = publish_points

    def validate(self):
        if self.origin_config:
            self.origin_config.validate()
        if self.ssl:
            self.ssl.validate()
        if self.live_config:
            self.live_config.validate()
        if self.publish_points:
            for k in self.publish_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.version is not None:
            result['version'] = self.version
        if self.comment is not None:
            result['comment'] = self.comment
        if self.service_areas is not None:
            result['service-areas'] = self.service_areas
        if self.cname_label is not None:
            result['cname-label'] = self.cname_label
        if self.origin_config is not None:
            result['origin-config'] = self.origin_config.to_map()
        if self.ssl is not None:
            result['ssl'] = self.ssl.to_map()
        if self.cache_host is not None:
            result['cache-host'] = self.cache_host
        if self.enable_httpdns is not None:
            result['enable-httpdns'] = self.enable_httpdns
        if self.header_of_clientip is not None:
            result['header-of-clientip'] = self.header_of_clientip
        if self.live_config is not None:
            result['live-config'] = self.live_config.to_map()
        if self.publish_points is not None:
            result['publish-points'] = []
            for k in self.publish_points:
                result['publish-points'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('version') is not None:
            self.version = m.get('version')
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('service-areas') is not None:
            self.service_areas = m.get('service-areas')
        if m.get('cname-label') is not None:
            self.cname_label = m.get('cname-label')
        if m.get('origin-config') is not None:
            temp_model = EditDomainConfigRequestOriginConfig()
            self.origin_config = temp_model.from_map(m['origin-config'])
        if m.get('ssl') is not None:
            temp_model = EditDomainConfigRequestSsl()
            self.ssl = temp_model.from_map(m['ssl'])
        if m.get('cache-host') is not None:
            self.cache_host = m.get('cache-host')
        if m.get('enable-httpdns') is not None:
            self.enable_httpdns = m.get('enable-httpdns')
        if m.get('header-of-clientip') is not None:
            self.header_of_clientip = m.get('header-of-clientip')
        if m.get('live-config') is not None:
            temp_model = EditDomainConfigRequestLiveConfig()
            self.live_config = temp_model.from_map(m['live-config'])
        if m.get('publish-points') is not None:
            self.publish_points = []
            for k in m.get('publish-points'):
                temp_model = EditDomainConfigRequestPublishPoints()
                self.publish_points.append(temp_model.from_map(k))
        return self


class EditDomainConfigResponse(TeaModel):
    def __init__(
        self,
        http_status_code: int = None,
        x_cnc_request_id: str = None,
        x_cnc_deploy_version: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"If httpstatus=202, the interface is successfully invoked. You can use the x-cnc-request-id in the header to check the deployment of domain.", "zh_CN":"httpstatus=202;   表示成功调用接口，可使用header中的x-cnc-request-id查看域名的部署情况"}
        self.http_status_code = http_status_code
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The corresponding deployment version number of this modification", "zh_CN":"本次修改对应的部署版本号"}
        self.x_cnc_deploy_version = x_cnc_deploy_version
        # {"en":"Error code, which appears when HTTPStatus is not 202, represents the error type of the current request call", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status_code, 'http_status_code')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.x_cnc_deploy_version, 'x_cnc_deploy_version')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status_code is not None:
            result['http status code'] = self.http_status_code
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.x_cnc_deploy_version is not None:
            result['x-cnc-deploy-version'] = self.x_cnc_deploy_version
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status_code = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('x-cnc-deploy-version') is not None:
            self.x_cnc_deploy_version = m.get('x-cnc-deploy-version')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditDomainConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain you are going to modify, it can be domain id or domain name.", "zh_CN":"需要修改的域名，可以是域名名称或域名id。"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class EditDomainConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditDomainConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditDomainConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainAccessCtrlsRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainAccessCtrlsResponseDataIpFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        ips: List[str] = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"IP List", "zh_CN":"IP或IP段"}
        self.ips = ips

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.type, 'type')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainAccessCtrlsPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class QueryLiveDomainAccessCtrlsResponseDataRefererFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        referer_regex: str = None,
        referer_url: str = None,
        referer_domain: str = None,
        allow_empty_referer: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"Referer Regex", "zh_CN":"Referer正则"}
        self.referer_regex = referer_regex
        # {"en":"Referer URL", "zh_CN":"Referer URL"}
        self.referer_url = referer_url
        # {"en":"Referer Domain", "zh_CN":"Referer 域名"}
        self.referer_domain = referer_domain
        # {"en":"Allow Empty Referer", "zh_CN":"是否允许空referer"}
        self.allow_empty_referer = allow_empty_referer

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.type, 'type')
        self.validate_required(self.referer_regex, 'referer_regex')
        self.validate_required(self.referer_url, 'referer_url')
        self.validate_required(self.referer_domain, 'referer_domain')
        self.validate_required(self.allow_empty_referer, 'allow_empty_referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.referer_regex is not None:
            result['refererRegex'] = self.referer_regex
        if self.referer_url is not None:
            result['refererUrl'] = self.referer_url
        if self.referer_domain is not None:
            result['refererDomain'] = self.referer_domain
        if self.allow_empty_referer is not None:
            result['allowEmptyReferer'] = self.allow_empty_referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainAccessCtrlsPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('refererRegex') is not None:
            self.referer_regex = m.get('refererRegex')
        if m.get('refererUrl') is not None:
            self.referer_url = m.get('refererUrl')
        if m.get('refererDomain') is not None:
            self.referer_domain = m.get('refererDomain')
        if m.get('allowEmptyReferer') is not None:
            self.allow_empty_referer = m.get('allowEmptyReferer')
        return self


class QueryLiveDomainAccessCtrlsResponseDataUaFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        ua_regex: List[str] = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"UA Regex", "zh_CN":"客户端UA，支持正则"}
        self.ua_regex = ua_regex

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.type, 'type')
        self.validate_required(self.ua_regex, 'ua_regex')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.ua_regex is not None:
            result['uaRegex'] = self.ua_regex
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainAccessCtrlsPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('uaRegex') is not None:
            self.ua_regex = m.get('uaRegex')
        return self


class QueryLiveDomainAccessCtrlsResponseDataUrlAuths(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        sign_keys: List[str] = None,
        time_format: str = None,
        cipher_combination: str = None,
        sign_aglo: str = None,
        time_arg: str = None,
        secret_arg: str = None,
        period: int = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Sign Keys", "zh_CN":"加密串key"}
        self.sign_keys = sign_keys
        # {"en":"Time Format, Enum[1, 2]", "zh_CN":"Unix时间戳格式，可选值[1, 2]"}
        self.time_format = time_format
        # {"en":"Cipher Combination, Enum[1,2,3,4,5,6]", "zh_CN":"密码组合，可选值[1, 2, 3, 4, 5, 6]"}
        self.cipher_combination = cipher_combination
        # {"en":"Sign Aglo", "zh_CN":"加密算法"}
        self.sign_aglo = sign_aglo
        # {"en":"Time Arg", "zh_CN":"时间串的参数名"}
        self.time_arg = time_arg
        # {"en":"Secret Arg", "zh_CN":"防盗链串的参数名称"}
        self.secret_arg = secret_arg
        # {"en":"Period", "zh_CN":"相对时间有效期，单位秒"}
        self.period = period

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.sign_keys, 'sign_keys')
        self.validate_required(self.time_format, 'time_format')
        self.validate_required(self.cipher_combination, 'cipher_combination')
        self.validate_required(self.sign_aglo, 'sign_aglo')
        self.validate_required(self.time_arg, 'time_arg')
        self.validate_required(self.secret_arg, 'secret_arg')
        self.validate_required(self.period, 'period')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.sign_keys is not None:
            result['signKeys'] = self.sign_keys
        if self.time_format is not None:
            result['timeFormat'] = self.time_format
        if self.cipher_combination is not None:
            result['cipherCombination'] = self.cipher_combination
        if self.sign_aglo is not None:
            result['signAglo'] = self.sign_aglo
        if self.time_arg is not None:
            result['timeArg'] = self.time_arg
        if self.secret_arg is not None:
            result['secretArg'] = self.secret_arg
        if self.period is not None:
            result['period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainAccessCtrlsPaths')
        if m.get('signKeys') is not None:
            self.sign_keys = m.get('signKeys')
        if m.get('timeFormat') is not None:
            self.time_format = m.get('timeFormat')
        if m.get('cipherCombination') is not None:
            self.cipher_combination = m.get('cipherCombination')
        if m.get('signAglo') is not None:
            self.sign_aglo = m.get('signAglo')
        if m.get('timeArg') is not None:
            self.time_arg = m.get('timeArg')
        if m.get('secretArg') is not None:
            self.secret_arg = m.get('secretArg')
        if m.get('period') is not None:
            self.period = m.get('period')
        return self


class QueryLiveDomainAccessCtrlsResponseDataRemoteAuthsAuthArgs(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en":"Arg Name", "zh_CN":"参数名称"}
        self.name = name
        # {"en":"Arg Value", "zh_CN":"参数值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class QueryLiveDomainAccessCtrlsResponseDataRemoteAuthsAuthResult(TeaModel):
    def __init__(
        self,
        success_codes: List[str] = None,
        failed_codes: List[str] = None,
        success_body: str = None,
        failed_body: str = None,
    ):
        # {"en":"Auth Result Success Codes", "zh_CN":"鉴权成功响应状态码"}
        self.success_codes = success_codes
        # {"en":"Auth Result Failed Codes", "zh_CN":"鉴权失败响应状态码"}
        self.failed_codes = failed_codes
        # {"en":"Auth Result Success Body", "zh_CN":"鉴权成功响应body"}
        self.success_body = success_body
        # {"en":"Auth Result Failed Body", "zh_CN":"鉴权失败响应body"}
        self.failed_body = failed_body

    def validate(self):
        self.validate_required(self.success_codes, 'success_codes')
        self.validate_required(self.failed_codes, 'failed_codes')
        self.validate_required(self.success_body, 'success_body')
        self.validate_required(self.failed_body, 'failed_body')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_codes is not None:
            result['successCodes'] = self.success_codes
        if self.failed_codes is not None:
            result['failedCodes'] = self.failed_codes
        if self.success_body is not None:
            result['successBody'] = self.success_body
        if self.failed_body is not None:
            result['failedBody'] = self.failed_body
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('successCodes') is not None:
            self.success_codes = m.get('successCodes')
        if m.get('failedCodes') is not None:
            self.failed_codes = m.get('failedCodes')
        if m.get('successBody') is not None:
            self.success_body = m.get('successBody')
        if m.get('failedBody') is not None:
            self.failed_body = m.get('failedBody')
        return self


class QueryLiveDomainAccessCtrlsResponseDataRemoteAuths(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        enabled: bool = None,
        auth_address: str = None,
        auth_host: str = None,
        auth_uri: str = None,
        auth_args: List[QueryLiveDomainAccessCtrlsResponseDataRemoteAuthsAuthArgs] = None,
        auth_method: str = None,
        auth_use_https: bool = None,
        auth_result: QueryLiveDomainAccessCtrlsResponseDataRemoteAuthsAuthResult = None,
        auth_timeout: int = None,
        retry_times: int = None,
        timeout_action: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Enabled", "zh_CN":"是否启用回源鉴权"}
        self.enabled = enabled
        # {"en":"Auth Address", "zh_CN":"鉴权地址，支持IP或域名"}
        self.auth_address = auth_address
        # {"en":"Auth Host", "zh_CN":"鉴权主机名"}
        self.auth_host = auth_host
        # {"en":"Auth URI", "zh_CN":"回源鉴权URI"}
        self.auth_uri = auth_uri
        # {"en":"Auth Args", "zh_CN":"回源鉴权请求参数"}
        self.auth_args = auth_args
        # {"en":"Auth Method, Enum [GET, POST]", "zh_CN":"回源鉴权请求方法，可选值[GET, POST]"}
        self.auth_method = auth_method
        # {"en":"Auth Use Https", "zh_CN":"回源鉴权是否启用HTTPS"}
        self.auth_use_https = auth_use_https
        # {"en":"Auth Result", "zh_CN":"鉴权结果判定，成功或失败的标识"}
        self.auth_result = auth_result
        # {"en":"Auth Timeout, [1, 10]", "zh_CN":"鉴权超时时间，[1, 10]"}
        self.auth_timeout = auth_timeout
        # {"en":"Auth Timeout, [0, 30]", "zh_CN":"鉴权重试次数，[0, 30]"}
        self.retry_times = retry_times
        # {"en":"Timeout Action, Enum [allow, deny]", "zh_CN":"超时动作，可选值[allow, deny]"}
        self.timeout_action = timeout_action

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.enabled, 'enabled')
        self.validate_required(self.auth_address, 'auth_address')
        self.validate_required(self.auth_host, 'auth_host')
        self.validate_required(self.auth_uri, 'auth_uri')
        self.validate_required(self.auth_args, 'auth_args')
        if self.auth_args:
            for k in self.auth_args:
                if k:
                    k.validate()
        self.validate_required(self.auth_method, 'auth_method')
        self.validate_required(self.auth_use_https, 'auth_use_https')
        self.validate_required(self.auth_result, 'auth_result')
        if self.auth_result:
            self.auth_result.validate()
        self.validate_required(self.auth_timeout, 'auth_timeout')
        self.validate_required(self.retry_times, 'retry_times')
        self.validate_required(self.timeout_action, 'timeout_action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.auth_address is not None:
            result['authAddress'] = self.auth_address
        if self.auth_host is not None:
            result['authHost'] = self.auth_host
        if self.auth_uri is not None:
            result['authUri'] = self.auth_uri
        if self.auth_args is not None:
            result['authArgs'] = []
            for k in self.auth_args:
                result['authArgs'].append(k.to_map() if k else None)
        if self.auth_method is not None:
            result['authMethod'] = self.auth_method
        if self.auth_use_https is not None:
            result['authUseHttps'] = self.auth_use_https
        if self.auth_result is not None:
            result['authResult'] = self.auth_result.to_map()
        if self.auth_timeout is not None:
            result['authTimeout'] = self.auth_timeout
        if self.retry_times is not None:
            result['retryTimes'] = self.retry_times
        if self.timeout_action is not None:
            result['timeoutAction'] = self.timeout_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('authAddress') is not None:
            self.auth_address = m.get('authAddress')
        if m.get('authHost') is not None:
            self.auth_host = m.get('authHost')
        if m.get('authUri') is not None:
            self.auth_uri = m.get('authUri')
        if m.get('authArgs') is not None:
            self.auth_args = []
            for k in m.get('authArgs'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataRemoteAuthsAuthArgs()
                self.auth_args.append(temp_model.from_map(k))
        if m.get('authMethod') is not None:
            self.auth_method = m.get('authMethod')
        if m.get('authUseHttps') is not None:
            self.auth_use_https = m.get('authUseHttps')
        if m.get('authResult') is not None:
            temp_model = QueryLiveDomainAccessCtrlsResponseDataRemoteAuthsAuthResult()
            self.auth_result = temp_model.from_map(m['authResult'])
        if m.get('authTimeout') is not None:
            self.auth_timeout = m.get('authTimeout')
        if m.get('retryTimes') is not None:
            self.retry_times = m.get('retryTimes')
        if m.get('timeoutAction') is not None:
            self.timeout_action = m.get('timeoutAction')
        return self


class QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersIpFilter(TeaModel):
    def __init__(
        self,
        type: str = None,
        ips: List[str] = None,
    ):
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"IP List", "zh_CN":"IP或IP段"}
        self.ips = ips

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersUaFilter(TeaModel):
    def __init__(
        self,
        type: str = None,
        ua_regex: List[str] = None,
    ):
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"UA Regex", "zh_CN":"客户端UA，支持正则"}
        self.ua_regex = ua_regex

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.ua_regex, 'ua_regex')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.ua_regex is not None:
            result['uaRegex'] = self.ua_regex
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('uaRegex') is not None:
            self.ua_regex = m.get('uaRegex')
        return self


class QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersRefererFilter(TeaModel):
    def __init__(
        self,
        type: str = None,
        referer_regex: str = None,
        referer_url: str = None,
        referer_domain: str = None,
        allow_empty_referer: bool = None,
    ):
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"Referer Regex", "zh_CN":"Referer正则"}
        self.referer_regex = referer_regex
        # {"en":"Referer URL", "zh_CN":"Referer URL"}
        self.referer_url = referer_url
        # {"en":"Referer Domain", "zh_CN":"Referer 域名"}
        self.referer_domain = referer_domain
        # {"en":"Allow Empty Referer", "zh_CN":"是否允许空referer"}
        self.allow_empty_referer = allow_empty_referer

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.referer_regex, 'referer_regex')
        self.validate_required(self.referer_url, 'referer_url')
        self.validate_required(self.referer_domain, 'referer_domain')
        self.validate_required(self.allow_empty_referer, 'allow_empty_referer')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['type'] = self.type
        if self.referer_regex is not None:
            result['refererRegex'] = self.referer_regex
        if self.referer_url is not None:
            result['refererUrl'] = self.referer_url
        if self.referer_domain is not None:
            result['refererDomain'] = self.referer_domain
        if self.allow_empty_referer is not None:
            result['allowEmptyReferer'] = self.allow_empty_referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('refererRegex') is not None:
            self.referer_regex = m.get('refererRegex')
        if m.get('refererUrl') is not None:
            self.referer_url = m.get('refererUrl')
        if m.get('refererDomain') is not None:
            self.referer_domain = m.get('refererDomain')
        if m.get('allowEmptyReferer') is not None:
            self.allow_empty_referer = m.get('allowEmptyReferer')
        return self


class QueryLiveDomainAccessCtrlsResponseDataCombinedFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url: str = None,
        url_regex: str = None,
        exclude_url_regex: str = None,
        file_types: List[str] = None,
        exclude_file_types: List[str] = None,
        file_paths: List[str] = None,
        exclude_file_paths: List[str] = None,
        ip_filter: QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersIpFilter = None,
        ua_filter: QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersUaFilter = None,
        referer_filter: QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersRefererFilter = None,
        action: str = None,
        redirect_url: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL", "zh_CN":"指定URL，非正则"}
        self.url = url
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"Exclude URL Regex", "zh_CN":"URL正则取反"}
        self.exclude_url_regex = exclude_url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"Exclude File Types", "zh_CN":"文件类型取反"}
        self.exclude_file_types = exclude_file_types
        # {"en":"File QueryLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Exclude File QueryLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录取反"}
        self.exclude_file_paths = exclude_file_paths
        # {"en":"IP Filter", "zh_CN":"IP黑白名单"}
        self.ip_filter = ip_filter
        # {"en":"UA Filter", "zh_CN":"UA黑白名单"}
        self.ua_filter = ua_filter
        # {"en":"Referer Filter", "zh_CN":"referer黑白名单"}
        self.referer_filter = referer_filter
        # {"en":"Control Action", "zh_CN":"控制动作"}
        self.action = action
        # {"en":"Redirect URL", "zh_CN":"跳转到URL"}
        self.redirect_url = redirect_url

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.url, 'url')
        self.validate_required(self.url_regex, 'url_regex')
        self.validate_required(self.exclude_url_regex, 'exclude_url_regex')
        self.validate_required(self.file_types, 'file_types')
        self.validate_required(self.exclude_file_types, 'exclude_file_types')
        self.validate_required(self.file_paths, 'file_paths')
        self.validate_required(self.exclude_file_paths, 'exclude_file_paths')
        self.validate_required(self.ip_filter, 'ip_filter')
        if self.ip_filter:
            self.ip_filter.validate()
        self.validate_required(self.ua_filter, 'ua_filter')
        if self.ua_filter:
            self.ua_filter.validate()
        self.validate_required(self.referer_filter, 'referer_filter')
        if self.referer_filter:
            self.referer_filter.validate()
        self.validate_required(self.action, 'action')
        self.validate_required(self.redirect_url, 'redirect_url')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url is not None:
            result['url'] = self.url
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.exclude_url_regex is not None:
            result['excludeUrlRegex'] = self.exclude_url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.exclude_file_types is not None:
            result['excludeFileTypes'] = self.exclude_file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.exclude_file_paths is not None:
            result['excludeFileQueryLiveDomainAccessCtrlsPaths'] = self.exclude_file_paths
        if self.ip_filter is not None:
            result['ipFilter'] = self.ip_filter.to_map()
        if self.ua_filter is not None:
            result['uaFilter'] = self.ua_filter.to_map()
        if self.referer_filter is not None:
            result['refererFilter'] = self.referer_filter.to_map()
        if self.action is not None:
            result['action'] = self.action
        if self.redirect_url is not None:
            result['redirectUrl'] = self.redirect_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('url') is not None:
            self.url = m.get('url')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('excludeUrlRegex') is not None:
            self.exclude_url_regex = m.get('excludeUrlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('excludeFileTypes') is not None:
            self.exclude_file_types = m.get('excludeFileTypes')
        if m.get('fileQueryLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainAccessCtrlsPaths')
        if m.get('excludeFileQueryLiveDomainAccessCtrlsPaths') is not None:
            self.exclude_file_paths = m.get('excludeFileQueryLiveDomainAccessCtrlsPaths')
        if m.get('ipFilter') is not None:
            temp_model = QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersIpFilter()
            self.ip_filter = temp_model.from_map(m['ipFilter'])
        if m.get('uaFilter') is not None:
            temp_model = QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersUaFilter()
            self.ua_filter = temp_model.from_map(m['uaFilter'])
        if m.get('refererFilter') is not None:
            temp_model = QueryLiveDomainAccessCtrlsResponseDataCombinedFiltersRefererFilter()
            self.referer_filter = temp_model.from_map(m['refererFilter'])
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('redirectUrl') is not None:
            self.redirect_url = m.get('redirectUrl')
        return self


class QueryLiveDomainAccessCtrlsResponseData(TeaModel):
    def __init__(
        self,
        ip_filters: List[QueryLiveDomainAccessCtrlsResponseDataIpFilters] = None,
        referer_filters: List[QueryLiveDomainAccessCtrlsResponseDataRefererFilters] = None,
        ua_filters: List[QueryLiveDomainAccessCtrlsResponseDataUaFilters] = None,
        url_auths: List[QueryLiveDomainAccessCtrlsResponseDataUrlAuths] = None,
        remote_auths: List[QueryLiveDomainAccessCtrlsResponseDataRemoteAuths] = None,
        combined_filters: List[QueryLiveDomainAccessCtrlsResponseDataCombinedFilters] = None,
    ):
        # {"en":"IP Filters", "zh_CN":"IP访问控制"}
        self.ip_filters = ip_filters
        # {"en":"Referer Filters", "zh_CN":"Refferer访问控制"}
        self.referer_filters = referer_filters
        # {"en":"UA Filters", "zh_CN":"UA访问控制"}
        self.ua_filters = ua_filters
        # {"en":"URL Auths", "zh_CN":"URL Auths"}
        self.url_auths = url_auths
        # {"en":"Remote Auths", "zh_CN":"Remote Auths"}
        self.remote_auths = remote_auths
        # {"en":"Combined Filters", "zh_CN":"访问控制组合"}
        self.combined_filters = combined_filters

    def validate(self):
        self.validate_required(self.ip_filters, 'ip_filters')
        if self.ip_filters:
            for k in self.ip_filters:
                if k:
                    k.validate()
        self.validate_required(self.referer_filters, 'referer_filters')
        if self.referer_filters:
            for k in self.referer_filters:
                if k:
                    k.validate()
        self.validate_required(self.ua_filters, 'ua_filters')
        if self.ua_filters:
            for k in self.ua_filters:
                if k:
                    k.validate()
        self.validate_required(self.url_auths, 'url_auths')
        if self.url_auths:
            for k in self.url_auths:
                if k:
                    k.validate()
        self.validate_required(self.remote_auths, 'remote_auths')
        if self.remote_auths:
            for k in self.remote_auths:
                if k:
                    k.validate()
        self.validate_required(self.combined_filters, 'combined_filters')
        if self.combined_filters:
            for k in self.combined_filters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_filters is not None:
            result['ipFilters'] = []
            for k in self.ip_filters:
                result['ipFilters'].append(k.to_map() if k else None)
        if self.referer_filters is not None:
            result['refererFilters'] = []
            for k in self.referer_filters:
                result['refererFilters'].append(k.to_map() if k else None)
        if self.ua_filters is not None:
            result['uaFilters'] = []
            for k in self.ua_filters:
                result['uaFilters'].append(k.to_map() if k else None)
        if self.url_auths is not None:
            result['urlAuths'] = []
            for k in self.url_auths:
                result['urlAuths'].append(k.to_map() if k else None)
        if self.remote_auths is not None:
            result['remoteAuths'] = []
            for k in self.remote_auths:
                result['remoteAuths'].append(k.to_map() if k else None)
        if self.combined_filters is not None:
            result['combinedFilters'] = []
            for k in self.combined_filters:
                result['combinedFilters'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipFilters') is not None:
            self.ip_filters = []
            for k in m.get('ipFilters'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataIpFilters()
                self.ip_filters.append(temp_model.from_map(k))
        if m.get('refererFilters') is not None:
            self.referer_filters = []
            for k in m.get('refererFilters'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataRefererFilters()
                self.referer_filters.append(temp_model.from_map(k))
        if m.get('uaFilters') is not None:
            self.ua_filters = []
            for k in m.get('uaFilters'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataUaFilters()
                self.ua_filters.append(temp_model.from_map(k))
        if m.get('urlAuths') is not None:
            self.url_auths = []
            for k in m.get('urlAuths'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataUrlAuths()
                self.url_auths.append(temp_model.from_map(k))
        if m.get('remoteAuths') is not None:
            self.remote_auths = []
            for k in m.get('remoteAuths'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataRemoteAuths()
                self.remote_auths.append(temp_model.from_map(k))
        if m.get('combinedFilters') is not None:
            self.combined_filters = []
            for k in m.get('combinedFilters'):
                temp_model = QueryLiveDomainAccessCtrlsResponseDataCombinedFilters()
                self.combined_filters.append(temp_model.from_map(k))
        return self


class QueryLiveDomainAccessCtrlsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainAccessCtrlsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainAccessCtrlsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainAccessCtrlsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainAccessCtrlsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainAccessCtrlsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainAccessCtrlsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateLiveDomainAccessCtrlsRequestIpFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        ips: List[str] = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"IP List", "zh_CN":"IP或IP段"}
        self.ips = ips

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.ips, 'ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.ips is not None:
            result['ips'] = self.ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainAccessCtrlsPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        return self


class UpdateLiveDomainAccessCtrlsRequestRefererFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        referer_regex: str = None,
        referer_url: str = None,
        referer_domain: str = None,
        allow_empty_referer: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"Referer Regex", "zh_CN":"Referer正则"}
        self.referer_regex = referer_regex
        # {"en":"Referer URL", "zh_CN":"Referer URL"}
        self.referer_url = referer_url
        # {"en":"Referer Domain", "zh_CN":"Referer 域名"}
        self.referer_domain = referer_domain
        # {"en":"Allow Empty Referer", "zh_CN":"是否允许空referer"}
        self.allow_empty_referer = allow_empty_referer

    def validate(self):
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.referer_regex is not None:
            result['refererRegex'] = self.referer_regex
        if self.referer_url is not None:
            result['refererUrl'] = self.referer_url
        if self.referer_domain is not None:
            result['refererDomain'] = self.referer_domain
        if self.allow_empty_referer is not None:
            result['allowEmptyReferer'] = self.allow_empty_referer
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainAccessCtrlsPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('refererRegex') is not None:
            self.referer_regex = m.get('refererRegex')
        if m.get('refererUrl') is not None:
            self.referer_url = m.get('refererUrl')
        if m.get('refererDomain') is not None:
            self.referer_domain = m.get('refererDomain')
        if m.get('allowEmptyReferer') is not None:
            self.allow_empty_referer = m.get('allowEmptyReferer')
        return self


class UpdateLiveDomainAccessCtrlsRequestUaFilters(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        type: str = None,
        ua_regex: List[str] = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Blacklist or Whitelist, Enum[blacklist, whitelist]", "zh_CN":"黑名单或白名单，可选值[blacklist, whitelist]"}
        self.type = type
        # {"en":"UA Regex", "zh_CN":"客户端UA，支持正则"}
        self.ua_regex = ua_regex

    def validate(self):
        self.validate_required(self.type, 'type')
        self.validate_required(self.ua_regex, 'ua_regex')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.type is not None:
            result['type'] = self.type
        if self.ua_regex is not None:
            result['uaRegex'] = self.ua_regex
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainAccessCtrlsPaths')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('uaRegex') is not None:
            self.ua_regex = m.get('uaRegex')
        return self


class UpdateLiveDomainAccessCtrlsRequestUrlAuths(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        sign_keys: List[str] = None,
        time_format: str = None,
        cipher_combination: str = None,
        time_arg: str = None,
        secret_arg: str = None,
        period: int = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainAccessCtrlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Sign Keys", "zh_CN":"加密串key"}
        self.sign_keys = sign_keys
        # {"en":"Time Format, Enum[1, 2]", "zh_CN":"Unix时间戳格式，可选值[1, 2]"}
        self.time_format = time_format
        # {"en":"Cipher Combination, Enum[1,2,3,4,5,6]", "zh_CN":"密码组合，可选值[1, 2, 3, 4, 5, 6]"}
        self.cipher_combination = cipher_combination
        # {"en":"Time Arg", "zh_CN":"时间串的参数名"}
        self.time_arg = time_arg
        # {"en":"Secret Arg", "zh_CN":"防盗链串的参数名称"}
        self.secret_arg = secret_arg
        # {"en":"Period", "zh_CN":"相对时间有效期，单位秒"}
        self.period = period

    def validate(self):
        self.validate_required(self.sign_keys, 'sign_keys')
        self.validate_required(self.cipher_combination, 'cipher_combination')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainAccessCtrlsPaths'] = self.file_paths
        if self.sign_keys is not None:
            result['signKeys'] = self.sign_keys
        if self.time_format is not None:
            result['timeFormat'] = self.time_format
        if self.cipher_combination is not None:
            result['cipherCombination'] = self.cipher_combination
        if self.time_arg is not None:
            result['timeArg'] = self.time_arg
        if self.secret_arg is not None:
            result['secretArg'] = self.secret_arg
        if self.period is not None:
            result['period'] = self.period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainAccessCtrlsPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainAccessCtrlsPaths')
        if m.get('signKeys') is not None:
            self.sign_keys = m.get('signKeys')
        if m.get('timeFormat') is not None:
            self.time_format = m.get('timeFormat')
        if m.get('cipherCombination') is not None:
            self.cipher_combination = m.get('cipherCombination')
        if m.get('timeArg') is not None:
            self.time_arg = m.get('timeArg')
        if m.get('secretArg') is not None:
            self.secret_arg = m.get('secretArg')
        if m.get('period') is not None:
            self.period = m.get('period')
        return self


class UpdateLiveDomainAccessCtrlsRequestRemoteAuthsAuthArgs(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en":"Arg Name", "zh_CN":"参数名称"}
        self.name = name
        # {"en":"Arg Value", "zh_CN":"参数值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateLiveDomainAccessCtrlsRequestRemoteAuthsAuthResult(TeaModel):
    def __init__(
        self,
        success_codes: List[str] = None,
        failed_codes: List[str] = None,
        success_body: str = None,
        failed_body: str = None,
    ):
        # {"en":"Auth Result Success Codes", "zh_CN":"鉴权成功响应状态码"}
        self.success_codes = success_codes
        # {"en":"Auth Result Failed Codes", "zh_CN":"鉴权失败响应状态码"}
        self.failed_codes = failed_codes
        # {"en":"Auth Result Success Body", "zh_CN":"鉴权成功响应body"}
        self.success_body = success_body
        # {"en":"Auth Result Failed Body", "zh_CN":"鉴权失败响应body"}
        self.failed_body = failed_body

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_codes is not None:
            result['successCodes'] = self.success_codes
        if self.failed_codes is not None:
            result['failedCodes'] = self.failed_codes
        if self.success_body is not None:
            result['successBody'] = self.success_body
        if self.failed_body is not None:
            result['failedBody'] = self.failed_body
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('successCodes') is not None:
            self.success_codes = m.get('successCodes')
        if m.get('failedCodes') is not None:
            self.failed_codes = m.get('failedCodes')
        if m.get('successBody') is not None:
            self.success_body = m.get('successBody')
        if m.get('failedBody') is not None:
            self.failed_body = m.get('failedBody')
        return self


class UpdateLiveDomainAccessCtrlsRequestRemoteAuths(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        enabled: bool = None,
        auth_address: str = None,
        auth_host: str = None,
        auth_uri: str = None,
        auth_args: List[UpdateLiveDomainAccessCtrlsRequestRemoteAuthsAuthArgs] = None,
        auth_method: str = None,
        auth_use_https: bool = None,
        auth_result: UpdateLiveDomainAccessCtrlsRequestRemoteAuthsAuthResult = None,
        auth_timeout: int = None,
        retry_times: int = None,
        timeout_action: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Enabled", "zh_CN":"是否启用回源鉴权"}
        self.enabled = enabled
        # {"en":"Auth Address", "zh_CN":"鉴权地址，支持IP或域名"}
        self.auth_address = auth_address
        # {"en":"Auth Host", "zh_CN":"鉴权主机名"}
        self.auth_host = auth_host
        # {"en":"Auth URI", "zh_CN":"回源鉴权URI"}
        self.auth_uri = auth_uri
        # {"en":"Auth Args", "zh_CN":"回源鉴权请求参数"}
        self.auth_args = auth_args
        # {"en":"Auth Method, Enum [GET, POST]", "zh_CN":"回源鉴权请求方法，可选值[GET, POST]"}
        self.auth_method = auth_method
        # {"en":"Auth Use Https", "zh_CN":"回源鉴权是否启用HTTPS"}
        self.auth_use_https = auth_use_https
        # {"en":"Auth Result", "zh_CN":"鉴权结果判定，成功或失败的标识"}
        self.auth_result = auth_result
        # {"en":"Auth Timeout, [1, 10]", "zh_CN":"鉴权超时时间，[1, 10]"}
        self.auth_timeout = auth_timeout
        # {"en":"Auth Timeout, [0, 30]", "zh_CN":"鉴权重试次数，[0, 30]"}
        self.retry_times = retry_times
        # {"en":"Timeout Action, Enum [allow, deny]", "zh_CN":"超时动作，可选值[allow, deny]"}
        self.timeout_action = timeout_action

    def validate(self):
        self.validate_required(self.auth_address, 'auth_address')
        self.validate_required(self.auth_uri, 'auth_uri')
        self.validate_required(self.auth_args, 'auth_args')
        if self.auth_args:
            for k in self.auth_args:
                if k:
                    k.validate()
        self.validate_required(self.auth_result, 'auth_result')
        if self.auth_result:
            self.auth_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.enabled is not None:
            result['enabled'] = self.enabled
        if self.auth_address is not None:
            result['authAddress'] = self.auth_address
        if self.auth_host is not None:
            result['authHost'] = self.auth_host
        if self.auth_uri is not None:
            result['authUri'] = self.auth_uri
        if self.auth_args is not None:
            result['authArgs'] = []
            for k in self.auth_args:
                result['authArgs'].append(k.to_map() if k else None)
        if self.auth_method is not None:
            result['authMethod'] = self.auth_method
        if self.auth_use_https is not None:
            result['authUseHttps'] = self.auth_use_https
        if self.auth_result is not None:
            result['authResult'] = self.auth_result.to_map()
        if self.auth_timeout is not None:
            result['authTimeout'] = self.auth_timeout
        if self.retry_times is not None:
            result['retryTimes'] = self.retry_times
        if self.timeout_action is not None:
            result['timeoutAction'] = self.timeout_action
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('enabled') is not None:
            self.enabled = m.get('enabled')
        if m.get('authAddress') is not None:
            self.auth_address = m.get('authAddress')
        if m.get('authHost') is not None:
            self.auth_host = m.get('authHost')
        if m.get('authUri') is not None:
            self.auth_uri = m.get('authUri')
        if m.get('authArgs') is not None:
            self.auth_args = []
            for k in m.get('authArgs'):
                temp_model = UpdateLiveDomainAccessCtrlsRequestRemoteAuthsAuthArgs()
                self.auth_args.append(temp_model.from_map(k))
        if m.get('authMethod') is not None:
            self.auth_method = m.get('authMethod')
        if m.get('authUseHttps') is not None:
            self.auth_use_https = m.get('authUseHttps')
        if m.get('authResult') is not None:
            temp_model = UpdateLiveDomainAccessCtrlsRequestRemoteAuthsAuthResult()
            self.auth_result = temp_model.from_map(m['authResult'])
        if m.get('authTimeout') is not None:
            self.auth_timeout = m.get('authTimeout')
        if m.get('retryTimes') is not None:
            self.retry_times = m.get('retryTimes')
        if m.get('timeoutAction') is not None:
            self.timeout_action = m.get('timeoutAction')
        return self


class UpdateLiveDomainAccessCtrlsRequest(TeaModel):
    def __init__(
        self,
        ip_filters: List[UpdateLiveDomainAccessCtrlsRequestIpFilters] = None,
        referer_filters: List[UpdateLiveDomainAccessCtrlsRequestRefererFilters] = None,
        ua_filters: List[UpdateLiveDomainAccessCtrlsRequestUaFilters] = None,
        url_auths: List[UpdateLiveDomainAccessCtrlsRequestUrlAuths] = None,
        remote_auths: List[UpdateLiveDomainAccessCtrlsRequestRemoteAuths] = None,
    ):
        # {"en":"IP Filters", "zh_CN":"IP访问控制"}
        self.ip_filters = ip_filters
        # {"en":"Referer Filters", "zh_CN":"Refferer访问控制"}
        self.referer_filters = referer_filters
        # {"en":"UA Filters", "zh_CN":"UA访问控制"}
        self.ua_filters = ua_filters
        # {"en":"URL Auths", "zh_CN":"URL Auths"}
        self.url_auths = url_auths
        # {"en":"Remote Auths", "zh_CN":"Remote Auths"}
        self.remote_auths = remote_auths

    def validate(self):
        if self.ip_filters:
            for k in self.ip_filters:
                if k:
                    k.validate()
        if self.referer_filters:
            for k in self.referer_filters:
                if k:
                    k.validate()
        if self.ua_filters:
            for k in self.ua_filters:
                if k:
                    k.validate()
        if self.url_auths:
            for k in self.url_auths:
                if k:
                    k.validate()
        if self.remote_auths:
            for k in self.remote_auths:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip_filters is not None:
            result['ipFilters'] = []
            for k in self.ip_filters:
                result['ipFilters'].append(k.to_map() if k else None)
        if self.referer_filters is not None:
            result['refererFilters'] = []
            for k in self.referer_filters:
                result['refererFilters'].append(k.to_map() if k else None)
        if self.ua_filters is not None:
            result['uaFilters'] = []
            for k in self.ua_filters:
                result['uaFilters'].append(k.to_map() if k else None)
        if self.url_auths is not None:
            result['urlAuths'] = []
            for k in self.url_auths:
                result['urlAuths'].append(k.to_map() if k else None)
        if self.remote_auths is not None:
            result['remoteAuths'] = []
            for k in self.remote_auths:
                result['remoteAuths'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ipFilters') is not None:
            self.ip_filters = []
            for k in m.get('ipFilters'):
                temp_model = UpdateLiveDomainAccessCtrlsRequestIpFilters()
                self.ip_filters.append(temp_model.from_map(k))
        if m.get('refererFilters') is not None:
            self.referer_filters = []
            for k in m.get('refererFilters'):
                temp_model = UpdateLiveDomainAccessCtrlsRequestRefererFilters()
                self.referer_filters.append(temp_model.from_map(k))
        if m.get('uaFilters') is not None:
            self.ua_filters = []
            for k in m.get('uaFilters'):
                temp_model = UpdateLiveDomainAccessCtrlsRequestUaFilters()
                self.ua_filters.append(temp_model.from_map(k))
        if m.get('urlAuths') is not None:
            self.url_auths = []
            for k in m.get('urlAuths'):
                temp_model = UpdateLiveDomainAccessCtrlsRequestUrlAuths()
                self.url_auths.append(temp_model.from_map(k))
        if m.get('remoteAuths') is not None:
            self.remote_auths = []
            for k in m.get('remoteAuths'):
                temp_model = UpdateLiveDomainAccessCtrlsRequestRemoteAuths()
                self.remote_auths.append(temp_model.from_map(k))
        return self


class UpdateLiveDomainAccessCtrlsResponseData(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The preliminary deployment id", "zh_CN":"预部署id"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class UpdateLiveDomainAccessCtrlsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: UpdateLiveDomainAccessCtrlsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = UpdateLiveDomainAccessCtrlsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateLiveDomainAccessCtrlsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class UpdateLiveDomainAccessCtrlsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainAccessCtrlsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainAccessCtrlsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryInnerRedirectRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryInnerRedirectResponseRewriteRuleSettings(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        path_pattern: str = None,
        except_path_pattern: str = None,
        custom_pattern: str = None,
        directory: str = None,
        file_type: str = None,
        ignore_letter_case: str = None,
        publish_type: str = None,
        priority: int = None,
        before_value: str = None,
        after_value: str = None,
        rewrite_type: str = None,
        request_header: str = None,
        exception_request_header: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置；data-id重复，已入参同个id最后一组为准生效"}
        self.data_id = data_id
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则,  .*：匹配所有文件
        # 客户入参参考：.*\
        # 对于匹配到的URL进行内容重定向"}
        self.path_pattern = path_pattern
        # {"en":"Exceptional url matching mode, except for certain URLs: such as abc.jpg, no content redirection
        # Customer reference: ^https?://[^/]+/.*\.m3u8", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做内容重定向
        # 客户入参参考：^https?://[^/]+/.*\.m3u8"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Matching conditions: specify common types, optional values are all or homepage 1. all: all files 2. homepage: home page", "zh_CN":"匹配条件：指定常用类型，可选值为all或homepage 1、all：全部文件 2、homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"directory", "zh_CN":"目录"}
        self.directory = directory
        # {"en":"gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts", "zh_CN":"匹配条件：文件类型，多个请以英文;分隔，可选值：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts"}
        self.file_type = file_type
        # {"en":"Ignore case, the optional value is true or false, true means to ignore case; false means not to ignore case;
        # When adding a new configuration item, the default is not true.
        # If the client passes a null value: such as <ignore-letter-case></ignore-letter-case>, the configuration is cleared.", "zh_CN":"忽略大小写，可选值为true或false，true表示忽略大小写；false表示不忽略大小写；
        # 新增配置项时，不传默认为 true
        # 如果客户传了空值：如<ignore-letter-case></ignore-letter-case>，则表示清空配置"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Rewrite the location where the content is generated. The input value is: Cache indicates the node;
        # Other input formats are not supported at this time", "zh_CN":"改写内容的生成位置。可输入值为：Cache表示节点；
        # 暂不支持其他入参格式"}
        self.publish_type = publish_type
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"表示客户多组重定向内容的优先执行顺序。数字越大，优先级越高。
        # 新增配置项时，不传默认为 10"}
        self.priority = priority
        # {"en":"Configuration item: old url
        # Indicates the protocol mode before rewriting (that is, the object that needs to be rewritten), such as: ^https://([^/]+/.*)", "zh_CN":"配置项：旧url
        # 表示改写前的协议方式（即需要改写的对象），如：^https://([^/]+/.*)"}
        self.before_value = before_value
        # {"en":"Configuration item: new url
        # Indicates the protocol method after rewriting, such as: http://$1", "zh_CN":"配置项：新url
        # 表示改写后的协议方式，如：http://$1"}
        self.after_value = after_value
        # {"en":"Redirection type; support for input:
        # before: before the anti-theft chain
        # after: after the anti-theft chain", "zh_CN":"重定向类型；支持入参：
        # before：防盗链之前
        # after：防盗链之后"}
        self.rewrite_type = rewrite_type
        # {"en":"Matching condition: Request header", "zh_CN":"匹配条件：请求头"}
        self.request_header = request_header
        # {"en":"Matching condition: Exception request header", "zh_CN":"匹配条件：例外的请求头"}
        self.exception_request_header = exception_request_header

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.custom_pattern, 'custom_pattern')
        self.validate_required(self.directory, 'directory')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.ignore_letter_case, 'ignore_letter_case')
        self.validate_required(self.publish_type, 'publish_type')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.before_value, 'before_value')
        self.validate_required(self.after_value, 'after_value')
        self.validate_required(self.rewrite_type, 'rewrite_type')
        self.validate_required(self.request_header, 'request_header')
        self.validate_required(self.exception_request_header, 'exception_request_header')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.directory is not None:
            result['directory'] = self.directory
        if self.file_type is not None:
            result['file-type'] = self.file_type
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.publish_type is not None:
            result['publish-type'] = self.publish_type
        if self.priority is not None:
            result['priority'] = self.priority
        if self.before_value is not None:
            result['before-value'] = self.before_value
        if self.after_value is not None:
            result['after-value'] = self.after_value
        if self.rewrite_type is not None:
            result['rewrite-type'] = self.rewrite_type
        if self.request_header is not None:
            result['request-header'] = self.request_header
        if self.exception_request_header is not None:
            result['exception-request-header'] = self.exception_request_header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('file-type') is not None:
            self.file_type = m.get('file-type')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('publish-type') is not None:
            self.publish_type = m.get('publish-type')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('before-value') is not None:
            self.before_value = m.get('before-value')
        if m.get('after-value') is not None:
            self.after_value = m.get('after-value')
        if m.get('rewrite-type') is not None:
            self.rewrite_type = m.get('rewrite-type')
        if m.get('request-header') is not None:
            self.request_header = m.get('request-header')
        if m.get('exception-request-header') is not None:
            self.exception_request_header = m.get('exception-request-header')
        return self


class QueryInnerRedirectResponse(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        rewrite_rule_settings: List[QueryInnerRedirectResponseRewriteRuleSettings] = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名id"}
        self.domain_id = domain_id
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名"}
        self.domain_name = domain_name
        self.rewrite_rule_settings = rewrite_rule_settings

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.rewrite_rule_settings, 'rewrite_rule_settings')
        if self.rewrite_rule_settings:
            for k in self.rewrite_rule_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.rewrite_rule_settings is not None:
            result['rewrite-rule-settings'] = []
            for k in self.rewrite_rule_settings:
                result['rewrite-rule-settings'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('rewrite-rule-settings') is not None:
            self.rewrite_rule_settings = []
            for k in m.get('rewrite-rule-settings'):
                temp_model = QueryInnerRedirectResponseRewriteRuleSettings()
                self.rewrite_rule_settings.append(temp_model.from_map(k))
        return self


class QueryInnerRedirectPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryInnerRedirectParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryInnerRedirectRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryInnerRedirectResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditDomainRedirectConfigRequestRewriteRuleSettings(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        path_pattern: str = None,
        custom_pattern: str = None,
        directory: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        except_path_pattern: str = None,
        ignore_letter_case: str = None,
        publish_type: str = None,
        priority: str = None,
        before_value: str = None,
        after_value: str = None,
        rewrite_type: str = None,
        request_header: str = None,
        exception_request_header: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置；data-id重复，以入参同个id最后一组为准生效
        # data-id可以通过查询接口获取。
        # 注意：添加grid类型标识：data-id，每一组配置对应一个data-id：
        # a、如果客户有传data-id，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传data-id，有些没有传，则有传data-id的表示修改具体某组配置，没有传data-id的表示在原来基础上新增一组配置；
        # c、如果客户入参都没有传data-id,表示用本次的配置全量覆盖原先配置；
        # d、如果客户入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置。（c、d内容和当前方案实现一致）；
        # e、一个gird标签下的入参不能为空，如果，没有具体的配置项，则data-id必填，且值为实际存在的data-id,表示清空这个data-id对应配置项的值；"}
        self.data_id = data_id
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则，客户入参参考：.*\
        # 对于匹配到的URL进行内容重定向"}
        self.path_pattern = path_pattern
        # {"en":"Matching conditions: specify common types, optional values are all or homepage 1. all: all files 2. homepage: home page", "zh_CN":"匹配条件：指定常用类型，可选值为all或homepage 1. all：全部文件 2. homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"directory", "zh_CN":"目录"}
        self.directory = directory
        # {"en":"gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts", "zh_CN":"匹配条件：文件类型，多个请以英文;分隔，可选值：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf m3u8 xml f4m bootstarp ts"}
        self.file_type = file_type
        # {"en":"Matching condition: Custom file type, please separate them by semicolon.", "zh_CN":"匹配条件：自定义文件类型，多个请以英文;分隔。"}
        self.custom_file_type = custom_file_type
        # {"en":"Exceptional url matching mode, except for certain URLs: such as abc.jpg, no content redirection
        # Customer reference: ^https?://[^/]+/.*\.m3u8", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做内容重定向
        # 客户入参参考：^https?://[^/]+/.*\.m3u8"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Ignore case, the optional value is true or false, true means to ignore case; false means not to ignore case;
        # When adding a new configuration item, the default is not true.
        # If the client passes a null value: such as <ignore-letter-case></ignore-letter-case>, the configuration is cleared.", "zh_CN":"忽略大小写，可选值为true或false，true表示忽略大小写；false表示不忽略大小写；
        # 新增配置项时，不传默认为 true
        # 如果客户传了空值：如<ignore-letter-case></ignore-letter-case>，则表示清空配置"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Rewrite the location where the content is generated. The input value is: Cache indicates the node;
        # Other input formats are not supported at this time", "zh_CN":"改写内容的生成位置。可输入值为：Cache表示节点；
        # 暂不支持其他入参格式"}
        self.publish_type = publish_type
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"表示客户多组重定向内容的优先执行顺序。数字越大，优先级越高。
        # 新增配置项时，不传默认为 10"}
        self.priority = priority
        # {"en":"Configuration item: old url
        # Indicates the protocol mode before rewriting (that is, the object that needs to be rewritten), such as: ^https://([^/]+/.*)", "zh_CN":"配置项：旧url
        # 表示改写前的协议方式（即需要改写的对象），如：^https://([^/]+/.*)
        # 如果是回源协议改写，则表示客户请求的原始url，配套的参数after-value，表示客户请求需要转换的回源请求。"}
        self.before_value = before_value
        # {"en":"Configuration item: new url
        # Indicates the protocol method after rewriting, such as: http://$1", "zh_CN":"配置项：新url
        # 表示改写后的协议方式，如：http://$1
        # 如果请求重定向带状态码则参考入参：301:https://$1
        # 注：如果url含域名，则域名需要是本身。"}
        self.after_value = after_value
        # {"en":"Redirection type; support for input:
        # before: before the anti-theft chain
        # after: after the anti-theft chain", "zh_CN":"重定向类型；支持入参：
        # before：防盗链之前
        # after：防盗链之后"}
        self.rewrite_type = rewrite_type
        # {"en":"Matching condition: Request header", "zh_CN":"匹配条件：请求头"}
        self.request_header = request_header
        # {"en":"Matching condition: Exception request header", "zh_CN":"匹配条件：例外的请求头"}
        self.exception_request_header = exception_request_header

    def validate(self):
        self.validate_required(self.publish_type, 'publish_type')
        self.validate_required(self.before_value, 'before_value')
        self.validate_required(self.after_value, 'after_value')
        self.validate_required(self.rewrite_type, 'rewrite_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.directory is not None:
            result['directory'] = self.directory
        if self.file_type is not None:
            result['file-type'] = self.file_type
        if self.custom_file_type is not None:
            result['custom-file-type'] = self.custom_file_type
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.publish_type is not None:
            result['publish-type'] = self.publish_type
        if self.priority is not None:
            result['priority'] = self.priority
        if self.before_value is not None:
            result['before-value'] = self.before_value
        if self.after_value is not None:
            result['after-value'] = self.after_value
        if self.rewrite_type is not None:
            result['rewrite-type'] = self.rewrite_type
        if self.request_header is not None:
            result['request-header'] = self.request_header
        if self.exception_request_header is not None:
            result['exception-request-header'] = self.exception_request_header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('file-type') is not None:
            self.file_type = m.get('file-type')
        if m.get('custom-file-type') is not None:
            self.custom_file_type = m.get('custom-file-type')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('publish-type') is not None:
            self.publish_type = m.get('publish-type')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('before-value') is not None:
            self.before_value = m.get('before-value')
        if m.get('after-value') is not None:
            self.after_value = m.get('after-value')
        if m.get('rewrite-type') is not None:
            self.rewrite_type = m.get('rewrite-type')
        if m.get('request-header') is not None:
            self.request_header = m.get('request-header')
        if m.get('exception-request-header') is not None:
            self.exception_request_header = m.get('exception-request-header')
        return self


class EditDomainRedirectConfigRequest(TeaModel):
    def __init__(
        self,
        rewrite_rule_settings: List[EditDomainRedirectConfigRequestRewriteRuleSettings] = None,
    ):
        # {"en":"redirection function
        # note:
        # 1. Define a set of internal redirected content. If there is internal redirected content, this field is required.
        # 2. need to clear the content redirection content under the domain name, you can pass the empty node <rewrite-rule-settings></rewrite-rule-settings>", "zh_CN":"一级服务改写替换&mdash;二级服务 内部重定向
        # 注意：
        # 1. 定义一组内部重定向内容，，如果有使用内部重定向内容，此项必填
        # 2. 需要清空域名下的内容重定向内容，可以传入空节点<rewrite-rule-settings></rewrite-rule-settings>
        # 3. 如果有开启其他高级配置（如防盗链配置），有些配置可能会有配置冲突，建议先与技术支持人员确认"}
        self.rewrite_rule_settings = rewrite_rule_settings

    def validate(self):
        self.validate_required(self.rewrite_rule_settings, 'rewrite_rule_settings')
        if self.rewrite_rule_settings:
            for k in self.rewrite_rule_settings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rewrite_rule_settings is not None:
            result['rewrite-rule-settings'] = []
            for k in self.rewrite_rule_settings:
                result['rewrite-rule-settings'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('rewrite-rule-settings') is not None:
            self.rewrite_rule_settings = []
            for k in m.get('rewrite-rule-settings'):
                temp_model = EditDomainRedirectConfigRequestRewriteRuleSettings()
                self.rewrite_rule_settings.append(temp_model.from_map(k))
        return self


class EditDomainRedirectConfigResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditDomainRedirectConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditDomainRedirectConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditDomainRedirectConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditDomainRedirectConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateHttp2SettingsConfigForWplusRequestHttp2Settings(TeaModel):
    def __init__(
        self,
        enable_http_2: str = None,
        back_to_origin_protocol: str = None,
    ):
        # {"en":"Enable http2.0. The optional values are true and false. If it is empty, the default value is false. True means http2.0 is on; false means http2.0 is off.", "zh_CN":"开启http2.0，可选值为true和false，为空时默认为false。true表示开启http2.0；false表示关闭http2.0"}
        self.enable_http_2 = enable_http_2
        # {"en":"Back-to-origin protocol, the optional value is
        # http1.1: Use the HTTP1.1 protocol version to back to source. if not filled, use it as default.
        # follow-request: Same as client request protocol
        # http2.0: Use the HTTP2.0 protocol. version to back to source.", "zh_CN":"回源协议，可选值为
        # http1.1：使用HTTP1.1协议版本回源，不填时默认该协议
        # follow-request：跟随客户端请求协议
        # http2.0：使用HTTP2.0协议版本回源（点播下载直播产品不支持H2回源）"}
        self.back_to_origin_protocol = back_to_origin_protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_http_2 is not None:
            result['enableHttp2'] = self.enable_http_2
        if self.back_to_origin_protocol is not None:
            result['backToOriginProtocol'] = self.back_to_origin_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHttp2') is not None:
            self.enable_http_2 = m.get('enableHttp2')
        if m.get('backToOriginProtocol') is not None:
            self.back_to_origin_protocol = m.get('backToOriginProtocol')
        return self


class UpdateHttp2SettingsConfigForWplusRequest(TeaModel):
    def __init__(
        self,
        http_2settings: UpdateHttp2SettingsConfigForWplusRequestHttp2Settings = None,
    ):
        # {"en":"Http2.0 settings, used to enable or disable http2.0, parent node.", "zh_CN":"http2.0设置，用于设置http2.0的开启或关闭，父标签"}
        self.http_2settings = http_2settings

    def validate(self):
        self.validate_required(self.http_2settings, 'http_2settings')
        if self.http_2settings:
            self.http_2settings.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_2settings is not None:
            result['http2Settings'] = self.http_2settings.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http2Settings') is not None:
            temp_model = UpdateHttp2SettingsConfigForWplusRequestHttp2Settings()
            self.http_2settings = temp_model.from_map(m['http2Settings'])
        return self


class UpdateHttp2SettingsConfigForWplusResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"Error code, which appears when HTTPStatus is not 202, represents the error type of the current request call", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateHttp2SettingsConfigForWplusPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class UpdateHttp2SettingsConfigForWplusParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateHttp2SettingsConfigForWplusRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateHttp2SettingsConfigForWplusResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAmazonS3AuthorizationConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAmazonS3AuthorizationConfigResponseAmazonS3AccessAuthorizationRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        except_path_pattern: str = None,
        add_authorization_header: str = None,
        access_key: str = None,
        access_key_id: str = None,
        signature_version: str = None,
        region: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"The exception url matching mode.", "zh_CN":"例外的url匹配模式，格式同path-pattern"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Define whether to add Authorization header when back to Amazon S3 source. Allowed  true and false.", "zh_CN":"是否添加鉴权头部，为true，则回源按照Amazon S3的算法添加 添加Authorization头部。
        # 允许值为true和false，默认为false。"}
        self.add_authorization_header = add_authorization_header
        # {"en":"access key", "zh_CN":"校验所需的密钥"}
        self.access_key = access_key
        # {"en":"access key id", "zh_CN":"校验所需的密钥ID"}
        self.access_key_id = access_key_id
        # {"en":"Signature version, default value is 2. Support 2 and 4.", "zh_CN":"算法版本，默认值2，目前仅支持2和4"}
        self.signature_version = signature_version
        # {"en":"Authorization region. Please refer to the AWS official site for detail.", "zh_CN":"认证地区，见AWS官网区域说明"}
        self.region = region
        # {"en":"When configuring multiple configurations, the ID of a specific group of configurations", "zh_CN":"配置多组配置时，具体某组配置的id"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.add_authorization_header, 'add_authorization_header')
        self.validate_required(self.access_key, 'access_key')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.signature_version, 'signature_version')
        self.validate_required(self.region, 'region')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.add_authorization_header is not None:
            result['add-authorization-header'] = self.add_authorization_header
        if self.access_key is not None:
            result['access-key'] = self.access_key
        if self.access_key_id is not None:
            result['access-key-id'] = self.access_key_id
        if self.signature_version is not None:
            result['signature-version'] = self.signature_version
        if self.region is not None:
            result['region'] = self.region
        if self.data_id is not None:
            result['data-id'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('add-authorization-header') is not None:
            self.add_authorization_header = m.get('add-authorization-header')
        if m.get('access-key') is not None:
            self.access_key = m.get('access-key')
        if m.get('access-key-id') is not None:
            self.access_key_id = m.get('access-key-id')
        if m.get('signature-version') is not None:
            self.signature_version = m.get('signature-version')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        return self


class QueryAmazonS3AuthorizationConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        amazon_s3access_authorization_rules: List[QueryAmazonS3AuthorizationConfigResponseAmazonS3AccessAuthorizationRules] = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        # {"en":"Amazon S3 Access Authorization Configuration, parent node
        # 1. When you need to configure the Amazon S3 Access Authorization rules, this must be filled in.
        # 2. Configuration of clearing for <amazon-s3-access-authorization-rules/>.
        # 3.vodstream/download support, web/wsa does not support.
        # 4.Amason S3 and Aliyun OSS cannot be configured simultaneously.", "zh_CN":"Amazon S3鉴权配置，父标签
        # 1.需要设置Amazon S3鉴权时，此项必填
        # 2.为<amazon-s3-access-authorization-rules/>时清空Amazon S3鉴权配置的配置
        # 3.点播下载支持，网页wsa不支持
        # 4.Amason S3和Aliyun OSS不可同时配置"}
        self.amazon_s3access_authorization_rules = amazon_s3access_authorization_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.amazon_s3access_authorization_rules, 'amazon_s3access_authorization_rules')
        if self.amazon_s3access_authorization_rules:
            for k in self.amazon_s3access_authorization_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.amazon_s3access_authorization_rules is not None:
            result['amazon-s3-access-authorization-rules'] = []
            for k in self.amazon_s3access_authorization_rules:
                result['amazon-s3-access-authorization-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('amazon-s3-access-authorization-rules') is not None:
            self.amazon_s3access_authorization_rules = []
            for k in m.get('amazon-s3-access-authorization-rules'):
                temp_model = QueryAmazonS3AuthorizationConfigResponseAmazonS3AccessAuthorizationRules()
                self.amazon_s3access_authorization_rules.append(temp_model.from_map(k))
        return self


class QueryAmazonS3AuthorizationConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"Domain name or domain ID that needs to be queried for configuration.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryAmazonS3AuthorizationConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAmazonS3AuthorizationConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAmazonS3AuthorizationConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLiveDomainHeaderRulesRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainHeaderRulesResponseDataHeaderRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        header_name: str = None,
        header_type: str = None,
        action: str = None,
        header_value: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File QueryLiveDomainHeaderRulesPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Header Name", "zh_CN":"头部名称"}
        self.header_name = header_name
        # {"en":"Header Type, Enum[clientReq, clientResp, originReq, originResp]", "zh_CN":"头部类型，可选值[clientReq, clientResp, originReq, originResp]"}
        self.header_type = header_type
        # {"en":"Operate Type, Enum[add, set, delete]", "zh_CN":"操作类型，可选值[add, set, delete]"}
        self.action = action
        # {"en":"Header Value", "zh_CN":"头部值"}
        self.header_value = header_value

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.header_name, 'header_name')
        self.validate_required(self.header_type, 'header_type')
        self.validate_required(self.action, 'action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileQueryLiveDomainHeaderRulesPaths'] = self.file_paths
        if self.header_name is not None:
            result['headerName'] = self.header_name
        if self.header_type is not None:
            result['headerType'] = self.header_type
        if self.action is not None:
            result['action'] = self.action
        if self.header_value is not None:
            result['headerValue'] = self.header_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileQueryLiveDomainHeaderRulesPaths') is not None:
            self.file_paths = m.get('fileQueryLiveDomainHeaderRulesPaths')
        if m.get('headerName') is not None:
            self.header_name = m.get('headerName')
        if m.get('headerType') is not None:
            self.header_type = m.get('headerType')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('headerValue') is not None:
            self.header_value = m.get('headerValue')
        return self


class QueryLiveDomainHeaderRulesResponseData(TeaModel):
    def __init__(
        self,
        header_rules: List[QueryLiveDomainHeaderRulesResponseDataHeaderRules] = None,
    ):
        # {"en":"Header Rules", "zh_CN":"HTTP头部控制"}
        self.header_rules = header_rules

    def validate(self):
        self.validate_required(self.header_rules, 'header_rules')
        if self.header_rules:
            for k in self.header_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header_rules is not None:
            result['headerRules'] = []
            for k in self.header_rules:
                result['headerRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headerRules') is not None:
            self.header_rules = []
            for k in m.get('headerRules'):
                temp_model = QueryLiveDomainHeaderRulesResponseDataHeaderRules()
                self.header_rules.append(temp_model.from_map(k))
        return self


class QueryLiveDomainHeaderRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLiveDomainHeaderRulesResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLiveDomainHeaderRulesResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLiveDomainHeaderRulesPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class QueryLiveDomainHeaderRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainHeaderRulesRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLiveDomainHeaderRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigResponseCacheByRespHeaderViews(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        response_header: str = None,
        is_rep_header: str = None,
        path_pattern: str = None,
        except_path_pattern: str = None,
        ignore_letter_case: str = None,
        priority: str = None,
        response_value: str = None,
    ):
        # {"en":"Add grid type identity, represents the customer multi - group configuration, a specific group of configuration", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置"}
        self.data_id = data_id
        # {"en":"The name of the response header", "zh_CN":"响应头头部名称 需要缓存的响应头名称。如Cache-Control"}
        self.response_header = response_header
        # {"en":"Whether the response header content cache file is allowed. An optional value of true or false indicates that the response header content cache file is allowed.False indicates that the response header content cache file is not allowed.", "zh_CN":"是否允许响应头内容缓存文件，可选值为true或false，true表示允许响应头内容缓存文件；false表示不允许响应头内容缓存文件"}
        self.is_rep_header = is_rep_header
        # {"en":"Url matching pattern, support fuzzy regular, if all match, the parameter can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Exception to url matching pattern, except for some urls: abc.jpg, no content redirection", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做内容重定向"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Ignore case, the optional value is true or false, true means ignore case;False means that case is not ignored.", "zh_CN":"忽略大小写，可选值为true或false，true表示忽略大小写；false表示不忽略大小写； 新增配置项时，不传默认为 true"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"Header values.", "zh_CN":"头部值。"}
        self.response_value = response_value

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.response_header, 'response_header')
        self.validate_required(self.is_rep_header, 'is_rep_header')
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.ignore_letter_case, 'ignore_letter_case')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.response_value, 'response_value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.response_header is not None:
            result['response-header'] = self.response_header
        if self.is_rep_header is not None:
            result['is-respheader'] = self.is_rep_header
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.priority is not None:
            result['priority'] = self.priority
        if self.response_value is not None:
            result['response-value'] = self.response_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('response-header') is not None:
            self.response_header = m.get('response-header')
        if m.get('is-respheader') is not None:
            self.is_rep_header = m.get('is-respheader')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('response-value') is not None:
            self.response_value = m.get('response-value')
        return self


class QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        cache_by_resp_header_views: List[QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigResponseCacheByRespHeaderViews] = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_id = domain_id
        self.cache_by_resp_header_views = cache_by_resp_header_views

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.cache_by_resp_header_views, 'cache_by_resp_header_views')
        if self.cache_by_resp_header_views:
            for k in self.cache_by_resp_header_views:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.cache_by_resp_header_views is not None:
            result['cache-by-respheaders'] = []
            for k in self.cache_by_resp_header_views:
                result['cache-by-respheaders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('cache-by-respheaders') is not None:
            self.cache_by_resp_header_views = []
            for k in m.get('cache-by-respheaders'):
                temp_model = QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigResponseCacheByRespHeaderViews()
                self.cache_by_resp_header_views.append(temp_model.from_map(k))
        return self


class QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheByQueryCacheByResponseHeaderConfigResponseHeaderConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheByResponseHeaderConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateLiveDomainRequest(TeaModel):
    def __init__(
        self,
        comment: str = None,
        origin_address: str = None,
        origin_protocol: str = None,
        app_names: List[str] = None,
    ):
        # {"en":"Comment", "zh_CN":"备注信息"}
        self.comment = comment
        # {"en":"Origin Address", "zh_CN":"源站地址"}
        self.origin_address = origin_address
        # {"en":"Origin Protocol, Enum[HTTP,HTTPS] or Enum[RTMP,HDL]", "zh_CN":"回源协议，Enum[HTTP,HTTPS] or Enum[RTMP,HDL]"}
        self.origin_protocol = origin_protocol
        # {"en":"App Names", "zh_CN":"发布点"}
        self.app_names = app_names

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.comment is not None:
            result['comment'] = self.comment
        if self.origin_address is not None:
            result['originAddress'] = self.origin_address
        if self.origin_protocol is not None:
            result['originProtocol'] = self.origin_protocol
        if self.app_names is not None:
            result['appNames'] = self.app_names
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('comment') is not None:
            self.comment = m.get('comment')
        if m.get('originAddress') is not None:
            self.origin_address = m.get('originAddress')
        if m.get('originProtocol') is not None:
            self.origin_protocol = m.get('originProtocol')
        if m.get('appNames') is not None:
            self.app_names = m.get('appNames')
        return self


class UpdateLiveDomainResponseData(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The preliminary deployment id", "zh_CN":"预部署id"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class UpdateLiveDomainResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: UpdateLiveDomainResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = UpdateLiveDomainResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateLiveDomainPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class UpdateLiveDomainParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainRequestHeader(TeaModel):
    def __init__(
        self,
        wsdeployment_target: List[str] = None,
    ):
        # {"en":"WS Deployment Target", "zh_CN":"部署环境"}
        self.wsdeployment_target = wsdeployment_target

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.wsdeployment_target is not None:
            result['WS-Deployment-Target'] = self.wsdeployment_target
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('WS-Deployment-Target') is not None:
            self.wsdeployment_target = m.get('WS-Deployment-Target')
        return self


class UpdateLiveDomainResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLivestreamingAntihotlinkingConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLivestreamingAntihotlinkingConfigResponseDataVisitControlRules(TeaModel):
    def __init__(
        self,
        control_action: str = None,
        ips: List[str] = None,
        referers: List[str] = None,
        allow_null_referer: bool = None,
        control_relation: str = None,
        data_id: int = None,
    ):
        # {"en":"Control action, optional values: allow, forbid
        # Note: when add or modify a rule, you must configure both controlaction and IP, referer. At least one of IP and referer must be configured, otherwise the function will not work.", "zh_CN":"控制动作，允许或禁止，可选值：allow，forbid
        # 注意：配置或修改流媒体防盗链时，必须同时配置controlAction和ip、referer，ip和referer至少配置一项，否则此防盗链功能无效。"}
        self.control_action = control_action
        # {"en":"Allowed or forbidden IP, support IP and IP segment, parent node. Controlaction must be configured at the same time. Such as:
        # <controlAction>forbid</controlAction>
        # <ips>
        # <ip>1.1.1.1</ip>
        # <ip>2.2.2.0/24</ip>
        # </ips>", "zh_CN":"允许或禁止的IP，支持IP或IP段，父标签。必须同时配置controlAction。
        # 格式如
        # <controlAction>forbid</controlAction>
        # <ips>
        # <ip>1.1.1.1</ip> 
        # <ip>2.2.2.0/24</ip>
        # </ips>"}
        self.ips = ips
        # {"en":"The allowed or forbidden referer, support domain name and URL format. Parent node. It must start with the protocol header, such as http://, https://. Controlaction must be configured at the same time. Such as:
        # <controlAction>forbid</controlAction>
        # <referers>
        # <referer>http://www.referer1.com</referer>
        # <referer>http://www.referer2.com</referer>
        # </referers>", "zh_CN":"允许或禁止的referer，支持输入域名或url格式，父标签，必须以协议头开头，如http://、https://。必须同时配置controlAction。格式如：
        # <controlAction>forbid</controlAction>
        # <referers>
        # <referer>http://www.referer1.com</referer>
        # <referer>http://www.referer2.com</referer>
        # </referers>"}
        self.referers = referers
        # {"en":"Allow or forbid null referer. Optional value is 'true' or 'false',default value is 'false'.
        # When controlAction equals forbid, it means whether null referer is forbidden. If it is true, it means null referer is prohibited.
        # When controlAction  equals  allow, it means whether null referer is allowed. If it is true, it means null referer is allowed.", "zh_CN":"是否允许/禁止空referer，可选值为true、false，默认为否。
        # 当控制动作=forbid，表示是否禁止空referer，为true，表示禁止空referer
        # 当控制动作=allow，表示是否允许空referer，为true，表示允许空referer"}
        self.allow_null_referer = allow_null_referer
        # {"en":"IP and refer condition relationship, optional values: and, or, default to and.", "zh_CN":"ip和refer条件关系，可选值：and，or，默认为and
        # 为and，表示ip和refer都满足，才允许/禁止。为or，表示ip和refer满足一个，就允许/禁止"}
        self.control_relation = control_relation
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.control_action, 'control_action')
        self.validate_required(self.ips, 'ips')
        self.validate_required(self.referers, 'referers')
        self.validate_required(self.allow_null_referer, 'allow_null_referer')
        self.validate_required(self.control_relation, 'control_relation')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.control_action is not None:
            result['controlAction'] = self.control_action
        if self.ips is not None:
            result['ips'] = self.ips
        if self.referers is not None:
            result['referers'] = self.referers
        if self.allow_null_referer is not None:
            result['allowNullReferer'] = self.allow_null_referer
        if self.control_relation is not None:
            result['controlRelation'] = self.control_relation
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('controlAction') is not None:
            self.control_action = m.get('controlAction')
        if m.get('ips') is not None:
            self.ips = m.get('ips')
        if m.get('referers') is not None:
            self.referers = m.get('referers')
        if m.get('allowNullReferer') is not None:
            self.allow_null_referer = m.get('allowNullReferer')
        if m.get('controlRelation') is not None:
            self.control_relation = m.get('controlRelation')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryLivestreamingAntihotlinkingConfigResponseData(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        visit_control_rules: List[QueryLivestreamingAntihotlinkingConfigResponseDataVisitControlRules] = None,
    ):
        # {"en":"domain id", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"Streaming visit control configuration, parent node
        # 1. This item is required when the function of streaming visit control configuration needs to be set
        # 2. Clear the Streaming visit control configuration when <visitControlRules/>", "zh_CN":"流媒体防盗链配置，父标签
        # 1.需要设置流媒体防盗链配置时，此项必填
        # 2.为<visitControlRules/>时清空流媒体防盗链配置"}
        self.visit_control_rules = visit_control_rules

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.visit_control_rules, 'visit_control_rules')
        if self.visit_control_rules:
            for k in self.visit_control_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.visit_control_rules is not None:
            result['visitControlRules'] = []
            for k in self.visit_control_rules:
                result['visitControlRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('visitControlRules') is not None:
            self.visit_control_rules = []
            for k in m.get('visitControlRules'):
                temp_model = QueryLivestreamingAntihotlinkingConfigResponseDataVisitControlRules()
                self.visit_control_rules.append(temp_model.from_map(k))
        return self


class QueryLivestreamingAntihotlinkingConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLivestreamingAntihotlinkingConfigResponseData = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 200, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLivestreamingAntihotlinkingConfigResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryLivestreamingAntihotlinkingConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryLivestreamingAntihotlinkingConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLivestreamingAntihotlinkingConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLivestreamingAntihotlinkingConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryAntiHotlinkingConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesAdvanceControlRules(TeaModel):
    def __init__(
        self,
        invalid_time: str = None,
    ):
        # {"en":"The format is: YYYY start date - end date weekday start time - end date, Beijing time. For example: 2022 1/1-6/30 Mon 00:00-16:00, which means: 0:00-16:00 every Monday from January 1st to June 30th, 2017. You can only configure the start time, such as 00:00-16:00, which means 0:00 to 16:00 every day.", "zh_CN":"禁止访问的时间"}
        self.invalid_time = invalid_time

    def validate(self):
        self.validate_required(self.invalid_time, 'invalid_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_time is not None:
            result['invalid-time'] = self.invalid_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('invalid-time') is not None:
            self.invalid_time = m.get('invalid-time')
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesIpControlRule(TeaModel):
    def __init__(
        self,
        forbidden_ips: str = None,
    ):
        # {"en":"Prohibited IP segment
        # Input parameter limit reference interface limit
        # Forbidden IP and exceptional IP cannot be configured at the same time", "zh_CN":"禁止的IP段
        # 禁止的IP和例外的IP只能一个有值"}
        self.forbidden_ips = forbidden_ips

    def validate(self):
        self.validate_required(self.forbidden_ips, 'forbidden_ips')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.forbidden_ips is not None:
            result['forbidden-ips'] = self.forbidden_ips
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('forbidden-ips') is not None:
            self.forbidden_ips = m.get('forbidden-ips')
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRuleUaControlRule(TeaModel):
    def __init__(
        self,
        valid_user_agents: str = None,
        invalid_user_agents: str = None,
    ):
        # {"en":"Allows clients, regular matching, to configure multiple UA such as:
        # < valid user - agents > Android | iPhone < / valid - the user - agents >", "zh_CN":"允许的客户端，正则匹配，配置多个UA如：<valid-user-agents>Android|iPhone</valid-user-agents>"}
        self.valid_user_agents = valid_user_agents
        # {"en":"Forbidden client, regular match, configure multiple UA such as:
        # <invalid-user-agents>Android|iPhone</invalid-user-agents>", "zh_CN":"禁止的客户端，正则匹配，配置多个UA如：<invalid-user-agents>Android|iPhone</invalid-user-agents>"}
        self.invalid_user_agents = invalid_user_agents

    def validate(self):
        self.validate_required(self.valid_user_agents, 'valid_user_agents')
        self.validate_required(self.invalid_user_agents, 'invalid_user_agents')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.valid_user_agents is not None:
            result['valid-user-agents'] = self.valid_user_agents
        if self.invalid_user_agents is not None:
            result['invalid-user-agents'] = self.invalid_user_agents
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('valid-user-agents') is not None:
            self.valid_user_agents = m.get('valid-user-agents')
        if m.get('invalid-user-agents') is not None:
            self.invalid_user_agents = m.get('invalid-user-agents')
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRuleAdvanceControlRules(TeaModel):
    def __init__(
        self,
        invalid_visitor_region: str = None,
        valid_visitor_region: str = None,
    ):
        # {"en":"Forbidden visitor regions, separate with semicolons. Note:
        # 1. Only support ISO 3166-1-alpha-2 two-letter country codes.
        # 2. If you have special regional configuration requirements, please contact your technical support.
        # 3. In the same set of rules, forbidden and allowed visitor regions cannot be configured at the same time.", "zh_CN":"禁止的访客区域，多个请用英文分号分隔。注意
        # 1、仅支持iso 3166-1国家二字简称
        # 2、如果有特殊区域配置需求，请联系您的专属。
        # 3、同一组规则里，禁止的访客区域、允许的访客区域，不能同时配"}
        self.invalid_visitor_region = invalid_visitor_region
        # {"en":"Allowed  visitor regions, separate with semicolons. Note:
        # 1. Only support ISO 3166-1-alpha-2 two-letter country codes.
        # 2. If you have special regional configuration requirements, please contact your technical support.
        # 3. In the same set of rules, forbidden and allowed visitor regions cannot be configured at the same time.", "zh_CN":"允许的访客区域，多个请用英文分号分隔。注意
        # 1、仅支持iso 3166-1国家二字简称
        # 2、如果有特殊区域配置需求，请联系您的专属。
        # 3、同一组规则里，禁止的访客区域、允许的访客区域，不能同时配"}
        self.valid_visitor_region = valid_visitor_region

    def validate(self):
        self.validate_required(self.invalid_visitor_region, 'invalid_visitor_region')
        self.validate_required(self.valid_visitor_region, 'valid_visitor_region')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.invalid_visitor_region is not None:
            result['invalid-visitor-region'] = self.invalid_visitor_region
        if self.valid_visitor_region is not None:
            result['valid-visitor-region'] = self.valid_visitor_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('invalid-visitor-region') is not None:
            self.invalid_visitor_region = m.get('invalid-visitor-region')
        if m.get('valid-visitor-region') is not None:
            self.valid_visitor_region = m.get('valid-visitor-region')
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRule(TeaModel):
    def __init__(
        self,
        allow_null_referer: str = None,
        valid_referer: str = None,
        valid_url: str = None,
        valid_domain: str = None,
        invalid_referer: str = None,
        invalid_url: str = None,
        invalid_domain: str = None,
        ua_control_rule: QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRuleUaControlRule = None,
        advance_control_rules: QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRuleAdvanceControlRules = None,
    ):
        # {"en":"If any of the four terms 'nullreferer: legal referer, (legal domain name, legal URL), illegal referer, (illegal domain name, illegal URL)' is allowed, then 'nullreferer' cannot be null.If the four terms 'legal refer', 'legal domain name, legal URL', 'illegal refer', 'illegal domain name, illegal URL' are all null values, then 'whether to allow a null referer' must be null", "zh_CN":"是否允许空referer：合法refer、（合法域名、合法URL）、非法refer、（非法域名、非法URL）这四项任意一项有值，则&ldquo;是否允许空referer&rdquo;不能为空；合法refer、（合法域名、合法URL）、非法refer、（非法域名、非法URL）这四项都为空值，则&ldquo;是否允许空referer&rdquo;必须为空"}
        self.allow_null_referer = allow_null_referer
        # {"en":"Legal referer.", "zh_CN":"合法referer.可以输入url或域名"}
        self.valid_referer = valid_referer
        # {"en":"Legal url, enter the correct url format", "zh_CN":"合法url，输入正确的url格式"}
        self.valid_url = valid_url
        # {"en":"Legal domain name", "zh_CN":"合法域名"}
        self.valid_domain = valid_domain
        # {"en":"Illegal referer", "zh_CN":"非法referer，可以输入url或域名"}
        self.invalid_referer = invalid_referer
        # {"en":"Invalid url, enter the correct url format", "zh_CN":"非法url，输入正确的url格式"}
        self.invalid_url = invalid_url
        # {"en":"Illegal domain name", "zh_CN":"非法域名"}
        self.invalid_domain = invalid_domain
        # {"en":"UA head protection against hotlinking,
        # Note:
        # 1. Represents a group of UA head defense hotlinking, and only one group under a data-id
        # 2. when empty label means clear UA head protection hotlinking", "zh_CN":"标识UA头防盗链，
        # 注意：
        # 1、表示一组UA头防盗链，一个data-id下只能一组
        # 2、当传空标签表示清除UA头防盗链"}
        self.ua_control_rule = ua_control_rule
        # {"en":"Configure other access control rules, such as invalid visitor regions, example:
        # advance-control-rules:{invalid-visitor-region:CN;JP;K}", "zh_CN":"配置其他访问控制策略，比如禁止的访客区域，JSON示例：
        # advance-control-rules:{invalid-visitor-region:CN;JP;KR}"}
        self.advance_control_rules = advance_control_rules

    def validate(self):
        self.validate_required(self.allow_null_referer, 'allow_null_referer')
        self.validate_required(self.valid_referer, 'valid_referer')
        self.validate_required(self.valid_url, 'valid_url')
        self.validate_required(self.valid_domain, 'valid_domain')
        self.validate_required(self.invalid_referer, 'invalid_referer')
        self.validate_required(self.invalid_url, 'invalid_url')
        self.validate_required(self.invalid_domain, 'invalid_domain')
        self.validate_required(self.ua_control_rule, 'ua_control_rule')
        if self.ua_control_rule:
            self.ua_control_rule.validate()
        self.validate_required(self.advance_control_rules, 'advance_control_rules')
        if self.advance_control_rules:
            self.advance_control_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_null_referer is not None:
            result['allow-null-referer'] = self.allow_null_referer
        if self.valid_referer is not None:
            result['valid-referer'] = self.valid_referer
        if self.valid_url is not None:
            result['valid-url'] = self.valid_url
        if self.valid_domain is not None:
            result['valid-domain'] = self.valid_domain
        if self.invalid_referer is not None:
            result['invalid-referer'] = self.invalid_referer
        if self.invalid_url is not None:
            result['invalid-url'] = self.invalid_url
        if self.invalid_domain is not None:
            result['invalid-domain'] = self.invalid_domain
        if self.ua_control_rule is not None:
            result['ua-control-rule'] = self.ua_control_rule.to_map()
        if self.advance_control_rules is not None:
            result['advance-control-rules'] = self.advance_control_rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allow-null-referer') is not None:
            self.allow_null_referer = m.get('allow-null-referer')
        if m.get('valid-referer') is not None:
            self.valid_referer = m.get('valid-referer')
        if m.get('valid-url') is not None:
            self.valid_url = m.get('valid-url')
        if m.get('valid-domain') is not None:
            self.valid_domain = m.get('valid-domain')
        if m.get('invalid-referer') is not None:
            self.invalid_referer = m.get('invalid-referer')
        if m.get('invalid-url') is not None:
            self.invalid_url = m.get('invalid-url')
        if m.get('invalid-domain') is not None:
            self.invalid_domain = m.get('invalid-domain')
        if m.get('ua-control-rule') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRuleUaControlRule()
            self.ua_control_rule = temp_model.from_map(m['ua-control-rule'])
        if m.get('advance-control-rules') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRuleAdvanceControlRules()
            self.advance_control_rules = temp_model.from_map(m['advance-control-rules'])
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesCookieControlRules(TeaModel):
    def __init__(
        self,
        allow_cookie: str = None,
        allow_null_cookie: str = None,
        forbidden_cookie: str = None,
    ):
        # {"en":"Allow Cookie.Fill in regular format, e.g(. *) (range1 | range2) (. *)", "zh_CN":"允许的cookie。填写正则格式，比如(.*)(range1|range2)(.*)。"}
        self.allow_cookie = allow_cookie
        # {"en":"Allow Null Cookie.Only true and false are allowed to be filled in allow null cookie", "zh_CN":"是否允许空cookie。只允许填写true或false。"}
        self.allow_null_cookie = allow_null_cookie
        # {"en":"Forbidden Cookie.Fill in regular format, e.g(. *) (range1 | range2) (. *)", "zh_CN":"禁止的cookie。填写正则格式，比如(.*)(range1|range2)(.*)。"}
        self.forbidden_cookie = forbidden_cookie

    def validate(self):
        self.validate_required(self.allow_cookie, 'allow_cookie')
        self.validate_required(self.allow_null_cookie, 'allow_null_cookie')
        self.validate_required(self.forbidden_cookie, 'forbidden_cookie')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_cookie is not None:
            result['allow-cookie'] = self.allow_cookie
        if self.allow_null_cookie is not None:
            result['allow-null-cookie'] = self.allow_null_cookie
        if self.forbidden_cookie is not None:
            result['forbidden-cookie'] = self.forbidden_cookie
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allow-cookie') is not None:
            self.allow_cookie = m.get('allow-cookie')
        if m.get('allow-null-cookie') is not None:
            self.allow_null_cookie = m.get('allow-null-cookie')
        if m.get('forbidden-cookie') is not None:
            self.forbidden_cookie = m.get('forbidden-cookie')
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRulesCustomHeaderControlRules(TeaModel):
    def __init__(
        self,
        header_direction: str = None,
        header_whitelist: str = None,
        header_value_whitelist: str = None,
        header_blacklist: str = None,
        header_value_blacklist: str = None,
    ):
        # {"en":"Header Direction.Can choose from the client or the server.Only allowed to fill client or server", "zh_CN":"来源。可选择来源于客户端还是服务端。客户端填写client，服务端填写server"}
        self.header_direction = header_direction
        # {"en":"Header Whitelist", "zh_CN":"头域白名单"}
        self.header_whitelist = header_whitelist
        # {"en":"Header Value Whitelist", "zh_CN":"头域值白名单"}
        self.header_value_whitelist = header_value_whitelist
        # {"en":"Header Blacklist", "zh_CN":"头域黑名单"}
        self.header_blacklist = header_blacklist
        # {"en":"Header Value Blacklist", "zh_CN":"头域值黑名单"}
        self.header_value_blacklist = header_value_blacklist

    def validate(self):
        self.validate_required(self.header_direction, 'header_direction')
        self.validate_required(self.header_whitelist, 'header_whitelist')
        self.validate_required(self.header_value_whitelist, 'header_value_whitelist')
        self.validate_required(self.header_blacklist, 'header_blacklist')
        self.validate_required(self.header_value_blacklist, 'header_value_blacklist')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header_direction is not None:
            result['header-direction'] = self.header_direction
        if self.header_whitelist is not None:
            result['header-whitelist'] = self.header_whitelist
        if self.header_value_whitelist is not None:
            result['header-value-whitelist'] = self.header_value_whitelist
        if self.header_blacklist is not None:
            result['header-blacklist'] = self.header_blacklist
        if self.header_value_blacklist is not None:
            result['header-value-blacklist'] = self.header_value_blacklist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('header-direction') is not None:
            self.header_direction = m.get('header-direction')
        if m.get('header-whitelist') is not None:
            self.header_whitelist = m.get('header-whitelist')
        if m.get('header-value-whitelist') is not None:
            self.header_value_whitelist = m.get('header-value-whitelist')
        if m.get('header-blacklist') is not None:
            self.header_blacklist = m.get('header-blacklist')
        if m.get('header-value-blacklist') is not None:
            self.header_value_blacklist = m.get('header-value-blacklist')
        return self


class QueryAntiHotlinkingConfigResponseVisitControlRules(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        path_pattern: str = None,
        except_path_pattern: str = None,
        custom_pattern: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        specify_url_pattern: str = None,
        directory: str = None,
        except_file_type: str = None,
        except_custom_file_type: str = None,
        except_directory: str = None,
        control_action: str = None,
        rewrite_to: str = None,
        priority: int = None,
        exceptional_request: str = None,
        ignored_case: str = None,
        advance_control_rules: QueryAntiHotlinkingConfigResponseVisitControlRulesAdvanceControlRules = None,
        ip_control_rule: QueryAntiHotlinkingConfigResponseVisitControlRulesIpControlRule = None,
        allowed_ips: str = None,
        referer_control_rule: QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRule = None,
        cookie_control_rules: QueryAntiHotlinkingConfigResponseVisitControlRulesCookieControlRules = None,
        custom_header_control_rules: QueryAntiHotlinkingConfigResponseVisitControlRulesCustomHeaderControlRules = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置"}
        self.data_id = data_id
        # {"en":"The url matching mode supports regularization. If all matches, the input parameters can be configured as: .*", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Exceptional url matching mode, except for some URLs: such as abc.jpg, do not do anti-theft chain function
        # E.g: ^https?://[^/]+/.*\.m3u8", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做防盗链功能
        # 客户入参参考：^https?://[^/]+/.*\.m3u8"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Specify common types: Select the domain name that requires the anti-theft chain to be all files or the home page. :
        # E.g:
        # All: all files
        # Homepage: homepage", "zh_CN":"指定常用类型：选择需要防盗链的域名是全部文件还是首页。入参参考值：
        # all：全部文件
        # homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"File Type: Specify the file type for anti-theft chain settings.
        # File types include: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # If you need all types, pass all directly. Multiples are separated by semicolons, and all and specific file types cannot be configured at the same time.", "zh_CN":"文件类型：指定文件类型进行防盗链设置。
        # 文件类型包括：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # 如果需要全部类型，则直接传all。多个以分号隔开，all和具体文件类型不能同时配置。"}
        self.file_type = file_type
        # {"en":"Custom file type: Fill in the appropriate identifiable file type according to your needs outside of the specified file type. Can be used with file-type. If the file-type is also configured, the actual file type is the sum of the two parameters.", "zh_CN":"自定义文件类型：在指定文件类型外根据自身需求，填写适当的可识别文件类型。可以搭配file-type使用。如果file-type也有配置，实际生效的文件类型是两个入参的总和"}
        self.custom_file_type = custom_file_type
        # {"en":"Specify URL cache: Specify url according to requirements for anti-theft chain setting
        # INS format does not support URI format with http(s)://", "zh_CN":"指定URL缓存：根据需求指定url进行防盗链设置
        # 入参不支持含http(s):// 开头的URI格式"}
        self.specify_url_pattern = specify_url_pattern
        # {"en":"Directory: Specify the directory for anti-theft chain settings
        # Enter a legal directory format. Multiple separated by semicolons", "zh_CN":"目录：指定目录进行防盗链设置
        # 输入合法的目录格式。多个以英文分号隔开"}
        self.directory = directory
        # {"en":"Exception file type: Specify the file type that does not require anti-theft chain function
        # File types include: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # If you need all types, pass all directly. Multiple separated by semicolons, all and specific file types cannot be configured at the same time
        # If file-type=all, except-file-type=all means that the task file type is not matched.", "zh_CN":"例外的文件类型：指定不需要进行防盗链功能的文件类型
        # 文件类型包括：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # 如果需要全部类型，则直接传all。多个以分号隔开，all和具体文件类型不能同时配置
        # 如果file-type=all,except-file-type=all 则表示不匹配任务文件类型"}
        self.except_file_type = except_file_type
        # {"en":"Exceptional custom file types: Fill in the appropriate identifiable file types based on your needs, outside of the specified file type. Can be used with the exception-file-type. If the except-file-type is also configured, the actual file type is the sum of the two parameters.", "zh_CN":"例外的自定义文件类型：在指定文件类型外根据自身需求，填写适当的可识别文件类型。可以搭配except-file-type使用。如果except-file-type也有配置，实际生效的文件类型是两个入参的总和"}
        self.except_custom_file_type = except_custom_file_type
        # {"en":"Exceptional directory: Specify a directory that does not require anti-theft chain settings
        # Enter a legal directory format. Multiple separated by semicolons", "zh_CN":"例外的目录：指定不需要进行进行防盗链设置的目录
        # 输入合法的目录格式。多个以英文分号隔开"}
        self.except_directory = except_directory
        # {"en":"control direction. Available values: 403 and 302
        # 1) 403 means to return a specific error status code to reject the service (the default mode, the status code can be specified, generally 403).
        # 2) 302 means to return 302 the redirect url of the Found, the redirected url can be specified. If pass 302, rewrite-to is required", "zh_CN":"控制方向。可选值：403和302
        # 1） 403表示返回特定的错误状态码来拒绝服务（默认方式，状态码可以指定，一般为403）。
        # 2） 302表示返回302 Found的重定向url，重定向的url可以指定。如果传302，rewrite-to必填"}
        self.control_action = control_action
        # {"en":"Specify the url after the 302 jump. This field is required if the control-action value is 302.", "zh_CN":"指定302跳转后的url。如果control-action值为302，此项必填"}
        self.rewrite_to = rewrite_to
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"表示客户多组重定向内容的优先执行顺序。数字越大，优先级越高。
        # 新增配置项时，不传默认为 10"}
        self.priority = priority
        # {"en":"Exceptional Request Method.Multiple entires separated by ;", "zh_CN":"例外的请求方法。多个以;隔开"}
        self.exceptional_request = exceptional_request
        # {"en":"Only true and false are allowed to be filled in ignoredcase.", "zh_CN":"是否忽略大小写。只允许填写true或false"}
        self.ignored_case = ignored_case
        # {"en":"You can set other visit control rules here.", "zh_CN":"配置其他访问控制策略，比如禁止访问的时间"}
        self.advance_control_rules = advance_control_rules
        # {"en":"Identify IP black and white list anti-theft chain note: 1, a set of black and white list anti-theft chain, only one set under a data-id 2. When the air interface label indicates the exception of the IP segment configuration and the forbidden IP segment configuration.", "zh_CN":"标识IP黑白名单防盗链 注意： 1、表示一组黑白名单防盗链，一个data-id下只能一组 2、当传空标签表示清楚例外的IP段配置和禁止的IP段配置。"}
        self.ip_control_rule = ip_control_rule
        # {"en":"The exception IP segment supports input IP or IP segment, and the IP segments are separated by a semicolon (;), such as 1.1.1.0/24; 2.2.2.2, some IP exceptions, no anti-theft chain", "zh_CN":"例外的IP段，支持输入IP或IP段，IP段之间用分号(;)隔开，如1.1.1.0/24;2.2.2.2，某些IP例外，不做防盗链"}
        self.allowed_ips = allowed_ips
        # {"en":"Identify referer anti-theft chain
        # Note:
        # 1. Represents a set of referer security chains, and a single data-id can only have one set under one
        # 2. when the empty tag means to clear referer security chain
        # 3. legal refer, ( legal domain name, legal URL), illegal refer, ( illegal domain name, illegal URL) these four, a data-id can only configure one or all empty under one data-id", "zh_CN":"标识referer防盗链
        # 注意：
        # 1、表示一组referer防盗链，一个data-id下只能一组
        # 2、当传空标签表示清除referer防盗链
        # 3、合法refer、（合法域名、合法URL）、非法refer、（非法域名、非法URL）这四项，一个data-id下只能配置一个或者都为空"}
        self.referer_control_rule = referer_control_rule
        # {"en":"Configuration cookie control rules.Allow-cookie and forbidden-cookie are not allowed to be configured together.", "zh_CN":"配置Cookie防盗链策略。【允许的cookie】和【禁止的cookie】只允许配置一个"}
        self.cookie_control_rules = cookie_control_rules
        # {"en":"Configuration custom header control rules.Header-whitelist and header-blacklist are not allowed to be configured together.", "zh_CN":"配置自定义头部防盗链。【头域黑名单】和【头域白名单】只允许配置一个"}
        self.custom_header_control_rules = custom_header_control_rules

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.custom_pattern, 'custom_pattern')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.custom_file_type, 'custom_file_type')
        self.validate_required(self.specify_url_pattern, 'specify_url_pattern')
        self.validate_required(self.directory, 'directory')
        self.validate_required(self.except_file_type, 'except_file_type')
        self.validate_required(self.except_custom_file_type, 'except_custom_file_type')
        self.validate_required(self.except_directory, 'except_directory')
        self.validate_required(self.control_action, 'control_action')
        self.validate_required(self.rewrite_to, 'rewrite_to')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.exceptional_request, 'exceptional_request')
        self.validate_required(self.ignored_case, 'ignored_case')
        self.validate_required(self.advance_control_rules, 'advance_control_rules')
        if self.advance_control_rules:
            self.advance_control_rules.validate()
        self.validate_required(self.ip_control_rule, 'ip_control_rule')
        if self.ip_control_rule:
            self.ip_control_rule.validate()
        self.validate_required(self.allowed_ips, 'allowed_ips')
        self.validate_required(self.referer_control_rule, 'referer_control_rule')
        if self.referer_control_rule:
            self.referer_control_rule.validate()
        self.validate_required(self.cookie_control_rules, 'cookie_control_rules')
        if self.cookie_control_rules:
            self.cookie_control_rules.validate()
        self.validate_required(self.custom_header_control_rules, 'custom_header_control_rules')
        if self.custom_header_control_rules:
            self.custom_header_control_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.file_type is not None:
            result['file-type'] = self.file_type
        if self.custom_file_type is not None:
            result['custom-file-type'] = self.custom_file_type
        if self.specify_url_pattern is not None:
            result['specify-url-pattern'] = self.specify_url_pattern
        if self.directory is not None:
            result['directory'] = self.directory
        if self.except_file_type is not None:
            result['except-file-type'] = self.except_file_type
        if self.except_custom_file_type is not None:
            result['except-custom-file-type'] = self.except_custom_file_type
        if self.except_directory is not None:
            result['except-directory'] = self.except_directory
        if self.control_action is not None:
            result['control-action'] = self.control_action
        if self.rewrite_to is not None:
            result['rewrite-to'] = self.rewrite_to
        if self.priority is not None:
            result['priority'] = self.priority
        if self.exceptional_request is not None:
            result['exceptional-request'] = self.exceptional_request
        if self.ignored_case is not None:
            result['ignored-case'] = self.ignored_case
        if self.advance_control_rules is not None:
            result['advance-control-rules'] = self.advance_control_rules.to_map()
        if self.ip_control_rule is not None:
            result['ip-control-rule'] = self.ip_control_rule.to_map()
        if self.allowed_ips is not None:
            result['allowed-ips'] = self.allowed_ips
        if self.referer_control_rule is not None:
            result['referer-control-rule'] = self.referer_control_rule.to_map()
        if self.cookie_control_rules is not None:
            result['cookie-control-rules'] = self.cookie_control_rules.to_map()
        if self.custom_header_control_rules is not None:
            result['custom-header-control-rules'] = self.custom_header_control_rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('file-type') is not None:
            self.file_type = m.get('file-type')
        if m.get('custom-file-type') is not None:
            self.custom_file_type = m.get('custom-file-type')
        if m.get('specify-url-pattern') is not None:
            self.specify_url_pattern = m.get('specify-url-pattern')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('except-file-type') is not None:
            self.except_file_type = m.get('except-file-type')
        if m.get('except-custom-file-type') is not None:
            self.except_custom_file_type = m.get('except-custom-file-type')
        if m.get('except-directory') is not None:
            self.except_directory = m.get('except-directory')
        if m.get('control-action') is not None:
            self.control_action = m.get('control-action')
        if m.get('rewrite-to') is not None:
            self.rewrite_to = m.get('rewrite-to')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('exceptional-request') is not None:
            self.exceptional_request = m.get('exceptional-request')
        if m.get('ignored-case') is not None:
            self.ignored_case = m.get('ignored-case')
        if m.get('advance-control-rules') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesAdvanceControlRules()
            self.advance_control_rules = temp_model.from_map(m['advance-control-rules'])
        if m.get('ip-control-rule') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesIpControlRule()
            self.ip_control_rule = temp_model.from_map(m['ip-control-rule'])
        if m.get('allowed-ips') is not None:
            self.allowed_ips = m.get('allowed-ips')
        if m.get('referer-control-rule') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesRefererControlRule()
            self.referer_control_rule = temp_model.from_map(m['referer-control-rule'])
        if m.get('cookie-control-rules') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesCookieControlRules()
            self.cookie_control_rules = temp_model.from_map(m['cookie-control-rules'])
        if m.get('custom-header-control-rules') is not None:
            temp_model = QueryAntiHotlinkingConfigResponseVisitControlRulesCustomHeaderControlRules()
            self.custom_header_control_rules = temp_model.from_map(m['custom-header-control-rules'])
        return self


class QueryAntiHotlinkingConfigResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        visit_control_rules: List[QueryAntiHotlinkingConfigResponseVisitControlRules] = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名"}
        self.domain_name = domain_name
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名id"}
        self.domain_id = domain_id
        # {"en":"Anti-theft chain configuration
        # note:
        # 1. When you need to cancel the anti-theft chain configuration settings, you can pass in the empty node <cache-time-behaviors></cache-time-behaviors>.
        # 2. When it is necessary to set the anti-theft chain configuration, this item is required.", "zh_CN":"防盗链配置
        # 注意：
        # 1、需要取消防盗链配置设置时，可以传入空节点<cache-time-behaviors></cache-time-behaviors>。
        # 2、表示需要设置防盗链配置时，此项必填"}
        self.visit_control_rules = visit_control_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.visit_control_rules, 'visit_control_rules')
        if self.visit_control_rules:
            for k in self.visit_control_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.visit_control_rules is not None:
            result['visit-control-rules'] = []
            for k in self.visit_control_rules:
                result['visit-control-rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('visit-control-rules') is not None:
            self.visit_control_rules = []
            for k in m.get('visit-control-rules'):
                temp_model = QueryAntiHotlinkingConfigResponseVisitControlRules()
                self.visit_control_rules.append(temp_model.from_map(k))
        return self


class QueryAntiHotlinkingConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryAntiHotlinkingConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAntiHotlinkingConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryAntiHotlinkingConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCacheTimeRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheTimeResponseCacheTimeBehaviors(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        path_pattern: str = None,
        except_path_pattern: str = None,
        custom_pattern: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        specify_url_pattern: str = None,
        directory: str = None,
        cache_ttl: int = None,
        ignore_cache_control: str = None,
        is_respect_server: str = None,
        ignore_letter_case: str = None,
        reload_manage: str = None,
        priority: int = None,
        request_header_field: str = None,
        value_request_header: str = None,
        ignore_authentication_header: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置"}
        self.data_id = data_id
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Exceptional url matching mode, except for some URLs: such as abc.jpg, do not do anti-theft chain function
        # E.g: ^https?://[^/]+/.*\.m3u8", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做内容重定向
        # 客户入参参考：^https?://[^/]+/.*\.m3u8"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Specify common types: Select the domain name that requires the cache  to be all files or the home page. :
        # E.g:
        # All: all files
        # Homepage: homepage", "zh_CN":"指定常用类型：选择缓存域名的是全部文件还是首页。入参参考值：
        # all：全部文件
        # homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"File Type: Specify the file type for cache settings.
        # File types include: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # If you need all types, pass all directly. Multiples are separated by semicolons, and all and specific file types cannot be configured at the same time.", "zh_CN":"文件类型：指定需要缓存的文件类型。
        # 文件类型包括：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # 如果需要全部类型，则直接传all。多个以分号隔开，all和具体文件类型不能同时配置。"}
        self.file_type = file_type
        # {"en":"Custom file type: Fill in the appropriate identifiable file type according to your needs outside of the specified file type. Can be used with file-type. If the file-type is also configured, the actual file type is the sum of the two parameters.", "zh_CN":"自定义文件类型：在指定文件类型外根据自身需求，填写适当的可识别文件类型。可以搭配file-type使用。如果file-type也有配置，实际生效的文件类型是两个入参的总和"}
        self.custom_file_type = custom_file_type
        # {"en":"Specify URL cache: Specify url according to requirements for cache
        # INS format does not support URI format with http(s)://", "zh_CN":"指定URL缓存：根据需求指定url进行缓存
        # 入参不支持含http(s):// 开头的URI格式"}
        self.specify_url_pattern = specify_url_pattern
        # {"en":"Directory: Specify the directory cache.
        # Enter a legal directory format. Multiple separated by semicolons", "zh_CN":"目录：指定目录缓存。
        # 输入合法的目录格式。多个以英文分号隔开"}
        self.directory = directory
        # {"en":"Cache time: set the time corresponding to the cache object
        # Input format: integer plus unit, such as 20s, 30m, 1h, 2d, no cache is set to 0. Do not enter the unit default is seconds
        # There is no upper limit on the cache time theory. This time is set according to the customer's own needs. If the customer feels that some of the files are not changed frequently, then the setting is longer. For example, the text class js, css, html, etc. can be set shorter, the picture, video and audio classes can be set longer (because the cache time will be replaced by the new file due to the file heat algorithm, the longest suggestion Do not exceed one month)", "zh_CN":"缓存时间：设置缓存对象对应的时间
        # 入参格式：整数加单位，比如20s、30m、1h、2d，不缓存设置为0。不输入单位默认是秒
        # 缓存时间理论上没有上限限制，这个时间根据客户自身的需求设定，如果客户觉得其中一些文件，变更不频繁，那么就设置长一点。例如，文本类的js，css，html等可以设置得短一些，图片、视频音频类的可以设置的长一点（因为缓存时间会因文件热度算法，旧文件会被新文件替换掉，最长建议不要超过一个月）"}
        self.cache_ttl = cache_ttl
        # {"en":"Ignore the source station does not cache the header. The optional values are true and false, which are used to ignore the two configurations of cache-control in the request header (private, no-cache) and the Authorization set by the client.
        # The ture indicates that the source station's settings for the three are ignored. Enables resources to be cached on the service node in the form of cache-control: public, and then our nodes can cache this type of resource and provide acceleration services.
        # False means that when the source station sets cache-control: private, cache-control: no-cache for a resource or specifies to cache according to authorization, our service node will not cache such files.", "zh_CN":"忽略源站不缓存头。可选值为true和false，用于忽略请求头中cache-control的两种配置（private，no-cache）和客户端设置的Authorization。
        # ture表示会忽略掉源站对于这三者的设定。使得资源能够以cache-control: public的方式缓存在服务节点上，然后我们的节点才能缓存这种类型的资源，提供加速服务。
        # false表示当源站对某种资源设定了cache-control: private,cache-control:no-cache或指定根据authorization进行缓存时，我们的服务节点将不会对此类文件进行缓存。"}
        self.ignore_cache_control = ignore_cache_control
        # {"en":"Respect the server: Accelerate whether to prioritize the source cache time.
        # Optional values: true and false
        # True: indicates that the server is time-first
        # False: The cache time of the CDN configuration takes precedence.", "zh_CN":"尊重服务端：加速是否要按源站缓存时间优先。
        # 可选值：true和false
        # true：表示重服务端时间优先
        # false:CDN配置的缓存时间优先"}
        self.is_respect_server = is_respect_server
        # {"en":"Ignore case, the optional value is true or false, true means to ignore case; false means not to ignore case;
        # When adding a new configuration item, the default is not true.", "zh_CN":"忽略大小写，可选值为true或false，true表示忽略大小写；false表示不忽略大小写；
        # 新增配置项时，不传默认为 true"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Reload processing rules, optional: ignore or if-modified-since
        # If-modified-since: indicates that you want to convert to if-modified-since
        # Ignore: means to ignore client refresh", "zh_CN":"reload处理规则，可选项：ignore或者if-modified-since
        # if-modified-since：表示要转成if-modified-since
        # ignore:表示忽略客户端刷新"}
        self.reload_manage = reload_manage
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"表示客户多组重定向内容的优先执行顺序。数字越大，优先级越高。
        # 新增配置项时，不传默认为 10
        # 如果传了值，不能为空"}
        self.priority = priority
        # {"en":"Request Header", "zh_CN":"请求头域"}
        self.request_header_field = request_header_field
        # {"en":"Request Header Value", "zh_CN":"请求头的值"}
        self.value_request_header = value_request_header
        # {"en":"You can set it 'true' to cache
        # ignoring the http header 'Authentication'.  If it is empty, the header is not ignored by default.", "zh_CN":"忽略鉴权头部Authentication，可选值为true和false。为空默认为不忽略。"}
        self.ignore_authentication_header = ignore_authentication_header

    def validate(self):
        self.validate_required(self.data_id, 'data_id')
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.except_path_pattern, 'except_path_pattern')
        self.validate_required(self.custom_pattern, 'custom_pattern')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.custom_file_type, 'custom_file_type')
        self.validate_required(self.specify_url_pattern, 'specify_url_pattern')
        self.validate_required(self.directory, 'directory')
        self.validate_required(self.cache_ttl, 'cache_ttl')
        self.validate_required(self.ignore_cache_control, 'ignore_cache_control')
        self.validate_required(self.is_respect_server, 'is_respect_server')
        self.validate_required(self.ignore_letter_case, 'ignore_letter_case')
        self.validate_required(self.reload_manage, 'reload_manage')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.request_header_field, 'request_header_field')
        self.validate_required(self.value_request_header, 'value_request_header')
        self.validate_required(self.ignore_authentication_header, 'ignore_authentication_header')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.custom_pattern is not None:
            result['custom-pattern'] = self.custom_pattern
        if self.file_type is not None:
            result['file-type'] = self.file_type
        if self.custom_file_type is not None:
            result['custom-file-type'] = self.custom_file_type
        if self.specify_url_pattern is not None:
            result['specify-url-pattern'] = self.specify_url_pattern
        if self.directory is not None:
            result['directory'] = self.directory
        if self.cache_ttl is not None:
            result['cache-ttl'] = self.cache_ttl
        if self.ignore_cache_control is not None:
            result['ignore-cache-control'] = self.ignore_cache_control
        if self.is_respect_server is not None:
            result['is-respect-server'] = self.is_respect_server
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.reload_manage is not None:
            result['reload-manage'] = self.reload_manage
        if self.priority is not None:
            result['priority'] = self.priority
        if self.request_header_field is not None:
            result['request-header-field'] = self.request_header_field
        if self.value_request_header is not None:
            result['value-request-header'] = self.value_request_header
        if self.ignore_authentication_header is not None:
            result['ignore-authentication-header'] = self.ignore_authentication_header
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('custom-pattern') is not None:
            self.custom_pattern = m.get('custom-pattern')
        if m.get('file-type') is not None:
            self.file_type = m.get('file-type')
        if m.get('custom-file-type') is not None:
            self.custom_file_type = m.get('custom-file-type')
        if m.get('specify-url-pattern') is not None:
            self.specify_url_pattern = m.get('specify-url-pattern')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('cache-ttl') is not None:
            self.cache_ttl = m.get('cache-ttl')
        if m.get('ignore-cache-control') is not None:
            self.ignore_cache_control = m.get('ignore-cache-control')
        if m.get('is-respect-server') is not None:
            self.is_respect_server = m.get('is-respect-server')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('reload-manage') is not None:
            self.reload_manage = m.get('reload-manage')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('request-header-field') is not None:
            self.request_header_field = m.get('request-header-field')
        if m.get('value-request-header') is not None:
            self.value_request_header = m.get('value-request-header')
        if m.get('ignore-authentication-header') is not None:
            self.ignore_authentication_header = m.get('ignore-authentication-header')
        return self


class QueryCacheTimeResponse(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: str = None,
        cache_time_behaviors: List[QueryCacheTimeResponseCacheTimeBehaviors] = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名"}
        self.domain_name = domain_name
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名id"}
        self.domain_id = domain_id
        self.cache_time_behaviors = cache_time_behaviors

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.cache_time_behaviors, 'cache_time_behaviors')
        if self.cache_time_behaviors:
            for k in self.cache_time_behaviors:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        if self.domain_id is not None:
            result['domain-id'] = self.domain_id
        if self.cache_time_behaviors is not None:
            result['cache-time-behaviors'] = []
            for k in self.cache_time_behaviors:
                result['cache-time-behaviors'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        if m.get('domain-id') is not None:
            self.domain_id = m.get('domain-id')
        if m.get('cache-time-behaviors') is not None:
            self.cache_time_behaviors = []
            for k in m.get('cache-time-behaviors'):
                temp_model = QueryCacheTimeResponseCacheTimeBehaviors()
                self.cache_time_behaviors.append(temp_model.from_map(k))
        return self


class QueryCacheTimePaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class QueryCacheTimeParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheTimeRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheTimeResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryDomainCertConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainCertConfigResponseData(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        certificate_id: int = None,
        tlsversion: str = None,
        enable_ocsp: str = None,
        cipher_suites: str = None,
    ):
        # {"en":"domain id", "zh_CN":"域名id"}
        self.domain_id = domain_id
        # {"en":"domain name", "zh_CN":"域名名称"}
        self.domain_name = domain_name
        # {"en":"The certificate ID you want to bind.", "zh_CN":"证书ID，为域名关联证书或换证书。请注意：置空时为取消关联证书。"}
        self.certificate_id = certificate_id
        # {"en":"TLS version. Optional values: SSLv3,TLSv1,TLSv1.1,TLSv1.2,TLSv1.3", "zh_CN":"TLS协议（TLSVersion），支持配置多个，英文分号分隔。可选值为: SSLv3、TLSv1、TLSv1.1、TLSv1.2、TLSv1.3。域名有配置证书时，该配置才有效。"}
        self.tlsversion = tlsversion
        # {"en":"Enable OCSP(Online Certificate Status Protocol).", "zh_CN":"支持OCSP，默认不启用，可选值true、false。域名有配置证书时，该配置才有效。"}
        self.enable_ocsp = enable_ocsp
        # {"en":"This optional object is used to specify a colon separated list of cipher suites which are permitted when clients negotiate security settings to access your content. Cipher suites which you can specify are: LOW, ALL:!LOW, HIGH, !EXPORT, !aNULL, !RC4, !DH, !SHA, !MD5, @STRENGTH,  AES128-SHA, AES256-SHA, AES128-SHA256, AES256-SHA256, AES128-GCM-SHA256, AES256-GCM-SHA384, ECDHE-RSA-AES128-SHA, ECDHE-RSA-AES256-SHA, ECDHE-RSA-AES128-SHA256, ECDHE-RSA-AES256-SHA384, ECDHE-RSA-AES128-GCM-SHA256, and ECDHE-RSA-AES256-GCM-SHA384. These cipher suites are a subset of those supported by OpenSSL, https://www.openssl.org/docs/man1.0.2/man1/ciphers.html. Please note that !MD5 or !SHA must appear after HIGH.", "zh_CN":"设置cipher加密套件，冒号分隔。请注意：系统已有默认的算法，如无特殊修改需要，无需调整。"}
        self.cipher_suites = cipher_suites

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.certificate_id, 'certificate_id')
        self.validate_required(self.tlsversion, 'tlsversion')
        self.validate_required(self.enable_ocsp, 'enable_ocsp')
        self.validate_required(self.cipher_suites, 'cipher_suites')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.certificate_id is not None:
            result['certificateId'] = self.certificate_id
        if self.tlsversion is not None:
            result['TLSVersion'] = self.tlsversion
        if self.enable_ocsp is not None:
            result['enableOCSP'] = self.enable_ocsp
        if self.cipher_suites is not None:
            result['cipherSuites'] = self.cipher_suites
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('certificateId') is not None:
            self.certificate_id = m.get('certificateId')
        if m.get('TLSVersion') is not None:
            self.tlsversion = m.get('TLSVersion')
        if m.get('enableOCSP') is not None:
            self.enable_ocsp = m.get('enableOCSP')
        if m.get('cipherSuites') is not None:
            self.cipher_suites = m.get('cipherSuites')
        return self


class QueryDomainCertConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryDomainCertConfigResponseData = None,
    ):
        # {"en":"Error code, which appears when HTTPStatus is not 202, represents the error type of the current request call", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, success when successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryDomainCertConfigResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryDomainCertConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryDomainCertConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainCertConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryDomainCertConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryLivestreamingTimestampAntihotlinkingConfigRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigResponseDataTimestampVisitControlRules(TeaModel):
    def __init__(
        self,
        cipher_param: str = None,
        time_param: str = None,
        secret_key: str = None,
        time_format: str = None,
        effective_time_mode: str = None,
        effective_time: int = None,
        tolerant_time: int = None,
        ciphe_combination: str = None,
        data_id: int = None,
    ):
        # {"en":"The name of the time parameter, and the default value is wsTime if no parameters are entered.", "zh_CN":"密文参数名称，未入参则默认值为wsSecret"}
        self.cipher_param = cipher_param
        # {"en":"The name of the time parameter, and the default value is wsTime if no parameters are entered.", "zh_CN":"时间参数名称，未入参则默认值为wsTime"}
        self.time_param = time_param
        # {"en":"The secret key", "zh_CN":"密钥"}
        self.secret_key = secret_key
        # {"en":"The encrypted time format, is required， with values of [UNIX timestamp] and [hex], corresponding to [UNIX timestamp] and [hex], respectively.", "zh_CN":"加密时间格式，必填，可选值为【UNIX timestamp】和【hex】，分别为【UNIX时间戳】、【16进制】。"}
        self.time_format = time_format
        # {"en":"Effective time method, optional values: duration, abstime, no verification.
        # 1. duration, means get effective time by duration. When this mode is set, effectiveTime is required.
        # 2. abstime, means get effective time by absolute time. Support a URL to be valid for a certain future time (the maximum 3652 days)
        # 3. No verification, means it will not verify the time. When this mode is set, effectiveTime will be cleared cleaned.", "zh_CN":"有效时间计算方式，可选值：duration、abstime、no verification
        # 1、duration，表示按时长。设置为“按时长”，则effectiveTime必填。
        # 2、abstime，表示按绝对时间。支持某个url到某个未来时间有效（最大支持3652天）
        # 3、no verification，表示不校验时间。则自动清空effectiveTime。"}
        self.effective_time_mode = effective_time_mode
        # {"en":"The effective length, unit second (s), positive integer,and value >=1", "zh_CN":"有效时长，单位秒（s），正整数，值要>=1。"}
        self.effective_time = effective_time
        # {"en":"The tolerance value, error time, unit second (s), positive integer and value >=1", "zh_CN":"容忍值，误差时间，单位秒（s），正整数，值要>=1"}
        self.tolerant_time = tolerant_time
        # {"en":"Ciphertext combination mode, with the following six optional values:
        # 
        # key+path+time
        # key+time+path
        # path+key+time
        # path+time+key
        # time+path+key
        # time+key+path", "zh_CN":"密文组合方式，可选值为以下六项：
        # 
        # key+path+time
        # key+time+path
        # path+key+time
        # path+time+key
        # time+path+key
        # time+key+path"}
        self.ciphe_combination = ciphe_combination
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.cipher_param, 'cipher_param')
        self.validate_required(self.time_param, 'time_param')
        self.validate_required(self.secret_key, 'secret_key')
        self.validate_required(self.time_format, 'time_format')
        self.validate_required(self.effective_time_mode, 'effective_time_mode')
        self.validate_required(self.effective_time, 'effective_time')
        self.validate_required(self.tolerant_time, 'tolerant_time')
        self.validate_required(self.ciphe_combination, 'ciphe_combination')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cipher_param is not None:
            result['cipherParam'] = self.cipher_param
        if self.time_param is not None:
            result['timeParam'] = self.time_param
        if self.secret_key is not None:
            result['secretKey'] = self.secret_key
        if self.time_format is not None:
            result['timeFormat'] = self.time_format
        if self.effective_time_mode is not None:
            result['effectiveTimeMode'] = self.effective_time_mode
        if self.effective_time is not None:
            result['effectiveTime'] = self.effective_time
        if self.tolerant_time is not None:
            result['tolerantTime'] = self.tolerant_time
        if self.ciphe_combination is not None:
            result['cipheCombination'] = self.ciphe_combination
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cipherParam') is not None:
            self.cipher_param = m.get('cipherParam')
        if m.get('timeParam') is not None:
            self.time_param = m.get('timeParam')
        if m.get('secretKey') is not None:
            self.secret_key = m.get('secretKey')
        if m.get('timeFormat') is not None:
            self.time_format = m.get('timeFormat')
        if m.get('effectiveTimeMode') is not None:
            self.effective_time_mode = m.get('effectiveTimeMode')
        if m.get('effectiveTime') is not None:
            self.effective_time = m.get('effectiveTime')
        if m.get('tolerantTime') is not None:
            self.tolerant_time = m.get('tolerantTime')
        if m.get('cipheCombination') is not None:
            self.ciphe_combination = m.get('cipheCombination')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigResponseData(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        timestamp_visit_control_rules: List[QueryLivestreamingTimestampAntihotlinkingConfigResponseDataTimestampVisitControlRules] = None,
    ):
        self.domain_id = domain_id
        self.domain_name = domain_name
        # {"en":"Streaming media anti-hotlinking configuration, parent tag
        # 1. This must be filled when the hotlinking configuration of streaming media needs to be set
        # 2. Empty the configuration for <timestampVisitControls/>", "zh_CN":"流媒体防盗链配置，父标签
        # 1.需要设置流媒体防盗链配置时，此项必填
        # 2.为<timestampVisitControls/>时清空配置"}
        self.timestamp_visit_control_rules = timestamp_visit_control_rules

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.timestamp_visit_control_rules, 'timestamp_visit_control_rules')
        if self.timestamp_visit_control_rules:
            for k in self.timestamp_visit_control_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.timestamp_visit_control_rules is not None:
            result['timestampVisitControlRules'] = []
            for k in self.timestamp_visit_control_rules:
                result['timestampVisitControlRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('timestampVisitControlRules') is not None:
            self.timestamp_visit_control_rules = []
            for k in m.get('timestampVisitControlRules'):
                temp_model = QueryLivestreamingTimestampAntihotlinkingConfigResponseDataTimestampVisitControlRules()
                self.timestamp_visit_control_rules.append(temp_model.from_map(k))
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryLivestreamingTimestampAntihotlinkingConfigResponseData = None,
        x_cnc_request_id: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 200, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"The response data", "zh_CN":"响应数据"}
        self.data = data
        # {"en":"Uniquely labeled id for querying each requested task (for all interfaces)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryLivestreamingTimestampAntihotlinkingConfigResponseData()
            self.data = temp_model.from_map(m['data'])
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryLivestreamingTimestampAntihotlinkingConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateLiveDomainHeaderRulesUpdateLiveDomainHeaderRulesRequestHeaderRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        header_name: str = None,
        header_type: str = None,
        action: str = None,
        header_value: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainHeaderRulesPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Header Name", "zh_CN":"头部名称"}
        self.header_name = header_name
        # {"en":"Header Type, Enum[clientReq, clientResp, originReq, originResp]", "zh_CN":"头部类型，可选值[clientReq, clientResp, originReq, originResp]"}
        self.header_type = header_type
        # {"en":"Operate Type, Enum[add, set, delete]", "zh_CN":"操作类型，可选值[add, set, delete]"}
        self.action = action
        # {"en":"Header Value", "zh_CN":"头部值"}
        self.header_value = header_value

    def validate(self):
        self.validate_required(self.header_name, 'header_name')
        self.validate_required(self.header_type, 'header_type')
        self.validate_required(self.action, 'action')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainHeaderRulesPaths'] = self.file_paths
        if self.header_name is not None:
            result['headerName'] = self.header_name
        if self.header_type is not None:
            result['headerType'] = self.header_type
        if self.action is not None:
            result['action'] = self.action
        if self.header_value is not None:
            result['headerValue'] = self.header_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainHeaderRulesPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainHeaderRulesPaths')
        if m.get('headerName') is not None:
            self.header_name = m.get('headerName')
        if m.get('headerType') is not None:
            self.header_type = m.get('headerType')
        if m.get('action') is not None:
            self.action = m.get('action')
        if m.get('headerValue') is not None:
            self.header_value = m.get('headerValue')
        return self


class UpdateLiveDomainHeaderRulesRequest(TeaModel):
    def __init__(
        self,
        header_rules: List[UpdateLiveDomainHeaderRulesUpdateLiveDomainHeaderRulesRequestHeaderRules] = None,
    ):
        # {"en":"Header Rules", "zh_CN":"HTTP头部控制"}
        self.header_rules = header_rules

    def validate(self):
        self.validate_required(self.header_rules, 'header_rules')
        if self.header_rules:
            for k in self.header_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.header_rules is not None:
            result['headerRules'] = []
            for k in self.header_rules:
                result['headerRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headerRules') is not None:
            self.header_rules = []
            for k in m.get('headerRules'):
                temp_model = UpdateLiveDomainHeaderRulesUpdateLiveDomainHeaderRulesRequestHeaderRules()
                self.header_rules.append(temp_model.from_map(k))
        return self


class UpdateLiveDomainHeaderRulesResponseData(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The preliminary deployment id", "zh_CN":"预部署id"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class UpdateLiveDomainHeaderRulesResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: UpdateLiveDomainHeaderRulesResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = UpdateLiveDomainHeaderRulesResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateLiveDomainHeaderRulesPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class UpdateLiveDomainHeaderRulesParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainHeaderRulesRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainHeaderRulesResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class AddBanUrltoDomianRequestIllegalInformation(TeaModel):
    def __init__(
        self,
        areas: List[str] = None,
        ban_urls: List[str] = None,
        method: str = None,
    ):
        # {"en":"Area code, mandatory field, like Global.", "zh_CN":"需要设置非法信息屏蔽的区域。则此项必填.支持多个。如设置全球，则输入 Global"}
        self.areas = areas
        # {"en":"URL", "zh_CN":"一个区域下配置需要非法信息屏蔽的url，如果某些区域有多个屏蔽url则有多组"}
        self.ban_urls = ban_urls
        # {"en":"Matching method, support fuzzy and precise, fuzzy match: fuzzy, precise match: exact.", "zh_CN":"匹配方式，支持模糊和精确；模糊入参为：fuzzy;精确匹配：exact
        # 如果没有传默认是exact"}
        self.method = method

    def validate(self):
        self.validate_required(self.areas, 'areas')
        self.validate_required(self.ban_urls, 'ban_urls')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.areas is not None:
            result['areas'] = self.areas
        if self.ban_urls is not None:
            result['ban-urls'] = self.ban_urls
        if self.method is not None:
            result['method'] = self.method
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('areas') is not None:
            self.areas = m.get('areas')
        if m.get('ban-urls') is not None:
            self.ban_urls = m.get('ban-urls')
        if m.get('method') is not None:
            self.method = m.get('method')
        return self


class AddBanUrltoDomianRequest(TeaModel):
    def __init__(
        self,
        customer_code: str = None,
        illegal_information: List[AddBanUrltoDomianRequestIllegalInformation] = None,
    ):
        # {"en":"Customer code", "zh_CN":"需要非法屏蔽的客户在我司设置的英文名"}
        self.customer_code = customer_code
        # {"en":"illegal information", "zh_CN":"非法信息屏蔽配置标签
        # 注意：表示需要设置非法信息屏蔽配置时，此项必填"}
        self.illegal_information = illegal_information

    def validate(self):
        self.validate_required(self.illegal_information, 'illegal_information')
        if self.illegal_information:
            for k in self.illegal_information:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customer_code is not None:
            result['customer-code'] = self.customer_code
        if self.illegal_information is not None:
            result['illegal-information'] = []
            for k in self.illegal_information:
                result['illegal-information'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('customer-code') is not None:
            self.customer_code = m.get('customer-code')
        if m.get('illegal-information') is not None:
            self.illegal_information = []
            for k in m.get('illegal-information'):
                temp_model = AddBanUrltoDomianRequestIllegalInformation()
                self.illegal_information.append(temp_model.from_map(k))
        return self


class AddBanUrltoDomianResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        location: str = None,
        cname: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The URL used to access the domain information, where domain-id is the unique token generated by our cloud platform for the domain name and whose value is a string.", "zh_CN":"响应信用于访问该域名信息的URL，其中domain-id为我司云平台为该域名生成的唯一标示，其值为字符串。"}
        self.location = location
        # {"en":"Service Domain assigned by the system, e.g. xxxx.cdn30.com", "zh_CN":"由自动生成的服务域名名称，例如：xxxx.cdn30.com"}
        self.cname = cname
        # {"en":"Error code. It will only have a value when the HTTP Status of response is not 202. ", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response message. When the request is successful, the response message is success.", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.location, 'location')
        self.validate_required(self.cname, 'cname')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.location is not None:
            result['location'] = self.location
        if self.cname is not None:
            result['cname'] = self.cname
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('location') is not None:
            self.location = m.get('location')
        if m.get('cname') is not None:
            self.cname = m.get('cname')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class AddBanUrltoDomianPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddBanUrltoDomianParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddBanUrltoDomianRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class AddBanUrltoDomianResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class EditDomainPropertyRequestOriginConfig(TeaModel):
    def __init__(
        self,
        origin_host: str = None,
        origin_ips: str = None,
        origin_port: str = None,
    ):
        # {"en":"Back to source host, not required", "zh_CN":"回源host，非必填"}
        self.origin_host = origin_host
        # {"en":"Source IP or domain name. 
        # 1. Support IPV4,IPV6.
        # 2. Multiple IPs are separated by semicolons, such as:1.1.1.1;2.2.2.2.
        # 3. Support single domain name.", "zh_CN":"源站Ip或者域名，非必填。
        # 1.支持IPV4,IPV6
        # 2.多个IP用分号隔开，如1.1.1.1;2.2.2.2
        # 3.支持单个域名"}
        self.origin_ips = origin_ips
        # {"en":"Origin port. Port range:(0-65535].", "zh_CN":"回源端口，非必填
        # 端口范围：(0-65535]"}
        self.origin_port = origin_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_host is not None:
            result['origin-host'] = self.origin_host
        if self.origin_ips is not None:
            result['origin-ips'] = self.origin_ips
        if self.origin_port is not None:
            result['origin-port'] = self.origin_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('origin-host') is not None:
            self.origin_host = m.get('origin-host')
        if m.get('origin-ips') is not None:
            self.origin_ips = m.get('origin-ips')
        if m.get('origin-port') is not None:
            self.origin_port = m.get('origin-port')
        return self


class EditDomainPropertyRequest(TeaModel):
    def __init__(
        self,
        origin_config: EditDomainPropertyRequestOriginConfig = None,
    ):
        # {"en":"Origin config.", "zh_CN":"回源配置"}
        self.origin_config = origin_config

    def validate(self):
        self.validate_required(self.origin_config, 'origin_config')
        if self.origin_config:
            self.origin_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.origin_config is not None:
            result['origin-config'] = self.origin_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('origin-config') is not None:
            temp_model = EditDomainPropertyRequestOriginConfig()
            self.origin_config = temp_model.from_map(m['origin-config'])
        return self


class EditDomainPropertyResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
    ):
        # {"en":"The error code, which appears when HTTPStatus is not 202, indicates the error type of the current request invocation", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class EditDomainPropertyPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class EditDomainPropertyParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditDomainPropertyRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class EditDomainPropertyResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryCacheKeyConfigurationRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheKeyConfigurationResponseCacheKeyRules(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        specify_url: str = None,
        full_match_4specify_url: str = None,
        custom_pattern: str = None,
        file_type: str = None,
        custom_file_type: str = None,
        directory: str = None,
        ignore_case: str = None,
        header_name: str = None,
        parameter_of_header: str = None,
        priority: str = None,
        data_id: int = None,
    ):
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Specify a uri, such as /test/specifyurl", "zh_CN":"指定具体的url，如/test/specifyurl"}
        self.specify_url = specify_url
        # {"en":"Whether to match specifyUrl exactly or not, you can select true and false.
        # True:means match exactly. False: means fuzzy match, such as specifyUrl='/test/uri', and  request for /test/uri?p=1 will be matched.", "zh_CN":"是否完全匹配specifyUrl，可选择为true和false。
        # 为true则完全匹配；为false则模糊匹配，如指定/test/uri，请求/test/uri?p=1也会匹配"}
        self.full_match_4specify_url = full_match_4specify_url
        # {"en":"Specify common types: Select the domain name that requires the cache to be all files or the home page. :
        # E.g:
        # All: all files
        # Homepage: homepage", "zh_CN":"指定常用类型：选择缓存域名的是全部文件还是首页。入参参考值： all：全部文件 homepage：首页"}
        self.custom_pattern = custom_pattern
        # {"en":"File Type: Specify the file type for cache settings.
        # File types include: gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf
        # If you need all types, pass all directly. Multiples are separated by semicolons, and all and specific file types cannot be configured at the same time.", "zh_CN":"文件类型：指定需要缓存的文件类型。 文件类型包括：gif png bmp jpeg jpg html htm shtml mp3 wma flv mp4 wmv zip exe rar css txt ico js swf 如果需要全部类型，则直接传all。多个以分号隔开，all和具体文件类型不能同时配置。"}
        self.file_type = file_type
        # {"en":"Custom file type: Fill in the appropriate identifiable file type according to your needs outside of the specified file type. Can be used with file-type. If the file-type is also configured, the actual file type is the sum of the two parameters.", "zh_CN":"自定义文件类型：在指定文件类型外根据自身需求，填写适当的可识别文件类型。可以搭配file-type使用。如果file-type也有配置，实际生效的文件类型是两个入参的总和"}
        self.custom_file_type = custom_file_type
        # {"en":"Directory: Specify the directory cache.
        # Enter a legal directory format. Multiple separated by semicolons", "zh_CN":"目录：指定目录缓存。 输入合法的目录格式。多个以英文分号隔开"}
        self.directory = directory
        # {"en":"Ignore case, the optional value is true or false, true means to ignore case; false means not to ignore case;
        # When adding a new configuration item, the default is true", "zh_CN":"是否忽略大小写：允许值为true和false，默认为忽略"}
        self.ignore_case = ignore_case
        # {"en":"Header name.
        # Example: If you specify a header as &lsquo;lang', Then, if the value of Lang is consistent, one copy will be cached", "zh_CN":"头部名称
        # 例如：指定头部lang，lang的值一致则缓存一份"}
        self.header_name = header_name
        # {"en":"Parameter Of the specified Header，
        # Example: Specifies the header as 'cookie', parameterOfHeader as 'name'. Then, if the value of name is consistent, one copy will be cached.", "zh_CN":"头部值的参数名，
        # 例如：指定头部Cookie，头部值的参数名为name。则name的值一致则缓存一份。"}
        self.parameter_of_header = parameter_of_header
        # {"en":"Indicates the priority execution order of multiple sets of redirected content by the customer. The higher the number, the higher the priority.
        # When adding a new configuration item, the default is 10", "zh_CN":"优先级，表示客户多组配置的优先执行顺序。数字越大，优先级越高。不传默认为10，不可清空。"}
        self.priority = priority
        # {"en":"DataId is to indicate a specific group configuration when the client has multiple groups of configurations. dataId can be retrieved through a query interface. Note: A. If dataId is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with dataId and others are not, then the expression of dataId is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of dataId. C. If the dataId is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the dataId must be filled in, and the value is the actual dataId, which means clearing the value of the corresponding dataId configuration item; it is not allowed that there is no specific configuration item or dataId in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。本功能只支持一组配置。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改该组配置项内容； b、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； c、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.path_pattern, 'path_pattern')
        self.validate_required(self.specify_url, 'specify_url')
        self.validate_required(self.full_match_4specify_url, 'full_match_4specify_url')
        self.validate_required(self.custom_pattern, 'custom_pattern')
        self.validate_required(self.file_type, 'file_type')
        self.validate_required(self.custom_file_type, 'custom_file_type')
        self.validate_required(self.directory, 'directory')
        self.validate_required(self.ignore_case, 'ignore_case')
        self.validate_required(self.header_name, 'header_name')
        self.validate_required(self.parameter_of_header, 'parameter_of_header')
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['pathPattern'] = self.path_pattern
        if self.specify_url is not None:
            result['specifyUrl'] = self.specify_url
        if self.full_match_4specify_url is not None:
            result['fullMatch4SpecifyUrl'] = self.full_match_4specify_url
        if self.custom_pattern is not None:
            result['customPattern'] = self.custom_pattern
        if self.file_type is not None:
            result['fileType'] = self.file_type
        if self.custom_file_type is not None:
            result['customFileType'] = self.custom_file_type
        if self.directory is not None:
            result['directory'] = self.directory
        if self.ignore_case is not None:
            result['ignoreCase'] = self.ignore_case
        if self.header_name is not None:
            result['headerName'] = self.header_name
        if self.parameter_of_header is not None:
            result['parameterOfHeader'] = self.parameter_of_header
        if self.priority is not None:
            result['priority'] = self.priority
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('pathPattern') is not None:
            self.path_pattern = m.get('pathPattern')
        if m.get('specifyUrl') is not None:
            self.specify_url = m.get('specifyUrl')
        if m.get('fullMatch4SpecifyUrl') is not None:
            self.full_match_4specify_url = m.get('fullMatch4SpecifyUrl')
        if m.get('customPattern') is not None:
            self.custom_pattern = m.get('customPattern')
        if m.get('fileType') is not None:
            self.file_type = m.get('fileType')
        if m.get('customFileType') is not None:
            self.custom_file_type = m.get('customFileType')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('ignoreCase') is not None:
            self.ignore_case = m.get('ignoreCase')
        if m.get('headerName') is not None:
            self.header_name = m.get('headerName')
        if m.get('parameterOfHeader') is not None:
            self.parameter_of_header = m.get('parameterOfHeader')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryCacheKeyConfigurationResponse(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        cache_key_rules: List[QueryCacheKeyConfigurationResponseCacheKeyRules] = None,
    ):
        # {"en":"Domain id", "zh_CN":"域名ID"}
        self.domain_id = domain_id
        # {"en":"Domain name", "zh_CN":"域名"}
        self.domain_name = domain_name
        # {"en":"Custom Cachekey Configuration, parent node
        # 1. When you need to configure the cachekey rules, this must be filled in.
        # 2. Configuration of clearing for <cacheKeyRules/>.", "zh_CN":"配置自定义缓存key功能。
        # 1.需要设置自定义缓存key配置时，此项必填
        # 2.为<cacheKeyRules/>时清空自定义缓存key配置"}
        self.cache_key_rules = cache_key_rules

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.cache_key_rules, 'cache_key_rules')
        if self.cache_key_rules:
            for k in self.cache_key_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.cache_key_rules is not None:
            result['cacheKeyRules'] = []
            for k in self.cache_key_rules:
                result['cacheKeyRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('cacheKeyRules') is not None:
            self.cache_key_rules = []
            for k in m.get('cacheKeyRules'):
                temp_model = QueryCacheKeyConfigurationResponseCacheKeyRules()
                self.cache_key_rules.append(temp_model.from_map(k))
        return self


class QueryCacheKeyConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryCacheKeyConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheKeyConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryCacheKeyConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigRequestCacheByRespheaders(TeaModel):
    def __init__(
        self,
        data_id: int = None,
        response_header: str = None,
        path_pattern: str = None,
        except_path_pattern: str = None,
        response_value: str = None,
        ignore_letter_case: str = None,
        priority: str = None,
        is_respheader: str = None,
    ):
        # {"en":"Add grid type identity, represents the customer multi - group configuration, a specific group of configuration", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置
        # 如果是新增一组配置项的值时，不需要传。如果指定修改具体data-id的配置项值时，需要传入对应配置项对应的data-id.可以通过查询接口获取"}
        self.data_id = data_id
        # {"en":"The name of the response header", "zh_CN":"响应头头部名称
        # 需要缓存的响应头名称。如Cache-Control"}
        self.response_header = response_header
        # {"en":"Url matching pattern, support fuzzy regular, if all match, the parameter can be configured as: *", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*"}
        self.path_pattern = path_pattern
        # {"en":"Exception to url matching pattern, except for some urls: abc.jpg, no content redirection", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做内容重定向
        # 客户入参参考：^https?://[^/]+/.*\.m3u8"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Header values.", "zh_CN":"头部值。"}
        self.response_value = response_value
        # {"en":"Ignore case, the optional value is true or false, true means ignore case;False means that case is not ignored.", "zh_CN":"忽略大小写，可选值为true或false，true表示忽略大小写；false表示不忽略大小写；
        # 新增配置项时，不传默认为 true"}
        self.ignore_letter_case = ignore_letter_case
        # {"en":"Represents the priority execution order for multiple groups of customer redirected content.The larger the number, the higher the priority.", "zh_CN":"表示客户多组重定向内容的优先执行顺序。数字越大，优先级越高。
        # 新增配置项时，不传默认为 10
        # 如果传了值，为清空配置"}
        self.priority = priority
        # {"en":"Whether the response header content cache file is allowed. An optional value of true or false indicates that the response header content cache file is allowed.False indicates that the response header content cache file is not allowed.", "zh_CN":"是否允许响应头内容缓存文件，可选值为true或false，true表示允许响应头内容缓存文件；false表示不允许响应头内容缓存文件；"}
        self.is_respheader = is_respheader

    def validate(self):
        self.validate_required(self.response_header, 'response_header')
        self.validate_required(self.response_value, 'response_value')
        self.validate_required(self.is_respheader, 'is_respheader')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['data-id'] = self.data_id
        if self.response_header is not None:
            result['response-header'] = self.response_header
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.response_value is not None:
            result['response-value'] = self.response_value
        if self.ignore_letter_case is not None:
            result['ignore-letter-case'] = self.ignore_letter_case
        if self.priority is not None:
            result['priority'] = self.priority
        if self.is_respheader is not None:
            result['is-respheader'] = self.is_respheader
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data-id') is not None:
            self.data_id = m.get('data-id')
        if m.get('response-header') is not None:
            self.response_header = m.get('response-header')
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('response-value') is not None:
            self.response_value = m.get('response-value')
        if m.get('ignore-letter-case') is not None:
            self.ignore_letter_case = m.get('ignore-letter-case')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('is-respheader') is not None:
            self.is_respheader = m.get('is-respheader')
        return self


class UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigRequest(TeaModel):
    def __init__(
        self,
        cache_by_respheaders: List[UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigRequestCacheByRespheaders] = None,
    ):
        # {"en":"Cache the file according to the response header content", "zh_CN":"根据响应头内容缓存文件
        # 注意：
        # 1、需要取消根据响应头内容缓存文件配置设置时，可以传入空节点<cache-by-repheaers></cache-by-repheaers>。
        # 2、表示需要设置根据响应头内容缓存文件配置时，此项必填"}
        self.cache_by_respheaders = cache_by_respheaders

    def validate(self):
        self.validate_required(self.cache_by_respheaders, 'cache_by_respheaders')
        if self.cache_by_respheaders:
            for k in self.cache_by_respheaders:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_by_respheaders is not None:
            result['cache-by-respheaders'] = []
            for k in self.cache_by_respheaders:
                result['cache-by-respheaders'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cache-by-respheaders') is not None:
            self.cache_by_respheaders = []
            for k in m.get('cache-by-respheaders'):
                temp_model = UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigRequestCacheByRespheaders()
                self.cache_by_respheaders.append(temp_model.from_map(k))
        return self


class UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('x-cnc-request-id') is not None:
            self.x_cnc_request_id = m.get('x-cnc-request-id')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        return self


class UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigPaths(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
    ):
        # {"en":"the domain whoes need query config", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain_name = domain_name

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domain-name'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain-name') is not None:
            self.domain_name = m.get('domain-name')
        return self


class UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCacheByUpdateCacheByResponseHeaderConfigResponseHeaderConfigRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCacheByResponseHeaderConfigResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateCloudStorageBasicConfigurationRequestCloudStorageRules(TeaModel):
    def __init__(
        self,
        storage_enabled: bool = None,
        access_key_id: str = None,
        access_key: str = None,
        storage_manage_domain: str = None,
        pull_address: str = None,
        notice_address: str = None,
        merge_notice: bool = None,
        publish_points: List[str] = None,
        data_id: int = None,
    ):
        # {"en":"This item is to open cloud storage. The optional vaules are true and false.", "zh_CN":"是否开启云存储，可选择为true、false"}
        self.storage_enabled = storage_enabled
        # {"en":"Access Key ID for uploading files.", "zh_CN":"上传文件密钥ID，Access Key ID"}
        self.access_key_id = access_key_id
        # {"en":"Secret Access Key for uploading files.", "zh_CN":"上传文件密钥，Secret Access Key"}
        self.access_key = access_key
        # {"en":"Management domain for cloud storage, used for recording / screenshot uploadingt, domain name format.", "zh_CN":"云存储的管理域名，用于录制/截图上传汇报，域名格式"}
        self.storage_manage_domain = storage_manage_domain
        # {"en":"The address of the pull tream domain. It needs to be configured with a full path in the format of http://domainname/, where the domain name is the matching  pull tream domain and must end with '/'", "zh_CN":"拉流域名地址，需要配置完整路径，格式为http://域名/，其中，域名为配套的拉流域名，必须以‘/’结束"}
        self.pull_address = pull_address
        # {"en":"Callback notification address, URL format", "zh_CN":"回调通知地址，url格式"}
        self.notice_address = notice_address
        # {"en":"Whether to notify after merging files.", "zh_CN":"是否合并通知，可选择为true、false"}
        self.merge_notice = merge_notice
        # {"en":"Setting publish point of pull push domain. This is parent Tag.
        # example:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。本功能只支持一组配置。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改该组配置项内容； b、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； c、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.storage_enabled, 'storage_enabled')
        self.validate_required(self.access_key_id, 'access_key_id')
        self.validate_required(self.access_key, 'access_key')
        self.validate_required(self.storage_manage_domain, 'storage_manage_domain')
        self.validate_required(self.pull_address, 'pull_address')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.storage_enabled is not None:
            result['storageEnabled'] = self.storage_enabled
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.access_key is not None:
            result['accessKey'] = self.access_key
        if self.storage_manage_domain is not None:
            result['storageManageDomain'] = self.storage_manage_domain
        if self.pull_address is not None:
            result['pullAddress'] = self.pull_address
        if self.notice_address is not None:
            result['noticeAddress'] = self.notice_address
        if self.merge_notice is not None:
            result['mergeNotice'] = self.merge_notice
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('storageEnabled') is not None:
            self.storage_enabled = m.get('storageEnabled')
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accessKey') is not None:
            self.access_key = m.get('accessKey')
        if m.get('storageManageDomain') is not None:
            self.storage_manage_domain = m.get('storageManageDomain')
        if m.get('pullAddress') is not None:
            self.pull_address = m.get('pullAddress')
        if m.get('noticeAddress') is not None:
            self.notice_address = m.get('noticeAddress')
        if m.get('mergeNotice') is not None:
            self.merge_notice = m.get('mergeNotice')
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class UpdateCloudStorageBasicConfigurationRequest(TeaModel):
    def __init__(
        self,
        cloud_storage_rules: List[UpdateCloudStorageBasicConfigurationRequestCloudStorageRules] = None,
    ):
        # {"en":"Recording Storage Configuration, parent node
        # 1. When you need to use the recording or screenshot function, this must be filled in.
        # 2. Configuration of clearing for <cloudStorageRules/>.", "zh_CN":"云存储配置，父标签
        # 1.需要设置录制/截图功能时，此项必填
        # 2.为<cloudStorageRules/>时清空配置"}
        self.cloud_storage_rules = cloud_storage_rules

    def validate(self):
        self.validate_required(self.cloud_storage_rules, 'cloud_storage_rules')
        if self.cloud_storage_rules:
            for k in self.cloud_storage_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cloud_storage_rules is not None:
            result['cloudStorageRules'] = []
            for k in self.cloud_storage_rules:
                result['cloudStorageRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cloudStorageRules') is not None:
            self.cloud_storage_rules = []
            for k in m.get('cloudStorageRules'):
                temp_model = UpdateCloudStorageBasicConfigurationRequestCloudStorageRules()
                self.cloud_storage_rules.append(temp_model.from_map(k))
        return self


class UpdateCloudStorageBasicConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: str = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 202, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            self.data = m.get('data')
        return self


class UpdateCloudStorageBasicConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"The domain whoes need query config.", "zh_CN":"需要查询配置的域名或域名id"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class UpdateCloudStorageBasicConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCloudStorageBasicConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCloudStorageBasicConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateLiveDomainHlsRequestSlices(TeaModel):
    def __init__(
        self,
        enable_hls: bool = None,
        m_3u_8seg_num: int = None,
        first_m3u_8seg_num: int = None,
        seg_duration: int = None,
        new_meta_seq_reset: bool = None,
    ):
        # {"en":"Enable HLS", "zh_CN":"是否启用HLS"}
        self.enable_hls = enable_hls
        # {"en":"M3u8 Seg Num", "zh_CN":"普通m3u8切片个数"}
        self.m_3u_8seg_num = m_3u_8seg_num
        # {"en":"First M3u8 Seg Num", "zh_CN":"首个m3u8切片个数"}
        self.first_m3u_8seg_num = first_m3u_8seg_num
        # {"en":"Seg Duration", "zh_CN":"切片间隔，单位秒"}
        self.seg_duration = seg_duration
        # {"en":"New Meta Seq Reset", "zh_CN":"收到新的metadata是否重置sequence"}
        self.new_meta_seq_reset = new_meta_seq_reset

    def validate(self):
        self.validate_required(self.enable_hls, 'enable_hls')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_hls is not None:
            result['enableHls'] = self.enable_hls
        if self.m_3u_8seg_num is not None:
            result['m3u8SegNum'] = self.m_3u_8seg_num
        if self.first_m3u_8seg_num is not None:
            result['firstM3u8SegNum'] = self.first_m3u_8seg_num
        if self.seg_duration is not None:
            result['segDuration'] = self.seg_duration
        if self.new_meta_seq_reset is not None:
            result['newMetaSeqReset'] = self.new_meta_seq_reset
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableHls') is not None:
            self.enable_hls = m.get('enableHls')
        if m.get('m3u8SegNum') is not None:
            self.m_3u_8seg_num = m.get('m3u8SegNum')
        if m.get('firstM3u8SegNum') is not None:
            self.first_m3u_8seg_num = m.get('firstM3u8SegNum')
        if m.get('segDuration') is not None:
            self.seg_duration = m.get('segDuration')
        if m.get('newMetaSeqReset') is not None:
            self.new_meta_seq_reset = m.get('newMetaSeqReset')
        return self


class UpdateLiveDomainHlsRequestCacheTimeRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        cache_time: str = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainHlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Cache Time", "zh_CN":"缓存时间，整数加单位，比如20s、30m、1h、2d"}
        self.cache_time = cache_time

    def validate(self):
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.cache_time, 'cache_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainHlsPaths'] = self.file_paths
        if self.cache_time is not None:
            result['cacheTime'] = self.cache_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainHlsPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainHlsPaths')
        if m.get('cacheTime') is not None:
            self.cache_time = m.get('cacheTime')
        return self


class UpdateLiveDomainHlsRequestQueryStringRules(TeaModel):
    def __init__(
        self,
        data_id: str = None,
        priority: int = None,
        url_regex: str = None,
        file_types: List[str] = None,
        file_paths: List[str] = None,
        ignore_query_string: bool = None,
        ignore_case: bool = None,
        query_string_2origin: bool = None,
    ):
        # {"en":"Add a grid type identifier to indicate a specific group configuration when the client has multiple groups of configurations.", "zh_CN":"添加grid类型标识，表示客户多组配置时，具体某组配置。
        # dataId可以通过查询接口获取。
        # 注意：添加grid类型标识：dataId，每一组配置对应一个dataId：
        # a、如果客户有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参；
        # b、如果客户入参多组配置，其中有些组配置有传dataId，有些没有传，则有传data-id的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置；
        # c、一个gird标签下的入参不能为空，如果，没有具体的配置项，则dataId必填，且值为实际存在的data-id,表示清空这个dataId对应配置项的值；"}
        self.data_id = data_id
        # {"en":"Priority", "zh_CN":"优先级"}
        self.priority = priority
        # {"en":"URL Regex", "zh_CN":"url匹配规则"}
        self.url_regex = url_regex
        # {"en":"File Types", "zh_CN":"文件类型"}
        self.file_types = file_types
        # {"en":"File UpdateLiveDomainHlsPaths", "zh_CN":"文件目录"}
        self.file_paths = file_paths
        # {"en":"Ignore Query String", "zh_CN":"是否去问号缓存"}
        self.ignore_query_string = ignore_query_string
        # {"en":"Ignore Case", "zh_CN":"是否忽略querystring大小写"}
        self.ignore_case = ignore_case
        # {"en":"Query String To Origin", "zh_CN":"回源是否带querystring"}
        self.query_string_2origin = query_string_2origin

    def validate(self):
        self.validate_required(self.priority, 'priority')
        self.validate_required(self.ignore_query_string, 'ignore_query_string')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data_id is not None:
            result['dataId'] = self.data_id
        if self.priority is not None:
            result['priority'] = self.priority
        if self.url_regex is not None:
            result['urlRegex'] = self.url_regex
        if self.file_types is not None:
            result['fileTypes'] = self.file_types
        if self.file_paths is not None:
            result['fileUpdateLiveDomainHlsPaths'] = self.file_paths
        if self.ignore_query_string is not None:
            result['ignoreQueryString'] = self.ignore_query_string
        if self.ignore_case is not None:
            result['ignoreCase'] = self.ignore_case
        if self.query_string_2origin is not None:
            result['queryString2Origin'] = self.query_string_2origin
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('urlRegex') is not None:
            self.url_regex = m.get('urlRegex')
        if m.get('fileTypes') is not None:
            self.file_types = m.get('fileTypes')
        if m.get('fileUpdateLiveDomainHlsPaths') is not None:
            self.file_paths = m.get('fileUpdateLiveDomainHlsPaths')
        if m.get('ignoreQueryString') is not None:
            self.ignore_query_string = m.get('ignoreQueryString')
        if m.get('ignoreCase') is not None:
            self.ignore_case = m.get('ignoreCase')
        if m.get('queryString2Origin') is not None:
            self.query_string_2origin = m.get('queryString2Origin')
        return self


class UpdateLiveDomainHlsRequest(TeaModel):
    def __init__(
        self,
        slices: UpdateLiveDomainHlsRequestSlices = None,
        cache_time_rules: List[UpdateLiveDomainHlsRequestCacheTimeRules] = None,
        query_string_rules: List[UpdateLiveDomainHlsRequestQueryStringRules] = None,
    ):
        # {"en":"Slices", "zh_CN":"多协议输出-HLS"}
        self.slices = slices
        # {"en":"Cache Time Rules", "zh_CN":"节点缓存-缓存时间配置"}
        self.cache_time_rules = cache_time_rules
        # {"en":"Query String Rules", "zh_CN":"节点缓存-带问号缓存配置"}
        self.query_string_rules = query_string_rules

    def validate(self):
        if self.slices:
            self.slices.validate()
        if self.cache_time_rules:
            for k in self.cache_time_rules:
                if k:
                    k.validate()
        if self.query_string_rules:
            for k in self.query_string_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.slices is not None:
            result['slices'] = self.slices.to_map()
        if self.cache_time_rules is not None:
            result['cacheTimeRules'] = []
            for k in self.cache_time_rules:
                result['cacheTimeRules'].append(k.to_map() if k else None)
        if self.query_string_rules is not None:
            result['queryStringRules'] = []
            for k in self.query_string_rules:
                result['queryStringRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('slices') is not None:
            temp_model = UpdateLiveDomainHlsRequestSlices()
            self.slices = temp_model.from_map(m['slices'])
        if m.get('cacheTimeRules') is not None:
            self.cache_time_rules = []
            for k in m.get('cacheTimeRules'):
                temp_model = UpdateLiveDomainHlsRequestCacheTimeRules()
                self.cache_time_rules.append(temp_model.from_map(k))
        if m.get('queryStringRules') is not None:
            self.query_string_rules = []
            for k in m.get('queryStringRules'):
                temp_model = UpdateLiveDomainHlsRequestQueryStringRules()
                self.query_string_rules.append(temp_model.from_map(k))
        return self


class UpdateLiveDomainHlsResponseData(TeaModel):
    def __init__(
        self,
        pre_deploy_id: str = None,
    ):
        # {"en":"The preliminary deployment id", "zh_CN":"预部署id"}
        self.pre_deploy_id = pre_deploy_id

    def validate(self):
        self.validate_required(self.pre_deploy_id, 'pre_deploy_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_deploy_id is not None:
            result['preDeployId'] = self.pre_deploy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preDeployId') is not None:
            self.pre_deploy_id = m.get('preDeployId')
        return self


class UpdateLiveDomainHlsResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: UpdateLiveDomainHlsResponseData = None,
    ):
        # {"en":"Error code. Appeared when http status is not 200.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Reponse message.", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"Response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = UpdateLiveDomainHlsResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateLiveDomainHlsPaths(TeaModel):
    def __init__(
        self,
        domain_id: int = None,
    ):
        # {"en":"", "zh_CN":"加速域名在系统中对应的ID
        # 1. 参看请求示例中的url，123344对应的就是domainId
        # 2. 可以通过【获取域名配置】和【获取域名列表】接口查询到domainId"}
        self.domain_id = domain_id

    def validate(self):
        self.validate_required(self.domain_id, 'domain_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        return self


class UpdateLiveDomainHlsParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainHlsRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateLiveDomainHlsResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class QueryScreenshotConfigurationRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryScreenshotConfigurationResponseDataScreenshotRules(TeaModel):
    def __init__(
        self,
        space_name: str = None,
        interval: int = None,
        width: int = None,
        high: int = None,
        overwrite: int = None,
        notice_address: str = None,
        publish_points: List[str] = None,
        data_id: int = None,
    ):
        # {"en":"Screenshot space name, this must be filled when screenshot is opened.", "zh_CN":"截图空间名，开启截图时，此项必填"}
        self.space_name = space_name
        # {"en":"Screenshot interval. This is required when screenshot is enabled.When configured, it must be >=5s, for example, 30, which means taking screenshots every 30s.", "zh_CN":"截图时间间隔，单位秒（s）；开启截图时，此项必填。配置时，必须>=5s。例如30，表示间隔30s截图一次。"}
        self.interval = interval
        # {"en":"Screenshot width resolution, not in the original resolution;Exceeding the original resolution also according to the original resolution.Note: the value should be <=2560.", "zh_CN":"截图宽度分辨率，未传入则按原始分辨率；超过原始分辨率也按原始分辨率。注：值要<=2560。"}
        self.width = width
        # {"en":"Screenshot height resolution, not in the original resolution;Exceeding the original resolution also according to the original resolution.Note: the value should be <=1440.", "zh_CN":"截图高度分辨率，未传入则按原始分辨率；超过原始分辨率也按原始分辨率。注：值要<=1440。"}
        self.high = high
        # {"en":"The optional values to override storage are true, false, true for override, and false for not override.When opening screenshot, this item must be filled in.", "zh_CN":"是否覆盖存储，可选值为true、false，true为覆盖，false为不覆盖。开启截图时，此项必填。
        # 注意：
        # 1.开启截图时，此项必填
        # 2.覆盖存储时，文件命名格式为“流名”
        # 3.非覆盖存储时，文件命名格式为“流名-时间戳”"}
        self.overwrite = overwrite
        # {"en":"Callback notification address, URL format.
        # Note:
        # The callback address that takes precedence over the [record/screenshot cloud storage configuration] interface configuration", "zh_CN":"回调通知地址，url格式
        # 注：优先于【录制/截图云存储配置】接口配置的回调地址；
        # 回调通知地址，url格式"}
        self.notice_address = notice_address
        # {"en":"Setting publish point of pull push domain. This is parent Tag.
        # example:
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>", "zh_CN":"设置直播推拉流域名的发布点，父标签，格式如：
        # <publishPoints>
        # <publishPoint>video</publishPoint>
        # <publishPoint>game</publishPoint>
        # </publishPoints>"}
        self.publish_points = publish_points
        # {"en":"Data-id is to indicate a specific group configuration when the client has multiple groups of configurations. Data-id can be retrieved through a query interface. Note: A. If data-id is passed, it means that one group of configuration items is specified to be modified, and no other group configuration items need to be modified. B. If multiple groups of configurations are included, some of them are configured with data-id and others are not, then the expression of data-id is used to modify a specific group of configurations, and a new group of configurations is added on the original basis without the expression of data-id. C. If the data-id is not transmitted, it means that the original configuration will be fully covered by this configuration. D. If no configuration parameter is passed, only domain name and secondary label are passed, which means that all configuration of domain name secondary service corresponding to this interface is cleared. E. If there is no specific configuration item in a set of configurations, the data-id must be filled in, and the value is the actual data-id, which means clearing the value of the corresponding data-id configuration item; it is not allowed that there is no specific configuration item or data-id in a set of configurations.", "zh_CN":"配置多组配置时，具体某组配置的id。dataId可以通过查询接口获取。 注意： a、如果有传dataId，说明指定修改其中一组配置项内容，不需求修改其他组配置内容不需要入参； b、如果入参多组配置，其中有些组配置有传dataId，有些没有传，则有传dataId的表示修改具体某组配置，没有传dataId的表示在原来基础上新增一组配置； c、如果入参都没有传dataId,表示用本次的配置全量覆盖原先配置； d、如果入参没有传任何配置项参数，只传了域名和二级标签，表示清空这个接口对应域名二级服务所有配置； e、如果一组配置没有具体的配置项，则dataId必填，且值为实际存在的dataId，表示清空这个dataId对应配置项的值；不允许一组配置没有具体的配置项也没有dataId。"}
        self.data_id = data_id

    def validate(self):
        self.validate_required(self.space_name, 'space_name')
        self.validate_required(self.interval, 'interval')
        self.validate_required(self.width, 'width')
        self.validate_required(self.high, 'high')
        self.validate_required(self.overwrite, 'overwrite')
        self.validate_required(self.notice_address, 'notice_address')
        self.validate_required(self.publish_points, 'publish_points')
        self.validate_required(self.data_id, 'data_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.space_name is not None:
            result['spaceName'] = self.space_name
        if self.interval is not None:
            result['interval'] = self.interval
        if self.width is not None:
            result['width'] = self.width
        if self.high is not None:
            result['high'] = self.high
        if self.overwrite is not None:
            result['overwrite'] = self.overwrite
        if self.notice_address is not None:
            result['noticeAddress'] = self.notice_address
        if self.publish_points is not None:
            result['publishPoints'] = self.publish_points
        if self.data_id is not None:
            result['dataId'] = self.data_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('spaceName') is not None:
            self.space_name = m.get('spaceName')
        if m.get('interval') is not None:
            self.interval = m.get('interval')
        if m.get('width') is not None:
            self.width = m.get('width')
        if m.get('high') is not None:
            self.high = m.get('high')
        if m.get('overwrite') is not None:
            self.overwrite = m.get('overwrite')
        if m.get('noticeAddress') is not None:
            self.notice_address = m.get('noticeAddress')
        if m.get('publishPoints') is not None:
            self.publish_points = m.get('publishPoints')
        if m.get('dataId') is not None:
            self.data_id = m.get('dataId')
        return self


class QueryScreenshotConfigurationResponseData(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_id: int = None,
        screenshot_rules: List[QueryScreenshotConfigurationResponseDataScreenshotRules] = None,
    ):
        # {"en":"Domain name", "zh_CN":"查询的域名名称"}
        self.domain_name = domain_name
        # {"en":"Domain id", "zh_CN":"查询的域名id"}
        self.domain_id = domain_id
        # {"en":"Recording Configuration, parent node 1. When you need to use the screenshot function, this must be filled in.  2. Configuration of clearing for <screenshotRules/>.", "zh_CN":"截图配置，父标签 1.需要设置截图配置时，此项必填 2.为<screenshotRules/>时清空配置 3.只支持jpg格式的截图"}
        self.screenshot_rules = screenshot_rules

    def validate(self):
        self.validate_required(self.domain_name, 'domain_name')
        self.validate_required(self.domain_id, 'domain_id')
        self.validate_required(self.screenshot_rules, 'screenshot_rules')
        if self.screenshot_rules:
            for k in self.screenshot_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.domain_id is not None:
            result['domainId'] = self.domain_id
        if self.screenshot_rules is not None:
            result['screenshotRules'] = []
            for k in self.screenshot_rules:
                result['screenshotRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('domainId') is not None:
            self.domain_id = m.get('domainId')
        if m.get('screenshotRules') is not None:
            self.screenshot_rules = []
            for k in m.get('screenshotRules'):
                temp_model = QueryScreenshotConfigurationResponseDataScreenshotRules()
                self.screenshot_rules.append(temp_model.from_map(k))
        return self


class QueryScreenshotConfigurationResponse(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        data: QueryScreenshotConfigurationResponseData = None,
    ):
        # {"en":"The error code, when HTTPStatus is not 200, indicates the type of error the current request is calling.", "zh_CN":"错误代码，当HTTPStatus不为200时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response information, when success is successful", "zh_CN":"响应信息，成功时为success"}
        self.message = message
        # {"en":"The response data", "zh_CN":"响应数据"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('data') is not None:
            temp_model = QueryScreenshotConfigurationResponseData()
            self.data = temp_model.from_map(m['data'])
        return self


class QueryScreenshotConfigurationPaths(TeaModel):
    def __init__(
        self,
        domain: str = None,
    ):
        # {"en":"Domain name or domain name id to query configuration", "zh_CN":"需要查询配置的域名（domainName）或域名id（domainId）"}
        self.domain = domain

    def validate(self):
        self.validate_required(self.domain, 'domain')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['domain'] = self.domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('domain') is not None:
            self.domain = m.get('domain')
        return self


class QueryScreenshotConfigurationParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryScreenshotConfigurationRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class QueryScreenshotConfigurationResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdatetimecontrolServiceRequestTimestampVisitControlRule(TeaModel):
    def __init__(
        self,
        path_pattern: str = None,
        except_path_pattern: str = None,
        protocol_of_path_pattern: str = None,
        directory: str = None,
        allowed_ips: str = None,
        ignore_uri_slash: str = None,
        ignore_key_and_time_position: str = None,
        encrypt_method: str = None,
        cipher_combination: str = None,
        secret_key: str = None,
        cipher_param: str = None,
        time_param: str = None,
        lower_limit_expiry_time: int = None,
        upper_limit_expiry_time: int = None,
        multiple_secret_keys: str = None,
        time_format: str = None,
        request_url_style: str = None,
        dst_style: int = None,
        log_format: str = None,
        url_key: str = None,
    ):
        # {"en":"The url matching mode supports fuzzy regularization. If all matches, the input parameters can be configured as: *.
        # Verify the time stamp of the matched URL for anti-leeching; reject URLs that are not matched.", "zh_CN":"url匹配模式，支持正则，如果是全部匹配，入参可以配置为：.*\
        # 对匹配到的URL进行时间戳防盗链验证；未匹配到的URL，则拒绝。"}
        self.path_pattern = path_pattern
        # {"en":"Exceptional url matching mode, except for some URLs: such as abc.jpg, do not do anti-theft chain function
        # ", "zh_CN":"例外的url匹配模式，某些URL除外：如abc.jpg，不做防盗链"}
        self.except_path_pattern = except_path_pattern
        # {"en":"Optional values are: http, https, http;https, noprefix, empty. If it is empty, it defaults to \"http;https\"; if it is noprefix, it means that the protocol prefix of url is not specified, and it only matches according to the regularity of path-pattern. This configuration item only matches with path-pattern. example: 1. Specify protocol-of-path-pattern=https and path-pattern=.* to match all https requests, but not http requests. 2. Specify protocol-of-path-pattern=http;https, path-pattern=.* to match all http and https requests. 3. Specify protocol-of-path-pattern=noprefix and path-pattern=^http://[^/]+/.* to match all http requests but not https requests.",
        #                               "zh_CN":"可选值为: http、https、http;https、noprefix、空。为空默认为\"http;https\"；为noprefix表示不指定url的协议前缀，仅按path-pattern的正则匹配。本配置项只与path-pattern（url匹配模式）结合匹配。 例子： 1、指定protocol-of-path-pattern=https，path-pattern=.*，则匹配所有https的请求，不匹配http的请求。 2、指定protocol-of-path-pattern=http;https，path-pattern=.*，则匹配所有http和https的请求。 3、指定protocol-of-path-pattern=noprefix，path-pattern=^http://[^/]+/.*，则匹配所有http的请求，不匹配https的请求。"}
        self.protocol_of_path_pattern = protocol_of_path_pattern
        # {"en":"Directory, multiple separated by English semicolons. Perform timestamp anti-leech verification for the matched directory; reject the unmatched directory. mutually exclusive with path-pattern.", "zh_CN":"目录，多个以英文分号隔开。对于匹配到的目录进行时间戳防盗链验证；未匹配到的则拒绝。和path-pattern互斥。"}
        self.directory = directory
        # {"en":"Exceptional IP, supports input of IP or IP range, separate IP ranges with semicolons (;), such as 1.1.1.0/24;2.2.2.2, some IP exceptions, no anti-leeching.
        # ", "zh_CN":"例外的IP，支持输入IP或IP段，IP段之间用分号(;)隔开，如1.1.1.0/24;2.2.2.2，某些IP例外，不做防盗链"}
        self.allowed_ips = allowed_ips
        # {"en":"Whether to remove / from $uri in anti-leech, the optional values are true or false, and the default is false, that is, it contains /. For example: http://www.test.com/1.flv, then $uri is /1.flv by default, if ignore-uri-slash is true, then $uri is 1.flv", "zh_CN":"防盗链中的$uri是否去掉/，可选值为true、false，默认为false，即包含/。 例如： http://www.test.com/1.flv，则$uri默认为/1.flv,若ignore-uri-slash为true，则$uri为1.flv"}
        self.ignore_uri_slash = ignore_uri_slash
        # {"en":"Whether key and time are allowed to be interchanged, the optional values are true and false, true is allowed, false is not allowed. By default, the order of key parameters and time parameters must strictly follow the order required by the authentication mode, that is, the default key and time cannot be interchanged. If true is selected, the key and time positions can be interchanged and the authentication succeeds.", "zh_CN":"key与time是否允许互换，可选值为true和false，true则允许，false则不允许。默认情况下，密钥参数和时间参数的顺序，必须严格参照鉴权模式要求的顺序，即，默认key和time不能互换位置。如选择true，key和time位置可以互换并鉴权成功。"}
        self.ignore_key_and_time_position = ignore_key_and_time_position
        # {"en":"Encryption Algorithm. Support value: md5sum
        # ", "zh_CN":"加密算法
        # 当前支持入参：md5sum"}
        self.encrypt_method = encrypt_method
        # {"en":"The anti-leech chain generation method, the parameters involved in the MD5 calculation and the combination sequence only support the following parameters: $uri: A string between domain and question mark, special values are configured in the input parameter <uri-select> For example http://cdn.example.com/v0/test.dat?k=v, the URI is /v0/test.dat $ourkey: secret key, the actual secret key is configured in the input parameter <secret-key> $time: time string $spec_name: file name For example: http://cdn.example.com/v0/test.dat?k=v, the file name is test.dat $args: the value of a specific key in QUERY_STRING Example: <cipher-combination>$uri$ourkey$time$args{k}</cipher-combination> Notice: 1. K in $args{k} only allows A-Z uppercase and lowercase letters, numbers, underscores, and bars 2. Except for $args, other parameters are only allowed to appear once 3. Each parameter can be spliced according to any combination order
        # ", "zh_CN":"防盗链生成方式，参与MD5计算的参数及组合顺序，仅支持传入以下参数：
        # $uri：介于domain和问号之间的字符串
        # 例如http://cdn.example.com/v0/test.dat?k=v，则URI为/v0/test.dat
        # $ourkey：秘钥，实际秘钥在入参<secret-key>中配置
        # $time：时间串
        # $spec_name：文件名
        # 例如：http://cdn.example.com/v0/test.dat?k=v，文件名为 test.dat
        # $args：QUERY_STRING中的某个具体key的值
        # 示例：<cipher-combination>$uri$ourkey$time$args{k}</cipher-combination>
        # 注意：
        # 1、$args{k}中的K只允许A-Z大小写字母、数字、下划线、横杠
        # 2、除了$args外，其它参数只允许出现1次
        # 3、可以按照任意组合顺序，拼接各个参数"}
        self.cipher_combination = cipher_combination
        # {"en":"The key of the anti-leech encryption string, only one key is allowed to be passed in Example: <secret-key>abcdef</secret-key> Notice: 1. For the secret key agreed with the customer, a value in <multiple-secret-keys> can be equal to the corresponding value of <secret-key> 2. The value of $ourkey mainly comes from the configuration of <secret-key> a) If <secret-key> is not a value in multiple-secret-keys>, the value of $ourkey is <multiple-secret-keys> b) <secret-key> is a value in multiple-secret-keys>, then the value of $ourkey is <secret-key> c) If <secret-key> is not passed or is empty, then the value of $ourkey is <multiple-secret-keys>
        # ", "zh_CN":"防盗链加密串的秘钥，只允许传入一个秘钥
        # 示例：<secret-key>abcdef</secret-key>
        # 注意：
        # 1、与客户约定好的秘钥，入参<multiple-secret-keys>中的某个值可以等于<secret-key>对应的值
        # 2、$ourkey值主要是来自<secret-key>的配置
        # a)如果<secret-key>不是multiple-secret-keys>中的某个值，则$ourkey值取<multiple-secret-keys>
        # b）<secret-key>是multiple-secret-keys>中的某个值，则$ourkey值取<secret-key>
        # c）如果<secret-key>没有传或者空值，则$ourkey值取<multiple-secret-keys>"}
        self.secret_key = secret_key
        # {"en":"Parameter name of the anti-leech string Example: <cipher-param>keyname</cipher-param> Notice: 1. If the anti-leech encryption string is in the parameter after the question mark in the url, the parameter name of the anti-leech encryption string is determined by the configuration of <cipher-param>; 2. If <cipher-param> is empty, the key is used as the parameter name in the URL of the default request
        # ", "zh_CN":"防盗链串的参数名称
        # 示例：<cipher-param>keyname</cipher-param>
        # 注意：
        # 1、如果防盗链加密串是在url问号后的参数中，则防盗链加密串的参数名由<cipher-param>的配置决定；
        # 2、如果<cipher-param>为空，则默认请求的url中使用key作为参数名"}
        self.cipher_param = cipher_param
        # {"en":"Parameter name for time string Example: <time-param>tname</time-param> Notice: 1. If the anti-leech time string is placed in the parameter after the url question mark, the parameter name of the anti-leech time string is determined by the configuration of <time-param>; 2. If <time-param> is empty, time is used as the parameter name in the URL of the default request
        # ", "zh_CN":"时间串的参数名称
        # 示例：<time-param>tname</time-param>
        # 注意：
        # 1、如果防盗链时间串是放在url问号后面的参数中，则防盗链时间串的参数名由<time-param>的配置决定；
        # 2、如果<time-param>为空，则默认请求的url中使用time作为参数名"}
        self.time_param = time_param
        # {"en":"The lower limit of the expiration time of the anti-leech chain Example: <lower-limit-expiry-time>200</lower-limit-expiry-time> The configuration methods corresponding to various scenarios are as follows: Notice: 1. If the timestamp carried in the request URL is the generation time of the URL, the expiration time needs to be added with the effective duration, that is, <lower-limit-expiry-time> and <upper-limit-expiry-time> are configured as the effective duration . 2. If the timestamp carried in the URL is the expiration time, it can be set to zero.
        # ", "zh_CN":"防盗链串的过期时间下限
        # 示例：
        # <lower-limit-expiry-time>200</lower-limit-expiry-time>
        # 对应各种场景的配置方式如下：
        # 注意：
        # 1、请求URL中携带的时间戳如果是URL的生成时间，需要加上有效时长才是过期时间，即<lower-limit-expiry-time>和<upper-limit-expiry-time>配置为有效时长。
        # 2、如果URL携带的时间戳是过期时间，则可以配成零。"}
        self.lower_limit_expiry_time = lower_limit_expiry_time
        # {"en":"The upper limit of the expiration time of the anti-leech chain Example: <upper-limit-expiry-time>5000</upper-limit-expiry-time> The configuration methods corresponding to various scenarios are as follows: Notice: 1. If the timestamp carried in the request URL is the generation time of the URL, the expiration time needs to be added with the effective duration, that is, <lower-limit-expiry-time> and <upper-limit-expiry-time> are configured as the effective duration . 2. If the timestamp carried in the URL is the expiration time, it can be set to zero.
        # ", "zh_CN":"防盗链串的过期时间上限
        # 示例：
        # <upper-limit-expiry-time>5000</upper-limit-expiry-time>
        # 对应各种场景的配置方式如下：
        # 注意：
        # 1、请求URL中携带的时间戳如果是URL的生成时间，需要加上有效时长才是过期时间，即<lower-limit-expiry-time>和<upper-limit-expiry-time>配置为有效时长。
        # 2、如果URL携带的时间戳是过期时间，则可以配成零。"}
        self.upper_limit_expiry_time = upper_limit_expiry_time
        # {"en":"Anti-leech encrypted string, multiple encrypted strings are supported, and multiple encrypted strings are separated by semicolons (;) Example: <multiple-secret-keys>abcdef;uvwxyz</multiple-secret-keys> Notice: 1. Support setting multiple keys for url anti-leech. Support customers to modify the key at will, and achieve seamless switching. The anti-theft chain level is higher. 2. As long as the key of the requested url is consistent with the key calculated from any of the encrypted strings, the verification will pass
        # ", "zh_CN":"防盗链加密串，支持多个加密串，多个加密串以分号(;)隔开
        # 示例：<multiple-secret-keys>abcdef;uvwxyz</multiple-secret-keys>
        # 注意：
        # 1、支持对url 防盗链设置多个密钥。支持客户任意修改密钥，并做到无缝切换。防盗链等级更高。
        # 2、请求url的key只要跟其中任意一个加密串算出来的key一致就验证通过"}
        self.multiple_secret_keys = multiple_secret_keys
        # {"en":"The time format of the anti-leech encryption string, multiple choices can be selected, separated by semicolons (;) Year|Month|Day|Hour|Minute|Second|UNIX timestamp|Hexadecimal timestamp|Timestamp in milliseconds: 1Y;2m;3d;4H;5M;6S;7s;8x Example: <time-format>1Y;2m;3d;4H;5M;6S;7s;8x</time-format> or <time-format>1Y;2m;3d;4H;5M;7s</time-format > Notice: 1. Must be English letters and numbers 2. Each value can only appear once
        # ", "zh_CN":"防盗链加密串时间格式，可多选，以分号(;)分隔
        # 年|月|日|时|分|秒|UNIX时间戳|16进制时间戳：1Y;2m;3d;4H;5M;6S;7s;8x
        # 示例：<time-format>1Y;2m;3d;4H;5M;6S;7s;8x</time-format> 或 <time-format>1Y;2m;3d;4H;5M;7s</time-format>
        # 注意：
        # 1、必须是英文字母和数字
        # 2、每个值只能出现1次
        # 3、如果配置的是16进制时间戳，则需要同时入参：UNIX时间戳|16进制时间戳"}
        self.time_format = time_format
        # {"en":"The anti-leech request url format supports two anti-leech methods, that is, the encrypted string and timestamp are placed after \"?\" or the encrypted string and timestamp are placed after \"host\". The parameters supported by the url format are as follows: $domain: domain name $uri: the url part that does not contain the domain name $key: MD5 value of anti-leech encrypted string $time: Anti-leech time string $args: the QUERY_STRING parameter after the question mark Example: The following request url format is supported, which can be replaced with https://. The url request protocol is based on actual use. If you don't know how to configure it correctly, please ask customer technical support for assistance; the parameter name carrying two values of encrypted string and time string\" keyname\" and \"tname\", which can be replaced by the actual parameter names used <request-url-style>http://$domain/$key/$time/$uri?$args</request-url-style> <request-url-style>http://$domain/$time/$key/$uri?$args</request-url-style> http://$domain/$uri?auth_key=$key <request-url-style>http://$domain/$uri?keyname=$key&tname=$time</request-url-style> <request-url-style>http://$domain/$uri?$args&keyname=$key&tname=$time</request-url-style> <request-url-style>http://$domain/$uri?keyname=$key&tname=$time&$args</request-url-style> <request-url-style>http://$domain/$uri?$args&keyname=$key&tname=$time&$args</request-url-style> <request-url-style>http://$domain/$uri?tname=$time&keyname=$key</request-url-style> <request-url-style>http://$domain/$uri?$args&tname=$time&keyname=$key</request-url-style> <request-url-style>http://$domain/$uri?tname=$time&keyname=$key&$args</request-url-style> <request-url-style>http://$domain/$uri?$args&tname=$time&keyname=$key&$args</request-url-style> Notice: 1. The input url must start with \"http/https\" 2. If the encrypted string and timestamp are placed after \"?\", the keyname and tname must be consistent with the configured values of <cipher-param> and <time-param> 3. If there is no configuration value for <cipher-param> and <time-param>, the parameter name corresponding to $key defaults to key, and the parameter name corresponding to $time defaults to time 4. If the anti-leech encryption string and time string are in the parameters behind the question mark in the url, the \"keyname\" and \"tname\" in the url correspond to the anti-leech string and time string parameter names configured in cipher-param and time-param.", "zh_CN":"防盗链请求url格式，支持两种防盗链方式，即加密串和时间戳放到“?”后面或者是加密串和时间戳放到“host”后面，url格式支持的参数如下：
        # $domain：域名
        # $uri：不包含域名的url部分
        # $key：防盗链加密串的MD5值
        # $time：防盗链时间串
        # $args：问号后的QUERY_STRING参数
        # 示例：支持以下请求url格式，可替换为https://，url请求协议根据实际使用，如不知道如何正确配置，请找客户技术支持协助；携带加密串和时间串两个值的参数名“keyname”和“tname”，可替换为实际使用的参数名
        # <request-url-style>http://$domain/$key/$time/$uri?$args</request-url-style>
        # <request-url-style>http://$domain/$time/$key/$uri?$args</request-url-style>
        #  http://$domain/$uri?auth_key=$key 
        # <request-url-style>http://$domain/$uri?keyname=$key&tname=$time</request-url-style>
        # <request-url-style>http://$domain/$uri?$args&keyname=$key&tname=$time</request-url-style>
        # <request-url-style>http://$domain/$uri?keyname=$key&tname=$time&$args</request-url-style>
        # <request-url-style>http://$domain/$uri?$args&keyname=$key&tname=$time&$args</request-url-style>
        # <request-url-style>http://$domain/$uri?tname=$time&keyname=$key</request-url-style>
        # <request-url-style>http://$domain/$uri?$args&tname=$time&keyname=$key</request-url-style>
        # <request-url-style>http://$domain/$uri?tname=$time&keyname=$key&$args</request-url-style>
        # <request-url-style>http://$domain/$uri?$args&tname=$time&keyname=$key&$args</request-url-style>
        # 注意：
        # 1、输入的url必须以“http/https”开头
        # 2、如果加密串和时间戳是放到“?”后面时，keyname和tname必须跟<cipher-param>和<time-param>配置的值一致
        # 3、如果<cipher-param>和<time-param>没有配置值，则$key对应的参数名默认为key，$time对应的参数名默认为time
        # 4、如果防盗链加密串和时间串在url问号后面的参数中，url中的“keyname”和“tname”，对应的是cipher-param和 time-param配置的防盗链串和时间串参数名称。"}
        self.request_url_style = request_url_style
        # {"en":"Anti-leech back-to-source method, optional values: 1 (use unencrypted url to go back to the source), 2 (use the customer request to return to the source with encrypted string url) Example: <dst-style>1<dst-style> Notice: 1. If the URL format is: http://www.xxx.com/md5/time/uri? parameter, please contact your technical support.
        # ", "zh_CN":"防盗链回源方式，可选值：1（使用未加密url回源）、2（使用客户请求带加密串url回源）
        # 示例：<dst-style>1<dst-style>
        # 注意：
        # 1、如果URL格式是：http://www.xxx.com/md5/time/uri?参数，则需要下工单给对应客服，让客服在父配置去掉时间戳格式再缓存。"}
        self.dst_style = dst_style
        # {"en":"Logging original url, optional values: true (logging original url), false (do not enable logging original url)
        # ", "zh_CN":" 日志记录原始url，可选值：true（日志记录原始url）、false（不开启日志记录原始url）"}
        self.log_format = log_format
        # {"en":"Used to configure the name of the key in the url Example: <url-key>auth_key</url-key>
        # ", "zh_CN":"用于配置获取url中的key的名称
        # 示例： <url-key>auth_key</url-key>"}
        self.url_key = url_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path_pattern is not None:
            result['path-pattern'] = self.path_pattern
        if self.except_path_pattern is not None:
            result['except-path-pattern'] = self.except_path_pattern
        if self.protocol_of_path_pattern is not None:
            result['protocol-of-path-pattern'] = self.protocol_of_path_pattern
        if self.directory is not None:
            result['directory'] = self.directory
        if self.allowed_ips is not None:
            result['allowed-ips'] = self.allowed_ips
        if self.ignore_uri_slash is not None:
            result['ignore-uri-slash'] = self.ignore_uri_slash
        if self.ignore_key_and_time_position is not None:
            result['ignore-key-and-time-position'] = self.ignore_key_and_time_position
        if self.encrypt_method is not None:
            result['encrypt-method'] = self.encrypt_method
        if self.cipher_combination is not None:
            result['cipher-combination'] = self.cipher_combination
        if self.secret_key is not None:
            result['secret-key'] = self.secret_key
        if self.cipher_param is not None:
            result['cipher-param'] = self.cipher_param
        if self.time_param is not None:
            result['time-param'] = self.time_param
        if self.lower_limit_expiry_time is not None:
            result['lower-limit-expiry-time'] = self.lower_limit_expiry_time
        if self.upper_limit_expiry_time is not None:
            result['upper-limit-expiry-time'] = self.upper_limit_expiry_time
        if self.multiple_secret_keys is not None:
            result['multiple-secret-keys'] = self.multiple_secret_keys
        if self.time_format is not None:
            result['time-format'] = self.time_format
        if self.request_url_style is not None:
            result['request-url-style'] = self.request_url_style
        if self.dst_style is not None:
            result['dst-style'] = self.dst_style
        if self.log_format is not None:
            result['log-format'] = self.log_format
        if self.url_key is not None:
            result['url-key'] = self.url_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path-pattern') is not None:
            self.path_pattern = m.get('path-pattern')
        if m.get('except-path-pattern') is not None:
            self.except_path_pattern = m.get('except-path-pattern')
        if m.get('protocol-of-path-pattern') is not None:
            self.protocol_of_path_pattern = m.get('protocol-of-path-pattern')
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('allowed-ips') is not None:
            self.allowed_ips = m.get('allowed-ips')
        if m.get('ignore-uri-slash') is not None:
            self.ignore_uri_slash = m.get('ignore-uri-slash')
        if m.get('ignore-key-and-time-position') is not None:
            self.ignore_key_and_time_position = m.get('ignore-key-and-time-position')
        if m.get('encrypt-method') is not None:
            self.encrypt_method = m.get('encrypt-method')
        if m.get('cipher-combination') is not None:
            self.cipher_combination = m.get('cipher-combination')
        if m.get('secret-key') is not None:
            self.secret_key = m.get('secret-key')
        if m.get('cipher-param') is not None:
            self.cipher_param = m.get('cipher-param')
        if m.get('time-param') is not None:
            self.time_param = m.get('time-param')
        if m.get('lower-limit-expiry-time') is not None:
            self.lower_limit_expiry_time = m.get('lower-limit-expiry-time')
        if m.get('upper-limit-expiry-time') is not None:
            self.upper_limit_expiry_time = m.get('upper-limit-expiry-time')
        if m.get('multiple-secret-keys') is not None:
            self.multiple_secret_keys = m.get('multiple-secret-keys')
        if m.get('time-format') is not None:
            self.time_format = m.get('time-format')
        if m.get('request-url-style') is not None:
            self.request_url_style = m.get('request-url-style')
        if m.get('dst-style') is not None:
            self.dst_style = m.get('dst-style')
        if m.get('log-format') is not None:
            self.log_format = m.get('log-format')
        if m.get('url-key') is not None:
            self.url_key = m.get('url-key')
        return self


class UpdatetimecontrolServiceRequest(TeaModel):
    def __init__(
        self,
        timestamp_visit_control_rule: UpdatetimecontrolServiceRequestTimestampVisitControlRule = None,
    ):
        # {"en":"", "zh_CN":"时间戳防盗链设置
        # 注意：
        # 1、时间戳防盗链分为两部分，一部分是防盗链校验，一部分是时间有效性校验。二者都有效，则防盗链通过，否则不通过。
        # 2、防盗链校验：加密算法为md5sum，按照参与MD5计算的参数及组合顺序进行防盗链加密串的计算，对匹配目录下所有文件的url进行防盗链校验，未匹配到的url，则拒绝访问。
        # 3、时间有效性检验：按照年月日时分秒换算的当前时间，与请求url中所带的名文时间相减，判断是否超过设置的上下限（即前后60s内），时间差小于设置上下限的，系统才会给予正常的响应，否则拒绝请求，返回403
        # 4、日志记录没有带加密串的url
        # 6、需要清空时间戳防盗链规则时，可以只传入节点<timestamp-visit-control-rule></timestamp-visit-control-rule>"}
        self.timestamp_visit_control_rule = timestamp_visit_control_rule

    def validate(self):
        self.validate_required(self.timestamp_visit_control_rule, 'timestamp_visit_control_rule')
        if self.timestamp_visit_control_rule:
            self.timestamp_visit_control_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp_visit_control_rule is not None:
            result['timestamp-visit-control-rule'] = self.timestamp_visit_control_rule.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('timestamp-visit-control-rule') is not None:
            temp_model = UpdatetimecontrolServiceRequestTimestampVisitControlRule()
            self.timestamp_visit_control_rule = temp_model.from_map(m['timestamp-visit-control-rule'])
        return self


class UpdatetimecontrolServiceResponse(TeaModel):
    def __init__(
        self,
        http_status: int = None,
        x_cnc_request_id: str = None,
        code: str = None,
        message: str = None,
    ):
        # {"en":"httpstatus=202; Indicates that the new domain API was successfully invoked, and the current deployment of the new domain can be viewed using x-cnc-request-id in the header", "zh_CN":"httpstatus=202;   表示成功调用新增域名接口，可使用header中的x-cnc-request-id查看当前新增域名的部署情况"}
        self.http_status = http_status
        # {"en":"Uniquely identified id for querying tasks per request (for all API)", "zh_CN":"唯一标示的id，用于查询每次请求的任务 （适用全部接口）"}
        self.x_cnc_request_id = x_cnc_request_id
        # {"en":"Error code. It pops up when the HTTPStatus is not 202, and shows the revoking error type of the current request.", "zh_CN":"错误代码，当HTTPStatus不为202时出现，表示当前请求调用的错误类型"}
        self.code = code
        # {"en":"Response message, and shows as success when it succeeds.", "zh_CN":"响应信息，成功时为success"}
        self.message = message

    def validate(self):
        self.validate_required(self.http_status, 'http_status')
        self.validate_required(self.x_cnc_request_id, 'x_cnc_request_id')
        self.validate_required(self.code, 'code')
        self.validate_required(self.message, 'message')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_status is not None:
            result['http status code'] = self.http_status
        if self.x_cnc_request_id is not None:
            result['x-cnc-request-id'] = self.x_cnc_request_id
        if self.code is not None:
            result['code'] = self.code
        if self.message is not None:
            result['message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('http status code') is not None:
            self.http_status = m.get('http status code')
        if m.get('