# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel  
from typing import Dict, List



class DeleteClusterCrdResourceRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteClusterCrdResourceStatusDetails(TeaModel):
    def __init__(
        self,
        name: str = None,
        kind: str = None,
        group: str = None,
        uid: str = None,
    ):
        # {"en":"The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)", "zh_CN":"与状态 StatusReason 关联的资源的名称属性（当有一个可以描述的名称时）"}
        self.name = name
        # {"en":"The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind", "zh_CN":"与状态 StatusReason 关联的资源的种类属性"}
        self.kind = kind
        # {"en":"The group attribute of the resource associated with the status StatusReason", "zh_CN":"与状态 StatusReason 关联的资源的组属性"}
        self.group = group
        # {"en":"UID of the resource. (when there is a single resource which can be described)", "zh_CN":"资源的 UID（当有单个可以描述的资源时）"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.group, 'group')
        self.validate_required(self.uid, 'uid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.kind is not None:
            result['kind'] = self.kind
        if self.group is not None:
            result['group'] = self.group
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class DeleteClusterCrdResourceStatus(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        status: str = None,
        code: int = None,
        details: DeleteClusterCrdResourceStatusDetails = None,
    ):
        # {"en":"APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values", "zh_CN":"APIVersion 定义对象表示的版本化模式。 服务器应将已识别的模式转换为最新的内部值，并可能拒绝无法识别的值"}
        self.api_version = api_version
        # {"en":"Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase", "zh_CN":"Kind 是一个字符串值，表示此对象表示的 REST 资源。 服务器可以从客户端提交请求的端点推断出这一点。 无法更新。驼峰式规则"}
        self.kind = kind
        # {"en":"DeleteClusterCrdResourceStatus of the operation. One of: 'Success' or 'Failure'", "zh_CN":"操作状态。“Success”或“Failure” 之一"}
        self.status = status
        # {"en":"Suggested HTTP return code for this status, 0 if not set", "zh_CN":"此状态的建议 HTTP 返回代码，如果未设置，则为 0"}
        self.code = code
        # {"en":"Extended data associated with the reason. Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type", "zh_CN":"与原因（Reason）相关的扩展数据。每个原因都可以定义自己的扩展细节。 此字段是可选的，并且不保证返回的数据符合任何模式，除非由原因类型定义"}
        self.details = details

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.status, 'status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.details, 'details')
        if self.details:
            self.details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.status is not None:
            result['status'] = self.status
        if self.code is not None:
            result['code'] = self.code
        if self.details is not None:
            result['details'] = self.details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('details') is not None:
            temp_model = DeleteClusterCrdResourceStatusDetails()
            self.details = temp_model.from_map(m['details'])
        return self


class DeleteClusterCrdResourceResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: DeleteClusterCrdResourceStatus = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"status", "zh_CN":"status"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = DeleteClusterCrdResourceStatus()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteClusterCrdResourcePaths(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # {"en":"crdResource name", "zh_CN":"crdResource 名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class DeleteClusterCrdResourceParameters(TeaModel):
    def __init__(
        self,
        kind: str = None,
        group: str = None,
        version: str = None,
    ):
        # {"en":"crdResource kind", "zh_CN":"crdResource 类型"}
        self.kind = kind
        # {"en":"crdResource group", "zh_CN":"crdResource 组"}
        self.group = group
        # {"en":"crdResource version", "zh_CN":"crdResource 版本号"}
        self.version = version

    def validate(self):
        self.validate_required(self.kind, 'kind')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.kind is not None:
            result['kind'] = self.kind
        if self.group is not None:
            result['group'] = self.group
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class DeleteClusterCrdResourceRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteClusterCrdResourceResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class ListJobRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        fields_type: str = None,
        fields_v1: Dict[str, Any] = None,
        manager: str = None,
        operation: str = None,
        time: str = None,
    ):
        # {"en": "APIVersion defines the version of this resource that this field set applies to. The format is group/version just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.", "zh_CN": "apiVersion 定义此字段集适用的资源的版本。 格式是 “group/version”，就像顶级 apiVersion 字段一样。 必须跟踪字段集的版本，因为它不能自动转换"}
        self.api_version = api_version
        # {"en": "FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: FieldsV1", "zh_CN": "FieldsType 是不同字段格式和版本的鉴别器。 目前只有一个可能的值：“FieldsV1”"}
        self.fields_type = fields_type
        # {"en": "FieldsV1 holds the first JSON version format as described in the FieldsV1 type.", "zh_CN": "FieldsV1 包含类型 “FieldsV1” 中描述的第一个 JSON 版本格式"}
        self.fields_v1 = fields_v1
        # {"en": "Manager is an identifier of the workflow managing these fields.", "zh_CN": "管理这些字段的工作流的标识符"}
        self.manager = manager
        # {"en": "Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.", "zh_CN": "导致创建此 managedFields 表项的操作类型。 此字段的仅有合法值是 “Apply” 和 “Update”"}
        self.operation = operation
        # {"en": "Time is timestamp of when these fields were set. It should always be empty if Operation is 'Apply'", "zh_CN": "添加 managedFields 条目时的时间戳。 如果一个字段被添加、管理器更新任一所属字段值或移除一个字段，该时间戳也会更新。 从此条目中移除一个字段时该时间戳不会更新，因为另一个管理器将它接管了"}
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.fields_type is not None:
            result['fieldsType'] = self.fields_type
        if self.fields_v1 is not None:
            result['fieldsV1'] = self.fields_v1
        if self.manager is not None:
            result['manager'] = self.manager
        if self.operation is not None:
            result['operation'] = self.operation
        if self.time is not None:
            result['time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('fieldsType') is not None:
            self.fields_type = m.get('fieldsType')
        if m.get('fieldsV1') is not None:
            self.fields_v1 = m.get('fieldsV1')
        if m.get('manager') is not None:
            self.manager = m.get('manager')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('time') is not None:
            self.time = m.get('time')
        return self


class ListJobIoK8sApimachineryPkgApisMetaV1OwnerReference(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        block_owner_deletion: bool = None,
        controller: bool = None,
        kind: str = None,
        name: str = None,
        uid: str = None,
    ):
        # {"en": "API version of the referent.", "zh_CN": "被引用资源的 API 版本"}
        self.api_version = api_version
        # {"en": "If true, AND if the owner has the foregroundDeletion finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs delete permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.", "zh_CN": "如果为 true，**并且** 如果属主具有 “foregroundDeletion” 终结器，则在删除此引用之前，无法从键值存储中删除属主。 默认为 false。要设置此字段，用户需要属主的 “delete” 权限， 否则将返回 422 (Unprocessable Entity)"}
        self.block_owner_deletion = block_owner_deletion
        # {"en": "If true, this reference points to the managing controller.", "zh_CN": "如果为 true，则此引用指向管理的控制器"}
        self.controller = controller
        # {"en": "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds", "zh_CN": "被引用资源的类别"}
        self.kind = kind
        # {"en": "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids", "zh_CN": "被引用资源的 uid"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')
        self.validate_required(self.uid, 'uid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.block_owner_deletion is not None:
            result['blockOwnerDeletion'] = self.block_owner_deletion
        if self.controller is not None:
            result['controller'] = self.controller
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('blockOwnerDeletion') is not None:
            self.block_owner_deletion = m.get('blockOwnerDeletion')
        if m.get('controller') is not None:
            self.controller = m.get('controller')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta(TeaModel):
    def __init__(
        self,
        annotations: Dict[str, Any] = None,
        cluster_name: str = None,
        creation_timestamp: str = None,
        deletion_grace_period_seconds: int = None,
        deletion_timestamp: str = None,
        finalizers: List[str] = None,
        generate_name: str = None,
        generation: int = None,
        labels: Dict[str, Any] = None,
        managed_fields: List[ListJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry] = None,
        name: str = None,
        namespace: str = None,
        owner_references: List[ListJobIoK8sApimachineryPkgApisMetaV1OwnerReference] = None,
        resource_version: str = None,
        self_link: str = None,
        uid: str = None,
    ):
        # {"en": "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations", "zh_CN": "annotations 是一个非结构化的键值映射，存储在资源中，可以由外部工具设置以存储和检索任意元数据。 它们不可查询，在修改对象时应保留"}
        self.annotations = annotations
        # {"en": "The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.", "zh_CN": "对象所属集群的名称。用于区分不同集群中具有相同名称和namespace的资源。这个字段现在没有在任何地方设置，如果在创建或更新请求中设置，apisserver将忽略它"}
        self.cluster_name = cluster_name
        # {"en": "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "creationTimestamp 是一个时间戳，表示创建此对象时的服务器时间。 不能保证在单独的操作中按发生前的顺序设置。 客户端不得设置此值。它以 RFC3339 形式表示，并采用 UTC。由系统填充。只读。列表为空"}
        self.creation_timestamp = creation_timestamp
        # {"en": "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.", "zh_CN": "此对象从系统中删除之前允许正常终止的秒数。 仅当设置了 deletionTimestamp 时才设置。 只能缩短。只读"}
        self.deletion_grace_period_seconds = deletion_grace_period_seconds
        # {"en": "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "deletionTimestamp 是删除此资源的 RFC 3339 日期和时间。 该字段在用户请求体面删除时由服务器设置，客户端不能直接设置。 一旦 finalizers 列表为空，该资源预计将在此字段中的时间之后被删除 （不再从资源列表中可见，并且无法通过名称访问）。 只要 finalizers 列表包含项目，就阻止删除。一旦设置了 deletionTimestamp， 该值可能不会被取消设置或在未来进一步设置，尽管它可能会缩短或在此时间之前可能会删除资源。 例如，用户可能要求在 30 秒内删除一个 Pod。 Kubelet 将通过向 Pod 中的容器发送体面的终止信号来做出反应。 30 秒后，Kubelet 将向容器发送硬终止信号（SIGKILL）， 并在清理后从 API 中删除 Pod。在网络存在分区的情况下， 此对象可能在此时间戳之后仍然存在，直到管理员或自动化进程可以确定资源已完全终止。 如果未设置，则未请求体面删除该对象。请求体面删除时由系统填充。只读"}
        self.deletion_timestamp = deletion_timestamp
        # {"en": "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.", "zh_CN": "在从注册表中删除对象之前该字段必须为空。 每个条目都是负责的组件的标识符，各组件将从列表中删除自己对应的条目。 如果对象的 deletionTimestamp 非空，则只能删除此列表中的条目。 终结器可以按任何顺序处理和删除。没有按照顺序执行， 因为它引入了终结器卡住的重大风险。finalizers 是一个共享字段， 任何有权限的参与者都可以对其进行重新排序。如果按顺序处理终结器列表， 那么这可能导致列表中第一个负责终结器的组件正在等待列表中靠后负责终结器的组件产生的信号（字段值、外部系统或其他）， 从而导致死锁。在没有强制排序的情况下，终结者可以在它们之间自由排序， 并且不容易受到列表中排序更改的影响"}
        self.finalizers = finalizers
        # {"en": "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency", "zh_CN": "generateName 是一个可选前缀，由服务器使用，仅在未提供 name 字段时生成唯一名称。 如果使用此字段，则返回给客户端的名称将与传递的名称不同。该值还将与唯一的后缀组合。 提供的值与 name 字段具有相同的验证规则，并且可能会根据所需的后缀长度被截断，以使该值在服务器上唯一。如果指定了此字段并且生成的名称存在，则服务器将不会返回 409 ——相反，它将返回 201 Created 或 500， 原因是 ServerTimeout 指示在分配的时间内找不到唯一名称，客户端应重试（可选，在 Retry-After 标头中指定的时间之后）。仅在未指定 name 时应用"}
        self.generate_name = generate_name
        # {"en": "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.", "zh_CN": "表示期望状态的特定生成的序列号。由系统填充。只读"}
        self.generation = generation
        # {"en": "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels", "zh_CN": "可用于组织和分类（确定范围和选择）对象的字符串键和值的映射。 可以匹配 ReplicationController 和 Service 的选择算符"}
        self.labels = labels
        # {"en": "ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like ci-cd. The set of fields is always in the version that the workflow used when modifying the object.", "zh_CN": "managedFields 将 workflow-id 和版本映射到由该工作流管理的字段集。 这主要用于内部管理，用户通常不需要设置或理解该字段。 工作流可以是用户名、控制器名或特定应用路径的名称，如 “ci-cd”。 字段集始终存在于修改对象时工作流使用的版本"}
        self.managed_fields = managed_fields
        # {"en": "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names", "zh_CN": "name 在命名空间内必须是唯一的。创建资源时需要，尽管某些资源可能允许客户端请求自动地生成适当的名称。 名称主要用于创建幂等性和配置定义。无法更新"}
        self.name = name
        # {"en": "Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the default namespace, but default is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces", "zh_CN": "namespace 定义了一个值空间，其中每个名称必须唯一。空命名空间相当于 “default” 命名空间，但 “default” 是规范表示。 并非所有对象都需要限定在命名空间中——这些对象的此字段的值将为空。必须是 DNS_LABEL。无法更新"}
        self.namespace = namespace
        # {"en": "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.", "zh_CN": "此对象所依赖的对象列表。如果列表中的所有对象都已被删除，则该对象将被垃圾回收。 如果此对象由控制器管理，则此列表中的条目将指向此控制器，controller 字段设置为 true。 管理控制器不能超过一个"}
        self.owner_references = owner_references
        # {"en": "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency", "zh_CN": "一个不透明的值，表示此对象的内部版本，客户端可以使用该值来确定对象是否已被更改。 可用于乐观并发、变更检测以及对资源或资源集的监听操作。 客户端必须将这些值视为不透明的，且未更改地传回服务器。 它们可能仅对特定资源或一组资源有效。由系统填充。只读。客户端必须将值视为不透明"}
        self.resource_version = resource_version
        # {"en": "SelfLink is a URL representing this object. Populated by the system. Read-only.DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.", "zh_CN": "selfLink 是表示此对象的 URL。由系统填充。只读。已弃用。Kubernetes 将在 1.20 版本中停止传播该字段，并计划在 1.21 版本中删除该字段"}
        self.self_link = self_link
        # {"en": "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids", "zh_CN": "UID 是该对象在时间和空间上的唯一值。它通常由服务器在成功创建资源时生成，并且不允许使用 PUT 操作更改。由系统填充。只读"}
        self.uid = uid

    def validate(self):
        if self.managed_fields:
            for k in self.managed_fields:
                if k:
                    k.validate()
        if self.owner_references:
            for k in self.owner_references:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['annotations'] = self.annotations
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.creation_timestamp is not None:
            result['creationTimestamp'] = self.creation_timestamp
        if self.deletion_grace_period_seconds is not None:
            result['deletionGracePeriodSeconds'] = self.deletion_grace_period_seconds
        if self.deletion_timestamp is not None:
            result['deletionTimestamp'] = self.deletion_timestamp
        if self.finalizers is not None:
            result['finalizers'] = self.finalizers
        if self.generate_name is not None:
            result['generateName'] = self.generate_name
        if self.generation is not None:
            result['generation'] = self.generation
        if self.labels is not None:
            result['labels'] = self.labels
        if self.managed_fields is not None:
            result['managedFields'] = []
            for k in self.managed_fields:
                result['managedFields'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.owner_references is not None:
            result['ownerReferences'] = []
            for k in self.owner_references:
                result['ownerReferences'].append(k.to_map() if k else None)
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('annotations') is not None:
            self.annotations = m.get('annotations')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('creationTimestamp') is not None:
            self.creation_timestamp = m.get('creationTimestamp')
        if m.get('deletionGracePeriodSeconds') is not None:
            self.deletion_grace_period_seconds = m.get('deletionGracePeriodSeconds')
        if m.get('deletionTimestamp') is not None:
            self.deletion_timestamp = m.get('deletionTimestamp')
        if m.get('finalizers') is not None:
            self.finalizers = m.get('finalizers')
        if m.get('generateName') is not None:
            self.generate_name = m.get('generateName')
        if m.get('generation') is not None:
            self.generation = m.get('generation')
        if m.get('labels') is not None:
            self.labels = m.get('labels')
        if m.get('managedFields') is not None:
            self.managed_fields = []
            for k in m.get('managedFields'):
                temp_model = ListJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry()
                self.managed_fields.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('ownerReferences') is not None:
            self.owner_references = []
            for k in m.get('ownerReferences'):
                temp_model = ListJobIoK8sApimachineryPkgApisMetaV1OwnerReference()
                self.owner_references.append(temp_model.from_map(k))
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class ListJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        values: List[str] = None,
    ):
        # {"en": "key is the label key that the selector applies to.", "zh_CN": "选择器应用的标签键"}
        self.key = key
        # {"en": "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.", "zh_CN": "表示键与一组值的关系。有效的运算符包括 In、NotIn、Exists 和 DoesNotExist"}
        self.operator = operator
        # {"en": "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.", "zh_CN": "values 是一个字符串值数组。如果运算符为 In 或 NotIn，则 values 数组必须为非空。如果运算符是 Exists 或 DoesNotExist，则 values 数组必须为空。该数组在策略性合并补丁（Strategic Merge Patch）期间被替换"}
        self.values = values

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector(TeaModel):
    def __init__(
        self,
        match_expressions: List[ListJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement] = None,
        match_labels: Dict[str, Any] = None,
    ):
        # {"en": "matchExpressions is a list of label selector requirements. The requirements are ANDed.", "zh_CN": "标签选择器要求的列表，这些要求的结果按逻辑与的关系来计算"}
        self.match_expressions = match_expressions
        # {"en": "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is key, the operator is In, and the values array contains only value. The requirements are ANDed.", "zh_CN": "matchLabels 是 {key,value} 键值对的映射。matchLabels 映射中的单个 {key,value} 键值对相当于 matchExpressions 的一个元素，其键字段为 key，运算符为 In，values 数组仅包含 value。所表达的需求最终要按逻辑与的关系组合"}
        self.match_labels = match_labels

    def validate(self):
        if self.match_expressions:
            for k in self.match_expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_expressions is not None:
            result['matchExpressions'] = []
            for k in self.match_expressions:
                result['matchExpressions'].append(k.to_map() if k else None)
        if self.match_labels is not None:
            result['matchLabels'] = self.match_labels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchExpressions') is not None:
            self.match_expressions = []
            for k in m.get('matchExpressions'):
                temp_model = ListJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement()
                self.match_expressions.append(temp_model.from_map(k))
        if m.get('matchLabels') is not None:
            self.match_labels = m.get('matchLabels')
        return self


class ListJobIoK8sApiCoreV1NodeSelectorRequirement(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        values: List[str] = None,
    ):
        # {"en": "The label key that the selector applies to.", "zh_CN": "选择算符所适用的标签主键"}
        self.key = key
        # {"en": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.", "zh_CN": "代表主键与值集之间的关系。合法的 operator 值包括 In、NotIn、Exists、DoesNotExist、Gt 和 Lt"}
        self.operator = operator
        # {"en": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.", "zh_CN": "一个由字符串值组成的数组。如果 operator 是 In 或 NotIn，则 values 数组不能为空。 如果 operator 为 Exists 或 DoesNotExist，则 values 数组只能为空。 如果 operator 为 Gt 或 Lt，则 values 数组只能包含一个元素，并且该元素会被解释为整数。 在执行策略性合并补丁操作时，此数组会被整体替换"}
        self.values = values

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class ListJobIoK8sApiCoreV1NodeSelectorTerm(TeaModel):
    def __init__(
        self,
        match_expressions: List[ListJobIoK8sApiCoreV1NodeSelectorRequirement] = None,
        match_fields: List[ListJobIoK8sApiCoreV1NodeSelectorRequirement] = None,
    ):
        # {"en": "A list of node selector requirements by node's labels.", "zh_CN": "按节点标签列出的节点选择条件列表"}
        self.match_expressions = match_expressions
        # {"en": "A list of node selector requirements by node's fields.", "zh_CN": "按节点字段列出的节点选择要求列表"}
        self.match_fields = match_fields

    def validate(self):
        if self.match_expressions:
            for k in self.match_expressions:
                if k:
                    k.validate()
        if self.match_fields:
            for k in self.match_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_expressions is not None:
            result['matchExpressions'] = []
            for k in self.match_expressions:
                result['matchExpressions'].append(k.to_map() if k else None)
        if self.match_fields is not None:
            result['matchFields'] = []
            for k in self.match_fields:
                result['matchFields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchExpressions') is not None:
            self.match_expressions = []
            for k in m.get('matchExpressions'):
                temp_model = ListJobIoK8sApiCoreV1NodeSelectorRequirement()
                self.match_expressions.append(temp_model.from_map(k))
        if m.get('matchFields') is not None:
            self.match_fields = []
            for k in m.get('matchFields'):
                temp_model = ListJobIoK8sApiCoreV1NodeSelectorRequirement()
                self.match_fields.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1PreferredSchedulingTerm(TeaModel):
    def __init__(
        self,
        preference: ListJobIoK8sApiCoreV1NodeSelectorTerm = None,
        weight: int = None,
    ):
        # {"en": "A node selector term, associated with the corresponding weight.", "zh_CN": "与相应权重相关联的节点选择条件"}
        self.preference = preference
        # {"en": "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.", "zh_CN": "与匹配相应的 nodeSelectorTerm 相关的权重，范围为 1-100"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.preference, 'preference')
        if self.preference:
            self.preference.validate()
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preference is not None:
            result['preference'] = self.preference.to_map()
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preference') is not None:
            temp_model = ListJobIoK8sApiCoreV1NodeSelectorTerm()
            self.preference = temp_model.from_map(m['preference'])
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class ListJobIoK8sApiCoreV1NodeSelector(TeaModel):
    def __init__(
        self,
        node_selector_terms: List[ListJobIoK8sApiCoreV1NodeSelectorTerm] = None,
    ):
        # {"en": "Required. A list of node selector terms. The terms are ORed.", "zh_CN": "必需的字段。节点选择条件列表。这些条件按逻辑或操作组合"}
        self.node_selector_terms = node_selector_terms

    def validate(self):
        self.validate_required(self.node_selector_terms, 'node_selector_terms')
        if self.node_selector_terms:
            for k in self.node_selector_terms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_selector_terms is not None:
            result['nodeSelectorTerms'] = []
            for k in self.node_selector_terms:
                result['nodeSelectorTerms'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeSelectorTerms') is not None:
            self.node_selector_terms = []
            for k in m.get('nodeSelectorTerms'):
                temp_model = ListJobIoK8sApiCoreV1NodeSelectorTerm()
                self.node_selector_terms.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1NodeAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[ListJobIoK8sApiCoreV1PreferredSchedulingTerm] = None,
        required_during_scheduling_ignored_during_execution: ListJobIoK8sApiCoreV1NodeSelector = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度程序会更倾向于将 Pod 调度到满足该字段指定的亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。最优选的节点是权重总和最大的节点， 即对于满足所有调度要求（资源请求、requiredDuringScheduling 亲和表达式等）的每个节点， 通过迭代该字段的元素来计算总和如果节点匹配相应的 matchExpressions，则将 “权重” 添加到总和中； 具有最高总和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.", "zh_CN": "如果在调度时不满足该字段指定的亲和性要求，则不会将 Pod 调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的亲和性要求（例如：由于更新）， 系统可能会或可能不会尝试最终将 Pod 从其节点中逐出"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            self.required_during_scheduling_ignored_during_execution.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = self.required_during_scheduling_ignored_during_execution.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = ListJobIoK8sApiCoreV1PreferredSchedulingTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            temp_model = ListJobIoK8sApiCoreV1NodeSelector()
            self.required_during_scheduling_ignored_during_execution = temp_model.from_map(m['requiredDuringSchedulingIgnoredDuringExecution'])
        return self


class ListJobIoK8sApiCoreV1PodAffinityTerm(TeaModel):
    def __init__(
        self,
        label_selector: ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        namespaces: List[str] = None,
        topology_key: str = None,
    ):
        # {"en": "A label query over a set of resources, in this case pods.", "zh_CN": "对一组资源的标签查询，在这里资源为 Pod"}
        self.label_selector = label_selector
        # {"en": "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means this pod's namespace", "zh_CN": "namespaces 指定此条件所适用的名字空间，是一个静态列表。 此条件会被应用到 namespaces 字段中列出的名字空间和由 namespaceSelector 选中的名字空间上。 namespaces 列表为 null 或空，以及 namespaceSelector 值为 null 均表示“此 Pod 的名字空间”"}
        self.namespaces = namespaces
        # {"en": "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.", "zh_CN": "此 Pod 应与指定名字空间中与标签选择算符匹配的 Pod 集合位于同一位置（亲和性） 或位于不同位置（反亲和性），这里的“在同一位置”意味着运行在一个节点上，其键名为 topologyKey 的标签值与运行所选 Pod 集合中的某 Pod 的任何节点上的标签值匹配。 不允许使用空的 topologyKey"}
        self.topology_key = topology_key

    def validate(self):
        if self.label_selector:
            self.label_selector.validate()
        self.validate_required(self.topology_key, 'topology_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector.to_map()
        if self.namespaces is not None:
            result['namespaces'] = self.namespaces
        if self.topology_key is not None:
            result['topologyKey'] = self.topology_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('labelSelector') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.label_selector = temp_model.from_map(m['labelSelector'])
        if m.get('namespaces') is not None:
            self.namespaces = m.get('namespaces')
        if m.get('topologyKey') is not None:
            self.topology_key = m.get('topologyKey')
        return self


class ListJobIoK8sApiCoreV1WeightedPodAffinityTerm(TeaModel):
    def __init__(
        self,
        pod_affinity_term: ListJobIoK8sApiCoreV1PodAffinityTerm = None,
        weight: int = None,
    ):
        # {"en": "Required. A pod affinity term, associated with the corresponding weight.", "zh_CN": "必需的字段。一个 Pod 亲和性条件，对应一个与相应的权重值"}
        self.pod_affinity_term = pod_affinity_term
        # {"en": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.", "zh_CN": "weight 是匹配相应 podAffinityTerm 条件的权重，范围为 1-100"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.pod_affinity_term, 'pod_affinity_term')
        if self.pod_affinity_term:
            self.pod_affinity_term.validate()
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pod_affinity_term is not None:
            result['podAffinityTerm'] = self.pod_affinity_term.to_map()
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('podAffinityTerm') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodAffinityTerm()
            self.pod_affinity_term = temp_model.from_map(m['podAffinityTerm'])
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class ListJobIoK8sApiCoreV1PodAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[ListJobIoK8sApiCoreV1WeightedPodAffinityTerm] = None,
        required_during_scheduling_ignored_during_execution: List[ListJobIoK8sApiCoreV1PodAffinityTerm] = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度器会更倾向于将 Pod 调度到满足该字段指定的亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。最优选择是权重总和最大的节点， 即对于满足所有调度要求（资源请求、requiredDuringScheduling 亲和表达式等）的每个节点， 通过迭代该字段的元素来计算总和，如果节点具有与相应 podAffinityTerm 匹配的 Pod，则将“权重”添加到总和中； 具有最高总和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.", "zh_CN": "如果在调度时不满足该字段指定的亲和性要求，则该 Pod 不会被调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的亲和性要求（例如：由于 Pod 标签更新）， 系统可能会也可能不会尝试最终将 Pod 从其节点中逐出。 当此列表中有多个元素时，每个 podAffinityTerm 对应的节点列表是取其交集的，即必须满足所有条件"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            for k in self.required_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.required_during_scheduling_ignored_during_execution:
                result['requiredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = ListJobIoK8sApiCoreV1WeightedPodAffinityTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            self.required_during_scheduling_ignored_during_execution = []
            for k in m.get('requiredDuringSchedulingIgnoredDuringExecution'):
                temp_model = ListJobIoK8sApiCoreV1PodAffinityTerm()
                self.required_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1PodAntiAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[ListJobIoK8sApiCoreV1WeightedPodAffinityTerm] = None,
        required_during_scheduling_ignored_during_execution: List[ListJobIoK8sApiCoreV1PodAffinityTerm] = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度器更倾向于将 Pod 调度到满足该字段指定的反亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。 最优选的节点是权重总和最大的节点，即对于满足所有调度要求（资源请求、requiredDuringScheduling 反亲和性表达式等）的每个节点，通过遍历元素来计算总和如果节点具有与相应 podAffinityTerm 匹配的 Pod，则此字段并在总和中添加“权重”；具有最高加和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.", "zh_CN": "如果在调度时不满足该字段指定的反亲和性要求，则该 Pod 不会被调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的反亲和性要求（例如：由于 Pod 标签更新）， 系统可能会或可能不会尝试最终将 Pod 从其节点中逐出。 当有多个元素时，每个 podAffinityTerm 对应的节点列表是取其交集的，即必须满足所有条件"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            for k in self.required_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.required_during_scheduling_ignored_during_execution:
                result['requiredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = ListJobIoK8sApiCoreV1WeightedPodAffinityTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            self.required_during_scheduling_ignored_during_execution = []
            for k in m.get('requiredDuringSchedulingIgnoredDuringExecution'):
                temp_model = ListJobIoK8sApiCoreV1PodAffinityTerm()
                self.required_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1Affinity(TeaModel):
    def __init__(
        self,
        node_affinity: ListJobIoK8sApiCoreV1NodeAffinity = None,
        pod_affinity: ListJobIoK8sApiCoreV1PodAffinity = None,
        pod_anti_affinity: ListJobIoK8sApiCoreV1PodAntiAffinity = None,
    ):
        # {"en": "Describes node affinity scheduling rules for the pod.", "zh_CN": "描述 Pod 的节点亲和性调度规则"}
        self.node_affinity = node_affinity
        # {"en": "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).", "zh_CN": "描述 Pod 亲和性调度规则（例如，将此 Pod 与其他一些 Pod 放在同一节点、区域等）"}
        self.pod_affinity = pod_affinity
        # {"en": "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).", "zh_CN": "描述 Pod 反亲和性调度规则（例如，避免将此 Pod 与其他一些 Pod 放在相同的节点、区域等）"}
        self.pod_anti_affinity = pod_anti_affinity

    def validate(self):
        if self.node_affinity:
            self.node_affinity.validate()
        if self.pod_affinity:
            self.pod_affinity.validate()
        if self.pod_anti_affinity:
            self.pod_anti_affinity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_affinity is not None:
            result['nodeAffinity'] = self.node_affinity.to_map()
        if self.pod_affinity is not None:
            result['podAffinity'] = self.pod_affinity.to_map()
        if self.pod_anti_affinity is not None:
            result['podAntiAffinity'] = self.pod_anti_affinity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeAffinity') is not None:
            temp_model = ListJobIoK8sApiCoreV1NodeAffinity()
            self.node_affinity = temp_model.from_map(m['nodeAffinity'])
        if m.get('podAffinity') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodAffinity()
            self.pod_affinity = temp_model.from_map(m['podAffinity'])
        if m.get('podAntiAffinity') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodAntiAffinity()
            self.pod_anti_affinity = temp_model.from_map(m['podAntiAffinity'])
        return self


class ListJobIoK8sApiCoreV1ConfigMapKeySelector(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "The key to select.", "zh_CN": "要选择的主键"}
        self.key = key
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用者的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its key must be defined", "zh_CN": "指定 ConfigMap 或其主键是否必须已经定义"}
        self.optional = optional

    def validate(self):
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1ObjectFieldSelector(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        field_path: str = None,
    ):
        # {"en": "Version of the schema the FieldPath is written in terms of, defaults to v1.", "zh_CN": "fieldPath 写入时所使用的模式版本，默认为 v1"}
        self.api_version = api_version
        # {"en": "Path of the field to select in the specified API version.", "zh_CN": "在指定 API 版本中要选择的字段的路径"}
        self.field_path = field_path

    def validate(self):
        self.validate_required(self.field_path, 'field_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.field_path is not None:
            result['fieldPath'] = self.field_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('fieldPath') is not None:
            self.field_path = m.get('fieldPath')
        return self


class ListJobIoK8sApiCoreV1ResourceFieldSelector(TeaModel):
    def __init__(
        self,
        container_name: str = None,
        divisor: str = None,
        resource: str = None,
    ):
        # {"en": "Container name: required for volumes, optional for env vars", "zh_CN": "容器名称：对卷必选，对环境变量可选"}
        self.container_name = container_name
        # {"en": "Specifies the output format of the exposed resources, defaults to 1", "zh_CN": "指定所曝光资源的输出格式，默认值为“1”"}
        self.divisor = divisor
        # {"en": "Required: resource to select", "zh_CN": "必选：选择的资源"}
        self.resource = resource

    def validate(self):
        self.validate_required(self.resource, 'resource')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_name is not None:
            result['containerName'] = self.container_name
        if self.divisor is not None:
            result['divisor'] = self.divisor
        if self.resource is not None:
            result['resource'] = self.resource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containerName') is not None:
            self.container_name = m.get('containerName')
        if m.get('divisor') is not None:
            self.divisor = m.get('divisor')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        return self


class ListJobIoK8sApiCoreV1SecretKeySelector(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "The key of the secret to select from.  Must be a valid secret key.", "zh_CN": "要选择的 Secret 的主键。必须是有效的主键"}
        self.key = key
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用 Secret 的名称"}
        self.name = name
        # {"en": "Specify whether the Secret or its key must be defined", "zh_CN": "指定 Secret 或其主键是否必须已经定义"}
        self.optional = optional

    def validate(self):
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1EnvVarSource(TeaModel):
    def __init__(
        self,
        config_map_key_ref: ListJobIoK8sApiCoreV1ConfigMapKeySelector = None,
        field_ref: ListJobIoK8sApiCoreV1ObjectFieldSelector = None,
        resource_field_ref: ListJobIoK8sApiCoreV1ResourceFieldSelector = None,
        secret_key_ref: ListJobIoK8sApiCoreV1SecretKeySelector = None,
    ):
        # {"en": "Selects a key of a ConfigMap.", "zh_CN": "选择某个 ConfigMap 的一个主键"}
        self.config_map_key_ref = config_map_key_ref
        # {"en": "Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.", "zh_CN": "选择 Pod 的一个字段：支持 metadata.name、metadata.namespace、metadata.labels['<KEY>']、 metadata.annotations['<KEY>']、spec.nodeName、spec.serviceAccountName、status.hostIP status.podIP、status.podIPs"}
        self.field_ref = field_ref
        # {"en": "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.", "zh_CN": "选择容器的资源：目前仅支持资源限制和请求（limits.cpu、limits.memory、limits.ephemeral-storage、 requests.cpu、requests.memory 和 requests.ephemeral-storage）"}
        self.resource_field_ref = resource_field_ref
        # {"en": "Selects a key of a secret in the pod's namespace", "zh_CN": "在 Pod 的名字空间中选择 Secret 的主键"}
        self.secret_key_ref = secret_key_ref

    def validate(self):
        if self.config_map_key_ref:
            self.config_map_key_ref.validate()
        if self.field_ref:
            self.field_ref.validate()
        if self.resource_field_ref:
            self.resource_field_ref.validate()
        if self.secret_key_ref:
            self.secret_key_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_key_ref is not None:
            result['configMapKeyRef'] = self.config_map_key_ref.to_map()
        if self.field_ref is not None:
            result['fieldRef'] = self.field_ref.to_map()
        if self.resource_field_ref is not None:
            result['resourceFieldRef'] = self.resource_field_ref.to_map()
        if self.secret_key_ref is not None:
            result['secretKeyRef'] = self.secret_key_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMapKeyRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1ConfigMapKeySelector()
            self.config_map_key_ref = temp_model.from_map(m['configMapKeyRef'])
        if m.get('fieldRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1ObjectFieldSelector()
            self.field_ref = temp_model.from_map(m['fieldRef'])
        if m.get('resourceFieldRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1ResourceFieldSelector()
            self.resource_field_ref = temp_model.from_map(m['resourceFieldRef'])
        if m.get('secretKeyRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1SecretKeySelector()
            self.secret_key_ref = temp_model.from_map(m['secretKeyRef'])
        return self


class ListJobIoK8sApiCoreV1EnvVar(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_from: ListJobIoK8sApiCoreV1EnvVarSource = None,
    ):
        # {"en": "Name of the environment variable. Must be a C_IDENTIFIER.", "zh_CN": "环境变量的名称。必须是 C_IDENTIFIER"}
        self.name = name
        # {"en": "Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to ''.", "zh_CN": "变量引用 $(VAR_NAME) 使用容器中先前定义的环境变量和任何服务环境变量进行扩展。 如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 会被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。默认为 “”"}
        self.value = value
        # {"en": "Source for the environment variable's value. Cannot be used if value is not empty.", "zh_CN": "环境变量值的来源。如果 value 值不为空，则不能使用"}
        self.value_from = value_from

    def validate(self):
        self.validate_required(self.name, 'name')
        if self.value_from:
            self.value_from.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        if self.value_from is not None:
            result['valueFrom'] = self.value_from.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('valueFrom') is not None:
            temp_model = ListJobIoK8sApiCoreV1EnvVarSource()
            self.value_from = temp_model.from_map(m['valueFrom'])
        return self


class ListJobIoK8sApiCoreV1ConfigMapEnvSource(TeaModel):
    def __init__(
        self,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用的 ConfigMap 的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap must be defined", "zh_CN": "指定 ConfigMap 是否必须已经定义"}
        self.optional = optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1SecretEnvSource(TeaModel):
    def __init__(
        self,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用 Secret 的名称"}
        self.name = name
        # {"en": "Specify whether the Secret must be defined", "zh_CN": "指定 Secret 是否必须已经定义"}
        self.optional = optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1EnvFromSource(TeaModel):
    def __init__(
        self,
        config_map_ref: ListJobIoK8sApiCoreV1ConfigMapEnvSource = None,
        prefix: str = None,
        secret_ref: ListJobIoK8sApiCoreV1SecretEnvSource = None,
    ):
        # {"en": "The ConfigMap to select from", "zh_CN": "要从中选择主键的 ConfigMap"}
        self.config_map_ref = config_map_ref
        # {"en": "An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.", "zh_CN": "附加到 ConfigMap 中每个键名之前的可选标识符。必须是 C_IDENTIFIER"}
        self.prefix = prefix
        # {"en": "The Secret to select from", "zh_CN": "要从中选择主键的 Secret"}
        self.secret_ref = secret_ref

    def validate(self):
        if self.config_map_ref:
            self.config_map_ref.validate()
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_ref is not None:
            result['configMapRef'] = self.config_map_ref.to_map()
        if self.prefix is not None:
            result['prefix'] = self.prefix
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMapRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1ConfigMapEnvSource()
            self.config_map_ref = temp_model.from_map(m['configMapRef'])
        if m.get('prefix') is not None:
            self.prefix = m.get('prefix')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1SecretEnvSource()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        return self


class ListJobIoK8sApiCoreV1ExecAction(TeaModel):
    def __init__(
        self,
        command: List[str] = None,
    ):
        # {"en": "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.", "zh_CN": "要在容器内执行的命令行，命令的工作目录是容器文件系统中的根目录（'/'）。 该命令只是被通过 exec 执行，而不会单独启动一个 Shell 来运行，因此传统的 Shell 指令（'|' 等）将不起作用。要使用某 Shell，你需要显式调用该 Shell。 退出状态 0 被视为活动/健康，非零表示不健康"}
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('command') is not None:
            self.command = m.get('command')
        return self


class ListJobIoK8sApiCoreV1HTTPHeader(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "The header field name", "zh_CN": "HTTP 头部字段名称"}
        self.name = name
        # {"en": "The header field value", "zh_CN": "HTTP 头部字段取值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ListJobIoK8sApiCoreV1HTTPGetAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        http_headers: List[ListJobIoK8sApiCoreV1HTTPHeader] = None,
        path: str = None,
        port: str = None,
        scheme: str = None,
    ):
        # {"en": "Host name to connect to, defaults to the pod IP. You probably want to set Host in httpHeaders instead.", "zh_CN": "要连接的主机名，默认为 Pod IP。你可能想在 httpHeaders 中设置 Host"}
        self.host = host
        # {"en": "Custom headers to set in the request. HTTP allows repeated headers.", "zh_CN": "要在请求中设置的自定义 HTTP 标头。HTTP 允许重复的标头"}
        self.http_headers = http_headers
        # {"en": "Path to access on the HTTP server.", "zh_CN": "HTTP 服务器上的访问路径"}
        self.path = path
        # {"en": "Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.", "zh_CN": "容器上要访问的端口的名称或端口号。端口号必须在 1 到 65535 内。名称必须是 IANA_SVC_NAME"}
        self.port = port
        # {"en": "Scheme to use for connecting to the host. Defaults to HTTP.", "zh_CN": "用于连接到主机的方案。默认为 HTTP"}
        self.scheme = scheme

    def validate(self):
        if self.http_headers:
            for k in self.http_headers:
                if k:
                    k.validate()
        self.validate_required(self.port, 'port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.http_headers is not None:
            result['httpHeaders'] = []
            for k in self.http_headers:
                result['httpHeaders'].append(k.to_map() if k else None)
        if self.path is not None:
            result['path'] = self.path
        if self.port is not None:
            result['port'] = self.port
        if self.scheme is not None:
            result['scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('httpHeaders') is not None:
            self.http_headers = []
            for k in m.get('httpHeaders'):
                temp_model = ListJobIoK8sApiCoreV1HTTPHeader()
                self.http_headers.append(temp_model.from_map(k))
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('scheme') is not None:
            self.scheme = m.get('scheme')
        return self


class ListJobIoK8sApiCoreV1TCPSocketAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        port: str = None,
    ):
        # {"en": "Optional: Host name to connect to, defaults to the pod IP.", "zh_CN": "可选字段。要连接的主机名，默认为 Pod IP"}
        self.host = host
        # {"en": "Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.", "zh_CN": "容器上要访问的端口的编号或名称。端口号必须在 1 到 65535 的范围内。 名称必须是 IANA_SVC_NAME"}
        self.port = port

    def validate(self):
        self.validate_required(self.port, 'port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class ListJobIoK8sApiCoreV1Handler(TeaModel):
    def __init__(
        self,
        exec: ListJobIoK8sApiCoreV1ExecAction = None,
        http_get: ListJobIoK8sApiCoreV1HTTPGetAction = None,
        tcp_socket: ListJobIoK8sApiCoreV1TCPSocketAction = None,
    ):
        # {"en": "One and only one of the following should be specified. Exec specifies the action to take.", "zh_CN": "指定要执行的操作"}
        self.exec = exec
        # {"en": "HTTPGet specifies the http request to perform.", "zh_CN": "指定要执行的 HTTP 请求"}
        self.http_get = http_get
        # {"en": "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported", "zh_CN": "已弃用。不再支持 tcpSocket 作为 LifecycleHandler，但为向后兼容保留之。 当指定 tcp 处理程序时，此字段不会被验证，而生命周期回调将在运行时失败"}
        self.tcp_socket = tcp_socket

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['exec'] = self.exec.to_map()
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec') is not None:
            temp_model = ListJobIoK8sApiCoreV1ExecAction()
            self.exec = temp_model.from_map(m['exec'])
        if m.get('httpGet') is not None:
            temp_model = ListJobIoK8sApiCoreV1HTTPGetAction()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('tcpSocket') is not None:
            temp_model = ListJobIoK8sApiCoreV1TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        return self


class ListJobIoK8sApiCoreV1Lifecycle(TeaModel):
    def __init__(
        self,
        post_start: ListJobIoK8sApiCoreV1Handler = None,
        pre_stop: ListJobIoK8sApiCoreV1Handler = None,
    ):
        # {"en": "PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks", "zh_CN": "创建容器后立即调用 postStart。如果处理程序失败，则容器将根据其重新启动策略终止并重新启动。 容器的其他管理阻塞直到钩子完成"}
        self.post_start = post_start
        # {"en": "PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks", "zh_CN": "preStop 在容器因 API 请求或管理事件（如存活态探针/启动探针失败、抢占、资源争用等）而终止之前立即调用。 如果容器崩溃或退出，则不会调用处理程序。Pod 的终止宽限期倒计时在 preStop 钩子执行之前开始。 无论处理程序的结果如何，容器最终都会在 Pod 的终止宽限期内终止（除非被终结器延迟）。 容器的其他管理会阻塞，直到钩子完成或达到终止宽限期"}
        self.pre_stop = pre_stop

    def validate(self):
        if self.post_start:
            self.post_start.validate()
        if self.pre_stop:
            self.pre_stop.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.post_start is not None:
            result['postStart'] = self.post_start.to_map()
        if self.pre_stop is not None:
            result['preStop'] = self.pre_stop.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('postStart') is not None:
            temp_model = ListJobIoK8sApiCoreV1Handler()
            self.post_start = temp_model.from_map(m['postStart'])
        if m.get('preStop') is not None:
            temp_model = ListJobIoK8sApiCoreV1Handler()
            self.pre_stop = temp_model.from_map(m['preStop'])
        return self


class ListJobIoK8sApiCoreV1Probe(TeaModel):
    def __init__(
        self,
        exec: ListJobIoK8sApiCoreV1ExecAction = None,
        failure_threshold: int = None,
        http_get: ListJobIoK8sApiCoreV1HTTPGetAction = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        success_threshold: int = None,
        tcp_socket: ListJobIoK8sApiCoreV1TCPSocketAction = None,
        timeout_seconds: int = None,
    ):
        # {"en": "One and only one of the following should be specified. Exec specifies the action to take.", "zh_CN": "指定要执行的操作"}
        self.exec = exec
        # {"en": "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.", "zh_CN": "探针成功后的最小连续失败次数，超出此阈值则认为探针失败。默认为 3。最小值为 1"}
        self.failure_threshold = failure_threshold
        # {"en": "HTTPGet specifies the http request to perform.", "zh_CN": "指定要执行的 HTTP 请求"}
        self.http_get = http_get
        # {"en": "Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "容器启动后启动存活态探针之前的秒数"}
        self.initial_delay_seconds = initial_delay_seconds
        # {"en": "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.", "zh_CN": "探针的执行周期（以秒为单位）。默认为 10 秒。最小值为 1"}
        self.period_seconds = period_seconds
        # {"en": "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.", "zh_CN": "探针失败后最小连续成功次数，超过此阈值才会被视为探针成功。默认为 1。 存活性探针和启动探针必须为 1。最小值为 1"}
        self.success_threshold = success_threshold
        # {"en": "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported", "zh_CN": "tcpSocket 指定涉及 TCP 端口的操作"}
        self.tcp_socket = tcp_socket
        # {"en": "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "探针超时的秒数。默认为 1 秒。最小值为 1"}
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['exec'] = self.exec.to_map()
        if self.failure_threshold is not None:
            result['failureThreshold'] = self.failure_threshold
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.initial_delay_seconds is not None:
            result['initialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['periodSeconds'] = self.period_seconds
        if self.success_threshold is not None:
            result['successThreshold'] = self.success_threshold
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        if self.timeout_seconds is not None:
            result['timeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec') is not None:
            temp_model = ListJobIoK8sApiCoreV1ExecAction()
            self.exec = temp_model.from_map(m['exec'])
        if m.get('failureThreshold') is not None:
            self.failure_threshold = m.get('failureThreshold')
        if m.get('httpGet') is not None:
            temp_model = ListJobIoK8sApiCoreV1HTTPGetAction()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('initialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('initialDelaySeconds')
        if m.get('periodSeconds') is not None:
            self.period_seconds = m.get('periodSeconds')
        if m.get('successThreshold') is not None:
            self.success_threshold = m.get('successThreshold')
        if m.get('tcpSocket') is not None:
            temp_model = ListJobIoK8sApiCoreV1TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        if m.get('timeoutSeconds') is not None:
            self.timeout_seconds = m.get('timeoutSeconds')
        return self


class ListJobIoK8sApiCoreV1ContainerPort(TeaModel):
    def __init__(
        self,
        container_port: int = None,
        host_ip: str = None,
        host_port: int = None,
        name: str = None,
        protocol: str = None,
    ):
        # {"en": "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.", "zh_CN": "要在 Pod 的 IP 地址上公开的端口号。这必须是有效的端口号，0 < x < 65536"}
        self.container_port = container_port
        # {"en": "What host IP to bind the external port to.", "zh_CN": "绑定外部端口的主机 IP"}
        self.host_ip = host_ip
        # {"en": "Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.", "zh_CN": "要在主机上公开的端口号。如果指定，此字段必须是一个有效的端口号，0 < x < 65536。 如果设置了 hostNetwork，此字段值必须与 containerPort 匹配。大多数容器不需要设置此字段"}
        self.host_port = host_port
        # {"en": "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.", "zh_CN": "如果设置此字段，这必须是 IANA_SVC_NAME 并且在 Pod 中唯一。 Pod 中的每个命名端口都必须具有唯一的名称。服务可以引用的端口的名称"}
        self.name = name
        # {"en": "Protocol for port. Must be UDP, TCP, or SCTP. Defaults to TCP.", "zh_CN": "端口协议。必须是 UDP、TCP 或 SCTP。默认为 TCP"}
        self.protocol = protocol

    def validate(self):
        self.validate_required(self.container_port, 'container_port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_port is not None:
            result['containerPort'] = self.container_port
        if self.host_ip is not None:
            result['hostIP'] = self.host_ip
        if self.host_port is not None:
            result['hostPort'] = self.host_port
        if self.name is not None:
            result['name'] = self.name
        if self.protocol is not None:
            result['protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containerPort') is not None:
            self.container_port = m.get('containerPort')
        if m.get('hostIP') is not None:
            self.host_ip = m.get('hostIP')
        if m.get('hostPort') is not None:
            self.host_port = m.get('hostPort')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        return self


class ListJobIoK8sApiCoreV1ResourceRequirements(TeaModel):
    def __init__(
        self,
        limits: Dict[str, Any] = None,
        requests: Dict[str, Any] = None,
    ):
        # {"en": "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "limits 描述所允许的最大计算资源量"}
        self.limits = limits
        # {"en": "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "requests 描述所需的最小计算资源量。如果对容器省略了 requests，则默认其资源请求值为 limits （如果已显式指定）的值，否则为实现定义的值。请求不能超过限制"}
        self.requests = requests

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limits is not None:
            result['limits'] = self.limits
        if self.requests is not None:
            result['requests'] = self.requests
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('limits') is not None:
            self.limits = m.get('limits')
        if m.get('requests') is not None:
            self.requests = m.get('requests')
        return self


class ListJobIoK8sApiCoreV1Capabilities(TeaModel):
    def __init__(
        self,
        add: List[str] = None,
        drop: List[str] = None,
    ):
        # {"en": "Added capabilities", "zh_CN": "新增权能"}
        self.add = add
        # {"en": "Removed capabilities", "zh_CN": "放弃权能"}
        self.drop = drop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add is not None:
            result['add'] = self.add
        if self.drop is not None:
            result['drop'] = self.drop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add') is not None:
            self.add = m.get('add')
        if m.get('drop') is not None:
            self.drop = m.get('drop')
        return self


class ListJobIoK8sApiCoreV1SELinuxOptions(TeaModel):
    def __init__(
        self,
        level: str = None,
        role: str = None,
        type: str = None,
        user: str = None,
    ):
        # {"en": "Level is SELinux level label that applies to the container.", "zh_CN": "应用于容器的 SELinux 级别标签"}
        self.level = level
        # {"en": "Role is a SELinux role label that applies to the container.", "zh_CN": "应用于容器的 SELinux 角色标签"}
        self.role = role
        # {"en": "Type is a SELinux type label that applies to the container.", "zh_CN": "适用于容器的 SELinux 类型标签"}
        self.type = type
        # {"en": "User is a SELinux user label that applies to the container.", "zh_CN": "应用于容器的 SELinux 用户标签"}
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.role is not None:
            result['role'] = self.role
        if self.type is not None:
            result['type'] = self.type
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class ListJobIoK8sApiCoreV1SeccompProfile(TeaModel):
    def __init__(
        self,
        localhost_profile: str = None,
        type: str = None,
    ):
        # {"en": "localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is Localhost.", "zh_CN": "localhostProfile 指示应使用在节点上的文件中定义的配置文件。 该配置文件必须在节点上预先配置才能工作。 必须是相对于 kubelet 配置的 seccomp 配置文件位置下的子路径。 仅当 type 为 Localhost 时才必须设置"}
        self.localhost_profile = localhost_profile
        # {"en": "type indicates which kind of seccomp profile will be applied. Valid options are: Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.", "zh_CN": "type 指示将应用哪种 seccomp 配置文件。有效的选项是：Localhost - 应使用在节点上的文件中定义的配置文件。RuntimeDefault - 应使用容器运行时默认配置文件。Unconfined - 不应应用任何配置文件"}
        self.type = type

    def validate(self):
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.localhost_profile is not None:
            result['localhostProfile'] = self.localhost_profile
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('localhostProfile') is not None:
            self.localhost_profile = m.get('localhostProfile')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ListJobIoK8sApiCoreV1WindowsSecurityContextOptions(TeaModel):
    def __init__(
        self,
        gmsa_credential_spec: str = None,
        gmsa_credential_spec_name: str = None,
        run_as_user_name: str = None,
    ):
        # {"en": "GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.", "zh_CN": "gmsaCredentialSpec 是 GMSA 准入 Webhook 内嵌由 gmsaCredentialSpecName 字段所指定的 GMSA 凭证规约内容的地方"}
        self.gmsa_credential_spec = gmsa_credential_spec
        # {"en": "GMSACredentialSpecName is the name of the GMSA credential spec to use.", "zh_CN": "gmsaCredentialSpecName 是要使用的 GMSA 凭证规约的名称"}
        self.gmsa_credential_spec_name = gmsa_credential_spec_name
        # {"en": "The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "Windows 中运行容器进程入口点的用户名。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 PodSecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_user_name = run_as_user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmsa_credential_spec is not None:
            result['gmsaCredentialSpec'] = self.gmsa_credential_spec
        if self.gmsa_credential_spec_name is not None:
            result['gmsaCredentialSpecName'] = self.gmsa_credential_spec_name
        if self.run_as_user_name is not None:
            result['runAsUserName'] = self.run_as_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmsaCredentialSpec') is not None:
            self.gmsa_credential_spec = m.get('gmsaCredentialSpec')
        if m.get('gmsaCredentialSpecName') is not None:
            self.gmsa_credential_spec_name = m.get('gmsaCredentialSpecName')
        if m.get('runAsUserName') is not None:
            self.run_as_user_name = m.get('runAsUserName')
        return self


class ListJobIoK8sApiCoreV1SecurityContext(TeaModel):
    def __init__(
        self,
        allow_privilege_escalation: bool = None,
        capabilities: ListJobIoK8sApiCoreV1Capabilities = None,
        privileged: bool = None,
        proc_mount: str = None,
        read_only_root_filesystem: bool = None,
        run_as_group: int = None,
        run_as_non_root: bool = None,
        run_as_user: int = None,
        se_linux_options: ListJobIoK8sApiCoreV1SELinuxOptions = None,
        seccomp_profile: ListJobIoK8sApiCoreV1SeccompProfile = None,
        windows_options: ListJobIoK8sApiCoreV1WindowsSecurityContextOptions = None,
    ):
        # {"en": "AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN", "zh_CN": "allowPrivilegeEscalation 控制进程是否可以获得比其父进程更多的权限。此布尔值直接控制是否在容器进程上设置 no_new_privs 标志。allowPrivilegeEscalation 在容器处于以下状态时始终为 true：- 以特权身份运行- 具有 CAP_SYS_ADMIN。请注意，当 spec.os.name 为 windows 时，无法设置此字段"}
        self.allow_privilege_escalation = allow_privilege_escalation
        # {"en": "The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.", "zh_CN": "运行容器时添加或放弃的权能（Capabilities）。默认为容器运行时所授予的权能集合。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.capabilities = capabilities
        # {"en": "Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.", "zh_CN": "以特权模式运行容器。特权容器中的进程本质上等同于主机上的 root。默认为 false。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.privileged = privileged
        # {"en": "procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.", "zh_CN": "procMount 表示用于容器的 proc 挂载类型。默认值为 DefaultProcMount， 它针对只读路径和掩码路径使用容器运行时的默认值。此字段需要启用 ProcMountType 特性门控。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.proc_mount = proc_mount
        # {"en": "Whether this container has a read-only root filesystem. Default is false.", "zh_CN": "此容器是否具有只读根文件系统。默认为 false。注意，spec.os.name 为 windows 时不能设置该字段"}
        self.read_only_root_filesystem = read_only_root_filesystem
        # {"en": "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "运行容器进程入口点的 GID。如果未设置，则使用运行时默认值。也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_group = run_as_group
        # {"en": "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "指示容器必须以非 root 用户身份运行。 如果为 true，kubelet 将在运行时验证镜像，以确保它不会以 UID 0（root）身份运行，如果是，则无法启动容器。 如果未设置或为 false，则不会执行此类验证。也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_non_root = run_as_non_root
        # {"en": "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "运行容器进程入口点的 UID。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_user = run_as_user
        # {"en": "The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用到容器上的 SELinux 上下文。如果未设置此字段，容器运行时将为每个容器分配一个随机的 SELinux 上下文。 也可以在 PodSecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置， 则在 SecurityContext 中指定的值优先。注意，spec.os.name 为 windows 时不能设置此字段"}
        self.se_linux_options = se_linux_options
        # {"en": "The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.", "zh_CN": "此容器使用的 seccomp 选项。如果在 Pod 和容器级别都提供了 seccomp 选项，则容器级别的选项会覆盖 Pod 级别的选项设置。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.seccomp_profile = seccomp_profile
        # {"en": "The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用于所有容器上的特定于 Windows 的设置。如果未指定，将使用 PodSecurityContext 中的选项。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 linux 时不能设置此字段"}
        self.windows_options = windows_options

    def validate(self):
        if self.capabilities:
            self.capabilities.validate()
        if self.se_linux_options:
            self.se_linux_options.validate()
        if self.seccomp_profile:
            self.seccomp_profile.validate()
        if self.windows_options:
            self.windows_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_privilege_escalation is not None:
            result['allowPrivilegeEscalation'] = self.allow_privilege_escalation
        if self.capabilities is not None:
            result['capabilities'] = self.capabilities.to_map()
        if self.privileged is not None:
            result['privileged'] = self.privileged
        if self.proc_mount is not None:
            result['procMount'] = self.proc_mount
        if self.read_only_root_filesystem is not None:
            result['readOnlyRootFilesystem'] = self.read_only_root_filesystem
        if self.run_as_group is not None:
            result['runAsGroup'] = self.run_as_group
        if self.run_as_non_root is not None:
            result['runAsNonRoot'] = self.run_as_non_root
        if self.run_as_user is not None:
            result['runAsUser'] = self.run_as_user
        if self.se_linux_options is not None:
            result['seLinuxOptions'] = self.se_linux_options.to_map()
        if self.seccomp_profile is not None:
            result['seccompProfile'] = self.seccomp_profile.to_map()
        if self.windows_options is not None:
            result['windowsOptions'] = self.windows_options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowPrivilegeEscalation') is not None:
            self.allow_privilege_escalation = m.get('allowPrivilegeEscalation')
        if m.get('capabilities') is not None:
            temp_model = ListJobIoK8sApiCoreV1Capabilities()
            self.capabilities = temp_model.from_map(m['capabilities'])
        if m.get('privileged') is not None:
            self.privileged = m.get('privileged')
        if m.get('procMount') is not None:
            self.proc_mount = m.get('procMount')
        if m.get('readOnlyRootFilesystem') is not None:
            self.read_only_root_filesystem = m.get('readOnlyRootFilesystem')
        if m.get('runAsGroup') is not None:
            self.run_as_group = m.get('runAsGroup')
        if m.get('runAsNonRoot') is not None:
            self.run_as_non_root = m.get('runAsNonRoot')
        if m.get('runAsUser') is not None:
            self.run_as_user = m.get('runAsUser')
        if m.get('seLinuxOptions') is not None:
            temp_model = ListJobIoK8sApiCoreV1SELinuxOptions()
            self.se_linux_options = temp_model.from_map(m['seLinuxOptions'])
        if m.get('seccompProfile') is not None:
            temp_model = ListJobIoK8sApiCoreV1SeccompProfile()
            self.seccomp_profile = temp_model.from_map(m['seccompProfile'])
        if m.get('windowsOptions') is not None:
            temp_model = ListJobIoK8sApiCoreV1WindowsSecurityContextOptions()
            self.windows_options = temp_model.from_map(m['windowsOptions'])
        return self


class ListJobIoK8sApiCoreV1VolumeDevice(TeaModel):
    def __init__(
        self,
        device_path: str = None,
        name: str = None,
    ):
        # {"en": "devicePath is the path inside of the container that the device will be mapped to.", "zh_CN": "设备将被映射到的容器内的路径"}
        self.device_path = device_path
        # {"en": "name must match the name of a persistentVolumeClaim in the pod", "zh_CN": "name 必须与 Pod 中的 persistentVolumeClaim 的名称匹配"}
        self.name = name

    def validate(self):
        self.validate_required(self.device_path, 'device_path')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_path is not None:
            result['devicePath'] = self.device_path
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('devicePath') is not None:
            self.device_path = m.get('devicePath')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ListJobIoK8sApiCoreV1VolumeMount(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
        sub_path_expr: str = None,
    ):
        # {"en": "Path within the container at which the volume should be mounted.  Must not contain ':'.", "zh_CN": "容器内应安装卷的路径。不得包含 ':'"}
        self.mount_path = mount_path
        # {"en": "mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.", "zh_CN": "mountPropagation 确定装载如何从主机传播到容器，及反向传播选项。 如果未设置，则使用 None。此字段在 1.10 中为 Beta 字段"}
        self.mount_propagation = mount_propagation
        # {"en": "This must match the Name of a Volume.", "zh_CN": "此字段必须与卷的名称匹配"}
        self.name = name
        # {"en": "Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.", "zh_CN": "如果为 true，则挂载卷为只读，否则为读写（false 或未指定）。默认值为 false"}
        self.read_only = read_only
        # {"en": "Path within the volume from which the container's volume should be mounted. Defaults to  (volume's root).", "zh_CN": "卷中的路径名，应该从该路径挂在容器的卷。默认为 “” （卷的根）"}
        self.sub_path = sub_path
        # {"en": "Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to  (volume's root). SubPathExpr and SubPath are mutually exclusive.", "zh_CN": "应安装容器卷的卷内的扩展路径。行为类似于 subPath，但环境变量引用 $(VAR_NAME) 使用容器的环境进行扩展。默认为 “”（卷的根）。subPathExpr 和 SubPath 是互斥的"}
        self.sub_path_expr = sub_path_expr

    def validate(self):
        self.validate_required(self.mount_path, 'mount_path')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['mountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['mountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['name'] = self.name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.sub_path is not None:
            result['subPath'] = self.sub_path
        if self.sub_path_expr is not None:
            result['subPathExpr'] = self.sub_path_expr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mountPath') is not None:
            self.mount_path = m.get('mountPath')
        if m.get('mountPropagation') is not None:
            self.mount_propagation = m.get('mountPropagation')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('subPath') is not None:
            self.sub_path = m.get('subPath')
        if m.get('subPathExpr') is not None:
            self.sub_path_expr = m.get('subPathExpr')
        return self


class ListJobIoK8sApiCoreV1Container(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
        env: List[ListJobIoK8sApiCoreV1EnvVar] = None,
        env_from: List[ListJobIoK8sApiCoreV1EnvFromSource] = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle: ListJobIoK8sApiCoreV1Lifecycle = None,
        liveness_probe: ListJobIoK8sApiCoreV1Probe = None,
        name: str = None,
        ports: List[ListJobIoK8sApiCoreV1ContainerPort] = None,
        readiness_probe: ListJobIoK8sApiCoreV1Probe = None,
        resources: ListJobIoK8sApiCoreV1ResourceRequirements = None,
        security_context: ListJobIoK8sApiCoreV1SecurityContext = None,
        startup_probe: ListJobIoK8sApiCoreV1Probe = None,
        stdin: bool = None,
        stdin_once: bool = None,
        termination_message_path: str = None,
        termination_message_policy: str = None,
        tty: bool = None,
        volume_devices: List[ListJobIoK8sApiCoreV1VolumeDevice] = None,
        volume_mounts: List[ListJobIoK8sApiCoreV1VolumeMount] = None,
        working_dir: str = None,
    ):
        # {"en": "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "entrypoint 的参数。如果未提供，则使用容器镜像的 CMD 设置。变量引用 $(VAR_NAME) 使用容器的环境进行扩展。 如果无法解析变量，则输入字符串中的引用将保持不变。$$ 被简化为 $，这允许转义 $(VAR_NAME) 语法： 即 “$$(VAR_NAME)” 将产生字符串字面值 “$(VAR_NAME)”。无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.args = args
        # {"en": "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "入口点数组。不在 Shell 中执行。如果未提供，则使用容器镜像的 ENTRYPOINT。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 “$$(VAR_NAME)” 将产生字符串字面值 “$(VAR_NAME)”。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.command = command
        # {"en": "List of environment variables to set in the container. Cannot be updated.", "zh_CN": "要在容器中设置的环境变量列表。无法更新"}
        self.env = env
        # {"en": "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.", "zh_CN": "用来在容器中填充环境变量的数据源列表。在源中定义的键必须是 C_IDENTIFIER。 容器启动时，所有无效主键都将作为事件报告。 当一个键存在于多个源中时，与最后一个来源关联的值将优先。 由 env 定义的条目中，与此处键名重复者，以 env 中定义为准。无法更新"}
        self.env_from = env_from
        # {"en": "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.", "zh_CN": "容器镜像名称"}
        self.image = image
        # {"en": "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images", "zh_CN": "镜像拉取策略。Always、Never、IfNotPresent 之一。如果指定了 :latest 标签，则默认为 Always， 否则默认为 IfNotPresent。无法更新"}
        self.image_pull_policy = image_pull_policy
        # {"en": "Actions that the management system should take in response to container lifecycle events. Cannot be updated.", "zh_CN": "管理系统应对容器生命周期事件采取的行动。无法更新"}
        self.lifecycle = lifecycle
        # {"en": "Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "定期探针容器活跃度。如果探针失败，容器将重新启动。无法更新"}
        self.liveness_probe = liveness_probe
        # {"en": "Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.", "zh_CN": "指定为 DNS_LABEL 的容器的名称。Pod 中的每个容器都必须有一个唯一的名称 (DNS_LABEL)。无法更新"}
        self.name = name
        # {"en": "List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default 0.0.0.0 address inside a container will be accessible from the network. Cannot be updated.", "zh_CN": "要从容器暴露的端口列表。此处不指定端口不会阻止该端口被暴露。 任何侦听容器内默认 0.0.0.0 地址的端口都可以从网络访问。使用策略合并补丁来修改此数组可能会破坏数据"}
        self.ports = ports
        # {"en": "Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "定期探测容器服务就绪情况。如果探针失败，容器将被从服务端点中删除。无法更新"}
        self.readiness_probe = readiness_probe
        # {"en": "Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "此容器所需的计算资源。无法更新"}
        self.resources = resources
        # {"en": "Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/", "zh_CN": "SecurityContext 定义了容器应该运行的安全选项。如果设置，SecurityContext 的字段将覆盖 PodSecurityContext 的等效字段"}
        self.security_context = security_context
        # {"en": "StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "startupProbe 表示 Pod 已成功初始化。如果设置了此字段，则此探针成功完成之前不会执行其他探针。 如果这个探针失败，Pod 会重新启动，就像存活态探针失败一样。 这可用于在 Pod 生命周期开始时提供不同的探针参数，此时加载数据或预热缓存可能需要比稳态操作期间更长的时间。 这无法更新"}
        self.startup_probe = startup_probe
        # {"en": "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.", "zh_CN": "此容器是否应在容器运行时为 stdin 分配缓冲区。如果未设置，从容器中的 stdin 读取将始终导致 EOF。 默认为 false"}
        self.stdin = stdin
        # {"en": "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false", "zh_CN": "容器运行时是否应在某个 attach 打开 stdin 通道后关闭它。当 stdin 为 true 时，stdin 流将在多个 attach 会话中保持打开状态。 如果 stdinOnce 设置为 true，则 stdin 在容器启动时打开，在第一个客户端连接到 stdin 之前为空， 然后保持打开并接受数据，直到客户端断开连接，此时 stdin 关闭并保持关闭直到容器重新启动。 如果此标志为 false，则从 stdin 读取的容器进程将永远不会收到 EOF。默认为 false"}
        self.stdin_once = stdin_once
        # {"en": "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.", "zh_CN": "可选字段。挂载到容器文件系统的一个路径，容器终止消息写入到该路径下的文件中。 写入的消息旨在成为简短的最终状态，例如断言失败消息。如果大于 4096 字节，将被节点截断。 所有容器的总消息长度将限制为 12 KB。默认为 /dev/termination-log。无法更新"}
        self.termination_message_path = termination_message_path
        # {"en": "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.", "zh_CN": "指示应如何填充终止消息。字段值 File 将使用 terminateMessagePath 的内容来填充成功和失败的容器状态消息。 如果终止消息文件为空并且容器因错误退出，FallbackToLogsOnError 将使用容器日志输出的最后一块。 日志输出限制为 2048 字节或 80 行，以较小者为准。默认为 File。无法更新"}
        self.termination_message_policy = termination_message_policy
        # {"en": "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.", "zh_CN": "这个容器是否应该为自己分配一个 TTY，也需要 stdin 为 true。默认为 false"}
        self.tty = tty
        # {"en": "volumeDevices is the list of block devices to be used by the container.", "zh_CN": "容器要使用的块设备列表"}
        self.volume_devices = volume_devices
        # {"en": "Pod volumes to mount into the container's filesystem. Cannot be updated.", "zh_CN": "要挂载到容器文件系统中的 Pod 卷。无法更新"}
        self.volume_mounts = volume_mounts
        # {"en": "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.", "zh_CN": "容器的工作目录。如果未指定，将使用容器运行时的默认值，默认值可能在容器镜像中配置。无法更新"}
        self.working_dir = working_dir

    def validate(self):
        if self.env:
            for k in self.env:
                if k:
                    k.validate()
        if self.env_from:
            for k in self.env_from:
                if k:
                    k.validate()
        if self.lifecycle:
            self.lifecycle.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        self.validate_required(self.name, 'name')
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.resources:
            self.resources.validate()
        if self.security_context:
            self.security_context.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.volume_devices:
            for k in self.volume_devices:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        if self.env is not None:
            result['env'] = []
            for k in self.env:
                result['env'].append(k.to_map() if k else None)
        if self.env_from is not None:
            result['envFrom'] = []
            for k in self.env_from:
                result['envFrom'].append(k.to_map() if k else None)
        if self.image is not None:
            result['image'] = self.image
        if self.image_pull_policy is not None:
            result['imagePullPolicy'] = self.image_pull_policy
        if self.lifecycle is not None:
            result['lifecycle'] = self.lifecycle.to_map()
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.ports is not None:
            result['ports'] = []
            for k in self.ports:
                result['ports'].append(k.to_map() if k else None)
        if self.readiness_probe is not None:
            result['readinessProbe'] = self.readiness_probe.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdin_once is not None:
            result['stdinOnce'] = self.stdin_once
        if self.termination_message_path is not None:
            result['terminationMessagePath'] = self.termination_message_path
        if self.termination_message_policy is not None:
            result['terminationMessagePolicy'] = self.termination_message_policy
        if self.tty is not None:
            result['tty'] = self.tty
        if self.volume_devices is not None:
            result['volumeDevices'] = []
            for k in self.volume_devices:
                result['volumeDevices'].append(k.to_map() if k else None)
        if self.volume_mounts is not None:
            result['volumeMounts'] = []
            for k in self.volume_mounts:
                result['volumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['workingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('env') is not None:
            self.env = []
            for k in m.get('env'):
                temp_model = ListJobIoK8sApiCoreV1EnvVar()
                self.env.append(temp_model.from_map(k))
        if m.get('envFrom') is not None:
            self.env_from = []
            for k in m.get('envFrom'):
                temp_model = ListJobIoK8sApiCoreV1EnvFromSource()
                self.env_from.append(temp_model.from_map(k))
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('imagePullPolicy') is not None:
            self.image_pull_policy = m.get('imagePullPolicy')
        if m.get('lifecycle') is not None:
            temp_model = ListJobIoK8sApiCoreV1Lifecycle()
            self.lifecycle = temp_model.from_map(m['lifecycle'])
        if m.get('livenessProbe') is not None:
            temp_model = ListJobIoK8sApiCoreV1Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ports') is not None:
            self.ports = []
            for k in m.get('ports'):
                temp_model = ListJobIoK8sApiCoreV1ContainerPort()
                self.ports.append(temp_model.from_map(k))
        if m.get('readinessProbe') is not None:
            temp_model = ListJobIoK8sApiCoreV1Probe()
            self.readiness_probe = temp_model.from_map(m['readinessProbe'])
        if m.get('resources') is not None:
            temp_model = ListJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('securityContext') is not None:
            temp_model = ListJobIoK8sApiCoreV1SecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('startupProbe') is not None:
            temp_model = ListJobIoK8sApiCoreV1Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdinOnce') is not None:
            self.stdin_once = m.get('stdinOnce')
        if m.get('terminationMessagePath') is not None:
            self.termination_message_path = m.get('terminationMessagePath')
        if m.get('terminationMessagePolicy') is not None:
            self.termination_message_policy = m.get('terminationMessagePolicy')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        if m.get('volumeDevices') is not None:
            self.volume_devices = []
            for k in m.get('volumeDevices'):
                temp_model = ListJobIoK8sApiCoreV1VolumeDevice()
                self.volume_devices.append(temp_model.from_map(k))
        if m.get('volumeMounts') is not None:
            self.volume_mounts = []
            for k in m.get('volumeMounts'):
                temp_model = ListJobIoK8sApiCoreV1VolumeMount()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('workingDir') is not None:
            self.working_dir = m.get('workingDir')
        return self


class ListJobIoK8sApiCoreV1PodDNSConfigOption(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "Required.", "zh_CN": "必需字段"}
        self.name = name
        # {"en": "Optional", "zh_CN": "选项取值"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ListJobIoK8sApiCoreV1PodDNSConfig(TeaModel):
    def __init__(
        self,
        nameservers: List[str] = None,
        options: List[ListJobIoK8sApiCoreV1PodDNSConfigOption] = None,
        searches: List[str] = None,
    ):
        # {"en": "A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.", "zh_CN": "DNS 名字服务器的 IP 地址列表。此列表将被追加到基于 dnsPolicy 生成的基本名字服务器列表。 重复的名字服务器将被删除"}
        self.nameservers = nameservers
        # {"en": "A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.", "zh_CN": "DNS 解析器选项列表。此处的选项将与基于 dnsPolicy 所生成的基本选项合并。重复的条目将被删除。 options 中所给出的解析选项将覆盖基本 dnsPolicy 中出现的对应选项"}
        self.options = options
        # {"en": "A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.", "zh_CN": "用于主机名查找的 DNS 搜索域列表。这一列表将被追加到基于 dnsPolicy 生成的基本搜索路径列表。 重复的搜索路径将被删除"}
        self.searches = searches

    def validate(self):
        if self.options:
            for k in self.options:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nameservers is not None:
            result['nameservers'] = self.nameservers
        if self.options is not None:
            result['options'] = []
            for k in self.options:
                result['options'].append(k.to_map() if k else None)
        if self.searches is not None:
            result['searches'] = self.searches
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nameservers') is not None:
            self.nameservers = m.get('nameservers')
        if m.get('options') is not None:
            self.options = []
            for k in m.get('options'):
                temp_model = ListJobIoK8sApiCoreV1PodDNSConfigOption()
                self.options.append(temp_model.from_map(k))
        if m.get('searches') is not None:
            self.searches = m.get('searches')
        return self


class ListJobIoK8sApiCoreV1EphemeralContainer(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
        env: List[ListJobIoK8sApiCoreV1EnvVar] = None,
        env_from: List[ListJobIoK8sApiCoreV1EnvFromSource] = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle: ListJobIoK8sApiCoreV1Lifecycle = None,
        liveness_probe: ListJobIoK8sApiCoreV1Probe = None,
        name: str = None,
        ports: List[ListJobIoK8sApiCoreV1ContainerPort] = None,
        readiness_probe: ListJobIoK8sApiCoreV1Probe = None,
        resources: ListJobIoK8sApiCoreV1ResourceRequirements = None,
        security_context: ListJobIoK8sApiCoreV1SecurityContext = None,
        startup_probe: ListJobIoK8sApiCoreV1Probe = None,
        stdin: bool = None,
        stdin_once: bool = None,
        target_container_name: str = None,
        termination_message_path: str = None,
        termination_message_policy: str = None,
        tty: bool = None,
        volume_devices: List[ListJobIoK8sApiCoreV1VolumeDevice] = None,
        volume_mounts: List[ListJobIoK8sApiCoreV1VolumeMount] = None,
        working_dir: str = None,
    ):
        # {"en": "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "entrypoint 的参数。如果未提供，则使用镜像的 CMD。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.args = args
        # {"en": "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "入口点数组。不在 Shell 中执行。如果未提供，则使用镜像的 ENTRYPOINT。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.command = command
        # {"en": "List of environment variables to set in the container. Cannot be updated.", "zh_CN": "要在容器中设置的环境变量列表。无法更新"}
        self.env = env
        # {"en": "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.", "zh_CN": "在容器中填充环境变量的来源列表。在来源中定义的键名必须是 C_IDENTIFIER。 容器启动时，所有无效键都将作为事件报告。当一个键存在于多个来源中时，与最后一个来源关联的值将优先。 如果有重复主键，env 中定义的值将优先。无法更新"}
        self.env_from = env_from
        # {"en": "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images", "zh_CN": "容器镜像名称"}
        self.image = image
        # {"en": "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images", "zh_CN": "镜像拉取策略。取值为 Always、Never、IfNotPresent 之一。 如果指定了 :latest 标签，则默认为 Always，否则默认为 IfNotPresent。 无法更新"}
        self.image_pull_policy = image_pull_policy
        # {"en": "Lifecycle is not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用生命周期"}
        self.lifecycle = lifecycle
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.liveness_probe = liveness_probe
        # {"en": "Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.", "zh_CN": "以 DNS_LABEL 形式设置的临时容器的名称。此名称在所有容器、Init 容器和临时容器中必须是唯一的"}
        self.name = name
        # {"en": "Ports are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用端口"}
        self.ports = ports
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.readiness_probe = readiness_probe
        # {"en": "Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.", "zh_CN": "临时容器不允许使用资源。临时容器使用已分配给 Pod 的空闲资源"}
        self.resources = resources
        # {"en": "Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext", "zh_CN": "可选字段。securityContext 定义了运行临时容器的安全选项。 如果设置了此字段，SecurityContext 的字段将覆盖 PodSecurityContext 的等效字段"}
        self.security_context = security_context
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.startup_probe = startup_probe
        # {"en": "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.", "zh_CN": "是否应在容器运行时内为此容器 stdin 分配缓冲区。 如果未设置，从容器中的 stdin 读数据将始终导致 EOF。默认为 false"}
        self.stdin = stdin
        # {"en": "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false", "zh_CN": "容器运行时是否应在某个 attach 操作打开 stdin 通道后关闭它。 当 stdin 为 true 时，stdin 流将在多个 attach 会话中保持打开状态。 如果 stdinOnce 设置为 true，则 stdin 在容器启动时打开，在第一个客户端连接到 stdin 之前为空， 然后保持打开并接受数据，直到客户端断开连接，此时 stdin 关闭并保持关闭直到容器重新启动。 如果此标志为 false，则从 stdin 读取的容器进程将永远不会收到 EOF。默认为 false"}
        self.stdin_once = stdin_once
        # {"en": "If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.", "zh_CN": "如果设置，则为 Pod 规约中此临时容器所针对的容器的名称。临时容器将在该容器的名字空间（IPC、PID 等）中运行。 如果未设置，则临时容器使用 Pod 规约中配置的名字空间。容器运行时必须实现对此功能的支持。如果运行时不支持名字空间定位，则设置此字段的结果是未定义的"}
        self.target_container_name = target_container_name
        # {"en": "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.", "zh_CN": "可选字段。挂载到容器文件系统的路径，用于写入容器终止消息的文件。 写入的消息旨在成为简短的最终状态，例如断言失败消息。如果超出 4096 字节，将被节点截断。 所有容器的总消息长度将限制为 12 KB。默认为 /dev/termination-log。无法更新"}
        self.termination_message_path = termination_message_path
        # {"en": "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.", "zh_CN": "指示应如何填充终止消息。字段值为 File 表示将使用 terminateMessagePath 的内容来填充成功和失败的容器状态消息。 如果终止消息文件为空并且容器因错误退出，字段值 FallbackToLogsOnError 表示将使用容器日志输出的最后一块。日志输出限制为 2048 字节或 80 行，以较小者为准。 默认为 File。无法更新"}
        self.termination_message_policy = termination_message_policy
        # {"en": "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.", "zh_CN": "这个容器是否应该为自己分配一个 TTY，也需要 stdin 为 true。默认为 false"}
        self.tty = tty
        # {"en": "volumeDevices is the list of block devices to be used by the container.", "zh_CN": "volumeDevices 是容器要使用的块设备列表"}
        self.volume_devices = volume_devices
        # {"en": "Pod volumes to mount into the container's filesystem. Cannot be updated.", "zh_CN": "要挂载到容器文件系统中的 Pod 卷。临时容器不允许子路径挂载。无法更新"}
        self.volume_mounts = volume_mounts
        # {"en": "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.", "zh_CN": "容器的工作目录。如果未指定，将使用容器运行时的默认值，默认值可能在容器镜像中配置。无法更新"}
        self.working_dir = working_dir

    def validate(self):
        if self.env:
            for k in self.env:
                if k:
                    k.validate()
        if self.env_from:
            for k in self.env_from:
                if k:
                    k.validate()
        if self.lifecycle:
            self.lifecycle.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        self.validate_required(self.name, 'name')
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.resources:
            self.resources.validate()
        if self.security_context:
            self.security_context.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.volume_devices:
            for k in self.volume_devices:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        if self.env is not None:
            result['env'] = []
            for k in self.env:
                result['env'].append(k.to_map() if k else None)
        if self.env_from is not None:
            result['envFrom'] = []
            for k in self.env_from:
                result['envFrom'].append(k.to_map() if k else None)
        if self.image is not None:
            result['image'] = self.image
        if self.image_pull_policy is not None:
            result['imagePullPolicy'] = self.image_pull_policy
        if self.lifecycle is not None:
            result['lifecycle'] = self.lifecycle.to_map()
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.ports is not None:
            result['ports'] = []
            for k in self.ports:
                result['ports'].append(k.to_map() if k else None)
        if self.readiness_probe is not None:
            result['readinessProbe'] = self.readiness_probe.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdin_once is not None:
            result['stdinOnce'] = self.stdin_once
        if self.target_container_name is not None:
            result['targetContainerName'] = self.target_container_name
        if self.termination_message_path is not None:
            result['terminationMessagePath'] = self.termination_message_path
        if self.termination_message_policy is not None:
            result['terminationMessagePolicy'] = self.termination_message_policy
        if self.tty is not None:
            result['tty'] = self.tty
        if self.volume_devices is not None:
            result['volumeDevices'] = []
            for k in self.volume_devices:
                result['volumeDevices'].append(k.to_map() if k else None)
        if self.volume_mounts is not None:
            result['volumeMounts'] = []
            for k in self.volume_mounts:
                result['volumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['workingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('env') is not None:
            self.env = []
            for k in m.get('env'):
                temp_model = ListJobIoK8sApiCoreV1EnvVar()
                self.env.append(temp_model.from_map(k))
        if m.get('envFrom') is not None:
            self.env_from = []
            for k in m.get('envFrom'):
                temp_model = ListJobIoK8sApiCoreV1EnvFromSource()
                self.env_from.append(temp_model.from_map(k))
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('imagePullPolicy') is not None:
            self.image_pull_policy = m.get('imagePullPolicy')
        if m.get('lifecycle') is not None:
            temp_model = ListJobIoK8sApiCoreV1Lifecycle()
            self.lifecycle = temp_model.from_map(m['lifecycle'])
        if m.get('livenessProbe') is not None:
            temp_model = ListJobIoK8sApiCoreV1Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ports') is not None:
            self.ports = []
            for k in m.get('ports'):
                temp_model = ListJobIoK8sApiCoreV1ContainerPort()
                self.ports.append(temp_model.from_map(k))
        if m.get('readinessProbe') is not None:
            temp_model = ListJobIoK8sApiCoreV1Probe()
            self.readiness_probe = temp_model.from_map(m['readinessProbe'])
        if m.get('resources') is not None:
            temp_model = ListJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('securityContext') is not None:
            temp_model = ListJobIoK8sApiCoreV1SecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('startupProbe') is not None:
            temp_model = ListJobIoK8sApiCoreV1Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdinOnce') is not None:
            self.stdin_once = m.get('stdinOnce')
        if m.get('targetContainerName') is not None:
            self.target_container_name = m.get('targetContainerName')
        if m.get('terminationMessagePath') is not None:
            self.termination_message_path = m.get('terminationMessagePath')
        if m.get('terminationMessagePolicy') is not None:
            self.termination_message_policy = m.get('terminationMessagePolicy')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        if m.get('volumeDevices') is not None:
            self.volume_devices = []
            for k in m.get('volumeDevices'):
                temp_model = ListJobIoK8sApiCoreV1VolumeDevice()
                self.volume_devices.append(temp_model.from_map(k))
        if m.get('volumeMounts') is not None:
            self.volume_mounts = []
            for k in m.get('volumeMounts'):
                temp_model = ListJobIoK8sApiCoreV1VolumeMount()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('workingDir') is not None:
            self.working_dir = m.get('workingDir')
        return self


class ListJobIoK8sApiCoreV1HostAlias(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        # {"en": "Hostnames for the above IP address.", "zh_CN": "指定 IP 地址对应的主机名"}
        self.hostnames = hostnames
        # {"en": "IP address of the host file entry.", "zh_CN": "主机文件条目的 IP 地址"}
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['hostnames'] = self.hostnames
        if self.ip is not None:
            result['ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hostnames') is not None:
            self.hostnames = m.get('hostnames')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        return self


class ListJobIoK8sApiCoreV1LocalObjectReference(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用者的名称"}
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ListJobIoK8sApiCoreV1PodReadinessGate(TeaModel):
    def __init__(
        self,
        condition_type: str = None,
    ):
        # {"en": "ConditionType refers to a condition in the pod's condition list with matching type.", "zh_CN": "指 Pod 的状况列表中类型匹配的状况"}
        self.condition_type = condition_type

    def validate(self):
        self.validate_required(self.condition_type, 'condition_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_type is not None:
            result['conditionType'] = self.condition_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conditionType') is not None:
            self.condition_type = m.get('conditionType')
        return self


class ListJobIoK8sApiCoreV1Sysctl(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "Name of a property to set", "zh_CN": "要设置的属性的名称"}
        self.name = name
        # {"en": "Value of a property to set", "zh_CN": "要设置的属性值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ListJobIoK8sApiCoreV1PodSecurityContext(TeaModel):
    def __init__(
        self,
        fs_group: int = None,
        fs_group_change_policy: str = None,
        run_as_group: int = None,
        run_as_non_root: bool = None,
        run_as_user: int = None,
        se_linux_options: ListJobIoK8sApiCoreV1SELinuxOptions = None,
        seccomp_profile: ListJobIoK8sApiCoreV1SeccompProfile = None,
        supplemental_groups: List[int] = None,
        sysctls: List[ListJobIoK8sApiCoreV1Sysctl] = None,
        windows_options: ListJobIoK8sApiCoreV1WindowsSecurityContextOptions = None,
    ):
        # {"en": "A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----.If unset, the Kubelet will not modify the ownership and permissions of any volume.", "zh_CN": "应用到 Pod 中所有容器的特殊补充组。某些卷类型允许 kubelet 将该卷的所有权更改为由 Pod 拥有：1. 文件系统的属主 GID 将是 fsGroup 字段值2. setgid 位已设置（在卷中创建的新文件将归 fsGroup 所有）3. 权限位将与 rw-rw---- 进行按位或操作。如果未设置此字段，kubelet 不会修改任何卷的所有权和权限。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.fs_group = fs_group
        # {"en": "fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are OnRootMismatch and Always. If not specified, Always is used.", "zh_CN": "fsGroupChangePolicy 定义了在卷被在 Pod 中暴露之前更改其属主和权限的行为。 此字段仅适用于支持基于 fsGroup 的属主权（和权限）的卷类型。它不会影响临时卷类型， 例如：secret、configmap 和 emptydir。 有效值为 OnRootMismatch 和 Always。如果未设置，则使用 Always。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.fs_group_change_policy = fs_group_change_policy
        # {"en": "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "运行容器进程入口点（Entrypoint）的 GID。如果未设置，则使用运行时的默认值。 也可以在 SecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置， 则在对应容器中设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_group = run_as_group
        # {"en": "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "指示容器必须以非 root 用户身份运行。如果为 true，kubelet 将在运行时验证镜像， 以确保它不会以 UID 0（root）身份运行。如果镜像中确实使用 root 账号启动，则容器无法被启动。 如果此字段未设置或为 false，则不会执行此类验证。也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_non_root = run_as_non_root
        # {"en": "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "运行容器进程入口点（Entrypoint）的 UID。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在对应容器中所设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.run_as_user = run_as_user
        # {"en": "The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "应用于所有容器的 SELinux 上下文。如果未设置，容器运行时将为每个容器分配一个随机 SELinux 上下文。 也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在对应容器中设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.se_linux_options = se_linux_options
        # {"en": "The seccomp options to use by the containers in this pod.", "zh_CN": "此 Pod 中的容器使用的 seccomp 选项。注意，spec.os.name 为 windows 时不能设置此字段"}
        self.seccomp_profile = seccomp_profile
        # {"en": "A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.", "zh_CN": "此字段包含将应用到每个容器中运行的第一个进程的组列表。 容器进程的组成员身份取决于容器的主 GID、fsGroup（如果指定了的话） 和在容器镜像中为容器进程的 uid 定义的组成员身份，以及这里所给的列表。如果未指定，则不会向任何容器添加其他组。 注意，在容器镜像中为容器进程的 uid 定义的组成员身份仍然有效， 即使它们未包含在此列表中也是如此。 注意，当 spec.os.name 为 windows 时，不能设置此字段"}
        self.supplemental_groups = supplemental_groups
        # {"en": "Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.", "zh_CN": "sysctls 包含用于 Pod 的名字空间 sysctl 列表。具有不受（容器运行时）支持的 sysctl 的 Pod 可能无法启动。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.sysctls = sysctls
        # {"en": "The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用到所有容器上的、特定于 Windows 的设置。 如果未设置此字段，将使用容器的 SecurityContext 中的选项。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 linux 时不能设置该字段"}
        self.windows_options = windows_options

    def validate(self):
        if self.se_linux_options:
            self.se_linux_options.validate()
        if self.seccomp_profile:
            self.seccomp_profile.validate()
        if self.sysctls:
            for k in self.sysctls:
                if k:
                    k.validate()
        if self.windows_options:
            self.windows_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_group is not None:
            result['fsGroup'] = self.fs_group
        if self.fs_group_change_policy is not None:
            result['fsGroupChangePolicy'] = self.fs_group_change_policy
        if self.run_as_group is not None:
            result['runAsGroup'] = self.run_as_group
        if self.run_as_non_root is not None:
            result['runAsNonRoot'] = self.run_as_non_root
        if self.run_as_user is not None:
            result['runAsUser'] = self.run_as_user
        if self.se_linux_options is not None:
            result['seLinuxOptions'] = self.se_linux_options.to_map()
        if self.seccomp_profile is not None:
            result['seccompProfile'] = self.seccomp_profile.to_map()
        if self.supplemental_groups is not None:
            result['supplementalGroups'] = self.supplemental_groups
        if self.sysctls is not None:
            result['sysctls'] = []
            for k in self.sysctls:
                result['sysctls'].append(k.to_map() if k else None)
        if self.windows_options is not None:
            result['windowsOptions'] = self.windows_options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsGroup') is not None:
            self.fs_group = m.get('fsGroup')
        if m.get('fsGroupChangePolicy') is not None:
            self.fs_group_change_policy = m.get('fsGroupChangePolicy')
        if m.get('runAsGroup') is not None:
            self.run_as_group = m.get('runAsGroup')
        if m.get('runAsNonRoot') is not None:
            self.run_as_non_root = m.get('runAsNonRoot')
        if m.get('runAsUser') is not None:
            self.run_as_user = m.get('runAsUser')
        if m.get('seLinuxOptions') is not None:
            temp_model = ListJobIoK8sApiCoreV1SELinuxOptions()
            self.se_linux_options = temp_model.from_map(m['seLinuxOptions'])
        if m.get('seccompProfile') is not None:
            temp_model = ListJobIoK8sApiCoreV1SeccompProfile()
            self.seccomp_profile = temp_model.from_map(m['seccompProfile'])
        if m.get('supplementalGroups') is not None:
            self.supplemental_groups = m.get('supplementalGroups')
        if m.get('sysctls') is not None:
            self.sysctls = []
            for k in m.get('sysctls'):
                temp_model = ListJobIoK8sApiCoreV1Sysctl()
                self.sysctls.append(temp_model.from_map(k))
        if m.get('windowsOptions') is not None:
            temp_model = ListJobIoK8sApiCoreV1WindowsSecurityContextOptions()
            self.windows_options = temp_model.from_map(m['windowsOptions'])
        return self


class ListJobIoK8sApiCoreV1Toleration(TeaModel):
    def __init__(
        self,
        effect: str = None,
        key: str = None,
        operator: str = None,
        toleration_seconds: int = None,
        value: str = None,
    ):
        # {"en": "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.", "zh_CN": "指示要匹配的污点效果。空值意味著匹配所有污点效果。如果要设置此字段，允许的值为 NoSchedule、PreferNoSchedule 和 NoExecute 之一"}
        self.effect = effect
        # {"en": "Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.", "zh_CN": "容忍度所适用的污点的键名。此字段为空意味着匹配所有的污点键。 如果 key 为空，则 operator 必须为 Exists；这种组合意味着匹配所有值和所有键"}
        self.key = key
        # {"en": "Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.", "zh_CN": "表示 key 与 value 之间的关系。有效的 operator 取值是 Exists 和 Equal。默认为 Equal。 Exists 相当于 value 为某种通配符，因此 Pod 可以容忍特定类别的所有污点"}
        self.operator = operator
        # {"en": "TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.", "zh_CN": "表示容忍度（effect 必须是 NoExecute，否则此字段被忽略）容忍污点的时间长度。 默认情况下，此字段未被设置，这意味着会一直能够容忍对应污点（不会发生驱逐操作）。 零值和负值会被系统当做 0 值处理（立即触发驱逐）"}
        self.toleration_seconds = toleration_seconds
        # {"en": "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.", "zh_CN": "容忍度所匹配的污点值。如果 operator 为 Exists，则此 value 值应该为空， 否则 value 值应该是一个正常的字符串"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['effect'] = self.effect
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.toleration_seconds is not None:
            result['tolerationSeconds'] = self.toleration_seconds
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effect') is not None:
            self.effect = m.get('effect')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('tolerationSeconds') is not None:
            self.toleration_seconds = m.get('tolerationSeconds')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ListJobIoK8sApiCoreV1TopologySpreadConstraint(TeaModel):
    def __init__(
        self,
        label_selector: ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        max_skew: int = None,
        topology_key: str = None,
        when_unsatisfiable: str = None,
    ):
        # {"en": "LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.", "zh_CN": "用于识别匹配的 Pod。对匹配此标签选择算符的 Pod 进行计数， 以确定其相应拓扑域中的 Pod 数量"}
        self.label_selector = label_selector
        # {"en": "MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.", "zh_CN": "maxSkew 描述 Pod 可能分布不均衡的程度。当 whenUnsatisfiable=DoNotSchedule 时， 此字段值是目标拓扑中匹配的 Pod 数量与全局最小值之间的最大允许差值。 全局最小值是候选域中匹配 Pod 的最小数量，如果候选域的数量小于 minDomains，则为零。 例如，在一个包含三个可用区的集群中，maxSkew 设置为 1，具有相同 labelSelector 的 Pod 分布为 2/2/1： 在这种情况下，全局最小值为 1。当 whenUnsatisfiable=ScheduleAnyway 时，此字段被用来给满足此约束的拓扑域更高的优先级。此字段是一个必填字段。默认值为 1，不允许为 0"}
        self.max_skew = max_skew
        # {"en": "TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a bucket, and try to put balanced number of pods into each bucket. It's a required field.", "zh_CN": "topologyKey 是节点标签的键名。如果节点的标签中包含此键名且键值亦相同，则被认为在相同的拓扑域中。 我们将每个 <键, 值> 视为一个 “桶（Bucket）”，并尝试将数量均衡的 Pod 放入每个桶中。 我们定义域（Domain）为拓扑域的特定实例。 此外，我们定义一个候选域（Eligible Domain）为其节点与 nodeAffinityPolicy 和 nodeTaintsPolicy 的要求匹配的域。 例如，如果 topologyKey 是 kubernetes.io/hostname，则每个 Node 都是该拓扑的域。 而如果 topologyKey 是 topology.kubernetes.io/zone，则每个区域都是该拓扑的一个域。 这是一个必填字段"}
        self.topology_key = topology_key
        # {"en": "WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,but giving higher precedence to topologies that would help reduce the skew.A constraint is considered Unsatisfiable for an incoming pod if and only if every possible node assigment for that pod would violate MaxSkew on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.", "zh_CN": "whenUnsatisfiable 表示如果 Pod 不满足分布约束，如何处理它。- DoNotSchedule（默认）：告诉调度器不要调度它。- ScheduleAnyway：告诉调度器将 Pod 调度到任何位置，但给予能够降低偏差的拓扑更高的优先级。当且仅当该 Pod 的每个可能的节点分配都会违反某些拓扑对应的 “maxSkew” 时， 才认为传入 Pod 的约束是 “不可满足的”"}
        self.when_unsatisfiable = when_unsatisfiable

    def validate(self):
        if self.label_selector:
            self.label_selector.validate()
        self.validate_required(self.max_skew, 'max_skew')
        self.validate_required(self.topology_key, 'topology_key')
        self.validate_required(self.when_unsatisfiable, 'when_unsatisfiable')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector.to_map()
        if self.max_skew is not None:
            result['maxSkew'] = self.max_skew
        if self.topology_key is not None:
            result['topologyKey'] = self.topology_key
        if self.when_unsatisfiable is not None:
            result['whenUnsatisfiable'] = self.when_unsatisfiable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('labelSelector') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.label_selector = temp_model.from_map(m['labelSelector'])
        if m.get('maxSkew') is not None:
            self.max_skew = m.get('maxSkew')
        if m.get('topologyKey') is not None:
            self.topology_key = m.get('topologyKey')
        if m.get('whenUnsatisfiable') is not None:
            self.when_unsatisfiable = m.get('whenUnsatisfiable')
        return self


class ListJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        partition: int = None,
        read_only: bool = None,
        volume_id: str = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "fsType 是你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型"}
        self.fs_type = fs_type
        # {"en": "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as 1. Similarly, the volume partition for /dev/sda is 0 (or you can leave the property empty).", "zh_CN": "partition 是你要挂载的卷中的分区。如果省略，则默认为按卷名称进行挂载"}
        self.partition = partition
        # {"en": "Specify true to force and set the ReadOnly property in VolumeMounts to true. If omitted, the default is false. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "readOnly 值为 true 将使得卷挂载被强制设置为 readOnly"}
        self.read_only = read_only
        # {"en": "Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "volumeID 是 AWS（Amazon EBS 卷）中持久磁盘资源的唯一 ID"}
        self.volume_id = volume_id

    def validate(self):
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class ListJobIoK8sApiCoreV1AzureDiskVolumeSource(TeaModel):
    def __init__(
        self,
        caching_mode: str = None,
        disk_name: str = None,
        disk_uri: str = None,
        fs_type: str = None,
        kind: str = None,
        read_only: bool = None,
    ):
        # {"en": "Host Caching mode: None, Read Only, Read Write.", "zh_CN": "主机缓存（Host Caching）模式：None、Read Only、Read Write"}
        self.caching_mode = caching_mode
        # {"en": "The Name of the data disk in the blob storage", "zh_CN": "Blob 存储中数据盘的名称"}
        self.disk_name = disk_name
        # {"en": "The URI the data disk in the blob storage", "zh_CN": "Blob 存储中数据盘的 URI"}
        self.disk_uri = disk_uri
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一"}
        self.fs_type = fs_type
        # {"en": "Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared", "zh_CN": "kind 预期值包括：Shared：每个存储帐户多个 Blob 磁盘；Dedicated：每个存储帐户单个 Blob 磁盘；Managed：azure 托管的数据盘（仅托管的可用性集合中）。默认为 Shared"}
        self.kind = kind
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.disk_uri, 'disk_uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caching_mode is not None:
            result['cachingMode'] = self.caching_mode
        if self.disk_name is not None:
            result['diskName'] = self.disk_name
        if self.disk_uri is not None:
            result['diskURI'] = self.disk_uri
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.kind is not None:
            result['kind'] = self.kind
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cachingMode') is not None:
            self.caching_mode = m.get('cachingMode')
        if m.get('diskName') is not None:
            self.disk_name = m.get('diskName')
        if m.get('diskURI') is not None:
            self.disk_uri = m.get('diskURI')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class ListJobIoK8sApiCoreV1AzureFileVolumeSource(TeaModel):
    def __init__(
        self,
        read_only: bool = None,
        secret_name: str = None,
        share_name: str = None,
    ):
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "the name of secret that contains Azure Storage Account Name and Key", "zh_CN": "包含 Azure 存储账号名称和主键的 Secret 的名称"}
        self.secret_name = secret_name
        # {"en": "Share Name", "zh_CN": "Azure 共享名称"}
        self.share_name = share_name

    def validate(self):
        self.validate_required(self.secret_name, 'secret_name')
        self.validate_required(self.share_name, 'share_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_name is not None:
            result['secretName'] = self.secret_name
        if self.share_name is not None:
            result['shareName'] = self.share_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretName') is not None:
            self.secret_name = m.get('secretName')
        if m.get('shareName') is not None:
            self.share_name = m.get('shareName')
        return self


class ListJobIoK8sApiCoreV1CephFSVolumeSource(TeaModel):
    def __init__(
        self,
        monitors: List[str] = None,
        path: str = None,
        read_only: bool = None,
        secret_file: str = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        user: str = None,
    ):
        # {"en": "Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "必需的。monitors 是 Ceph 监测的集合"}
        self.monitors = monitors
        # {"en": "Optional: Used as the mounted root, rather than the full Ceph tree, default is /", "zh_CN": "可选的。用作挂载的根，而不是挂载完整的 Ceph 树，默认为 “/”"}
        self.path = path
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。默认为 false（读/写）。 此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "secretFile 是可选的。secretFile 是 User 对应的密钥环的路径，默认为 /etc/ceph/user.secret"}
        self.secret_file = secret_file
        # {"en": "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。secretRef 是针对用户的身份认证 Secret 的引用，默认为空"}
        self.secret_ref = secret_ref
        # {"en": "Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。user 是 rados 用户名，默认为 admin"}
        self.user = user

    def validate(self):
        self.validate_required(self.monitors, 'monitors')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitors is not None:
            result['monitors'] = self.monitors
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_file is not None:
            result['secretFile'] = self.secret_file
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('monitors') is not None:
            self.monitors = m.get('monitors')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretFile') is not None:
            self.secret_file = m.get('secretFile')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class ListJobIoK8sApiCoreV1CinderVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        volume_id: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一"}
        self.fs_type = fs_type
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": " 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: points to a secret object containing parameters used to connect to OpenStack.", "zh_CN": "可选的。指向 Secret 对象，内含的参数用于连接到 OpenStack"}
        self.secret_ref = secret_ref
        # {"en": "volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "用于标识 Cinder 中的卷"}
        self.volume_id = volume_id

    def validate(self):
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class ListJobIoK8sApiCoreV1KeyToPath(TeaModel):
    def __init__(
        self,
        key: str = None,
        mode: int = None,
        path: str = None,
    ):
        # {"en": "The key to project.", "zh_CN": "要投射的键"}
        self.key = key
        # {"en": "Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "mode 是可选的：模式位用于为文件设置权限。必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 如果未指定，则将使用卷 defaultMode。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.mode = mode
        # {"en": "The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.", "zh_CN": "将键映射到的文件的相对路径。不能是绝对路径。不能包含路径元素 “..”。不能以字符串 “..” 开头"}
        self.path = path

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.mode is not None:
            result['mode'] = self.mode
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class ListJobIoK8sApiCoreV1ConfigMapVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[ListJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. ListJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 ConfigMap 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 ConfigMap 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its keys must be defined", "zh_CN": "指定是否所引用的 ConfigMap 或其键必须已经被定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1CSIVolumeSource(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        node_publish_secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        read_only: bool = None,
        volume_attributes: Dict[str, Any] = None,
    ):
        # {"en": "Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.", "zh_CN": "处理此卷的 CSI 驱动的名称。咨询你的管理员以获取在集群中注册的正确名称"}
        self.driver = driver
        # {"en": "Filesystem type to mount. Ex. ext4, xfs, ntfs. If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.", "zh_CN": "要挂载的 fsType。例如 “ext4”、“xfs”、“ntfs”。 如果未提供，则将空值传递给关联的 CSI 驱动，以便决定要应用的默认文件系统"}
        self.fs_type = fs_type
        # {"en": "NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.", "zh_CN": "对包含敏感信息的 Secret 对象的引用， 该 Secret 对象将被传递到 CSI 驱动以完成 CSI NodePublishVolume 和 NodeUnpublishVolume 调用。 此字段是可选的，如果不需要 Secret，则此字段可以为空。 如果 Secret 对象包含多个 Secret，则所有 Secret 引用将被传递"}
        self.node_publish_secret_ref = node_publish_secret_ref
        # {"en": "Specifies a read-only configuration for the volume. Defaults to false (read/write).", "zh_CN": "指定供卷使用的只读配置。默认为 false（读/写）"}
        self.read_only = read_only
        # {"en": "VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.", "zh_CN": "存储传递给 CSI 驱动且特定于驱动的属性。查阅你的驱动文档，了解支持的值"}
        self.volume_attributes = volume_attributes

    def validate(self):
        self.validate_required(self.driver, 'driver')
        if self.node_publish_secret_ref:
            self.node_publish_secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['driver'] = self.driver
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.node_publish_secret_ref is not None:
            result['nodePublishSecretRef'] = self.node_publish_secret_ref.to_map()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_attributes is not None:
            result['volumeAttributes'] = self.volume_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('driver') is not None:
            self.driver = m.get('driver')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('nodePublishSecretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.node_publish_secret_ref = temp_model.from_map(m['nodePublishSecretRef'])
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeAttributes') is not None:
            self.volume_attributes = m.get('volumeAttributes')
        return self


class ListJobIoK8sApiCoreV1DownwardAPIVolumeFile(TeaModel):
    def __init__(
        self,
        field_ref: ListJobIoK8sApiCoreV1ObjectFieldSelector = None,
        mode: int = None,
        path: str = None,
        resource_field_ref: ListJobIoK8sApiCoreV1ResourceFieldSelector = None,
    ):
        # {"en": "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.", "zh_CN": "必需。选择 Pod 的字段：仅支持注解、标签、名称和名字空间"}
        self.field_ref = field_ref
        # {"en": "Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "可选：模式位用于设置文件的权限，必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 如果未指定，则将使用卷 defaultMode。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.mode = mode
        # {"en": "Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'", "zh_CN": "必需。path 是要创建的文件的相对路径名称。不得使用绝对路径，也不得包含 “..” 路径。 必须用 UTF-8 进行编码。相对路径的第一项不得用 “..” 开头"}
        self.path = path
        # {"en": "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.", "zh_CN": "选择容器的资源：目前仅支持资源限制与请求（limits.cpu、limits.memory、requests.cpu 和 requests.memory）"}
        self.resource_field_ref = resource_field_ref

    def validate(self):
        if self.field_ref:
            self.field_ref.validate()
        self.validate_required(self.path, 'path')
        if self.resource_field_ref:
            self.resource_field_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref is not None:
            result['fieldRef'] = self.field_ref.to_map()
        if self.mode is not None:
            result['mode'] = self.mode
        if self.path is not None:
            result['path'] = self.path
        if self.resource_field_ref is not None:
            result['resourceFieldRef'] = self.resource_field_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1ObjectFieldSelector()
            self.field_ref = temp_model.from_map(m['fieldRef'])
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('resourceFieldRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1ResourceFieldSelector()
            self.resource_field_ref = temp_model.from_map(m['resourceFieldRef'])
        return self


class ListJobIoK8sApiCoreV1DownwardAPIVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[ListJobIoK8sApiCoreV1DownwardAPIVolumeFile] = None,
    ):
        # {"en": "Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "可选：默认情况下，模式位用于已创建的文件。 必须是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "Items is a list of downward API volume file", "zh_CN": "Downward API 卷文件的列表"}
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiCoreV1DownwardAPIVolumeFile()
                self.items.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1EmptyDirVolumeSource(TeaModel):
    def __init__(
        self,
        medium: str = None,
        size_limit: str = None,
    ):
        # {"en": "What type of storage medium should back this directory. The default is  which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir", "zh_CN": "表示此目录应使用哪种类别的存储介质。默认为 “”，这意味着使用节点的默认介质。 必须是空字符串（默认值）或 Memory"}
        self.medium = medium
        # {"en": "Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir", "zh_CN": "这个 EmptyDir 卷所需的本地存储总量。这个大小限制也适用于内存介质。 EmptyDir 的内存介质最大使用量将是此处指定的 sizeLimit 与 Pod 中所有容器内存限制总和这两个值之间的最小值。 默认为 nil，这意味着限制未被定义"}
        self.size_limit = size_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.medium is not None:
            result['medium'] = self.medium
        if self.size_limit is not None:
            result['sizeLimit'] = self.size_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('medium') is not None:
            self.medium = m.get('medium')
        if m.get('sizeLimit') is not None:
            self.size_limit = m.get('sizeLimit')
        return self


class ListJobIoK8sApiCoreV1TypedLocalObjectReference(TeaModel):
    def __init__(
        self,
        api_group: str = None,
        kind: str = None,
        name: str = None,
    ):
        # {"en": "APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.", "zh_CN": "APIGroup 是被引用资源的组。如果不指定 APIGroup，则指定的 Kind 必须在核心 API 组中。对于任何其它第三方类型，都需要 APIGroup"}
        self.api_group = api_group
        # {"en": "Kind is the type of resource being referenced", "zh_CN": "Kind 是被引用的资源的类型"}
        self.kind = kind
        # {"en": "Name is the name of resource being referenced", "zh_CN": "Name 是被引用的资源的名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class ListJobIoK8sApiCoreV1PersistentVolumeClaimSpec(TeaModel):
    def __init__(
        self,
        access_modes: List[str] = None,
        data_source: ListJobIoK8sApiCoreV1TypedLocalObjectReference = None,
        resources: ListJobIoK8sApiCoreV1ResourceRequirements = None,
        selector: ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        storage_class_name: str = None,
        volume_mode: str = None,
        volume_name: str = None,
    ):
        # {"en": "AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1", "zh_CN": "accessModes 包含卷应具备的预期访问模式"}
        self.access_modes = access_modes
        # {"en": "This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.", "zh_CN": "dataSource 字段可用于二选一：- 现有的 VolumeSnapshot 对象（snapshot.storage.k8s.io/VolumeSnapshot）- 现有的 PVC (PersistentVolumeClaim)。如果制备器或外部控制器可以支持指定的数据源，则它将根据指定数据源的内容创建新的卷。 当 AnyVolumeDataSource 特性门控被启用时，dataSource 内容将被复制到 dataSourceRef， 当 dataSourceRef.namespace 未被指定时，dataSourceRef 内容将被复制到 dataSource。 如果名字空间被指定，则 dataSourceRef 不会被复制到 dataSource"}
        self.data_source = data_source
        # {"en": "Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources", "zh_CN": "resources 表示卷应拥有的最小资源。 如果启用了 RecoverVolumeExpansionFailure 功能特性，则允许用户指定这些资源要求， 此值必须低于之前的值，但必须高于申领的状态字段中记录的容量"}
        self.resources = resources
        # {"en": "A label query over volumes to consider for binding.", "zh_CN": "selector 是在绑定时对卷进行选择所执行的标签查询"}
        self.selector = selector
        # {"en": "Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1", "zh_CN": "storageClassName 是此申领所要求的 StorageClass 名称"}
        self.storage_class_name = storage_class_name
        # {"en": "volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.", "zh_CN": "volumeMode 定义申领需要哪种类别的卷。当申领规约中未包含此字段时，意味着取值为 Filesystem"}
        self.volume_mode = volume_mode
        # {"en": "VolumeName is the binding reference to the PersistentVolume backing this claim.", "zh_CN": "volumeName 是对此申领所对应的 PersistentVolume 的绑定引用"}
        self.volume_name = volume_name

    def validate(self):
        if self.data_source:
            self.data_source.validate()
        if self.resources:
            self.resources.validate()
        if self.selector:
            self.selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_modes is not None:
            result['accessModes'] = self.access_modes
        if self.data_source is not None:
            result['dataSource'] = self.data_source.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.selector is not None:
            result['selector'] = self.selector.to_map()
        if self.storage_class_name is not None:
            result['storageClassName'] = self.storage_class_name
        if self.volume_mode is not None:
            result['volumeMode'] = self.volume_mode
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessModes') is not None:
            self.access_modes = m.get('accessModes')
        if m.get('dataSource') is not None:
            temp_model = ListJobIoK8sApiCoreV1TypedLocalObjectReference()
            self.data_source = temp_model.from_map(m['dataSource'])
        if m.get('resources') is not None:
            temp_model = ListJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('selector') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.selector = temp_model.from_map(m['selector'])
        if m.get('storageClassName') is not None:
            self.storage_class_name = m.get('storageClassName')
        if m.get('volumeMode') is not None:
            self.volume_mode = m.get('volumeMode')
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        return self


class ListJobIoK8sApiCoreV1PersistentVolumeClaimTemplate(TeaModel):
    def __init__(
        self,
        metadata: ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: ListJobIoK8sApiCoreV1PersistentVolumeClaimSpec = None,
    ):
        # {"en": "May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.", "zh_CN": "可能包含一些标签和注解，在创建 PVC 时，这些数据会被复制到 PVC 中。 在验证期间，其他字段都不允许设置，即便设置也会在验证阶段被拒绝"}
        self.metadata = metadata
        # {"en": "The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.", "zh_CN": "PersistentVolumeClaim 的规约。整个规约的内容将被原封不动地复制到从此模板创建的 PVC 中。 与 PersistentVolumeClaim 相同的字段在此处也有效"}
        self.spec = spec

    def validate(self):
        if self.metadata:
            self.metadata.validate()
        self.validate_required(self.spec, 'spec')
        if self.spec:
            self.spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('metadata') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = ListJobIoK8sApiCoreV1PersistentVolumeClaimSpec()
            self.spec = temp_model.from_map(m['spec'])
        return self


class ListJobIoK8sApiCoreV1EphemeralVolumeSource(TeaModel):
    def __init__(
        self,
        read_only: bool = None,
        volume_claim_template: ListJobIoK8sApiCoreV1PersistentVolumeClaimTemplate = None,
    ):
        # {"en": "Specifies a read-only configuration for the volume. Defaults to false (read/write).", "zh_CN": "指定供卷使用的只读配置。默认为 false（读/写）"}
        self.read_only = read_only
        # {"en": "Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.Required, must not be nil.", "zh_CN": "将用于创建独立的 PVC 以制备卷。 嵌入了 EphemeralVolumeSource 的 Pod 将是 PVC 的所有者，即 PVC 将与 Pod 一起删除。 PVC 的名称将是 <pod 名称>-<卷名称>，其中 <卷名称> 是来自 PodSpec.Volumes 数组条目的名称。 如果串联的名称对于 PVC 无效（例如太长），则 Pod 验证将拒绝该 Pod。如果具有此名称的现有 PVC 不属于此 Pod，则这一 PVC 将 不会 被用于此 Pod，以避免错误地使用不相关的卷。 如果出现这种情况，Pod 的启动操作会被阻塞直到不相关的 PVC 被移除。 如果 Pod 准备使用这样一个预先创建的 PVC，那么一旦此 Pod 出现，就必须更新 PVC， 将其属主引用指向该 Pod。通常没有必要这样做，但这对手动重构损坏的集群时可能很有用。此字段是只读的，PVC 被创建后 Kubernetes 不会对其进行任何更改。必需，不能为 nil"}
        self.volume_claim_template = volume_claim_template

    def validate(self):
        if self.volume_claim_template:
            self.volume_claim_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_claim_template is not None:
            result['volumeClaimTemplate'] = self.volume_claim_template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeClaimTemplate') is not None:
            temp_model = ListJobIoK8sApiCoreV1PersistentVolumeClaimTemplate()
            self.volume_claim_template = temp_model.from_map(m['volumeClaimTemplate'])
        return self


class ListJobIoK8sApiCoreV1FCVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        lun: int = None,
        read_only: bool = None,
        target_wwns: List[str] = None,
        wwids: List[str] = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Optional: FC target lun number", "zh_CN": "可选的：FC 目标 lun 编号"}
        self.lun = lun
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "可选的。默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: FC target worldwide names (WWNs)", "zh_CN": "可选的。FC 目标全球名称（WWN）"}
        self.target_wwns = target_wwns
        # {"en": "Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.", "zh_CN": "可选的。FC 卷全球识别号（wwids）。 必须设置 wwids 或 targetWWNs 及 lun 的组合，但不能同时设置两者"}
        self.wwids = wwids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.lun is not None:
            result['lun'] = self.lun
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.target_wwns is not None:
            result['targetWWNs'] = self.target_wwns
        if self.wwids is not None:
            result['wwids'] = self.wwids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('lun') is not None:
            self.lun = m.get('lun')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('targetWWNs') is not None:
            self.target_wwns = m.get('targetWWNs')
        if m.get('wwids') is not None:
            self.wwids = m.get('wwids')
        return self


class ListJobIoK8sApiCoreV1FlexVolumeSource(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        options: Dict[str, Any] = None,
        read_only: bool = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
    ):
        # {"en": "Driver is the name of the driver to use for this volume.", "zh_CN": "供此卷使用的驱动的名称"}
        self.driver = driver
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. The default filesystem depends on FlexVolume script.", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。例如 “ext4”、“xfs”、“ntfs”。 默认的文件系统取决于 flexVolume 脚本"}
        self.fs_type = fs_type
        # {"en": "Optional: Extra command options if any.", "zh_CN": "可选的。此字段包含额外的命令选项（如果有）"}
        self.options = options
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "可选的。默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.", "zh_CN": "可选的。secretRef 是对包含敏感信息的 Secret 对象的引用，该 Secret 会被传递到插件脚本。 如果未指定 Secret 对象，则此字段可以为空。如果 Secret 对象包含多个 Secret，则所有 Secret 被传递到插件脚本"}
        self.secret_ref = secret_ref

    def validate(self):
        self.validate_required(self.driver, 'driver')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['driver'] = self.driver
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.options is not None:
            result['options'] = self.options
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('driver') is not None:
            self.driver = m.get('driver')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('options') is not None:
            self.options = m.get('options')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        return self


class ListJobIoK8sApiCoreV1FlockerVolumeSource(TeaModel):
    def __init__(
        self,
        dataset_name: str = None,
        dataset_uuid: str = None,
    ):
        # {"en": "Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated", "zh_CN": "存储为元数据的数据集的名称。Flocker 数据集的名称应视为已弃用"}
        self.dataset_name = dataset_name
        # {"en": "UUID of the dataset. This is unique identifier of a Flocker dataset", "zh_CN": "数据集的 UUID。这是 Flocker 数据集的唯一标识符"}
        self.dataset_uuid = dataset_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_name is not None:
            result['datasetName'] = self.dataset_name
        if self.dataset_uuid is not None:
            result['datasetUUID'] = self.dataset_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('datasetName') is not None:
            self.dataset_name = m.get('datasetName')
        if m.get('datasetUUID') is not None:
            self.dataset_uuid = m.get('datasetUUID')
        return self


class ListJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        partition: int = None,
        pd_name: str = None,
        read_only: bool = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为“ext4”"}
        self.fs_type = fs_type
        # {"en": "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as 1. Similarly, the volume partition for /dev/sda is 0 (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "你要挂载的卷中的分区。如果省略，则默认为按卷名称进行挂载。 例如：对于卷 /dev/sda1，将分区指定为 “1”。类似地，/dev/sda 的卷分区为 “0”（或可以将属性留空）。"}
        self.partition = partition
        # {"en": "Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "GCE 中 PD 资源的唯一名称。用于标识 GCE 中的磁盘"}
        self.pd_name = pd_name
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.pd_name, 'pd_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.pd_name is not None:
            result['pdName'] = self.pd_name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('pdName') is not None:
            self.pd_name = m.get('pdName')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class ListJobIoK8sApiCoreV1GitRepoVolumeSource(TeaModel):
    def __init__(
        self,
        directory: str = None,
        repository: str = None,
        revision: str = None,
    ):
        # {"en": "Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.", "zh_CN": "目标目录的名称。不得包含 “..” 或以 “..” 开头。如果提供了 “.”，则卷目录将是 Git 仓库。 否则，如果指定，卷将用给定名称的子目录中存放 Git 仓库"}
        self.directory = directory
        # {"en": "Repository URL", "zh_CN": "仓库的 URL"}
        self.repository = repository
        # {"en": "Commit hash for the specified revision.", "zh_CN": "指定修订版本的提交哈希值"}
        self.revision = revision

    def validate(self):
        self.validate_required(self.repository, 'repository')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory is not None:
            result['directory'] = self.directory
        if self.repository is not None:
            result['repository'] = self.repository
        if self.revision is not None:
            result['revision'] = self.revision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('repository') is not None:
            self.repository = m.get('repository')
        if m.get('revision') is not None:
            self.revision = m.get('revision')
        return self


class ListJobIoK8sApiCoreV1GlusterfsVolumeSource(TeaModel):
    def __init__(
        self,
        endpoints: str = None,
        path: str = None,
        read_only: bool = None,
    ):
        # {"en": "EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "详细给出 Glusterfs 拓扑结构的端点的名称"}
        self.endpoints = endpoints
        # {"en": "Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "Glusterfs 卷的路径"}
        self.path = path
        # {"en": "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "此处的 readOnly 将强制以只读权限挂载 Glusterfs 卷。 默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.endpoints, 'endpoints')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoints is not None:
            result['endpoints'] = self.endpoints
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endpoints') is not None:
            self.endpoints = m.get('endpoints')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class ListJobIoK8sApiCoreV1HostPathVolumeSource(TeaModel):
    def __init__(
        self,
        path: str = None,
        type: str = None,
    ):
        # {"en": "Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "目录在主机上的路径。如果该路径是一个符号链接，则它将沿着链接指向真实路径"}
        self.path = path
        # {"en": "Type for HostPath Volume Defaults to  More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "HostPath 卷的类型。默认为 “”"}
        self.type = type

    def validate(self):
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['path'] = self.path
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ListJobIoK8sApiCoreV1ISCSIVolumeSource(TeaModel):
    def __init__(
        self,
        chap_auth_discovery: bool = None,
        chap_auth_session: bool = None,
        fs_type: str = None,
        initiator_name: str = None,
        iqn: str = None,
        iscsi_interface: str = None,
        lun: int = None,
        portals: List[str] = None,
        read_only: bool = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        target_portal: str = None,
    ):
        # {"en": "whether support iSCSI Discovery CHAP authentication", "zh_CN": "定义是否支持 iSCSI Discovery CHAP 身份认证"}
        self.chap_auth_discovery = chap_auth_discovery
        # {"en": "whether support iSCSI Session CHAP authentication", "zh_CN": "定义是否支持 iSCSI Session CHAP 身份认证"}
        self.chap_auth_session = chap_auth_session
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi", "zh_CN": "你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.", "zh_CN": "自定义的 iSCSI 发起程序名称（iSCSI Initiator Name）。 如果同时用 iscsiInterface 指定 initiatorName，将为连接创建新的 iSCSI 接口 <目标门户>:<卷名称>"}
        self.initiator_name = initiator_name
        # {"en": "Target iSCSI Qualified Name.", "zh_CN": "目标 iSCSI 限定名称"}
        self.iqn = iqn
        # {"en": "iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).", "zh_CN": "使用 iSCSI 传输的接口名称。默认为 “default”（tcp）"}
        self.iscsi_interface = iscsi_interface
        # {"en": "iSCSI Target Lun number.", "zh_CN": "表示 iSCSI 目标逻辑单元号"}
        self.lun = lun
        # {"en": "iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).", "zh_CN": " iSCSI 目标门户列表（iSCSI Target Portal List）。 如果不是默认端口（通常是 TCP 端口 860 和 3260），则 Portal 为 IP 或 ip_addr:port"}
        self.portals = portals
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only
        # {"en": "CHAP Secret for iSCSI target and initiator authentication", "zh_CN": "iSCSI 目标和发起程序身份认证所用的 CHAP Secret"}
        self.secret_ref = secret_ref
        # {"en": "iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).", "zh_CN": "iSCSI 目标门户。 如果不是默认端口（通常是 TCP 端口 860 和 3260），则 Portal 为 IP 或 ip_addr:port"}
        self.target_portal = target_portal

    def validate(self):
        self.validate_required(self.iqn, 'iqn')
        self.validate_required(self.lun, 'lun')
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.target_portal, 'target_portal')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chap_auth_discovery is not None:
            result['chapAuthDiscovery'] = self.chap_auth_discovery
        if self.chap_auth_session is not None:
            result['chapAuthSession'] = self.chap_auth_session
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.initiator_name is not None:
            result['initiatorName'] = self.initiator_name
        if self.iqn is not None:
            result['iqn'] = self.iqn
        if self.iscsi_interface is not None:
            result['iscsiInterface'] = self.iscsi_interface
        if self.lun is not None:
            result['lun'] = self.lun
        if self.portals is not None:
            result['portals'] = self.portals
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.target_portal is not None:
            result['targetPortal'] = self.target_portal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('chapAuthDiscovery') is not None:
            self.chap_auth_discovery = m.get('chapAuthDiscovery')
        if m.get('chapAuthSession') is not None:
            self.chap_auth_session = m.get('chapAuthSession')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('initiatorName') is not None:
            self.initiator_name = m.get('initiatorName')
        if m.get('iqn') is not None:
            self.iqn = m.get('iqn')
        if m.get('iscsiInterface') is not None:
            self.iscsi_interface = m.get('iscsiInterface')
        if m.get('lun') is not None:
            self.lun = m.get('lun')
        if m.get('portals') is not None:
            self.portals = m.get('portals')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('targetPortal') is not None:
            self.target_portal = m.get('targetPortal')
        return self


class ListJobIoK8sApiCoreV1NFSVolumeSource(TeaModel):
    def __init__(
        self,
        path: str = None,
        read_only: bool = None,
        server: str = None,
    ):
        # {"en": "Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": "由 NFS 服务器导出的路径"}
        self.path = path
        # {"en": "ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": "此处 readOnly 将强制使用只读权限挂载 NFS 导出。默认为 false"}
        self.read_only = read_only
        # {"en": "Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": " NFS 服务器的主机名或 IP 地址"}
        self.server = server

    def validate(self):
        self.validate_required(self.path, 'path')
        self.validate_required(self.server, 'server')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.server is not None:
            result['server'] = self.server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('server') is not None:
            self.server = m.get('server')
        return self


class ListJobIoK8sApiCoreV1PersistentVolumeClaimVolumeSource(TeaModel):
    def __init__(
        self,
        claim_name: str = None,
        read_only: bool = None,
    ):
        # {"en": "ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims", "zh_CN": "与使用此卷的 Pod 位于同一名字空间中的 PersistentVolumeClaim 的名称"}
        self.claim_name = claim_name
        # {"en": "Will force the ReadOnly setting in VolumeMounts. Default false.", "zh_CN": "readOnly 将在卷挂载中强制设置 readOnly 属性。默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.claim_name, 'claim_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.claim_name is not None:
            result['claimName'] = self.claim_name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('claimName') is not None:
            self.claim_name = m.get('claimName')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class ListJobIoK8sApiCoreV1PhotonPersistentDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        pd_id: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "ID that identifies Photon Controller persistent disk", "zh_CN": "标识 Photon Controller 持久磁盘的 ID"}
        self.pd_id = pd_id

    def validate(self):
        self.validate_required(self.pd_id, 'pd_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.pd_id is not None:
            result['pdID'] = self.pd_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('pdID') is not None:
            self.pd_id = m.get('pdID')
        return self


class ListJobIoK8sApiCoreV1PortworxVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        volume_id: str = None,
    ):
        # {"en": "FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. ext4, xfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "表示要挂载的文件系统类型。必须是主机操作系统支持的文件系统类型。例如 “ext4”、“xfs”。 如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "VolumeID uniquely identifies a Portworx volume", "zh_CN": "volumeID 唯一标识 Portworx 卷"}
        self.volume_id = volume_id

    def validate(self):
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class ListJobIoK8sApiCoreV1ConfigMapProjection(TeaModel):
    def __init__(
        self,
        items: List[ListJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. ListJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 ConfigMap 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 ConfigMap 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its keys must be defined", "zh_CN": "optional 指定是否所引用的 ConfigMap 或其键必须已经被定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1DownwardAPIProjection(TeaModel):
    def __init__(
        self,
        items: List[ListJobIoK8sApiCoreV1DownwardAPIVolumeFile] = None,
    ):
        # {"en": "Items is a list of DownwardAPIVolume file", "zh_CN": "items 是 DownwardAPIVolume 文件的列表"}
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiCoreV1DownwardAPIVolumeFile()
                self.items.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1SecretProjection(TeaModel):
    def __init__(
        self,
        items: List[ListJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. ListJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 Secret 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 Secret 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the Secret or its key must be defined", "zh_CN": "optional 字段指定是否 Secret 或其键必须已经定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class ListJobIoK8sApiCoreV1ServiceAccountTokenProjection(TeaModel):
    def __init__(
        self,
        audience: str = None,
        expiration_seconds: int = None,
        path: str = None,
    ):
        # {"en": "Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.", "zh_CN": "audience 是令牌的目标受众。 令牌的接收方必须用令牌受众中指定的一个标识符来标识自己，否则应拒绝此令牌。 受众默认为 apiserver 的标识符"}
        self.audience = audience
        # {"en": "ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.", "zh_CN": "expirationSeconds 是所请求的服务账号令牌的有效期。 当令牌即将到期时，kubelet 卷插件将主动轮换服务账号令牌。 如果令牌超过其生存时间的 80% 或令牌超过 24 小时，kubelet 将开始尝试轮换令牌。 默认为 1 小时且必须至少为 10 分钟"}
        self.expiration_seconds = expiration_seconds
        # {"en": "Path is the path relative to the mount point of the file to project the token into.", "zh_CN": "path 是相对于令牌投射目标文件的挂载点的路径"}
        self.path = path

    def validate(self):
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audience is not None:
            result['audience'] = self.audience
        if self.expiration_seconds is not None:
            result['expirationSeconds'] = self.expiration_seconds
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('audience') is not None:
            self.audience = m.get('audience')
        if m.get('expirationSeconds') is not None:
            self.expiration_seconds = m.get('expirationSeconds')
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class ListJobIoK8sApiCoreV1VolumeProjection(TeaModel):
    def __init__(
        self,
        config_map: ListJobIoK8sApiCoreV1ConfigMapProjection = None,
        downward_api: ListJobIoK8sApiCoreV1DownwardAPIProjection = None,
        secret: ListJobIoK8sApiCoreV1SecretProjection = None,
        service_account_token: ListJobIoK8sApiCoreV1ServiceAccountTokenProjection = None,
    ):
        # {"en": "information about the configMap data to project", "zh_CN": "与要投射的 ConfigMap 数据有关的 ConfigMap 信息"}
        self.config_map = config_map
        # {"en": "information about the downwardAPI data to project", "zh_CN": "与要投射的 downward API 数据有关的 downward API 信息"}
        self.downward_api = downward_api
        # {"en": "information about the secret data to project", "zh_CN": "与要投射的 Secret 数据有关的 Secret 信息"}
        self.secret = secret
        # {"en": "information about the serviceAccountToken data to project", "zh_CN": "serviceAccountToken 是与要投射的服务账号令牌数据有关的信息"}
        self.service_account_token = service_account_token

    def validate(self):
        if self.config_map:
            self.config_map.validate()
        if self.downward_api:
            self.downward_api.validate()
        if self.secret:
            self.secret.validate()
        if self.service_account_token:
            self.service_account_token.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map is not None:
            result['configMap'] = self.config_map.to_map()
        if self.downward_api is not None:
            result['downwardAPI'] = self.downward_api.to_map()
        if self.secret is not None:
            result['secret'] = self.secret.to_map()
        if self.service_account_token is not None:
            result['serviceAccountToken'] = self.service_account_token.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMap') is not None:
            temp_model = ListJobIoK8sApiCoreV1ConfigMapProjection()
            self.config_map = temp_model.from_map(m['configMap'])
        if m.get('downwardAPI') is not None:
            temp_model = ListJobIoK8sApiCoreV1DownwardAPIProjection()
            self.downward_api = temp_model.from_map(m['downwardAPI'])
        if m.get('secret') is not None:
            temp_model = ListJobIoK8sApiCoreV1SecretProjection()
            self.secret = temp_model.from_map(m['secret'])
        if m.get('serviceAccountToken') is not None:
            temp_model = ListJobIoK8sApiCoreV1ServiceAccountTokenProjection()
            self.service_account_token = temp_model.from_map(m['serviceAccountToken'])
        return self


class ListJobIoK8sApiCoreV1ProjectedVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        sources: List[ListJobIoK8sApiCoreV1VolumeProjection] = None,
    ):
        # {"en": "Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是默认情况下用于为已创建的文件设置权限的模式位。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 路径内的目录不受此设置的影响。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "list of volume projections", "zh_CN": "sources 是卷投射的列表"}
        self.sources = sources

    def validate(self):
        if self.sources:
            for k in self.sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.sources is not None:
            result['sources'] = []
            for k in self.sources:
                result['sources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('sources') is not None:
            self.sources = []
            for k in m.get('sources'):
                temp_model = ListJobIoK8sApiCoreV1VolumeProjection()
                self.sources.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1QuobyteVolumeSource(TeaModel):
    def __init__(
        self,
        group: str = None,
        read_only: bool = None,
        registry: str = None,
        tenant: str = None,
        user: str = None,
        volume: str = None,
    ):
        # {"en": "Group to map volume access to Default is no group", "zh_CN": "将卷访问映射到的组。默认为无组"}
        self.group = group
        # {"en": "ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.", "zh_CN": "此处 readOnly 将强制使用只读权限挂载 Quobyte 卷。默认为 false"}
        self.read_only = read_only
        # {"en": "Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes", "zh_CN": "表示将一个或多个 Quobyte Registry 服务指定为 host:port 对的字符串形式 （多个条目用英文逗号分隔），用作卷的中央注册表"}
        self.registry = registry
        # {"en": "Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin", "zh_CN": "tenant 拥有 Backend Used 中给定的 Quobyte 卷，随动态制备的 Quobyte 卷一起使用，值由插件设置"}
        self.tenant = tenant
        # {"en": "User to map volume access to Defaults to serivceaccount user", "zh_CN": "user 是将卷访问映射到的用户。默认为 serivceaccount 用户"}
        self.user = user
        # {"en": "Volume is a string that references an already created Quobyte volume by name.", "zh_CN": "volume 是按名称引用已创建的 Quobyte 卷的字符串"}
        self.volume = volume

    def validate(self):
        self.validate_required(self.registry, 'registry')
        self.validate_required(self.volume, 'volume')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group is not None:
            result['group'] = self.group
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.registry is not None:
            result['registry'] = self.registry
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.user is not None:
            result['user'] = self.user
        if self.volume is not None:
            result['volume'] = self.volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('registry') is not None:
            self.registry = m.get('registry')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('user') is not None:
            self.user = m.get('user')
        if m.get('volume') is not None:
            self.volume = m.get('volume')
        return self


class ListJobIoK8sApiCoreV1RBDVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        image: str = None,
        keyring: str = None,
        monitors: List[str] = None,
        pool: str = None,
        read_only: bool = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        user: str = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd", "zh_CN": "fsType 是你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "rados 镜像名称"}
        self.image = image
        # {"en": "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "RBDUser 密钥环的路径。默认为 /etc/ceph/keyring"}
        self.keyring = keyring
        # {"en": "A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "Ceph 监测的集合"}
        self.monitors = monitors
        # {"en": "The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "rados 池名称。默认为 rbd"}
        self.pool = pool
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only
        # {"en": "SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "secretRef 是 RBDUser 的身份认证 Secret 的名称。如果提供，则重载 keyring。默认为 nil"}
        self.secret_ref = secret_ref
        # {"en": "The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "user 是 rados 用户名。默认为 admin"}
        self.user = user

    def validate(self):
        self.validate_required(self.image, 'image')
        self.validate_required(self.monitors, 'monitors')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.image is not None:
            result['image'] = self.image
        if self.keyring is not None:
            result['keyring'] = self.keyring
        if self.monitors is not None:
            result['monitors'] = self.monitors
        if self.pool is not None:
            result['pool'] = self.pool
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('keyring') is not None:
            self.keyring = m.get('keyring')
        if m.get('monitors') is not None:
            self.monitors = m.get('monitors')
        if m.get('pool') is not None:
            self.pool = m.get('pool')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class ListJobIoK8sApiCoreV1ScaleIOVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        gateway: str = None,
        protection_domain: str = None,
        read_only: bool = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        ssl_enabled: bool = None,
        storage_mode: str = None,
        storage_pool: str = None,
        system: str = None,
        volume_name: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Default is xfs.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。例如 “ext4”、“xfs”、“ntfs”。默认为 “xfs”"}
        self.fs_type = fs_type
        # {"en": "The host address of the ScaleIO API Gateway.", "zh_CN": "ScaleIO API 网关的主机地址"}
        self.gateway = gateway
        # {"en": "The name of the ScaleIO Protection Domain for the configured storage.", "zh_CN": "protectionDomain 是 ScaleIO 保护域（ScaleIO Protection Domain）的名称，用于已配置的存储"}
        self.protection_domain = protection_domain
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.", "zh_CN": "secretRef 引用到 ScaleIO 用户的 Secret 和其他敏感信息。如果未提供此项，则 Login 操作将失败"}
        self.secret_ref = secret_ref
        # {"en": "Flag to enable/disable SSL communication with Gateway, default false", "zh_CN": "sslEnabled 标志启用/禁用与网关的 SSL 通信，默认为 false"}
        self.ssl_enabled = ssl_enabled
        # {"en": "Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.", "zh_CN": "storageMode 指示卷所用的存储应是 ThickProvisioned 或 ThinProvisioned。默认为 ThinProvisioned"}
        self.storage_mode = storage_mode
        # {"en": "The ScaleIO Storage Pool associated with the protection domain.", "zh_CN": "storagePool 是与保护域关联的 ScaleIO Storage Pool"}
        self.storage_pool = storage_pool
        # {"en": "The name of the storage system as configured in ScaleIO.", "zh_CN": "system 是存储系统的名称，与 ScaleIO 中的配置相同"}
        self.system = system
        # {"en": "The name of a volume already created in the ScaleIO system that is associated with this volume source.", "zh_CN": "volumeName 是在与此卷源关联的 ScaleIO 系统中已创建的卷的名称"}
        self.volume_name = volume_name

    def validate(self):
        self.validate_required(self.gateway, 'gateway')
        self.validate_required(self.secret_ref, 'secret_ref')
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.system, 'system')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.gateway is not None:
            result['gateway'] = self.gateway
        if self.protection_domain is not None:
            result['protectionDomain'] = self.protection_domain
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.ssl_enabled is not None:
            result['sslEnabled'] = self.ssl_enabled
        if self.storage_mode is not None:
            result['storageMode'] = self.storage_mode
        if self.storage_pool is not None:
            result['storagePool'] = self.storage_pool
        if self.system is not None:
            result['system'] = self.system
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('gateway') is not None:
            self.gateway = m.get('gateway')
        if m.get('protectionDomain') is not None:
            self.protection_domain = m.get('protectionDomain')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('sslEnabled') is not None:
            self.ssl_enabled = m.get('sslEnabled')
        if m.get('storageMode') is not None:
            self.storage_mode = m.get('storageMode')
        if m.get('storagePool') is not None:
            self.storage_pool = m.get('storagePool')
        if m.get('system') is not None:
            self.system = m.get('system')
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        return self


class ListJobIoK8sApiCoreV1SecretVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[ListJobIoK8sApiCoreV1KeyToPath] = None,
        optional: bool = None,
        secret_name: str = None,
    ):
        # {"en": "Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. ListJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 Secret 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 Secret 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Specify whether the Secret or its keys must be defined", "zh_CN": "optional 字段指定是否 Secret 或其键必须已经定义"}
        self.optional = optional
        # {"en": "Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret", "zh_CN": "secretName 是要使用的、位于 Pod 的名字空间中的 Secret 名称"}
        self.secret_name = secret_name

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.optional is not None:
            result['optional'] = self.optional
        if self.secret_name is not None:
            result['secretName'] = self.secret_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        if m.get('secretName') is not None:
            self.secret_name = m.get('secretName')
        return self


class ListJobIoK8sApiCoreV1StorageOSVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        secret_ref: ListJobIoK8sApiCoreV1LocalObjectReference = None,
        volume_name: str = None,
        volume_namespace: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.", "zh_CN": "secretRef 指定用于获取 StorageOS API 凭据的 Secret。如果未指定，则将尝试使用默认值"}
        self.secret_ref = secret_ref
        # {"en": "VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.", "zh_CN": "volumeName 是 StorageOS 卷的人类可读名称。这些卷名称在一个名字空间内是唯一的"}
        self.volume_name = volume_name
        # {"en": "VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to default if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.", "zh_CN": "volumeNamespace 指定 StorageOS 内卷的作用域。如果未指定名字空间，则将使用 Pod 的名字空间。 这个设置使得 Kubernetes 的名字作用域可以在 StorageOS 内进行映射，实现更紧密的集成。 将 volumeName 设为任何名称以重载默认的行为。如果你未在 StorageOS 内使用名字空间，则设为“default”。 将创建 StorageOS 内预先不存在的名字空间"}
        self.volume_namespace = volume_namespace

    def validate(self):
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        if self.volume_namespace is not None:
            result['volumeNamespace'] = self.volume_namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        if m.get('volumeNamespace') is not None:
            self.volume_namespace = m.get('volumeNamespace')
        return self


class ListJobIoK8sApiCoreV1VsphereVirtualDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        storage_policy_id: str = None,
        storage_policy_name: str = None,
        volume_path: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.", "zh_CN": "storagePolicyID 是与 StoragePolicyName 关联的基于存储策略的管理（SPBM）配置文件 ID"}
        self.storage_policy_id = storage_policy_id
        # {"en": "Storage Policy Based Management (SPBM) profile name.", "zh_CN": "storagePolicyName 是基于存储策略的管理（SPBM）配置文件名称"}
        self.storage_policy_name = storage_policy_name
        # {"en": "Path that identifies vSphere volume vmdk", "zh_CN": "volumePath 是标识 vSphere 卷 vmdk 的路径"}
        self.volume_path = volume_path

    def validate(self):
        self.validate_required(self.volume_path, 'volume_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.storage_policy_id is not None:
            result['storagePolicyID'] = self.storage_policy_id
        if self.storage_policy_name is not None:
            result['storagePolicyName'] = self.storage_policy_name
        if self.volume_path is not None:
            result['volumePath'] = self.volume_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('storagePolicyID') is not None:
            self.storage_policy_id = m.get('storagePolicyID')
        if m.get('storagePolicyName') is not None:
            self.storage_policy_name = m.get('storagePolicyName')
        if m.get('volumePath') is not None:
            self.volume_path = m.get('volumePath')
        return self


class ListJobIoK8sApiCoreV1Volume(TeaModel):
    def __init__(
        self,
        aws_elastic_block_store: ListJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource = None,
        azure_disk: ListJobIoK8sApiCoreV1AzureDiskVolumeSource = None,
        azure_file: ListJobIoK8sApiCoreV1AzureFileVolumeSource = None,
        cephfs: ListJobIoK8sApiCoreV1CephFSVolumeSource = None,
        cinder: ListJobIoK8sApiCoreV1CinderVolumeSource = None,
        config_map: ListJobIoK8sApiCoreV1ConfigMapVolumeSource = None,
        csi: ListJobIoK8sApiCoreV1CSIVolumeSource = None,
        downward_api: ListJobIoK8sApiCoreV1DownwardAPIVolumeSource = None,
        empty_dir: ListJobIoK8sApiCoreV1EmptyDirVolumeSource = None,
        ephemeral: ListJobIoK8sApiCoreV1EphemeralVolumeSource = None,
        fc: ListJobIoK8sApiCoreV1FCVolumeSource = None,
        flex_volume: ListJobIoK8sApiCoreV1FlexVolumeSource = None,
        flocker: ListJobIoK8sApiCoreV1FlockerVolumeSource = None,
        gce_persistent_disk: ListJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource = None,
        git_repo: ListJobIoK8sApiCoreV1GitRepoVolumeSource = None,
        glusterfs: ListJobIoK8sApiCoreV1GlusterfsVolumeSource = None,
        host_path: ListJobIoK8sApiCoreV1HostPathVolumeSource = None,
        iscsi: ListJobIoK8sApiCoreV1ISCSIVolumeSource = None,
        name: str = None,
        nfs: ListJobIoK8sApiCoreV1NFSVolumeSource = None,
        persistent_volume_claim: ListJobIoK8sApiCoreV1PersistentVolumeClaimVolumeSource = None,
        photon_persistent_disk: ListJobIoK8sApiCoreV1PhotonPersistentDiskVolumeSource = None,
        portworx_volume: ListJobIoK8sApiCoreV1PortworxVolumeSource = None,
        projected: ListJobIoK8sApiCoreV1ProjectedVolumeSource = None,
        quobyte: ListJobIoK8sApiCoreV1QuobyteVolumeSource = None,
        rbd: ListJobIoK8sApiCoreV1RBDVolumeSource = None,
        scale_io: ListJobIoK8sApiCoreV1ScaleIOVolumeSource = None,
        secret: ListJobIoK8sApiCoreV1SecretVolumeSource = None,
        storageos: ListJobIoK8sApiCoreV1StorageOSVolumeSource = None,
        vsphere_volume: ListJobIoK8sApiCoreV1VsphereVirtualDiskVolumeSource = None,
    ):
        # {"en": "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 AWS Disk 资源"}
        self.aws_elastic_block_store = aws_elastic_block_store
        # {"en": "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.", "zh_CN": "表示挂载到主机上并绑定挂载到 Pod 上的 Azure 数据盘"}
        self.azure_disk = azure_disk
        # {"en": "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.", "zh_CN": "表示挂载到主机上并绑定挂载到 Pod 上的 Azure File Service"}
        self.azure_file = azure_file
        # {"en": "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime", "zh_CN": "表示在主机上挂载的 Ceph FS，该文件系统挂载与 Pod 的生命周期相同"}
        self.cephfs = cephfs
        # {"en": "Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "表示 kubelet 主机上挂接和挂载的 Cinder 卷"}
        self.cinder = cinder
        # {"en": "ConfigMap represents a configMap that should populate this volume", "zh_CN": "表示应填充此卷的 configMap"}
        self.config_map = config_map
        # {"en": "CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).", "zh_CN": "表示由某个外部容器存储接口（Container Storage Interface，CSI）驱动处理的临时存储（Beta 特性）"}
        self.csi = csi
        # {"en": "DownwardAPI represents downward API about the pod that should populate this volume", "zh_CN": "表示有关 Pod 的 Downward API，用来填充此卷"}
        self.downward_api = downward_api
        # {"en": "EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir", "zh_CN": "表示与 Pod 生命周期相同的临时目录"}
        self.empty_dir = empty_dir
        # {"en": "Ephemeral represents a volume that is handled by a cluster storage driver (Alpha feature). The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity tracking are needed c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through a PersistentVolumeClaim (see EphemeralVolumeSource for more information on the connection between this volume type and PersistentVolumeClaim).Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.A pod can use both types of ephemeral volumes and persistent volumes at the same time.", "zh_CN": "表示由一个集群存储驱动处理的卷。此卷的生命周期与定义该卷的 Pod 相关联。 Pod 启动前创建此卷，Pod 移除时删除此卷。使用此字段的情形包括： a) 仅在 Pod 运行时才需要此卷， b) 需要从快照恢复或容量跟踪等正常卷的功能特性， c) 通过存储类指定存储驱动，以及 d) 存储驱动支持通过 PersistentVolumeClaim 进行动态卷制备 （有关此卷类型和 PersistentVolumeClaim 之间连接的更多信息，请参考 EphemeralVolumeSource）。对于持续时间超过单个 Pod 生命周期的卷，使用 PersistentVolumeClaim 或某种特定于供应商的 API。如果打算以这种方式使用 CSI 驱动，则将 CSI 用于轻量级本地临时卷。更多的相关信息，请参考驱动文档。一个 Pod 可以同时使用临时卷和持久卷这两种类别的卷"}
        self.ephemeral = ephemeral
        # {"en": "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 Fibre Channel 资源"}
        self.fc = fc
        # {"en": "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.", "zh_CN": "表示使用基于 exec 的插件制备/挂接的通用卷资源"}
        self.flex_volume = flex_volume
        # {"en": "Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running", "zh_CN": "表示挂接到一个 kubelet 主机的 Flocker 卷。Flocker 卷依赖于正在运行的 Flocker 控制服务"}
        self.flocker = flocker
        # {"en": "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 GCE Disk 资源"}
        self.gce_persistent_disk = gce_persistent_disk
        # {"en": "GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.", "zh_CN": "表示特定修订版本的 git 仓库。（注意：GitRepo 已被弃用。）如果与为某容器提速 Git 仓库， 可以先将 emptyDir 挂载到 InitContainer 上，由后者使用 git 克隆仓库，然后将 emptyDir 挂载到 Pod 的容器中"}
        self.git_repo = git_repo
        # {"en": "Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md", "zh_CN": "表示关联到主机并暴露给 Pod 的 Glusterfs 卷。由管理员配置"}
        self.glusterfs = glusterfs
        # {"en": "HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "表示主机上预先存在的文件或目录，它们将被直接暴露给容器。 这种卷通常用于系统代理或允许查看主机的其他特权操作。大多数容器不需要这种卷"}
        self.host_path = host_path
        # {"en": "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 ISCSI Disk 资源"}
        self.iscsi = iscsi
        # {"en": "Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "卷的名称。必须是 DNS_LABEL 且在 Pod 内是唯一的"}
        self.name = name
        # {"en": "NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": "表示在主机上挂载的 NFS，其生命周期与 Pod 相同"}
        self.nfs = nfs
        # {"en": "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims", "zh_CN": "persistentVolumeClaimVolumeSource 表示对同一名字空间中 PersistentVolumeClaim 的引用"}
        self.persistent_volume_claim = persistent_volume_claim
        # {"en": "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine", "zh_CN": "表示 kubelet 主机上挂接和挂载的 PhotonController 持久磁盘"}
        self.photon_persistent_disk = photon_persistent_disk
        # {"en": "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine", "zh_CN": "表示 kubelet 主机上挂接和挂载的 portworx 卷"}
        self.portworx_volume = portworx_volume
        # {"en": "Items for all in one resources secrets, configmaps, and downward API", "zh_CN": "这是供 Secret、ConfigMap 和 Downward API 等所有资源使用的投射项"}
        self.projected = projected
        # {"en": "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime", "zh_CN": "表示在共享 Pod 生命周期的主机上挂载的 Quobyte"}
        self.quobyte = quobyte
        # {"en": "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md", "zh_CN": "表示在共享 Pod 生命周期的主机上挂载的 Rados Block Device"}
        self.rbd = rbd
        # {"en": "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.", "zh_CN": "表示 Kubernetes 节点上挂接和挂载的 ScaleIO 持久卷"}
        self.scale_io = scale_io
        # {"en": "Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret", "zh_CN": "表示用来填充此卷的 Secret"}
        self.secret = secret
        # {"en": "StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.", "zh_CN": "表示 Kubernetes 节点上挂接和挂载的 StorageOS 卷"}
        self.storageos = storageos
        # {"en": "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine", "zh_CN": "表示 kubelet 主机上挂接和挂载的 vSphere 卷"}
        self.vsphere_volume = vsphere_volume

    def validate(self):
        if self.aws_elastic_block_store:
            self.aws_elastic_block_store.validate()
        if self.azure_disk:
            self.azure_disk.validate()
        if self.azure_file:
            self.azure_file.validate()
        if self.cephfs:
            self.cephfs.validate()
        if self.cinder:
            self.cinder.validate()
        if self.config_map:
            self.config_map.validate()
        if self.csi:
            self.csi.validate()
        if self.downward_api:
            self.downward_api.validate()
        if self.empty_dir:
            self.empty_dir.validate()
        if self.ephemeral:
            self.ephemeral.validate()
        if self.fc:
            self.fc.validate()
        if self.flex_volume:
            self.flex_volume.validate()
        if self.flocker:
            self.flocker.validate()
        if self.gce_persistent_disk:
            self.gce_persistent_disk.validate()
        if self.git_repo:
            self.git_repo.validate()
        if self.glusterfs:
            self.glusterfs.validate()
        if self.host_path:
            self.host_path.validate()
        if self.iscsi:
            self.iscsi.validate()
        self.validate_required(self.name, 'name')
        if self.nfs:
            self.nfs.validate()
        if self.persistent_volume_claim:
            self.persistent_volume_claim.validate()
        if self.photon_persistent_disk:
            self.photon_persistent_disk.validate()
        if self.portworx_volume:
            self.portworx_volume.validate()
        if self.projected:
            self.projected.validate()
        if self.quobyte:
            self.quobyte.validate()
        if self.rbd:
            self.rbd.validate()
        if self.scale_io:
            self.scale_io.validate()
        if self.secret:
            self.secret.validate()
        if self.storageos:
            self.storageos.validate()
        if self.vsphere_volume:
            self.vsphere_volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aws_elastic_block_store is not None:
            result['awsElasticBlockStore'] = self.aws_elastic_block_store.to_map()
        if self.azure_disk is not None:
            result['azureDisk'] = self.azure_disk.to_map()
        if self.azure_file is not None:
            result['azureFile'] = self.azure_file.to_map()
        if self.cephfs is not None:
            result['cephfs'] = self.cephfs.to_map()
        if self.cinder is not None:
            result['cinder'] = self.cinder.to_map()
        if self.config_map is not None:
            result['configMap'] = self.config_map.to_map()
        if self.csi is not None:
            result['csi'] = self.csi.to_map()
        if self.downward_api is not None:
            result['downwardAPI'] = self.downward_api.to_map()
        if self.empty_dir is not None:
            result['emptyDir'] = self.empty_dir.to_map()
        if self.ephemeral is not None:
            result['ephemeral'] = self.ephemeral.to_map()
        if self.fc is not None:
            result['fc'] = self.fc.to_map()
        if self.flex_volume is not None:
            result['flexVolume'] = self.flex_volume.to_map()
        if self.flocker is not None:
            result['flocker'] = self.flocker.to_map()
        if self.gce_persistent_disk is not None:
            result['gcePersistentDisk'] = self.gce_persistent_disk.to_map()
        if self.git_repo is not None:
            result['gitRepo'] = self.git_repo.to_map()
        if self.glusterfs is not None:
            result['glusterfs'] = self.glusterfs.to_map()
        if self.host_path is not None:
            result['hostPath'] = self.host_path.to_map()
        if self.iscsi is not None:
            result['iscsi'] = self.iscsi.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.nfs is not None:
            result['nfs'] = self.nfs.to_map()
        if self.persistent_volume_claim is not None:
            result['persistentVolumeClaim'] = self.persistent_volume_claim.to_map()
        if self.photon_persistent_disk is not None:
            result['photonPersistentDisk'] = self.photon_persistent_disk.to_map()
        if self.portworx_volume is not None:
            result['portworxVolume'] = self.portworx_volume.to_map()
        if self.projected is not None:
            result['projected'] = self.projected.to_map()
        if self.quobyte is not None:
            result['quobyte'] = self.quobyte.to_map()
        if self.rbd is not None:
            result['rbd'] = self.rbd.to_map()
        if self.scale_io is not None:
            result['scaleIO'] = self.scale_io.to_map()
        if self.secret is not None:
            result['secret'] = self.secret.to_map()
        if self.storageos is not None:
            result['storageos'] = self.storageos.to_map()
        if self.vsphere_volume is not None:
            result['vsphereVolume'] = self.vsphere_volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('awsElasticBlockStore') is not None:
            temp_model = ListJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource()
            self.aws_elastic_block_store = temp_model.from_map(m['awsElasticBlockStore'])
        if m.get('azureDisk') is not None:
            temp_model = ListJobIoK8sApiCoreV1AzureDiskVolumeSource()
            self.azure_disk = temp_model.from_map(m['azureDisk'])
        if m.get('azureFile') is not None:
            temp_model = ListJobIoK8sApiCoreV1AzureFileVolumeSource()
            self.azure_file = temp_model.from_map(m['azureFile'])
        if m.get('cephfs') is not None:
            temp_model = ListJobIoK8sApiCoreV1CephFSVolumeSource()
            self.cephfs = temp_model.from_map(m['cephfs'])
        if m.get('cinder') is not None:
            temp_model = ListJobIoK8sApiCoreV1CinderVolumeSource()
            self.cinder = temp_model.from_map(m['cinder'])
        if m.get('configMap') is not None:
            temp_model = ListJobIoK8sApiCoreV1ConfigMapVolumeSource()
            self.config_map = temp_model.from_map(m['configMap'])
        if m.get('csi') is not None:
            temp_model = ListJobIoK8sApiCoreV1CSIVolumeSource()
            self.csi = temp_model.from_map(m['csi'])
        if m.get('downwardAPI') is not None:
            temp_model = ListJobIoK8sApiCoreV1DownwardAPIVolumeSource()
            self.downward_api = temp_model.from_map(m['downwardAPI'])
        if m.get('emptyDir') is not None:
            temp_model = ListJobIoK8sApiCoreV1EmptyDirVolumeSource()
            self.empty_dir = temp_model.from_map(m['emptyDir'])
        if m.get('ephemeral') is not None:
            temp_model = ListJobIoK8sApiCoreV1EphemeralVolumeSource()
            self.ephemeral = temp_model.from_map(m['ephemeral'])
        if m.get('fc') is not None:
            temp_model = ListJobIoK8sApiCoreV1FCVolumeSource()
            self.fc = temp_model.from_map(m['fc'])
        if m.get('flexVolume') is not None:
            temp_model = ListJobIoK8sApiCoreV1FlexVolumeSource()
            self.flex_volume = temp_model.from_map(m['flexVolume'])
        if m.get('flocker') is not None:
            temp_model = ListJobIoK8sApiCoreV1FlockerVolumeSource()
            self.flocker = temp_model.from_map(m['flocker'])
        if m.get('gcePersistentDisk') is not None:
            temp_model = ListJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource()
            self.gce_persistent_disk = temp_model.from_map(m['gcePersistentDisk'])
        if m.get('gitRepo') is not None:
            temp_model = ListJobIoK8sApiCoreV1GitRepoVolumeSource()
            self.git_repo = temp_model.from_map(m['gitRepo'])
        if m.get('glusterfs') is not None:
            temp_model = ListJobIoK8sApiCoreV1GlusterfsVolumeSource()
            self.glusterfs = temp_model.from_map(m['glusterfs'])
        if m.get('hostPath') is not None:
            temp_model = ListJobIoK8sApiCoreV1HostPathVolumeSource()
            self.host_path = temp_model.from_map(m['hostPath'])
        if m.get('iscsi') is not None:
            temp_model = ListJobIoK8sApiCoreV1ISCSIVolumeSource()
            self.iscsi = temp_model.from_map(m['iscsi'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nfs') is not None:
            temp_model = ListJobIoK8sApiCoreV1NFSVolumeSource()
            self.nfs = temp_model.from_map(m['nfs'])
        if m.get('persistentVolumeClaim') is not None:
            temp_model = ListJobIoK8sApiCoreV1PersistentVolumeClaimVolumeSource()
            self.persistent_volume_claim = temp_model.from_map(m['persistentVolumeClaim'])
        if m.get('photonPersistentDisk') is not None:
            temp_model = ListJobIoK8sApiCoreV1PhotonPersistentDiskVolumeSource()
            self.photon_persistent_disk = temp_model.from_map(m['photonPersistentDisk'])
        if m.get('portworxVolume') is not None:
            temp_model = ListJobIoK8sApiCoreV1PortworxVolumeSource()
            self.portworx_volume = temp_model.from_map(m['portworxVolume'])
        if m.get('projected') is not None:
            temp_model = ListJobIoK8sApiCoreV1ProjectedVolumeSource()
            self.projected = temp_model.from_map(m['projected'])
        if m.get('quobyte') is not None:
            temp_model = ListJobIoK8sApiCoreV1QuobyteVolumeSource()
            self.quobyte = temp_model.from_map(m['quobyte'])
        if m.get('rbd') is not None:
            temp_model = ListJobIoK8sApiCoreV1RBDVolumeSource()
            self.rbd = temp_model.from_map(m['rbd'])
        if m.get('scaleIO') is not None:
            temp_model = ListJobIoK8sApiCoreV1ScaleIOVolumeSource()
            self.scale_io = temp_model.from_map(m['scaleIO'])
        if m.get('secret') is not None:
            temp_model = ListJobIoK8sApiCoreV1SecretVolumeSource()
            self.secret = temp_model.from_map(m['secret'])
        if m.get('storageos') is not None:
            temp_model = ListJobIoK8sApiCoreV1StorageOSVolumeSource()
            self.storageos = temp_model.from_map(m['storageos'])
        if m.get('vsphereVolume') is not None:
            temp_model = ListJobIoK8sApiCoreV1VsphereVirtualDiskVolumeSource()
            self.vsphere_volume = temp_model.from_map(m['vsphereVolume'])
        return self


class ListJobIoK8sApiCoreV1PodSpec(TeaModel):
    def __init__(
        self,
        active_deadline_seconds: int = None,
        affinity: ListJobIoK8sApiCoreV1Affinity = None,
        automount_service_account_token: bool = None,
        containers: List[ListJobIoK8sApiCoreV1Container] = None,
        dns_config: ListJobIoK8sApiCoreV1PodDNSConfig = None,
        dns_policy: str = None,
        enable_service_links: bool = None,
        ephemeral_containers: List[ListJobIoK8sApiCoreV1EphemeralContainer] = None,
        host_aliases: List[ListJobIoK8sApiCoreV1HostAlias] = None,
        host_ipc: bool = None,
        host_network: bool = None,
        host_pid: bool = None,
        hostname: str = None,
        image_pull_secrets: List[ListJobIoK8sApiCoreV1LocalObjectReference] = None,
        init_containers: List[ListJobIoK8sApiCoreV1Container] = None,
        node_name: str = None,
        node_selector: Dict[str, Any] = None,
        overhead: Dict[str, Any] = None,
        preemption_policy: str = None,
        priority: int = None,
        priority_class_name: str = None,
        readiness_gates: List[ListJobIoK8sApiCoreV1PodReadinessGate] = None,
        restart_policy: str = None,
        runtime_class_name: str = None,
        scheduler_name: str = None,
        security_context: ListJobIoK8sApiCoreV1PodSecurityContext = None,
        service_account: str = None,
        service_account_name: str = None,
        set_hostname_as_fqdn: bool = None,
        share_process_namespace: bool = None,
        subdomain: str = None,
        termination_grace_period_seconds: int = None,
        tolerations: List[ListJobIoK8sApiCoreV1Toleration] = None,
        topology_spread_constraints: List[ListJobIoK8sApiCoreV1TopologySpreadConstraint] = None,
        volumes: List[ListJobIoK8sApiCoreV1Volume] = None,
    ):
        # {"en": "Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.", "zh_CN": "在系统将主动尝试将此 Pod 标记为已失败并杀死相关容器之前，Pod 可能在节点上活跃的时长； 市场计算基于 startTime 计算间（以秒为单位）。字段值必须是正整数"}
        self.active_deadline_seconds = active_deadline_seconds
        # {"en": "If specified, the pod's scheduling constraints", "zh_CN": "如果指定了，则作为 Pod 的调度约束"}
        self.affinity = affinity
        # {"en": "AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.", "zh_CN": "指示是否应自动挂载服务帐户令牌"}
        self.automount_service_account_token = automount_service_account_token
        # {"en": "List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.", "zh_CN": "属于 Pod 的容器列表。当前无法添加或删除容器。Pod 中必须至少有一个容器。无法更新"}
        self.containers = containers
        # {"en": "Specifies the DNS parameters of a pod. ListJobParameters specified here will be merged to the generated DNS configuration based on DNSPolicy.", "zh_CN": "指定 Pod 的 DNS 参数。此处指定的参数将被合并到基于 dnsPolicy 生成的 DNS 配置中"}
        self.dns_config = dns_config
        # {"en": "Set DNS policy for the pod. Defaults to ClusterFirst. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.", "zh_CN": "为 Pod 设置 DNS 策略。默认为 “ClusterFirst”。 有效值为 “ClusterFirstWithHostNet”、“ClusterFirst”、“Default” 或 “None”。 dnsConfig 字段中给出的 DNS 参数将与使用 dnsPolicy 字段所选择的策略合并。 要针对 hostNetwork 的 Pod 设置 DNS 选项，你必须将 DNS 策略显式设置为 “ClusterFirstWithHostNet”"}
        self.dns_policy = dns_policy
        # {"en": "EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.", "zh_CN": "enableServiceLinks 指示是否应将有关服务的信息注入到 Pod 的环境变量中，服务连接的语法与 Docker links 的语法相匹配。可选。默认为 true"}
        self.enable_service_links = enable_service_links
        # {"en": "List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.", "zh_CN": "在此 Pod 中运行的临时容器列表。临时容器可以在现有的 Pod 中运行，以执行用户发起的操作，例如调试。 此列表在创建 Pod 时不能指定，也不能通过更新 Pod 规约来修改。 要将临时容器添加到现有 Pod，请使用 Pod 的 ephemeralcontainers 子资源"}
        self.ephemeral_containers = ephemeral_containers
        # {"en": "HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.", "zh_CN": "hostAliases 是一个可选的列表属性，包含要被注入到 Pod 的 hosts 文件中的主机和 IP 地址。 这仅对非 hostNetwork Pod 有效"}
        self.host_aliases = host_aliases
        # {"en": "Use the host's ipc namespace. Optional: Default to false.", "zh_CN": "使用主机的 IPC 名字空间。可选：默认为 false"}
        self.host_ipc = host_ipc
        # {"en": "Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.", "zh_CN": "为此 Pod 请求主机层面联网支持。使用主机的网络名字空间。 如果设置了此选项，则必须指定将使用的端口。默认为 false"}
        self.host_network = host_network
        # {"en": "Use the host's pid namespace. Optional: Default to false.", "zh_CN": "使用主机的 PID 名字空间。可选：默认为 false"}
        self.host_pid = host_pid
        # {"en": "Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.", "zh_CN": "指定 Pod 的主机名。如果此字段未指定，则 Pod 的主机名将设置为系统定义的值"}
        self.hostname = hostname
        # {"en": "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod", "zh_CN": "imagePullSecrets 是对同一名字空间中 Secret 的引用的列表，用于拉取此 Pod 规约中使用的任何镜像，此字段可选。 如果指定，这些 Secret 将被传递给各个镜像拉取组件（Puller）实现供其使用"}
        self.image_pull_secrets = image_pull_secrets
        # {"en": "List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/", "zh_CN": "属于 Pod 的 Init 容器列表。Init 容器在容器启动之前按顺序执行。 如果任何一个 Init 容器发生故障，则认为该 Pod 失败，并根据其 restartPolicy 处理。 Init 容器或普通容器的名称在所有容器中必须是唯一的。 Init 容器不可以有生命周期操作、就绪态探针、存活态探针或启动探针。 在调度过程中会考虑 Init 容器的资源需求，方法是查找每种资源类型的最高请求/限制， 然后使用该值的最大值或正常容器的资源请求的总和。 对资源限制以类似的方式应用于 Init 容器。当前无法添加或删除 Init 容器。无法更新"}
        self.init_containers = init_containers
        # {"en": "NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.", "zh_CN": "将此 Pod 调度到特定节点的请求。 如果字段值不为空，调度器只是直接将这个 Pod 调度到所指定节点上，假设节点符合资源要求"}
        self.node_name = node_name
        # {"en": "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/", "zh_CN": "nodeSelector 是一个选择算符，这些算符必须取值为 true 才能认为 Pod 适合在节点上运行。 选择算符必须与节点的标签匹配，以便在该节点上调度 Pod"}
        self.node_selector = node_selector
        # {"en": "Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.", "zh_CN": "overhead 表示与用指定 RuntimeClass 运行 Pod 相关的资源开销。 该字段将由 RuntimeClass 准入控制器在准入时自动填充。 如果启用了 RuntimeClass 准入控制器，则不得在 Pod 创建请求中设置 overhead 字段。 RuntimeClass 准入控制器将拒绝已设置 overhead 字段的 Pod 创建请求。 如果在 Pod 规约中配置并选择了 RuntimeClass，overhead 字段将被设置为对应 RuntimeClass 中定义的值， 否则将保持不设置并视为零"}
        self.overhead = overhead
        # {"en": "PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.", "zh_CN": "preemptionPolicy 是用来抢占优先级较低的 Pod 的策略。取值为 “Never”、“PreemptLowerPriority” 之一。 如果未设置，则默认为 “PreemptLowerPriority”"}
        self.preemption_policy = preemption_policy
        # {"en": "The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.", "zh_CN": "优先级值。各种系统组件使用该字段来确定 Pod 的优先级。当启用 Priority 准入控制器时， 该控制器会阻止用户设置此字段。准入控制器基于 priorityClassName 设置来填充此字段。 字段值越高，优先级越高"}
        self.priority = priority
        # {"en": "If specified, indicates the pod's priority. system-node-critical and system-cluster-critical are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.", "zh_CN": "如果设置了此字段，则用来标明 Pod 的优先级。 “system-node-critical” 和 “system-cluster-critical” 是两个特殊关键字， 分别用来表示两个最高优先级，前者优先级更高一些。 任何其他名称都必须通过创建具有该名称的 PriorityClass 对象来定义。 如果未指定此字段，则 Pod 优先级将为默认值。如果没有默认值，则为零"}
        self.priority_class_name = priority_class_name
        # {"en": "If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to True More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md", "zh_CN": "如果设置了此字段，则将评估所有就绪门控（Readiness Gate）以确定 Pod 就绪状况。 当所有容器都已就绪，并且就绪门控中指定的所有状况的 status 都为 true 时，Pod 被视为就绪"}
        self.readiness_gates = readiness_gates
        # {"en": "Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy", "zh_CN": "Pod 内所有容器的重启策略。Always、OnFailure、Never 之一。 在某些情况下，可能只允许这些值的一个子集。默认为 Always"}
        self.restart_policy = restart_policy
        # {"en": "RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the legacy RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.", "zh_CN": "runtimeClassName 引用 node.k8s.io 组中的一个 RuntimeClass 对象，该 RuntimeClass 将被用来运行这个 Pod。 如果没有 RuntimeClass 资源与所设置的类匹配，则 Pod 将不会运行。 如果此字段未设置或为空，将使用 “旧版” RuntimeClass。 “旧版” RuntimeClass 可以视作一个隐式的运行时类，其定义为空，会使用默认运行时处理程序"}
        self.runtime_class_name = runtime_class_name
        # {"en": "If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.", "zh_CN": "如果设置了此字段，则 Pod 将由指定的调度器调度。如果未指定，则使用默认调度器来调度 Pod"}
        self.scheduler_name = scheduler_name
        # {"en": "SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.", "zh_CN": "SecurityContext 包含 Pod 级别的安全属性和常见的容器设置。 可选：默认为空。每个字段的默认值见类型描述"}
        self.security_context = security_context
        # {"en": "DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.", "zh_CN": "deprecatedServiceAccount 是 serviceAccountName 的弃用别名。此字段已被弃用：应改用 serviceAccountName"}
        self.service_account = service_account
        # {"en": "ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/", "zh_CN": "serviceAccountName 是用于运行此 Pod 的服务账号的名称"}
        self.service_account_name = service_account_name
        # {"en": "If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\ListJobParameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.", "zh_CN": "如果为 true，则 Pod 的主机名将配置为 Pod 的 FQDN，而不是叶名称（默认值）。 在 Linux 容器中，这意味着将内核的 hostname 字段（struct utsname 的 nodename 字段）设置为 FQDN。 在 Windows 容器中，这意味着将注册表项 HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\ListJobParameters 的 hostname 键设置为 FQDN。如果 Pod 没有 FQDN，则此字段不起作用。 默认为 false。"}
        self.set_hostname_as_fqdn = set_hostname_as_fqdn
        # {"en": "Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.", "zh_CN": "在 Pod 中的所有容器之间共享单个进程名字空间。设置了此字段之后，容器将能够查看来自同一 Pod 中其他容器的进程并发出信号， 并且每个容器中的第一个进程不会被分配 PID 1。hostPID 和 shareProcessNamespace 不能同时设置。 可选：默认为 false"}
        self.share_process_namespace = share_process_namespace
        # {"en": "If specified, the fully qualified Pod hostname will be <hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>. If not specified, the pod will not have a domainname at all.", "zh_CN": "如果设置了此字段，则完全限定的 Pod 主机名将是 <hostname>.<subdomain>.<Pod 名字空间>.svc.<集群域名>。 如果未设置此字段，则该 Pod 将没有域名"}
        self.subdomain = subdomain
        # {"en": "Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.", "zh_CN": "Pod 需要在探针失败时体面终止所需的时间长度（以秒为单位），为可选字段。 宽限期是 Pod 中运行的进程收到终止信号后，到进程被终止信号强制停止之前的时间长度（以秒为单位）。 你应该将此值设置为比你的进程的预期清理时间更长。 如果此值为 nil，则将使用 Pod 的 terminateGracePeriodSeconds。 否则，此值将覆盖 Pod 规约中设置的值。字段值值必须是非负整数。 零值表示收到终止信号立即停止（没有机会关闭）。 这是一个 Beta 字段，需要启用 ProbeTerminationGracePeriod 特性门控。最小值为 1。 如果未设置，则使用 spec.terminationGracePeriodSeconds"}
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # {"en": "If specified, the pod's tolerations.", "zh_CN": "如果设置了此字段，则作为 Pod 的容忍度"}
        self.tolerations = tolerations
        # {"en": "TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.", "zh_CN": "TopologySpreadConstraints 描述一组 Pod 应该如何跨拓扑域来分布。调度器将以遵从此约束的方式来调度 Pod。 所有 topologySpreadConstraints 条目会通过逻辑与操作进行组合"}
        self.topology_spread_constraints = topology_spread_constraints
        # {"en": "List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes", "zh_CN": "可以由属于 Pod 的容器挂载的卷列表"}
        self.volumes = volumes

    def validate(self):
        if self.affinity:
            self.affinity.validate()
        self.validate_required(self.containers, 'containers')
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()
        if self.dns_config:
            self.dns_config.validate()
        if self.ephemeral_containers:
            for k in self.ephemeral_containers:
                if k:
                    k.validate()
        if self.host_aliases:
            for k in self.host_aliases:
                if k:
                    k.validate()
        if self.image_pull_secrets:
            for k in self.image_pull_secrets:
                if k:
                    k.validate()
        if self.init_containers:
            for k in self.init_containers:
                if k:
                    k.validate()
        if self.readiness_gates:
            for k in self.readiness_gates:
                if k:
                    k.validate()
        if self.security_context:
            self.security_context.validate()
        if self.tolerations:
            for k in self.tolerations:
                if k:
                    k.validate()
        if self.topology_spread_constraints:
            for k in self.topology_spread_constraints:
                if k:
                    k.validate()
        if self.volumes:
            for k in self.volumes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_deadline_seconds is not None:
            result['activeDeadlineSeconds'] = self.active_deadline_seconds
        if self.affinity is not None:
            result['affinity'] = self.affinity.to_map()
        if self.automount_service_account_token is not None:
            result['automountServiceAccountToken'] = self.automount_service_account_token
        if self.containers is not None:
            result['containers'] = []
            for k in self.containers:
                result['containers'].append(k.to_map() if k else None)
        if self.dns_config is not None:
            result['dnsConfig'] = self.dns_config.to_map()
        if self.dns_policy is not None:
            result['dnsPolicy'] = self.dns_policy
        if self.enable_service_links is not None:
            result['enableServiceLinks'] = self.enable_service_links
        if self.ephemeral_containers is not None:
            result['ephemeralContainers'] = []
            for k in self.ephemeral_containers:
                result['ephemeralContainers'].append(k.to_map() if k else None)
        if self.host_aliases is not None:
            result['hostAliases'] = []
            for k in self.host_aliases:
                result['hostAliases'].append(k.to_map() if k else None)
        if self.host_ipc is not None:
            result['hostIPC'] = self.host_ipc
        if self.host_network is not None:
            result['hostNetwork'] = self.host_network
        if self.host_pid is not None:
            result['hostPID'] = self.host_pid
        if self.hostname is not None:
            result['hostname'] = self.hostname
        if self.image_pull_secrets is not None:
            result['imagePullSecrets'] = []
            for k in self.image_pull_secrets:
                result['imagePullSecrets'].append(k.to_map() if k else None)
        if self.init_containers is not None:
            result['initContainers'] = []
            for k in self.init_containers:
                result['initContainers'].append(k.to_map() if k else None)
        if self.node_name is not None:
            result['nodeName'] = self.node_name
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector
        if self.overhead is not None:
            result['overhead'] = self.overhead
        if self.preemption_policy is not None:
            result['preemptionPolicy'] = self.preemption_policy
        if self.priority is not None:
            result['priority'] = self.priority
        if self.priority_class_name is not None:
            result['priorityClassName'] = self.priority_class_name
        if self.readiness_gates is not None:
            result['readinessGates'] = []
            for k in self.readiness_gates:
                result['readinessGates'].append(k.to_map() if k else None)
        if self.restart_policy is not None:
            result['restartPolicy'] = self.restart_policy
        if self.runtime_class_name is not None:
            result['runtimeClassName'] = self.runtime_class_name
        if self.scheduler_name is not None:
            result['schedulerName'] = self.scheduler_name
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.service_account is not None:
            result['serviceAccount'] = self.service_account
        if self.service_account_name is not None:
            result['serviceAccountName'] = self.service_account_name
        if self.set_hostname_as_fqdn is not None:
            result['setHostnameAsFQDN'] = self.set_hostname_as_fqdn
        if self.share_process_namespace is not None:
            result['shareProcessNamespace'] = self.share_process_namespace
        if self.subdomain is not None:
            result['subdomain'] = self.subdomain
        if self.termination_grace_period_seconds is not None:
            result['terminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.tolerations is not None:
            result['tolerations'] = []
            for k in self.tolerations:
                result['tolerations'].append(k.to_map() if k else None)
        if self.topology_spread_constraints is not None:
            result['topologySpreadConstraints'] = []
            for k in self.topology_spread_constraints:
                result['topologySpreadConstraints'].append(k.to_map() if k else None)
        if self.volumes is not None:
            result['volumes'] = []
            for k in self.volumes:
                result['volumes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activeDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('activeDeadlineSeconds')
        if m.get('affinity') is not None:
            temp_model = ListJobIoK8sApiCoreV1Affinity()
            self.affinity = temp_model.from_map(m['affinity'])
        if m.get('automountServiceAccountToken') is not None:
            self.automount_service_account_token = m.get('automountServiceAccountToken')
        if m.get('containers') is not None:
            self.containers = []
            for k in m.get('containers'):
                temp_model = ListJobIoK8sApiCoreV1Container()
                self.containers.append(temp_model.from_map(k))
        if m.get('dnsConfig') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodDNSConfig()
            self.dns_config = temp_model.from_map(m['dnsConfig'])
        if m.get('dnsPolicy') is not None:
            self.dns_policy = m.get('dnsPolicy')
        if m.get('enableServiceLinks') is not None:
            self.enable_service_links = m.get('enableServiceLinks')
        if m.get('ephemeralContainers') is not None:
            self.ephemeral_containers = []
            for k in m.get('ephemeralContainers'):
                temp_model = ListJobIoK8sApiCoreV1EphemeralContainer()
                self.ephemeral_containers.append(temp_model.from_map(k))
        if m.get('hostAliases') is not None:
            self.host_aliases = []
            for k in m.get('hostAliases'):
                temp_model = ListJobIoK8sApiCoreV1HostAlias()
                self.host_aliases.append(temp_model.from_map(k))
        if m.get('hostIPC') is not None:
            self.host_ipc = m.get('hostIPC')
        if m.get('hostNetwork') is not None:
            self.host_network = m.get('hostNetwork')
        if m.get('hostPID') is not None:
            self.host_pid = m.get('hostPID')
        if m.get('hostname') is not None:
            self.hostname = m.get('hostname')
        if m.get('imagePullSecrets') is not None:
            self.image_pull_secrets = []
            for k in m.get('imagePullSecrets'):
                temp_model = ListJobIoK8sApiCoreV1LocalObjectReference()
                self.image_pull_secrets.append(temp_model.from_map(k))
        if m.get('initContainers') is not None:
            self.init_containers = []
            for k in m.get('initContainers'):
                temp_model = ListJobIoK8sApiCoreV1Container()
                self.init_containers.append(temp_model.from_map(k))
        if m.get('nodeName') is not None:
            self.node_name = m.get('nodeName')
        if m.get('nodeSelector') is not None:
            self.node_selector = m.get('nodeSelector')
        if m.get('overhead') is not None:
            self.overhead = m.get('overhead')
        if m.get('preemptionPolicy') is not None:
            self.preemption_policy = m.get('preemptionPolicy')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('priorityClassName') is not None:
            self.priority_class_name = m.get('priorityClassName')
        if m.get('readinessGates') is not None:
            self.readiness_gates = []
            for k in m.get('readinessGates'):
                temp_model = ListJobIoK8sApiCoreV1PodReadinessGate()
                self.readiness_gates.append(temp_model.from_map(k))
        if m.get('restartPolicy') is not None:
            self.restart_policy = m.get('restartPolicy')
        if m.get('runtimeClassName') is not None:
            self.runtime_class_name = m.get('runtimeClassName')
        if m.get('schedulerName') is not None:
            self.scheduler_name = m.get('schedulerName')
        if m.get('securityContext') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodSecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('serviceAccount') is not None:
            self.service_account = m.get('serviceAccount')
        if m.get('serviceAccountName') is not None:
            self.service_account_name = m.get('serviceAccountName')
        if m.get('setHostnameAsFQDN') is not None:
            self.set_hostname_as_fqdn = m.get('setHostnameAsFQDN')
        if m.get('shareProcessNamespace') is not None:
            self.share_process_namespace = m.get('shareProcessNamespace')
        if m.get('subdomain') is not None:
            self.subdomain = m.get('subdomain')
        if m.get('terminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('terminationGracePeriodSeconds')
        if m.get('tolerations') is not None:
            self.tolerations = []
            for k in m.get('tolerations'):
                temp_model = ListJobIoK8sApiCoreV1Toleration()
                self.tolerations.append(temp_model.from_map(k))
        if m.get('topologySpreadConstraints') is not None:
            self.topology_spread_constraints = []
            for k in m.get('topologySpreadConstraints'):
                temp_model = ListJobIoK8sApiCoreV1TopologySpreadConstraint()
                self.topology_spread_constraints.append(temp_model.from_map(k))
        if m.get('volumes') is not None:
            self.volumes = []
            for k in m.get('volumes'):
                temp_model = ListJobIoK8sApiCoreV1Volume()
                self.volumes.append(temp_model.from_map(k))
        return self


class ListJobIoK8sApiCoreV1PodTemplateSpec(TeaModel):
    def __init__(
        self,
        metadata: ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: ListJobIoK8sApiCoreV1PodSpec = None,
    ):
        # {"en": "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "标准的对象元数据"}
        self.metadata = metadata
        # {"en": "Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status", "zh_CN": "Pod 预期行为的规约"}
        self.spec = spec

    def validate(self):
        if self.metadata:
            self.metadata.validate()
        if self.spec:
            self.spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('metadata') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodSpec()
            self.spec = temp_model.from_map(m['spec'])
        return self


class ListJobIoK8sApiBatchV1JobSpec(TeaModel):
    def __init__(
        self,
        active_deadline_seconds: int = None,
        backoff_limit: int = None,
        completions: int = None,
        manual_selector: bool = None,
        parallelism: int = None,
        selector: ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        template: ListJobIoK8sApiCoreV1PodTemplateSpec = None,
        ttl_seconds_after_finished: int = None,
    ):
        # {"en": "Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer", "zh_CN": "系统尝试终止任务之前任务可以持续活跃的持续时间（秒），时间长度是相对于 startTime 的； 字段值必须为正整数。如果任务被挂起（在创建期间或因更新而挂起）， 则当任务再次恢复时，此计时器会被停止并重置"}
        self.active_deadline_seconds = active_deadline_seconds
        # {"en": "Specifies the number of retries before marking this job failed. Defaults to 6", "zh_CN": "指定标记此任务失败之前的重试次数。默认值为 6"}
        self.backoff_limit = backoff_limit
        # {"en": "Specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "指定任务应该运行并预期成功完成的 Pod 个数。设置为空意味着任何 Pod 的成功都标识着所有 Pod 的成功， 并允许 parallelism 设置为任何正值。设置为 1 意味着并行性被限制为 1，并且该 Pod 的成功标志着任务的成功"}
        self.completions = completions
        # {"en": "manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector", "zh_CN": "manualSelector 控制 Pod 标签和 Pod 选择器的生成。除非你确定你在做什么，否则不要设置 manualSelector。 当此字段为 false 或未设置时，系统会选择此 Pod 唯一的标签并将这些标签附加到 Pod 模板。 当此字段为 true 时，用户负责选择唯一标签并指定选择器。 未能选择唯一标签可能会导致此任务和其他任务无法正常运行。但是，你可能会在使用旧的 extensions/v1beta1 API 创建的任务中看到 manualSelector=true"}
        self.manual_selector = manual_selector
        # {"en": "Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "指定任务应在任何给定时刻预期运行的 Pod 个数上限。 当(.spec.completions - .status.successful) < .spec.parallelism 时， 即当剩余的工作小于最大并行度时，在稳定状态下运行的 Pod 的实际数量将小于此数量"}
        self.parallelism = parallelism
        # {"en": "A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors", "zh_CN": "对应与 Pod 计数匹配的 Pod 的标签查询。通常，系统会为你设置此字段"}
        self.selector = selector
        # {"en": "Describes the pod that will be created when executing a job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "描述执行任务时将创建的 Pod。template.spec.restartPolicy 可以取的值只能是 Never 或 OnFailure"}
        self.template = template
        # {"en": "ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the TTLAfterFinished feature.", "zh_CN": "ttlSecondsAfterFinished 限制已完成执行（完成或失败）的任务的生命周期。如果设置了这个字段， 在 Job 完成 ttlSecondsAfterFinished 秒之后，就可以被自动删除。 当 Job 被删除时，它的生命周期保证（例如终结器）会被考察。 如果未设置此字段，则任务不会被自动删除。如果此字段设置为零，则任务在完成后即可立即删除"}
        self.ttl_seconds_after_finished = ttl_seconds_after_finished

    def validate(self):
        if self.selector:
            self.selector.validate()
        self.validate_required(self.template, 'template')
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_deadline_seconds is not None:
            result['activeDeadlineSeconds'] = self.active_deadline_seconds
        if self.backoff_limit is not None:
            result['backoffLimit'] = self.backoff_limit
        if self.completions is not None:
            result['completions'] = self.completions
        if self.manual_selector is not None:
            result['manualSelector'] = self.manual_selector
        if self.parallelism is not None:
            result['parallelism'] = self.parallelism
        if self.selector is not None:
            result['selector'] = self.selector.to_map()
        if self.template is not None:
            result['template'] = self.template.to_map()
        if self.ttl_seconds_after_finished is not None:
            result['ttlSecondsAfterFinished'] = self.ttl_seconds_after_finished
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activeDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('activeDeadlineSeconds')
        if m.get('backoffLimit') is not None:
            self.backoff_limit = m.get('backoffLimit')
        if m.get('completions') is not None:
            self.completions = m.get('completions')
        if m.get('manualSelector') is not None:
            self.manual_selector = m.get('manualSelector')
        if m.get('parallelism') is not None:
            self.parallelism = m.get('parallelism')
        if m.get('selector') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.selector = temp_model.from_map(m['selector'])
        if m.get('template') is not None:
            temp_model = ListJobIoK8sApiCoreV1PodTemplateSpec()
            self.template = temp_model.from_map(m['template'])
        if m.get('ttlSecondsAfterFinished') is not None:
            self.ttl_seconds_after_finished = m.get('ttlSecondsAfterFinished')
        return self


class ListJobIoK8sApiBatchV1JobCondition(TeaModel):
    def __init__(
        self,
        last_probe_time: str = None,
        last_transition_time: str = None,
        message: str = None,
        reason: str = None,
        status: str = None,
        type: str = None,
    ):
        # {"en": "Last time the condition was checked.", "zh_CN": "最后一次探测的时间"}
        self.last_probe_time = last_probe_time
        # {"en": "Last time the condition transit from one status to another.", "zh_CN": "上一次从一种状况转换到另一种状况的时间"}
        self.last_transition_time = last_transition_time
        # {"en": "Human readable message indicating details about last transition.", "zh_CN": "表示上次转换信息的人类可读消息"}
        self.message = message
        # {"en": "(brief) reason for the condition's last transition.", "zh_CN": "状况最后一次转换的（简要）原因"}
        self.reason = reason
        # {"en": "Status of the condition, one of True, False, Unknown.", "zh_CN": "状况的状态：True、False、Unknown 之一"}
        self.status = status
        # {"en": "Type of job condition, Complete or Failed.", "zh_CN": "任务状况的类型：Completed 或 Failed"}
        self.type = type

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_probe_time is not None:
            result['lastProbeTime'] = self.last_probe_time
        if self.last_transition_time is not None:
            result['lastTransitionTime'] = self.last_transition_time
        if self.message is not None:
            result['message'] = self.message
        if self.reason is not None:
            result['reason'] = self.reason
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('lastProbeTime') is not None:
            self.last_probe_time = m.get('lastProbeTime')
        if m.get('lastTransitionTime') is not None:
            self.last_transition_time = m.get('lastTransitionTime')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class ListJobIoK8sApiBatchV1JobStatus(TeaModel):
    def __init__(
        self,
        active: int = None,
        completion_time: str = None,
        conditions: List[ListJobIoK8sApiBatchV1JobCondition] = None,
        failed: int = None,
        start_time: str = None,
        succeeded: int = None,
    ):
        # {"en": "The number of actively running pods.", "zh_CN": "待处理和正在运行的 Pod 的数量"}
        self.active = active
        # {"en": "Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is only set when the job finishes successfully.", "zh_CN": "表示任务完成的时间。不能保证对多个独立操作按发生的先后顺序设置。此字段表示为 RFC3339 格式的 UTC 时间。 仅当任务成功完成时才设置完成时间"}
        self.completion_time = completion_time
        # {"en": "The latest available observations of an object's current state. When a job fails, one of the conditions will have type == Failed. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "对象当前状态的最新可用观察结果。当任务失败时，其中一个状况的类型为 “Failed”，状态为 true。 当任务被暂停时，其中一个状况的类型为 “Suspended”，状态为true；当任务被恢复时，该状况的状态将变为 false。 任务完成时，其中一个状况的类型为 “Complete”，状态为 true"}
        self.conditions = conditions
        # {"en": "The number of pods which reached phase Failed.", "zh_CN": "进入 Failed 阶段的 Pod 数量"}
        self.failed = failed
        # {"en": "Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.", "zh_CN": "表示任务控制器开始处理任务的时间。在挂起状态下创建 Job 时，直到第一次恢复时才会设置此字段。 每次从暂停中恢复任务时都会重置此字段。它表示为 RFC3339 格式的 UTC 时间"}
        self.start_time = start_time
        # {"en": "The number of pods which reached phase Succeeded.", "zh_CN": "进入 Succeeded 阶段的 Pod 数量"}
        self.succeeded = succeeded

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.completion_time is not None:
            result['completionTime'] = self.completion_time
        if self.conditions is not None:
            result['conditions'] = []
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.failed is not None:
            result['failed'] = self.failed
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.succeeded is not None:
            result['succeeded'] = self.succeeded
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('completionTime') is not None:
            self.completion_time = m.get('completionTime')
        if m.get('conditions') is not None:
            self.conditions = []
            for k in m.get('conditions'):
                temp_model = ListJobIoK8sApiBatchV1JobCondition()
                self.conditions.append(temp_model.from_map(k))
        if m.get('failed') is not None:
            self.failed = m.get('failed')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('succeeded') is not None:
            self.succeeded = m.get('succeeded')
        return self


class ListJobIoK8sApiBatchV1Job(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: ListJobIoK8sApiBatchV1JobSpec = None,
        status: ListJobIoK8sApiBatchV1JobStatus = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata
        # {"en":"Specification of the desired behavior of a job", "zh_CN":"任务的预期行为的规约"}
        self.spec = spec
        # {"en": "Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status", "zh_CN": "任务的当前状态"}
        self.status = status

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()
        if self.spec:
            self.spec.validate()
        if self.status:
            self.status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        if self.status is not None:
            result['status'] = self.status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = ListJobIoK8sApiBatchV1JobSpec()
            self.spec = temp_model.from_map(m['spec'])
        if m.get('status') is not None:
            temp_model = ListJobIoK8sApiBatchV1JobStatus()
            self.status = temp_model.from_map(m['status'])
        return self


class ListJobIoK8sApimachineryPkgApisMetaV1ListMeta(TeaModel):
    def __init__(
        self,
        continue_: str = None,
        remaining_item_count: int = None,
        resource_version: str = None,
        self_link: str = None,
    ):
        # {"en": "continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.", "zh_CN": "如果用户对返回的条目数量设置了限制，则 continue 可能被设置，表示服务器有更多可用的数据。 该值是不透明的，可用于向提供此列表服务的端点发出另一个请求，以检索下一组可用的对象。 如果服务器配置已更改或时间已过去几分钟，则可能无法继续提供一致的列表。 除非你在错误消息中收到此令牌（token），否则使用此 continue 值时返回的 resourceVersion 字段应该和第一个响应中的值是相同的"}
        self.continue_ = continue_
        # {"en": "remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.", "zh_CN": "remainingItemCount 是列表中未包含在此列表响应中的后续项目的数量。 如果列表请求包含标签或字段选择器，则剩余项目的数量是未知的，并且在序列化期间该字段将保持未设置和省略。 如果列表是完整的（因为它没有分块或者这是最后一个块），那么就没有剩余的项目，并且在序列化过程中该字段将保持未设置和省略。 早于 v1.15 的服务器不设置此字段。remainingItemCount 的预期用途是估计集合的大小。 客户端不应依赖于设置准确的 remainingItemCount"}
        self.remaining_item_count = remaining_item_count
        # {"en": "String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency", "zh_CN": "标识该对象的服务器内部版本的字符串，客户端可以用该字段来确定对象何时被更改。 该值对客户端是不透明的，并且应该原样传回给服务器。该值由系统填充，只读"}
        self.resource_version = resource_version
        # {"en": "selfLink is a URL representing this object. Populated by the system. Read-only.DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.", "zh_CN": "selfLink 表示此对象的 URL，由系统填充，只读。已弃用：selfLink 是一个遗留的只读字段，不再由系统填充"}
        self.self_link = self_link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.continue_ is not None:
            result['continue'] = self.continue_
        if self.remaining_item_count is not None:
            result['remainingItemCount'] = self.remaining_item_count
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('continue') is not None:
            self.continue_ = m.get('continue')
        if m.get('remainingItemCount') is not None:
            self.remaining_item_count = m.get('remainingItemCount')
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        return self


class ListJobIoK8sApiBatchV1JobList(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        items: List[ListJobIoK8sApiBatchV1Job] = None,
        kind: str = None,
        metadata: ListJobIoK8sApimachineryPkgApisMetaV1ListMeta = None,
    ):
        # {"en": "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources", "zh_CN": "APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en": "items is the list of Jobs.", "zh_CN": "items 是 Job 对象的列表"}
        self.items = items
        # {"en": "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds", "zh_CN": "kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en": "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "标准列表元数据"}
        self.metadata = metadata

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()
        if self.metadata:
            self.metadata.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = ListJobIoK8sApiBatchV1Job()
                self.items.append(temp_model.from_map(k))
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = ListJobIoK8sApimachineryPkgApisMetaV1ListMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        return self


class ListJobResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: ListJobIoK8sApiBatchV1JobList = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"job list", "zh_CN":"job 列表"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = ListJobIoK8sApiBatchV1JobList()
            self.data = temp_model.from_map(m['data'])
        return self


class ListJobPaths(TeaModel):
    def __init__(
        self,
        namespace: str = None,
    ):
        # {"en":"namespace", "zh_CN":"命名空间"}
        self.namespace = namespace

    def validate(self):
        self.validate_required(self.namespace, 'namespace')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['namespace'] = self.namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        return self


class ListJobParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListJobRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListJobResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        fields_type: str = None,
        fields_v1: Dict[str, Any] = None,
        manager: str = None,
        operation: str = None,
        time: str = None,
    ):
        # {"en": "APIVersion defines the version of this resource that this field set applies to. The format is group/version just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.", "zh_CN": "apiVersion 定义此字段集适用的资源的版本。 格式是 “group/version”，就像顶级 apiVersion 字段一样。 必须跟踪字段集的版本，因为它不能自动转换"}
        self.api_version = api_version
        # {"en": "FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: FieldsV1", "zh_CN": "FieldsType 是不同字段格式和版本的鉴别器。 目前只有一个可能的值：“FieldsV1”"}
        self.fields_type = fields_type
        # {"en": "FieldsV1 holds the first JSON version format as described in the FieldsV1 type.", "zh_CN": "FieldsV1 包含类型 “FieldsV1” 中描述的第一个 JSON 版本格式"}
        self.fields_v1 = fields_v1
        # {"en": "Manager is an identifier of the workflow managing these fields.", "zh_CN": "管理这些字段的工作流的标识符"}
        self.manager = manager
        # {"en": "Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.", "zh_CN": "导致创建此 managedFields 表项的操作类型。 此字段的仅有合法值是 “Apply” 和 “Update”"}
        self.operation = operation
        # {"en": "Time is timestamp of when these fields were set. It should always be empty if Operation is 'Apply'", "zh_CN": "添加 managedFields 条目时的时间戳。 如果一个字段被添加、管理器更新任一所属字段值或移除一个字段，该时间戳也会更新。 从此条目中移除一个字段时该时间戳不会更新，因为另一个管理器将它接管了"}
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.fields_type is not None:
            result['fieldsType'] = self.fields_type
        if self.fields_v1 is not None:
            result['fieldsV1'] = self.fields_v1
        if self.manager is not None:
            result['manager'] = self.manager
        if self.operation is not None:
            result['operation'] = self.operation
        if self.time is not None:
            result['time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('fieldsType') is not None:
            self.fields_type = m.get('fieldsType')
        if m.get('fieldsV1') is not None:
            self.fields_v1 = m.get('fieldsV1')
        if m.get('manager') is not None:
            self.manager = m.get('manager')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('time') is not None:
            self.time = m.get('time')
        return self


class UpdateJobIoK8sApimachineryPkgApisMetaV1OwnerReference(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        block_owner_deletion: bool = None,
        controller: bool = None,
        kind: str = None,
        name: str = None,
        uid: str = None,
    ):
        # {"en": "API version of the referent.", "zh_CN": "被引用资源的 API 版本"}
        self.api_version = api_version
        # {"en": "If true, AND if the owner has the foregroundDeletion finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs delete permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.", "zh_CN": "如果为 true，**并且** 如果属主具有 “foregroundDeletion” 终结器，则在删除此引用之前，无法从键值存储中删除属主。 默认为 false。要设置此字段，用户需要属主的 “delete” 权限， 否则将返回 422 (Unprocessable Entity)"}
        self.block_owner_deletion = block_owner_deletion
        # {"en": "If true, this reference points to the managing controller.", "zh_CN": "如果为 true，则此引用指向管理的控制器"}
        self.controller = controller
        # {"en": "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds", "zh_CN": "被引用资源的类别"}
        self.kind = kind
        # {"en": "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids", "zh_CN": "被引用资源的 uid"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')
        self.validate_required(self.uid, 'uid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.block_owner_deletion is not None:
            result['blockOwnerDeletion'] = self.block_owner_deletion
        if self.controller is not None:
            result['controller'] = self.controller
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('blockOwnerDeletion') is not None:
            self.block_owner_deletion = m.get('blockOwnerDeletion')
        if m.get('controller') is not None:
            self.controller = m.get('controller')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta(TeaModel):
    def __init__(
        self,
        annotations: Dict[str, Any] = None,
        cluster_name: str = None,
        creation_timestamp: str = None,
        deletion_grace_period_seconds: int = None,
        deletion_timestamp: str = None,
        finalizers: List[str] = None,
        generate_name: str = None,
        generation: int = None,
        labels: Dict[str, Any] = None,
        managed_fields: List[UpdateJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry] = None,
        name: str = None,
        namespace: str = None,
        owner_references: List[UpdateJobIoK8sApimachineryPkgApisMetaV1OwnerReference] = None,
        resource_version: str = None,
        self_link: str = None,
        uid: str = None,
    ):
        # {"en": "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations", "zh_CN": "annotations 是一个非结构化的键值映射，存储在资源中，可以由外部工具设置以存储和检索任意元数据。 它们不可查询，在修改对象时应保留"}
        self.annotations = annotations
        # {"en": "The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.", "zh_CN": "对象所属集群的名称。用于区分不同集群中具有相同名称和namespace的资源。这个字段现在没有在任何地方设置，如果在创建或更新请求中设置，apisserver将忽略它"}
        self.cluster_name = cluster_name
        # {"en": "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "creationTimestamp 是一个时间戳，表示创建此对象时的服务器时间。 不能保证在单独的操作中按发生前的顺序设置。 客户端不得设置此值。它以 RFC3339 形式表示，并采用 UTC。由系统填充。只读。列表为空"}
        self.creation_timestamp = creation_timestamp
        # {"en": "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.", "zh_CN": "此对象从系统中删除之前允许正常终止的秒数。 仅当设置了 deletionTimestamp 时才设置。 只能缩短。只读"}
        self.deletion_grace_period_seconds = deletion_grace_period_seconds
        # {"en": "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "deletionTimestamp 是删除此资源的 RFC 3339 日期和时间。 该字段在用户请求体面删除时由服务器设置，客户端不能直接设置。 一旦 finalizers 列表为空，该资源预计将在此字段中的时间之后被删除 （不再从资源列表中可见，并且无法通过名称访问）。 只要 finalizers 列表包含项目，就阻止删除。一旦设置了 deletionTimestamp， 该值可能不会被取消设置或在未来进一步设置，尽管它可能会缩短或在此时间之前可能会删除资源。 例如，用户可能要求在 30 秒内删除一个 Pod。 Kubelet 将通过向 Pod 中的容器发送体面的终止信号来做出反应。 30 秒后，Kubelet 将向容器发送硬终止信号（SIGKILL）， 并在清理后从 API 中删除 Pod。在网络存在分区的情况下， 此对象可能在此时间戳之后仍然存在，直到管理员或自动化进程可以确定资源已完全终止。 如果未设置，则未请求体面删除该对象。请求体面删除时由系统填充。只读"}
        self.deletion_timestamp = deletion_timestamp
        # {"en": "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.", "zh_CN": "在从注册表中删除对象之前该字段必须为空。 每个条目都是负责的组件的标识符，各组件将从列表中删除自己对应的条目。 如果对象的 deletionTimestamp 非空，则只能删除此列表中的条目。 终结器可以按任何顺序处理和删除。没有按照顺序执行， 因为它引入了终结器卡住的重大风险。finalizers 是一个共享字段， 任何有权限的参与者都可以对其进行重新排序。如果按顺序处理终结器列表， 那么这可能导致列表中第一个负责终结器的组件正在等待列表中靠后负责终结器的组件产生的信号（字段值、外部系统或其他）， 从而导致死锁。在没有强制排序的情况下，终结者可以在它们之间自由排序， 并且不容易受到列表中排序更改的影响"}
        self.finalizers = finalizers
        # {"en": "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency", "zh_CN": "generateName 是一个可选前缀，由服务器使用，仅在未提供 name 字段时生成唯一名称。 如果使用此字段，则返回给客户端的名称将与传递的名称不同。该值还将与唯一的后缀组合。 提供的值与 name 字段具有相同的验证规则，并且可能会根据所需的后缀长度被截断，以使该值在服务器上唯一。如果指定了此字段并且生成的名称存在，则服务器将不会返回 409 ——相反，它将返回 201 Created 或 500， 原因是 ServerTimeout 指示在分配的时间内找不到唯一名称，客户端应重试（可选，在 Retry-After 标头中指定的时间之后）。仅在未指定 name 时应用"}
        self.generate_name = generate_name
        # {"en": "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.", "zh_CN": "表示期望状态的特定生成的序列号。由系统填充。只读"}
        self.generation = generation
        # {"en": "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels", "zh_CN": "可用于组织和分类（确定范围和选择）对象的字符串键和值的映射。 可以匹配 ReplicationController 和 Service 的选择算符"}
        self.labels = labels
        # {"en": "ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like ci-cd. The set of fields is always in the version that the workflow used when modifying the object.", "zh_CN": "managedFields 将 workflow-id 和版本映射到由该工作流管理的字段集。 这主要用于内部管理，用户通常不需要设置或理解该字段。 工作流可以是用户名、控制器名或特定应用路径的名称，如 “ci-cd”。 字段集始终存在于修改对象时工作流使用的版本"}
        self.managed_fields = managed_fields
        # {"en": "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names", "zh_CN": "name 在命名空间内必须是唯一的。创建资源时需要，尽管某些资源可能允许客户端请求自动地生成适当的名称。 名称主要用于创建幂等性和配置定义。无法更新"}
        self.name = name
        # {"en": "Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the default namespace, but default is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces", "zh_CN": "namespace 定义了一个值空间，其中每个名称必须唯一。空命名空间相当于 “default” 命名空间，但 “default” 是规范表示。 并非所有对象都需要限定在命名空间中——这些对象的此字段的值将为空。必须是 DNS_LABEL。无法更新"}
        self.namespace = namespace
        # {"en": "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.", "zh_CN": "此对象所依赖的对象列表。如果列表中的所有对象都已被删除，则该对象将被垃圾回收。 如果此对象由控制器管理，则此列表中的条目将指向此控制器，controller 字段设置为 true。 管理控制器不能超过一个"}
        self.owner_references = owner_references
        # {"en": "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency", "zh_CN": "一个不透明的值，表示此对象的内部版本，客户端可以使用该值来确定对象是否已被更改。 可用于乐观并发、变更检测以及对资源或资源集的监听操作。 客户端必须将这些值视为不透明的，且未更改地传回服务器。 它们可能仅对特定资源或一组资源有效。由系统填充。只读。客户端必须将值视为不透明"}
        self.resource_version = resource_version
        # {"en": "SelfLink is a URL representing this object. Populated by the system. Read-only.DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.", "zh_CN": "selfLink 是表示此对象的 URL。由系统填充。只读。已弃用。Kubernetes 将在 1.20 版本中停止传播该字段，并计划在 1.21 版本中删除该字段"}
        self.self_link = self_link
        # {"en": "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids", "zh_CN": "UID 是该对象在时间和空间上的唯一值。它通常由服务器在成功创建资源时生成，并且不允许使用 PUT 操作更改。由系统填充。只读"}
        self.uid = uid

    def validate(self):
        if self.managed_fields:
            for k in self.managed_fields:
                if k:
                    k.validate()
        if self.owner_references:
            for k in self.owner_references:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['annotations'] = self.annotations
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.creation_timestamp is not None:
            result['creationTimestamp'] = self.creation_timestamp
        if self.deletion_grace_period_seconds is not None:
            result['deletionGracePeriodSeconds'] = self.deletion_grace_period_seconds
        if self.deletion_timestamp is not None:
            result['deletionTimestamp'] = self.deletion_timestamp
        if self.finalizers is not None:
            result['finalizers'] = self.finalizers
        if self.generate_name is not None:
            result['generateName'] = self.generate_name
        if self.generation is not None:
            result['generation'] = self.generation
        if self.labels is not None:
            result['labels'] = self.labels
        if self.managed_fields is not None:
            result['managedFields'] = []
            for k in self.managed_fields:
                result['managedFields'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.owner_references is not None:
            result['ownerReferences'] = []
            for k in self.owner_references:
                result['ownerReferences'].append(k.to_map() if k else None)
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('annotations') is not None:
            self.annotations = m.get('annotations')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('creationTimestamp') is not None:
            self.creation_timestamp = m.get('creationTimestamp')
        if m.get('deletionGracePeriodSeconds') is not None:
            self.deletion_grace_period_seconds = m.get('deletionGracePeriodSeconds')
        if m.get('deletionTimestamp') is not None:
            self.deletion_timestamp = m.get('deletionTimestamp')
        if m.get('finalizers') is not None:
            self.finalizers = m.get('finalizers')
        if m.get('generateName') is not None:
            self.generate_name = m.get('generateName')
        if m.get('generation') is not None:
            self.generation = m.get('generation')
        if m.get('labels') is not None:
            self.labels = m.get('labels')
        if m.get('managedFields') is not None:
            self.managed_fields = []
            for k in m.get('managedFields'):
                temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry()
                self.managed_fields.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('ownerReferences') is not None:
            self.owner_references = []
            for k in m.get('ownerReferences'):
                temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1OwnerReference()
                self.owner_references.append(temp_model.from_map(k))
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        values: List[str] = None,
    ):
        # {"en": "key is the label key that the selector applies to.", "zh_CN": "选择器应用的标签键"}
        self.key = key
        # {"en": "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.", "zh_CN": "表示键与一组值的关系。有效的运算符包括 In、NotIn、Exists 和 DoesNotExist"}
        self.operator = operator
        # {"en": "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.", "zh_CN": "values 是一个字符串值数组。如果运算符为 In 或 NotIn，则 values 数组必须为非空。如果运算符是 Exists 或 DoesNotExist，则 values 数组必须为空。该数组在策略性合并补丁（Strategic Merge Patch）期间被替换"}
        self.values = values

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector(TeaModel):
    def __init__(
        self,
        match_expressions: List[UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement] = None,
        match_labels: Dict[str, Any] = None,
    ):
        # {"en": "matchExpressions is a list of label selector requirements. The requirements are ANDed.", "zh_CN": "标签选择器要求的列表，这些要求的结果按逻辑与的关系来计算"}
        self.match_expressions = match_expressions
        # {"en": "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is key, the operator is In, and the values array contains only value. The requirements are ANDed.", "zh_CN": "matchLabels 是 {key,value} 键值对的映射。matchLabels 映射中的单个 {key,value} 键值对相当于 matchExpressions 的一个元素，其键字段为 key，运算符为 In，values 数组仅包含 value。所表达的需求最终要按逻辑与的关系组合"}
        self.match_labels = match_labels

    def validate(self):
        if self.match_expressions:
            for k in self.match_expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_expressions is not None:
            result['matchExpressions'] = []
            for k in self.match_expressions:
                result['matchExpressions'].append(k.to_map() if k else None)
        if self.match_labels is not None:
            result['matchLabels'] = self.match_labels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchExpressions') is not None:
            self.match_expressions = []
            for k in m.get('matchExpressions'):
                temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement()
                self.match_expressions.append(temp_model.from_map(k))
        if m.get('matchLabels') is not None:
            self.match_labels = m.get('matchLabels')
        return self


class UpdateJobIoK8sApiCoreV1NodeSelectorRequirement(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        values: List[str] = None,
    ):
        # {"en": "The label key that the selector applies to.", "zh_CN": "选择算符所适用的标签主键"}
        self.key = key
        # {"en": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.", "zh_CN": "代表主键与值集之间的关系。合法的 operator 值包括 In、NotIn、Exists、DoesNotExist、Gt 和 Lt"}
        self.operator = operator
        # {"en": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.", "zh_CN": "一个由字符串值组成的数组。如果 operator 是 In 或 NotIn，则 values 数组不能为空。 如果 operator 为 Exists 或 DoesNotExist，则 values 数组只能为空。 如果 operator 为 Gt 或 Lt，则 values 数组只能包含一个元素，并且该元素会被解释为整数。 在执行策略性合并补丁操作时，此数组会被整体替换"}
        self.values = values

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class UpdateJobIoK8sApiCoreV1NodeSelectorTerm(TeaModel):
    def __init__(
        self,
        match_expressions: List[UpdateJobIoK8sApiCoreV1NodeSelectorRequirement] = None,
        match_fields: List[UpdateJobIoK8sApiCoreV1NodeSelectorRequirement] = None,
    ):
        # {"en": "A list of node selector requirements by node's labels.", "zh_CN": "按节点标签列出的节点选择条件列表"}
        self.match_expressions = match_expressions
        # {"en": "A list of node selector requirements by node's fields.", "zh_CN": "按节点字段列出的节点选择要求列表"}
        self.match_fields = match_fields

    def validate(self):
        if self.match_expressions:
            for k in self.match_expressions:
                if k:
                    k.validate()
        if self.match_fields:
            for k in self.match_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_expressions is not None:
            result['matchExpressions'] = []
            for k in self.match_expressions:
                result['matchExpressions'].append(k.to_map() if k else None)
        if self.match_fields is not None:
            result['matchFields'] = []
            for k in self.match_fields:
                result['matchFields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchExpressions') is not None:
            self.match_expressions = []
            for k in m.get('matchExpressions'):
                temp_model = UpdateJobIoK8sApiCoreV1NodeSelectorRequirement()
                self.match_expressions.append(temp_model.from_map(k))
        if m.get('matchFields') is not None:
            self.match_fields = []
            for k in m.get('matchFields'):
                temp_model = UpdateJobIoK8sApiCoreV1NodeSelectorRequirement()
                self.match_fields.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1PreferredSchedulingTerm(TeaModel):
    def __init__(
        self,
        preference: UpdateJobIoK8sApiCoreV1NodeSelectorTerm = None,
        weight: int = None,
    ):
        # {"en": "A node selector term, associated with the corresponding weight.", "zh_CN": "与相应权重相关联的节点选择条件"}
        self.preference = preference
        # {"en": "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.", "zh_CN": "与匹配相应的 nodeSelectorTerm 相关的权重，范围为 1-100"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.preference, 'preference')
        if self.preference:
            self.preference.validate()
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preference is not None:
            result['preference'] = self.preference.to_map()
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preference') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1NodeSelectorTerm()
            self.preference = temp_model.from_map(m['preference'])
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class UpdateJobIoK8sApiCoreV1NodeSelector(TeaModel):
    def __init__(
        self,
        node_selector_terms: List[UpdateJobIoK8sApiCoreV1NodeSelectorTerm] = None,
    ):
        # {"en": "Required. A list of node selector terms. The terms are ORed.", "zh_CN": "必需的字段。节点选择条件列表。这些条件按逻辑或操作组合"}
        self.node_selector_terms = node_selector_terms

    def validate(self):
        self.validate_required(self.node_selector_terms, 'node_selector_terms')
        if self.node_selector_terms:
            for k in self.node_selector_terms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_selector_terms is not None:
            result['nodeSelectorTerms'] = []
            for k in self.node_selector_terms:
                result['nodeSelectorTerms'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeSelectorTerms') is not None:
            self.node_selector_terms = []
            for k in m.get('nodeSelectorTerms'):
                temp_model = UpdateJobIoK8sApiCoreV1NodeSelectorTerm()
                self.node_selector_terms.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1NodeAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[UpdateJobIoK8sApiCoreV1PreferredSchedulingTerm] = None,
        required_during_scheduling_ignored_during_execution: UpdateJobIoK8sApiCoreV1NodeSelector = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度程序会更倾向于将 Pod 调度到满足该字段指定的亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。最优选的节点是权重总和最大的节点， 即对于满足所有调度要求（资源请求、requiredDuringScheduling 亲和表达式等）的每个节点， 通过迭代该字段的元素来计算总和如果节点匹配相应的 matchExpressions，则将 “权重” 添加到总和中； 具有最高总和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.", "zh_CN": "如果在调度时不满足该字段指定的亲和性要求，则不会将 Pod 调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的亲和性要求（例如：由于更新）， 系统可能会或可能不会尝试最终将 Pod 从其节点中逐出"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            self.required_during_scheduling_ignored_during_execution.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = self.required_during_scheduling_ignored_during_execution.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = UpdateJobIoK8sApiCoreV1PreferredSchedulingTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1NodeSelector()
            self.required_during_scheduling_ignored_during_execution = temp_model.from_map(m['requiredDuringSchedulingIgnoredDuringExecution'])
        return self


class UpdateJobIoK8sApiCoreV1PodAffinityTerm(TeaModel):
    def __init__(
        self,
        label_selector: UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        namespaces: List[str] = None,
        topology_key: str = None,
    ):
        # {"en": "A label query over a set of resources, in this case pods.", "zh_CN": "对一组资源的标签查询，在这里资源为 Pod"}
        self.label_selector = label_selector
        # {"en": "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means this pod's namespace", "zh_CN": "namespaces 指定此条件所适用的名字空间，是一个静态列表。 此条件会被应用到 namespaces 字段中列出的名字空间和由 namespaceSelector 选中的名字空间上。 namespaces 列表为 null 或空，以及 namespaceSelector 值为 null 均表示“此 Pod 的名字空间”"}
        self.namespaces = namespaces
        # {"en": "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.", "zh_CN": "此 Pod 应与指定名字空间中与标签选择算符匹配的 Pod 集合位于同一位置（亲和性） 或位于不同位置（反亲和性），这里的“在同一位置”意味着运行在一个节点上，其键名为 topologyKey 的标签值与运行所选 Pod 集合中的某 Pod 的任何节点上的标签值匹配。 不允许使用空的 topologyKey"}
        self.topology_key = topology_key

    def validate(self):
        if self.label_selector:
            self.label_selector.validate()
        self.validate_required(self.topology_key, 'topology_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector.to_map()
        if self.namespaces is not None:
            result['namespaces'] = self.namespaces
        if self.topology_key is not None:
            result['topologyKey'] = self.topology_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('labelSelector') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.label_selector = temp_model.from_map(m['labelSelector'])
        if m.get('namespaces') is not None:
            self.namespaces = m.get('namespaces')
        if m.get('topologyKey') is not None:
            self.topology_key = m.get('topologyKey')
        return self


class UpdateJobIoK8sApiCoreV1WeightedPodAffinityTerm(TeaModel):
    def __init__(
        self,
        pod_affinity_term: UpdateJobIoK8sApiCoreV1PodAffinityTerm = None,
        weight: int = None,
    ):
        # {"en": "Required. A pod affinity term, associated with the corresponding weight.", "zh_CN": "必需的字段。一个 Pod 亲和性条件，对应一个与相应的权重值"}
        self.pod_affinity_term = pod_affinity_term
        # {"en": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.", "zh_CN": "weight 是匹配相应 podAffinityTerm 条件的权重，范围为 1-100"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.pod_affinity_term, 'pod_affinity_term')
        if self.pod_affinity_term:
            self.pod_affinity_term.validate()
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pod_affinity_term is not None:
            result['podAffinityTerm'] = self.pod_affinity_term.to_map()
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('podAffinityTerm') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodAffinityTerm()
            self.pod_affinity_term = temp_model.from_map(m['podAffinityTerm'])
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class UpdateJobIoK8sApiCoreV1PodAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[UpdateJobIoK8sApiCoreV1WeightedPodAffinityTerm] = None,
        required_during_scheduling_ignored_during_execution: List[UpdateJobIoK8sApiCoreV1PodAffinityTerm] = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度器会更倾向于将 Pod 调度到满足该字段指定的亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。最优选择是权重总和最大的节点， 即对于满足所有调度要求（资源请求、requiredDuringScheduling 亲和表达式等）的每个节点， 通过迭代该字段的元素来计算总和，如果节点具有与相应 podAffinityTerm 匹配的 Pod，则将“权重”添加到总和中； 具有最高总和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.", "zh_CN": "如果在调度时不满足该字段指定的亲和性要求，则该 Pod 不会被调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的亲和性要求（例如：由于 Pod 标签更新）， 系统可能会也可能不会尝试最终将 Pod 从其节点中逐出。 当此列表中有多个元素时，每个 podAffinityTerm 对应的节点列表是取其交集的，即必须满足所有条件"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            for k in self.required_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.required_during_scheduling_ignored_during_execution:
                result['requiredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = UpdateJobIoK8sApiCoreV1WeightedPodAffinityTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            self.required_during_scheduling_ignored_during_execution = []
            for k in m.get('requiredDuringSchedulingIgnoredDuringExecution'):
                temp_model = UpdateJobIoK8sApiCoreV1PodAffinityTerm()
                self.required_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1PodAntiAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[UpdateJobIoK8sApiCoreV1WeightedPodAffinityTerm] = None,
        required_during_scheduling_ignored_during_execution: List[UpdateJobIoK8sApiCoreV1PodAffinityTerm] = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度器更倾向于将 Pod 调度到满足该字段指定的反亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。 最优选的节点是权重总和最大的节点，即对于满足所有调度要求（资源请求、requiredDuringScheduling 反亲和性表达式等）的每个节点，通过遍历元素来计算总和如果节点具有与相应 podAffinityTerm 匹配的 Pod，则此字段并在总和中添加“权重”；具有最高加和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.", "zh_CN": "如果在调度时不满足该字段指定的反亲和性要求，则该 Pod 不会被调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的反亲和性要求（例如：由于 Pod 标签更新）， 系统可能会或可能不会尝试最终将 Pod 从其节点中逐出。 当有多个元素时，每个 podAffinityTerm 对应的节点列表是取其交集的，即必须满足所有条件"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            for k in self.required_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.required_during_scheduling_ignored_during_execution:
                result['requiredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = UpdateJobIoK8sApiCoreV1WeightedPodAffinityTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            self.required_during_scheduling_ignored_during_execution = []
            for k in m.get('requiredDuringSchedulingIgnoredDuringExecution'):
                temp_model = UpdateJobIoK8sApiCoreV1PodAffinityTerm()
                self.required_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1Affinity(TeaModel):
    def __init__(
        self,
        node_affinity: UpdateJobIoK8sApiCoreV1NodeAffinity = None,
        pod_affinity: UpdateJobIoK8sApiCoreV1PodAffinity = None,
        pod_anti_affinity: UpdateJobIoK8sApiCoreV1PodAntiAffinity = None,
    ):
        # {"en": "Describes node affinity scheduling rules for the pod.", "zh_CN": "描述 Pod 的节点亲和性调度规则"}
        self.node_affinity = node_affinity
        # {"en": "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).", "zh_CN": "描述 Pod 亲和性调度规则（例如，将此 Pod 与其他一些 Pod 放在同一节点、区域等）"}
        self.pod_affinity = pod_affinity
        # {"en": "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).", "zh_CN": "描述 Pod 反亲和性调度规则（例如，避免将此 Pod 与其他一些 Pod 放在相同的节点、区域等）"}
        self.pod_anti_affinity = pod_anti_affinity

    def validate(self):
        if self.node_affinity:
            self.node_affinity.validate()
        if self.pod_affinity:
            self.pod_affinity.validate()
        if self.pod_anti_affinity:
            self.pod_anti_affinity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_affinity is not None:
            result['nodeAffinity'] = self.node_affinity.to_map()
        if self.pod_affinity is not None:
            result['podAffinity'] = self.pod_affinity.to_map()
        if self.pod_anti_affinity is not None:
            result['podAntiAffinity'] = self.pod_anti_affinity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeAffinity') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1NodeAffinity()
            self.node_affinity = temp_model.from_map(m['nodeAffinity'])
        if m.get('podAffinity') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodAffinity()
            self.pod_affinity = temp_model.from_map(m['podAffinity'])
        if m.get('podAntiAffinity') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodAntiAffinity()
            self.pod_anti_affinity = temp_model.from_map(m['podAntiAffinity'])
        return self


class UpdateJobIoK8sApiCoreV1ConfigMapKeySelector(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "The key to select.", "zh_CN": "要选择的主键"}
        self.key = key
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用者的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its key must be defined", "zh_CN": "指定 ConfigMap 或其主键是否必须已经定义"}
        self.optional = optional

    def validate(self):
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1ObjectFieldSelector(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        field_path: str = None,
    ):
        # {"en": "Version of the schema the FieldPath is written in terms of, defaults to v1.", "zh_CN": "fieldPath 写入时所使用的模式版本，默认为 v1"}
        self.api_version = api_version
        # {"en": "Path of the field to select in the specified API version.", "zh_CN": "在指定 API 版本中要选择的字段的路径"}
        self.field_path = field_path

    def validate(self):
        self.validate_required(self.field_path, 'field_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.field_path is not None:
            result['fieldPath'] = self.field_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('fieldPath') is not None:
            self.field_path = m.get('fieldPath')
        return self


class UpdateJobIoK8sApiCoreV1ResourceFieldSelector(TeaModel):
    def __init__(
        self,
        container_name: str = None,
        divisor: str = None,
        resource: str = None,
    ):
        # {"en": "Container name: required for volumes, optional for env vars", "zh_CN": "容器名称：对卷必选，对环境变量可选"}
        self.container_name = container_name
        # {"en": "Specifies the output format of the exposed resources, defaults to 1", "zh_CN": "指定所曝光资源的输出格式，默认值为“1”"}
        self.divisor = divisor
        # {"en": "Required: resource to select", "zh_CN": "必选：选择的资源"}
        self.resource = resource

    def validate(self):
        self.validate_required(self.resource, 'resource')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_name is not None:
            result['containerName'] = self.container_name
        if self.divisor is not None:
            result['divisor'] = self.divisor
        if self.resource is not None:
            result['resource'] = self.resource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containerName') is not None:
            self.container_name = m.get('containerName')
        if m.get('divisor') is not None:
            self.divisor = m.get('divisor')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        return self


class UpdateJobIoK8sApiCoreV1SecretKeySelector(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "The key of the secret to select from.  Must be a valid secret key.", "zh_CN": "要选择的 Secret 的主键。必须是有效的主键"}
        self.key = key
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用 Secret 的名称"}
        self.name = name
        # {"en": "Specify whether the Secret or its key must be defined", "zh_CN": "指定 Secret 或其主键是否必须已经定义"}
        self.optional = optional

    def validate(self):
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1EnvVarSource(TeaModel):
    def __init__(
        self,
        config_map_key_ref: UpdateJobIoK8sApiCoreV1ConfigMapKeySelector = None,
        field_ref: UpdateJobIoK8sApiCoreV1ObjectFieldSelector = None,
        resource_field_ref: UpdateJobIoK8sApiCoreV1ResourceFieldSelector = None,
        secret_key_ref: UpdateJobIoK8sApiCoreV1SecretKeySelector = None,
    ):
        # {"en": "Selects a key of a ConfigMap.", "zh_CN": "选择某个 ConfigMap 的一个主键"}
        self.config_map_key_ref = config_map_key_ref
        # {"en": "Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.", "zh_CN": "选择 Pod 的一个字段：支持 metadata.name、metadata.namespace、metadata.labels['<KEY>']、 metadata.annotations['<KEY>']、spec.nodeName、spec.serviceAccountName、status.hostIP status.podIP、status.podIPs"}
        self.field_ref = field_ref
        # {"en": "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.", "zh_CN": "选择容器的资源：目前仅支持资源限制和请求（limits.cpu、limits.memory、limits.ephemeral-storage、 requests.cpu、requests.memory 和 requests.ephemeral-storage）"}
        self.resource_field_ref = resource_field_ref
        # {"en": "Selects a key of a secret in the pod's namespace", "zh_CN": "在 Pod 的名字空间中选择 Secret 的主键"}
        self.secret_key_ref = secret_key_ref

    def validate(self):
        if self.config_map_key_ref:
            self.config_map_key_ref.validate()
        if self.field_ref:
            self.field_ref.validate()
        if self.resource_field_ref:
            self.resource_field_ref.validate()
        if self.secret_key_ref:
            self.secret_key_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_key_ref is not None:
            result['configMapKeyRef'] = self.config_map_key_ref.to_map()
        if self.field_ref is not None:
            result['fieldRef'] = self.field_ref.to_map()
        if self.resource_field_ref is not None:
            result['resourceFieldRef'] = self.resource_field_ref.to_map()
        if self.secret_key_ref is not None:
            result['secretKeyRef'] = self.secret_key_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMapKeyRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ConfigMapKeySelector()
            self.config_map_key_ref = temp_model.from_map(m['configMapKeyRef'])
        if m.get('fieldRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ObjectFieldSelector()
            self.field_ref = temp_model.from_map(m['fieldRef'])
        if m.get('resourceFieldRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ResourceFieldSelector()
            self.resource_field_ref = temp_model.from_map(m['resourceFieldRef'])
        if m.get('secretKeyRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SecretKeySelector()
            self.secret_key_ref = temp_model.from_map(m['secretKeyRef'])
        return self


class UpdateJobIoK8sApiCoreV1EnvVar(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_from: UpdateJobIoK8sApiCoreV1EnvVarSource = None,
    ):
        # {"en": "Name of the environment variable. Must be a C_IDENTIFIER.", "zh_CN": "环境变量的名称。必须是 C_IDENTIFIER"}
        self.name = name
        # {"en": "Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to ''.", "zh_CN": "变量引用 $(VAR_NAME) 使用容器中先前定义的环境变量和任何服务环境变量进行扩展。 如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 会被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。默认为 “”"}
        self.value = value
        # {"en": "Source for the environment variable's value. Cannot be used if value is not empty.", "zh_CN": "环境变量值的来源。如果 value 值不为空，则不能使用"}
        self.value_from = value_from

    def validate(self):
        self.validate_required(self.name, 'name')
        if self.value_from:
            self.value_from.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        if self.value_from is not None:
            result['valueFrom'] = self.value_from.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('valueFrom') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1EnvVarSource()
            self.value_from = temp_model.from_map(m['valueFrom'])
        return self


class UpdateJobIoK8sApiCoreV1ConfigMapEnvSource(TeaModel):
    def __init__(
        self,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用的 ConfigMap 的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap must be defined", "zh_CN": "指定 ConfigMap 是否必须已经定义"}
        self.optional = optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1SecretEnvSource(TeaModel):
    def __init__(
        self,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用 Secret 的名称"}
        self.name = name
        # {"en": "Specify whether the Secret must be defined", "zh_CN": "指定 Secret 是否必须已经定义"}
        self.optional = optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1EnvFromSource(TeaModel):
    def __init__(
        self,
        config_map_ref: UpdateJobIoK8sApiCoreV1ConfigMapEnvSource = None,
        prefix: str = None,
        secret_ref: UpdateJobIoK8sApiCoreV1SecretEnvSource = None,
    ):
        # {"en": "The ConfigMap to select from", "zh_CN": "要从中选择主键的 ConfigMap"}
        self.config_map_ref = config_map_ref
        # {"en": "An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.", "zh_CN": "附加到 ConfigMap 中每个键名之前的可选标识符。必须是 C_IDENTIFIER"}
        self.prefix = prefix
        # {"en": "The Secret to select from", "zh_CN": "要从中选择主键的 Secret"}
        self.secret_ref = secret_ref

    def validate(self):
        if self.config_map_ref:
            self.config_map_ref.validate()
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_ref is not None:
            result['configMapRef'] = self.config_map_ref.to_map()
        if self.prefix is not None:
            result['prefix'] = self.prefix
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMapRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ConfigMapEnvSource()
            self.config_map_ref = temp_model.from_map(m['configMapRef'])
        if m.get('prefix') is not None:
            self.prefix = m.get('prefix')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SecretEnvSource()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        return self


class UpdateJobIoK8sApiCoreV1ExecAction(TeaModel):
    def __init__(
        self,
        command: List[str] = None,
    ):
        # {"en": "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.", "zh_CN": "要在容器内执行的命令行，命令的工作目录是容器文件系统中的根目录（'/'）。 该命令只是被通过 exec 执行，而不会单独启动一个 Shell 来运行，因此传统的 Shell 指令（'|' 等）将不起作用。要使用某 Shell，你需要显式调用该 Shell。 退出状态 0 被视为活动/健康，非零表示不健康"}
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('command') is not None:
            self.command = m.get('command')
        return self


class UpdateJobIoK8sApiCoreV1HTTPHeader(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "The header field name", "zh_CN": "HTTP 头部字段名称"}
        self.name = name
        # {"en": "The header field value", "zh_CN": "HTTP 头部字段取值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateJobIoK8sApiCoreV1HTTPGetAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        http_headers: List[UpdateJobIoK8sApiCoreV1HTTPHeader] = None,
        path: str = None,
        port: str = None,
        scheme: str = None,
    ):
        # {"en": "Host name to connect to, defaults to the pod IP. You probably want to set Host in httpHeaders instead.", "zh_CN": "要连接的主机名，默认为 Pod IP。你可能想在 httpHeaders 中设置 Host"}
        self.host = host
        # {"en": "Custom headers to set in the request. HTTP allows repeated headers.", "zh_CN": "要在请求中设置的自定义 HTTP 标头。HTTP 允许重复的标头"}
        self.http_headers = http_headers
        # {"en": "Path to access on the HTTP server.", "zh_CN": "HTTP 服务器上的访问路径"}
        self.path = path
        # {"en": "Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.", "zh_CN": "容器上要访问的端口的名称或端口号。端口号必须在 1 到 65535 内。名称必须是 IANA_SVC_NAME"}
        self.port = port
        # {"en": "Scheme to use for connecting to the host. Defaults to HTTP.", "zh_CN": "用于连接到主机的方案。默认为 HTTP"}
        self.scheme = scheme

    def validate(self):
        if self.http_headers:
            for k in self.http_headers:
                if k:
                    k.validate()
        self.validate_required(self.port, 'port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.http_headers is not None:
            result['httpHeaders'] = []
            for k in self.http_headers:
                result['httpHeaders'].append(k.to_map() if k else None)
        if self.path is not None:
            result['path'] = self.path
        if self.port is not None:
            result['port'] = self.port
        if self.scheme is not None:
            result['scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('httpHeaders') is not None:
            self.http_headers = []
            for k in m.get('httpHeaders'):
                temp_model = UpdateJobIoK8sApiCoreV1HTTPHeader()
                self.http_headers.append(temp_model.from_map(k))
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('scheme') is not None:
            self.scheme = m.get('scheme')
        return self


class UpdateJobIoK8sApiCoreV1TCPSocketAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        port: str = None,
    ):
        # {"en": "Optional: Host name to connect to, defaults to the pod IP.", "zh_CN": "可选字段。要连接的主机名，默认为 Pod IP"}
        self.host = host
        # {"en": "Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.", "zh_CN": "容器上要访问的端口的编号或名称。端口号必须在 1 到 65535 的范围内。 名称必须是 IANA_SVC_NAME"}
        self.port = port

    def validate(self):
        self.validate_required(self.port, 'port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class UpdateJobIoK8sApiCoreV1Handler(TeaModel):
    def __init__(
        self,
        exec: UpdateJobIoK8sApiCoreV1ExecAction = None,
        http_get: UpdateJobIoK8sApiCoreV1HTTPGetAction = None,
        tcp_socket: UpdateJobIoK8sApiCoreV1TCPSocketAction = None,
    ):
        # {"en": "One and only one of the following should be specified. Exec specifies the action to take.", "zh_CN": "指定要执行的操作"}
        self.exec = exec
        # {"en": "HTTPGet specifies the http request to perform.", "zh_CN": "指定要执行的 HTTP 请求"}
        self.http_get = http_get
        # {"en": "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported", "zh_CN": "已弃用。不再支持 tcpSocket 作为 LifecycleHandler，但为向后兼容保留之。 当指定 tcp 处理程序时，此字段不会被验证，而生命周期回调将在运行时失败"}
        self.tcp_socket = tcp_socket

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['exec'] = self.exec.to_map()
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ExecAction()
            self.exec = temp_model.from_map(m['exec'])
        if m.get('httpGet') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1HTTPGetAction()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('tcpSocket') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        return self


class UpdateJobIoK8sApiCoreV1Lifecycle(TeaModel):
    def __init__(
        self,
        post_start: UpdateJobIoK8sApiCoreV1Handler = None,
        pre_stop: UpdateJobIoK8sApiCoreV1Handler = None,
    ):
        # {"en": "PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks", "zh_CN": "创建容器后立即调用 postStart。如果处理程序失败，则容器将根据其重新启动策略终止并重新启动。 容器的其他管理阻塞直到钩子完成"}
        self.post_start = post_start
        # {"en": "PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks", "zh_CN": "preStop 在容器因 API 请求或管理事件（如存活态探针/启动探针失败、抢占、资源争用等）而终止之前立即调用。 如果容器崩溃或退出，则不会调用处理程序。Pod 的终止宽限期倒计时在 preStop 钩子执行之前开始。 无论处理程序的结果如何，容器最终都会在 Pod 的终止宽限期内终止（除非被终结器延迟）。 容器的其他管理会阻塞，直到钩子完成或达到终止宽限期"}
        self.pre_stop = pre_stop

    def validate(self):
        if self.post_start:
            self.post_start.validate()
        if self.pre_stop:
            self.pre_stop.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.post_start is not None:
            result['postStart'] = self.post_start.to_map()
        if self.pre_stop is not None:
            result['preStop'] = self.pre_stop.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('postStart') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Handler()
            self.post_start = temp_model.from_map(m['postStart'])
        if m.get('preStop') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Handler()
            self.pre_stop = temp_model.from_map(m['preStop'])
        return self


class UpdateJobIoK8sApiCoreV1Probe(TeaModel):
    def __init__(
        self,
        exec: UpdateJobIoK8sApiCoreV1ExecAction = None,
        failure_threshold: int = None,
        http_get: UpdateJobIoK8sApiCoreV1HTTPGetAction = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        success_threshold: int = None,
        tcp_socket: UpdateJobIoK8sApiCoreV1TCPSocketAction = None,
        timeout_seconds: int = None,
    ):
        # {"en": "One and only one of the following should be specified. Exec specifies the action to take.", "zh_CN": "指定要执行的操作"}
        self.exec = exec
        # {"en": "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.", "zh_CN": "探针成功后的最小连续失败次数，超出此阈值则认为探针失败。默认为 3。最小值为 1"}
        self.failure_threshold = failure_threshold
        # {"en": "HTTPGet specifies the http request to perform.", "zh_CN": "指定要执行的 HTTP 请求"}
        self.http_get = http_get
        # {"en": "Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "容器启动后启动存活态探针之前的秒数"}
        self.initial_delay_seconds = initial_delay_seconds
        # {"en": "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.", "zh_CN": "探针的执行周期（以秒为单位）。默认为 10 秒。最小值为 1"}
        self.period_seconds = period_seconds
        # {"en": "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.", "zh_CN": "探针失败后最小连续成功次数，超过此阈值才会被视为探针成功。默认为 1。 存活性探针和启动探针必须为 1。最小值为 1"}
        self.success_threshold = success_threshold
        # {"en": "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported", "zh_CN": "tcpSocket 指定涉及 TCP 端口的操作"}
        self.tcp_socket = tcp_socket
        # {"en": "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "探针超时的秒数。默认为 1 秒。最小值为 1"}
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['exec'] = self.exec.to_map()
        if self.failure_threshold is not None:
            result['failureThreshold'] = self.failure_threshold
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.initial_delay_seconds is not None:
            result['initialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['periodSeconds'] = self.period_seconds
        if self.success_threshold is not None:
            result['successThreshold'] = self.success_threshold
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        if self.timeout_seconds is not None:
            result['timeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ExecAction()
            self.exec = temp_model.from_map(m['exec'])
        if m.get('failureThreshold') is not None:
            self.failure_threshold = m.get('failureThreshold')
        if m.get('httpGet') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1HTTPGetAction()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('initialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('initialDelaySeconds')
        if m.get('periodSeconds') is not None:
            self.period_seconds = m.get('periodSeconds')
        if m.get('successThreshold') is not None:
            self.success_threshold = m.get('successThreshold')
        if m.get('tcpSocket') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        if m.get('timeoutSeconds') is not None:
            self.timeout_seconds = m.get('timeoutSeconds')
        return self


class UpdateJobIoK8sApiCoreV1ContainerPort(TeaModel):
    def __init__(
        self,
        container_port: int = None,
        host_ip: str = None,
        host_port: int = None,
        name: str = None,
        protocol: str = None,
    ):
        # {"en": "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.", "zh_CN": "要在 Pod 的 IP 地址上公开的端口号。这必须是有效的端口号，0 < x < 65536"}
        self.container_port = container_port
        # {"en": "What host IP to bind the external port to.", "zh_CN": "绑定外部端口的主机 IP"}
        self.host_ip = host_ip
        # {"en": "Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.", "zh_CN": "要在主机上公开的端口号。如果指定，此字段必须是一个有效的端口号，0 < x < 65536。 如果设置了 hostNetwork，此字段值必须与 containerPort 匹配。大多数容器不需要设置此字段"}
        self.host_port = host_port
        # {"en": "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.", "zh_CN": "如果设置此字段，这必须是 IANA_SVC_NAME 并且在 Pod 中唯一。 Pod 中的每个命名端口都必须具有唯一的名称。服务可以引用的端口的名称"}
        self.name = name
        # {"en": "Protocol for port. Must be UDP, TCP, or SCTP. Defaults to TCP.", "zh_CN": "端口协议。必须是 UDP、TCP 或 SCTP。默认为 TCP"}
        self.protocol = protocol

    def validate(self):
        self.validate_required(self.container_port, 'container_port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_port is not None:
            result['containerPort'] = self.container_port
        if self.host_ip is not None:
            result['hostIP'] = self.host_ip
        if self.host_port is not None:
            result['hostPort'] = self.host_port
        if self.name is not None:
            result['name'] = self.name
        if self.protocol is not None:
            result['protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containerPort') is not None:
            self.container_port = m.get('containerPort')
        if m.get('hostIP') is not None:
            self.host_ip = m.get('hostIP')
        if m.get('hostPort') is not None:
            self.host_port = m.get('hostPort')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        return self


class UpdateJobIoK8sApiCoreV1ResourceRequirements(TeaModel):
    def __init__(
        self,
        limits: Dict[str, Any] = None,
        requests: Dict[str, Any] = None,
    ):
        # {"en": "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "limits 描述所允许的最大计算资源量"}
        self.limits = limits
        # {"en": "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "requests 描述所需的最小计算资源量。如果对容器省略了 requests，则默认其资源请求值为 limits （如果已显式指定）的值，否则为实现定义的值。请求不能超过限制"}
        self.requests = requests

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limits is not None:
            result['limits'] = self.limits
        if self.requests is not None:
            result['requests'] = self.requests
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('limits') is not None:
            self.limits = m.get('limits')
        if m.get('requests') is not None:
            self.requests = m.get('requests')
        return self


class UpdateJobIoK8sApiCoreV1Capabilities(TeaModel):
    def __init__(
        self,
        add: List[str] = None,
        drop: List[str] = None,
    ):
        # {"en": "Added capabilities", "zh_CN": "新增权能"}
        self.add = add
        # {"en": "Removed capabilities", "zh_CN": "放弃权能"}
        self.drop = drop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add is not None:
            result['add'] = self.add
        if self.drop is not None:
            result['drop'] = self.drop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add') is not None:
            self.add = m.get('add')
        if m.get('drop') is not None:
            self.drop = m.get('drop')
        return self


class UpdateJobIoK8sApiCoreV1SELinuxOptions(TeaModel):
    def __init__(
        self,
        level: str = None,
        role: str = None,
        type: str = None,
        user: str = None,
    ):
        # {"en": "Level is SELinux level label that applies to the container.", "zh_CN": "应用于容器的 SELinux 级别标签"}
        self.level = level
        # {"en": "Role is a SELinux role label that applies to the container.", "zh_CN": "应用于容器的 SELinux 角色标签"}
        self.role = role
        # {"en": "Type is a SELinux type label that applies to the container.", "zh_CN": "适用于容器的 SELinux 类型标签"}
        self.type = type
        # {"en": "User is a SELinux user label that applies to the container.", "zh_CN": "应用于容器的 SELinux 用户标签"}
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.role is not None:
            result['role'] = self.role
        if self.type is not None:
            result['type'] = self.type
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class UpdateJobIoK8sApiCoreV1SeccompProfile(TeaModel):
    def __init__(
        self,
        localhost_profile: str = None,
        type: str = None,
    ):
        # {"en": "localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is Localhost.", "zh_CN": "localhostProfile 指示应使用在节点上的文件中定义的配置文件。 该配置文件必须在节点上预先配置才能工作。 必须是相对于 kubelet 配置的 seccomp 配置文件位置下的子路径。 仅当 type 为 Localhost 时才必须设置"}
        self.localhost_profile = localhost_profile
        # {"en": "type indicates which kind of seccomp profile will be applied. Valid options are: Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.", "zh_CN": "type 指示将应用哪种 seccomp 配置文件。有效的选项是：Localhost - 应使用在节点上的文件中定义的配置文件。RuntimeDefault - 应使用容器运行时默认配置文件。Unconfined - 不应应用任何配置文件"}
        self.type = type

    def validate(self):
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.localhost_profile is not None:
            result['localhostProfile'] = self.localhost_profile
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('localhostProfile') is not None:
            self.localhost_profile = m.get('localhostProfile')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UpdateJobIoK8sApiCoreV1WindowsSecurityContextOptions(TeaModel):
    def __init__(
        self,
        gmsa_credential_spec: str = None,
        gmsa_credential_spec_name: str = None,
        run_as_user_name: str = None,
    ):
        # {"en": "GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.", "zh_CN": "gmsaCredentialSpec 是 GMSA 准入 Webhook 内嵌由 gmsaCredentialSpecName 字段所指定的 GMSA 凭证规约内容的地方"}
        self.gmsa_credential_spec = gmsa_credential_spec
        # {"en": "GMSACredentialSpecName is the name of the GMSA credential spec to use.", "zh_CN": "gmsaCredentialSpecName 是要使用的 GMSA 凭证规约的名称"}
        self.gmsa_credential_spec_name = gmsa_credential_spec_name
        # {"en": "The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "Windows 中运行容器进程入口点的用户名。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 PodSecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_user_name = run_as_user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmsa_credential_spec is not None:
            result['gmsaCredentialSpec'] = self.gmsa_credential_spec
        if self.gmsa_credential_spec_name is not None:
            result['gmsaCredentialSpecName'] = self.gmsa_credential_spec_name
        if self.run_as_user_name is not None:
            result['runAsUserName'] = self.run_as_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmsaCredentialSpec') is not None:
            self.gmsa_credential_spec = m.get('gmsaCredentialSpec')
        if m.get('gmsaCredentialSpecName') is not None:
            self.gmsa_credential_spec_name = m.get('gmsaCredentialSpecName')
        if m.get('runAsUserName') is not None:
            self.run_as_user_name = m.get('runAsUserName')
        return self


class UpdateJobIoK8sApiCoreV1SecurityContext(TeaModel):
    def __init__(
        self,
        allow_privilege_escalation: bool = None,
        capabilities: UpdateJobIoK8sApiCoreV1Capabilities = None,
        privileged: bool = None,
        proc_mount: str = None,
        read_only_root_filesystem: bool = None,
        run_as_group: int = None,
        run_as_non_root: bool = None,
        run_as_user: int = None,
        se_linux_options: UpdateJobIoK8sApiCoreV1SELinuxOptions = None,
        seccomp_profile: UpdateJobIoK8sApiCoreV1SeccompProfile = None,
        windows_options: UpdateJobIoK8sApiCoreV1WindowsSecurityContextOptions = None,
    ):
        # {"en": "AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN", "zh_CN": "allowPrivilegeEscalation 控制进程是否可以获得比其父进程更多的权限。此布尔值直接控制是否在容器进程上设置 no_new_privs 标志。allowPrivilegeEscalation 在容器处于以下状态时始终为 true：- 以特权身份运行- 具有 CAP_SYS_ADMIN。请注意，当 spec.os.name 为 windows 时，无法设置此字段"}
        self.allow_privilege_escalation = allow_privilege_escalation
        # {"en": "The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.", "zh_CN": "运行容器时添加或放弃的权能（Capabilities）。默认为容器运行时所授予的权能集合。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.capabilities = capabilities
        # {"en": "Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.", "zh_CN": "以特权模式运行容器。特权容器中的进程本质上等同于主机上的 root。默认为 false。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.privileged = privileged
        # {"en": "procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.", "zh_CN": "procMount 表示用于容器的 proc 挂载类型。默认值为 DefaultProcMount， 它针对只读路径和掩码路径使用容器运行时的默认值。此字段需要启用 ProcMountType 特性门控。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.proc_mount = proc_mount
        # {"en": "Whether this container has a read-only root filesystem. Default is false.", "zh_CN": "此容器是否具有只读根文件系统。默认为 false。注意，spec.os.name 为 windows 时不能设置该字段"}
        self.read_only_root_filesystem = read_only_root_filesystem
        # {"en": "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "运行容器进程入口点的 GID。如果未设置，则使用运行时默认值。也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_group = run_as_group
        # {"en": "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "指示容器必须以非 root 用户身份运行。 如果为 true，kubelet 将在运行时验证镜像，以确保它不会以 UID 0（root）身份运行，如果是，则无法启动容器。 如果未设置或为 false，则不会执行此类验证。也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_non_root = run_as_non_root
        # {"en": "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "运行容器进程入口点的 UID。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_user = run_as_user
        # {"en": "The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用到容器上的 SELinux 上下文。如果未设置此字段，容器运行时将为每个容器分配一个随机的 SELinux 上下文。 也可以在 PodSecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置， 则在 SecurityContext 中指定的值优先。注意，spec.os.name 为 windows 时不能设置此字段"}
        self.se_linux_options = se_linux_options
        # {"en": "The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.", "zh_CN": "此容器使用的 seccomp 选项。如果在 Pod 和容器级别都提供了 seccomp 选项，则容器级别的选项会覆盖 Pod 级别的选项设置。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.seccomp_profile = seccomp_profile
        # {"en": "The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用于所有容器上的特定于 Windows 的设置。如果未指定，将使用 PodSecurityContext 中的选项。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 linux 时不能设置此字段"}
        self.windows_options = windows_options

    def validate(self):
        if self.capabilities:
            self.capabilities.validate()
        if self.se_linux_options:
            self.se_linux_options.validate()
        if self.seccomp_profile:
            self.seccomp_profile.validate()
        if self.windows_options:
            self.windows_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_privilege_escalation is not None:
            result['allowPrivilegeEscalation'] = self.allow_privilege_escalation
        if self.capabilities is not None:
            result['capabilities'] = self.capabilities.to_map()
        if self.privileged is not None:
            result['privileged'] = self.privileged
        if self.proc_mount is not None:
            result['procMount'] = self.proc_mount
        if self.read_only_root_filesystem is not None:
            result['readOnlyRootFilesystem'] = self.read_only_root_filesystem
        if self.run_as_group is not None:
            result['runAsGroup'] = self.run_as_group
        if self.run_as_non_root is not None:
            result['runAsNonRoot'] = self.run_as_non_root
        if self.run_as_user is not None:
            result['runAsUser'] = self.run_as_user
        if self.se_linux_options is not None:
            result['seLinuxOptions'] = self.se_linux_options.to_map()
        if self.seccomp_profile is not None:
            result['seccompProfile'] = self.seccomp_profile.to_map()
        if self.windows_options is not None:
            result['windowsOptions'] = self.windows_options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowPrivilegeEscalation') is not None:
            self.allow_privilege_escalation = m.get('allowPrivilegeEscalation')
        if m.get('capabilities') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Capabilities()
            self.capabilities = temp_model.from_map(m['capabilities'])
        if m.get('privileged') is not None:
            self.privileged = m.get('privileged')
        if m.get('procMount') is not None:
            self.proc_mount = m.get('procMount')
        if m.get('readOnlyRootFilesystem') is not None:
            self.read_only_root_filesystem = m.get('readOnlyRootFilesystem')
        if m.get('runAsGroup') is not None:
            self.run_as_group = m.get('runAsGroup')
        if m.get('runAsNonRoot') is not None:
            self.run_as_non_root = m.get('runAsNonRoot')
        if m.get('runAsUser') is not None:
            self.run_as_user = m.get('runAsUser')
        if m.get('seLinuxOptions') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SELinuxOptions()
            self.se_linux_options = temp_model.from_map(m['seLinuxOptions'])
        if m.get('seccompProfile') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SeccompProfile()
            self.seccomp_profile = temp_model.from_map(m['seccompProfile'])
        if m.get('windowsOptions') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1WindowsSecurityContextOptions()
            self.windows_options = temp_model.from_map(m['windowsOptions'])
        return self


class UpdateJobIoK8sApiCoreV1VolumeDevice(TeaModel):
    def __init__(
        self,
        device_path: str = None,
        name: str = None,
    ):
        # {"en": "devicePath is the path inside of the container that the device will be mapped to.", "zh_CN": "设备将被映射到的容器内的路径"}
        self.device_path = device_path
        # {"en": "name must match the name of a persistentVolumeClaim in the pod", "zh_CN": "name 必须与 Pod 中的 persistentVolumeClaim 的名称匹配"}
        self.name = name

    def validate(self):
        self.validate_required(self.device_path, 'device_path')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_path is not None:
            result['devicePath'] = self.device_path
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('devicePath') is not None:
            self.device_path = m.get('devicePath')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class UpdateJobIoK8sApiCoreV1VolumeMount(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
        sub_path_expr: str = None,
    ):
        # {"en": "Path within the container at which the volume should be mounted.  Must not contain ':'.", "zh_CN": "容器内应安装卷的路径。不得包含 ':'"}
        self.mount_path = mount_path
        # {"en": "mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.", "zh_CN": "mountPropagation 确定装载如何从主机传播到容器，及反向传播选项。 如果未设置，则使用 None。此字段在 1.10 中为 Beta 字段"}
        self.mount_propagation = mount_propagation
        # {"en": "This must match the Name of a Volume.", "zh_CN": "此字段必须与卷的名称匹配"}
        self.name = name
        # {"en": "Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.", "zh_CN": "如果为 true，则挂载卷为只读，否则为读写（false 或未指定）。默认值为 false"}
        self.read_only = read_only
        # {"en": "Path within the volume from which the container's volume should be mounted. Defaults to  (volume's root).", "zh_CN": "卷中的路径名，应该从该路径挂在容器的卷。默认为 “” （卷的根）"}
        self.sub_path = sub_path
        # {"en": "Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to  (volume's root). SubPathExpr and SubPath are mutually exclusive.", "zh_CN": "应安装容器卷的卷内的扩展路径。行为类似于 subPath，但环境变量引用 $(VAR_NAME) 使用容器的环境进行扩展。默认为 “”（卷的根）。subPathExpr 和 SubPath 是互斥的"}
        self.sub_path_expr = sub_path_expr

    def validate(self):
        self.validate_required(self.mount_path, 'mount_path')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['mountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['mountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['name'] = self.name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.sub_path is not None:
            result['subPath'] = self.sub_path
        if self.sub_path_expr is not None:
            result['subPathExpr'] = self.sub_path_expr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mountPath') is not None:
            self.mount_path = m.get('mountPath')
        if m.get('mountPropagation') is not None:
            self.mount_propagation = m.get('mountPropagation')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('subPath') is not None:
            self.sub_path = m.get('subPath')
        if m.get('subPathExpr') is not None:
            self.sub_path_expr = m.get('subPathExpr')
        return self


class UpdateJobIoK8sApiCoreV1Container(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
        env: List[UpdateJobIoK8sApiCoreV1EnvVar] = None,
        env_from: List[UpdateJobIoK8sApiCoreV1EnvFromSource] = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle: UpdateJobIoK8sApiCoreV1Lifecycle = None,
        liveness_probe: UpdateJobIoK8sApiCoreV1Probe = None,
        name: str = None,
        ports: List[UpdateJobIoK8sApiCoreV1ContainerPort] = None,
        readiness_probe: UpdateJobIoK8sApiCoreV1Probe = None,
        resources: UpdateJobIoK8sApiCoreV1ResourceRequirements = None,
        security_context: UpdateJobIoK8sApiCoreV1SecurityContext = None,
        startup_probe: UpdateJobIoK8sApiCoreV1Probe = None,
        stdin: bool = None,
        stdin_once: bool = None,
        termination_message_path: str = None,
        termination_message_policy: str = None,
        tty: bool = None,
        volume_devices: List[UpdateJobIoK8sApiCoreV1VolumeDevice] = None,
        volume_mounts: List[UpdateJobIoK8sApiCoreV1VolumeMount] = None,
        working_dir: str = None,
    ):
        # {"en": "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "entrypoint 的参数。如果未提供，则使用容器镜像的 CMD 设置。变量引用 $(VAR_NAME) 使用容器的环境进行扩展。 如果无法解析变量，则输入字符串中的引用将保持不变。$$ 被简化为 $，这允许转义 $(VAR_NAME) 语法： 即 “$$(VAR_NAME)” 将产生字符串字面值 “$(VAR_NAME)”。无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.args = args
        # {"en": "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "入口点数组。不在 Shell 中执行。如果未提供，则使用容器镜像的 ENTRYPOINT。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 “$$(VAR_NAME)” 将产生字符串字面值 “$(VAR_NAME)”。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.command = command
        # {"en": "List of environment variables to set in the container. Cannot be updated.", "zh_CN": "要在容器中设置的环境变量列表。无法更新"}
        self.env = env
        # {"en": "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.", "zh_CN": "用来在容器中填充环境变量的数据源列表。在源中定义的键必须是 C_IDENTIFIER。 容器启动时，所有无效主键都将作为事件报告。 当一个键存在于多个源中时，与最后一个来源关联的值将优先。 由 env 定义的条目中，与此处键名重复者，以 env 中定义为准。无法更新"}
        self.env_from = env_from
        # {"en": "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.", "zh_CN": "容器镜像名称"}
        self.image = image
        # {"en": "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images", "zh_CN": "镜像拉取策略。Always、Never、IfNotPresent 之一。如果指定了 :latest 标签，则默认为 Always， 否则默认为 IfNotPresent。无法更新"}
        self.image_pull_policy = image_pull_policy
        # {"en": "Actions that the management system should take in response to container lifecycle events. Cannot be updated.", "zh_CN": "管理系统应对容器生命周期事件采取的行动。无法更新"}
        self.lifecycle = lifecycle
        # {"en": "Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "定期探针容器活跃度。如果探针失败，容器将重新启动。无法更新"}
        self.liveness_probe = liveness_probe
        # {"en": "Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.", "zh_CN": "指定为 DNS_LABEL 的容器的名称。Pod 中的每个容器都必须有一个唯一的名称 (DNS_LABEL)。无法更新"}
        self.name = name
        # {"en": "List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default 0.0.0.0 address inside a container will be accessible from the network. Cannot be updated.", "zh_CN": "要从容器暴露的端口列表。此处不指定端口不会阻止该端口被暴露。 任何侦听容器内默认 0.0.0.0 地址的端口都可以从网络访问。使用策略合并补丁来修改此数组可能会破坏数据"}
        self.ports = ports
        # {"en": "Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "定期探测容器服务就绪情况。如果探针失败，容器将被从服务端点中删除。无法更新"}
        self.readiness_probe = readiness_probe
        # {"en": "Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "此容器所需的计算资源。无法更新"}
        self.resources = resources
        # {"en": "Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/", "zh_CN": "SecurityContext 定义了容器应该运行的安全选项。如果设置，SecurityContext 的字段将覆盖 PodSecurityContext 的等效字段"}
        self.security_context = security_context
        # {"en": "StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "startupProbe 表示 Pod 已成功初始化。如果设置了此字段，则此探针成功完成之前不会执行其他探针。 如果这个探针失败，Pod 会重新启动，就像存活态探针失败一样。 这可用于在 Pod 生命周期开始时提供不同的探针参数，此时加载数据或预热缓存可能需要比稳态操作期间更长的时间。 这无法更新"}
        self.startup_probe = startup_probe
        # {"en": "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.", "zh_CN": "此容器是否应在容器运行时为 stdin 分配缓冲区。如果未设置，从容器中的 stdin 读取将始终导致 EOF。 默认为 false"}
        self.stdin = stdin
        # {"en": "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false", "zh_CN": "容器运行时是否应在某个 attach 打开 stdin 通道后关闭它。当 stdin 为 true 时，stdin 流将在多个 attach 会话中保持打开状态。 如果 stdinOnce 设置为 true，则 stdin 在容器启动时打开，在第一个客户端连接到 stdin 之前为空， 然后保持打开并接受数据，直到客户端断开连接，此时 stdin 关闭并保持关闭直到容器重新启动。 如果此标志为 false，则从 stdin 读取的容器进程将永远不会收到 EOF。默认为 false"}
        self.stdin_once = stdin_once
        # {"en": "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.", "zh_CN": "可选字段。挂载到容器文件系统的一个路径，容器终止消息写入到该路径下的文件中。 写入的消息旨在成为简短的最终状态，例如断言失败消息。如果大于 4096 字节，将被节点截断。 所有容器的总消息长度将限制为 12 KB。默认为 /dev/termination-log。无法更新"}
        self.termination_message_path = termination_message_path
        # {"en": "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.", "zh_CN": "指示应如何填充终止消息。字段值 File 将使用 terminateMessagePath 的内容来填充成功和失败的容器状态消息。 如果终止消息文件为空并且容器因错误退出，FallbackToLogsOnError 将使用容器日志输出的最后一块。 日志输出限制为 2048 字节或 80 行，以较小者为准。默认为 File。无法更新"}
        self.termination_message_policy = termination_message_policy
        # {"en": "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.", "zh_CN": "这个容器是否应该为自己分配一个 TTY，也需要 stdin 为 true。默认为 false"}
        self.tty = tty
        # {"en": "volumeDevices is the list of block devices to be used by the container.", "zh_CN": "容器要使用的块设备列表"}
        self.volume_devices = volume_devices
        # {"en": "Pod volumes to mount into the container's filesystem. Cannot be updated.", "zh_CN": "要挂载到容器文件系统中的 Pod 卷。无法更新"}
        self.volume_mounts = volume_mounts
        # {"en": "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.", "zh_CN": "容器的工作目录。如果未指定，将使用容器运行时的默认值，默认值可能在容器镜像中配置。无法更新"}
        self.working_dir = working_dir

    def validate(self):
        if self.env:
            for k in self.env:
                if k:
                    k.validate()
        if self.env_from:
            for k in self.env_from:
                if k:
                    k.validate()
        if self.lifecycle:
            self.lifecycle.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        self.validate_required(self.name, 'name')
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.resources:
            self.resources.validate()
        if self.security_context:
            self.security_context.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.volume_devices:
            for k in self.volume_devices:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        if self.env is not None:
            result['env'] = []
            for k in self.env:
                result['env'].append(k.to_map() if k else None)
        if self.env_from is not None:
            result['envFrom'] = []
            for k in self.env_from:
                result['envFrom'].append(k.to_map() if k else None)
        if self.image is not None:
            result['image'] = self.image
        if self.image_pull_policy is not None:
            result['imagePullPolicy'] = self.image_pull_policy
        if self.lifecycle is not None:
            result['lifecycle'] = self.lifecycle.to_map()
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.ports is not None:
            result['ports'] = []
            for k in self.ports:
                result['ports'].append(k.to_map() if k else None)
        if self.readiness_probe is not None:
            result['readinessProbe'] = self.readiness_probe.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdin_once is not None:
            result['stdinOnce'] = self.stdin_once
        if self.termination_message_path is not None:
            result['terminationMessagePath'] = self.termination_message_path
        if self.termination_message_policy is not None:
            result['terminationMessagePolicy'] = self.termination_message_policy
        if self.tty is not None:
            result['tty'] = self.tty
        if self.volume_devices is not None:
            result['volumeDevices'] = []
            for k in self.volume_devices:
                result['volumeDevices'].append(k.to_map() if k else None)
        if self.volume_mounts is not None:
            result['volumeMounts'] = []
            for k in self.volume_mounts:
                result['volumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['workingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('env') is not None:
            self.env = []
            for k in m.get('env'):
                temp_model = UpdateJobIoK8sApiCoreV1EnvVar()
                self.env.append(temp_model.from_map(k))
        if m.get('envFrom') is not None:
            self.env_from = []
            for k in m.get('envFrom'):
                temp_model = UpdateJobIoK8sApiCoreV1EnvFromSource()
                self.env_from.append(temp_model.from_map(k))
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('imagePullPolicy') is not None:
            self.image_pull_policy = m.get('imagePullPolicy')
        if m.get('lifecycle') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Lifecycle()
            self.lifecycle = temp_model.from_map(m['lifecycle'])
        if m.get('livenessProbe') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ports') is not None:
            self.ports = []
            for k in m.get('ports'):
                temp_model = UpdateJobIoK8sApiCoreV1ContainerPort()
                self.ports.append(temp_model.from_map(k))
        if m.get('readinessProbe') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Probe()
            self.readiness_probe = temp_model.from_map(m['readinessProbe'])
        if m.get('resources') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('securityContext') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('startupProbe') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdinOnce') is not None:
            self.stdin_once = m.get('stdinOnce')
        if m.get('terminationMessagePath') is not None:
            self.termination_message_path = m.get('terminationMessagePath')
        if m.get('terminationMessagePolicy') is not None:
            self.termination_message_policy = m.get('terminationMessagePolicy')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        if m.get('volumeDevices') is not None:
            self.volume_devices = []
            for k in m.get('volumeDevices'):
                temp_model = UpdateJobIoK8sApiCoreV1VolumeDevice()
                self.volume_devices.append(temp_model.from_map(k))
        if m.get('volumeMounts') is not None:
            self.volume_mounts = []
            for k in m.get('volumeMounts'):
                temp_model = UpdateJobIoK8sApiCoreV1VolumeMount()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('workingDir') is not None:
            self.working_dir = m.get('workingDir')
        return self


class UpdateJobIoK8sApiCoreV1PodDNSConfigOption(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "Required.", "zh_CN": "必需字段"}
        self.name = name
        # {"en": "Optional", "zh_CN": "选项取值"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateJobIoK8sApiCoreV1PodDNSConfig(TeaModel):
    def __init__(
        self,
        nameservers: List[str] = None,
        options: List[UpdateJobIoK8sApiCoreV1PodDNSConfigOption] = None,
        searches: List[str] = None,
    ):
        # {"en": "A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.", "zh_CN": "DNS 名字服务器的 IP 地址列表。此列表将被追加到基于 dnsPolicy 生成的基本名字服务器列表。 重复的名字服务器将被删除"}
        self.nameservers = nameservers
        # {"en": "A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.", "zh_CN": "DNS 解析器选项列表。此处的选项将与基于 dnsPolicy 所生成的基本选项合并。重复的条目将被删除。 options 中所给出的解析选项将覆盖基本 dnsPolicy 中出现的对应选项"}
        self.options = options
        # {"en": "A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.", "zh_CN": "用于主机名查找的 DNS 搜索域列表。这一列表将被追加到基于 dnsPolicy 生成的基本搜索路径列表。 重复的搜索路径将被删除"}
        self.searches = searches

    def validate(self):
        if self.options:
            for k in self.options:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nameservers is not None:
            result['nameservers'] = self.nameservers
        if self.options is not None:
            result['options'] = []
            for k in self.options:
                result['options'].append(k.to_map() if k else None)
        if self.searches is not None:
            result['searches'] = self.searches
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nameservers') is not None:
            self.nameservers = m.get('nameservers')
        if m.get('options') is not None:
            self.options = []
            for k in m.get('options'):
                temp_model = UpdateJobIoK8sApiCoreV1PodDNSConfigOption()
                self.options.append(temp_model.from_map(k))
        if m.get('searches') is not None:
            self.searches = m.get('searches')
        return self


class UpdateJobIoK8sApiCoreV1EphemeralContainer(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
        env: List[UpdateJobIoK8sApiCoreV1EnvVar] = None,
        env_from: List[UpdateJobIoK8sApiCoreV1EnvFromSource] = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle: UpdateJobIoK8sApiCoreV1Lifecycle = None,
        liveness_probe: UpdateJobIoK8sApiCoreV1Probe = None,
        name: str = None,
        ports: List[UpdateJobIoK8sApiCoreV1ContainerPort] = None,
        readiness_probe: UpdateJobIoK8sApiCoreV1Probe = None,
        resources: UpdateJobIoK8sApiCoreV1ResourceRequirements = None,
        security_context: UpdateJobIoK8sApiCoreV1SecurityContext = None,
        startup_probe: UpdateJobIoK8sApiCoreV1Probe = None,
        stdin: bool = None,
        stdin_once: bool = None,
        target_container_name: str = None,
        termination_message_path: str = None,
        termination_message_policy: str = None,
        tty: bool = None,
        volume_devices: List[UpdateJobIoK8sApiCoreV1VolumeDevice] = None,
        volume_mounts: List[UpdateJobIoK8sApiCoreV1VolumeMount] = None,
        working_dir: str = None,
    ):
        # {"en": "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "entrypoint 的参数。如果未提供，则使用镜像的 CMD。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.args = args
        # {"en": "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "入口点数组。不在 Shell 中执行。如果未提供，则使用镜像的 ENTRYPOINT。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.command = command
        # {"en": "List of environment variables to set in the container. Cannot be updated.", "zh_CN": "要在容器中设置的环境变量列表。无法更新"}
        self.env = env
        # {"en": "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.", "zh_CN": "在容器中填充环境变量的来源列表。在来源中定义的键名必须是 C_IDENTIFIER。 容器启动时，所有无效键都将作为事件报告。当一个键存在于多个来源中时，与最后一个来源关联的值将优先。 如果有重复主键，env 中定义的值将优先。无法更新"}
        self.env_from = env_from
        # {"en": "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images", "zh_CN": "容器镜像名称"}
        self.image = image
        # {"en": "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images", "zh_CN": "镜像拉取策略。取值为 Always、Never、IfNotPresent 之一。 如果指定了 :latest 标签，则默认为 Always，否则默认为 IfNotPresent。 无法更新"}
        self.image_pull_policy = image_pull_policy
        # {"en": "Lifecycle is not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用生命周期"}
        self.lifecycle = lifecycle
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.liveness_probe = liveness_probe
        # {"en": "Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.", "zh_CN": "以 DNS_LABEL 形式设置的临时容器的名称。此名称在所有容器、Init 容器和临时容器中必须是唯一的"}
        self.name = name
        # {"en": "Ports are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用端口"}
        self.ports = ports
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.readiness_probe = readiness_probe
        # {"en": "Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.", "zh_CN": "临时容器不允许使用资源。临时容器使用已分配给 Pod 的空闲资源"}
        self.resources = resources
        # {"en": "Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext", "zh_CN": "可选字段。securityContext 定义了运行临时容器的安全选项。 如果设置了此字段，SecurityContext 的字段将覆盖 PodSecurityContext 的等效字段"}
        self.security_context = security_context
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.startup_probe = startup_probe
        # {"en": "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.", "zh_CN": "是否应在容器运行时内为此容器 stdin 分配缓冲区。 如果未设置，从容器中的 stdin 读数据将始终导致 EOF。默认为 false"}
        self.stdin = stdin
        # {"en": "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false", "zh_CN": "容器运行时是否应在某个 attach 操作打开 stdin 通道后关闭它。 当 stdin 为 true 时，stdin 流将在多个 attach 会话中保持打开状态。 如果 stdinOnce 设置为 true，则 stdin 在容器启动时打开，在第一个客户端连接到 stdin 之前为空， 然后保持打开并接受数据，直到客户端断开连接，此时 stdin 关闭并保持关闭直到容器重新启动。 如果此标志为 false，则从 stdin 读取的容器进程将永远不会收到 EOF。默认为 false"}
        self.stdin_once = stdin_once
        # {"en": "If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.", "zh_CN": "如果设置，则为 Pod 规约中此临时容器所针对的容器的名称。临时容器将在该容器的名字空间（IPC、PID 等）中运行。 如果未设置，则临时容器使用 Pod 规约中配置的名字空间。容器运行时必须实现对此功能的支持。如果运行时不支持名字空间定位，则设置此字段的结果是未定义的"}
        self.target_container_name = target_container_name
        # {"en": "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.", "zh_CN": "可选字段。挂载到容器文件系统的路径，用于写入容器终止消息的文件。 写入的消息旨在成为简短的最终状态，例如断言失败消息。如果超出 4096 字节，将被节点截断。 所有容器的总消息长度将限制为 12 KB。默认为 /dev/termination-log。无法更新"}
        self.termination_message_path = termination_message_path
        # {"en": "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.", "zh_CN": "指示应如何填充终止消息。字段值为 File 表示将使用 terminateMessagePath 的内容来填充成功和失败的容器状态消息。 如果终止消息文件为空并且容器因错误退出，字段值 FallbackToLogsOnError 表示将使用容器日志输出的最后一块。日志输出限制为 2048 字节或 80 行，以较小者为准。 默认为 File。无法更新"}
        self.termination_message_policy = termination_message_policy
        # {"en": "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.", "zh_CN": "这个容器是否应该为自己分配一个 TTY，也需要 stdin 为 true。默认为 false"}
        self.tty = tty
        # {"en": "volumeDevices is the list of block devices to be used by the container.", "zh_CN": "volumeDevices 是容器要使用的块设备列表"}
        self.volume_devices = volume_devices
        # {"en": "Pod volumes to mount into the container's filesystem. Cannot be updated.", "zh_CN": "要挂载到容器文件系统中的 Pod 卷。临时容器不允许子路径挂载。无法更新"}
        self.volume_mounts = volume_mounts
        # {"en": "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.", "zh_CN": "容器的工作目录。如果未指定，将使用容器运行时的默认值，默认值可能在容器镜像中配置。无法更新"}
        self.working_dir = working_dir

    def validate(self):
        if self.env:
            for k in self.env:
                if k:
                    k.validate()
        if self.env_from:
            for k in self.env_from:
                if k:
                    k.validate()
        if self.lifecycle:
            self.lifecycle.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        self.validate_required(self.name, 'name')
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.resources:
            self.resources.validate()
        if self.security_context:
            self.security_context.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.volume_devices:
            for k in self.volume_devices:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        if self.env is not None:
            result['env'] = []
            for k in self.env:
                result['env'].append(k.to_map() if k else None)
        if self.env_from is not None:
            result['envFrom'] = []
            for k in self.env_from:
                result['envFrom'].append(k.to_map() if k else None)
        if self.image is not None:
            result['image'] = self.image
        if self.image_pull_policy is not None:
            result['imagePullPolicy'] = self.image_pull_policy
        if self.lifecycle is not None:
            result['lifecycle'] = self.lifecycle.to_map()
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.ports is not None:
            result['ports'] = []
            for k in self.ports:
                result['ports'].append(k.to_map() if k else None)
        if self.readiness_probe is not None:
            result['readinessProbe'] = self.readiness_probe.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdin_once is not None:
            result['stdinOnce'] = self.stdin_once
        if self.target_container_name is not None:
            result['targetContainerName'] = self.target_container_name
        if self.termination_message_path is not None:
            result['terminationMessagePath'] = self.termination_message_path
        if self.termination_message_policy is not None:
            result['terminationMessagePolicy'] = self.termination_message_policy
        if self.tty is not None:
            result['tty'] = self.tty
        if self.volume_devices is not None:
            result['volumeDevices'] = []
            for k in self.volume_devices:
                result['volumeDevices'].append(k.to_map() if k else None)
        if self.volume_mounts is not None:
            result['volumeMounts'] = []
            for k in self.volume_mounts:
                result['volumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['workingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('env') is not None:
            self.env = []
            for k in m.get('env'):
                temp_model = UpdateJobIoK8sApiCoreV1EnvVar()
                self.env.append(temp_model.from_map(k))
        if m.get('envFrom') is not None:
            self.env_from = []
            for k in m.get('envFrom'):
                temp_model = UpdateJobIoK8sApiCoreV1EnvFromSource()
                self.env_from.append(temp_model.from_map(k))
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('imagePullPolicy') is not None:
            self.image_pull_policy = m.get('imagePullPolicy')
        if m.get('lifecycle') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Lifecycle()
            self.lifecycle = temp_model.from_map(m['lifecycle'])
        if m.get('livenessProbe') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ports') is not None:
            self.ports = []
            for k in m.get('ports'):
                temp_model = UpdateJobIoK8sApiCoreV1ContainerPort()
                self.ports.append(temp_model.from_map(k))
        if m.get('readinessProbe') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Probe()
            self.readiness_probe = temp_model.from_map(m['readinessProbe'])
        if m.get('resources') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('securityContext') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('startupProbe') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdinOnce') is not None:
            self.stdin_once = m.get('stdinOnce')
        if m.get('targetContainerName') is not None:
            self.target_container_name = m.get('targetContainerName')
        if m.get('terminationMessagePath') is not None:
            self.termination_message_path = m.get('terminationMessagePath')
        if m.get('terminationMessagePolicy') is not None:
            self.termination_message_policy = m.get('terminationMessagePolicy')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        if m.get('volumeDevices') is not None:
            self.volume_devices = []
            for k in m.get('volumeDevices'):
                temp_model = UpdateJobIoK8sApiCoreV1VolumeDevice()
                self.volume_devices.append(temp_model.from_map(k))
        if m.get('volumeMounts') is not None:
            self.volume_mounts = []
            for k in m.get('volumeMounts'):
                temp_model = UpdateJobIoK8sApiCoreV1VolumeMount()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('workingDir') is not None:
            self.working_dir = m.get('workingDir')
        return self


class UpdateJobIoK8sApiCoreV1HostAlias(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        # {"en": "Hostnames for the above IP address.", "zh_CN": "指定 IP 地址对应的主机名"}
        self.hostnames = hostnames
        # {"en": "IP address of the host file entry.", "zh_CN": "主机文件条目的 IP 地址"}
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['hostnames'] = self.hostnames
        if self.ip is not None:
            result['ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hostnames') is not None:
            self.hostnames = m.get('hostnames')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        return self


class UpdateJobIoK8sApiCoreV1LocalObjectReference(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用者的名称"}
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class UpdateJobIoK8sApiCoreV1PodReadinessGate(TeaModel):
    def __init__(
        self,
        condition_type: str = None,
    ):
        # {"en": "ConditionType refers to a condition in the pod's condition list with matching type.", "zh_CN": "指 Pod 的状况列表中类型匹配的状况"}
        self.condition_type = condition_type

    def validate(self):
        self.validate_required(self.condition_type, 'condition_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_type is not None:
            result['conditionType'] = self.condition_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conditionType') is not None:
            self.condition_type = m.get('conditionType')
        return self


class UpdateJobIoK8sApiCoreV1Sysctl(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "Name of a property to set", "zh_CN": "要设置的属性的名称"}
        self.name = name
        # {"en": "Value of a property to set", "zh_CN": "要设置的属性值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateJobIoK8sApiCoreV1PodSecurityContext(TeaModel):
    def __init__(
        self,
        fs_group: int = None,
        fs_group_change_policy: str = None,
        run_as_group: int = None,
        run_as_non_root: bool = None,
        run_as_user: int = None,
        se_linux_options: UpdateJobIoK8sApiCoreV1SELinuxOptions = None,
        seccomp_profile: UpdateJobIoK8sApiCoreV1SeccompProfile = None,
        supplemental_groups: List[int] = None,
        sysctls: List[UpdateJobIoK8sApiCoreV1Sysctl] = None,
        windows_options: UpdateJobIoK8sApiCoreV1WindowsSecurityContextOptions = None,
    ):
        # {"en": "A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----.If unset, the Kubelet will not modify the ownership and permissions of any volume.", "zh_CN": "应用到 Pod 中所有容器的特殊补充组。某些卷类型允许 kubelet 将该卷的所有权更改为由 Pod 拥有：1. 文件系统的属主 GID 将是 fsGroup 字段值2. setgid 位已设置（在卷中创建的新文件将归 fsGroup 所有）3. 权限位将与 rw-rw---- 进行按位或操作。如果未设置此字段，kubelet 不会修改任何卷的所有权和权限。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.fs_group = fs_group
        # {"en": "fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are OnRootMismatch and Always. If not specified, Always is used.", "zh_CN": "fsGroupChangePolicy 定义了在卷被在 Pod 中暴露之前更改其属主和权限的行为。 此字段仅适用于支持基于 fsGroup 的属主权（和权限）的卷类型。它不会影响临时卷类型， 例如：secret、configmap 和 emptydir。 有效值为 OnRootMismatch 和 Always。如果未设置，则使用 Always。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.fs_group_change_policy = fs_group_change_policy
        # {"en": "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "运行容器进程入口点（Entrypoint）的 GID。如果未设置，则使用运行时的默认值。 也可以在 SecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置， 则在对应容器中设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_group = run_as_group
        # {"en": "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "指示容器必须以非 root 用户身份运行。如果为 true，kubelet 将在运行时验证镜像， 以确保它不会以 UID 0（root）身份运行。如果镜像中确实使用 root 账号启动，则容器无法被启动。 如果此字段未设置或为 false，则不会执行此类验证。也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_non_root = run_as_non_root
        # {"en": "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "运行容器进程入口点（Entrypoint）的 UID。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在对应容器中所设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.run_as_user = run_as_user
        # {"en": "The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "应用于所有容器的 SELinux 上下文。如果未设置，容器运行时将为每个容器分配一个随机 SELinux 上下文。 也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在对应容器中设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.se_linux_options = se_linux_options
        # {"en": "The seccomp options to use by the containers in this pod.", "zh_CN": "此 Pod 中的容器使用的 seccomp 选项。注意，spec.os.name 为 windows 时不能设置此字段"}
        self.seccomp_profile = seccomp_profile
        # {"en": "A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.", "zh_CN": "此字段包含将应用到每个容器中运行的第一个进程的组列表。 容器进程的组成员身份取决于容器的主 GID、fsGroup（如果指定了的话） 和在容器镜像中为容器进程的 uid 定义的组成员身份，以及这里所给的列表。如果未指定，则不会向任何容器添加其他组。 注意，在容器镜像中为容器进程的 uid 定义的组成员身份仍然有效， 即使它们未包含在此列表中也是如此。 注意，当 spec.os.name 为 windows 时，不能设置此字段"}
        self.supplemental_groups = supplemental_groups
        # {"en": "Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.", "zh_CN": "sysctls 包含用于 Pod 的名字空间 sysctl 列表。具有不受（容器运行时）支持的 sysctl 的 Pod 可能无法启动。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.sysctls = sysctls
        # {"en": "The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用到所有容器上的、特定于 Windows 的设置。 如果未设置此字段，将使用容器的 SecurityContext 中的选项。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 linux 时不能设置该字段"}
        self.windows_options = windows_options

    def validate(self):
        if self.se_linux_options:
            self.se_linux_options.validate()
        if self.seccomp_profile:
            self.seccomp_profile.validate()
        if self.sysctls:
            for k in self.sysctls:
                if k:
                    k.validate()
        if self.windows_options:
            self.windows_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_group is not None:
            result['fsGroup'] = self.fs_group
        if self.fs_group_change_policy is not None:
            result['fsGroupChangePolicy'] = self.fs_group_change_policy
        if self.run_as_group is not None:
            result['runAsGroup'] = self.run_as_group
        if self.run_as_non_root is not None:
            result['runAsNonRoot'] = self.run_as_non_root
        if self.run_as_user is not None:
            result['runAsUser'] = self.run_as_user
        if self.se_linux_options is not None:
            result['seLinuxOptions'] = self.se_linux_options.to_map()
        if self.seccomp_profile is not None:
            result['seccompProfile'] = self.seccomp_profile.to_map()
        if self.supplemental_groups is not None:
            result['supplementalGroups'] = self.supplemental_groups
        if self.sysctls is not None:
            result['sysctls'] = []
            for k in self.sysctls:
                result['sysctls'].append(k.to_map() if k else None)
        if self.windows_options is not None:
            result['windowsOptions'] = self.windows_options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsGroup') is not None:
            self.fs_group = m.get('fsGroup')
        if m.get('fsGroupChangePolicy') is not None:
            self.fs_group_change_policy = m.get('fsGroupChangePolicy')
        if m.get('runAsGroup') is not None:
            self.run_as_group = m.get('runAsGroup')
        if m.get('runAsNonRoot') is not None:
            self.run_as_non_root = m.get('runAsNonRoot')
        if m.get('runAsUser') is not None:
            self.run_as_user = m.get('runAsUser')
        if m.get('seLinuxOptions') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SELinuxOptions()
            self.se_linux_options = temp_model.from_map(m['seLinuxOptions'])
        if m.get('seccompProfile') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SeccompProfile()
            self.seccomp_profile = temp_model.from_map(m['seccompProfile'])
        if m.get('supplementalGroups') is not None:
            self.supplemental_groups = m.get('supplementalGroups')
        if m.get('sysctls') is not None:
            self.sysctls = []
            for k in m.get('sysctls'):
                temp_model = UpdateJobIoK8sApiCoreV1Sysctl()
                self.sysctls.append(temp_model.from_map(k))
        if m.get('windowsOptions') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1WindowsSecurityContextOptions()
            self.windows_options = temp_model.from_map(m['windowsOptions'])
        return self


class UpdateJobIoK8sApiCoreV1Toleration(TeaModel):
    def __init__(
        self,
        effect: str = None,
        key: str = None,
        operator: str = None,
        toleration_seconds: int = None,
        value: str = None,
    ):
        # {"en": "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.", "zh_CN": "指示要匹配的污点效果。空值意味著匹配所有污点效果。如果要设置此字段，允许的值为 NoSchedule、PreferNoSchedule 和 NoExecute 之一"}
        self.effect = effect
        # {"en": "Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.", "zh_CN": "容忍度所适用的污点的键名。此字段为空意味着匹配所有的污点键。 如果 key 为空，则 operator 必须为 Exists；这种组合意味着匹配所有值和所有键"}
        self.key = key
        # {"en": "Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.", "zh_CN": "表示 key 与 value 之间的关系。有效的 operator 取值是 Exists 和 Equal。默认为 Equal。 Exists 相当于 value 为某种通配符，因此 Pod 可以容忍特定类别的所有污点"}
        self.operator = operator
        # {"en": "TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.", "zh_CN": "表示容忍度（effect 必须是 NoExecute，否则此字段被忽略）容忍污点的时间长度。 默认情况下，此字段未被设置，这意味着会一直能够容忍对应污点（不会发生驱逐操作）。 零值和负值会被系统当做 0 值处理（立即触发驱逐）"}
        self.toleration_seconds = toleration_seconds
        # {"en": "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.", "zh_CN": "容忍度所匹配的污点值。如果 operator 为 Exists，则此 value 值应该为空， 否则 value 值应该是一个正常的字符串"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['effect'] = self.effect
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.toleration_seconds is not None:
            result['tolerationSeconds'] = self.toleration_seconds
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effect') is not None:
            self.effect = m.get('effect')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('tolerationSeconds') is not None:
            self.toleration_seconds = m.get('tolerationSeconds')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class UpdateJobIoK8sApiCoreV1TopologySpreadConstraint(TeaModel):
    def __init__(
        self,
        label_selector: UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        max_skew: int = None,
        topology_key: str = None,
        when_unsatisfiable: str = None,
    ):
        # {"en": "LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.", "zh_CN": "用于识别匹配的 Pod。对匹配此标签选择算符的 Pod 进行计数， 以确定其相应拓扑域中的 Pod 数量"}
        self.label_selector = label_selector
        # {"en": "MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.", "zh_CN": "maxSkew 描述 Pod 可能分布不均衡的程度。当 whenUnsatisfiable=DoNotSchedule 时， 此字段值是目标拓扑中匹配的 Pod 数量与全局最小值之间的最大允许差值。 全局最小值是候选域中匹配 Pod 的最小数量，如果候选域的数量小于 minDomains，则为零。 例如，在一个包含三个可用区的集群中，maxSkew 设置为 1，具有相同 labelSelector 的 Pod 分布为 2/2/1： 在这种情况下，全局最小值为 1。当 whenUnsatisfiable=ScheduleAnyway 时，此字段被用来给满足此约束的拓扑域更高的优先级。此字段是一个必填字段。默认值为 1，不允许为 0"}
        self.max_skew = max_skew
        # {"en": "TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a bucket, and try to put balanced number of pods into each bucket. It's a required field.", "zh_CN": "topologyKey 是节点标签的键名。如果节点的标签中包含此键名且键值亦相同，则被认为在相同的拓扑域中。 我们将每个 <键, 值> 视为一个 “桶（Bucket）”，并尝试将数量均衡的 Pod 放入每个桶中。 我们定义域（Domain）为拓扑域的特定实例。 此外，我们定义一个候选域（Eligible Domain）为其节点与 nodeAffinityPolicy 和 nodeTaintsPolicy 的要求匹配的域。 例如，如果 topologyKey 是 kubernetes.io/hostname，则每个 Node 都是该拓扑的域。 而如果 topologyKey 是 topology.kubernetes.io/zone，则每个区域都是该拓扑的一个域。 这是一个必填字段"}
        self.topology_key = topology_key
        # {"en": "WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,but giving higher precedence to topologies that would help reduce the skew.A constraint is considered Unsatisfiable for an incoming pod if and only if every possible node assigment for that pod would violate MaxSkew on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.", "zh_CN": "whenUnsatisfiable 表示如果 Pod 不满足分布约束，如何处理它。- DoNotSchedule（默认）：告诉调度器不要调度它。- ScheduleAnyway：告诉调度器将 Pod 调度到任何位置，但给予能够降低偏差的拓扑更高的优先级。当且仅当该 Pod 的每个可能的节点分配都会违反某些拓扑对应的 “maxSkew” 时， 才认为传入 Pod 的约束是 “不可满足的”"}
        self.when_unsatisfiable = when_unsatisfiable

    def validate(self):
        if self.label_selector:
            self.label_selector.validate()
        self.validate_required(self.max_skew, 'max_skew')
        self.validate_required(self.topology_key, 'topology_key')
        self.validate_required(self.when_unsatisfiable, 'when_unsatisfiable')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector.to_map()
        if self.max_skew is not None:
            result['maxSkew'] = self.max_skew
        if self.topology_key is not None:
            result['topologyKey'] = self.topology_key
        if self.when_unsatisfiable is not None:
            result['whenUnsatisfiable'] = self.when_unsatisfiable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('labelSelector') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.label_selector = temp_model.from_map(m['labelSelector'])
        if m.get('maxSkew') is not None:
            self.max_skew = m.get('maxSkew')
        if m.get('topologyKey') is not None:
            self.topology_key = m.get('topologyKey')
        if m.get('whenUnsatisfiable') is not None:
            self.when_unsatisfiable = m.get('whenUnsatisfiable')
        return self


class UpdateJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        partition: int = None,
        read_only: bool = None,
        volume_id: str = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "fsType 是你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型"}
        self.fs_type = fs_type
        # {"en": "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as 1. Similarly, the volume partition for /dev/sda is 0 (or you can leave the property empty).", "zh_CN": "partition 是你要挂载的卷中的分区。如果省略，则默认为按卷名称进行挂载"}
        self.partition = partition
        # {"en": "Specify true to force and set the ReadOnly property in VolumeMounts to true. If omitted, the default is false. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "readOnly 值为 true 将使得卷挂载被强制设置为 readOnly"}
        self.read_only = read_only
        # {"en": "Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "volumeID 是 AWS（Amazon EBS 卷）中持久磁盘资源的唯一 ID"}
        self.volume_id = volume_id

    def validate(self):
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class UpdateJobIoK8sApiCoreV1AzureDiskVolumeSource(TeaModel):
    def __init__(
        self,
        caching_mode: str = None,
        disk_name: str = None,
        disk_uri: str = None,
        fs_type: str = None,
        kind: str = None,
        read_only: bool = None,
    ):
        # {"en": "Host Caching mode: None, Read Only, Read Write.", "zh_CN": "主机缓存（Host Caching）模式：None、Read Only、Read Write"}
        self.caching_mode = caching_mode
        # {"en": "The Name of the data disk in the blob storage", "zh_CN": "Blob 存储中数据盘的名称"}
        self.disk_name = disk_name
        # {"en": "The URI the data disk in the blob storage", "zh_CN": "Blob 存储中数据盘的 URI"}
        self.disk_uri = disk_uri
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一"}
        self.fs_type = fs_type
        # {"en": "Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared", "zh_CN": "kind 预期值包括：Shared：每个存储帐户多个 Blob 磁盘；Dedicated：每个存储帐户单个 Blob 磁盘；Managed：azure 托管的数据盘（仅托管的可用性集合中）。默认为 Shared"}
        self.kind = kind
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.disk_uri, 'disk_uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caching_mode is not None:
            result['cachingMode'] = self.caching_mode
        if self.disk_name is not None:
            result['diskName'] = self.disk_name
        if self.disk_uri is not None:
            result['diskURI'] = self.disk_uri
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.kind is not None:
            result['kind'] = self.kind
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cachingMode') is not None:
            self.caching_mode = m.get('cachingMode')
        if m.get('diskName') is not None:
            self.disk_name = m.get('diskName')
        if m.get('diskURI') is not None:
            self.disk_uri = m.get('diskURI')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class UpdateJobIoK8sApiCoreV1AzureFileVolumeSource(TeaModel):
    def __init__(
        self,
        read_only: bool = None,
        secret_name: str = None,
        share_name: str = None,
    ):
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "the name of secret that contains Azure Storage Account Name and Key", "zh_CN": "包含 Azure 存储账号名称和主键的 Secret 的名称"}
        self.secret_name = secret_name
        # {"en": "Share Name", "zh_CN": "Azure 共享名称"}
        self.share_name = share_name

    def validate(self):
        self.validate_required(self.secret_name, 'secret_name')
        self.validate_required(self.share_name, 'share_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_name is not None:
            result['secretName'] = self.secret_name
        if self.share_name is not None:
            result['shareName'] = self.share_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretName') is not None:
            self.secret_name = m.get('secretName')
        if m.get('shareName') is not None:
            self.share_name = m.get('shareName')
        return self


class UpdateJobIoK8sApiCoreV1CephFSVolumeSource(TeaModel):
    def __init__(
        self,
        monitors: List[str] = None,
        path: str = None,
        read_only: bool = None,
        secret_file: str = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        user: str = None,
    ):
        # {"en": "Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "必需的。monitors 是 Ceph 监测的集合"}
        self.monitors = monitors
        # {"en": "Optional: Used as the mounted root, rather than the full Ceph tree, default is /", "zh_CN": "可选的。用作挂载的根，而不是挂载完整的 Ceph 树，默认为 “/”"}
        self.path = path
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。默认为 false（读/写）。 此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "secretFile 是可选的。secretFile 是 User 对应的密钥环的路径，默认为 /etc/ceph/user.secret"}
        self.secret_file = secret_file
        # {"en": "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。secretRef 是针对用户的身份认证 Secret 的引用，默认为空"}
        self.secret_ref = secret_ref
        # {"en": "Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。user 是 rados 用户名，默认为 admin"}
        self.user = user

    def validate(self):
        self.validate_required(self.monitors, 'monitors')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitors is not None:
            result['monitors'] = self.monitors
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_file is not None:
            result['secretFile'] = self.secret_file
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('monitors') is not None:
            self.monitors = m.get('monitors')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretFile') is not None:
            self.secret_file = m.get('secretFile')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class UpdateJobIoK8sApiCoreV1CinderVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        volume_id: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一"}
        self.fs_type = fs_type
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": " 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: points to a secret object containing parameters used to connect to OpenStack.", "zh_CN": "可选的。指向 Secret 对象，内含的参数用于连接到 OpenStack"}
        self.secret_ref = secret_ref
        # {"en": "volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "用于标识 Cinder 中的卷"}
        self.volume_id = volume_id

    def validate(self):
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class UpdateJobIoK8sApiCoreV1KeyToPath(TeaModel):
    def __init__(
        self,
        key: str = None,
        mode: int = None,
        path: str = None,
    ):
        # {"en": "The key to project.", "zh_CN": "要投射的键"}
        self.key = key
        # {"en": "Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "mode 是可选的：模式位用于为文件设置权限。必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 如果未指定，则将使用卷 defaultMode。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.mode = mode
        # {"en": "The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.", "zh_CN": "将键映射到的文件的相对路径。不能是绝对路径。不能包含路径元素 “..”。不能以字符串 “..” 开头"}
        self.path = path

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.mode is not None:
            result['mode'] = self.mode
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class UpdateJobIoK8sApiCoreV1ConfigMapVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[UpdateJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. UpdateJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 ConfigMap 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 ConfigMap 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its keys must be defined", "zh_CN": "指定是否所引用的 ConfigMap 或其键必须已经被定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1CSIVolumeSource(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        node_publish_secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        read_only: bool = None,
        volume_attributes: Dict[str, Any] = None,
    ):
        # {"en": "Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.", "zh_CN": "处理此卷的 CSI 驱动的名称。咨询你的管理员以获取在集群中注册的正确名称"}
        self.driver = driver
        # {"en": "Filesystem type to mount. Ex. ext4, xfs, ntfs. If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.", "zh_CN": "要挂载的 fsType。例如 “ext4”、“xfs”、“ntfs”。 如果未提供，则将空值传递给关联的 CSI 驱动，以便决定要应用的默认文件系统"}
        self.fs_type = fs_type
        # {"en": "NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.", "zh_CN": "对包含敏感信息的 Secret 对象的引用， 该 Secret 对象将被传递到 CSI 驱动以完成 CSI NodePublishVolume 和 NodeUnpublishVolume 调用。 此字段是可选的，如果不需要 Secret，则此字段可以为空。 如果 Secret 对象包含多个 Secret，则所有 Secret 引用将被传递"}
        self.node_publish_secret_ref = node_publish_secret_ref
        # {"en": "Specifies a read-only configuration for the volume. Defaults to false (read/write).", "zh_CN": "指定供卷使用的只读配置。默认为 false（读/写）"}
        self.read_only = read_only
        # {"en": "VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.", "zh_CN": "存储传递给 CSI 驱动且特定于驱动的属性。查阅你的驱动文档，了解支持的值"}
        self.volume_attributes = volume_attributes

    def validate(self):
        self.validate_required(self.driver, 'driver')
        if self.node_publish_secret_ref:
            self.node_publish_secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['driver'] = self.driver
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.node_publish_secret_ref is not None:
            result['nodePublishSecretRef'] = self.node_publish_secret_ref.to_map()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_attributes is not None:
            result['volumeAttributes'] = self.volume_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('driver') is not None:
            self.driver = m.get('driver')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('nodePublishSecretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.node_publish_secret_ref = temp_model.from_map(m['nodePublishSecretRef'])
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeAttributes') is not None:
            self.volume_attributes = m.get('volumeAttributes')
        return self


class UpdateJobIoK8sApiCoreV1DownwardAPIVolumeFile(TeaModel):
    def __init__(
        self,
        field_ref: UpdateJobIoK8sApiCoreV1ObjectFieldSelector = None,
        mode: int = None,
        path: str = None,
        resource_field_ref: UpdateJobIoK8sApiCoreV1ResourceFieldSelector = None,
    ):
        # {"en": "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.", "zh_CN": "必需。选择 Pod 的字段：仅支持注解、标签、名称和名字空间"}
        self.field_ref = field_ref
        # {"en": "Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "可选：模式位用于设置文件的权限，必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 如果未指定，则将使用卷 defaultMode。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.mode = mode
        # {"en": "Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'", "zh_CN": "必需。path 是要创建的文件的相对路径名称。不得使用绝对路径，也不得包含 “..” 路径。 必须用 UTF-8 进行编码。相对路径的第一项不得用 “..” 开头"}
        self.path = path
        # {"en": "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.", "zh_CN": "选择容器的资源：目前仅支持资源限制与请求（limits.cpu、limits.memory、requests.cpu 和 requests.memory）"}
        self.resource_field_ref = resource_field_ref

    def validate(self):
        if self.field_ref:
            self.field_ref.validate()
        self.validate_required(self.path, 'path')
        if self.resource_field_ref:
            self.resource_field_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref is not None:
            result['fieldRef'] = self.field_ref.to_map()
        if self.mode is not None:
            result['mode'] = self.mode
        if self.path is not None:
            result['path'] = self.path
        if self.resource_field_ref is not None:
            result['resourceFieldRef'] = self.resource_field_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ObjectFieldSelector()
            self.field_ref = temp_model.from_map(m['fieldRef'])
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('resourceFieldRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ResourceFieldSelector()
            self.resource_field_ref = temp_model.from_map(m['resourceFieldRef'])
        return self


class UpdateJobIoK8sApiCoreV1DownwardAPIVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[UpdateJobIoK8sApiCoreV1DownwardAPIVolumeFile] = None,
    ):
        # {"en": "Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "可选：默认情况下，模式位用于已创建的文件。 必须是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "Items is a list of downward API volume file", "zh_CN": "Downward API 卷文件的列表"}
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiCoreV1DownwardAPIVolumeFile()
                self.items.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1EmptyDirVolumeSource(TeaModel):
    def __init__(
        self,
        medium: str = None,
        size_limit: str = None,
    ):
        # {"en": "What type of storage medium should back this directory. The default is  which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir", "zh_CN": "表示此目录应使用哪种类别的存储介质。默认为 “”，这意味着使用节点的默认介质。 必须是空字符串（默认值）或 Memory"}
        self.medium = medium
        # {"en": "Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir", "zh_CN": "这个 EmptyDir 卷所需的本地存储总量。这个大小限制也适用于内存介质。 EmptyDir 的内存介质最大使用量将是此处指定的 sizeLimit 与 Pod 中所有容器内存限制总和这两个值之间的最小值。 默认为 nil，这意味着限制未被定义"}
        self.size_limit = size_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.medium is not None:
            result['medium'] = self.medium
        if self.size_limit is not None:
            result['sizeLimit'] = self.size_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('medium') is not None:
            self.medium = m.get('medium')
        if m.get('sizeLimit') is not None:
            self.size_limit = m.get('sizeLimit')
        return self


class UpdateJobIoK8sApiCoreV1TypedLocalObjectReference(TeaModel):
    def __init__(
        self,
        api_group: str = None,
        kind: str = None,
        name: str = None,
    ):
        # {"en": "APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.", "zh_CN": "APIGroup 是被引用资源的组。如果不指定 APIGroup，则指定的 Kind 必须在核心 API 组中。对于任何其它第三方类型，都需要 APIGroup"}
        self.api_group = api_group
        # {"en": "Kind is the type of resource being referenced", "zh_CN": "Kind 是被引用的资源的类型"}
        self.kind = kind
        # {"en": "Name is the name of resource being referenced", "zh_CN": "Name 是被引用的资源的名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class UpdateJobIoK8sApiCoreV1PersistentVolumeClaimSpec(TeaModel):
    def __init__(
        self,
        access_modes: List[str] = None,
        data_source: UpdateJobIoK8sApiCoreV1TypedLocalObjectReference = None,
        resources: UpdateJobIoK8sApiCoreV1ResourceRequirements = None,
        selector: UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        storage_class_name: str = None,
        volume_mode: str = None,
        volume_name: str = None,
    ):
        # {"en": "AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1", "zh_CN": "accessModes 包含卷应具备的预期访问模式"}
        self.access_modes = access_modes
        # {"en": "This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.", "zh_CN": "dataSource 字段可用于二选一：- 现有的 VolumeSnapshot 对象（snapshot.storage.k8s.io/VolumeSnapshot）- 现有的 PVC (PersistentVolumeClaim)。如果制备器或外部控制器可以支持指定的数据源，则它将根据指定数据源的内容创建新的卷。 当 AnyVolumeDataSource 特性门控被启用时，dataSource 内容将被复制到 dataSourceRef， 当 dataSourceRef.namespace 未被指定时，dataSourceRef 内容将被复制到 dataSource。 如果名字空间被指定，则 dataSourceRef 不会被复制到 dataSource"}
        self.data_source = data_source
        # {"en": "Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources", "zh_CN": "resources 表示卷应拥有的最小资源。 如果启用了 RecoverVolumeExpansionFailure 功能特性，则允许用户指定这些资源要求， 此值必须低于之前的值，但必须高于申领的状态字段中记录的容量"}
        self.resources = resources
        # {"en": "A label query over volumes to consider for binding.", "zh_CN": "selector 是在绑定时对卷进行选择所执行的标签查询"}
        self.selector = selector
        # {"en": "Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1", "zh_CN": "storageClassName 是此申领所要求的 StorageClass 名称"}
        self.storage_class_name = storage_class_name
        # {"en": "volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.", "zh_CN": "volumeMode 定义申领需要哪种类别的卷。当申领规约中未包含此字段时，意味着取值为 Filesystem"}
        self.volume_mode = volume_mode
        # {"en": "VolumeName is the binding reference to the PersistentVolume backing this claim.", "zh_CN": "volumeName 是对此申领所对应的 PersistentVolume 的绑定引用"}
        self.volume_name = volume_name

    def validate(self):
        if self.data_source:
            self.data_source.validate()
        if self.resources:
            self.resources.validate()
        if self.selector:
            self.selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_modes is not None:
            result['accessModes'] = self.access_modes
        if self.data_source is not None:
            result['dataSource'] = self.data_source.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.selector is not None:
            result['selector'] = self.selector.to_map()
        if self.storage_class_name is not None:
            result['storageClassName'] = self.storage_class_name
        if self.volume_mode is not None:
            result['volumeMode'] = self.volume_mode
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessModes') is not None:
            self.access_modes = m.get('accessModes')
        if m.get('dataSource') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1TypedLocalObjectReference()
            self.data_source = temp_model.from_map(m['dataSource'])
        if m.get('resources') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('selector') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.selector = temp_model.from_map(m['selector'])
        if m.get('storageClassName') is not None:
            self.storage_class_name = m.get('storageClassName')
        if m.get('volumeMode') is not None:
            self.volume_mode = m.get('volumeMode')
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        return self


class UpdateJobIoK8sApiCoreV1PersistentVolumeClaimTemplate(TeaModel):
    def __init__(
        self,
        metadata: UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: UpdateJobIoK8sApiCoreV1PersistentVolumeClaimSpec = None,
    ):
        # {"en": "May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.", "zh_CN": "可能包含一些标签和注解，在创建 PVC 时，这些数据会被复制到 PVC 中。 在验证期间，其他字段都不允许设置，即便设置也会在验证阶段被拒绝"}
        self.metadata = metadata
        # {"en": "The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.", "zh_CN": "PersistentVolumeClaim 的规约。整个规约的内容将被原封不动地复制到从此模板创建的 PVC 中。 与 PersistentVolumeClaim 相同的字段在此处也有效"}
        self.spec = spec

    def validate(self):
        if self.metadata:
            self.metadata.validate()
        self.validate_required(self.spec, 'spec')
        if self.spec:
            self.spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('metadata') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PersistentVolumeClaimSpec()
            self.spec = temp_model.from_map(m['spec'])
        return self


class UpdateJobIoK8sApiCoreV1EphemeralVolumeSource(TeaModel):
    def __init__(
        self,
        read_only: bool = None,
        volume_claim_template: UpdateJobIoK8sApiCoreV1PersistentVolumeClaimTemplate = None,
    ):
        # {"en": "Specifies a read-only configuration for the volume. Defaults to false (read/write).", "zh_CN": "指定供卷使用的只读配置。默认为 false（读/写）"}
        self.read_only = read_only
        # {"en": "Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.Required, must not be nil.", "zh_CN": "将用于创建独立的 PVC 以制备卷。 嵌入了 EphemeralVolumeSource 的 Pod 将是 PVC 的所有者，即 PVC 将与 Pod 一起删除。 PVC 的名称将是 <pod 名称>-<卷名称>，其中 <卷名称> 是来自 PodSpec.Volumes 数组条目的名称。 如果串联的名称对于 PVC 无效（例如太长），则 Pod 验证将拒绝该 Pod。如果具有此名称的现有 PVC 不属于此 Pod，则这一 PVC 将 不会 被用于此 Pod，以避免错误地使用不相关的卷。 如果出现这种情况，Pod 的启动操作会被阻塞直到不相关的 PVC 被移除。 如果 Pod 准备使用这样一个预先创建的 PVC，那么一旦此 Pod 出现，就必须更新 PVC， 将其属主引用指向该 Pod。通常没有必要这样做，但这对手动重构损坏的集群时可能很有用。此字段是只读的，PVC 被创建后 Kubernetes 不会对其进行任何更改。必需，不能为 nil"}
        self.volume_claim_template = volume_claim_template

    def validate(self):
        if self.volume_claim_template:
            self.volume_claim_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_claim_template is not None:
            result['volumeClaimTemplate'] = self.volume_claim_template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeClaimTemplate') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PersistentVolumeClaimTemplate()
            self.volume_claim_template = temp_model.from_map(m['volumeClaimTemplate'])
        return self


class UpdateJobIoK8sApiCoreV1FCVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        lun: int = None,
        read_only: bool = None,
        target_wwns: List[str] = None,
        wwids: List[str] = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Optional: FC target lun number", "zh_CN": "可选的：FC 目标 lun 编号"}
        self.lun = lun
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "可选的。默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: FC target worldwide names (WWNs)", "zh_CN": "可选的。FC 目标全球名称（WWN）"}
        self.target_wwns = target_wwns
        # {"en": "Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.", "zh_CN": "可选的。FC 卷全球识别号（wwids）。 必须设置 wwids 或 targetWWNs 及 lun 的组合，但不能同时设置两者"}
        self.wwids = wwids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.lun is not None:
            result['lun'] = self.lun
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.target_wwns is not None:
            result['targetWWNs'] = self.target_wwns
        if self.wwids is not None:
            result['wwids'] = self.wwids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('lun') is not None:
            self.lun = m.get('lun')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('targetWWNs') is not None:
            self.target_wwns = m.get('targetWWNs')
        if m.get('wwids') is not None:
            self.wwids = m.get('wwids')
        return self


class UpdateJobIoK8sApiCoreV1FlexVolumeSource(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        options: Dict[str, Any] = None,
        read_only: bool = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
    ):
        # {"en": "Driver is the name of the driver to use for this volume.", "zh_CN": "供此卷使用的驱动的名称"}
        self.driver = driver
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. The default filesystem depends on FlexVolume script.", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。例如 “ext4”、“xfs”、“ntfs”。 默认的文件系统取决于 flexVolume 脚本"}
        self.fs_type = fs_type
        # {"en": "Optional: Extra command options if any.", "zh_CN": "可选的。此字段包含额外的命令选项（如果有）"}
        self.options = options
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "可选的。默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.", "zh_CN": "可选的。secretRef 是对包含敏感信息的 Secret 对象的引用，该 Secret 会被传递到插件脚本。 如果未指定 Secret 对象，则此字段可以为空。如果 Secret 对象包含多个 Secret，则所有 Secret 被传递到插件脚本"}
        self.secret_ref = secret_ref

    def validate(self):
        self.validate_required(self.driver, 'driver')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['driver'] = self.driver
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.options is not None:
            result['options'] = self.options
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('driver') is not None:
            self.driver = m.get('driver')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('options') is not None:
            self.options = m.get('options')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        return self


class UpdateJobIoK8sApiCoreV1FlockerVolumeSource(TeaModel):
    def __init__(
        self,
        dataset_name: str = None,
        dataset_uuid: str = None,
    ):
        # {"en": "Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated", "zh_CN": "存储为元数据的数据集的名称。Flocker 数据集的名称应视为已弃用"}
        self.dataset_name = dataset_name
        # {"en": "UUID of the dataset. This is unique identifier of a Flocker dataset", "zh_CN": "数据集的 UUID。这是 Flocker 数据集的唯一标识符"}
        self.dataset_uuid = dataset_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_name is not None:
            result['datasetName'] = self.dataset_name
        if self.dataset_uuid is not None:
            result['datasetUUID'] = self.dataset_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('datasetName') is not None:
            self.dataset_name = m.get('datasetName')
        if m.get('datasetUUID') is not None:
            self.dataset_uuid = m.get('datasetUUID')
        return self


class UpdateJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        partition: int = None,
        pd_name: str = None,
        read_only: bool = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为“ext4”"}
        self.fs_type = fs_type
        # {"en": "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as 1. Similarly, the volume partition for /dev/sda is 0 (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "你要挂载的卷中的分区。如果省略，则默认为按卷名称进行挂载。 例如：对于卷 /dev/sda1，将分区指定为 “1”。类似地，/dev/sda 的卷分区为 “0”（或可以将属性留空）。"}
        self.partition = partition
        # {"en": "Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "GCE 中 PD 资源的唯一名称。用于标识 GCE 中的磁盘"}
        self.pd_name = pd_name
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.pd_name, 'pd_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.pd_name is not None:
            result['pdName'] = self.pd_name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('pdName') is not None:
            self.pd_name = m.get('pdName')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class UpdateJobIoK8sApiCoreV1GitRepoVolumeSource(TeaModel):
    def __init__(
        self,
        directory: str = None,
        repository: str = None,
        revision: str = None,
    ):
        # {"en": "Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.", "zh_CN": "目标目录的名称。不得包含 “..” 或以 “..” 开头。如果提供了 “.”，则卷目录将是 Git 仓库。 否则，如果指定，卷将用给定名称的子目录中存放 Git 仓库"}
        self.directory = directory
        # {"en": "Repository URL", "zh_CN": "仓库的 URL"}
        self.repository = repository
        # {"en": "Commit hash for the specified revision.", "zh_CN": "指定修订版本的提交哈希值"}
        self.revision = revision

    def validate(self):
        self.validate_required(self.repository, 'repository')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory is not None:
            result['directory'] = self.directory
        if self.repository is not None:
            result['repository'] = self.repository
        if self.revision is not None:
            result['revision'] = self.revision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('repository') is not None:
            self.repository = m.get('repository')
        if m.get('revision') is not None:
            self.revision = m.get('revision')
        return self


class UpdateJobIoK8sApiCoreV1GlusterfsVolumeSource(TeaModel):
    def __init__(
        self,
        endpoints: str = None,
        path: str = None,
        read_only: bool = None,
    ):
        # {"en": "EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "详细给出 Glusterfs 拓扑结构的端点的名称"}
        self.endpoints = endpoints
        # {"en": "Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "Glusterfs 卷的路径"}
        self.path = path
        # {"en": "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "此处的 readOnly 将强制以只读权限挂载 Glusterfs 卷。 默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.endpoints, 'endpoints')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoints is not None:
            result['endpoints'] = self.endpoints
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endpoints') is not None:
            self.endpoints = m.get('endpoints')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class UpdateJobIoK8sApiCoreV1HostPathVolumeSource(TeaModel):
    def __init__(
        self,
        path: str = None,
        type: str = None,
    ):
        # {"en": "Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "目录在主机上的路径。如果该路径是一个符号链接，则它将沿着链接指向真实路径"}
        self.path = path
        # {"en": "Type for HostPath Volume Defaults to  More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "HostPath 卷的类型。默认为 “”"}
        self.type = type

    def validate(self):
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['path'] = self.path
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UpdateJobIoK8sApiCoreV1ISCSIVolumeSource(TeaModel):
    def __init__(
        self,
        chap_auth_discovery: bool = None,
        chap_auth_session: bool = None,
        fs_type: str = None,
        initiator_name: str = None,
        iqn: str = None,
        iscsi_interface: str = None,
        lun: int = None,
        portals: List[str] = None,
        read_only: bool = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        target_portal: str = None,
    ):
        # {"en": "whether support iSCSI Discovery CHAP authentication", "zh_CN": "定义是否支持 iSCSI Discovery CHAP 身份认证"}
        self.chap_auth_discovery = chap_auth_discovery
        # {"en": "whether support iSCSI Session CHAP authentication", "zh_CN": "定义是否支持 iSCSI Session CHAP 身份认证"}
        self.chap_auth_session = chap_auth_session
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi", "zh_CN": "你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.", "zh_CN": "自定义的 iSCSI 发起程序名称（iSCSI Initiator Name）。 如果同时用 iscsiInterface 指定 initiatorName，将为连接创建新的 iSCSI 接口 <目标门户>:<卷名称>"}
        self.initiator_name = initiator_name
        # {"en": "Target iSCSI Qualified Name.", "zh_CN": "目标 iSCSI 限定名称"}
        self.iqn = iqn
        # {"en": "iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).", "zh_CN": "使用 iSCSI 传输的接口名称。默认为 “default”（tcp）"}
        self.iscsi_interface = iscsi_interface
        # {"en": "iSCSI Target Lun number.", "zh_CN": "表示 iSCSI 目标逻辑单元号"}
        self.lun = lun
        # {"en": "iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).", "zh_CN": " iSCSI 目标门户列表（iSCSI Target Portal List）。 如果不是默认端口（通常是 TCP 端口 860 和 3260），则 Portal 为 IP 或 ip_addr:port"}
        self.portals = portals
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only
        # {"en": "CHAP Secret for iSCSI target and initiator authentication", "zh_CN": "iSCSI 目标和发起程序身份认证所用的 CHAP Secret"}
        self.secret_ref = secret_ref
        # {"en": "iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).", "zh_CN": "iSCSI 目标门户。 如果不是默认端口（通常是 TCP 端口 860 和 3260），则 Portal 为 IP 或 ip_addr:port"}
        self.target_portal = target_portal

    def validate(self):
        self.validate_required(self.iqn, 'iqn')
        self.validate_required(self.lun, 'lun')
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.target_portal, 'target_portal')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chap_auth_discovery is not None:
            result['chapAuthDiscovery'] = self.chap_auth_discovery
        if self.chap_auth_session is not None:
            result['chapAuthSession'] = self.chap_auth_session
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.initiator_name is not None:
            result['initiatorName'] = self.initiator_name
        if self.iqn is not None:
            result['iqn'] = self.iqn
        if self.iscsi_interface is not None:
            result['iscsiInterface'] = self.iscsi_interface
        if self.lun is not None:
            result['lun'] = self.lun
        if self.portals is not None:
            result['portals'] = self.portals
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.target_portal is not None:
            result['targetPortal'] = self.target_portal
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('chapAuthDiscovery') is not None:
            self.chap_auth_discovery = m.get('chapAuthDiscovery')
        if m.get('chapAuthSession') is not None:
            self.chap_auth_session = m.get('chapAuthSession')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('initiatorName') is not None:
            self.initiator_name = m.get('initiatorName')
        if m.get('iqn') is not None:
            self.iqn = m.get('iqn')
        if m.get('iscsiInterface') is not None:
            self.iscsi_interface = m.get('iscsiInterface')
        if m.get('lun') is not None:
            self.lun = m.get('lun')
        if m.get('portals') is not None:
            self.portals = m.get('portals')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('targetPortal') is not None:
            self.target_portal = m.get('targetPortal')
        return self


class UpdateJobIoK8sApiCoreV1NFSVolumeSource(TeaModel):
    def __init__(
        self,
        path: str = None,
        read_only: bool = None,
        server: str = None,
    ):
        # {"en": "Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": "由 NFS 服务器导出的路径"}
        self.path = path
        # {"en": "ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": "此处 readOnly 将强制使用只读权限挂载 NFS 导出。默认为 false"}
        self.read_only = read_only
        # {"en": "Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": " NFS 服务器的主机名或 IP 地址"}
        self.server = server

    def validate(self):
        self.validate_required(self.path, 'path')
        self.validate_required(self.server, 'server')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.server is not None:
            result['server'] = self.server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('server') is not None:
            self.server = m.get('server')
        return self


class UpdateJobIoK8sApiCoreV1PersistentVolumeClaimVolumeSource(TeaModel):
    def __init__(
        self,
        claim_name: str = None,
        read_only: bool = None,
    ):
        # {"en": "ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims", "zh_CN": "与使用此卷的 Pod 位于同一名字空间中的 PersistentVolumeClaim 的名称"}
        self.claim_name = claim_name
        # {"en": "Will force the ReadOnly setting in VolumeMounts. Default false.", "zh_CN": "readOnly 将在卷挂载中强制设置 readOnly 属性。默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.claim_name, 'claim_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.claim_name is not None:
            result['claimName'] = self.claim_name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('claimName') is not None:
            self.claim_name = m.get('claimName')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class UpdateJobIoK8sApiCoreV1PhotonPersistentDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        pd_id: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "ID that identifies Photon Controller persistent disk", "zh_CN": "标识 Photon Controller 持久磁盘的 ID"}
        self.pd_id = pd_id

    def validate(self):
        self.validate_required(self.pd_id, 'pd_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.pd_id is not None:
            result['pdID'] = self.pd_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('pdID') is not None:
            self.pd_id = m.get('pdID')
        return self


class UpdateJobIoK8sApiCoreV1PortworxVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        volume_id: str = None,
    ):
        # {"en": "FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. ext4, xfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "表示要挂载的文件系统类型。必须是主机操作系统支持的文件系统类型。例如 “ext4”、“xfs”。 如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "VolumeID uniquely identifies a Portworx volume", "zh_CN": "volumeID 唯一标识 Portworx 卷"}
        self.volume_id = volume_id

    def validate(self):
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class UpdateJobIoK8sApiCoreV1ConfigMapProjection(TeaModel):
    def __init__(
        self,
        items: List[UpdateJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. UpdateJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 ConfigMap 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 ConfigMap 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its keys must be defined", "zh_CN": "optional 指定是否所引用的 ConfigMap 或其键必须已经被定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1DownwardAPIProjection(TeaModel):
    def __init__(
        self,
        items: List[UpdateJobIoK8sApiCoreV1DownwardAPIVolumeFile] = None,
    ):
        # {"en": "Items is a list of DownwardAPIVolume file", "zh_CN": "items 是 DownwardAPIVolume 文件的列表"}
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiCoreV1DownwardAPIVolumeFile()
                self.items.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1SecretProjection(TeaModel):
    def __init__(
        self,
        items: List[UpdateJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. UpdateJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 Secret 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 Secret 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the Secret or its key must be defined", "zh_CN": "optional 字段指定是否 Secret 或其键必须已经定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class UpdateJobIoK8sApiCoreV1ServiceAccountTokenProjection(TeaModel):
    def __init__(
        self,
        audience: str = None,
        expiration_seconds: int = None,
        path: str = None,
    ):
        # {"en": "Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.", "zh_CN": "audience 是令牌的目标受众。 令牌的接收方必须用令牌受众中指定的一个标识符来标识自己，否则应拒绝此令牌。 受众默认为 apiserver 的标识符"}
        self.audience = audience
        # {"en": "ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.", "zh_CN": "expirationSeconds 是所请求的服务账号令牌的有效期。 当令牌即将到期时，kubelet 卷插件将主动轮换服务账号令牌。 如果令牌超过其生存时间的 80% 或令牌超过 24 小时，kubelet 将开始尝试轮换令牌。 默认为 1 小时且必须至少为 10 分钟"}
        self.expiration_seconds = expiration_seconds
        # {"en": "Path is the path relative to the mount point of the file to project the token into.", "zh_CN": "path 是相对于令牌投射目标文件的挂载点的路径"}
        self.path = path

    def validate(self):
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audience is not None:
            result['audience'] = self.audience
        if self.expiration_seconds is not None:
            result['expirationSeconds'] = self.expiration_seconds
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('audience') is not None:
            self.audience = m.get('audience')
        if m.get('expirationSeconds') is not None:
            self.expiration_seconds = m.get('expirationSeconds')
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class UpdateJobIoK8sApiCoreV1VolumeProjection(TeaModel):
    def __init__(
        self,
        config_map: UpdateJobIoK8sApiCoreV1ConfigMapProjection = None,
        downward_api: UpdateJobIoK8sApiCoreV1DownwardAPIProjection = None,
        secret: UpdateJobIoK8sApiCoreV1SecretProjection = None,
        service_account_token: UpdateJobIoK8sApiCoreV1ServiceAccountTokenProjection = None,
    ):
        # {"en": "information about the configMap data to project", "zh_CN": "与要投射的 ConfigMap 数据有关的 ConfigMap 信息"}
        self.config_map = config_map
        # {"en": "information about the downwardAPI data to project", "zh_CN": "与要投射的 downward API 数据有关的 downward API 信息"}
        self.downward_api = downward_api
        # {"en": "information about the secret data to project", "zh_CN": "与要投射的 Secret 数据有关的 Secret 信息"}
        self.secret = secret
        # {"en": "information about the serviceAccountToken data to project", "zh_CN": "serviceAccountToken 是与要投射的服务账号令牌数据有关的信息"}
        self.service_account_token = service_account_token

    def validate(self):
        if self.config_map:
            self.config_map.validate()
        if self.downward_api:
            self.downward_api.validate()
        if self.secret:
            self.secret.validate()
        if self.service_account_token:
            self.service_account_token.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map is not None:
            result['configMap'] = self.config_map.to_map()
        if self.downward_api is not None:
            result['downwardAPI'] = self.downward_api.to_map()
        if self.secret is not None:
            result['secret'] = self.secret.to_map()
        if self.service_account_token is not None:
            result['serviceAccountToken'] = self.service_account_token.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMap') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ConfigMapProjection()
            self.config_map = temp_model.from_map(m['configMap'])
        if m.get('downwardAPI') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1DownwardAPIProjection()
            self.downward_api = temp_model.from_map(m['downwardAPI'])
        if m.get('secret') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SecretProjection()
            self.secret = temp_model.from_map(m['secret'])
        if m.get('serviceAccountToken') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ServiceAccountTokenProjection()
            self.service_account_token = temp_model.from_map(m['serviceAccountToken'])
        return self


class UpdateJobIoK8sApiCoreV1ProjectedVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        sources: List[UpdateJobIoK8sApiCoreV1VolumeProjection] = None,
    ):
        # {"en": "Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是默认情况下用于为已创建的文件设置权限的模式位。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 路径内的目录不受此设置的影响。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "list of volume projections", "zh_CN": "sources 是卷投射的列表"}
        self.sources = sources

    def validate(self):
        if self.sources:
            for k in self.sources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.sources is not None:
            result['sources'] = []
            for k in self.sources:
                result['sources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('sources') is not None:
            self.sources = []
            for k in m.get('sources'):
                temp_model = UpdateJobIoK8sApiCoreV1VolumeProjection()
                self.sources.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1QuobyteVolumeSource(TeaModel):
    def __init__(
        self,
        group: str = None,
        read_only: bool = None,
        registry: str = None,
        tenant: str = None,
        user: str = None,
        volume: str = None,
    ):
        # {"en": "Group to map volume access to Default is no group", "zh_CN": "将卷访问映射到的组。默认为无组"}
        self.group = group
        # {"en": "ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.", "zh_CN": "此处 readOnly 将强制使用只读权限挂载 Quobyte 卷。默认为 false"}
        self.read_only = read_only
        # {"en": "Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes", "zh_CN": "表示将一个或多个 Quobyte Registry 服务指定为 host:port 对的字符串形式 （多个条目用英文逗号分隔），用作卷的中央注册表"}
        self.registry = registry
        # {"en": "Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin", "zh_CN": "tenant 拥有 Backend Used 中给定的 Quobyte 卷，随动态制备的 Quobyte 卷一起使用，值由插件设置"}
        self.tenant = tenant
        # {"en": "User to map volume access to Defaults to serivceaccount user", "zh_CN": "user 是将卷访问映射到的用户。默认为 serivceaccount 用户"}
        self.user = user
        # {"en": "Volume is a string that references an already created Quobyte volume by name.", "zh_CN": "volume 是按名称引用已创建的 Quobyte 卷的字符串"}
        self.volume = volume

    def validate(self):
        self.validate_required(self.registry, 'registry')
        self.validate_required(self.volume, 'volume')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group is not None:
            result['group'] = self.group
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.registry is not None:
            result['registry'] = self.registry
        if self.tenant is not None:
            result['tenant'] = self.tenant
        if self.user is not None:
            result['user'] = self.user
        if self.volume is not None:
            result['volume'] = self.volume
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('registry') is not None:
            self.registry = m.get('registry')
        if m.get('tenant') is not None:
            self.tenant = m.get('tenant')
        if m.get('user') is not None:
            self.user = m.get('user')
        if m.get('volume') is not None:
            self.volume = m.get('volume')
        return self


class UpdateJobIoK8sApiCoreV1RBDVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        image: str = None,
        keyring: str = None,
        monitors: List[str] = None,
        pool: str = None,
        read_only: bool = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        user: str = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd", "zh_CN": "fsType 是你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "rados 镜像名称"}
        self.image = image
        # {"en": "Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "RBDUser 密钥环的路径。默认为 /etc/ceph/keyring"}
        self.keyring = keyring
        # {"en": "A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "Ceph 监测的集合"}
        self.monitors = monitors
        # {"en": "The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "rados 池名称。默认为 rbd"}
        self.pool = pool
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only
        # {"en": "SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "secretRef 是 RBDUser 的身份认证 Secret 的名称。如果提供，则重载 keyring。默认为 nil"}
        self.secret_ref = secret_ref
        # {"en": "The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it", "zh_CN": "user 是 rados 用户名。默认为 admin"}
        self.user = user

    def validate(self):
        self.validate_required(self.image, 'image')
        self.validate_required(self.monitors, 'monitors')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.image is not None:
            result['image'] = self.image
        if self.keyring is not None:
            result['keyring'] = self.keyring
        if self.monitors is not None:
            result['monitors'] = self.monitors
        if self.pool is not None:
            result['pool'] = self.pool
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('keyring') is not None:
            self.keyring = m.get('keyring')
        if m.get('monitors') is not None:
            self.monitors = m.get('monitors')
        if m.get('pool') is not None:
            self.pool = m.get('pool')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class UpdateJobIoK8sApiCoreV1ScaleIOVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        gateway: str = None,
        protection_domain: str = None,
        read_only: bool = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        ssl_enabled: bool = None,
        storage_mode: str = None,
        storage_pool: str = None,
        system: str = None,
        volume_name: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Default is xfs.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。例如 “ext4”、“xfs”、“ntfs”。默认为 “xfs”"}
        self.fs_type = fs_type
        # {"en": "The host address of the ScaleIO API Gateway.", "zh_CN": "ScaleIO API 网关的主机地址"}
        self.gateway = gateway
        # {"en": "The name of the ScaleIO Protection Domain for the configured storage.", "zh_CN": "protectionDomain 是 ScaleIO 保护域（ScaleIO Protection Domain）的名称，用于已配置的存储"}
        self.protection_domain = protection_domain
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.", "zh_CN": "secretRef 引用到 ScaleIO 用户的 Secret 和其他敏感信息。如果未提供此项，则 Login 操作将失败"}
        self.secret_ref = secret_ref
        # {"en": "Flag to enable/disable SSL communication with Gateway, default false", "zh_CN": "sslEnabled 标志启用/禁用与网关的 SSL 通信，默认为 false"}
        self.ssl_enabled = ssl_enabled
        # {"en": "Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.", "zh_CN": "storageMode 指示卷所用的存储应是 ThickProvisioned 或 ThinProvisioned。默认为 ThinProvisioned"}
        self.storage_mode = storage_mode
        # {"en": "The ScaleIO Storage Pool associated with the protection domain.", "zh_CN": "storagePool 是与保护域关联的 ScaleIO Storage Pool"}
        self.storage_pool = storage_pool
        # {"en": "The name of the storage system as configured in ScaleIO.", "zh_CN": "system 是存储系统的名称，与 ScaleIO 中的配置相同"}
        self.system = system
        # {"en": "The name of a volume already created in the ScaleIO system that is associated with this volume source.", "zh_CN": "volumeName 是在与此卷源关联的 ScaleIO 系统中已创建的卷的名称"}
        self.volume_name = volume_name

    def validate(self):
        self.validate_required(self.gateway, 'gateway')
        self.validate_required(self.secret_ref, 'secret_ref')
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.system, 'system')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.gateway is not None:
            result['gateway'] = self.gateway
        if self.protection_domain is not None:
            result['protectionDomain'] = self.protection_domain
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.ssl_enabled is not None:
            result['sslEnabled'] = self.ssl_enabled
        if self.storage_mode is not None:
            result['storageMode'] = self.storage_mode
        if self.storage_pool is not None:
            result['storagePool'] = self.storage_pool
        if self.system is not None:
            result['system'] = self.system
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('gateway') is not None:
            self.gateway = m.get('gateway')
        if m.get('protectionDomain') is not None:
            self.protection_domain = m.get('protectionDomain')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('sslEnabled') is not None:
            self.ssl_enabled = m.get('sslEnabled')
        if m.get('storageMode') is not None:
            self.storage_mode = m.get('storageMode')
        if m.get('storagePool') is not None:
            self.storage_pool = m.get('storagePool')
        if m.get('system') is not None:
            self.system = m.get('system')
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        return self


class UpdateJobIoK8sApiCoreV1SecretVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[UpdateJobIoK8sApiCoreV1KeyToPath] = None,
        optional: bool = None,
        secret_name: str = None,
    ):
        # {"en": "Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. UpdateJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 Secret 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 Secret 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Specify whether the Secret or its keys must be defined", "zh_CN": "optional 字段指定是否 Secret 或其键必须已经定义"}
        self.optional = optional
        # {"en": "Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret", "zh_CN": "secretName 是要使用的、位于 Pod 的名字空间中的 Secret 名称"}
        self.secret_name = secret_name

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.optional is not None:
            result['optional'] = self.optional
        if self.secret_name is not None:
            result['secretName'] = self.secret_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        if m.get('secretName') is not None:
            self.secret_name = m.get('secretName')
        return self


class UpdateJobIoK8sApiCoreV1StorageOSVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        secret_ref: UpdateJobIoK8sApiCoreV1LocalObjectReference = None,
        volume_name: str = None,
        volume_namespace: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.", "zh_CN": "secretRef 指定用于获取 StorageOS API 凭据的 Secret。如果未指定，则将尝试使用默认值"}
        self.secret_ref = secret_ref
        # {"en": "VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.", "zh_CN": "volumeName 是 StorageOS 卷的人类可读名称。这些卷名称在一个名字空间内是唯一的"}
        self.volume_name = volume_name
        # {"en": "VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to default if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.", "zh_CN": "volumeNamespace 指定 StorageOS 内卷的作用域。如果未指定名字空间，则将使用 Pod 的名字空间。 这个设置使得 Kubernetes 的名字作用域可以在 StorageOS 内进行映射，实现更紧密的集成。 将 volumeName 设为任何名称以重载默认的行为。如果你未在 StorageOS 内使用名字空间，则设为“default”。 将创建 StorageOS 内预先不存在的名字空间"}
        self.volume_namespace = volume_namespace

    def validate(self):
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        if self.volume_namespace is not None:
            result['volumeNamespace'] = self.volume_namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        if m.get('volumeNamespace') is not None:
            self.volume_namespace = m.get('volumeNamespace')
        return self


class UpdateJobIoK8sApiCoreV1VsphereVirtualDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        storage_policy_id: str = None,
        storage_policy_name: str = None,
        volume_path: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.", "zh_CN": "storagePolicyID 是与 StoragePolicyName 关联的基于存储策略的管理（SPBM）配置文件 ID"}
        self.storage_policy_id = storage_policy_id
        # {"en": "Storage Policy Based Management (SPBM) profile name.", "zh_CN": "storagePolicyName 是基于存储策略的管理（SPBM）配置文件名称"}
        self.storage_policy_name = storage_policy_name
        # {"en": "Path that identifies vSphere volume vmdk", "zh_CN": "volumePath 是标识 vSphere 卷 vmdk 的路径"}
        self.volume_path = volume_path

    def validate(self):
        self.validate_required(self.volume_path, 'volume_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.storage_policy_id is not None:
            result['storagePolicyID'] = self.storage_policy_id
        if self.storage_policy_name is not None:
            result['storagePolicyName'] = self.storage_policy_name
        if self.volume_path is not None:
            result['volumePath'] = self.volume_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('storagePolicyID') is not None:
            self.storage_policy_id = m.get('storagePolicyID')
        if m.get('storagePolicyName') is not None:
            self.storage_policy_name = m.get('storagePolicyName')
        if m.get('volumePath') is not None:
            self.volume_path = m.get('volumePath')
        return self


class UpdateJobIoK8sApiCoreV1Volume(TeaModel):
    def __init__(
        self,
        aws_elastic_block_store: UpdateJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource = None,
        azure_disk: UpdateJobIoK8sApiCoreV1AzureDiskVolumeSource = None,
        azure_file: UpdateJobIoK8sApiCoreV1AzureFileVolumeSource = None,
        cephfs: UpdateJobIoK8sApiCoreV1CephFSVolumeSource = None,
        cinder: UpdateJobIoK8sApiCoreV1CinderVolumeSource = None,
        config_map: UpdateJobIoK8sApiCoreV1ConfigMapVolumeSource = None,
        csi: UpdateJobIoK8sApiCoreV1CSIVolumeSource = None,
        downward_api: UpdateJobIoK8sApiCoreV1DownwardAPIVolumeSource = None,
        empty_dir: UpdateJobIoK8sApiCoreV1EmptyDirVolumeSource = None,
        ephemeral: UpdateJobIoK8sApiCoreV1EphemeralVolumeSource = None,
        fc: UpdateJobIoK8sApiCoreV1FCVolumeSource = None,
        flex_volume: UpdateJobIoK8sApiCoreV1FlexVolumeSource = None,
        flocker: UpdateJobIoK8sApiCoreV1FlockerVolumeSource = None,
        gce_persistent_disk: UpdateJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource = None,
        git_repo: UpdateJobIoK8sApiCoreV1GitRepoVolumeSource = None,
        glusterfs: UpdateJobIoK8sApiCoreV1GlusterfsVolumeSource = None,
        host_path: UpdateJobIoK8sApiCoreV1HostPathVolumeSource = None,
        iscsi: UpdateJobIoK8sApiCoreV1ISCSIVolumeSource = None,
        name: str = None,
        nfs: UpdateJobIoK8sApiCoreV1NFSVolumeSource = None,
        persistent_volume_claim: UpdateJobIoK8sApiCoreV1PersistentVolumeClaimVolumeSource = None,
        photon_persistent_disk: UpdateJobIoK8sApiCoreV1PhotonPersistentDiskVolumeSource = None,
        portworx_volume: UpdateJobIoK8sApiCoreV1PortworxVolumeSource = None,
        projected: UpdateJobIoK8sApiCoreV1ProjectedVolumeSource = None,
        quobyte: UpdateJobIoK8sApiCoreV1QuobyteVolumeSource = None,
        rbd: UpdateJobIoK8sApiCoreV1RBDVolumeSource = None,
        scale_io: UpdateJobIoK8sApiCoreV1ScaleIOVolumeSource = None,
        secret: UpdateJobIoK8sApiCoreV1SecretVolumeSource = None,
        storageos: UpdateJobIoK8sApiCoreV1StorageOSVolumeSource = None,
        vsphere_volume: UpdateJobIoK8sApiCoreV1VsphereVirtualDiskVolumeSource = None,
    ):
        # {"en": "AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 AWS Disk 资源"}
        self.aws_elastic_block_store = aws_elastic_block_store
        # {"en": "AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.", "zh_CN": "表示挂载到主机上并绑定挂载到 Pod 上的 Azure 数据盘"}
        self.azure_disk = azure_disk
        # {"en": "AzureFile represents an Azure File Service mount on the host and bind mount to the pod.", "zh_CN": "表示挂载到主机上并绑定挂载到 Pod 上的 Azure File Service"}
        self.azure_file = azure_file
        # {"en": "CephFS represents a Ceph FS mount on the host that shares a pod's lifetime", "zh_CN": "表示在主机上挂载的 Ceph FS，该文件系统挂载与 Pod 的生命周期相同"}
        self.cephfs = cephfs
        # {"en": "Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "表示 kubelet 主机上挂接和挂载的 Cinder 卷"}
        self.cinder = cinder
        # {"en": "ConfigMap represents a configMap that should populate this volume", "zh_CN": "表示应填充此卷的 configMap"}
        self.config_map = config_map
        # {"en": "CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).", "zh_CN": "表示由某个外部容器存储接口（Container Storage Interface，CSI）驱动处理的临时存储（Beta 特性）"}
        self.csi = csi
        # {"en": "DownwardAPI represents downward API about the pod that should populate this volume", "zh_CN": "表示有关 Pod 的 Downward API，用来填充此卷"}
        self.downward_api = downward_api
        # {"en": "EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir", "zh_CN": "表示与 Pod 生命周期相同的临时目录"}
        self.empty_dir = empty_dir
        # {"en": "Ephemeral represents a volume that is handled by a cluster storage driver (Alpha feature). The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity tracking are needed c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through a PersistentVolumeClaim (see EphemeralVolumeSource for more information on the connection between this volume type and PersistentVolumeClaim).Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.A pod can use both types of ephemeral volumes and persistent volumes at the same time.", "zh_CN": "表示由一个集群存储驱动处理的卷。此卷的生命周期与定义该卷的 Pod 相关联。 Pod 启动前创建此卷，Pod 移除时删除此卷。使用此字段的情形包括： a) 仅在 Pod 运行时才需要此卷， b) 需要从快照恢复或容量跟踪等正常卷的功能特性， c) 通过存储类指定存储驱动，以及 d) 存储驱动支持通过 PersistentVolumeClaim 进行动态卷制备 （有关此卷类型和 PersistentVolumeClaim 之间连接的更多信息，请参考 EphemeralVolumeSource）。对于持续时间超过单个 Pod 生命周期的卷，使用 PersistentVolumeClaim 或某种特定于供应商的 API。如果打算以这种方式使用 CSI 驱动，则将 CSI 用于轻量级本地临时卷。更多的相关信息，请参考驱动文档。一个 Pod 可以同时使用临时卷和持久卷这两种类别的卷"}
        self.ephemeral = ephemeral
        # {"en": "FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 Fibre Channel 资源"}
        self.fc = fc
        # {"en": "FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.", "zh_CN": "表示使用基于 exec 的插件制备/挂接的通用卷资源"}
        self.flex_volume = flex_volume
        # {"en": "Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running", "zh_CN": "表示挂接到一个 kubelet 主机的 Flocker 卷。Flocker 卷依赖于正在运行的 Flocker 控制服务"}
        self.flocker = flocker
        # {"en": "GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 GCE Disk 资源"}
        self.gce_persistent_disk = gce_persistent_disk
        # {"en": "GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.", "zh_CN": "表示特定修订版本的 git 仓库。（注意：GitRepo 已被弃用。）如果与为某容器提速 Git 仓库， 可以先将 emptyDir 挂载到 InitContainer 上，由后者使用 git 克隆仓库，然后将 emptyDir 挂载到 Pod 的容器中"}
        self.git_repo = git_repo
        # {"en": "Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md", "zh_CN": "表示关联到主机并暴露给 Pod 的 Glusterfs 卷。由管理员配置"}
        self.glusterfs = glusterfs
        # {"en": "HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "表示主机上预先存在的文件或目录，它们将被直接暴露给容器。 这种卷通常用于系统代理或允许查看主机的其他特权操作。大多数容器不需要这种卷"}
        self.host_path = host_path
        # {"en": "ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md", "zh_CN": "表示挂接到 kubelet 的主机随后暴露给 Pod 的一个 ISCSI Disk 资源"}
        self.iscsi = iscsi
        # {"en": "Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "卷的名称。必须是 DNS_LABEL 且在 Pod 内是唯一的"}
        self.name = name
        # {"en": "NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs", "zh_CN": "表示在主机上挂载的 NFS，其生命周期与 Pod 相同"}
        self.nfs = nfs
        # {"en": "PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims", "zh_CN": "persistentVolumeClaimVolumeSource 表示对同一名字空间中 PersistentVolumeClaim 的引用"}
        self.persistent_volume_claim = persistent_volume_claim
        # {"en": "PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine", "zh_CN": "表示 kubelet 主机上挂接和挂载的 PhotonController 持久磁盘"}
        self.photon_persistent_disk = photon_persistent_disk
        # {"en": "PortworxVolume represents a portworx volume attached and mounted on kubelets host machine", "zh_CN": "表示 kubelet 主机上挂接和挂载的 portworx 卷"}
        self.portworx_volume = portworx_volume
        # {"en": "Items for all in one resources secrets, configmaps, and downward API", "zh_CN": "这是供 Secret、ConfigMap 和 Downward API 等所有资源使用的投射项"}
        self.projected = projected
        # {"en": "Quobyte represents a Quobyte mount on the host that shares a pod's lifetime", "zh_CN": "表示在共享 Pod 生命周期的主机上挂载的 Quobyte"}
        self.quobyte = quobyte
        # {"en": "RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md", "zh_CN": "表示在共享 Pod 生命周期的主机上挂载的 Rados Block Device"}
        self.rbd = rbd
        # {"en": "ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.", "zh_CN": "表示 Kubernetes 节点上挂接和挂载的 ScaleIO 持久卷"}
        self.scale_io = scale_io
        # {"en": "Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret", "zh_CN": "表示用来填充此卷的 Secret"}
        self.secret = secret
        # {"en": "StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.", "zh_CN": "表示 Kubernetes 节点上挂接和挂载的 StorageOS 卷"}
        self.storageos = storageos
        # {"en": "VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine", "zh_CN": "表示 kubelet 主机上挂接和挂载的 vSphere 卷"}
        self.vsphere_volume = vsphere_volume

    def validate(self):
        if self.aws_elastic_block_store:
            self.aws_elastic_block_store.validate()
        if self.azure_disk:
            self.azure_disk.validate()
        if self.azure_file:
            self.azure_file.validate()
        if self.cephfs:
            self.cephfs.validate()
        if self.cinder:
            self.cinder.validate()
        if self.config_map:
            self.config_map.validate()
        if self.csi:
            self.csi.validate()
        if self.downward_api:
            self.downward_api.validate()
        if self.empty_dir:
            self.empty_dir.validate()
        if self.ephemeral:
            self.ephemeral.validate()
        if self.fc:
            self.fc.validate()
        if self.flex_volume:
            self.flex_volume.validate()
        if self.flocker:
            self.flocker.validate()
        if self.gce_persistent_disk:
            self.gce_persistent_disk.validate()
        if self.git_repo:
            self.git_repo.validate()
        if self.glusterfs:
            self.glusterfs.validate()
        if self.host_path:
            self.host_path.validate()
        if self.iscsi:
            self.iscsi.validate()
        self.validate_required(self.name, 'name')
        if self.nfs:
            self.nfs.validate()
        if self.persistent_volume_claim:
            self.persistent_volume_claim.validate()
        if self.photon_persistent_disk:
            self.photon_persistent_disk.validate()
        if self.portworx_volume:
            self.portworx_volume.validate()
        if self.projected:
            self.projected.validate()
        if self.quobyte:
            self.quobyte.validate()
        if self.rbd:
            self.rbd.validate()
        if self.scale_io:
            self.scale_io.validate()
        if self.secret:
            self.secret.validate()
        if self.storageos:
            self.storageos.validate()
        if self.vsphere_volume:
            self.vsphere_volume.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aws_elastic_block_store is not None:
            result['awsElasticBlockStore'] = self.aws_elastic_block_store.to_map()
        if self.azure_disk is not None:
            result['azureDisk'] = self.azure_disk.to_map()
        if self.azure_file is not None:
            result['azureFile'] = self.azure_file.to_map()
        if self.cephfs is not None:
            result['cephfs'] = self.cephfs.to_map()
        if self.cinder is not None:
            result['cinder'] = self.cinder.to_map()
        if self.config_map is not None:
            result['configMap'] = self.config_map.to_map()
        if self.csi is not None:
            result['csi'] = self.csi.to_map()
        if self.downward_api is not None:
            result['downwardAPI'] = self.downward_api.to_map()
        if self.empty_dir is not None:
            result['emptyDir'] = self.empty_dir.to_map()
        if self.ephemeral is not None:
            result['ephemeral'] = self.ephemeral.to_map()
        if self.fc is not None:
            result['fc'] = self.fc.to_map()
        if self.flex_volume is not None:
            result['flexVolume'] = self.flex_volume.to_map()
        if self.flocker is not None:
            result['flocker'] = self.flocker.to_map()
        if self.gce_persistent_disk is not None:
            result['gcePersistentDisk'] = self.gce_persistent_disk.to_map()
        if self.git_repo is not None:
            result['gitRepo'] = self.git_repo.to_map()
        if self.glusterfs is not None:
            result['glusterfs'] = self.glusterfs.to_map()
        if self.host_path is not None:
            result['hostPath'] = self.host_path.to_map()
        if self.iscsi is not None:
            result['iscsi'] = self.iscsi.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.nfs is not None:
            result['nfs'] = self.nfs.to_map()
        if self.persistent_volume_claim is not None:
            result['persistentVolumeClaim'] = self.persistent_volume_claim.to_map()
        if self.photon_persistent_disk is not None:
            result['photonPersistentDisk'] = self.photon_persistent_disk.to_map()
        if self.portworx_volume is not None:
            result['portworxVolume'] = self.portworx_volume.to_map()
        if self.projected is not None:
            result['projected'] = self.projected.to_map()
        if self.quobyte is not None:
            result['quobyte'] = self.quobyte.to_map()
        if self.rbd is not None:
            result['rbd'] = self.rbd.to_map()
        if self.scale_io is not None:
            result['scaleIO'] = self.scale_io.to_map()
        if self.secret is not None:
            result['secret'] = self.secret.to_map()
        if self.storageos is not None:
            result['storageos'] = self.storageos.to_map()
        if self.vsphere_volume is not None:
            result['vsphereVolume'] = self.vsphere_volume.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('awsElasticBlockStore') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource()
            self.aws_elastic_block_store = temp_model.from_map(m['awsElasticBlockStore'])
        if m.get('azureDisk') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1AzureDiskVolumeSource()
            self.azure_disk = temp_model.from_map(m['azureDisk'])
        if m.get('azureFile') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1AzureFileVolumeSource()
            self.azure_file = temp_model.from_map(m['azureFile'])
        if m.get('cephfs') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1CephFSVolumeSource()
            self.cephfs = temp_model.from_map(m['cephfs'])
        if m.get('cinder') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1CinderVolumeSource()
            self.cinder = temp_model.from_map(m['cinder'])
        if m.get('configMap') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ConfigMapVolumeSource()
            self.config_map = temp_model.from_map(m['configMap'])
        if m.get('csi') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1CSIVolumeSource()
            self.csi = temp_model.from_map(m['csi'])
        if m.get('downwardAPI') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1DownwardAPIVolumeSource()
            self.downward_api = temp_model.from_map(m['downwardAPI'])
        if m.get('emptyDir') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1EmptyDirVolumeSource()
            self.empty_dir = temp_model.from_map(m['emptyDir'])
        if m.get('ephemeral') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1EphemeralVolumeSource()
            self.ephemeral = temp_model.from_map(m['ephemeral'])
        if m.get('fc') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1FCVolumeSource()
            self.fc = temp_model.from_map(m['fc'])
        if m.get('flexVolume') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1FlexVolumeSource()
            self.flex_volume = temp_model.from_map(m['flexVolume'])
        if m.get('flocker') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1FlockerVolumeSource()
            self.flocker = temp_model.from_map(m['flocker'])
        if m.get('gcePersistentDisk') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource()
            self.gce_persistent_disk = temp_model.from_map(m['gcePersistentDisk'])
        if m.get('gitRepo') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1GitRepoVolumeSource()
            self.git_repo = temp_model.from_map(m['gitRepo'])
        if m.get('glusterfs') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1GlusterfsVolumeSource()
            self.glusterfs = temp_model.from_map(m['glusterfs'])
        if m.get('hostPath') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1HostPathVolumeSource()
            self.host_path = temp_model.from_map(m['hostPath'])
        if m.get('iscsi') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ISCSIVolumeSource()
            self.iscsi = temp_model.from_map(m['iscsi'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('nfs') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1NFSVolumeSource()
            self.nfs = temp_model.from_map(m['nfs'])
        if m.get('persistentVolumeClaim') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PersistentVolumeClaimVolumeSource()
            self.persistent_volume_claim = temp_model.from_map(m['persistentVolumeClaim'])
        if m.get('photonPersistentDisk') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PhotonPersistentDiskVolumeSource()
            self.photon_persistent_disk = temp_model.from_map(m['photonPersistentDisk'])
        if m.get('portworxVolume') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PortworxVolumeSource()
            self.portworx_volume = temp_model.from_map(m['portworxVolume'])
        if m.get('projected') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ProjectedVolumeSource()
            self.projected = temp_model.from_map(m['projected'])
        if m.get('quobyte') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1QuobyteVolumeSource()
            self.quobyte = temp_model.from_map(m['quobyte'])
        if m.get('rbd') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1RBDVolumeSource()
            self.rbd = temp_model.from_map(m['rbd'])
        if m.get('scaleIO') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1ScaleIOVolumeSource()
            self.scale_io = temp_model.from_map(m['scaleIO'])
        if m.get('secret') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1SecretVolumeSource()
            self.secret = temp_model.from_map(m['secret'])
        if m.get('storageos') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1StorageOSVolumeSource()
            self.storageos = temp_model.from_map(m['storageos'])
        if m.get('vsphereVolume') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1VsphereVirtualDiskVolumeSource()
            self.vsphere_volume = temp_model.from_map(m['vsphereVolume'])
        return self


class UpdateJobIoK8sApiCoreV1PodSpec(TeaModel):
    def __init__(
        self,
        active_deadline_seconds: int = None,
        affinity: UpdateJobIoK8sApiCoreV1Affinity = None,
        automount_service_account_token: bool = None,
        containers: List[UpdateJobIoK8sApiCoreV1Container] = None,
        dns_config: UpdateJobIoK8sApiCoreV1PodDNSConfig = None,
        dns_policy: str = None,
        enable_service_links: bool = None,
        ephemeral_containers: List[UpdateJobIoK8sApiCoreV1EphemeralContainer] = None,
        host_aliases: List[UpdateJobIoK8sApiCoreV1HostAlias] = None,
        host_ipc: bool = None,
        host_network: bool = None,
        host_pid: bool = None,
        hostname: str = None,
        image_pull_secrets: List[UpdateJobIoK8sApiCoreV1LocalObjectReference] = None,
        init_containers: List[UpdateJobIoK8sApiCoreV1Container] = None,
        node_name: str = None,
        node_selector: Dict[str, Any] = None,
        overhead: Dict[str, Any] = None,
        preemption_policy: str = None,
        priority: int = None,
        priority_class_name: str = None,
        readiness_gates: List[UpdateJobIoK8sApiCoreV1PodReadinessGate] = None,
        restart_policy: str = None,
        runtime_class_name: str = None,
        scheduler_name: str = None,
        security_context: UpdateJobIoK8sApiCoreV1PodSecurityContext = None,
        service_account: str = None,
        service_account_name: str = None,
        set_hostname_as_fqdn: bool = None,
        share_process_namespace: bool = None,
        subdomain: str = None,
        termination_grace_period_seconds: int = None,
        tolerations: List[UpdateJobIoK8sApiCoreV1Toleration] = None,
        topology_spread_constraints: List[UpdateJobIoK8sApiCoreV1TopologySpreadConstraint] = None,
        volumes: List[UpdateJobIoK8sApiCoreV1Volume] = None,
    ):
        # {"en": "Optional duration in seconds the pod may be active on the node relative to StartTime before the system will actively try to mark it failed and kill associated containers. Value must be a positive integer.", "zh_CN": "在系统将主动尝试将此 Pod 标记为已失败并杀死相关容器之前，Pod 可能在节点上活跃的时长； 市场计算基于 startTime 计算间（以秒为单位）。字段值必须是正整数"}
        self.active_deadline_seconds = active_deadline_seconds
        # {"en": "If specified, the pod's scheduling constraints", "zh_CN": "如果指定了，则作为 Pod 的调度约束"}
        self.affinity = affinity
        # {"en": "AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.", "zh_CN": "指示是否应自动挂载服务帐户令牌"}
        self.automount_service_account_token = automount_service_account_token
        # {"en": "List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Cannot be updated.", "zh_CN": "属于 Pod 的容器列表。当前无法添加或删除容器。Pod 中必须至少有一个容器。无法更新"}
        self.containers = containers
        # {"en": "Specifies the DNS parameters of a pod. UpdateJobParameters specified here will be merged to the generated DNS configuration based on DNSPolicy.", "zh_CN": "指定 Pod 的 DNS 参数。此处指定的参数将被合并到基于 dnsPolicy 生成的 DNS 配置中"}
        self.dns_config = dns_config
        # {"en": "Set DNS policy for the pod. Defaults to ClusterFirst. Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy. To have DNS options set along with hostNetwork, you have to specify DNS policy explicitly to 'ClusterFirstWithHostNet'.", "zh_CN": "为 Pod 设置 DNS 策略。默认为 “ClusterFirst”。 有效值为 “ClusterFirstWithHostNet”、“ClusterFirst”、“Default” 或 “None”。 dnsConfig 字段中给出的 DNS 参数将与使用 dnsPolicy 字段所选择的策略合并。 要针对 hostNetwork 的 Pod 设置 DNS 选项，你必须将 DNS 策略显式设置为 “ClusterFirstWithHostNet”"}
        self.dns_policy = dns_policy
        # {"en": "EnableServiceLinks indicates whether information about services should be injected into pod's environment variables, matching the syntax of Docker links. Optional: Defaults to true.", "zh_CN": "enableServiceLinks 指示是否应将有关服务的信息注入到 Pod 的环境变量中，服务连接的语法与 Docker links 的语法相匹配。可选。默认为 true"}
        self.enable_service_links = enable_service_links
        # {"en": "List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing pod to perform user-initiated actions such as debugging. This list cannot be specified when creating a pod, and it cannot be modified by updating the pod spec. In order to add an ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource. This field is alpha-level and is only honored by servers that enable the EphemeralContainers feature.", "zh_CN": "在此 Pod 中运行的临时容器列表。临时容器可以在现有的 Pod 中运行，以执行用户发起的操作，例如调试。 此列表在创建 Pod 时不能指定，也不能通过更新 Pod 规约来修改。 要将临时容器添加到现有 Pod，请使用 Pod 的 ephemeralcontainers 子资源"}
        self.ephemeral_containers = ephemeral_containers
        # {"en": "HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts file if specified. This is only valid for non-hostNetwork pods.", "zh_CN": "hostAliases 是一个可选的列表属性，包含要被注入到 Pod 的 hosts 文件中的主机和 IP 地址。 这仅对非 hostNetwork Pod 有效"}
        self.host_aliases = host_aliases
        # {"en": "Use the host's ipc namespace. Optional: Default to false.", "zh_CN": "使用主机的 IPC 名字空间。可选：默认为 false"}
        self.host_ipc = host_ipc
        # {"en": "Host networking requested for this pod. Use the host's network namespace. If this option is set, the ports that will be used must be specified. Default to false.", "zh_CN": "为此 Pod 请求主机层面联网支持。使用主机的网络名字空间。 如果设置了此选项，则必须指定将使用的端口。默认为 false"}
        self.host_network = host_network
        # {"en": "Use the host's pid namespace. Optional: Default to false.", "zh_CN": "使用主机的 PID 名字空间。可选：默认为 false"}
        self.host_pid = host_pid
        # {"en": "Specifies the hostname of the Pod If not specified, the pod's hostname will be set to a system-defined value.", "zh_CN": "指定 Pod 的主机名。如果此字段未指定，则 Pod 的主机名将设置为系统定义的值"}
        self.hostname = hostname
        # {"en": "ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod", "zh_CN": "imagePullSecrets 是对同一名字空间中 Secret 的引用的列表，用于拉取此 Pod 规约中使用的任何镜像，此字段可选。 如果指定，这些 Secret 将被传递给各个镜像拉取组件（Puller）实现供其使用"}
        self.image_pull_secrets = image_pull_secrets
        # {"en": "List of initialization containers belonging to the pod. Init containers are executed in order prior to containers being started. If any init container fails, the pod is considered to have failed and is handled according to its restartPolicy. The name for an init container or normal container must be unique among all containers. Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes. The resourceRequirements of an init container are taken into account during scheduling by finding the highest request/limit for each resource type, and then using the max of of that value or the sum of the normal containers. Limits are applied to init containers in a similar fashion. Init containers cannot currently be added or removed. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/", "zh_CN": "属于 Pod 的 Init 容器列表。Init 容器在容器启动之前按顺序执行。 如果任何一个 Init 容器发生故障，则认为该 Pod 失败，并根据其 restartPolicy 处理。 Init 容器或普通容器的名称在所有容器中必须是唯一的。 Init 容器不可以有生命周期操作、就绪态探针、存活态探针或启动探针。 在调度过程中会考虑 Init 容器的资源需求，方法是查找每种资源类型的最高请求/限制， 然后使用该值的最大值或正常容器的资源请求的总和。 对资源限制以类似的方式应用于 Init 容器。当前无法添加或删除 Init 容器。无法更新"}
        self.init_containers = init_containers
        # {"en": "NodeName is a request to schedule this pod onto a specific node. If it is non-empty, the scheduler simply schedules this pod onto that node, assuming that it fits resource requirements.", "zh_CN": "将此 Pod 调度到特定节点的请求。 如果字段值不为空，调度器只是直接将这个 Pod 调度到所指定节点上，假设节点符合资源要求"}
        self.node_name = node_name
        # {"en": "NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/", "zh_CN": "nodeSelector 是一个选择算符，这些算符必须取值为 true 才能认为 Pod 适合在节点上运行。 选择算符必须与节点的标签匹配，以便在该节点上调度 Pod"}
        self.node_selector = node_selector
        # {"en": "Overhead represents the resource overhead associated with running a pod for a given RuntimeClass. This field will be autopopulated at admission time by the RuntimeClass admission controller. If the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests. The RuntimeClass admission controller will reject Pod create requests which have the overhead already set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero. More info: https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This field is alpha-level as of Kubernetes v1.16, and is only honored by servers that enable the PodOverhead feature.", "zh_CN": "overhead 表示与用指定 RuntimeClass 运行 Pod 相关的资源开销。 该字段将由 RuntimeClass 准入控制器在准入时自动填充。 如果启用了 RuntimeClass 准入控制器，则不得在 Pod 创建请求中设置 overhead 字段。 RuntimeClass 准入控制器将拒绝已设置 overhead 字段的 Pod 创建请求。 如果在 Pod 规约中配置并选择了 RuntimeClass，overhead 字段将被设置为对应 RuntimeClass 中定义的值， 否则将保持不设置并视为零"}
        self.overhead = overhead
        # {"en": "PreemptionPolicy is the Policy for preempting pods with lower priority. One of Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This field is beta-level, gated by the NonPreemptingPriority feature-gate.", "zh_CN": "preemptionPolicy 是用来抢占优先级较低的 Pod 的策略。取值为 “Never”、“PreemptLowerPriority” 之一。 如果未设置，则默认为 “PreemptLowerPriority”"}
        self.preemption_policy = preemption_policy
        # {"en": "The priority value. Various system components use this field to find the priority of the pod. When Priority Admission Controller is enabled, it prevents users from setting this field. The admission controller populates this field from PriorityClassName. The higher the value, the higher the priority.", "zh_CN": "优先级值。各种系统组件使用该字段来确定 Pod 的优先级。当启用 Priority 准入控制器时， 该控制器会阻止用户设置此字段。准入控制器基于 priorityClassName 设置来填充此字段。 字段值越高，优先级越高"}
        self.priority = priority
        # {"en": "If specified, indicates the pod's priority. system-node-critical and system-cluster-critical are two special keywords which indicate the highest priorities with the former being the highest priority. Any other name must be defined by creating a PriorityClass object with that name. If not specified, the pod priority will be default or zero if there is no default.", "zh_CN": "如果设置了此字段，则用来标明 Pod 的优先级。 “system-node-critical” 和 “system-cluster-critical” 是两个特殊关键字， 分别用来表示两个最高优先级，前者优先级更高一些。 任何其他名称都必须通过创建具有该名称的 PriorityClass 对象来定义。 如果未指定此字段，则 Pod 优先级将为默认值。如果没有默认值，则为零"}
        self.priority_class_name = priority_class_name
        # {"en": "If specified, all readiness gates will be evaluated for pod readiness. A pod is ready when all its containers are ready AND all conditions specified in the readiness gates have status equal to True More info: https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md", "zh_CN": "如果设置了此字段，则将评估所有就绪门控（Readiness Gate）以确定 Pod 就绪状况。 当所有容器都已就绪，并且就绪门控中指定的所有状况的 status 都为 true 时，Pod 被视为就绪"}
        self.readiness_gates = readiness_gates
        # {"en": "Restart policy for all containers within the pod. One of Always, OnFailure, Never. Default to Always. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy", "zh_CN": "Pod 内所有容器的重启策略。Always、OnFailure、Never 之一。 在某些情况下，可能只允许这些值的一个子集。默认为 Always"}
        self.restart_policy = restart_policy
        # {"en": "RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run. If unset or empty, the legacy RuntimeClass will be used, which is an implicit class with an empty definition that uses the default runtime handler. More info: https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta feature as of Kubernetes v1.14.", "zh_CN": "runtimeClassName 引用 node.k8s.io 组中的一个 RuntimeClass 对象，该 RuntimeClass 将被用来运行这个 Pod。 如果没有 RuntimeClass 资源与所设置的类匹配，则 Pod 将不会运行。 如果此字段未设置或为空，将使用 “旧版” RuntimeClass。 “旧版” RuntimeClass 可以视作一个隐式的运行时类，其定义为空，会使用默认运行时处理程序"}
        self.runtime_class_name = runtime_class_name
        # {"en": "If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.", "zh_CN": "如果设置了此字段，则 Pod 将由指定的调度器调度。如果未指定，则使用默认调度器来调度 Pod"}
        self.scheduler_name = scheduler_name
        # {"en": "SecurityContext holds pod-level security attributes and common container settings. Optional: Defaults to empty.  See type description for default values of each field.", "zh_CN": "SecurityContext 包含 Pod 级别的安全属性和常见的容器设置。 可选：默认为空。每个字段的默认值见类型描述"}
        self.security_context = security_context
        # {"en": "DeprecatedServiceAccount is a depreciated alias for ServiceAccountName. Deprecated: Use serviceAccountName instead.", "zh_CN": "deprecatedServiceAccount 是 serviceAccountName 的弃用别名。此字段已被弃用：应改用 serviceAccountName"}
        self.service_account = service_account
        # {"en": "ServiceAccountName is the name of the ServiceAccount to use to run this pod. More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/", "zh_CN": "serviceAccountName 是用于运行此 Pod 的服务账号的名称"}
        self.service_account_name = service_account_name
        # {"en": "If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default). In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname). In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\UpdateJobParameters to FQDN. If a pod does not have FQDN, this has no effect. Default to false.", "zh_CN": "如果为 true，则 Pod 的主机名将配置为 Pod 的 FQDN，而不是叶名称（默认值）。 在 Linux 容器中，这意味着将内核的 hostname 字段（struct utsname 的 nodename 字段）设置为 FQDN。 在 Windows 容器中，这意味着将注册表项 HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\UpdateJobParameters 的 hostname 键设置为 FQDN。如果 Pod 没有 FQDN，则此字段不起作用。 默认为 false。"}
        self.set_hostname_as_fqdn = set_hostname_as_fqdn
        # {"en": "Share a single process namespace between all of the containers in a pod. When this is set containers will be able to view and signal processes from other containers in the same pod, and the first process in each container will not be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set. Optional: Default to false.", "zh_CN": "在 Pod 中的所有容器之间共享单个进程名字空间。设置了此字段之后，容器将能够查看来自同一 Pod 中其他容器的进程并发出信号， 并且每个容器中的第一个进程不会被分配 PID 1。hostPID 和 shareProcessNamespace 不能同时设置。 可选：默认为 false"}
        self.share_process_namespace = share_process_namespace
        # {"en": "If specified, the fully qualified Pod hostname will be <hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>. If not specified, the pod will not have a domainname at all.", "zh_CN": "如果设置了此字段，则完全限定的 Pod 主机名将是 <hostname>.<subdomain>.<Pod 名字空间>.svc.<集群域名>。 如果未设置此字段，则该 Pod 将没有域名"}
        self.subdomain = subdomain
        # {"en": "Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request. Value must be non-negative integer. The value zero indicates delete immediately. If this value is nil, the default grace period will be used instead. The grace period is the duration in seconds after the processes running in the pod are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. Defaults to 30 seconds.", "zh_CN": "Pod 需要在探针失败时体面终止所需的时间长度（以秒为单位），为可选字段。 宽限期是 Pod 中运行的进程收到终止信号后，到进程被终止信号强制停止之前的时间长度（以秒为单位）。 你应该将此值设置为比你的进程的预期清理时间更长。 如果此值为 nil，则将使用 Pod 的 terminateGracePeriodSeconds。 否则，此值将覆盖 Pod 规约中设置的值。字段值值必须是非负整数。 零值表示收到终止信号立即停止（没有机会关闭）。 这是一个 Beta 字段，需要启用 ProbeTerminationGracePeriod 特性门控。最小值为 1。 如果未设置，则使用 spec.terminationGracePeriodSeconds"}
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # {"en": "If specified, the pod's tolerations.", "zh_CN": "如果设置了此字段，则作为 Pod 的容忍度"}
        self.tolerations = tolerations
        # {"en": "TopologySpreadConstraints describes how a group of pods ought to spread across topology domains. Scheduler will schedule pods in a way which abides by the constraints. All topologySpreadConstraints are ANDed.", "zh_CN": "TopologySpreadConstraints 描述一组 Pod 应该如何跨拓扑域来分布。调度器将以遵从此约束的方式来调度 Pod。 所有 topologySpreadConstraints 条目会通过逻辑与操作进行组合"}
        self.topology_spread_constraints = topology_spread_constraints
        # {"en": "List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes", "zh_CN": "可以由属于 Pod 的容器挂载的卷列表"}
        self.volumes = volumes

    def validate(self):
        if self.affinity:
            self.affinity.validate()
        self.validate_required(self.containers, 'containers')
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()
        if self.dns_config:
            self.dns_config.validate()
        if self.ephemeral_containers:
            for k in self.ephemeral_containers:
                if k:
                    k.validate()
        if self.host_aliases:
            for k in self.host_aliases:
                if k:
                    k.validate()
        if self.image_pull_secrets:
            for k in self.image_pull_secrets:
                if k:
                    k.validate()
        if self.init_containers:
            for k in self.init_containers:
                if k:
                    k.validate()
        if self.readiness_gates:
            for k in self.readiness_gates:
                if k:
                    k.validate()
        if self.security_context:
            self.security_context.validate()
        if self.tolerations:
            for k in self.tolerations:
                if k:
                    k.validate()
        if self.topology_spread_constraints:
            for k in self.topology_spread_constraints:
                if k:
                    k.validate()
        if self.volumes:
            for k in self.volumes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_deadline_seconds is not None:
            result['activeDeadlineSeconds'] = self.active_deadline_seconds
        if self.affinity is not None:
            result['affinity'] = self.affinity.to_map()
        if self.automount_service_account_token is not None:
            result['automountServiceAccountToken'] = self.automount_service_account_token
        if self.containers is not None:
            result['containers'] = []
            for k in self.containers:
                result['containers'].append(k.to_map() if k else None)
        if self.dns_config is not None:
            result['dnsConfig'] = self.dns_config.to_map()
        if self.dns_policy is not None:
            result['dnsPolicy'] = self.dns_policy
        if self.enable_service_links is not None:
            result['enableServiceLinks'] = self.enable_service_links
        if self.ephemeral_containers is not None:
            result['ephemeralContainers'] = []
            for k in self.ephemeral_containers:
                result['ephemeralContainers'].append(k.to_map() if k else None)
        if self.host_aliases is not None:
            result['hostAliases'] = []
            for k in self.host_aliases:
                result['hostAliases'].append(k.to_map() if k else None)
        if self.host_ipc is not None:
            result['hostIPC'] = self.host_ipc
        if self.host_network is not None:
            result['hostNetwork'] = self.host_network
        if self.host_pid is not None:
            result['hostPID'] = self.host_pid
        if self.hostname is not None:
            result['hostname'] = self.hostname
        if self.image_pull_secrets is not None:
            result['imagePullSecrets'] = []
            for k in self.image_pull_secrets:
                result['imagePullSecrets'].append(k.to_map() if k else None)
        if self.init_containers is not None:
            result['initContainers'] = []
            for k in self.init_containers:
                result['initContainers'].append(k.to_map() if k else None)
        if self.node_name is not None:
            result['nodeName'] = self.node_name
        if self.node_selector is not None:
            result['nodeSelector'] = self.node_selector
        if self.overhead is not None:
            result['overhead'] = self.overhead
        if self.preemption_policy is not None:
            result['preemptionPolicy'] = self.preemption_policy
        if self.priority is not None:
            result['priority'] = self.priority
        if self.priority_class_name is not None:
            result['priorityClassName'] = self.priority_class_name
        if self.readiness_gates is not None:
            result['readinessGates'] = []
            for k in self.readiness_gates:
                result['readinessGates'].append(k.to_map() if k else None)
        if self.restart_policy is not None:
            result['restartPolicy'] = self.restart_policy
        if self.runtime_class_name is not None:
            result['runtimeClassName'] = self.runtime_class_name
        if self.scheduler_name is not None:
            result['schedulerName'] = self.scheduler_name
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.service_account is not None:
            result['serviceAccount'] = self.service_account
        if self.service_account_name is not None:
            result['serviceAccountName'] = self.service_account_name
        if self.set_hostname_as_fqdn is not None:
            result['setHostnameAsFQDN'] = self.set_hostname_as_fqdn
        if self.share_process_namespace is not None:
            result['shareProcessNamespace'] = self.share_process_namespace
        if self.subdomain is not None:
            result['subdomain'] = self.subdomain
        if self.termination_grace_period_seconds is not None:
            result['terminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.tolerations is not None:
            result['tolerations'] = []
            for k in self.tolerations:
                result['tolerations'].append(k.to_map() if k else None)
        if self.topology_spread_constraints is not None:
            result['topologySpreadConstraints'] = []
            for k in self.topology_spread_constraints:
                result['topologySpreadConstraints'].append(k.to_map() if k else None)
        if self.volumes is not None:
            result['volumes'] = []
            for k in self.volumes:
                result['volumes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activeDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('activeDeadlineSeconds')
        if m.get('affinity') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1Affinity()
            self.affinity = temp_model.from_map(m['affinity'])
        if m.get('automountServiceAccountToken') is not None:
            self.automount_service_account_token = m.get('automountServiceAccountToken')
        if m.get('containers') is not None:
            self.containers = []
            for k in m.get('containers'):
                temp_model = UpdateJobIoK8sApiCoreV1Container()
                self.containers.append(temp_model.from_map(k))
        if m.get('dnsConfig') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodDNSConfig()
            self.dns_config = temp_model.from_map(m['dnsConfig'])
        if m.get('dnsPolicy') is not None:
            self.dns_policy = m.get('dnsPolicy')
        if m.get('enableServiceLinks') is not None:
            self.enable_service_links = m.get('enableServiceLinks')
        if m.get('ephemeralContainers') is not None:
            self.ephemeral_containers = []
            for k in m.get('ephemeralContainers'):
                temp_model = UpdateJobIoK8sApiCoreV1EphemeralContainer()
                self.ephemeral_containers.append(temp_model.from_map(k))
        if m.get('hostAliases') is not None:
            self.host_aliases = []
            for k in m.get('hostAliases'):
                temp_model = UpdateJobIoK8sApiCoreV1HostAlias()
                self.host_aliases.append(temp_model.from_map(k))
        if m.get('hostIPC') is not None:
            self.host_ipc = m.get('hostIPC')
        if m.get('hostNetwork') is not None:
            self.host_network = m.get('hostNetwork')
        if m.get('hostPID') is not None:
            self.host_pid = m.get('hostPID')
        if m.get('hostname') is not None:
            self.hostname = m.get('hostname')
        if m.get('imagePullSecrets') is not None:
            self.image_pull_secrets = []
            for k in m.get('imagePullSecrets'):
                temp_model = UpdateJobIoK8sApiCoreV1LocalObjectReference()
                self.image_pull_secrets.append(temp_model.from_map(k))
        if m.get('initContainers') is not None:
            self.init_containers = []
            for k in m.get('initContainers'):
                temp_model = UpdateJobIoK8sApiCoreV1Container()
                self.init_containers.append(temp_model.from_map(k))
        if m.get('nodeName') is not None:
            self.node_name = m.get('nodeName')
        if m.get('nodeSelector') is not None:
            self.node_selector = m.get('nodeSelector')
        if m.get('overhead') is not None:
            self.overhead = m.get('overhead')
        if m.get('preemptionPolicy') is not None:
            self.preemption_policy = m.get('preemptionPolicy')
        if m.get('priority') is not None:
            self.priority = m.get('priority')
        if m.get('priorityClassName') is not None:
            self.priority_class_name = m.get('priorityClassName')
        if m.get('readinessGates') is not None:
            self.readiness_gates = []
            for k in m.get('readinessGates'):
                temp_model = UpdateJobIoK8sApiCoreV1PodReadinessGate()
                self.readiness_gates.append(temp_model.from_map(k))
        if m.get('restartPolicy') is not None:
            self.restart_policy = m.get('restartPolicy')
        if m.get('runtimeClassName') is not None:
            self.runtime_class_name = m.get('runtimeClassName')
        if m.get('schedulerName') is not None:
            self.scheduler_name = m.get('schedulerName')
        if m.get('securityContext') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodSecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('serviceAccount') is not None:
            self.service_account = m.get('serviceAccount')
        if m.get('serviceAccountName') is not None:
            self.service_account_name = m.get('serviceAccountName')
        if m.get('setHostnameAsFQDN') is not None:
            self.set_hostname_as_fqdn = m.get('setHostnameAsFQDN')
        if m.get('shareProcessNamespace') is not None:
            self.share_process_namespace = m.get('shareProcessNamespace')
        if m.get('subdomain') is not None:
            self.subdomain = m.get('subdomain')
        if m.get('terminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('terminationGracePeriodSeconds')
        if m.get('tolerations') is not None:
            self.tolerations = []
            for k in m.get('tolerations'):
                temp_model = UpdateJobIoK8sApiCoreV1Toleration()
                self.tolerations.append(temp_model.from_map(k))
        if m.get('topologySpreadConstraints') is not None:
            self.topology_spread_constraints = []
            for k in m.get('topologySpreadConstraints'):
                temp_model = UpdateJobIoK8sApiCoreV1TopologySpreadConstraint()
                self.topology_spread_constraints.append(temp_model.from_map(k))
        if m.get('volumes') is not None:
            self.volumes = []
            for k in m.get('volumes'):
                temp_model = UpdateJobIoK8sApiCoreV1Volume()
                self.volumes.append(temp_model.from_map(k))
        return self


class UpdateJobIoK8sApiCoreV1PodTemplateSpec(TeaModel):
    def __init__(
        self,
        metadata: UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: UpdateJobIoK8sApiCoreV1PodSpec = None,
    ):
        # {"en": "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "标准的对象元数据"}
        self.metadata = metadata
        # {"en": "Specification of the desired behavior of the pod. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status", "zh_CN": "Pod 预期行为的规约"}
        self.spec = spec

    def validate(self):
        if self.metadata:
            self.metadata.validate()
        if self.spec:
            self.spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('metadata') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodSpec()
            self.spec = temp_model.from_map(m['spec'])
        return self


class UpdateJobIoK8sApiBatchV1JobSpec(TeaModel):
    def __init__(
        self,
        active_deadline_seconds: int = None,
        backoff_limit: int = None,
        completions: int = None,
        manual_selector: bool = None,
        parallelism: int = None,
        selector: UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        template: UpdateJobIoK8sApiCoreV1PodTemplateSpec = None,
        ttl_seconds_after_finished: int = None,
    ):
        # {"en": "Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it; value must be positive integer", "zh_CN": "系统尝试终止任务之前任务可以持续活跃的持续时间（秒），时间长度是相对于 startTime 的； 字段值必须为正整数。如果任务被挂起（在创建期间或因更新而挂起）， 则当任务再次恢复时，此计时器会被停止并重置"}
        self.active_deadline_seconds = active_deadline_seconds
        # {"en": "Specifies the number of retries before marking this job failed. Defaults to 6", "zh_CN": "指定标记此任务失败之前的重试次数。默认值为 6"}
        self.backoff_limit = backoff_limit
        # {"en": "Specifies the desired number of successfully finished pods the job should be run with.  Setting to nil means that the success of any pod signals the success of all pods, and allows parallelism to have any positive value.  Setting to 1 means that parallelism is limited to 1 and the success of that pod signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "指定任务应该运行并预期成功完成的 Pod 个数。设置为空意味着任何 Pod 的成功都标识着所有 Pod 的成功， 并允许 parallelism 设置为任何正值。设置为 1 意味着并行性被限制为 1，并且该 Pod 的成功标志着任务的成功"}
        self.completions = completions
        # {"en": "manualSelector controls generation of pod labels and pod selectors. Leave `manualSelector` unset unless you are certain what you are doing. When false or unset, the system pick labels unique to this job and appends those labels to the pod template.  When true, the user is responsible for picking unique labels and specifying the selector.  Failure to pick a unique label may cause this and other jobs to not function correctly.  However, You may see `manualSelector=true` in jobs that were created with the old `extensions/v1beta1` API. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector", "zh_CN": "manualSelector 控制 Pod 标签和 Pod 选择器的生成。除非你确定你在做什么，否则不要设置 manualSelector。 当此字段为 false 或未设置时，系统会选择此 Pod 唯一的标签并将这些标签附加到 Pod 模板。 当此字段为 true 时，用户负责选择唯一标签并指定选择器。 未能选择唯一标签可能会导致此任务和其他任务无法正常运行。但是，你可能会在使用旧的 extensions/v1beta1 API 创建的任务中看到 manualSelector=true"}
        self.manual_selector = manual_selector
        # {"en": "Specifies the maximum desired number of pods the job should run at any given time. The actual number of pods running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "指定任务应在任何给定时刻预期运行的 Pod 个数上限。 当(.spec.completions - .status.successful) < .spec.parallelism 时， 即当剩余的工作小于最大并行度时，在稳定状态下运行的 Pod 的实际数量将小于此数量"}
        self.parallelism = parallelism
        # {"en": "A label query over pods that should match the pod count. Normally, the system sets this field for you. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors", "zh_CN": "对应与 Pod 计数匹配的 Pod 的标签查询。通常，系统会为你设置此字段"}
        self.selector = selector
        # {"en": "Describes the pod that will be created when executing a job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "描述执行任务时将创建的 Pod。template.spec.restartPolicy 可以取的值只能是 Never 或 OnFailure"}
        self.template = template
        # {"en": "ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is unset, the Job won't be automatically deleted. If this field is set to zero, the Job becomes eligible to be deleted immediately after it finishes. This field is alpha-level and is only honored by servers that enable the TTLAfterFinished feature.", "zh_CN": "ttlSecondsAfterFinished 限制已完成执行（完成或失败）的任务的生命周期。如果设置了这个字段， 在 Job 完成 ttlSecondsAfterFinished 秒之后，就可以被自动删除。 当 Job 被删除时，它的生命周期保证（例如终结器）会被考察。 如果未设置此字段，则任务不会被自动删除。如果此字段设置为零，则任务在完成后即可立即删除"}
        self.ttl_seconds_after_finished = ttl_seconds_after_finished

    def validate(self):
        if self.selector:
            self.selector.validate()
        self.validate_required(self.template, 'template')
        if self.template:
            self.template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_deadline_seconds is not None:
            result['activeDeadlineSeconds'] = self.active_deadline_seconds
        if self.backoff_limit is not None:
            result['backoffLimit'] = self.backoff_limit
        if self.completions is not None:
            result['completions'] = self.completions
        if self.manual_selector is not None:
            result['manualSelector'] = self.manual_selector
        if self.parallelism is not None:
            result['parallelism'] = self.parallelism
        if self.selector is not None:
            result['selector'] = self.selector.to_map()
        if self.template is not None:
            result['template'] = self.template.to_map()
        if self.ttl_seconds_after_finished is not None:
            result['ttlSecondsAfterFinished'] = self.ttl_seconds_after_finished
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activeDeadlineSeconds') is not None:
            self.active_deadline_seconds = m.get('activeDeadlineSeconds')
        if m.get('backoffLimit') is not None:
            self.backoff_limit = m.get('backoffLimit')
        if m.get('completions') is not None:
            self.completions = m.get('completions')
        if m.get('manualSelector') is not None:
            self.manual_selector = m.get('manualSelector')
        if m.get('parallelism') is not None:
            self.parallelism = m.get('parallelism')
        if m.get('selector') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.selector = temp_model.from_map(m['selector'])
        if m.get('template') is not None:
            temp_model = UpdateJobIoK8sApiCoreV1PodTemplateSpec()
            self.template = temp_model.from_map(m['template'])
        if m.get('ttlSecondsAfterFinished') is not None:
            self.ttl_seconds_after_finished = m.get('ttlSecondsAfterFinished')
        return self


class UpdateJobIoK8sApiBatchV1JobCondition(TeaModel):
    def __init__(
        self,
        last_probe_time: str = None,
        last_transition_time: str = None,
        message: str = None,
        reason: str = None,
        status: str = None,
        type: str = None,
    ):
        # {"en": "Last time the condition was checked.", "zh_CN": "最后一次探测的时间"}
        self.last_probe_time = last_probe_time
        # {"en": "Last time the condition transit from one status to another.", "zh_CN": "上一次从一种状况转换到另一种状况的时间"}
        self.last_transition_time = last_transition_time
        # {"en": "Human readable message indicating details about last transition.", "zh_CN": "表示上次转换信息的人类可读消息"}
        self.message = message
        # {"en": "(brief) reason for the condition's last transition.", "zh_CN": "状况最后一次转换的（简要）原因"}
        self.reason = reason
        # {"en": "Status of the condition, one of True, False, Unknown.", "zh_CN": "状况的状态：True、False、Unknown 之一"}
        self.status = status
        # {"en": "Type of job condition, Complete or Failed.", "zh_CN": "任务状况的类型：Completed 或 Failed"}
        self.type = type

    def validate(self):
        self.validate_required(self.status, 'status')
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.last_probe_time is not None:
            result['lastProbeTime'] = self.last_probe_time
        if self.last_transition_time is not None:
            result['lastTransitionTime'] = self.last_transition_time
        if self.message is not None:
            result['message'] = self.message
        if self.reason is not None:
            result['reason'] = self.reason
        if self.status is not None:
            result['status'] = self.status
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('lastProbeTime') is not None:
            self.last_probe_time = m.get('lastProbeTime')
        if m.get('lastTransitionTime') is not None:
            self.last_transition_time = m.get('lastTransitionTime')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('reason') is not None:
            self.reason = m.get('reason')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class UpdateJobIoK8sApiBatchV1JobStatus(TeaModel):
    def __init__(
        self,
        active: int = None,
        completion_time: str = None,
        conditions: List[UpdateJobIoK8sApiBatchV1JobCondition] = None,
        failed: int = None,
        start_time: str = None,
        succeeded: int = None,
    ):
        # {"en": "The number of actively running pods.", "zh_CN": "待处理和正在运行的 Pod 的数量"}
        self.active = active
        # {"en": "Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. The completion time is only set when the job finishes successfully.", "zh_CN": "表示任务完成的时间。不能保证对多个独立操作按发生的先后顺序设置。此字段表示为 RFC3339 格式的 UTC 时间。 仅当任务成功完成时才设置完成时间"}
        self.completion_time = completion_time
        # {"en": "The latest available observations of an object's current state. When a job fails, one of the conditions will have type == Failed. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/", "zh_CN": "对象当前状态的最新可用观察结果。当任务失败时，其中一个状况的类型为 “Failed”，状态为 true。 当任务被暂停时，其中一个状况的类型为 “Suspended”，状态为true；当任务被恢复时，该状况的状态将变为 false。 任务完成时，其中一个状况的类型为 “Complete”，状态为 true"}
        self.conditions = conditions
        # {"en": "The number of pods which reached phase Failed.", "zh_CN": "进入 Failed 阶段的 Pod 数量"}
        self.failed = failed
        # {"en": "Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.", "zh_CN": "表示任务控制器开始处理任务的时间。在挂起状态下创建 Job 时，直到第一次恢复时才会设置此字段。 每次从暂停中恢复任务时都会重置此字段。它表示为 RFC3339 格式的 UTC 时间"}
        self.start_time = start_time
        # {"en": "The number of pods which reached phase Succeeded.", "zh_CN": "进入 Succeeded 阶段的 Pod 数量"}
        self.succeeded = succeeded

    def validate(self):
        if self.conditions:
            for k in self.conditions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['active'] = self.active
        if self.completion_time is not None:
            result['completionTime'] = self.completion_time
        if self.conditions is not None:
            result['conditions'] = []
            for k in self.conditions:
                result['conditions'].append(k.to_map() if k else None)
        if self.failed is not None:
            result['failed'] = self.failed
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.succeeded is not None:
            result['succeeded'] = self.succeeded
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('active') is not None:
            self.active = m.get('active')
        if m.get('completionTime') is not None:
            self.completion_time = m.get('completionTime')
        if m.get('conditions') is not None:
            self.conditions = []
            for k in m.get('conditions'):
                temp_model = UpdateJobIoK8sApiBatchV1JobCondition()
                self.conditions.append(temp_model.from_map(k))
        if m.get('failed') is not None:
            self.failed = m.get('failed')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('succeeded') is not None:
            self.succeeded = m.get('succeeded')
        return self


class UpdateJobRequest(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: UpdateJobIoK8sApiBatchV1JobSpec = None,
        status: UpdateJobIoK8sApiBatchV1JobStatus = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata
        # {"en":"Specification of the desired behavior of a job", "zh_CN":"任务的预期行为的规约"}
        self.spec = spec
        # {"en": "Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status", "zh_CN": "任务的当前状态"}
        self.status = status

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()
        if self.spec:
            self.spec.validate()
        if self.status:
            self.status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        if self.status is not None:
            result['status'] = self.status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = UpdateJobIoK8sApiBatchV1JobSpec()
            self.spec = temp_model.from_map(m['spec'])
        if m.get('status') is not None:
            temp_model = UpdateJobIoK8sApiBatchV1JobStatus()
            self.status = temp_model.from_map(m['status'])
        return self


class UpdateJobIoK8sApiBatchV1Job(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: UpdateJobIoK8sApiBatchV1JobSpec = None,
        status: UpdateJobIoK8sApiBatchV1JobStatus = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata
        # {"en":"Specification of the desired behavior of a job", "zh_CN":"任务的预期行为的规约"}
        self.spec = spec
        # {"en": "Current status of a job. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status", "zh_CN": "任务的当前状态"}
        self.status = status

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()
        if self.spec:
            self.spec.validate()
        if self.status:
            self.status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        if self.status is not None:
            result['status'] = self.status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = UpdateJobIoK8sApiBatchV1JobSpec()
            self.spec = temp_model.from_map(m['spec'])
        if m.get('status') is not None:
            temp_model = UpdateJobIoK8sApiBatchV1JobStatus()
            self.status = temp_model.from_map(m['status'])
        return self


class UpdateJobResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: UpdateJobIoK8sApiBatchV1Job = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"job", "zh_CN":"job"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = UpdateJobIoK8sApiBatchV1Job()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateJobPaths(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        name: str = None,
    ):
        # {"en":"namespace", "zh_CN":"命名空间"}
        self.namespace = namespace
        # {"en":"job name", "zh_CN":"job 名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class UpdateJobParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateJobRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateJobResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateJobIoK8sApimachineryPkgApisMetaV1ListMeta(TeaModel):
    def __init__(
        self,
        continue_: str = None,
        remaining_item_count: int = None,
        resource_version: str = None,
        self_link: str = None,
    ):
        # {"en": "continue may be set if the user set a limit on the number of items returned, and indicates that the server has more data available. The value is opaque and may be used to issue another request to the endpoint that served this list to retrieve the next set of available objects. Continuing a consistent list may not be possible if the server configuration has changed or more than a few minutes have passed. The resourceVersion field returned when using this continue value will be identical to the value in the first response, unless you have received this token from an error message.", "zh_CN": "如果用户对返回的条目数量设置了限制，则 continue 可能被设置，表示服务器有更多可用的数据。 该值是不透明的，可用于向提供此列表服务的端点发出另一个请求，以检索下一组可用的对象。 如果服务器配置已更改或时间已过去几分钟，则可能无法继续提供一致的列表。 除非你在错误消息中收到此令牌（token），否则使用此 continue 值时返回的 resourceVersion 字段应该和第一个响应中的值是相同的"}
        self.continue_ = continue_
        # {"en": "remainingItemCount is the number of subsequent items in the list which are not included in this list response. If the list request contained label or field selectors, then the number of remaining items is unknown and the field will be left unset and omitted during serialization. If the list is complete (either because it is not chunking or because this is the last chunk), then there are no more remaining items and this field will be left unset and omitted during serialization. Servers older than v1.15 do not set this field. The intended use of the remainingItemCount is *estimating* the size of a collection. Clients should not rely on the remainingItemCount to be set or to be exact.", "zh_CN": "remainingItemCount 是列表中未包含在此列表响应中的后续项目的数量。 如果列表请求包含标签或字段选择器，则剩余项目的数量是未知的，并且在序列化期间该字段将保持未设置和省略。 如果列表是完整的（因为它没有分块或者这是最后一个块），那么就没有剩余的项目，并且在序列化过程中该字段将保持未设置和省略。 早于 v1.15 的服务器不设置此字段。remainingItemCount 的预期用途是估计集合的大小。 客户端不应依赖于设置准确的 remainingItemCount"}
        self.remaining_item_count = remaining_item_count
        # {"en": "String that identifies the server's internal version of this object that can be used by clients to determine when objects have changed. Value must be treated as opaque by clients and passed unmodified back to the server. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency", "zh_CN": "标识该对象的服务器内部版本的字符串，客户端可以用该字段来确定对象何时被更改。 该值对客户端是不透明的，并且应该原样传回给服务器。该值由系统填充，只读"}
        self.resource_version = resource_version
        # {"en": "selfLink is a URL representing this object. Populated by the system. Read-only.DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.", "zh_CN": "selfLink 表示此对象的 URL，由系统填充，只读。已弃用：selfLink 是一个遗留的只读字段，不再由系统填充"}
        self.self_link = self_link

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.continue_ is not None:
            result['continue'] = self.continue_
        if self.remaining_item_count is not None:
            result['remainingItemCount'] = self.remaining_item_count
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('continue') is not None:
            self.continue_ = m.get('continue')
        if m.get('remainingItemCount') is not None:
            self.remaining_item_count = m.get('remainingItemCount')
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        return self


class UpdateJobIoK8sApiBatchV1JobList(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        items: List[UpdateJobIoK8sApiBatchV1Job] = None,
        kind: str = None,
        metadata: UpdateJobIoK8sApimachineryPkgApisMetaV1ListMeta = None,
    ):
        # {"en": "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources", "zh_CN": "APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en": "items is the list of Jobs.", "zh_CN": "items 是 Job 对象的列表"}
        self.items = items
        # {"en": "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds", "zh_CN": "kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en": "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "标准列表元数据"}
        self.metadata = metadata

    def validate(self):
        self.validate_required(self.items, 'items')
        if self.items:
            for k in self.items:
                if k:
                    k.validate()
        if self.metadata:
            self.metadata.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = UpdateJobIoK8sApiBatchV1Job()
                self.items.append(temp_model.from_map(k))
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = UpdateJobIoK8sApimachineryPkgApisMetaV1ListMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        return self






class ListPodEventRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListPodEventEvent(TeaModel):
    def __init__(
        self,
        name: str = None,
        event_type: str = None,
        desc: str = None,
        count: int = None,
        last_time: str = None,
        first_time: str = None,
    ):
        # {"en":"event name", "zh_CN":"事件名称"}
        self.name = name
        # {"en":"event type", "zh_CN":"事件类型"}
        self.event_type = event_type
        # {"en":"describe", "zh_CN":"事件描述"}
        self.desc = desc
        # {"en":"event count", "zh_CN":"事件产生次数"}
        self.count = count
        # {"en":"last time", "zh_CN":"事件最后产生时间"}
        self.last_time = last_time
        # {"en":"first time", "zh_CN":"事件首次产生时间"}
        self.first_time = first_time

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.event_type, 'event_type')
        self.validate_required(self.desc, 'desc')
        self.validate_required(self.count, 'count')
        self.validate_required(self.last_time, 'last_time')
        self.validate_required(self.first_time, 'first_time')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.event_type is not None:
            result['eventType'] = self.event_type
        if self.desc is not None:
            result['desc'] = self.desc
        if self.count is not None:
            result['count'] = self.count
        if self.last_time is not None:
            result['lastTime'] = self.last_time
        if self.first_time is not None:
            result['firstTime'] = self.first_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('eventType') is not None:
            self.event_type = m.get('eventType')
        if m.get('desc') is not None:
            self.desc = m.get('desc')
        if m.get('count') is not None:
            self.count = m.get('count')
        if m.get('lastTime') is not None:
            self.last_time = m.get('lastTime')
        if m.get('firstTime') is not None:
            self.first_time = m.get('firstTime')
        return self


class ListPodEventEventList(TeaModel):
    def __init__(
        self,
        events: List[ListPodEventEvent] = None,
    ):
        # {"en":"event info", "zh_CN":"event信息"}
        self.events = events

    def validate(self):
        self.validate_required(self.events, 'events')
        if self.events:
            for k in self.events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.events is not None:
            result['events'] = []
            for k in self.events:
                result['events'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('events') is not None:
            self.events = []
            for k in m.get('events'):
                temp_model = ListPodEventEvent()
                self.events.append(temp_model.from_map(k))
        return self


class ListPodEventResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: List[ListPodEventEventList] = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"event list", "zh_CN":"event列表"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = []
            for k in self.data:
                result['data'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            self.data = []
            for k in m.get('data'):
                temp_model = ListPodEventEventList()
                self.data.append(temp_model.from_map(k))
        return self


class ListPodEventPaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListPodEventParameters(TeaModel):
    def __init__(
        self,
        cluster_name: str = None,
        namespace: str = None,
        name: str = None,
        uid: str = None,
    ):
        # {"en":"edge cluster", "zh_CN":"边缘集群名"}
        self.cluster_name = cluster_name
        # {"en":"namespace", "zh_CN":"namespace"}
        self.namespace = namespace
        # {"en":"pod name", "zh_CN":"pod名称"}
        self.name = name
        # {"en":"pod uid", "zh_CN":"pod UID"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.cluster_name, 'cluster_name')
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class ListPodEventRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class ListPodEventResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class CreateClusterCrdResourceOwnerReference(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        name: str = None,
        uid: str = None,
        controller: bool = None,
        block_owner_deletion: bool = None,
    ):
        # {"en":"API version of the referent", "zh_CN":"被引用资源的 API 版本"}
        self.api_version = api_version
        # {"en":"Kind of the referent", "zh_CN":"被引用资源的类别"}
        self.kind = kind
        # {"en":"Name of the referent", "zh_CN":"被引用资源的名称"}
        self.name = name
        # {"en":"UID of the referent", "zh_CN":"被引用资源的 uid"}
        self.uid = uid
        # {"en":"If true, this reference points to the managing controller", "zh_CN":"如果为 true，则此引用指向管理的控制器"}
        self.controller = controller
        # {"en":"If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed", "zh_CN":"如果为 true，**并且** 如果属主具有 “foregroundDeletion” 终结器，则在删除此引用之前，无法从键值存储中删除属主。 默认为 false。要设置此字段，用户需要属主的 “delete” 权限， 否则将返回 422 (Unprocessable Entity)"}
        self.block_owner_deletion = block_owner_deletion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        if self.controller is not None:
            result['controller'] = self.controller
        if self.block_owner_deletion is not None:
            result['blockOwnerDeletion'] = self.block_owner_deletion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('controller') is not None:
            self.controller = m.get('controller')
        if m.get('blockOwnerDeletion') is not None:
            self.block_owner_deletion = m.get('blockOwnerDeletion')
        return self


class CreateClusterCrdResourceFieldsV1(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateClusterCrdResourceManagedFieldsEntry(TeaModel):
    def __init__(
        self,
        manager: str = None,
        operation: str = None,
        api_version: str = None,
        time: str = None,
        fields_type: str = None,
        fields_v1: CreateClusterCrdResourceFieldsV1 = None,
        subresource: str = None,
    ):
        # {"en":"an identifier of the workflow managing these fields", "zh_CN":"管理这些字段的工作流的标识符"}
        self.manager = manager
        # {"en":"the type of operation which lead to this CreateClusterCrdResourceManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'", "zh_CN":"导致创建此 managedFields 表项的操作类型。 此字段的仅有合法值是 “Apply” 和 “Update”"}
        self.operation = operation
        # {"en":"defines the version of this resource that this field set applies to. The format is \"group\/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted", "zh_CN":"定义此字段集适用的资源的版本。 格式是 “group\/version”，就像顶级 apiVersion 字段一样。 必须跟踪字段集的版本，因为它不能自动转换"}
        self.api_version = api_version
        # {"en":"the timestamp of when the ManagedFields entry was added", "zh_CN":"添加 managedFields 条目时的时间戳"}
        self.time = time
        # {"en":"the discriminator for the different fields format and version. There is currently only one possible value: 'CreateClusterCrdResourceFieldsV1'", "zh_CN":"不同字段格式和版本的鉴别器。 目前只有一个可能的值：“CreateClusterCrdResourceFieldsV1”"}
        self.fields_type = fields_type
        # {"en":"CreateClusterCrdResourceFieldsV1 holds the first JSON version format as described in the 'CreateClusterCrdResourceFieldsV1' type", "zh_CN":"CreateClusterCrdResourceFieldsV1 包含类型 “CreateClusterCrdResourceFieldsV1” 中描述的第一个 JSON 版本格式"}
        self.fields_v1 = fields_v1
        # {"en":"the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource", "zh_CN":"用于更新该对象的子资源的名称，如果对象是通过主资源更新的，则为空字符串。 该字段的值用于区分管理者，即使他们共享相同的名称。例如，状态更新将不同于使用相同管理者名称的常规更新。 请注意，apiVersion 字段与 subresource 字段无关，它始终对应于主资源的版本"}
        self.subresource = subresource

    def validate(self):
        if self.fields_v1:
            self.fields_v1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.manager is not None:
            result['manager'] = self.manager
        if self.operation is not None:
            result['operation'] = self.operation
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.time is not None:
            result['time'] = self.time
        if self.fields_type is not None:
            result['fieldsType'] = self.fields_type
        if self.fields_v1 is not None:
            result['fieldsV1'] = self.fields_v1.to_map()
        if self.subresource is not None:
            result['subresource'] = self.subresource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('manager') is not None:
            self.manager = m.get('manager')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('fieldsType') is not None:
            self.fields_type = m.get('fieldsType')
        if m.get('fieldsV1') is not None:
            temp_model = CreateClusterCrdResourceFieldsV1()
            self.fields_v1 = temp_model.from_map(m['fieldsV1'])
        if m.get('subresource') is not None:
            self.subresource = m.get('subresource')
        return self


class CreateClusterCrdResourceObjectMeta(TeaModel):
    def __init__(
        self,
        name: str = None,
        generate_name: str = None,
        namespace: str = None,
        self_link: str = None,
        uid: str = None,
        resource_version: str = None,
        generation: int = None,
        creation_timestamp: str = None,
        deletion_timestamp: str = None,
        deletion_grace_period_seconds: int = None,
        labels: Dict[str, str] = None,
        annotations: Dict[str, str] = None,
        owner_references: List[CreateClusterCrdResourceOwnerReference] = None,
        finalizers: List[str] = None,
        cluster_name: str = None,
        managed_fields: List[CreateClusterCrdResourceManagedFieldsEntry] = None,
    ):
        # {"en":"must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated", "zh_CN":"name 在命名空间内必须是唯一的。创建资源时需要，尽管某些资源可能允许客户端请求自动地生成适当的名称。 名称主要用于创建幂等性和配置定义。无法更新"}
        self.name = name
        # {"en":"an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server", "zh_CN":"一个可选前缀，由服务器使用，仅在未提供 name 字段时生成唯一名称。 如果使用此字段，则返回给客户端的名称将与传递的名称不同。该值还将与唯一的后缀组合。 提供的值与 name 字段具有相同的验证规则，并且可能会根据所需的后缀长度被截断，以使该值在服务器上唯一"}
        self.generate_name = generate_name
        # {"en":"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.Must be a DNS_LABEL. Cannot be updated", "zh_CN":"namespace 定义了一个值空间，其中每个名称必须唯一。空命名空间相当于 “default” 命名空间，但 “default” 是规范表示。 并非所有对象都需要限定在命名空间中——这些对象的此字段的值将为空。必须是 DNS_LABEL。无法更新。"}
        self.namespace = namespace
        # {"en":"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.", "zh_CN":"表示此对象的 URL。由系统填充。只读。已弃用。Kubernetes 将在 1.20 版本中停止传播该字段，并计划在 1.21 版本中删除该字段。"}
        self.self_link = self_link
        # {"en":"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.Populated by the system. Read-only", "zh_CN":"该对象在时间和空间上的唯一值。它通常由服务器在成功创建资源时生成，并且不允许使用 PUT 操作更改。由系统填充。只读"}
        self.uid = uid
        # {"en":"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.Populated by the system. Read-only. Value must be treated as opaque by clients and", "zh_CN":"一个不透明的值，表示此对象的内部版本，客户端可以使用该值来确定对象是否已被更改。 可用于乐观并发、变更检测以及对资源或资源集的监听操作。 客户端必须将这些值视为不透明的，且未更改地传回服务器。 它们可能仅对特定资源或一组资源有效。由系统填充。只读。客户端必须将值视为不透明。"}
        self.resource_version = resource_version
        # {"en":"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only", "zh_CN":"表示期望状态的特定生成的序列号。由系统填充。只读"}
        self.generation = generation
        # {"en":"a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.Populated by the system. Read-only. Null for lists", "zh_CN":"一个时间戳，表示创建此对象时的服务器时间。 不能保证在单独的操作中按发生前的顺序设置。 客户端不得设置此值。它以 RFC3339 形式表示，并采用 UTC。由系统填充。只读。列表为空"}
        self.creation_timestamp = creation_timestamp
        # {"en":"RFC 3339 date and time at which this resource will be deleted", "zh_CN":"删除此资源的 RFC 3339 日期和时间"}
        self.deletion_timestamp = deletion_timestamp
        # {"en":"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only", "zh_CN":"此对象从系统中删除之前允许正常终止的秒数。 仅当设置了 deletionTimestamp 时才设置。 只能缩短。只读"}
        self.deletion_grace_period_seconds = deletion_grace_period_seconds
        # {"en":"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services", "zh_CN":"可用于组织和分类（确定范围和选择）对象的字符串键和值的映射。 可以匹配 ReplicationController 和 Service 的选择算符"}
        self.labels = labels
        # {"en":"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects", "zh_CN":"annotations 是一个非结构化的键值映射，存储在资源中，可以由外部工具设置以存储和检索任意元数据。 它们不可查询，在修改对象时应保留"}
        self.annotations = annotations
        # {"en":"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller", "zh_CN":"此对象所依赖的对象列表。如果列表中的所有对象都已被删除，则该对象将被垃圾回收。 如果此对象由控制器管理，则此列表中的条目将指向此控制器，controller 字段设置为 true。 管理控制器不能超过一个"}
        self.owner_references = owner_references
        # {"en":"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order. Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.", "zh_CN":"在从注册表中删除对象之前该字段必须为空。 每个条目都是负责的组件的标识符，各组件将从列表中删除自己对应的条目。 如果对象的 deletionTimestamp 非空，则只能删除此列表中的条目。 终结器可以按任何顺序处理和删除。没有按照顺序执行， 因为它引入了终结器卡住的重大风险。finalizers 是一个共享字段， 任何有权限的参与者都可以对其进行重新排序。如果按顺序处理终结器列表， 那么这可能导致列表中第一个负责终结器的组件正在等待列表中靠后负责终结器的组件产生的信号（字段值、外部系统或其他）， 从而导致死锁。在没有强制排序的情况下，终结者可以在它们之间自由排序， 并且不容易受到列表中排序更改的影响。"}
        self.finalizers = finalizers
        # {"en":"name of cluster", "zh_CN":"集群名称"}
        self.cluster_name = cluster_name
        # {"en":"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \"ci-cd\". The set of fields is always in the version that the workflow used when modifying the object", "zh_CN":"managedFields 将 workflow-id 和版本映射到由该工作流管理的字段集。 这主要用于内部管理，用户通常不需要设置或理解该字段。 工作流可以是用户名、控制器名或特定应用路径的名称，如 “ci-cd”。 字段集始终存在于修改对象时工作流使用的版本"}
        self.managed_fields = managed_fields

    def validate(self):
        if self.owner_references:
            for k in self.owner_references:
                if k:
                    k.validate()
        if self.managed_fields:
            for k in self.managed_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.generate_name is not None:
            result['generateName'] = self.generate_name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        if self.uid is not None:
            result['uid'] = self.uid
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.generation is not None:
            result['generation'] = self.generation
        if self.creation_timestamp is not None:
            result['creationTimestamp'] = self.creation_timestamp
        if self.deletion_timestamp is not None:
            result['deletionTimestamp'] = self.deletion_timestamp
        if self.deletion_grace_period_seconds is not None:
            result['deletionGracePeriodSeconds'] = self.deletion_grace_period_seconds
        if self.labels is not None:
            result['labels'] = self.labels
        if self.annotations is not None:
            result['annotations'] = self.annotations
        if self.owner_references is not None:
            result['ownerReferences'] = []
            for k in self.owner_references:
                result['ownerReferences'].append(k.to_map() if k else None)
        if self.finalizers is not None:
            result['finalizers'] = self.finalizers
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.managed_fields is not None:
            result['managedFields'] = []
            for k in self.managed_fields:
                result['managedFields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('generateName') is not None:
            self.generate_name = m.get('generateName')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('generation') is not None:
            self.generation = m.get('generation')
        if m.get('creationTimestamp') is not None:
            self.creation_timestamp = m.get('creationTimestamp')
        if m.get('deletionTimestamp') is not None:
            self.deletion_timestamp = m.get('deletionTimestamp')
        if m.get('deletionGracePeriodSeconds') is not None:
            self.deletion_grace_period_seconds = m.get('deletionGracePeriodSeconds')
        if m.get('labels') is not None:
            self.labels = m.get('labels')
        if m.get('annotations') is not None:
            self.annotations = m.get('annotations')
        if m.get('ownerReferences') is not None:
            self.owner_references = []
            for k in m.get('ownerReferences'):
                temp_model = CreateClusterCrdResourceOwnerReference()
                self.owner_references.append(temp_model.from_map(k))
        if m.get('finalizers') is not None:
            self.finalizers = m.get('finalizers')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('managedFields') is not None:
            self.managed_fields = []
            for k in m.get('managedFields'):
                temp_model = CreateClusterCrdResourceManagedFieldsEntry()
                self.managed_fields.append(temp_model.from_map(k))
        return self


class CreateClusterCrdResourceRequest(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: CreateClusterCrdResourceObjectMeta = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = CreateClusterCrdResourceObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        return self


class CreateClusterCrdResourceCrdResource(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: CreateClusterCrdResourceObjectMeta = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = CreateClusterCrdResourceObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        return self


class CreateClusterCrdResourceResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: CreateClusterCrdResourceCrdResource = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"service", "zh_CN":"service"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = CreateClusterCrdResourceCrdResource()
            self.data = temp_model.from_map(m['data'])
        return self


class CreateClusterCrdResourcePaths(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateClusterCrdResourceParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateClusterCrdResourceRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class CreateClusterCrdResourceResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteStatefulsetRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteStatefulsetStatusDetails(TeaModel):
    def __init__(
        self,
        name: str = None,
        kind: str = None,
        group: str = None,
        uid: str = None,
    ):
        # {"en":"The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)", "zh_CN":"与状态 StatusReason 关联的资源的名称属性（当有一个可以描述的名称时）"}
        self.name = name
        # {"en":"The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind", "zh_CN":"与状态 StatusReason 关联的资源的种类属性"}
        self.kind = kind
        # {"en":"The group attribute of the resource associated with the status StatusReason", "zh_CN":"与状态 StatusReason 关联的资源的组属性"}
        self.group = group
        # {"en":"UID of the resource. (when there is a single resource which can be described)", "zh_CN":"资源的 UID（当有单个可以描述的资源时）"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.group, 'group')
        self.validate_required(self.uid, 'uid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.kind is not None:
            result['kind'] = self.kind
        if self.group is not None:
            result['group'] = self.group
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class DeleteStatefulsetStatus(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        status: str = None,
        code: int = None,
        details: DeleteStatefulsetStatusDetails = None,
    ):
        # {"en":"APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values", "zh_CN":"APIVersion 定义对象表示的版本化模式。 服务器应将已识别的模式转换为最新的内部值，并可能拒绝无法识别的值"}
        self.api_version = api_version
        # {"en":"Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase", "zh_CN":"Kind 是一个字符串值，表示此对象表示的 REST 资源。 服务器可以从客户端提交请求的端点推断出这一点。 无法更新。驼峰式规则"}
        self.kind = kind
        # {"en":"DeleteStatefulsetStatus of the operation. One of: 'Success' or 'Failure'", "zh_CN":"操作状态。“Success”或“Failure” 之一"}
        self.status = status
        # {"en":"Suggested HTTP return code for this status, 0 if not set", "zh_CN":"此状态的建议 HTTP 返回代码，如果未设置，则为 0"}
        self.code = code
        # {"en":"Extended data associated with the reason. Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type", "zh_CN":"与原因（Reason）相关的扩展数据。每个原因都可以定义自己的扩展细节。 此字段是可选的，并且不保证返回的数据符合任何模式，除非由原因类型定义"}
        self.details = details

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.status, 'status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.details, 'details')
        if self.details:
            self.details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.status is not None:
            result['status'] = self.status
        if self.code is not None:
            result['code'] = self.code
        if self.details is not None:
            result['details'] = self.details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('details') is not None:
            temp_model = DeleteStatefulsetStatusDetails()
            self.details = temp_model.from_map(m['details'])
        return self


class DeleteStatefulsetResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: DeleteStatefulsetStatus = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"status", "zh_CN":"status"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = DeleteStatefulsetStatus()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteStatefulsetPaths(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        name: str = None,
    ):
        # {"en":"namespace", "zh_CN":"命名空间"}
        self.namespace = namespace
        # {"en":"statefulset name", "zh_CN":"statefulset 名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class DeleteStatefulsetParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteStatefulsetRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteStatefulsetResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class UpdateCrdResourceOwnerReference(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        name: str = None,
        uid: str = None,
        controller: bool = None,
        block_owner_deletion: bool = None,
    ):
        # {"en":"API version of the referent", "zh_CN":"被引用资源的 API 版本"}
        self.api_version = api_version
        # {"en":"Kind of the referent", "zh_CN":"被引用资源的类别"}
        self.kind = kind
        # {"en":"Name of the referent", "zh_CN":"被引用资源的名称"}
        self.name = name
        # {"en":"UID of the referent", "zh_CN":"被引用资源的 uid"}
        self.uid = uid
        # {"en":"If true, this reference points to the managing controller", "zh_CN":"如果为 true，则此引用指向管理的控制器"}
        self.controller = controller
        # {"en":"If true, AND if the owner has the \"foregroundDeletion\" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed", "zh_CN":"如果为 true，**并且** 如果属主具有 “foregroundDeletion” 终结器，则在删除此引用之前，无法从键值存储中删除属主。 默认为 false。要设置此字段，用户需要属主的 “delete” 权限， 否则将返回 422 (Unprocessable Entity)"}
        self.block_owner_deletion = block_owner_deletion

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        if self.controller is not None:
            result['controller'] = self.controller
        if self.block_owner_deletion is not None:
            result['blockOwnerDeletion'] = self.block_owner_deletion
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('controller') is not None:
            self.controller = m.get('controller')
        if m.get('blockOwnerDeletion') is not None:
            self.block_owner_deletion = m.get('blockOwnerDeletion')
        return self


class UpdateCrdResourceFieldsV1(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCrdResourceManagedFieldsEntry(TeaModel):
    def __init__(
        self,
        manager: str = None,
        operation: str = None,
        api_version: str = None,
        time: str = None,
        fields_type: str = None,
        fields_v1: UpdateCrdResourceFieldsV1 = None,
        subresource: str = None,
    ):
        # {"en":"an identifier of the workflow managing these fields", "zh_CN":"管理这些字段的工作流的标识符"}
        self.manager = manager
        # {"en":"the type of operation which lead to this UpdateCrdResourceManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'", "zh_CN":"导致创建此 managedFields 表项的操作类型。 此字段的仅有合法值是 “Apply” 和 “Update”"}
        self.operation = operation
        # {"en":"defines the version of this resource that this field set applies to. The format is \"group\/version\" just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted", "zh_CN":"定义此字段集适用的资源的版本。 格式是 “group\/version”，就像顶级 apiVersion 字段一样。 必须跟踪字段集的版本，因为它不能自动转换"}
        self.api_version = api_version
        # {"en":"the timestamp of when the ManagedFields entry was added", "zh_CN":"添加 managedFields 条目时的时间戳"}
        self.time = time
        # {"en":"the discriminator for the different fields format and version. There is currently only one possible value: 'UpdateCrdResourceFieldsV1'", "zh_CN":"不同字段格式和版本的鉴别器。 目前只有一个可能的值：“UpdateCrdResourceFieldsV1”"}
        self.fields_type = fields_type
        # {"en":"UpdateCrdResourceFieldsV1 holds the first JSON version format as described in the 'UpdateCrdResourceFieldsV1' type", "zh_CN":"UpdateCrdResourceFieldsV1 包含类型 “UpdateCrdResourceFieldsV1” 中描述的第一个 JSON 版本格式"}
        self.fields_v1 = fields_v1
        # {"en":"the name of the subresource used to update that object, or empty string if the object was updated through the main resource. The value of this field is used to distinguish between managers, even if they share the same name. For example, a status update will be distinct from a regular update using the same manager name. Note that the APIVersion field is not related to the Subresource field and it always corresponds to the version of the main resource", "zh_CN":"用于更新该对象的子资源的名称，如果对象是通过主资源更新的，则为空字符串。 该字段的值用于区分管理者，即使他们共享相同的名称。例如，状态更新将不同于使用相同管理者名称的常规更新。 请注意，apiVersion 字段与 subresource 字段无关，它始终对应于主资源的版本"}
        self.subresource = subresource

    def validate(self):
        if self.fields_v1:
            self.fields_v1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.manager is not None:
            result['manager'] = self.manager
        if self.operation is not None:
            result['operation'] = self.operation
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.time is not None:
            result['time'] = self.time
        if self.fields_type is not None:
            result['fieldsType'] = self.fields_type
        if self.fields_v1 is not None:
            result['fieldsV1'] = self.fields_v1.to_map()
        if self.subresource is not None:
            result['subresource'] = self.subresource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('manager') is not None:
            self.manager = m.get('manager')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('time') is not None:
            self.time = m.get('time')
        if m.get('fieldsType') is not None:
            self.fields_type = m.get('fieldsType')
        if m.get('fieldsV1') is not None:
            temp_model = UpdateCrdResourceFieldsV1()
            self.fields_v1 = temp_model.from_map(m['fieldsV1'])
        if m.get('subresource') is not None:
            self.subresource = m.get('subresource')
        return self


class UpdateCrdResourceObjectMeta(TeaModel):
    def __init__(
        self,
        name: str = None,
        generate_name: str = None,
        namespace: str = None,
        self_link: str = None,
        uid: str = None,
        resource_version: str = None,
        generation: int = None,
        creation_timestamp: str = None,
        deletion_timestamp: str = None,
        deletion_grace_period_seconds: int = None,
        labels: Dict[str, str] = None,
        annotations: Dict[str, str] = None,
        owner_references: List[UpdateCrdResourceOwnerReference] = None,
        finalizers: List[str] = None,
        cluster_name: str = None,
        managed_fields: List[UpdateCrdResourceManagedFieldsEntry] = None,
    ):
        # {"en":"must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated", "zh_CN":"name 在命名空间内必须是唯一的。创建资源时需要，尽管某些资源可能允许客户端请求自动地生成适当的名称。 名称主要用于创建幂等性和配置定义。无法更新"}
        self.name = name
        # {"en":"an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server", "zh_CN":"一个可选前缀，由服务器使用，仅在未提供 name 字段时生成唯一名称。 如果使用此字段，则返回给客户端的名称将与传递的名称不同。该值还将与唯一的后缀组合。 提供的值与 name 字段具有相同的验证规则，并且可能会根据所需的后缀长度被截断，以使该值在服务器上唯一"}
        self.generate_name = generate_name
        # {"en":"Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the \"default\" namespace, but \"default\" is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.Must be a DNS_LABEL. Cannot be updated", "zh_CN":"namespace 定义了一个值空间，其中每个名称必须唯一。空命名空间相当于 “default” 命名空间，但 “default” 是规范表示。 并非所有对象都需要限定在命名空间中——这些对象的此字段的值将为空。必须是 DNS_LABEL。无法更新。"}
        self.namespace = namespace
        # {"en":"Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.", "zh_CN":"表示此对象的 URL。由系统填充。只读。已弃用。Kubernetes 将在 1.20 版本中停止传播该字段，并计划在 1.21 版本中删除该字段。"}
        self.self_link = self_link
        # {"en":"UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.Populated by the system. Read-only", "zh_CN":"该对象在时间和空间上的唯一值。它通常由服务器在成功创建资源时生成，并且不允许使用 PUT 操作更改。由系统填充。只读"}
        self.uid = uid
        # {"en":"An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.Populated by the system. Read-only. Value must be treated as opaque by clients and", "zh_CN":"一个不透明的值，表示此对象的内部版本，客户端可以使用该值来确定对象是否已被更改。 可用于乐观并发、变更检测以及对资源或资源集的监听操作。 客户端必须将这些值视为不透明的，且未更改地传回服务器。 它们可能仅对特定资源或一组资源有效。由系统填充。只读。客户端必须将值视为不透明。"}
        self.resource_version = resource_version
        # {"en":"A sequence number representing a specific generation of the desired state. Populated by the system. Read-only", "zh_CN":"表示期望状态的特定生成的序列号。由系统填充。只读"}
        self.generation = generation
        # {"en":"a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.Populated by the system. Read-only. Null for lists", "zh_CN":"一个时间戳，表示创建此对象时的服务器时间。 不能保证在单独的操作中按发生前的顺序设置。 客户端不得设置此值。它以 RFC3339 形式表示，并采用 UTC。由系统填充。只读。列表为空"}
        self.creation_timestamp = creation_timestamp
        # {"en":"RFC 3339 date and time at which this resource will be deleted", "zh_CN":"删除此资源的 RFC 3339 日期和时间"}
        self.deletion_timestamp = deletion_timestamp
        # {"en":"Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only", "zh_CN":"此对象从系统中删除之前允许正常终止的秒数。 仅当设置了 deletionTimestamp 时才设置。 只能缩短。只读"}
        self.deletion_grace_period_seconds = deletion_grace_period_seconds
        # {"en":"Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services", "zh_CN":"可用于组织和分类（确定范围和选择）对象的字符串键和值的映射。 可以匹配 ReplicationController 和 Service 的选择算符"}
        self.labels = labels
        # {"en":"Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects", "zh_CN":"annotations 是一个非结构化的键值映射，存储在资源中，可以由外部工具设置以存储和检索任意元数据。 它们不可查询，在修改对象时应保留"}
        self.annotations = annotations
        # {"en":"List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller", "zh_CN":"此对象所依赖的对象列表。如果列表中的所有对象都已被删除，则该对象将被垃圾回收。 如果此对象由控制器管理，则此列表中的条目将指向此控制器，controller 字段设置为 true。 管理控制器不能超过一个"}
        self.owner_references = owner_references
        # {"en":"Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order. Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.", "zh_CN":"在从注册表中删除对象之前该字段必须为空。 每个条目都是负责的组件的标识符，各组件将从列表中删除自己对应的条目。 如果对象的 deletionTimestamp 非空，则只能删除此列表中的条目。 终结器可以按任何顺序处理和删除。没有按照顺序执行， 因为它引入了终结器卡住的重大风险。finalizers 是一个共享字段， 任何有权限的参与者都可以对其进行重新排序。如果按顺序处理终结器列表， 那么这可能导致列表中第一个负责终结器的组件正在等待列表中靠后负责终结器的组件产生的信号（字段值、外部系统或其他）， 从而导致死锁。在没有强制排序的情况下，终结者可以在它们之间自由排序， 并且不容易受到列表中排序更改的影响。"}
        self.finalizers = finalizers
        # {"en":"name of cluster", "zh_CN":"集群名称"}
        self.cluster_name = cluster_name
        # {"en":"ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like \"ci-cd\". The set of fields is always in the version that the workflow used when modifying the object", "zh_CN":"managedFields 将 workflow-id 和版本映射到由该工作流管理的字段集。 这主要用于内部管理，用户通常不需要设置或理解该字段。 工作流可以是用户名、控制器名或特定应用路径的名称，如 “ci-cd”。 字段集始终存在于修改对象时工作流使用的版本"}
        self.managed_fields = managed_fields

    def validate(self):
        if self.owner_references:
            for k in self.owner_references:
                if k:
                    k.validate()
        if self.managed_fields:
            for k in self.managed_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.generate_name is not None:
            result['generateName'] = self.generate_name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        if self.uid is not None:
            result['uid'] = self.uid
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.generation is not None:
            result['generation'] = self.generation
        if self.creation_timestamp is not None:
            result['creationTimestamp'] = self.creation_timestamp
        if self.deletion_timestamp is not None:
            result['deletionTimestamp'] = self.deletion_timestamp
        if self.deletion_grace_period_seconds is not None:
            result['deletionGracePeriodSeconds'] = self.deletion_grace_period_seconds
        if self.labels is not None:
            result['labels'] = self.labels
        if self.annotations is not None:
            result['annotations'] = self.annotations
        if self.owner_references is not None:
            result['ownerReferences'] = []
            for k in self.owner_references:
                result['ownerReferences'].append(k.to_map() if k else None)
        if self.finalizers is not None:
            result['finalizers'] = self.finalizers
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.managed_fields is not None:
            result['managedFields'] = []
            for k in self.managed_fields:
                result['managedFields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('generateName') is not None:
            self.generate_name = m.get('generateName')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('generation') is not None:
            self.generation = m.get('generation')
        if m.get('creationTimestamp') is not None:
            self.creation_timestamp = m.get('creationTimestamp')
        if m.get('deletionTimestamp') is not None:
            self.deletion_timestamp = m.get('deletionTimestamp')
        if m.get('deletionGracePeriodSeconds') is not None:
            self.deletion_grace_period_seconds = m.get('deletionGracePeriodSeconds')
        if m.get('labels') is not None:
            self.labels = m.get('labels')
        if m.get('annotations') is not None:
            self.annotations = m.get('annotations')
        if m.get('ownerReferences') is not None:
            self.owner_references = []
            for k in m.get('ownerReferences'):
                temp_model = UpdateCrdResourceOwnerReference()
                self.owner_references.append(temp_model.from_map(k))
        if m.get('finalizers') is not None:
            self.finalizers = m.get('finalizers')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('managedFields') is not None:
            self.managed_fields = []
            for k in m.get('managedFields'):
                temp_model = UpdateCrdResourceManagedFieldsEntry()
                self.managed_fields.append(temp_model.from_map(k))
        return self


class UpdateCrdResourceRequest(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: UpdateCrdResourceObjectMeta = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = UpdateCrdResourceObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        return self


class UpdateCrdResourceCrdResource(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        metadata: UpdateCrdResourceObjectMeta = None,
    ):
        # {"en":"apiVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values.", "zh_CN":"APIVersion定义了表示对象的版本化模式。服务器应该将认可的模式转换为最新的内部值，并可以拒绝不被认可的值。"}
        self.api_version = api_version
        # {"en":"kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase.", "zh_CN":"kind是一个字符串值，表示此对象所代表的REST资源。服务器可以根据客户端提交请求的终点推断出这个值。不能更新。"}
        self.kind = kind
        # {"en":"standard object metadata.", "zh_CN":"标准的对象元数据"}
        self.metadata = metadata

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        if self.metadata:
            self.metadata.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('metadata') is not None:
            temp_model = UpdateCrdResourceObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        return self


class UpdateCrdResourceResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: UpdateCrdResourceCrdResource = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"crdResource", "zh_CN":"crdResource"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = UpdateCrdResourceCrdResource()
            self.data = temp_model.from_map(m['data'])
        return self


class UpdateCrdResourcePaths(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        name: str = None,
    ):
        # {"en":"namespace", "zh_CN":"命名空间"}
        self.namespace = namespace
        # {"en":"service name", "zh_CN":"service 名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class UpdateCrdResourceParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCrdResourceRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class UpdateCrdResourceResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class DeleteDeploymentRequest(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteDeploymentStatusDetails(TeaModel):
    def __init__(
        self,
        name: str = None,
        kind: str = None,
        group: str = None,
        uid: str = None,
    ):
        # {"en":"The name attribute of the resource associated with the status StatusReason (when there is a single name which can be described)", "zh_CN":"与状态 StatusReason 关联的资源的名称属性（当有一个可以描述的名称时）"}
        self.name = name
        # {"en":"The kind attribute of the resource associated with the status StatusReason. On some operations may differ from the requested resource Kind", "zh_CN":"与状态 StatusReason 关联的资源的种类属性"}
        self.kind = kind
        # {"en":"The group attribute of the resource associated with the status StatusReason", "zh_CN":"与状态 StatusReason 关联的资源的组属性"}
        self.group = group
        # {"en":"UID of the resource. (when there is a single resource which can be described)", "zh_CN":"资源的 UID（当有单个可以描述的资源时）"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.group, 'group')
        self.validate_required(self.uid, 'uid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.kind is not None:
            result['kind'] = self.kind
        if self.group is not None:
            result['group'] = self.group
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('group') is not None:
            self.group = m.get('group')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class DeleteDeploymentStatus(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        kind: str = None,
        status: str = None,
        code: int = None,
        details: DeleteDeploymentStatusDetails = None,
    ):
        # {"en":"APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values", "zh_CN":"APIVersion 定义对象表示的版本化模式。 服务器应将已识别的模式转换为最新的内部值，并可能拒绝无法识别的值"}
        self.api_version = api_version
        # {"en":"Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase", "zh_CN":"Kind 是一个字符串值，表示此对象表示的 REST 资源。 服务器可以从客户端提交请求的端点推断出这一点。 无法更新。驼峰式规则"}
        self.kind = kind
        # {"en":"DeleteDeploymentStatus of the operation. One of: 'Success' or 'Failure'", "zh_CN":"操作状态。“Success”或“Failure” 之一"}
        self.status = status
        # {"en":"Suggested HTTP return code for this status, 0 if not set", "zh_CN":"此状态的建议 HTTP 返回代码，如果未设置，则为 0"}
        self.code = code
        # {"en":"Extended data associated with the reason. Each reason may define its own extended details. This field is optional and the data returned is not guaranteed to conform to any schema except that defined by the reason type", "zh_CN":"与原因（Reason）相关的扩展数据。每个原因都可以定义自己的扩展细节。 此字段是可选的，并且不保证返回的数据符合任何模式，除非由原因类型定义"}
        self.details = details

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.status, 'status')
        self.validate_required(self.code, 'code')
        self.validate_required(self.details, 'details')
        if self.details:
            self.details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.kind is not None:
            result['kind'] = self.kind
        if self.status is not None:
            result['status'] = self.status
        if self.code is not None:
            result['code'] = self.code
        if self.details is not None:
            result['details'] = self.details.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('details') is not None:
            temp_model = DeleteDeploymentStatusDetails()
            self.details = temp_model.from_map(m['details'])
        return self


class DeleteDeploymentResponse(TeaModel):
    def __init__(
        self,
        code: int = None,
        msg: str = None,
        request_id: str = None,
        data: DeleteDeploymentStatus = None,
    ):
        # {"en":"response code", "zh_CN":"请求返回码"}
        self.code = code
        # {"en":"response message", "zh_CN":"请求返回信息"}
        self.msg = msg
        # {"en":"requestId", "zh_CN":"请求识别码"}
        self.request_id = request_id
        # {"en":"status", "zh_CN":"status"}
        self.data = data

    def validate(self):
        self.validate_required(self.code, 'code')
        self.validate_required(self.msg, 'msg')
        self.validate_required(self.request_id, 'request_id')
        self.validate_required(self.data, 'data')
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.msg is not None:
            result['msg'] = self.msg
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.data is not None:
            result['data'] = self.data.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('msg') is not None:
            self.msg = m.get('msg')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('data') is not None:
            temp_model = DeleteDeploymentStatus()
            self.data = temp_model.from_map(m['data'])
        return self


class DeleteDeploymentPaths(TeaModel):
    def __init__(
        self,
        namespace: str = None,
        name: str = None,
    ):
        # {"en":"namespace", "zh_CN":"命名空间"}
        self.namespace = namespace
        # {"en":"deployment name", "zh_CN":"deployment 名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.namespace, 'namespace')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class DeleteDeploymentParameters(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteDeploymentRequestHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self


class DeleteDeploymentResponseHeader(TeaModel):
    def __init__(self):
        pass

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        return self






class PatchJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        fields_type: str = None,
        fields_v1: Dict[str, Any] = None,
        manager: str = None,
        operation: str = None,
        time: str = None,
    ):
        # {"en": "APIVersion defines the version of this resource that this field set applies to. The format is group/version just like the top-level APIVersion field. It is necessary to track the version of a field set because it cannot be automatically converted.", "zh_CN": "apiVersion 定义此字段集适用的资源的版本。 格式是 “group/version”，就像顶级 apiVersion 字段一样。 必须跟踪字段集的版本，因为它不能自动转换"}
        self.api_version = api_version
        # {"en": "FieldsType is the discriminator for the different fields format and version. There is currently only one possible value: FieldsV1", "zh_CN": "FieldsType 是不同字段格式和版本的鉴别器。 目前只有一个可能的值：“FieldsV1”"}
        self.fields_type = fields_type
        # {"en": "FieldsV1 holds the first JSON version format as described in the FieldsV1 type.", "zh_CN": "FieldsV1 包含类型 “FieldsV1” 中描述的第一个 JSON 版本格式"}
        self.fields_v1 = fields_v1
        # {"en": "Manager is an identifier of the workflow managing these fields.", "zh_CN": "管理这些字段的工作流的标识符"}
        self.manager = manager
        # {"en": "Operation is the type of operation which lead to this ManagedFieldsEntry being created. The only valid values for this field are 'Apply' and 'Update'.", "zh_CN": "导致创建此 managedFields 表项的操作类型。 此字段的仅有合法值是 “Apply” 和 “Update”"}
        self.operation = operation
        # {"en": "Time is timestamp of when these fields were set. It should always be empty if Operation is 'Apply'", "zh_CN": "添加 managedFields 条目时的时间戳。 如果一个字段被添加、管理器更新任一所属字段值或移除一个字段，该时间戳也会更新。 从此条目中移除一个字段时该时间戳不会更新，因为另一个管理器将它接管了"}
        self.time = time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.fields_type is not None:
            result['fieldsType'] = self.fields_type
        if self.fields_v1 is not None:
            result['fieldsV1'] = self.fields_v1
        if self.manager is not None:
            result['manager'] = self.manager
        if self.operation is not None:
            result['operation'] = self.operation
        if self.time is not None:
            result['time'] = self.time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('fieldsType') is not None:
            self.fields_type = m.get('fieldsType')
        if m.get('fieldsV1') is not None:
            self.fields_v1 = m.get('fieldsV1')
        if m.get('manager') is not None:
            self.manager = m.get('manager')
        if m.get('operation') is not None:
            self.operation = m.get('operation')
        if m.get('time') is not None:
            self.time = m.get('time')
        return self


class PatchJobIoK8sApimachineryPkgApisMetaV1OwnerReference(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        block_owner_deletion: bool = None,
        controller: bool = None,
        kind: str = None,
        name: str = None,
        uid: str = None,
    ):
        # {"en": "API version of the referent.", "zh_CN": "被引用资源的 API 版本"}
        self.api_version = api_version
        # {"en": "If true, AND if the owner has the foregroundDeletion finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs delete permission of the owner, otherwise 422 (Unprocessable Entity) will be returned.", "zh_CN": "如果为 true，**并且** 如果属主具有 “foregroundDeletion” 终结器，则在删除此引用之前，无法从键值存储中删除属主。 默认为 false。要设置此字段，用户需要属主的 “delete” 权限， 否则将返回 422 (Unprocessable Entity)"}
        self.block_owner_deletion = block_owner_deletion
        # {"en": "If true, this reference points to the managing controller.", "zh_CN": "如果为 true，则此引用指向管理的控制器"}
        self.controller = controller
        # {"en": "Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds", "zh_CN": "被引用资源的类别"}
        self.kind = kind
        # {"en": "Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids", "zh_CN": "被引用资源的 uid"}
        self.uid = uid

    def validate(self):
        self.validate_required(self.api_version, 'api_version')
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')
        self.validate_required(self.uid, 'uid')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.block_owner_deletion is not None:
            result['blockOwnerDeletion'] = self.block_owner_deletion
        if self.controller is not None:
            result['controller'] = self.controller
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('blockOwnerDeletion') is not None:
            self.block_owner_deletion = m.get('blockOwnerDeletion')
        if m.get('controller') is not None:
            self.controller = m.get('controller')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class PatchJobIoK8sApimachineryPkgApisMetaV1ObjectMeta(TeaModel):
    def __init__(
        self,
        annotations: Dict[str, Any] = None,
        cluster_name: str = None,
        creation_timestamp: str = None,
        deletion_grace_period_seconds: int = None,
        deletion_timestamp: str = None,
        finalizers: List[str] = None,
        generate_name: str = None,
        generation: int = None,
        labels: Dict[str, Any] = None,
        managed_fields: List[PatchJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry] = None,
        name: str = None,
        namespace: str = None,
        owner_references: List[PatchJobIoK8sApimachineryPkgApisMetaV1OwnerReference] = None,
        resource_version: str = None,
        self_link: str = None,
        uid: str = None,
    ):
        # {"en": "Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations", "zh_CN": "annotations 是一个非结构化的键值映射，存储在资源中，可以由外部工具设置以存储和检索任意元数据。 它们不可查询，在修改对象时应保留"}
        self.annotations = annotations
        # {"en": "The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request.", "zh_CN": "对象所属集群的名称。用于区分不同集群中具有相同名称和namespace的资源。这个字段现在没有在任何地方设置，如果在创建或更新请求中设置，apisserver将忽略它"}
        self.cluster_name = cluster_name
        # {"en": "CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC.Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "creationTimestamp 是一个时间戳，表示创建此对象时的服务器时间。 不能保证在单独的操作中按发生前的顺序设置。 客户端不得设置此值。它以 RFC3339 形式表示，并采用 UTC。由系统填充。只读。列表为空"}
        self.creation_timestamp = creation_timestamp
        # {"en": "Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only.", "zh_CN": "此对象从系统中删除之前允许正常终止的秒数。 仅当设置了 deletionTimestamp 时才设置。 只能缩短。只读"}
        self.deletion_grace_period_seconds = deletion_grace_period_seconds
        # {"en": "DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested.Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata", "zh_CN": "deletionTimestamp 是删除此资源的 RFC 3339 日期和时间。 该字段在用户请求体面删除时由服务器设置，客户端不能直接设置。 一旦 finalizers 列表为空，该资源预计将在此字段中的时间之后被删除 （不再从资源列表中可见，并且无法通过名称访问）。 只要 finalizers 列表包含项目，就阻止删除。一旦设置了 deletionTimestamp， 该值可能不会被取消设置或在未来进一步设置，尽管它可能会缩短或在此时间之前可能会删除资源。 例如，用户可能要求在 30 秒内删除一个 Pod。 Kubelet 将通过向 Pod 中的容器发送体面的终止信号来做出反应。 30 秒后，Kubelet 将向容器发送硬终止信号（SIGKILL）， 并在清理后从 API 中删除 Pod。在网络存在分区的情况下， 此对象可能在此时间戳之后仍然存在，直到管理员或自动化进程可以确定资源已完全终止。 如果未设置，则未请求体面删除该对象。请求体面删除时由系统填充。只读"}
        self.deletion_timestamp = deletion_timestamp
        # {"en": "Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. Finalizers may be processed and removed in any order.  Order is NOT enforced because it introduces significant risk of stuck finalizers. finalizers is a shared field, any actor with permission can reorder it. If the finalizer list is processed in order, then this can lead to a situation in which the component responsible for the first finalizer in the list is waiting for a signal (field value, external system, or other) produced by a component responsible for a finalizer later in the list, resulting in a deadlock. Without enforced ordering finalizers are free to order amongst themselves and are not vulnerable to ordering changes in the list.", "zh_CN": "在从注册表中删除对象之前该字段必须为空。 每个条目都是负责的组件的标识符，各组件将从列表中删除自己对应的条目。 如果对象的 deletionTimestamp 非空，则只能删除此列表中的条目。 终结器可以按任何顺序处理和删除。没有按照顺序执行， 因为它引入了终结器卡住的重大风险。finalizers 是一个共享字段， 任何有权限的参与者都可以对其进行重新排序。如果按顺序处理终结器列表， 那么这可能导致列表中第一个负责终结器的组件正在等待列表中靠后负责终结器的组件产生的信号（字段值、外部系统或其他）， 从而导致死锁。在没有强制排序的情况下，终结者可以在它们之间自由排序， 并且不容易受到列表中排序更改的影响"}
        self.finalizers = finalizers
        # {"en": "GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server.If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header).Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency", "zh_CN": "generateName 是一个可选前缀，由服务器使用，仅在未提供 name 字段时生成唯一名称。 如果使用此字段，则返回给客户端的名称将与传递的名称不同。该值还将与唯一的后缀组合。 提供的值与 name 字段具有相同的验证规则，并且可能会根据所需的后缀长度被截断，以使该值在服务器上唯一。如果指定了此字段并且生成的名称存在，则服务器将不会返回 409 ——相反，它将返回 201 Created 或 500， 原因是 ServerTimeout 指示在分配的时间内找不到唯一名称，客户端应重试（可选，在 Retry-After 标头中指定的时间之后）。仅在未指定 name 时应用"}
        self.generate_name = generate_name
        # {"en": "A sequence number representing a specific generation of the desired state. Populated by the system. Read-only.", "zh_CN": "表示期望状态的特定生成的序列号。由系统填充。只读"}
        self.generation = generation
        # {"en": "Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels", "zh_CN": "可用于组织和分类（确定范围和选择）对象的字符串键和值的映射。 可以匹配 ReplicationController 和 Service 的选择算符"}
        self.labels = labels
        # {"en": "ManagedFields maps workflow-id and version to the set of fields that are managed by that workflow. This is mostly for internal housekeeping, and users typically shouldn't need to set or understand this field. A workflow can be the user's name, a controller's name, or the name of a specific apply path like ci-cd. The set of fields is always in the version that the workflow used when modifying the object.", "zh_CN": "managedFields 将 workflow-id 和版本映射到由该工作流管理的字段集。 这主要用于内部管理，用户通常不需要设置或理解该字段。 工作流可以是用户名、控制器名或特定应用路径的名称，如 “ci-cd”。 字段集始终存在于修改对象时工作流使用的版本"}
        self.managed_fields = managed_fields
        # {"en": "Name must be unique within a namespace. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names", "zh_CN": "name 在命名空间内必须是唯一的。创建资源时需要，尽管某些资源可能允许客户端请求自动地生成适当的名称。 名称主要用于创建幂等性和配置定义。无法更新"}
        self.name = name
        # {"en": "Namespace defines the space within which each name must be unique. An empty namespace is equivalent to the default namespace, but default is the canonical representation. Not all objects are required to be scoped to a namespace - the value of this field for those objects will be empty.Must be a DNS_LABEL. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/namespaces", "zh_CN": "namespace 定义了一个值空间，其中每个名称必须唯一。空命名空间相当于 “default” 命名空间，但 “default” 是规范表示。 并非所有对象都需要限定在命名空间中——这些对象的此字段的值将为空。必须是 DNS_LABEL。无法更新"}
        self.namespace = namespace
        # {"en": "List of objects depended by this object. If ALL objects in the list have been deleted, this object will be garbage collected. If this object is managed by a controller, then an entry in this list will point to this controller, with the controller field set to true. There cannot be more than one managing controller.", "zh_CN": "此对象所依赖的对象列表。如果列表中的所有对象都已被删除，则该对象将被垃圾回收。 如果此对象由控制器管理，则此列表中的条目将指向此控制器，controller 字段设置为 true。 管理控制器不能超过一个"}
        self.owner_references = owner_references
        # {"en": "An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources.Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency", "zh_CN": "一个不透明的值，表示此对象的内部版本，客户端可以使用该值来确定对象是否已被更改。 可用于乐观并发、变更检测以及对资源或资源集的监听操作。 客户端必须将这些值视为不透明的，且未更改地传回服务器。 它们可能仅对特定资源或一组资源有效。由系统填充。只读。客户端必须将值视为不透明"}
        self.resource_version = resource_version
        # {"en": "SelfLink is a URL representing this object. Populated by the system. Read-only.DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the field is planned to be removed in 1.21 release.", "zh_CN": "selfLink 是表示此对象的 URL。由系统填充。只读。已弃用。Kubernetes 将在 1.20 版本中停止传播该字段，并计划在 1.21 版本中删除该字段"}
        self.self_link = self_link
        # {"en": "UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations.Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids", "zh_CN": "UID 是该对象在时间和空间上的唯一值。它通常由服务器在成功创建资源时生成，并且不允许使用 PUT 操作更改。由系统填充。只读"}
        self.uid = uid

    def validate(self):
        if self.managed_fields:
            for k in self.managed_fields:
                if k:
                    k.validate()
        if self.owner_references:
            for k in self.owner_references:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.annotations is not None:
            result['annotations'] = self.annotations
        if self.cluster_name is not None:
            result['clusterName'] = self.cluster_name
        if self.creation_timestamp is not None:
            result['creationTimestamp'] = self.creation_timestamp
        if self.deletion_grace_period_seconds is not None:
            result['deletionGracePeriodSeconds'] = self.deletion_grace_period_seconds
        if self.deletion_timestamp is not None:
            result['deletionTimestamp'] = self.deletion_timestamp
        if self.finalizers is not None:
            result['finalizers'] = self.finalizers
        if self.generate_name is not None:
            result['generateName'] = self.generate_name
        if self.generation is not None:
            result['generation'] = self.generation
        if self.labels is not None:
            result['labels'] = self.labels
        if self.managed_fields is not None:
            result['managedFields'] = []
            for k in self.managed_fields:
                result['managedFields'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.owner_references is not None:
            result['ownerReferences'] = []
            for k in self.owner_references:
                result['ownerReferences'].append(k.to_map() if k else None)
        if self.resource_version is not None:
            result['resourceVersion'] = self.resource_version
        if self.self_link is not None:
            result['selfLink'] = self.self_link
        if self.uid is not None:
            result['uid'] = self.uid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('annotations') is not None:
            self.annotations = m.get('annotations')
        if m.get('clusterName') is not None:
            self.cluster_name = m.get('clusterName')
        if m.get('creationTimestamp') is not None:
            self.creation_timestamp = m.get('creationTimestamp')
        if m.get('deletionGracePeriodSeconds') is not None:
            self.deletion_grace_period_seconds = m.get('deletionGracePeriodSeconds')
        if m.get('deletionTimestamp') is not None:
            self.deletion_timestamp = m.get('deletionTimestamp')
        if m.get('finalizers') is not None:
            self.finalizers = m.get('finalizers')
        if m.get('generateName') is not None:
            self.generate_name = m.get('generateName')
        if m.get('generation') is not None:
            self.generation = m.get('generation')
        if m.get('labels') is not None:
            self.labels = m.get('labels')
        if m.get('managedFields') is not None:
            self.managed_fields = []
            for k in m.get('managedFields'):
                temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1ManagedFieldsEntry()
                self.managed_fields.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('ownerReferences') is not None:
            self.owner_references = []
            for k in m.get('ownerReferences'):
                temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1OwnerReference()
                self.owner_references.append(temp_model.from_map(k))
        if m.get('resourceVersion') is not None:
            self.resource_version = m.get('resourceVersion')
        if m.get('selfLink') is not None:
            self.self_link = m.get('selfLink')
        if m.get('uid') is not None:
            self.uid = m.get('uid')
        return self


class PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        values: List[str] = None,
    ):
        # {"en": "key is the label key that the selector applies to.", "zh_CN": "选择器应用的标签键"}
        self.key = key
        # {"en": "operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.", "zh_CN": "表示键与一组值的关系。有效的运算符包括 In、NotIn、Exists 和 DoesNotExist"}
        self.operator = operator
        # {"en": "values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.", "zh_CN": "values 是一个字符串值数组。如果运算符为 In 或 NotIn，则 values 数组必须为非空。如果运算符是 Exists 或 DoesNotExist，则 values 数组必须为空。该数组在策略性合并补丁（Strategic Merge Patch）期间被替换"}
        self.values = values

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector(TeaModel):
    def __init__(
        self,
        match_expressions: List[PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement] = None,
        match_labels: Dict[str, Any] = None,
    ):
        # {"en": "matchExpressions is a list of label selector requirements. The requirements are ANDed.", "zh_CN": "标签选择器要求的列表，这些要求的结果按逻辑与的关系来计算"}
        self.match_expressions = match_expressions
        # {"en": "matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is key, the operator is In, and the values array contains only value. The requirements are ANDed.", "zh_CN": "matchLabels 是 {key,value} 键值对的映射。matchLabels 映射中的单个 {key,value} 键值对相当于 matchExpressions 的一个元素，其键字段为 key，运算符为 In，values 数组仅包含 value。所表达的需求最终要按逻辑与的关系组合"}
        self.match_labels = match_labels

    def validate(self):
        if self.match_expressions:
            for k in self.match_expressions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_expressions is not None:
            result['matchExpressions'] = []
            for k in self.match_expressions:
                result['matchExpressions'].append(k.to_map() if k else None)
        if self.match_labels is not None:
            result['matchLabels'] = self.match_labels
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchExpressions') is not None:
            self.match_expressions = []
            for k in m.get('matchExpressions'):
                temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelectorRequirement()
                self.match_expressions.append(temp_model.from_map(k))
        if m.get('matchLabels') is not None:
            self.match_labels = m.get('matchLabels')
        return self


class PatchJobIoK8sApiCoreV1NodeSelectorRequirement(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        values: List[str] = None,
    ):
        # {"en": "The label key that the selector applies to.", "zh_CN": "选择算符所适用的标签主键"}
        self.key = key
        # {"en": "Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.", "zh_CN": "代表主键与值集之间的关系。合法的 operator 值包括 In、NotIn、Exists、DoesNotExist、Gt 和 Lt"}
        self.operator = operator
        # {"en": "An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.", "zh_CN": "一个由字符串值组成的数组。如果 operator 是 In 或 NotIn，则 values 数组不能为空。 如果 operator 为 Exists 或 DoesNotExist，则 values 数组只能为空。 如果 operator 为 Gt 或 Lt，则 values 数组只能包含一个元素，并且该元素会被解释为整数。 在执行策略性合并补丁操作时，此数组会被整体替换"}
        self.values = values

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.operator, 'operator')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.values is not None:
            result['values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('values') is not None:
            self.values = m.get('values')
        return self


class PatchJobIoK8sApiCoreV1NodeSelectorTerm(TeaModel):
    def __init__(
        self,
        match_expressions: List[PatchJobIoK8sApiCoreV1NodeSelectorRequirement] = None,
        match_fields: List[PatchJobIoK8sApiCoreV1NodeSelectorRequirement] = None,
    ):
        # {"en": "A list of node selector requirements by node's labels.", "zh_CN": "按节点标签列出的节点选择条件列表"}
        self.match_expressions = match_expressions
        # {"en": "A list of node selector requirements by node's fields.", "zh_CN": "按节点字段列出的节点选择要求列表"}
        self.match_fields = match_fields

    def validate(self):
        if self.match_expressions:
            for k in self.match_expressions:
                if k:
                    k.validate()
        if self.match_fields:
            for k in self.match_fields:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_expressions is not None:
            result['matchExpressions'] = []
            for k in self.match_expressions:
                result['matchExpressions'].append(k.to_map() if k else None)
        if self.match_fields is not None:
            result['matchFields'] = []
            for k in self.match_fields:
                result['matchFields'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('matchExpressions') is not None:
            self.match_expressions = []
            for k in m.get('matchExpressions'):
                temp_model = PatchJobIoK8sApiCoreV1NodeSelectorRequirement()
                self.match_expressions.append(temp_model.from_map(k))
        if m.get('matchFields') is not None:
            self.match_fields = []
            for k in m.get('matchFields'):
                temp_model = PatchJobIoK8sApiCoreV1NodeSelectorRequirement()
                self.match_fields.append(temp_model.from_map(k))
        return self


class PatchJobIoK8sApiCoreV1PreferredSchedulingTerm(TeaModel):
    def __init__(
        self,
        preference: PatchJobIoK8sApiCoreV1NodeSelectorTerm = None,
        weight: int = None,
    ):
        # {"en": "A node selector term, associated with the corresponding weight.", "zh_CN": "与相应权重相关联的节点选择条件"}
        self.preference = preference
        # {"en": "Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.", "zh_CN": "与匹配相应的 nodeSelectorTerm 相关的权重，范围为 1-100"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.preference, 'preference')
        if self.preference:
            self.preference.validate()
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preference is not None:
            result['preference'] = self.preference.to_map()
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preference') is not None:
            temp_model = PatchJobIoK8sApiCoreV1NodeSelectorTerm()
            self.preference = temp_model.from_map(m['preference'])
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class PatchJobIoK8sApiCoreV1NodeSelector(TeaModel):
    def __init__(
        self,
        node_selector_terms: List[PatchJobIoK8sApiCoreV1NodeSelectorTerm] = None,
    ):
        # {"en": "Required. A list of node selector terms. The terms are ORed.", "zh_CN": "必需的字段。节点选择条件列表。这些条件按逻辑或操作组合"}
        self.node_selector_terms = node_selector_terms

    def validate(self):
        self.validate_required(self.node_selector_terms, 'node_selector_terms')
        if self.node_selector_terms:
            for k in self.node_selector_terms:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_selector_terms is not None:
            result['nodeSelectorTerms'] = []
            for k in self.node_selector_terms:
                result['nodeSelectorTerms'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeSelectorTerms') is not None:
            self.node_selector_terms = []
            for k in m.get('nodeSelectorTerms'):
                temp_model = PatchJobIoK8sApiCoreV1NodeSelectorTerm()
                self.node_selector_terms.append(temp_model.from_map(k))
        return self


class PatchJobIoK8sApiCoreV1NodeAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[PatchJobIoK8sApiCoreV1PreferredSchedulingTerm] = None,
        required_during_scheduling_ignored_during_execution: PatchJobIoK8sApiCoreV1NodeSelector = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node matches the corresponding matchExpressions; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度程序会更倾向于将 Pod 调度到满足该字段指定的亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。最优选的节点是权重总和最大的节点， 即对于满足所有调度要求（资源请求、requiredDuringScheduling 亲和表达式等）的每个节点， 通过迭代该字段的元素来计算总和如果节点匹配相应的 matchExpressions，则将 “权重” 添加到总和中； 具有最高总和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to an update), the system may or may not try to eventually evict the pod from its node.", "zh_CN": "如果在调度时不满足该字段指定的亲和性要求，则不会将 Pod 调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的亲和性要求（例如：由于更新）， 系统可能会或可能不会尝试最终将 Pod 从其节点中逐出"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            self.required_during_scheduling_ignored_during_execution.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = self.required_during_scheduling_ignored_during_execution.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = PatchJobIoK8sApiCoreV1PreferredSchedulingTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            temp_model = PatchJobIoK8sApiCoreV1NodeSelector()
            self.required_during_scheduling_ignored_during_execution = temp_model.from_map(m['requiredDuringSchedulingIgnoredDuringExecution'])
        return self


class PatchJobIoK8sApiCoreV1PodAffinityTerm(TeaModel):
    def __init__(
        self,
        label_selector: PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        namespaces: List[str] = None,
        topology_key: str = None,
    ):
        # {"en": "A label query over a set of resources, in this case pods.", "zh_CN": "对一组资源的标签查询，在这里资源为 Pod"}
        self.label_selector = label_selector
        # {"en": "namespaces specifies which namespaces the labelSelector applies to (matches against); null or empty list means this pod's namespace", "zh_CN": "namespaces 指定此条件所适用的名字空间，是一个静态列表。 此条件会被应用到 namespaces 字段中列出的名字空间和由 namespaceSelector 选中的名字空间上。 namespaces 列表为 null 或空，以及 namespaceSelector 值为 null 均表示“此 Pod 的名字空间”"}
        self.namespaces = namespaces
        # {"en": "This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching the labelSelector in the specified namespaces, where co-located is defined as running on a node whose value of the label with key topologyKey matches that of any node on which any of the selected pods is running. Empty topologyKey is not allowed.", "zh_CN": "此 Pod 应与指定名字空间中与标签选择算符匹配的 Pod 集合位于同一位置（亲和性） 或位于不同位置（反亲和性），这里的“在同一位置”意味着运行在一个节点上，其键名为 topologyKey 的标签值与运行所选 Pod 集合中的某 Pod 的任何节点上的标签值匹配。 不允许使用空的 topologyKey"}
        self.topology_key = topology_key

    def validate(self):
        if self.label_selector:
            self.label_selector.validate()
        self.validate_required(self.topology_key, 'topology_key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector.to_map()
        if self.namespaces is not None:
            result['namespaces'] = self.namespaces
        if self.topology_key is not None:
            result['topologyKey'] = self.topology_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('labelSelector') is not None:
            temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.label_selector = temp_model.from_map(m['labelSelector'])
        if m.get('namespaces') is not None:
            self.namespaces = m.get('namespaces')
        if m.get('topologyKey') is not None:
            self.topology_key = m.get('topologyKey')
        return self


class PatchJobIoK8sApiCoreV1WeightedPodAffinityTerm(TeaModel):
    def __init__(
        self,
        pod_affinity_term: PatchJobIoK8sApiCoreV1PodAffinityTerm = None,
        weight: int = None,
    ):
        # {"en": "Required. A pod affinity term, associated with the corresponding weight.", "zh_CN": "必需的字段。一个 Pod 亲和性条件，对应一个与相应的权重值"}
        self.pod_affinity_term = pod_affinity_term
        # {"en": "weight associated with matching the corresponding podAffinityTerm, in the range 1-100.", "zh_CN": "weight 是匹配相应 podAffinityTerm 条件的权重，范围为 1-100"}
        self.weight = weight

    def validate(self):
        self.validate_required(self.pod_affinity_term, 'pod_affinity_term')
        if self.pod_affinity_term:
            self.pod_affinity_term.validate()
        self.validate_required(self.weight, 'weight')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pod_affinity_term is not None:
            result['podAffinityTerm'] = self.pod_affinity_term.to_map()
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('podAffinityTerm') is not None:
            temp_model = PatchJobIoK8sApiCoreV1PodAffinityTerm()
            self.pod_affinity_term = temp_model.from_map(m['podAffinityTerm'])
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class PatchJobIoK8sApiCoreV1PodAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[PatchJobIoK8sApiCoreV1WeightedPodAffinityTerm] = None,
        required_during_scheduling_ignored_during_execution: List[PatchJobIoK8sApiCoreV1PodAffinityTerm] = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度器会更倾向于将 Pod 调度到满足该字段指定的亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。最优选择是权重总和最大的节点， 即对于满足所有调度要求（资源请求、requiredDuringScheduling 亲和表达式等）的每个节点， 通过迭代该字段的元素来计算总和，如果节点具有与相应 podAffinityTerm 匹配的 Pod，则将“权重”添加到总和中； 具有最高总和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.", "zh_CN": "如果在调度时不满足该字段指定的亲和性要求，则该 Pod 不会被调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的亲和性要求（例如：由于 Pod 标签更新）， 系统可能会也可能不会尝试最终将 Pod 从其节点中逐出。 当此列表中有多个元素时，每个 podAffinityTerm 对应的节点列表是取其交集的，即必须满足所有条件"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            for k in self.required_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.required_during_scheduling_ignored_during_execution:
                result['requiredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = PatchJobIoK8sApiCoreV1WeightedPodAffinityTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            self.required_during_scheduling_ignored_during_execution = []
            for k in m.get('requiredDuringSchedulingIgnoredDuringExecution'):
                temp_model = PatchJobIoK8sApiCoreV1PodAffinityTerm()
                self.required_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        return self


class PatchJobIoK8sApiCoreV1PodAntiAffinity(TeaModel):
    def __init__(
        self,
        preferred_during_scheduling_ignored_during_execution: List[PatchJobIoK8sApiCoreV1WeightedPodAffinityTerm] = None,
        required_during_scheduling_ignored_during_execution: List[PatchJobIoK8sApiCoreV1PodAffinityTerm] = None,
    ):
        # {"en": "The scheduler will prefer to schedule pods to nodes that satisfy the anti-affinity expressions specified by this field, but it may choose a node that violates one or more of the expressions. The node that is most preferred is the one with the greatest sum of weights, i.e. for each node that meets all of the scheduling requirements (resource request, requiredDuringScheduling anti-affinity expressions, etc.), compute a sum by iterating through the elements of this field and adding weight to the sum if the node has pods which matches the corresponding podAffinityTerm; the node(s) with the highest sum are the most preferred.", "zh_CN": "调度器更倾向于将 Pod 调度到满足该字段指定的反亲和性表达式的节点， 但它可能会选择违反一个或多个表达式的节点。 最优选的节点是权重总和最大的节点，即对于满足所有调度要求（资源请求、requiredDuringScheduling 反亲和性表达式等）的每个节点，通过遍历元素来计算总和如果节点具有与相应 podAffinityTerm 匹配的 Pod，则此字段并在总和中添加“权重”；具有最高加和的节点是最优选的"}
        self.preferred_during_scheduling_ignored_during_execution = preferred_during_scheduling_ignored_during_execution
        # {"en": "If the anti-affinity requirements specified by this field are not met at scheduling time, the pod will not be scheduled onto the node. If the anti-affinity requirements specified by this field cease to be met at some point during pod execution (e.g. due to a pod label update), the system may or may not try to eventually evict the pod from its node. When there are multiple elements, the lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all terms must be satisfied.", "zh_CN": "如果在调度时不满足该字段指定的反亲和性要求，则该 Pod 不会被调度到该节点上。 如果在 Pod 执行期间的某个时间点不再满足此字段指定的反亲和性要求（例如：由于 Pod 标签更新）， 系统可能会或可能不会尝试最终将 Pod 从其节点中逐出。 当有多个元素时，每个 podAffinityTerm 对应的节点列表是取其交集的，即必须满足所有条件"}
        self.required_during_scheduling_ignored_during_execution = required_during_scheduling_ignored_during_execution

    def validate(self):
        if self.preferred_during_scheduling_ignored_during_execution:
            for k in self.preferred_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()
        if self.required_during_scheduling_ignored_during_execution:
            for k in self.required_during_scheduling_ignored_during_execution:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.preferred_during_scheduling_ignored_during_execution is not None:
            result['preferredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.preferred_during_scheduling_ignored_during_execution:
                result['preferredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        if self.required_during_scheduling_ignored_during_execution is not None:
            result['requiredDuringSchedulingIgnoredDuringExecution'] = []
            for k in self.required_during_scheduling_ignored_during_execution:
                result['requiredDuringSchedulingIgnoredDuringExecution'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preferredDuringSchedulingIgnoredDuringExecution') is not None:
            self.preferred_during_scheduling_ignored_during_execution = []
            for k in m.get('preferredDuringSchedulingIgnoredDuringExecution'):
                temp_model = PatchJobIoK8sApiCoreV1WeightedPodAffinityTerm()
                self.preferred_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        if m.get('requiredDuringSchedulingIgnoredDuringExecution') is not None:
            self.required_during_scheduling_ignored_during_execution = []
            for k in m.get('requiredDuringSchedulingIgnoredDuringExecution'):
                temp_model = PatchJobIoK8sApiCoreV1PodAffinityTerm()
                self.required_during_scheduling_ignored_during_execution.append(temp_model.from_map(k))
        return self


class PatchJobIoK8sApiCoreV1Affinity(TeaModel):
    def __init__(
        self,
        node_affinity: PatchJobIoK8sApiCoreV1NodeAffinity = None,
        pod_affinity: PatchJobIoK8sApiCoreV1PodAffinity = None,
        pod_anti_affinity: PatchJobIoK8sApiCoreV1PodAntiAffinity = None,
    ):
        # {"en": "Describes node affinity scheduling rules for the pod.", "zh_CN": "描述 Pod 的节点亲和性调度规则"}
        self.node_affinity = node_affinity
        # {"en": "Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).", "zh_CN": "描述 Pod 亲和性调度规则（例如，将此 Pod 与其他一些 Pod 放在同一节点、区域等）"}
        self.pod_affinity = pod_affinity
        # {"en": "Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).", "zh_CN": "描述 Pod 反亲和性调度规则（例如，避免将此 Pod 与其他一些 Pod 放在相同的节点、区域等）"}
        self.pod_anti_affinity = pod_anti_affinity

    def validate(self):
        if self.node_affinity:
            self.node_affinity.validate()
        if self.pod_affinity:
            self.pod_affinity.validate()
        if self.pod_anti_affinity:
            self.pod_anti_affinity.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_affinity is not None:
            result['nodeAffinity'] = self.node_affinity.to_map()
        if self.pod_affinity is not None:
            result['podAffinity'] = self.pod_affinity.to_map()
        if self.pod_anti_affinity is not None:
            result['podAntiAffinity'] = self.pod_anti_affinity.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nodeAffinity') is not None:
            temp_model = PatchJobIoK8sApiCoreV1NodeAffinity()
            self.node_affinity = temp_model.from_map(m['nodeAffinity'])
        if m.get('podAffinity') is not None:
            temp_model = PatchJobIoK8sApiCoreV1PodAffinity()
            self.pod_affinity = temp_model.from_map(m['podAffinity'])
        if m.get('podAntiAffinity') is not None:
            temp_model = PatchJobIoK8sApiCoreV1PodAntiAffinity()
            self.pod_anti_affinity = temp_model.from_map(m['podAntiAffinity'])
        return self


class PatchJobIoK8sApiCoreV1ConfigMapKeySelector(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "The key to select.", "zh_CN": "要选择的主键"}
        self.key = key
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用者的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its key must be defined", "zh_CN": "指定 ConfigMap 或其主键是否必须已经定义"}
        self.optional = optional

    def validate(self):
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class PatchJobIoK8sApiCoreV1ObjectFieldSelector(TeaModel):
    def __init__(
        self,
        api_version: str = None,
        field_path: str = None,
    ):
        # {"en": "Version of the schema the FieldPath is written in terms of, defaults to v1.", "zh_CN": "fieldPath 写入时所使用的模式版本，默认为 v1"}
        self.api_version = api_version
        # {"en": "Path of the field to select in the specified API version.", "zh_CN": "在指定 API 版本中要选择的字段的路径"}
        self.field_path = field_path

    def validate(self):
        self.validate_required(self.field_path, 'field_path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.field_path is not None:
            result['fieldPath'] = self.field_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('fieldPath') is not None:
            self.field_path = m.get('fieldPath')
        return self


class PatchJobIoK8sApiCoreV1ResourceFieldSelector(TeaModel):
    def __init__(
        self,
        container_name: str = None,
        divisor: str = None,
        resource: str = None,
    ):
        # {"en": "Container name: required for volumes, optional for env vars", "zh_CN": "容器名称：对卷必选，对环境变量可选"}
        self.container_name = container_name
        # {"en": "Specifies the output format of the exposed resources, defaults to 1", "zh_CN": "指定所曝光资源的输出格式，默认值为“1”"}
        self.divisor = divisor
        # {"en": "Required: resource to select", "zh_CN": "必选：选择的资源"}
        self.resource = resource

    def validate(self):
        self.validate_required(self.resource, 'resource')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_name is not None:
            result['containerName'] = self.container_name
        if self.divisor is not None:
            result['divisor'] = self.divisor
        if self.resource is not None:
            result['resource'] = self.resource
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containerName') is not None:
            self.container_name = m.get('containerName')
        if m.get('divisor') is not None:
            self.divisor = m.get('divisor')
        if m.get('resource') is not None:
            self.resource = m.get('resource')
        return self


class PatchJobIoK8sApiCoreV1SecretKeySelector(TeaModel):
    def __init__(
        self,
        key: str = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "The key of the secret to select from.  Must be a valid secret key.", "zh_CN": "要选择的 Secret 的主键。必须是有效的主键"}
        self.key = key
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用 Secret 的名称"}
        self.name = name
        # {"en": "Specify whether the Secret or its key must be defined", "zh_CN": "指定 Secret 或其主键是否必须已经定义"}
        self.optional = optional

    def validate(self):
        self.validate_required(self.key, 'key')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class PatchJobIoK8sApiCoreV1EnvVarSource(TeaModel):
    def __init__(
        self,
        config_map_key_ref: PatchJobIoK8sApiCoreV1ConfigMapKeySelector = None,
        field_ref: PatchJobIoK8sApiCoreV1ObjectFieldSelector = None,
        resource_field_ref: PatchJobIoK8sApiCoreV1ResourceFieldSelector = None,
        secret_key_ref: PatchJobIoK8sApiCoreV1SecretKeySelector = None,
    ):
        # {"en": "Selects a key of a ConfigMap.", "zh_CN": "选择某个 ConfigMap 的一个主键"}
        self.config_map_key_ref = config_map_key_ref
        # {"en": "Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.", "zh_CN": "选择 Pod 的一个字段：支持 metadata.name、metadata.namespace、metadata.labels['<KEY>']、 metadata.annotations['<KEY>']、spec.nodeName、spec.serviceAccountName、status.hostIP status.podIP、status.podIPs"}
        self.field_ref = field_ref
        # {"en": "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.", "zh_CN": "选择容器的资源：目前仅支持资源限制和请求（limits.cpu、limits.memory、limits.ephemeral-storage、 requests.cpu、requests.memory 和 requests.ephemeral-storage）"}
        self.resource_field_ref = resource_field_ref
        # {"en": "Selects a key of a secret in the pod's namespace", "zh_CN": "在 Pod 的名字空间中选择 Secret 的主键"}
        self.secret_key_ref = secret_key_ref

    def validate(self):
        if self.config_map_key_ref:
            self.config_map_key_ref.validate()
        if self.field_ref:
            self.field_ref.validate()
        if self.resource_field_ref:
            self.resource_field_ref.validate()
        if self.secret_key_ref:
            self.secret_key_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_key_ref is not None:
            result['configMapKeyRef'] = self.config_map_key_ref.to_map()
        if self.field_ref is not None:
            result['fieldRef'] = self.field_ref.to_map()
        if self.resource_field_ref is not None:
            result['resourceFieldRef'] = self.resource_field_ref.to_map()
        if self.secret_key_ref is not None:
            result['secretKeyRef'] = self.secret_key_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMapKeyRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ConfigMapKeySelector()
            self.config_map_key_ref = temp_model.from_map(m['configMapKeyRef'])
        if m.get('fieldRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ObjectFieldSelector()
            self.field_ref = temp_model.from_map(m['fieldRef'])
        if m.get('resourceFieldRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ResourceFieldSelector()
            self.resource_field_ref = temp_model.from_map(m['resourceFieldRef'])
        if m.get('secretKeyRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SecretKeySelector()
            self.secret_key_ref = temp_model.from_map(m['secretKeyRef'])
        return self


class PatchJobIoK8sApiCoreV1EnvVar(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
        value_from: PatchJobIoK8sApiCoreV1EnvVarSource = None,
    ):
        # {"en": "Name of the environment variable. Must be a C_IDENTIFIER.", "zh_CN": "环境变量的名称。必须是 C_IDENTIFIER"}
        self.name = name
        # {"en": "Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to ''.", "zh_CN": "变量引用 $(VAR_NAME) 使用容器中先前定义的环境变量和任何服务环境变量进行扩展。 如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 会被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。默认为 “”"}
        self.value = value
        # {"en": "Source for the environment variable's value. Cannot be used if value is not empty.", "zh_CN": "环境变量值的来源。如果 value 值不为空，则不能使用"}
        self.value_from = value_from

    def validate(self):
        self.validate_required(self.name, 'name')
        if self.value_from:
            self.value_from.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        if self.value_from is not None:
            result['valueFrom'] = self.value_from.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        if m.get('valueFrom') is not None:
            temp_model = PatchJobIoK8sApiCoreV1EnvVarSource()
            self.value_from = temp_model.from_map(m['valueFrom'])
        return self


class PatchJobIoK8sApiCoreV1ConfigMapEnvSource(TeaModel):
    def __init__(
        self,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用的 ConfigMap 的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap must be defined", "zh_CN": "指定 ConfigMap 是否必须已经定义"}
        self.optional = optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class PatchJobIoK8sApiCoreV1SecretEnvSource(TeaModel):
    def __init__(
        self,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用 Secret 的名称"}
        self.name = name
        # {"en": "Specify whether the Secret must be defined", "zh_CN": "指定 Secret 是否必须已经定义"}
        self.optional = optional

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class PatchJobIoK8sApiCoreV1EnvFromSource(TeaModel):
    def __init__(
        self,
        config_map_ref: PatchJobIoK8sApiCoreV1ConfigMapEnvSource = None,
        prefix: str = None,
        secret_ref: PatchJobIoK8sApiCoreV1SecretEnvSource = None,
    ):
        # {"en": "The ConfigMap to select from", "zh_CN": "要从中选择主键的 ConfigMap"}
        self.config_map_ref = config_map_ref
        # {"en": "An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.", "zh_CN": "附加到 ConfigMap 中每个键名之前的可选标识符。必须是 C_IDENTIFIER"}
        self.prefix = prefix
        # {"en": "The Secret to select from", "zh_CN": "要从中选择主键的 Secret"}
        self.secret_ref = secret_ref

    def validate(self):
        if self.config_map_ref:
            self.config_map_ref.validate()
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_ref is not None:
            result['configMapRef'] = self.config_map_ref.to_map()
        if self.prefix is not None:
            result['prefix'] = self.prefix
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('configMapRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ConfigMapEnvSource()
            self.config_map_ref = temp_model.from_map(m['configMapRef'])
        if m.get('prefix') is not None:
            self.prefix = m.get('prefix')
        if m.get('secretRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SecretEnvSource()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        return self


class PatchJobIoK8sApiCoreV1ExecAction(TeaModel):
    def __init__(
        self,
        command: List[str] = None,
    ):
        # {"en": "Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.", "zh_CN": "要在容器内执行的命令行，命令的工作目录是容器文件系统中的根目录（'/'）。 该命令只是被通过 exec 执行，而不会单独启动一个 Shell 来运行，因此传统的 Shell 指令（'|' 等）将不起作用。要使用某 Shell，你需要显式调用该 Shell。 退出状态 0 被视为活动/健康，非零表示不健康"}
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('command') is not None:
            self.command = m.get('command')
        return self


class PatchJobIoK8sApiCoreV1HTTPHeader(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "The header field name", "zh_CN": "HTTP 头部字段名称"}
        self.name = name
        # {"en": "The header field value", "zh_CN": "HTTP 头部字段取值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PatchJobIoK8sApiCoreV1HTTPGetAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        http_headers: List[PatchJobIoK8sApiCoreV1HTTPHeader] = None,
        path: str = None,
        port: str = None,
        scheme: str = None,
    ):
        # {"en": "Host name to connect to, defaults to the pod IP. You probably want to set Host in httpHeaders instead.", "zh_CN": "要连接的主机名，默认为 Pod IP。你可能想在 httpHeaders 中设置 Host"}
        self.host = host
        # {"en": "Custom headers to set in the request. HTTP allows repeated headers.", "zh_CN": "要在请求中设置的自定义 HTTP 标头。HTTP 允许重复的标头"}
        self.http_headers = http_headers
        # {"en": "Path to access on the HTTP server.", "zh_CN": "HTTP 服务器上的访问路径"}
        self.path = path
        # {"en": "Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.", "zh_CN": "容器上要访问的端口的名称或端口号。端口号必须在 1 到 65535 内。名称必须是 IANA_SVC_NAME"}
        self.port = port
        # {"en": "Scheme to use for connecting to the host. Defaults to HTTP.", "zh_CN": "用于连接到主机的方案。默认为 HTTP"}
        self.scheme = scheme

    def validate(self):
        if self.http_headers:
            for k in self.http_headers:
                if k:
                    k.validate()
        self.validate_required(self.port, 'port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.http_headers is not None:
            result['httpHeaders'] = []
            for k in self.http_headers:
                result['httpHeaders'].append(k.to_map() if k else None)
        if self.path is not None:
            result['path'] = self.path
        if self.port is not None:
            result['port'] = self.port
        if self.scheme is not None:
            result['scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('httpHeaders') is not None:
            self.http_headers = []
            for k in m.get('httpHeaders'):
                temp_model = PatchJobIoK8sApiCoreV1HTTPHeader()
                self.http_headers.append(temp_model.from_map(k))
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('scheme') is not None:
            self.scheme = m.get('scheme')
        return self


class PatchJobIoK8sApiCoreV1TCPSocketAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        port: str = None,
    ):
        # {"en": "Optional: Host name to connect to, defaults to the pod IP.", "zh_CN": "可选字段。要连接的主机名，默认为 Pod IP"}
        self.host = host
        # {"en": "Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.", "zh_CN": "容器上要访问的端口的编号或名称。端口号必须在 1 到 65535 的范围内。 名称必须是 IANA_SVC_NAME"}
        self.port = port

    def validate(self):
        self.validate_required(self.port, 'port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['host'] = self.host
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('host') is not None:
            self.host = m.get('host')
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class PatchJobIoK8sApiCoreV1Handler(TeaModel):
    def __init__(
        self,
        exec: PatchJobIoK8sApiCoreV1ExecAction = None,
        http_get: PatchJobIoK8sApiCoreV1HTTPGetAction = None,
        tcp_socket: PatchJobIoK8sApiCoreV1TCPSocketAction = None,
    ):
        # {"en": "One and only one of the following should be specified. Exec specifies the action to take.", "zh_CN": "指定要执行的操作"}
        self.exec = exec
        # {"en": "HTTPGet specifies the http request to perform.", "zh_CN": "指定要执行的 HTTP 请求"}
        self.http_get = http_get
        # {"en": "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported", "zh_CN": "已弃用。不再支持 tcpSocket 作为 LifecycleHandler，但为向后兼容保留之。 当指定 tcp 处理程序时，此字段不会被验证，而生命周期回调将在运行时失败"}
        self.tcp_socket = tcp_socket

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['exec'] = self.exec.to_map()
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ExecAction()
            self.exec = temp_model.from_map(m['exec'])
        if m.get('httpGet') is not None:
            temp_model = PatchJobIoK8sApiCoreV1HTTPGetAction()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('tcpSocket') is not None:
            temp_model = PatchJobIoK8sApiCoreV1TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        return self


class PatchJobIoK8sApiCoreV1Lifecycle(TeaModel):
    def __init__(
        self,
        post_start: PatchJobIoK8sApiCoreV1Handler = None,
        pre_stop: PatchJobIoK8sApiCoreV1Handler = None,
    ):
        # {"en": "PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks", "zh_CN": "创建容器后立即调用 postStart。如果处理程序失败，则容器将根据其重新启动策略终止并重新启动。 容器的其他管理阻塞直到钩子完成"}
        self.post_start = post_start
        # {"en": "PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks", "zh_CN": "preStop 在容器因 API 请求或管理事件（如存活态探针/启动探针失败、抢占、资源争用等）而终止之前立即调用。 如果容器崩溃或退出，则不会调用处理程序。Pod 的终止宽限期倒计时在 preStop 钩子执行之前开始。 无论处理程序的结果如何，容器最终都会在 Pod 的终止宽限期内终止（除非被终结器延迟）。 容器的其他管理会阻塞，直到钩子完成或达到终止宽限期"}
        self.pre_stop = pre_stop

    def validate(self):
        if self.post_start:
            self.post_start.validate()
        if self.pre_stop:
            self.pre_stop.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.post_start is not None:
            result['postStart'] = self.post_start.to_map()
        if self.pre_stop is not None:
            result['preStop'] = self.pre_stop.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('postStart') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Handler()
            self.post_start = temp_model.from_map(m['postStart'])
        if m.get('preStop') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Handler()
            self.pre_stop = temp_model.from_map(m['preStop'])
        return self


class PatchJobIoK8sApiCoreV1Probe(TeaModel):
    def __init__(
        self,
        exec: PatchJobIoK8sApiCoreV1ExecAction = None,
        failure_threshold: int = None,
        http_get: PatchJobIoK8sApiCoreV1HTTPGetAction = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        success_threshold: int = None,
        tcp_socket: PatchJobIoK8sApiCoreV1TCPSocketAction = None,
        timeout_seconds: int = None,
    ):
        # {"en": "One and only one of the following should be specified. Exec specifies the action to take.", "zh_CN": "指定要执行的操作"}
        self.exec = exec
        # {"en": "Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.", "zh_CN": "探针成功后的最小连续失败次数，超出此阈值则认为探针失败。默认为 3。最小值为 1"}
        self.failure_threshold = failure_threshold
        # {"en": "HTTPGet specifies the http request to perform.", "zh_CN": "指定要执行的 HTTP 请求"}
        self.http_get = http_get
        # {"en": "Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "容器启动后启动存活态探针之前的秒数"}
        self.initial_delay_seconds = initial_delay_seconds
        # {"en": "How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.", "zh_CN": "探针的执行周期（以秒为单位）。默认为 10 秒。最小值为 1"}
        self.period_seconds = period_seconds
        # {"en": "Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.", "zh_CN": "探针失败后最小连续成功次数，超过此阈值才会被视为探针成功。默认为 1。 存活性探针和启动探针必须为 1。最小值为 1"}
        self.success_threshold = success_threshold
        # {"en": "TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported", "zh_CN": "tcpSocket 指定涉及 TCP 端口的操作"}
        self.tcp_socket = tcp_socket
        # {"en": "Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "探针超时的秒数。默认为 1 秒。最小值为 1"}
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.exec:
            self.exec.validate()
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exec is not None:
            result['exec'] = self.exec.to_map()
        if self.failure_threshold is not None:
            result['failureThreshold'] = self.failure_threshold
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.initial_delay_seconds is not None:
            result['initialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['periodSeconds'] = self.period_seconds
        if self.success_threshold is not None:
            result['successThreshold'] = self.success_threshold
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        if self.timeout_seconds is not None:
            result['timeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('exec') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ExecAction()
            self.exec = temp_model.from_map(m['exec'])
        if m.get('failureThreshold') is not None:
            self.failure_threshold = m.get('failureThreshold')
        if m.get('httpGet') is not None:
            temp_model = PatchJobIoK8sApiCoreV1HTTPGetAction()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('initialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('initialDelaySeconds')
        if m.get('periodSeconds') is not None:
            self.period_seconds = m.get('periodSeconds')
        if m.get('successThreshold') is not None:
            self.success_threshold = m.get('successThreshold')
        if m.get('tcpSocket') is not None:
            temp_model = PatchJobIoK8sApiCoreV1TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        if m.get('timeoutSeconds') is not None:
            self.timeout_seconds = m.get('timeoutSeconds')
        return self


class PatchJobIoK8sApiCoreV1ContainerPort(TeaModel):
    def __init__(
        self,
        container_port: int = None,
        host_ip: str = None,
        host_port: int = None,
        name: str = None,
        protocol: str = None,
    ):
        # {"en": "Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.", "zh_CN": "要在 Pod 的 IP 地址上公开的端口号。这必须是有效的端口号，0 < x < 65536"}
        self.container_port = container_port
        # {"en": "What host IP to bind the external port to.", "zh_CN": "绑定外部端口的主机 IP"}
        self.host_ip = host_ip
        # {"en": "Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.", "zh_CN": "要在主机上公开的端口号。如果指定，此字段必须是一个有效的端口号，0 < x < 65536。 如果设置了 hostNetwork，此字段值必须与 containerPort 匹配。大多数容器不需要设置此字段"}
        self.host_port = host_port
        # {"en": "If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.", "zh_CN": "如果设置此字段，这必须是 IANA_SVC_NAME 并且在 Pod 中唯一。 Pod 中的每个命名端口都必须具有唯一的名称。服务可以引用的端口的名称"}
        self.name = name
        # {"en": "Protocol for port. Must be UDP, TCP, or SCTP. Defaults to TCP.", "zh_CN": "端口协议。必须是 UDP、TCP 或 SCTP。默认为 TCP"}
        self.protocol = protocol

    def validate(self):
        self.validate_required(self.container_port, 'container_port')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_port is not None:
            result['containerPort'] = self.container_port
        if self.host_ip is not None:
            result['hostIP'] = self.host_ip
        if self.host_port is not None:
            result['hostPort'] = self.host_port
        if self.name is not None:
            result['name'] = self.name
        if self.protocol is not None:
            result['protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('containerPort') is not None:
            self.container_port = m.get('containerPort')
        if m.get('hostIP') is not None:
            self.host_ip = m.get('hostIP')
        if m.get('hostPort') is not None:
            self.host_port = m.get('hostPort')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        return self


class PatchJobIoK8sApiCoreV1ResourceRequirements(TeaModel):
    def __init__(
        self,
        limits: Dict[str, Any] = None,
        requests: Dict[str, Any] = None,
    ):
        # {"en": "Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "limits 描述所允许的最大计算资源量"}
        self.limits = limits
        # {"en": "Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "requests 描述所需的最小计算资源量。如果对容器省略了 requests，则默认其资源请求值为 limits （如果已显式指定）的值，否则为实现定义的值。请求不能超过限制"}
        self.requests = requests

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.limits is not None:
            result['limits'] = self.limits
        if self.requests is not None:
            result['requests'] = self.requests
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('limits') is not None:
            self.limits = m.get('limits')
        if m.get('requests') is not None:
            self.requests = m.get('requests')
        return self


class PatchJobIoK8sApiCoreV1Capabilities(TeaModel):
    def __init__(
        self,
        add: List[str] = None,
        drop: List[str] = None,
    ):
        # {"en": "Added capabilities", "zh_CN": "新增权能"}
        self.add = add
        # {"en": "Removed capabilities", "zh_CN": "放弃权能"}
        self.drop = drop

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.add is not None:
            result['add'] = self.add
        if self.drop is not None:
            result['drop'] = self.drop
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('add') is not None:
            self.add = m.get('add')
        if m.get('drop') is not None:
            self.drop = m.get('drop')
        return self


class PatchJobIoK8sApiCoreV1SELinuxOptions(TeaModel):
    def __init__(
        self,
        level: str = None,
        role: str = None,
        type: str = None,
        user: str = None,
    ):
        # {"en": "Level is SELinux level label that applies to the container.", "zh_CN": "应用于容器的 SELinux 级别标签"}
        self.level = level
        # {"en": "Role is a SELinux role label that applies to the container.", "zh_CN": "应用于容器的 SELinux 角色标签"}
        self.role = role
        # {"en": "Type is a SELinux type label that applies to the container.", "zh_CN": "适用于容器的 SELinux 类型标签"}
        self.type = type
        # {"en": "User is a SELinux user label that applies to the container.", "zh_CN": "应用于容器的 SELinux 用户标签"}
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.level is not None:
            result['level'] = self.level
        if self.role is not None:
            result['role'] = self.role
        if self.type is not None:
            result['type'] = self.type
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('level') is not None:
            self.level = m.get('level')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class PatchJobIoK8sApiCoreV1SeccompProfile(TeaModel):
    def __init__(
        self,
        localhost_profile: str = None,
        type: str = None,
    ):
        # {"en": "localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is Localhost.", "zh_CN": "localhostProfile 指示应使用在节点上的文件中定义的配置文件。 该配置文件必须在节点上预先配置才能工作。 必须是相对于 kubelet 配置的 seccomp 配置文件位置下的子路径。 仅当 type 为 Localhost 时才必须设置"}
        self.localhost_profile = localhost_profile
        # {"en": "type indicates which kind of seccomp profile will be applied. Valid options are: Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.", "zh_CN": "type 指示将应用哪种 seccomp 配置文件。有效的选项是：Localhost - 应使用在节点上的文件中定义的配置文件。RuntimeDefault - 应使用容器运行时默认配置文件。Unconfined - 不应应用任何配置文件"}
        self.type = type

    def validate(self):
        self.validate_required(self.type, 'type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.localhost_profile is not None:
            result['localhostProfile'] = self.localhost_profile
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('localhostProfile') is not None:
            self.localhost_profile = m.get('localhostProfile')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PatchJobIoK8sApiCoreV1WindowsSecurityContextOptions(TeaModel):
    def __init__(
        self,
        gmsa_credential_spec: str = None,
        gmsa_credential_spec_name: str = None,
        run_as_user_name: str = None,
    ):
        # {"en": "GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.", "zh_CN": "gmsaCredentialSpec 是 GMSA 准入 Webhook 内嵌由 gmsaCredentialSpecName 字段所指定的 GMSA 凭证规约内容的地方"}
        self.gmsa_credential_spec = gmsa_credential_spec
        # {"en": "GMSACredentialSpecName is the name of the GMSA credential spec to use.", "zh_CN": "gmsaCredentialSpecName 是要使用的 GMSA 凭证规约的名称"}
        self.gmsa_credential_spec_name = gmsa_credential_spec_name
        # {"en": "The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "Windows 中运行容器进程入口点的用户名。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 PodSecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_user_name = run_as_user_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gmsa_credential_spec is not None:
            result['gmsaCredentialSpec'] = self.gmsa_credential_spec
        if self.gmsa_credential_spec_name is not None:
            result['gmsaCredentialSpecName'] = self.gmsa_credential_spec_name
        if self.run_as_user_name is not None:
            result['runAsUserName'] = self.run_as_user_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('gmsaCredentialSpec') is not None:
            self.gmsa_credential_spec = m.get('gmsaCredentialSpec')
        if m.get('gmsaCredentialSpecName') is not None:
            self.gmsa_credential_spec_name = m.get('gmsaCredentialSpecName')
        if m.get('runAsUserName') is not None:
            self.run_as_user_name = m.get('runAsUserName')
        return self


class PatchJobIoK8sApiCoreV1SecurityContext(TeaModel):
    def __init__(
        self,
        allow_privilege_escalation: bool = None,
        capabilities: PatchJobIoK8sApiCoreV1Capabilities = None,
        privileged: bool = None,
        proc_mount: str = None,
        read_only_root_filesystem: bool = None,
        run_as_group: int = None,
        run_as_non_root: bool = None,
        run_as_user: int = None,
        se_linux_options: PatchJobIoK8sApiCoreV1SELinuxOptions = None,
        seccomp_profile: PatchJobIoK8sApiCoreV1SeccompProfile = None,
        windows_options: PatchJobIoK8sApiCoreV1WindowsSecurityContextOptions = None,
    ):
        # {"en": "AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN", "zh_CN": "allowPrivilegeEscalation 控制进程是否可以获得比其父进程更多的权限。此布尔值直接控制是否在容器进程上设置 no_new_privs 标志。allowPrivilegeEscalation 在容器处于以下状态时始终为 true：- 以特权身份运行- 具有 CAP_SYS_ADMIN。请注意，当 spec.os.name 为 windows 时，无法设置此字段"}
        self.allow_privilege_escalation = allow_privilege_escalation
        # {"en": "The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.", "zh_CN": "运行容器时添加或放弃的权能（Capabilities）。默认为容器运行时所授予的权能集合。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.capabilities = capabilities
        # {"en": "Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.", "zh_CN": "以特权模式运行容器。特权容器中的进程本质上等同于主机上的 root。默认为 false。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.privileged = privileged
        # {"en": "procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.", "zh_CN": "procMount 表示用于容器的 proc 挂载类型。默认值为 DefaultProcMount， 它针对只读路径和掩码路径使用容器运行时的默认值。此字段需要启用 ProcMountType 特性门控。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.proc_mount = proc_mount
        # {"en": "Whether this container has a read-only root filesystem. Default is false.", "zh_CN": "此容器是否具有只读根文件系统。默认为 false。注意，spec.os.name 为 windows 时不能设置该字段"}
        self.read_only_root_filesystem = read_only_root_filesystem
        # {"en": "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "运行容器进程入口点的 GID。如果未设置，则使用运行时默认值。也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_group = run_as_group
        # {"en": "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "指示容器必须以非 root 用户身份运行。 如果为 true，kubelet 将在运行时验证镜像，以确保它不会以 UID 0（root）身份运行，如果是，则无法启动容器。 如果未设置或为 false，则不会执行此类验证。也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_non_root = run_as_non_root
        # {"en": "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "运行容器进程入口点的 UID。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 PodSecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_user = run_as_user
        # {"en": "The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用到容器上的 SELinux 上下文。如果未设置此字段，容器运行时将为每个容器分配一个随机的 SELinux 上下文。 也可以在 PodSecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置， 则在 SecurityContext 中指定的值优先。注意，spec.os.name 为 windows 时不能设置此字段"}
        self.se_linux_options = se_linux_options
        # {"en": "The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.", "zh_CN": "此容器使用的 seccomp 选项。如果在 Pod 和容器级别都提供了 seccomp 选项，则容器级别的选项会覆盖 Pod 级别的选项设置。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.seccomp_profile = seccomp_profile
        # {"en": "The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用于所有容器上的特定于 Windows 的设置。如果未指定，将使用 PodSecurityContext 中的选项。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 linux 时不能设置此字段"}
        self.windows_options = windows_options

    def validate(self):
        if self.capabilities:
            self.capabilities.validate()
        if self.se_linux_options:
            self.se_linux_options.validate()
        if self.seccomp_profile:
            self.seccomp_profile.validate()
        if self.windows_options:
            self.windows_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_privilege_escalation is not None:
            result['allowPrivilegeEscalation'] = self.allow_privilege_escalation
        if self.capabilities is not None:
            result['capabilities'] = self.capabilities.to_map()
        if self.privileged is not None:
            result['privileged'] = self.privileged
        if self.proc_mount is not None:
            result['procMount'] = self.proc_mount
        if self.read_only_root_filesystem is not None:
            result['readOnlyRootFilesystem'] = self.read_only_root_filesystem
        if self.run_as_group is not None:
            result['runAsGroup'] = self.run_as_group
        if self.run_as_non_root is not None:
            result['runAsNonRoot'] = self.run_as_non_root
        if self.run_as_user is not None:
            result['runAsUser'] = self.run_as_user
        if self.se_linux_options is not None:
            result['seLinuxOptions'] = self.se_linux_options.to_map()
        if self.seccomp_profile is not None:
            result['seccompProfile'] = self.seccomp_profile.to_map()
        if self.windows_options is not None:
            result['windowsOptions'] = self.windows_options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('allowPrivilegeEscalation') is not None:
            self.allow_privilege_escalation = m.get('allowPrivilegeEscalation')
        if m.get('capabilities') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Capabilities()
            self.capabilities = temp_model.from_map(m['capabilities'])
        if m.get('privileged') is not None:
            self.privileged = m.get('privileged')
        if m.get('procMount') is not None:
            self.proc_mount = m.get('procMount')
        if m.get('readOnlyRootFilesystem') is not None:
            self.read_only_root_filesystem = m.get('readOnlyRootFilesystem')
        if m.get('runAsGroup') is not None:
            self.run_as_group = m.get('runAsGroup')
        if m.get('runAsNonRoot') is not None:
            self.run_as_non_root = m.get('runAsNonRoot')
        if m.get('runAsUser') is not None:
            self.run_as_user = m.get('runAsUser')
        if m.get('seLinuxOptions') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SELinuxOptions()
            self.se_linux_options = temp_model.from_map(m['seLinuxOptions'])
        if m.get('seccompProfile') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SeccompProfile()
            self.seccomp_profile = temp_model.from_map(m['seccompProfile'])
        if m.get('windowsOptions') is not None:
            temp_model = PatchJobIoK8sApiCoreV1WindowsSecurityContextOptions()
            self.windows_options = temp_model.from_map(m['windowsOptions'])
        return self


class PatchJobIoK8sApiCoreV1VolumeDevice(TeaModel):
    def __init__(
        self,
        device_path: str = None,
        name: str = None,
    ):
        # {"en": "devicePath is the path inside of the container that the device will be mapped to.", "zh_CN": "设备将被映射到的容器内的路径"}
        self.device_path = device_path
        # {"en": "name must match the name of a persistentVolumeClaim in the pod", "zh_CN": "name 必须与 Pod 中的 persistentVolumeClaim 的名称匹配"}
        self.name = name

    def validate(self):
        self.validate_required(self.device_path, 'device_path')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.device_path is not None:
            result['devicePath'] = self.device_path
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('devicePath') is not None:
            self.device_path = m.get('devicePath')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class PatchJobIoK8sApiCoreV1VolumeMount(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        mount_propagation: str = None,
        name: str = None,
        read_only: bool = None,
        sub_path: str = None,
        sub_path_expr: str = None,
    ):
        # {"en": "Path within the container at which the volume should be mounted.  Must not contain ':'.", "zh_CN": "容器内应安装卷的路径。不得包含 ':'"}
        self.mount_path = mount_path
        # {"en": "mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.", "zh_CN": "mountPropagation 确定装载如何从主机传播到容器，及反向传播选项。 如果未设置，则使用 None。此字段在 1.10 中为 Beta 字段"}
        self.mount_propagation = mount_propagation
        # {"en": "This must match the Name of a Volume.", "zh_CN": "此字段必须与卷的名称匹配"}
        self.name = name
        # {"en": "Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.", "zh_CN": "如果为 true，则挂载卷为只读，否则为读写（false 或未指定）。默认值为 false"}
        self.read_only = read_only
        # {"en": "Path within the volume from which the container's volume should be mounted. Defaults to  (volume's root).", "zh_CN": "卷中的路径名，应该从该路径挂在容器的卷。默认为 “” （卷的根）"}
        self.sub_path = sub_path
        # {"en": "Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to  (volume's root). SubPathExpr and SubPath are mutually exclusive.", "zh_CN": "应安装容器卷的卷内的扩展路径。行为类似于 subPath，但环境变量引用 $(VAR_NAME) 使用容器的环境进行扩展。默认为 “”（卷的根）。subPathExpr 和 SubPath 是互斥的"}
        self.sub_path_expr = sub_path_expr

    def validate(self):
        self.validate_required(self.mount_path, 'mount_path')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['mountPath'] = self.mount_path
        if self.mount_propagation is not None:
            result['mountPropagation'] = self.mount_propagation
        if self.name is not None:
            result['name'] = self.name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.sub_path is not None:
            result['subPath'] = self.sub_path
        if self.sub_path_expr is not None:
            result['subPathExpr'] = self.sub_path_expr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('mountPath') is not None:
            self.mount_path = m.get('mountPath')
        if m.get('mountPropagation') is not None:
            self.mount_propagation = m.get('mountPropagation')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('subPath') is not None:
            self.sub_path = m.get('subPath')
        if m.get('subPathExpr') is not None:
            self.sub_path_expr = m.get('subPathExpr')
        return self


class PatchJobIoK8sApiCoreV1Container(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
        env: List[PatchJobIoK8sApiCoreV1EnvVar] = None,
        env_from: List[PatchJobIoK8sApiCoreV1EnvFromSource] = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle: PatchJobIoK8sApiCoreV1Lifecycle = None,
        liveness_probe: PatchJobIoK8sApiCoreV1Probe = None,
        name: str = None,
        ports: List[PatchJobIoK8sApiCoreV1ContainerPort] = None,
        readiness_probe: PatchJobIoK8sApiCoreV1Probe = None,
        resources: PatchJobIoK8sApiCoreV1ResourceRequirements = None,
        security_context: PatchJobIoK8sApiCoreV1SecurityContext = None,
        startup_probe: PatchJobIoK8sApiCoreV1Probe = None,
        stdin: bool = None,
        stdin_once: bool = None,
        termination_message_path: str = None,
        termination_message_policy: str = None,
        tty: bool = None,
        volume_devices: List[PatchJobIoK8sApiCoreV1VolumeDevice] = None,
        volume_mounts: List[PatchJobIoK8sApiCoreV1VolumeMount] = None,
        working_dir: str = None,
    ):
        # {"en": "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "entrypoint 的参数。如果未提供，则使用容器镜像的 CMD 设置。变量引用 $(VAR_NAME) 使用容器的环境进行扩展。 如果无法解析变量，则输入字符串中的引用将保持不变。$$ 被简化为 $，这允许转义 $(VAR_NAME) 语法： 即 “$$(VAR_NAME)” 将产生字符串字面值 “$(VAR_NAME)”。无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.args = args
        # {"en": "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "入口点数组。不在 Shell 中执行。如果未提供，则使用容器镜像的 ENTRYPOINT。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 “$$(VAR_NAME)” 将产生字符串字面值 “$(VAR_NAME)”。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.command = command
        # {"en": "List of environment variables to set in the container. Cannot be updated.", "zh_CN": "要在容器中设置的环境变量列表。无法更新"}
        self.env = env
        # {"en": "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.", "zh_CN": "用来在容器中填充环境变量的数据源列表。在源中定义的键必须是 C_IDENTIFIER。 容器启动时，所有无效主键都将作为事件报告。 当一个键存在于多个源中时，与最后一个来源关联的值将优先。 由 env 定义的条目中，与此处键名重复者，以 env 中定义为准。无法更新"}
        self.env_from = env_from
        # {"en": "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.", "zh_CN": "容器镜像名称"}
        self.image = image
        # {"en": "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images", "zh_CN": "镜像拉取策略。Always、Never、IfNotPresent 之一。如果指定了 :latest 标签，则默认为 Always， 否则默认为 IfNotPresent。无法更新"}
        self.image_pull_policy = image_pull_policy
        # {"en": "Actions that the management system should take in response to container lifecycle events. Cannot be updated.", "zh_CN": "管理系统应对容器生命周期事件采取的行动。无法更新"}
        self.lifecycle = lifecycle
        # {"en": "Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "定期探针容器活跃度。如果探针失败，容器将重新启动。无法更新"}
        self.liveness_probe = liveness_probe
        # {"en": "Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.", "zh_CN": "指定为 DNS_LABEL 的容器的名称。Pod 中的每个容器都必须有一个唯一的名称 (DNS_LABEL)。无法更新"}
        self.name = name
        # {"en": "List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default 0.0.0.0 address inside a container will be accessible from the network. Cannot be updated.", "zh_CN": "要从容器暴露的端口列表。此处不指定端口不会阻止该端口被暴露。 任何侦听容器内默认 0.0.0.0 地址的端口都可以从网络访问。使用策略合并补丁来修改此数组可能会破坏数据"}
        self.ports = ports
        # {"en": "Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "定期探测容器服务就绪情况。如果探针失败，容器将被从服务端点中删除。无法更新"}
        self.readiness_probe = readiness_probe
        # {"en": "Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/", "zh_CN": "此容器所需的计算资源。无法更新"}
        self.resources = resources
        # {"en": "Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/", "zh_CN": "SecurityContext 定义了容器应该运行的安全选项。如果设置，SecurityContext 的字段将覆盖 PodSecurityContext 的等效字段"}
        self.security_context = security_context
        # {"en": "StartupProbe indicates that the Pod has successfully initialized. If specified, no other probes are executed until this completes successfully. If this probe fails, the Pod will be restarted, just as if the livenessProbe failed. This can be used to provide different probe parameters at the beginning of a Pod's lifecycle, when it might take a long time to load data or warm a cache, than during steady-state operation. This cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes", "zh_CN": "startupProbe 表示 Pod 已成功初始化。如果设置了此字段，则此探针成功完成之前不会执行其他探针。 如果这个探针失败，Pod 会重新启动，就像存活态探针失败一样。 这可用于在 Pod 生命周期开始时提供不同的探针参数，此时加载数据或预热缓存可能需要比稳态操作期间更长的时间。 这无法更新"}
        self.startup_probe = startup_probe
        # {"en": "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.", "zh_CN": "此容器是否应在容器运行时为 stdin 分配缓冲区。如果未设置，从容器中的 stdin 读取将始终导致 EOF。 默认为 false"}
        self.stdin = stdin
        # {"en": "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false", "zh_CN": "容器运行时是否应在某个 attach 打开 stdin 通道后关闭它。当 stdin 为 true 时，stdin 流将在多个 attach 会话中保持打开状态。 如果 stdinOnce 设置为 true，则 stdin 在容器启动时打开，在第一个客户端连接到 stdin 之前为空， 然后保持打开并接受数据，直到客户端断开连接，此时 stdin 关闭并保持关闭直到容器重新启动。 如果此标志为 false，则从 stdin 读取的容器进程将永远不会收到 EOF。默认为 false"}
        self.stdin_once = stdin_once
        # {"en": "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.", "zh_CN": "可选字段。挂载到容器文件系统的一个路径，容器终止消息写入到该路径下的文件中。 写入的消息旨在成为简短的最终状态，例如断言失败消息。如果大于 4096 字节，将被节点截断。 所有容器的总消息长度将限制为 12 KB。默认为 /dev/termination-log。无法更新"}
        self.termination_message_path = termination_message_path
        # {"en": "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.", "zh_CN": "指示应如何填充终止消息。字段值 File 将使用 terminateMessagePath 的内容来填充成功和失败的容器状态消息。 如果终止消息文件为空并且容器因错误退出，FallbackToLogsOnError 将使用容器日志输出的最后一块。 日志输出限制为 2048 字节或 80 行，以较小者为准。默认为 File。无法更新"}
        self.termination_message_policy = termination_message_policy
        # {"en": "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.", "zh_CN": "这个容器是否应该为自己分配一个 TTY，也需要 stdin 为 true。默认为 false"}
        self.tty = tty
        # {"en": "volumeDevices is the list of block devices to be used by the container.", "zh_CN": "容器要使用的块设备列表"}
        self.volume_devices = volume_devices
        # {"en": "Pod volumes to mount into the container's filesystem. Cannot be updated.", "zh_CN": "要挂载到容器文件系统中的 Pod 卷。无法更新"}
        self.volume_mounts = volume_mounts
        # {"en": "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.", "zh_CN": "容器的工作目录。如果未指定，将使用容器运行时的默认值，默认值可能在容器镜像中配置。无法更新"}
        self.working_dir = working_dir

    def validate(self):
        if self.env:
            for k in self.env:
                if k:
                    k.validate()
        if self.env_from:
            for k in self.env_from:
                if k:
                    k.validate()
        if self.lifecycle:
            self.lifecycle.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        self.validate_required(self.name, 'name')
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.resources:
            self.resources.validate()
        if self.security_context:
            self.security_context.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.volume_devices:
            for k in self.volume_devices:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        if self.env is not None:
            result['env'] = []
            for k in self.env:
                result['env'].append(k.to_map() if k else None)
        if self.env_from is not None:
            result['envFrom'] = []
            for k in self.env_from:
                result['envFrom'].append(k.to_map() if k else None)
        if self.image is not None:
            result['image'] = self.image
        if self.image_pull_policy is not None:
            result['imagePullPolicy'] = self.image_pull_policy
        if self.lifecycle is not None:
            result['lifecycle'] = self.lifecycle.to_map()
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.ports is not None:
            result['ports'] = []
            for k in self.ports:
                result['ports'].append(k.to_map() if k else None)
        if self.readiness_probe is not None:
            result['readinessProbe'] = self.readiness_probe.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdin_once is not None:
            result['stdinOnce'] = self.stdin_once
        if self.termination_message_path is not None:
            result['terminationMessagePath'] = self.termination_message_path
        if self.termination_message_policy is not None:
            result['terminationMessagePolicy'] = self.termination_message_policy
        if self.tty is not None:
            result['tty'] = self.tty
        if self.volume_devices is not None:
            result['volumeDevices'] = []
            for k in self.volume_devices:
                result['volumeDevices'].append(k.to_map() if k else None)
        if self.volume_mounts is not None:
            result['volumeMounts'] = []
            for k in self.volume_mounts:
                result['volumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['workingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('env') is not None:
            self.env = []
            for k in m.get('env'):
                temp_model = PatchJobIoK8sApiCoreV1EnvVar()
                self.env.append(temp_model.from_map(k))
        if m.get('envFrom') is not None:
            self.env_from = []
            for k in m.get('envFrom'):
                temp_model = PatchJobIoK8sApiCoreV1EnvFromSource()
                self.env_from.append(temp_model.from_map(k))
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('imagePullPolicy') is not None:
            self.image_pull_policy = m.get('imagePullPolicy')
        if m.get('lifecycle') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Lifecycle()
            self.lifecycle = temp_model.from_map(m['lifecycle'])
        if m.get('livenessProbe') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ports') is not None:
            self.ports = []
            for k in m.get('ports'):
                temp_model = PatchJobIoK8sApiCoreV1ContainerPort()
                self.ports.append(temp_model.from_map(k))
        if m.get('readinessProbe') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Probe()
            self.readiness_probe = temp_model.from_map(m['readinessProbe'])
        if m.get('resources') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('securityContext') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('startupProbe') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdinOnce') is not None:
            self.stdin_once = m.get('stdinOnce')
        if m.get('terminationMessagePath') is not None:
            self.termination_message_path = m.get('terminationMessagePath')
        if m.get('terminationMessagePolicy') is not None:
            self.termination_message_policy = m.get('terminationMessagePolicy')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        if m.get('volumeDevices') is not None:
            self.volume_devices = []
            for k in m.get('volumeDevices'):
                temp_model = PatchJobIoK8sApiCoreV1VolumeDevice()
                self.volume_devices.append(temp_model.from_map(k))
        if m.get('volumeMounts') is not None:
            self.volume_mounts = []
            for k in m.get('volumeMounts'):
                temp_model = PatchJobIoK8sApiCoreV1VolumeMount()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('workingDir') is not None:
            self.working_dir = m.get('workingDir')
        return self


class PatchJobIoK8sApiCoreV1PodDNSConfigOption(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "Required.", "zh_CN": "必需字段"}
        self.name = name
        # {"en": "Optional", "zh_CN": "选项取值"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PatchJobIoK8sApiCoreV1PodDNSConfig(TeaModel):
    def __init__(
        self,
        nameservers: List[str] = None,
        options: List[PatchJobIoK8sApiCoreV1PodDNSConfigOption] = None,
        searches: List[str] = None,
    ):
        # {"en": "A list of DNS name server IP addresses. This will be appended to the base nameservers generated from DNSPolicy. Duplicated nameservers will be removed.", "zh_CN": "DNS 名字服务器的 IP 地址列表。此列表将被追加到基于 dnsPolicy 生成的基本名字服务器列表。 重复的名字服务器将被删除"}
        self.nameservers = nameservers
        # {"en": "A list of DNS resolver options. This will be merged with the base options generated from DNSPolicy. Duplicated entries will be removed. Resolution options given in Options will override those that appear in the base DNSPolicy.", "zh_CN": "DNS 解析器选项列表。此处的选项将与基于 dnsPolicy 所生成的基本选项合并。重复的条目将被删除。 options 中所给出的解析选项将覆盖基本 dnsPolicy 中出现的对应选项"}
        self.options = options
        # {"en": "A list of DNS search domains for host-name lookup. This will be appended to the base search paths generated from DNSPolicy. Duplicated search paths will be removed.", "zh_CN": "用于主机名查找的 DNS 搜索域列表。这一列表将被追加到基于 dnsPolicy 生成的基本搜索路径列表。 重复的搜索路径将被删除"}
        self.searches = searches

    def validate(self):
        if self.options:
            for k in self.options:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.nameservers is not None:
            result['nameservers'] = self.nameservers
        if self.options is not None:
            result['options'] = []
            for k in self.options:
                result['options'].append(k.to_map() if k else None)
        if self.searches is not None:
            result['searches'] = self.searches
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('nameservers') is not None:
            self.nameservers = m.get('nameservers')
        if m.get('options') is not None:
            self.options = []
            for k in m.get('options'):
                temp_model = PatchJobIoK8sApiCoreV1PodDNSConfigOption()
                self.options.append(temp_model.from_map(k))
        if m.get('searches') is not None:
            self.searches = m.get('searches')
        return self


class PatchJobIoK8sApiCoreV1EphemeralContainer(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
        env: List[PatchJobIoK8sApiCoreV1EnvVar] = None,
        env_from: List[PatchJobIoK8sApiCoreV1EnvFromSource] = None,
        image: str = None,
        image_pull_policy: str = None,
        lifecycle: PatchJobIoK8sApiCoreV1Lifecycle = None,
        liveness_probe: PatchJobIoK8sApiCoreV1Probe = None,
        name: str = None,
        ports: List[PatchJobIoK8sApiCoreV1ContainerPort] = None,
        readiness_probe: PatchJobIoK8sApiCoreV1Probe = None,
        resources: PatchJobIoK8sApiCoreV1ResourceRequirements = None,
        security_context: PatchJobIoK8sApiCoreV1SecurityContext = None,
        startup_probe: PatchJobIoK8sApiCoreV1Probe = None,
        stdin: bool = None,
        stdin_once: bool = None,
        target_container_name: str = None,
        termination_message_path: str = None,
        termination_message_policy: str = None,
        tty: bool = None,
        volume_devices: List[PatchJobIoK8sApiCoreV1VolumeDevice] = None,
        volume_mounts: List[PatchJobIoK8sApiCoreV1VolumeMount] = None,
        working_dir: str = None,
    ):
        # {"en": "Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "entrypoint 的参数。如果未提供，则使用镜像的 CMD。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.args = args
        # {"en": "Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell", "zh_CN": "入口点数组。不在 Shell 中执行。如果未提供，则使用镜像的 ENTRYPOINT。 变量引用 $(VAR_NAME) 使用容器的环境进行扩展。如果无法解析变量，则输入字符串中的引用将保持不变。 $$ 被简化为 $，这允许转义 $(VAR_NAME) 语法：即 $$(VAR_NAME) 将产生字符串字面值 $(VAR_NAME)。 无论变量是否存在，转义引用都不会被扩展。无法更新"}
        self.command = command
        # {"en": "List of environment variables to set in the container. Cannot be updated.", "zh_CN": "要在容器中设置的环境变量列表。无法更新"}
        self.env = env
        # {"en": "List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.", "zh_CN": "在容器中填充环境变量的来源列表。在来源中定义的键名必须是 C_IDENTIFIER。 容器启动时，所有无效键都将作为事件报告。当一个键存在于多个来源中时，与最后一个来源关联的值将优先。 如果有重复主键，env 中定义的值将优先。无法更新"}
        self.env_from = env_from
        # {"en": "Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images", "zh_CN": "容器镜像名称"}
        self.image = image
        # {"en": "Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images", "zh_CN": "镜像拉取策略。取值为 Always、Never、IfNotPresent 之一。 如果指定了 :latest 标签，则默认为 Always，否则默认为 IfNotPresent。 无法更新"}
        self.image_pull_policy = image_pull_policy
        # {"en": "Lifecycle is not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用生命周期"}
        self.lifecycle = lifecycle
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.liveness_probe = liveness_probe
        # {"en": "Name of the ephemeral container specified as a DNS_LABEL. This name must be unique among all containers, init containers and ephemeral containers.", "zh_CN": "以 DNS_LABEL 形式设置的临时容器的名称。此名称在所有容器、Init 容器和临时容器中必须是唯一的"}
        self.name = name
        # {"en": "Ports are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用端口"}
        self.ports = ports
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.readiness_probe = readiness_probe
        # {"en": "Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources already allocated to the pod.", "zh_CN": "临时容器不允许使用资源。临时容器使用已分配给 Pod 的空闲资源"}
        self.resources = resources
        # {"en": "Optional: SecurityContext defines the security options the ephemeral container should be run with. If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext", "zh_CN": "可选字段。securityContext 定义了运行临时容器的安全选项。 如果设置了此字段，SecurityContext 的字段将覆盖 PodSecurityContext 的等效字段"}
        self.security_context = security_context
        # {"en": "Probes are not allowed for ephemeral containers.", "zh_CN": "临时容器不允许使用探针"}
        self.startup_probe = startup_probe
        # {"en": "Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.", "zh_CN": "是否应在容器运行时内为此容器 stdin 分配缓冲区。 如果未设置，从容器中的 stdin 读数据将始终导致 EOF。默认为 false"}
        self.stdin = stdin
        # {"en": "Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false", "zh_CN": "容器运行时是否应在某个 attach 操作打开 stdin 通道后关闭它。 当 stdin 为 true 时，stdin 流将在多个 attach 会话中保持打开状态。 如果 stdinOnce 设置为 true，则 stdin 在容器启动时打开，在第一个客户端连接到 stdin 之前为空， 然后保持打开并接受数据，直到客户端断开连接，此时 stdin 关闭并保持关闭直到容器重新启动。 如果此标志为 false，则从 stdin 读取的容器进程将永远不会收到 EOF。默认为 false"}
        self.stdin_once = stdin_once
        # {"en": "If set, the name of the container from PodSpec that this ephemeral container targets. The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container. If not set then the ephemeral container is run in whatever namespaces are shared for the pod. Note that the container runtime must support this feature.", "zh_CN": "如果设置，则为 Pod 规约中此临时容器所针对的容器的名称。临时容器将在该容器的名字空间（IPC、PID 等）中运行。 如果未设置，则临时容器使用 Pod 规约中配置的名字空间。容器运行时必须实现对此功能的支持。如果运行时不支持名字空间定位，则设置此字段的结果是未定义的"}
        self.target_container_name = target_container_name
        # {"en": "Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.", "zh_CN": "可选字段。挂载到容器文件系统的路径，用于写入容器终止消息的文件。 写入的消息旨在成为简短的最终状态，例如断言失败消息。如果超出 4096 字节，将被节点截断。 所有容器的总消息长度将限制为 12 KB。默认为 /dev/termination-log。无法更新"}
        self.termination_message_path = termination_message_path
        # {"en": "Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.", "zh_CN": "指示应如何填充终止消息。字段值为 File 表示将使用 terminateMessagePath 的内容来填充成功和失败的容器状态消息。 如果终止消息文件为空并且容器因错误退出，字段值 FallbackToLogsOnError 表示将使用容器日志输出的最后一块。日志输出限制为 2048 字节或 80 行，以较小者为准。 默认为 File。无法更新"}
        self.termination_message_policy = termination_message_policy
        # {"en": "Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.", "zh_CN": "这个容器是否应该为自己分配一个 TTY，也需要 stdin 为 true。默认为 false"}
        self.tty = tty
        # {"en": "volumeDevices is the list of block devices to be used by the container.", "zh_CN": "volumeDevices 是容器要使用的块设备列表"}
        self.volume_devices = volume_devices
        # {"en": "Pod volumes to mount into the container's filesystem. Cannot be updated.", "zh_CN": "要挂载到容器文件系统中的 Pod 卷。临时容器不允许子路径挂载。无法更新"}
        self.volume_mounts = volume_mounts
        # {"en": "Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.", "zh_CN": "容器的工作目录。如果未指定，将使用容器运行时的默认值，默认值可能在容器镜像中配置。无法更新"}
        self.working_dir = working_dir

    def validate(self):
        if self.env:
            for k in self.env:
                if k:
                    k.validate()
        if self.env_from:
            for k in self.env_from:
                if k:
                    k.validate()
        if self.lifecycle:
            self.lifecycle.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        self.validate_required(self.name, 'name')
        if self.ports:
            for k in self.ports:
                if k:
                    k.validate()
        if self.readiness_probe:
            self.readiness_probe.validate()
        if self.resources:
            self.resources.validate()
        if self.security_context:
            self.security_context.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.volume_devices:
            for k in self.volume_devices:
                if k:
                    k.validate()
        if self.volume_mounts:
            for k in self.volume_mounts:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        if self.env is not None:
            result['env'] = []
            for k in self.env:
                result['env'].append(k.to_map() if k else None)
        if self.env_from is not None:
            result['envFrom'] = []
            for k in self.env_from:
                result['envFrom'].append(k.to_map() if k else None)
        if self.image is not None:
            result['image'] = self.image
        if self.image_pull_policy is not None:
            result['imagePullPolicy'] = self.image_pull_policy
        if self.lifecycle is not None:
            result['lifecycle'] = self.lifecycle.to_map()
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.name is not None:
            result['name'] = self.name
        if self.ports is not None:
            result['ports'] = []
            for k in self.ports:
                result['ports'].append(k.to_map() if k else None)
        if self.readiness_probe is not None:
            result['readinessProbe'] = self.readiness_probe.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.security_context is not None:
            result['securityContext'] = self.security_context.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdin_once is not None:
            result['stdinOnce'] = self.stdin_once
        if self.target_container_name is not None:
            result['targetContainerName'] = self.target_container_name
        if self.termination_message_path is not None:
            result['terminationMessagePath'] = self.termination_message_path
        if self.termination_message_policy is not None:
            result['terminationMessagePolicy'] = self.termination_message_policy
        if self.tty is not None:
            result['tty'] = self.tty
        if self.volume_devices is not None:
            result['volumeDevices'] = []
            for k in self.volume_devices:
                result['volumeDevices'].append(k.to_map() if k else None)
        if self.volume_mounts is not None:
            result['volumeMounts'] = []
            for k in self.volume_mounts:
                result['volumeMounts'].append(k.to_map() if k else None)
        if self.working_dir is not None:
            result['workingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('env') is not None:
            self.env = []
            for k in m.get('env'):
                temp_model = PatchJobIoK8sApiCoreV1EnvVar()
                self.env.append(temp_model.from_map(k))
        if m.get('envFrom') is not None:
            self.env_from = []
            for k in m.get('envFrom'):
                temp_model = PatchJobIoK8sApiCoreV1EnvFromSource()
                self.env_from.append(temp_model.from_map(k))
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('imagePullPolicy') is not None:
            self.image_pull_policy = m.get('imagePullPolicy')
        if m.get('lifecycle') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Lifecycle()
            self.lifecycle = temp_model.from_map(m['lifecycle'])
        if m.get('livenessProbe') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('ports') is not None:
            self.ports = []
            for k in m.get('ports'):
                temp_model = PatchJobIoK8sApiCoreV1ContainerPort()
                self.ports.append(temp_model.from_map(k))
        if m.get('readinessProbe') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Probe()
            self.readiness_probe = temp_model.from_map(m['readinessProbe'])
        if m.get('resources') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('securityContext') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SecurityContext()
            self.security_context = temp_model.from_map(m['securityContext'])
        if m.get('startupProbe') is not None:
            temp_model = PatchJobIoK8sApiCoreV1Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdinOnce') is not None:
            self.stdin_once = m.get('stdinOnce')
        if m.get('targetContainerName') is not None:
            self.target_container_name = m.get('targetContainerName')
        if m.get('terminationMessagePath') is not None:
            self.termination_message_path = m.get('terminationMessagePath')
        if m.get('terminationMessagePolicy') is not None:
            self.termination_message_policy = m.get('terminationMessagePolicy')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        if m.get('volumeDevices') is not None:
            self.volume_devices = []
            for k in m.get('volumeDevices'):
                temp_model = PatchJobIoK8sApiCoreV1VolumeDevice()
                self.volume_devices.append(temp_model.from_map(k))
        if m.get('volumeMounts') is not None:
            self.volume_mounts = []
            for k in m.get('volumeMounts'):
                temp_model = PatchJobIoK8sApiCoreV1VolumeMount()
                self.volume_mounts.append(temp_model.from_map(k))
        if m.get('workingDir') is not None:
            self.working_dir = m.get('workingDir')
        return self


class PatchJobIoK8sApiCoreV1HostAlias(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        # {"en": "Hostnames for the above IP address.", "zh_CN": "指定 IP 地址对应的主机名"}
        self.hostnames = hostnames
        # {"en": "IP address of the host file entry.", "zh_CN": "主机文件条目的 IP 地址"}
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['hostnames'] = self.hostnames
        if self.ip is not None:
            result['ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hostnames') is not None:
            self.hostnames = m.get('hostnames')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        return self


class PatchJobIoK8sApiCoreV1LocalObjectReference(TeaModel):
    def __init__(
        self,
        name: str = None,
    ):
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用者的名称"}
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class PatchJobIoK8sApiCoreV1PodReadinessGate(TeaModel):
    def __init__(
        self,
        condition_type: str = None,
    ):
        # {"en": "ConditionType refers to a condition in the pod's condition list with matching type.", "zh_CN": "指 Pod 的状况列表中类型匹配的状况"}
        self.condition_type = condition_type

    def validate(self):
        self.validate_required(self.condition_type, 'condition_type')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_type is not None:
            result['conditionType'] = self.condition_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('conditionType') is not None:
            self.condition_type = m.get('conditionType')
        return self


class PatchJobIoK8sApiCoreV1Sysctl(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        # {"en": "Name of a property to set", "zh_CN": "要设置的属性的名称"}
        self.name = name
        # {"en": "Value of a property to set", "zh_CN": "要设置的属性值"}
        self.value = value

    def validate(self):
        self.validate_required(self.name, 'name')
        self.validate_required(self.value, 'value')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PatchJobIoK8sApiCoreV1PodSecurityContext(TeaModel):
    def __init__(
        self,
        fs_group: int = None,
        fs_group_change_policy: str = None,
        run_as_group: int = None,
        run_as_non_root: bool = None,
        run_as_user: int = None,
        se_linux_options: PatchJobIoK8sApiCoreV1SELinuxOptions = None,
        seccomp_profile: PatchJobIoK8sApiCoreV1SeccompProfile = None,
        supplemental_groups: List[int] = None,
        sysctls: List[PatchJobIoK8sApiCoreV1Sysctl] = None,
        windows_options: PatchJobIoK8sApiCoreV1WindowsSecurityContextOptions = None,
    ):
        # {"en": "A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----.If unset, the Kubelet will not modify the ownership and permissions of any volume.", "zh_CN": "应用到 Pod 中所有容器的特殊补充组。某些卷类型允许 kubelet 将该卷的所有权更改为由 Pod 拥有：1. 文件系统的属主 GID 将是 fsGroup 字段值2. setgid 位已设置（在卷中创建的新文件将归 fsGroup 所有）3. 权限位将与 rw-rw---- 进行按位或操作。如果未设置此字段，kubelet 不会修改任何卷的所有权和权限。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.fs_group = fs_group
        # {"en": "fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are OnRootMismatch and Always. If not specified, Always is used.", "zh_CN": "fsGroupChangePolicy 定义了在卷被在 Pod 中暴露之前更改其属主和权限的行为。 此字段仅适用于支持基于 fsGroup 的属主权（和权限）的卷类型。它不会影响临时卷类型， 例如：secret、configmap 和 emptydir。 有效值为 OnRootMismatch 和 Always。如果未设置，则使用 Always。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.fs_group_change_policy = fs_group_change_policy
        # {"en": "The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "运行容器进程入口点（Entrypoint）的 GID。如果未设置，则使用运行时的默认值。 也可以在 SecurityContext 中设置。如果同时在 SecurityContext 和 PodSecurityContext 中设置， 则在对应容器中设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.run_as_group = run_as_group
        # {"en": "Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "指示容器必须以非 root 用户身份运行。如果为 true，kubelet 将在运行时验证镜像， 以确保它不会以 UID 0（root）身份运行。如果镜像中确实使用 root 账号启动，则容器无法被启动。 如果此字段未设置或为 false，则不会执行此类验证。也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先"}
        self.run_as_non_root = run_as_non_root
        # {"en": "The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "运行容器进程入口点（Entrypoint）的 UID。如果未指定，则默认为镜像元数据中指定的用户。 也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在对应容器中所设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.run_as_user = run_as_user
        # {"en": "The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.", "zh_CN": "应用于所有容器的 SELinux 上下文。如果未设置，容器运行时将为每个容器分配一个随机 SELinux 上下文。 也可以在 SecurityContext 中设置。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在对应容器中设置的 SecurityContext 值优先。 注意，spec.os.name 为 windows 时不能设置该字段"}
        self.se_linux_options = se_linux_options
        # {"en": "The seccomp options to use by the containers in this pod.", "zh_CN": "此 Pod 中的容器使用的 seccomp 选项。注意，spec.os.name 为 windows 时不能设置此字段"}
        self.seccomp_profile = seccomp_profile
        # {"en": "A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.", "zh_CN": "此字段包含将应用到每个容器中运行的第一个进程的组列表。 容器进程的组成员身份取决于容器的主 GID、fsGroup（如果指定了的话） 和在容器镜像中为容器进程的 uid 定义的组成员身份，以及这里所给的列表。如果未指定，则不会向任何容器添加其他组。 注意，在容器镜像中为容器进程的 uid 定义的组成员身份仍然有效， 即使它们未包含在此列表中也是如此。 注意，当 spec.os.name 为 windows 时，不能设置此字段"}
        self.supplemental_groups = supplemental_groups
        # {"en": "Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.", "zh_CN": "sysctls 包含用于 Pod 的名字空间 sysctl 列表。具有不受（容器运行时）支持的 sysctl 的 Pod 可能无法启动。 注意，spec.os.name 为 windows 时不能设置此字段"}
        self.sysctls = sysctls
        # {"en": "The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.", "zh_CN": "要应用到所有容器上的、特定于 Windows 的设置。 如果未设置此字段，将使用容器的 SecurityContext 中的选项。 如果同时在 SecurityContext 和 PodSecurityContext 中设置，则在 SecurityContext 中指定的值优先。 注意，spec.os.name 为 linux 时不能设置该字段"}
        self.windows_options = windows_options

    def validate(self):
        if self.se_linux_options:
            self.se_linux_options.validate()
        if self.seccomp_profile:
            self.seccomp_profile.validate()
        if self.sysctls:
            for k in self.sysctls:
                if k:
                    k.validate()
        if self.windows_options:
            self.windows_options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_group is not None:
            result['fsGroup'] = self.fs_group
        if self.fs_group_change_policy is not None:
            result['fsGroupChangePolicy'] = self.fs_group_change_policy
        if self.run_as_group is not None:
            result['runAsGroup'] = self.run_as_group
        if self.run_as_non_root is not None:
            result['runAsNonRoot'] = self.run_as_non_root
        if self.run_as_user is not None:
            result['runAsUser'] = self.run_as_user
        if self.se_linux_options is not None:
            result['seLinuxOptions'] = self.se_linux_options.to_map()
        if self.seccomp_profile is not None:
            result['seccompProfile'] = self.seccomp_profile.to_map()
        if self.supplemental_groups is not None:
            result['supplementalGroups'] = self.supplemental_groups
        if self.sysctls is not None:
            result['sysctls'] = []
            for k in self.sysctls:
                result['sysctls'].append(k.to_map() if k else None)
        if self.windows_options is not None:
            result['windowsOptions'] = self.windows_options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsGroup') is not None:
            self.fs_group = m.get('fsGroup')
        if m.get('fsGroupChangePolicy') is not None:
            self.fs_group_change_policy = m.get('fsGroupChangePolicy')
        if m.get('runAsGroup') is not None:
            self.run_as_group = m.get('runAsGroup')
        if m.get('runAsNonRoot') is not None:
            self.run_as_non_root = m.get('runAsNonRoot')
        if m.get('runAsUser') is not None:
            self.run_as_user = m.get('runAsUser')
        if m.get('seLinuxOptions') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SELinuxOptions()
            self.se_linux_options = temp_model.from_map(m['seLinuxOptions'])
        if m.get('seccompProfile') is not None:
            temp_model = PatchJobIoK8sApiCoreV1SeccompProfile()
            self.seccomp_profile = temp_model.from_map(m['seccompProfile'])
        if m.get('supplementalGroups') is not None:
            self.supplemental_groups = m.get('supplementalGroups')
        if m.get('sysctls') is not None:
            self.sysctls = []
            for k in m.get('sysctls'):
                temp_model = PatchJobIoK8sApiCoreV1Sysctl()
                self.sysctls.append(temp_model.from_map(k))
        if m.get('windowsOptions') is not None:
            temp_model = PatchJobIoK8sApiCoreV1WindowsSecurityContextOptions()
            self.windows_options = temp_model.from_map(m['windowsOptions'])
        return self


class PatchJobIoK8sApiCoreV1Toleration(TeaModel):
    def __init__(
        self,
        effect: str = None,
        key: str = None,
        operator: str = None,
        toleration_seconds: int = None,
        value: str = None,
    ):
        # {"en": "Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.", "zh_CN": "指示要匹配的污点效果。空值意味著匹配所有污点效果。如果要设置此字段，允许的值为 NoSchedule、PreferNoSchedule 和 NoExecute 之一"}
        self.effect = effect
        # {"en": "Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.", "zh_CN": "容忍度所适用的污点的键名。此字段为空意味着匹配所有的污点键。 如果 key 为空，则 operator 必须为 Exists；这种组合意味着匹配所有值和所有键"}
        self.key = key
        # {"en": "Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.", "zh_CN": "表示 key 与 value 之间的关系。有效的 operator 取值是 Exists 和 Equal。默认为 Equal。 Exists 相当于 value 为某种通配符，因此 Pod 可以容忍特定类别的所有污点"}
        self.operator = operator
        # {"en": "TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.", "zh_CN": "表示容忍度（effect 必须是 NoExecute，否则此字段被忽略）容忍污点的时间长度。 默认情况下，此字段未被设置，这意味着会一直能够容忍对应污点（不会发生驱逐操作）。 零值和负值会被系统当做 0 值处理（立即触发驱逐）"}
        self.toleration_seconds = toleration_seconds
        # {"en": "Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.", "zh_CN": "容忍度所匹配的污点值。如果 operator 为 Exists，则此 value 值应该为空， 否则 value 值应该是一个正常的字符串"}
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.effect is not None:
            result['effect'] = self.effect
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.toleration_seconds is not None:
            result['tolerationSeconds'] = self.toleration_seconds
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('effect') is not None:
            self.effect = m.get('effect')
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('tolerationSeconds') is not None:
            self.toleration_seconds = m.get('tolerationSeconds')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PatchJobIoK8sApiCoreV1TopologySpreadConstraint(TeaModel):
    def __init__(
        self,
        label_selector: PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        max_skew: int = None,
        topology_key: str = None,
        when_unsatisfiable: str = None,
    ):
        # {"en": "LabelSelector is used to find matching pods. Pods that match this label selector are counted to determine the number of pods in their corresponding topology domain.", "zh_CN": "用于识别匹配的 Pod。对匹配此标签选择算符的 Pod 进行计数， 以确定其相应拓扑域中的 Pod 数量"}
        self.label_selector = label_selector
        # {"en": "MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.", "zh_CN": "maxSkew 描述 Pod 可能分布不均衡的程度。当 whenUnsatisfiable=DoNotSchedule 时， 此字段值是目标拓扑中匹配的 Pod 数量与全局最小值之间的最大允许差值。 全局最小值是候选域中匹配 Pod 的最小数量，如果候选域的数量小于 minDomains，则为零。 例如，在一个包含三个可用区的集群中，maxSkew 设置为 1，具有相同 labelSelector 的 Pod 分布为 2/2/1： 在这种情况下，全局最小值为 1。当 whenUnsatisfiable=ScheduleAnyway 时，此字段被用来给满足此约束的拓扑域更高的优先级。此字段是一个必填字段。默认值为 1，不允许为 0"}
        self.max_skew = max_skew
        # {"en": "TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a bucket, and try to put balanced number of pods into each bucket. It's a required field.", "zh_CN": "topologyKey 是节点标签的键名。如果节点的标签中包含此键名且键值亦相同，则被认为在相同的拓扑域中。 我们将每个 <键, 值> 视为一个 “桶（Bucket）”，并尝试将数量均衡的 Pod 放入每个桶中。 我们定义域（Domain）为拓扑域的特定实例。 此外，我们定义一个候选域（Eligible Domain）为其节点与 nodeAffinityPolicy 和 nodeTaintsPolicy 的要求匹配的域。 例如，如果 topologyKey 是 kubernetes.io/hostname，则每个 Node 都是该拓扑的域。 而如果 topologyKey 是 topology.kubernetes.io/zone，则每个区域都是该拓扑的一个域。 这是一个必填字段"}
        self.topology_key = topology_key
        # {"en": "WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the spread constraint. - DoNotSchedule (default) tells the scheduler not to schedule it. - ScheduleAnyway tells the scheduler to schedule the pod in any location,but giving higher precedence to topologies that would help reduce the skew.A constraint is considered Unsatisfiable for an incoming pod if and only if every possible node assigment for that pod would violate MaxSkew on some topology. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 | zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler won't make it *more* imbalanced. It's a required field.", "zh_CN": "whenUnsatisfiable 表示如果 Pod 不满足分布约束，如何处理它。- DoNotSchedule（默认）：告诉调度器不要调度它。- ScheduleAnyway：告诉调度器将 Pod 调度到任何位置，但给予能够降低偏差的拓扑更高的优先级。当且仅当该 Pod 的每个可能的节点分配都会违反某些拓扑对应的 “maxSkew” 时， 才认为传入 Pod 的约束是 “不可满足的”"}
        self.when_unsatisfiable = when_unsatisfiable

    def validate(self):
        if self.label_selector:
            self.label_selector.validate()
        self.validate_required(self.max_skew, 'max_skew')
        self.validate_required(self.topology_key, 'topology_key')
        self.validate_required(self.when_unsatisfiable, 'when_unsatisfiable')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.label_selector is not None:
            result['labelSelector'] = self.label_selector.to_map()
        if self.max_skew is not None:
            result['maxSkew'] = self.max_skew
        if self.topology_key is not None:
            result['topologyKey'] = self.topology_key
        if self.when_unsatisfiable is not None:
            result['whenUnsatisfiable'] = self.when_unsatisfiable
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('labelSelector') is not None:
            temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.label_selector = temp_model.from_map(m['labelSelector'])
        if m.get('maxSkew') is not None:
            self.max_skew = m.get('maxSkew')
        if m.get('topologyKey') is not None:
            self.topology_key = m.get('topologyKey')
        if m.get('whenUnsatisfiable') is not None:
            self.when_unsatisfiable = m.get('whenUnsatisfiable')
        return self


class PatchJobIoK8sApiCoreV1AWSElasticBlockStoreVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        partition: int = None,
        read_only: bool = None,
        volume_id: str = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "fsType 是你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型"}
        self.fs_type = fs_type
        # {"en": "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as 1. Similarly, the volume partition for /dev/sda is 0 (or you can leave the property empty).", "zh_CN": "partition 是你要挂载的卷中的分区。如果省略，则默认为按卷名称进行挂载"}
        self.partition = partition
        # {"en": "Specify true to force and set the ReadOnly property in VolumeMounts to true. If omitted, the default is false. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "readOnly 值为 true 将使得卷挂载被强制设置为 readOnly"}
        self.read_only = read_only
        # {"en": "Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore", "zh_CN": "volumeID 是 AWS（Amazon EBS 卷）中持久磁盘资源的唯一 ID"}
        self.volume_id = volume_id

    def validate(self):
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class PatchJobIoK8sApiCoreV1AzureDiskVolumeSource(TeaModel):
    def __init__(
        self,
        caching_mode: str = None,
        disk_name: str = None,
        disk_uri: str = None,
        fs_type: str = None,
        kind: str = None,
        read_only: bool = None,
    ):
        # {"en": "Host Caching mode: None, Read Only, Read Write.", "zh_CN": "主机缓存（Host Caching）模式：None、Read Only、Read Write"}
        self.caching_mode = caching_mode
        # {"en": "The Name of the data disk in the blob storage", "zh_CN": "Blob 存储中数据盘的名称"}
        self.disk_name = disk_name
        # {"en": "The URI the data disk in the blob storage", "zh_CN": "Blob 存储中数据盘的 URI"}
        self.disk_uri = disk_uri
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "fsType 是要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一"}
        self.fs_type = fs_type
        # {"en": "Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared", "zh_CN": "kind 预期值包括：Shared：每个存储帐户多个 Blob 磁盘；Dedicated：每个存储帐户单个 Blob 磁盘；Managed：azure 托管的数据盘（仅托管的可用性集合中）。默认为 Shared"}
        self.kind = kind
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.disk_name, 'disk_name')
        self.validate_required(self.disk_uri, 'disk_uri')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.caching_mode is not None:
            result['cachingMode'] = self.caching_mode
        if self.disk_name is not None:
            result['diskName'] = self.disk_name
        if self.disk_uri is not None:
            result['diskURI'] = self.disk_uri
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.kind is not None:
            result['kind'] = self.kind
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cachingMode') is not None:
            self.caching_mode = m.get('cachingMode')
        if m.get('diskName') is not None:
            self.disk_name = m.get('diskName')
        if m.get('diskURI') is not None:
            self.disk_uri = m.get('diskURI')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class PatchJobIoK8sApiCoreV1AzureFileVolumeSource(TeaModel):
    def __init__(
        self,
        read_only: bool = None,
        secret_name: str = None,
        share_name: str = None,
    ):
        # {"en": "Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "readOnly 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "the name of secret that contains Azure Storage Account Name and Key", "zh_CN": "包含 Azure 存储账号名称和主键的 Secret 的名称"}
        self.secret_name = secret_name
        # {"en": "Share Name", "zh_CN": "Azure 共享名称"}
        self.share_name = share_name

    def validate(self):
        self.validate_required(self.secret_name, 'secret_name')
        self.validate_required(self.share_name, 'share_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_name is not None:
            result['secretName'] = self.secret_name
        if self.share_name is not None:
            result['shareName'] = self.share_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretName') is not None:
            self.secret_name = m.get('secretName')
        if m.get('shareName') is not None:
            self.share_name = m.get('shareName')
        return self


class PatchJobIoK8sApiCoreV1CephFSVolumeSource(TeaModel):
    def __init__(
        self,
        monitors: List[str] = None,
        path: str = None,
        read_only: bool = None,
        secret_file: str = None,
        secret_ref: PatchJobIoK8sApiCoreV1LocalObjectReference = None,
        user: str = None,
    ):
        # {"en": "Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "必需的。monitors 是 Ceph 监测的集合"}
        self.monitors = monitors
        # {"en": "Optional: Used as the mounted root, rather than the full Ceph tree, default is /", "zh_CN": "可选的。用作挂载的根，而不是挂载完整的 Ceph 树，默认为 “/”"}
        self.path = path
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。默认为 false（读/写）。 此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "secretFile 是可选的。secretFile 是 User 对应的密钥环的路径，默认为 /etc/ceph/user.secret"}
        self.secret_file = secret_file
        # {"en": "Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。secretRef 是针对用户的身份认证 Secret 的引用，默认为空"}
        self.secret_ref = secret_ref
        # {"en": "Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it", "zh_CN": "可选的。user 是 rados 用户名，默认为 admin"}
        self.user = user

    def validate(self):
        self.validate_required(self.monitors, 'monitors')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitors is not None:
            result['monitors'] = self.monitors
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_file is not None:
            result['secretFile'] = self.secret_file
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.user is not None:
            result['user'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('monitors') is not None:
            self.monitors = m.get('monitors')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretFile') is not None:
            self.secret_file = m.get('secretFile')
        if m.get('secretRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('user') is not None:
            self.user = m.get('user')
        return self


class PatchJobIoK8sApiCoreV1CinderVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        read_only: bool = None,
        secret_ref: PatchJobIoK8sApiCoreV1LocalObjectReference = None,
        volume_id: str = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一"}
        self.fs_type = fs_type
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": " 默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: points to a secret object containing parameters used to connect to OpenStack.", "zh_CN": "可选的。指向 Secret 对象，内含的参数用于连接到 OpenStack"}
        self.secret_ref = secret_ref
        # {"en": "volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md", "zh_CN": "用于标识 Cinder 中的卷"}
        self.volume_id = volume_id

    def validate(self):
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.volume_id, 'volume_id')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        if self.volume_id is not None:
            result['volumeID'] = self.volume_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        if m.get('volumeID') is not None:
            self.volume_id = m.get('volumeID')
        return self


class PatchJobIoK8sApiCoreV1KeyToPath(TeaModel):
    def __init__(
        self,
        key: str = None,
        mode: int = None,
        path: str = None,
    ):
        # {"en": "The key to project.", "zh_CN": "要投射的键"}
        self.key = key
        # {"en": "Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "mode 是可选的：模式位用于为文件设置权限。必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 如果未指定，则将使用卷 defaultMode。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.mode = mode
        # {"en": "The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.", "zh_CN": "将键映射到的文件的相对路径。不能是绝对路径。不能包含路径元素 “..”。不能以字符串 “..” 开头"}
        self.path = path

    def validate(self):
        self.validate_required(self.key, 'key')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.mode is not None:
            result['mode'] = self.mode
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class PatchJobIoK8sApiCoreV1ConfigMapVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[PatchJobIoK8sApiCoreV1KeyToPath] = None,
        name: str = None,
        optional: bool = None,
    ):
        # {"en": "Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "defaultMode 是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. PatchJobPaths must be relative and may not contain the '..' path or start with '..'.", "zh_CN": "如果未指定 items，则所引用的 ConfigMap 的 data 字段中的每个键值对将作为一个文件被投射到卷中， 这个文件的名称是键名，而文件的内容是键的取值。 如果指定 items，则所列出的键将被投射到指定的路径中，且不会显示未列出的键。 如果指定的键不在 ConfigMap 中，则卷设置将出错，除非对应的键被标记为可选。 路径必须是相对路径，不能包含 “..” 路径，也不能以 “..” 开头"}
        self.items = items
        # {"en": "Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names", "zh_CN": "被引用资源的名称"}
        self.name = name
        # {"en": "Specify whether the ConfigMap or its keys must be defined", "zh_CN": "指定是否所引用的 ConfigMap 或其键必须已经被定义"}
        self.optional = optional

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.name is not None:
            result['name'] = self.name
        if self.optional is not None:
            result['optional'] = self.optional
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = PatchJobIoK8sApiCoreV1KeyToPath()
                self.items.append(temp_model.from_map(k))
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('optional') is not None:
            self.optional = m.get('optional')
        return self


class PatchJobIoK8sApiCoreV1CSIVolumeSource(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        node_publish_secret_ref: PatchJobIoK8sApiCoreV1LocalObjectReference = None,
        read_only: bool = None,
        volume_attributes: Dict[str, Any] = None,
    ):
        # {"en": "Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.", "zh_CN": "处理此卷的 CSI 驱动的名称。咨询你的管理员以获取在集群中注册的正确名称"}
        self.driver = driver
        # {"en": "Filesystem type to mount. Ex. ext4, xfs, ntfs. If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.", "zh_CN": "要挂载的 fsType。例如 “ext4”、“xfs”、“ntfs”。 如果未提供，则将空值传递给关联的 CSI 驱动，以便决定要应用的默认文件系统"}
        self.fs_type = fs_type
        # {"en": "NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.", "zh_CN": "对包含敏感信息的 Secret 对象的引用， 该 Secret 对象将被传递到 CSI 驱动以完成 CSI NodePublishVolume 和 NodeUnpublishVolume 调用。 此字段是可选的，如果不需要 Secret，则此字段可以为空。 如果 Secret 对象包含多个 Secret，则所有 Secret 引用将被传递"}
        self.node_publish_secret_ref = node_publish_secret_ref
        # {"en": "Specifies a read-only configuration for the volume. Defaults to false (read/write).", "zh_CN": "指定供卷使用的只读配置。默认为 false（读/写）"}
        self.read_only = read_only
        # {"en": "VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.", "zh_CN": "存储传递给 CSI 驱动且特定于驱动的属性。查阅你的驱动文档，了解支持的值"}
        self.volume_attributes = volume_attributes

    def validate(self):
        self.validate_required(self.driver, 'driver')
        if self.node_publish_secret_ref:
            self.node_publish_secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['driver'] = self.driver
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.node_publish_secret_ref is not None:
            result['nodePublishSecretRef'] = self.node_publish_secret_ref.to_map()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_attributes is not None:
            result['volumeAttributes'] = self.volume_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('driver') is not None:
            self.driver = m.get('driver')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('nodePublishSecretRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1LocalObjectReference()
            self.node_publish_secret_ref = temp_model.from_map(m['nodePublishSecretRef'])
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeAttributes') is not None:
            self.volume_attributes = m.get('volumeAttributes')
        return self


class PatchJobIoK8sApiCoreV1DownwardAPIVolumeFile(TeaModel):
    def __init__(
        self,
        field_ref: PatchJobIoK8sApiCoreV1ObjectFieldSelector = None,
        mode: int = None,
        path: str = None,
        resource_field_ref: PatchJobIoK8sApiCoreV1ResourceFieldSelector = None,
    ):
        # {"en": "Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.", "zh_CN": "必需。选择 Pod 的字段：仅支持注解、标签、名称和名字空间"}
        self.field_ref = field_ref
        # {"en": "Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "可选：模式位用于设置文件的权限，必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。 如果未指定，则将使用卷 defaultMode。 这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.mode = mode
        # {"en": "Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'", "zh_CN": "必需。path 是要创建的文件的相对路径名称。不得使用绝对路径，也不得包含 “..” 路径。 必须用 UTF-8 进行编码。相对路径的第一项不得用 “..” 开头"}
        self.path = path
        # {"en": "Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.", "zh_CN": "选择容器的资源：目前仅支持资源限制与请求（limits.cpu、limits.memory、requests.cpu 和 requests.memory）"}
        self.resource_field_ref = resource_field_ref

    def validate(self):
        if self.field_ref:
            self.field_ref.validate()
        self.validate_required(self.path, 'path')
        if self.resource_field_ref:
            self.resource_field_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.field_ref is not None:
            result['fieldRef'] = self.field_ref.to_map()
        if self.mode is not None:
            result['mode'] = self.mode
        if self.path is not None:
            result['path'] = self.path
        if self.resource_field_ref is not None:
            result['resourceFieldRef'] = self.resource_field_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fieldRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ObjectFieldSelector()
            self.field_ref = temp_model.from_map(m['fieldRef'])
        if m.get('mode') is not None:
            self.mode = m.get('mode')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('resourceFieldRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ResourceFieldSelector()
            self.resource_field_ref = temp_model.from_map(m['resourceFieldRef'])
        return self


class PatchJobIoK8sApiCoreV1DownwardAPIVolumeSource(TeaModel):
    def __init__(
        self,
        default_mode: int = None,
        items: List[PatchJobIoK8sApiCoreV1DownwardAPIVolumeFile] = None,
    ):
        # {"en": "Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.", "zh_CN": "可选：默认情况下，模式位用于已创建的文件。 必须是可选的：默认情况下，模式位用于为已创建的文件设置权限。 必须是 0000 到 0777 之间的八进制值或 0 到 511 之间的十进制值。 YAML 既接受八进制值也接受十进制值，JSON 针对模式位需要十进制值。此字段默认为 0644。 路径内的目录不受此设置的影响。这可能与影响文件模式的其他选项（如 fsGroup）有冲突，且结果可以是其他模式位也被设置"}
        self.default_mode = default_mode
        # {"en": "Items is a list of downward API volume file", "zh_CN": "Downward API 卷文件的列表"}
        self.items = items

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_mode is not None:
            result['defaultMode'] = self.default_mode
        if self.items is not None:
            result['items'] = []
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('defaultMode') is not None:
            self.default_mode = m.get('defaultMode')
        if m.get('items') is not None:
            self.items = []
            for k in m.get('items'):
                temp_model = PatchJobIoK8sApiCoreV1DownwardAPIVolumeFile()
                self.items.append(temp_model.from_map(k))
        return self


class PatchJobIoK8sApiCoreV1EmptyDirVolumeSource(TeaModel):
    def __init__(
        self,
        medium: str = None,
        size_limit: str = None,
    ):
        # {"en": "What type of storage medium should back this directory. The default is  which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir", "zh_CN": "表示此目录应使用哪种类别的存储介质。默认为 “”，这意味着使用节点的默认介质。 必须是空字符串（默认值）或 Memory"}
        self.medium = medium
        # {"en": "Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir", "zh_CN": "这个 EmptyDir 卷所需的本地存储总量。这个大小限制也适用于内存介质。 EmptyDir 的内存介质最大使用量将是此处指定的 sizeLimit 与 Pod 中所有容器内存限制总和这两个值之间的最小值。 默认为 nil，这意味着限制未被定义"}
        self.size_limit = size_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.medium is not None:
            result['medium'] = self.medium
        if self.size_limit is not None:
            result['sizeLimit'] = self.size_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('medium') is not None:
            self.medium = m.get('medium')
        if m.get('sizeLimit') is not None:
            self.size_limit = m.get('sizeLimit')
        return self


class PatchJobIoK8sApiCoreV1TypedLocalObjectReference(TeaModel):
    def __init__(
        self,
        api_group: str = None,
        kind: str = None,
        name: str = None,
    ):
        # {"en": "APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.", "zh_CN": "APIGroup 是被引用资源的组。如果不指定 APIGroup，则指定的 Kind 必须在核心 API 组中。对于任何其它第三方类型，都需要 APIGroup"}
        self.api_group = api_group
        # {"en": "Kind is the type of resource being referenced", "zh_CN": "Kind 是被引用的资源的类型"}
        self.kind = kind
        # {"en": "Name is the name of resource being referenced", "zh_CN": "Name 是被引用的资源的名称"}
        self.name = name

    def validate(self):
        self.validate_required(self.kind, 'kind')
        self.validate_required(self.name, 'name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.api_group is not None:
            result['apiGroup'] = self.api_group
        if self.kind is not None:
            result['kind'] = self.kind
        if self.name is not None:
            result['name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('apiGroup') is not None:
            self.api_group = m.get('apiGroup')
        if m.get('kind') is not None:
            self.kind = m.get('kind')
        if m.get('name') is not None:
            self.name = m.get('name')
        return self


class PatchJobIoK8sApiCoreV1PersistentVolumeClaimSpec(TeaModel):
    def __init__(
        self,
        access_modes: List[str] = None,
        data_source: PatchJobIoK8sApiCoreV1TypedLocalObjectReference = None,
        resources: PatchJobIoK8sApiCoreV1ResourceRequirements = None,
        selector: PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector = None,
        storage_class_name: str = None,
        volume_mode: str = None,
        volume_name: str = None,
    ):
        # {"en": "AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1", "zh_CN": "accessModes 包含卷应具备的预期访问模式"}
        self.access_modes = access_modes
        # {"en": "This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.", "zh_CN": "dataSource 字段可用于二选一：- 现有的 VolumeSnapshot 对象（snapshot.storage.k8s.io/VolumeSnapshot）- 现有的 PVC (PersistentVolumeClaim)。如果制备器或外部控制器可以支持指定的数据源，则它将根据指定数据源的内容创建新的卷。 当 AnyVolumeDataSource 特性门控被启用时，dataSource 内容将被复制到 dataSourceRef， 当 dataSourceRef.namespace 未被指定时，dataSourceRef 内容将被复制到 dataSource。 如果名字空间被指定，则 dataSourceRef 不会被复制到 dataSource"}
        self.data_source = data_source
        # {"en": "Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources", "zh_CN": "resources 表示卷应拥有的最小资源。 如果启用了 RecoverVolumeExpansionFailure 功能特性，则允许用户指定这些资源要求， 此值必须低于之前的值，但必须高于申领的状态字段中记录的容量"}
        self.resources = resources
        # {"en": "A label query over volumes to consider for binding.", "zh_CN": "selector 是在绑定时对卷进行选择所执行的标签查询"}
        self.selector = selector
        # {"en": "Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1", "zh_CN": "storageClassName 是此申领所要求的 StorageClass 名称"}
        self.storage_class_name = storage_class_name
        # {"en": "volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.", "zh_CN": "volumeMode 定义申领需要哪种类别的卷。当申领规约中未包含此字段时，意味着取值为 Filesystem"}
        self.volume_mode = volume_mode
        # {"en": "VolumeName is the binding reference to the PersistentVolume backing this claim.", "zh_CN": "volumeName 是对此申领所对应的 PersistentVolume 的绑定引用"}
        self.volume_name = volume_name

    def validate(self):
        if self.data_source:
            self.data_source.validate()
        if self.resources:
            self.resources.validate()
        if self.selector:
            self.selector.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_modes is not None:
            result['accessModes'] = self.access_modes
        if self.data_source is not None:
            result['dataSource'] = self.data_source.to_map()
        if self.resources is not None:
            result['resources'] = self.resources.to_map()
        if self.selector is not None:
            result['selector'] = self.selector.to_map()
        if self.storage_class_name is not None:
            result['storageClassName'] = self.storage_class_name
        if self.volume_mode is not None:
            result['volumeMode'] = self.volume_mode
        if self.volume_name is not None:
            result['volumeName'] = self.volume_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessModes') is not None:
            self.access_modes = m.get('accessModes')
        if m.get('dataSource') is not None:
            temp_model = PatchJobIoK8sApiCoreV1TypedLocalObjectReference()
            self.data_source = temp_model.from_map(m['dataSource'])
        if m.get('resources') is not None:
            temp_model = PatchJobIoK8sApiCoreV1ResourceRequirements()
            self.resources = temp_model.from_map(m['resources'])
        if m.get('selector') is not None:
            temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1LabelSelector()
            self.selector = temp_model.from_map(m['selector'])
        if m.get('storageClassName') is not None:
            self.storage_class_name = m.get('storageClassName')
        if m.get('volumeMode') is not None:
            self.volume_mode = m.get('volumeMode')
        if m.get('volumeName') is not None:
            self.volume_name = m.get('volumeName')
        return self


class PatchJobIoK8sApiCoreV1PersistentVolumeClaimTemplate(TeaModel):
    def __init__(
        self,
        metadata: PatchJobIoK8sApimachineryPkgApisMetaV1ObjectMeta = None,
        spec: PatchJobIoK8sApiCoreV1PersistentVolumeClaimSpec = None,
    ):
        # {"en": "May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.", "zh_CN": "可能包含一些标签和注解，在创建 PVC 时，这些数据会被复制到 PVC 中。 在验证期间，其他字段都不允许设置，即便设置也会在验证阶段被拒绝"}
        self.metadata = metadata
        # {"en": "The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.", "zh_CN": "PersistentVolumeClaim 的规约。整个规约的内容将被原封不动地复制到从此模板创建的 PVC 中。 与 PersistentVolumeClaim 相同的字段在此处也有效"}
        self.spec = spec

    def validate(self):
        if self.metadata:
            self.metadata.validate()
        self.validate_required(self.spec, 'spec')
        if self.spec:
            self.spec.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metadata is not None:
            result['metadata'] = self.metadata.to_map()
        if self.spec is not None:
            result['spec'] = self.spec.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('metadata') is not None:
            temp_model = PatchJobIoK8sApimachineryPkgApisMetaV1ObjectMeta()
            self.metadata = temp_model.from_map(m['metadata'])
        if m.get('spec') is not None:
            temp_model = PatchJobIoK8sApiCoreV1PersistentVolumeClaimSpec()
            self.spec = temp_model.from_map(m['spec'])
        return self


class PatchJobIoK8sApiCoreV1EphemeralVolumeSource(TeaModel):
    def __init__(
        self,
        read_only: bool = None,
        volume_claim_template: PatchJobIoK8sApiCoreV1PersistentVolumeClaimTemplate = None,
    ):
        # {"en": "Specifies a read-only configuration for the volume. Defaults to false (read/write).", "zh_CN": "指定供卷使用的只读配置。默认为 false（读/写）"}
        self.read_only = read_only
        # {"en": "Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.Required, must not be nil.", "zh_CN": "将用于创建独立的 PVC 以制备卷。 嵌入了 EphemeralVolumeSource 的 Pod 将是 PVC 的所有者，即 PVC 将与 Pod 一起删除。 PVC 的名称将是 <pod 名称>-<卷名称>，其中 <卷名称> 是来自 PodSpec.Volumes 数组条目的名称。 如果串联的名称对于 PVC 无效（例如太长），则 Pod 验证将拒绝该 Pod。如果具有此名称的现有 PVC 不属于此 Pod，则这一 PVC 将 不会 被用于此 Pod，以避免错误地使用不相关的卷。 如果出现这种情况，Pod 的启动操作会被阻塞直到不相关的 PVC 被移除。 如果 Pod 准备使用这样一个预先创建的 PVC，那么一旦此 Pod 出现，就必须更新 PVC， 将其属主引用指向该 Pod。通常没有必要这样做，但这对手动重构损坏的集群时可能很有用。此字段是只读的，PVC 被创建后 Kubernetes 不会对其进行任何更改。必需，不能为 nil"}
        self.volume_claim_template = volume_claim_template

    def validate(self):
        if self.volume_claim_template:
            self.volume_claim_template.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.volume_claim_template is not None:
            result['volumeClaimTemplate'] = self.volume_claim_template.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('volumeClaimTemplate') is not None:
            temp_model = PatchJobIoK8sApiCoreV1PersistentVolumeClaimTemplate()
            self.volume_claim_template = temp_model.from_map(m['volumeClaimTemplate'])
        return self


class PatchJobIoK8sApiCoreV1FCVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        lun: int = None,
        read_only: bool = None,
        target_wwns: List[str] = None,
        wwids: List[str] = None,
    ):
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified.", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。 例如 “ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Optional: FC target lun number", "zh_CN": "可选的：FC 目标 lun 编号"}
        self.lun = lun
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "可选的。默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: FC target worldwide names (WWNs)", "zh_CN": "可选的。FC 目标全球名称（WWN）"}
        self.target_wwns = target_wwns
        # {"en": "Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.", "zh_CN": "可选的。FC 卷全球识别号（wwids）。 必须设置 wwids 或 targetWWNs 及 lun 的组合，但不能同时设置两者"}
        self.wwids = wwids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.lun is not None:
            result['lun'] = self.lun
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.target_wwns is not None:
            result['targetWWNs'] = self.target_wwns
        if self.wwids is not None:
            result['wwids'] = self.wwids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('lun') is not None:
            self.lun = m.get('lun')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('targetWWNs') is not None:
            self.target_wwns = m.get('targetWWNs')
        if m.get('wwids') is not None:
            self.wwids = m.get('wwids')
        return self


class PatchJobIoK8sApiCoreV1FlexVolumeSource(TeaModel):
    def __init__(
        self,
        driver: str = None,
        fs_type: str = None,
        options: Dict[str, Any] = None,
        read_only: bool = None,
        secret_ref: PatchJobIoK8sApiCoreV1LocalObjectReference = None,
    ):
        # {"en": "Driver is the name of the driver to use for this volume.", "zh_CN": "供此卷使用的驱动的名称"}
        self.driver = driver
        # {"en": "Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. ext4, xfs, ntfs. The default filesystem depends on FlexVolume script.", "zh_CN": "要挂载的文件系统类型。必须是主机操作系统所支持的文件系统类型之一。例如 “ext4”、“xfs”、“ntfs”。 默认的文件系统取决于 flexVolume 脚本"}
        self.fs_type = fs_type
        # {"en": "Optional: Extra command options if any.", "zh_CN": "可选的。此字段包含额外的命令选项（如果有）"}
        self.options = options
        # {"en": "Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.", "zh_CN": "可选的。默认为 false（读/写）。此处的 readOnly 将强制设置卷挂载中的 readOnly 属性"}
        self.read_only = read_only
        # {"en": "Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.", "zh_CN": "可选的。secretRef 是对包含敏感信息的 Secret 对象的引用，该 Secret 会被传递到插件脚本。 如果未指定 Secret 对象，则此字段可以为空。如果 Secret 对象包含多个 Secret，则所有 Secret 被传递到插件脚本"}
        self.secret_ref = secret_ref

    def validate(self):
        self.validate_required(self.driver, 'driver')
        if self.secret_ref:
            self.secret_ref.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.driver is not None:
            result['driver'] = self.driver
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.options is not None:
            result['options'] = self.options
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        if self.secret_ref is not None:
            result['secretRef'] = self.secret_ref.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('driver') is not None:
            self.driver = m.get('driver')
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('options') is not None:
            self.options = m.get('options')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        if m.get('secretRef') is not None:
            temp_model = PatchJobIoK8sApiCoreV1LocalObjectReference()
            self.secret_ref = temp_model.from_map(m['secretRef'])
        return self


class PatchJobIoK8sApiCoreV1FlockerVolumeSource(TeaModel):
    def __init__(
        self,
        dataset_name: str = None,
        dataset_uuid: str = None,
    ):
        # {"en": "Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated", "zh_CN": "存储为元数据的数据集的名称。Flocker 数据集的名称应视为已弃用"}
        self.dataset_name = dataset_name
        # {"en": "UUID of the dataset. This is unique identifier of a Flocker dataset", "zh_CN": "数据集的 UUID。这是 Flocker 数据集的唯一标识符"}
        self.dataset_uuid = dataset_uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dataset_name is not None:
            result['datasetName'] = self.dataset_name
        if self.dataset_uuid is not None:
            result['datasetUUID'] = self.dataset_uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('datasetName') is not None:
            self.dataset_name = m.get('datasetName')
        if m.get('datasetUUID') is not None:
            self.dataset_uuid = m.get('datasetUUID')
        return self


class PatchJobIoK8sApiCoreV1GCEPersistentDiskVolumeSource(TeaModel):
    def __init__(
        self,
        fs_type: str = None,
        partition: int = None,
        pd_name: str = None,
        read_only: bool = None,
    ):
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为“ext4”"}
        self.fs_type = fs_type
        # {"en": "The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as 1. Similarly, the volume partition for /dev/sda is 0 (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "你要挂载的卷中的分区。如果省略，则默认为按卷名称进行挂载。 例如：对于卷 /dev/sda1，将分区指定为 “1”。类似地，/dev/sda 的卷分区为 “0”（或可以将属性留空）。"}
        self.partition = partition
        # {"en": "Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "GCE 中 PD 资源的唯一名称。用于标识 GCE 中的磁盘"}
        self.pd_name = pd_name
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.pd_name, 'pd_name')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fs_type is not None:
            result['fsType'] = self.fs_type
        if self.partition is not None:
            result['partition'] = self.partition
        if self.pd_name is not None:
            result['pdName'] = self.pd_name
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('fsType') is not None:
            self.fs_type = m.get('fsType')
        if m.get('partition') is not None:
            self.partition = m.get('partition')
        if m.get('pdName') is not None:
            self.pd_name = m.get('pdName')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class PatchJobIoK8sApiCoreV1GitRepoVolumeSource(TeaModel):
    def __init__(
        self,
        directory: str = None,
        repository: str = None,
        revision: str = None,
    ):
        # {"en": "Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.", "zh_CN": "目标目录的名称。不得包含 “..” 或以 “..” 开头。如果提供了 “.”，则卷目录将是 Git 仓库。 否则，如果指定，卷将用给定名称的子目录中存放 Git 仓库"}
        self.directory = directory
        # {"en": "Repository URL", "zh_CN": "仓库的 URL"}
        self.repository = repository
        # {"en": "Commit hash for the specified revision.", "zh_CN": "指定修订版本的提交哈希值"}
        self.revision = revision

    def validate(self):
        self.validate_required(self.repository, 'repository')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.directory is not None:
            result['directory'] = self.directory
        if self.repository is not None:
            result['repository'] = self.repository
        if self.revision is not None:
            result['revision'] = self.revision
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('directory') is not None:
            self.directory = m.get('directory')
        if m.get('repository') is not None:
            self.repository = m.get('repository')
        if m.get('revision') is not None:
            self.revision = m.get('revision')
        return self


class PatchJobIoK8sApiCoreV1GlusterfsVolumeSource(TeaModel):
    def __init__(
        self,
        endpoints: str = None,
        path: str = None,
        read_only: bool = None,
    ):
        # {"en": "EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "详细给出 Glusterfs 拓扑结构的端点的名称"}
        self.endpoints = endpoints
        # {"en": "Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "Glusterfs 卷的路径"}
        self.path = path
        # {"en": "ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod", "zh_CN": "此处的 readOnly 将强制以只读权限挂载 Glusterfs 卷。 默认为 false"}
        self.read_only = read_only

    def validate(self):
        self.validate_required(self.endpoints, 'endpoints')
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoints is not None:
            result['endpoints'] = self.endpoints
        if self.path is not None:
            result['path'] = self.path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endpoints') is not None:
            self.endpoints = m.get('endpoints')
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class PatchJobIoK8sApiCoreV1HostPathVolumeSource(TeaModel):
    def __init__(
        self,
        path: str = None,
        type: str = None,
    ):
        # {"en": "Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "目录在主机上的路径。如果该路径是一个符号链接，则它将沿着链接指向真实路径"}
        self.path = path
        # {"en": "Type for HostPath Volume Defaults to  More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath", "zh_CN": "HostPath 卷的类型。默认为 “”"}
        self.type = type

    def validate(self):
        self.validate_required(self.path, 'path')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.path is not None:
            result['path'] = self.path
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class PatchJobIoK8sApiCoreV1ISCSIVolumeSource(TeaModel):
    def __init__(
        self,
        chap_auth_discovery: bool = None,
        chap_auth_session: bool = None,
        fs_type: str = None,
        initiator_name: str = None,
        iqn: str = None,
        iscsi_interface: str = None,
        lun: int = None,
        portals: List[str] = None,
        read_only: bool = None,
        secret_ref: PatchJobIoK8sApiCoreV1LocalObjectReference = None,
        target_portal: str = None,
    ):
        # {"en": "whether support iSCSI Discovery CHAP authentication", "zh_CN": "定义是否支持 iSCSI Discovery CHAP 身份认证"}
        self.chap_auth_discovery = chap_auth_discovery
        # {"en": "whether support iSCSI Session CHAP authentication", "zh_CN": "定义是否支持 iSCSI Session CHAP 身份认证"}
        self.chap_auth_session = chap_auth_session
        # {"en": "Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: ext4, xfs, ntfs. Implicitly inferred to be ext4 if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi", "zh_CN": "你要挂载的卷的文件系统类型。提示：确保主机操作系统支持此文件系统类型。 例如：“ext4”、“xfs”、“ntfs”。如果未指定，则隐式推断为 “ext4”"}
        self.fs_type = fs_type
        # {"en": "Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.", "zh_CN": "自定义的 iSCSI 发起程序名称（iSCSI Initiator Name）。 如果同时用 iscsiInterface 指定 initiatorName，将为连接创建新的 iSCSI 接口 <目标门户>:<卷名称>"}
        self.initiator_name = initiator_name
        # {"en": "Target iSCSI Qualified Name.", "zh_CN": "目标 iSCSI 限定名称"}
        self.iqn = iqn
        # {"en": "iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).", "zh_CN": "使用 iSCSI 传输的接口名称。默认为 “default”（tcp）"}
        self.iscsi_interface = iscsi_interface
        # {"en": "iSCSI Target Lun number.", "zh_CN": "表示 iSCSI 目标逻辑单元号"}
        self.lun = lun
        # {"en": "iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).", "zh_CN": " iSCSI 目标门户列表（iSCSI Target Portal List）。 如果不是默认端口（通常是 TCP 端口 860 和 3260），则 Portal 为 IP 或 ip_addr:port"}
        self.portals = portals
        # {"en": "ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.", "zh_CN": "此处的 readOnly 将强制设置卷挂载中的 readOnly 属性。默认为 false"}
        self.read_only = read_only
        # {"en": "CHAP Secret for iSCSI target and initiator authentication", "zh_CN": "iSCSI 目标和发起程序身份认证所用的 CHAP Secret"}
        self.secret_ref = secret_ref
        # {"en": "iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).", "zh_CN": "iSCSI 目标门户。 如果不是默认端口（通常是 TCP 端口 860 和 3260），则 Portal 为 IP 或 ip_addr:port"}
        self.target_portal = target_portal

    def validate(self):
        self.validate_required(self.iqn, 'iqn')
        self.validate_required(self.lun, 'lun')
        if self.secret_ref:
            self.secret_ref.validate()
        self.validate_required(self.target_portal, 'target_portal')

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.chap_auth_discovery is not None:
            result['chapAuthDiscovery'] = self.chap_auth_discovery
        if self.chap_auth_session is not None:
            result['chapAu