"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration}
*/
class SamlIntegration extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SamlIntegrationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'snowflake_saml_integration',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '0.33.1',
                providerVersionConstraint: ' ~> 0.25'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._enabled = config.enabled;
        this._id = config.id;
        this._name = config.name;
        this._saml2EnableSpInitiated = config.saml2EnableSpInitiated;
        this._saml2ForceAuthn = config.saml2ForceAuthn;
        this._saml2Issuer = config.saml2Issuer;
        this._saml2PostLogoutRedirectUrl = config.saml2PostLogoutRedirectUrl;
        this._saml2Provider = config.saml2Provider;
        this._saml2RequestedNameidFormat = config.saml2RequestedNameidFormat;
        this._saml2SignRequest = config.saml2SignRequest;
        this._saml2SnowflakeAcsUrl = config.saml2SnowflakeAcsUrl;
        this._saml2SnowflakeIssuerUrl = config.saml2SnowflakeIssuerUrl;
        this._saml2SnowflakeX509Cert = config.saml2SnowflakeX509Cert;
        this._saml2SpInitiatedLoginPageLabel = config.saml2SpInitiatedLoginPageLabel;
        this._saml2SsoUrl = config.saml2SsoUrl;
        this._saml2X509Cert = config.saml2X509Cert;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // created_on - computed: true, optional: false, required: false
    get createdOn() {
        return this.getStringAttribute('created_on');
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    // saml2_digest_methods_used - computed: true, optional: false, required: false
    get saml2DigestMethodsUsed() {
        return this.getStringAttribute('saml2_digest_methods_used');
    }
    get saml2EnableSpInitiated() {
        return this.getBooleanAttribute('saml2_enable_sp_initiated');
    }
    set saml2EnableSpInitiated(value) {
        this._saml2EnableSpInitiated = value;
    }
    resetSaml2EnableSpInitiated() {
        this._saml2EnableSpInitiated = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2EnableSpInitiatedInput() {
        return this._saml2EnableSpInitiated;
    }
    get saml2ForceAuthn() {
        return this.getBooleanAttribute('saml2_force_authn');
    }
    set saml2ForceAuthn(value) {
        this._saml2ForceAuthn = value;
    }
    resetSaml2ForceAuthn() {
        this._saml2ForceAuthn = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ForceAuthnInput() {
        return this._saml2ForceAuthn;
    }
    get saml2Issuer() {
        return this.getStringAttribute('saml2_issuer');
    }
    set saml2Issuer(value) {
        this._saml2Issuer = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2IssuerInput() {
        return this._saml2Issuer;
    }
    get saml2PostLogoutRedirectUrl() {
        return this.getStringAttribute('saml2_post_logout_redirect_url');
    }
    set saml2PostLogoutRedirectUrl(value) {
        this._saml2PostLogoutRedirectUrl = value;
    }
    resetSaml2PostLogoutRedirectUrl() {
        this._saml2PostLogoutRedirectUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2PostLogoutRedirectUrlInput() {
        return this._saml2PostLogoutRedirectUrl;
    }
    get saml2Provider() {
        return this.getStringAttribute('saml2_provider');
    }
    set saml2Provider(value) {
        this._saml2Provider = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2ProviderInput() {
        return this._saml2Provider;
    }
    get saml2RequestedNameidFormat() {
        return this.getStringAttribute('saml2_requested_nameid_format');
    }
    set saml2RequestedNameidFormat(value) {
        this._saml2RequestedNameidFormat = value;
    }
    resetSaml2RequestedNameidFormat() {
        this._saml2RequestedNameidFormat = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2RequestedNameidFormatInput() {
        return this._saml2RequestedNameidFormat;
    }
    get saml2SignRequest() {
        return this.getBooleanAttribute('saml2_sign_request');
    }
    set saml2SignRequest(value) {
        this._saml2SignRequest = value;
    }
    resetSaml2SignRequest() {
        this._saml2SignRequest = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SignRequestInput() {
        return this._saml2SignRequest;
    }
    // saml2_signature_methods_used - computed: true, optional: false, required: false
    get saml2SignatureMethodsUsed() {
        return this.getStringAttribute('saml2_signature_methods_used');
    }
    get saml2SnowflakeAcsUrl() {
        return this.getStringAttribute('saml2_snowflake_acs_url');
    }
    set saml2SnowflakeAcsUrl(value) {
        this._saml2SnowflakeAcsUrl = value;
    }
    resetSaml2SnowflakeAcsUrl() {
        this._saml2SnowflakeAcsUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeAcsUrlInput() {
        return this._saml2SnowflakeAcsUrl;
    }
    get saml2SnowflakeIssuerUrl() {
        return this.getStringAttribute('saml2_snowflake_issuer_url');
    }
    set saml2SnowflakeIssuerUrl(value) {
        this._saml2SnowflakeIssuerUrl = value;
    }
    resetSaml2SnowflakeIssuerUrl() {
        this._saml2SnowflakeIssuerUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeIssuerUrlInput() {
        return this._saml2SnowflakeIssuerUrl;
    }
    // saml2_snowflake_metadata - computed: true, optional: false, required: false
    get saml2SnowflakeMetadata() {
        return this.getStringAttribute('saml2_snowflake_metadata');
    }
    get saml2SnowflakeX509Cert() {
        return this.getStringAttribute('saml2_snowflake_x509_cert');
    }
    set saml2SnowflakeX509Cert(value) {
        this._saml2SnowflakeX509Cert = value;
    }
    resetSaml2SnowflakeX509Cert() {
        this._saml2SnowflakeX509Cert = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SnowflakeX509CertInput() {
        return this._saml2SnowflakeX509Cert;
    }
    get saml2SpInitiatedLoginPageLabel() {
        return this.getStringAttribute('saml2_sp_initiated_login_page_label');
    }
    set saml2SpInitiatedLoginPageLabel(value) {
        this._saml2SpInitiatedLoginPageLabel = value;
    }
    resetSaml2SpInitiatedLoginPageLabel() {
        this._saml2SpInitiatedLoginPageLabel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SpInitiatedLoginPageLabelInput() {
        return this._saml2SpInitiatedLoginPageLabel;
    }
    get saml2SsoUrl() {
        return this.getStringAttribute('saml2_sso_url');
    }
    set saml2SsoUrl(value) {
        this._saml2SsoUrl = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2SsoUrlInput() {
        return this._saml2SsoUrl;
    }
    get saml2X509Cert() {
        return this.getStringAttribute('saml2_x509_cert');
    }
    set saml2X509Cert(value) {
        this._saml2X509Cert = value;
    }
    // Temporarily expose input value. Use with caution.
    get saml2X509CertInput() {
        return this._saml2X509Cert;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            enabled: cdktf.booleanToTerraform(this._enabled),
            id: cdktf.stringToTerraform(this._id),
            name: cdktf.stringToTerraform(this._name),
            saml2_enable_sp_initiated: cdktf.booleanToTerraform(this._saml2EnableSpInitiated),
            saml2_force_authn: cdktf.booleanToTerraform(this._saml2ForceAuthn),
            saml2_issuer: cdktf.stringToTerraform(this._saml2Issuer),
            saml2_post_logout_redirect_url: cdktf.stringToTerraform(this._saml2PostLogoutRedirectUrl),
            saml2_provider: cdktf.stringToTerraform(this._saml2Provider),
            saml2_requested_nameid_format: cdktf.stringToTerraform(this._saml2RequestedNameidFormat),
            saml2_sign_request: cdktf.booleanToTerraform(this._saml2SignRequest),
            saml2_snowflake_acs_url: cdktf.stringToTerraform(this._saml2SnowflakeAcsUrl),
            saml2_snowflake_issuer_url: cdktf.stringToTerraform(this._saml2SnowflakeIssuerUrl),
            saml2_snowflake_x509_cert: cdktf.stringToTerraform(this._saml2SnowflakeX509Cert),
            saml2_sp_initiated_login_page_label: cdktf.stringToTerraform(this._saml2SpInitiatedLoginPageLabel),
            saml2_sso_url: cdktf.stringToTerraform(this._saml2SsoUrl),
            saml2_x509_cert: cdktf.stringToTerraform(this._saml2X509Cert),
        };
    }
}
exports.SamlIntegration = SamlIntegration;
_a = JSII_RTTI_SYMBOL_1;
SamlIntegration[_a] = { fqn: "@cdktf/provider-snowflake.SamlIntegration", version: "0.2.37" };
// =================
// STATIC PROPERTIES
// =================
SamlIntegration.tfResourceType = "snowflake_saml_integration";
//# sourceMappingURL=data:application/json;base64,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