/*
 * Decompiled with CFR 0.152.
 */
package com.dylibso.chicory.runtime;

import com.dylibso.chicory.runtime.Instance;
import com.dylibso.chicory.wasm.types.Instruction;
import com.dylibso.chicory.wasm.types.OpCode;
import com.dylibso.chicory.wasm.types.ValueType;
import java.util.Arrays;
import java.util.List;

final class ConstantEvaluators {
    private ConstantEvaluators() {
    }

    public static long[] computeConstantValue(Instance instance, Instruction[] expr2) {
        return ConstantEvaluators.computeConstantValue(instance, Arrays.asList(expr2));
    }

    public static long[] computeConstantValue(Instance instance, List<Instruction> expr2) {
        long tos = -1L;
        for (Instruction instruction : expr2) {
            switch (instruction.opcode()) {
                case V128_CONST: {
                    return new long[]{instruction.operand(0), instruction.operand(1)};
                }
                case F32_CONST: 
                case F64_CONST: 
                case I32_CONST: 
                case I64_CONST: 
                case REF_FUNC: {
                    tos = instruction.operand(0);
                    break;
                }
                case REF_NULL: {
                    tos = -1L;
                    break;
                }
                case GLOBAL_GET: {
                    int idx = (int)instruction.operand(0);
                    if (instance.global(idx).getType() == ValueType.V128) {
                        return new long[]{instance.global(idx).getValueLow(), instance.global(idx).getValueHigh()};
                    }
                    return new long[]{instance.global(idx).getValueLow()};
                }
            }
        }
        return new long[]{tos};
    }

    public static Instance computeConstantInstance(Instance instance, List<Instruction> expr2) {
        for (Instruction instruction : expr2) {
            if (instruction.opcode() != OpCode.GLOBAL_GET) continue;
            return instance.global((int)instruction.operand(0)).getInstance();
        }
        return instance;
    }
}

