/*
 * Decompiled with CFR 0.152.
 */
package compiler;

import com.certora.collect.Treapable;
import compiler.SourceContext;
import compiler.SourceContextKt;
import compiler.SourceIdentifier;
import compiler.SourceSegment$;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import report.TreeViewLocation;
import report.TreeViewRepBuilder;
import utils.CertoraFileCache;
import utils.CertoraFileCacheException;
import utils.ExtStdlibKt;
import utils.LineStarts;
import utils.Range;
import utils.Range$Range$;
import utils.SourcePosition;

@kotlinx.serialization.Serializable
@Treapable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 >2\u00020\u00012\u00020\u0002:\u0002=>B-\b\u0011\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\t\u0010)\u001a\u00020\u0006H\u00c6\u0003J\t\u0010*\u001a\u00020\bH\u00c6\u0003J\u001d\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010/H\u00d6\u0003J\t\u00100\u001a\u00020\u0004H\u00d6\u0001J\t\u00101\u001a\u00020\bH\u0096\u0001J\t\u00102\u001a\u00020\bH\u00d6\u0001J\t\u00103\u001a\u000204H\u0096\u0001J&\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00002\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u00c1\u0001\u00a2\u0006\u0002\b<R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u0014\u0010\u0017\u001a\u00020\u00048VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00048VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u0011\u0010 \u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u0012\u0010\"\u001a\u00020\u0010X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0012R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8VX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006?"}, d2={"Lcompiler/SourceSegment;", "Ljava/io/Serializable;", "Lreport/TreeViewLocation;", "seen1", "", "range", "Lutils/Range$Range;", "content", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILutils/Range$Range;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Lutils/Range$Range;Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "end", "Lutils/SourcePosition;", "getEnd", "()Lutils/SourcePosition;", "file", "getFile", "fileName", "getFileName", "lineNumber", "getLineNumber", "()I", "lineNumberZeroBased", "getLineNumberZeroBased", "getRange", "()Lutils/Range$Range;", "sanitizedContent", "getSanitizedContent", "sanitizedContentWithLoc", "getSanitizedContentWithLoc", "start", "getStart", "treeViewRepBuilder", "Lreport/TreeViewRepBuilder;", "Lkotlinx/serialization/json/JsonObjectBuilder;", "getTreeViewRepBuilder", "()Lreport/TreeViewRepBuilder;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toJsonString", "toString", "toTreeViewRep", "Lkotlinx/serialization/json/JsonElement;", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$Shared", "$serializer", "Companion", "Shared"})
public final class SourceSegment
implements Serializable,
TreeViewLocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range.Range range;
    @NotNull
    private final String content;

    public SourceSegment(@NotNull Range.Range range, @NotNull String content) {
        Intrinsics.checkNotNullParameter(range, "range");
        Intrinsics.checkNotNullParameter(content, "content");
        this.range = range;
        this.content = content;
    }

    @NotNull
    public final Range.Range getRange() {
        return this.range;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @Override
    @NotNull
    public SourcePosition getEnd() {
        return this.range.getEnd();
    }

    @Override
    @NotNull
    public String getFile() {
        return this.range.getFile();
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.range.getFileName();
    }

    @Override
    public int getLineNumber() {
        return this.range.getLineNumber();
    }

    @Override
    public int getLineNumberZeroBased() {
        return this.range.getLineNumberZeroBased();
    }

    @Override
    @NotNull
    public SourcePosition getStart() {
        return this.range.getStart();
    }

    @Override
    @NotNull
    public TreeViewRepBuilder<JsonObjectBuilder> getTreeViewRepBuilder() {
        return this.range.getTreeViewRepBuilder();
    }

    @Override
    @NotNull
    public String toJsonString() {
        return this.range.toJsonString();
    }

    @Override
    @NotNull
    public JsonElement toTreeViewRep() {
        return this.range.toTreeViewRep();
    }

    @NotNull
    public final String getSanitizedContent() {
        return ExtStdlibKt.splitAndJoin(((Object)StringsKt.trim((CharSequence)this.content)).toString());
    }

    @NotNull
    public final String getSanitizedContentWithLoc() {
        return "/* " + this.range.getFileName() + ": " + this.range.getLineNumber() + ": */ " + ExtStdlibKt.condense(this.getSanitizedContent(), 1);
    }

    @NotNull
    public final Range.Range component1() {
        return this.range;
    }

    @NotNull
    public final String component2() {
        return this.content;
    }

    @NotNull
    public final SourceSegment copy(@NotNull Range.Range range, @NotNull String content) {
        Intrinsics.checkNotNullParameter(range, "range");
        Intrinsics.checkNotNullParameter(content, "content");
        return new SourceSegment(range, content);
    }

    public static /* synthetic */ SourceSegment copy$default(SourceSegment sourceSegment, Range.Range range, String string, int n, Object object) {
        if ((n & 1) != 0) {
            range = sourceSegment.range;
        }
        if ((n & 2) != 0) {
            string = sourceSegment.content;
        }
        return sourceSegment.copy(range, string);
    }

    @NotNull
    public String toString() {
        return "SourceSegment(range=" + this.range + ", content=" + this.content + ")";
    }

    public int hashCode() {
        int result2 = this.range.hashCode();
        result2 = result2 * 31 + this.content.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SourceSegment)) {
            return false;
        }
        SourceSegment sourceSegment = (SourceSegment)other;
        if (!Intrinsics.areEqual(this.range, sourceSegment.range)) {
            return false;
        }
        return Intrinsics.areEqual(this.content, sourceSegment.content);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$Shared(SourceSegment self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeSerializableElement(serialDesc, 0, Range$Range$.serializer.INSTANCE, self.range);
        output.encodeStringElement(serialDesc, 1, self.content);
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ SourceSegment(int seen1, Range.Range range, String content, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen1)) {
            PluginExceptionsKt.throwMissingFieldException(seen1, 3, $serializer.INSTANCE.getDescriptor());
        }
        this.range = range;
        this.content = content;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0086\u0002J\u0018\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u00c6\u0001\u00a8\u0006\u0013"}, d2={"Lcompiler/SourceSegment$Companion;", "", "()V", "invoke", "Lcompiler/SourceSegment;", "sourceFile", "Ljava/io/File;", "startIndex", "", "size", "relativeFile", "", "resolveFromContext", "context", "Lcompiler/SourceContext;", "identifier", "Lcompiler/SourceIdentifier;", "serializer", "Lkotlinx/serialization/KSerializer;", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final SourceSegment invoke(@NotNull File sourceFile, int startIndex, int size, @NotNull String relativeFile) {
            Object s;
            Intrinsics.checkNotNullParameter(sourceFile, "sourceFile");
            Intrinsics.checkNotNullParameter(relativeFile, "relativeFile");
            if (startIndex < 0 || size < 0) {
                return null;
            }
            try {
                String string = sourceFile.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                s = string;
                s = TuplesKt.to(CertoraFileCache.INSTANCE.byteContent((String)s), LineStarts.box-impl(CertoraFileCache.INSTANCE.lineStarts-CilK_FQ((String)s)));
            }
            catch (CertoraFileCacheException e) {
                SourceContextKt.access$getLogger$p().warn(e.getCause(), (Function0<? extends Object>)new Function0<Object>(sourceFile, relativeFile){
                    final /* synthetic */ File $sourceFile;
                    final /* synthetic */ String $relativeFile;
                    {
                        this.$sourceFile = $sourceFile;
                        this.$relativeFile = $relativeFile;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Had error when reading from source file " + this.$sourceFile + " (" + this.$relativeFile + ")";
                    }
                });
                return null;
            }
            Object object = s;
            byte[] allBytes = (byte[])((Pair)object).component1();
            List lineStarts2 = ((LineStarts)((Pair)object).component2()).unbox-impl();
            if (allBytes.length < startIndex + size) {
                SourceContextKt.access$getLogger$p().warn((Function0<? extends Object>)new Function0<Object>(relativeFile, allBytes, startIndex, size){
                    final /* synthetic */ String $relativeFile;
                    final /* synthetic */ byte[] $allBytes;
                    final /* synthetic */ int $startIndex;
                    final /* synthetic */ int $size;
                    {
                        this.$relativeFile = $relativeFile;
                        this.$allBytes = $allBytes;
                        this.$startIndex = $startIndex;
                        this.$size = $size;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Source file " + this.$relativeFile + " is shorter than expected!! Read " + this.$allBytes.length + " < " + this.$startIndex + " + " + this.$size;
                    }
                });
                return null;
            }
            Range.Range range = new Range.Range(relativeFile, LineStarts.sourcePosition-impl(lineStarts2, startIndex), LineStarts.sourcePosition-impl(lineStarts2, startIndex + size));
            return new SourceSegment(range, SourceContextKt.access$removeNonPrintableChars(new String(allBytes, startIndex, size, Charsets.UTF_8)));
        }

        @Nullable
        public final SourceSegment resolveFromContext(@NotNull SourceContext context, @NotNull SourceIdentifier identifier) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(identifier, "identifier");
            File file = identifier.resolve(context);
            if (file == null) {
                return null;
            }
            File sourceFile = file;
            Object object = identifier.relativeSourceFile(context);
            if (object == null || (object = ((File)object).toString()) == null) {
                return null;
            }
            Object relativeFile = object;
            return Companion.invoke(sourceFile, identifier.getBegin(), identifier.getLen(), (String)relativeFile);
        }

        @NotNull
        public final KSerializer<SourceSegment> serializer() {
            return $serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

